/*************************************************************************\
 * Copyright (c) 2002 The University of Chicago, as Operator of Argonne
 *     National Laboratory.
 * Copyright (c) 2002 The Regents of the University of California, as
 *     Operator of Los Alamos National Laboratory.
 * EPICS BASE is distributed subject to a Software License Agreement found
 * in file LICENSE that is included with this distribution.
\*************************************************************************/

#ifndef INC_epicsSignal_H
#define INC_epicsSignal_H

#ifdef __cplusplus
extern "C" {
#endif

#include "shareLib.h"

/* 
 * The requests in this interface are typically ignored on OS that do not implement
 * POSIX signals. 
 */

struct epicsThreadOSD;

/* 
 * Required to avoid problems with soft IOCs getting SIGHUPs when a
 * Channel Access client disconnects
 */
epicsShareFunc void epicsShareAPI epicsSignalInstallSigHupIgnore ( void );

/* 
 * Required to avoid terminating a process which is blocking in a 
 * socket send() call when the SIGPIPE signal is generated by the OS.
 */
epicsShareFunc void epicsShareAPI epicsSignalInstallSigPipeIgnore ( void );

/* 
 * required only if shutdown() and close() do not interrupt a thread blocking in
 * a socket system call
 */
epicsShareFunc void epicsShareAPI epicsSignalInstallSigAlarmIgnore ( void );
epicsShareFunc void epicsShareAPI epicsSignalRaiseSigAlarm ( struct epicsThreadOSD * );

#ifdef __cplusplus
}
#endif

#endif /* INC_epicsSignal_H */
