#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>
#include "tiny_complex.h"
#include "eggx.h"
#include "e_ctrls.h"

typedef complex double  Cdbl;

void btree(int win, Cdbl z1, Cdbl z2, float *th, double rt, int dim)
{
  Cdbl z3, z4, z5;

  if (dim == -1) return;
  z3 = z1*rt + z2*(1-rt);
  z4 = z3 + rt*(z2 - z1)*cexp(I*th[dim]);
  z5 = z3 + rt*(z2 - z1)*cexp(-I*th[dim]);
  moveto(win, creal(z1), cimag(z1));
  lineto(win, creal(z3), cimag(z3));
  btree(win, z3, z5, th, rt, dim-1);
  btree(win, z3, z4, th, rt, dim-1);
}


#define L 400
#define MAXORDER 13
#define MAXSNOW  700
Cdbl  z1 = 0, z2 = 0 + L*I;
float snowx[MAXSNOW], snowy[MAXSNOW], th[MAXORDER];

char bgcolor[]="#506070";
int win, cwin, iscwin, type, button;
double rt = 0.8, run = 1, quit = 0, order = 9 ;
double ra = 0.09, chbg = 0;
float wx, wy;

void remake_tree()
{
  z2 = 0 + 0.9*L/(1-pow(rt,order+1))*I;
  gsetbgcolor(win, bgcolor);
  layer(win, 0, 2);
  gclr(win);
  newcolor(win, "ForestGreen");
  btree(win, z1, z2, th, rt, order);
  newcolor(win, "white");
  drawstr(win, L/2-180, 4, 14, 0, "Background Color: %s",bgcolor);
  layer(win, 0, 1);
}

void change_bgcolor()
{
  sprintf(bgcolor,"#%02X%02X%02X", (int)(drand48()*128),
              (int)(drand48()*128),(int)(drand48()*128));
  gsetbgcolor(win, bgcolor);
  remake_tree();
  chbg = 0;
}


void remake_all()
{
  int i;
 
  for(i = 0; i < MAXORDER; i++) th[i] = ra*M_PI*(0.9*drand48()+0.1);
  for(i = 0; i < MAXSNOW; i++) {
    snowx[i] = L*(drand48() - 0.5);
    snowy[i] = L * (1+drand48());
  }
  remake_tree();
}

void draw(){
  int i;

  gclr(win);
  copylayer(win, 2, 1);
  newcolor(win, "White");
  for(i = 0; i < MAXSNOW; i++) {
    snowx[i] += 2*(drand48()-0.5); 
    snowy[i] -= 2.5 + drand48();
    if ( snowy[i] <= 0.0 ) snowy[i] = L;
  }
  drawpts(win, snowx, snowy, MAXSNOW);
  copylayer(win, 1, 0);
}



int main(int argc, char **argv)
{
  _CTRL ctrls[] = {
    {"order", &order, 1, remake_all}, 
    {"ratio", &rt, 0.01, remake_all},
    {"angle", &ra, 0.01, remake_all},
     {"_change bgcolor", &chbg, 0, change_bgcolor},
    {"_quit", &quit, 0, exit},
  };
  init_ctrls(&cwin, 5);

  srand48(time(NULL));  
  win = gopen(L, L);
  window(win, -L/2, 0, L/2-1, L-1);
  winname(win, "snow fall");
  layer(win, 0, 1);
  remake_all();
  gsetnonblock(ENABLE);

  while (!quit) {
    if (order > 11) order = 12;
    iscwin = ggetxpress(&type, &button, &wx, &wy);
    display_ctrls(cwin, ctrls, 5, wx, wy, iscwin, type, button);
    if(run) draw();
    msleep(40);
  }
  return 0;
}

