#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "tiny_complex.h"
#include "eggx.h"
#include "e_ctrls.h"

#define WD 500
#define HT 300
#define MG 5
#define SC 400

typedef complex double  Cdbl;

Cdbl a = 0, b= 0, c = 0, d = 0;
Cdbl origin = 0;
double br, bi, cr, ci, order, reset = 0, quit = 0;
int win, cwin, range, type, iscwin, button = 1;
int gr[256], gg[256], gb[256];
float wx, wy;


Cdbl f(Cdbl z, int rank, int parity)
{ 
  if (rank != 0) {
    if (parity % 2 ) {
      z = a*z + b*conj(z);
    } else {
      z = c*(z-1) + d*(conj(z)-1) + 1;
    }
    return f(z, rank-1, parity/2);
  } else { 
    return z;
  }
}

void draw()
{
  int i;
  Cdbl z;

  range = (int)pow(2,order);
  c = cr + ci*I;
  b = br + bi*I;
  gclr(win);
  for (i = 1; i <= range; i++) {
    newrgbcolor(win, gr[i%256], gg[i%256], gb[i%256]);    
    z = f(origin, order, i);
    pset(win, SC*creal(z), SC*cimag(z));
  }
  drawstr(win, 0, HT-10, 14, 0, 
          "b = %+6f %+6fi", creal(b), cimag(b));  
  drawstr(win, WD/2, HT-10, 14, 0, 
          "c = %+6f %+6fi", creal(c), cimag(c));  
}
 
void param_reset()
{
  order = 13;
  range = (int)pow(2,order);
  br = 0.4614;
  bi = 0.4614;
  cr = 0.662;
  ci = -0.196;
}

int main(void)
{
  int i;

  _CTRL ctrls[] = {
    {"Order", &order, 1, },
    {"real(b)", &br, 0.01, },
    {"imag(b)", &bi, 0.01, },
    {"real(c)", &cr, 0.01, },
    {"image(c)", &ci, 0.01,},
    {"_Reset c,b", &reset, 0, param_reset},
    {"_Quit", &quit,0, exit}
  };
  init_ctrls(&cwin, 7);

  for(i = 0; i <256; i++){
    makecolor(DS9_GREEN, 0, 255, i, gr+i, gg+i, gb+i);
  }

  gsetinitialbgcolor("white");
  win = gopen(WD+2*MG, HT+2*MG);
  window(win, -MG, -MG, WD+MG, HT+MG);
  winname(win, "Fractal Tree");
  newpen(win, 13);
  param_reset();

  while (!quit) {
    if (button) {
      display_ctrls(cwin, ctrls, 7, wx, wy, iscwin, type, button);
      if (reset) {
        reset = 0;
        display_ctrls(cwin, ctrls, 7, wx, wy, iscwin, type, button);
      }
      button = 0;
      draw();
    }
    iscwin = ggetxpress(&type, &button, &wx, &wy);
    msleep(100);
  }

  return 0;
}

