#%% begin initialize update-4.73-noarch-P1
# aaa_base-4.5-noarch-P5

echo "checking /root/.bashrc"
chk=`cat /root/.bashrc | grep 'PS1='`
if [ "$chk.x" = ".x" ]; then
echo "patching /root/.bashrc"
cat << "EOF" | patch -p1
--- old/root/.bashrc	2006-04-24 18:49:33.000000000 +0900
+++ new/root/.bashrc	2010-07-15 16:10:08.000000000 +0900
@@ -9,6 +9,8 @@ if [ "$TERM" = "dumb" ] ; then LS_OPTION
 export LS_OPTIONS
 alias ls='ls $LS_OPTIONS'
 
+PS1='\u@\h:\w\$ '
+
 # Source global definitions
 if [ -f /etc/bashrc ] ; then
   . /etc/bashrc
EOF
fi

# dcron-3.2-i386-P5
echo "checking crontabs/root"
chk=`cat /var/spool/cron/crontabs/root | grep updatedb`
if [ "$chk.x" != ".x" ]; then
  echo "updating crontabs/root"
  sed -i -e "/rmmod -a/d"  /var/spool/cron/crontabs/root
  sed -i -e "/updatedb 1>/d" /var/spool/cron/crontabs/root
fi

# etc-4.5-noarch-P34

echo "checking /etc/bashrc"
chk=`cat /etc/bashrc | grep 'PS1='`
if [ "$chk.x" != ".x" ]; then
echo "updating etc/bashrc"
cat <<"EOF" | patch -p1
--- old/etc/bashrc	2010-01-16 19:06:54.000000000 +0900
+++ new/etc/bashrc	2010-08-26 09:21:40.000000000 +0900
@@ -1,8 +1,6 @@
 # /etc/bashrc: This file contains system-wide defaults used by
 # all Bourne (and related) shells. (sourced by ~/.bashrc)
 
-PS1='\u@\h:\w\$ '
-
 function ls() {
   local args=""
   local arg
@@ -24,11 +22,11 @@ function ls() {
     fi
     if [ $isopt == 1 -a "${arg:0:4}" == "--fu" ] ; then
       if [ "$LANG" == "ja_JP.eucJP" ] ; then
-        TIME_STYLE=$'+%EY%m\xb7\xee%d\xc6\xfc(%a) '
+        TIME_STYLE=$'+%8EY%m\xb7\xee%d\xc6\xfc(%a) '
         TIME_STYLE=$TIME_STYLE$'%H\xbb\xfe%M\xca\xac%S\xc9\xc3'
         export TIME_STYLE
       elif [ "$LANG" == "ja_JP.UTF-8" ] ; then
-        TIME_STYLE=$'+%EY%m\xe6\x9c\x88%d\xe6\x97\xa5(%a) '
+        TIME_STYLE=$'+%8EY%m\xe6\x9c\x88%d\xe6\x97\xa5(%a) '
         TIME_STYLE=$TIME_STYLE$'%H\xe6\x99\x82%M\xe5\x88\x86%S\xe7\xa7\x92'
         export TIME_STYLE
       else
EOF
fi

echo "checking /etc/passwd"
chk=`grep 'ftp:x:19:FTP server' /etc/passwd`
if [ "$chk.x" != ".x" ]; then
    echo "updating /etc/passwd for ftp account"
    sed -i -e "s/ftp:x:19:FTP server/ftp:x:19:19:FTP server/" /etc/passwd
fi

echo "checking .xinitrc"
chk=`grep '.Xresouces' /etc/template/Default/.xinitrc`
if [ "$chk.x" != ".x" ]; then
    echo "updating .xinitrc"
    sed -i -e "s/.Xresouces/.Xdefaults/" /etc/template/Default/.xinitrc
    sed -i -e "s/.Xresouces/.Xdefaults/" /etc/template/Source/.xinitrc
fi

# grub-0.97-i586-P16
echo "checking grubconfig"
if [ -f /sbin/grubconfig ]; then
   chk=`grep Plamo-4.72 /sbin/grubconfig`
   if [ "$chk.x" != ".x" ]; then
      echo "updating grubconfig"
      sed -i -e "s/Plamo-4.72/Plamo-4.73/" /sbin/grubconfig
      sed -i -e "s/Plamo-4.72/Plamo-4.73/" /sbin/egrubconfig
   fi
fi

if [ -f /boot/grub/grub.conf ]; then
    echo "checking grub.conf"
    chk=`grep Plamo-4.72 /boot/grub/grub.conf`
    if [ "$chk.x" != ".x" ]; then
	echo "updating grub.conf"
       sed -i -e "s/Plamo-4.72/Plamo-4.73u/" /boot/grub/grub.conf
    fi
fi

# hdsetup-4.7-i386-P11

echo "checking hdsetup"
chk=`cat /sbin/updatepkg | grep 'non-canonical-versioned package'`
if [ "$chk.x" = ".x" ]; then
echo "updating hdsetup"
cat <<"EOF" | patch -p1
diff -uprN old/sbin/makepkg new/sbin/makepkg
--- old/sbin/makepkg	2008-05-30 13:54:40.000000000 +0900
+++ new/sbin/makepkg	2010-08-04 15:22:30.000000000 +0900
@@ -636,7 +636,8 @@ EOF
    ;;
   esac
   # tar --create --gzip --exclude $PKGNAME --exclude initpkg --file $PKGNAME `ls -f | tail +3`
-  tar --create --gzip --exclude $PKGNAME --exclude initpkg --file $PKGNAME `ls -a | sed '1,2d'`
+  #tar --create --gzip --exclude $PKGNAME --exclude initpkg --file $PKGNAME `ls -a | sed '1,2d'`
+  tar --create --gzip --exclude $PKGNAME --exclude initpkg --file $PKGNAME `ls -f --indicator-style=none | sed '/^\.\{1,2\}$/d'`
  fi
 else # we're just going to try to install each argument as a package:
  for package in $* ; do
diff -uprN old/sbin/updatepkg new/sbin/updatepkg
--- old/sbin/updatepkg	2009-01-17 00:17:25.000000000 +0900
+++ new/sbin/updatepkg	2010-08-04 15:22:30.000000000 +0900
@@ -19,11 +19,27 @@ check_vers() {
     for i in 1 2 3 4 5; do
 	t1=`echo $old | cut -f$i -d'.'`
 	t2=`echo $new | cut -f$i -d'.'`
- 	if [ $t2 -gt $t1 ]; then
-	    return $t2
+	
+	# echo "i, t1, t2", $i, $t1, $t2
+
+	if [ ! -z $t1 ]; then
+	    if [ ! -z $t2 ]; then
+		if [ $t2 -gt $t1 ]; then    # 󥹥ȡ뤷褦Ȥ(礭)
+		    return 2                #     2 = 󥹥ȡ뤹
+		elif [ $t2 -lt $t1 ]; then  # 󥹥ȡѤ(礭)
+		    return 0                #     0 = 󥹥ȡ뤷ʤ
+		fi
+	    else
+	    	return 0   # 󥹥ȡ뤷褦ȤΥब̵ʤä
+            fi
+	else
+	    if [ -z $t2 ]; then # ξȤ⥳ब̵ʤä
+		return 1          #    1  = СƱʤΤǥӥֹƥ
+	    else                  # 󥹥ȡ뤷褦ȤΥϻĤ
+		return 2          #    2 = 󥹥ȡ뤹
+	    fi
 	fi
     done
-    return 0
 }
 
 check_build() {
@@ -41,6 +57,10 @@ usage() {
     echo "usage: $0 [-f] [-v] [-h] package(s)"
     echo "    -f force install mode(without version check)"
     echo "    -h help(this message)"
+    echo 
+    echo "non-canonical-versioned package(such as \"x264-20100716_git-i586-P1.tgz\")"
+    echo " are cannot version-checked automatically. You need -f option to update such package(s)."
+    echo
     exit
 }
 
@@ -71,15 +91,20 @@ for tmppkg in $* ; do
 	    old_vers=`get_version $base`
 	    check_vers $old_vers $vers
 	    ver_test=$?
-	    if [ $ver_test != "0" ]; then
+	    # echo "ver_test:$ver_test"
+	    if [ $ver_test = "2" ]; then
 		echo "removing $base-$old_vers"
 		/sbin/removepkg $base
+	    elif [ $ver_test = "0" ]; then
+		echo "same or newer vesion($chk-$old_vers) has been installed."
+		echo "installation stopped for $tmppkg"	    
+		continue
 	    else
 		old_build=`get_build $base`
 		check_build $old_build $build
 		build_test=$?
 		if [ $build_test != "0" ]; then
-		    echo "removing $base-$old_vers build $old_build"
+		    echo "removing $base-$old_vers ($old_build)"
 		    /sbin/removepkg $base
 		else
 		    echo "same or newer vesion($chk-$old_vers,$build) has been installed."
EOF
fi

if [ -f /usr/lib/setup/Plamo-4.72 ]; then
    mv /usr/lib/setup/Plamo-4.72 /usr/lib/setup/Plamo-4.73u
fi

# sysvinit-2.86-i586-P34
echo "checking sysvinit"
chk=`grep -- '-x $server' /etc/rc.d/rc.inet2`
if [ "$chk.x" != ".x" ]; then
    echo "updating rc.inet2"
    cat << "EOF" | patch -p1
diff -uprN old/etc/rc.d/rc.inet2 new/etc/rc.d/rc.inet2
--- old/etc/rc.d/rc.inet2	2010-01-26 05:58:25.000000000 +0900
+++ new/etc/rc.d/rc.inet2	2010-05-09 18:41:18.000000000 +0900
@@ -93,7 +93,7 @@ fi
 for spec in $SERV ; do
   server=${spec%%:*}
   service=${server##*/}
-  if [ -x $server ] ; then
+  if [ -x /usr/sbin/$server -o -x /usr/bin/$server ] ; then
     echo "Starting ${service##*.}..."
     ${spec//:/ }
   fi

EOF
fi

# tcpip-4.5-i386-P9
echo "checking idecrypt.8"
chk=`file /usr/share/man/man8/idecrypt.8.gz | grep troff`
if [ "$chk.x" != ".x" ];then
    echo "gziping idecrypt.8"
    mv /usr/share/man/man8/idecrypt.8.gz /usr/share/man/man8/idecrypt.8
    gzip /usr/share/man/man8/idecrypt.8
fi
#%% end
