;;; byeoru-dic.scm: Hangul character to Chinese character
;;; dictionary for byeoru.scm
;;;
;;; Copyright (c) 2003-2010 uim Project http://code.google.com/p/uim/
;;;
;;; All rights reserved.
;;;
;;; Redistribution and use in source and binary forms, with or without
;;; modification, are permitted provided that the following conditions
;;; are met:
;;; 1. Redistributions of source code must retain the above copyright
;;;    notice, this list of conditions and the following disclaimer.
;;; 2. Redistributions in binary form must reproduce the above copyright
;;;    notice, this list of conditions and the following disclaimer in the
;;;    documentation and/or other materials provided with the distribution.
;;; 3. Neither the name of authors nor the names of its contributors
;;;    may be used to endorse or promote products derived from this software
;;;    without specific prior written permission.
;;;
;;; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND
;;; ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
;;; IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
;;; ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE
;;; FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
;;; DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
;;; OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
;;; HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
;;; LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
;;; OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
;;; SUCH DAMAGE.
;;;;

;; This data is from hanja.txt in libhangul
;; [http://wiki.kldp.org/wiki.php/libhangul] courtesy of Choe Hwanjin
;; <krisna@kldp.org>.
;; The following is the original copyright notice in hanja.txt.
;;
;; Copyright (c) 2005,2006 Choe Hwanjin
;; All rights reserved.
;;
;; Redistribution and use in source and binary forms, with or without
;; modification, are permitted provided that the following conditions are met:
;;
;; 1. Redistributions of source code must retain the above copyright notice,
;;    this list of conditions and the following disclaimer.
;; 2. Redistributions in binary form must reproduce the above copyright notice,
;;    this list of conditions and the following disclaimer in the documentation
;;    and/or other materials provided with the distribution.
;; 3. Neither the name of the author nor the names of its contributors
;;    may be used to endorse or promote products derived from this software
;;    without specific prior written permission.
;;
;; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
;; AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
;; IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
;; ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
;; LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
;; CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
;; SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
;; INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
;; CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
;; ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
;; POSSIBILITY OF SUCH DAMAGE.

(define byeoru-dic
  '(("가"
     "价"
     ("伽" . "절 가")
     ("佳" . "아름다울 가")
     ("假" . "거짓 가")
     ("價" . "값 가")
     ("加" . "더할 가")
     ("可" . "옳을 가")
     ("呵" . "꾸짖을 가")
     ("哥" . "노래 가")
     ("嘉" . "아름다울 가")
     ("嫁" . "시집갈 가")
     ("家" . "집 가")
     ("暇" . "겨를 가")
     ("架" . "시렁 가")
     ("枷" . "목칼 가, 도리깨채 가")
     ("柯" . "가지 가")
     ("歌" . "노래 가")
     ("珂" . "옥 이름 가")
     ("痂" . "헌데 딱지 가")
     ("稼" . "심을 가")
     ("苛" . "매울 가")
     ("茄" . "가지 가")
     ("街" . "거리 가")
     ("袈" . "가사 가")
     ("訶" . "꾸짖을 가")
     ("賈" . "값 가")
     ("跏" . "책상다리할 가")
     ("軻" . "수레 가기 힘들 가")
     ("迦" . "부처이름 가")
     ("駕" . "멍에 가")
     ("仮" . "假의 略字")
     "佉"
     ("傢" . "세간 가")
     "呿"
     ("咖" . "커피차 가, 커피의 음차로 쓰는자 가")
     ("哿" . "좋을 가")
     ("坷" . "험할 가")
     ("斝" . "옥잔 가")
     ("榎" . "檟와 同字")
     ("檟" . "오동나무 가")
     ("珈" . "머리꾸미개 가")
     "瘕"
     "砢"
     ("笳" . "갈잎피리 가")
     ("耞" . "도리깨 가")
     ("舸" . "큰 배 가")
     ("葭" . "갈대 가")
     ("謌" . "歌와 同字"))
    ("가가"
     "假家")
    ("가가대소"
     "呵呵大笑")
    ("가가호호"
     "家家戶戶")
    ("가감"
     "加減")
    ("가객"
     "歌客")
    ("가거주"
     "假居住")
    ("가건물"
     "假建物")
    ("가검물"
     "可檢物")
    ("가격"
     "價格"
     "加擊")
    ("가결"
     "可決")
    ("가계"
     "家系"
     "家計")
    ("가계부"
     "家計簿")
    ("가계비"
     "家計費")
    ("가계성"
     "家計性")
    ("가계약"
     "假契約")
    ("가계약서"
     "假契約書")
    ("가곡"
     "歌曲")
    ("가곡집"
     "歌曲集")
    ("가공"
     "加工"
     "可恐"
     "架空")
    ("가공과"
     "加工科")
    ("가공법"
     "加工法")
    ("가공성"
     "加工性")
    ("가공업"
     "加工業")
    ("가공인물"
     "架空人物")
    ("가공적"
     "架空的")
    ("가공품"
     "加工品")
    ("가공학과"
     "加工學科")
    ("가공형적"
     "加工形的")
    ("가관"
     "可觀")
    ("가교"
     "架橋")
    ("가교적"
     "架橋的")
    ("가구"
     "家具"
     "家口")
    ("가구상"
     "家具商")
    ("가구업체"
     "家具業體")
    ("가극"
     "歌劇")
    ("가급"
     "加給")
    ("가급적"
     "可及的")
    ("가난"
     "家難")
    ("가내"
     "家內")
    ("가내적"
     "家內的")
    ("가능"
     "可能")
    ("가능성"
     "可能性")
    ("가능액"
     "可能額")
    ("가담"
     "加擔")
    ("가담자"
     "加擔者")
    ("가담항설"
     "街談巷說")
    ("가당"
     "可當")
    ("가도"
     "街道")
    ("가독성"
     "可讀性")
    ("가동"
     "可動"
     "稼動")
    ("가동률"
     "稼動率")
    ("가동비"
     "可動費")
    ("가동성"
     "可動性")
    ("가동주졸"
     "街童走卒")
    ("가두"
     "街頭")
    ("가량"
     "假量")
    ("가련"
     "可憐")
    ("가렴주구"
     "苛斂誅求")
    ("가령"
     "假令")
    ("가례"
     "嘉禮")
    ("가로"
     "街路")
    ("가로계"
     "街路係")
    ("가로등"
     "街路燈")
    ("가로림만"
     "加露林灣")
    ("가로망"
     "街路網")
    ("가로수"
     "街路樹")
    ("가망"
     "可望")
    ("가매장"
     "假埋葬")
    ("가맹사"
     "加盟社")
    ("가맹점"
     "加盟店")
    ("가면"
     "假面")
    ("가면관"
     "假面館")
    ("가면극"
     "假面劇")
    ("가면무"
     "假面舞")
    ("가명"
     "假名")
    ("가명제"
     "假名制")
    ("가무"
     "歌舞")
    ("가무단"
     "歌舞團")
    ("가문"
     "家門")
    ("가미"
     "加味")
    ("가반"
     "柯半")
    ("가발"
     "假髮")
    ("가방"
     "街坊")
    ("가벌성"
     "加罰性")
    ("가변선"
     "可變線")
    ("가변성"
     "可變性")
    ("가변식"
     "可變式")
    ("가변적"
     "可變的")
    ("가보"
     "家寶")
    ("가봉"
     "假縫")
    ("가부"
     "可否")
    ("가부장"
     "家父長")
    ("가부장적"
     "家父長的")
    ("가부장제"
     "家父長制")
    ("가부장제적"
     "家父長制的")
    ("가부좌"
     "跏趺坐")
    ("가사"
     "假死"
     "家事"
     "家士"
     "歌詞"
     "歌辭"
     "袈裟")
    ("가산"
     "加算"
     "家産")
    ("가산율"
     "加算率")
    ("가산점"
     "加算點")
    ("가상"
     "假想"
     "假相"
     "假象"
     "嘉尙")
    ("가상적"
     "假想敵")
    ("가석방"
     "假釋放")
    ("가설"
     "假說"
     "架設")
    ("가설무대"
     "假設舞臺")
    ("가설적"
     "假說的")
    ("가성"
     "假聲")
    ("가세"
     "加勢"
     "家世")
    ("가소"
     "可笑")
    ("가속"
     "加速")
    ("가속기"
     "加速器")
    ("가속도"
     "加速度")
    ("가속적"
     "加速的")
    ("가속화"
     "加速化")
    ("가수"
     "歌手")
    ("가수면"
     "假睡眠")
    ("가수요"
     "假需要")
    ("가습기"
     "加濕器")
    ("가시거리"
     "可視距離")
    ("가시권"
     "可視圈")
    ("가시적"
     "可視的")
    ("가시화"
     "可視化")
    ("가식"
     "假飾"
     "加飾")
    ("가식적"
     "假飾的")
    ("가신"
     "家臣")
    ("가압장"
     "加壓場")
    ("가액"
     "價額")
    ("가야금"
     "伽倻琴")
    ("가업"
     "家業")
    ("가연성"
     "可燃性")
    ("가열"
     "加熱"
     "苛烈")
    ("가열화"
     "加熱化")
    ("가옥"
     "假玉"
     "家屋")
    ("가옥대장"
     "家屋臺帳")
    ("가외"
     "加外")
    ("가욋"
     "加外")
    ("가요"
     "歌謠")
    ("가요계"
     "歌謠界")
    ("가요사"
     "歌謠史")
    ("가요제"
     "歌謠祭")
    ("가용"
     "可用")
    ("가위"
     "可謂")
    ("가인박명"
     "佳人薄命")
    ("가일층"
     "加一層")
    ("가입"
     "加入")
    ("가입비"
     "加入費")
    ("가입서"
     "加入書")
    ("가입순"
     "加入順")
    ("가입안"
     "加入案")
    ("가입자"
     "加入者")
    ("가작"
     "佳作")
    ("가장"
     "假裝"
     "家長")
    ("가장행렬"
     "假裝行列")
    ("가재도구"
     "家財道具")
    ("가전"
     "家電")
    ("가전사"
     "家電社")
    ("가전속"
     "假專屬")
    ("가전업계"
     "家電業界")
    ("가전용품"
     "家電用品")
    ("가전제품"
     "家電製品")
    ("가정"
     "假定"
     "家庭"
     "家政")
    ("가정과"
     "家政科")
    ("가정교사"
     "家庭敎師")
    ("가정교육"
     "家庭敎育")
    ("가정법"
     "假定法")
    ("가정부"
     "家政婦")
    ("가정부인"
     "家庭婦人")
    ("가정불화"
     "家庭不和")
    ("가정생활"
     "家庭生活")
    ("가정용품"
     "家庭用品")
    ("가정의"
     "家庭醫")
    ("가정의례"
     "家庭儀禮")
    ("가정적"
     "家庭的")
    ("가정주부"
     "家庭主婦")
    ("가정학"
     "家政學")
    ("가정학과"
     "家政學科")
    ("가정환경"
     "家庭環境")
    ("가제"
     "假題")
    ("가족"
     "家族")
    ("가족계획"
     "家族計劃")
    ("가족도"
     "家族圖")
    ("가족사진"
     "家族寫眞")
    ("가족애"
     "家族愛")
    ("가족적"
     "家族的")
    ("가족학"
     "家族學")
    ("가족회의"
     "家族會議")
    ("가주제"
     "假主題")
    ("가중"
     "加重")
    ("가증"
     "可憎")
    ("가지급금"
     "假支給金")
    ("가집"
     "歌集")
    ("가차"
     "假借")
    ("가창력"
     "歌唱力")
    ("가책"
     "呵責")
    ("가처분"
     "假處分")
    ("가체"
     "假諦")
    ("가축"
     "家畜")
    ("가축병원"
     "家畜病院")
    ("가축적"
     "家畜的")
    ("가출"
     "家出")
    ("가치"
     "假齒"
     "價値")
    ("가치관"
     "價値觀")
    ("가치세"
     "價値稅")
    ("가치적"
     "價値的")
    ("가치중립"
     "價値中立")
    ("가치화"
     "價値化")
    ("가칭"
     "假稱")
    ("가타부"
     "可-否")
    ("가택"
     "家宅")
    ("가판대"
     "街販臺")
    ("가풍"
     "家風")
    ("가필"
     "加筆")
    ("가학"
     "苛虐")
    ("가학적"
     "加虐的")
    ("가해"
     "加害")
    ("가해자"
     "加害者")
    ("가행궁"
     "假行宮")
    ("가호"
     "家戶")
    ("가호자"
     "加護者")
    ("가혹"
     "苛酷")
    ("가화"
     "佳話")
    ("각"
     ("刻" . "새길 각")
     ("却" . "물리칠 각")
     ("各" . "각각 각")
     ("恪" . "삼갈 각")
     ("慤" . "삼갈 각")
     ("殼" . "껍질 각")
     ("珏" . "쌍옥 각")
     ("脚" . "다리 각")
     ("覺" . "깨달을 각")
     ("角" . "뿔 각")
     ("閣" . "문설주 각")
     ("卻" . "却의 本字")
     ("咯" . "토할 각")
     ("埆" . "메마를 각")
     "塙"
     ("搉" . "칠 각")
     ("擱" . "놓을 각")
     ("桷" . "서까래 각")
     "榷"
     "礭"
     "躩"
     "骼")
    ("각각"
     "各各")
    ("각개"
     "各個")
    ("각거성"
     "各居性")
    ("각계"
     "各界")
    ("각계각층"
     "各界各層")
    ("각고"
     "刻苦")
    ("각골난망"
     "刻骨難忘")
    ("각골통한"
     "刻骨痛恨")
    ("각광"
     "脚光")
    ("각국"
     "各國")
    ("각국어"
     "各國語")
    ("각급"
     "各級")
    ("각기"
     "各其")
    ("각기병"
     "脚氣病")
    ("각도"
     "角度")
    ("각도기"
     "角度器")
    ("각론"
     "各論")
    ("각론적"
     "各論的")
    ("각료"
     "閣僚")
    ("각막"
     "角膜")
    ("각막염"
     "角膜炎")
    ("각목"
     "角木")
    ("각박"
     "刻薄")
    ("각박성가"
     "刻薄成家")
    ("각반"
     "脚絆")
    ("각배"
     "角杯")
    ("각별"
     "各別")
    ("각본"
     "脚本")
    ("각본난"
     "刻本難")
    ("각부"
     "各部")
    ("각색"
     "各色"
     "脚色")
    ("각색자"
     "脚色者")
    ("각서"
     "覺書")
    ("각서설"
     "覺書說")
    ("각서화"
     "覺書化")
    ("각선미"
     "脚線美")
    ("각설"
     "却說")
    ("각설탕"
     "角雪糖")
    ("각성"
     "覺醒")
    ("각양"
     "各樣")
    ("각양각색"
     "各樣各色")
    ("각오"
     "覺悟")
    ("각의"
     "閣議")
    ("각인"
     "刻印")
    ("각자"
     "各自")
    ("각자각자"
     "各自各自")
    ("각자무치"
     "角者無齒")
    ("각종"
     "各種")
    ("각주"
     "脚註")
    ("각주구검"
     "刻舟求劍")
    ("각지"
     "各地")
    ("각지불이"
     "各知不移")
    ("각질"
     "角質")
    ("각처"
     "各處")
    ("각첨"
     "角尖")
    ("각축"
     "角逐")
    ("각축전"
     "角逐戰")
    ("각층"
     "各層")
    ("각하"
     "却下"
     "閣下")
    ("각형"
     "角形")
    ("각화형"
     "角化型")
    ("간"
     ("乾" . "마를 간")
     ("侃" . "강직할 간")
     ("刊" . "책 펴낼 간")
     ("墾" . "따비질할 간")
     ("奸" . "범할 간, 간악할 간")
     ("姦" . "간사할 간")
     ("干" . "방패 간")
     ("幹" . "줄기 간, 우물난간 간")
     ("懇" . "정성 간")
     ("揀" . "가릴 간")
     ("杆" . "지레 간, 나무이름 간")
     ("柬" . "가릴 간")
     "桿"
     ("澗" . "산골물 간")
     ("癎" . "경풍 간")
     ("看" . "볼 간")
     ("磵" . "산골 시내 간, 석간수 간")
     ("稈" . "짚 간")
     ("竿" . "장대 간, 화살대 간, 횃대 간")
     ("簡" . "대쪽 간")
     ("肝" . "간 간")
     ("艮" . "괘이름 간")
     ("艱" . "어려울 간")
     ("諫" . "간할 간")
     ("間" . "틈 간, 사이 간")
     ("偘" . "侃과 同字")
     ("慳" . "아낄 간")
     ("栞" . "도표 간")
     ("榦" . "幹의 本字")
     ("玕" . "옥돌 간")
     ("秆" . "稈과 同字")
     ("茛" . "독초이름 간, 미나리아재비 간")
     ("衎" . "즐길 간, 바를 간")
     ("赶" . "달릴 간")
     ("迀" . "구할 간, 권할 간")
     ("齦" . "물을 간"))
    ("간간"
     "間間")
    ("간격"
     "間隔")
    ("간결"
     "簡潔")
    ("간경변증"
     "肝硬變症")
    ("간계"
     "奸計")
    ("간곡"
     "懇曲")
    ("간과"
     "看過")
    ("간교"
     "奸巧")
    ("간구"
     "干求"
     "懇求")
    ("간극"
     "間隙")
    ("간난신고"
     "艱難辛苦")
    ("간뇌"
     "間腦")
    ("간단"
     "簡單"
     "間斷")
    ("간단명료"
     "簡單明瞭")
    ("간담상조"
     "肝膽相照")
    ("간담회"
     "懇談會")
    ("간두지세"
     "竿頭之勢")
    ("간략"
     "簡略")
    ("간만"
     "干滿")
    ("간맥"
     "肝脈")
    ("간명"
     "簡明")
    ("간발"
     "間髮")
    ("간병인"
     "看病人")
    ("간부"
     "幹部")
    ("간부급"
     "幹部級")
    ("간부화"
     "幹部化")
    ("간부회"
     "幹部會")
    ("간불용발"
     "間不容髮")
    ("간빙기"
     "間氷期")
    ("간사"
     "奸詐"
     "奸邪"
     "幹事")
    ("간사국"
     "幹事國")
    ("간사장"
     "幹事長")
    ("간석지"
     "干潟地")
    ("간선"
     "幹線")
    ("간선망"
     "幹線網")
    ("간섭"
     "干涉")
    ("간섭기"
     "干涉期")
    ("간성"
     "干城")
    ("간성지재"
     "干城之材")
    ("간세지배"
     "奸細之輩")
    ("간세지재"
     "間世之材")
    ("간소"
     "簡素")
    ("간소화"
     "簡素化")
    ("간식"
     "間食")
    ("간신"
     "艱辛")
    ("간신배"
     "奸臣輩")
    ("간신적자"
     "奸臣賊子")
    ("간악"
     "奸惡")
    ("간악무도"
     "奸惡無道")
    ("간암"
     "肝癌")
    ("간어제초"
     "間於齊楚")
    ("간여"
     "干與")
    ("간염"
     "肝炎")
    ("간운보월"
     "看雲步月")
    ("간음죄"
     "姦淫罪")
    ("간이"
     "簡易")
    ("간이식당"
     "簡易食堂")
    ("간이역"
     "簡易驛")
    ("간인"
     "間印")
    ("간장"
     "肝腸"
     "肝臟")
    ("간절"
     "懇切")
    ("간접"
     "間接")
    ("간접세"
     "間接稅")
    ("간접적"
     "間接的")
    ("간접흡연"
     "間接吸煙")
    ("간주"
     "看做"
     "間奏")
    ("간주관적"
     "間主觀的")
    ("간증"
     "干證")
    ("간지"
     "奸智"
     "干支")
    ("간질"
     "癎疾")
    ("간척"
     "干拓")
    ("간척지"
     "干拓地")
    ("간첩"
     "間諜")
    ("간첩단"
     "間諜團")
    ("간청"
     "懇請")
    ("간체자화"
     "簡體字化")
    ("간취"
     "看取")
    ("간친회"
     "懇親會")
    ("간택"
     "揀擇")
    ("간파"
     "看破")
    ("간판"
     "看板")
    ("간편"
     "簡便")
    ("간편성"
     "簡便性")
    ("간편식"
     "簡便食")
    ("간행"
     "刊行")
    ("간행물"
     "刊行物")
    ("간헐적"
     "間歇的")
    ("간호"
     "看護")
    ("간호대"
     "看護隊")
    ("간호대학"
     "看護大學")
    ("간호복"
     "看護服")
    ("간호부"
     "看護婦")
    ("간호부장"
     "看護部長")
    ("간호사"
     "看護師")
    ("간호실"
     "看護室")
    ("간호원"
     "看護員")
    ("간호학과"
     "看護學科")
    ("간혹"
     "間或")
    ("갈"
     ("乫" . "땅이름 갈")
     ("喝" . "꾸짖을 갈, 성낸 소리 갈")
     ("曷" . "어찌 갈, 그칠 갈, 벌레이름 갈")
     ("渴" . "목마를 갈, 급할 갈")
     ("碣" . "비 갈, 우뚝선 돌 갈, 동해의 산이름 갈")
     ("竭" . "다할 갈, 마를 갈")
     ("葛" . "칡 갈")
     ("蝎" . "전갈 갈, 빈대 갈")
     ("褐" . "털베 갈, 굵은 베 갈, 천한사람 갈, 갈옷 갈")
     ("鞨" . "말갈나라 갈, 말갈보석 갈")
     ("噶" . "벼슬이름 갈, 땅이름 갈")
     ("楬" . "패를 써서 표시할 갈")
     ("秸" . "볏짚 갈, 짚 고갱이 갈")
     ("羯" . "불친 양 갈, 땅이름 갈")
     ("蠍" . "전갈 갈"))
    ("갈구"
     "渴求")
    ("갈급"
     "渴急")
    ("갈등"
     "葛藤")
    ("갈등론적"
     "葛藤論的")
    ("갈등형"
     "葛藤型")
    ("갈망"
     "渴望")
    ("갈색"
     "褐色")
    ("갈수기"
     "渴水期")
    ("갈애"
     "渴愛")
    ("갈이천정"
     "渴而穿井")
    ("갈증"
     "渴症")
    ("갈채"
     "喝采")
    ("갈충보국"
     "竭忠報國")
    ("갈취"
     "喝取")
    ("갈취형"
     "喝取型")
    ("갈탄"
     "褐炭")
    ("갈파"
     "喝破")
    ("갈포"
     "葛布")
    ("감"
     ("勘" . "마감할 감, 정할 감")
     ("坎" . "구덩이 감, 험할 감, 작은 잔 감, 괘 이름 감, 불우하여 뜻을 이루지 못할 감")
     ("堪" . "견딜 감, 이길 감, 맡을 감, 하늘 감, 산 모양이 기괴할 감")
     ("嵌" . "깊은 골 감, 곁굴 감, 깊은 산 감")
     ("感" . "감동할 감, 찌를 감, 깨달을 감, 느낄 감")
     ("憾" . "섭섭할 감, 한할 감, 한혐할 감")
     ("戡" . "찌를 감, 이길 감, 죽일 감")
     ("敢" . "감히 감, 구태여 감, 날랠 감, 용맹할 감")
     ("柑" . "감귤 감, 감자 감")
     ("橄" . "감람나무 감")
     ("減" . "덜 감, 무지러질 감, 가벼울 감, 물이름 감")
     ("甘" . "달 감, 달게 여길 감")
     ("疳" . "감질병 감, 궤양 감, 창병 감, 종기 아플 감")
     ("監" . "거느릴 감, 살필 감, 볼 감, 벼슬 감, 감옥 감")
     ("瞰" . "굽어볼 감, 내려다 볼 감")
     ("紺" . "아청 감, 보랏빛 감")
     ("鑑" . "거울 감, 밝을 감, 비칠 감, 경계할 감")
     ("鑒" . "鑑과 同字")
     ("龕" . "취할 감, 이길 감, 감실 감")
     ("坩" . "도가니 감")
     ("埳" . "구덩이 감")
     ("嵁" . "산 험할 감")
     ("弇" . "뚜껑 감, 사람이름 감")
     ("憨" . "어리석을 감, 미련할 감")
     ("撼" . "흔들 감, 움직일 감, 깨뜨릴 감")
     ("欿" . "서운할 감, 찌푸릴 감, 걱정할 감")
     "歛"
     "泔"
     "淦"
     "澉"
     "矙"
     "轗"
     "酣"
     "闞"
     "鹻")
    ("감가"
     "坎軻")
    ("감가상각비"
     "減價償却費")
    ("감각"
     "感覺")
    ("감각적"
     "感覺的")
    ("감개"
     "感慨")
    ("감개무량"
     "感慨無量")
    ("감격"
     "感激")
    ("감격적"
     "感激的")
    ("감경"
     "減輕")
    ("감광지"
     "感光紙")
    ("감광판"
     "感光板")
    ("감구지회"
     "感舊之懷")
    ("감군"
     "減軍")
    ("감귤"
     "柑橘")
    ("감금"
     "監禁")
    ("감금당"
     "監禁當")
    ("감금죄"
     "監禁罪")
    ("감기"
     "感氣")
    ("감기약"
     "感氣藥")
    ("감내"
     "堪耐")
    ("감당"
     "堪當")
    ("감독"
     "減毒"
     "監督")
    ("감독관"
     "監督官")
    ("감독권"
     "監督權")
    ("감독론"
     "監督論")
    ("감독상"
     "監督賞")
    ("감독원"
     "監督院")
    ("감독자"
     "監督者")
    ("감독직"
     "監督職")
    ("감동"
     "感動")
    ("감동적"
     "感動的")
    ("감량"
     "減量")
    ("감리자"
     "監理者")
    ("감면"
     "減免")
    ("감명"
     "感銘")
    ("감미"
     "甘味")
    ("감미료"
     "甘味料")
    ("감방"
     "勘放"
     "監房")
    ("감별"
     "鑑別")
    ("감별력"
     "鑑別力")
    ("감복"
     "感服")
    ("감봉"
     "減俸")
    ("감불생심"
     "敢不生心")
    ("감사"
     "勘査"
     "感謝"
     "監事"
     "監司"
     "監査")
    ("감사관"
     "監査官")
    ("감사권"
     "監査權")
    ("감사반"
     "監査班")
    ("감사반원"
     "監査班員")
    ("감사실"
     "監査室")
    ("감사원"
     "鑑査員")
    ("감사절"
     "感謝節")
    ("감상"
     "感傷"
     "感想"
     "鑑賞")
    ("감상문"
     "感想文")
    ("감상실"
     "鑑賞室")
    ("감상자"
     "鑑賞者")
    ("감상적"
     "感傷的")
    ("감상주의"
     "感傷主義")
    ("감상회"
     "鑑賞會")
    ("감색"
     "減色"
     "紺色")
    ("감성"
     "感性")
    ("감성적"
     "感性的")
    ("감성화"
     "感性化")
    ("감소"
     "減少")
    ("감소분"
     "減少分")
    ("감소세"
     "減少勢")
    ("감소율"
     "減少率")
    ("감소치"
     "減少値")
    ("감속"
     "減速")
    ("감수"
     "甘受"
     "甘水"
     "甘遂")
    ("감수력"
     "感受力")
    ("감수성"
     "感受性")
    ("감시"
     "監視")
    ("감시권"
     "監視圈")
    ("감시대"
     "監視臺")
    ("감시망"
     "監視網")
    ("감시원"
     "監視員")
    ("감시자"
     "監視者")
    ("감시탑"
     "監視塔")
    ("감식"
     "鑑識")
    ("감안"
     "勘案")
    ("감액"
     "減額")
    ("감언이설"
     "甘言利說")
    ("감염"
     "感染")
    ("감염자"
     "感染者")
    ("감영"
     "監營")
    ("감옥"
     "監獄")
    ("감옥선"
     "監獄船")
    ("감옥소"
     "監獄所")
    ("감원"
     "減員")
    ("감읍"
     "感泣")
    ("감응"
     "感應")
    ("감응력"
     "感應力")
    ("감자"
     "減資")
    ("감전"
     "感電")
    ("감점"
     "減點")
    ("감정"
     "感情"
     "憾情"
     "鑑定")
    ("감정성"
     "感情性")
    ("감정인"
     "鑑定人")
    ("감정적"
     "感情的"
     "憾情的")
    ("감정지와"
     "坎井之蛙")
    ("감지"
     "感知")
    ("감지기"
     "感知器")
    ("감지덕지"
     "感之德之")
    ("감지력"
     "感知力")
    ("감지형"
     "感知型")
    ("감질"
     "疳疾")
    ("감찰"
     "監察")
    ("감찰반"
     "監察班")
    ("감천"
     "感天")
    ("감청"
     "紺靑")
    ("감초"
     "甘草")
    ("감촉"
     "感觸")
    ("감축"
     "減縮")
    ("감축안"
     "減縮案")
    ("감치"
     "監置")
    ("감탄"
     "感歎")
    ("감탄고토"
     "甘呑苦吐")
    ("감탄사"
     "感歎詞")
    ("감퇴"
     "減退")
    ("감투"
     "敢鬪")
    ("감행"
     "敢行")
    ("감형"
     "減刑")
    ("감호"
     "監護")
    ("감호소"
     "監護所")
    ("감화"
     "感化")
    ("감화원"
     "感化院")
    ("감회"
     "感懷")
    ("감흥"
     "感興")
    ("갑"
     ("匣" . "궤 갑, 상자 갑")
     ("岬" . "산 허구리 갑, 줄이 느런할 갑")
     ("甲" . "갑옷 갑, 첫째 천간 갑, 비롯할 갑, 떡잎 날 갑, 법령 갑, 대궐 갑")
     ("胛" . "어깻죽지 갑")
     ("鉀" . "갑옷 갑")
     ("閘" . "문 빗장 갑, 물 문 갑")
     ("韐" . "가죽바지 갑"))
    ("갑골"
     "甲骨")
    ("갑남을녀"
     "甲男乙女")
    ("갑문"
     "閘門")
    ("갑부"
     "甲富")
    ("갑사"
     "甲紗")
    ("갑상선"
     "甲狀腺")
    ("갑술"
     "甲戌")
    ("갑오"
     "甲午")
    ("갑오개혁"
     "甲午改革")
    ("갑오경장"
     "甲午更張")
    ("갑자"
     "甲子")
    ("갑족"
     "甲族")
    ("갑종"
     "甲種")
    ("갑판"
     "甲板")
    ("갑판부"
     "甲板部")
    ("갑판부원"
     "甲板部員")
    ("갑판장"
     "甲板長")
    ("갑호"
     "甲號")
    ("강"
     ("剛" . "굳을 강, 굳셀 강, 꼬장할 강, 바야흐로 강")
     ("堈" . "언덕 강, 밭 두둑 강")
     ("姜" . "성씨 강, 강할 강")
     ("岡" . "멧동 강, 산등성이 강")
     ("崗" . "岡의 俗字")
     ("康" . "편안할 강, 즐거울 강, 다섯거리 강")
     ("强" . "강할 강, 나머지 강, 바구미 강")
     ("彊" . "굳셀 강, 센 활 강, 사나울 강, 송장 뻣뻣할 강")
     ("慷" . "강개할 강")
     ("江" . "가람 강, 물 강")
     ("畺" . "疆과 同字")
     ("疆" . "땅 경계 강, 갈피 강, 굳셀 강, 변방 강")
     ("糠" . "겨 강, 번쇄할 강")
     ("絳" . "깊게 붉을 강, 강초 강")
     ("綱" . "벼리 강, 근본 강, 법 강, 대강 강")
     ("羌" . "오랑캐 강, 말 끝낼 강")
     ("腔" . "창자 강, 속 빌 강, 뼈대 강, 말 허구리 강")
     ("舡" . "오나라 배 강")
     ("薑" . "생강 강")
     ("襁" . "포대기 강")
     ("講" . "강론할 강, 강구할 강, 익힐 강, 강화할 강")
     ("鋼" . "쇠 강")
     ("降" . "내릴 강, 떨어질 강, 돌아갈 강")
     ("鱇" . "천징어 강")
     ("傋" . "아첨 아니할 강")
     ("僵" . "엎드러질 강, 쓰러질 강")
     ("壃" . "疆과 同字")
     ("忼" . "강개할 강, 뜻이 크고 기개있을 강, 탄식할 강")
     ("扛" . "마주 들 강")
     ("杠" . "외나무 다리 강, 깃대 강, 상 앞 가로막대 강, 올릴 강")
     ("橿" . "참죽나무 강, 호미자루 강, 사닥다리 강, 억셀 강")
     ("殭" . "죽어 썩지 않을 강, 마른 누에 강")
     ("矼" . "돌다리 강, 징검다리 강, 성실할 강")
     ("穅" . "겨 강, 악기이름 강")
     ("繈" . "繦의 本字")
     ("罡" . "강별 강")
     ("羗" . "羌과 同字")
     ("羫" . "밭 갈 강")
     ("茳" . "강리풀 강")
     ("豇" . "광저기 강")
     "跫"
     "釭"
     ("韁" . "고삐 강"))
    ("강간"
     "强姦")
    ("강간당"
     "强姦當")
    ("강간범"
     "强姦犯")
    ("강강수월래"
     "强羌水越來")
    ("강건"
     "强健")
    ("강경"
     "强勁")
    ("강경론"
     "强勁論")
    ("강경론자"
     "强勁論者")
    ("강경책"
     "强勁策")
    ("강경파"
     "强勁派")
    ("강고"
     "强固")
    ("강고성"
     "强固性")
    ("강공"
     "强攻")
    ("강관"
     "鋼管")
    ("강구"
     "江口"
     "講究")
    ("강구연월"
     "康衢煙月")
    ("강국"
     "强國")
    ("강군"
     "强軍")
    ("강권"
     "强勸"
     "强權")
    ("강근지친"
     "强近之親")
    ("강남"
     "江南")
    ("강녕"
     "康寧")
    ("강단"
     "講壇")
    ("강당"
     "講堂")
    ("강대국"
     "强大國")
    ("강도"
     "剛度"
     "强度"
     "强盜")
    ("강도단"
     "强盜團")
    ("강도범"
     "强盜犯")
    ("강독"
     "講讀")
    ("강독용"
     "講讀用")
    ("강등"
     "降等")
    ("강력"
     "强力")
    ("강력반"
     "强力班")
    ("강력범"
     "强力犯")
    ("강력부"
     "强力部")
    ("강렬"
     "强烈")
    ("강렬화"
     "强烈化")
    ("강령"
     "綱領")
    ("강론"
     "講論")
    ("강림"
     "降臨")
    ("강목수생"
     "剛木水生")
    ("강박"
     "强迫")
    ("강박감"
     "强迫感")
    ("강박적"
     "强迫的")
    ("강박증"
     "强迫症")
    ("강변"
     "强辯"
     "江邊")
    ("강변도로"
     "江邊道路")
    ("강보합"
     "强保合")
    ("강보합세"
     "强保合勢")
    ("강북"
     "江北")
    ("강사"
     "講師")
    ("강사진"
     "講師陣")
    ("강산"
     "江山")
    ("강산성"
     "强酸性")
    ("강상"
     "崗上")
    ("강상지변"
     "綱常之變")
    ("강설"
     "講說"
     "降雪")
    ("강성"
     "强性"
     "强盛")
    ("강세"
     "强勢")
    ("강속구"
     "强速球")
    ("강수"
     "强手")
    ("강수량"
     "降水量")
    ("강술"
     "講述")
    ("강습"
     "講習")
    ("강습소"
     "講習所")
    ("강습회"
     "講習會")
    ("강신무"
     "降神巫")
    ("강심"
     "江心")
    ("강안"
     "江岸")
    ("강압"
     "强壓")
    ("강압적"
     "强壓的")
    ("강약"
     "强弱")
    ("강약부동"
     "强弱不同")
    ("강역"
     "疆域")
    ("강연"
     "講演")
    ("강연회"
     "講演會")
    ("강요"
     "强要")
    ("강요당"
     "强要當")
    ("강우"
     "降雨")
    ("강우량"
     "降雨量")
    ("강원도"
     "江原道")
    ("강유겸전"
     "剛柔兼全")
    ("강의"
     "講義")
    ("강의록"
     "講義錄")
    ("강의실"
     "講義室")
    ("강인"
     "强靭")
    ("강인성"
     "强靭性")
    ("강자"
     "强者")
    ("강장고"
     "强壯膏")
    ("강장제"
     "强壯劑")
    ("강장지년"
     "强壯之年")
    ("강적"
     "强敵")
    ("강점"
     "强占"
     "强點")
    ("강점기"
     "强占期")
    ("강제"
     "强制")
    ("강제력"
     "强制力")
    ("강제성"
     "强制性")
    ("강제적"
     "强制的")
    ("강조"
     "强調")
    ("강좌"
     "講座")
    ("강직"
     "剛直")
    ("강철"
     "鋼鐵")
    ("강타"
     "强打")
    ("강타자"
     "强打者")
    ("강탈"
     "强奪")
    ("강태공"
     "姜太公")
    ("강판"
     "薑板"
     "鋼板")
    ("강퍅"
     "剛愎")
    ("강포"
     "江布")
    ("강풍"
     "强風")
    ("강풍명월"
     "江風明月")
    ("강행"
     "强行")
    ("강행군"
     "强行軍")
    ("강호"
     "强豪")
    ("강호연파"
     "江湖煙波")
    ("강화"
     "强化"
     "講和")
    ("강화책"
     "强化策")
    ("개"
     ("介" . "낄 개, 도울 개, 맬 개, 클 개, 중매할 개")
     ("价" . "착할 개, 클 개, 사신 개")
     ("個" . "낱 개, 치우칠 개")
     ("凱" . "싸움 이긴 풍류 개, 착할 개, 마파람 개, 좋은 사람 개")
     ("塏" . "시원한 땅 개")
     ("恝" . "걱정 없을 개")
     ("愷" . "탐할 개, 급할 개")
     ("愾" . "한숨 쉴 개, 성낼 개")
     ("慨" . "분할 개, 강개할 개, 슬플 개")
     ("改" . "고칠 개, 거듭할 개, 바꿀 개")
     ("槪" . "평두목 개, 절개 개, 대강 개, 거리낄 개, 칠한 술통 개")
     ("漑" . "물 댈 개, 씻을 개, 물 천천히 흐를 개")
     ("疥" . "옴 개")
     ("皆" . "모두 개, 한 가지 개, 같을 개")
     ("盖" . "蓋의 俗字")
     ("箇" . "낱 개, 개수 개")
     ("芥" . "겨자 개, 갓 개, 지푸라기 개, 티끌 개")
     ("蓋" . "뚜껑 개, 덮개 개, 이엉 개, 우산 개, 가리울 개")
     ("鎧" . "투구 개, 갑옷 개")
     ("開" . "열 개, 통할 개, 발할 개, 베풀 개, 풀 개")
     ("豈" . "승전악 개")
     ("剴" . "낫 개, 가까울 개, 간절할 개")
     ("匃" . "청구할 개, 줄 개, 빌 개")
     ("揩" . "문지를 개, 문질러 훔칠 개")
     ("槩" . "槪와 同字")
     ("玠" . "큰 서옥 개")
     ("磕" . "돌 부딪는 소리 개")
     ("闓" . "열 개, 풀 개, 활깍지 개"))
    ("개가"
     "凱歌"
     "改嫁")
    ("개가식"
     "開架式")
    ("개각"
     "改閣")
    ("개각설"
     "改閣說")
    ("개간"
     "開墾")
    ("개강"
     "開講")
    ("개개"
     "個個")
    ("개개인"
     "個個人")
    ("개과천선"
     "改過遷善")
    ("개관"
     "槪觀"
     "開館")
    ("개관식"
     "開館式")
    ("개관일"
     "開館日")
    ("개괄적"
     "槪括的")
    ("개교"
     "個校"
     "開校")
    ("개교기념일"
     "開校記念日")
    ("개교회"
     "個敎會")
    ("개구즉착"
     "開口卽錯")
    ("개국"
     "個國"
     "開國"
     "開局")
    ("개권유득"
     "開卷有得")
    ("개년"
     "個年")
    ("개념"
     "槪念")
    ("개념적"
     "槪念的")
    ("개념화"
     "槪念化")
    ("개도국"
     "開途國")
    ("개두환면"
     "改頭換面")
    ("개략적"
     "槪略的")
    ("개량"
     "改良")
    ("개량적"
     "改良的")
    ("개량종"
     "改良種")
    ("개량주의"
     "改良主義")
    ("개량형"
     "改良型")
    ("개량화"
     "改良化")
    ("개력"
     "改曆")
    ("개막"
     "開幕")
    ("개막식"
     "開幕式")
    ("개막일"
     "開幕日")
    ("개막작"
     "開幕作")
    ("개막전"
     "開幕戰")
    ("개명"
     "改名"
     "開明")
    ("개명화"
     "開明化")
    ("개문"
     "開門")
    ("개문납적"
     "開門納賊")
    ("개발"
     "開發")
    ("개발단"
     "開發團")
    ("개발도상국"
     "開發途上國")
    ("개발부"
     "開發部")
    ("개발부장"
     "開發部長")
    ("개발비"
     "開發費")
    ("개발사"
     "開發社")
    ("개발서"
     "開發書")
    ("개발설"
     "開發說")
    ("개발실장"
     "開發室長")
    ("개발업"
     "開發業")
    ("개발원"
     "開發員")
    ("개발자"
     "開發者")
    ("개발학과"
     "開發學科")
    ("개방"
     "開房"
     "開放")
    ("개방계"
     "開放系")
    ("개방론"
     "開放論")
    ("개방론자"
     "開放論者")
    ("개방률"
     "開放率")
    ("개방미"
     "開放美")
    ("개방성"
     "開放性")
    ("개방적"
     "開放的")
    ("개방형"
     "開放形")
    ("개방화"
     "開放化")
    ("개벽"
     "開闢")
    ("개별"
     "個別")
    ("개별성"
     "個別性")
    ("개별자"
     "個別者")
    ("개별적"
     "個別的")
    ("개별체"
     "個別體")
    ("개별화"
     "個別化")
    ("개봉"
     "開封")
    ("개봉관"
     "開封館")
    ("개봉작"
     "開封作")
    ("개사"
     "個社"
     "改詞")
    ("개선"
     "凱旋"
     "改善")
    ("개선광정"
     "改善匡正")
    ("개선안"
     "改善案")
    ("개선책"
     "改善策")
    ("개설"
     "開設")
    ("개설서"
     "槪說書")
    ("개설적"
     "槪說的")
    ("개성"
     "個性")
    ("개성미"
     "個性美")
    ("개성적"
     "個性的")
    ("개성파"
     "個性派")
    ("개성화"
     "個性化")
    ("개세지재"
     "蓋世之才")
    ("개소"
     "個所")
    ("개수"
     "個數"
     "改修")
    ("개시"
     "開始"
     "開市")
    ("개시기"
     "開始期")
    ("개시론"
     "開始論")
    ("개시일"
     "開始日")
    ("개식형"
     "個式型")
    ("개신교"
     "改新敎")
    ("개신교계"
     "改新敎界")
    ("개심"
     "改心")
    ("개아"
     "個我")
    ("개악"
     "改惡")
    ("개안"
     "開眼")
    ("개업"
     "開業")
    ("개연"
     "蓋然")
    ("개연성"
     "蓋然性")
    ("개연적"
     "蓋然的")
    ("개옥개행"
     "改玉改行")
    ("개요"
     "槪要")
    ("개요란"
     "槪要欄")
    ("개원"
     "開院")
    ("개월"
     "個月")
    ("개의"
     "介意")
    ("개인"
     "個人")
    ("개인기"
     "個人技")
    ("개인별"
     "個人別")
    ("개인사"
     "個人史")
    ("개인용품"
     "個人用品")
    ("개인적"
     "個人的")
    ("개인전"
     "個人展"
     "個人戰")
    ("개인주의"
     "個人主義")
    ("개인주의적"
     "個人主義的")
    ("개인차"
     "個人差")
    ("개인화"
     "個人化")
    ("개입"
     "介入")
    ("개입설"
     "介入說")
    ("개작"
     "改作")
    ("개작권"
     "改作權")
    ("개장"
     "開場")
    ("개재"
     "介在")
    ("개전"
     "改悛"
     "開戰")
    ("개점"
     "開店")
    ("개정"
     "改定"
     "改正"
     "改訂")
    ("개정권"
     "改定權")
    ("개정안"
     "改正案")
    ("개정판"
     "改訂版")
    ("개조"
     "個條"
     "改造"
     "開祖")
    ("개종"
     "改宗")
    ("개중"
     "個中")
    ("개진"
     "改進"
     "開陳")
    ("개찰"
     "改札")
    ("개찰구"
     "改札口")
    ("개창"
     "開創")
    ("개척"
     "開拓")
    ("개척자"
     "開拓者")
    ("개척적"
     "開拓的")
    ("개천절"
     "開天節")
    ("개체"
     "個體"
     "改替")
    ("개체성"
     "個體性")
    ("개체적"
     "個體的")
    ("개체화"
     "個體化")
    ("개촌"
     "開村")
    ("개최"
     "開催")
    ("개최지"
     "開催地")
    ("개축"
     "改築")
    ("개칭"
     "改稱")
    ("개탄"
     "慨歎")
    ("개탄조"
     "慨歎調")
    ("개통"
     "開通")
    ("개통식"
     "開通式")
    ("개편"
     "改編")
    ("개편안"
     "改編案")
    ("개폐"
     "改廢"
     "開閉")
    ("개폐식"
     "開閉式")
    ("개표"
     "開票")
    ("개학"
     "開學")
    ("개항"
     "開港")
    ("개헌"
     "改憲")
    ("개헌선"
     "改憲線")
    ("개헌안"
     "改憲案")
    ("개혁"
     "改革")
    ("개혁가"
     "改革家")
    ("개혁론"
     "改革論")
    ("개혁안"
     "改革案")
    ("개혁자"
     "改革者")
    ("개혁적"
     "改革的")
    ("개혁파"
     "改革派")
    ("개혁풍"
     "改革風")
    ("개화"
     "改化"
     "開化"
     "開花")
    ("개화기"
     "開化期")
    ("개화파"
     "開化派")
    ("개활"
     "開豁")
    ("개활지"
     "開豁地")
    ("개회"
     "開會")
    ("개회사"
     "開會辭")
    ("개회식"
     "開會式")
    ("객"
     ("喀" . "기침할 객, 토할 객")
     ("客" . "손님 객, 부칠 객, 나그네 객, 지날 객"))
    ("객관"
     "客觀")
    ("객관성"
     "客觀性")
    ("객관식"
     "客觀式")
    ("객관적"
     "客觀的")
    ("객관주의"
     "客觀主義")
    ("객관화"
     "客觀化")
    ("객기"
     "客氣")
    ("객반위주"
     "客反爲主")
    ("객사"
     "客死")
    ("객석"
     "客席")
    ("객실"
     "客室")
    ("객원"
     "客員")
    ("객장"
     "客場")
    ("객주"
     "客主")
    ("객중보체"
     "客中寶體")
    ("객지"
     "客地")
    ("객차"
     "客車")
    ("객창한등"
     "客窓寒燈")
    ("객체"
     "客體")
    ("객체적"
     "客體的")
    ("객체화"
     "客體化")
    ("갱"
     ("坑" . "빠질 갱, 묻을 갱, 구덩이 갱")
     ("粳" . "메벼 갱")
     ("羹" . "국 갱")
     ("更" . "다시 갱")
     ("硜" . "아릿아릿할 갱, 알랑알랑할 갱, 돌소리 갱")
     ("賡" . "이을 갱, 일 갱")
     ("鏗" . "금석 소리 갱, 사람이름 갱"))
    ("갱년기"
     "更年期")
    ("갱목"
     "坑木")
    ("갱생"
     "更生")
    ("갱신"
     "更新")
    ("갱유분서"
     "坑儒焚書")
    ("갹"
     "蹻")
    ("갹출"
     "醵出")
    ("거"
     ("倨" . "거만할 거, 걸터 앉을 거, 굽을 거")
     ("去" . "갈 거, 버릴 거, 오래될 거, 떨어질 거, 쫓을 거, 감출 거")
     ("居" . "살 거, 곳 거, 앉을 거, 놓을 거, 쌓을 거")
     ("巨" . "클 거, 많을 거, 억 거")
     ("拒" . "막을 거, 맞설 거, 다닥칠 거, 다다를 거")
     ("据" . "가질 거, 길거할 거, 의지할 거, 손병 거")
     ("據" . "의지할 거, 기댈 거, 웅거할 거, 짚을 거")
     ("擧" . "들 거, 받들 거, 움직일 거, 일걸을 거")
     ("渠" . "개천 거, 도랑 거, 휑덩그렁할 거, 클 거, 껄껄 웃을 거, 무엇 거")
     ("炬" . "횃불 거, 불 땔 거")
     ("祛" . "물리칠 거, 빌 거, 굳셀 거")
     ("距" . "며느리 발톱 거, 지낼 거, 뛸 거, 겨룰 거, 미눌 거")
     ("踞" . "걸터앉을 거")
     "迲"
     ("遽" . "급할 거, 두려울 거, 역말 수레 거")
     ("醵" . "술추렴 거, 추렴 걷을 거")
     ("鉅" . "갈고리 거, 클 거, 강한 쇠 거")
     ("鋸" . "톱 거, 다리 꺾는 형벌 거")
     ("車" . "수레 거, 그물 거, 잇몸 거")
     ("佉" . "나라이름 거")
     ("呿" . "입 딱 벌일 거")
     ("昛" . "밝을 거")
     ("秬" . "검은 기장 거")
     ("筥" . "쌀 담는 광주리 거, 볏단 거")
     ("籧" . "대자리 거, 천상바라기 거, 양잠기 거")
     ("胠" . "열 거, 갈비 거")
     ("腒" . "건치 거, 꿩 포 거")
     ("苣" . "상추 거, 검은 깨 거")
     ("莒" . "모시풀 거, 나라이름 거, 고을이름 거")
     ("蕖" . "연꽃 거")
     ("蘧" . "패랭이꽃 거, 석죽화 거, 마음에 든든할 거")
     ("袪" . "소매 거, 소매 아귀 거")
     ("裾" . "옷 뒷자락 거")
     ("駏" . "튀기 거, 거공벌레 거"))
    ("거가대족"
     "巨家大族")
    ("거간"
     "居間")
    ("거개"
     "擧皆")
    ("거거익심"
     "去去益甚")
    ("거경궁리"
     "居敬窮理")
    ("거구"
     "巨軀")
    ("거국적"
     "擧國的")
    ("거금"
     "巨金")
    ("거대"
     "巨大")
    ("거대화"
     "巨大化")
    ("거동"
     "擧動")
    ("거두절미"
     "去頭截尾")
    ("거래"
     "去來")
    ("거래량"
     "去來量")
    ("거래선"
     "去來先")
    ("거래세"
     "去來稅")
    ("거래액"
     "去來額")
    ("거래자"
     "去來者")
    ("거래점"
     "去來店")
    ("거래제"
     "去來制")
    ("거래처"
     "去來處")
    ("거론"
     "擧論")
    ("거리"
     "距離")
    ("거리감"
     "距離感")
    ("거만"
     "倨慢")
    ("거명"
     "擧名")
    ("거목"
     "巨木")
    ("거문불납"
     "拒門不納")
    ("거물"
     "巨物")
    ("거봉"
     "巨峯")
    ("거부"
     "巨富"
     "拒否")
    ("거부감"
     "拒否感")
    ("거부권"
     "拒否權")
    ("거사"
     "居士"
     "巨事")
    ("거산"
     "巨山")
    ("거상"
     "巨像")
    ("거서간"
     "居西干")
    ("거석"
     "巨石")
    ("거선"
     "巨船")
    ("거성"
     "居城")
    ("거세"
     "去勢")
    ("거세당"
     "去勢當")
    ("거소"
     "居所")
    ("거수"
     "巨獸"
     "擧手"
     "渠首")
    ("거수경례"
     "擧手敬禮")
    ("거시"
     "巨視"
     "踞侍")
    ("거시적"
     "巨視的")
    ("거식증"
     "拒食症")
    ("거실"
     "居室")
    ("거안사위"
     "居安思危")
    ("거안제미"
     "擧案齊眉")
    ("거액"
     "巨額")
    ("거여"
     "巨與")
    ("거역"
     "拒逆")
    ("거인"
     "巨人")
    ("거인국"
     "巨人國")
    ("거일반삼"
     "擧一反三")
    ("거자물추"
     "去者勿追")
    ("거자일소"
     "去者日疎")
    ("거자필반"
     "去者必反")
    ("거장"
     "巨匠")
    ("거재두량"
     "車載斗量")
    ("거재마전"
     "車在馬前")
    ("거절"
     "拒絶")
    ("거절당"
     "拒絶當")
    ("거점"
     "據點")
    ("거정"
     "巨晶")
    ("거주"
     "居住")
    ("거주구"
     "居住區")
    ("거주민"
     "居住民")
    ("거주자"
     "居住者")
    ("거주지"
     "居住地")
    ("거주촉객"
     "擧酒屬客")
    ("거지반"
     "居之半")
    ("거창"
     "巨創")
    ("거처"
     "居處")
    ("거취"
     "去就")
    ("거폐생폐"
     "去弊生弊")
    ("거행"
     "擧行")
    ("건"
     ("乾" . "하늘 건, 괘 이름 건, 서북쪽 건, 굳셀 건, 임금 건")
     ("件" . "조건 건, 가지 건, 구별할 건, 나눌 건")
     ("健" . "굳셀 건, 병 없을 건, 탐할 건")
     ("巾" . "수건 건, 덮을 건")
     ("建" . "세울 건, 둘 건, 심을 건, 칼집 건, 별이름 건")
     ("愆" . "죄 건, 허물 건, 어기어질 건")
     ("楗" . "문 빗장 건, 문지방 건")
     ("腱" . "힘줄 건")
     ("虔" . "정성 건, 빼앗을 건, 죽일 건")
     ("蹇" . "절름거릴 건, 험할 건, 교만할 건")
     ("鍵" . "열쇠 건, 수레 굴대 건")
     ("騫" . "말 배 앓을 건, 이지러질 건, 휙 뛰어 나아갈 건")
     ("揵" . "멜 건, 막을 건, 들 건")
     ("犍" . "불친 소 건, 짐승이름 건, 촉나라 고을이름 건")
     ("睷" . "눈으로 세어볼 건")
     ("褰" . "바지 건, 걷을 건, 발 걷을 건")
     ("謇" . "말 더듬거릴 건, 바른말할 건")
     ("鞬" . "칼집 건, 동개 건"))
    ("건각"
     "健脚")
    ("건강"
     "健康")
    ("건강관리"
     "健康管理")
    ("건강미"
     "健康美")
    ("건강성"
     "健康性")
    ("건강식"
     "健康食")
    ("건강식품"
     "健康食品")
    ("건강체"
     "健康體")
    ("건강학"
     "健康學")
    ("건계"
     "乾季")
    ("건곤일척"
     "乾坤一擲")
    ("건과"
     "乾果")
    ("건구역"
     "乾嘔逆")
    ("건국"
     "建國")
    ("건국자"
     "建國者")
    ("건군"
     "建軍")
    ("건냉소"
     "乾冷所")
    ("건뇌제"
     "建腦劑")
    ("건달"
     "乾達")
    ("건답법"
     "乾畓法")
    ("건립"
     "建立")
    ("건망증"
     "健忘症")
    ("건물"
     "建物")
    ("건물주"
     "建物主")
    ("건반"
     "鍵盤")
    ("건배"
     "乾杯")
    ("건설"
     "建設")
    ("건설기적"
     "建設期的")
    ("건설비"
     "建設費")
    ("건설업"
     "建設業")
    ("건설업계"
     "建設業界")
    ("건설업자"
     "建設業者")
    ("건설자"
     "建設者")
    ("건설적"
     "建設的")
    ("건설처장"
     "建設處長")
    ("건성"
     "乾性")
    ("건수"
     "件數")
    ("건식"
     "乾食")
    ("건실"
     "健實")
    ("건어물"
     "乾魚物")
    ("건의"
     "建議")
    ("건의문"
     "建議文")
    ("건장"
     "健壯")
    ("건재"
     "健在"
     "建材")
    ("건전"
     "健全")
    ("건전도"
     "健全度")
    ("건전성"
     "健全性")
    ("건전지"
     "乾電池")
    ("건조"
     "乾燥")
    ("건조기"
     "乾燥期")
    ("건조물"
     "建造物")
    ("건조실"
     "乾燥室")
    ("건조증"
     "乾燥症")
    ("건조지"
     "乾燥地")
    ("건준"
     "建準")
    ("건중탕"
     "建中湯")
    ("건지황"
     "乾地黃")
    ("건초"
     "乾草")
    ("건축"
     "建築")
    ("건축가"
     "建築家")
    ("건축계"
     "建築界")
    ("건축관"
     "建築觀")
    ("건축물"
     "建築物")
    ("건축미"
     "建築美")
    ("건축법"
     "建築法")
    ("건축비"
     "建築費")
    ("건축사"
     "建築士")
    ("건축사학"
     "建築史學")
    ("건축사학자"
     "建築史學者")
    ("건축업"
     "建築業")
    ("건축인"
     "建築人")
    ("건축적"
     "建築的")
    ("건축주"
     "建築主")
    ("건축학"
     "建築學")
    ("건축학계"
     "建築學界")
    ("건축학과"
     "建築學科")
    ("건치"
     "健齒")
    ("건투"
     "健鬪")
    ("건평"
     "建坪")
    ("건포도"
     "乾葡萄")
    ("건필"
     "健筆")
    ("걸"
     ("乞" . "구걸할 걸, 요구할 걸, 원할 걸, 거지 걸")
     ("偈" . "힘 빼두를 걸, 빠를 걸, 헌걸찰 걸")
     ("傑" . "호걸 걸, 준걸 걸, 뛰어날 걸, 거만할 걸, 떡잎 걸")
     ("杰" . "傑의 俗字")
     ("桀" . "찢을 걸, 홰 걸, 빼어날 걸, 멜 걸, 사나을 걸, 왕이름 걸")
     ("乬" . "갈 걸")
     ("朅" . "갈 걸")
     ("榤" . "닭의 홰 걸"))
    ("걸불병행"
     "乞不竝行")
    ("걸신"
     "乞神")
    ("걸인"
     "乞人")
    ("걸작"
     "傑作")
    ("걸작품"
     "傑作品")
    ("걸출"
     "傑出")
    ("검"
     ("儉" . "검소할 검, 흉년들 검, 적을 검, 가난할 검")
     ("劍" . "칼 검, 칼로 찔러 죽일 검, 칼 쓰는법 검")
     ("劒" . "劎의 譌字")
     ("檢" . "교정할 검, 금제할 검, 법 검, 봉할 검, 책메뚜기 검, 수결둘 검")
     ("瞼" . "눈시울 검")
     ("鈐" . "굴대 비녀장 검, 자물쇠 검, 큰 보습 검")
     ("黔" . "검을 검")
     "岒"
     ("撿" . "잡을 검, 구속할 검, 관찰할 검, 비교할 검")
     ("芡" . "마름 검, 가시연밥 검"))
    ("검객"
     "劍客")
    ("검거"
     "檢擧")
    ("검거망"
     "檢擧網")
    ("검검청"
     "檢檢廳")
    ("검경"
     "檢警")
    ("검도부"
     "劍道部")
    ("검무"
     "劍舞")
    ("검문"
     "檢問")
    ("검문검색"
     "檢問檢索")
    ("검문소"
     "檢問所")
    ("검사"
     "檢事"
     "檢査")
    ("검사공"
     "檢査工")
    ("검사기"
     "檢査機")
    ("검사대"
     "檢査臺")
    ("검사물"
     "檢査物")
    ("검사법"
     "檢査法")
    ("검사비"
     "檢査費")
    ("검사소"
     "檢査所")
    ("검사실"
     "檢査室")
    ("검사역"
     "檢査役")
    ("검사장"
     "檢事長")
    ("검사제"
     "檢査制")
    ("검사청장"
     "檢査廳長")
    ("검산"
     "檢算")
    ("검색"
     "檢索")
    ("검색기"
     "檢索機")
    ("검색당"
     "檢索當")
    ("검색대"
     "檢索臺")
    ("검색원"
     "檢索員")
    ("검소"
     "儉素")
    ("검속"
     "檢束")
    ("검식관"
     "檢食官")
    ("검역"
     "檢疫")
    ("검역소"
     "檢疫所")
    ("검열"
     "檢閱")
    ("검열난"
     "檢閱難")
    ("검정"
     "檢定")
    ("검정고시"
     "檢定考試")
    ("검증"
     "檢證")
    ("검진"
     "檢診")
    ("검찰"
     "檢察")
    ("검찰권"
     "檢察權")
    ("검찰력"
     "檢察力")
    ("검찰부"
     "檢察部")
    ("검찰청"
     "檢察廳")
    ("검출"
     "檢出")
    ("검토"
     "檢討")
    ("검토자"
     "檢討者")
    ("검투사"
     "劍鬪士")
    ("검표"
     "檢票")
    ("겁"
     ("劫" . "위협할 겁, 겁탈할 겁, 부지런할 겁, 대궐 층계 겁, 겁 겁, 화재 겁")
     ("怯" . "무서워할 겁, 겁낼 겁, 으를 겁")
     ("刦" . "겁탈할 겁, 구속할 겁")
     ("刧" . "刦의 俗字"))
    ("겁탈"
     "劫奪")
    ("겁탈당"
     "劫奪當")
    ("게"
     ("偈" . "쉴 게, 게타 게, 글귀 게")
     ("憩" . "쉴 게")
     ("揭" . "높이 들 게, 옷 걷고 물 건널 게, 등에 질 게"))
    ("게시"
     "揭示")
    ("게시판"
     "揭示板")
    ("게양"
     "揭揚")
    ("게양대"
     "揭揚臺")
    ("게재"
     "揭載")
    ("격"
     ("擊" . "撃과 同字")
     ("格" . "이를 격, 올 격, 바를 격, 대적할 격, 감동할 격")
     ("檄" . "격서 격, 격문 격, 과격할 격")
     ("激" . "물결 부딪혀 흐를 격, 찌를 격, 맑은 소리 격, 말 과격히 할 격")
     ("膈" . "명치 격")
     ("覡" . "박수 격, 남자무당 격")
     ("隔" . "막을 격, 멀 격")
     ("挌" . "칠 격, 들 격")
     ("毄" . "맞부딛는 소리 격, 충돌할 격, 창 격")
     "翮"
     ("闃" . "고요할 격")
     ("骼" . "마른 뼈 격, 드러난 뼈 격, 짐승의 뼈 격")
     ("鬲" . "오지병 격, 땅이름 격")
     ("鴃" . "왜가리 격, 때까치 격"))
    ("격감"
     "激減")
    ("격강천리"
     "隔江千里")
    ("격고명금"
     "擊鼓鳴金")
    ("격구"
     "擊毬")
    ("격년"
     "隔年")
    ("격년제"
     "隔年制")
    ("격노"
     "激怒")
    ("격돌"
     "激突")
    ("격동"
     "激動")
    ("격동기"
     "激動期")
    ("격랑"
     "激浪")
    ("격려"
     "激勵")
    ("격려금"
     "激勵金")
    ("격려사"
     "激勵辭")
    ("격렬"
     "激烈")
    ("격론"
     "激論")
    ("격류"
     "激流")
    ("격리"
     "隔離")
    ("격리감"
     "隔離感")
    ("격리성"
     "隔離性")
    ("격멸"
     "擊滅")
    ("격무"
     "激務")
    ("격문"
     "檄文")
    ("격물치지"
     "格物致知")
    ("격변"
     "激變")
    ("격변기"
     "激變期")
    ("격분"
     "激忿")
    ("격상"
     "格上")
    ("격세지감"
     "隔世之感")
    ("격식"
     "格式")
    ("격식화"
     "格式化")
    ("격심"
     "激甚")
    ("격앙"
     "激昻")
    ("격양가"
     "擊壤歌")
    ("격언"
     "格言")
    ("격월"
     "隔月")
    ("격월간"
     "隔月刊")
    ("격의"
     "隔意")
    ("격일제"
     "隔日制")
    ("격자형"
     "格子形")
    ("격장지린"
     "隔墻之隣")
    ("격전"
     "激戰")
    ("격전지"
     "激戰地")
    ("격정"
     "激情")
    ("격정적"
     "激情的")
    ("격조"
     "格調"
     "隔阻")
    ("격차"
     "隔差")
    ("격찬"
     "激讚")
    ("격추"
     "擊墜")
    ("격침"
     "擊沈")
    ("격투"
     "格鬪")
    ("격투기"
     "格鬪技")
    ("격파"
     "擊破")
    ("격하"
     "格下")
    ("격화"
     "激化")
    ("격화소양"
     "隔靴搔瘍")
    ("견"
     "俔"
     ("堅" . "굳을 견, 굳셀 견, 반드시 견")
     ("牽" . "당길 견, 이끌 견, 빠를 견, 거리낄 견, 볏줄 견")
     ("犬" . "큰 개 견")
     ("甄" . "질그릇 견, 살필 견, 표시할 견, 진 이름 견, 면할 견, 밝을 견")
     ("絹" . "비단 견, 깁 견")
     ("繭" . "고치 견, 발 부르틀 견, 목 쉴 견, 비단 견")
     ("肩" . "어깨 견, 이길 견, 맡길 견, 멜 견, 세 살 된 짐승 견")
     ("見" . "볼 견, 만날 견, 당할 견")
     ("譴" . "꾸짖을 견, 성낼 견, 귀양갈 견")
     ("遣" . "보낼 견, 쫓을 견, 견전제 견")
     ("鵑" . "접동새 견, 두견새 견, 뻐꾹새 견")
     ("樫" . "떡갈나무 견")
     ("狷" . "고집스러울 견, 조수할 견, 편협할 견")
     ("畎" . "밭 도랑 견, 산골 도랑 견")
     ("筧" . "대 홈통 견")
     ("繾" . "곡진할 견, 마지 않을 견")
     ("羂" . "걸 견, 걸릴 견")
     ("蠲" . "밝을 견, 조촐할 견, 반딧불 견")
     ("鰹" . "큰 가물치 견, 물치 견, 강고도리 견"))
    ("견갑골"
     "肩胛骨")
    ("견강부회"
     "牽强附會")
    ("견결"
     "堅決")
    ("견고"
     "堅固")
    ("견공"
     "犬公")
    ("견과"
     "堅果")
    ("견금여석"
     "見金如石")
    ("견기이작"
     "見機而作")
    ("견리사의"
     "見利思義")
    ("견마지로"
     "犬馬之勞")
    ("견마지치"
     "犬馬之齒")
    ("견문"
     "見聞")
    ("견문발검"
     "見蚊拔劍")
    ("견물생심"
     "見物生心")
    ("견본"
     "見本")
    ("견본시"
     "見本市")
    ("견비통"
     "肩臂痛")
    ("견사"
     "絹紗"
     "絹絲")
    ("견성성불"
     "見性成佛")
    ("견습"
     "見習")
    ("견습공"
     "見習工")
    ("견습원"
     "見習員")
    ("견아상제"
     "犬牙相制")
    ("견여금석"
     "堅如金石")
    ("견우직녀"
     "牽牛織女")
    ("견원지간"
     "犬猿之間")
    ("견위수명"
     "見危授命")
    ("견인"
     "牽引")
    ("견인불발"
     "堅忍不拔")
    ("견인차"
     "牽引車")
    ("견장"
     "肩章")
    ("견적"
     "見積")
    ("견적서"
     "見積書")
    ("견전제"
     "遣奠祭")
    ("견제"
     "牽制")
    ("견제력"
     "牽制力")
    ("견지"
     "堅持"
     "見地")
    ("견직"
     "絹織")
    ("견직물"
     "絹織物")
    ("견진"
     "堅振")
    ("견책"
     "譴責")
    ("견토지쟁"
     "犬兎之爭")
    ("견포"
     "絹布")
    ("견학"
     "見學")
    ("견해"
     "見解")
    ("견해차"
     "見解差")
    ("견현사제"
     "見賢思齊")
    ("결"
     ("抉" . "긁을 결, 당길 결")
     ("拮" . "길거할 결, 열심히 일할 결")
     ("決" . "결단할 결, 물이름 결, 물골 터 놓을 결, 끊을 결, 이별할 결")
     ("潔" . "맑을 결, 정결할 결, 조촐할 결")
     ("結" . "맺을 결, 마칠 결, 나중 결, 몫 결")
     ("缺" . "이지러질 결, 번개 번쩍거릴 결, 깨어질 결, 이 빠질 결")
     ("訣" . "이별할 결, 열결할 결, 사례할 결, 비결 결")
     ("玦" . "옥패 결, 활 깍지 결")
     "絜"
     ("觖" . "서운할 결, 들쳐낼 결, 바랄 결")
     ("闋" . "쉴 결, 다할 결, 풍류 마칠 결, 문 닫을 결")
     "鴃")
    ("결각"
     "缺刻")
    ("결각상"
     "缺刻狀")
    ("결강"
     "缺講")
    ("결격"
     "缺格")
    ("결계"
     "結界")
    ("결곤"
     "決棍")
    ("결과"
     "結果"
     "缺課")
    ("결과론"
     "結果論")
    ("결과론적"
     "結果論的")
    ("결과물"
     "結果物")
    ("결과적"
     "結果的")
    ("결국"
     "結局")
    ("결근"
     "缺勤")
    ("결단"
     "決斷"
     "結團")
    ("결단력"
     "決斷力")
    ("결렬"
     "決裂")
    ("결례"
     "缺禮")
    ("결론"
     "結論")
    ("결론적"
     "結論的")
    ("결막염"
     "結膜炎")
    ("결말"
     "結末")
    ("결말부"
     "結末部")
    ("결박"
     "結縛")
    ("결백"
     "潔白")
    ("결벽"
     "潔癖")
    ("결벽증"
     "潔癖症")
    ("결별"
     "訣別")
    ("결부"
     "結付")
    ("결빙"
     "結氷")
    ("결사"
     "決死"
     "結社")
    ("결사문"
     "結社文")
    ("결사반대"
     "決死反對")
    ("결사적"
     "決死的")
    ("결산"
     "決算")
    ("결산서"
     "決算書")
    ("결석"
     "缺席")
    ("결석계"
     "缺席屆")
    ("결석생"
     "缺席生")
    ("결석자"
     "缺席者")
    ("결선"
     "決選")
    ("결성"
     "結成")
    ("결성식"
     "結成式")
    ("결속"
     "結束")
    ("결속력"
     "結束力")
    ("결속체"
     "結束體")
    ("결손"
     "缺損")
    ("결손증"
     "缺損症")
    ("결승"
     "決勝")
    ("결승선"
     "決勝線")
    ("결승전"
     "決勝戰")
    ("결승점"
     "決勝點")
    ("결식아동"
     "缺食兒童")
    ("결실"
     "結實")
    ("결심"
     "決心"
     "結審")
    ("결안"
     "結案")
    ("결여"
     "缺如")
    ("결여론"
     "缺如論")
    ("결여론자"
     "缺如論者")
    ("결여설"
     "缺如說")
    ("결연"
     "決然"
     "結緣")
    ("결원"
     "缺員")
    ("결의"
     "決意"
     "決議"
     "結義")
    ("결의문"
     "決議文")
    ("결의서"
     "決意書")
    ("결의안"
     "決議案")
    ("결의형제"
     "結義兄弟")
    ("결자해지"
     "結者解之")
    ("결장"
     "缺場")
    ("결재"
     "決裁")
    ("결재란"
     "決裁欄")
    ("결전"
     "決戰")
    ("결절점"
     "決折點")
    ("결점"
     "缺點")
    ("결정"
     "決定"
     "結晶")
    ("결정권"
     "決定權")
    ("결정력"
     "決定力")
    ("결정론"
     "決定論")
    ("결정론자"
     "決定論者")
    ("결정론적"
     "決定論的")
    ("결정문"
     "決定文")
    ("결정자"
     "決定者")
    ("결정적"
     "決定的")
    ("결정전"
     "決定戰")
    ("결정체"
     "結晶體")
    ("결제"
     "決濟")
    ("결집"
     "結集")
    ("결집력"
     "結集力")
    ("결집체"
     "結集體")
    ("결처"
     "決處")
    ("결초보은"
     "結草報恩")
    ("결탁"
     "結託")
    ("결투"
     "決鬪")
    ("결판"
     "決判")
    ("결핍"
     "缺乏")
    ("결핍증"
     "缺乏症")
    ("결함"
     "缺陷")
    ("결합"
     "結合")
    ("결합력"
     "結合力")
    ("결항"
     "缺航")
    ("결핵"
     "結核")
    ("결핵균"
     "結核菌")
    ("결핵병"
     "結核病")
    ("결혼"
     "結婚")
    ("결혼관"
     "結婚觀")
    ("결혼기념일"
     "結婚記念日")
    ("결혼설"
     "結婚說")
    ("결혼식"
     "結婚式")
    ("결혼식장"
     "結婚式場")
    ("겸"
     ("兼" . "겸할 겸, 아우를 겸, 둘 얻을 겸, 모을 겸")
     ("慊" . "앙심먹을 겸, 불만족하게 생각할 겸, 싫을 겸")
     ("箝" . "재갈 겸, 족집개 겸, 목 잠글 겸")
     ("謙" . "사양할 겸, 겸손할 겸, 괘 이름 겸")
     ("鉗" . "목사슬 겸, 세력으로써 남을 누를 겸, 입 다물 겸")
     ("鎌" . "낫 겸")
     ("傔" . "겸종 겸")
     ("嗛" . "부족히 여길 겸, 겸손 겸, 입에 밥 물고 있을 겸")
     ("拑" . "자갈 먹일 겸")
     "檶"
     ("歉" . "흉년들 겸, 적을 겸, 나쁠 겸")
     ("縑" . "합사비단 겸")
     ("蒹" . "갈대 겸")
     "鹻"
     ("黚" . "얕은 금향빛 겸")
     ("鼸" . "두더쥐 겸"))
    ("겸병"
     "兼倂")
    ("겸비"
     "兼備")
    ("겸사"
     "謙辭")
    ("겸상"
     "兼床")
    ("겸손"
     "謙遜")
    ("겸양"
     "謙讓")
    ("겸양지덕"
     "謙讓之德")
    ("겸업"
     "兼業")
    ("겸연"
     "慊然")
    ("겸용"
     "兼用")
    ("겸용선"
     "兼用線")
    ("겸유"
     "兼有")
    ("겸인지용"
     "兼人之勇")
    ("겸임"
     "兼任")
    ("겸직"
     "兼職")
    ("겸허"
     "謙虛")
    ("겸허감"
     "謙虛感")
    ("경"
     ("京" . "서울 경")
     ("俓" . "徑과 同字")
     ("倞" . "굳셀 경")
     ("傾" . "기울 경")
     ("儆" . "경계할 경")
     ("勁" . "굳셀 경")
     ("勍" . "셀 경")
     ("卿" . "벼슬 경")
     ("坰" . "들 경")
     ("境" . "지경 경")
     ("庚" . "일곱째 천간 경")
     ("徑" . "지름길 경")
     ("慶" . "경사 경")
     ("憬" . "깨달을 경")
     ("擎" . "들 경")
     ("敬" . "공경할 경")
     ("景" . "별 경")
     ("暻" . "밝을 경")
     ("更" . "고칠 경")
     ("梗" . "대개 경")
     ("涇" . "통할 경")
     ("炅" . "빛날 경")
     ("烱" . "빛날 경")
     ("璟" . "옥 빛 경")
     ("璥" . "경옥 경")
     ("瓊" . "옥 경")
     ("痙" . "심줄 땅길 경")
     ("硬" . "굳을 경")
     ("磬" . "경쇠 경")
     ("竟" . "다할 경")
     ("競" . "겨룰 경")
     ("絅" . "끌어 쥘 경")
     ("經" . "날 경")
     ("耕" . "밭갈 경")
     ("耿" . "빛날 경")
     ("脛" . "정강이 경")
     ("莖" . "줄기 경")
     ("警" . "경계할 경")
     ("輕" . "가벼울 경")
     ("逕" . "소로 경")
     ("鏡" . "거울 경")
     ("頃" . "밭 넓이 단위 경")
     ("頸" . "목 경")
     ("驚" . "놀랄 경")
     ("鯨" . "고래 경")
     ("冏" . "빛날 경")
     ("剄" . "목 벨 경")
     ("哽" . "목멜 경")
     ("惸" . "근심할 경")
     ("憼" . "공경할 경")
     ("扃" . "빗장 경")
     ("檠" . "도지개 경")
     ("焭" . "근싱할 경")
     ("煢" . "외로울 경")
     ("熲" . "빛날 경")
     ("畊" . "耕의 古字")
     ("竸" . "競과 同字")
     ("綆" . "두레박줄 경")
     ("罄" . "빌 경")
     ("褧" . "홑옷 경")
     ("謦" . "기침 경")
     ("顈" . "홑옷 경")
     ("駉" . "목장 경")
     ("鯁" . "생선뼈 경")
     ("黥" . "묵형할 경"))
    ("경각"
     "頃刻")
    ("경각심"
     "警覺心")
    ("경감"
     "警監"
     "輕減")
    ("경개"
     "梗槪")
    ("경거망동"
     "輕擧妄動")
    ("경건"
     "敬虔")
    ("경결"
     "硬結")
    ("경계"
     "境界"
     "經界"
     "警戒")
    ("경계경보"
     "警戒警報")
    ("경계령"
     "警戒令")
    ("경계론"
     "警戒論")
    ("경계망"
     "警戒網")
    ("경계부"
     "境界部")
    ("경계선"
     "境界線")
    ("경계심"
     "警戒心")
    ("경고"
     "警告"
     "警固")
    ("경고문"
     "警告文")
    ("경고성"
     "警告性")
    ("경공업"
     "輕工業")
    ("경과"
     "經過")
    ("경관"
     "景觀"
     "警官")
    ("경관화"
     "景觀化")
    ("경구"
     "警句")
    ("경구금"
     "經拘禁")
    ("경국지색"
     "傾國之色")
    ("경국지재"
     "經國之才")
    ("경금"
     "經錦")
    ("경기"
     "景氣"
     "競技"
     "驚氣")
    ("경기관총"
     "輕機關銃")
    ("경기도"
     "京畿道")
    ("경기력"
     "競技力")
    ("경기상"
     "競技賞")
    ("경기장"
     "競技場")
    ("경기화"
     "競技化")
    ("경난"
     "經難")
    ("경내"
     "境內")
    ("경단"
     "瓊團")
    ("경당문노"
     "耕當問奴")
    ("경대"
     "鏡臺")
    ("경대부"
     "卿大夫")
    ("경도"
     "傾倒"
     "傾度")
    ("경도력"
     "傾度力")
    ("경동"
     "傾動")
    ("경락"
     "競落"
     "經絡")
    ("경량화"
     "輕量化")
    ("경력"
     "經歷")
    ("경력자"
     "經歷者")
    ("경련"
     "痙攣")
    ("경련성"
     "痙攣性")
    ("경례"
     "敬禮")
    ("경로"
     "敬老"
     "經路")
    ("경로당"
     "敬老堂")
    ("경로도"
     "經路圖")
    ("경로사상"
     "敬老思想")
    ("경루"
     "經樓")
    ("경륜"
     "經綸")
    ("경리"
     "景利"
     "經理")
    ("경리과"
     "經理課")
    ("경리부"
     "經理部")
    ("경리실"
     "經理室")
    ("경마"
     "牽馬"
     "競馬")
    ("경마장"
     "競馬場")
    ("경망"
     "敬望")
    ("경매"
     "競賣")
    ("경매장"
     "競賣場")
    ("경매제"
     "競賣制")
    ("경멸"
     "輕蔑")
    ("경멸적"
     "輕蔑的")
    ("경무과장"
     "警務課長")
    ("경물"
     "敬物")
    ("경미"
     "輕微")
    ("경박"
     "輕薄")
    ("경박단소"
     "輕薄短少")
    ("경배"
     "敬拜")
    ("경변"
     "硬變")
    ("경보"
     "警報")
    ("경보기"
     "警報器")
    ("경보음"
     "警報音")
    ("경보장치"
     "警報裝置")
    ("경복궁"
     "景福宮")
    ("경비"
     "經費"
     "警備")
    ("경비단"
     "警備團")
    ("경비단장"
     "警備團長")
    ("경비대"
     "警備隊")
    ("경비망"
     "警備網")
    ("경비병"
     "警備兵")
    ("경비실"
     "警備室")
    ("경비원"
     "警備員")
    ("경비행기"
     "輕飛行機")
    ("경사"
     "傾斜"
     "慶事"
     "經絲"
     "警査")
    ("경사로"
     "傾斜路")
    ("경상"
     "經常"
     "輕傷")
    ("경상계"
     "慶尙系")
    ("경상도"
     "慶尙道")
    ("경상비"
     "經常費")
    ("경상자"
     "輕傷者")
    ("경상차"
     "硬床車")
    ("경색"
     "梗塞")
    ("경선"
     "競選")
    ("경선론자"
     "競選論者")
    ("경선자"
     "競選者")
    ("경세제민"
     "經世濟民")
    ("경세치용"
     "經世致用")
    ("경솔"
     "輕率")
    ("경수"
     "輕水")
    ("경수로"
     "輕水爐")
    ("경수로형"
     "輕水爐型")
    ("경술국치"
     "庚戌國恥")
    ("경승"
     "景勝")
    ("경승지지"
     "景勝之地")
    ("경시"
     "競試"
     "輕視")
    ("경신"
     "更新")
    ("경악"
     "驚愕")
    ("경애"
     "敬愛")
    ("경양식"
     "輕洋食")
    ("경어"
     "敬語")
    ("경어법"
     "敬語法")
    ("경연"
     "競演")
    ("경연장"
     "競演場")
    ("경영"
     "經營")
    ("경영권"
     "經營權")
    ("경영난"
     "經營難")
    ("경영대"
     "經營大")
    ("경영론"
     "經營論")
    ("경영인"
     "經營人")
    ("경영자"
     "經營者")
    ("경영주"
     "經營主")
    ("경영진"
     "經營陣")
    ("경영체"
     "經營體")
    ("경영학"
     "經營學")
    ("경영학과"
     "經營學科")
    ("경외"
     "敬畏")
    ("경외감"
     "敬畏感")
    ("경용"
     "經用")
    ("경우"
     "境遇")
    ("경원"
     "敬遠")
    ("경위"
     "京位"
     "經緯"
     "警衛")
    ("경위서"
     "經緯書")
    ("경유"
     "經由"
     "輕油")
    ("경유지"
     "經由地")
    ("경음악"
     "輕音樂")
    ("경의"
     "敬意")
    ("경의비마"
     "輕衣肥馬")
    ("경이"
     "驚異")
    ("경이감"
     "驚異感")
    ("경이원지"
     "敬而遠之")
    ("경이적"
     "驚異的")
    ("경자유전"
     "耕者有田")
    ("경작"
     "耕作")
    ("경작권"
     "耕作權")
    ("경작자"
     "耕作者")
    ("경작지"
     "耕作地")
    ("경장"
     "警長")
    ("경쟁"
     "競爭")
    ("경쟁국"
     "競爭國")
    ("경쟁기"
     "競爭期")
    ("경쟁력"
     "競爭力")
    ("경쟁률"
     "競爭率")
    ("경쟁사"
     "競爭社")
    ("경쟁심"
     "競爭心")
    ("경쟁의식"
     "競爭意識")
    ("경쟁자"
     "競爭者")
    ("경쟁적"
     "競爭的")
    ("경적"
     "警笛")
    ("경전"
     "經典")
    ("경전철"
     "輕電鐵")
    ("경전투"
     "輕戰鬪")
    ("경전하사"
     "鯨戰蝦死")
    ("경정"
     "更正")
    ("경제"
     "京第"
     "經濟")
    ("경제계"
     "經濟界")
    ("경제관"
     "經濟觀")
    ("경제관념"
     "經濟觀念")
    ("경제국"
     "經濟國")
    ("경제국장"
     "經濟局長")
    ("경제권"
     "經濟圈"
     "經濟權")
    ("경제난"
     "經濟難")
    ("경제력"
     "經濟力")
    ("경제론"
     "經濟論")
    ("경제사"
     "經濟史")
    ("경제사가"
     "經濟史家")
    ("경제사적"
     "經濟史的")
    ("경제사학"
     "經濟史學")
    ("경제사학계"
     "經濟史學界")
    ("경제사학자"
     "經濟史學者")
    ("경제생활"
     "經濟生活")
    ("경제성"
     "經濟性")
    ("경제인"
     "經濟人")
    ("경제적"
     "經濟的")
    ("경제주의"
     "經濟主義")
    ("경제특구"
     "經濟特區")
    ("경제학"
     "經濟學")
    ("경제학계"
     "經濟學界")
    ("경제학과"
     "經濟學科")
    ("경제학부"
     "經濟學部")
    ("경제학자"
     "經濟學者")
    ("경제학적"
     "經濟學的")
    ("경조부박"
     "輕조浮薄")
    ("경조사"
     "慶弔事")
    ("경조사비"
     "慶弔事費")
    ("경종"
     "警鐘")
    ("경좌차"
     "硬座車")
    ("경주"
     "傾注"
     "慶州"
     "競走")
    ("경주장"
     "競走場")
    ("경중"
     "輕重")
    ("경중미인"
     "鏡中美人")
    ("경지"
     "境地"
     "耕地")
    ("경지율"
     "耕地率")
    ("경직"
     "硬直")
    ("경직성"
     "硬直性")
    ("경진"
     "競進")
    ("경질"
     "更迭")
    ("경차"
     "輕車")
    ("경찰"
     "警察")
    ("경찰관"
     "警察官")
    ("경찰력"
     "警察力")
    ("경찰봉"
     "警察棒")
    ("경찰서"
     "警察署")
    ("경찰서장"
     "警察署長")
    ("경찰차"
     "警察車")
    ("경찰청"
     "警察廳")
    ("경찰청장"
     "警察廳長")
    ("경창"
     "競唱")
    ("경책"
     "警策")
    ("경천동지"
     "驚天動地")
    ("경천애인"
     "敬天愛人")
    ("경천위지"
     "經天緯地")
    ("경청"
     "傾聽")
    ("경추"
     "頸椎")
    ("경축"
     "慶祝")
    ("경치"
     "景致")
    ("경칩"
     "驚蟄")
    ("경쾌"
     "輕快")
    ("경탄"
     "敬歎"
     "驚歎")
    ("경품"
     "景品")
    ("경품부"
     "景品付")
    ("경합"
     "競合")
    ("경합자"
     "競合者")
    ("경향"
     "京鄕"
     "傾向")
    ("경향극"
     "傾向劇")
    ("경험"
     "經驗")
    ("경험담"
     "經驗談")
    ("경험률"
     "經驗率")
    ("경험자"
     "經驗者")
    ("경험적"
     "經驗的")
    ("경험주의적"
     "經驗主義的")
    ("경험칙"
     "經驗則")
    ("경혈"
     "經穴")
    ("경협"
     "經協")
    ("경호"
     "警護")
    ("경호관"
     "警護官")
    ("경호실"
     "警護室")
    ("경호실장"
     "警護室長")
    ("경호원"
     "警護員")
    ("경호처장"
     "警護處長")
    ("경화"
     "硬化"
     "硬貨")
    ("경화증"
     "硬化症")
    ("경황"
     "景況"
     "驚惶")
    ("계"
     ("係" . "걸릴 계")
     ("啓" . "열 계")
     ("堺" . "界와 同字")
     ("契" . "맺을 계")
     ("季" . "끝 계")
     ("屆" . "이를 계")
     ("悸" . "두근거를 계")
     ("戒" . "경계할 계")
     ("桂" . "계수나무 계")
     ("械" . "형틀 계")
     ("棨" . "창 계")
     ("溪" . "시내 계")
     ("界" . "지경 계")
     ("癸" . "열째 천간 계")
     ("磎" . "谿와 同字")
     ("稽" . "머무를 계")
     ("系" . "이을 계")
     ("繫" . "맬 계, 맺을 계")
     ("繼" . "이을 계")
     ("計" . "꾀 계")
     ("誡" . "경계할 계")
     ("谿" . "시내 계")
     "蹊"
     ("階" . "섬돌 계")
     ("鷄" . "닭 계")
     ("堦" . "섬돌 계")
     ("烓" . "화덕 계")
     ("瘈" . "미칠 계")
     ("禊" . "계제 계")
     "稧"
     ("筓" . "비녀 계")
     ("綮" . "발 고운 비단 계")
     ("縘" . "繫와 同字")
     ("罽" . "물고기 그물 계")
     ("葪" . "베일 계, 삽주 계")
     ("薊" . "삽주 계")
     ("雞" . "닭 계")
     ("髻" . "상투 계"))
    ("계간"
     "季刊")
    ("계고"
     "戒告")
    ("계고장"
     "戒告狀")
    ("계곡"
     "溪谷")
    ("계구우후"
     "鷄口牛後")
    ("계급"
     "階級")
    ("계급성"
     "階級性")
    ("계급장"
     "階級章")
    ("계급적"
     "階級的")
    ("계급투쟁"
     "階級鬪爭")
    ("계급화"
     "階級化")
    ("계기"
     "契機"
     "繼起"
     "計器")
    ("계기성"
     "契機性")
    ("계기적"
     "契機的")
    ("계단"
     "階段")
    ("계단식"
     "階段式")
    ("계도"
     "啓導")
    ("계도적"
     "啓導的")
    ("계란"
     "鷄卵")
    ("계란유골"
     "鷄卵有骨")
    ("계란형"
     "鷄卵形")
    ("계략"
     "計略")
    ("계량"
     "計量")
    ("계량기"
     "計量器")
    ("계류"
     "溪流"
     "繫留")
    ("계류형"
     "溪流型")
    ("계륵"
     "鷄肋")
    ("계면조"
     "界面調")
    ("계명"
     "階名")
    ("계명구도"
     "鷄鳴狗盜")
    ("계모"
     "繼母")
    ("계몽"
     "啓蒙")
    ("계몽사상"
     "啓蒙思想")
    ("계몽사상가"
     "啓蒙思想家")
    ("계몽주의"
     "啓蒙主義")
    ("계몽주의자"
     "啓蒙主義者")
    ("계몽주의적"
     "啓蒙主義的")
    ("계무소출"
     "計無所出")
    ("계박"
     "繫縛")
    ("계발"
     "啓發")
    ("계보"
     "系譜")
    ("계산"
     "計算")
    ("계산기"
     "計算器")
    ("계산대"
     "計算臺")
    ("계산서"
     "計算書")
    ("계산소"
     "計算所")
    ("계산소장"
     "計算所長")
    ("계산적"
     "計算的")
    ("계산표"
     "計算表")
    ("계상"
     "計上"
     "階上")
    ("계서적"
     "階序的")
    ("계서화"
     "階序化")
    ("계속"
     "繫屬"
     "繼續")
    ("계속적"
     "繼續的")
    ("계수"
     "係數")
    ("계수기"
     "計數器")
    ("계수배"
     "階手拜")
    ("계승"
     "繼承")
    ("계승권"
     "繼承權")
    ("계승자"
     "繼承者")
    ("계승적"
     "繼承的")
    ("계시"
     "啓示")
    ("계약"
     "契約")
    ("계약고"
     "契約庫")
    ("계약금"
     "契約金")
    ("계약서"
     "契約書")
    ("계약자"
     "契約者")
    ("계약제"
     "契約制")
    ("계엄"
     "戒嚴")
    ("계엄군"
     "戒嚴軍")
    ("계엄령"
     "戒嚴令")
    ("계열"
     "系列")
    ("계열사"
     "系列社")
    ("계열형"
     "系列型")
    ("계열화"
     "系列化")
    ("계원"
     "契員")
    ("계위"
     "階位")
    ("계유년"
     "癸酉年")
    ("계율"
     "戒律")
    ("계장"
     "係長"
     "契長")
    ("계절"
     "季節")
    ("계절병"
     "季節病")
    ("계절성"
     "季節性")
    ("계절적"
     "季節的")
    ("계절풍"
     "季節風")
    ("계정"
     "計定")
    ("계제"
     "階梯")
    ("계좌"
     "計座")
    ("계좌설"
     "計座說")
    ("계주"
     "繼走")
    ("계주생면"
     "契酒生面")
    ("계체량"
     "計體量")
    ("계축"
     "癸丑")
    ("계측"
     "計測")
    ("계층"
     "階層")
    ("계층론"
     "階層論")
    ("계층적"
     "階層的")
    ("계층화"
     "階層化")
    ("계통"
     "系統")
    ("계파"
     "系派")
    ("계파적"
     "系派的")
    ("계포일락"
     "季布一諾")
    ("계피"
     "桂皮")
    ("계핏"
     "桂皮")
    ("계회"
     "契會")
    ("계획"
     "計劃")
    ("계획과"
     "計劃課")
    ("계획서"
     "計劃書")
    ("계획성"
     "計劃性")
    ("계획안"
     "計劃案")
    ("계획자"
     "計劃者")
    ("계획적"
     "計劃的")
    ("계획지"
     "計劃紙")
    ("계획표"
     "計劃表")
    ("계획학"
     "計劃學")
    ("고"
     ("古" . "옛 고")
     ("叩" . "두드릴 고")
     ("告" . "알릴 고")
     ("呱" . "울 고")
     ("固" . "굳을 고")
     ("姑" . "시어미 고")
     ("孤" . "외로울 고")
     ("尻" . "꽁무니 고")
     ("庫" . "곳집 고")
     ("拷" . "가질 고")
     ("攷" . "考의 古字")
     ("故" . "옛 고")
     ("敲" . "두드릴 고")
     ("暠" . "흴 고")
     ("枯" . "마를 고")
     ("槁" . "槀와 同字")
     ("沽" . "팔 고")
     ("痼" . "고질 고")
     ("皐" . "부르는 소리 고")
     ("睾" . "못 고")
     ("稿" . "볏집 고")
     ("羔" . "새끼양 고")
     ("考" . "상고할 고")
     ("股" . "넓적다리 고")
     ("膏" . "살찔 고")
     ("苦" . "쓸 고")
     ("苽" . "줄 고")
     ("菰" . "향초 고")
     ("藁" . "마른 나무 고")
     ("蠱" . "독 고")
     ("袴" . "바지 고")
     ("誥" . "고할 고")
     ("辜" . "허물 고")
     ("錮" . "땜질할 고")
     ("雇" . "새이름 고")
     ("顧" . "돌아볼 고")
     ("高" . "높을 고")
     ("鼓" . "북 고")
     ("賈" . "장사 고")
     ("估" . "값 고")
     ("凅" . "얼어붙을 고")
     ("刳" . "가를 고")
     ("杲" . "밝을 고")
     ("栲" . "북나무 고")
     ("槀" . "마를 고")
     ("槹" . "두레박 고")
     ("櫜" . "활집 고")
     ("牯" . "암소 고")
     "犒"
     ("皋" . "못 고")
     ("盬" . "염지 고")
     ("瞽" . "소경 고")
     ("稁" . "稿와 同字")
     ("箍" . "테 고")
     ("篙" . "상앗대 고")
     ("糕" . "떡 고")
     ("罟" . "그물 고")
     ("羖" . "검은 암양 고")
     ("翺" . "날 고")
     ("胯" . "사타구니 고")
     ("觚" . "술잔 고")
     ("詁" . "주석 고")
     ("郜" . "나라이름 고")
     ("酤" . "계명주 고")
     ("鈷" . "다리미 고")
     ("靠" . "기댈 고")
     ("鴣" . "자고 고")
     ("鷱" . "새이름 고"))
    ("고가"
     "古家"
     "高價")
    ("고가격"
     "高價格")
    ("고가구"
     "古家具")
    ("고가품"
     "高價品")
    ("고가화"
     "高價化")
    ("고갈"
     "枯渴")
    ("고감도"
     "高感度")
    ("고강도"
     "高强度")
    ("고객"
     "顧客")
    ("고객층"
     "顧客層")
    ("고견"
     "高見")
    ("고결"
     "高潔")
    ("고경"
     "苦境")
    ("고고"
     "孤高"
     "考古")
    ("고고지성"
     "呱呱之聲")
    ("고고학"
     "考古學")
    ("고고학계"
     "考古學界")
    ("고고학자"
     "考古學者")
    ("고고학적"
     "考古學的")
    ("고공"
     "高空")
    ("고공비행"
     "高空飛行")
    ("고과"
     "考課")
    ("고관"
     "高官")
    ("고관대작"
     "高官大爵")
    ("고굉지신"
     "股肱之臣")
    ("고교"
     "高校")
    ("고교생"
     "高校生")
    ("고구려"
     "高句麗")
    ("고국"
     "故國")
    ("고군분투"
     "孤軍奮鬪")
    ("고궁"
     "古宮")
    ("고귀"
     "高貴")
    ("고금"
     "古今")
    ("고금독보"
     "古今獨步")
    ("고금동서"
     "古今東西")
    ("고금동연"
     "古今同然")
    ("고금리"
     "高金利")
    ("고급"
     "高級")
    ("고급문화"
     "高級文化")
    ("고급반"
     "高級班")
    ("고급적"
     "高級的")
    ("고급품"
     "高級品")
    ("고급화"
     "高級化")
    ("고기능"
     "高技能")
    ("고기압"
     "高氣壓")
    ("고기압권"
     "高氣壓圈")
    ("고기압부"
     "高氣壓部")
    ("고길상사"
     "庫吉祥紗")
    ("고난"
     "苦難")
    ("고난도"
     "高難度")
    ("고뇌"
     "苦惱")
    ("고단백"
     "高蛋白")
    ("고단백질"
     "高蛋白質")
    ("고단수"
     "高段數")
    ("고담준론"
     "高談峻論")
    ("고답적"
     "高踏的")
    ("고대"
     "古代"
     "苦待")
    ("고대광실"
     "高臺廣室")
    ("고대사"
     "古代史")
    ("고대사학계"
     "古代史學界")
    ("고대인"
     "古代人")
    ("고대적"
     "古代的")
    ("고도"
     "古都"
     "孤島"
     "高度")
    ("고도화"
     "高度化")
    ("고독"
     "孤獨")
    ("고독감"
     "孤獨感")
    ("고동"
     "鼓動")
    ("고동색"
     "古銅色")
    ("고두배"
     "叩頭拜")
    ("고득점자"
     "高得點者")
    ("고등"
     "高等")
    ("고등계"
     "高等係")
    ("고등부"
     "高等部")
    ("고등중학교"
     "高等中學校")
    ("고등학교"
     "高等學校")
    ("고등학생"
     "高等學生")
    ("고락"
     "苦樂")
    ("고래희"
     "古來稀")
    ("고랭지"
     "高冷地")
    ("고량"
     "高粱")
    ("고량진미"
     "膏粱珍味")
    ("고려"
     "考慮"
     "顧慮"
     "高麗")
    ("고려공사삼일"
     "高麗公事三日")
    ("고려자기"
     "高麗瓷器")
    ("고려장"
     "高麗葬")
    ("고려조"
     "高麗朝")
    ("고려청자"
     "高麗靑瓷")
    ("고령"
     "高齡")
    ("고령자"
     "高齡者")
    ("고령지"
     "高嶺地")
    ("고령층"
     "高齡層")
    ("고령토"
     "高嶺土")
    ("고령화"
     "高齡化")
    ("고료"
     "稿料")
    ("고루"
     "固陋")
    ("고립"
     "孤立")
    ("고립감"
     "孤立感")
    ("고립무원"
     "孤立無援")
    ("고립성"
     "孤立性")
    ("고립주의"
     "孤立主義")
    ("고립화"
     "孤立化")
    ("고마이간"
     "叩馬而諫")
    ("고막"
     "鼓膜")
    ("고매"
     "高邁")
    ("고명"
     "高名")
    ("고모"
     "姑母")
    ("고모부"
     "姑母夫")
    ("고목"
     "古木"
     "枯木")
    ("고목생화"
     "枯木生花")
    ("고무"
     "鼓舞")
    ("고무적"
     "鼓舞的")
    ("고문"
     "拷問"
     "顧問")
    ("고문관"
     "顧問官")
    ("고문자"
     "拷問者")
    ("고물"
     "古物")
    ("고물가"
     "高物價")
    ("고물류"
     "高物流")
    ("고물상"
     "古物商")
    ("고민"
     "苦悶")
    ("고민녀"
     "苦悶女")
    ("고밀도"
     "高密度")
    ("고발"
     "告發")
    ("고발인"
     "告發人")
    ("고발자"
     "告發者")
    ("고발장"
     "告發狀")
    ("고배"
     "高杯")
    ("고백"
     "告白")
    ("고백적"
     "告白的")
    ("고법"
     "高法")
    ("고변"
     "告變")
    ("고별"
     "告別")
    ("고별사"
     "告別辭")
    ("고보"
     "高普")
    ("고복격양"
     "鼓腹擊壤")
    ("고봉"
     "高捧")
    ("고봉준령"
     "高峰峻嶺")
    ("고부"
     "姑婦")
    ("고부가"
     "高附加")
    ("고부간"
     "姑婦間")
    ("고분"
     "古墳")
    ("고분군"
     "古墳郡")
    ("고비용"
     "高費用")
    ("고사"
     "古史"
     "告祀"
     "固辭"
     "姑捨"
     "故事"
     "枯死"
     "考査")
    ("고사실"
     "考査室")
    ("고사장"
     "考査場")
    ("고사포"
     "高射砲")
    ("고사포병"
     "高射砲兵")
    ("고산"
     "高山")
    ("고산대"
     "高山帶")
    ("고상"
     "高尙")
    ("고색창연"
     "古色蒼然")
    ("고생"
     "苦生")
    ("고생고생"
     "苦生苦生")
    ("고생대"
     "古生代")
    ("고생물학자"
     "古生物學者")
    ("고생물학적"
     "古生物學的")
    ("고서"
     "古書")
    ("고성"
     "固性")
    ("고성낙일"
     "孤城落日")
    ("고성능"
     "高性能")
    ("고성장"
     "高成長")
    ("고성제"
     "苦聖諦")
    ("고소"
     "告訴"
     "苦笑")
    ("고소권자"
     "告訴權者")
    ("고소득"
     "高所得")
    ("고소원"
     "固所願")
    ("고소인"
     "告訴人")
    ("고소자"
     "告訴者")
    ("고소장"
     "告訴狀")
    ("고속"
     "古俗"
     "高速")
    ("고속도"
     "高速度"
     "高速道")
    ("고속도로"
     "高速道路")
    ("고속화"
     "高速化")
    ("고수"
     "固守"
     "苦水"
     "高手"
     "鼓手")
    ("고수부지"
     "高水敷地")
    ("고수익"
     "高收益")
    ("고순도"
     "高純度")
    ("고승"
     "高僧")
    ("고시"
     "告示"
     "考試"
     "高試")
    ("고시생"
     "考試生")
    ("고시원"
     "考試院")
    ("고시율"
     "考試率")
    ("고식적"
     "姑息的")
    ("고식지계"
     "姑息之計")
    ("고심"
     "苦心")
    ("고심초사"
     "苦心焦思")
    ("고아"
     "孤兒")
    ("고아원"
     "孤兒院")
    ("고아적"
     "孤兒的")
    ("고안"
     "考案")
    ("고압"
     "高壓")
    ("고압선"
     "高壓線")
    ("고압적"
     "高壓的")
    ("고액"
     "高額")
    ("고양"
     "高揚")
    ("고양감"
     "高揚感")
    ("고양화"
     "高揚化")
    ("고어"
     "古語")
    ("고역"
     "苦役")
    ("고열"
     "高熱")
    ("고엽제"
     "枯葉劑")
    ("고영양식"
     "高營養食")
    ("고온"
     "高溫")
    ("고왕"
     "古往")
    ("고용"
     "雇傭"
     "雇用")
    ("고용인"
     "雇傭人")
    ("고용자"
     "雇用者")
    ("고용주"
     "雇用主")
    ("고원"
     "高原")
    ("고위"
     "高位")
    ("고위급"
     "高位級")
    ("고위도"
     "高緯度")
    ("고위직"
     "高位職")
    ("고위층"
     "高位層")
    ("고위험"
     "高危險")
    ("고유"
     "固有")
    ("고유성"
     "固有性")
    ("고유어"
     "固有語")
    ("고유종"
     "固有種")
    ("고육지계"
     "苦肉之計")
    ("고육지책"
     "苦肉之策")
    ("고육책"
     "苦肉策")
    ("고율"
     "高率")
    ("고음"
     "高音")
    ("고음계"
     "高音階")
    ("고읍"
     "古邑")
    ("고의"
     "故意")
    ("고의적"
     "故意的")
    ("고인"
     "古人"
     "故人")
    ("고인쇄"
     "古印刷")
    ("고임"
     "高賃")
    ("고임국"
     "高賃國")
    ("고임금"
     "高賃金")
    ("고입"
     "高入")
    ("고자"
     "告者")
    ("고자세"
     "高姿勢")
    ("고자질"
     "告者­")
    ("고장"
     "故障")
    ("고장난명"
     "孤掌難鳴")
    ("고저"
     "高低")
    ("고적"
     "古跡"
     "孤寂")
    ("고적감"
     "孤寂感")
    ("고적지"
     "古跡地")
    ("고전"
     "古典"
     "苦戰")
    ("고전극"
     "古典劇")
    ("고전기"
     "古典期")
    ("고전물"
     "古典物")
    ("고전미"
     "古典美")
    ("고전적"
     "古典的")
    ("고전주의"
     "古典主義")
    ("고전주의자"
     "古典主義者")
    ("고전주의적"
     "古典主義的")
    ("고전학파"
     "古典學派")
    ("고정"
     "固定")
    ("고정간첩"
     "固定間諜")
    ("고정관념"
     "固定觀念")
    ("고정급화"
     "固定給化")
    ("고정밀도"
     "高精密度")
    ("고정불변"
     "固定不變")
    ("고정선"
     "固定線")
    ("고정적"
     "固定的")
    ("고정화"
     "固定化")
    ("고조"
     "高祖"
     "高調")
    ("고졸"
     "高卒")
    ("고종"
     "姑從")
    ("고종명"
     "考終命")
    ("고준위"
     "高準位")
    ("고증"
     "考證")
    ("고증학적"
     "考證學的")
    ("고지"
     "告知"
     "故地"
     "高地")
    ("고지가"
     "高地價")
    ("고지대"
     "高地帶")
    ("고지방질"
     "高脂肪質")
    ("고지서"
     "告知書")
    ("고지혈증"
     "高脂血症")
    ("고진감래"
     "苦盡甘來")
    ("고질"
     "痼疾")
    ("고질적"
     "痼疾的")
    ("고질화"
     "痼疾化")
    ("고집"
     "固執")
    ("고집멸도"
     "苦集滅道")
    ("고집불통"
     "固執不通")
    ("고집형"
     "固執型")
    ("고차원"
     "高次元")
    ("고차원적"
     "高次元的")
    ("고차적"
     "高次的")
    ("고착"
     "固着")
    ("고찰"
     "考察")
    ("고참"
     "古參")
    ("고창"
     "高唱")
    ("고창기"
     "高唱期")
    ("고철"
     "古鐵")
    ("고체"
     "固體")
    ("고초"
     "苦楚")
    ("고초일"
     "枯焦日")
    ("고촉"
     "高燭")
    ("고촉등"
     "高燭燈")
    ("고출력"
     "高出力")
    ("고충"
     "苦衷")
    ("고취"
     "鼓吹")
    ("고층"
     "高層")
    ("고침단금"
     "孤枕單衾")
    ("고침이와"
     "高枕而臥")
    ("고탄수화물"
     "高炭水化物")
    ("고통"
     "苦痛")
    ("고투"
     "苦鬪")
    ("고품위"
     "高品位")
    ("고품질"
     "高品質")
    ("고풍"
     "古風")
    ("고하"
     "高下")
    ("고하재심"
     "高下在心")
    ("고학"
     "苦學")
    ("고학년"
     "高學年")
    ("고학력"
     "高學歷")
    ("고학력자"
     "高學歷者")
    ("고학생"
     "苦學生")
    ("고함"
     "高喊")
    ("고해"
     "告解"
     "苦海")
    ("고해상도"
     "高解像度")
    ("고행"
     "苦行")
    ("고향"
     "故鄕")
    ("고헐무상"
     "高歇無常")
    ("고혈단신"
     "孤孑單身")
    ("고혈압"
     "高血壓")
    ("고형"
     "固形")
    ("고혹적"
     "蠱惑的")
    ("고혼"
     "孤魂")
    ("고화질"
     "高畵質")
    ("고환"
     "睾丸")
    ("고황지질"
     "膏황之疾")
    ("고효율"
     "高效率")
    ("고효율화"
     "高效率化")
    ("고희"
     "古稀")
    ("곡"
     ("哭" . "울 곡")
     ("斛" . "휘 곡")
     ("曲" . "굽을 곡")
     ("梏" . "쇠고랑 곡")
     ("穀" . "곡식 곡")
     ("谷" . "골짜기 곡")
     ("鵠" . "고니 곡")
     "嚳"
     ("槲" . "떡갈나무 곡")
     ("縠" . "주름 비단 곡")
     ("觳" . "뿔잔 곡")
     ("轂" . "바퀴 곡"))
    ("곡굉지락"
     "曲肱之樂")
    ("곡령"
     "穀靈")
    ("곡류"
     "曲流"
     "穀類")
    ("곡류천"
     "曲流川")
    ("곡률"
     "曲率")
    ("곡목"
     "曲目")
    ("곡물"
     "穀物")
    ("곡복사신"
     "穀腹絲身")
    ("곡선"
     "曲線")
    ("곡성"
     "哭聲")
    ("곡수유상"
     "曲水流觴")
    ("곡식"
     "穀食")
    ("곡예"
     "曲藝")
    ("곡우"
     "穀雨")
    ("곡절"
     "曲折"
     "曲節")
    ("곡조"
     "曲調")
    ("곡창"
     "穀倉")
    ("곡학아세"
     "曲學阿世")
    ("곡해"
     "曲解")
    ("곤"
     ("困" . "괴로울 곤")
     ("坤" . "땅 곤")
     ("崑" . "산이름 곤")
     ("昆" . "형 곤")
     ("梱" . "문지방 곤")
     ("棍" . "몽둥이 곤")
     ("滾" . "흐를 곤")
     ("琨" . "옥돌 곤")
     ("袞" . "곤룡포 곤")
     ("鯤" . "준마 이름 곤")
     ("堃" . "따 곤")
     ("崐" . "곤륜산 곤")
     ("悃" . "정성 곤")
     ("捆" . "두드릴 곤")
     ("緄" . "띠 곤")
     ("衮" . "袞과 同字")
     ("裍" . "걷어 올릴 곤")
     ("褌" . "잠방이 곤")
     ("錕" . "붉은 쇠 곤")
     ("閫" . "문지방 곤")
     ("髡" . "머리 깍을 곤")
     ("鵾" . "댓닭 곤")
     ("鶤" . "댓닭 곤")
     ("齫" . "이 빠질 곤"))
    ("곤경"
     "困境")
    ("곤고"
     "困苦")
    ("곤곤"
     "滾滾")
    ("곤궁"
     "困窮")
    ("곤란"
     "困難")
    ("곤란성"
     "困難性")
    ("곤룡포"
     "袞龍袍")
    ("곤봉"
     "棍棒")
    ("곤비"
     "困憊")
    ("곤욕"
     "困辱")
    ("곤장"
     "棍杖")
    ("곤충"
     "昆蟲")
    ("곤충학자"
     "昆蟲學者")
    ("곤핍"
     "困乏")
    ("곤혹"
     "困惑")
    ("골"
     ("骨" . "뼈 골")
     ("滑" . "어지러울 골")
     ("搰" . "팔 골")
     ("榾" . "등걸 골")
     ("鶻" . "송골매 골"))
    ("골격"
     "骨格")
    ("골격계"
     "骨格系")
    ("골다공증"
     "骨多孔症")
    ("골동"
     "骨董")
    ("골동품"
     "骨董品")
    ("골동품계"
     "骨董品界")
    ("골동품점"
     "骨董品店")
    ("골막"
     "骨膜")
    ("골몰"
     "汨沒")
    ("골반"
     "骨盤")
    ("골수"
     "骨髓")
    ("골육상잔"
     "骨肉相殘")
    ("골자"
     "骨子")
    ("골재"
     "骨材")
    ("골절"
     "骨折")
    ("골절상"
     "骨折傷")
    ("골조"
     "骨組")
    ("골품"
     "骨品")
    ("골품제"
     "骨品制")
    ("골품제적"
     "骨品制的")
    ("곱상"
     "­相")
    ("곳간"
     "庫間")
    ("공"
     ("供" . "이바지할 공")
     ("公" . "공변될 공")
     ("共" . "함께 공")
     ("功" . "공 공")
     ("孔" . "구멍 공")
     ("工" . "장인 공")
     ("恐" . "두려울 공")
     ("恭" . "공손할 공")
     ("拱" . "두 손 맞잡을 공")
     ("控" . "당길 공")
     ("攻" . "칠 공")
     ("珙" . "큰 옥 공")
     ("空" . "빌 공")
     ("蚣" . "지네 공")
     ("貢" . "바칠 공")
     ("鞏" . "묶을 공")
     ("倥" . "어리석을 공")
     ("崆" . "산이름 공")
     ("悾" . "정성 공")
     ("栱" . "두공 공")
     ("槓" . "지렛대 공")
     ("箜" . "공후 공")
     ("蛩" . "메뚜기 공")
     ("蛬" . "귀뚜라미 공")
     ("贛" . "줄 공")
     ("跫" . "발자국 소리 공")
     ("釭" . "굴대 공")
     ("龔" . "공손할 공"))
    ("공가"
     "公家"
     "空家")
    ("공간"
     "空間")
    ("공간감"
     "空間感")
    ("공간대"
     "空間帶")
    ("공간적"
     "空間的")
    ("공갈"
     "恐喝")
    ("공갈단"
     "恐喝團")
    ("공감"
     "共感")
    ("공감대"
     "共感帶")
    ("공강"
     "空講")
    ("공개"
     "公開")
    ("공개강좌"
     "公開講座")
    ("공개경쟁"
     "公開競爭")
    ("공개념"
     "公槪念")
    ("공개도"
     "公開度")
    ("공개론자"
     "公開論者")
    ("공개리"
     "公開裡")
    ("공개적"
     "公開的")
    ("공개화"
     "公開化")
    ("공격"
     "攻擊")
    ("공격력"
     "攻擊力")
    ("공격성"
     "攻擊性")
    ("공격수"
     "攻擊手")
    ("공격자"
     "攻擊者")
    ("공격적"
     "攻擊的")
    ("공격형"
     "攻擊型")
    ("공경"
     "恭敬")
    ("공경대부"
     "公卿大夫")
    ("공고"
     "公告"
     "工高"
     "鞏固")
    ("공고일"
     "公告日")
    ("공공"
     "公共")
    ("공공건물"
     "公共建物")
    ("공공복리"
     "公共福利")
    ("공공성"
     "公共性")
    ("공공시설"
     "公共施設")
    ("공공연"
     "公公然")
    ("공공요금"
     "公共料金")
    ("공공용"
     "公共用")
    ("공공용지"
     "公共用地")
    ("공공장소"
     "公共場所")
    ("공공적"
     "公共的")
    ("공공질서"
     "公共秩序")
    ("공과"
     "功課"
     "功過"
     "工科")
    ("공과금"
     "公課金")
    ("공관"
     "公館")
    ("공관원"
     "公館員")
    ("공교"
     "工巧")
    ("공교육"
     "公敎育")
    ("공교육비"
     "公敎育費")
    ("공구"
     "工具")
    ("공군"
     "空軍")
    ("공권력"
     "公權力")
    ("공금"
     "公金")
    ("공금리"
     "公金利")
    ("공급"
     "供給")
    ("공급관"
     "供給管")
    ("공급기"
     "供給期")
    ("공급난"
     "供給難")
    ("공급량"
     "供給量")
    ("공급분"
     "供給分")
    ("공급원"
     "供給源")
    ("공급자"
     "供給者")
    ("공급책"
     "供給責")
    ("공기"
     "空器"
     "空氣")
    ("공기업"
     "公企業")
    ("공기업적"
     "公企業的")
    ("공기업체"
     "公企業體")
    ("공기총"
     "空氣銃")
    ("공납"
     "貢納")
    ("공납금"
     "公納金")
    ("공납적"
     "公納的")
    ("공납제"
     "公納制")
    ("공납제적"
     "公納制的")
    ("공단"
     "公團"
     "工團"
     "貢緞")
    ("공대"
     "工大"
     "恭待")
    ("공대공"
     "空對空")
    ("공덕"
     "功德")
    ("공동"
     "共同"
     "空洞")
    ("공동묘지"
     "共同墓地")
    ("공동생활"
     "共同生活")
    ("공동적"
     "共同的")
    ("공동체"
     "共同體")
    ("공동체론"
     "共同體論")
    ("공동체원"
     "共同體員")
    ("공동체적"
     "共同體的")
    ("공동체화"
     "共同體化")
    ("공동화"
     "空洞化")
    ("공람"
     "供覽")
    ("공략"
     "攻掠"
     "攻略")
    ("공력"
     "功力")
    ("공로"
     "功勞")
    ("공론"
     "公論"
     "空論")
    ("공론화"
     "公論化")
    ("공룡"
     "恐龍")
    ("공리"
     "公理"
     "共利"
     "功利")
    ("공리공론"
     "空理空論")
    ("공리적"
     "功利的")
    ("공립"
     "公立")
    ("공립학교"
     "公立學校")
    ("공명"
     "公明"
     "共鳴")
    ("공명선거"
     "公明選擧")
    ("공명정대"
     "公明正大")
    ("공모"
     "公募"
     "共謀")
    ("공모전"
     "公募展")
    ("공모주"
     "公募株")
    ("공무"
     "公務")
    ("공무원"
     "公務員")
    ("공무원제"
     "公務員制")
    ("공문"
     "公文")
    ("공문서"
     "公文書")
    ("공문서식"
     "公文書式")
    ("공문화"
     "公文化")
    ("공물"
     "貢物")
    ("공민"
     "公民")
    ("공박"
     "攻駁")
    ("공방"
     "攻防")
    ("공방전"
     "攻防戰")
    ("공백"
     "空白")
    ("공백기"
     "空白期")
    ("공범"
     "共犯")
    ("공범자"
     "共犯者")
    ("공법"
     "公法"
     "工法")
    ("공법학자"
     "公法學者")
    ("공병"
     "工兵")
    ("공보"
     "公報")
    ("공보관"
     "公報官")
    ("공보실장"
     "公報室長")
    ("공복"
     "公僕"
     "公服"
     "空腹")
    ("공복감"
     "空腹感")
    ("공부"
     "工夫"
     "貢賦")
    ("공부반"
     "工夫班")
    ("공부방"
     "工夫房")
    ("공분"
     "公憤")
    ("공붓"
     "工夫")
    ("공비"
     "共匪")
    ("공사"
     "公使"
     "公社"
     "公私"
     "工事")
    ("공사립"
     "公私立")
    ("공사비"
     "工事費")
    ("공사장"
     "工事場")
    ("공사채형"
     "公社債型")
    ("공산"
     "公算"
     "共産")
    ("공산군"
     "共産軍")
    ("공산권"
     "共産圈")
    ("공산당"
     "共産黨")
    ("공산명월"
     "空山明月")
    ("공산물"
     "工産物")
    ("공산제"
     "共産制")
    ("공산주의"
     "共産主義")
    ("공산주의자"
     "共産主義者")
    ("공산품"
     "工産品")
    ("공산화"
     "共産化")
    ("공상"
     "空想")
    ("공상적"
     "空想的")
    ("공생"
     "共生")
    ("공생균"
     "共生菌")
    ("공석"
     "公席"
     "空席")
    ("공선"
     "空船")
    ("공설"
     "公設")
    ("공세"
     "攻勢"
     "貢稅")
    ("공세식"
     "攻勢式")
    ("공세형"
     "攻勢型")
    ("공세화"
     "攻勢化")
    ("공소"
     "公訴")
    ("공소장"
     "公訴狀")
    ("공손"
     "恭遜")
    ("공수"
     "拱手"
     "攻守"
     "空輸")
    ("공수단"
     "空輸團")
    ("공수래공수거"
     "空手來空手去")
    ("공수배"
     "空手拜")
    ("공수복"
     "空輸服")
    ("공수형"
     "空手形")
    ("공습"
     "空襲")
    ("공습경보"
     "空襲警報")
    ("공시"
     "公示"
     "共時")
    ("공시적"
     "共時的")
    ("공식"
     "公式"
     "共食")
    ("공식적"
     "公式的")
    ("공식형"
     "公式型")
    ("공식화"
     "公式化")
    ("공신"
     "功臣")
    ("공신력"
     "公信力")
    ("공심돈"
     "空心墩")
    ("공안"
     "公安")
    ("공안부"
     "公安部")
    ("공약"
     "公約"
     "空約")
    ("공약수"
     "公約數")
    ("공양"
     "供養")
    ("공양사"
     "貢洋紗")
    ("공언"
     "公言")
    ("공업"
     "工業")
    ("공업계"
     "工業界")
    ("공업국"
     "工業國")
    ("공업부"
     "工業部")
    ("공업용"
     "工業用")
    ("공업용수"
     "工業用水")
    ("공업적"
     "工業的")
    ("공업체"
     "工業體")
    ("공업품"
     "工業品")
    ("공업학교"
     "工業學校")
    ("공업화"
     "工業化")
    ("공여"
     "供與")
    ("공역"
     "公役"
     "空域")
    ("공연"
     "公演"
     "公然"
     "共演"
     "空然")
    ("공연단"
     "公演團")
    ("공연물"
     "公演物")
    ("공연성"
     "公演性")
    ("공연장"
     "公演場")
    ("공염불"
     "空念佛")
    ("공영"
     "公營"
     "共榮")
    ("공영제"
     "公營制")
    ("공예"
     "工藝")
    ("공예관"
     "工藝館")
    ("공예실"
     "工藝室")
    ("공예품"
     "工藝品")
    ("공용"
     "共用")
    ("공원"
     "公園"
     "工員")
    ("공원묘지"
     "公園墓地")
    ("공원수"
     "公園樹")
    ("공원화"
     "公園化")
    ("공유"
     "公有"
     "共有")
    ("공유물"
     "公有物")
    ("공유화"
     "共有化")
    ("공음전시"
     "功蔭田柴")
    ("공익"
     "公益"
     "共益")
    ("공익사업"
     "公益事業")
    ("공익성"
     "公益性")
    ("공익적"
     "公益的")
    ("공인"
     "公人"
     "公認"
     "共認")
    ("공일"
     "空日")
    ("공자"
     "公子")
    ("공작"
     "公爵"
     "孔雀"
     "工作")
    ("공작원"
     "工作員")
    ("공장"
     "工場")
    ("공장장"
     "工場長")
    ("공저"
     "共著")
    ("공적"
     "公的"
     "共的"
     "功績")
    ("공전"
     "公田"
     "公轉"
     "空前"
     "空轉")
    ("공전론"
     "公田論")
    ("공전절후"
     "空前絶後")
    ("공전제"
     "公田制")
    ("공정"
     "公定"
     "公正"
     "工程")
    ("공정성"
     "公正性")
    ("공제"
     "控除")
    ("공제당"
     "控除當")
    ("공조"
     "共助"
     "貢租")
    ("공존"
     "共存")
    ("공주"
     "公主")
    ("공주병"
     "公主病")
    ("공중"
     "公衆"
     "空中")
    ("공중누각"
     "空中樓閣")
    ("공중도덕"
     "公衆道德")
    ("공중도덕심"
     "公衆道德心")
    ("공중목욕탕"
     "公衆沐浴湯")
    ("공중변소"
     "公衆便所")
    ("공중분해"
     "空中分解")
    ("공중위생"
     "公衆衛生")
    ("공중전"
     "空中戰")
    ("공중전화"
     "公衆電話")
    ("공중파"
     "公衆波")
    ("공증인"
     "公證人")
    ("공지"
     "公知"
     "空地")
    ("공직"
     "公職")
    ("공직자"
     "公職者")
    ("공찰"
     "公刹")
    ("공참"
     "孔慘")
    ("공채"
     "公債"
     "公採")
    ("공책"
     "空冊")
    ("공처가"
     "恐妻家")
    ("공천"
     "公薦")
    ("공천설"
     "公薦說")
    ("공천자"
     "公薦者")
    ("공청"
     "公聽")
    ("공청회"
     "公聽會")
    ("공체"
     "空諦")
    ("공초"
     "供招")
    ("공출"
     "供出")
    ("공치사"
     "功致辭")
    ("공탁"
     "供託")
    ("공통"
     "共通")
    ("공통분모"
     "共通分母")
    ("공통성"
     "共通性")
    ("공통어"
     "共通語")
    ("공통적"
     "共通的")
    ("공통점"
     "共通點")
    ("공판"
     "公判")
    ("공판부"
     "公判部")
    ("공평"
     "公平")
    ("공평무사"
     "公平無私")
    ("공포"
     "恐怖"
     "空包")
    ("공포감"
     "恐怖感")
    ("공포물"
     "恐怖物")
    ("공포심"
     "恐怖心")
    ("공포적"
     "恐怖的")
    ("공포증"
     "恐怖症")
    ("공표"
     "公表"
     "空表")
    ("공표권"
     "公表權")
    ("공표죄"
     "公表罪")
    ("공학"
     "共學"
     "工學")
    ("공학과"
     "工學科")
    ("공학자"
     "工學者")
    ("공학적"
     "工學的")
    ("공한"
     "公翰")
    ("공항"
     "空港")
    ("공해"
     "公害"
     "公海")
    ("공해병"
     "公害病")
    ("공허"
     "空虛")
    ("공허감"
     "空虛感")
    ("공헌"
     "貢獻")
    ("공헌도"
     "貢獻度")
    ("공헌론"
     "貢獻論")
    ("공화국"
     "共和國")
    ("공화정"
     "共和政")
    ("공화제"
     "共和制")
    ("공황"
     "恐慌")
    ("공황증"
     "恐慌症")
    ("공회"
     "公會")
    ("공회전"
     "空回轉")
    ("공훈전"
     "功勳田")
    ("공휴일"
     "公休日")
    ("곶"
     ("串" . "땅이름 곶"))
    ("과"
     ("寡" . "적을 과")
     ("戈" . "창 과")
     ("果" . "실과 과")
     ("瓜" . "오이 과")
     ("科" . "과정 과")
     ("菓" . "과일 과")
     "蝸"
     "袴"
     ("誇" . "자랑할 과")
     ("課" . "매길 과")
     ("跨" . "타넘을 과")
     ("過" . "지날 과")
     ("鍋" . "노구솥 과")
     ("顆" . "낟알 과")
     ("侉" . "자랑할 과")
     "倮"
     ("堝" . "도가니 과")
     ("夥" . "많을 과")
     ("夸" . "자랑할 과")
     ("媧" . "사람 이름 과")
     ("撾" . "칠 과")
     ("猓" . "긴 꼬리 원숭이 과")
     ("稞" . "보리 과")
     ("窠" . "보금자리 과")
     ("胯" . "사타구니 과")
     ("蝌" . "올챙이 과")
     ("裹" . "쌀 과")
     ("踝" . "복사뼈 과")
     ("銙" . "대구 과")
     ("騍" . "암말 과"))
    ("과감"
     "果敢")
    ("과객"
     "過客")
    ("과거"
     "科擧"
     "過去")
    ("과거사"
     "過去事")
    ("과거식"
     "過去式")
    ("과거제"
     "科擧制")
    ("과거지사"
     "過去之事")
    ("과거형"
     "過去形")
    ("과격"
     "過激")
    ("과격파"
     "過激派")
    ("과공비례"
     "過恭非禮")
    ("과기"
     "科技")
    ("과년"
     "過年")
    ("과다"
     "過多")
    ("과단성"
     "果斷性")
    ("과당"
     "過當")
    ("과대"
     "誇大"
     "過大")
    ("과대망상"
     "誇大妄想")
    ("과대망상적"
     "誇大妄想的")
    ("과대평가"
     "過大評價")
    ("과덕지인"
     "寡德之人")
    ("과도"
     "果刀"
     "過度"
     "過渡")
    ("과도기"
     "過渡期")
    ("과도기적"
     "過渡期的")
    ("과도적"
     "過渡的")
    ("과람"
     "過濫")
    ("과량"
     "過量")
    ("과로"
     "過勞")
    ("과료"
     "科料")
    ("과립"
     "顆粒")
    ("과립형"
     "顆粒型")
    ("과립화"
     "顆粒化")
    ("과목"
     "科目")
    ("과목주의"
     "科目主義")
    ("과묵"
     "寡默")
    ("과묵형"
     "寡默型")
    ("과문"
     "寡聞")
    ("과민"
     "過敏")
    ("과민성"
     "過敏性")
    ("과밀"
     "過密")
    ("과반"
     "過半")
    ("과반수"
     "過半數")
    ("과보호"
     "過保護")
    ("과부"
     "寡婦")
    ("과부댁"
     "寡婦宅")
    ("과부적중"
     "寡不敵衆")
    ("과분"
     "過分")
    ("과산화"
     "過酸化")
    ("과세"
     "課稅")
    ("과소비"
     "過消費")
    ("과소평가"
     "過小評價")
    ("과속"
     "過速")
    ("과수"
     "果樹")
    ("과수댁"
     "寡守宅")
    ("과수원"
     "果樹園")
    ("과시"
     "誇示")
    ("과식"
     "過食")
    ("과신"
     "過信")
    ("과실"
     "果實"
     "過失")
    ("과실상규"
     "過失相規")
    ("과실음료"
     "果實飮料")
    ("과언"
     "過言")
    ("과업"
     "課業")
    ("과연"
     "果然")
    ("과열"
     "過熱")
    ("과오"
     "過誤")
    ("과외"
     "課外")
    ("과외비"
     "課外費")
    ("과욕"
     "過慾")
    ("과용"
     "過用")
    ("과원"
     "果園")
    ("과월"
     "過月")
    ("과유불급"
     "過猶不及")
    ("과음"
     "過飮")
    ("과잉"
     "過剩")
    ("과잉보호"
     "過剩保護")
    ("과자"
     "菓子")
    ("과장"
     "科場"
     "科長"
     "誇張"
     "課長")
    ("과장적"
     "誇張的")
    ("과전불납리"
     "瓜田不納履")
    ("과점"
     "寡占")
    ("과점적"
     "寡占的")
    ("과정"
     "科程"
     "課程"
     "過程")
    ("과정론적"
     "過程論的")
    ("과정적"
     "過程的")
    ("과제"
     "科題"
     "課題")
    ("과제물"
     "課題物")
    ("과중"
     "過重")
    ("과즙"
     "果汁")
    ("과채류"
     "果菜類")
    ("과태료"
     "過怠料")
    ("과표"
     "課標")
    ("과학"
     "科學")
    ("과학계"
     "科學界")
    ("과학과"
     "科學科")
    ("과학관"
     "科學館")
    ("과학도"
     "科學徒")
    ("과학물"
     "科學物")
    ("과학사"
     "科學史")
    ("과학사가"
     "科學史家")
    ("과학성"
     "科學性")
    ("과학실"
     "科學室")
    ("과학자"
     "科學者")
    ("과학적"
     "科學的")
    ("과학주의"
     "科學主義")
    ("과학주의적"
     "科學主義的")
    ("과학화"
     "科學化")
    ("과형"
     "科刑")
    ("곽"
     ("廓" . "둘레 곽")
     ("槨" . "덧널 곽")
     ("藿" . "콩잎 곽")
     ("郭" . "성곽 곽")
     ("椁" . "관 곽")
     ("癨" . "곽란 곽")
     "矡"
     ("霍" . "빠를 곽")
     ("鞹" . "무두질한 가죽 곽"))
    ("관"
     ("冠" . "갓 관")
     ("官" . "벼슬 관")
     ("寬" . "너그러울 관")
     ("慣" . "버릇 관")
     "梡"
     ("棺" . "널 관")
     ("款" . "정성 관")
     ("灌" . "물 댈 관")
     ("琯" . "옥피리 관")
     ("瓘" . "옥 이름 관")
     ("管" . "피리 관")
     ("罐" . "두레박 관")
     ("莞" . "골풀 관")
     ("菅" . "골풀 관")
     ("觀" . "볼 관")
     ("貫" . "꿸 관")
     ("關" . "빗장 관")
     ("館" . "객사 관")
     "串"
     ("丱" . "쌍상투 관")
     ("涫" . "끓을 관")
     ("爟" . "봉화 관")
     ("盥" . "대야 관")
     ("祼" . "강신제 관")
     ("窾" . "빌 관")
     ("筦" . "피리 관")
     ("綰" . "얽을 관")
     ("輨" . "줏대 관")
     ("錧" . "비녀장 관")
     ("鑵" . "두레박 관")
     ("雚" . "황새 관")
     ("顴" . "광대뼈 관")
     ("髖" . "허리뼈 관")
     ("鸛" . "황새 관"))
    ("관가"
     "官家")
    ("관개"
     "灌漑")
    ("관객"
     "觀客")
    ("관객석"
     "觀客席")
    ("관객층"
     "觀客層")
    ("관건"
     "關鍵")
    ("관계"
     "官桂"
     "官界"
     "官階"
     "關係"
     "關契")
    ("관계국"
     "關係國")
    ("관계망"
     "關係網")
    ("관계법"
     "關係法")
    ("관계사"
     "關係史")
    ("관계인"
     "關係人")
    ("관계자"
     "關係者")
    ("관계적"
     "關係的")
    ("관곡"
     "官穀")
    ("관공서"
     "官公署")
    ("관광"
     "觀光")
    ("관광객"
     "觀光客")
    ("관광단"
     "觀光團")
    ("관광단지"
     "觀光團地")
    ("관광업계"
     "觀光業界")
    ("관광업체"
     "觀光業體")
    ("관광전"
     "觀光展")
    ("관광지"
     "觀光地")
    ("관광지화"
     "觀光地化")
    ("관광학과"
     "觀光學科")
    ("관군"
     "官軍")
    ("관권"
     "官權")
    ("관극"
     "觀劇")
    ("관급"
     "官給")
    ("관내"
     "管內")
    ("관념"
     "觀念")
    ("관념론"
     "觀念論")
    ("관념론자"
     "觀念論者")
    ("관념성"
     "觀念性")
    ("관념적"
     "觀念的")
    ("관념주의"
     "觀念主義")
    ("관노"
     "官奴")
    ("관능"
     "官能")
    ("관능미"
     "官能美")
    ("관능성"
     "官能性")
    ("관능적"
     "官能的")
    ("관능주의"
     "官能主義")
    ("관대"
     "寬大"
     "寬待"
     "款待")
    ("관동"
     "關東")
    ("관두형"
     "貫頭型")
    ("관등"
     "官等")
    ("관람"
     "觀覽")
    ("관람객"
     "觀覽客")
    ("관람료"
     "觀覽料")
    ("관람자"
     "觀覽者")
    ("관람자적"
     "觀覽者的")
    ("관련"
     "關聯")
    ("관련국"
     "關聯國")
    ("관련설"
     "關聯說")
    ("관련성"
     "關聯性")
    ("관련세"
     "關聯稅")
    ("관련업"
     "關聯業")
    ("관련자"
     "關聯者")
    ("관례"
     "冠禮"
     "慣例")
    ("관례화"
     "慣例化")
    ("관록"
     "貫祿")
    ("관료"
     "官僚")
    ("관료배"
     "官僚輩")
    ("관료의식"
     "官僚意識")
    ("관료적"
     "官僚的")
    ("관료전"
     "官僚田")
    ("관료전제"
     "官僚田制")
    ("관료제"
     "官僚制")
    ("관료주의"
     "官僚主義")
    ("관료주의적"
     "官僚主義的")
    ("관료층"
     "官僚層")
    ("관료화"
     "官僚化")
    ("관류"
     "貫流")
    ("관류율"
     "貫流率")
    ("관리"
     "官吏"
     "管理")
    ("관리계"
     "管理係")
    ("관리계장"
     "管理係長")
    ("관리과"
     "管理科")
    ("관리과장"
     "管理科長")
    ("관리관"
     "管理官")
    ("관리국장"
     "管理局長")
    ("관리령"
     "管理令")
    ("관리법"
     "管理法")
    ("관리부"
     "管理部")
    ("관리부장"
     "管理部長")
    ("관리비"
     "管理費")
    ("관리사"
     "管理使")
    ("관리소"
     "管理所")
    ("관리실"
     "管理室")
    ("관리실장"
     "管理室長")
    ("관리원"
     "管理員")
    ("관리인"
     "管理人")
    ("관리자"
     "管理者")
    ("관리직"
     "管理職")
    ("관리책"
     "管理責")
    ("관리학과"
     "管理學科")
    ("관망"
     "觀望")
    ("관망적"
     "觀望的")
    ("관명"
     "官名")
    ("관모"
     "冠帽")
    ("관목"
     "灌木")
    ("관목림"
     "灌木林")
    ("관문"
     "關門")
    ("관민"
     "官民")
    ("관변"
     "官邊")
    ("관복"
     "冠服"
     "官服")
    ("관부"
     "官府")
    ("관북"
     "關北")
    ("관비"
     "官婢")
    ("관사"
     "冠詞"
     "官紗"
     "官舍")
    ("관산"
     "關山")
    ("관상"
     "觀相")
    ("관상수"
     "觀賞樹")
    ("관상용"
     "觀賞用")
    ("관서"
     "官署"
     "關西")
    ("관서장"
     "官署長")
    ("관선"
     "官選")
    ("관성"
     "慣性")
    ("관세"
     "關稅")
    ("관세국장"
     "關稅局長")
    ("관세율"
     "關稅率")
    ("관세음보살"
     "觀世音菩薩")
    ("관세화"
     "關稅化")
    ("관속"
     "官屬")
    ("관습"
     "慣習")
    ("관습법"
     "慣習法")
    ("관습적"
     "慣習的")
    ("관습화"
     "慣習化")
    ("관식"
     "冠飾")
    ("관심"
     "關心")
    ("관심권"
     "關心圈")
    ("관심도"
     "關心度")
    ("관심사"
     "關心事")
    ("관심자"
     "關心者")
    ("관아"
     "官衙")
    ("관악기"
     "管樂器")
    ("관여"
     "關與")
    ("관엽"
     "觀葉")
    ("관영"
     "官營")
    ("관왕"
     "冠王")
    ("관외"
     "管外")
    ("관용"
     "官用"
     "寬容")
    ("관용어"
     "慣用語")
    ("관용적"
     "寬容的")
    ("관용화"
     "慣用化")
    ("관원"
     "官員")
    ("관음적"
     "觀淫的")
    ("관인화"
     "官人化")
    ("관자"
     "貫子")
    ("관작"
     "官爵")
    ("관장"
     "官長"
     "管掌"
     "館長")
    ("관재"
     "官災")
    ("관저"
     "官邸")
    ("관전"
     "觀戰")
    ("관전평"
     "觀戰評")
    ("관절"
     "關節")
    ("관절염"
     "關節炎")
    ("관점"
     "觀點")
    ("관제"
     "官制"
     "官製"
     "管制")
    ("관제사"
     "管制士")
    ("관제탑"
     "管制塔")
    ("관조"
     "觀照")
    ("관조자"
     "觀照者")
    ("관존민비"
     "官尊民卑")
    ("관중"
     "觀衆"
     "貫衆")
    ("관직"
     "官職")
    ("관직명"
     "官職名")
    ("관직자"
     "官職者")
    ("관찬"
     "官撰")
    ("관찰"
     "觀察")
    ("관찰국"
     "觀察國")
    ("관찰기"
     "觀察記")
    ("관찰력"
     "觀察力")
    ("관찰사"
     "觀察使")
    ("관찰자"
     "觀察者")
    ("관철"
     "觀徹"
     "貫徹")
    ("관청"
     "官廳")
    ("관청가"
     "官廳街")
    ("관측"
     "觀測")
    ("관측기"
     "觀測器")
    ("관측소"
     "觀測所")
    ("관측자"
     "觀測者")
    ("관측치"
     "觀測値")
    ("관측통"
     "觀測通")
    ("관치"
     "官治")
    ("관통"
     "貫通")
    ("관통형"
     "貫通型")
    ("관포지교"
     "管鮑之交")
    ("관품제"
     "官品制")
    ("관학자"
     "官學者")
    ("관할"
     "管轄")
    ("관할권"
     "管轄權")
    ("관행"
     "慣行")
    ("관행화"
     "慣行化")
    ("관헌"
     "官憲")
    ("관현악과"
     "管絃樂科")
    ("관혼상제"
     "冠婚喪祭")
    ("관활"
     "寬闊")
    ("괄"
     ("刮" . "깍을 괄")
     ("恝" . "걱정 없을 괄")
     ("括" . "묶을 괄")
     ("檜" . "전나무 괄, 나라이름 괄")
     ("适" . "빠를 괄")
     ("佸" . "힘 쓸 괄")
     ("栝" . "노송나무 괄")
     ("筈" . "하눌타리 괄")
     ("聒" . "떠들석할 괄")
     ("髺" . "머리 묶을 괄")
     ("鴰" . "재두루미 괄"))
    ("괄목"
     "刮目")
    ("괄목상대"
     "刮目相對")
    ("괄시"
     "恝視")
    ("괄약근"
     "括約筋")
    ("괄호"
     "括弧")
    ("광"
     ("侊" . "성한 모양 광")
     ("光" . "빛 광")
     ("匡" . "바룰 광")
     ("壙" . "광 광")
     ("廣" . "넓을 광")
     ("曠" . "밝을 광")
     ("洸" . "물 용솟음할 광")
     ("炚" . "햇빚 뜨거울 광")
     ("狂" . "미질 광")
     ("珖" . "옥피리 광")
     ("筐" . "광주리 광")
     ("胱" . "오줌통 광")
     ("鑛" . "쇳돌 광")
     ("恇" . "겁낼 광")
     ("桄" . "광랑나무 광")
     ("框" . "문테 광")
     ("爌" . "불 빛 환할 광")
     ("獷" . "사나울 광")
     ("磺" . "쇳돌 광")
     ("絖" . "솜 광")
     ("纊" . "솜 광")
     ("茪" . "초결명 광")
     ("誆" . "속일 광")
     ("誑" . "속일 광"))
    ("광경"
     "光景")
    ("광고"
     "廣告")
    ("광고계"
     "廣告界")
    ("광고란"
     "廣告欄")
    ("광고량"
     "廣告量")
    ("광고문"
     "廣告文")
    ("광고물"
     "廣告物")
    ("광고비"
     "廣告費")
    ("광고업계"
     "廣告業界")
    ("광고업체"
     "廣告業體")
    ("광고인"
     "廣告人")
    ("광고전"
     "廣告展")
    ("광고주"
     "廣告主")
    ("광고탑"
     "廣告塔")
    ("광고판"
     "廣告板")
    ("광공업"
     "鑛工業")
    ("광과민성"
     "光過敏性")
    ("광궤"
     "廣軌")
    ("광기"
     "狂氣")
    ("광년"
     "光年")
    ("광대"
     "廣大")
    ("광대무변"
     "廣大無邊")
    ("광도"
     "光度")
    ("광독성"
     "光毒性")
    ("광란"
     "狂亂")
    ("광란적"
     "狂亂的")
    ("광막"
     "廣漠")
    ("광망"
     "光芒")
    ("광명"
     "光明")
    ("광목"
     "廣木")
    ("광물"
     "鑛物")
    ("광물질"
     "鑛物質")
    ("광범"
     "廣範")
    ("광범위"
     "廣範圍")
    ("광범위성"
     "廣範圍性")
    ("광변"
     "廣變")
    ("광복"
     "光復")
    ("광복절"
     "光復節")
    ("광부"
     "鑛夫")
    ("광분"
     "狂奔")
    ("광산"
     "鑛山")
    ("광산촌"
     "鑛山村")
    ("광석"
     "鑛石")
    ("광선"
     "光線")
    ("광속"
     "光速")
    ("광수"
     "廣袖")
    ("광신"
     "狂信")
    ("광신도"
     "狂信徒")
    ("광신론"
     "狂信論")
    ("광신자"
     "狂信者")
    ("광야"
     "曠野")
    ("광업"
     "鑛業")
    ("광업권"
     "鑛業權")
    ("광업소"
     "鑛業所")
    ("광역"
     "廣域")
    ("광역권"
     "廣域圈")
    ("광역시"
     "廣域市")
    ("광역화"
     "廣域化")
    ("광원"
     "鑛員")
    ("광의"
     "廣義")
    ("광인"
     "狂人")
    ("광장"
     "廣場")
    ("광적"
     "狂的")
    ("광전지"
     "光電池")
    ("광제창생"
     "廣濟蒼生")
    ("광주"
     "光州")
    ("광채"
     "光彩")
    ("광초"
     "光秒")
    ("광태"
     "狂態")
    ("광택"
     "光澤")
    ("광파"
     "光波")
    ("광포"
     "狂暴")
    ("광풍제월"
     "光風霽月")
    ("광학"
     "光學")
    ("광학적"
     "光學的")
    ("광합성"
     "光合成")
    ("광활"
     "廣闊")
    ("광활성"
     "廣闊性")
    ("광휘"
     "光輝")
    ("괘"
     ("卦" . "걸 괘")
     ("掛" . "걸 괘")
     ("罫" . "줄 괘")
     ("咼" . "입 비뚤어질 괘")
     ("挂" . "그림족자 괘")
     ("罣" . "걸 괘")
     ("詿" . "그르칠 괘"))
    ("괘념"
     "掛念")
    ("괘종시계"
     "掛鐘時計")
    ("괘포형"
     "掛布型")
    ("괴"
     ("乖" . "어그러질 괴")
     ("傀" . "클 괴")
     ("塊" . "흙덩이 괴")
     ("壞" . "무너질 괴")
     ("怪" . "기이할 괴")
     ("愧" . "부끄러워할 괴")
     ("拐" . "속일 괴")
     ("槐" . "홰나무 괴")
     ("魁" . "으뜸 괴")
     "坏"
     ("媿" . "창피줄 괴")
     ("廥" . "여물광 괴")
     ("恠" . "怪의 俗字")
     ("瑰" . "슬이름 괴")
     ("璝" . "옥돌 괴")
     ("蒯" . "황모 괴")
     ("襘" . "띠매듭 괴")
     "闠")
    ("괴괴"
     "怪怪")
    ("괴기"
     "怪奇")
    ("괴력"
     "怪力")
    ("괴뢰"
     "傀儡")
    ("괴뢰군"
     "傀儡軍")
    ("괴리"
     "乖離")
    ("괴리감"
     "乖離感")
    ("괴멸"
     "壞滅")
    ("괴멸적"
     "壞滅的")
    ("괴물"
     "怪物")
    ("괴변"
     "怪變")
    ("괴사"
     "壞死")
    ("괴상"
     "怪常")
    ("괴상망측"
     "怪常罔測")
    ("괴성"
     "怪聲")
    ("괴수"
     "魁首")
    ("괴음"
     "怪音")
    ("괴이"
     "怪異")
    ("괴팍"
     "乖愎")
    ("괴한"
     "怪漢")
    ("괴혈병"
     "壞血病")
    ("괴화"
     "槐花")
    ("괵"
     ("馘" . "벨 괵"))
    ("굉"
     ("宏" . "클 굉")
     ("紘" . "갓끈 굉")
     ("肱" . "팔뚝 굉")
     ("轟" . "울릴 굉")
     ("浤" . "용솟음할 굉")
     ("觥" . "뿔잔 굉")
     ("訇" . "큰 소리 굉")
     ("閎" . "마을문 굉")
     "黌")
    ("굉음"
     "轟音")
    ("굉장"
     "宏壯")
    ("교"
     ("交" . "사귈 교")
     ("僑" . "높을 교")
     ("咬" . "새소리 교")
     ("喬" . "높을 교")
     ("嬌" . "아리따울 교")
     ("嶠" . "뾰족하게 높을 교")
     ("巧" . "공교할 교")
     ("攪" . "어지러울 교")
     ("敎" . "가르침 교")
     ("校" . "학교 교")
     ("橋" . "다리 교")
     ("狡" . "교활할 교")
     ("皎" . "달빛 교")
     ("矯" . "바로잡을 교")
     ("絞" . "목맬 교")
     ("翹" . "꼬리 긴 깃털 교")
     ("膠" . "아교 교")
     ("蕎" . "메밀 교")
     ("蛟" . "교룡 교")
     ("較" . "견줄 교")
     ("轎" . "가마 교")
     ("郊" . "성 밖 교")
     "酵"
     ("餃" . "경단 교")
     ("驕" . "교만할 교")
     ("鮫" . "상어 교")
     ("佼" . "예쁠 교")
     ("嘄" . "부르짖을 교")
     ("嘐" . "닭 울 교")
     ("噭" . "부르짖을 교")
     ("嚙" . "깨물 교")
     ("姣" . "예쁠 교")
     "徼"
     ("憍" . "교만할 교")
     ("撟" . "들 교")
     ("晈" . "달 밝을 교")
     ("暞" . "밝을 교")
     ("榷" . "외나무 다리 교")
     "橇"
     ("磽" . "메마른 땅 교")
     "窖"
     "趫"
     "蹻"
     "鉸"
     "骹"
     "鵁"
     "齩")
    ("교가"
     "校歌")
    ("교각"
     "橋脚"
     "橋閣")
    ("교각살우"
     "矯角殺牛")
    ("교감"
     "交感"
     "校監")
    ("교과"
     "敎果"
     "敎科")
    ("교과목"
     "敎科目")
    ("교과서"
     "敎科書")
    ("교과서적"
     "敎科書的")
    ("교관"
     "敎官"
     "敎觀")
    ("교교"
     "皎皎")
    ("교구"
     "敎區")
    ("교구비"
     "敎具費")
    ("교구장"
     "敎區長")
    ("교군"
     "轎軍")
    ("교권"
     "敎權")
    ("교내"
     "校內")
    ("교단"
     "敎團"
     "敎壇")
    ("교단생활"
     "敎壇生活")
    ("교대"
     "交代"
     "敎大")
    ("교대자"
     "交代者")
    ("교도"
     "敎導"
     "敎徒")
    ("교도관"
     "矯導官")
    ("교도소"
     "矯導所")
    ("교도소장"
     "矯導所長")
    ("교두보"
     "橋頭堡")
    ("교란"
     "攪亂")
    ("교량"
     "橋梁"
     "較量")
    ("교련"
     "敎鍊")
    ("교련화"
     "敎鍊化")
    ("교류"
     "交流")
    ("교리"
     "敎理")
    ("교리적"
     "敎理的")
    ("교만"
     "驕慢")
    ("교만심"
     "驕慢心")
    ("교목"
     "喬木"
     "校木")
    ("교목실장"
     "校牧室長")
    ("교묘"
     "巧妙")
    ("교무"
     "敎務"
     "校務")
    ("교무과"
     "敎務課")
    ("교무과장"
     "敎務課長")
    ("교무실"
     "敎務室")
    ("교무처"
     "敎務處")
    ("교무처장"
     "敎務處長")
    ("교문"
     "校門")
    ("교민"
     "僑民")
    ("교민회"
     "僑民會")
    ("교범"
     "敎範")
    ("교변"
     "交變")
    ("교복"
     "校服")
    ("교본"
     "敎本")
    ("교부"
     "交付")
    ("교부율"
     "交附率")
    ("교분"
     "交分")
    ("교사"
     "敎唆"
     "敎師"
     "校舍")
    ("교사제"
     "敎師制")
    ("교사회"
     "敎師會")
    ("교생"
     "敎生")
    ("교서"
     "敎書")
    ("교선"
     "敎禪")
    ("교설"
     "敎說")
    ("교섭"
     "交涉")
    ("교섭권"
     "交涉權")
    ("교섭사"
     "交涉史")
    ("교성"
     "嬌聲")
    ("교세"
     "敎勢")
    ("교수"
     "敎授")
    ("교수대"
     "絞首臺")
    ("교수법"
     "敎授法")
    ("교수실"
     "敎授室")
    ("교수직"
     "敎授職")
    ("교수진"
     "敎授陣")
    ("교수형"
     "絞首刑")
    ("교술시"
     "敎述詩")
    ("교습"
     "敎習")
    ("교시"
     "敎示"
     "校時")
    ("교신"
     "交信")
    ("교실"
     "敎室")
    ("교양"
     "敎養")
    ("교양과"
     "敎養科")
    ("교양서"
     "敎養書")
    ("교양인"
     "敎養人")
    ("교언"
     "巧言")
    ("교언영색"
     "巧言令色")
    ("교역"
     "交易")
    ("교역국"
     "交易國")
    ("교역량"
     "交易量")
    ("교역전"
     "交易展")
    ("교열부"
     "校閱部")
    ("교외"
     "校外"
     "郊外")
    ("교외별전"
     "敎外別傳")
    ("교우"
     "交友"
     "敎友"
     "校友")
    ("교우회지"
     "校友會誌")
    ("교원"
     "敎員")
    ("교위"
     "敎委")
    ("교유"
     "交遊")
    ("교육"
     "敎育")
    ("교육감"
     "敎育監")
    ("교육계"
     "敎育界")
    ("교육과"
     "敎育科")
    ("교육관"
     "敎育觀")
    ("교육권"
     "敎育權")
    ("교육령"
     "敎育令")
    ("교육부장"
     "敎育部長")
    ("교육비"
     "敎育費")
    ("교육서"
     "敎育書")
    ("교육성"
     "敎育性")
    ("교육세"
     "敎育稅")
    ("교육세율"
     "敎育稅率")
    ("교육실"
     "敎育室")
    ("교육열"
     "敎育熱")
    ("교육원"
     "敎育院")
    ("교육자"
     "敎育者")
    ("교육자적"
     "敎育者的")
    ("교육장"
     "敎育場"
     "敎育長")
    ("교육적"
     "敎育的")
    ("교육지"
     "敎育誌")
    ("교육청"
     "敎育廳")
    ("교육학"
     "敎育學")
    ("교육학과"
     "敎育學科")
    ("교육학자"
     "敎育學者")
    ("교의"
     "敎義")
    ("교인"
     "敎人")
    ("교자"
     "轎子")
    ("교장"
     "校葬"
     "校長")
    ("교장단"
     "敎長團")
    ("교장도감"
     "敎藏都監")
    ("교장론"
     "敎長論")
    ("교장실"
     "校長室")
    ("교장직"
     "敎長職")
    ("교재"
     "敎材")
    ("교재원"
     "敎材園")
    ("교전"
     "交戰")
    ("교정"
     "校庭"
     "校正"
     "校訂"
     "矯正")
    ("교제"
     "交際")
    ("교제비"
     "交際費")
    ("교조"
     "敎祖")
    ("교조적"
     "敎條的")
    ("교조주의"
     "敎條主義")
    ("교조주의자"
     "敎條主義者")
    ("교조주의적"
     "敎條主義的")
    ("교종"
     "敎宗")
    ("교주"
     "敎主")
    ("교주고슬"
     "膠柱鼓瑟")
    ("교지"
     "校紙"
     "校誌")
    ("교직"
     "敎職")
    ("교직원"
     "敎職員")
    ("교차"
     "交叉")
    ("교차로"
     "交叉路")
    ("교차점"
     "交叉點")
    ("교착"
     "交着"
     "膠着")
    ("교체"
     "交替")
    ("교체기"
     "交替期")
    ("교체설"
     "交替說")
    ("교칙"
     "校則")
    ("교탁"
     "敎卓")
    ("교태"
     "嬌態")
    ("교통"
     "交通")
    ("교통경찰"
     "交通警察")
    ("교통난"
     "交通難")
    ("교통량"
     "交通量")
    ("교통로"
     "交通路")
    ("교통망"
     "交通網")
    ("교통비"
     "交通費")
    ("교통사고"
     "交通事故")
    ("교통사고율"
     "交通事故率")
    ("교통수단"
     "交通手段")
    ("교통순경"
     "交通巡警")
    ("교통안전"
     "交通安全")
    ("교통정리"
     "交通整理")
    ("교통지옥"
     "交通地獄")
    ("교통질서"
     "交通秩序")
    ("교통편"
     "交通便")
    ("교파"
     "敎派")
    ("교편"
     "敎鞭")
    ("교포"
     "僑胞")
    ("교학"
     "敎學")
    ("교학처장"
     "敎學處長")
    ("교합"
     "咬合")
    ("교향곡"
     "交響曲")
    ("교향악단"
     "交響樂團")
    ("교협"
     "敎協")
    ("교호"
     "交好")
    ("교화"
     "敎化"
     "校花")
    ("교화력"
     "敎化力")
    ("교환"
     "交換")
    ("교환기"
     "交換機")
    ("교환대"
     "交換臺")
    ("교환소"
     "交換所")
    ("교환원"
     "交換員")
    ("교환전"
     "交換展")
    ("교활"
     "狡猾")
    ("교황"
     "敎皇")
    ("교회"
     "敎會")
    ("교회당"
     "敎會堂")
    ("교회사"
     "敎會史")
    ("교회사가"
     "敎會史家")
    ("교훈"
     "敎訓"
     "校訓")
    ("교훈적"
     "敎訓的")
    ("구"
     ("丘" . "언덕 구")
     ("久" . "오랠 구")
     ("九" . "아홉 구")
     ("仇" . "짝 구")
     ("俱" . "함께 구")
     ("具" . "갖출 구")
     ("勾" . "글귀절 구")
     ("區" . "감출 구")
     ("口" . "입 구")
     ("句" . "글귀절 구")
     ("咎" . "허물 구")
     ("嘔" . "토할 구")
     ("坵" . "丘의 俗字")
     ("垢" . "때 구, 더러울 구")
     ("寇" . "도둑 구")
     ("嶇" . "산험준할 구")
     ("廐" . "마구간 구")
     ("懼" . "두려워할 구")
     ("拘" . "잡을 구")
     ("救" . "구원할 구")
     "晷"
     ("枸" . "구기자 구")
     ("柩" . "관 구")
     ("柾" . "관 구, 널 구")
     ("構" . "집세울 구")
     ("歐" . "토할 구")
     ("毆" . "때릴 구")
     ("毬" . "제기 구")
     ("求" . "찾을 구")
     ("溝" . "개천 구")
     ("灸" . "지질 구")
     ("狗" . "개 구")
     ("玖" . "옥 다음가는 돌 구")
     ("球" . "옥경쇠 구")
     ("瞿" . "놀라서 볼 구")
     ("矩" . "곡척 구")
     ("究" . "궁리할 구")
     ("絿" . "급박할 구")
     ("耉" . "늙을 구")
     ("臼" . "절구 구")
     ("舅" . "외삼촌 구")
     ("舊" . "옛 구")
     ("苟" . "진실로 구")
     ("衢" . "네거리 구")
     ("謳" . "읊조릴 구")
     ("購" . "살(구입할) 구")
     ("軀" . "몸 구")
     ("逑" . "짝 구")
     ("邱" . "언덕 구")
     ("鉤" . "갈고랑쇠 구")
     ("銶" . "끌 구")
     ("駒" . "망아지 구")
     ("驅" . "몰 구")
     ("鳩" . "비둘기 구")
     ("鷗" . "갈매기 구")
     ("龜" . "나라 이름 구")
     ("佝" . "꼽추 구")
     ("俅" . "공손할 구")
     "傋"
     ("傴" . "구부릴 구")
     ("冓" . "재목 어긋매겨 쌓을 구")
     ("劬" . "수고로울 구")
     ("匶" . "柩의 古字")
     ("厹" . "세모창 구")
     ("叴" . "소리 높일 구")
     ("坸" . "垢와 同字")
     ("姤" . "만날 구")
     ("媾" . "겹사돈 구")
     ("嫗" . "할미 구")
     ("屨" . "삼으로 짠 신 구")
     ("岣" . "산이름 구")
     ("彀" . "활 잔뜩 당길 구")
     ("戵" . "창 구")
     ("扣" . "두드릴 구")
     ("捄" . "흙파올릴 구")
     ("搆" . "얽어맬 구")
     ("摳" . "치마걷어들 구")
     ("昫" . "해돋아 따뜻할 구")
     ("榘" . "곡척 구")
     ("漚" . "물거품 구")
     ("璆" . "옥경쇠 구")
     ("甌" . "사발 구")
     ("疚" . "오랜 병 구")
     ("痀" . "곱사등이 구")
     ("癯" . "여윌 구")
     ("窛" . "노략질할 구")
     ("窶" . "가난하여 예절없을 구")
     ("篝" . "불덮개 구")
     ("糗" . "마른밥가루 구")
     ("胊" . "포(얇게 저미어서 말린 고기) 구")
     ("蒟" . "구장 구")
     ("蚯" . "지렁이 구")
     ("裘" . "갓옷 구")
     ("詬" . "꾸짖을 구")
     ("遘" . "만날 구")
     ("釦" . "그릇에 금테 두를 구")
     ("韝" . "깍지 구")
     ("韭" . "부추 구")
     ("韮" . "韭와 同字")
     ("颶" . "사방풍 구")
     ("駈" . "驅와 同字")
     ("鬮" . "제비뽑을 구")
     ("鷇" . "새 새끼 구")
     ("鸜" . "구관조 구"))
    ("구가"
     "謳歌")
    ("구간"
     "區間")
    ("구강"
     "口腔")
    ("구걸"
     "求乞")
    ("구경"
     "口徑"
     "究竟")
    ("구경각"
     "究竟覺")
    ("구곡간장"
     "九曲肝腸")
    ("구관"
     "舊館")
    ("구교"
     "舊橋")
    ("구구"
     "區區")
    ("구구단"
     "九九段")
    ("구구식"
     "九九式")
    ("구구절절"
     "句句節節")
    ("구국"
     "救國")
    ("구국간성"
     "救國干城")
    ("구군복"
     "具軍服")
    ("구극적"
     "究極的")
    ("구금"
     "拘禁")
    ("구금당"
     "拘禁當")
    ("구금자"
     "拘禁者")
    ("구금죄"
     "拘禁罪")
    ("구급"
     "救急")
    ("구급약"
     "救急藥")
    ("구급차"
     "救急車")
    ("구기"
     "球技")
    ("구내"
     "構內")
    ("구내매점"
     "構內賣店")
    ("구내방송"
     "構內放送")
    ("구내식당"
     "構內食堂")
    ("구내전화"
     "構內電話")
    ("구단"
     "球團")
    ("구단주"
     "球團主")
    ("구단협"
     "舊團協")
    ("구도"
     "構圖"
     "求道")
    ("구도독부"
     "九都督府")
    ("구도자"
     "求道者")
    ("구도적"
     "求道的")
    ("구독"
     "購讀")
    ("구독료"
     "購讀料")
    ("구독자"
     "購讀者")
    ("구동"
     "驅動")
    ("구두"
     "口頭")
    ("구두점"
     "句讀點")
    ("구득난"
     "求得難")
    ("구락부"
     "俱樂部")
    ("구랍"
     "舊臘")
    ("구령"
     "口令")
    ("구류"
     "句留"
     "拘留")
    ("구류형"
     "拘留刑")
    ("구륵"
     "鉤勒")
    ("구릉"
     "丘陵")
    ("구릉성"
     "丘陵性")
    ("구릉지"
     "丘陵地")
    ("구릉지대"
     "丘陵地帶")
    ("구만"
     "九萬")
    ("구매"
     "購買")
    ("구매력"
     "購買力")
    ("구매사"
     "購買社")
    ("구매선"
     "購買線")
    ("구매설"
     "購買說")
    ("구매자"
     "購買者")
    ("구면"
     "舊面")
    ("구면지기"
     "舊面知己")
    ("구명"
     "救命")
    ("구명대"
     "救命帶")
    ("구명선"
     "救命船")
    ("구명정"
     "救命艇")
    ("구문"
     "構文")
    ("구미"
     "口味"
     "歐美")
    ("구미속초"
     "狗尾續貂")
    ("구민"
     "區民")
    ("구밀복검"
     "口蜜腹劍")
    ("구박"
     "驅迫")
    ("구백팔십"
     "九百八十")
    ("구법"
     "舊法")
    ("구별"
     "區別")
    ("구보"
     "驅步")
    ("구부득고"
     "求不得苦")
    ("구북구"
     "舊北區")
    ("구분"
     "區分")
    ("구분론"
     "區分論")
    ("구분법"
     "區分法")
    ("구분적"
     "區分的")
    ("구비"
     "具備"
     "口碑")
    ("구사"
     "驅使")
    ("구사대"
     "救社隊")
    ("구사력"
     "驅使力")
    ("구사일생"
     "九死一生")
    ("구사회주의"
     "舊社會主義")
    ("구산"
     "九山")
    ("구산선문"
     "九山禪門")
    ("구상"
     "具象"
     "構想")
    ("구상도"
     "構想圖")
    ("구상류층"
     "舊上流層")
    ("구상안"
     "構想案")
    ("구상유취"
     "口尙乳臭")
    ("구색"
     "具色")
    ("구서당"
     "九誓幢")
    ("구석기"
     "舊石器")
    ("구석기인"
     "舊石器人")
    ("구설"
     "口舌")
    ("구설수"
     "口舌數")
    ("구성"
     "構成")
    ("구성극"
     "構成劇")
    ("구성력"
     "構成力")
    ("구성물"
     "構成物")
    ("구성법"
     "構成法")
    ("구성비"
     "構成比")
    ("구성선"
     "構成線")
    ("구성원"
     "構成員")
    ("구성적"
     "構成的")
    ("구성체"
     "構成體")
    ("구성체론"
     "構成體論")
    ("구성체적"
     "構成體的")
    ("구세계"
     "舊世界")
    ("구세대"
     "舊世代")
    ("구세주"
     "救世主")
    ("구속"
     "拘束"
     "球速")
    ("구속력"
     "拘束力")
    ("구속성"
     "拘束性")
    ("구속자"
     "拘束者")
    ("구수회의"
     "鳩首會議")
    ("구술"
     "口述")
    ("구술시험"
     "口述試驗")
    ("구습"
     "舊習")
    ("구시대"
     "舊時代")
    ("구시대적"
     "舊時代的")
    ("구식"
     "舊式")
    ("구실"
     "口實")
    ("구심"
     "求心"
     "球心")
    ("구심성"
     "求心性")
    ("구심점"
     "求心點")
    ("구심체"
     "求心體")
    ("구십"
     "九十")
    ("구십구"
     "九十九")
    ("구십사"
     "九十四")
    ("구십삼"
     "九十三")
    ("구십오"
     "九十五")
    ("구십육"
     "九十六")
    ("구십일"
     "九十日")
    ("구십춘광"
     "九十春光")
    ("구십칠"
     "九十七")
    ("구안투생"
     "苟安偸生")
    ("구애"
     "拘碍"
     "求愛")
    ("구약"
     "舊約")
    ("구어"
     "口語")
    ("구어체"
     "口語體")
    ("구여현하"
     "口如懸河")
    ("구역"
     "區域"
     "嘔逆")
    ("구역제"
     "區域制")
    ("구연"
     "口演"
     "舊緣")
    ("구연동화"
     "口演童話")
    ("구우일모"
     "九牛一毛")
    ("구원"
     "救援")
    ("구원자"
     "救援者")
    ("구월"
     "九月")
    ("구읍"
     "舊邑")
    ("구이지학"
     "口耳之學")
    ("구인"
     "拘引"
     "求人")
    ("구입"
     "求入"
     "購入")
    ("구입난"
     "求入難")
    ("구입비"
     "求入費")
    ("구입자"
     "求入者")
    ("구입처"
     "求入處")
    ("구입품"
     "求入品")
    ("구장"
     "區長"
     "球場")
    ("구전"
     "口傳")
    ("구절"
     "句節")
    ("구절양장"
     "九折羊腸")
    ("구절초"
     "九節草")
    ("구정"
     "舊正")
    ("구정치인"
     "舊政治人")
    ("구제"
     "救濟"
     "驅除")
    ("구제책"
     "救濟策")
    ("구제품"
     "舊製品")
    ("구조"
     "救助"
     "構造")
    ("구조론"
     "構造論")
    ("구조론적"
     "構造論的")
    ("구조물"
     "構造物")
    ("구조적"
     "構造的")
    ("구조주의"
     "構造主義")
    ("구조주의자"
     "構造主義者")
    ("구조주의적"
     "構造主義的")
    ("구조학"
     "構造學")
    ("구조화"
     "構造化")
    ("구족계"
     "具足戒")
    ("구좌"
     "口座")
    ("구주"
     "九州"
     "救主")
    ("구중궁궐"
     "九重宮闕")
    ("구즉득지"
     "求則得之")
    ("구직"
     "求職")
    ("구직자"
     "求職者")
    ("구질"
     "球質")
    ("구차"
     "苟且")
    ("구천"
     "九千"
     "九泉")
    ("구첩반상"
     "九-飯床")
    ("구청"
     "區廳")
    ("구청장"
     "區廳長")
    ("구청장실"
     "區廳長室")
    ("구체"
     "具體")
    ("구체성"
     "具體性")
    ("구체적"
     "具體的")
    ("구체제"
     "舊體制")
    ("구체화"
     "具體化")
    ("구축"
     "構築")
    ("구축업"
     "構築業")
    ("구출"
     "救出")
    ("구치소"
     "拘置所")
    ("구치소장"
     "拘置所長")
    ("구타"
     "毆打")
    ("구태"
     "舊態")
    ("구태의연"
     "舊態依然")
    ("구토"
     "嘔吐")
    ("구토증"
     "嘔吐症")
    ("구판장"
     "購販場")
    ("구팽"
     "狗烹")
    ("구필"
     "口筆")
    ("구한감우"
     "久旱甘雨")
    ("구한말"
     "舊韓末")
    ("구헌법"
     "舊憲法")
    ("구현"
     "具現")
    ("구형"
     "求刑"
     "舊型")
    ("구형량"
     "求刑量")
    ("구호"
     "口號"
     "救護")
    ("구호물자"
     "救護物資")
    ("구호미"
     "救護米")
    ("구호성"
     "救護性")
    ("구호품"
     "救護品")
    ("구혼장"
     "求婚狀")
    ("구화"
     "口畵")
    ("구화지문"
     "口禍之門")
    ("구황"
     "救荒")
    ("구획"
     "區劃")
    ("구휼"
     "救恤")
    ("국"
     ("國" . "나라 국")
     ("局" . "부분 국")
     ("菊" . "국화 국")
     ("鞠" . "기를 국")
     "鞫"
     ("麴" . "누룩 국")
     ("匊" . "움켜 뜰 국")
     ("掬" . "두 손으로 움킬 국")
     ("跼" . "구부릴 국")
     ("麯" . "麴과 同字"))
    ("국가"
     "國家")
    ("국가계획"
     "國家計劃")
    ("국가고시"
     "國家考試")
    ("국가론"
     "國家論")
    ("국가사"
     "國家史")
    ("국가사상"
     "國家思想")
    ("국가사업"
     "國家事業")
    ("국가설"
     "國家說")
    ("국가수반"
     "國家首班")
    ("국가적"
     "國家的")
    ("국가주석"
     "國家主席")
    ("국가주석직"
     "國家主席職")
    ("국가주의"
     "國家主義")
    ("국가학설"
     "國家學說")
    ("국경"
     "國境")
    ("국경선"
     "國境線")
    ("국경일"
     "國慶日")
    ("국고"
     "國庫")
    ("국공립"
     "國公立")
    ("국교"
     "國交"
     "國敎")
    ("국교생"
     "國校生")
    ("국군"
     "國軍")
    ("국권"
     "國權")
    ("국기"
     "國基"
     "國旗")
    ("국난"
     "國難")
    ("국내"
     "國內")
    ("국내계"
     "國內系")
    ("국내법"
     "國內法")
    ("국내법적"
     "國內法的")
    ("국내산"
     "國內産")
    ("국내선"
     "國內線")
    ("국내외"
     "國內外")
    ("국내외적"
     "國內外的")
    ("국내인"
     "國內人")
    ("국내적"
     "國內的")
    ("국내파"
     "國內派")
    ("국도"
     "國道")
    ("국량"
     "局量")
    ("국력"
     "國力")
    ("국록"
     "國祿")
    ("국론"
     "國論")
    ("국리민복"
     "國利民福")
    ("국리민복적"
     "國利民福的")
    ("국립"
     "國立")
    ("국립공원"
     "國立公園")
    ("국립대"
     "國立大")
    ("국립대학"
     "國立大學")
    ("국면"
     "局面")
    ("국명"
     "國名"
     "局名")
    ("국모"
     "國母")
    ("국무"
     "國務")
    ("국무총리"
     "國務總理")
    ("국무총리상"
     "國務總理賞")
    ("국무총리실"
     "國務總理室")
    ("국문"
     "國文")
    ("국문과"
     "國文科")
    ("국문학"
     "國文學")
    ("국문학계"
     "國文學界")
    ("국문학자"
     "國文學者")
    ("국민"
     "國民")
    ("국민감정"
     "國民感情")
    ("국민성"
     "國民性")
    ("국민운동"
     "國民運動")
    ("국민장"
     "國民章"
     "國民葬")
    ("국민적"
     "國民的")
    ("국민주"
     "國民株")
    ("국민학교"
     "國民學校")
    ("국민학교생"
     "國民學校生")
    ("국민학교장"
     "國民學校長")
    ("국민학생"
     "國民學生")
    ("국방"
     "國防")
    ("국방군"
     "國防軍")
    ("국방력"
     "國防力")
    ("국방비"
     "國防費")
    ("국번"
     "局番")
    ("국법"
     "國法")
    ("국보"
     "國寶")
    ("국부"
     "國富"
     "局部")
    ("국부적"
     "局部的")
    ("국부화"
     "國富化")
    ("국사"
     "國事"
     "國史"
     "國師")
    ("국사무쌍"
     "國士無雙")
    ("국산"
     "國産")
    ("국산품"
     "國産品")
    ("국산화"
     "國産化")
    ("국산화율"
     "國産化率")
    ("국상"
     "國喪"
     "國相")
    ("국선"
     "國選")
    ("국세"
     "國稅")
    ("국소"
     "局所")
    ("국수적"
     "國粹的")
    ("국수주의"
     "國粹主義")
    ("국수주의자"
     "國粹主義者")
    ("국수주의적"
     "國粹主義的")
    ("국시"
     "國是")
    ("국악"
     "國樂")
    ("국악과"
     "國樂科")
    ("국악단"
     "國樂團")
    ("국악풍"
     "國樂風")
    ("국어"
     "國語")
    ("국어과"
     "國語科")
    ("국어사전"
     "國語辭典")
    ("국어학"
     "國語學")
    ("국어학계"
     "國語學界")
    ("국어학자"
     "國語學者")
    ("국역"
     "國役"
     "國譯")
    ("국영"
     "國營")
    ("국영화"
     "國營化")
    ("국왕"
     "國王")
    ("국외"
     "國外")
    ("국외자"
     "局外者")
    ("국외적"
     "國外的")
    ("국운"
     "國運")
    ("국위"
     "國威")
    ("국유"
     "國有")
    ("국유론"
     "國有論")
    ("국유론자"
     "國有論者")
    ("국유제"
     "國有制")
    ("국유제론"
     "國有制論")
    ("국유제적"
     "國有制的")
    ("국유화"
     "國有化")
    ("국유화론"
     "國有化論")
    ("국읍"
     "國邑")
    ("국익"
     "國益")
    ("국장"
     "局長")
    ("국적"
     "國籍")
    ("국적선"
     "國籍船")
    ("국전"
     "國展")
    ("국정"
     "國定"
     "國情"
     "國政")
    ("국제"
     "國際")
    ("국제간"
     "國際間")
    ("국제공항"
     "國際空港")
    ("국제관"
     "國際館")
    ("국제기구"
     "國際機構")
    ("국제무대"
     "國際舞臺")
    ("국제법"
     "國際法")
    ("국제법적"
     "國際法的")
    ("국제부"
     "國際部")
    ("국제선"
     "國際線")
    ("국제인"
     "國際人")
    ("국제적"
     "國際的")
    ("국제전"
     "國際戰")
    ("국제주의적"
     "國際主義的")
    ("국제파"
     "國際派")
    ("국제화"
     "國際化")
    ("국제회의"
     "國際會議")
    ("국제회의실"
     "國際會議室")
    ("국제회의장"
     "國際會議場")
    ("국조"
     "國祖")
    ("국조권"
     "國調權")
    ("국조신"
     "國祖神")
    ("국졸"
     "國卒")
    ("국중"
     "國中")
    ("국지"
     "國志"
     "局地")
    ("국지적"
     "局地的")
    ("국지전"
     "局地戰")
    ("국채"
     "國債")
    ("국책"
     "國策")
    ("국치민욕"
     "國恥民辱")
    ("국태민안"
     "國泰民安")
    ("국토"
     "國土")
    ("국풍"
     "國風")
    ("국풍파"
     "國風派")
    ("국한"
     "局限")
    ("국한문"
     "國漢文")
    ("국호"
     "國號")
    ("국혼"
     "國婚"
     "國魂")
    ("국화"
     "國花"
     "菊花")
    ("국화과"
     "菊花科")
    ("국회"
     "國會")
    ("국회의원"
     "國會議員")
    ("국회의원직"
     "國會議員職")
    ("국회직"
     "國會職")
    ("군"
     ("君" . "임금 군")
     ("窘" . "군색할 군")
     ("群" . "무리 군")
     ("裙" . "치마 군")
     ("軍" . "군사 군")
     ("郡" . "고을 군")
     ("捃" . "주울 군")
     ("桾" . "고욤나무 군")
     ("皸" . "얼어터질 군"))
    ("군가"
     "軍歌")
    ("군견병"
     "軍犬兵")
    ("군경"
     "軍警")
    ("군계"
     "郡界")
    ("군계일학"
     "群鷄一鶴")
    ("군관"
     "軍官")
    ("군교"
     "軍校")
    ("군구"
     "軍區")
    ("군국"
     "軍國"
     "郡國")
    ("군국주의"
     "軍國主義")
    ("군국주의화"
     "軍國主義化")
    ("군권"
     "軍權")
    ("군기"
     "軍氣"
     "軍紀")
    ("군기인호정전"
     "軍其人戶丁田")
    ("군납업"
     "軍納業")
    ("군내"
     "郡內")
    ("군단"
     "群團"
     "軍團")
    ("군단장"
     "軍團長")
    ("군대"
     "軍隊")
    ("군대식"
     "軍隊式")
    ("군도"
     "群島"
     "郡都")
    ("군락"
     "群落")
    ("군락상"
     "群落狀")
    ("군란"
     "軍亂")
    ("군량"
     "軍糧")
    ("군량미"
     "軍糧米")
    ("군령"
     "軍令")
    ("군림"
     "君臨")
    ("군림자"
     "君臨者")
    ("군명"
     "郡名")
    ("군무"
     "群舞")
    ("군무원"
     "軍務員")
    ("군문"
     "軍門")
    ("군민"
     "郡民")
    ("군번"
     "軍番")
    ("군벌"
     "軍閥")
    ("군보포"
     "軍保布")
    ("군복"
     "軍服")
    ("군부"
     "軍夫"
     "軍部")
    ("군부대"
     "軍部隊")
    ("군비"
     "軍備")
    ("군사"
     "軍事"
     "軍司"
     "軍士")
    ("군사력"
     "軍事力")
    ("군사령관"
     "軍司令官")
    ("군사령부"
     "軍司令部")
    ("군사범"
     "軍事犯")
    ("군사부일체"
     "君師父一體")
    ("군사비"
     "軍事費")
    ("군사적"
     "軍事的")
    ("군사주의"
     "軍事主義")
    ("군사화"
     "軍事化")
    ("군산"
     "軍産")
    ("군상"
     "群像")
    ("군소"
     "群小")
    ("군수"
     "軍需"
     "郡守")
    ("군수과장"
     "軍需課長")
    ("군수실"
     "軍需室")
    ("군수용"
     "軍需用")
    ("군수품"
     "軍需品")
    ("군신"
     "君臣")
    ("군신유의"
     "君臣有義")
    ("군역"
     "軍役")
    ("군영"
     "軍營")
    ("군왕"
     "君王"
     "郡王")
    ("군용"
     "軍用")
    ("군용기"
     "軍用機")
    ("군용물"
     "軍用物")
    ("군용지"
     "軍用地")
    ("군용차"
     "軍用車")
    ("군웅할거"
     "群雄割據")
    ("군의관"
     "軍醫官")
    ("군의회"
     "郡議會")
    ("군인"
     "軍人")
    ("군인전"
     "軍人田")
    ("군자"
     "君子")
    ("군자국"
     "君子國")
    ("군자삼락"
     "君子三樂")
    ("군장"
     "君長"
     "軍裝")
    ("군장국"
     "君長國")
    ("군정"
     "軍情"
     "軍政")
    ("군정관"
     "軍政官")
    ("군정청"
     "軍政廳")
    ("군제"
     "郡制")
    ("군졸"
     "軍卒")
    ("군종"
     "軍宗")
    ("군주"
     "君主")
    ("군중"
     "群衆")
    ("군중대회"
     "群衆大會")
    ("군중집회"
     "群衆集會")
    ("군지"
     "郡誌")
    ("군집"
     "群集")
    ("군청"
     "郡廳")
    ("군청색"
     "群靑色")
    ("군축"
     "軍縮")
    ("군축국장"
     "軍縮局長")
    ("군치소"
     "郡治所")
    ("군포"
     "軍布")
    ("군필"
     "軍必")
    ("군함"
     "軍艦")
    ("군항"
     "軍港")
    ("군항제"
     "軍港祭")
    ("군현"
     "郡縣")
    ("군현제"
     "郡縣制")
    ("군현제적"
     "郡縣制的")
    ("군혼"
     "群婚")
    ("군화"
     "軍靴")
    ("군홧"
     "軍靴")
    ("굴"
     ("堀" . "굴뚝 굴")
     ("屈" . "굽을 굴")
     ("掘" . "팔 굴")
     ("窟" . "구멍 굴")
     ("倔" . "딱딱할 굴")
     ("崛" . "산 높을 굴")
     ("淈" . "흐릴 굴")
     "矻"
     ("詘" . "굽을 굴"))
    ("굴곡"
     "屈曲")
    ("굴복"
     "屈伏"
     "屈服")
    ("굴복당"
     "屈服當")
    ("굴삭기"
     "掘削機")
    ("굴욕"
     "屈辱")
    ("굴욕사"
     "屈辱史")
    ("굴욕적"
     "屈辱的")
    ("굴절"
     "屈折")
    ("굴절력"
     "屈折力")
    ("굴종"
     "屈從")
    ("굴종적"
     "屈從的")
    ("굴지"
     "屈指")
    ("굴착"
     "掘鑿")
    ("굴착기"
     "掘鑿機")
    ("궁"
     ("宮" . "굴궐 궁")
     ("弓" . "활 궁")
     ("穹" . "높을 궁")
     ("窮" . "다할 궁")
     ("芎" . "궁궁이 궁")
     ("躬" . "몸 궁")
     ("躳" . "躬의 本字"))
    ("궁고"
     "窮袴")
    ("궁구"
     "窮究")
    ("궁궐"
     "宮闕")
    ("궁극"
     "窮極")
    ("궁극적"
     "窮極的")
    ("궁극점"
     "窮極點")
    ("궁기"
     "窮氣")
    ("궁내"
     "宮內")
    ("궁내수"
     "宮內水")
    ("궁내천"
     "宮內川")
    ("궁녀"
     "宮女")
    ("궁리"
     "窮理")
    ("궁상"
     "窮狀")
    ("궁색"
     "窮塞")
    ("궁서"
     "宮書")
    ("궁성"
     "宮城")
    ("궁여지책"
     "窮餘之策")
    ("궁원"
     "宮苑")
    ("궁을"
     "弓乙")
    ("궁전"
     "宮殿")
    ("궁정"
     "宮廷")
    ("궁중"
     "宮中"
     "宮重")
    ("궁지"
     "窮地")
    ("궁핍"
     "窮乏")
    ("궁합"
     "宮合")
    ("궁형"
     "宮刑")
    ("궉"
     "鴌")
    ("권"
     ("倦" . "게으를 권")
     ("券" . "엄쪽(어음을 쪼갠 한 쪽) 권")
     ("勸" . "권할 권")
     ("卷" . "굽을 권")
     ("圈" . "둥글 권")
     ("拳" . "주먹 권")
     ("捲" . "거둘 권")
     ("權" . "권세 권")
     ("淃" . "물돌아 흐를 권")
     ("眷" . "돌아볼 권")
     ("勌" . "倦과 同字")
     ("惓" . "삼갈 권")
     ("棬" . "휘어만든 나무그릇 권")
     ("睠" . "眷과 同字")
     ("綣" . "정다울 권")
     ("蜷" . "움추러질 권"))
    ("권격"
     "拳擊")
    ("권고"
     "勸告")
    ("권고안"
     "勸告案")
    ("권농"
     "勸農")
    ("권능"
     "權能")
    ("권두"
     "卷頭")
    ("권력"
     "權力")
    ("권력관계"
     "權力關係")
    ("권력자"
     "權力者")
    ("권력적"
     "權力的")
    ("권력체"
     "權力體")
    ("권력층"
     "權力層")
    ("권력형"
     "權力型")
    ("권리"
     "權利")
    ("권리금"
     "權利金")
    ("권모술수"
     "權謀術數")
    ("권문"
     "權門")
    ("권문세가"
     "權門勢家")
    ("권문세족"
     "權門勢族")
    ("권법"
     "拳法")
    ("권부"
     "權府")
    ("권불십년"
     "權不十年")
    ("권사"
     "勸士")
    ("권선"
     "勸善")
    ("권선징악"
     "勸善懲惡")
    ("권세"
     "權勢")
    ("권업"
     "勸業")
    ("권역"
     "圈域")
    ("권연초"
     "卷煙草")
    ("권위"
     "權威")
    ("권위자"
     "權威者")
    ("권위적"
     "權威的")
    ("권위주의"
     "權威主義")
    ("권위주의적"
     "權威主義的")
    ("권위주의화"
     "權威主義化")
    ("권위지"
     "權威紙")
    ("권위화"
     "權威化")
    ("권유"
     "勸誘"
     "勸諭")
    ("권익"
     "權益")
    ("권장"
     "勸奬")
    ("권장량"
     "勸奬量")
    ("권좌"
     "權座")
    ("권총"
     "拳銃")
    ("권총식"
     "拳銃式")
    ("권태"
     "倦怠")
    ("권태감"
     "倦怠感")
    ("권태기"
     "倦怠期")
    ("권토중래"
     "捲土重來")
    ("권투"
     "拳鬪")
    ("권한"
     "權限")
    ("궐"
     ("厥" . "그 궐")
     ("獗" . "도둑 일어날 궐")
     ("蕨" . "고사리 궐")
     ("蹶" . "우물벌레 궐")
     ("闕" . "대궐 궐")
     "劂"
     "撅")
    ("궐기"
     "蹶起")
    ("궐내"
     "闕內")
    ("궐석"
     "闕席")
    ("궤"
     ("机" . "느티나무 궤")
     ("櫃" . "상자 궤")
     ("潰" . "흩어질 궤")
     ("詭" . "속일 궤")
     ("蹶" . "급히걸을 궤")
     ("軌" . "수레바퀴 사이 궤")
     ("饋" . "먹일 궤")
     ("佹" . "포갤 궤")
     ("几" . "안석 궤")
     ("匱" . "갑 궤")
     ("憒" . "심란할 궤")
     ("樻" . "가마테나무 궤")
     ("氿" . "물가 궤")
     ("簋" . "대제기 궤")
     ("繢" . "톱끝 궤")
     ("跪" . "끓어앉을 궤")
     ("闠" . "저자문 궤")
     ("餽" . "饋와 同字")
     ("麂" . "큰고라니 궤"))
    ("궤도"
     "軌道")
    ("궤도선"
     "軌道線")
    ("궤멸"
     "潰滅")
    ("궤변"
     "詭辯")
    ("궤양"
     "潰瘍")
    ("궤적"
     "軌跡")
    ("귀"
     ("晷" . "시각 귀")
     ("歸" . "돌아올 귀")
     ("貴" . "높을 귀")
     ("鬼" . "귀신 귀")
     ("句" . "글귀 귀")
     ("龜" . "거북 귀")
     "巋")
    ("귀가"
     "歸家")
    ("귀감"
     "龜鑑")
    ("귀갓"
     "歸家")
    ("귀결"
     "歸結")
    ("귀경"
     "歸京")
    ("귀곡성"
     "鬼哭聲")
    ("귀공자"
     "貴公子")
    ("귀공자풍"
     "貴公子風")
    ("귀공자형"
     "貴公子型")
    ("귀교"
     "貴校")
    ("귀국"
     "歸國")
    ("귀금속"
     "貴金屬")
    ("귀납"
     "歸納")
    ("귀납적"
     "歸納的")
    ("귀대"
     "歸隊")
    ("귀로"
     "歸路")
    ("귀면"
     "鬼面")
    ("귀물"
     "貴物")
    ("귀배괄모"
     "龜背刮毛")
    ("귀법"
     "歸法")
    ("귀부인"
     "貴婦人")
    ("귀빈"
     "貴賓")
    ("귀빈관"
     "貴賓館")
    ("귀빈실"
     "貴賓室")
    ("귀선"
     "歸船")
    ("귀성"
     "歸省")
    ("귀성객"
     "歸省客")
    ("귀소"
     "歸巢")
    ("귀소형"
     "歸巢型")
    ("귀속"
     "歸屬")
    ("귀순"
     "歸順")
    ("귀순자"
     "歸順者")
    ("귀신"
     "鬼神")
    ("귀와"
     "歸臥")
    ("귀의"
     "歸依")
    ("귀인"
     "貴人")
    ("귀일"
     "歸一")
    ("귀재"
     "鬼才")
    ("귀족"
     "貴族")
    ("귀족적"
     "貴族的")
    ("귀족주의"
     "貴族主義")
    ("귀족주의적"
     "貴族主義的")
    ("귀족층"
     "貴族層")
    ("귀족화"
     "貴族化")
    ("귀중"
     "貴重")
    ("귀중품"
     "貴重品")
    ("귀착"
     "歸着")
    ("귀책"
     "歸責")
    ("귀천"
     "貴賤")
    ("귀추"
     "歸趨")
    ("귀축"
     "鬼畜")
    ("귀하"
     "貴下")
    ("귀항"
     "歸港")
    ("귀항지"
     "歸港地")
    ("귀향"
     "歸鄕")
    ("귀향객"
     "歸鄕客")
    ("귀향기"
     "歸鄕記")
    ("귀향형"
     "歸鄕型")
    ("귀화"
     "歸化")
    ("귀환"
     "歸還")
    ("규"
     ("叫" . "부를 규")
     ("圭" . "서옥 규")
     ("奎" . "별 규")
     ("揆" . "헤아릴 규")
     ("槻" . "물푸레나무 규")
     ("珪" . "圭와 同字")
     "畦"
     ("硅" . "유리만드는 흙 규")
     ("窺" . "엿볼 규")
     ("竅" . "구멍 규")
     ("糾" . "삼합노 규")
     "繆"
     ("葵" . "해바라기 규")
     ("規" . "그림쇠 규")
     ("赳" . "헌걸찰 규")
     ("逵" . "구거리 규")
     ("閨" . "색시 규")
     ("刲" . "찌를 규")
     ("嫢" . "가는 허리 규")
     ("嬀" . "성 규")
     ("暌" . "해질 규")
     ("楏" . "호미자루 규")
     ("樛" . "나무가지 휘어질 규")
     ("睽" . "어그러질 규")
     ("糺" . "거둘 규")
     ("虬" . "虯와 同字")
     ("虯" . "뿔없는 용 규")
     ("跬" . "한발자국 규")
     ("邽" . "고을이름 규")
     ("闚" . "갸웃이 볼 규")
     ("頍" . "고깔비녀 규")
     ("馗" . "아홉거리 규")
     "鮭")
    ("규격"
     "規格")
    ("규격성"
     "規格性")
    ("규격안"
     "規格案")
    ("규격적"
     "規格的")
    ("규격화"
     "規格化")
    ("규구준승"
     "規矩準繩")
    ("규명"
     "糾明")
    ("규명론"
     "糾明論")
    ("규모"
     "規模")
    ("규모망"
     "規模網")
    ("규범"
     "規範")
    ("규범성"
     "規範性")
    ("규범적"
     "規範的")
    ("규범화"
     "規範化")
    ("규소"
     "硅素")
    ("규수"
     "閨秀")
    ("규약"
     "規約")
    ("규율"
     "規律")
    ("규정"
     "糾正"
     "規定"
     "規程")
    ("규정력"
     "規定力")
    ("규정적"
     "規定的")
    ("규정화"
     "規定化")
    ("규제"
     "規制")
    ("규제력"
     "規制力")
    ("규제법"
     "規制法")
    ("규제책"
     "規制策")
    ("규찰대"
     "糾察隊")
    ("규칙"
     "糾飭"
     "規則")
    ("규칙성"
     "規則性")
    ("규칙적"
     "規則的")
    ("규칙화"
     "規則化")
    ("규탄"
     "糾彈")
    ("규합"
     "糾合")
    ("균"
     ("勻" . "고를 균")
     ("均" . "고를 균")
     ("畇" . "밭개간할 균")
     ("筠" . "대껍질 균")
     ("菌" . "버섯 균")
     ("鈞" . "서른 근 균")
     ("龜" . "(피부가)틀 균")
     ("囷" . "둥근곳집 균")
     ("麏" . "고라니 균"))
    ("균근"
     "菌根")
    ("균등"
     "均等")
    ("균분"
     "均分")
    ("균열"
     "龜裂")
    ("균일"
     "均一")
    ("균일가"
     "均一價")
    ("균일성"
     "均一性")
    ("균전제"
     "均田制")
    ("균점"
     "均霑")
    ("균제성"
     "均齊性")
    ("균질화"
     "均質化")
    ("균형"
     "均衡")
    ("균형미"
     "均衡美")
    ("균형적"
     "均衡的")
    ("귤"
     ("橘" . "귤나무 귤"))
    ("귤색"
     "橘色")
    ("극"
     ("克" . "이길 극")
     ("剋" . "깍일 극")
     ("劇" . "심할 극")
     ("戟" . "갈래진 창 극")
     ("棘" . "가시나무 극")
     ("極" . "가운데 극")
     ("隙" . "틈 극")
     ("亟" . "빠를 극")
     ("尅" . "剋과 同字")
     ("屐" . "나막신 극")
     ("郄" . "隙과 同字"))
    ("극구"
     "極口")
    ("극구변명"
     "極口辨明")
    ("극기"
     "克己")
    ("극기복례"
     "克己復禮")
    ("극단"
     "劇團"
     "極端")
    ("극단론"
     "極端論")
    ("극단적"
     "極端的")
    ("극단화"
     "極端化")
    ("극대화"
     "極大化")
    ("극도"
     "極度")
    ("극독물"
     "極毒物")
    ("극돌기"
     "極突起")
    ("극동"
     "極東")
    ("극락"
     "極樂")
    ("극락세계"
     "極樂世界")
    ("극락왕생"
     "極樂往生")
    ("극락전"
     "極樂殿")
    ("극락정토"
     "極樂淨土")
    ("극력"
     "極力")
    ("극렬"
     "極烈")
    ("극렬분자"
     "極烈分子")
    ("극명"
     "克明")
    ("극목"
     "極木")
    ("극미"
     "極微")
    ("극미량"
     "極微量")
    ("극벌원욕"
     "克伐怨慾")
    ("극복"
     "克復"
     "克服")
    ("극본"
     "劇本")
    ("극비"
     "極秘")
    ("극빈"
     "極貧")
    ("극빈자"
     "極貧者")
    ("극빈층"
     "極貧層")
    ("극성"
     "極盛")
    ("극성파"
     "極盛派")
    ("극소수"
     "極少數")
    ("극소화"
     "極小化"
     "極少化")
    ("극심"
     "極甚")
    ("극악"
     "極惡")
    ("극약"
     "劇藥")
    ("극언"
     "極言")
    ("극영화"
     "劇映畵")
    ("극우"
     "極右")
    ("극우파"
     "極右派")
    ("극의"
     "極意")
    ("극작"
     "劇作")
    ("극작가"
     "劇作家")
    ("극작술"
     "劇作術")
    ("극장"
     "劇場")
    ("극장가"
     "劇場街")
    ("극장난"
     "劇場難")
    ("극장용"
     "劇場用")
    ("극장제"
     "劇場制")
    ("극적"
     "劇的")
    ("극점"
     "極點")
    ("극좌"
     "極左")
    ("극중극"
     "劇中劇")
    ("극지방"
     "極地方")
    ("극진"
     "極盡")
    ("극초단파"
     "極超短波")
    ("극치"
     "極致")
    ("극한"
     "極限")
    ("극한적"
     "極限的")
    ("극형"
     "極刑")
    ("극화"
     "劇化"
     "劇畵")
    ("근"
     ("僅" . "겨우 근")
     ("劤" . "힘많을 근")
     ("勤" . "부지런할 근")
     ("懃" . "은근할 근")
     ("斤" . "근 근")
     ("根" . "뿌리 근")
     ("槿" . "무궁화 근")
     ("瑾" . "붉은옥 근")
     ("筋" . "힘줄 근")
     ("芹" . "미나리 근")
     ("菫" . "오랑캐 꽃 근")
     ("謹" . "삼갈 근")
     ("近" . "가까울 근")
     ("饉" . "주릴 근")
     ("卺" . "합환주잔 근")
     ("厪" . "적을 근")
     ("墐" . "진흙 근")
     ("巹" . "받들 근")
     ("廑" . "작은집 근")
     ("漌" . "맑을 근")
     "蘄"
     ("觔" . "筋과 同字")
     ("跟" . "발두꿈치 근")
     ("釿" . "대패 근")
     ("靳" . "아낄 근"))
    ("근간"
     "根幹")
    ("근거"
     "根據")
    ("근거리"
     "近距離")
    ("근거지"
     "根據地")
    ("근검"
     "勤儉")
    ("근검절약"
     "勤儉節約")
    ("근경"
     "近景")
    ("근고"
     "勤苦")
    ("근교"
     "近郊")
    ("근근"
     "僅僅"
     "勤勤"
     "近近")
    ("근근자자"
     "勤勤孜孜")
    ("근기"
     "根氣")
    ("근년"
     "近年")
    ("근대"
     "近代")
    ("근대극"
     "近代劇")
    ("근대사"
     "近代史")
    ("근대성"
     "近代性")
    ("근대식"
     "近代式")
    ("근대인"
     "近代人")
    ("근대적"
     "近代的")
    ("근대주의적"
     "近代主義的")
    ("근대화"
     "近代化")
    ("근동"
     "近洞")
    ("근래"
     "近來")
    ("근력"
     "筋力")
    ("근로"
     "勤勞")
    ("근로자"
     "勤勞者")
    ("근로제"
     "勤勞制")
    ("근린"
     "近隣")
    ("근막"
     "筋膜")
    ("근막통"
     "筋膜痛")
    ("근면"
     "勤勉")
    ("근면성"
     "勤勉性")
    ("근무"
     "勤務")
    ("근무소"
     "勤務所")
    ("근무자"
     "勤務者")
    ("근무조"
     "勤務組")
    ("근무지"
     "勤務地")
    ("근무처"
     "勤務處")
    ("근묵자흑"
     "近墨者黑")
    ("근방"
     "近方")
    ("근본"
     "根本")
    ("근본적"
     "根本的")
    ("근본주의"
     "根本主義")
    ("근본주의적"
     "根本主義的")
    ("근본책"
     "根本策")
    ("근사"
     "近似")
    ("근사치"
     "近似値")
    ("근성"
     "根性")
    ("근세"
     "近世"
     "近歲")
    ("근세사"
     "近世史")
    ("근소"
     "僅少")
    ("근소세"
     "勤所稅")
    ("근속"
     "勤續")
    ("근시안"
     "近視眼")
    ("근시안적"
     "近視眼的")
    ("근신"
     "謹愼")
    ("근실"
     "勤實")
    ("근엄"
     "謹嚴")
    ("근엄화"
     "謹嚴化")
    ("근연종"
     "近緣種")
    ("근왕주의"
     "勤王主義")
    ("근원"
     "根源")
    ("근원적"
     "根源的")
    ("근위축증"
     "筋萎縮症")
    ("근육"
     "筋肉")
    ("근육계"
     "筋肉系")
    ("근육질"
     "筋肉質")
    ("근육통"
     "筋肉痛")
    ("근자"
     "近者")
    ("근저"
     "根底")
    ("근절"
     "根絶")
    ("근절안"
     "根絶案")
    ("근절책"
     "根絶策")
    ("근접"
     "近接")
    ("근지구력"
     "筋持久力")
    ("근처"
     "近處")
    ("근친"
     "近親")
    ("근친상간적"
     "近親相姦的")
    ("근하신년"
     "謹賀新年")
    ("근해"
     "近海")
    ("근황"
     "近況")
    ("글"
     "訖"
     ("契" . "부족 이름 글"))
    ("금"
     ("今" . "이제 금")
     ("妗" . "외숙모 금")
     ("擒" . "사로잡을 금")
     ("昑" . "밝을 금")
     ("檎" . "능금나무 금")
     ("琴" . "거문고 금")
     ("禁" . "금할 금")
     ("禽" . "날짐승 금")
     ("芩" . "풀 이름 금")
     ("衾" . "이불 금")
     ("衿" . "옷깃 금")
     ("襟" . "옷깃 금")
     "鈐"
     ("錦" . "비단 금")
     ("金" . "성 금")
     ("唫" . "입 다물 금")
     ("噤" . "입 다물 금")
     ("嶔" . "높고 험할 금")
     ("笒" . "첨대 금")
     ("黅" . "누른 빛 금"))
    ("금강"
     "金剛")
    ("금강산"
     "金剛山")
    ("금강석"
     "金剛石")
    ("금강좌"
     "金剛座")
    ("금견"
     "錦絹")
    ("금계포란형"
     "金鷄抱卵型")
    ("금고"
     "禁錮"
     "金庫")
    ("금과옥조"
     "金科玉條")
    ("금관"
     "金冠")
    ("금광"
     "金光")
    ("금권"
     "金權")
    ("금기"
     "禁忌")
    ("금기담"
     "禁忌談")
    ("금기라"
     "錦綺羅")
    ("금기시"
     "禁忌視")
    ("금남"
     "禁男")
    ("금녀"
     "禁女")
    ("금년"
     "今年")
    ("금년도"
     "今年度")
    ("금단"
     "禁斷")
    ("금당"
     "金堂")
    ("금도"
     "襟度")
    ("금도금"
     "金鍍金")
    ("금동"
     "金銅")
    ("금란지계"
     "金蘭之契")
    ("금력"
     "金力")
    ("금리"
     "金利")
    ("금맥"
     "金脈")
    ("금명간"
     "今明間")
    ("금목수화토"
     "金木水火土")
    ("금물"
     "禁物")
    ("금박"
     "金箔")
    ("금반지"
     "金半指")
    ("금발"
     "金髮")
    ("금방"
     "今方")
    ("금방금방"
     "今方今方")
    ("금배"
     "金杯")
    ("금번"
     "今番")
    ("금부도사"
     "禁府都事")
    ("금사"
     "金絲")
    ("금상첨화"
     "錦上添花")
    ("금색"
     "金色")
    ("금서"
     "禁書")
    ("금석맹약"
     "金石盟約")
    ("금석문"
     "金石文")
    ("금석지감"
     "今昔之感")
    ("금석지교"
     "金石之交")
    ("금석학"
     "金石學")
    ("금성"
     "金星")
    ("금성옥진"
     "金聲玉振")
    ("금성탕지"
     "金城湯池")
    ("금세기"
     "今世紀")
    ("금세기인"
     "今世紀人")
    ("금속"
     "金屬")
    ("금속기"
     "金屬器")
    ("금속성"
     "金屬聲")
    ("금속판"
     "金屬板")
    ("금송령"
     "禁松領")
    ("금수"
     "禁輸"
     "錦繡")
    ("금수강산"
     "錦繡江山")
    ("금슬"
     "琴瑟")
    ("금슬지락"
     "琴瑟之樂")
    ("금시"
     "今時")
    ("금시계"
     "金時計")
    ("금시초문"
     "今始初聞"
     "今時初聞")
    ("금식"
     "禁食")
    ("금실"
     "琴瑟")
    ("금심수구"
     "錦心繡口")
    ("금액"
     "金額")
    ("금어"
     "禁語")
    ("금언"
     "金言")
    ("금연"
     "禁煙")
    ("금연법"
     "禁煙法")
    ("금오옥토"
     "金烏玉兎")
    ("금옥군자"
     "金玉君子")
    ("금옥만당"
     "金玉滿堂")
    ("금요일"
     "金曜日")
    ("금욕"
     "禁慾")
    ("금욕적"
     "禁慾的")
    ("금융"
     "金融")
    ("금융가"
     "金融街")
    ("금융계"
     "金融界")
    ("금융국장"
     "金融局長")
    ("금융권"
     "金融圈")
    ("금융사"
     "金融社")
    ("금융업"
     "金融業")
    ("금융업계"
     "金融業界")
    ("금융인"
     "金融人")
    ("금융적"
     "金融的")
    ("금은방"
     "金銀房")
    ("금의야행"
     "錦衣夜行")
    ("금의환향"
     "錦衣還鄕")
    ("금일"
     "今日")
    ("금일봉"
     "金一封")
    ("금자탑"
     "金字塔")
    ("금장"
     "金裝")
    ("금전"
     "錦典"
     "金錢")
    ("금전만능"
     "金錢萬能")
    ("금전적"
     "金錢的")
    ("금제"
     "禁制")
    ("금주"
     "今週")
    ("금주주의"
     "金主主義")
    ("금지"
     "禁止")
    ("금지곡"
     "禁止曲")
    ("금지당"
     "禁止當")
    ("금지령"
     "禁止令")
    ("금지법"
     "禁止法")
    ("금지안"
     "禁止案")
    ("금지옥엽"
     "金枝玉葉")
    ("금치산자"
     "禁治産者")
    ("금패"
     "金牌")
    ("금표비"
     "禁標碑")
    ("금품"
     "金品")
    ("금형"
     "金型")
    ("금후"
     "今後")
    ("급"
     ("伋" . "속일 급")
     ("及" . "미칠 급")
     ("急" . "급할 급")
     ("扱" . "미칠 급")
     ("汲" . "길을 급")
     ("級" . "등급 급")
     ("給" . "넉넉할 급")
     ("圾" . "위태할 급")
     ("岌" . "높을 급")
     ("皀" . "고소할 급")
     ("礏" . "산 높은 모양 급")
     ("笈" . "책상자 급")
     ("芨" . "말오줌나무 급"))
    ("급강하"
     "急降下")
    ("급격"
     "急激")
    ("급경사"
     "急傾斜")
    ("급급"
     "汲汲")
    ("급기야"
     "及其也")
    ("급난지풍"
     "急難之風")
    ("급등"
     "急騰")
    ("급등세"
     "急騰勢")
    ("급락"
     "急落")
    ("급료"
     "給料")
    ("급류"
     "急流")
    ("급매물"
     "急賣物")
    ("급모"
     "急募")
    ("급무"
     "急務")
    ("급박"
     "急迫")
    ("급반등"
     "急反騰")
    ("급반등세"
     "急反騰勢")
    ("급배수"
     "給排水")
    ("급변"
     "急變")
    ("급부상"
     "急浮上")
    ("급사"
     "急死"
     "給仕")
    ("급사면"
     "急斜面")
    ("급상승"
     "急上昇")
    ("급선"
     "急先")
    ("급선무"
     "急先務")
    ("급선회"
     "急旋回")
    ("급성"
     "急性")
    ("급성장"
     "急成長")
    ("급소"
     "急所")
    ("급속"
     "急速")
    ("급속도"
     "急速度")
    ("급수"
     "級數"
     "給水")
    ("급습"
     "急襲")
    ("급식"
     "給食")
    ("급신장"
     "急伸張")
    ("급여"
     "給與")
    ("급우"
     "級友")
    ("급유"
     "給油")
    ("급전"
     "急錢")
    ("급전직하"
     "急轉直下")
    ("급정거"
     "急停車")
    ("급제"
     "及第")
    ("급제동"
     "急制動")
    ("급조"
     "急造")
    ("급증"
     "急增")
    ("급증가"
     "急增加")
    ("급지"
     "級地")
    ("급진"
     "急進")
    ("급진적"
     "急進的")
    ("급진전"
     "急進展")
    ("급진주의"
     "急進主義")
    ("급진주의자"
     "急進主義者")
    ("급체"
     "急滯")
    ("급탕비"
     "急湯費")
    ("급파"
     "急派")
    ("급팽창"
     "急膨脹")
    ("급팽창론"
     "急膨脹論")
    ("급행열차"
     "急行列車")
    ("급회전"
     "急回轉")
    ("긍"
     "亘"
     ("兢" . "삼갈 긍")
     ("矜" . "불쌍히 여길 긍")
     ("肯" . "옳이 여길 긍")
     ("亙" . "뻗칠 긍")
     ("殑" . "까무라칠 긍"))
    ("긍구"
     "兢懼")
    ("긍정"
     "肯定")
    ("긍정론"
     "肯定論")
    ("긍정적"
     "肯定的")
    ("긍지"
     "矜持")
    ("기"
     ("乞" . "줄 기")
     ("企" . "꾀할 기")
     ("伎" . "재주 기")
     ("其" . "그 기")
     ("冀" . "바랄 기")
     ("嗜" . "즐길 기")
     ("器" . "그릇 기")
     ("圻" . "경기 기")
     ("基" . "터 기")
     ("埼" . "崎와 同字")
     ("夔" . "조심할 기")
     ("奇" . "기이할 기")
     ("妓" . "기생 기")
     ("寄" . "부칠 기")
     ("岐" . "갈림길 기")
     ("崎" . "험할 기")
     ("己" . "자기 기")
     ("幾" . "기미 기")
     ("忌" . "꺼릴 기")
     ("技" . "재주 기")
     ("旗" . "기 기")
     ("旣" . "이미 기")
     ("朞" . "돌 기")
     ("期" . "기약할 기")
     "机"
     ("杞" . "나무 이름 기")
     ("枳" . "해할 기, 사타구니 기")
     ("棄" . "버릴 기")
     ("棋" . "바둑 기")
     ("機" . "틀 기")
     ("欺" . "속일 기")
     ("氣" . "기운 기")
     ("汽" . "김 기")
     ("沂" . "물 이름 기")
     ("淇" . "강 이름 기")
     ("玘" . "패옥 기")
     ("琦" . "옥 이름 기")
     ("琪" . "옥 기")
     ("璂" . "피변 꾸미개 기")
     ("璣" . "구슬 기")
     ("畸" . "뙈기 밭 기")
     ("畿" . "경기 기")
     ("碁" . "棋와 同字")
     ("磯" . "물가 기")
     ("祁" . "성할 기")
     ("祇" . "토지의 신 기")
     ("祈" . "빌 기")
     ("祺" . "복 기")
     ("箕" . "키 기")
     ("紀" . "벼리 기")
     ("綺" . "비단 기")
     ("羈" . "굴레 기")
     ("耆" . "늙은이 기")
     ("耭" . "갈 기")
     ("肌" . "살 기")
     ("記" . "기록할 기")
     ("譏" . "나무랄 기")
     ("豈" . "어찌 기")
     ("起" . "일어날 기")
     ("錡" . "솥 기")
     ("錤" . "호미 기")
     ("飢" . "주릴 기")
     ("饑" . "주릴 기")
     ("騎" . "말탈 기")
     ("騏" . "털총이 기")
     ("驥" . "천리마 기")
     ("麒" . "기린 기")
     ("僛" . "취하여 춤추는 모양 기")
     "几"
     ("剞" . "새김칼 기")
     ("墍" . "맥질할 기")
     ("屺" . "민둥산 기")
     ("庋" . "시렁 기")
     ("弃" . "棄의 古字")
     ("忮" . "해칠 기")
     ("愭" . "공손할 기")
     ("掎" . "끌 기")
     ("攲" . "기울기 기")
     ("旂" . "기 기")
     ("暣" . "볕기운 기")
     ("曁" . "및 기")
     ("棊" . "棋와 同字")
     "欹"
     ("歧" . "岐와 同字")
     ("炁" . "기운 기")
     "猉"
     ("禨" . "조짐 기")
     ("綥" . "비단 쑥색 기")
     ("綦" . "연두빛 비단 기")
     ("羇" . "나그네 기")
     ("肵" . "적대 기")
     ("芪" . "단너삼 기")
     ("芰" . "세발 마름 기")
     ("蘄" . "풀 이름 기")
     ("虁" . "夔와 同字")
     ("蜝" . "방계 기")
     ("蟣" . "서캐 기")
     ("覉" . "구속할 기, 말 굴레 기")
     ("覬" . "바랄 기")
     ("跂" . "육발 기")
     ("頎" . "헌걸찰 기")
     ("鬐" . "갈기 기")
     ("鰭" . "지느러미 기"))
    ("기각"
     "棄却")
    ("기간"
     "其間"
     "基幹"
     "期間")
    ("기간병"
     "基幹兵")
    ("기간산업"
     "基幹産業")
    ("기간산업체"
     "基幹産業體")
    ("기갈"
     "飢渴")
    ("기강"
     "紀綱")
    ("기개"
     "氣槪")
    ("기거"
     "寄居"
     "起居")
    ("기겁"
     "氣怯")
    ("기견"
     "綺絹")
    ("기계"
     "器械"
     "機械")
    ("기계과"
     "機械科")
    ("기계관"
     "機械觀")
    ("기계론적"
     "機械論的")
    ("기계식"
     "機械式")
    ("기계어"
     "機械語")
    ("기계적"
     "機械的")
    ("기계주의"
     "機械主義")
    ("기계화"
     "機械化")
    ("기고"
     "奇古"
     "寄稿")
    ("기고가"
     "寄稿家")
    ("기고만장"
     "氣高萬丈")
    ("기골"
     "氣骨")
    ("기골장대"
     "氣骨壯大")
    ("기공"
     "技工"
     "起工")
    ("기공물"
     "技工物")
    ("기공식"
     "起工式")
    ("기관"
     "器官"
     "機關"
     "汽罐")
    ("기관부"
     "機關部")
    ("기관부원"
     "機關部員")
    ("기관사"
     "機關士")
    ("기관실"
     "機關室")
    ("기관원"
     "機關員")
    ("기관장"
     "機關長")
    ("기관지"
     "機關紙"
     "機關誌"
     "氣管支")
    ("기관지염"
     "氣管支炎")
    ("기관차"
     "機關車")
    ("기관총"
     "機關銃")
    ("기관화"
     "機關化")
    ("기괴"
     "奇怪")
    ("기괴망측"
     "奇怪罔測")
    ("기교"
     "技巧")
    ("기교적"
     "技巧的")
    ("기교주의"
     "技巧主義")
    ("기교파"
     "技巧派")
    ("기구"
     "器具"
     "崎嶇"
     "機構"
     "祈求")
    ("기구업"
     "器具業")
    ("기구업자"
     "器具業者")
    ("기구화"
     "機構化")
    ("기군망상"
     "欺君罔上")
    ("기권"
     "棄權"
     "氣圈")
    ("기근"
     "飢饉")
    ("기금"
     "基金"
     "寄金")
    ("기기"
     "機器")
    ("기기묘묘"
     "奇奇妙妙")
    ("기내"
     "機內")
    ("기내식"
     "機內食")
    ("기념"
     "記念")
    ("기념관"
     "記念館")
    ("기념물"
     "記念物")
    ("기념비"
     "記念碑")
    ("기념비적"
     "記念碑的")
    ("기념사"
     "記念辭")
    ("기념사업"
     "記念事業")
    ("기념사업회"
     "記念事業會")
    ("기념사진"
     "記念寫眞")
    ("기념식"
     "記念式")
    ("기념식장"
     "記念式場")
    ("기념엽서"
     "記念葉書")
    ("기념일"
     "記念日")
    ("기념주화"
     "記念鑄貨")
    ("기념탑"
     "記念塔")
    ("기념품"
     "記念品")
    ("기념품점"
     "紀念品店")
    ("기념행사"
     "記念行事")
    ("기념호"
     "記念號")
    ("기념회"
     "記念會")
    ("기능"
     "技能"
     "機能")
    ("기능공"
     "技能工")
    ("기능사"
     "技能士")
    ("기능성"
     "機能性")
    ("기능신"
     "機能神")
    ("기능인"
     "機能人")
    ("기능적"
     "機能的")
    ("기능주의"
     "機能主義")
    ("기능주의적"
     "機能主義的")
    ("기능직"
     "技能職")
    ("기단"
     "基壇")
    ("기단부"
     "基壇部")
    ("기담괴설"
     "奇談怪說")
    ("기대"
     "期待")
    ("기대감"
     "期待感")
    ("기대주"
     "期待株")
    ("기대치"
     "期待値")
    ("기도"
     "企圖"
     "氣道"
     "祈禱")
    ("기도문"
     "祈禱文")
    ("기도원"
     "祈禱院")
    ("기도회"
     "祈禱會")
    ("기독"
     "基督")
    ("기독교"
     "基督敎")
    ("기독교도"
     "基督敎徒")
    ("기독교식"
     "基督敎式")
    ("기독교인"
     "基督敎人")
    ("기독교적"
     "基督敎的")
    ("기독교회"
     "基督敎會")
    ("기동"
     "機動"
     "起動")
    ("기동대"
     "機動隊")
    ("기동력"
     "機動力")
    ("기동성"
     "機動性")
    ("기득권"
     "旣得權")
    ("기득권자"
     "旣得權者")
    ("기득권적"
     "旣得權的")
    ("기득권층"
     "旣得權層")
    ("기라성"
     "綺羅星")
    ("기량"
     "器量"
     "技倆"
     "氣量")
    ("기력"
     "氣力")
    ("기로"
     "岐路")
    ("기록"
     "記錄")
    ("기록물"
     "記錄物")
    ("기록부"
     "記錄簿")
    ("기록실"
     "記錄室")
    ("기록적"
     "記錄的")
    ("기록화"
     "記錄畵")
    ("기론"
     "氣論")
    ("기류"
     "氣流")
    ("기린"
     "麒麟")
    ("기린아"
     "麒麟兒")
    ("기마"
     "騎馬")
    ("기마전"
     "騎馬戰")
    ("기만"
     "幾萬"
     "欺瞞")
    ("기만적"
     "欺瞞的")
    ("기만책"
     "欺瞞策")
    ("기말"
     "期末")
    ("기명"
     "器皿")
    ("기모"
     "機謀")
    ("기모비계"
     "奇謀秘計")
    ("기묘"
     "奇妙")
    ("기무"
     "機務")
    ("기무사"
     "機務司")
    ("기물"
     "器物")
    ("기미"
     "幾微"
     "氣味")
    ("기미상합"
     "氣味相合")
    ("기민"
     "機敏"
     "飢民")
    ("기밀"
     "機密")
    ("기밀문서"
     "機密文書")
    ("기반"
     "基盤")
    ("기반암"
     "基盤巖")
    ("기발"
     "奇拔")
    ("기방"
     "妓房")
    ("기법"
     "技法")
    ("기법적"
     "技法的")
    ("기벽"
     "奇癖")
    ("기별"
     "奇別")
    ("기병"
     "起兵")
    ("기복"
     "忌服"
     "祈福"
     "起伏")
    ("기복량"
     "起伏量")
    ("기복성"
     "祈福性")
    ("기본"
     "基本")
    ("기본권"
     "基本權")
    ("기본급"
     "基本給")
    ("기본기"
     "基本技")
    ("기본료"
     "基本料")
    ("기본법"
     "基本法")
    ("기본선"
     "基本線")
    ("기본예절"
     "基本禮節")
    ("기본요금"
     "基本料金")
    ("기본적"
     "基本的")
    ("기본형"
     "基本形")
    ("기부"
     "寄附"
     "肌膚")
    ("기부금"
     "寄附金")
    ("기분"
     "氣分")
    ("기사"
     "技士"
     "技師"
     "棋士"
     "記事"
     "騎士")
    ("기사화"
     "記事化")
    ("기사회생"
     "起死回生")
    ("기산일"
     "起算日")
    ("기산점"
     "起算點")
    ("기삿"
     "記事")
    ("기상"
     "氣像"
     "氣象"
     "起牀")
    ("기상대"
     "氣象臺")
    ("기상도"
     "氣象圖")
    ("기상천외"
     "奇想天外")
    ("기색"
     "氣色")
    ("기색혼절"
     "氣塞昏絶")
    ("기생"
     "妓生"
     "寄生"
     "期生")
    ("기생적"
     "寄生的")
    ("기생충"
     "寄生蟲")
    ("기생충적"
     "寄生蟲的")
    ("기선"
     "機先"
     "汽船")
    ("기설과"
     "機設科")
    ("기성"
     "奇聲"
     "旣成")
    ("기성사실"
     "旣成事實")
    ("기성세대"
     "旣成世代")
    ("기성품"
     "旣成品")
    ("기세"
     "氣勢")
    ("기세도명"
     "欺世盜名")
    ("기세등등"
     "氣勢騰騰")
    ("기세양난"
     "其勢兩難")
    ("기소"
     "起訴")
    ("기소장"
     "起訴狀")
    ("기속"
     "羈束")
    ("기수"
     "旗手"
     "機首")
    ("기숙"
     "寄宿")
    ("기숙사"
     "寄宿舍")
    ("기술"
     "技術"
     "記述")
    ("기술계"
     "技術界")
    ("기술공"
     "技術工")
    ("기술과"
     "技術科")
    ("기술력"
     "技術力")
    ("기술서"
     "技術書")
    ("기술자"
     "技術者")
    ("기술적"
     "技術的"
     "記述的")
    ("기술주의"
     "技術主義")
    ("기술지"
     "記述誌")
    ("기술직"
     "技術職")
    ("기술진"
     "技術陣")
    ("기습"
     "奇襲")
    ("기습당"
     "奇襲當")
    ("기습용"
     "奇襲用")
    ("기습적"
     "奇襲的")
    ("기승"
     "氣勝")
    ("기승전결"
     "起承轉結")
    ("기식"
     "寄食")
    ("기신"
     "氣神")
    ("기실"
     "其實")
    ("기십만"
     "幾十萬")
    ("기아"
     "飢餓")
    ("기아국"
     "飢餓國")
    ("기아선상"
     "饑餓線上")
    ("기아종"
     "基亞種")
    ("기악과"
     "器樂科")
    ("기암괴석"
     "奇巖怪石")
    ("기암절벽"
     "奇巖絶壁")
    ("기압"
     "氣壓")
    ("기약"
     "期約")
    ("기어"
     "期於")
    ("기억"
     "記憶")
    ("기억력"
     "記憶力")
    ("기업"
     "企業"
     "基業")
    ("기업가"
     "企業家")
    ("기업군"
     "企業群")
    ("기업명"
     "企業名")
    ("기업소"
     "企業所")
    ("기업인"
     "企業人")
    ("기업자"
     "企業者")
    ("기업적"
     "企業的")
    ("기업주"
     "企業主")
    ("기업체"
     "企業體")
    ("기업화"
     "企業化")
    ("기여"
     "寄與")
    ("기여보비"
     "寄與補裨")
    ("기염"
     "氣焰")
    ("기염만장"
     "氣焰萬丈")
    ("기예"
     "技藝")
    ("기온"
     "氣溫")
    ("기온차"
     "氣溫差")
    ("기왕"
     "旣往")
    ("기용"
     "起用")
    ("기우"
     "杞憂")
    ("기우제"
     "祈雨祭")
    ("기운"
     "氣運")
    ("기원"
     "棋院"
     "祈願"
     "紀元"
     "起源")
    ("기원론"
     "起源論")
    ("기원설"
     "起源說")
    ("기원전"
     "紀元前")
    ("기원후"
     "紀元後")
    ("기율"
     "紀律")
    ("기이"
     "奇異")
    ("기인"
     "其人"
     "奇人"
     "起因")
    ("기인역"
     "其人役")
    ("기인전"
     "其人田")
    ("기인제"
     "其人制")
    ("기인지우"
     "杞人之憂")
    ("기인취물"
     "欺人取物")
    ("기일"
     "忌日"
     "期日")
    ("기일원론"
     "氣一元論")
    ("기입"
     "記入")
    ("기입장"
     "記入帳")
    ("기자"
     "記者")
    ("기자감식"
     "飢者甘食")
    ("기자단"
     "記者團")
    ("기자상"
     "記者賞")
    ("기자실"
     "記者室")
    ("기자재"
     "機資材")
    ("기자직"
     "記者職")
    ("기장"
     "期長"
     "機長")
    ("기장지무"
     "旣張之舞")
    ("기재"
     "記載")
    ("기저"
     "基底")
    ("기저면"
     "基底面")
    ("기저적"
     "基底的")
    ("기적"
     "奇跡"
     "汽笛")
    ("기적적"
     "奇跡的")
    ("기전"
     "綺典")
    ("기전부장"
     "起電部長")
    ("기전체"
     "紀傳體")
    ("기절"
     "氣絶")
    ("기절초풍"
     "氣絶-風"
     "氣絶­風")
    ("기점"
     "起點")
    ("기정사실"
     "旣定事實")
    ("기정사실화"
     "旣定事實化")
    ("기제"
     "機制")
    ("기조"
     "基調")
    ("기조실장"
     "基調室長")
    ("기조연설"
     "基調演說")
    ("기존"
     "旣存")
    ("기종"
     "機種")
    ("기준"
     "基準")
    ("기준계"
     "基準系")
    ("기준선"
     "基準線")
    ("기준치"
     "基準値")
    ("기중"
     "期中")
    ("기중기"
     "起重機")
    ("기중력"
     "起重力")
    ("기증"
     "寄贈")
    ("기증자"
     "寄贈者")
    ("기지"
     "基地"
     "機智")
    ("기지국"
     "基地局")
    ("기지촌"
     "基地村")
    ("기진"
     "氣盡")
    ("기진맥진"
     "氣盡脈盡")
    ("기진장"
     "寄進狀")
    ("기질"
     "基質"
     "氣質")
    ("기질성"
     "氣質性")
    ("기질적"
     "氣質的")
    ("기차"
     "汽車")
    ("기차간"
     "汽車間")
    ("기차역"
     "汽車驛")
    ("기착지"
     "寄着地")
    ("기찰"
     "譏察")
    ("기찻"
     "汽車")
    ("기천"
     "幾千")
    ("기체"
     "機體"
     "氣體")
    ("기초"
     "基礎"
     "起草")
    ("기초반"
     "基礎班")
    ("기초식품"
     "基礎食品")
    ("기초적"
     "基礎的")
    ("기초화장"
     "基礎化粧")
    ("기총"
     "機銃")
    ("기축"
     "基軸"
     "機軸")
    ("기층"
     "基層")
    ("기층문화"
     "基層文化")
    ("기치"
     "旗幟")
    ("기타"
     "其他")
    ("기탁"
     "寄託")
    ("기탁금"
     "寄託金")
    ("기탄"
     "忌憚")
    ("기특"
     "奇特")
    ("기판"
     "基板")
    ("기포"
     "氣泡")
    ("기포화"
     "氣泡化")
    ("기폭"
     "起爆")
    ("기폭제"
     "起爆劑")
    ("기표소"
     "記票所")
    ("기품"
     "氣品"
     "氣稟")
    ("기풍"
     "氣風")
    ("기풍제"
     "祈豊祭")
    ("기피"
     "忌避")
    ("기피성"
     "忌避性")
    ("기피증"
     "忌避症")
    ("기필"
     "期必")
    ("기하"
     "幾何")
    ("기하급수"
     "幾何級數")
    ("기하급수적"
     "幾何級數的")
    ("기하학"
     "幾何學")
    ("기하학적"
     "幾何學的")
    ("기학"
     "氣學")
    ("기한"
     "期限")
    ("기한부"
     "期限附")
    ("기합"
     "氣合")
    ("기항"
     "寄港")
    ("기항지"
     "寄港地")
    ("기해"
     "氣海")
    ("기행"
     "奇行"
     "紀行")
    ("기행문"
     "紀行文")
    ("기현상"
     "奇現象")
    ("기혈"
     "氣穴")
    ("기형"
     "畸形")
    ("기형아"
     "畸形兒")
    ("기형적"
     "奇形的")
    ("기형화"
     "畸形化")
    ("기호"
     "嗜好"
     "記號")
    ("기호론적"
     "記號論的")
    ("기호물"
     "嗜好物")
    ("기호성"
     "記號性")
    ("기호지세"
     "騎虎之勢")
    ("기호품"
     "嗜好品")
    ("기호학"
     "記號學")
    ("기호학적"
     "記號學的")
    ("기호학파"
     "畿湖學派")
    ("기호화"
     "記號化")
    ("기혼"
     "旣婚")
    ("기혼자"
     "旣婚者")
    ("기화"
     "奇貨"
     "氣化")
    ("기화가거"
     "奇貨可居")
    ("기화신령"
     "氣化神靈")
    ("기화지신"
     "氣化之神")
    ("기회"
     "機會")
    ("기회균등"
     "機會均等")
    ("기회주의"
     "機會主義")
    ("기회주의자"
     "機會主義者")
    ("기회주의적"
     "機會主義的")
    ("기획"
     "企劃")
    ("기획과"
     "企劃課")
    ("기획국"
     "企劃局")
    ("기획국장"
     "企劃局長")
    ("기획단"
     "企劃團")
    ("기획력"
     "企劃力")
    ("기획사"
     "企劃社")
    ("기획서"
     "企劃書")
    ("기획실"
     "企劃室")
    ("기획실장"
     "企劃室長")
    ("기획원"
     "企劃院")
    ("기획자"
     "企劃者")
    ("기후"
     "氣候")
    ("기후구"
     "氣候區")
    ("기후적"
     "氣候的")
    ("기후학자"
     "氣候學者")
    ("긴"
     ("緊" . "굳게 얽힐 긴"))
    ("긴급"
     "緊急")
    ("긴급회의"
     "緊急會議")
    ("긴밀"
     "緊密")
    ("긴밀감"
     "緊密感")
    ("긴밀화"
     "緊密化")
    ("긴박"
     "緊迫")
    ("긴박감"
     "緊迫感")
    ("긴박성"
     "緊迫性")
    ("긴요"
     "緊要")
    ("긴요성"
     "緊要性")
    ("긴장"
     "緊張")
    ("긴장감"
     "緊張感")
    ("긴장미"
     "緊張味")
    ("긴장성"
     "緊張性")
    ("긴축"
     "緊縮")
    ("길"
     ("佶" . "건장할 길")
     ("吉" . "길할 길")
     ("拮" . "일할 길")
     ("桔" . "도라지 길")
     ("姞" . "성 길")
     ("蛣" . "장구벌레 길")
     "鴶")
    ("길괘"
     "吉卦")
    ("길기"
     "吉氣")
    ("길룡"
     "吉龍")
    ("길복"
     "吉福")
    ("길상"
     "吉相")
    ("길상사"
     "吉祥紗")
    ("길운"
     "吉運")
    ("길인"
     "吉人")
    ("길일"
     "吉日")
    ("길조"
     "吉兆")
    ("길지"
     "吉地")
    ("길지성"
     "吉地性")
    ("길흉"
     "吉凶")
    ("길흉사"
     "吉凶事")
    ("길흉화복"
     "吉凶禍福")
    ("김"
     ("金" . "사람의 성 김"))
    ("김포공항"
     "金浦空港")
    ("꽃향유"
     "香유@")
    ("끝"
     "唜")
    ("끽"
     ("喫" . "마실 끽"))
    ("끽긴"
     "喫緊")
    ("끽연"
     "喫煙")
    ("나"
     ("儺" . "역귀 쫓을 나")
     ("娜" . "아리따울 나")
     ("懦" . "나약할 나")
     ("拏" . "붙잡을 나")
     ("拿" . "붙잡을 나")
     ("那" . "어찌 나")
     ("喇" . "나팔 라, 라마교 라")
     ("奈" . "어찌 나")
     ("懶" . "게으를 나")
     ("癩" . "약물 중독 나")
     ("羅" . "새 그물 나")
     ("蘿" . "소나무겨우살이 나")
     ("螺" . "소라 나")
     ("裸" . "벌거벗을 라, 털 없는 벌레 라")
     ("邏" . "돌 나")
     ("挐" . "붙잡을 나")
     ("挪" . "옮길 나")
     ("梛" . "나무 이름 나")
     ("糥" . "糯와 同字")
     ("糯" . "찰벼 나"))
    ("나견"
     "羅絹")
    ("나락"
     "那落")
    ("나말"
     "羅末")
    ("나발"
     "喇叭"
     "喇叭")
    ("나병"
     "癩病")
    ("나사"
     "螺絲"
     "羅紗"
     "螺絲")
    ("나선"
     "螺旋")
    ("나선적"
     "螺旋的")
    ("나선형"
     "螺旋形")
    ("나신"
     "裸身")
    ("나약"
     "懦弱")
    ("나열"
     "羅列")
    ("나왕"
     "羅王")
    ("나전"
     "螺鈿")
    ("나체"
     "裸體")
    ("나체화"
     "裸體畵")
    ("나침반"
     "羅針盤")
    ("나태"
     "懶怠")
    ("나태심"
     "懶怠心")
    ("나팔"
     "喇叭"
     "喇叭")
    ("나팔관"
     "喇叭管")
    ("나팔수"
     "喇叭手")
    ("낙"
     ("諾" . "대답할 낙")
     ("樂" . "즐길 낙")
     ("洛" . "강 이름 낙")
     ("烙" . "지질 낙")
     ("珞" . "구슬 목걸이 낙")
     ("落" . "떨어질 낙")
     ("酪" . "타락 낙")
     ("駱" . "낙타 낙"))
    ("낙관"
     "樂觀")
    ("낙관론"
     "樂觀論")
    ("낙관성"
     "樂觀性")
    ("낙관적"
     "樂觀的")
    ("낙관주의"
     "樂觀主義")
    ("낙극애생"
     "樂極哀生")
    ("낙농"
     "酪農")
    ("낙농업"
     "酪農業")
    ("낙담"
     "落膽")
    ("낙도"
     "落島")
    ("낙락장송"
     "落落長松"
     "落落長松")
    ("낙망"
     "落望")
    ("낙미지액"
     "落眉之厄")
    ("낙방"
     "落榜")
    ("낙백"
     "落魄")
    ("낙상"
     "落傷")
    ("낙서"
     "落書")
    ("낙서장"
     "落書帳")
    ("낙선"
     "落選")
    ("낙선자"
     "落選者")
    ("낙성"
     "落成")
    ("낙승"
     "樂勝")
    ("낙심"
     "落心")
    ("낙심천만"
     "落心千萬")
    ("낙양지가귀"
     "洛陽紙價貴")
    ("낙역부절"
     "絡繹不絶")
    ("낙엽"
     "落葉")
    ("낙엽송"
     "落葉松")
    ("낙오"
     "落伍")
    ("낙오자"
     "落伍者")
    ("낙원"
     "樂園")
    ("낙월옥량"
     "落月屋梁")
    ("낙인"
     "烙印")
    ("낙장"
     "落張")
    ("낙장불입"
     "落張不入")
    ("낙점"
     "落點")
    ("낙점설"
     "落點說")
    ("낙제"
     "落第")
    ("낙제점"
     "落第點")
    ("낙조"
     "落照")
    ("낙조어"
     "樂釣魚")
    ("낙차"
     "落差")
    ("낙착"
     "落着")
    ("낙찰"
     "落札")
    ("낙찰자"
     "落札者")
    ("낙천적"
     "樂天的")
    ("낙타"
     "駱駝")
    ("낙타초"
     "駱駝草")
    ("낙태"
     "落胎")
    ("낙태죄"
     "落胎罪")
    ("낙토"
     "樂土")
    ("낙폭"
     "落幅")
    ("낙하"
     "落下")
    ("낙하산"
     "落下傘")
    ("낙하산병"
     "落下傘兵")
    ("낙하산식"
     "落下傘式")
    ("낙향"
     "落鄕")
    ("낙화"
     "落花")
    ("낙화생"
     "落花生")
    ("낙화유수"
     "落花流水")
    ("낙후"
     "落後")
    ("난"
     ("暖" . "따뜻할 난")
     ("煖" . "따뜻할 난")
     ("難" . "어려울 난")
     ("亂" . "어지러울 난")
     ("卵" . "알 난")
     ("欄" . "난간 난")
     ("爛" . "문드러질 난")
     ("蘭" . "난초 난")
     ("鸞" . "난새 난")
     ("偄" . "언약할 난")
     ("煗" . "터울 난")
     ("赧" . "얼굴 붉힐 난")
     ("餪" . "풀보기 잔치 난"))
    ("난간"
     "欄干")
    ("난감"
     "難堪")
    ("난경"
     "難境")
    ("난공불락"
     "難攻不落")
    ("난관"
     "難關"
     "卵管")
    ("난국"
     "亂局"
     "難局")
    ("난기류"
     "亂氣流")
    ("난대성"
     "暖帶性")
    ("난도"
     "亂刀"
     "暖度")
    ("난도질"
     "亂刀­")
    ("난동"
     "亂動"
     "暖冬")
    ("난로"
     "暖爐")
    ("난롯"
     "暖爐")
    ("난류"
     "暖流"
     "亂流")
    ("난륜"
     "亂倫")
    ("난리"
     "亂離"
     "亂離")
    ("난립"
     "亂立")
    ("난립상"
     "亂立相")
    ("난만"
     "爛漫")
    ("난맥상"
     "亂脈相")
    ("난무"
     "亂舞")
    ("난문제"
     "難問題")
    ("난민"
     "難民")
    ("난민촌"
     "難民村")
    ("난방"
     "暖房")
    ("난방법"
     "暖房法")
    ("난방비"
     "暖房費")
    ("난비"
     "亂飛")
    ("난산"
     "難産")
    ("난삽"
     "難澁")
    ("난상"
     "卵狀")
    ("난상토의"
     "爛商討議")
    ("난색"
     "暖色"
     "難色")
    ("난생"
     "卵生")
    ("난세"
     "亂世")
    ("난소"
     "卵巢")
    ("난숙"
     "爛熟")
    ("난시청"
     "難視聽")
    ("난신적자"
     "亂臣賊子")
    ("난연성"
     "難燃性")
    ("난이도"
     "難易度")
    ("난입"
     "亂入")
    ("난자"
     "亂刺"
     "卵子")
    ("난잡"
     "亂雜")
    ("난장"
     "亂場")
    ("난적"
     "難敵")
    ("난점"
     "難點")
    ("난제"
     "難題")
    ("난처"
     "難處")
    ("난초"
     "蘭草"
     "蘭草")
    ("난타"
     "亂打")
    ("난타전"
     "亂打戰")
    ("난투극"
     "亂鬪劇")
    ("난파"
     "難破")
    ("난파선"
     "難破船")
    ("난폭"
     "亂暴"
     "亂暴")
    ("난항"
     "難航")
    ("난해"
     "難解")
    ("난행"
     "亂行")
    ("난형난제"
     "難兄難弟")
    ("날"
     ("捏" . "이길 날")
     ("捺" . "누를 날")
     ("涅" . "앙금 흙 날"))
    ("날염"
     "捺染")
    ("날인"
     "捺印")
    ("날조"
     "捏造")
    ("남"
     ("南" . "남녘 남")
     ("枏" . "녹나무 남")
     ("楠" . "녹나무 남")
     ("湳" . "강 이름 남")
     ("男" . "사내 남")
     ("嵐" . "남기 남")
     ("濫" . "퍼질 남")
     ("藍" . "쪽 남")
     ("襤" . "누더기 남")
     ("喃" . "재잘거릴 남")
     ("柟" . "枏의 俗字"))
    ("남가일몽"
     "南柯一夢")
    ("남고부"
     "男高部")
    ("남고생"
     "男高生")
    ("남국"
     "南國")
    ("남국적"
     "南國的")
    ("남귤북지"
     "南橘北枳")
    ("남근"
     "男根")
    ("남기북두"
     "南箕北斗")
    ("남남동"
     "南南東")
    ("남남북녀"
     "南男北女")
    ("남남서"
     "南南西")
    ("남녀"
     "男女")
    ("남녀관"
     "男女觀")
    ("남녀노소"
     "男女老少")
    ("남녀동등"
     "男女同等")
    ("남녀별"
     "男女別")
    ("남녀상열지사"
     "男女相悅之詞")
    ("남녀유별"
     "男女有別")
    ("남녀칠세부동석"
     "男女七歲不同席")
    ("남녀평등"
     "男女平等")
    ("남녀평등관"
     "男女平等觀")
    ("남노인"
     "男老人")
    ("남단"
     "南端")
    ("남대"
     "男大")
    ("남대문"
     "南大門")
    ("남대문시장"
     "南大門市場")
    ("남대문입납"
     "南大門入納")
    ("남대부"
     "男大部")
    ("남도"
     "南道")
    ("남동"
     "南東")
    ("남동류"
     "南東流")
    ("남동부"
     "南東部")
    ("남록"
     "南麓")
    ("남루"
     "襤褸")
    ("남류"
     "南流")
    ("남만북적"
     "南蠻北狄")
    ("남매"
     "男妹")
    ("남매간"
     "男妹間")
    ("남면지존"
     "南面之尊")
    ("남문"
     "南門")
    ("남미"
     "南美")
    ("남반구"
     "南半球")
    ("남발"
     "濫發")
    ("남방"
     "南方")
    ("남벌"
     "濫伐")
    ("남부"
     "南部")
    ("남부권"
     "南部圈")
    ("남북"
     "南北")
    ("남북국"
     "南北國")
    ("남북국론"
     "南北國論")
    ("남북문제"
     "南北問題")
    ("남북조"
     "南北朝")
    ("남북통일"
     "南北統一")
    ("남산"
     "南山")
    ("남상"
     "男相"
     "濫觴")
    ("남색"
     "藍色")
    ("남서"
     "南西")
    ("남서부"
     "南西部")
    ("남선북마"
     "南船北馬")
    ("남성"
     "男性"
     "男聲")
    ("남성기"
     "南性器")
    ("남성미"
     "男性美")
    ("남성복"
     "男性服")
    ("남성적"
     "男性的")
    ("남성화"
     "男性化")
    ("남순"
     "南巡")
    ("남아"
     "男兒")
    ("남안"
     "南岸")
    ("남왜북로"
     "南倭北虜")
    ("남용"
     "濫用")
    ("남용죄"
     "濫用罪")
    ("남우"
     "男優")
    ("남자"
     "男子")
    ("남자관계"
     "男子關係")
    ("남자부"
     "男子部")
    ("남작"
     "男爵")
    ("남전북답"
     "南田北畓")
    ("남정"
     "男丁")
    ("남조"
     "南朝")
    ("남존여비"
     "男尊女卑")
    ("남좌여우"
     "男左女右")
    ("남주작"
     "南朱雀")
    ("남중일색"
     "男中一色")
    ("남진"
     "南進")
    ("남침"
     "南侵")
    ("남탕"
     "男湯")
    ("남파"
     "南派")
    ("남편"
     "男便")
    ("남풍"
     "南風")
    ("남하"
     "南下")
    ("남학교"
     "男學校")
    ("남학생"
     "男學生")
    ("남해안"
     "南海岸")
    ("남행"
     "南行")
    ("남향"
     "南向")
    ("남획"
     "濫獲")
    ("납"
     ("納" . "바칠 납")
     ("衲" . "기울 납")
     ("拉" . "꺽을 납")
     ("臘" . "납향 납")
     ("蠟" . "밀 납"))
    ("납기"
     "納期")
    ("납득"
     "納得")
    ("납막"
     "臘膜")
    ("납부"
     "納付")
    ("납북"
     "拉北")
    ("납북당"
     "拉北當")
    ("납세"
     "納稅")
    ("납세자"
     "納稅者")
    ("납월"
     "臘月")
    ("납입"
     "納入")
    ("납입금"
     "納入金")
    ("납자"
     "衲子")
    ("납치"
     "拉致")
    ("납치당"
     "拉致當")
    ("납치범"
     "拉致犯")
    ("납품"
     "納品")
    ("납향"
     "臘享")
    ("낭"
     ("囊" . "주머니 낭")
     ("娘" . "아가씨 낭")
     ("廊" . "복도 낭")
     ("朗" . "밝을 낭")
     ("浪" . "물결 낭")
     ("狼" . "이리 낭")
     ("郎" . "사나이 낭")
     ("曩" . "접때 낭"))
    ("낭가"
     "娘家")
    ("낭독"
     "朗讀")
    ("낭독회"
     "朗讀會")
    ("낭랑"
     "朗朗")
    ("낭만"
     "浪漫")
    ("낭만성"
     "浪漫性")
    ("낭만적"
     "浪漫的")
    ("낭만주의"
     "浪漫主義")
    ("낭만주의자"
     "浪漫主義者")
    ("낭만주의적"
     "浪漫主義的")
    ("낭만파"
     "浪漫派")
    ("낭불"
     "郞佛")
    ("낭비"
     "浪費")
    ("낭비벽"
     "浪費癖")
    ("낭비적"
     "浪費的")
    ("낭설"
     "浪說")
    ("낭송"
     "朗誦")
    ("낭송회"
     "朗誦會")
    ("낭인"
     "浪人")
    ("낭자"
     "娘子"
     "狼藉")
    ("낭종"
     "囊腫")
    ("낭중지추"
     "囊中之錐")
    ("낭중취물"
     "囊中取物")
    ("낭패"
     "狼狽"
     "狼狽")
    ("낭패감"
     "狼狽感")
    ("내"
     ("乃" . "이에 내")
     ("內" . "안 내")
     ("奈" . "어찌 내")
     ("柰" . "능금나무 내")
     ("耐" . "견딜 내")
     ("來" . "올 내")
     ("匂" . "향내 내")
     ("奶" . "젖 내")
     ("嬭" . "젖 내")
     ("迺" . "이에 내")
     ("鼐" . "가마솥 내"))
    ("내각"
     "內角"
     "內閣")
    ("내각제"
     "內閣制")
    ("내공"
     "內攻")
    ("내과"
     "內科")
    ("내구"
     "耐久")
    ("내구성"
     "耐久性")
    ("내국"
     "內國")
    ("내국세"
     "內國稅")
    ("내국인"
     "內國人")
    ("내규"
     "內規")
    ("내년"
     "來年")
    ("내년도"
     "來年度")
    ("내당"
     "內堂")
    ("내락"
     "內諾")
    ("내란"
     "內亂")
    ("내력"
     "來歷")
    ("내력담"
     "來歷談")
    ("내륙"
     "內陸")
    ("내막"
     "內幕"
     "內膜")
    ("내막증"
     "內膜症")
    ("내면"
     "內面")
    ("내면세계"
     "內面世界")
    ("내면적"
     "內面的")
    ("내면화"
     "內面化")
    ("내무"
     "內務")
    ("내무과"
     "內務課")
    ("내무과장"
     "內務課長")
    ("내무반"
     "內務班")
    ("내무실"
     "內務室")
    ("내밀"
     "內密")
    ("내방"
     "內房")
    ("내방자"
     "來訪者")
    ("내벽"
     "內壁")
    ("내복"
     "內服")
    ("내복약"
     "內服藥")
    ("내부"
     "內部")
    ("내부자"
     "內部者")
    ("내부적"
     "內部的")
    ("내분"
     "內紛")
    ("내분비"
     "內分泌")
    ("내사"
     "內査")
    ("내색"
     "­色")
    ("내성"
     "內城"
     "內聖"
     "耐性")
    ("내성외왕"
     "內聖外王")
    ("내성적"
     "內省的")
    ("내성종"
     "耐性種")
    ("내세"
     "來世")
    ("내세관"
     "來世觀")
    ("내수"
     "內水"
     "內需")
    ("내수도문"
     "內修道文")
    ("내수성"
     "耐水性")
    ("내습"
     "來襲")
    ("내시경"
     "內視鏡")
    ("내신"
     "內申")
    ("내실"
     "內室"
     "內實")
    ("내실화"
     "內實化")
    ("내심"
     "內心")
    ("내압"
     "耐壓")
    ("내야진"
     "內野陣")
    ("내역"
     "內譯")
    ("내역서"
     "內譯書")
    ("내연"
     "內燃"
     "內緣")
    ("내열"
     "耐熱")
    ("내왕"
     "來往")
    ("내외"
     "內外")
    ("내외국"
     "內外國")
    ("내외신"
     "內外信")
    ("내용"
     "內容")
    ("내용물"
     "內容物")
    ("내용성"
     "內用性")
    ("내용적"
     "內容的")
    ("내우"
     "內憂")
    ("내우외환"
     "內憂外患")
    ("내원"
     "來院")
    ("내유외강"
     "內柔外剛")
    ("내의"
     "內衣")
    ("내의적"
     "內衣的")
    ("내인가"
     "內認可")
    ("내일"
     "來日")
    ("내자"
     "內子")
    ("내장"
     "內臟"
     "內藏"
     "內裝")
    ("내장객"
     "來場客")
    ("내장재"
     "內裝材")
    ("내장형"
     "內藏型")
    ("내재"
     "內在")
    ("내재적"
     "內在的")
    ("내재화"
     "內在化")
    ("내적"
     "內的")
    ("내전"
     "內戰"
     "內殿")
    ("내전근"
     "內轉筋")
    ("내전적"
     "內戰的")
    ("내정"
     "內定"
     "內廷"
     "內政")
    ("내정설"
     "內定說")
    ("내정자"
     "內定者")
    ("내조"
     "內助")
    ("내주"
     "來週")
    ("내지"
     "乃至")
    ("내칙"
     "內則")
    ("내통"
     "內通")
    ("내투"
     "來投")
    ("내편"
     "內篇")
    ("내포"
     "內包")
    ("내핍"
     "耐乏")
    ("내한"
     "來韓")
    ("내항"
     "內港")
    ("내향"
     "內向")
    ("내향적"
     "內向的")
    ("내후년"
     "來後年")
    ("내훈서"
     "內訓書")
    ("냉"
     ("冷" . "차가울 냉"))
    ("냉각"
     "冷却")
    ("냉각수"
     "冷却水")
    ("냉기"
     "冷氣")
    ("냉기류"
     "冷氣流")
    ("냉난방"
     "冷暖房")
    ("냉담"
     "冷淡")
    ("냉대"
     "冷待"
     "冷帶")
    ("냉동"
     "冷凍")
    ("냉동량"
     "冷凍量")
    ("냉동선"
     "冷凍船")
    ("냉동실"
     "冷凍室")
    ("냉랭"
     "冷冷")
    ("냉량"
     "冷凉")
    ("냉매"
     "冷媒")
    ("냉면"
     "冷麵")
    ("냉방"
     "冷房")
    ("냉방병"
     "冷房病")
    ("냉병"
     "冷病")
    ("냉소"
     "冷笑")
    ("냉소적"
     "冷笑的")
    ("냉소주의"
     "冷笑主義")
    ("냉수"
     "冷水")
    ("냉습"
     "冷濕")
    ("냉식"
     "冷食")
    ("냉엄"
     "冷嚴")
    ("냉연"
     "冷延")
    ("냉온방기"
     "冷溫房機")
    ("냉온풍기"
     "冷溫風機")
    ("냉우유"
     "冷牛乳")
    ("냉장"
     "冷藏")
    ("냉장고"
     "冷藏庫")
    ("냉전"
     "冷戰")
    ("냉정"
     "冷情"
     "冷靜")
    ("냉증"
     "冷症")
    ("냉채"
     "冷菜")
    ("냉철"
     "冷徹")
    ("냉탕"
     "冷湯")
    ("냉탕식"
     "冷湯式")
    ("냉해"
     "冷害")
    ("냉혹"
     "冷酷")
    ("냥"
     "娘"
     "孃")
    ("녀"
     ("女" . "계집 녀"))
    ("녁"
     ("惄" . "마음 졸일 녁"))
    ("년"
     ("年" . "해 년")
     ("撚" . "비틀 년")
     ("秊" . "年의 本字")
     ("碾" . "맷돌 년"))
    ("년기"
     "年期")
    ("년대"
     "年代")
    ("년대생"
     "年大生")
    ("년대적"
     "年代的")
    ("년도"
     "年度")
    ("년분"
     "年分")
    ("년사"
     "年史")
    ("년산"
     "年産")
    ("년생"
     "年生")
    ("년식"
     "年式")
    ("년제"
     "年制"
     "年製")
    ("년판"
     "年板")
    ("년형"
     "年形")
    ("녈"
     ("涅" . "죽을 녈"))
    ("념"
     ("念" . "생각 념")
     ("恬" . "편안할 념")
     ("捻" . "비틀 념")
     "鮎")
    ("녑"
     "鑷")
    ("녕"
     ("寗" . "편안할 녕")
     ("寧" . "편안할 녕")
     "獰"
     ("佞" . "재주 녕")
     ("儜" . "고달플 녕")
     ("嚀" . "정녕할 녕")
     ("濘" . "진흙 녕"))
    ("녜"
     "祢"
     "禰")
    ("노"
     ("努" . "힘쓸 노")
     ("奴" . "종 노")
     ("帑" . "처자식 노")
     ("弩" . "쇠뇌(여러 개의 화살이나 돌을 잇따라 쏘게 된 큰 활) 노")
     ("怒" . "성낼 노")
     ("瑙" . "마노 노")
     ("駑" . "둔할 노")
     ("勞" . "수고할 노")
     ("擄" . "사로잡을 노")
     ("櫓" . "큰 방패 노")
     ("爐" . "화로 노")
     ("盧" . "밥그릇 노")
     ("老" . "늙을 노")
     ("蘆" . "갈대 노")
     ("虜" . "포로 노")
     ("路" . "길 노")
     ("露" . "이슬 노")
     ("魯" . "미련할 노")
     ("鷺" . "해오라기 노")
     ("呶" . "들랠 노")
     ("孥" . "자식 노")
     ("峱" . "산이름 노")
     ("猱" . "못할 노")
     ("笯" . "새장 노")
     ("臑" . "팔마디 노"))
    ("노거수"
     "老巨樹")
    ("노계"
     "老鷄")
    ("노고"
     "勞苦")
    ("노곤"
     "勞困")
    ("노골적"
     "露骨的")
    ("노골화"
     "露骨化")
    ("노교수"
     "老敎授")
    ("노구"
     "老軀")
    ("노기"
     "怒氣")
    ("노기등등"
     "怒氣騰騰")
    ("노년"
     "老年")
    ("노년기"
     "老年期")
    ("노년자"
     "老年者")
    ("노년층"
     "老年層")
    ("노대감"
     "老大監")
    ("노도"
     "怒濤")
    ("노동"
     "勞動"
     "勞動")
    ("노동계"
     "勞動界")
    ("노동관"
     "勞動觀")
    ("노동국"
     "勞動局")
    ("노동권"
     "勞動圈"
     "勞動權")
    ("노동량"
     "勞動量")
    ("노동력"
     "勞動力")
    ("노동요"
     "勞動謠")
    ("노동일"
     "勞動日")
    ("노동자"
     "勞動者")
    ("노동자회"
     "勞動者會")
    ("노동장"
     "勞動場")
    ("노동절"
     "勞動節")
    ("노동조합"
     "勞動組合")
    ("노동조합주의"
     "勞動組合主義")
    ("노략"
     "擄掠")
    ("노략질당"
     "擄掠-當")
    ("노력"
     "努力"
     "勞力")
    ("노력비"
     "努力費")
    ("노련"
     "老鍊")
    ("노령"
     "老齡")
    ("노령자"
     "老齡者")
    ("노령층"
     "老齡層")
    ("노령화"
     "老齡化")
    ("노마지지"
     "老馬之智")
    ("노망"
     "老妄")
    ("노망기"
     "老妄氣")
    ("노면"
     "路面")
    ("노모"
     "老母")
    ("노무"
     "勞務")
    ("노무비"
     "勞務費")
    ("노무사"
     "勞務士")
    ("노무직"
     "勞務職")
    ("노문학"
     "露文學")
    ("노문학계"
     "露文學界")
    ("노복"
     "奴僕")
    ("노부모"
     "老父母")
    ("노부부"
     "老夫婦")
    ("노부인"
     "老婦人")
    ("노비"
     "奴婢")
    ("노사"
     "老死"
     "勞使")
    ("노사정"
     "勞使政")
    ("노산"
     "老産")
    ("노상"
     "路上")
    ("노상강도"
     "路上强盜")
    ("노생지몽"
     "盧生之夢")
    ("노선"
     "路線")
    ("노소"
     "老少")
    ("노송"
     "老松")
    ("노쇠"
     "老衰")
    ("노수"
     "路需")
    ("노숙"
     "露宿")
    ("노숙자"
     "露宿者")
    ("노시인"
     "老詩人")
    ("노신사"
     "老紳士")
    ("노심초사"
     "勞心焦思"
     "勞心焦思")
    ("노약자"
     "老弱者")
    ("노역"
     "勞役")
    ("노예"
     "奴隸")
    ("노예군"
     "奴隸軍")
    ("노예론자"
     "奴隸論者")
    ("노예적"
     "奴隸的")
    ("노예제"
     "奴隸制")
    ("노예제론자"
     "奴隸制論者")
    ("노예제설"
     "奴隸制說")
    ("노예제적"
     "奴隸制的")
    ("노예주"
     "奴隸主")
    ("노예화"
     "奴隸化")
    ("노운전기사"
     "老運轉技士")
    ("노인"
     "老人")
    ("노인장"
     "老人丈")
    ("노인정"
     "老人亭")
    ("노인촌"
     "老人村")
    ("노인층"
     "老人層")
    ("노인회"
     "老人會")
    ("노임"
     "勞賃")
    ("노자"
     "勞資"
     "路資")
    ("노작"
     "勞作")
    ("노잣"
     "路資")
    ("노장"
     "老莊"
     "老將"
     "老長")
    ("노점"
     "露店")
    ("노점상"
     "露店商")
    ("노정"
     "路程")
    ("노제"
     "路祭")
    ("노조"
     "勞組")
    ("노조원"
     "勞組員")
    ("노처녀"
     "老處女")
    ("노천"
     "露天")
    ("노총각"
     "老總角")
    ("노추"
     "老醜")
    ("노출"
     "露出")
    ("노출미"
     "露出美")
    ("노출형"
     "露出型")
    ("노파"
     "老婆")
    ("노폐물"
     "老廢物")
    ("노포"
     "老鋪")
    ("노폭"
     "路幅")
    ("노형"
     "老兄")
    ("노화"
     "老化")
    ("노회"
     "老獪")
    ("노후"
     "老後"
     "老朽")
    ("노후관"
     "老朽管")
    ("녹"
     ("碌" . "푸른 빛 녹")
     ("祿" . "행복 녹")
     ("綠" . "초록빛 녹")
     ("菉" . "조개풀 녹")
     ("錄" . "기록할 녹")
     ("鹿" . "사슴 녹"))
    ("녹각"
     "鹿角")
    ("녹각교탕"
     "鹿角膠湯")
    ("녹과전"
     "祿科田")
    ("녹금"
     "綠錦")
    ("녹내장"
     "綠內障")
    ("녹두"
     "綠豆")
    ("녹라"
     "綠羅")
    ("녹록"
     "碌碌")
    ("녹말"
     "綠末"
     "綠末")
    ("녹말기"
     "綠末機")
    ("녹봉"
     "祿俸")
    ("녹비왈자"
     "鹿皮曰字")
    ("녹색"
     "綠色")
    ("녹색등"
     "綠色燈")
    ("녹수"
     "綠水")
    ("녹양방초"
     "綠楊芳草")
    ("녹용"
     "鹿茸")
    ("녹원"
     "鹿苑")
    ("녹음"
     "綠陰"
     "錄音")
    ("녹음기"
     "錄音器")
    ("녹읍"
     "祿邑")
    ("녹읍민"
     "祿邑民")
    ("녹읍제"
     "祿邑制")
    ("녹의홍상"
     "綠衣紅裳")
    ("녹즙"
     "綠汁")
    ("녹즙기"
     "綠汁機")
    ("녹지"
     "綠地")
    ("녹지과"
     "綠地課")
    ("녹차"
     "綠茶")
    ("녹청색"
     "綠靑色")
    ("녹화"
     "綠化"
     "錄畵")
    ("녹화장"
     "錄畵場")
    ("녹황색"
     "綠黃色")
    ("녹회색"
     "綠灰色")
    ("논"
     "嫩"
     ("論" . "말할 논"))
    ("논거"
     "論據")
    ("논고"
     "論告")
    ("논고문"
     "論告文")
    ("논공행상"
     "論功行賞")
    ("논구"
     "論究")
    ("논난"
     "論難")
    ("논단"
     "論壇")
    ("논란"
     "論難"
     "論難")
    ("논리"
     "論理")
    ("논리성"
     "論理性")
    ("논리적"
     "論理的")
    ("논리학"
     "論理學")
    ("논문"
     "論文")
    ("논문성"
     "論文性")
    ("논문적"
     "論文的")
    ("논문집"
     "論文集")
    ("논박"
     "論駁")
    ("논법"
     "論法")
    ("논설"
     "論說")
    ("논설문"
     "論說文")
    ("논설위원"
     "論說委員")
    ("논술"
     "論述")
    ("논외"
     "論外")
    ("논의"
     "論意"
     "論議")
    ("논자"
     "論者")
    ("논쟁"
     "論爭")
    ("논쟁적"
     "論爭的")
    ("논쟁점"
     "論爭點")
    ("논저"
     "論著")
    ("논전"
     "論戰")
    ("논점"
     "論點")
    ("논제"
     "論題")
    ("논조"
     "論調")
    ("논증"
     "論證")
    ("논지"
     "論之"
     "論旨")
    ("논파"
     "論破")
    ("논평"
     "論評")
    ("농"
     ("濃" . "짙을 농")
     ("膿" . "고름 농")
     ("農" . "농사 농")
     ("壟" . "밭두둑 농")
     ("弄" . "희롱할 농")
     ("籠" . "대그릇 농")
     ("聾" . "귀머거리 농")
     ("儂" . "나 농")
     ("噥" . "달게 먹을 농")
     ("穠" . "후한 제사 농")
     ("醲" . "텁텁한 술 농"))
    ("농가"
     "農家")
    ("농가성진"
     "弄假成眞")
    ("농간"
     "弄奸")
    ("농경"
     "農耕")
    ("농경문화"
     "農耕文化")
    ("농경민족"
     "農耕民族")
    ("농경적"
     "農耕的")
    ("농경제"
     "農耕制")
    ("농경지"
     "農耕地")
    ("농고"
     "農高")
    ("농공"
     "農工")
    ("농과"
     "農科")
    ("농구"
     "籠球"
     "籠球")
    ("농군"
     "農軍")
    ("농기계"
     "農機械")
    ("농기구"
     "農器具")
    ("농노"
     "農奴")
    ("농노적"
     "農奴的")
    ("농노제"
     "農奴制")
    ("농노제설"
     "農奴制說")
    ("농노제적"
     "農奴制的")
    ("농단"
     "壟斷")
    ("농담"
     "弄談"
     "濃淡")
    ("농대"
     "農大")
    ("농도"
     "濃度")
    ("농락"
     "籠絡")
    ("농량"
     "農糧")
    ("농림"
     "農林")
    ("농막"
     "農幕")
    ("농목"
     "農牧")
    ("농목업"
     "農牧業")
    ("농묵"
     "濃墨")
    ("농민"
     "農民")
    ("농민극"
     "農民劇")
    ("농민시장"
     "農民市場")
    ("농민층"
     "農民層")
    ("농민회"
     "農民會")
    ("농민회원"
     "農民會員")
    ("농번기"
     "農繁期")
    ("농법"
     "農法")
    ("농본"
     "農本")
    ("농부"
     "農夫")
    ("농사"
     "農事")
    ("농사법"
     "農事法")
    ("농사일"
     "農事­")
    ("농산물"
     "農産物")
    ("농산품"
     "農産品")
    ("농삿"
     "農事")
    ("농성"
     "籠城")
    ("농성장"
     "籠城場")
    ("농수산"
     "農水産")
    ("농수산물"
     "農水産物")
    ("농아"
     "聾啞"
     "聾兒")
    ("농악"
     "農樂")
    ("농악대"
     "農樂隊")
    ("농약"
     "農藥")
    ("농어가"
     "農漁家")
    ("농어민"
     "農漁民")
    ("농어촌"
     "農漁村")
    ("농업"
     "農業")
    ("농업국"
     "農業國")
    ("농업용수"
     "農業用水")
    ("농업자"
     "農業者")
    ("농와지경"
     "弄瓦之慶")
    ("농외소득"
     "農外所得")
    ("농요"
     "農謠")
    ("농우"
     "農牛")
    ("농원"
     "農園")
    ("농자"
     "農者")
    ("농자재"
     "農資材")
    ("농작물"
     "農作物")
    ("농작업"
     "農作業")
    ("농잠"
     "農蠶")
    ("농장"
     "農場"
     "農莊")
    ("농장주"
     "農場主")
    ("농장지경"
     "弄璋之慶")
    ("농정"
     "農政")
    ("농조연운"
     "籠鳥戀雲")
    ("농주"
     "農酒")
    ("농지"
     "農地")
    ("농채"
     "濃彩")
    ("농촌"
     "農村")
    ("농축"
     "濃縮")
    ("농축산물"
     "農畜産物")
    ("농토"
     "農土")
    ("농한기"
     "農閑期")
    ("농호"
     "農戶")
    ("농활"
     "農活")
    ("뇌"
     ("惱" . "괴로워할 뇌")
     ("腦" . "머리 뇌")
     ("牢" . "가축우리 뇌")
     ("磊" . "돌이 많이 쌓인 모양 뇌")
     ("賂" . "뇌물 뇌")
     ("雷" . "우뢰 뇌")
     ("餒" . "굶길 뇌")
     "餧")
    ("뇌과"
     "腦科")
    ("뇌관"
     "雷管")
    ("뇌대장소"
     "腦大腸小")
    ("뇌리"
     "腦裏")
    ("뇌물"
     "賂物")
    ("뇌물성"
     "賂物性")
    ("뇌물죄"
     "賂物罪")
    ("뇌병원"
     "腦病院")
    ("뇌빈혈"
     "腦貧血")
    ("뇌사"
     "腦死")
    ("뇌사자"
     "腦死者")
    ("뇌성"
     "腦性"
     "雷聲")
    ("뇌성벽력"
     "雷聲霹靂")
    ("뇌세포"
     "腦細胞")
    ("뇌쇄"
     "惱殺")
    ("뇌수"
     "腦髓")
    ("뇌신경"
     "腦神經")
    ("뇌신경외과"
     "腦神經外科")
    ("뇌염"
     "腦炎")
    ("뇌졸중"
     "腦卒中")
    ("뇌종양"
     "腦腫瘍")
    ("뇌출혈"
     "腦出血")
    ("뇌파"
     "腦波")
    ("뇌하수체"
     "腦下垂體")
    ("뇨"
     ("尿" . "오줌 뇨")
     "撓"
     "橈"
     ("溺" . "우줌눌 뇨")
     ("鬧" . "시끄러울 뇨")
     ("嫋" . "날릴 뇨")
     "嬈"
     ("嬲" . "샘낼 뇨")
     ("淖" . "진흙 뇨")
     ("裊" . "끄을 뇨")
     ("鐃" . "작은 징 뇨"))
    ("누"
     ("壘" . "진 누")
     ("屢" . "(빛이 들어오는)창 누")
     ("樓" . "다락 누")
     ("淚" . "눈물 누")
     ("漏" . "샐 누")
     ("累" . "포갤 누")
     ("縷" . "자세할 누")
     ("陋" . "줍을 누")
     "啂"
     ("耨" . "김맬 누"))
    ("누각"
     "樓閣")
    ("누계"
     "累計")
    ("누관"
     "淚管")
    ("누누"
     "累累")
    ("누대"
     "累代")
    ("누락"
     "漏落")
    ("누락분"
     "漏落分")
    ("누란"
     "累卵")
    ("누란지세"
     "累卵之勢")
    ("누명"
     "陋名")
    ("누문"
     "樓門")
    ("누상"
     "壘上"
     "樓上")
    ("누설"
     "漏泄")
    ("누설량"
     "累雪量")
    ("누수"
     "漏水")
    ("누적"
     "累積")
    ("누적적"
     "累積的")
    ("누전"
     "漏電")
    ("누증"
     "累增")
    ("누진"
     "累進")
    ("누진세"
     "累進稅")
    ("누진제"
     "累進制")
    ("누추"
     "陋醜")
    ("누출"
     "漏出")
    ("눈"
     ("嫩" . "언약할 눈"))
    ("눌"
     ("訥" . "말 더듬거릴 눌")
     ("吶" . "말 더듬을 눌")
     ("肭" . "물개 눌"))
    ("뉴"
     ("杻" . "옷 부드러울 뉴")
     ("紐" . "잡색비단 뉴")
     ("忸" . "익을 뉴")
     ("靵" . "단추 뉴"))
    ("뉵"
     "忸"
     ("衄" . "코피 뉵"))
    ("늑"
     ("勒" . "굴레 늑")
     ("肋" . "갈비대 늑"))
    ("늑골"
     "肋骨")
    ("늑막"
     "肋膜")
    ("늑막염"
     "肋膜炎")
    ("늠"
     ("凜" . "찰 늠"))
    ("늠름"
     "凜凜")
    ("능"
     ("能" . "능할 능")
     ("凌" . "얼음 능")
     ("稜" . "모질 능")
     ("綾" . "무늬 놓은 비단 능")
     ("菱" . "마름 능")
     ("陵" . "능 능"))
    ("능가"
     "凌駕")
    ("능곡지변"
     "陵谷之變")
    ("능동"
     "能動")
    ("능동성"
     "能動性")
    ("능동적"
     "能動的")
    ("능란"
     "能爛")
    ("능력"
     "能力")
    ("능률"
     "能率")
    ("능률성"
     "能率性")
    ("능률적"
     "能率的")
    ("능멸"
     "凌蔑")
    ("능사"
     "能事")
    ("능서불택필"
     "能書不擇筆")
    ("능선"
     "稜線")
    ("능선부"
     "稜線部")
    ("능소능대"
     "能小能大")
    ("능수능란"
     "能手能爛")
    ("능숙"
     "能熟")
    ("능욕"
     "凌辱")
    ("능지능문능"
     "綾地綾文綾")
    ("능지부문능"
     "綾地浮文綾")
    ("능지처참"
     "陵遲處斬")
    ("능직"
     "綾織")
    ("능참봉"
     "陵參奉")
    ("능통"
     "能通")
    ("능행"
     "陵幸")
    ("니"
     ("尼" . "여승 니")
     ("泥" . "막힐 니")
     ("呢" . "소근거릴 니")
     ("怩" . "부끄러워할 니")
     ("柅" . "얼레자루 니")
     ("膩" . "살찔 니"))
    ("닉"
     ("匿" . "숨쉴 닉")
     ("溺" . "빠질 닉"))
    ("닐"
     ("昵" . "가깝게 할 닐")
     ("暱" . "칠근할 닐"))
    ("다"
     ("多" . "많을 다")
     ("茶" . "차풀 다")
     ("爹" . "아비 다"))
    ("다각도"
     "多角度")
    ("다각적"
     "多角的")
    ("다각화"
     "多角化")
    ("다갈색"
     "茶褐色")
    ("다감"
     "多感")
    ("다강조성"
     "多强調性")
    ("다과"
     "多寡"
     "茶菓")
    ("다과점"
     "茶菓店")
    ("다관"
     "茶罐")
    ("다구"
     "茶具")
    ("다국"
     "多國")
    ("다국어"
     "多國語")
    ("다국적"
     "多國籍")
    ("다국적군"
     "多國籍軍")
    ("다규제"
     "多規制")
    ("다급"
     "多急")
    ("다기"
     "茶器")
    ("다기망양"
     "多岐亡羊")
    ("다난"
     "多難")
    ("다년간"
     "多年間")
    ("다년생"
     "多年生")
    ("다년초"
     "多年草")
    ("다다익선"
     "多多益善")
    ("다다익선조"
     "多多益善組")
    ("다단"
     "多段")
    ("다단계"
     "多段階")
    ("다단계적"
     "多段階的")
    ("다당제"
     "多黨制")
    ("다대"
     "多對")
    ("다도실"
     "茶道室")
    ("다도해"
     "多島海")
    ("다독"
     "多讀")
    ("다득점"
     "多得點")
    ("다량"
     "多量")
    ("다망"
     "多忙")
    ("다매체"
     "多媒體")
    ("다면적"
     "多面的")
    ("다목적"
     "多目的")
    ("다문박식"
     "多聞博識")
    ("다반사"
     "茶飯事")
    ("다발"
     "多發")
    ("다발적"
     "多發的")
    ("다발형"
     "多發型")
    ("다방"
     "茶房")
    ("다방면"
     "多方面")
    ("다변"
     "多變"
     "多辯")
    ("다변화"
     "多邊化")
    ("다분"
     "多分")
    ("다비"
     "茶毘")
    ("다사다난"
     "多事多難")
    ("다사제제"
     "多士濟濟")
    ("다산"
     "多産")
    ("다산성"
     "多産性")
    ("다산형"
     "多産型")
    ("다선"
     "多選")
    ("다선적"
     "多線的")
    ("다세대"
     "多世帶")
    ("다소"
     "多少")
    ("다소간"
     "多少間")
    ("다수"
     "多數")
    ("다수결"
     "多數決")
    ("다수당"
     "多數黨")
    ("다수인"
     "多數人")
    ("다수확"
     "多收穫")
    ("다습"
     "多濕")
    ("다신교"
     "多神敎")
    ("다신론적"
     "多神論的")
    ("다실"
     "茶室")
    ("다양"
     "多樣")
    ("다양성"
     "多樣性")
    ("다양화"
     "多樣化")
    ("다언혹중"
     "多言或中")
    ("다연발탄"
     "多連發彈")
    ("다용도"
     "多用途")
    ("다우"
     "多雨")
    ("다우지"
     "多雨地")
    ("다원"
     "多元")
    ("다원론적"
     "多元論的")
    ("다원적"
     "多元的")
    ("다원주의"
     "多元主義"
     "多院主義")
    ("다원주의적"
     "多元主義的")
    ("다원화"
     "多元化")
    ("다자"
     "多者")
    ("다자간"
     "多者間")
    ("다재다능"
     "多才多能")
    ("다정"
     "多情")
    ("다정다감"
     "多情多感")
    ("다종다양"
     "多種多樣")
    ("다주택"
     "多住宅")
    ("다중"
     "多衆"
     "多重")
    ("다중적"
     "多重的")
    ("다차원적"
     "多次元的")
    ("다채"
     "多彩")
    ("다축"
     "多軸")
    ("다층적"
     "多層的")
    ("다탁"
     "茶卓")
    ("다태아"
     "多胎兒")
    ("다품종"
     "多品種")
    ("다행"
     "多幸")
    ("다혈질"
     "多血質")
    ("다혈질적"
     "多血質的")
    ("단"
     ("丹" . "붉을 단")
     ("亶" . "믿을 단")
     ("但" . "다만 단")
     ("單" . "홀로 단")
     ("團" . "둥글 단")
     ("壇" . "제터 단")
     ("彖" . "결단할 단")
     ("斷" . "끊을 단")
     ("旦" . "밝을 단")
     ("檀" . "향나무 단")
     ("段" . "층계 단")
     ("湍" . "여울 단")
     ("短" . "짧을 단")
     ("端" . "끝 단")
     ("簞" . "소쿠리 단")
     ("緞" . "비단 단")
     "蓴"
     ("蛋" . "오랑캐 이름 단")
     ("袒" . "웃옷 벗을 단")
     ("鄲" . "조나라 서울 단")
     ("鍛" . "쇠불릴 단")
     ("慱" . "근심할 단")
     ("担" . "원숭이 같은 짐승 단")
     ("椴" . "자작나무 단")
     ("漙" . "이슬방울 맺을 단")
     "澶"
     ("癉" . "황달 단")
     ("耑" . "시초 단")
     ("胆" . "침비깨 단")
     ("腶" . "약포 단")
     ("蜑" . "오랑캐 이름 단")
     "靼")
    ("단가"
     "單價")
    ("단거리"
     "短距離")
    ("단검"
     "短劍")
    ("단견"
     "短見")
    ("단결"
     "團結")
    ("단결권"
     "團結權")
    ("단결력"
     "團結力")
    ("단결심"
     "團結心")
    ("단결정"
     "單結晶")
    ("단결체"
     "團結體")
    ("단계"
     "段階")
    ("단계론"
     "段階論")
    ("단계설"
     "段階說")
    ("단계적"
     "段階的")
    ("단계화"
     "段階化")
    ("단과"
     "單科")
    ("단과대"
     "單科大")
    ("단교"
     "斷交")
    ("단금지교"
     "斷金之交")
    ("단기"
     "檀紀"
     "短期")
    ("단기간"
     "短期間")
    ("단기성"
     "短期性")
    ("단기일"
     "短期日")
    ("단기적"
     "短期的")
    ("단기전"
     "短期戰")
    ("단기지계"
     "斷機之戒")
    ("단념"
     "斷念")
    ("단대"
     "單大")
    ("단도직입"
     "單刀直入")
    ("단도직입적"
     "單刀直入的")
    ("단독"
     "單獨")
    ("단독정부"
     "單獨政府")
    ("단독형"
     "單獨型")
    ("단두대"
     "斷頭臺")
    ("단락"
     "段落")
    ("단란"
     "團欒")
    ("단련"
     "鍛鍊")
    ("단령"
     "團領")
    ("단막"
     "單幕")
    ("단막극"
     "短幕劇")
    ("단말기"
     "端末機")
    ("단말마"
     "斷末摩"
     "斷末魔")
    ("단말마적"
     "斷末摩的")
    ("단면"
     "斷面")
    ("단면도"
     "斷面圖")
    ("단면적"
     "斷面的")
    ("단명"
     "短命")
    ("단발"
     "單發"
     "斷髮")
    ("단발령"
     "斷髮令")
    ("단발사격"
     "單發射擊")
    ("단발성"
     "單發性")
    ("단방약"
     "單方藥")
    ("단백질"
     "蛋白質")
    ("단번"
     "單番")
    ("단사표음"
     "簞食瓢飮")
    ("단산"
     "斷産")
    ("단상"
     "壇上"
     "斷想")
    ("단서"
     "但書"
     "端緖")
    ("단선"
     "單線")
    ("단선단정"
     "單選單政")
    ("단선적"
     "單線的")
    ("단세포"
     "端細胞")
    ("단세포적"
     "單細胞的")
    ("단소"
     "短簫")
    ("단속"
     "團束"
     "斷續")
    ("단속반"
     "團束班")
    ("단속반원"
     "團束班員")
    ("단수"
     "單數"
     "斷水")
    ("단수적"
     "單數的")
    ("단순"
     "單純")
    ("단순성"
     "單純性")
    ("단순호치"
     "丹脣皓齒")
    ("단순화"
     "單純化")
    ("단시간"
     "短時間")
    ("단시일"
     "短時日")
    ("단식"
     "單式"
     "斷食")
    ("단신"
     "單身"
     "短信"
     "短身")
    ("단아"
     "端雅")
    ("단안"
     "斷案")
    ("단어"
     "單語")
    ("단어적"
     "單語的")
    ("단언"
     "斷言")
    ("단역"
     "端役")
    ("단연"
     "斷然")
    ("단열"
     "斷熱")
    ("단열재"
     "斷熱材")
    ("단오"
     "端午")
    ("단오절"
     "端午節")
    ("단옷"
     "端午")
    ("단원"
     "單元"
     "團員")
    ("단위"
     "單位")
    ("단위체"
     "單位體")
    ("단음계권"
     "短音階圈")
    ("단일"
     "單一")
    ("단일화"
     "單一化")
    ("단임"
     "單任")
    ("단자"
     "單子"
     "短資")
    ("단자사"
     "端子社")
    ("단장"
     "丹粧"
     "團長")
    ("단장실"
     "團長室")
    ("단장형"
     "丹粧型")
    ("단적"
     "端的")
    ("단전"
     "丹田")
    ("단전호흡"
     "丹田呼吸")
    ("단전호흡법"
     "丹田呼吸法")
    ("단절"
     "斷絶")
    ("단절적"
     "斷絶的")
    ("단점"
     "短點")
    ("단정"
     "斷定"
     "端正")
    ("단정론"
     "單政論")
    ("단정미"
     "端正美")
    ("단정적"
     "斷定的")
    ("단정학"
     "丹頂鶴")
    ("단조"
     "單調")
    ("단죄"
     "斷罪")
    ("단지"
     "但只"
     "團地")
    ("단청"
     "丹靑")
    ("단체"
     "團體")
    ("단체장"
     "團體長")
    ("단체적"
     "團體的")
    ("단체전"
     "團體戰")
    ("단체정신"
     "團體精神")
    ("단초"
     "端初")
    ("단초적"
     "端初的")
    ("단축"
     "短縮")
    ("단축법"
     "短縮法")
    ("단층"
     "單層")
    ("단칸방"
     "單-房")
    ("단파"
     "短波")
    ("단편"
     "斷片"
     "短篇")
    ("단편성"
     "斷片性")
    ("단편적"
     "斷片的")
    ("단편집"
     "短篇集")
    ("단편화"
     "斷片化")
    ("단품"
     "斷品")
    ("단풍"
     "丹楓")
    ("단학"
     "丹學")
    ("단합"
     "團合")
    ("단행"
     "斷行"
     "短行")
    ("단행본"
     "單行本")
    ("단호"
     "斷乎")
    ("단화"
     "短靴")
    ("달"
     ("撻" . "매질할 달")
     "澾"
     ("獺" . "수달 달")
     ("疸" . "황달 달")
     ("達" . "통달할 달")
     ("妲" . "계집의 이름 달")
     ("怛" . "깜짝 놀랄 달")
     ("闥" . "대문 달")
     ("靼" . "다룬가죽 달")
     ("韃" . "칠 달"))
    ("달관"
     "達觀")
    ("달도"
     "達道")
    ("달변"
     "達辯")
    ("달불리도"
     "達不離道")
    ("달성"
     "達成")
    ("달인"
     "達人")
    ("담"
     ("啖" . "씹을 담")
     ("坍" . "물이 언덕 찰 담")
     ("憺" . "고요할 담")
     ("擔" . "질 담")
     ("曇" . "날 흐릴 담")
     ("淡" . "물모양 담")
     ("湛" . "즐거울 담")
     ("潭" . "깊을 담")
     ("澹" . "맑을 담")
     ("痰" . "가래 담")
     ("聃" . "노자이름 담")
     ("膽" . "쓸개 담")
     ("蕁" . "말 담")
     ("覃" . "미칠 담")
     ("談" . "말씀 담")
     ("譚" . "클 담")
     ("錟" . "긴 창 담")
     ("儋" . "기운차고 날쌜해집 담")
     ("啗" . "씹을 담")
     ("噉" . "씹을 담")
     ("墰" . "목긴 술병 담")
     ("壜" . "술병 담")
     "忐"
     "担"
     ("毯" . "담자리 담")
     ("禫" . "담제 담")
     ("罎" . "壜과 同字")
     "胆"
     ("薝" . "치자나무 담")
     ("郯" . "나라이름 담")
     ("黮" . "검을 담")
     ("黵" . "문신할 담"))
    ("담가"
     "擔架")
    ("담갈색"
     "淡褐色")
    ("담녹색"
     "淡綠色")
    ("담담"
     "淡淡")
    ("담당"
     "擔當")
    ("담당관"
     "擔當官")
    ("담당관실"
     "擔當官室")
    ("담당자"
     "擔當者")
    ("담당층"
     "擔當層")
    ("담대"
     "膽大")
    ("담력"
     "膽力")
    ("담론"
     "談論")
    ("담론적"
     "談論的")
    ("담백"
     "淡白")
    ("담보"
     "擔保")
    ("담보물"
     "擔保物")
    ("담색"
     "淡色")
    ("담세층"
     "擔稅層")
    ("담소"
     "談笑")
    ("담소자약"
     "談笑自若")
    ("담수"
     "淡水"
     "湛水")
    ("담수어"
     "淡水魚")
    ("담시"
     "譚詩")
    ("담언미중"
     "談言微中")
    ("담임"
     "擔任")
    ("담임교사"
     "擔任敎師")
    ("담임선생"
     "擔任先生")
    ("담지"
     "擔持")
    ("담지자"
     "擔持者")
    ("담지체"
     "擔持體")
    ("담천"
     "曇天")
    ("담판"
     "談判")
    ("담합"
     "談合")
    ("담호호지"
     "談虎虎至")
    ("담화"
     "談話")
    ("담화문"
     "談話文")
    ("담황색"
     "淡黃色")
    ("담황적갈색"
     "淡黃赤葛色")
    ("담회갈색"
     "淡灰葛色")
    ("답"
     ("沓" . "거듭 답")
     ("畓" . "논 답")
     ("答" . "젖을 답")
     ("踏" . "떨어지는 소리 답")
     ("遝" . "가다가설 답"))
    ("답례"
     "答禮")
    ("답례품"
     "答禮品")
    ("답방"
     "答訪")
    ("답배"
     "答拜")
    ("답변"
     "答辯")
    ("답보"
     "踏步")
    ("답사"
     "踏査")
    ("답습"
     "踏襲")
    ("답신"
     "答信")
    ("답안"
     "答案")
    ("답안지"
     "答案紙")
    ("답장"
     "答狀")
    ("답전"
     "踏典")
    ("당"
     ("唐" . "당나라 당")
     ("堂" . "집 당")
     ("塘" . "연못 당")
     ("幢" . "기 당")
     ("戇" . "어리석을 당")
     ("撞" . "두드릴 당")
     ("棠" . "아가위 당")
     ("當" . "마땅할 당")
     ("糖" . "엿 당")
     ("螳" . "버마 재비 당")
     ("黨" . "무리 당")
     ("倘" . "혹시 당")
     ("儻" . "빼어날 당")
     ("党" . "黨의 略字")
     ("搪" . "당동할 당")
     ("檔" . "책상 당")
     ("溏" . "진수렁 당")
     ("瑭" . "옥이름 당")
     ("璫" . "귀고리 당")
     ("瞠" . "바로볼 당")
     ("礑" . "밑바닥 당")
     ("蟷" . "사마귀 당")
     ("襠" . "잠방이 당")
     ("讜" . "곧은 말 당")
     ("鏜" . "북방축소 당")
     ("鐺" . "죄인 자물쇠 당")
     ("餳" . "엿 당")
     ("餹" . "엿 당"))
    ("당고모"
     "堂姑母")
    ("당구"
     "撞球")
    ("당구장"
     "撞球場")
    ("당구풍월"
     "堂狗風月")
    ("당국"
     "當國"
     "當局")
    ("당국자"
     "當局者")
    ("당권"
     "黨權")
    ("당귀"
     "當歸")
    ("당규"
     "黨規")
    ("당기"
     "當期")
    ("당기위"
     "黨紀委")
    ("당내"
     "黨內")
    ("당내지친"
     "堂內至親")
    ("당뇨"
     "糖尿")
    ("당뇨병"
     "糖尿病")
    ("당뇨병성"
     "糖尿病性")
    ("당단풍"
     "唐丹楓")
    ("당당"
     "堂堂")
    ("당대"
     "當代")
    ("당대인"
     "當代人")
    ("당대적"
     "當代的")
    ("당대회"
     "黨大會")
    ("당도"
     "當到"
     "當道"
     "糖度")
    ("당돌"
     "唐突")
    ("당동벌이"
     "黨同伐異")
    ("당락"
     "當落")
    ("당랑거철"
     "螳螂拒轍")
    ("당랑규선"
     "螳螂窺蟬")
    ("당략"
     "黨略")
    ("당론"
     "黨論")
    ("당료"
     "黨僚")
    ("당류"
     "糖類")
    ("당리당략"
     "黨利黨略")
    ("당리적"
     "黨利的")
    ("당면"
     "當面")
    ("당명"
     "黨命")
    ("당무"
     "黨務")
    ("당번"
     "當番")
    ("당부"
     "當付"
     "當否")
    ("당분"
     "糖分")
    ("당분간"
     "當分間")
    ("당비"
     "黨費")
    ("당비서"
     "黨秘書")
    ("당사"
     "當社"
     "黨舍")
    ("당사국"
     "當事國")
    ("당사자"
     "當事者")
    ("당사주"
     "唐四柱")
    ("당산"
     "堂山")
    ("당산목"
     "堂山木")
    ("당삼채"
     "唐三彩")
    ("당상"
     "堂上")
    ("당상관"
     "堂上官")
    ("당색"
     "黨色")
    ("당선"
     "當選")
    ("당선권"
     "當選圈")
    ("당선자"
     "當選者")
    ("당선작"
     "當選作")
    ("당세"
     "黨勢")
    ("당세지풍"
     "當世之風")
    ("당수"
     "黨首")
    ("당숙"
     "堂叔")
    ("당숙모"
     "堂叔母")
    ("당시"
     "唐詩"
     "當時")
    ("당신"
     "當身")
    ("당악"
     "唐樂")
    ("당연"
     "當然")
    ("당연시"
     "當然視")
    ("당연지사"
     "當然之事")
    ("당원"
     "黨員")
    ("당위"
     "當爲")
    ("당위론적"
     "當爲論的")
    ("당위성"
     "當爲性")
    ("당의"
     "唐衣")
    ("당의정"
     "糖衣錠")
    ("당일"
     "當日")
    ("당일권"
     "當日券")
    ("당자"
     "當者")
    ("당장"
     "堂長"
     "當場")
    ("당쟁"
     "黨爭")
    ("당적"
     "黨籍")
    ("당정"
     "黨政")
    ("당제"
     "唐制")
    ("당좌"
     "當座")
    ("당주"
     "堂主")
    ("당중앙"
     "黨中央")
    ("당중앙위원회"
     "黨中央委員會")
    ("당직"
     "當直"
     "黨職")
    ("당직자"
     "當直者"
     "黨職者")
    ("당질"
     "糖質")
    ("당질대사"
     "糖質代謝")
    ("당첨"
     "當籤")
    ("당첨자"
     "當籤者")
    ("당초"
     "當初")
    ("당파"
     "黨派")
    ("당파성"
     "黨派性")
    ("당파적"
     "黨派的")
    ("당해"
     "當該")
    ("당해인"
     "當該人")
    ("당헌"
     "黨憲")
    ("당혹"
     "當惑")
    ("당혹감"
     "當惑感")
    ("당황"
     "唐慌")
    ("대"
     ("代" . "대신할 대")
     "台"
     ("坮" . "들 대")
     ("垈" . "터 대")
     ("大" . "클 대")
     ("對" . "마주볼 대")
     ("岱" . "태산 대")
     ("帶" . "띠 대")
     ("待" . "기다릴 대")
     ("戴" . "받들 대")
     ("擡" . "들 대")
     ("玳" . "대모(바다거북) 대")
     ("臺" . "능 대")
     ("袋" . "자루 대")
     ("貸" . "빌릴 대")
     ("錞" . "창고달 대")
     ("隊" . "군대 대")
     ("黛" . "눈썹 그릴 대, 새파랄 대")
     ("儓" . "하인 대")
     ("懟" . "원망할 대")
     ("旲" . "햇빛 대")
     ("汏" . "씻을 대")
     ("碓" . "방아 대")
     ("鐓" . "창고달 대")
     "隶")
    ("대가"
     "代價"
     "大家")
    ("대가부장적"
     "大家父長的")
    ("대가족"
     "大家族")
    ("대각"
     "對角")
    ("대각선"
     "對角線")
    ("대갈일성"
     "大喝一聲")
    ("대감"
     "大監")
    ("대감층"
     "大監層")
    ("대강"
     "大綱")
    ("대강당"
     "大講堂")
    ("대강대강"
     "大綱大綱")
    ("대개"
     "大槪")
    ("대개벽"
     "大開闢")
    ("대개편"
     "大改編")
    ("대거"
     "大擧")
    ("대결"
     "對決")
    ("대결사"
     "對決史")
    ("대결산"
     "大決算")
    ("대결상"
     "對決相")
    ("대결장"
     "對決場")
    ("대경실색"
     "大驚失色")
    ("대계"
     "大計")
    ("대고모"
     "大姑母")
    ("대공"
     "對共"
     "對空")
    ("대공망"
     "對空網")
    ("대공사"
     "大工事")
    ("대공원"
     "大公園")
    ("대공장"
     "大工場")
    ("대과"
     "大科")
    ("대과업"
     "大課業")
    ("대관절"
     "大關節")
    ("대관측가"
     "大觀測家")
    ("대광장"
     "大廣場")
    ("대교"
     "待敎")
    ("대구"
     "大口"
     "大邱")
    ("대구고"
     "大口袴")
    ("대국"
     "大國"
     "大局")
    ("대국화"
     "大國化")
    ("대군"
     "大君"
     "大軍")
    ("대굿"
     "大口")
    ("대권"
     "大權")
    ("대권자"
     "大權者")
    ("대궐"
     "大闕")
    ("대규모"
     "大規模")
    ("대규모적"
     "大規模的")
    ("대극"
     "大戟"
     "對極")
    ("대극장"
     "大劇場")
    ("대금"
     "代金")
    ("대기"
     "大氣"
     "待機")
    ("대기권"
     "大氣圈")
    ("대기록"
     "大記錄")
    ("대기론자"
     "待機論者")
    ("대기만성"
     "大器晩成")
    ("대기붕"
     "大氣棚")
    ("대기소용"
     "大器小用")
    ("대기실"
     "待機室")
    ("대기업"
     "大企業")
    ("대기업체"
     "大企業體")
    ("대기자"
     "待機者")
    ("대기질"
     "大氣質")
    ("대기층"
     "大氣層")
    ("대길"
     "大吉")
    ("대남"
     "對南")
    ("대남관"
     "對南觀")
    ("대납"
     "代納")
    ("대납제"
     "代納制")
    ("대내"
     "對內")
    ("대내외"
     "對內外")
    ("대내외적"
     "對內外的")
    ("대내적"
     "對內的")
    ("대농"
     "大農")
    ("대농가"
     "大農家")
    ("대농장주"
     "大農場主")
    ("대뇌"
     "大腦")
    ("대다수"
     "大多數")
    ("대단결"
     "大團結")
    ("대단원"
     "大團圓")
    ("대단위"
     "大單位")
    ("대담"
     "大膽"
     "對談")
    ("대담성"
     "大膽性")
    ("대답"
     "對答")
    ("대대"
     "代代"
     "大隊")
    ("대대로"
     "大對盧")
    ("대대로제"
     "大對盧制")
    ("대대손손"
     "代代孫孫")
    ("대대장"
     "大隊長")
    ("대대적"
     "大大的")
    ("대덕"
     "大德")
    ("대도"
     "大道")
    ("대도무문"
     "大道無門")
    ("대도시"
     "大都市")
    ("대동"
     "大同"
     "帶同")
    ("대동계"
     "大同系"
     "大洞契")
    ("대동단결"
     "大同團結")
    ("대동소이"
     "大同小異")
    ("대두"
     "大豆"
     "擡頭")
    ("대등"
     "對等")
    ("대란"
     "大亂")
    ("대략"
     "大略")
    ("대략적"
     "大略的")
    ("대량"
     "大量")
    ("대량적"
     "大量的")
    ("대량화"
     "大量化")
    ("대령"
     "大領"
     "待令")
    ("대례"
     "大禮")
    ("대례식"
     "大禮式")
    ("대로"
     "大路")
    ("대로변"
     "大路邊")
    ("대류"
     "對流")
    ("대류성"
     "對流性")
    ("대륙"
     "大陸")
    ("대륙성"
     "大陸性")
    ("대륙식"
     "大陸式")
    ("대륙적"
     "大陸的")
    ("대리"
     "代理")
    ("대리석"
     "大理石")
    ("대리암"
     "大理巖")
    ("대리인"
     "代理人")
    ("대리자"
     "代理者")
    ("대리전"
     "代理戰")
    ("대리점"
     "代理店")
    ("대립"
     "對立")
    ("대립기"
     "對立期")
    ("대립적"
     "對立的")
    ("대마"
     "大麻")
    ("대마초"
     "大麻草")
    ("대만원"
     "大滿員")
    ("대망"
     "大望"
     "待望")
    ("대망론"
     "待望論")
    ("대매출"
     "大賣出")
    ("대면"
     "對面")
    ("대명사"
     "代名詞")
    ("대명사적"
     "代名詞的")
    ("대명천지"
     "大明天地")
    ("대모"
     "大母")
    ("대모집"
     "大募集")
    ("대목"
     "大木")
    ("대문"
     "大文"
     "大門")
    ("대문간"
     "大門間")
    ("대문라"
     "大紋羅")
    ("대문자"
     "大文字")
    ("대미"
     "大尾"
     "對美")
    ("대민"
     "對民")
    ("대반격"
     "大反擊")
    ("대배우"
     "大俳優")
    ("대범"
     "大汎")
    ("대법관"
     "大法官")
    ("대법원장"
     "大法院長")
    ("대변"
     "代辯"
     "大便")
    ("대변신"
     "大變身")
    ("대변여눌"
     "大辯如訥")
    ("대변인"
     "代辯人")
    ("대변인단"
     "代辯人團")
    ("대변자"
     "代辯者")
    ("대변칙"
     "大變則")
    ("대변혁"
     "大變革")
    ("대변환"
     "大變換")
    ("대별"
     "大別")
    ("대보"
     "大輔")
    ("대본"
     "臺本")
    ("대본소"
     "貸本所")
    ("대본영"
     "大本營")
    ("대부"
     "代父"
     "大富"
     "貸付")
    ("대부계"
     "貸付係")
    ("대부금"
     "貸付金")
    ("대부대"
     "大部隊")
    ("대부분"
     "大部分")
    ("대북"
     "對北")
    ("대분류"
     "大分類")
    ("대분망천"
     "戴盆望天")
    ("대붕"
     "大鵬")
    ("대비"
     "大妃"
     "對備"
     "對比")
    ("대비기"
     "對備期")
    ("대비적"
     "對比的")
    ("대비책"
     "對備策")
    ("대사"
     "代謝"
     "大事"
     "大使"
     "大師"
     "臺詞")
    ("대사건"
     "大事件")
    ("대사관"
     "大使館")
    ("대사관원"
     "大使館員")
    ("대사량"
     "代謝量")
    ("대사령"
     "大赦令")
    ("대사면"
     "大赦免")
    ("대사법"
     "臺詞法")
    ("대사상가"
     "大思想家")
    ("대사성"
     "代謝性")
    ("대사전"
     "大辭典")
    ("대사직"
     "大使職")
    ("대사찰"
     "大寺刹")
    ("대사헌"
     "大司憲")
    ("대상"
     "大賞"
     "對象"
     "帶狀")
    ("대상국"
     "對象國")
    ("대상물"
     "對象物")
    ("대상성"
     "對象性")
    ("대상신"
     "對象神")
    ("대상자"
     "對象者")
    ("대상작"
     "大賞作")
    ("대상적"
     "對象的")
    ("대상지"
     "對象地")
    ("대상층"
     "對象層")
    ("대상화"
     "對象化")
    ("대생"
     "對生")
    ("대서"
     "大暑")
    ("대서사시"
     "大敍事詩")
    ("대서특필"
     "大書特筆")
    ("대선"
     "大選")
    ("대선거구제"
     "大選擧區制")
    ("대선배"
     "大先輩")
    ("대설"
     "大說"
     "大雪")
    ("대섬멸전"
     "大殲滅戰")
    ("대성"
     "大姓"
     "大成")
    ("대성공"
     "大成功")
    ("대성당"
     "大聖堂")
    ("대성악"
     "大晟樂")
    ("대성전"
     "大成殿")
    ("대성통곡"
     "大聲痛哭")
    ("대성황"
     "大盛況")
    ("대세"
     "大勢")
    ("대세론"
     "大勢論")
    ("대소"
     "大小")
    ("대소변"
     "大小便")
    ("대소사"
     "大小事")
    ("대소설가"
     "大小說家")
    ("대손"
     "代孫")
    ("대수"
     "代數"
     "大數"
     "臺數")
    ("대수술"
     "大手術")
    ("대수학자"
     "大數學者")
    ("대순환"
     "大循環")
    ("대승"
     "大乘")
    ("대승리"
     "大勝利")
    ("대승적"
     "大乘的")
    ("대식"
     "大食")
    ("대식구"
     "大食口")
    ("대신"
     "代身"
     "大臣")
    ("대아"
     "大我")
    ("대악"
     "大樂")
    ("대안"
     "代案"
     "對案")
    ("대안적"
     "代案的")
    ("대야합"
     "大野合")
    ("대양"
     "大洋")
    ("대어"
     "大魚")
    ("대업"
     "大業")
    ("대여"
     "貸與")
    ("대여금"
     "貸與金")
    ("대여당"
     "大與黨")
    ("대여료"
     "貸與料")
    ("대여업"
     "貸與業")
    ("대여업소"
     "貸與業所")
    ("대역"
     "代役"
     "大逆"
     "帶域")
    ("대역사"
     "大役事"
     "大歷史")
    ("대역전극"
     "大逆戰劇")
    ("대연합"
     "大聯合")
    ("대열"
     "隊列")
    ("대오"
     "大悟"
     "隊伍")
    ("대왕"
     "大王")
    ("대왕제"
     "大王制")
    ("대외"
     "對外")
    ("대외비"
     "對外秘")
    ("대외수"
     "大外水")
    ("대외적"
     "對外的")
    ("대외전"
     "對外戰")
    ("대용"
     "代用")
    ("대용량"
     "大容量")
    ("대용품"
     "代用品")
    ("대우"
     "待遇")
    ("대우주"
     "大宇宙")
    ("대우탄금"
     "對牛彈琴")
    ("대웅보전"
     "大雄寶殿")
    ("대웅전"
     "大雄殿")
    ("대원"
     "隊員")
    ("대원수"
     "大元帥")
    ("대원칙"
     "大原則")
    ("대위"
     "大尉")
    ("대유지년"
     "大有之年")
    ("대유행"
     "大流行")
    ("대읍"
     "大邑")
    ("대응"
     "對應")
    ("대응물"
     "對應物")
    ("대응책"
     "對應策")
    ("대의"
     "代議"
     "大義")
    ("대의멸친"
     "大義滅親")
    ("대의명분"
     "大義名分")
    ("대의원"
     "代議員")
    ("대이동"
     "大移動")
    ("대인"
     "大人"
     "對人")
    ("대인적"
     "大人的")
    ("대일"
     "對日")
    ("대일변"
     "大一變")
    ("대입"
     "大入")
    ("대자"
     "大字")
    ("대자대비"
     "大慈大悲")
    ("대자보"
     "大字報")
    ("대자연"
     "大自然")
    ("대작"
     "代作"
     "大作"
     "對酌")
    ("대작가"
     "大作家")
    ("대작물"
     "大作物")
    ("대작전"
     "大作戰")
    ("대잠"
     "對潛")
    ("대장"
     "大將"
     "大腸"
     "臺帳")
    ("대장경"
     "大藏經")
    ("대장경판"
     "大藏經版")
    ("대장군"
     "大將軍")
    ("대장균"
     "大腸菌")
    ("대장부"
     "大丈夫")
    ("대장상"
     "大將相")
    ("대장암"
     "大腸癌")
    ("대장염"
     "大腸炎")
    ("대장정"
     "大長程")
    ("대재벌"
     "大財閥")
    ("대저"
     "大抵")
    ("대저택"
     "大邸宅")
    ("대적"
     "對敵")
    ("대전"
     "大典"
     "大戰"
     "大田"
     "對戰")
    ("대전시실"
     "大展示室")
    ("대전제"
     "大前提")
    ("대전향"
     "大轉向")
    ("대전환"
     "大轉換")
    ("대절"
     "貸切")
    ("대접"
     "待接")
    ("대접론"
     "待接論")
    ("대접전"
     "大接戰")
    ("대정치가"
     "大政治家")
    ("대제"
     "大帝")
    ("대제국"
     "大帝國")
    ("대제전"
     "大祭典")
    ("대제학"
     "大提學")
    ("대조"
     "對照")
    ("대조사"
     "大祖師")
    ("대조적"
     "對照的")
    ("대조표"
     "對照表")
    ("대조화"
     "大造化")
    ("대졸"
     "大卒")
    ("대졸자"
     "大卒者")
    ("대종"
     "大宗")
    ("대종회"
     "大宗會")
    ("대좌"
     "對坐"
     "臺座")
    ("대주"
     "貸株")
    ("대주주"
     "大株主")
    ("대중"
     "大衆"
     "對中")
    ("대중가요"
     "大衆歌謠")
    ("대중교통"
     "大衆交通")
    ("대중극"
     "大衆劇")
    ("대중론"
     "大衆論")
    ("대중목욕탕"
     "大衆沐浴湯")
    ("대중문화"
     "大衆文化")
    ("대중문화론"
     "大衆文化論")
    ("대중문화적"
     "大衆文化的")
    ("대중문화화"
     "大衆文化化")
    ("대중서"
     "大衆書")
    ("대중성"
     "大衆性")
    ("대중오락"
     "大衆娛樂")
    ("대중음악"
     "大衆音樂")
    ("대중음악가"
     "大衆音樂家")
    ("대중음악인"
     "大衆音樂人")
    ("대중적"
     "大衆的")
    ("대중주"
     "大衆酒")
    ("대중지"
     "大衆誌")
    ("대중탕"
     "大衆湯")
    ("대중화"
     "大衆化")
    ("대중화주의"
     "大衆化主義")
    ("대증"
     "對症")
    ("대지"
     "垈地"
     "大地"
     "臺地")
    ("대지진"
     "大地震")
    ("대지휘자"
     "大指揮者")
    ("대진표"
     "對陣表")
    ("대질"
     "對質")
    ("대집단"
     "大集團")
    ("대집행"
     "代執行")
    ("대차"
     "大差"
     "貸借")
    ("대참사"
     "大慘事")
    ("대책"
     "對策")
    ("대책반"
     "對策班")
    ("대책안"
     "對策案")
    ("대책위"
     "對策委")
    ("대처"
     "大處"
     "對處")
    ("대척적"
     "對蹠的")
    ("대천지원수"
     "戴天之怨讐")
    ("대첩"
     "大捷")
    ("대청"
     "大廳")
    ("대청소"
     "大淸掃")
    ("대체"
     "代替"
     "大體")
    ("대체물"
     "代替物")
    ("대체적"
     "大體的")
    ("대축제"
     "大祝祭")
    ("대축척"
     "大縮尺")
    ("대출"
     "貸出")
    ("대출금"
     "貸出金")
    ("대출력"
     "貸出力")
    ("대출분"
     "貸出分")
    ("대출액"
     "貸出額")
    ("대출자"
     "貸出者")
    ("대취락"
     "大聚落")
    ("대층"
     "代層")
    ("대치"
     "代置"
     "對峙")
    ("대치물"
     "代置物")
    ("대침"
     "大鍼")
    ("대칭"
     "對稱")
    ("대칭성"
     "對稱性")
    ("대칭적"
     "對稱的")
    ("대타"
     "代打")
    ("대타론"
     "代打論")
    ("대탄압"
     "大彈壓")
    ("대탈출"
     "大脫出")
    ("대토론회"
     "大討論會")
    ("대토지"
     "大土地")
    ("대통력"
     "大統曆")
    ("대통령"
     "大統領")
    ("대통령령"
     "大統領令")
    ("대통령상"
     "大統領賞")
    ("대통령제"
     "大統領制")
    ("대통령직"
     "大統領職")
    ("대통령학"
     "大統領學")
    ("대투매"
     "大投賣")
    ("대투쟁"
     "大鬪爭")
    ("대파"
     "大破")
    ("대패"
     "大敗")
    ("대팽창기"
     "大膨脹期")
    ("대평원"
     "大平原")
    ("대포"
     "大砲")
    ("대폭"
     "大幅")
    ("대폭발"
     "大爆發")
    ("대폭적"
     "大幅的")
    ("대표"
     "代表")
    ("대표곡"
     "代表曲")
    ("대표권"
     "代表權")
    ("대표단"
     "代表團")
    ("대표부"
     "代表部")
    ("대표성"
     "代表性")
    ("대표자"
     "代表者")
    ("대표작"
     "代表作")
    ("대표적"
     "代表的")
    ("대표제"
     "代表制")
    ("대표직"
     "代表職")
    ("대피"
     "待避")
    ("대피소"
     "待避所")
    ("대필"
     "代筆")
    ("대필생"
     "代筆生")
    ("대하"
     "大河"
     "帶下")
    ("대하증"
     "帶下症")
    ("대학"
     "大學")
    ("대학가"
     "大學街")
    ("대학교"
     "大學校")
    ("대학교수"
     "大學敎授")
    ("대학로"
     "大學路")
    ("대학살"
     "大虐殺")
    ("대학생"
     "大學生")
    ("대학원"
     "大學院")
    ("대학원생"
     "大學院生")
    ("대한"
     "大寒"
     "大旱")
    ("대한민국"
     "大韓民國")
    ("대할인"
     "大割引")
    ("대합"
     "大蛤")
    ("대합실"
     "待合室")
    ("대항"
     "對抗")
    ("대항적"
     "對抗的")
    ("대항전"
     "對抗戰")
    ("대해"
     "大海")
    ("대행"
     "代行")
    ("대행기"
     "代行期")
    ("대행사"
     "代行社")
    ("대행업"
     "代行業")
    ("대행업체"
     "代行業體")
    ("대행자"
     "代行者")
    ("대행진"
     "大行進")
    ("대혁명"
     "大革命")
    ("대혈"
     "大穴")
    ("대혈전"
     "大血戰")
    ("대혈투"
     "大血鬪")
    ("대형"
     "大型")
    ("대형선"
     "大型船")
    ("대형차"
     "大型車")
    ("대형화"
     "大型化")
    ("대호"
     "大戶")
    ("대호족"
     "大豪族")
    ("대호황"
     "大好況")
    ("대혼란"
     "大混亂")
    ("대홍면포"
     "大紅綿布")
    ("대홍수"
     "大洪水")
    ("대화"
     "對話")
    ("대화방"
     "對話房")
    ("대화법"
     "對話法")
    ("대화어아금"
     "大花魚牙錦")
    ("대화자"
     "對話者")
    ("대화재"
     "大火災")
    ("대화체"
     "對話體")
    ("대화합"
     "大和合")
    ("대화해"
     "大和解")
    ("대화형"
     "對話型")
    ("대회"
     "大會")
    ("대회신"
     "大會新")
    ("대회의실"
     "大會議室")
    ("대회장"
     "大會場")
    ("대회전"
     "大回戰")
    ("대훈장"
     "大勳章")
    ("대흉근"
     "大胸筋")
    ("대흉년"
     "大凶年")
    ("댁"
     ("宅" . "집 댁"))
    ("덕"
     ("德" . "큰 덕")
     ("悳" . "德의 古字"))
    ("덕고망중"
     "德高望重")
    ("덕담"
     "德談")
    ("덕망"
     "德望")
    ("덕망가"
     "德望家")
    ("덕목"
     "德目")
    ("덕분"
     "德分")
    ("덕성"
     "德性")
    ("덕수궁"
     "德壽宮")
    ("덕업"
     "德業")
    ("덕업상권"
     "德業相勸")
    ("덕육"
     "德育")
    ("덕택"
     "德澤")
    ("덕행"
     "德行")
    ("덧칠"
     "­漆")
    ("도"
     ("倒" . "넘어질 도")
     "兜"
     ("刀" . "칼 도")
     ("到" . "이를 도")
     ("圖" . "그림 도")
     ("堵" . "담 도")
     ("塗" . "바를 도")
     ("導" . "이끌 도")
     ("屠" . "잡을 도")
     ("島" . "섬 도")
     ("嶋" . "섬 도")
     ("度" . "법도 도")
     ("徒" . "무리 도")
     ("悼" . "슬퍼할 도")
     ("挑" . "돋을 도")
     ("掉" . "흔들 도")
     ("搗" . "찧을 도")
     ("桃" . "복숭아 나무 도")
     ("棹" . "노 저을 도")
     ("櫂" . "상앗대 도")
     ("淘" . "일 도")
     ("渡" . "건널 도")
     ("滔" . "물 넘칠 도")
     ("濤" . "물결 도")
     ("燾" . "비칠 도")
     ("盜" . "도둑 도")
     ("睹" . "볼 도")
     ("禱" . "빌 도")
     ("稻" . "벼 도")
     ("覩" . "睹와 同字")
     ("賭" . "노름 도")
     ("跳" . "뛸 도")
     ("蹈" . "밟을 도")
     ("逃" . "달아날 도")
     ("途" . "길 도")
     ("道" . "길 도")
     ("都" . "도읍 도")
     ("鍍" . "도금할 도")
     ("陶" . "질 그도 도")
     ("韜" . "활집 도")
     ("叨" . "탐할 도")
     ("壔" . "작은 성 도")
     ("弢" . "활집 도")
     ("忉" . "근심할 도")
     ("慆" . "기뻐할 도")
     ("掏" . "가릴(선택)할 도")
     ("搯" . "두드릴 도")
     ("擣" . "찧을 도")
     "杲"
     ("檮" . "그루터기 도")
     ("涂" . "길 도")
     ("稌" . "찰벼 도")
     "絛"
     ("酴" . "두번 빚은 술 도")
     ("闍" . "성문 층대 도")
     ("鞀" . "소고 도")
     ("鞱" . "너그러울 도")
     ("饕" . "탐할 도")
     ("鼗" . "땡땡이 도"))
    ("도가"
     "道家"
     "都家")
    ("도감"
     "圖鑑"
     "都監")
    ("도강"
     "渡江")
    ("도경"
     "道警")
    ("도교"
     "道敎")
    ("도교적"
     "道敎的")
    ("도구"
     "道具")
    ("도구적"
     "道具的")
    ("도국근성"
     "島國根性")
    ("도굴"
     "盜掘")
    ("도금"
     "鍍金")
    ("도급"
     "都給")
    ("도난"
     "盜難")
    ("도난당"
     "盜難當")
    ("도난품"
     "盜難品")
    ("도내"
     "道內")
    ("도농"
     "都農")
    ("도달"
     "到達")
    ("도당"
     "徒黨"
     "渡唐"
     "道黨")
    ("도대체"
     "都大體")
    ("도덕"
     "道德")
    ("도덕군자연"
     "道德君子然")
    ("도덕규범"
     "道德規範")
    ("도덕성"
     "道德性")
    ("도덕심"
     "道德心")
    ("도덕인"
     "道德人")
    ("도덕적"
     "道德的")
    ("도덕주의"
     "道德主義")
    ("도덕주의자"
     "道德主義者")
    ("도덕주의적"
     "道德主義的")
    ("도도"
     "滔滔"
     "道都")
    ("도독"
     "都督")
    ("도래"
     "到來"
     "渡來")
    ("도래인"
     "渡來人")
    ("도량"
     "道場")
    ("도량형"
     "度量衡")
    ("도로"
     "道路")
    ("도로국장"
     "道路局長")
    ("도로망"
     "道路網")
    ("도로무익"
     "徒勞無益")
    ("도로변"
     "道路邊")
    ("도로이목"
     "道路以目")
    ("도룡지기"
     "屠龍之技")
    ("도루"
     "盜壘")
    ("도루왕"
     "盜壘王")
    ("도류단"
     "桃榴緞")
    ("도륙"
     "屠戮")
    ("도리"
     "道理")
    ("도립"
     "道立")
    ("도망"
     "逃亡")
    ("도망자"
     "逃亡者")
    ("도매"
     "都賣")
    ("도매상"
     "都賣商")
    ("도매업"
     "都賣業")
    ("도매업자"
     "都賣業者")
    ("도면"
     "圖面")
    ("도명"
     "盜名")
    ("도모"
     "圖謀")
    ("도목수"
     "都木手")
    ("도문대작"
     "屠門大嚼")
    ("도미"
     "渡美")
    ("도민"
     "道民")
    ("도박"
     "賭博")
    ("도박장"
     "賭博場")
    ("도발"
     "挑發")
    ("도발적"
     "挑發的")
    ("도배"
     "塗褙")
    ("도배지"
     "塗褙紙")
    ("도벽"
     "盜癖")
    ("도보"
     "徒步")
    ("도부"
     "到付")
    ("도불습유"
     "道不拾遺")
    ("도사"
     "道使"
     "道士")
    ("도산"
     "倒産")
    ("도상"
     "道上")
    ("도상적"
     "圖像的")
    ("도색"
     "塗色"
     "桃色")
    ("도생주의"
     "圖生主義")
    ("도서"
     "圖書"
     "島嶼")
    ("도서관"
     "圖書館")
    ("도서관장"
     "圖書館長")
    ("도서관장실"
     "圖書館長室")
    ("도서관학과"
     "圖書館學科")
    ("도서실"
     "圖書室")
    ("도선"
     "渡船")
    ("도선장"
     "渡船場")
    ("도설"
     "圖說")
    ("도성"
     "都城")
    ("도성제"
     "道聖諦")
    ("도세"
     "道稅")
    ("도소지양"
     "屠所之羊")
    ("도솔천"
     "兜率天")
    ("도수"
     "刀手"
     "度數")
    ("도시"
     "都市"
     "都是")
    ("도시공원"
     "都市公園")
    ("도시과"
     "都市課")
    ("도시국장"
     "都市局長")
    ("도시극"
     "都市劇")
    ("도시인"
     "都市人")
    ("도시적"
     "都市的")
    ("도시형"
     "都市型")
    ("도시화"
     "都市化")
    ("도식"
     "圖式")
    ("도식성"
     "圖式性")
    ("도식적"
     "圖式的")
    ("도식화"
     "圖式化")
    ("도심"
     "盜心"
     "都心")
    ("도심지"
     "都心地")
    ("도심형"
     "倒心形")
    ("도안"
     "圖案")
    ("도안적"
     "圖案的")
    ("도야"
     "陶冶")
    ("도약"
     "跳躍")
    ("도약기"
     "跳躍期")
    ("도약력"
     "跳躍力")
    ("도열"
     "堵列")
    ("도예가"
     "陶藝家")
    ("도예과"
     "陶藝科")
    ("도외시"
     "度外視")
    ("도용"
     "盜用")
    ("도원결의"
     "桃園結義")
    ("도원경"
     "桃源境")
    ("도읍"
     "都邑")
    ("도읍지"
     "都邑地")
    ("도의"
     "道義")
    ("도의원"
     "道議員")
    ("도의적"
     "道義的")
    ("도의회"
     "道議會")
    ("도인"
     "道人")
    ("도입"
     "導入")
    ("도입기"
     "導入期")
    ("도입부"
     "導入部")
    ("도입선"
     "導入船")
    ("도자"
     "陶瓷")
    ("도자기"
     "陶瓷器")
    ("도장"
     "圖章"
     "塗裝"
     "道場")
    ("도저"
     "到底")
    ("도적"
     "盜賊")
    ("도적질"
     "盜賊­")
    ("도전"
     "挑戰")
    ("도전감"
     "挑戰感")
    ("도전력"
     "挑戰力")
    ("도전성"
     "挑戰性")
    ("도전자"
     "挑戰者")
    ("도전작"
     "挑戰作")
    ("도전장"
     "挑戰狀")
    ("도전적"
     "挑戰的")
    ("도정"
     "搗精"
     "道程")
    ("도제"
     "道制")
    ("도조"
     "賭租")
    ("도주"
     "逃走")
    ("도중"
     "途中")
    ("도중예미"
     "塗中曳尾")
    ("도중하차"
     "途中下車")
    ("도증주인"
     "盜憎主人")
    ("도지사"
     "道知事")
    ("도지사실"
     "道知事室")
    ("도착"
     "倒錯"
     "到着")
    ("도착적"
     "倒錯的")
    ("도참설"
     "圖讖說")
    ("도처"
     "到處")
    ("도첩"
     "度牒")
    ("도청"
     "盜聽"
     "道廳")
    ("도청도설"
     "道聽塗說")
    ("도출"
     "導出")
    ("도취"
     "陶醉")
    ("도취경"
     "陶醉境")
    ("도취적"
     "陶醉的")
    ("도측기보"
     "道側奇寶")
    ("도치법"
     "倒置法")
    ("도탄"
     "塗炭")
    ("도탄지고"
     "塗炭之苦")
    ("도태"
     "淘汰")
    ("도통"
     "道統"
     "道通"
     "都統")
    ("도포"
     "道袍")
    ("도표"
     "圖表")
    ("도표화"
     "圖表化")
    ("도피"
     "逃避")
    ("도피구"
     "逃避口")
    ("도피성"
     "逃避性")
    ("도피적"
     "逃避的")
    ("도피주의"
     "逃避主義")
    ("도피처"
     "逃避處")
    ("도하"
     "都下")
    ("도학"
     "道學")
    ("도합"
     "都合")
    ("도해"
     "圖解")
    ("도행역시"
     "倒行逆施")
    ("도형"
     "圖形")
    ("도호"
     "都護")
    ("도호부"
     "都護府")
    ("도화살"
     "桃花煞")
    ("도화선"
     "導火線")
    ("도화지"
     "圖畵紙")
    ("도회적"
     "都會的")
    ("독"
     ("毒" . "독 독")
     ("瀆" . "도랑 독")
     ("牘" . "편지 독")
     ("犢" . "송아지 독")
     ("獨" . "홀로 독")
     ("督" . "감독할 독")
     ("禿" . "대머리 독")
     ("篤" . "도타울 독")
     "纛"
     ("讀" . "읽을 독")
     ("櫝" . "함 독")
     "髑"
     ("黷" . "더러울 독"))
    ("독감"
     "毒感")
    ("독견지명"
     "獨見之明")
    ("독경"
     "讀經")
    ("독과점"
     "獨寡占")
    ("독극물"
     "毒劇物")
    ("독기"
     "毒氣")
    ("독단"
     "獨斷")
    ("독단적"
     "獨斷的")
    ("독대"
     "獨對")
    ("독도법"
     "讀圖法")
    ("독려"
     "督勵")
    ("독력"
     "獨力")
    ("독림가"
     "篤林家")
    ("독립"
     "獨立")
    ("독립국"
     "獨立國")
    ("독립군"
     "獨立軍")
    ("독립당"
     "獨立黨")
    ("독립성"
     "獨立性")
    ("독립심"
     "獨立心")
    ("독립적"
     "獨立的")
    ("독립파"
     "獨立派")
    ("독맥"
     "督脈")
    ("독무"
     "獨舞")
    ("독무대"
     "獨舞臺")
    ("독문과"
     "獨文科")
    ("독문학"
     "獨文學")
    ("독문학과"
     "獨文學科")
    ("독방"
     "獨房")
    ("독백"
     "獨白")
    ("독백체"
     "獨白體")
    ("독법"
     "讀法")
    ("독보"
     "獨步")
    ("독보적"
     "獨步的")
    ("독본"
     "讀本")
    ("독불장군"
     "獨不將軍")
    ("독불장군식"
     "獨不將軍式")
    ("독사"
     "毒蛇")
    ("독사진"
     "獨寫眞")
    ("독살"
     "毒殺"
     "毒煞")
    ("독상"
     "獨床")
    ("독서"
     "讀書")
    ("독서계"
     "讀書界")
    ("독서광"
     "讀書狂")
    ("독서량"
     "讀書量")
    ("독서망양"
     "讀書亡羊")
    ("독서삼매"
     "讀書三昧")
    ("독서삼품과"
     "讀書三品科")
    ("독서실"
     "讀書室")
    ("독서인"
     "讀書人")
    ("독서층"
     "讀書層")
    ("독서파"
     "讀書派")
    ("독선"
     "獨善")
    ("독선기신"
     "獨善其身")
    ("독선생"
     "獨先生")
    ("독선적"
     "獨善的")
    ("독설"
     "毒舌")
    ("독설장"
     "毒舌場")
    ("독성"
     "毒性")
    ("독소"
     "毒素")
    ("독소량"
     "毒素量")
    ("독수공방"
     "獨守空房")
    ("독식"
     "獨食")
    ("독식론"
     "獨食論")
    ("독신"
     "瀆神"
     "獨身")
    ("독신주의"
     "獨身主義")
    ("독신주의자"
     "獨身主義者")
    ("독실"
     "篤實")
    ("독야청청"
     "獨也靑靑")
    ("독약"
     "毒藥")
    ("독어"
     "獨語")
    ("독일"
     "獨逸")
    ("독일어"
     "獨逸語")
    ("독자"
     "獨子"
     "獨自"
     "讀者")
    ("독자란"
     "讀者欄")
    ("독자성"
     "獨自性")
    ("독자적"
     "獨自的")
    ("독자층"
     "讀者層")
    ("독재"
     "獨裁")
    ("독재자"
     "獨裁者")
    ("독재적"
     "獨裁的")
    ("독재화"
     "獨裁化")
    ("독전"
     "督戰")
    ("독점"
     "獨占")
    ("독점권"
     "獨占權")
    ("독점기"
     "獨占期")
    ("독점욕"
     "獨占慾")
    ("독점적"
     "獨占的")
    ("독점화"
     "獨占化")
    ("독종"
     "毒種")
    ("독주"
     "毒酒"
     "獨奏"
     "獨走")
    ("독주회"
     "獨奏會")
    ("독지"
     "篤志")
    ("독지가"
     "篤志家")
    ("독직"
     "瀆職")
    ("독창"
     "獨唱")
    ("독창성"
     "獨創性")
    ("독창적"
     "獨創的")
    ("독초"
     "毒草")
    ("독촉"
     "督促")
    ("독촉장"
     "督促狀")
    ("독충"
     "毒蟲")
    ("독침"
     "毒針")
    ("독특"
     "獨特")
    ("독파"
     "讀破")
    ("독해"
     "讀解")
    ("독후감"
     "讀後感")
    ("돈"
     ("墩" . "돈대 돈")
     ("惇" . "두터울 돈")
     ("敦" . "도타울 돈")
     ("旽" . "늘 돋을 돈")
     ("暾" . "아침해 돈")
     ("沌" . "기름 덩어리 돈")
     ("焞" . "귀갑 지지는 불 돈")
     ("燉" . "불 성할 돈")
     "褪"
     ("豚" . "돼지 돈")
     "遯"
     ("頓" . "조아릴 돈")
     "噸"
     ("弴" . "그림 그린 활 돈")
     ("潡" . "큰 물 돈")
     "瓲"
     ("躉" . "거룻배 돈")
     "鐓")
    ("돈대"
     "墩臺")
    ("돈독"
     "敦篤")
    ("돈사"
     "豚舍")
    ("돈수배"
     "頓首拜")
    ("돈오"
     "頓悟")
    ("돌"
     ("乭" . "이름 돌")
     ("突" . "부딪칠 돌")
     ("咄" . "꾸짖을 돌")
     ("堗" . "굴똑 돌")
     "宊")
    ("돌격대"
     "突擊隊")
    ("돌기"
     "突起")
    ("돌발"
     "突發")
    ("돌발적"
     "突發的")
    ("돌변"
     "突變")
    ("돌연"
     "突然")
    ("돌연변이"
     "突然變異")
    ("돌연사"
     "突然死")
    ("돌입"
     "突入")
    ("돌진"
     "突進")
    ("돌출"
     "突出")
    ("돌출물"
     "突出物")
    ("돌파"
     "突破")
    ("돌파구"
     "突破口")
    ("돌파력"
     "突破力")
    ("돌풍"
     "突風")
    ("동"
     ("仝" . "同의 古字")
     ("冬" . "겨울 동")
     ("凍" . "얼 동")
     ("動" . "움직일 동")
     ("同" . "같을 동")
     ("憧" . "동경할 동")
     ("東" . "동녘 동")
     ("桐" . "오동나무 동")
     ("棟" . "용마루 동")
     ("洞" . "마을 동")
     ("潼" . "물 이름 동")
     ("疼" . "아플 동")
     ("瞳" . "눈동자 동")
     ("童" . "아이 동")
     ("胴" . "큰 창자 동")
     ("董" . "바로잡을 동")
     ("銅" . "구리 동")
     "佟"
     ("侗" . "무지할 동")
     ("僮" . "아이 동")
     ("哃" . "클말할 동")
     ("垌" . "항아리 동")
     ("峒" . "산이름 동")
     ("彤" . "붉은 칠 동")
     ("朣" . "달 뜰 동")
     ("橦" . "나무이름 동")
     ("涷" . "마룻대 동")
     ("艟" . "배 동")
     ("苳" . "겨울살이 동")
     ("茼" . "쏙갓 동")
     ("蕫" . "황모 동")
     ("蝀" . "무지개 동")
     ("錬" . "보습날 동")
     ("鮗" . "전어 동"))
    ("동가홍상"
     "同價紅裳")
    ("동감"
     "同感")
    ("동갑"
     "同甲")
    ("동거"
     "同居")
    ("동거인"
     "同居人")
    ("동격화"
     "同格化")
    ("동결"
     "凍結")
    ("동경"
     "憧憬"
     "東經"
     "銅鏡")
    ("동경심"
     "憧憬心")
    ("동계"
     "冬季"
     "同系")
    ("동고동락"
     "同苦同樂")
    ("동고서저"
     "東高西低")
    ("동공"
     "洞空"
     "瞳孔")
    ("동공이곡"
     "同工異曲")
    ("동구"
     "東歐"
     "洞口")
    ("동구권"
     "東歐圈")
    ("동국"
     "東國")
    ("동굴"
     "洞窟")
    ("동굴성"
     "洞窟性")
    ("동궁제"
     "東宮制")
    ("동귀"
     "同歸")
    ("동기"
     "動機"
     "同期")
    ("동기간"
     "同氣間")
    ("동기생"
     "同期生")
    ("동기적"
     "動機的")
    ("동남"
     "東南")
    ("동남부"
     "東南部")
    ("동내의"
     "冬內衣")
    ("동네방"
     "洞-坊")
    ("동년배"
     "同年輩")
    ("동단"
     "東端")
    ("동대문"
     "東大門")
    ("동대문시장"
     "東大門市場")
    ("동도서말"
     "東塗西抹")
    ("동등"
     "同等")
    ("동란"
     "動亂")
    ("동량"
     "同量")
    ("동량지재"
     "棟梁之材")
    ("동력"
     "動力")
    ("동력원"
     "動力源")
    ("동렬"
     "凍裂"
     "同列")
    ("동료"
     "同僚")
    ("동료애"
     "同僚愛")
    ("동루"
     "東樓")
    ("동류의식"
     "同類意識")
    ("동률"
     "同率")
    ("동리"
     "洞里")
    ("동맥"
     "動脈")
    ("동맹"
     "同盟"
     "東盟")
    ("동맹국"
     "同盟國")
    ("동맹군"
     "同盟軍")
    ("동면"
     "冬眠")
    ("동명"
     "同名"
     "洞名")
    ("동명이인"
     "同名異人")
    ("동모"
     "冬茅")
    ("동문"
     "同門"
     "東門")
    ("동문동궤"
     "同文同軌")
    ("동문서답"
     "東問西答")
    ("동문수학"
     "同文受學"
     "同門受學")
    ("동문회"
     "同門會")
    ("동문회장"
     "同門會長")
    ("동물"
     "動物")
    ("동물상"
     "動物相")
    ("동물성"
     "動物性")
    ("동물원"
     "動物園")
    ("동물적"
     "動物的")
    ("동물학"
     "動物學")
    ("동물학적"
     "動物學的")
    ("동반"
     "同伴"
     "東班")
    ("동반부"
     "東半部")
    ("동반자"
     "同伴者")
    ("동방"
     "東方"
     "東邦")
    ("동방국"
     "東方國")
    ("동방형"
     "東方型")
    ("동방화촉"
     "洞房華燭")
    ("동백"
     "冬柏")
    ("동법"
     "同法")
    ("동병상련"
     "同病相憐")
    ("동복"
     "冬服")
    ("동부"
     "東部")
    ("동부권"
     "東部圈")
    ("동북"
     "東北")
    ("동북부"
     "東北部")
    ("동북향"
     "東北向")
    ("동분서주"
     "東奔西走")
    ("동빙한설"
     "凍氷寒雪")
    ("동사"
     "凍死"
     "同社")
    ("동사무소"
     "洞事務所")
    ("동사자"
     "凍死者")
    ("동산"
     "動産"
     "東山")
    ("동상"
     "銅像")
    ("동상이몽"
     "同床異夢"
     "同牀異夢")
    ("동생"
     "同生")
    ("동서"
     "同壻"
     "東西")
    ("동서고금"
     "東西古今")
    ("동서남북"
     "東西南北")
    ("동서반"
     "東西班")
    ("동서부권"
     "東西部圈")
    ("동서불변"
     "東西不辨")
    ("동서양"
     "東西洋")
    ("동석"
     "同席")
    ("동선"
     "動線")
    ("동선하로"
     "冬扇夏爐")
    ("동섬서홀"
     "東閃西忽")
    ("동성"
     "同姓"
     "同性")
    ("동성애"
     "同性愛")
    ("동성애자"
     "同性愛者")
    ("동성연애"
     "同性戀愛")
    ("동성연애자"
     "同性戀愛者")
    ("동세"
     "動勢")
    ("동수"
     "同數")
    ("동승"
     "同乘"
     "童僧")
    ("동시"
     "同時"
     "童詩")
    ("동시대"
     "同時代")
    ("동시대성"
     "同時代性")
    ("동시대인"
     "同時代人")
    ("동시대적"
     "同時代的")
    ("동시성"
     "同時性")
    ("동시적"
     "同時的")
    ("동시통역"
     "同時通譯")
    ("동식물"
     "動植物")
    ("동식서숙"
     "東食西宿")
    ("동실동거"
     "同室同居")
    ("동실제"
     "同室制")
    ("동심"
     "童心")
    ("동심동력"
     "同心同力")
    ("동심원"
     "同心圓")
    ("동심지언"
     "同心之言")
    ("동안"
     "童顔")
    ("동양"
     "東洋")
    ("동양권"
     "東洋圈")
    ("동양란"
     "東洋蘭")
    ("동양사"
     "東洋史")
    ("동양사학과"
     "東洋史學科")
    ("동양식"
     "東洋式")
    ("동양인"
     "東洋人")
    ("동양적"
     "東洋的")
    ("동양학"
     "東洋學")
    ("동양화"
     "東洋畵")
    ("동양화가"
     "東洋畵家")
    ("동어"
     "同語")
    ("동업"
     "同業")
    ("동업자"
     "同業者")
    ("동영상"
     "動映像")
    ("동요"
     "動搖"
     "童謠")
    ("동우회"
     "同友會")
    ("동우회장"
     "同友會長")
    ("동원"
     "動員")
    ("동원력"
     "動員力")
    ("동원령"
     "動員令")
    ("동위"
     "同位")
    ("동의"
     "動議"
     "同意"
     "同議")
    ("동의권"
     "同意權")
    ("동의서"
     "同意書")
    ("동의안"
     "動議案")
    ("동의어"
     "同義語")
    ("동의제"
     "動議制")
    ("동의학"
     "東醫學")
    ("동이불화"
     "同而不和")
    ("동인"
     "動因"
     "同人")
    ("동인회"
     "同人會")
    ("동일"
     "同一")
    ("동일계"
     "同一系")
    ("동일성"
     "同一性")
    ("동일시"
     "同一視")
    ("동일인"
     "同一人")
    ("동일체"
     "同一體")
    ("동일화"
     "同一化")
    ("동자"
     "瞳子"
     "童子")
    ("동자승"
     "童子僧")
    ("동자주"
     "童子柱")
    ("동작"
     "動作")
    ("동장"
     "洞長")
    ("동적"
     "動的")
    ("동전"
     "銅錢")
    ("동점"
     "同點")
    ("동접"
     "同接")
    ("동정"
     "動靜"
     "同情"
     "童貞")
    ("동정남"
     "童貞男")
    ("동정론"
     "同情論")
    ("동정심"
     "同情心")
    ("동정적"
     "同情的")
    ("동정표"
     "同情票")
    ("동조"
     "同調")
    ("동조자"
     "同調者")
    ("동족"
     "同族")
    ("동족방뇨"
     "凍足放尿")
    ("동족상잔"
     "同族相殘")
    ("동종"
     "同種"
     "銅鐘")
    ("동주서고"
     "東走西顧")
    ("동지"
     "冬至"
     "同志")
    ("동지가"
     "同志歌")
    ("동지사"
     "冬至使")
    ("동지애"
     "同志愛")
    ("동지적"
     "同志的")
    ("동진"
     "東進")
    ("동질"
     "同質")
    ("동질감"
     "同質感")
    ("동질성"
     "同質性")
    ("동질적"
     "同質的")
    ("동질화"
     "同質化")
    ("동짓"
     "冬至")
    ("동참"
     "同參")
    ("동창"
     "同窓"
     "東窓")
    ("동창생"
     "同窓生")
    ("동창회"
     "同窓會")
    ("동창회장"
     "同窓會長")
    ("동체"
     "凍體"
     "胴體")
    ("동초"
     "動哨")
    ("동취서대"
     "東取西貸")
    ("동침"
     "同寢")
    ("동태"
     "凍太"
     "動態")
    ("동토"
     "凍土")
    ("동토대"
     "凍土帶")
    ("동판"
     "銅板"
     "銅版")
    ("동편"
     "東便")
    ("동포"
     "同胞")
    ("동포애"
     "同胞愛")
    ("동표서랑"
     "東漂西浪")
    ("동풍"
     "東風")
    ("동학"
     "同學")
    ("동해양진"
     "東海揚塵")
    ("동행"
     "同行")
    ("동행인"
     "同行人")
    ("동향"
     "動向"
     "同鄕"
     "東向")
    ("동헌"
     "東軒")
    ("동호인"
     "同好人")
    ("동호회"
     "同好會")
    ("동화"
     "同化"
     "童話")
    ("동화적"
     "童話的")
    ("동화집"
     "童話集")
    ("동화책"
     "童話冊")
    ("두"
     ("兜" . "투구 두")
     ("斗" . "말 두")
     ("杜" . "막을 두")
     ("枓" . "두공 두")
     ("痘" . "마마 두")
     ("竇" . "구멍 두")
     ("荳" . "콩 두")
     ("豆" . "콩 두")
     ("逗" . "머무를 두")
     ("頭" . "머리 두")
     ("讀" . "구절 두")
     "吋"
     ("抖" . "퍼주거릴 두")
     ("斁" . "섞을 두")
     ("肚" . "밥통 두")
     ("脰" . "목 두")
     ("蚪" . "올챙이 두")
     ("蠹" . "좀 두")
     ("陡" . "절벽 두"))
    ("두각"
     "頭角")
    ("두개골"
     "頭蓋骨")
    ("두견"
     "杜鵑")
    ("두관"
     "頭冠")
    ("두구탄성"
     "杜口呑聲")
    ("두규음"
     "頭竅陰")
    ("두냉증"
     "頭冷症")
    ("두뇌"
     "頭腦")
    ("두뇌적"
     "頭腦的")
    ("두둔"
     "斗頓")
    ("두령"
     "頭領")
    ("두목"
     "頭目")
    ("두문"
     "杜門")
    ("두문불출"
     "杜門不出")
    ("두발"
     "頭髮")
    ("두부"
     "豆腐")
    ("두부과분"
     "豆剖瓜分")
    ("두상"
     "頭像")
    ("두서"
     "頭緖")
    ("두식"
     "頭飾")
    ("두앙선"
     "頭央線")
    ("두절"
     "杜絶")
    ("두주불사"
     "斗酒不辭")
    ("두찬"
     "杜撰")
    ("두통"
     "頭痛")
    ("두품"
     "頭品")
    ("두한족열"
     "頭寒足熱")
    ("둔"
     ("屯" . "진칠 둔")
     ("臀" . "볼기 둔")
     ("芚" . "채소 이름 둔")
     ("遁" . "달아날 둔")
     ("遯" . "달아날 둔")
     ("鈍" . "무딜 둔")
     ("窀" . "광중 둔")
     ("迍" . "머뭇거릴 둔"))
    ("둔감"
     "鈍感")
    ("둔감성"
     "鈍感性")
    ("둔갑"
     "遁甲")
    ("둔강"
     "鈍羌")
    ("둔기"
     "鈍器")
    ("둔부"
     "臀部")
    ("둔사"
     "遁辭")
    ("둔전"
     "屯田")
    ("둔중"
     "鈍重")
    ("둔탁"
     "鈍濁")
    ("둔화"
     "鈍化")
    ("둘"
     ("乧" . "음역자 둘"))
    ("뒷정리"
     "­整理")
    ("득"
     ("得" . "얻을 득"))
    ("득남"
     "得男")
    ("득도"
     "得道")
    ("득롱망촉"
     "得롱望蜀")
    ("득세"
     "得勢")
    ("득수"
     "得水")
    ("득실"
     "得失")
    ("득어망전"
     "得魚忘筌")
    ("득의"
     "得意")
    ("득의만만"
     "得意滿滿")
    ("득의만면"
     "得意滿面")
    ("득의양양"
     "得意揚揚")
    ("득점"
     "得點")
    ("득점력"
     "得點力")
    ("득점상"
     "得點賞")
    ("득점왕"
     "得點王")
    ("득점원"
     "得點原")
    ("득점포"
     "得點砲")
    ("득표"
     "得票")
    ("득표력"
     "得票力")
    ("득표율"
     "得票率")
    ("득표자"
     "得票者")
    ("득표전"
     "得票戰")
    ("등"
     ("嶝" . "고개 등")
     ("橙" . "등자나무 등")
     ("燈" . "등잔 등")
     ("登" . "오를 등")
     ("等" . "가지런할 등")
     ("藤" . "등나무 등")
     ("謄" . "베낄 등")
     ("鄧" . "나라 이름 등")
     ("騰" . "오를 등")
     ("凳" . "걸상 등")
     ("墱" . "자드락길 등")
     ("滕" . "물 솟을 등")
     ("灯" . "燈의 略字")
     ("磴" . "돌 비탈길 등")
     ("籐" . "대 기구 등")
     ("縢" . "봉할 등")
     ("螣" . "등사 등")
     ("鐙" . "등자 등"))
    ("등가"
     "等價")
    ("등가구"
     "藤家具")
    ("등고선"
     "等高線")
    ("등고자비"
     "登高自卑")
    ("등공예"
     "藤工藝")
    ("등과"
     "登科")
    ("등교"
     "登校")
    ("등굣"
     "登校")
    ("등극"
     "登極")
    ("등급"
     "等級")
    ("등급제"
     "等級制")
    ("등기"
     "登記")
    ("등기부"
     "登記簿")
    ("등기소"
     "登記所")
    ("등단"
     "登壇")
    ("등대"
     "燈臺")
    ("등댓"
     "燈臺")
    ("등등"
     "等等"
     "騰騰")
    ("등락"
     "騰落")
    ("등록"
     "登錄")
    ("등록금"
     "登錄金")
    ("등록료"
     "登錄料")
    ("등록부"
     "登錄簿")
    ("등록비"
     "登錄費")
    ("등록인"
     "登錄人")
    ("등록자"
     "登錄者")
    ("등록제"
     "登錄制")
    ("등록증"
     "登錄證")
    ("등록지"
     "登錄地")
    ("등루거제"
     "登樓去梯")
    ("등반"
     "登攀")
    ("등반가"
     "登攀家")
    ("등벽"
     "登壁")
    ("등본"
     "謄本")
    ("등분"
     "等分")
    ("등사판"
     "謄寫版")
    ("등산"
     "登山")
    ("등산가"
     "登山家")
    ("등산객"
     "登山客")
    ("등산로"
     "登山路")
    ("등산모"
     "登山帽")
    ("등산복"
     "登山服")
    ("등산인"
     "登山人")
    ("등산지"
     "登山地")
    ("등산화"
     "登山靴")
    ("등성"
     "等星")
    ("등속"
     "等屬"
     "等速")
    ("등수"
     "等數")
    ("등식"
     "等式")
    ("등신"
     "等神")
    ("등용"
     "登用")
    ("등용문"
     "登龍門")
    ("등유"
     "燈油")
    ("등의자"
     "藤椅子")
    ("등잔"
     "燈盞")
    ("등장"
     "登場")
    ("등장인물"
     "登場人物")
    ("등재"
     "登載")
    ("등정"
     "登程"
     "登頂")
    ("등정로"
     "登頂路")
    ("등지"
     "等地")
    ("등차"
     "等次")
    ("등퇴장"
     "登退場")
    ("등판"
     "登板")
    ("등하불명"
     "燈下不明")
    ("등학로"
     "登學路")
    ("등한시"
     "等閑視")
    ("등화가친"
     "燈火可親")
    ("등화지희"
     "燈火之喜")
    ("똥칠"
     "­漆")
    ("라"
     ("懶" . "게으를 라")
     ("癩" . "약물 중독 라")
     ("羅" . "새그물 라")
     ("蘿" . "무 라")
     ("螺" . "소라 라")
     ("裸" . "벌거벗을 라")
     ("邏" . "순행할 라")
     ("拏" . "붙잡을 라")
     ("倮" . "알몸 라")
     ("囉" . "소리 읽힐 라")
     ("曪" . "날 흐릴 라")
     ("瘰" . "연주창 라")
     ("臝" . "벌거벗을 라")
     ("鑼" . "징 라")
     ("騾" . "노새 라")
     ("驘" . "옹 솥 라"))
    ("락"
     ("洛" . "강이름 락")
     ("烙" . "지질 락")
     ("珞" . "구슬 목걸이 락")
     ("絡" . "헌솜 락")
     ("落" . "떨어질 락")
     ("酪" . "진한 유즙 락")
     ("駱" . "낙타 락")
     ("樂" . "즐거울 락")
     ("諾" . "대답할 락")
     "嗠"
     ("犖" . "얼룩소 락"))
    ("란"
     ("亂" . "어지러울 란")
     ("卵" . "알 란")
     ("懶" . "게으를 란")
     ("欄" . "난간 란")
     ("欒" . "나무 이름 란")
     ("瀾" . "물결 란")
     ("爛" . "문드러질 란")
     ("蘭" . "난초 란")
     ("鸞" . "난새 란")
     ("丹" . "붉을 란")
     ("嬾" . "게으를 란")
     ("幱" . "내리다지 란")
     ("攔" . "막을 란")
     ("灓" . "적실 란")
     ("襴" . "난삼 란")
     ("鑾" . "방울 란")
     ("闌" . "가막을 란"))
    ("랄"
     ("剌" . "어그러질 랄")
     ("喇" . "말굽히할 랄")
     ("辣" . "매울 랄")
     ("埒" . "바자울 랄")
     ("辢" . "辣과 同字"))
    ("람"
     ("嵐" . "남기 람")
     ("擥" . "攬과 同字")
     ("攬" . "잡을 람")
     ("欖" . "감람나무 람")
     ("濫" . "퍼질 람")
     ("籃" . "바구니 람")
     ("纜" . "닻줄 람")
     ("藍" . "쪽 람")
     ("襤" . "누더기 람")
     ("覽" . "볼 람")
     ("婪" . "탐할 람")
     ("惏" . "떨릴 람"))
    ("랍"
     ("拉" . "꺽을 랍")
     "摺"
     ("臘" . "납향 랍")
     ("蠟" . "밀 랍")
     ("鑞" . "땜납 랍"))
    ("랑"
     ("廊" . "복도 랑")
     ("朗" . "밝을 랑")
     ("浪" . "물결 랑")
     "瀧"
     ("狼" . "이리 랑")
     ("琅" . "옥 이름 랑")
     ("瑯" . "고을 이름 랑")
     ("螂" . "蜋과 同字")
     ("郞" . "사나이 랑")
     ("榔" . "나무 이름 랑")
     ("硠" . "돌 부딪는 소라 랑")
     ("稂" . "강아지 풀 랑")
     ("莨" . "수크령 랑")
     ("蜋" . "사마귀 랑")
     "踉"
     ("閬" . "솟을 대문 랑"))
    ("래"
     ("來" . "올 래")
     ("崍" . "산 이름 래")
     ("徠" . "올 래")
     ("萊" . "명아주 래")
     "賚"
     ("淶" . "강 이름 래")
     "顂"
     ("騋" . "큰 말 래"))
    ("랭"
     ("冷" . "찰 랭"))
    ("략"
     ("掠" . "노략질할 략")
     ("略" . "다스릴 략")
     "攊"
     ("畧" . "略과 同字"))
    ("량"
     ("亮" . "밝을 량")
     ("倆" . "재주 량")
     ("兩" . "두 량")
     ("凉" . "涼의 俗字")
     "場"
     ("梁" . "푸조나무 량")
     ("樑" . "서늘할 량")
     ("粮" . "糧과 同字")
     ("粱" . "기장 량")
     ("糧" . "양식 량")
     ("良" . "좋을 량")
     ("諒" . "믿을 량")
     ("輛" . "수레 량")
     ("量" . "헤아릴 량")
     ("喨" . "소리 맑을 량")
     ("悢" . "슬퍼할 량")
     ("椋" . "들보 량")
     ("涼" . "서늘할 량")
     ("踉" . "뛸 량")
     ("魎" . "도깨비 량"))
    ("려"
     ("侶" . "짝 려")
     ("儷" . "짝 려")
     ("勵" . "힘쓸 려")
     ("呂" . "음률 려")
     ("廬" . "오두막집 려")
     ("慮" . "생각할 려")
     ("戾" . "여그러질 려")
     ("旅" . "군사 려")
     ("櫚" . "종려나무 려")
     ("濾" . "겨를 려")
     "犁"
     ("礪" . "거친 숫돌 려")
     ("藜" . "나라 이름 려")
     ("蠣" . "굴 려")
     ("閭" . "이문 려")
     ("驢" . "나귀 려")
     ("驪" . "가라말 려")
     ("麗" . "고울 려")
     ("黎" . "검을 려")
     ("儢" . "맘에 하기 싫을 려")
     ("厲" . "갈 려")
     ("唳" . "울 려")
     ("梠" . "평고대 려")
     ("癘" . "창질 려")
     ("糲" . "현미 려")
     ("膂" . "등골 뼈 려")
     ("臚" . "살갗 려")
     ("蠡" . "좀먹을 려")
     ("邌" . "천천히 걸을 려")
     ("鑢" . "줄 려"))
    ("력"
     ("力" . "힘 력")
     ("曆" . "책력 력")
     ("歷" . "지낼 력")
     ("瀝" . "거를 력")
     ("礫" . "조약돌 력")
     ("轢" . "삐걱거릴 력")
     ("靂" . "벼락 력")
     "攊"
     ("櫟" . "상수리나무 력")
     ("櫪" . "말구유 력")
     ("癧" . "연주창 력")
     ("轣" . "갈 력")
     ("酈" . "땅 이름 력")
     "鬲")
    ("련"
     ("怜" . "연리할 련")
     ("憐" . "불쌍히 여길 련")
     ("戀" . "사모할 련")
     ("攣" . "걸릴 련")
     ("漣" . "물놀이 련")
     ("煉" . "불릴 련")
     ("璉" . "호련 련")
     ("練" . "익힐 련")
     ("聯" . "잇달 련")
     ("蓮" . "연밥 련")
     ("輦" . "손수레 련")
     ("連" . "잇닿을 련")
     ("鍊" . "불릴 련")
     ("孌" . "아름다울 련")
     "孿"
     ("楝" . "멀구슬나무 련")
     ("湅" . "누일 련")
     ("臠" . "저민고기 련")
     "錬"
     ("鏈" . "쇠사슬 련")
     ("鰊" . "고기 이름 련")
     ("鰱" . "연어 련"))
    ("렬"
     ("冽" . "찰 렬")
     ("列" . "줄 렬")
     ("劣" . "못할 렬")
     ("洌" . "맑을 렬")
     ("烈" . "세찰 렬")
     ("裂" . "찢을 렬")
     "挒"
     ("捩" . "비틀 렬")
     ("颲" . "사나운 바람 렬"))
    ("렴"
     ("廉" . "청렴할 렴")
     ("斂" . "거둘 렴")
     ("殮" . "염할 렴")
     ("濂" . "내 이름 렴")
     ("簾" . "발 렴")
     ("奩" . "화장 상자 렴")
     "歛"
     ("瀲" . "넘칠 렴")
     "獫"
     ("磏" . "거친 숫돌 렴")
     "籟")
    ("렵"
     ("獵" . "사냥 렵")
     ("躐" . "밟을 렵")
     ("鬣" . "갈기 렵"))
    ("령"
     ("令" . "명령 령, 시킬 령")
     ("伶" . "영리할 령, 악공 령, 광대 령")
     ("囹" . "옥 령")
     ("岺" . "재 령")
     ("嶺" . "재 령")
     ("怜" . "영리할 령")
     ("玲" . "옥이름 령")
     ("笭" . "도꼬마리 령")
     ("羚" . "영양 령")
     ("翎" . "깃 령")
     ("聆" . "들을 령")
     ("逞" . "굳셀 령")
     ("鈴" . "방울 령")
     ("零" . "조용히 오는 비 령")
     ("靈" . "신령 령")
     ("領" . "옷깃 령")
     ("齡" . "나이 령")
     ("寧" . "편안할 령")
     ("另" . "나눌 령, 다를 령, 헤어질 령")
     ("呤" . "속삭일 령")
     ("姈" . "계집 슬기로울 령")
     ("岭" . "산 이름 령")
     ("昤" . "날 빛 영롱할 령")
     ("欞" . "격자창 령")
     ("泠" . "깨우칠 령")
     ("秢" . "벼 처음 익을 령")
     ("苓" . "도꼬마리 령")
     ("蛉" . "장자리 령")
     ("軨" . "사냥 수레 령")
     ("鴒" . "할미새 령")
     ("鹷" . "나이 령"))
    ("례"
     ("例" . "법식 례")
     ("澧" . "강 이름 례")
     ("禮" . "예도 례")
     ("豊" . "禮의 古字")
     ("醴" . "단술 례")
     ("隷" . "隸와 同字")
     ("隸" . "붙을 례")
     ("鱧" . "가물치 례"))
    ("로"
     ("勞" . "일할 로")
     ("撈" . "잡을 로")
     ("擄" . "사로잡을 로")
     ("櫓" . "방패 로")
     ("潞" . "강 이름 로")
     ("瀘" . "강 이름 로")
     ("爐" . "화로 로")
     ("盧" . "밥그릇 로")
     ("老" . "늙은이 로")
     "芦"
     ("蘆" . "갈대 로")
     ("虜" . "포로 로")
     ("路" . "길 로")
     ("輅" . "수레 로")
     ("露" . "이슬 로")
     ("魯" . "노둔할 로")
     ("鷺" . "해오라기 로")
     ("鹵" . "소금 로")
     ("怒" . "성냉 로")
     ("壚" . "흑토 로")
     ("滷" . "소금밭 로")
     "潦"
     ("玈" . "검을 로")
     ("癆" . "종독 로")
     "磠"
     ("窂" . "우리 로")
     ("艪" . "艫와 同字")
     ("艫" . "뱃머리 로")
     ("轤" . "고패 로")
     ("鐪" . "부레 로")
     ("鑪" . "화로 로")
     ("顱" . "머리뼈 로")
     "騾"
     ("髗" . "해골 로")
     ("鱸" . "농어 로")
     ("鸕" . "가마우지 로"))
    ("록"
     ("碌" . "돌 모양 록")
     ("祿" . "복 록")
     ("綠" . "초록빛 록")
     ("菉" . "조개풀 록")
     ("錄" . "기록할 록")
     ("鹿" . "사슴 록")
     ("麓" . "신기슭 록")
     ("圥" . "버섯 록")
     ("彔" . "나무 깍을 록")
     ("淥" . "밭을 록")
     ("漉" . "거를 록")
     ("簏" . "대 상자 록")
     ("轆" . "도르래 록")
     ("騄" . "말이름 록"))
    ("론"
     ("論" . "말할 론")
     "掄")
    ("롱"
     ("壟" . "언덕 롱")
     ("弄" . "희롱할 롱")
     ("朧" . "흐릿할 롱")
     "瀧"
     "瓏"
     ("籠" . "대그릇 롱")
     ("聾" . "귀머거리 롱")
     "龐"
     ("儱" . "건목칠 롱")
     ("攏" . "누를 롱")
     ("曨" . "어스레할 롱")
     ("礱" . "갈 롱")
     ("蘢" . "개여뀌 롱")
     ("隴" . "고개 이름 롱")
     "龎")
    ("뢰"
     ("儡" . "영락할 뢰")
     ("瀨" . "여울 뢰")
     ("牢" . "우리 뢰")
     ("磊" . "돌무더기 뢰")
     ("賂" . "뇌물 줄 뢰")
     ("賚" . "줄 뢰")
     ("賴" . "힘 입을 뢰")
     ("雷" . "우뢰 뢰")
     "攂"
     ("礌" . "돌 굴러내릴 뢰")
     ("礧" . "바위너설 뢰")
     ("纇" . "실 마디 뢰")
     ("罍" . "술독 뢰")
     ("耒" . "쟁기 뢰")
     ("蕾" . "꽃봉오리 뢰")
     ("誄" . "뇌사 뢰")
     ("酹" . "부을 뢰"))
    ("료"
     ("了" . "마칠 료")
     ("僚" . "동료 료")
     ("寥" . "쓸쓸할 료")
     ("寮" . "벼슬아쳐 료")
     ("廖" . "공허할 료")
     ("料" . "되질할 료")
     ("燎" . "화톳불 료")
     ("療" . "병고칠 료")
     ("瞭" . "밝을 료")
     ("聊" . "귀 울 료")
     ("蓼" . "여뀌 료")
     ("遼" . "멀 료")
     ("嘹" . "울 료")
     ("嫽" . "외조모 료")
     ("撩" . "다스릴 료")
     ("暸" . "밝을 료")
     ("潦" . "큰 비 료")
     ("獠" . "밤사냥 료")
     ("繚" . "감길 료")
     ("膋" . "발기름 료")
     ("醪" . "막걸리 료")
     ("鐐" . "은 료")
     ("飂" . "높이 부는 바람 료")
     ("飉" . "바람 료"))
    ("룡"
     ("龍" . "용 룡")
     ("龒" . "龍의 古字"))
    ("루"
     ("壘" . "진 루")
     ("婁" . "별 이름 루")
     ("屢" . "창 루")
     ("樓" . "다락 루")
     ("淚" . "눈물 루")
     ("漏" . "샐 루")
     ("瘻" . "부스럼 루")
     ("累" . "묶을 루")
     ("縷" . "실 루")
     ("蔞" . "쑥 루")
     ("褸" . "남루할 루")
     ("鏤" . "새길 루")
     ("陋" . "줍을 루")
     ("僂" . "구부릴 루")
     ("嘍" . "시끄러울 루")
     ("嶁" . "봉우리 루")
     ("慺" . "정성스러울 루")
     ("耬" . "씨 뿌리는 기구 루")
     ("螻" . "땅강아지 루")
     ("髏" . "해굴 루"))
    ("류"
     ("劉" . "죽일 류")
     ("旒" . "깃발 류")
     ("柳" . "버들 류")
     ("榴" . "석류나무 류")
     ("流" . "흐를 류")
     ("溜" . "방울져 떨어질 류")
     ("瀏" . "맑을 류")
     ("琉" . "유리 류")
     ("瑠" . "琉와 同字")
     ("留" . "머무를 류")
     ("瘤" . "혹 류")
     ("硫" . "유황 류")
     "繆"
     ("謬" . "그릇될 류")
     ("類" . "무리 류")
     ("橊" . "榴의 本字")
     ("縲" . "포승 류")
     ("纍" . "갇힐 류")
     ("遛" . "머무를 류")
     "飂"
     ("鶹" . "올빼미 류"))
    ("륙"
     ("六" . "여섯 륙")
     ("戮" . "죽일 륙")
     ("陸" . "뭍 륙")
     ("勠" . "협력할 륙"))
    ("륜"
     ("侖" . "둥글 륜")
     ("倫" . "인륜 륜")
     ("崙" . "산 이름 륜")
     ("淪" . "물놀이 륜")
     ("綸" . "낚싯줄 륜")
     ("輪" . "바퀴 륜")
     ("掄" . "가릴 륜"))
    ("률"
     ("律" . "법 률")
     ("慄" . "두려워할 률")
     ("栗" . "밤나무 률")
     ("率" . "헤아릴 률")
     ("嵂" . "가파를 률")
     ("溧" . "강 이름 률"))
    ("륭"
     "瀜"
     ("隆" . "클 륭")
     ("癃" . "느른할 륭")
     ("窿" . "활꼴 륭"))
    ("륵"
     ("勒" . "굴레 륵")
     ("肋" . "갈비 륵")
     ("泐" . "돌 갈라질 륵"))
    ("름"
     ("凜" . "찰 름")
     ("凛" . "찰 름")
     ("廩" . "곳집 름")
     ("澟" . "서늘할 름"))
    ("릉"
     ("凌" . "능가할 릉")
     ("楞" . "모 릉")
     ("稜" . "모 릉")
     ("綾" . "비단 릉")
     ("菱" . "蔆과 同字")
     ("陵" . "큰 언덕 릉")
     ("倰" . "속일 릉")
     ("蔆" . "마름 릉"))
    ("리"
     ("俚" . "속될 리")
     ("利" . "날카로울 리")
     ("厘" . "釐의 俗字")
     ("吏" . "벼슬아치 리")
     ("唎" . "가는 소리 리")
     ("履" . "신 리")
     ("悧" . "영리할 리")
     ("李" . "오얏 리")
     ("梨" . "태나무 리")
     ("浬" . "해리 리")
     ("犁" . "얼룩소 리")
     ("狸" . "貍와 同字")
     ("理" . "다스릴 리")
     ("璃" . "유리 리")
     ("痢" . "설사 리")
     ("籬" . "울타리 리")
     ("罹" . "근심 리")
     ("羸" . "여윌 리")
     ("莉" . "말리 리")
     ("裏" . "속 리")
     ("裡" . "裏와 同字")
     ("里" . "마을 리")
     ("釐" . "다스릴 리")
     ("離" . "떼 놓을 리")
     "驪"
     ("鯉" . "잉어 리")
     ("異" . "다를 리")
     ("俐" . "똑똑할 리")
     ("剺" . "벗길 리")
     ("哩" . "어조사 리")
     ("嫠" . "과부 리")
     ("涖" . "다다를 리")
     ("漓" . "스며들 리")
     ("离" . "산신 리")
     ("莅" . "다다를 리")
     ("蜊" . "참조개 리")
     ("螭" . "교륭 리")
     ("貍" . "삵 리")
     ("邐" . "이어질 리")
     ("魑" . "도깨비 리")
     ("黐" . "끈끈이 리"))
    ("린"
     ("吝" . "아낄 린")
     ("潾" . "맑을 린")
     ("燐" . "도깨비불 린")
     ("璘" . "옥빛 린")
     ("藺" . "골풀 린")
     ("躪" . "짓밟을 린")
     ("隣" . "鄰의 俗字")
     ("鱗" . "비늘 린")
     ("麟" . "기린 린")
     ("嶙" . "가파를 린")
     ("悋" . "아낄 린")
     ("獜" . "튼튼할 린")
     ("磷" . "돌 을 틈물이 흐르는 모양 린")
     ("粦" . "도깨비 불 린")
     ("粼" . "물 맑을 린")
     ("繗" . "이을 린")
     ("躙" . "짓밟을 린")
     ("轔" . "수레 소리 린")
     ("鄰" . "이웃 린")
     ("鏻" . "굳셀 린")
     ("驎" . "워라말 린"))
    ("림"
     ("林" . "수풀 림")
     ("淋" . "물뿌릴 림")
     ("琳" . "아름다운 옥 림")
     ("臨" . "임할 림")
     ("霖" . "장마 림")
     "惏"
     ("痳" . "임질 림"))
    ("립"
     ("砬" . "돌 소리 립")
     ("立" . "설 립")
     ("笠" . "우리 립")
     ("粒" . "알 립")
     ("岦" . "산 우뚝할 립"))
    ("마"
     ("摩" . "갈 마")
     ("瑪" . "마노 마")
     ("痲" . "저릴 마")
     ("碼" . "마노 마")
     ("磨" . "갈 마")
     ("馬" . "말 마")
     ("魔" . "마귀 마")
     ("麻" . "삼 마")
     ("劘" . "깍을 마")
     ("媽" . "어미 마")
     ("螞" . "말거머리 마")
     ("蟇" . "개구리 마")
     ("麽" . "잘 마")
     ("麿" . "갈 마"))
    ("마각노출"
     "馬脚露出")
    ("마구"
     "馬具")
    ("마구간"
     "馬廐間")
    ("마귀"
     "魔鬼")
    ("마니"
     "摩尼")
    ("마대"
     "麻袋")
    ("마량백미"
     "馬良白眉")
    ("마력"
     "馬力"
     "魔力")
    ("마리전"
     "麻履典")
    ("마립간"
     "麻立干")
    ("마모"
     "磨耗")
    ("마법"
     "魔法")
    ("마법사"
     "魔法師")
    ("마부"
     "馬夫")
    ("마부위침"
     "磨斧爲針")
    ("마분지"
     "馬糞紙")
    ("마비"
     "痲痺")
    ("마비성"
     "痲痺性")
    ("마상의"
     "馬上衣")
    ("마상재"
     "馬上才")
    ("마섬유"
     "麻纖維")
    ("마성적"
     "魔性的")
    ("마수"
     "魔手")
    ("마수모장"
     "馬瘦毛長")
    ("마술"
     "魔術")
    ("마술사"
     "魔術師")
    ("마술적"
     "魔術的")
    ("마약"
     "痲藥")
    ("마약상"
     "痲藥商")
    ("마약적"
     "痲藥的")
    ("마왕"
     "魔王")
    ("마이동풍"
     "馬耳東風")
    ("마적단"
     "馬賊團")
    ("마중지봉"
     "麻中之蓬")
    ("마직물"
     "麻織物")
    ("마차"
     "馬車")
    ("마찰"
     "摩擦")
    ("마찰력"
     "摩擦力")
    ("마찰적"
     "摩擦的")
    ("마천루"
     "摩天樓")
    ("마취"
     "痲醉")
    ("마취과"
     "痲醉科")
    ("마취제"
     "痲醉劑")
    ("마파두부"
     "麻婆豆腐")
    ("마포"
     "麻布")
    ("막"
     ("寞" . "쓸쓸할 막")
     ("幕" . "막 막")
     ("漠" . "사막 막")
     ("膜" . "막 막")
     ("莫" . "없을 막")
     ("邈" . "멀 막")
     ("瞙" . "눈 흐릴 막")
     "藐"
     ("鏌" . "칼 이름 막"))
    ("막강"
     "莫强")
    ("막노동"
     "­勞動")
    ("막대"
     "莫大")
    ("막론"
     "莫論")
    ("막료"
     "幕僚")
    ("막막"
     "寞寞"
     "漠漠")
    ("막막궁산"
     "寞寞窮山")
    ("막무가내"
     "莫無可奈")
    ("막사"
     "幕舍")
    ("막상막하"
     "莫上莫下")
    ("막역"
     "莫逆")
    ("막역지우"
     "莫逆之友")
    ("막연"
     "漠然")
    ("막중"
     "莫重")
    ("막천석지"
     "幕天席地")
    ("막하"
     "幕下")
    ("막후"
     "幕後")
    ("만"
     ("万" . "일만 만")
     ("卍" . "만자 만")
     ("娩" . "해산할 만")
     ("巒" . "뫼 만")
     ("彎" . "굽을 만")
     ("慢" . "게으를 만")
     ("挽" . "당길 만")
     ("晩" . "저물 만")
     ("曼" . "끌 만")
     ("滿" . "찰 만")
     ("漫" . "질펀할 만")
     ("灣" . "물굽이 만")
     ("瞞" . "속일 만")
     ("萬" . "일만 만")
     ("蔓" . "덩굴 만")
     ("蠻" . "오랑캐 만")
     ("輓" . "끌 만")
     ("饅" . "만두 만")
     ("鰻" . "뱀장어 만")
     ("墁" . "흙손 만")
     ("嫚" . "업신여길 만")
     ("幔" . "막 만")
     "悗"
     "懣"
     ("縵" . "무늬 없는 비단 만")
     ("謾" . "속일 만")
     ("蹣" . "비틀거릴 만")
     ("鏋" . "금 만")
     ("鏝" . "흙손 만")
     ("鬘" . "머리장식 만"))
    ("만각"
     "晩覺")
    ("만감"
     "萬感")
    ("만개"
     "滿開")
    ("만개형"
     "滿開型")
    ("만경창파"
     "萬頃蒼波")
    ("만고"
     "萬古")
    ("만고불변"
     "萬古不變")
    ("만고상청"
     "萬古常靑")
    ("만고풍상"
     "萬古風霜")
    ("만구일담"
     "萬口一談")
    ("만국"
     "萬國")
    ("만군"
     "滿軍")
    ("만근"
     "滿勤")
    ("만기"
     "滿期")
    ("만기일"
     "滿期日")
    ("만끽"
     "滿喫")
    ("만날만"
     "萬-萬")
    ("만년"
     "晩年"
     "萬年")
    ("만년필"
     "萬年筆")
    ("만능"
     "萬能")
    ("만능인"
     "萬能人")
    ("만능주의"
     "萬能主義")
    ("만단수심"
     "萬端愁心")
    ("만당"
     "晩唐")
    ("만두"
     "饅頭")
    ("만둣"
     "饅頭")
    ("만료"
     "滿了")
    ("만류"
     "挽留")
    ("만리타국"
     "萬里他國")
    ("만리타향"
     "萬里他鄕")
    ("만만"
     "滿滿")
    ("만만부당"
     "萬萬不當")
    ("만만세"
     "萬萬歲")
    ("만면"
     "滿面")
    ("만면희색"
     "滿面喜色")
    ("만무"
     "萬無")
    ("만물"
     "萬物")
    ("만물박사"
     "萬物博士")
    ("만물상"
     "萬物商")
    ("만민"
     "萬民")
    ("만반"
     "萬般")
    ("만발"
     "滿發")
    ("만방"
     "萬方"
     "萬邦")
    ("만병"
     "萬病")
    ("만병통치"
     "萬病通治")
    ("만병통치약"
     "萬病通治藥")
    ("만사"
     "萬事")
    ("만사여의"
     "萬事如意")
    ("만사천"
     "萬四千")
    ("만사형통"
     "萬事亨通")
    ("만사휴의"
     "萬事休矣")
    ("만삭"
     "滿朔")
    ("만삼천"
     "萬三千")
    ("만삼천팔백"
     "萬三千八百")
    ("만상"
     "萬象")
    ("만석"
     "萬石")
    ("만선"
     "滿船"
     "萬善")
    ("만성"
     "慢性")
    ("만성적"
     "慢性的")
    ("만성화"
     "慢性化")
    ("만세"
     "萬歲")
    ("만세불역"
     "萬世不易")
    ("만수무강"
     "萬壽無疆")
    ("만수위"
     "滿水位")
    ("만숙형"
     "晩熟型")
    ("만승지국"
     "萬乘之國")
    ("만시지탄"
     "晩時之歎")
    ("만식당육"
     "晩食當肉")
    ("만신"
     "滿身")
    ("만신창이"
     "滿身瘡痍")
    ("만약"
     "萬若")
    ("만연"
     "蔓延")
    ("만연체형"
     "蔓衍體型")
    ("만오천"
     "萬五千")
    ("만용"
     "蠻勇")
    ("만우절"
     "萬愚節")
    ("만원"
     "滿員")
    ("만월"
     "滿月")
    ("만유인력"
     "萬有引力")
    ("만육천"
     "萬六千")
    ("만인"
     "萬人")
    ("만인지상"
     "萬人之上")
    ("만일"
     "萬一")
    ("만입부"
     "灣入部")
    ("만장"
     "滿場"
     "輓章")
    ("만장일치"
     "滿場一致")
    ("만재"
     "滿載")
    ("만전"
     "萬全")
    ("만전지계"
     "萬全之計")
    ("만점"
     "滿點")
    ("만조"
     "滿潮")
    ("만족"
     "滿足")
    ("만족감"
     "滿足感")
    ("만족도"
     "滿足度")
    ("만좌중"
     "滿座中")
    ("만찬"
     "晩餐")
    ("만찬장"
     "晩餐場")
    ("만천하"
     "滿天下")
    ("만취"
     "漫醉")
    ("만파식적"
     "萬波息笛")
    ("만패불청"
     "萬覇不聽")
    ("만평"
     "漫評")
    ("만평집"
     "漫評集")
    ("만학천봉"
     "萬壑千峰")
    ("만행"
     "蠻行")
    ("만호"
     "萬戶")
    ("만화"
     "漫畵")
    ("만화가"
     "漫畵家")
    ("만화경"
     "萬華鏡")
    ("만화경적"
     "萬華鏡的")
    ("만화방"
     "漫畵房")
    ("만화지"
     "漫畵紙")
    ("만화책"
     "漫畵冊")
    ("만홧"
     "漫畵")
    ("만회"
     "挽回")
    ("만휘군상"
     "萬彙群象")
    ("말"
     ("抹" . "바랄 말")
     ("末" . "끝 말")
     ("沫" . "거품 말")
     ("茉" . "말리 말")
     ("襪" . "버선 말")
     ("靺" . "버선 말")
     ("秣" . "꼴 말"))
    ("말경"
     "末境")
    ("말기"
     "末期")
    ("말기적"
     "末期的")
    ("말년"
     "末年")
    ("말단"
     "末端")
    ("말단적"
     "末端的")
    ("말로"
     "末路")
    ("말미"
     "末尾")
    ("말번"
     "末番")
    ("말법"
     "末法")
    ("말복"
     "末伏")
    ("말사"
     "末寺")
    ("말살"
     "抹殺")
    ("말석"
     "末席")
    ("말세"
     "末世")
    ("말소"
     "抹消")
    ("말엽"
     "末葉")
    ("말일"
     "末日")
    ("말조심"
     "­操心")
    ("말종"
     "末種")
    ("말초"
     "末梢")
    ("말초적"
     "末梢的")
    ("말학부수"
     "末學膚受")
    ("망"
     ("亡" . "망할 망")
     ("妄" . "허망할 망")
     ("忘" . "잊을 망")
     ("忙" . "바쁠 망")
     ("望" . "바랄 망")
     ("網" . "그물 망")
     ("罔" . "그물 망")
     ("芒" . "까끄라기 망")
     ("茫" . "아득할 망")
     ("莽" . "우거질 망")
     ("輞" . "바퀴테 망")
     ("邙" . "산 이름 망")
     ("惘" . "멍할 망")
     ("汒" . "황급할 망")
     ("漭" . "넓을 망")
     ("莾" . "마디 짧은 대 망")
     ("蟒" . "이무기 망")
     ("魍" . "도깨비 망"))
    ("망가적"
     "亡家的")
    ("망각"
     "忘却")
    ("망각적"
     "妄覺的")
    ("망건"
     "網巾")
    ("망국"
     "亡國")
    ("망국적"
     "亡國的")
    ("망국지음"
     "亡國之音")
    ("망극"
     "罔極")
    ("망극지은"
     "罔極之恩")
    ("망년지교"
     "忘年之交")
    ("망념"
     "妄念")
    ("망동"
     "妄動")
    ("망라"
     "網羅")
    ("망령"
     "亡靈"
     "妄靈")
    ("망루"
     "望樓")
    ("망막"
     "網膜")
    ("망막증"
     "網膜症")
    ("망망"
     "茫茫")
    ("망망대해"
     "茫茫大海")
    ("망매해갈"
     "望梅解渴")
    ("망명"
     "亡命")
    ("망명자"
     "亡命者")
    ("망명지"
     "亡命地")
    ("망문생의"
     "望文生義")
    ("망발"
     "妄發")
    ("망부석"
     "望夫石")
    ("망사"
     "亡事"
     "網紗")
    ("망상"
     "妄想")
    ("망상가"
     "妄想家")
    ("망성"
     "亡姓")
    ("망신"
     "亡身")
    ("망양보뢰"
     "亡羊補牢")
    ("망양지탄"
     "亡羊之歎"
     "望洋之歎")
    ("망언"
     "妄言")
    ("망연"
     "茫然")
    ("망연자실"
     "茫然自失")
    ("망운지정"
     "望雲之情")
    ("망원경"
     "望遠鏡")
    ("망자"
     "亡者")
    ("망자계치"
     "亡子計齒")
    ("망자재배"
     "芒刺在背")
    ("망자존대"
     "妄自尊大")
    ("망조"
     "亡兆")
    ("망종"
     "亡種"
     "芒種")
    ("망중한"
     "忙中閑")
    ("망창"
     "茫蒼")
    ("망처"
     "亡妻")
    ("망향"
     "望鄕")
    ("망형지우"
     "忘形之友")
    ("맞대응"
     "­對應")
    ("매"
     ("埋" . "묻을 매")
     ("妹" . "누이 매")
     ("媒" . "중매 매")
     ("寐" . "잠잘 매")
     ("昧" . "새벽 매")
     ("枚" . "줄기 매")
     ("梅" . "매화나무 매")
     ("每" . "매양 매")
     ("煤" . "그을음 매")
     ("罵" . "욕할 매")
     ("買" . "살 매")
     ("賣" . "팔 매")
     ("邁" . "갈 매")
     ("魅" . "도깨비 매")
     ("呆" . "어리석을 매")
     ("楳" . "梅의 古字")
     ("沬" . "지명 매")
     ("玫" . "매괴 매")
     ("眛" . "어두울 매")
     ("苺" . "딸기 매")
     ("莓" . "나무딸기 매")
     ("酶" . "술밑 매")
     ("霉" . "매우 매"))
    ("매각"
     "賣却")
    ("매각설"
     "賣却說")
    ("매개"
     "媒介")
    ("매개적"
     "媒介的")
    ("매개체"
     "媒介體")
    ("매개충"
     "媒介蟲")
    ("매관매직"
     "賣官賣職")
    ("매국"
     "賣國")
    ("매국노"
     "賣國奴")
    ("매기"
     "買氣")
    ("매년"
     "每年")
    ("매도"
     "罵倒"
     "賣渡")
    ("매도금"
     "賣渡金")
    ("매도설"
     "賣渡說")
    ("매도자"
     "賣渡者")
    ("매독"
     "梅毒")
    ("매란국죽"
     "梅蘭菊竹")
    ("매력"
     "魅力")
    ("매력적"
     "魅力的")
    ("매료"
     "魅了")
    ("매립"
     "埋立")
    ("매립장"
     "埋立場")
    ("매립지"
     "埋立地")
    ("매매"
     "賣買")
    ("매매춘"
     "賣買春")
    ("매명"
     "賣名")
    ("매몰"
     "埋沒")
    ("매몰자"
     "埋沒者")
    ("매물"
     "賣物")
    ("매번"
     "每番")
    ("매복"
     "埋伏")
    ("매부"
     "妹夫")
    ("매사"
     "每事")
    ("매사마골"
     "買死馬骨")
    ("매상"
     "賣上")
    ("매석"
     "賣惜")
    ("매설"
     "埋設")
    ("매설관"
     "埋設管")
    ("매설물"
     "埋設物")
    ("매수"
     "買受"
     "買收")
    ("매수량"
     "買收量")
    ("매수설"
     "買收說")
    ("매수세"
     "買收勢")
    ("매시간"
     "每時間")
    ("매식"
     "買食")
    ("매실"
     "梅實")
    ("매연"
     "煤煙")
    ("매월"
     "每月")
    ("매음굴"
     "賣淫窟")
    ("매일"
     "每日")
    ("매일매일"
     "每日每日")
    ("매입"
     "買入")
    ("매입비"
     "買入費")
    ("매입자"
     "買入者")
    ("매장"
     "埋葬"
     "埋藏"
     "賣場")
    ("매장량"
     "埋藏量")
    ("매재"
     "媒材")
    ("매점"
     "買占"
     "賣店")
    ("매점매석"
     "買占賣惜")
    ("매제"
     "妹弟")
    ("매주"
     "每週")
    ("매직"
     "賣職")
    ("매진"
     "賣盡"
     "邁進")
    ("매질"
     "媒質")
    ("매체"
     "媒體")
    ("매체적"
     "媒體的")
    ("매초"
     "每秒")
    ("매춘"
     "買春"
     "賣春")
    ("매출"
     "賣出")
    ("매출량"
     "賣出量")
    ("매출액"
     "賣出額")
    ("매판"
     "買辦")
    ("매판성"
     "買辦性")
    ("매판화"
     "買辦化")
    ("매표"
     "買票"
     "賣票")
    ("매표구"
     "賣票口")
    ("매표소"
     "賣票所")
    ("매표창구"
     "賣票窓口")
    ("매형"
     "妹兄")
    ("매혹"
     "魅惑")
    ("매혹적"
     "魅惑的")
    ("매화"
     "梅花")
    ("매회"
     "每回")
    ("맥"
     ("脈" . "맥 맥")
     ("貊" . "북방 종족 맥")
     ("陌" . "두렁 맥")
     ("驀" . "말탈 맥")
     ("麥" . "보리 맥")
     ("脉" . "脈의 古字")
     ("貃" . "오랑캐 맥")
     ("貘" . "짐승 이름 맥"))
    ("맥동"
     "脈動")
    ("맥락"
     "脈絡")
    ("맥박"
     "脈搏")
    ("맥반석"
     "麥飯石")
    ("맥상"
     "脈狀")
    ("맥수지탄"
     "麥秀之嘆")
    ("맥주"
     "麥酒")
    ("맥주병"
     "麥酒甁")
    ("맥줏"
     "麥酒")
    ("맥진"
     "脈診")
    ("맹"
     ("孟" . "맏 맹")
     ("氓" . "백성 맹")
     ("猛" . "사나울 맹")
     ("盟" . "맹세할 맹")
     ("盲" . "소경 맹")
     ("萌" . "싹 맹")
     "甍"
     "甿"
     "虻"
     "黽")
    ("맹귀부목"
     "盲龜浮木")
    ("맹독"
     "猛毒")
    ("맹독성"
     "猛毒性")
    ("맹랑"
     "孟浪")
    ("맹렬"
     "猛烈")
    ("맹모단기"
     "孟母斷機")
    ("맹모삼천"
     "孟母三遷")
    ("맹목"
     "盲目")
    ("맹목적"
     "盲目的")
    ("맹비난"
     "猛非難")
    ("맹세"
     "盟誓")
    ("맹수"
     "猛獸")
    ("맹신"
     "盲信")
    ("맹아"
     "盲兒"
     "萌芽")
    ("맹아론"
     "萌芽論")
    ("맹아적"
     "萌芽的")
    ("맹완단청"
     "盲玩丹靑")
    ("맹원"
     "盟員")
    ("맹위"
     "猛威")
    ("맹인"
     "盲人")
    ("맹인모상"
     "盲人摸象")
    ("맹인안질"
     "盲人眼疾")
    ("맹자정문"
     "盲者正門")
    ("맹장"
     "盲腸")
    ("맹장염"
     "盲腸炎")
    ("맹점"
     "盲點")
    ("맹종"
     "盲從")
    ("맹주"
     "盟主")
    ("맹주국"
     "盟主國")
    ("맹추격"
     "猛追擊")
    ("맹폭"
     "猛爆")
    ("맹호"
     "猛虎")
    ("맹호출림형"
     "猛虎出林形")
    ("맹호형"
     "猛虎型")
    ("맹활약"
     "猛活躍")
    ("맹활약상"
     "猛活躍狀")
    ("맹휴"
     "盟休")
    ("먹칠"
     "­漆")
    ("멱"
     ("冪" . "덮을 멱")
     ("汨" . "물이름 멱")
     "蓂"
     ("覓" . "찾을 멱")
     ("幎" . "덮을 멱"))
    ("면"
     ("免" . "면할 면")
     ("冕" . "면류관 면")
     ("勉" . "힘쓸 면")
     "娩"
     ("棉" . "목화 면")
     ("沔" . "물 흐를 면")
     ("眄" . "애꾸눈 면")
     ("眠" . "잠잘 면")
     ("綿" . "이어질 면")
     ("緬" . "가는 실 면")
     ("面" . "낯 면")
     ("麵" . "麪과 同字")
     ("俛" . "힘쓸 면")
     ("湎" . "빠질 면")
     ("糆" . "麪과 同字")
     ("緜" . "햇솜 면")
     ("麪" . "밀가루 면"))
    ("면구"
     "面灸")
    ("면담"
     "面談")
    ("면도"
     "面刀")
    ("면도사"
     "面刀師")
    ("면류관"
     "冕旒冠")
    ("면리"
     "面里")
    ("면면"
     "綿綿"
     "面面")
    ("면모"
     "面貌")
    ("면목"
     "面目")
    ("면민"
     "面民")
    ("면밀"
     "綿密")
    ("면박"
     "面駁")
    ("면벽구년"
     "面壁九年")
    ("면복"
     "冕服")
    ("면봉"
     "綿棒")
    ("면사무소"
     "面事務所")
    ("면사포"
     "面紗布")
    ("면상"
     "面上")
    ("면섬유"
     "綿纖維")
    ("면세"
     "免稅")
    ("면세점"
     "免稅店"
     "免稅點")
    ("면세품"
     "免稅品")
    ("면수"
     "面數")
    ("면여관옥"
     "面如冠玉")
    ("면역"
     "免疫")
    ("면역성"
     "免疫性")
    ("면역증"
     "免疫症")
    ("면장"
     "面長")
    ("면재"
     "面材")
    ("면적"
     "面積")
    ("면적률"
     "面積率")
    ("면전"
     "面前")
    ("면접"
     "面接")
    ("면접시험"
     "面接試驗")
    ("면제"
     "免除")
    ("면제자"
     "免除者")
    ("면조"
     "免租")
    ("면조권"
     "免租權")
    ("면조권론"
     "免租權論")
    ("면조권설"
     "免租權說")
    ("면종복배"
     "面從腹背")
    ("면죄부"
     "免罪符")
    ("면주"
     "綿紬")
    ("면직"
     "免職")
    ("면직물"
     "綿織物")
    ("면찬"
     "面讚")
    ("면책"
     "免責")
    ("면책금"
     "免責金")
    ("면천"
     "免賤")
    ("면청"
     "面廳")
    ("면포"
     "綿布")
    ("면학"
     "勉學")
    ("면허"
     "免許")
    ("면허증"
     "免許證")
    ("면화"
     "綿花")
    ("면회"
     "面會")
    ("면회객"
     "面會客")
    ("면회실"
     "面會室")
    ("멸"
     ("滅" . "멸망할 멸")
     ("蔑" . "업신여길 멸")
     ("篾" . "대 껍질 멸")
     ("衊" . "모독할 멸"))
    ("멸망"
     "滅亡")
    ("멸망당"
     "滅亡當")
    ("멸문절호"
     "滅門絶戶")
    ("멸문지화"
     "滅門之禍")
    ("멸사"
     "滅私")
    ("멸사봉공"
     "滅私奉公")
    ("멸성제"
     "滅聖諦")
    ("멸시"
     "蔑視")
    ("멸시당"
     "蔑視當")
    ("멸실"
     "滅失")
    ("멸종"
     "滅種")
    ("명"
     ("冥" . "어두울 명")
     ("名" . "이름 명")
     ("命" . "목숨 명")
     ("明" . "밝을 명")
     ("暝" . "어두울 명")
     ("椧" . "홈 통 명")
     ("溟" . "어두울 명")
     ("皿" . "그릇 명")
     ("瞑" . "눈 감을 명")
     ("茗" . "차 싹 명")
     ("蓂" . "명협 명")
     ("螟" . "마디충 명")
     ("酩" . "술 취할 명")
     ("銘" . "새길 명")
     ("鳴" . "울 명")
     ("洺" . "강 이름 명")
     "黽")
    ("명감독"
     "名監督")
    ("명강의"
     "名講義")
    ("명건축"
     "名建築")
    ("명견만리"
     "明見萬里")
    ("명경"
     "明鏡")
    ("명경불피"
     "明鏡不疲")
    ("명경지수"
     "明鏡止水")
    ("명곡"
     "名曲")
    ("명과기실"
     "名過其實")
    ("명관"
     "名官")
    ("명궁"
     "名弓")
    ("명기"
     "明記")
    ("명단"
     "名單")
    ("명당"
     "明堂")
    ("명도"
     "明度")
    ("명동"
     "鳴動")
    ("명란"
     "明卵")
    ("명랑"
     "明朗")
    ("명령"
     "命令")
    ("명령서"
     "命令書")
    ("명령어"
     "命令語")
    ("명령제"
     "命令制")
    ("명료"
     "明瞭")
    ("명료화"
     "明瞭化")
    ("명륜당"
     "明倫堂")
    ("명리"
     "名利")
    ("명망가"
     "名望家")
    ("명맥"
     "命脈")
    ("명면각지"
     "名面各知")
    ("명멸"
     "明滅")
    ("명명"
     "命名")
    ("명명백백"
     "明明白白")
    ("명모호치"
     "明眸皓齒")
    ("명목"
     "名目")
    ("명목장담"
     "明目張膽")
    ("명문"
     "名門"
     "明文")
    ("명문거족"
     "名門巨族")
    ("명문고"
     "名門高")
    ("명문대"
     "名門大")
    ("명문대가"
     "名門大家")
    ("명문대생"
     "名門大生")
    ("명문장가"
     "名文章家")
    ("명문천하"
     "名聞天下")
    ("명문화"
     "明文化")
    ("명물"
     "名物")
    ("명민"
     "明敏")
    ("명백"
     "明白")
    ("명복"
     "冥福")
    ("명부"
     "冥府"
     "名簿")
    ("명부식"
     "名簿式")
    ("명부전"
     "冥府殿")
    ("명분"
     "名分")
    ("명불허전"
     "名不虛傳")
    ("명사"
     "名士"
     "名詞")
    ("명사적"
     "名詞的")
    ("명산"
     "名山")
    ("명산대천"
     "名山大川")
    ("명산지"
     "名産地")
    ("명상"
     "冥想")
    ("명상기"
     "冥想期")
    ("명상록"
     "冥想錄")
    ("명상적"
     "冥想的")
    ("명색"
     "名色")
    ("명석"
     "明晳")
    ("명석화"
     "明晳化")
    ("명선수"
     "名選手")
    ("명성"
     "名聲")
    ("명세"
     "明細")
    ("명세서"
     "明細書")
    ("명소"
     "名所")
    ("명수"
     "名手")
    ("명수죽백"
     "名垂竹帛")
    ("명수필"
     "名隨筆")
    ("명승"
     "名勝")
    ("명승부"
     "名勝負")
    ("명승지"
     "名勝地")
    ("명시"
     "名詩"
     "明示")
    ("명시도"
     "明視度")
    ("명시적"
     "明示的")
    ("명실"
     "名實")
    ("명실공"
     "名實公")
    ("명실상부"
     "名實相符")
    ("명심"
     "銘心")
    ("명암"
     "明暗")
    ("명약"
     "名藥")
    ("명약관화"
     "明若觀火")
    ("명언"
     "名言")
    ("명연설가"
     "名演說家")
    ("명예"
     "名譽")
    ("명예박사"
     "名譽博士")
    ("명예심"
     "名譽心")
    ("명예욕"
     "名譽慾")
    ("명예퇴직"
     "名譽退職")
    ("명왕성"
     "冥王星")
    ("명의"
     "名義"
     "名醫")
    ("명의자"
     "名義者")
    ("명인"
     "名人")
    ("명일"
     "名日")
    ("명작"
     "名作")
    ("명작극"
     "名作劇")
    ("명장"
     "名匠"
     "名將")
    ("명재경각"
     "命在頃刻")
    ("명저"
     "名著")
    ("명절"
     "名節")
    ("명정"
     "酩酊"
     "銘旌")
    ("명제"
     "命題")
    ("명조"
     "明朝")
    ("명조체"
     "明朝體")
    ("명주"
     "明珠"
     "明紬")
    ("명주암투"
     "明珠暗投")
    ("명중"
     "命中")
    ("명증성"
     "明證性")
    ("명진행자"
     "名進行者")
    ("명차"
     "名車")
    ("명찰"
     "名札")
    ("명찰추호"
     "明察秋毫")
    ("명창"
     "名唱")
    ("명철"
     "明哲")
    ("명철보신"
     "明哲保身")
    ("명칭"
     "名稱")
    ("명쾌"
     "明快")
    ("명태"
     "明太")
    ("명패"
     "名牌")
    ("명포"
     "名鋪")
    ("명품"
     "名品")
    ("명품관"
     "名品館")
    ("명품점"
     "名品店")
    ("명함"
     "名銜")
    ("명화"
     "名畵")
    ("명확"
     "明確")
    ("몌"
     ("袂" . "소매 몌"))
    ("모"
     ("侮" . "업신여길 모")
     ("冒" . "가릴 모")
     ("募" . "모을 모")
     ("姆" . "여스승 모")
     ("帽" . "모자 모")
     ("慕" . "그리워할 모")
     ("摸" . "찾을 모")
     ("摹" . "베낄 모")
     ("暮" . "저물 모")
     ("某" . "아무 모")
     ("模" . "법 모")
     ("母" . "어미 모")
     ("毛" . "털 모")
     ("牟" . "소 우는 소리 모")
     ("牡" . "수컷 모")
     ("瑁" . "서옥 모")
     ("眸" . "눈동자 모")
     ("矛" . "창 모")
     ("耗" . "줄 모")
     ("芼" . "풀 우거질 모")
     ("茅" . "띠 모")
     ("謀" . "꾀할 모")
     ("謨" . "꾀 모")
     ("貌" . "얼굴 모")
     ("侔" . "가지런 할 모")
     ("姥" . "할미 모")
     ("媢" . "강새암 할 모")
     ("嫫" . "예쁠 모")
     ("恈" . "탐할 모")
     ("旄" . "깃대 장식 모")
     ("皃" . "貌와 同字")
     ("眊" . "눈 흐릴 모")
     ("粍" . "밀리메트로 모")
     ("糢" . "模의 俗字")
     ("耄" . "늙은이 모")
     ("蝥" . "해충 모")
     ("蟊" . "蝥와 同字")
     ("鉾" . "칼 끝 모")
     ("髦" . "다팔머리 모"))
    ("모계"
     "母系")
    ("모계제"
     "母系制")
    ("모고신종"
     "暮鼓晨鐘")
    ("모골"
     "毛骨")
    ("모공"
     "毛孔")
    ("모과"
     "木瓜")
    ("모관"
     "毛冠")
    ("모교"
     "母校")
    ("모국"
     "母國")
    ("모국어"
     "母國語")
    ("모권제"
     "母權制")
    ("모금"
     "募金")
    ("모기구"
     "母機構")
    ("모기업"
     "母企業")
    ("모녀"
     "母女")
    ("모독"
     "冒瀆")
    ("모란"
     "牡丹")
    ("모략"
     "謀略")
    ("모략중상"
     "謀略中傷")
    ("모리배"
     "謀利輩")
    ("모면"
     "謀免")
    ("모멸"
     "侮蔑")
    ("모멸감"
     "侮蔑感")
    ("모반"
     "謀反")
    ("모발"
     "毛髮")
    ("모방"
     "模倣")
    ("모방도"
     "模倣度")
    ("모방자"
     "模倣者")
    ("모방적"
     "毛紡績")
    ("모범"
     "模範")
    ("모범생"
     "模範生")
    ("모범수"
     "模範囚")
    ("모범적"
     "模範的")
    ("모본단"
     "模本緞")
    ("모사"
     "模寫")
    ("모사론"
     "模寫論")
    ("모사론적"
     "模寫論的")
    ("모색"
     "摸索")
    ("모색기"
     "摸索期")
    ("모색창연"
     "暮色蒼然")
    ("모성"
     "母性")
    ("모성애"
     "母性愛")
    ("모세"
     "毛細")
    ("모수자천"
     "毛遂自薦")
    ("모순"
     "矛盾")
    ("모순율"
     "矛盾律")
    ("모순적"
     "矛盾的")
    ("모순점"
     "矛盾點")
    ("모신"
     "母神")
    ("모암"
     "母巖")
    ("모양"
     "某樣"
     "模樣")
    ("모욕"
     "侮辱")
    ("모욕감"
     "侮辱感")
    ("모욕당"
     "侮辱當")
    ("모욕적"
     "侮辱的")
    ("모욕죄"
     "侮辱罪")
    ("모우미성"
     "毛羽未成")
    ("모운낙일"
     "暮雲落日")
    ("모월"
     "某月")
    ("모유"
     "母乳")
    ("모음"
     "母音")
    ("모의"
     "模擬"
     "謀議")
    ("모의고사"
     "模擬考査")
    ("모의실험"
     "模擬實驗")
    ("모일"
     "某日")
    ("모자"
     "帽子"
     "母子")
    ("모자간"
     "母子間")
    ("모작"
     "模作")
    ("모작품"
     "模作品")
    ("모전"
     "毛典")
    ("모정"
     "母情")
    ("모조품"
     "模造品")
    ("모종"
     "某種")
    ("모주"
     "母酒")
    ("모직"
     "毛織")
    ("모직물"
     "毛織物")
    ("모집"
     "募集")
    ("모집인"
     "募集人")
    ("모처"
     "某處")
    ("모체"
     "母體")
    ("모친"
     "母親")
    ("모태"
     "母胎")
    ("모포"
     "毛布")
    ("모피"
     "毛皮")
    ("모함"
     "謀陷")
    ("모험"
     "冒險")
    ("모험가"
     "冒險家")
    ("모험담"
     "冒險談")
    ("모험성"
     "冒險性")
    ("모험심"
     "冒險心")
    ("모험적"
     "冒險的")
    ("모험주의자"
     "冒險主義者")
    ("모형"
     "模型"
     "母型")
    ("모형도"
     "模型圖")
    ("모형실험"
     "模型實驗")
    ("모호"
     "模糊")
    ("모회사"
     "母會社")
    ("목"
     ("木" . "나무 목")
     ("沐" . "머리감을 목")
     ("牧" . "칠 목")
     ("目" . "눈 목")
     ("穆" . "화목할 목")
     ("鶩" . "집오리 목")
     ("凩" . "찬바람 목")
     ("苜" . "거여목 목"))
    ("목가적"
     "牧歌的")
    ("목각"
     "木刻")
    ("목각상"
     "木刻像")
    ("목강즉절"
     "木强則折")
    ("목격"
     "目擊")
    ("목격담"
     "目擊談")
    ("목격자"
     "目擊者")
    ("목공"
     "木工")
    ("목공예품"
     "木工藝品")
    ("목공품"
     "木工品")
    ("목기"
     "木器")
    ("목도"
     "目睹")
    ("목동"
     "牧童")
    ("목련"
     "木蓮")
    ("목례"
     "目禮")
    ("목록"
     "目錄")
    ("목마"
     "木馬")
    ("목면"
     "木綿")
    ("목백일홍"
     "木百日紅")
    ("목별"
     "木鼈")
    ("목본"
     "木本")
    ("목불견첩"
     "目不見睫")
    ("목불규원"
     "目不窺園")
    ("목불식정"
     "目不識丁")
    ("목불인견"
     "目不忍見")
    ("목사"
     "牧使"
     "牧師")
    ("목석"
     "木石")
    ("목석심장"
     "木石心腸")
    ("목선"
     "木船")
    ("목성"
     "木星")
    ("목성판"
     "木星版")
    ("목수"
     "木手")
    ("목양장"
     "牧養場")
    ("목요"
     "木曜")
    ("목요일"
     "木曜日")
    ("목욕"
     "沐浴")
    ("목욕료"
     "沐浴料")
    ("목욕장"
     "沐浴場")
    ("목욕재계"
     "沐浴齋戒")
    ("목욕탕"
     "沐浴湯")
    ("목우인의"
     "木偶人衣")
    ("목우즐풍"
     "沐雨櫛風")
    ("목이"
     "木耳")
    ("목장"
     "牧場")
    ("목재"
     "木材")
    ("목재품"
     "木材品")
    ("목적"
     "目的")
    ("목적론적"
     "目的論的")
    ("목적법화"
     "目的法化")
    ("목적어"
     "目的語")
    ("목적의식"
     "目的意識")
    ("목적의식적"
     "目的意識的")
    ("목적지"
     "目的地")
    ("목적항"
     "目的港")
    ("목전"
     "目前")
    ("목전지계"
     "目前之計")
    ("목제"
     "木製")
    ("목제품"
     "木製品")
    ("목조"
     "木彫"
     "木造")
    ("목조부"
     "木造部")
    ("목차"
     "目次")
    ("목초지"
     "牧草地")
    ("목축"
     "牧畜")
    ("목축업"
     "牧畜業")
    ("목침"
     "木枕")
    ("목탁"
     "木鐸")
    ("목탄"
     "木炭")
    ("목탑"
     "木塔")
    ("목판"
     "木板"
     "木版")
    ("목판화"
     "木版畵")
    ("목표"
     "目標")
    ("목표량"
     "目標量")
    ("목표선"
     "目標線")
    ("목표액"
     "目標額")
    ("목표점"
     "目標點")
    ("목하"
     "目下")
    ("목하십행"
     "目下十行")
    ("목화"
     "木花")
    ("목회"
     "牧會")
    ("목회자"
     "牧會者")
    ("목회학"
     "牧會學")
    ("몰"
     ("歿" . "죽을 몰")
     ("沒" . "가라 앉을 몰"))
    ("몰개성화"
     "沒個性化")
    ("몰도덕성"
     "沒道德性")
    ("몰두"
     "沒頭")
    ("몰두몰미"
     "沒頭沒尾")
    ("몰락"
     "沒落")
    ("몰락기"
     "沒落期")
    ("몰살"
     "沒殺")
    ("몰상식"
     "沒常識")
    ("몰수"
     "沒收")
    ("몰역사적"
     "沒歷史的")
    ("몰염치"
     "沒廉恥")
    ("몰이해"
     "沒理解")
    ("몰입"
     "沒入")
    ("몰지각"
     "沒知覺")
    ("몰풍"
     "沒風")
    ("몸조심"
     "­操心")
    ("몽"
     ("夢" . "꿈 몽")
     ("朦" . "풍부할 몽")
     ("蒙" . "입을 몽")
     "儚"
     ("幪" . "덮을 몽")
     ("懞" . "어두울 몽")
     ("曚" . "어두울 몽")
     "溕"
     ("濛" . "가랑비 올 몽")
     ("瞢" . "어두울 몽")
     ("矇" . "소경 몽")
     ("艨" . "싸움배 몽")
     ("雺" . "안개 몽")
     ("鸏" . "비둘기 몽"))
    ("몽롱"
     "朦朧")
    ("몽매"
     "夢寐"
     "蒙昧")
    ("몽매주의"
     "蒙昧主義")
    ("몽상"
     "夢想")
    ("몽상가"
     "夢想家")
    ("몽상적"
     "夢想的")
    ("몽유"
     "夢遊")
    ("몽유병"
     "夢遊病")
    ("몽정"
     "夢精")
    ("몽중점몽"
     "夢中占夢")
    ("몽진"
     "蒙塵")
    ("몽환성"
     "夢幻性")
    ("묘"
     ("卯" . "토끼 묘")
     ("墓" . "무덤 묘")
     ("妙" . "묘할 묘")
     ("廟" . "사당 묘")
     ("描" . "그릴 묘")
     ("昴" . "별자리 이름 묘")
     ("杳" . "어두울 묘")
     ("渺" . "아득할 묘")
     ("猫" . "고양이 묘")
     "畝"
     ("秒" . "까끄라기 묘")
     ("竗" . "땅 이름 묘")
     ("苗" . "모 묘")
     ("錨" . "닻 묘")
     ("淼" . "물 아득할 묘")
     ("眇" . "애꾸눈 묘")
     ("藐" . "작을 묘")
     ("貓" . "猫와 同字"))
    ("묘기"
     "妙技")
    ("묘기성"
     "妙技性")
    ("묘두현령"
     "猫頭縣鈴")
    ("묘목"
     "苗木")
    ("묘미"
     "妙味")
    ("묘법"
     "描法")
    ("묘비명"
     "墓碑銘")
    ("묘사"
     "描寫")
    ("묘소"
     "墓所")
    ("묘수"
     "妙手")
    ("묘안"
     "妙案")
    ("묘약"
     "妙藥")
    ("묘역"
     "墓域")
    ("묘연"
     "杳然")
    ("묘유"
     "妙有")
    ("묘제"
     "墓祭")
    ("묘지"
     "墓地")
    ("묘책"
     "妙策")
    ("묘처"
     "妙處")
    ("묘출"
     "描出")
    ("묘파"
     "描破")
    ("묘합"
     "妙合")
    ("무"
     ("務" . "일 무, 힘쓸 무, 권장할 무")
     ("巫" . "무당 무, 산 이름 무")
     ("憮" . "어루만질 무, 애무할 무")
     ("懋" . "힘쓸 무, 노력할 무")
     ("戊" . "다섯째 천간 무, 무성할 무")
     ("拇" . "엄지손가락 무")
     ("撫" . "어루만질 무, 누를 무")
     ("无" . "없을 무")
     ("楙" . "무성할 무, 아름다울 무")
     ("武" . "굳셀 무, 자만할 무, 군인 무")
     ("毋" . "말 무")
     ("無" . "없을 무")
     ("珷" . "옥돌 무")
     ("繆" . "묶을 무, 얽을 무, 삼 무")
     ("舞" . "춤출 무")
     ("茂" . "우거질 무, 무성할 무")
     ("蕪" . "거칠어질 무, 거친풀 무")
     ("誣" . "무고할 무, 깔볼 무")
     ("貿" . "바꿀 무, 물건 살 무")
     ("霧" . "안개 무, 어두울 무")
     ("鵡" . "앵무새 무")
     ("儛" . "舞와 同字")
     ("嘸" . "분명하지 않을 무, 모호한 모양 무")
     ("廡" . "집 무, 처마 무, 지붕 무")
     ("膴" . "포 무, 크게 저민 고기 무")
     ("騖" . "달릴 무, 질주할 무"))
    ("무가치"
     "無價値")
    ("무감각"
     "無感覺")
    ("무개성"
     "無個性")
    ("무개성적"
     "無個性的")
    ("무개차"
     "無蓋車")
    ("무계획"
     "無計劃")
    ("무계획성"
     "無計劃性")
    ("무고"
     "無故"
     "無辜"
     "誣告")
    ("무고지민"
     "無告之民")
    ("무골호인"
     "無骨好人")
    ("무공해"
     "無公害")
    ("무관"
     "武官"
     "無關")
    ("무관계"
     "無關係")
    ("무관심"
     "無關心")
    ("무구"
     "巫具"
     "無垢")
    ("무국적"
     "無國籍")
    ("무궁"
     "無窮")
    ("무궁무궁"
     "無窮無窮")
    ("무궁무진"
     "無窮無盡")
    ("무궁화"
     "無窮花")
    ("무권리"
     "無權利")
    ("무규정적"
     "無規定的")
    ("무극"
     "無極")
    ("무근이고"
     "無根而固")
    ("무급"
     "無給")
    ("무기"
     "武器"
     "無期")
    ("무기고"
     "武器庫")
    ("무기력"
     "無氣力")
    ("무기력증"
     "無氣力症")
    ("무기력화"
     "無氣力化")
    ("무기명"
     "無記名")
    ("무기물"
     "無機物")
    ("무기상"
     "武器商")
    ("무기정학"
     "無期停學")
    ("무기질"
     "無機質")
    ("무기한"
     "無期限")
    ("무기형"
     "武器型")
    ("무기화"
     "武器化")
    ("무난"
     "無難")
    ("무남독녀"
     "無男獨女")
    ("무념"
     "無念")
    ("무념무상"
     "無念無想")
    ("무노동"
     "無勞動")
    ("무농약"
     "無農藥")
    ("무뇌아"
     "無腦兒")
    ("무능"
     "無能")
    ("무능력"
     "無能力")
    ("무능력자"
     "無能力者")
    ("무능인"
     "無能人")
    ("무단"
     "無斷")
    ("무단가출"
     "無斷家出")
    ("무단결근"
     "無斷缺勤")
    ("무대"
     "舞臺")
    ("무대극"
     "舞臺劇")
    ("무대화"
     "舞臺化")
    ("무도"
     "無道"
     "舞蹈")
    ("무도지인"
     "無道之人")
    ("무도회"
     "舞蹈會")
    ("무도회장"
     "舞蹈會場")
    ("무동작"
     "無動作")
    ("무두"
     "無頭")
    ("무득무실"
     "無得無失")
    ("무량"
     "無量")
    ("무량무변"
     "無量無邊")
    ("무려"
     "無慮")
    ("무력"
     "武力"
     "無力")
    ("무력감"
     "無力感")
    ("무력부"
     "武力部")
    ("무력시위"
     "武力示威")
    ("무력행사"
     "武力行使")
    ("무력화"
     "無力化")
    ("무례"
     "無禮")
    ("무료"
     "無料"
     "無聊")
    ("무료입장"
     "無料入場")
    ("무릉도원"
     "武陵桃源")
    ("무리"
     "無理")
    ("무리수"
     "無理手")
    ("무마"
     "撫摩")
    ("무망"
     "無望")
    ("무망지복"
     "無望之福")
    ("무망지화"
     "無望之禍")
    ("무매독자"
     "無妹獨子")
    ("무면도강"
     "無面渡江")
    ("무면허"
     "無免許")
    ("무명"
     "無名"
     "無明")
    ("무모"
     "無謀")
    ("무문화촌"
     "無文化村")
    ("무미"
     "無味")
    ("무미건조"
     "無味乾燥")
    ("무반동총"
     "無反動銃")
    ("무방"
     "無妨")
    ("무방비"
     "無防備")
    ("무방향"
     "無方向")
    ("무배란성"
     "無排卵性")
    ("무법"
     "無法")
    ("무법자"
     "無法者")
    ("무법천지"
     "無法天地")
    ("무변"
     "武弁"
     "無邊")
    ("무병"
     "巫病"
     "無病")
    ("무병자구"
     "無病自灸")
    ("무보"
     "舞譜")
    ("무분별"
     "無分別")
    ("무불간섭"
     "無不干涉")
    ("무불통지"
     "無不通知")
    ("무비판적"
     "無批判的")
    ("무사"
     "武士"
     "無事"
     "無私"
     "無邪")
    ("무사도"
     "武士道")
    ("무사통과"
     "無事通過")
    ("무사풍"
     "武士風")
    ("무산"
     "無産"
     "霧散")
    ("무산지몽"
     "巫山之夢")
    ("무상"
     "無上"
     "無償"
     "無常"
     "霧箱")
    ("무색"
     "無色")
    ("무색무취"
     "無色無臭")
    ("무생물"
     "無生物")
    ("무선"
     "無線")
    ("무선국"
     "無線局")
    ("무성"
     "無聲"
     "茂盛")
    ("무성격적"
     "無性格的")
    ("무성의"
     "無誠意")
    ("무소득"
     "無所得")
    ("무소불능"
     "無所不能")
    ("무소불위"
     "無所不爲")
    ("무소속"
     "無所屬")
    ("무소식"
     "無消息")
    ("무소신"
     "無所信")
    ("무소용"
     "無所用")
    ("무소유"
     "無所有")
    ("무속"
     "巫俗")
    ("무속적"
     "巫俗的")
    ("무수"
     "無數")
    ("무술"
     "武術")
    ("무술인"
     "武術人")
    ("무승부"
     "無勝負")
    ("무시"
     "無時"
     "無視")
    ("무시간"
     "無時間")
    ("무시당"
     "無視當")
    ("무시험"
     "無試驗")
    ("무식"
     "無識")
    ("무식자"
     "無識者")
    ("무신"
     "武臣")
    ("무신경"
     "無神經")
    ("무신론자"
     "無神論者")
    ("무실역행"
     "務實力行")
    ("무실점"
     "無失點")
    ("무심"
     "無心")
    ("무심지도극"
     "無心之道劇")
    ("무아"
     "無我")
    ("무아경"
     "無我境")
    ("무아성"
     "無我性")
    ("무아지경"
     "無我之境")
    ("무악도"
     "舞樂圖")
    ("무안"
     "無顔")
    ("무안당"
     "無顔當")
    ("무애"
     "無碍")
    ("무양식"
     "無良識")
    ("무언"
     "無言")
    ("무언극"
     "無言劇")
    ("무언중"
     "無言中")
    ("무엄"
     "無嚴")
    ("무역"
     "貿易")
    ("무역국"
     "貿易國")
    ("무역량"
     "貿易量")
    ("무역로"
     "貿易路")
    ("무역선"
     "貿易船")
    ("무역업"
     "貿易業")
    ("무역업자"
     "貿易業者")
    ("무역품"
     "貿易品")
    ("무역학과"
     "貿易學科")
    ("무역항"
     "貿易港")
    ("무연"
     "憮然")
    ("무연탄"
     "無煙炭")
    ("무염치"
     "無廉恥")
    ("무영륜"
     "無影輪")
    ("무예"
     "武藝")
    ("무예인"
     "武藝人")
    ("무오염"
     "無汚染")
    ("무욕"
     "無欲")
    ("무욕망"
     "無慾望")
    ("무용"
     "無用"
     "舞踊")
    ("무용가"
     "舞踊家")
    ("무용계"
     "舞踊界")
    ("무용과"
     "舞踊科")
    ("무용극"
     "舞踊劇")
    ("무용극적"
     "舞踊劇的")
    ("무용단"
     "舞踊團")
    ("무용담"
     "武勇談")
    ("무용도"
     "舞踊圖")
    ("무용론"
     "無用論")
    ("무용복"
     "舞踊服")
    ("무용성"
     "無用性")
    ("무용수"
     "舞踊手")
    ("무용인"
     "舞踊人")
    ("무용제"
     "舞踊祭")
    ("무용지물"
     "無用之物")
    ("무용지용"
     "無用之用")
    ("무용학"
     "舞踊學")
    ("무용학과"
     "舞踊學科")
    ("무원칙"
     "無原則")
    ("무위"
     "無爲")
    ("무위도식"
     "無爲徒食")
    ("무위이화"
     "無爲而化")
    ("무위자연"
     "無爲自然")
    ("무위지치"
     "無爲之治")
    ("무응답"
     "無應答")
    ("무의무탁"
     "無依無托")
    ("무의미"
     "無意味")
    ("무의미성"
     "無意味性")
    ("무의미화"
     "無意味化")
    ("무의식"
     "無意識")
    ("무의식적"
     "無意識的")
    ("무의식중"
     "無意識中")
    ("무의지성"
     "無意志性")
    ("무의촌"
     "無醫村")
    ("무의탁"
     "無依託")
    ("무이론적"
     "無理論的")
    ("무이자"
     "無利子")
    ("무익"
     "無益")
    ("무인"
     "武人"
     "無人")
    ("무인도"
     "無人島")
    ("무인점포"
     "無人店鋪")
    ("무인지경"
     "無人之境")
    ("무인화"
     "無人化")
    ("무일"
     "無一")
    ("무임"
     "無賃")
    ("무임금"
     "無賃金")
    ("무임소"
     "無任所")
    ("무임승차"
     "無賃乘車")
    ("무자격"
     "無資格")
    ("무자료"
     "無資料")
    ("무자비"
     "無慈悲")
    ("무작위"
     "無作爲")
    ("무작위적"
     "無作爲的")
    ("무작정"
     "無酌定")
    ("무장"
     "武將"
     "武裝")
    ("무장공자"
     "無腸公子")
    ("무장력"
     "武裝力")
    ("무장무애"
     "無障無碍")
    ("무장봉기"
     "武裝蜂起")
    ("무장화"
     "武裝化")
    ("무저항"
     "無抵抗")
    ("무적"
     "無敵"
     "無籍")
    ("무전"
     "無錢"
     "無電")
    ("무전기"
     "無電機")
    ("무절제"
     "無節制")
    ("무접촉"
     "無接觸")
    ("무정"
     "無情")
    ("무정부"
     "無政府")
    ("무정자"
     "無精子")
    ("무정형"
     "無定形")
    ("무정형성"
     "無定型性")
    ("무제한"
     "無制限")
    ("무제한급"
     "無制限級")
    ("무제한적"
     "無制限的")
    ("무조건"
     "無條件")
    ("무조건적"
     "無條件的")
    ("무죄"
     "無罪")
    ("무주견"
     "無主見")
    ("무주공산"
     "無主空山")
    ("무주택"
     "無住宅")
    ("무주택자"
     "無住宅者")
    ("무중력"
     "無重力")
    ("무지"
     "無地"
     "無智"
     "無知")
    ("무지막지"
     "無知莫知")
    ("무지몽매"
     "無知蒙昧")
    ("무지무지"
     "無知無知")
    ("무지외반증"
     "拇趾外反症")
    ("무직"
     "無職")
    ("무직자"
     "無職者")
    ("무진"
     "無盡")
    ("무진장"
     "無盡藏")
    ("무질서"
     "無秩序")
    ("무차별"
     "無差別")
    ("무차별적"
     "無差別的")
    ("무참"
     "無慘")
    ("무책"
     "無策")
    ("무책임"
     "無責任")
    ("무처가고"
     "無處可考")
    ("무척추동물"
     "無脊椎動物")
    ("무천"
     "舞天")
    ("무취"
     "無臭")
    ("무치"
     "無恥")
    ("무타"
     "無舵")
    ("무통"
     "無痛")
    ("무투표"
     "無投票")
    ("무패"
     "無敗")
    ("무표정"
     "無表情")
    ("무풍"
     "無風")
    ("무풍기란"
     "無風起瀾")
    ("무풍지대"
     "無風地帶")
    ("무한"
     "無限")
    ("무한궤도적"
     "無限軌道的")
    ("무한대"
     "無限大")
    ("무한량"
     "無限量")
    ("무한성"
     "無限性")
    ("무한정"
     "無限定")
    ("무항상무항심"
     "無恒産無恒心")
    ("무해"
     "無害")
    ("무허가"
     "無許可")
    ("무혈"
     "無血")
    ("무혐의"
     "無嫌疑")
    ("무협지"
     "武俠誌")
    ("무형"
     "無形")
    ("무호흡"
     "無呼吸")
    ("무호흡증"
     "無呼吸症")
    ("무화"
     "無化")
    ("무화과"
     "無花果")
    ("무효"
     "無效")
    ("무효론"
     "無效論")
    ("무효화"
     "無效化")
    ("무휴"
     "無休")
    ("무희"
     "舞姬")
    ("묵"
     ("墨" . "먹 묵, 형벌 이름 묵")
     ("默" . "묵묵할 묵, 고요할 묵")
     ("嘿" . "고요할 묵, 말 아니할 묵"))
    ("묵가"
     "墨家")
    ("묵계"
     "默契")
    ("묵과"
     "默過")
    ("묵념"
     "默念")
    ("묵묵"
     "默默")
    ("묵묵부답"
     "默默不答")
    ("묵비"
     "默秘")
    ("묵비권"
     "默秘權")
    ("묵살"
     "默殺")
    ("묵살당"
     "默殺當")
    ("묵상"
     "默想")
    ("묵시론적"
     "默示論的")
    ("묵시적"
     "默示的")
    ("묵언"
     "默言")
    ("묵인"
     "默認")
    ("묵자비염"
     "墨子悲染")
    ("묵적"
     "默賊")
    ("묵적지수"
     "墨翟之守")
    ("묵주"
     "默珠")
    ("묵중"
     "默重")
    ("묵청색"
     "墨靑色")
    ("묵향"
     "墨香")
    ("묵화"
     "墨畵")
    ("문"
     ("們" . "들 문, 무리 문")
     ("刎" . "목 벨 문, 자를 문, 끊을 문")
     ("吻" . "입술 문, 입가 문")
     ("問" . "물을 문, 알릴 문")
     ("文" . "무늬 문, 얼룩 문")
     ("汶" . "내 이름 문, 수치 문")
     ("紊" . "어지러울 문")
     ("紋" . "무늬 문, 주름 문")
     ("聞" . "들을 문")
     ("蚊" . "모기 문")
     ("門" . "문 문")
     ("雯" . "구름 무늬 문")
     ("匁" . "몸메 문")
     "忞"
     "忟"
     ("悗" . "잊어버릴 문")
     ("懣" . "번거로울 문")
     ("抆" . "닦을 문, 문지를 문")
     ("捫" . "어루만질 문, 쓰다듬을 문")
     ("炆" . "따뜻할 문")
     ("璊" . "붉은 옥 문"))
    ("문간"
     "門間")
    ("문간방"
     "門間房")
    ("문갑"
     "文匣")
    ("문건"
     "文件")
    ("문경"
     "文經")
    ("문경지교"
     "刎頸之交")
    ("문고"
     "文庫")
    ("문고본"
     "文庫本")
    ("문고판"
     "文庫判")
    ("문교"
     "文敎")
    ("문구"
     "文具"
     "文句")
    ("문구점"
     "文具店")
    ("문권"
     "文券")
    ("문단"
     "文壇"
     "文段"
     "紋緞")
    ("문단속"
     "門團束")
    ("문답"
     "問答")
    ("문답식"
     "問答式")
    ("문덕"
     "文德")
    ("문도어맹"
     "問道於盲")
    ("문란"
     "紊亂")
    ("문리"
     "文理")
    ("문리대"
     "文理大")
    ("문맥"
     "文脈")
    ("문맹"
     "文盲")
    ("문맹률"
     "文盲率")
    ("문명"
     "文名"
     "文明")
    ("문명국가"
     "文明國家")
    ("문명권"
     "文明圈")
    ("문명론적"
     "文明論的")
    ("문명사"
     "文明史")
    ("문명사회"
     "文明社會")
    ("문명인"
     "文明人")
    ("문명적"
     "文明的")
    ("문명화"
     "文明化")
    ("문묘"
     "文廟")
    ("문무"
     "文武")
    ("문무대"
     "文武隊")
    ("문물"
     "文物")
    ("문민"
     "文民")
    ("문민정부"
     "文民政府")
    ("문민정치"
     "文民政治")
    ("문민화"
     "文民化")
    ("문방구"
     "文房具")
    ("문방구점"
     "文房具店")
    ("문방사우"
     "文房四友")
    ("문벌"
     "門閥")
    ("문법"
     "文法")
    ("문법서"
     "文法書")
    ("문법성"
     "文法性")
    ("문법적"
     "文法的")
    ("문병"
     "問病")
    ("문불가점"
     "文不加點")
    ("문불야관"
     "門不夜關")
    ("문상"
     "問喪")
    ("문상객"
     "問喪客")
    ("문서"
     "文書")
    ("문서함"
     "文書函")
    ("문서화"
     "文書化")
    ("문설주"
     "門-柱")
    ("문신"
     "文臣"
     "文身")
    ("문안"
     "問安"
     "文案")
    ("문안가"
     "文案家")
    ("문양"
     "文樣")
    ("문어"
     "文魚")
    ("문어발식"
     "文魚-式")
    ("문언"
     "文言")
    ("문예"
     "文藝")
    ("문예란"
     "文藝欄")
    ("문예물"
     "文藝物")
    ("문예비"
     "文藝費")
    ("문예지"
     "文藝誌")
    ("문외한"
     "門外漢")
    ("문우"
     "文友")
    ("문의"
     "問議")
    ("문인"
     "文人")
    ("문인화"
     "文人畵")
    ("문일지십"
     "聞一知十")
    ("문자"
     "文字")
    ("문자적"
     "文字的")
    ("문자판"
     "文字板")
    ("문자화"
     "文字化")
    ("문장"
     "文章"
     "紋章")
    ("문장가"
     "文章家")
    ("문장력"
     "文章力")
    ("문재"
     "文才")
    ("문전"
     "門前")
    ("문전성시"
     "門前成市")
    ("문전옥답"
     "門前沃畓")
    ("문전작라"
     "門前雀羅")
    ("문정경중"
     "問鼎輕重")
    ("문제"
     "問題")
    ("문제극"
     "問題劇")
    ("문제성"
     "問題性")
    ("문제시"
     "問題視")
    ("문제아"
     "問題兒")
    ("문제의식"
     "問題意識")
    ("문제작"
     "問題作")
    ("문제적"
     "問題的")
    ("문제점"
     "問題點")
    ("문제지"
     "問題紙")
    ("문제집"
     "問題集")
    ("문제화"
     "問題化")
    ("문젯"
     "問題")
    ("문중"
     "門中")
    ("문지방"
     "門地枋")
    ("문직"
     "紋織")
    ("문직물"
     "紋織物")
    ("문진"
     "問診")
    ("문질빈빈"
     "文質彬彬")
    ("문집"
     "文集")
    ("문채"
     "文彩")
    ("문책"
     "問責")
    ("문책론"
     "問責論")
    ("문체"
     "文體")
    ("문초"
     "問招")
    ("문치주의"
     "文治主義")
    ("문토불이"
     "文土不二")
    ("문패"
     "門牌")
    ("문필가"
     "文筆家")
    ("문하"
     "門下")
    ("문하생"
     "門下生")
    ("문하시중"
     "門下侍中")
    ("문학"
     "文學"
     "聞學")
    ("문학가"
     "文學家")
    ("문학계"
     "文學界")
    ("문학관"
     "文學觀")
    ("문학도"
     "文學徒")
    ("문학론"
     "文學論")
    ("문학론자"
     "文學論者")
    ("문학사"
     "文學史")
    ("문학사가"
     "文學史家")
    ("문학사적"
     "文學史的")
    ("문학상"
     "文學賞")
    ("문학서"
     "文學書")
    ("문학성"
     "文學性")
    ("문학소녀"
     "文學少女")
    ("문학예술"
     "文學藝術")
    ("문학인"
     "文學人")
    ("문학자"
     "文學者")
    ("문학적"
     "文學的")
    ("문학지"
     "文學誌")
    ("문학청년"
     "文學靑年")
    ("문학파"
     "文學派")
    ("문항"
     "問項")
    ("문헌"
     "文獻")
    ("문호"
     "門戶")
    ("문화"
     "文化")
    ("문화가"
     "文化家")
    ("문화계"
     "文化界")
    ("문화관"
     "文化觀")
    ("문화국"
     "文化國")
    ("문화권"
     "文化圈")
    ("문화대"
     "文化帶")
    ("문화론"
     "文化論")
    ("문화론자"
     "文化論者")
    ("문화론적"
     "文化論的")
    ("문화면"
     "文化面")
    ("문화부"
     "文化部")
    ("문화사"
     "文化史")
    ("문화사적"
     "文化史的")
    ("문화생활"
     "文化生活")
    ("문화생활비"
     "文化生活費")
    ("문화어"
     "文化語")
    ("문화원"
     "文化院")
    ("문화원장"
     "文化院長")
    ("문화유산"
     "文化遺産")
    ("문화인"
     "文化人")
    ("문화인촌"
     "文化人村")
    ("문화인화"
     "文化人化")
    ("문화재"
     "文化財")
    ("문화재적"
     "文化財的")
    ("문화적"
     "文化的")
    ("문화제"
     "文化祭")
    ("문화주의"
     "文化主義")
    ("문화촌"
     "文化村")
    ("문화화"
     "文化化")
    ("물"
     ("勿" . "말 물, 아닐 물, 깃발 물")
     ("沕" . "아득할 물, 숨길 물")
     ("物" . "만물 물, 무리 물"))
    ("물가"
     "物價")
    ("물가고"
     "物價高")
    ("물가국"
     "物價局")
    ("물건"
     "物件")
    ("물격화"
     "物格化")
    ("물경"
     "勿驚")
    ("물경소사"
     "勿輕小事")
    ("물고"
     "物故")
    ("물구"
     "勿拘")
    ("물극즉반"
     "物極則反")
    ("물동량"
     "物動量")
    ("물량"
     "物量")
    ("물론"
     "勿論")
    ("물류"
     "物流")
    ("물류비"
     "物流費")
    ("물류비용"
     "物流費用")
    ("물리"
     "物理")
    ("물리력"
     "物理力")
    ("물리적"
     "物理的")
    ("물리학"
     "物理學")
    ("물리학계"
     "物理學界")
    ("물리학과"
     "物理學科")
    ("물리학자"
     "物理學者")
    ("물리학적"
     "物理學的")
    ("물리학회"
     "物理學會")
    ("물망"
     "物望")
    ("물물"
     "物物")
    ("물박정후"
     "物薄情厚")
    ("물산"
     "物産")
    ("물상"
     "物像"
     "物象")
    ("물상객주"
     "物商客主")
    ("물색"
     "物色")
    ("물성"
     "物性")
    ("물신"
     "物神")
    ("물신성"
     "物神性")
    ("물신적"
     "物神的")
    ("물신주의"
     "物神主義")
    ("물신화"
     "物神化")
    ("물실"
     "勿失")
    ("물심양면"
     "物心兩面")
    ("물심여일"
     "物心如一")
    ("물아일체"
     "物我一體")
    ("물역"
     "物役")
    ("물욕적"
     "物慾的")
    ("물의"
     "物議")
    ("물자"
     "物資")
    ("물자체"
     "物自體")
    ("물장즉노"
     "物壯則老")
    ("물적"
     "物的")
    ("물정"
     "物情")
    ("물증"
     "物證")
    ("물질"
     "物質")
    ("물질계"
     "物質界")
    ("물질관"
     "物質觀")
    ("물질문명"
     "物質文明")
    ("물질문화"
     "物質文化")
    ("물질생활"
     "物質生活")
    ("물질성"
     "物質性")
    ("물질세계"
     "物質世界")
    ("물질적"
     "物質的")
    ("물질주의"
     "物質主義")
    ("물질주의적"
     "物質主義的")
    ("물질학"
     "物質學")
    ("물질화"
     "物質化")
    ("물체"
     "物體")
    ("물품"
     "物品")
    ("물형"
     "物形")
    ("물화"
     "物化")
    ("물화적"
     "物化的")
    ("미"
     ("味" . "맛 미, 뜻 미")
     ("媚" . "아첨할 미, 풍치가 아름다울 미")
     ("尾" . "꼬리 미, 등 미")
     ("嵋" . "산이름 미")
     ("彌" . "두루 미, 널리 미")
     ("微" . "작을 미, 자질구레할 미")
     ("未" . "아닐 미")
     ("梶" . "나무 끝 미")
     ("楣" . "문미 미, 처마 미")
     ("渼" . "물놀이 미, 내 이름 미")
     ("湄" . "물 가 미, 더운 물 미")
     ("眉" . "눈썹 미, 노인 미")
     ("米" . "쌀 미")
     ("美" . "아름다울 미, 맛이 좋을 미")
     ("薇" . "고삐 미")
     ("謎" . "수수께끼 미")
     ("迷" . "미혹할 미, 전념할 미")
     ("靡" . "쓰러질 미, 쏠릴 미")
     ("黴" . "곰팡이 미, 검을 미, 썪을 미")
     ("亹" . "힘쓸 미, 문채가 있는 모양 미")
     ("娓" . "장황할 미, 힘쓸 미")
     ("媄" . "빛 고울 미")
     ("媺" . "착하고 아름다울 미")
     ("弥" . "彌와 同字")
     ("弭" . "활고자 미, 그칠 미")
     ("敉" . "어루만질 미")
     ("瀰" . "물 넓을 미")
     ("獼" . "원숭이 미")
     ("糜" . "죽 미, 싸라기 미")
     ("縻" . "고삐 미, 얽어맬 미")
     "苿"
     ("蘼" . "장미 미, 천궁 미")
     ("麋" . "큰사슴 미, 부서질 미"))
    ("미각"
     "味覺")
    ("미간"
     "眉間")
    ("미감"
     "美感")
    ("미개"
     "未開")
    ("미개봉"
     "未開封")
    ("미개인"
     "未開人")
    ("미개지"
     "未開地")
    ("미개척"
     "未開拓")
    ("미건설"
     "未建設")
    ("미결"
     "未決")
    ("미곡"
     "米穀")
    ("미골"
     "尾骨")
    ("미공개"
     "未公開")
    ("미관"
     "美觀")
    ("미관말직"
     "微官末職")
    ("미구"
     "未久")
    ("미국"
     "美國")
    ("미궁"
     "迷宮")
    ("미기입"
     "未記入")
    ("미남"
     "美男")
    ("미납금"
     "未納金")
    ("미녀"
     "美女")
    ("미달"
     "未達")
    ("미담"
     "美談")
    ("미대"
     "美大")
    ("미대부도"
     "尾大不掉")
    ("미덕"
     "美德")
    ("미도지반"
     "迷途知反")
    ("미동"
     "微動")
    ("미등"
     "尾燈")
    ("미등기"
     "未登記")
    ("미등록"
     "未登錄")
    ("미래"
     "未來")
    ("미래불"
     "未來佛")
    ("미래상"
     "未來像")
    ("미래적"
     "未來的")
    ("미래학자"
     "未來學者")
    ("미래학적"
     "未來學的")
    ("미래형"
     "未來形")
    ("미량"
     "微量")
    ("미려"
     "美麗")
    ("미력"
     "微力")
    ("미련"
     "未練")
    ("미로"
     "迷路")
    ("미로형"
     "迷路型")
    ("미륵"
     "彌勒")
    ("미륵당"
     "彌勒堂")
    ("미륵불"
     "彌勒佛")
    ("미만"
     "未滿")
    ("미망"
     "未忘"
     "迷妄")
    ("미망인"
     "未亡人")
    ("미명"
     "未明"
     "美名")
    ("미모"
     "美貌")
    ("미목반혜"
     "美目盼兮")
    ("미몽"
     "迷夢")
    ("미묘"
     "微妙"
     "美妙")
    ("미문"
     "美文")
    ("미물"
     "微物")
    ("미미"
     "微微")
    ("미백"
     "美白")
    ("미복"
     "微服")
    ("미복학"
     "未復學")
    ("미봉적"
     "彌縫的")
    ("미봉책"
     "彌縫策")
    ("미분"
     "微分")
    ("미분기"
     "微分器")
    ("미분양"
     "未分讓")
    ("미분화"
     "未分化")
    ("미비"
     "未備")
    ("미비점"
     "未備點")
    ("미사여구"
     "美辭麗句")
    ("미상"
     "未詳")
    ("미색"
     "米色")
    ("미생마"
     "未生馬")
    ("미생물"
     "微生物")
    ("미생물학"
     "微生物學")
    ("미생지신"
     "尾生之信")
    ("미서명"
     "未書名")
    ("미성"
     "美聲")
    ("미성년"
     "未成年")
    ("미성년자"
     "未成年者")
    ("미성숙"
     "未成熟")
    ("미성숙론"
     "未成熟論")
    ("미성숙성"
     "未成熟性")
    ("미성일궤"
     "未成一궤")
    ("미세"
     "微細")
    ("미소"
     "微小"
     "微笑")
    ("미수"
     "未收"
     "未遂"
     "米壽")
    ("미수금"
     "未收金")
    ("미숙"
     "未熟")
    ("미숙성"
     "未熟性")
    ("미숙성론"
     "未熟成論")
    ("미숙아"
     "未熟兒")
    ("미술"
     "美術")
    ("미술가"
     "美術家")
    ("미술가론"
     "美術家論")
    ("미술계"
     "美術界")
    ("미술과"
     "美術科")
    ("미술관"
     "美術館")
    ("미술반"
     "美術班")
    ("미술사"
     "美術史")
    ("미술사가"
     "美術史家")
    ("미술사적"
     "美術史的")
    ("미술사학"
     "美術史學")
    ("미술사학과"
     "美術史學科")
    ("미술상"
     "美術商"
     "美術賞")
    ("미술실"
     "美術室")
    ("미술인"
     "美術人")
    ("미술적"
     "美術的")
    ("미술지"
     "美術誌")
    ("미술품"
     "美術品")
    ("미술학과"
     "美術學科")
    ("미시"
     "微視"
     "未時")
    ("미시적"
     "微視的")
    ("미식"
     "美食")
    ("미식가"
     "美食家")
    ("미식축구"
     "美式蹴球")
    ("미신"
     "迷信")
    ("미신고"
     "未申告")
    ("미신고자"
     "未申告者")
    ("미신적"
     "迷信的")
    ("미심"
     "未審")
    ("미아"
     "迷兒")
    ("미아보호소"
     "迷兒保護所")
    ("미안"
     "未安")
    ("미안감"
     "未安感")
    ("미안수"
     "美顔水")
    ("미약"
     "微弱")
    ("미여작랍"
     "味如嚼蠟")
    ("미연"
     "未然")
    ("미열"
     "微熱")
    ("미온적"
     "微溫的")
    ("미완"
     "未完")
    ("미완성"
     "未完成")
    ("미용"
     "美容")
    ("미용실"
     "美容室")
    ("미음"
     "米飮")
    ("미의식"
     "美意識")
    ("미인"
     "美人")
    ("미인계"
     "美人計")
    ("미인도"
     "美人圖")
    ("미인박명"
     "美人薄命")
    ("미인상"
     "美人相")
    ("미인형"
     "美人型")
    ("미장원"
     "美粧院")
    ("미적"
     "美的")
    ("미적분학"
     "微積分學")
    ("미전향"
     "未轉向")
    ("미정"
     "未定")
    ("미제"
     "米帝"
     "美製")
    ("미조직"
     "未組織")
    ("미주신계"
     "米珠薪桂")
    ("미증유"
     "未曾有")
    ("미지"
     "未知")
    ("미지수"
     "未知數")
    ("미진"
     "未盡")
    ("미천"
     "微賤")
    ("미추"
     "美醜")
    ("미측심천"
     "未測深淺")
    ("미풍"
     "微風"
     "美風")
    ("미풍양속"
     "美風良俗")
    ("미필"
     "未畢")
    ("미학"
     "美學")
    ("미학과"
     "美學科")
    ("미학사"
     "美學史")
    ("미학적"
     "美學的")
    ("미해결"
     "未解決")
    ("미행"
     "尾行")
    ("미혹"
     "迷惑")
    ("미혼"
     "未婚")
    ("미혼모"
     "未婚母")
    ("미혼자"
     "未婚者")
    ("미화"
     "美化"
     "美貨")
    ("미화반"
     "美化班")
    ("미화원"
     "美化員")
    ("미확인"
     "未確認")
    ("미확정"
     "未確定")
    ("미흡"
     "未洽")
    ("민"
     ("岷" . "산이름 민")
     ("悶" . "번민할 민")
     ("愍" . "근심할 민")
     ("憫" . "불쌍히 여길 민")
     ("敏" . "민첩할 민")
     ("旻" . "하늘 민")
     ("旼" . "온화할 민")
     ("民" . "백성 민")
     ("泯" . "망할 민")
     ("玟" . "옥돌 민")
     ("珉" . "아름다운돌 민")
     ("緡" . "낚시줄 민")
     ("閔" . "위문할 민")
     ("忞" . "강인할 민")
     ("忟" . "강인할 민")
     ("暋" . "굳셀 민")
     ("湣" . "낚시줄 민")
     ("緍" . "낚시줄 민")
     ("罠" . "그물 민")
     ("苠" . "속대 민")
     ("閩" . "종족이름 민")
     ("鰵" . "대구 민")
     ("黽" . "힘쓸 민"))
    ("민가"
     "民家")
    ("민간"
     "民間")
    ("민간단체"
     "民間團體")
    ("민간약"
     "民間藥")
    ("민간요법"
     "民間療法")
    ("민간용"
     "民間用")
    ("민간인"
     "民間人")
    ("민간전승"
     "民間傳承")
    ("민감"
     "敏感")
    ("민감성"
     "敏感性")
    ("민관"
     "民官")
    ("민국"
     "民國")
    ("민권"
     "民權")
    ("민담"
     "民譚")
    ("민란"
     "民亂")
    ("민박"
     "民泊")
    ("민방"
     "民放")
    ("민방론"
     "民放論")
    ("민방업계"
     "民放業界")
    ("민방위"
     "民防衛")
    ("민방위과"
     "民防衛課")
    ("민법"
     "民法")
    ("민병대"
     "民兵隊")
    ("민복"
     "民復")
    ("민본"
     "民本")
    ("민본론"
     "民本論")
    ("민본주의적"
     "民本主義的")
    ("민사"
     "民事")
    ("민생"
     "民生")
    ("민선"
     "民選")
    ("민속"
     "民俗")
    ("민속극"
     "民俗劇")
    ("민속복"
     "民俗服")
    ("민속자료"
     "民俗資料")
    ("민속제"
     "民俗祭")
    ("민속촌"
     "民俗村")
    ("민속품"
     "民俗品")
    ("민속학"
     "民俗學")
    ("민속학자"
     "民俗學者")
    ("민속화"
     "民俗畵")
    ("민심"
     "民心")
    ("민심처"
     "民心處")
    ("민어"
     "民魚")
    ("민영"
     "民營")
    ("민영화"
     "民營化")
    ("민예"
     "民藝")
    ("민완"
     "敏腕")
    ("민요"
     "民謠")
    ("민요조"
     "民謠調")
    ("민원"
     "民願")
    ("민원실"
     "民願室")
    ("민원인"
     "民願人")
    ("민의"
     "民意")
    ("민의원"
     "民議院")
    ("민자"
     "民資")
    ("민전"
     "民田")
    ("민정"
     "民政")
    ("민족"
     "民族")
    ("민족극"
     "民族劇")
    ("민족복"
     "民族服")
    ("민족사"
     "民族史")
    ("민족사적"
     "民族史的")
    ("민족성"
     "民族性")
    ("민족의상"
     "民族衣裳")
    ("민족의식"
     "民族意識")
    ("민족적"
     "民族的")
    ("민족정기"
     "民族精氣")
    ("민족정신"
     "民族精神")
    ("민족주의"
     "民族主義")
    ("민족주의자"
     "民族主義者")
    ("민족주의적"
     "民族主義的")
    ("민족중흥"
     "民族中興")
    ("민족진영"
     "民族陣營")
    ("민족혼"
     "民族魂")
    ("민주"
     "民主")
    ("민주개혁"
     "民主改革")
    ("민주성"
     "民主性")
    ("민주적"
     "民主的")
    ("민주주의"
     "民主主義")
    ("민주주의적"
     "民主主義的")
    ("민주주의혁명"
     "民主主義革命")
    ("민주화"
     "民主化")
    ("민중"
     "民衆")
    ("민중가요"
     "民衆歌謠")
    ("민중극적"
     "民衆劇的")
    ("민중어"
     "民衆語")
    ("민중적"
     "民衆的")
    ("민첩"
     "敏捷")
    ("민첩성"
     "敏捷性")
    ("민치"
     "民治")
    ("민통선"
     "民統線")
    ("민폐"
     "民弊")
    ("민형사"
     "民刑事")
    ("민호"
     "民戶")
    ("민화"
     "民畵"
     "民話")
    ("민화적"
     "民畵的")
    ("민활"
     "敏活")
    ("밀"
     "宓"
     ("密" . "빽빽할 밀")
     ("蜜" . "꿀 밀")
     ("謐" . "고요할 밀")
     ("樒" . "침향 밀")
     ("滵" . "물 흐르는 모양 밀"))
    ("밀교"
     "密敎")
    ("밀담"
     "密談")
    ("밀도"
     "密度")
    ("밀랍"
     "蜜蠟")
    ("밀림"
     "密林")
    ("밀매"
     "密賣")
    ("밀반입"
     "密搬入")
    ("밀반출"
     "密搬出")
    ("밀봉"
     "密封")
    ("밀사"
     "密使")
    ("밀생"
     "密生")
    ("밀수"
     "密輸")
    ("밀수업자"
     "密輸業者")
    ("밀실"
     "密室")
    ("밀약"
     "密約")
    ("밀어"
     "密魚"
     "蜜語")
    ("밀영"
     "密營")
    ("밀원"
     "蜜源")
    ("밀입북"
     "密入北")
    ("밀접"
     "密接")
    ("밀접성"
     "密接性")
    ("밀지"
     "密旨")
    ("밀집"
     "密集")
    ("밀착"
     "密着")
    ("밀착형"
     "密着型")
    ("밀폐"
     "密閉")
    ("밀항"
     "密航")
    ("밀항자"
     "密航者")
    ("밀회"
     "密會")
    ("바라문"
     "婆羅門")
    ("박"
     ("剝" . "벗길 박")
     ("博" . "넓을 박")
     ("拍" . "칠 박")
     ("搏" . "칠 박")
     ("撲" . "업어질 박")
     ("朴" . "나무껍질 박")
     ("樸" . "통나무 박")
     ("泊" . "머무를 박")
     ("珀" . "호박 박")
     ("璞" . "옥덩어리 박")
     ("箔" . "발 박")
     ("粕" . "지게미 박")
     ("縛" . "묶을 박")
     ("膊" . "포 박")
     ("舶" . "배 박")
     ("薄" . "숲 박")
     ("迫" . "닥칠 박")
     ("雹" . "누리 박")
     ("駁" . "얼룩말 박")
     ("亳" . "땅이름 박")
     "墣"
     ("欂" . "주두 박")
     ("牔" . "박공 박")
     ("鎛" . "종 박")
     ("駮" . "짐승이름 박")
     ("髆" . "어깨쭉지 박"))
    ("박격포"
     "迫擊砲")
    ("박대"
     "薄待")
    ("박동"
     "搏動")
    ("박람회"
     "博覽會")
    ("박람회장"
     "博覽會場")
    ("박래품"
     "舶來品")
    ("박력"
     "迫力")
    ("박리성"
     "剝離性")
    ("박막"
     "薄膜")
    ("박멸"
     "撲滅")
    ("박문강기"
     "博聞强記")
    ("박문약례"
     "博文約禮")
    ("박물관"
     "博物館")
    ("박물관장"
     "博物館長")
    ("박물군자"
     "博物君子")
    ("박물원"
     "博物院")
    ("박물학"
     "博物學")
    ("박물학자"
     "博物學者")
    ("박복"
     "薄福")
    ("박봉"
     "薄俸")
    ("박빙"
     "薄氷")
    ("박사"
     "博士")
    ("박수"
     "拍手")
    ("박수갈채"
     "拍手喝采")
    ("박순경언"
     "薄脣輕言")
    ("박시제중"
     "博施濟衆")
    ("박식"
     "博識")
    ("박애"
     "博愛")
    ("박약"
     "薄弱")
    ("박이부정"
     "博而不精")
    ("박인방증"
     "博引旁證")
    ("박자"
     "拍子")
    ("박자부지"
     "博者不知")
    ("박장대소"
     "拍掌大笑")
    ("박정"
     "薄情")
    ("박제"
     "剝製")
    ("박제화"
     "剝製化")
    ("박지약행"
     "薄志弱行")
    ("박진감"
     "迫眞感")
    ("박진성"
     "迫進性")
    ("박진적"
     "迫進的")
    ("박차"
     "拍車")
    ("박탈"
     "剝奪")
    ("박탈감"
     "剝奪感")
    ("박하"
     "薄荷")
    ("박하사탕"
     "薄荷沙糖")
    ("박학"
     "博學")
    ("박학다식"
     "博學多識")
    ("박해"
     "迫害")
    ("반"
     ("伴" . "짝 반")
     ("半" . "반 반")
     ("反" . "돌이킬 반")
     ("叛" . "배반할 반")
     ("拌" . "버릴 반")
     ("搬" . "옮길 반")
     ("攀" . "더위잡을 반")
     ("斑" . "얼룩 반")
     ("槃" . "쟁반 반")
     ("泮" . "학교 반")
     ("潘" . "뜨물 반")
     ("班" . "나눌 반")
     ("畔" . "지경 반")
     ("瘢" . "흉터 반")
     ("盤" . "소반 반")
     ("盼" . "곁눈질 할 반")
     ("磐" . "넓을 반")
     ("磻" . "강이름 반")
     ("絆" . "줄 반")
     ("般" . "옮길 반")
     ("蟠" . "서릴 반")
     ("返" . "돌이킬 반")
     ("頒" . "나눌 반")
     ("飯" . "밥 반")
     ("仮" . "反과 同字")
     ("媻" . "비틀거릴 반")
     ("扳" . "끌 반")
     ("搫" . "덜 반")
     ("攽" . "나눌 반")
     ("朌" . "구실 반")
     ("肦" . "나눌 반")
     ("胖" . "희생 반")
     ("螌" . "가뢰 반")
     "蹣"
     ("頖" . "풀릴 반"))
    ("반가부좌"
     "半跏趺坐")
    ("반감"
     "半減"
     "反感")
    ("반감기"
     "半減期")
    ("반강제"
     "半强制")
    ("반강제적"
     "半强制的")
    ("반격"
     "反擊")
    ("반격론"
     "反擊論")
    ("반경"
     "半徑")
    ("반경례"
     "半敬禮")
    ("반계곡경"
     "盤溪曲徑")
    ("반고전주의적"
     "反古典主義的")
    ("반공"
     "反共")
    ("반공주의"
     "反共主義")
    ("반과학적"
     "反科學的")
    ("반구상적"
     "反具象的")
    ("반구형"
     "半球形")
    ("반국가"
     "反國家")
    ("반국가적"
     "反國家的")
    ("반군"
     "叛軍")
    ("반군부"
     "反軍部")
    ("반근착절"
     "盤根錯節")
    ("반기"
     "反旗")
    ("반납"
     "返納")
    ("반내성주의"
     "反耐性主義")
    ("반년"
     "半年")
    ("반노예적"
     "半奴隸的")
    ("반농담"
     "半弄談")
    ("반농민적"
     "反農民的")
    ("반당적"
     "反黨的")
    ("반대"
     "反對")
    ("반대급부"
     "反對給付")
    ("반대론"
     "反對論")
    ("반대론자"
     "反對論者")
    ("반대자"
     "反對者")
    ("반대중성"
     "反大衆性")
    ("반대파"
     "反對派")
    ("반대편"
     "反對便")
    ("반도"
     "半島")
    ("반도체"
     "半導體")
    ("반독재"
     "反獨裁")
    ("반독점"
     "反獨占")
    ("반동"
     "反動")
    ("반동분자"
     "反動分子")
    ("반동성"
     "反動性")
    ("반동적"
     "反動的")
    ("반등"
     "反騰")
    ("반라"
     "半裸")
    ("반란"
     "叛亂")
    ("반란군"
     "叛亂軍")
    ("반란죄"
     "叛亂罪")
    ("반려"
     "伴侶"
     "返戾")
    ("반려자"
     "伴侶者")
    ("반론"
     "反論")
    ("반만년"
     "半萬年")
    ("반면"
     "反面")
    ("반면교사"
     "反面敎師")
    ("반명제"
     "反命題")
    ("반명함판"
     "半名銜判")
    ("반목"
     "反目")
    ("반문"
     "反問"
     "斑紋")
    ("반문명"
     "反文明")
    ("반문화"
     "反文化")
    ("반문화적"
     "反文化的")
    ("반미"
     "反美")
    ("반민"
     "反民")
    ("반민족"
     "反民族")
    ("반민족적"
     "反民族的")
    ("반민주"
     "反民主")
    ("반민주성"
     "反民主性")
    ("반민주적"
     "反民主的")
    ("반민주주의적"
     "反民主主義的")
    ("반민중성"
     "反民衆性")
    ("반민중적"
     "反民衆的")
    ("반박"
     "反駁")
    ("반박문"
     "反駁文")
    ("반반"
     "半半")
    ("반발"
     "反撥")
    ("반발력"
     "反撥力")
    ("반발심"
     "反撥心")
    ("반배"
     "半拜")
    ("반변증법적"
     "反辨證法的")
    ("반병"
     "半甁")
    ("반병신"
     "半病身")
    ("반보"
     "半步")
    ("반복"
     "反復")
    ("반복적"
     "反復的")
    ("반봉건"
     "半封建"
     "反封建")
    ("반봉건적"
     "反封建的")
    ("반분"
     "半分")
    ("반비"
     "半臂")
    ("반비례"
     "反比例")
    ("반비판"
     "反批判")
    ("반사"
     "反射")
    ("반사각"
     "反射角")
    ("반사등"
     "反射燈")
    ("반사막"
     "半沙漠")
    ("반사식"
     "反射式")
    ("반사실주의적"
     "反寫實主義的")
    ("반사적"
     "反射的")
    ("반사회적"
     "反社會的")
    ("반상"
     "班常"
     "飯床")
    ("반상회"
     "班常會")
    ("반생"
     "半生")
    ("반생명"
     "反生命")
    ("반생명성"
     "反生命性")
    ("반생명적"
     "反生命的")
    ("반석"
     "盤石")
    ("반석지고"
     "盤石之固")
    ("반성"
     "反省")
    ("반성문"
     "反省文")
    ("반성적"
     "反省的")
    ("반세기"
     "半世紀")
    ("반송"
     "返送")
    ("반수"
     "半數"
     "半睡")
    ("반숙"
     "半熟")
    ("반식민"
     "反植民")
    ("반식민적"
     "反植民的")
    ("반식민지"
     "半植民地")
    ("반식민지적"
     "半植民地的")
    ("반신"
     "半身")
    ("반신반의"
     "半信半疑")
    ("반신반인"
     "半神半人")
    ("반신불수"
     "半身不隨")
    ("반신욕"
     "半身浴")
    ("반실성"
     "半失性")
    ("반실증주의적"
     "反實證主義的")
    ("반야"
     "般若")
    ("반야바라밀"
     "般若波羅蜜")
    ("반역"
     "反逆")
    ("반역사성"
     "反歷史性")
    ("반역자"
     "反逆者")
    ("반열"
     "班列")
    ("반영"
     "反映")
    ("반영구적"
     "半永久的")
    ("반영론적"
     "反映論的")
    ("반왕조"
     "反王朝")
    ("반외세"
     "反外勢")
    ("반원자력"
     "反原子力")
    ("반원형"
     "半圓形")
    ("반윤리적"
     "反倫理的")
    ("반응"
     "反應")
    ("반응성"
     "反應性")
    ("반의사"
     "反意思")
    ("반의지희"
     "斑衣之戱")
    ("반인간"
     "反人間")
    ("반인간적"
     "反人間的")
    ("반인권적"
     "反人權的")
    ("반인륜"
     "反人倫")
    ("반인륜성"
     "反人倫性")
    ("반인륜적"
     "反人倫的")
    ("반인종"
     "反人種")
    ("반일"
     "反日")
    ("반입"
     "搬入")
    ("반자연주의적"
     "反自然主義的")
    ("반작용"
     "反作用")
    ("반작용력"
     "反作用力")
    ("반장"
     "班長")
    ("반전"
     "反戰"
     "反轉")
    ("반절기"
     "半切機")
    ("반점"
     "斑點")
    ("반정"
     "半丁")
    ("반정부"
     "反政府")
    ("반정부적"
     "反政府的")
    ("반정신병자"
     "反精神病者")
    ("반정의"
     "反正意")
    ("반제"
     "反帝")
    ("반주"
     "伴奏"
     "飯酒")
    ("반증"
     "反證")
    ("반지"
     "半指")
    ("반진골적"
     "反眞骨的")
    ("반찬"
     "飯饌")
    ("반체제"
     "反體制")
    ("반추"
     "反芻")
    ("반추상적"
     "半抽象的")
    ("반출"
     "搬出")
    ("반출입"
     "搬出入")
    ("반출증"
     "搬出證")
    ("반칙"
     "反則")
    ("반통일"
     "反統一")
    ("반투명"
     "半透明")
    ("반파"
     "半破")
    ("반평생"
     "半平生")
    ("반포"
     "頒布")
    ("반포지효"
     "反哺之孝")
    ("반폭"
     "半幅")
    ("반학교"
     "反學校")
    ("반항"
     "反抗")
    ("반항기"
     "反抗期")
    ("반항심"
     "反抗心")
    ("반항아"
     "反抗兒")
    ("반항적"
     "反抗的")
    ("반핵"
     "反核")
    ("반향"
     "反響")
    ("반혁명"
     "反革命")
    ("반환"
     "返還")
    ("반환일"
     "返還日")
    ("반환점"
     "返還點")
    ("반희곡적"
     "半戱曲的")
    ("발"
     ("勃" . "갑작스러울 발")
     ("拔" . "뺄 발")
     ("撥" . "다스릴 발")
     ("渤" . "바다이름 발")
     ("潑" . "뿌릴 발")
     ("發" . "쏠 발")
     ("跋" . "밟을 발")
     ("醱" . "술 괼 발")
     ("鉢" . "바리때 발")
     ("髮" . "터럭 발")
     ("魃" . "가물 귀신 발")
     ("哱" . "어지러울 발")
     "孛"
     ("浡" . "일어날 발")
     ("脖" . "배꼽 발")
     ("鈸" . "방울 발")
     ("鵓" . "집비둘기 발"))
    ("발각"
     "發覺")
    ("발간"
     "發刊")
    ("발간사"
     "發刊辭")
    ("발견"
     "發見")
    ("발고"
     "發告")
    ("발광"
     "發光"
     "發狂")
    ("발군"
     "拔群")
    ("발굴"
     "發掘")
    ("발굴물"
     "發掘物")
    ("발굴지"
     "發掘地")
    ("발급"
     "發給")
    ("발급식"
     "發給式")
    ("발기"
     "勃起")
    ("발기력"
     "勃起力")
    ("발단"
     "發端")
    ("발달"
     "發達")
    ("발달사"
     "發達史")
    ("발대식"
     "發隊式")
    ("발동"
     "發動")
    ("발동기"
     "發動機")
    ("발동선"
     "發動船")
    ("발랄"
     "潑剌")
    ("발령"
     "發令")
    ("발로"
     "發露")
    ("발매"
     "發賣")
    ("발매기"
     "發賣機")
    ("발매식"
     "發賣式")
    ("발명"
     "發明")
    ("발명가"
     "發明家")
    ("발명자"
     "發明者")
    ("발명품"
     "發明品")
    ("발모"
     "發毛")
    ("발문"
     "跋文")
    ("발발"
     "勃發")
    ("발병"
     "發病")
    ("발병률"
     "發病率")
    ("발본색원"
     "拔本塞源")
    ("발부"
     "發付")
    ("발사"
     "發射")
    ("발사대"
     "發射臺")
    ("발사음"
     "發射音")
    ("발산"
     "發散")
    ("발산개세"
     "拔山蓋世")
    ("발상"
     "發想"
     "發祥")
    ("발상법"
     "發想法")
    ("발상지"
     "發祥地")
    ("발생"
     "發生")
    ("발생량"
     "發生量")
    ("발생론"
     "發生論")
    ("발생률"
     "發生率")
    ("발생원"
     "發生原")
    ("발생적"
     "發生的")
    ("발생지"
     "發生地")
    ("발생형"
     "發生型")
    ("발선"
     "發船")
    ("발설"
     "發說")
    ("발설자"
     "發說者")
    ("발성"
     "發聲")
    ("발송"
     "發送")
    ("발순"
     "發巡")
    ("발신"
     "發信")
    ("발신인"
     "發信人")
    ("발신자"
     "發信者")
    ("발악"
     "發惡")
    ("발암"
     "發癌")
    ("발암성"
     "發癌性")
    ("발언"
     "發言")
    ("발언권"
     "發言權")
    ("발언대"
     "發言臺")
    ("발열"
     "發熱")
    ("발원"
     "發源")
    ("발원지"
     "發源地")
    ("발육"
     "發育")
    ("발음"
     "發音")
    ("발의"
     "發議")
    ("발인"
     "發靷")
    ("발인식"
     "發靷式")
    ("발작"
     "發作")
    ("발작적"
     "發作的")
    ("발적"
     "發赤")
    ("발전"
     "發展"
     "發電")
    ("발전기"
     "發展期"
     "發電機")
    ("발전사"
     "發展史")
    ("발전상"
     "發展相")
    ("발전성"
     "發展性")
    ("발전소"
     "發電所")
    ("발전안"
     "發展案")
    ("발전적"
     "發展的")
    ("발제자"
     "發題者")
    ("발족"
     "發足")
    ("발족식"
     "發足式")
    ("발주"
     "發注")
    ("발지의천"
     "拔地倚天")
    ("발진"
     "發疹"
     "發進")
    ("발착"
     "發着")
    ("발출"
     "拔出")
    ("발췌"
     "拔萃")
    ("발탁"
     "拔擢")
    ("발파"
     "發破")
    ("발포"
     "發砲")
    ("발포기"
     "發泡器")
    ("발포물"
     "發泡物")
    ("발표"
     "發表")
    ("발표력"
     "發表力")
    ("발표문"
     "發表文")
    ("발표설"
     "發表說")
    ("발표자"
     "發表者")
    ("발표회"
     "發表會")
    ("발한"
     "發汗")
    ("발행"
     "發行")
    ("발행가"
     "發行價")
    ("발행권"
     "發行權")
    ("발행사"
     "發行社")
    ("발행인"
     "發行人")
    ("발행자"
     "發行者")
    ("발현"
     "發現")
    ("발호"
     "跋扈")
    ("발화"
     "發火")
    ("발효"
     "發效"
     "醱酵")
    ("발효법"
     "醱酵法")
    ("발효일"
     "發效日")
    ("발휘"
     "發揮")
    ("발흥"
     "勃興"
     "發興")
    ("방"
     ("倣" . "본뜰 방")
     ("傍" . "곁 방")
     ("坊" . "동네 방")
     ("妨" . "방해할 방")
     ("尨" . "삽살개 방")
     ("幇" . "幫과 同字")
     ("彷" . "거닐 방")
     ("房" . "방 방")
     ("放" . "놓을 방")
     ("方" . "모 방")
     ("旁" . "두루 방")
     ("昉" . "마침 방")
     ("枋" . "다목 방")
     "棒"
     ("榜" . "매 방")
     ("滂" . "비 퍼부을 방")
     ("磅" . "돌 떨어지는 소리 방")
     ("紡" . "자을 방")
     ("肪" . "기름 방")
     ("膀" . "쌍배 방")
     ("舫" . "배 방")
     ("芳" . "꽃다울 방")
     ("蒡" . "인동 덩굴 방")
     ("蚌" . "방합 방")
     ("訪" . "찾을 방")
     ("謗" . "헐뜯을 방")
     ("邦" . "나라 방")
     ("防" . "둑 방")
     ("龐" . "어지러울 방")
     ("仿" . "헤멜 방")
     ("厖" . "클 방")
     ("幫" . "도울 방")
     ("徬" . "시중들 방")
     ("搒" . "배저을 방")
     ("旊" . "옹기장 방")
     ("梆" . "목어 방")
     ("牓" . "패 방")
     ("舽" . "배 방")
     ("螃" . "방게 방")
     ("鎊" . "깎을 방")
     ("髣" . "비슷할 방")
     ("魴" . "방어 방")
     "龎")
    ("방계"
     "傍系")
    ("방곡령"
     "防穀令")
    ("방공호"
     "防空壕")
    ("방과"
     "放課")
    ("방관"
     "傍觀")
    ("방관적"
     "傍觀的")
    ("방극장"
     "房劇場")
    ("방금"
     "方今")
    ("방기"
     "放棄")
    ("방뇨"
     "放尿")
    ("방대"
     "尨大")
    ("방도"
     "方道")
    ("방랑"
     "放浪")
    ("방랑벽"
     "放浪癖")
    ("방랑인"
     "放浪人")
    ("방랑자"
     "放浪者")
    ("방량"
     "放良")
    ("방류"
     "放流")
    ("방만"
     "放漫")
    ("방면"
     "放免"
     "方面")
    ("방명"
     "芳名")
    ("방문"
     "房門"
     "訪問")
    ("방문객"
     "訪問客")
    ("방문자"
     "訪問者")
    ("방미"
     "訪美")
    ("방미두점"
     "防微杜漸")
    ("방미설"
     "訪美說")
    ("방방"
     "房房")
    ("방방곡곡"
     "坊坊曲曲")
    ("방벌적"
     "放伐的")
    ("방범"
     "防犯")
    ("방범대원"
     "防犯隊員")
    ("방범등"
     "防犯燈")
    ("방범망"
     "防犯網")
    ("방법"
     "方法")
    ("방법론"
     "方法論")
    ("방법론적"
     "方法論的")
    ("방법적"
     "方法的")
    ("방벽"
     "防壁")
    ("방부"
     "防腐")
    ("방부성"
     "防腐性")
    ("방부제"
     "防腐劑")
    ("방북"
     "訪北")
    ("방북설"
     "訪北說")
    ("방불"
     "彷彿")
    ("방비"
     "防備")
    ("방비대"
     "防備隊")
    ("방사"
     "放射")
    ("방사기"
     "放射器")
    ("방사능"
     "放射能")
    ("방사선"
     "放射線")
    ("방사선과"
     "放射線科")
    ("방사선형"
     "放射線形")
    ("방사성"
     "放射性")
    ("방사주"
     "紡紗紬")
    ("방사형"
     "放射形")
    ("방석"
     "方席")
    ("방선"
     "放船")
    ("방성대곡"
     "放聲大哭")
    ("방세"
     "房貰")
    ("방손"
     "傍孫")
    ("방송"
     "放送")
    ("방송가"
     "放送街")
    ("방송계"
     "放送界")
    ("방송관"
     "放送觀")
    ("방송국"
     "放送局")
    ("방송권"
     "放送權")
    ("방송극"
     "放送劇")
    ("방송량"
     "放送量")
    ("방송망"
     "放送網")
    ("방송명"
     "放送名")
    ("방송사"
     "放送社")
    ("방송업체"
     "放送業體")
    ("방송인"
     "放送人")
    ("방송학과"
     "放送學科")
    ("방수"
     "防水")
    ("방수량"
     "防水量")
    ("방수성"
     "防水性")
    ("방습"
     "防濕")
    ("방식"
     "方式"
     "防蝕")
    ("방심"
     "放心")
    ("방안"
     "方案")
    ("방약무인"
     "傍若無人")
    ("방어"
     "防禦")
    ("방어벽"
     "防禦壁")
    ("방어용"
     "防禦用")
    ("방어율"
     "防禦率")
    ("방어율왕"
     "防禦率王")
    ("방어자"
     "防禦者")
    ("방어적"
     "防禦的")
    ("방언"
     "方言")
    ("방열"
     "放熱")
    ("방영"
     "放映")
    ("방영분"
     "放映分")
    ("방우귀마"
     "放牛歸馬")
    ("방위"
     "方位"
     "防衛")
    ("방위력"
     "防衛力")
    ("방위비"
     "防衛費")
    ("방위성금"
     "防衛誠金")
    ("방위세"
     "防衛稅")
    ("방유벽"
     "防油壁")
    ("방음"
     "防音")
    ("방음문"
     "防音門")
    ("방음벽"
     "防音壁")
    ("방일"
     "訪日")
    ("방자"
     "放恣")
    ("방장"
     "房帳"
     "房長"
     "方丈")
    ("방장부절"
     "方長不折")
    ("방저원개"
     "方底圓蓋")
    ("방적"
     "紡績")
    ("방적기"
     "紡績機")
    ("방점"
     "傍點")
    ("방정"
     "方正")
    ("방정식"
     "方程式")
    ("방정지사"
     "方正之士")
    ("방제"
     "防除")
    ("방조제"
     "防潮堤")
    ("방종"
     "放縱")
    ("방주"
     "方舟")
    ("방중"
     "訪中")
    ("방증"
     "傍證")
    ("방지"
     "防止")
    ("방지책"
     "防止策")
    ("방직"
     "紡織")
    ("방차"
     "紡車")
    ("방책"
     "方策")
    ("방천"
     "防川")
    ("방청"
     "傍聽")
    ("방청객"
     "傍聽客")
    ("방청석"
     "傍聽席")
    ("방축"
     "防縮")
    ("방춘화시"
     "方春和時")
    ("방출"
     "放出")
    ("방출량"
     "放出量")
    ("방충제"
     "防蟲劑")
    ("방치"
     "放置")
    ("방침"
     "方針")
    ("방탄복"
     "防彈服")
    ("방탕"
     "放蕩")
    ("방탕아"
     "放蕩兒")
    ("방탕자"
     "放蕩者")
    ("방파제"
     "防波堤")
    ("방판"
     "訪販")
    ("방패"
     "防牌")
    ("방편"
     "方便")
    ("방풍"
     "防風")
    ("방풍림"
     "防風林")
    ("방하"
     "放下")
    ("방학"
     "放學")
    ("방학식"
     "放學式")
    ("방한"
     "訪韓"
     "防寒")
    ("방한모"
     "防寒帽")
    ("방한복"
     "防寒服")
    ("방해"
     "妨害")
    ("방해당"
     "妨害當")
    ("방해물"
     "妨害物")
    ("방해죄"
     "妨害罪")
    ("방향"
     "方向")
    ("방향성"
     "方向性")
    ("방향안"
     "方向案")
    ("방호"
     "防護")
    ("방호벽"
     "防護壁")
    ("방호복"
     "防護服")
    ("방호자위"
     "放虎自衛")
    ("방화"
     "放火"
     "防火")
    ("방화범"
     "放火犯")
    ("방화벽"
     "防火壁")
    ("방황"
     "彷徨")
    ("방휼지쟁"
     "蚌鷸之爭")
    ("배"
     ("俳" . "광대 배")
     ("倍" . "곱 배")
     ("培" . "북돋을 배")
     ("徘" . "노닐 배")
     ("拜" . "절 배")
     ("排" . "밀칠 배")
     ("杯" . "잔 배")
     ("湃" . "물결 이는 모양 배")
     ("焙" . "불에 쬘 배")
     ("盃" . "杯의 俗字")
     ("背" . "등 배")
     ("胚" . "아이 밸 배")
     ("裴" . "옷 치렁치렁할 배")
     "裵"
     "褙"
     ("賠" . "물어줄 배")
     ("輩" . "무리 배")
     ("配" . "아내 배")
     ("陪" . "쌓아올릴 배")
     "北"
     ("坏" . "언덕 배")
     ("坯" . "坏와 同字")
     ("扒" . "뺄 배")
     ("琲" . "구슬 꿰미 배")
     ("蓓" . "꽃봉오리 배"))
    ("배가"
     "倍加")
    ("배격"
     "排擊")
    ("배경"
     "背景")
    ("배관"
     "配管")
    ("배관공"
     "配管工")
    ("배구"
     "排球")
    ("배금주의"
     "拜金主義")
    ("배급"
     "配給")
    ("배급량"
     "配給量")
    ("배급사"
     "配給社")
    ("배급소"
     "配給所")
    ("배급제"
     "配給制")
    ("배급품"
     "配給品")
    ("배기"
     "排氣")
    ("배기량"
     "排氣量")
    ("배낭"
     "背囊")
    ("배낭여행"
     "背囊旅行")
    ("배낭족"
     "背囊族")
    ("배냉"
     "背冷")
    ("배뇨량"
     "排尿量")
    ("배달"
     "配達")
    ("배달업"
     "配達業")
    ("배달원"
     "配達員")
    ("배당"
     "配當")
    ("배당금"
     "配當金")
    ("배당률"
     "配當率")
    ("배란"
     "排卵")
    ("배란기"
     "排卵期")
    ("배란일"
     "排卵日")
    ("배려"
     "配慮")
    ("배력"
     "背力")
    ("배면"
     "背面")
    ("배반"
     "背反")
    ("배반낭자"
     "杯盤狼藉")
    ("배반자"
     "背反者")
    ("배변"
     "排便")
    ("배부"
     "配付")
    ("배분"
     "配分")
    ("배불"
     "排佛")
    ("배불론"
     "排佛論")
    ("배산"
     "背山")
    ("배산임수"
     "背山臨水")
    ("배상"
     "賠償")
    ("배상금"
     "賠償金")
    ("배색"
     "配色")
    ("배석"
     "陪席")
    ("배설"
     "排泄")
    ("배설물"
     "排泄物")
    ("배속"
     "配屬")
    ("배수"
     "倍數"
     "拜受"
     "排水"
     "配水")
    ("배수거신"
     "杯水車薪")
    ("배수구"
     "排水口")
    ("배수지진"
     "背水之陣")
    ("배수진"
     "背水陣")
    ("배신"
     "背信"
     "陪臣")
    ("배신감"
     "背信感")
    ("배신당"
     "背信當")
    ("배신자"
     "背信者")
    ("배신적"
     "背信的")
    ("배심원"
     "陪審員")
    ("배알"
     "拜謁")
    ("배암투명"
     "背暗投明")
    ("배양"
     "培養")
    ("배역"
     "配役")
    ("배역진"
     "配役陣")
    ("배열"
     "配列")
    ("배영"
     "背泳")
    ("배우"
     "俳優")
    ("배우난"
     "俳優難")
    ("배우자"
     "配偶者")
    ("배우적"
     "俳優的")
    ("배은망덕"
     "背恩忘德")
    ("배일병행"
     "倍日幷行")
    ("배임"
     "背任")
    ("배임수재"
     "背任受財")
    ("배전"
     "倍前"
     "配電")
    ("배점"
     "配點")
    ("배정"
     "配定")
    ("배제"
     "排除")
    ("배제법"
     "排除法")
    ("배주해원"
     "杯酒解怨")
    ("배중률"
     "排中律")
    ("배중사영"
     "杯中蛇影")
    ("배차"
     "配車")
    ("배척"
     "排斥")
    ("배척당"
     "排斥當")
    ("배출"
     "排出"
     "輩出")
    ("배출구"
     "排出口")
    ("배출량"
     "排出量")
    ("배출로"
     "排出路")
    ("배치"
     "排置"
     "背馳"
     "配置")
    ("배치군"
     "配置軍")
    ("배타성"
     "排他性")
    ("배타적"
     "排他的")
    ("배타주의"
     "排他主義")
    ("배태"
     "胚胎")
    ("배포"
     "排布"
     "配布")
    ("배포권"
     "配布權")
    ("배합"
     "配合")
    ("배합토"
     "配合土")
    ("배회"
     "徘徊")
    ("배후"
     "背後")
    ("배후지"
     "背後地")
    ("백"
     ("伯" . "맏 백")
     "佰"
     ("帛" . "비단 백")
     ("柏" . "나무 이름 백")
     ("栢" . "柏의 俗字")
     ("白" . "흰 백")
     ("百" . "일백 백")
     ("魄" . "넋 백")
     ("粨" . "힉터메트르 백"))
    ("백가"
     "百家")
    ("백가쟁명"
     "百家爭鳴")
    ("백견"
     "白絹")
    ("백경채"
     "白莖菜")
    ("백곡"
     "百穀")
    ("백골"
     "白骨")
    ("백골난망"
     "白骨難忘")
    ("백골단"
     "白骨團")
    ("백과"
     "百科")
    ("백과사전"
     "百科事典")
    ("백구과극"
     "白駒過隙")
    ("백군"
     "白軍")
    ("백귀야행"
     "百鬼夜行")
    ("백기"
     "白旗")
    ("백내장"
     "白內障")
    ("백년"
     "百年")
    ("백년가약"
     "百年佳約")
    ("백년대계"
     "百年大計")
    ("백년지대계"
     "百年之大計")
    ("백년하청"
     "百年河淸")
    ("백년해로"
     "百年偕老")
    ("백단"
     "白檀")
    ("백답"
     "白畓")
    ("백두"
     "白頭")
    ("백두산"
     "白頭山")
    ("백두여신"
     "白頭如新")
    ("백두옹"
     "白頭翁")
    ("백라"
     "白羅")
    ("백락일고"
     "伯樂一顧")
    ("백란과"
     "白蘭科")
    ("백로"
     "白露"
     "白鷺")
    ("백리부미"
     "百里負米")
    ("백마"
     "白馬")
    ("백만"
     "白萬")
    ("백만장자"
     "百萬長者")
    ("백면귀"
     "白面鬼")
    ("백면서생"
     "白面書生")
    ("백면포"
     "白綿布")
    ("백모"
     "白茅")
    ("백무문능"
     "白無紋綾")
    ("백문"
     "百聞")
    ("백미"
     "白眉"
     "白米")
    ("백반"
     "白礬")
    ("백발"
     "白拔"
     "白髮")
    ("백발백중"
     "百發百中")
    ("백방"
     "百方")
    ("백번"
     "百番")
    ("백분"
     "百分")
    ("백사"
     "白蛇"
     "百事")
    ("백사십"
     "百四十")
    ("백사장"
     "白沙場")
    ("백사청송"
     "白沙靑松")
    ("백삼십"
     "百三十")
    ("백색"
     "白色")
    ("백서"
     "白書")
    ("백선"
     "百選")
    ("백선균"
     "白癬菌")
    ("백설"
     "白雪")
    ("백설탕"
     "白雪糖")
    ("백성"
     "百姓")
    ("백세목"
     "白細木")
    ("백세지사"
     "百世之師")
    ("백수"
     "白手")
    ("백수공귀"
     "白首空歸")
    ("백수십"
     "百數十")
    ("백십"
     "百十")
    ("백십육"
     "百十六")
    ("백십이"
     "百十二")
    ("백아절현"
     "伯牙絶絃")
    ("백안시"
     "白眼視")
    ("백약"
     "百藥")
    ("백양"
     "白楊")
    ("백억"
     "百億")
    ("백열"
     "白熱")
    ("백열등"
     "白熱燈")
    ("백열전등"
     "白熱電燈")
    ("백오"
     "百五")
    ("백오십"
     "百五十")
    ("백오십만"
     "百五十萬")
    ("백오십오"
     "百五十五")
    ("백옥"
     "白玉")
    ("백옥미하"
     "白玉微瑕")
    ("백육"
     "百六")
    ("백육십"
     "百六十")
    ("백육십칠"
     "百六十七")
    ("백은"
     "白銀")
    ("백의"
     "白衣")
    ("백의민족"
     "白衣民族")
    ("백의종군"
     "白衣從軍")
    ("백이십"
     "百二十")
    ("백이십팔"
     "百二十八")
    ("백이지렴"
     "伯夷之廉")
    ("백인"
     "白人")
    ("백일"
     "百日")
    ("백일몽"
     "白日夢")
    ("백일장"
     "白日場")
    ("백일청천"
     "白日靑天")
    ("백일하"
     "白日下")
    ("백자"
     "白瓷")
    ("백저"
     "白苧")
    ("백저포"
     "白紵布")
    ("백전노장"
     "百戰老將")
    ("백전백승"
     "百戰百勝")
    ("백절불굴"
     "百折不屈")
    ("백정"
     "白丁")
    ("백정층"
     "白丁層")
    ("백제"
     "百濟")
    ("백조"
     "白鳥")
    ("백주"
     "白晝")
    ("백중"
     "伯仲"
     "百中")
    ("백중세"
     "伯仲勢")
    ("백중숙계"
     "伯仲叔季")
    ("백중절"
     "百中節")
    ("백중지세"
     "伯仲之勢")
    ("백지"
     "白紙")
    ("백지도"
     "白地圖")
    ("백지상태"
     "白紙狀態")
    ("백지장"
     "白紙張")
    ("백지화"
     "白紙化")
    ("백질"
     "白質")
    ("백차"
     "白車")
    ("백척간두"
     "百尺竿頭")
    ("백천만"
     "百千萬")
    ("백천학해"
     "百川學海")
    ("백체"
     "百體")
    ("백출"
     "百出")
    ("백치"
     "白癡")
    ("백칠십"
     "百七十")
    ("백칠십오"
     "百七十五")
    ("백칠십이"
     "百七十二")
    ("백태"
     "白苔")
    ("백팔"
     "百八")
    ("백팔번뇌"
     "百八煩惱")
    ("백팔십"
     "百八十")
    ("백팔십도"
     "百八十度")
    ("백팔십도제"
     "百八十度祭")
    ("백팔십삼"
     "百八十三")
    ("백포도주"
     "白葡萄酒")
    ("백합"
     "白蛤"
     "百合")
    ("백합과"
     "百合科")
    ("백합화"
     "百合花")
    ("백해무익"
     "百害無益")
    ("백혈병"
     "白血病")
    ("백호"
     "白虎")
    ("백호수"
     "白虎水")
    ("백홍관일"
     "白虹貫日")
    ("백화"
     "百花")
    ("백화난만"
     "百花爛漫")
    ("백화점"
     "百貨店")
    ("백화점식"
     "百貨店式")
    ("백화제방"
     "百花齊放")
    ("백회"
     "白灰")
    ("번"
     ("幡" . "기 번")
     ("樊" . "울 번")
     ("煩" . "괴로워할 번")
     ("燔" . "구울 번")
     ("番" . "갈마들 번")
     "礬"
     ("繁" . "많을 번")
     ("蕃" . "우거질 번")
     ("藩" . "덮을 번")
     ("飜" . "뒤칠 번")
     ("磻" . "강이름 번")
     ("繙" . "되풀이 풀이할 번")
     ("翻" . "날 번")
     ("膰" . "제사 고기 번")
     ("蘩" . "산흰쑥 번")
     ("袢" . "속옷 번"))
    ("번견"
     "番犬")
    ("번뇌"
     "煩惱")
    ("번다"
     "煩多")
    ("번민"
     "煩悶")
    ("번번"
     "番番")
    ("번복"
     "飜覆")
    ("번성"
     "蕃盛")
    ("번식"
     "繁殖")
    ("번식기"
     "繁殖期")
    ("번식력"
     "繁殖力")
    ("번식종"
     "繁殖種")
    ("번식지"
     "繁殖地")
    ("번안곡"
     "飜案曲")
    ("번안극"
     "飜案劇")
    ("번역"
     "飜譯")
    ("번역가"
     "飜譯家")
    ("번역권"
     "飜譯權")
    ("번역극"
     "飜譯劇")
    ("번역기"
     "飜譯機")
    ("번역료"
     "飜譯料")
    ("번역문"
     "飜譯文")
    ("번역본"
     "飜譯本")
    ("번역서"
     "飜譯書")
    ("번역어"
     "飜譯語")
    ("번역자"
     "飜譯者")
    ("번역진"
     "飜譯陣")
    ("번영"
     "繁榮")
    ("번잡"
     "煩雜")
    ("번지"
     "番地")
    ("번지수"
     "番地數")
    ("번창"
     "繁昌")
    ("번호"
     "番號")
    ("번호판"
     "番號版")
    ("번화"
     "繁華")
    ("번화가"
     "繁華街")
    ("벌"
     ("伐" . "칠 벌")
     ("筏" . "떼 벌")
     ("罰" . "죄 벌")
     ("閥" . "공훈 벌")
     ("橃" . "떼 벌")
     ("罸" . "罰과 同字"))
    ("벌과금"
     "罰科金")
    ("벌금"
     "罰金")
    ("벌금형"
     "罰金刑")
    ("벌목"
     "伐木")
    ("벌목공"
     "伐木工")
    ("벌채"
     "伐採")
    ("벌채업"
     "伐採業")
    ("벌초"
     "伐草")
    ("벌칙"
     "罰則")
    ("범"
     ("凡" . "무릇 범")
     ("帆" . "돛 범")
     ("梵" . "범어 범")
     ("氾" . "넘칠 범")
     ("汎" . "뜰 범")
     ("泛" . "뜰 범")
     ("犯" . "범할 범")
     ("範" . "법 범")
     ("范" . "풀 이름 범")
     ("笵" . "법 범")
     ("訉" . "말 많을 범")
     ("颿" . "돛 범"))
    ("범개혁"
     "汎改革")
    ("범국민"
     "汎國民")
    ("범국민적"
     "汎國民的")
    ("범람"
     "汎濫")
    ("범민족"
     "汎民族")
    ("범법"
     "犯法")
    ("범법자"
     "犯法者")
    ("범부"
     "凡夫")
    ("범상"
     "凡常")
    ("범상성"
     "凡常性")
    ("범선"
     "帆船")
    ("범성불이"
     "凡聖不二")
    ("범세계적"
     "汎世界的")
    ("범속"
     "凡俗")
    ("범속성"
     "凡俗性")
    ("범시민"
     "汎市民")
    ("범신론적"
     "汎神論的")
    ("범야권"
     "汎野圈")
    ("범위"
     "範圍")
    ("범인"
     "凡人"
     "犯人")
    ("범정부"
     "汎政府")
    ("범정부적"
     "汎政府的")
    ("범죄"
     "犯罪")
    ("범죄성"
     "犯罪性")
    ("범죄인"
     "犯罪人")
    ("범죄자"
     "犯罪者")
    ("범죄적"
     "犯罪的")
    ("범죄형"
     "犯罪型")
    ("범주"
     "範疇")
    ("범주적"
     "範疇的")
    ("범지역"
     "汎地域")
    ("범행"
     "犯行")
    ("법"
     ("法" . "법 법")
     ("琺" . "법랑 법"))
    ("법가"
     "法家")
    ("법계"
     "法界")
    ("법고창신"
     "法古創新")
    ("법과"
     "法科")
    ("법과대"
     "法科大")
    ("법관"
     "法官")
    ("법권"
     "法權")
    ("법규"
     "法規")
    ("법단"
     "法緞")
    ("법당"
     "法堂")
    ("법대"
     "法大"
     "法臺")
    ("법도"
     "法圖"
     "法度")
    ("법랍"
     "法臘")
    ("법령"
     "法令")
    ("법령안"
     "法令案")
    ("법령화"
     "法令化")
    ("법륜"
     "法輪")
    ("법률"
     "法律")
    ("법률가"
     "法律家")
    ("법률관계"
     "法律關係")
    ("법률안"
     "法律案")
    ("법률적"
     "法律的")
    ("법리"
     "法理")
    ("법망"
     "法網")
    ("법명"
     "法名")
    ("법무"
     "法務")
    ("법무관"
     "法務官")
    ("법문"
     "法文"
     "法門")
    ("법복"
     "法服")
    ("법사"
     "法事"
     "法師")
    ("법삼장"
     "法三章")
    ("법상"
     "法床")
    ("법상종"
     "法相宗")
    ("법성"
     "法性")
    ("법신"
     "法身")
    ("법안"
     "法案"
     "法眼")
    ("법열"
     "法悅")
    ("법원"
     "法院")
    ("법원권근"
     "法遠拳近")
    ("법인"
     "法人"
     "法印"
     "法認")
    ("법인세"
     "法人稅")
    ("법인체"
     "法人體")
    ("법적"
     "法的")
    ("법전"
     "法典")
    ("법정"
     "法定"
     "法廷")
    ("법정극"
     "法庭劇")
    ("법정주의"
     "法庭主義")
    ("법정형"
     "法定刑")
    ("법제"
     "法制")
    ("법제적"
     "法制的")
    ("법제화"
     "法制化")
    ("법조"
     "法曹")
    ("법조계"
     "法曹界")
    ("법조문"
     "法條文")
    ("법조인"
     "法曹人")
    ("법질서"
     "法秩序")
    ("법체계"
     "法體系")
    ("법치"
     "法治")
    ("법치주의"
     "法治主義")
    ("법칙"
     "法則")
    ("법칙성"
     "法則性")
    ("법칙적"
     "法則的")
    ("법통"
     "法統")
    ("법학"
     "法學")
    ("법학사"
     "法學士")
    ("법회"
     "法會")
    ("벽"
     ("僻" . "후미질 벽")
     ("劈" . "쪼갤 벽")
     ("壁" . "벽 벽")
     ("擘" . "엄지손가락 벽")
     ("檗" . "황벽나무 벽")
     ("璧" . "동근 옥 벽")
     ("癖" . "적취 벽")
     ("碧" . "푸를 벽")
     ("蘗" . "황경나무 벽")
     ("闢" . "열 벽")
     ("霹" . "벼락 벽")
     ("擗" . "가슴칠 벽")
     "椑"
     ("甓" . "벽돌 벽")
     ("疈" . "가를 벽")
     ("襞" . "주름 벽")
     ("辟" . "임금 벽")
     ("鷿" . "농병아리 벽")
     ("鼊" . "거북 벽"))
    ("벽난로"
     "壁暖爐")
    ("벽두"
     "劈頭")
    ("벽력"
     "霹靂")
    ("벽력섬전"
     "霹靂閃電")
    ("벽류"
     "碧流")
    ("벽면"
     "壁面")
    ("벽보"
     "壁報")
    ("벽시계"
     "壁時計")
    ("벽안"
     "碧眼")
    ("벽안자염"
     "碧眼紫髥")
    ("벽유이"
     "壁有耳")
    ("벽장"
     "壁欌")
    ("벽지"
     "僻地"
     "壁紙")
    ("벽창우"
     "碧昌牛")
    ("벽체"
     "壁體")
    ("벽촌"
     "僻村")
    ("벽화"
     "壁畵")
    ("변"
     ("卞" . "조급할 변")
     ("弁" . "고깔 변")
     "玭"
     ("變" . "변할 변")
     ("辨" . "분별할 변")
     ("辯" . "말잘할 변")
     ("邊" . "가 변")
     ("騈" . "나란히 할 변")
     ("便" . "똥오줌 변")
     "匾"
     "徧"
     ("忭" . "기뻐할 변")
     ("抃" . "손뼉칠 변")
     "汴"
     ("籩" . "제기 이름 변")
     ("腁" . "살갗 틀 변")
     "萹"
     "賆"
     "辮"
     ("駢" . "騈의 俗字")
     ("骿" . "통갈비 변")
     ("鴘" . "매 변"))
    ("변개"
     "變改")
    ("변경"
     "變更"
     "邊境")
    ("변경선"
     "變更線")
    ("변경식"
     "變更式")
    ("변괴"
     "變怪")
    ("변기"
     "便器")
    ("변덕"
     "變德")
    ("변동"
     "變動")
    ("변동기적"
     "變動機的")
    ("변동일실"
     "便同一室")
    ("변란"
     "變亂")
    ("변론"
     "辯論")
    ("변론권"
     "辯論權")
    ("변론문"
     "辯論文")
    ("변명"
     "辨明")
    ("변모"
     "變貌")
    ("변방"
     "邊方")
    ("변별"
     "辨別")
    ("변별적"
     "辨別的")
    ("변복"
     "變服")
    ("변비"
     "便秘")
    ("변사"
     "變死")
    ("변사체"
     "變死體")
    ("변상"
     "辨償")
    ("변색"
     "變色")
    ("변설여류"
     "辯舌如流")
    ("변성"
     "變性")
    ("변성기"
     "變聲期")
    ("변성암"
     "變成巖")
    ("변소"
     "便所")
    ("변소간"
     "便所間")
    ("변수"
     "變數")
    ("변시체"
     "變屍體")
    ("변신"
     "變身")
    ("변신술"
     "變身術")
    ("변심"
     "變心")
    ("변용"
     "變容")
    ("변의"
     "便意")
    ("변이"
     "變異")
    ("변인"
     "變因")
    ("변장"
     "變裝")
    ("변전소"
     "變電所")
    ("변절"
     "變節")
    ("변절자"
     "變節者")
    ("변제"
     "辨濟")
    ("변조"
     "變潮"
     "變調"
     "變造")
    ("변조단"
     "變造團")
    ("변주"
     "變奏")
    ("변주곡"
     "變奏曲")
    ("변즉통"
     "變則通")
    ("변증법"
     "辨證法")
    ("변증법적"
     "辨證法的")
    ("변질"
     "變質")
    ("변천"
     "變遷")
    ("변천사"
     "變遷史")
    ("변칙"
     "變則")
    ("변칙적"
     "變則的")
    ("변태"
     "變態")
    ("변태적"
     "變態的")
    ("변통"
     "變通")
    ("변풍이속"
     "變風移俗")
    ("변혁"
     "變革")
    ("변혁기"
     "變革期")
    ("변형"
     "變形")
    ("변호"
     "辯護")
    ("변호사"
     "辯護士")
    ("변호사계"
     "辯護士界")
    ("변호인"
     "辯護人")
    ("변호인단"
     "辯護人團")
    ("변호인제"
     "辯護人制")
    ("변호제"
     "辯護制")
    ("변화"
     "變化")
    ("변화감"
     "變化感")
    ("변화구"
     "變化球")
    ("변화무쌍"
     "變化無雙")
    ("변화성"
     "變化性")
    ("변환"
     "變換")
    ("별"
     ("別" . "나눌 별")
     ("瞥" . "언뜻 볼 별")
     ("鱉" . "鼈과 同字")
     ("鼈" . "자라 별")
     ("彆" . "활 뒤틀릴 별")
     ("鷩" . "금계 별"))
    ("별감"
     "別監")
    ("별개"
     "別個")
    ("별거"
     "別居")
    ("별관"
     "別館")
    ("별금방"
     "別錦房")
    ("별당"
     "別堂")
    ("별도"
     "別途")
    ("별도리"
     "別道理")
    ("별동대"
     "別動隊")
    ("별리"
     "別離")
    ("별매"
     "別賣")
    ("별명"
     "別名")
    ("별무"
     "別無")
    ("별문단"
     "別紋緞")
    ("별문제"
     "別問題")
    ("별미"
     "別味")
    ("별반"
     "別般")
    ("별별"
     "別別")
    ("별세"
     "別世")
    ("별세계"
     "別世界")
    ("별순검"
     "別巡檢")
    ("별시"
     "別試")
    ("별식"
     "別食")
    ("별안간"
     "瞥眼間")
    ("별읍"
     "別邑")
    ("별의별"
     "別-別")
    ("별이청지"
     "別而聽之")
    ("별입시"
     "別入侍")
    ("별장"
     "別莊")
    ("별정직"
     "別定職")
    ("별지장"
     "別支障")
    ("별차"
     "別差")
    ("별책"
     "別冊")
    ("별천지"
     "別天地")
    ("별칭"
     "別稱")
    ("별표"
     "別表")
    ("별풍회우"
     "別風淮雨")
    ("별호"
     "別號")
    ("병"
     ("丙" . "남녘 병")
     ("倂" . "아우를 병")
     ("兵" . "군사 병")
     ("屛" . "병풍 병")
     "幷"
     ("昞" . "밝을 병")
     ("昺" . "昞과 同字")
     ("柄" . "자루 병")
     ("棅" . "柄과 同字")
     "浜"
     ("炳" . "밝을 병")
     ("甁" . "병 병")
     ("病" . "병 병")
     ("秉" . "잡을 병")
     ("竝" . "아우를 병")
     ("輧" . "거마 소리 병")
     ("餠" . "떡 병")
     ("騈" . "나란히 할 병")
     ("並" . "竝과 同字")
     ("塀" . "담 병")
     "搒"
     ("絣" . "무늬없는 비단 병, 이을 병, 먹줄 튀길 병")
     ("缾" . "두레박 병")
     ("迸" . "달아날 병")
     "鈵"
     ("鉼" . "판금 병")
     ("鋲" . "넓은 못 병, 징 병")
     ("駢" . "騈의 俗字"))
    ("병가"
     "兵家")
    ("병가상사"
     "兵家常事")
    ("병간호"
     "病看護")
    ("병강즉멸"
     "兵彊則滅")
    ("병거지회"
     "兵車之會")
    ("병고"
     "病苦")
    ("병과"
     "倂科"
     "兵科")
    ("병균"
     "病菌")
    ("병기"
     "兵器")
    ("병동"
     "病棟")
    ("병력"
     "兵力"
     "病歷")
    ("병력자"
     "病歷者")
    ("병렬"
     "竝列")
    ("병렬적"
     "竝列的")
    ("병리"
     "病理")
    ("병리과"
     "病理科")
    ("병리사"
     "病理士")
    ("병리학"
     "病理學")
    ("병리학과"
     "病理學科")
    ("병리학적"
     "病理學的")
    ("병립"
     "竝立")
    ("병립제"
     "竝立制")
    ("병마"
     "病魔")
    ("병맥주"
     "甁麥酒")
    ("병명"
     "病名")
    ("병무"
     "兵務")
    ("병문안"
     "病問安")
    ("병반"
     "餠盤")
    ("병법"
     "兵法")
    ("병변"
     "病變")
    ("병사"
     "兵士"
     "病死")
    ("병상"
     "病床")
    ("병색"
     "病色")
    ("병서"
     "兵書")
    ("병설"
     "竝設")
    ("병세"
     "病勢")
    ("병소"
     "病巢")
    ("병수"
     "幷修")
    ("병신"
     "病身")
    ("병신년"
     "丙申年")
    ("병실"
     "病室")
    ("병약"
     "病弱")
    ("병역"
     "兵役")
    ("병영"
     "兵營")
    ("병용"
     "竝用")
    ("병원"
     "病院")
    ("병원성"
     "病原性")
    ("병원장"
     "病院長")
    ("병인"
     "丙寅"
     "病人")
    ("병인양요"
     "丙寅洋擾")
    ("병입고황"
     "病入膏황")
    ("병자"
     "丙子"
     "病者")
    ("병자생"
     "丙子生")
    ("병자호란"
     "丙子胡亂")
    ("병작제"
     "竝作制")
    ("병장"
     "兵長")
    ("병적"
     "病的")
    ("병정"
     "兵丁")
    ("병존"
     "竝存")
    ("병주고향"
     "幷州故鄕")
    ("병중"
     "病中")
    ("병참"
     "兵站")
    ("병촉야유"
     "秉燭夜遊")
    ("병충해"
     "病蟲害")
    ("병폐"
     "病弊")
    ("병풍"
     "屛風")
    ("병합"
     "倂合")
    ("병해충"
     "病害蟲")
    ("병행"
     "竝行")
    ("병환"
     "病患")
    ("병후"
     "病後")
    ("보"
     ("保" . "지킬 보")
     ("堡" . "작은 성 보")
     ("報" . "갚을 보")
     ("寶" . "보배 보")
     ("普" . "널리 보")
     ("步" . "걸을 보")
     ("洑" . "보 보")
     "潽"
     ("珤" . "寶의 古字")
     ("甫" . "클 보")
     ("菩" . "보살 보")
     ("補" . "기울 보")
     ("褓" . "포대기 보")
     ("譜" . "계보 보")
     ("輔" . "덧방나무 보")
     "逋"
     ("俌" . "도울 보")
     "捗"
     ("盙" . "簠의 本字")
     ("簠" . "제기 이름 보")
     ("葆" . "풀 더부룩할 보")
     "靌"
     "鞴"
     ("鴇" . "능에 보")
     ("黼" . "수 보"))
    ("보강"
     "補强"
     "補講")
    ("보거상의"
     "輔車相依")
    ("보건"
     "保健")
    ("보건과"
     "保健課")
    ("보건소"
     "保健所")
    ("보건소장"
     "保健所長")
    ("보검"
     "寶劍")
    ("보결"
     "補缺")
    ("보고"
     "報告"
     "寶庫")
    ("보고대회"
     "報告大會")
    ("보고서"
     "報告書")
    ("보고회"
     "報告會")
    ("보골"
     "補骨")
    ("보관"
     "保管")
    ("보관법"
     "保管法")
    ("보관소"
     "保管所")
    ("보관함"
     "保管函")
    ("보국대"
     "報國隊")
    ("보국안민"
     "輔國安民")
    ("보궁"
     "寶宮")
    ("보궐"
     "補闕")
    ("보균자"
     "保菌者")
    ("보급"
     "普及"
     "補給")
    ("보급대"
     "補給隊")
    ("보급로"
     "補給路")
    ("보급률"
     "補給率")
    ("보급소"
     "補給所")
    ("보답"
     "報答")
    ("보도"
     "報道"
     "寶刀"
     "步道"
     "輔導")
    ("보도국"
     "報道局")
    ("보도국장"
     "報道局長")
    ("보도진"
     "報道陣")
    ("보루"
     "堡壘")
    ("보류"
     "保留")
    ("보리"
     "菩提")
    ("보리수"
     "菩提樹")
    ("보모"
     "保姆")
    ("보무"
     "步武")
    ("보무당당"
     "步武堂堂")
    ("보물"
     "寶物")
    ("보병"
     "步兵")
    ("보복"
     "報復")
    ("보복성"
     "報復性")
    ("보복적"
     "報復的")
    ("보부상"
     "褓負商")
    ("보사"
     "保社")
    ("보살"
     "菩薩")
    ("보살상"
     "菩薩像")
    ("보살행"
     "菩薩行")
    ("보상"
     "報償"
     "補償"
     "褓商")
    ("보상과"
     "報償課")
    ("보상금"
     "報償金"
     "補償金")
    ("보상비"
     "報償費")
    ("보상성"
     "報償性")
    ("보상액"
     "報償額")
    ("보상적"
     "報償的")
    ("보상제"
     "補償制")
    ("보색"
     "補色")
    ("보생이사"
     "報生以死")
    ("보석"
     "寶石")
    ("보석상"
     "寶石商")
    ("보선"
     "補選")
    ("보수"
     "保守"
     "報酬"
     "補修")
    ("보수성"
     "保守性")
    ("보수적"
     "保守的")
    ("보수주의"
     "保守主義")
    ("보수주의자"
     "保守主義者")
    ("보수파"
     "保守派")
    ("보습"
     "補濕")
    ("보시"
     "布施")
    ("보신"
     "保身"
     "補身")
    ("보신용"
     "補身用")
    ("보신주의"
     "保身主義")
    ("보신지책"
     "保身之策")
    ("보신탕"
     "補身湯")
    ("보안"
     "保安")
    ("보안관"
     "保安官")
    ("보안대"
     "保安隊")
    ("보안등"
     "保安燈")
    ("보안사"
     "保安司")
    ("보안서원"
     "保安署員")
    ("보안원"
     "保安員")
    ("보약"
     "補藥")
    ("보양"
     "保養")
    ("보온"
     "保溫")
    ("보온밥통"
     "保溫-桶")
    ("보온병"
     "保溫甁")
    ("보완"
     "補完")
    ("보완적"
     "補完的")
    ("보완책"
     "補完策")
    ("보원이덕"
     "報怨以德")
    ("보위"
     "保衛"
     "寶位")
    ("보위부"
     "保衛部")
    ("보위부장"
     "保衛部長")
    ("보위원"
     "保衛員")
    ("보유"
     "保有"
     "保維")
    ("보유국"
     "保有國")
    ("보유량"
     "保有量")
    ("보유설"
     "保有說")
    ("보유액"
     "保有額")
    ("보유율"
     "保有率")
    ("보유자"
     "保有者")
    ("보유주"
     "保有株")
    ("보육"
     "保育")
    ("보육원"
     "保育院")
    ("보은"
     "報恩")
    ("보음제"
     "補陰劑")
    ("보인"
     "保人")
    ("보장"
     "保藏"
     "保障")
    ("보장금"
     "保障金")
    ("보장적"
     "保障的")
    ("보전"
     "保全"
     "補塡")
    ("보정"
     "補正")
    ("보조"
     "步調"
     "補助")
    ("보조금"
     "補助金")
    ("보조물"
     "補助物")
    ("보조액"
     "補助額")
    ("보조원"
     "補助員")
    ("보조율"
     "補助率")
    ("보조적"
     "補助的")
    ("보존"
     "保存")
    ("보존법"
     "保存法")
    ("보존자"
     "保存者")
    ("보존회"
     "保存會")
    ("보좌"
     "補佐")
    ("보좌관"
     "補佐官")
    ("보좌관실"
     "輔佐官室")
    ("보좌역"
     "輔佐役")
    ("보좌진"
     "輔佐陣")
    ("보주"
     "寶珠")
    ("보증"
     "保證")
    ("보증과"
     "保證課")
    ("보증금"
     "保證金")
    ("보증서"
     "保證書")
    ("보증인"
     "保證人")
    ("보직"
     "補職")
    ("보직자"
     "補職者")
    ("보천지하"
     "普天之下")
    ("보초"
     "步哨")
    ("보충"
     "補充")
    ("보충역"
     "補充役")
    ("보충적"
     "補充的")
    ("보충제"
     "補充制")
    ("보통"
     "普通")
    ("보통례"
     "普通例")
    ("보통학교"
     "普通學校")
    ("보편"
     "普遍")
    ("보편성"
     "普遍性")
    ("보편적"
     "普遍的")
    ("보편주의"
     "普遍主義")
    ("보편타당"
     "普遍妥當")
    ("보편화"
     "普遍化")
    ("보폭"
     "步幅")
    ("보필"
     "輔弼")
    ("보학"
     "譜學")
    ("보학지인"
     "寶學之人")
    ("보합권"
     "保合圈")
    ("보행"
     "步行")
    ("보행자"
     "步行者")
    ("보험"
     "保險")
    ("보험금"
     "保險金")
    ("보험료"
     "保險料")
    ("보험사"
     "保險社")
    ("보험업"
     "保險業")
    ("보험업계"
     "保險業界")
    ("보험업체"
     "保險業體")
    ("보험적"
     "保險的")
    ("보험제"
     "保險制")
    ("보험증"
     "保險證")
    ("보혁"
     "保革")
    ("보혈"
     "補血")
    ("보호"
     "保護")
    ("보호법"
     "保護法")
    ("보호석"
     "保護席")
    ("보호설"
     "保護說")
    ("보호소"
     "保護所")
    ("보호실"
     "保護室")
    ("보호자"
     "保護者")
    ("보호주의"
     "保護主義")
    ("보호직"
     "保護職")
    ("보호책"
     "保護策")
    ("보화"
     "寶貨")
    ("보화난수"
     "寶貨難수")
    ("보훈"
     "報勳")
    ("복"
     ("伏" . "엎드릴 복")
     ("僕" . "종 복")
     ("匐" . "길 복")
     ("卜" . "점 복")
     ("宓" . "성 복")
     ("復" . "돌아올 복")
     ("撲" . "닦을 복")
     ("服" . "옷 복")
     "洑"
     ("福" . "복 복")
     ("腹" . "배 복")
     ("茯" . "복령 복")
     ("蔔" . "무우 복")
     ("複" . "겹옷 복")
     ("覆" . "뒤집힐 복")
     ("輹" . "복토 복")
     ("輻" . "바퀴살 복")
     ("馥" . "향기 복")
     ("鰒" . "전복 복")
     "仆"
     ("墣" . "흙덩이 복")
     ("幞" . "건 복")
     ("扑" . "칠 복")
     ("濮" . "강 이름 복")
     ("箙" . "전동 복")
     ("菔" . "무 복")
     ("蝠" . "박쥐 복")
     ("蝮" . "살무사 복")
     ("鵩" . "새 이름 복"))
    ("복강"
     "腹腔")
    ("복강경"
     "腹腔鏡")
    ("복개"
     "覆蓋")
    ("복거지계"
     "覆車之戒")
    ("복고"
     "復古")
    ("복고적"
     "復古的")
    ("복고주의"
     "復古主義")
    ("복고풍"
     "復古風")
    ("복공판"
     "覆工板")
    ("복과재생"
     "福過災生")
    ("복구"
     "復仇"
     "復舊")
    ("복구공사"
     "復舊工事")
    ("복권"
     "復權"
     "福券")
    ("복권주의자"
     "復權主義者")
    ("복귀"
     "復歸")
    ("복냉"
     "腹冷")
    ("복덕방"
     "福德房")
    ("복도"
     "複道")
    ("복락"
     "福樂")
    ("복룡봉추"
     "伏龍鳳雛")
    ("복리"
     "福利")
    ("복마"
     "卜馬")
    ("복마전"
     "伏魔殿")
    ("복막염"
     "腹膜炎")
    ("복면"
     "覆面")
    ("복명서"
     "復命書")
    ("복모음"
     "複母音")
    ("복무"
     "服務")
    ("복무규정"
     "服務規程")
    ("복무자"
     "服務者")
    ("복부"
     "腹部")
    ("복부중지"
     "福不重至")
    ("복사"
     "伏射"
     "複寫"
     "輻射")
    ("복사기"
     "複寫機")
    ("복사무"
     "輻射霧")
    ("복사본"
     "複寫本")
    ("복사실"
     "複寫室")
    ("복사판"
     "複寫版")
    ("복상사"
     "腹上死")
    ("복색"
     "服色")
    ("복선"
     "伏線")
    ("복선화"
     "複線化")
    ("복소파란"
     "覆巢破卵")
    ("복속"
     "服屬")
    ("복수"
     "復讐"
     "腹水"
     "複數")
    ("복수난수"
     "覆水難收")
    ("복수심"
     "復讐心")
    ("복수안"
     "複數案")
    ("복수초"
     "福壽草")
    ("복수화"
     "複數化")
    ("복습"
     "復習")
    ("복식"
     "服飾"
     "腹式"
     "複式")
    ("복식미"
     "服飾美")
    ("복식사"
     "服飾史")
    ("복식조"
     "複式組")
    ("복아탈구"
     "復亞脫歐")
    ("복안"
     "腹案")
    ("복역"
     "服役")
    ("복엽"
     "複葉")
    ("복용"
     "服用")
    ("복원"
     "復元")
    ("복음"
     "福音")
    ("복음주의"
     "福音主義")
    ("복잡"
     "複雜")
    ("복잡다기"
     "複雜多岐")
    ("복잡다단"
     "複雜多端")
    ("복잡성"
     "複雜性")
    ("복잡화"
     "複雜化")
    ("복장"
     "服裝"
     "腹臟")
    ("복장미"
     "服裝美")
    ("복적"
     "復籍")
    ("복제"
     "複製")
    ("복제권"
     "複製權")
    ("복제물"
     "複製物")
    ("복제판"
     "複製版")
    ("복종"
     "服從")
    ("복중"
     "伏中")
    ("복지"
     "服地"
     "福祉")
    ("복지과"
     "福祉科")
    ("복지관"
     "福祉館")
    ("복지부동"
     "伏地不動")
    ("복지원"
     "福祉院")
    ("복지유체"
     "伏地流涕")
    ("복지학"
     "福祉學")
    ("복지학과"
     "福祉學科")
    ("복직"
     "復職")
    ("복직근"
     "腹直筋")
    ("복진"
     "腹診")
    ("복창"
     "復唱")
    ("복토"
     "覆土")
    ("복통"
     "腹痛")
    ("복학"
     "復學")
    ("복학생"
     "復學生")
    ("복합"
     "複合")
    ("복합성"
     "複合性")
    ("복합적"
     "複合的")
    ("복합체"
     "複合體")
    ("본"
     ("本" . "밑 본"))
    ("본가"
     "本家")
    ("본거지"
     "本據地")
    ("본건"
     "本件")
    ("본격"
     "本格")
    ("본격적"
     "本格的")
    ("본격화"
     "本格化")
    ("본고"
     "本考")
    ("본고사"
     "本考査")
    ("본과"
     "本科")
    ("본관"
     "本貫"
     "本館")
    ("본관제"
     "本貫制")
    ("본교"
     "本校")
    ("본국"
     "本國")
    ("본궁"
     "本宮")
    ("본궤도"
     "本軌道")
    ("본기"
     "本紀")
    ("본능"
     "本能")
    ("본능적"
     "本能的")
    ("본당"
     "本堂")
    ("본대"
     "本隊")
    ("본래"
     "本來")
    ("본래적"
     "本來的")
    ("본령"
     "本領")
    ("본론"
     "本論")
    ("본류"
     "本流")
    ("본말"
     "本末")
    ("본말전도"
     "本末顚倒")
    ("본말체"
     "本末體")
    ("본명"
     "本名")
    ("본문"
     "本文")
    ("본문체"
     "本文體")
    ("본변"
     "本邊")
    ("본보"
     "本報")
    ("본봉"
     "本俸")
    ("본부"
     "本部")
    ("본부장"
     "本部長")
    ("본분"
     "本分")
    ("본비아물"
     "本非我物")
    ("본사"
     "本寺"
     "本社")
    ("본산"
     "本山")
    ("본색"
     "本色")
    ("본서"
     "本署")
    ("본선"
     "本選")
    ("본성"
     "本性")
    ("본성적"
     "本性的")
    ("본시"
     "本是")
    ("본심"
     "本心")
    ("본안"
     "本案")
    ("본업"
     "本業")
    ("본연"
     "本然")
    ("본원적"
     "本源的")
    ("본위"
     "本位")
    ("본의"
     "本意")
    ("본인"
     "本人")
    ("본적"
     "本籍")
    ("본적지"
     "本籍地")
    ("본전"
     "本錢")
    ("본점"
     "本店")
    ("본제입납"
     "本第入納")
    ("본존"
     "本尊")
    ("본존불"
     "本尊佛")
    ("본지"
     "本紙"
     "本誌")
    ("본질"
     "本質")
    ("본질론"
     "本質論")
    ("본질적"
     "本質的")
    ("본처"
     "本妻")
    ("본청"
     "本廳")
    ("본체"
     "本體")
    ("본체적"
     "本體的")
    ("본토"
     "本土")
    ("본향"
     "本鄕")
    ("본회의"
     "本會議")
    ("볼"
     "乶")
    ("봉"
     ("俸" . "녹 봉")
     ("奉" . "받들 봉")
     ("封" . "봉할 봉")
     ("峯" . "봉우리 봉")
     ("峰" . "峯과 同字")
     ("捧" . "받들 봉")
     ("棒" . "몽둥이 봉")
     ("烽" . "봉화 봉")
     ("熢" . "연기 자욱할 봉")
     ("琫" . "칼집 장식 봉")
     ("縫" . "꿰맬 봉")
     ("蓬" . "쑥 봉")
     ("蜂" . "벌 봉")
     ("逢" . "만날 봉")
     ("鋒" . "칼끝 봉")
     ("鳳" . "봉새 봉")
     ("丰" . "예쁠 봉")
     ("夆" . "끌 봉")
     ("篷" . "뜸 봉")
     ("綘" . "縫과 同字")
     ("菶" . "풀 무성할 봉")
     "葑"
     ("鴌" . "鳳의 古字"))
    ("봉거대공"
     "鳳去臺空")
    ("봉건"
     "封建")
    ("봉건론자"
     "封建論者")
    ("봉건성"
     "封建性")
    ("봉건적"
     "封建的")
    ("봉건제"
     "封建制")
    ("봉건제론자"
     "封建制論者")
    ("봉건제적"
     "封建制的")
    ("봉건파적"
     "封建派的")
    ("봉공"
     "奉公")
    ("봉급"
     "俸給")
    ("봉급생활자"
     "俸給生活者")
    ("봉급자"
     "俸給者")
    ("봉기"
     "蜂起")
    ("봉당"
     "封堂")
    ("봉독"
     "奉讀")
    ("봉두난발"
     "蓬頭亂髮")
    ("봉래약수"
     "蓬萊弱水")
    ("봉명조양"
     "鳳鳴朝陽")
    ("봉목시성"
     "蜂目豺聲")
    ("봉변"
     "逢變")
    ("봉복절도"
     "捧腹絶倒")
    ("봉분"
     "封墳")
    ("봉사"
     "奉仕"
     "奉祀")
    ("봉사관"
     "奉仕館")
    ("봉사단"
     "奉仕團")
    ("봉사원"
     "奉仕員")
    ("봉사자"
     "奉仕者")
    ("봉선화"
     "鳳仙花")
    ("봉쇄"
     "封鎖")
    ("봉쇄령"
     "封鎖令")
    ("봉쇄망"
     "封鎖網")
    ("봉수대"
     "烽燧臺")
    ("봉시장사"
     "封豕長蛇")
    ("봉안"
     "奉安")
    ("봉양"
     "奉養")
    ("봉의천대"
     "縫衣淺帶")
    ("봉인"
     "封印")
    ("봉장작희"
     "逢場作戱")
    ("봉접수향"
     "蜂蝶隨香")
    ("봉제"
     "縫製")
    ("봉제공"
     "縫製工")
    ("봉제업"
     "縫製業")
    ("봉조부지"
     "鳳鳥不至")
    ("봉준장목"
     "蜂準長目")
    ("봉지"
     "封紙")
    ("봉직"
     "奉職")
    ("봉착"
     "逢着")
    ("봉창"
     "封窓")
    ("봉투"
     "封套")
    ("봉함"
     "封緘")
    ("봉합"
     "封合"
     "縫合")
    ("봉합선"
     "縫合線")
    ("봉행"
     "奉行")
    ("봉호만택"
     "蓬蒿滿宅")
    ("봉화"
     "烽火")
    ("봉화대"
     "烽火臺")
    ("봉환"
     "奉還")
    ("봉환단"
     "奉還團")
    ("봉황"
     "鳳凰")
    ("봉황래의"
     "鳳皇來儀")
    ("봉황우비"
     "鳳凰于飛")
    ("부"
     ("不" . "아닐 부")
     ("付" . "줄 부")
     ("俯" . "구푸릴 부")
     ("傅" . "스승 부")
     ("剖" . "쪼갤 부")
     ("副" . "버금 부")
     ("否" . "아닐 부")
     ("咐" . "분부할 부")
     ("埠" . "선창 부")
     ("培" . "무덤 부")
     ("夫" . "지아비 부")
     ("婦" . "며느리 부")
     ("孚" . "미쁠 부")
     ("孵" . "알 깔 부")
     ("富" . "가멸 부")
     ("府" . "곳집 부")
     ("扶" . "도울 부")
     ("敷" . "펼 부")
     ("斧" . "도끼 부")
     ("浮" . "뜰 부")
     ("溥" . "펼 부")
     ("父" . "아비 부")
     ("符" . "부신 부")
     ("簿" . "장부 부")
     ("缶" . "장군 부")
     ("腐" . "썩을 부")
     ("腑" . "장부 부")
     ("膚" . "살갗 부")
     ("艀" . "작은 배 부")
     ("芙" . "부용 부")
     ("莩" . "풀 이름 부")
     ("訃" . "부고 부")
     ("負" . "질 부")
     ("賦" . "구실 부")
     ("賻" . "부의 부")
     ("赴" . "나아갈 부")
     ("趺" . "책상다리할 부")
     ("部" . "거느릴 부")
     ("釜" . "가마 부")
     ("阜" . "언덕 부")
     ("附" . "붙을 부")
     ("駙" . "곁마 부")
     ("鳧" . "오리 부")
     ("復" . "다시 부")
     ("仆" . "엎드릴 부")
     ("俘" . "사로잡을 부")
     "俛"
     ("媍" . "婦와 同字")
     ("抔" . "움킬 부")
     ("拊" . "어루만질 부")
     ("掊" . "그러모을 부")
     ("桴" . "마룻대 부")
     ("榑" . "부상 부")
     ("涪" . "물거품 부")
     ("玞" . "옥돌 부")
     ("祔" . "합사할 부")
     ("筟" . "대청 부")
     ("罘" . "그물 부")
     ("罦" . "그물 부")
     ("胕" . "장부 부")
     ("芣" . "질경이 부")
     ("苻" . "귀목풀 부")
     ("蔀" . "빈지문 부")
     ("蚨" . "파랑강충이 부")
     ("蜉" . "하루살이 부")
     "袝"
     ("裒" . "모을 부")
     ("跗" . "발등 부")
     ("鈇" . "도끼 부")
     ("頫" . "머리 숙일 부")
     ("鮒" . "붕어 부")
     ("麩" . "밀기울 부"))
    ("부가"
     "附加")
    ("부가세"
     "附加稅")
    ("부가적"
     "附加的")
    ("부각"
     "浮刻")
    ("부감법"
     "俯瞰法")
    ("부강"
     "富强")
    ("부검"
     "剖檢")
    ("부결"
     "否決")
    ("부계"
     "父系")
    ("부고"
     "訃告")
    ("부곡"
     "部曲")
    ("부곡민"
     "部曲民")
    ("부곡제"
     "部曲制")
    ("부과"
     "賦課")
    ("부과율"
     "賦課率")
    ("부관"
     "釜關")
    ("부관참시"
     "剖棺斬屍")
    ("부교감"
     "副交感")
    ("부교수"
     "副敎授")
    ("부교재"
     "副敎材")
    ("부국"
     "富國")
    ("부국강병"
     "富國强兵")
    ("부국강병책"
     "富國强兵策")
    ("부국장"
     "副局長")
    ("부군"
     "夫君")
    ("부권"
     "父權")
    ("부귀"
     "富貴")
    ("부귀다남"
     "富貴多男")
    ("부귀영화"
     "富貴榮華")
    ("부귀재천"
     "富貴在天")
    ("부귀처영"
     "夫貴妻榮")
    ("부근"
     "附近")
    ("부금"
     "賦金")
    ("부기"
     "浮氣"
     "簿記")
    ("부기장"
     "副機長")
    ("부내"
     "府內"
     "部內")
    ("부녀"
     "婦女"
     "父女")
    ("부녀자"
     "婦女子")
    ("부녀화"
     "婦女化")
    ("부녀회"
     "婦女會")
    ("부녀회원"
     "婦女會員")
    ("부녀회장"
     "婦女會長")
    ("부단"
     "不斷")
    ("부단장"
     "副團長")
    ("부달시변"
     "不達時變")
    ("부담"
     "負擔")
    ("부담감"
     "負擔感")
    ("부담금"
     "負擔金")
    ("부담률"
     "負擔率")
    ("부담액"
     "負擔額")
    ("부담자"
     "負擔者")
    ("부담자층"
     "負擔者層")
    ("부담층"
     "負擔層")
    ("부당"
     "不當")
    ("부당성"
     "不當性")
    ("부대"
     "負袋"
     "部隊"
     "附帶")
    ("부대변인"
     "副代辯人")
    ("부대설비"
     "附帶設備")
    ("부대시설"
     "附帶施設")
    ("부대원"
     "部隊員")
    ("부대장"
     "部隊長")
    ("부대표"
     "副代表")
    ("부덕"
     "不德"
     "婦德")
    ("부도"
     "不渡"
     "附圖")
    ("부도덕"
     "不道德")
    ("부도덕성"
     "不道德性")
    ("부도심"
     "副都心")
    ("부도율"
     "不渡率")
    ("부동"
     "不動"
     "浮動")
    ("부동대천"
     "不同戴天")
    ("부동산"
     "不動産")
    ("부동산업"
     "不動産業")
    ("부동산업계"
     "不動産業界")
    ("부동산업자"
     "不動産業者")
    ("부동심"
     "不動心")
    ("부동자세"
     "不動姿勢")
    ("부동표"
     "浮動票")
    ("부동화"
     "不動化")
    ("부두"
     "埠頭")
    ("부두목"
     "副頭目")
    ("부둣"
     "埠頭")
    ("부득불"
     "不得不")
    ("부득요령"
     "不得要領")
    ("부득이"
     "不得已")
    ("부락"
     "部落")
    ("부랑"
     "浮浪")
    ("부랑아"
     "浮浪兒")
    ("부랑자"
     "浮浪者")
    ("부랑패류"
     "浮浪悖類")
    ("부력"
     "浮力")
    ("부로위고"
     "婦老爲姑")
    ("부록"
     "附錄")
    ("부류"
     "部類")
    ("부리방제"
     "部里坊制")
    ("부면"
     "部面")
    ("부모"
     "父母")
    ("부모구존"
     "父母俱存")
    ("부문"
     "部門")
    ("부문분"
     "部門分")
    ("부민"
     "府民")
    ("부반장"
     "副班長")
    ("부병제"
     "府兵制")
    ("부복"
     "俯伏")
    ("부복장주"
     "剖腹藏珠")
    ("부부"
     "夫婦")
    ("부부간"
     "夫婦間")
    ("부부애"
     "夫婦愛")
    ("부부유별"
     "夫婦有別")
    ("부부자자"
     "父父子子")
    ("부부장"
     "副部長")
    ("부분"
     "部分")
    ("부분부분"
     "部分部分")
    ("부분성"
     "部分性")
    ("부분적"
     "部分的")
    ("부분전"
     "部分戰")
    ("부분품"
     "部分品")
    ("부분화"
     "部分化")
    ("부사"
     "副使"
     "副詞"
     "府使")
    ("부사령관"
     "副司令官")
    ("부사무장"
     "副事務長")
    ("부사장"
     "副社長")
    ("부사종자"
     "夫死從子")
    ("부산"
     "釜山")
    ("부산물"
     "副産物")
    ("부상"
     "副賞"
     "富商"
     "扶桑"
     "浮上"
     "負傷"
     "負商")
    ("부상당"
     "負傷當")
    ("부상자"
     "負傷者")
    ("부생약몽"
     "浮生若夢")
    ("부서"
     "部署")
    ("부서기"
     "副書記")
    ("부서명"
     "部署名")
    ("부서장"
     "部署長")
    ("부석"
     "浮石")
    ("부설"
     "附設")
    ("부성애적"
     "父性愛的")
    ("부세"
     "賦稅")
    ("부소장"
     "副所長")
    ("부속"
     "附屬")
    ("부속물"
     "附屬物")
    ("부속사"
     "附屬寺")
    ("부속실"
     "附屬室")
    ("부속실장"
     "附屬室長")
    ("부속실장실"
     "附屬室長室")
    ("부속지"
     "附屬地")
    ("부속품"
     "附屬品")
    ("부송"
     "付送")
    ("부수"
     "部數"
     "附隨")
    ("부수상"
     "副首相")
    ("부수적"
     "附隨的")
    ("부식"
     "副食"
     "腐蝕")
    ("부식강상"
     "扶植綱常")
    ("부식비"
     "副食費")
    ("부식적"
     "腐蝕的")
    ("부식질"
     "腐植質")
    ("부신"
     "副腎")
    ("부신입화"
     "負薪入火")
    ("부신지우"
     "負薪之憂")
    ("부실"
     "不實")
    ("부실시공"
     "不實施工")
    ("부실화"
     "不實化")
    ("부심"
     "副審"
     "腐心")
    ("부양"
     "扶養"
     "浮揚")
    ("부양비"
     "扶養費")
    ("부양자"
     "扶養者")
    ("부양책"
     "浮揚策")
    ("부업"
     "副業")
    ("부여"
     "賦與"
     "附與")
    ("부역"
     "賦役"
     "附逆")
    ("부역장"
     "副驛長"
     "賦役場")
    ("부연"
     "敷衍")
    ("부연구"
     "副硏究")
    ("부영양화"
     "富營養化")
    ("부왕"
     "父王")
    ("부용"
     "芙蓉")
    ("부운경룡"
     "浮雲驚龍")
    ("부운유설"
     "浮言流說")
    ("부운조로"
     "浮雲朝露")
    ("부원"
     "部員")
    ("부원수"
     "副元帥")
    ("부원장"
     "副院長")
    ("부위"
     "部位")
    ("부위부강"
     "夫爲婦綱")
    ("부위원장"
     "副委員長")
    ("부위자강"
     "父爲子綱")
    ("부유"
     "富有"
     "富裕"
     "浮遊")
    ("부유층"
     "富裕層")
    ("부윤"
     "府尹")
    ("부음"
     "訃音")
    ("부응"
     "副應")
    ("부의"
     "賻儀")
    ("부의금"
     "賻儀金")
    ("부의장"
     "副議長")
    ("부익부"
     "富益富")
    ("부인"
     "否認"
     "夫人"
     "婦人")
    ("부인과"
     "婦人科")
    ("부인복"
     "婦人服")
    ("부임"
     "赴任")
    ("부임지"
     "赴任地")
    ("부자"
     "富者"
     "父子"
     "附子")
    ("부자간"
     "父子間")
    ("부자연"
     "不自然")
    ("부자유"
     "不自由")
    ("부자유자"
     "不自由者")
    ("부자유친"
     "父子有親")
    ("부자지간"
     "父子之間")
    ("부작용"
     "副作用")
    ("부작위"
     "不作爲")
    ("부잣"
     "富者")
    ("부장"
     "副長"
     "部長")
    ("부장지약"
     "腐腸之藥")
    ("부재"
     "不在"
     "不才")
    ("부재료"
     "副材料")
    ("부재자"
     "不在者")
    ("부재중"
     "不在中")
    ("부재지족"
     "富在知足")
    ("부저추신"
     "釜底抽薪")
    ("부적"
     "符籍")
    ("부적격"
     "不適格")
    ("부적격자"
     "不適格者")
    ("부적당"
     "不適當")
    ("부적응"
     "不適應")
    ("부적응증"
     "不適應症")
    ("부적절"
     "不適切")
    ("부적정"
     "不適正")
    ("부적합"
     "不適合")
    ("부적합성"
     "不適合性")
    ("부전공"
     "不專攻")
    ("부전자전"
     "父傳子傳")
    ("부전증"
     "不全症")
    ("부정"
     "不定"
     "不正"
     "不淨"
     "不貞"
     "否定"
     "父情")
    ("부정기적"
     "不定期的")
    ("부정론"
     "否定論")
    ("부정문"
     "否定文")
    ("부정부패"
     "不淨腐敗")
    ("부정사"
     "不定詞")
    ("부정적"
     "否定的")
    ("부정직"
     "不正直")
    ("부정행위"
     "不正行爲")
    ("부정확"
     "不正確")
    ("부제"
     "副祭"
     "副題")
    ("부조"
     "扶助"
     "浮彫")
    ("부조리"
     "不條理")
    ("부조리극풍"
     "不條理劇風")
    ("부조실"
     "副操室")
    ("부조화"
     "不調和")
    ("부족"
     "不足"
     "部族")
    ("부족분"
     "不足分")
    ("부족신적"
     "部族神的")
    ("부족액"
     "不足額")
    ("부족장"
     "部族長")
    ("부족적"
     "部族的")
    ("부족제"
     "部族制")
    ("부존"
     "賦存")
    ("부존자원"
     "賦存資源")
    ("부종"
     "浮腫")
    ("부주석"
     "副主席")
    ("부주의"
     "不注意")
    ("부중"
     "府中")
    ("부중생어"
     "釜中生魚")
    ("부중지어"
     "釜中之魚")
    ("부지"
     "不知"
     "扶持"
     "敷地")
    ("부지감고"
     "不知甘苦")
    ("부지기수"
     "不知其數")
    ("부지부장"
     "副支部長")
    ("부지불식간"
     "不知不識間")
    ("부지육미"
     "不知肉味")
    ("부지중"
     "不知中")
    ("부지하세월"
     "不知何歲月")
    ("부지향취"
     "不知香臭")
    ("부직포"
     "不織布")
    ("부진"
     "不振"
     "不進")
    ("부차관보"
     "副次官補")
    ("부차장"
     "副次長")
    ("부차적"
     "副次的")
    ("부착"
     "附着")
    ("부창부수"
     "夫唱婦隨")
    ("부채"
     "負債")
    ("부처"
     "夫妻"
     "部處")
    ("부처장"
     "副處長")
    ("부청장"
     "副廳長")
    ("부총리"
     "副總理")
    ("부총장"
     "副總長")
    ("부총재"
     "副總裁")
    ("부칙"
     "附則")
    ("부친"
     "父親")
    ("부친상"
     "父親喪")
    ("부탁"
     "付託")
    ("부통령"
     "副統領")
    ("부통령제"
     "副統領制")
    ("부패"
     "腐敗")
    ("부패당"
     "腐敗當")
    ("부패상"
     "腐敗相")
    ("부표"
     "浮標"
     "浮漂")
    ("부품"
     "部品")
    ("부품도"
     "部品圖")
    ("부품화"
     "部品化")
    ("부하"
     "負荷"
     "部下")
    ("부합"
     "符合")
    ("부항"
     "附缸")
    ("부허지설"
     "浮虛之說")
    ("부호"
     "符號"
     "負號")
    ("부호화"
     "符號化")
    ("부화"
     "孵化")
    ("부화기"
     "孵化器")
    ("부화뇌동"
     "附和雷同")
    ("부화율"
     "孵化率")
    ("부화장"
     "孵化場")
    ("부활"
     "復活")
    ("부활전"
     "復活戰")
    ("부활절"
     "復活節")
    ("부활제"
     "復活祭")
    ("부황"
     "浮黃")
    ("부회장"
     "副會長")
    ("부회장직"
     "副會長職")
    ("부흥"
     "復興")
    ("부흥군"
     "復興軍")
    ("부흥기"
     "復興期")
    ("북"
     ("北" . "북녘 북"))
    ("북괴"
     "北傀")
    ("북구"
     "北歐")
    ("북국"
     "北國")
    ("북군"
     "北軍")
    ("북극권"
     "北極圈")
    ("북단"
     "北端")
    ("북동"
     "北東")
    ("북동부"
     "北東部")
    ("북두칠성"
     "北斗七星")
    ("북록"
     "北麓")
    ("북문"
     "北門")
    ("북반구"
     "北半球")
    ("북반부"
     "北半部")
    ("북방"
     "北方")
    ("북방계"
     "北方系")
    ("북벌"
     "北伐")
    ("북벌론"
     "北伐論")
    ("북벌론자"
     "北伐論者")
    ("북부"
     "北部")
    ("북북동"
     "北北東")
    ("북산"
     "北山")
    ("북상"
     "北上")
    ("북서"
     "北西")
    ("북서류"
     "北西流")
    ("북서풍"
     "北西風")
    ("북송"
     "北送")
    ("북안"
     "北岸")
    ("북어"
     "北魚")
    ("북어포"
     "北魚脯")
    ("북엇"
     "北魚")
    ("북위"
     "北緯")
    ("북조"
     "北朝")
    ("북진"
     "北進")
    ("북창삼우"
     "北窓三友")
    ("북측"
     "北側")
    ("북침설"
     "北侵說")
    ("북포"
     "北布")
    ("북풍"
     "北風")
    ("북풍한설"
     "北風寒雪")
    ("북한"
     "北韓")
    ("북한강변"
     "北漢江邊")
    ("북한어"
     "北韓語")
    ("북행지초"
     "北行至楚")
    ("북향"
     "北向")
    ("북현무"
     "北玄武")
    ("분"
     ("分" . "나눌 분")
     ("吩" . "뿜을 분")
     ("噴" . "뿜을 분")
     ("墳" . "무덤 분")
     ("奔" . "달릴 분")
     ("奮" . "떨칠 분")
     ("忿" . "성낼 분")
     ("憤" . "결낼 분")
     ("扮" . "꾸밀 분")
     "昐"
     ("汾" . "클 분")
     ("焚" . "불사를 분")
     ("盆" . "동이 분")
     ("粉" . "가루 분")
     ("糞" . "똥 분")
     ("紛" . "어지러워질 분")
     ("芬" . "향기로울 분")
     ("賁" . "클 분")
     ("雰" . "안개 분")
     ("頒" . "큰 머리 분")
     ("体" . "용렬할 분")
     ("坌" . "먼지 분")
     ("帉" . "걸레 분, 행주 분")
     ("朌" . "頒과 同字")
     ("枌" . "나무 이름 분")
     "棻"
     ("棼" . "마룻대 분")
     ("氛" . "기운 분")
     ("湓" . "용솟음할 분")
     ("濆" . "뿜을 분")
     ("犇" . "달아날 분")
     ("畚" . "삼태기 분")
     ("砏" . "큰 소리 분")
     ("笨" . "거칠 분")
     ("肦" . "머리 클 분")
     ("膹" . "고기 삶은 국 분")
     ("蕡" . "들깨 분")
     ("轒" . "병거 분")
     ("黺" . "옷에 오색 수 놓을 분")
     ("鼢" . "두더지 분"))
    ("분가"
     "分家")
    ("분간"
     "分揀")
    ("분감공고"
     "分甘共苦")
    ("분개"
     "憤慨")
    ("분계선"
     "分界線")
    ("분골쇄신"
     "粉骨碎身")
    ("분과"
     "分科"
     "分課")
    ("분과위"
     "分課委")
    ("분광"
     "分光")
    ("분광기"
     "分光器")
    ("분광학적"
     "分光學的")
    ("분교"
     "分校")
    ("분국장"
     "分局長")
    ("분권화"
     "分權化")
    ("분규"
     "紛糾")
    ("분급"
     "分給")
    ("분급제"
     "分給制")
    ("분기"
     "分期"
     "憤氣")
    ("분기점"
     "分岐點")
    ("분기충천"
     "憤氣衝天")
    ("분기탱천"
     "憤氣撑天")
    ("분노"
     "憤怒")
    ("분노감"
     "憤怒感")
    ("분뇨"
     "糞尿")
    ("분단"
     "分團"
     "分斷")
    ("분단당"
     "分斷當")
    ("분단장"
     "分團長")
    ("분담"
     "分擔")
    ("분담금"
     "分擔金")
    ("분담론"
     "分擔論")
    ("분담률"
     "分擔率")
    ("분당"
     "分黨")
    ("분대"
     "分隊")
    ("분대원"
     "分隊員")
    ("분대장"
     "分隊長")
    ("분도"
     "分度")
    ("분란"
     "紛亂")
    ("분량"
     "分量")
    ("분루"
     "糞瘻")
    ("분류"
     "分類"
     "奔流")
    ("분류사"
     "分類史")
    ("분류표"
     "分類表")
    ("분리"
     "分離")
    ("분리론"
     "分離論")
    ("분리수거"
     "分離收去")
    ("분리적"
     "分離的")
    ("분리주의"
     "分離主義")
    ("분립"
     "分立")
    ("분립적"
     "分立的")
    ("분마기"
     "粉磨機")
    ("분만"
     "分娩")
    ("분만법"
     "分娩法")
    ("분만실"
     "分娩室")
    ("분말"
     "噴沫"
     "粉末")
    ("분말기"
     "粉末機")
    ("분명"
     "分明")
    ("분묘"
     "墳墓")
    ("분무"
     "噴霧")
    ("분무기"
     "噴霧器")
    ("분발"
     "奮發")
    ("분방"
     "奔放")
    ("분배"
     "分配")
    ("분배망"
     "分配網")
    ("분배율"
     "分配律")
    ("분백대록"
     "粉白黛綠")
    ("분별"
     "分別")
    ("분별력"
     "分別力")
    ("분별지"
     "分別智")
    ("분봉"
     "分封")
    ("분부"
     "分付")
    ("분분"
     "紛紛")
    ("분비"
     "分泌")
    ("분비물"
     "分泌物")
    ("분사"
     "噴射")
    ("분사제"
     "噴射劑")
    ("분산"
     "分散")
    ("분산성"
     "分散性")
    ("분산적"
     "分散的")
    ("분산지"
     "分散地")
    ("분산화"
     "分散化")
    ("분서갱유"
     "焚書坑儒")
    ("분석"
     "分析")
    ("분석가"
     "分析家")
    ("분석기"
     "分析器")
    ("분석력"
     "分析力")
    ("분석률"
     "分析率")
    ("분석원"
     "分析員")
    ("분석적"
     "分析的")
    ("분석표"
     "分析表")
    ("분석학"
     "分析學")
    ("분석학자"
     "分析學者")
    ("분석학적"
     "分析學的")
    ("분쇄"
     "粉碎")
    ("분쇄기"
     "粉碎機")
    ("분수"
     "分數"
     "噴水")
    ("분수계"
     "分水界")
    ("분수대"
     "噴水臺")
    ("분수령"
     "分水嶺")
    ("분식"
     "分食"
     "粉食"
     "粉飾")
    ("분식점"
     "粉食店")
    ("분신"
     "分身"
     "焚身")
    ("분신자살"
     "焚身自殺")
    ("분실"
     "分室"
     "紛失")
    ("분실물"
     "紛失物")
    ("분야"
     "分野")
    ("분양"
     "分讓")
    ("분양가"
     "分讓價")
    ("분업"
     "分業")
    ("분업화"
     "分業化")
    ("분연"
     "奮然")
    ("분열"
     "分裂")
    ("분열론"
     "分裂論")
    ("분열증"
     "分裂症")
    ("분위기"
     "雰圍氣")
    ("분유"
     "粉乳")
    ("분임"
     "分任")
    ("분자"
     "分子")
    ("분자시계"
     "分子時計")
    ("분장"
     "分掌"
     "扮裝")
    ("분장사"
     "扮裝師")
    ("분장실"
     "扮裝室")
    ("분재"
     "盆栽")
    ("분재원"
     "盆栽院")
    ("분쟁"
     "分爭"
     "紛爭")
    ("분전"
     "奮戰")
    ("분전역투"
     "奮戰力鬪")
    ("분정"
     "分定")
    ("분조장"
     "分組長")
    ("분주"
     "奔走")
    ("분지"
     "盆地")
    ("분지화"
     "分枝化")
    ("분진"
     "粉塵")
    ("분청사기"
     "粉靑沙器")
    ("분출"
     "噴出")
    ("분출물"
     "噴出物")
    ("분출적"
     "噴出的")
    ("분칠"
     "粉漆")
    ("분침"
     "分針")
    ("분탕"
     "焚蕩")
    ("분통"
     "憤痛")
    ("분투"
     "奮鬪")
    ("분파"
     "分派")
    ("분파주의자"
     "分派主義者")
    ("분패"
     "憤敗")
    ("분포"
     "分布")
    ("분포권"
     "分布圈")
    ("분포도"
     "分布圖")
    ("분포암"
     "分布巖")
    ("분필"
     "粉筆")
    ("분할"
     "分割"
     "分轄")
    ("분할미"
     "分割美")
    ("분할선"
     "分割線")
    ("분합"
     "分合")
    ("분합수"
     "分合水")
    ("분해"
     "分解")
    ("분해자"
     "分解者")
    ("분향"
     "焚香")
    ("분형연기"
     "分形連氣")
    ("분홍"
     "粉紅")
    ("분홍색"
     "粉紅色")
    ("분화"
     "分化")
    ("분화구"
     "噴火口")
    ("분화적"
     "分化的")
    ("불"
     ("佛" . "부처 불")
     ("弗" . "아닐 불")
     ("彿" . "비슷할 불")
     ("拂" . "떨 불")
     ("不" . "아닐 불")
     ("岪" . "산길 불")
     ("祓" . "푸닥거리할 불")
     ("紱" . "인끈 불")
     ("艴" . "발끈할 불")
     "芾"
     ("茀" . "풀 우거질 불")
     ("韍" . "폐슬 불")
     ("髴" . "비슷할 불")
     ("黻" . "수 불"))
    ("불가"
     "佛家"
     "不可")
    ("불가결"
     "不可缺")
    ("불가능"
     "不可能")
    ("불가분"
     "不可分")
    ("불가불"
     "不可不")
    ("불가사의"
     "不可思議")
    ("불가사의론"
     "不可思議論")
    ("불가입성"
     "不可入性")
    ("불가지론"
     "不可知論")
    ("불가침"
     "不可侵")
    ("불가침성"
     "不可侵性")
    ("불가피"
     "不可避")
    ("불가피성"
     "不可避性")
    ("불가항력"
     "不可抗力")
    ("불가항력적"
     "不可抗力的")
    ("불가해"
     "不可解")
    ("불간섭"
     "不干涉")
    ("불감생심"
     "不敢生心")
    ("불감증"
     "不感症")
    ("불감청"
     "不敢請")
    ("불개입"
     "不介入")
    ("불건강"
     "不健康")
    ("불건전"
     "不健全")
    ("불결"
     "不潔")
    ("불결감"
     "不潔感")
    ("불경"
     "佛經"
     "不敬")
    ("불경기"
     "不景氣")
    ("불경죄"
     "不敬罪")
    ("불계"
     "不計")
    ("불계지주"
     "不繫之舟")
    ("불계패"
     "不計敗")
    ("불고염치"
     "不顧廉恥")
    ("불고지죄"
     "不告知罪")
    ("불공정"
     "不公正")
    ("불공정성"
     "不公正性")
    ("불공평"
     "不公平")
    ("불과"
     "不過")
    ("불괴옥루"
     "不愧屋漏")
    ("불교"
     "佛敎")
    ("불교계"
     "佛敎界")
    ("불교관"
     "佛敎觀")
    ("불교도"
     "佛敎徒")
    ("불교사"
     "佛敎史")
    ("불교식"
     "佛敎式")
    ("불교적"
     "佛敎的")
    ("불구"
     "不具"
     "不拘")
    ("불구대천"
     "不俱戴天")
    ("불구속"
     "不拘束")
    ("불구자"
     "不具者")
    ("불구화"
     "不具化")
    ("불국"
     "佛國")
    ("불굴"
     "不屈")
    ("불귀"
     "不歸")
    ("불규칙"
     "不規則")
    ("불규칙성"
     "不規則性")
    ("불규칙적"
     "不規則的")
    ("불균등"
     "不均等")
    ("불균등성"
     "不均等性")
    ("불균일성"
     "不均一性")
    ("불균형"
     "不均衡")
    ("불균형적"
     "不均衡的")
    ("불급마복"
     "不及馬腹")
    ("불기소"
     "不起訴")
    ("불기이자"
     "不欺二字")
    ("불길"
     "不吉")
    ("불길지조"
     "不吉之兆")
    ("불내증"
     "不內症")
    ("불능"
     "不能")
    ("불도"
     "佛道")
    ("불두착분"
     "佛頭著糞")
    ("불량"
     "不良")
    ("불량률"
     "不良率")
    ("불량배"
     "不良輩")
    ("불량품"
     "不良品")
    ("불로"
     "不勞")
    ("불로소득"
     "不勞所得")
    ("불로장생"
     "不老長生"
     "不老長生")
    ("불륜"
     "不倫")
    ("불리"
     "不利")
    ("불립"
     "不立")
    ("불립문자"
     "不立文字")
    ("불만"
     "不滿")
    ("불만기"
     "不滿氣")
    ("불만족"
     "不滿足")
    ("불매"
     "不買")
    ("불면"
     "不眠")
    ("불면증"
     "不眠症")
    ("불멸"
     "不滅")
    ("불명"
     "不明")
    ("불명예"
     "不名譽")
    ("불명예제대"
     "不名譽除隊")
    ("불명확"
     "不明確")
    ("불모"
     "不毛")
    ("불모성"
     "不毛性")
    ("불모지"
     "不毛地")
    ("불모지지"
     "不毛之地")
    ("불문"
     "不問")
    ("불문가지"
     "不問可知")
    ("불문곡직"
     "不問曲直")
    ("불문과"
     "佛文科")
    ("불문율"
     "不文律"
     "不文律")
    ("불문지문"
     "不聞之聞")
    ("불문학"
     "佛文學")
    ("불미"
     "不美")
    ("불미지설"
     "不美之說")
    ("불발"
     "不發")
    ("불발탄"
     "不發彈")
    ("불벌기장"
     "不伐己長")
    ("불벌죄"
     "不罰罪")
    ("불법"
     "佛法"
     "不法")
    ("불법성"
     "不法性")
    ("불법적"
     "不法的")
    ("불법화"
     "不法化")
    ("불변"
     "不變")
    ("불변성"
     "不變性")
    ("불변숙맥"
     "不辨菽麥")
    ("불변적"
     "不變的")
    ("불보"
     "佛寶")
    ("불복"
     "不服")
    ("불분동서"
     "不分東西")
    ("불분명"
     "不分明")
    ("불분불계"
     "不憤不啓")
    ("불비"
     "不備")
    ("불비불명"
     "不飛不鳴")
    ("불비지혜"
     "不費之惠")
    ("불사"
     "不辭")
    ("불사이군"
     "不事二君")
    ("불상"
     "佛像")
    ("불상사"
     "不祥事")
    ("불상용"
     "不相容")
    ("불생불멸"
     "不生不滅")
    ("불성"
     "佛性")
    ("불성실"
     "不誠實")
    ("불세지재"
     "不世之材")
    ("불소"
     "弗素")
    ("불손"
     "不遜")
    ("불순"
     "不純"
     "不順")
    ("불순물"
     "不純物")
    ("불순분자"
     "不純分子")
    ("불시"
     "不時")
    ("불시착"
     "不時着")
    ("불식"
     "不息")
    ("불신"
     "不信")
    ("불신감"
     "不信感")
    ("불신론"
     "不信論")
    ("불신자"
     "不信者")
    ("불심"
     "不審")
    ("불안"
     "佛眼"
     "不安")
    ("불안감"
     "不安感")
    ("불안정"
     "不安定")
    ("불안증"
     "不安症")
    ("불야성"
     "不夜城")
    ("불어"
     "佛語")
    ("불어과"
     "佛語科")
    ("불언"
     "不言")
    ("불언지화"
     "不言之化"
     "不言之花")
    ("불여귀"
     "不如歸")
    ("불여일견"
     "不如一見")
    ("불역지전"
     "不易之典")
    ("불연기연"
     "不然其然")
    ("불연성"
     "不燃性")
    ("불연속"
     "不連續")
    ("불연속적"
     "不連續的")
    ("불온"
     "不穩")
    ("불온시"
     "不穩視")
    ("불완전"
     "不完全")
    ("불요구"
     "不要求")
    ("불요불굴"
     "不撓不屈")
    ("불요불급"
     "不要不急")
    ("불우"
     "不遇")
    ("불우자"
     "不遇者")
    ("불우지변"
     "不虞之變")
    ("불운"
     "不運")
    ("불원천리"
     "不遠千里")
    ("불유쾌"
     "不愉快")
    ("불응"
     "不應")
    ("불의"
     "不意"
     "不義")
    ("불이익"
     "不利益")
    ("불이행"
     "不履行")
    ("불인"
     "不人")
    ("불인도"
     "不引渡")
    ("불인정"
     "不認定")
    ("불인지심"
     "不忍之心")
    ("불일치"
     "不一致")
    ("불임"
     "不妊")
    ("불임증"
     "不妊症")
    ("불입"
     "拂入")
    ("불입액"
     "拂入額")
    ("불전"
     "佛典"
     "佛殿")
    ("불조심"
     "­操心")
    ("불지"
     "佛地")
    ("불참"
     "不參")
    ("불참여"
     "不參與")
    ("불참자"
     "不參者")
    ("불처벌"
     "不處罰")
    ("불철저"
     "不徹底")
    ("불철주야"
     "不撤晝夜")
    ("불청객"
     "不請客")
    ("불체포"
     "不逮捕")
    ("불초자제"
     "不肖子弟")
    ("불출"
     "不出")
    ("불충"
     "不忠")
    ("불충분"
     "不充分")
    ("불측"
     "不測")
    ("불치"
     "不治")
    ("불치병"
     "不治病")
    ("불치하문"
     "不恥下問")
    ("불친절"
     "不親切")
    ("불침번"
     "不寢番")
    ("불쾌"
     "不快")
    ("불쾌감"
     "不快感")
    ("불쾌지수"
     "不快指數")
    ("불탑"
     "佛塔")
    ("불통"
     "不通")
    ("불퇴전"
     "不退轉")
    ("불투명"
     "不透明")
    ("불특정"
     "不特定")
    ("불특정인"
     "不特定人")
    ("불패"
     "不敗")
    ("불편"
     "不便")
    ("불편부당"
     "不偏不黨"
     "不偏不黨")
    ("불평"
     "不平"
     "不評")
    ("불평등"
     "不平等")
    ("불평불만"
     "不平不滿")
    ("불폐풍우"
     "不蔽風雨")
    ("불필다언"
     "不必多言")
    ("불필요"
     "不必要")
    ("불필요론"
     "不必要論")
    ("불하"
     "拂下"
     "不下")
    ("불학"
     "不學")
    ("불한당"
     "不汗黨")
    ("불합격"
     "不合格")
    ("불합리"
     "不合理")
    ("불합리성"
     "不合理性")
    ("불행"
     "不幸")
    ("불행사"
     "不行事")
    ("불허"
     "不許")
    ("불협화"
     "不協化"
     "不協和")
    ("불협화음"
     "不協和音")
    ("불혹"
     "不惑")
    ("불혹지년"
     "不惑之年")
    ("불화"
     "弗化"
     "不和")
    ("불화설"
     "不和說")
    ("불화성"
     "不和性")
    ("불확실"
     "不確實")
    ("불확실성"
     "不確實性")
    ("불확정성"
     "不確定性")
    ("불황"
     "不況")
    ("불황기"
     "不況期")
    ("불효"
     "不孝")
    ("불효막심"
     "不孝莫甚")
    ("불효자"
     "不孝子")
    ("불후"
     "不朽")
    ("불후지공"
     "不朽之功")
    ("붕"
     ("崩" . "무너질 붕")
     ("朋" . "벗 붕")
     ("棚" . "시렁 붕")
     ("硼" . "붕산 붕")
     ("繃" . "묶을 붕")
     ("鵬" . "대붕새 붕")
     "堋"
     "漰"
     "鬅")
    ("붕괴"
     "崩壞")
    ("붕괴설"
     "崩壞說")
    ("붕대"
     "繃帶")
    ("붕대법"
     "繃帶法")
    ("붕락"
     "崩落")
    ("붕우유신"
     "朋友有信")
    ("붕우책선"
     "朋友責善")
    ("붕정만리"
     "鵬程萬里")
    ("비"
     ("丕" . "클 비")
     ("備" . "깆출 비")
     ("匕" . "비수 비")
     ("匪" . "대상자 비")
     ("卑" . "낮을 비")
     ("妃" . "왕비 비")
     ("婢" . "여자종 비")
     ("庇" . "덮을 비")
     ("悲" . "슬플 비")
     ("憊" . "고달플 비")
     ("扉" . "문짝 비")
     ("批" . "칠 비")
     ("斐" . "오락가락할 비")
     ("枇" . "비파나무 비")
     ("榧" . "비자나무 비")
     ("比" . "견줄 비")
     ("毖" . "삼갈 비")
     ("毗" . "도울 비")
     ("毘" . "毗와 同字")
     ("沸" . "끓을 비")
     ("琵" . "비파 비")
     ("痺" . "암메추라기 비")
     "睦"
     ("砒" . "비상 비")
     ("碑" . "돌기둥 비")
     ("秕" . "쭉정이 비")
     ("秘" . "숨길 비")
     ("粃" . "쭉정이 비")
     ("緋" . "붉은 빛 비")
     ("翡" . "물총새 비")
     ("肥" . "살찔 비")
     ("脾" . "지라 비")
     ("臂" . "팔 비")
     ("菲" . "엷을 비")
     ("蜚" . "바퀴 비")
     ("裨" . "도울 비")
     ("誹" . "헐뜯을 비")
     ("譬" . "비유할 비")
     ("費" . "쓸 비")
     "賁"
     ("鄙" . "다라울 비")
     ("非" . "아닐 비")
     ("飛" . "날 비")
     ("鼻" . "코 비")
     ("泌" . "샘물 흐르는 모양 비")
     ("仳" . "떠날 비")
     ("俾" . "더할 비")
     ("剕" . "발 벨 비")
     ("圮" . "무너질 비")
     ("埤" . "더할 비")
     ("妣" . "죽은 어미 비")
     ("屁" . "방귀 비")
     ("悱" . "표현 못할 비")
     ("棐" . "도지개 비")
     ("椑" . "술통 비")
     ("沘" . "강 이름 비")
     ("淝" . "강 이름 비")
     ("淠" . "강 이름 비")
     ("濞" . "물 소리 비")
     ("狉" . "삵의 새끼 비")
     ("狒" . "비비 비")
     ("痞" . "뱃속 결릴 비")
     ("痹" . "저릴 비")
     ("睥" . "흘겨볼 비")
     ("祕" . "귀신 비")
     ("篦" . "빗치개 비")
     ("紕" . "가선 비")
     ("羆" . "큰 곰 비")
     ("腓" . "장딴지 비")
     ("芘" . "풀 이름 비")
     ("芾" . "작은 모양 비")
     ("萆" . "비해 비")
     ("蓖" . "아주까리 비")
     ("蚍" . "왕개미 비")
     ("貔" . "비휴 비")
     ("贔" . "힘쓸 비")
     ("轡" . "고삐 비")
     ("邳" . "클 비")
     ("郫" . "고을 이름 비")
     ("閟" . "문 닫을 비")
     ("陴" . "성가퀴 비")
     ("霏" . "눈 펄펄 내릴 비")
     ("鞴" . "풀무 비")
     ("騑" . "곁마 비")
     ("騛" . "빠른 말 비")
     ("髀" . "넓적다리 비")
     "鵯"
     ("鼙" . "마상북 비"))
    ("비가시적"
     "非可視的")
    ("비가열"
     "非加熱")
    ("비가입국"
     "非加入國")
    ("비각"
     "碑刻")
    ("비감"
     "悲感")
    ("비감정화"
     "非感情化")
    ("비겁"
     "卑怯")
    ("비견"
     "比肩")
    ("비견수종"
     "比肩隨踵")
    ("비결"
     "秘訣")
    ("비결정론적"
     "非決定論的")
    ("비경쟁"
     "非競爭")
    ("비경제"
     "非經濟")
    ("비계열"
     "非系列")
    ("비고전성"
     "非古典性")
    ("비고전적"
     "非古典的")
    ("비고전주의적"
     "非古典主義的")
    ("비공개"
     "非公開")
    ("비공개성"
     "非公開性")
    ("비공격적"
     "非攻擊的")
    ("비공산당"
     "非共産黨")
    ("비공식"
     "非公式")
    ("비공식적"
     "非公式的")
    ("비공식화"
     "非公式化")
    ("비공인"
     "非公認")
    ("비과세"
     "非課稅")
    ("비과학"
     "非科學")
    ("비과학적"
     "非科學的")
    ("비관"
     "悲觀")
    ("비관론"
     "悲觀論")
    ("비관적"
     "悲觀的")
    ("비교"
     "比較")
    ("비교당"
     "比較當")
    ("비교사"
     "比較史")
    ("비교육적"
     "非敎育的")
    ("비교적"
     "比較的"
     "秘敎的")
    ("비교표"
     "比較表")
    ("비구"
     "比丘")
    ("비구니"
     "比丘尼")
    ("비구상적"
     "非具象的")
    ("비굴"
     "卑屈")
    ("비궁지절"
     "匪躬之節")
    ("비극"
     "悲劇")
    ("비극미"
     "悲劇美")
    ("비극적"
     "悲劇的")
    ("비근"
     "卑近")
    ("비금속"
     "非金屬")
    ("비금주수"
     "飛禽走獸")
    ("비난"
     "非難")
    ("비난적"
     "非難的")
    ("비난조"
     "非難調")
    ("비노예적"
     "非奴隸的")
    ("비논리"
     "非論理")
    ("비농민"
     "非農民")
    ("비농업"
     "非農業")
    ("비뇨기"
     "泌尿器")
    ("비뇨기과"
     "泌尿器科")
    ("비능률"
     "非能率")
    ("비능률성"
     "非能率性")
    ("비단"
     "緋緞"
     "非但")
    ("비당원"
     "非黨員")
    ("비대"
     "肥大")
    ("비대중화"
     "非大衆化")
    ("비대칭"
     "非對稱")
    ("비대화"
     "肥大化")
    ("비도"
     "非道")
    ("비도덕성"
     "非道德性")
    ("비도덕적"
     "非道德的")
    ("비동맹국"
     "非同盟國")
    ("비동시적"
     "非同時的")
    ("비동의"
     "非同意")
    ("비등"
     "沸騰"
     "飛騰")
    ("비련"
     "悲戀")
    ("비례"
     "比例")
    ("비례물동"
     "非禮勿動")
    ("비례적"
     "比例的")
    ("비례지례"
     "非禮之禮")
    ("비로전"
     "毘盧殿")
    ("비료"
     "肥料")
    ("비룡"
     "飛龍")
    ("비룡승운"
     "飛龍乘雲")
    ("비리"
     "非理")
    ("비만"
     "肥滿")
    ("비만도"
     "肥滿度")
    ("비만자"
     "肥滿者")
    ("비만증"
     "肥滿症")
    ("비망록"
     "備忘錄")
    ("비명"
     "悲鳴"
     "碑銘"
     "非命")
    ("비명횡사"
     "非命橫死")
    ("비몽사몽"
     "非夢似夢")
    ("비무장"
     "非武裝")
    ("비문"
     "碑文")
    ("비문명적"
     "非文明的")
    ("비문자적"
     "非文字的")
    ("비문화적"
     "非文化的")
    ("비물질계"
     "非物質界")
    ("비민족적"
     "非民族的")
    ("비민주"
     "非民主")
    ("비민주적"
     "非民主的")
    ("비밀"
     "秘密")
    ("비밀경찰"
     "秘密警察")
    ("비밀리"
     "秘密裏")
    ("비밀문서"
     "秘密文書")
    ("비밀주의"
     "秘密主義")
    ("비방"
     "秘方"
     "誹謗")
    ("비방전"
     "誹謗戰")
    ("비방지목"
     "誹謗之木")
    ("비범"
     "非凡")
    ("비법"
     "秘法")
    ("비보"
     "悲報"
     "裨補")
    ("비본질적"
     "非本質的")
    ("비봉수풍"
     "飛蓬隨風")
    ("비분강개"
     "悲憤慷慨")
    ("비불외곡"
     "臂不外曲")
    ("비빈"
     "妃嬪")
    ("비사실적"
     "非事實的")
    ("비사실주의적"
     "非寫實主義的")
    ("비사용자"
     "非使用者")
    ("비사주석"
     "飛沙走石")
    ("비산"
     "砒酸")
    ("비산비야"
     "非山非野")
    ("비상"
     "砒霜"
     "非常"
     "飛上"
     "飛翔")
    ("비상경계령"
     "非常警戒令")
    ("비상경보"
     "非常警報")
    ("비상계엄"
     "非常戒嚴")
    ("비상계엄령"
     "非常戒嚴令")
    ("비상구"
     "非常口")
    ("비상근무"
     "非常勤務")
    ("비상근무령"
     "非常勤務令")
    ("비상령"
     "非常令")
    ("비상사태"
     "非常事態")
    ("비상시"
     "非常時")
    ("비상시국"
     "非常時局")
    ("비상식적"
     "非常識的")
    ("비상업적"
     "非商業的")
    ("비상용"
     "非常用")
    ("비상임"
     "非常任")
    ("비상장"
     "非上場")
    ("비상조치"
     "非常措置")
    ("비상종"
     "非常鐘")
    ("비상지변"
     "非常之變")
    ("비상책"
     "非常策")
    ("비색"
     "翡色")
    ("비생물"
     "非生物")
    ("비생물적"
     "非生物的")
    ("비생산성"
     "非生産性")
    ("비생산적"
     "非生産的")
    ("비서"
     "秘書")
    ("비서관"
     "秘書官")
    ("비서관실"
     "秘書官室")
    ("비서실"
     "秘書室")
    ("비서실장"
     "秘書室長")
    ("비서장"
     "秘書長")
    ("비서진"
     "秘書陣")
    ("비석"
     "碑石")
    ("비석지심"
     "匪石之心")
    ("비선호도"
     "非選好度")
    ("비성여뢰"
     "沸聲如雷")
    ("비소설"
     "非小說")
    ("비속"
     "卑俗"
     "卑屬")
    ("비속어"
     "卑俗語")
    ("비수"
     "匕首")
    ("비수기"
     "非需期")
    ("비승비속"
     "非僧非俗")
    ("비시적"
     "非詩的")
    ("비식민지화"
     "非植民地化")
    ("비신"
     "碑身")
    ("비실명"
     "非實名")
    ("비실용성"
     "非實用性")
    ("비아부화"
     "飛蛾赴火")
    ("비애"
     "悲哀")
    ("비약"
     "飛躍")
    ("비약상"
     "飛躍狀")
    ("비약적"
     "飛躍的")
    ("비양발호"
     "飛揚跋扈")
    ("비양심적"
     "非良心的")
    ("비언어적"
     "非言語的")
    ("비업무"
     "非業務")
    ("비역사적"
     "非歷史的")
    ("비연고지"
     "非緣故地")
    ("비열"
     "卑劣")
    ("비염"
     "鼻炎")
    ("비엽"
     "鼻葉")
    ("비영리"
     "非營利")
    ("비영리적"
     "非營利的")
    ("비예술"
     "非藝術")
    ("비예술적"
     "非藝術的")
    ("비옥"
     "肥沃")
    ("비옥가봉"
     "比屋可封")
    ("비옥가주"
     "比屋可誅")
    ("비용"
     "費用")
    ("비운"
     "悲運")
    ("비위"
     "備位"
     "脾胃"
     "非違")
    ("비위생적"
     "非衛生的")
    ("비유"
     "比喩")
    ("비유법"
     "比喩法")
    ("비유적"
     "比喩的")
    ("비육대주"
     "肥肉大酒")
    ("비육지탄"
     "脾肉之嘆")
    ("비윤리적"
     "非倫理的")
    ("비율"
     "比率")
    ("비응주구"
     "飛鷹走狗")
    ("비의도적"
     "非意圖的")
    ("비의류"
     "非衣類")
    ("비의지적"
     "非意志的")
    ("비이부주"
     "比而不周")
    ("비이상주의적"
     "非理想主義的")
    ("비이성적"
     "非理性的")
    ("비이중적"
     "非二重的")
    ("비익연리"
     "比翼連理")
    ("비인간성"
     "非人間性")
    ("비인간적"
     "非人間的")
    ("비인간화"
     "非人間化")
    ("비인기"
     "非人氣")
    ("비인도적"
     "非人道的")
    ("비인문학적"
     "非人文學的")
    ("비인성적"
     "非人性的")
    ("비일비재"
     "非一非再")
    ("비일상적"
     "非日常的")
    ("비자금"
     "秘資金")
    ("비자생적"
     "非自生的")
    ("비자연적"
     "非自然的")
    ("비자연주의적"
     "非自然主義的")
    ("비장"
     "悲壯"
     "秘藏"
     "脾臟")
    ("비장미"
     "悲壯美")
    ("비장비"
     "非裝備")
    ("비적대적"
     "非敵對的")
    ("비전"
     "飛錢")
    ("비전문가"
     "非專門家")
    ("비전문성"
     "非專門性")
    ("비전문적"
     "非專門的")
    ("비전불행"
     "非錢不行")
    ("비정"
     "非情")
    ("비정기적"
     "非定期的")
    ("비정부적"
     "非政府的")
    ("비정상"
     "非正常")
    ("비정상성"
     "非正常性")
    ("비정상인"
     "非正常人")
    ("비정상적"
     "非正常的")
    ("비정치성"
     "非政治性")
    ("비정치인"
     "非政治人")
    ("비정치적"
     "非政治的")
    ("비정한"
     "非情漢")
    ("비정형적"
     "非定型的")
    ("비제도권"
     "非制度圈")
    ("비제조"
     "非製造")
    ("비제조업"
     "非製造業")
    ("비조"
     "鼻祖")
    ("비조객"
     "非釣客")
    ("비조진양궁장"
     "蜚鳥盡良弓藏")
    ("비주류"
     "非主流")
    ("비준"
     "批准")
    ("비준서"
     "批准書")
    ("비중"
     "比重")
    ("비지"
     "鼻紙")
    ("비지중물"
     "非池中物")
    ("비진흥"
     "非振興")
    ("비참"
     "悲慘")
    ("비참여"
     "非參與")
    ("비책"
     "秘策")
    ("비천"
     "卑賤"
     "鄙淺")
    ("비천상"
     "飛天像")
    ("비철"
     "非鐵")
    ("비축"
     "備蓄")
    ("비축미"
     "備蓄米")
    ("비취"
     "翡翠")
    ("비치"
     "備置")
    ("비타협적"
     "非妥協的")
    ("비탄"
     "悲嘆"
     "悲歎")
    ("비탄자"
     "悲嘆者")
    ("비통"
     "悲痛")
    ("비통신"
     "非通信")
    ("비통치"
     "非統治")
    ("비파"
     "琵琶")
    ("비파괴성"
     "非破壞性")
    ("비파형"
     "琵琶形")
    ("비판"
     "批判")
    ("비판력"
     "批判力")
    ("비판론"
     "批判論")
    ("비판론자"
     "批判論者")
    ("비판자"
     "批判者")
    ("비판적"
     "批判的")
    ("비평"
     "批評")
    ("비평가"
     "批評家")
    ("비평계"
     "批評界")
    ("비평문"
     "批評文")
    ("비평서"
     "批評書")
    ("비평자"
     "批評者")
    ("비평적"
     "批評的")
    ("비평준화"
     "非平準化")
    ("비평형"
     "批評型")
    ("비포장도로"
     "非鋪裝道路")
    ("비폭력"
     "非暴力")
    ("비품"
     "備品")
    ("비필충천"
     "飛必沖天")
    ("비하"
     "卑下")
    ("비하정치"
     "鼻下政事")
    ("비합리성"
     "非合理性")
    ("비합리적"
     "非合理的")
    ("비합법화"
     "非合法化")
    ("비핵"
     "非核")
    ("비핵화"
     "非核化")
    ("비행"
     "卑行"
     "非行"
     "飛行")
    ("비행기"
     "飛行機")
    ("비행기구"
     "飛行氣球")
    ("비행사"
     "飛行士")
    ("비행선"
     "飛行船")
    ("비행아"
     "非行兒")
    ("비행운"
     "飛行雲")
    ("비행장"
     "飛行場")
    ("비행체"
     "飛行體")
    ("비현실"
     "非現實")
    ("비현실감"
     "非現實感")
    ("비현실성"
     "非現實性")
    ("비현실적"
     "非現實的")
    ("비혈연적"
     "非血緣的")
    ("비협조"
     "非協調")
    ("비호"
     "庇護"
     "飛虎")
    ("비호남"
     "非湖南")
    ("비호자"
     "庇護者")
    ("비화"
     "秘話"
     "飛火")
    ("비회원"
     "非會員")
    ("비효율"
     "非效率")
    ("비효율성"
     "非效率性")
    ("비효율적"
     "非效率的")
    ("비흡연자"
     "非吸煙者")
    ("빈"
     ("嚬" . "찡그릴 빈")
     ("嬪" . "아내 빈")
     ("彬" . "빛날 빈")
     ("斌" . "빛날 빈")
     ("檳" . "빈랑나무 빈")
     ("殯" . "염할 빈")
     ("浜" . "물가 빈")
     ("濱" . "물가 빈")
     ("瀕" . "물가 빈")
     ("牝" . "암컷 빈")
     ("玭" . "구슬 이름 빈")
     ("貧" . "가난할 빈")
     ("賓" . "손 빈")
     "贇"
     ("頻" . "자주 빈")
     ("儐" . "인도할 빈")
     ("擯" . "물리칠 빈")
     ("矉" . "찡그릴 빈")
     ("繽" . "어지러울 빈")
     ("臏" . "종지뼈 빈")
     "苹"
     ("蘋" . "네가래 빈")
     ("豳" . "나라 이름 빈")
     ("邠" . "나라 이름 빈")
     ("鑌" . "강철 빈")
     ("霦" . "옥 광채 빈")
     ("顰" . "찡그릴 빈")
     ("鬂" . "鬢의 俗字")
     ("鬢" . "살쩍 빈"))
    ("빈계신명"
     "牝鷄晨鳴")
    ("빈곤"
     "貧困")
    ("빈곤자"
     "貧困者")
    ("빈곤화"
     "貧困化")
    ("빈공과"
     "賓貢科")
    ("빈국"
     "貧國")
    ("빈궁"
     "嬪宮")
    ("빈농"
     "貧農")
    ("빈농군"
     "貧農軍")
    ("빈도"
     "頻度")
    ("빈민"
     "貧民")
    ("빈민가"
     "貧民街")
    ("빈민굴"
     "貧民窟")
    ("빈민층"
     "貧民層")
    ("빈발"
     "頻發")
    ("빈번"
     "頻繁")
    ("빈부"
     "貧富")
    ("빈부귀천"
     "貧富貴賤")
    ("빈사"
     "瀕死")
    ("빈소"
     "殯所")
    ("빈약"
     "貧弱")
    ("빈이낙도"
     "貧而樂道")
    ("빈익빈"
     "貧益貧")
    ("빈자소인"
     "貧者小人")
    ("빈지여귀"
     "賓至如歸")
    ("빈천"
     "貧賤")
    ("빈천불능이"
     "貧賤不能移")
    ("빈천지교"
     "貧賤之交")
    ("빈축"
     "嚬蹙")
    ("빈한"
     "貧寒")
    ("빈혈"
     "貧血")
    ("빈혈증"
     "貧血症")
    ("빙"
     ("憑" . "기대다 빙")
     ("氷" . "얼음 빙")
     ("聘" . "찾아가다 빙")
     "馮"
     ("騁" . "달리다 빙")
     ("冰" . "氷의 本字")
     ("凭" . "기대다 빙")
     ("凴" . "凭과 同字")
     ("娉" . "장가들다 빙"))
    ("빙공영사"
     "憑公營私")
    ("빙과"
     "氷菓")
    ("빙기림"
     "氷淇淋")
    ("빙기설장"
     "氷肌雪腸")
    ("빙벽"
     "氷壁")
    ("빙산"
     "氷山")
    ("빙상"
     "氷上")
    ("빙소와해"
     "氷消瓦解")
    ("빙수"
     "氷水")
    ("빙수기"
     "氷水機")
    ("빙자"
     "憑藉")
    ("빙점"
     "氷點")
    ("빙청옥결"
     "氷淸玉潔")
    ("빙초산"
     "氷醋酸")
    ("빙탄불상용"
     "氷炭不相容")
    ("빙탄상애"
     "氷炭相愛")
    ("빙판"
     "氷板")
    ("빙하"
     "氷下"
     "氷河")
    ("빙하기"
     "氷河期")
    ("사"
     ("乍" . "잠깐 사")
     ("事" . "일 사")
     ("些" . "적을 사")
     ("仕" . "벼슬할 사")
     ("伺" . "엿볼 사")
     ("似" . "같을 사")
     ("使" . "하여금 사")
     ("俟" . "기다릴 사")
     ("僿" . "잘게 부슬 사")
     ("史" . "역사 사")
     ("司" . "맡을 사")
     ("唆" . "부추길 사")
     ("嗣" . "이을 사")
     ("四" . "넉 사")
     "埈"
     ("士" . "선비 사")
     ("奢" . "사치할 사")
     ("娑" . "춤출 사")
     ("寫" . "베낄 사")
     ("寺" . "절 사")
     ("射" . "궁술 사")
     ("巳" . "여섯째 지지 사")
     ("師" . "스승 사")
     ("徙" . "옮길 사")
     ("思" . "생각할 사")
     ("捨" . "버릴 사")
     ("斜" . "비낄 사")
     ("斯" . "이 사")
     ("柶" . "수저 사")
     ("査" . "사실할 사")
     ("梭" . "북 사")
     ("死" . "죽을 사")
     ("沙" . "모래 사")
     ("泗" . "물 이름 사")
     ("渣" . "찌끼 사")
     ("瀉" . "토할 사")
     ("獅" . "사자 사")
     ("砂" . "모래 사")
     ("社" . "토지의 신 사")
     ("祀" . "제사 사")
     ("祠" . "사당 사")
     ("私" . "사사 사")
     ("篩" . "체 사")
     ("紗" . "깁 사")
     ("絲" . "실 사")
     ("肆" . "방자할 사")
     ("舍" . "집 사")
     ("莎" . "향부자 사")
     ("蓑" . "도롱이 사")
     ("蛇" . "뱀 사")
     ("裟" . "가사 사")
     ("詐" . "속일 사")
     ("詞" . "말씀 사")
     ("謝" . "사례할 사")
     ("賜" . "줄 사")
     ("赦" . "용서할 사")
     ("辭" . "말 사")
     ("邪" . "간사할 사")
     ("食" . "밥 먹일 사")
     ("飼" . "먹일 사")
     ("駟" . "사마 사")
     ("麝" . "사향노루 사")
     ("傞" . "취하여 춤추는 모양 사")
     ("剚" . "찌를 사")
     ("卸" . "풀 사")
     ("咋" . "잠간 사")
     ("姒" . "동서 사")
     "崽"
     "撕"
     ("楂" . "떼 사")
     ("榭" . "정자 사")
     "槎"
     ("汜" . "지류 사")
     ("痧" . "쥐통 사")
     "皶"
     ("竢" . "기다릴 사")
     ("笥" . "상자 사")
     ("糸" . "가는 실 사")
     "缷"
     ("蜡" . "납향 사")
     ("覗" . "엿볼 사")
     "闍"
     ("駛" . "달릴 사")
     "騃"
     ("魦" . "鯊와 同字")
     ("鯊" . "문절망둑 사")
     ("鰤" . "새우 사"))
    ("사가"
     "史家"
     "私家")
    ("사각"
     "四角"
     "死角")
    ("사각지대"
     "死角地帶")
    ("사각형"
     "四角形")
    ("사감"
     "私感"
     "舍監")
    ("사거이도"
     "舍車而徒")
    ("사건"
     "事件"
     "紗巾")
    ("사격"
     "射擊")
    ("사견"
     "私見"
     "紗絹")
    ("사경"
     "死境")
    ("사계"
     "四季")
    ("사계사야"
     "使鷄司夜")
    ("사계절"
     "四季節")
    ("사고"
     "事故"
     "史庫"
     "四苦"
     "思考"
     "思顧")
    ("사고가"
     "思考家")
    ("사고관"
     "思考觀")
    ("사고력"
     "思考力")
    ("사고무친"
     "四顧無親")
    ("사고방식"
     "思考方式")
    ("사고율"
     "事故率")
    ("사곡"
     "紗穀")
    ("사골"
     "四骨")
    ("사공"
     "沙工")
    ("사공중곡"
     "射空中鵠")
    ("사과"
     "沙果"
     "謝過"
     "赦過")
    ("사과문"
     "謝過文")
    ("사과탄"
     "沙果彈")
    ("사관"
     "史官"
     "史觀"
     "士官")
    ("사관생도"
     "士官生徒")
    ("사관학교"
     "士官學校")
    ("사관후보생"
     "士官候補生")
    ("사교"
     "社交"
     "邪敎")
    ("사교계"
     "社交界")
    ("사교성"
     "社交性")
    ("사교술"
     "社交術")
    ("사교육비"
     "私敎育費")
    ("사교적"
     "社交的")
    ("사구"
     "四球"
     "沙丘")
    ("사군이충"
     "事君以忠")
    ("사군자"
     "四君子")
    ("사권화"
     "私權化")
    ("사극"
     "史劇")
    ("사근교원"
     "舍近交遠")
    ("사금"
     "沙金")
    ("사급계생"
     "事急計生")
    ("사기"
     "士氣"
     "沙器"
     "詐欺")
    ("사기극"
     "詐欺劇")
    ("사기단"
     "詐欺團")
    ("사기당"
     "詐欺當")
    ("사기범"
     "詐欺犯")
    ("사기적"
     "詐欺的")
    ("사기충천"
     "士氣衝天")
    ("사기포서"
     "使驥捕鼠")
    ("사내"
     "寺內"
     "社內")
    ("사념"
     "邪念")
    ("사농공상"
     "士農工商")
    ("사단"
     "事端"
     "四端"
     "師團"
     "社團")
    ("사단설"
     "四端設")
    ("사단장"
     "師團長")
    ("사단취장"
     "舍短取長")
    ("사달이이의"
     "辭達而已矣")
    ("사당"
     "祠堂")
    ("사당양자"
     "祠堂養子")
    ("사당적"
     "私黨的")
    ("사대"
     "事大"
     "四大"
     "師大")
    ("사대당"
     "事大黨")
    ("사대문"
     "四大門")
    ("사대부"
     "士大夫")
    ("사대부가"
     "士大夫家")
    ("사대사상"
     "事大思想")
    ("사대생"
     "師大生")
    ("사대성"
     "事大性")
    ("사대육신"
     "四大六身")
    ("사대주의"
     "事大主義")
    ("사대주의자"
     "事大主義者")
    ("사대주의적"
     "事大主義的")
    ("사도"
     "四都")
    ("사돈"
     "査頓")
    ("사돈팔촌"
     "査頓八寸")
    ("사동"
     "舍棟")
    ("사두품"
     "四頭品")
    ("사또"
     "使道")
    ("사라"
     "紗羅")
    ("사라수"
     "沙羅樹")
    ("사랑"
     "舍廊")
    ("사랑방"
     "舍廊房")
    ("사려"
     "思慮")
    ("사력"
     "死力")
    ("사력지"
     "沙礫地")
    ("사령"
     "使令")
    ("사령관"
     "司令官")
    ("사령기"
     "司令旗")
    ("사령대"
     "司令臺")
    ("사령부"
     "司令部")
    ("사령탑"
     "司令塔")
    ("사례"
     "事例"
     "謝禮")
    ("사례비"
     "事例費")
    ("사례품"
     "事例品")
    ("사료"
     "史料"
     "思料"
     "飼料")
    ("사료관"
     "史料館")
    ("사료적"
     "史料的")
    ("사륜"
     "四輪")
    ("사리"
     "事理"
     "舍利")
    ("사리사욕"
     "私利私慾")
    ("사리탑"
     "舍利塔")
    ("사립"
     "私立")
    ("사립대"
     "私立大")
    ("사립대학"
     "私立大學")
    ("사립학교"
     "私立學校")
    ("사막"
     "沙漠")
    ("사막화"
     "沙漠化")
    ("사망"
     "死亡")
    ("사망률"
     "死亡率")
    ("사망자"
     "死亡者")
    ("사면"
     "四面"
     "斜面"
     "絲綿"
     "赦免")
    ("사면령"
     "赦免令")
    ("사면초가"
     "四面楚歌")
    ("사면춘풍"
     "四面春風")
    ("사멸"
     "死滅")
    ("사명"
     "使命")
    ("사명감"
     "使命感")
    ("사모"
     "師母"
     "思慕"
     "紗帽")
    ("사모관대"
     "紗帽冠帶")
    ("사목"
     "司牧")
    ("사목지신"
     "徙木之信")
    ("사무"
     "事務"
     "師巫"
     "私務")
    ("사무과장"
     "事務課長")
    ("사무관"
     "事務官")
    ("사무국"
     "事務局")
    ("사무국장"
     "事務局長")
    ("사무두불행"
     "蛇無頭不行")
    ("사무소"
     "事務所")
    ("사무소장"
     "事務所長")
    ("사무실"
     "事務室")
    ("사무여한"
     "死無餘恨")
    ("사무원"
     "事務員")
    ("사무이성"
     "事無二成")
    ("사무장"
     "事務長")
    ("사무적"
     "事務的")
    ("사무직"
     "事務職")
    ("사무직원"
     "事務職員")
    ("사무처"
     "事務處")
    ("사무처장"
     "事務處長")
    ("사무총장"
     "事務總長")
    ("사무총장직"
     "事務總長職")
    ("사문"
     "査問"
     "沙門")
    ("사문난적"
     "斯文亂賊")
    ("사문부산"
     "使蚊負山")
    ("사문조직"
     "斜紋組織")
    ("사문직"
     "斜紋織")
    ("사문화"
     "死文化")
    ("사물"
     "事物"
     "四物")
    ("사물적"
     "事物的")
    ("사물화"
     "事物化")
    ("사미승"
     "沙彌僧")
    ("사민이시"
     "使民以時")
    ("사민주의자"
     "社民主義者")
    ("사바세계"
     "娑婆世界")
    ("사반공배"
     "事半功倍")
    ("사반세기"
     "四半世紀")
    ("사발"
     "沙鉢")
    ("사발농사"
     "沙鉢農事")
    ("사발시계"
     "沙鉢時計")
    ("사발통문"
     "沙鉢通文")
    ("사방"
     "四方"
     "沙防")
    ("사방팔방"
     "四方八方")
    ("사범"
     "事犯"
     "師範")
    ("사범대"
     "師範大")
    ("사범학교"
     "師範學校")
    ("사법"
     "司法")
    ("사법계"
     "事法界"
     "四法界")
    ("사법권"
     "司法權")
    ("사법부"
     "司法府")
    ("사법적"
     "司法的")
    ("사변"
     "事變"
     "思辨")
    ("사변적"
     "思辨的")
    ("사별"
     "死別")
    ("사병"
     "士兵")
    ("사보"
     "社報")
    ("사복"
     "私服")
    ("사본"
     "寫本")
    ("사본치말"
     "舍本治末")
    ("사부"
     "四部"
     "師傅"
     "師父")
    ("사분기"
     "四分期")
    ("사분오열"
     "四分五裂"
     "四分五裂")
    ("사불급설"
     "駟不及舌")
    ("사불여의"
     "事不如意")
    ("사비"
     "私費")
    ("사사"
     "師事"
     "私私")
    ("사사건건"
     "事事件件")
    ("사사무애법계"
     "事事無碍法界")
    ("사사분기"
     "四四分期")
    ("사사오입"
     "四捨五入"
     "四死五入")
    ("사산"
     "四山"
     "死産")
    ("사산율"
     "死産率")
    ("사살"
     "射殺")
    ("사상"
     "事象"
     "史上"
     "思想"
     "捨象"
     "死傷"
     "死狀"
     "舍上")
    ("사상가"
     "思想家")
    ("사상계"
     "思想界")
    ("사상누각"
     "沙上樓閣"
     "沙上樓閣")
    ("사상사"
     "思想史")
    ("사상사적"
     "思想史的")
    ("사상서"
     "思想書")
    ("사상자"
     "死傷者"
     "蛇床子")
    ("사상적"
     "思想的")
    ("사상제자"
     "泗上弟子")
    ("사상집"
     "思想集")
    ("사색"
     "四色"
     "思索"
     "死色")
    ("사색가"
     "思索家")
    ("사색당쟁"
     "四色黨爭")
    ("사색적"
     "思索的")
    ("사생"
     "舍生")
    ("사생결단"
     "死生決斷")
    ("사생아"
     "私生兒")
    ("사생영욕"
     "死生榮辱")
    ("사생취의"
     "捨生取義")
    ("사생활"
     "私生活")
    ("사서"
     "史書"
     "司書")
    ("사서성호"
     "社鼠城狐")
    ("사서오경"
     "四書五經")
    ("사서함"
     "私書函")
    ("사석"
     "私席")
    ("사석음우"
     "射石飮羽")
    ("사선"
     "斜線"
     "死線"
     "私船")
    ("사선미"
     "斜線美")
    ("사설"
     "社說"
     "私設"
     "私說")
    ("사설란"
     "社說欄")
    ("사설조"
     "辭說調")
    ("사섭법"
     "四攝法")
    ("사성제"
     "四聖諦")
    ("사세"
     "社勢")
    ("사소"
     "些少")
    ("사수"
     "射手"
     "死守")
    ("사수대"
     "死守隊")
    ("사수좌"
     "射手座")
    ("사시"
     "四時"
     "斜視")
    ("사시도"
     "四時圖")
    ("사시사"
     "四時四")
    ("사시장"
     "四時長")
    ("사시장춘"
     "四時長春")
    ("사식기"
     "寫植機")
    ("사신"
     "使臣"
     "辭神")
    ("사신사"
     "四神砂")
    ("사실"
     "事實"
     "史實"
     "寫實")
    ("사실감"
     "事實感")
    ("사실무근"
     "事實無根")
    ("사실상"
     "事實上")
    ("사실성"
     "事實性"
     "寫實性")
    ("사실적"
     "事實的"
     "寫實的")
    ("사실주의"
     "寫實主義")
    ("사실주의자"
     "寫實主義者")
    ("사실주의적"
     "寫實主義的")
    ("사심불구"
     "蛇心佛口")
    ("사심자용"
     "師心自用")
    ("사십"
     "四十")
    ("사십구"
     "四十九")
    ("사십만"
     "四十萬")
    ("사십사"
     "四十四")
    ("사십삼"
     "四十三")
    ("사십오"
     "四十五")
    ("사십오만"
     "四十五萬")
    ("사십이"
     "四十二")
    ("사십이불혹"
     "四十而不惑")
    ("사십초말"
     "四十初襪")
    ("사악"
     "邪惡")
    ("사안"
     "事案")
    ("사암"
     "沙巖")
    ("사약"
     "芍藥")
    ("사양"
     "仕樣"
     "斜陽"
     "辭讓")
    ("사양서"
     "仕樣書")
    ("사양장랑"
     "使羊將狼")
    ("사양지심"
     "辭讓之心")
    ("사양화"
     "斜陽化")
    ("사어"
     "死語")
    ("사어지천"
     "射魚指天")
    ("사업"
     "事業")
    ("사업가"
     "事業家")
    ("사업과장"
     "事業課長")
    ("사업관"
     "事業館")
    ("사업권"
     "事業圈")
    ("사업단"
     "事業團")
    ("사업부"
     "事業部")
    ("사업부장"
     "事業部長")
    ("사업부제"
     "事業部制")
    ("사업비"
     "事業費")
    ("사업소"
     "事業所")
    ("사업자"
     "事業者")
    ("사업작풍"
     "事業作風")
    ("사업장"
     "事業場")
    ("사업주"
     "事業主")
    ("사업체"
     "事業體")
    ("사업화"
     "事業化")
    ("사업회"
     "事業會")
    ("사여"
     "私與")
    ("사역"
     "使役")
    ("사연"
     "事緣"
     "私緣"
     "辭緣")
    ("사열"
     "査閱")
    ("사열식"
     "査閱式")
    ("사오"
     "四五")
    ("사오백"
     "四五百")
    ("사오십"
     "四五十")
    ("사옥"
     "社屋")
    ("사온"
     "四溫")
    ("사왕사래"
     "乍往乍來")
    ("사외"
     "社外")
    ("사외보"
     "社外報")
    ("사용"
     "使用"
     "私用")
    ("사용감"
     "使用感")
    ("사용권"
     "使用權")
    ("사용량"
     "使用量")
    ("사용료"
     "使用料")
    ("사용률"
     "使用率")
    ("사용법"
     "使用法")
    ("사용비"
     "使用費")
    ("사용성"
     "使用性")
    ("사용자"
     "使用者")
    ("사용자층"
     "使用者層")
    ("사용주"
     "使用主")
    ("사용처"
     "使用處")
    ("사원"
     "寺院"
     "沙原"
     "社員"
     "私怨")
    ("사원지"
     "寺院址")
    ("사월"
     "四月")
    ("사위"
     "四圍"
     "詐僞")
    ("사유"
     "事由"
     "思惟"
     "私有")
    ("사유권"
     "私有權")
    ("사유론"
     "私有論")
    ("사유서"
     "事由書")
    ("사유적"
     "私有的")
    ("사유제"
     "私有制")
    ("사유지"
     "私有地")
    ("사육"
     "飼育")
    ("사육신"
     "死六臣")
    ("사은품"
     "謝恩品")
    ("사의"
     "謝意"
     "辭意")
    ("사이비"
     "似而非")
    ("사이후이"
     "死而後已")
    ("사인"
     "使人"
     "死因")
    ("사인여천"
     "事人如天")
    ("사일구"
     "四一九")
    ("사임"
     "辭任")
    ("사자"
     "使者"
     "死者"
     "獅子")
    ("사자심상빈"
     "奢者心常貧")
    ("사자좌"
     "獅子座")
    ("사자차시학"
     "寫字此是學")
    ("사자후"
     "獅子吼")
    ("사잣"
     "使者")
    ("사장"
     "死藏"
     "沙場"
     "社長")
    ("사장단"
     "社長團")
    ("사장직"
     "社長職")
    ("사재"
     "私財")
    ("사저"
     "私邸")
    ("사적"
     "史的"
     "史跡"
     "社的"
     "私的")
    ("사전"
     "事典"
     "事前"
     "死前"
     "私田"
     "私電"
     "辭典")
    ("사전식"
     "辭典式")
    ("사전적"
     "事前的"
     "辭典的")
    ("사절"
     "使節"
     "謝絶"
     "辭絶")
    ("사절기"
     "四節氣")
    ("사절단"
     "使節團")
    ("사절단장"
     "使節團長")
    ("사정"
     "事情"
     "司正"
     "射精"
     "査定"
     "査正")
    ("사정거리"
     "射程距離")
    ("사정거리권"
     "射程距離圈")
    ("사정권"
     "射程圈")
    ("사정사정"
     "事情事情")
    ("사제"
     "司祭"
     "師弟"
     "私製")
    ("사제단"
     "司祭團")
    ("사제동행"
     "師弟同行")
    ("사제복"
     "司祭服")
    ("사제장"
     "司祭長")
    ("사제지간"
     "師弟之間")
    ("사제직"
     "司祭職")
    ("사조"
     "思潮")
    ("사족"
     "四足"
     "蛇足")
    ("사죄"
     "謝罪")
    ("사주"
     "使嗾"
     "四柱"
     "社主")
    ("사주단자"
     "四柱單子")
    ("사주팔자"
     "四柱八字")
    ("사중"
     "四重")
    ("사중구활"
     "死中求活")
    ("사증"
     "査證")
    ("사지"
     "四肢"
     "死地"
     "沙地")
    ("사지오등"
     "死之五等")
    ("사직"
     "司直"
     "社稷"
     "紗織")
    ("사직단"
     "社稷壇")
    ("사직서"
     "辭職書")
    ("사직원"
     "辭職願")
    ("사직위허"
     "社稷爲墟")
    ("사직지신"
     "社稷之臣")
    ("사진"
     "寫眞")
    ("사진관"
     "寫眞館")
    ("사진기"
     "寫眞機")
    ("사진반"
     "寫眞班")
    ("사진반원"
     "寫眞班員")
    ("사진부"
     "寫眞部")
    ("사진작가"
     "寫眞作家")
    ("사진전"
     "寫眞展")
    ("사진집"
     "寫眞集")
    ("사진첩"
     "寫眞帖")
    ("사진학"
     "寫眞學")
    ("사질"
     "沙質")
    ("사차불피"
     "死且不避")
    ("사차불후"
     "死且不朽")
    ("사차원"
     "四次元")
    ("사차원적"
     "四次元的")
    ("사찰"
     "伺察"
     "寺刹"
     "査察")
    ("사찰과장"
     "査察課長")
    ("사찰단"
     "査察團")
    ("사창"
     "史倉")
    ("사창가"
     "私娼街")
    ("사채"
     "社債"
     "私債")
    ("사채업자"
     "私債業者")
    ("사천왕"
     "四天王")
    ("사천이백구십일"
     "四千二百九十一")
    ("사초"
     "莎草")
    ("사초과"
     "莎草科")
    ("사촌"
     "四寸")
    ("사춘기"
     "思春期")
    ("사출"
     "寫出")
    ("사출물"
     "射出物")
    ("사치"
     "奢侈")
    ("사치성"
     "奢侈性")
    ("사치품"
     "奢侈品")
    ("사칙"
     "四則")
    ("사친이효"
     "事親以孝")
    ("사칭"
     "詐稱")
    ("사탑"
     "斜塔")
    ("사탕"
     "沙糖"
     "沙糖")
    ("사태"
     "事態"
     "沙汰")
    ("사택"
     "舍宅")
    ("사통팔달"
     "四通八達")
    ("사퇴"
     "辭退")
    ("사퇴서"
     "辭退書")
    ("사투"
     "思鬪"
     "死鬪")
    ("사패"
     "賜牌")
    ("사포"
     "沙布"
     "紗布")
    ("사폭"
     "邪幅")
    ("사표"
     "辭表")
    ("사풍"
     "沙風")
    ("사필귀정"
     "事必歸正")
    ("사하"
     "舍下")
    ("사학"
     "史學"
     "四學"
     "私學")
    ("사학계"
     "史學界")
    ("사학과"
     "史學科")
    ("사학론"
     "史學論")
    ("사학사적"
     "史學史的")
    ("사학자"
     "史學者")
    ("사항"
     "事項")
    ("사해"
     "四海")
    ("사해동포"
     "四海同胞")
    ("사해위가"
     "四海爲家")
    ("사행삭질"
     "射幸數跌")
    ("사혈가입"
     "使穴可入")
    ("사형"
     "死刑")
    ("사형당"
     "死刑當")
    ("사형수"
     "死刑囚")
    ("사환"
     "使喚")
    ("사활"
     "死活")
    ("사회"
     "司會"
     "社會")
    ("사회과"
     "社會科")
    ("사회관"
     "社會觀")
    ("사회관계"
     "社會關係")
    ("사회극"
     "社會劇")
    ("사회단체"
     "社會團體")
    ("사회론"
     "社會論")
    ("사회론자"
     "社會論者")
    ("사회면"
     "社會面")
    ("사회봉사"
     "社會奉仕")
    ("사회부"
     "社會部")
    ("사회부연"
     "死灰復燃")
    ("사회부장"
     "社會部長")
    ("사회사"
     "社會史")
    ("사회사가"
     "社會史家")
    ("사회사상"
     "社會思想")
    ("사회사업"
     "社會事業")
    ("사회사업과"
     "社會事業課")
    ("사회사업학과"
     "社會事業學科")
    ("사회사적"
     "社會史的")
    ("사회상"
     "社會相")
    ("사회생활"
     "社會生活")
    ("사회설"
     "社會說")
    ("사회성"
     "社會性")
    ("사회악"
     "社會惡")
    ("사회안전원"
     "社會安全員")
    ("사회의식"
     "社會意識")
    ("사회의식적"
     "社會意識的")
    ("사회인"
     "社會人")
    ("사회자"
     "司會者")
    ("사회적"
     "社會的")
    ("사회주의"
     "社會主義")
    ("사회주의권"
     "社會主義圈")
    ("사회주의자"
     "社會主義者")
    ("사회주의적"
     "社會主義的")
    ("사회체"
     "社會體")
    ("사회층"
     "社會層")
    ("사회학"
     "社會學")
    ("사회학과"
     "社會學科")
    ("사회학도"
     "社會學徒")
    ("사회학자"
     "社會學者")
    ("사회학적"
     "社會學的")
    ("사회화"
     "社會化")
    ("사후"
     "事後"
     "死後")
    ("사후약방문"
     "死後藥方文")
    ("삭"
     ("削" . "깎을 삭")
     ("朔" . "초하루 삭")
     ("數" . "자주 삭")
     ("索" . "동아줄 삭")
     ("槊" . "창 삭")
     ("爍" . "빛날 삭")
     "箾"
     ("蒴" . "말오줌대 삭")
     ("鑠" . "녹일 삭"))
    ("삭감"
     "削減")
    ("삭막"
     "索莫")
    ("삭발"
     "削髮")
    ("삭발위승"
     "削髮爲僧")
    ("삭제"
     "削除")
    ("삭주굴근"
     "削株掘根")
    ("삭탈관직"
     "削奪官職")
    ("산"
     ("傘" . "우산 산")
     ("刪" . "깎을 산")
     ("山" . "뫼 산")
     ("散" . "흩을 산")
     ("汕" . "오구 산")
     ("珊" . "산호 산")
     ("産" . "낳을 산")
     ("疝" . "산증 산")
     ("算" . "셀 산")
     ("蒜" . "달래 산")
     ("酸" . "초 산")
     ("霰" . "싸라기눈 산")
     ("剷" . "깎을 산")
     ("姍" . "헐뜯을 산")
     ("孿" . "쌍둥이 산")
     ("橵" . "산자 산")
     ("潸" . "눈물흐를 산")
     ("澘" . "潸의 略字")
     ("狻" . "사자 산")
     ("繖" . "일산 산")
     ("訕" . "헐뜯을 산")
     ("鏟" . "대패 산")
     ("閊" . "비색할 산")
     "餕")
    ("산간"
     "山間"
     "産看")
    ("산간벽지"
     "山間僻地")
    ("산경"
     "山景")
    ("산계야목"
     "山鷄夜鶩")
    ("산고"
     "産苦")
    ("산고수장"
     "山高水長")
    ("산관"
     "散官")
    ("산괴"
     "山塊")
    ("산괴형"
     "山塊形")
    ("산구절초"
     "山九折草")
    ("산국"
     "山菊")
    ("산궁수진"
     "山窮水盡")
    ("산기"
     "産氣")
    ("산남수북"
     "山南水北")
    ("산도"
     "酸度")
    ("산동"
     "山東"
     "山洞")
    ("산란"
     "散亂"
     "産卵")
    ("산란기"
     "産卵期")
    ("산란율"
     "産卵率")
    ("산록"
     "山麓")
    ("산록부"
     "山麓部")
    ("산림"
     "山林")
    ("산림처사"
     "山林處士")
    ("산만"
     "散漫")
    ("산매업"
     "散賣業")
    ("산매점"
     "散賣店")
    ("산맥"
     "山脈")
    ("산맥형"
     "山脈型")
    ("산명수려"
     "山明水麗")
    ("산모"
     "産母")
    ("산문"
     "山門"
     "散文")
    ("산문가"
     "散文家")
    ("산문극"
     "散文劇")
    ("산문부"
     "散文部")
    ("산문시"
     "散文詩")
    ("산문집"
     "散文集")
    ("산물"
     "産物")
    ("산미료"
     "酸味料")
    ("산발"
     "散發"
     "散髮")
    ("산발적"
     "散發的")
    ("산별"
     "産別")
    ("산보"
     "散步")
    ("산복"
     "山腹")
    ("산봉"
     "山峯")
    ("산부인과"
     "産婦人科")
    ("산불염고"
     "山不厭高")
    ("산사"
     "山寺"
     "山査"
     "散士"
     "算士")
    ("산사태"
     "山沙汰")
    ("산산"
     "散散")
    ("산삼"
     "山蔘")
    ("산서"
     "山西")
    ("산서곡음"
     "山棲谷飮")
    ("산성"
     "山城"
     "酸性")
    ("산성도"
     "酸性度")
    ("산성화"
     "酸性化")
    ("산세"
     "山勢")
    ("산소"
     "山所"
     "酸素")
    ("산수"
     "山水"
     "算數")
    ("산수소"
     "酸水素")
    ("산수화"
     "山水畵")
    ("산술"
     "算術")
    ("산술급수적"
     "算術級數的")
    ("산술법"
     "算術法")
    ("산술식"
     "算術式")
    ("산술적"
     "算術的")
    ("산신"
     "山神")
    ("산신령"
     "山神靈")
    ("산실"
     "産室")
    ("산아"
     "産兒")
    ("산악"
     "山岳")
    ("산악회"
     "山岳會")
    ("산악회원"
     "山岳會員")
    ("산야"
     "山野")
    ("산양"
     "山羊")
    ("산양좌"
     "山羊座")
    ("산업"
     "産業")
    ("산업계"
     "産業界")
    ("산업과장"
     "産業課長")
    ("산업국"
     "産業國")
    ("산업군"
     "産業群")
    ("산업로"
     "産業路")
    ("산업론"
     "産業論")
    ("산업별"
     "産業別")
    ("산업용"
     "産業用")
    ("산업적"
     "産業的")
    ("산업주의"
     "産業主義")
    ("산업체"
     "産業體")
    ("산업형"
     "産業型")
    ("산업화"
     "産業化")
    ("산유국"
     "産油國")
    ("산일엽초"
     "山一葉草")
    ("산입"
     "算入")
    ("산자수명"
     "山紫水明")
    ("산장"
     "山莊")
    ("산재"
     "散在"
     "産災")
    ("산저귀저"
     "山底貴杵")
    ("산적"
     "山積"
     "散炙")
    ("산전"
     "山田")
    ("산전수전"
     "山戰水戰")
    ("산점상"
     "散點狀")
    ("산정"
     "山頂"
     "算定")
    ("산조"
     "散調")
    ("산중"
     "山中")
    ("산중백운"
     "山中白雲")
    ("산지"
     "山地"
     "産地")
    ("산채"
     "山寨"
     "山菜")
    ("산책"
     "散策")
    ("산책로"
     "散策路")
    ("산천"
     "山川")
    ("산천초목"
     "山川草木")
    ("산체"
     "山體")
    ("산초"
     "山椒")
    ("산촌"
     "山村")
    ("산출"
     "産出"
     "算出")
    ("산파"
     "産婆")
    ("산파역"
     "産婆役")
    ("산판"
     "山坂")
    ("산하"
     "傘下"
     "山河")
    ("산학"
     "産學")
    ("산해진미"
     "山海珍味")
    ("산행"
     "山行")
    ("산협"
     "山峽")
    ("산형"
     "山形")
    ("산화"
     "酸化")
    ("산화물"
     "酸化物")
    ("산후"
     "産後")
    ("산후병"
     "産後病")
    ("산후열"
     "産後熱")
    ("살"
     ("乷" . "음역자 살")
     ("撒" . "뿌릴 살")
     ("殺" . "죽일 살")
     ("煞" . "죽일 살")
     ("蔡" . "내칠 살")
     ("薩" . "보살 살"))
    ("살균"
     "殺菌")
    ("살기"
     "殺氣")
    ("살농"
     "殺農")
    ("살모사"
     "殺母蛇")
    ("살벌"
     "殺伐")
    ("살상"
     "殺傷")
    ("살신성인"
     "殺身成仁")
    ("살육"
     "殺戮")
    ("살의"
     "殺意")
    ("살인"
     "殺人")
    ("살인마"
     "殺人魔")
    ("살인범"
     "殺人犯")
    ("살인자"
     "殺人者")
    ("살인적"
     "殺人的")
    ("살인죄"
     "殺人罪")
    ("살충제"
     "殺蟲劑")
    ("살포"
     "撒布")
    ("살해"
     "殺害")
    ("살해당"
     "殺害當")
    ("살해범"
     "殺害犯")
    ("삼"
     ("三" . "석 삼")
     ("杉" . "삼나무 삼")
     ("森" . "나무빽빽할 삼")
     "渗"
     ("芟" . "벨 삼")
     ("蔘" . "인삼 삼")
     ("衫" . "적삼 삼")
     ("參" . "석 삼")
     "叅"
     "摻"
     "椙"
     "櫼"
     ("毿" . "털긴 삼")
     ("糝" . "나물죽 삼")
     "纔"
     ("釤" . "낫 삼")
     ("鬖" . "헝클어질 삼"))
    ("삼각"
     "三角")
    ("삼각관계"
     "三角關係")
    ("삼각근"
     "三角筋")
    ("삼각선"
     "三角線")
    ("삼각주"
     "三角洲")
    ("삼각형"
     "三角形")
    ("삼간두옥"
     "三間斗屋")
    ("삼강"
     "三綱")
    ("삼강오륜"
     "三綱五倫")
    ("삼경"
     "三敬")
    ("삼계탕"
     "蔘鷄湯")
    ("삼고초려"
     "三顧草廬")
    ("삼관"
     "三觀")
    ("삼교"
     "三敎")
    ("삼국"
     "三國")
    ("삼국사"
     "三國史")
    ("삼군"
     "三軍")
    ("삼군가탈수"
     "三軍可奪帥")
    ("삼권"
     "三權")
    ("삼남"
     "三南")
    ("삼년"
     "三年")
    ("삼년불비"
     "三年不蜚")
    ("삼년상"
     "三年喪")
    ("삼다도"
     "三多島")
    ("삼대"
     "三代"
     "三大")
    ("삼대기"
     "三代記")
    ("삼동"
     "三冬")
    ("삼두근"
     "三頭筋")
    ("삼두박근"
     "三頭膊筋")
    ("삼등"
     "三等")
    ("삼등분"
     "三等分")
    ("삼라만상"
     "森羅萬象")
    ("삼락"
     "三樂")
    ("삼루"
     "三壘")
    ("삼루수"
     "三壘手")
    ("삼류"
     "三流")
    ("삼륜차"
     "三輪車")
    ("삼림"
     "森林")
    ("삼림토"
     "森林土")
    ("삼만"
     "三萬")
    ("삼만이천"
     "三萬二千")
    ("삼매"
     "三昧")
    ("삼매경"
     "三昧境")
    ("삼면"
     "三面")
    ("삼문"
     "三門")
    ("삼박자"
     "三拍子")
    ("삼백"
     "三百")
    ("삼백만"
     "三百萬")
    ("삼백육십"
     "三百六十")
    ("삼백이"
     "三百二")
    ("삼법인"
     "三法印")
    ("삼보"
     "三寶")
    ("삼복"
     "三伏")
    ("삼부"
     "三府"
     "三部")
    ("삼분정족"
     "三分鼎足")
    ("삼사"
     "三四")
    ("삼사십"
     "三四十")
    ("삼삼오오"
     "三三五五")
    ("삼색"
     "三色")
    ("삼생연분"
     "三生緣分")
    ("삼선"
     "三選")
    ("삼성"
     "三省")
    ("삼세"
     "三世"
     "三稅")
    ("삼수"
     "三修")
    ("삼순구식"
     "三旬九食")
    ("삼시"
     "三時")
    ("삼시금근"
     "三豕金根")
    ("삼신"
     "三神")
    ("삼십"
     "三十")
    ("삼십구"
     "三十九")
    ("삼십만"
     "三十萬")
    ("삼십사"
     "三十四")
    ("삼십삼인"
     "三十三人")
    ("삼십삼천"
     "三十三天")
    ("삼십억"
     "三十億")
    ("삼십오"
     "三十五")
    ("삼십육계"
     "三十六計")
    ("삼십이립"
     "三十而立")
    ("삼십일"
     "三十一")
    ("삼십조"
     "三十兆")
    ("삼십팔도선"
     "三十八度線")
    ("삼억"
     "三億")
    ("삼엄"
     "森嚴")
    ("삼역"
     "三役")
    ("삼오"
     "三五")
    ("삼원색"
     "三原色")
    ("삼월"
     "三月")
    ("삼월생"
     "三月生")
    ("삼위일체"
     "三位一體")
    ("삼육"
     "三育")
    ("삼인무"
     "三人舞")
    ("삼인성호"
     "三人成虎")
    ("삼일"
     "三一")
    ("삼일절"
     "三一節")
    ("삼일천하"
     "三日天下")
    ("삼자"
     "三者")
    ("삼자세"
     "三姿勢")
    ("삼재"
     "三才")
    ("삼종지도"
     "三從之道")
    ("삼종지의"
     "三從之義")
    ("삼중"
     "三重")
    ("삼중고"
     "三重苦")
    ("삼지구엽초"
     "三枝九葉草")
    ("삼지창"
     "三枝槍")
    ("삼차원"
     "三次元")
    ("삼차원적"
     "三次元的")
    ("삼창"
     "三唱")
    ("삼척동자"
     "三尺童子")
    ("삼천"
     "三千")
    ("삼천갑자"
     "三千甲子")
    ("삼천리"
     "三千里")
    ("삼천리강산"
     "三千里江山")
    ("삼천만"
     "三千萬")
    ("삼천오백"
     "三千五百")
    ("삼천지교"
     "三遷之敎")
    ("삼첩반상"
     "三-飯床")
    ("삼체"
     "三諦")
    ("삼촌"
     "三寸")
    ("삼총사"
     "三銃士")
    ("삼최"
     "三崔")
    ("삼층"
     "三層")
    ("삼칠일"
     "三七日")
    ("삼투"
     "渗透")
    ("삼투성"
     "渗透性")
    ("삼투압"
     "渗透壓")
    ("삼파전"
     "三巴戰")
    ("삼팔"
     "三八")
    ("삼팔선"
     "三八線")
    ("삼팔주"
     "三八紬")
    ("삼한"
     "三寒")
    ("삼한사온"
     "三寒四溫")
    ("삼현"
     "三絃")
    ("삽"
     ("揷" . "꽂을 삽")
     ("澁" . "떫을 삽")
     ("鈒" . "창 삽")
     ("颯" . "바람소리 삽")
     ("卅" . "서른 삽")
     ("唼" . "쪼아먹을 삽")
     ("歃" . "마실 삽")
     ("翣" . "운삽 삽")
     ("鍤" . "가래 삽")
     ("霅" . "비올 삽")
     ("霎" . "가랑비 삽"))
    ("삽입"
     "揷入")
    ("삽입술"
     "揷入術")
    ("삽화"
     "揷畵"
     "揷話")
    ("상"
     ("上" . "위 상")
     ("傷" . "상처 상")
     ("像" . "형상 상")
     ("償" . "갚을 상")
     ("商" . "헤아릴 상")
     ("喪" . "죽을 상")
     ("嘗" . "맛볼 상")
     "嫦"
     ("孀" . "과부 상")
     ("尙" . "오히려 상")
     ("峠" . "고개 상")
     ("常" . "항상 상")
     ("床" . "牀의 俗字")
     ("庠" . "학교 상")
     ("廂" . "행랑 상")
     ("想" . "생각할 상")
     ("桑" . "뽕나무 상")
     ("橡" . "상수리나무 상")
     ("湘" . "강이름 상")
     "瀧"
     ("爽" . "시원할 상")
     ("牀" . "평상 상")
     ("狀" . "형상 상")
     ("相" . "서로 상")
     ("祥" . "상서로울 상")
     ("箱" . "상자 상")
     ("翔" . "빙빙돌아날 상")
     ("裳" . "치마 상")
     ("觴" . "잔 상")
     ("詳" . "자세할 상")
     ("象" . "코끼리 상")
     ("賞" . "상줄 상")
     ("霜" . "서리 상")
     "倘"
     ("塽" . "높고밝은땅 상")
     ("徜" . "노닐 상")
     ("晌" . "정오 상")
     ("殤" . "일찍죽을 상")
     ("甞" . "맛볼 상")
     ("緗" . "담황색 상")
     ("鎟" . "방울소리 상")
     ("顙" . "이마 상")
     ("鬺" . "삶을 상"))
    ("상가"
     "商家"
     "商街"
     "喪家")
    ("상가지구"
     "喪家之狗")
    ("상감"
     "上監"
     "象嵌")
    ("상강"
     "霜降")
    ("상거"
     "上渠"
     "相距")
    ("상거래"
     "商去來")
    ("상견"
     "相見")
    ("상견례"
     "相見禮")
    ("상경"
     "上京"
     "商經"
     "常耕")
    ("상경대"
     "商經大")
    ("상경화"
     "常耕化")
    ("상계"
     "相計")
    ("상고"
     "上古"
     "上告"
     "相考")
    ("상고사"
     "上古史")
    ("상고선"
     "商賈船")
    ("상고심"
     "上告審")
    ("상공"
     "上空"
     "商工")
    ("상공업"
     "商工業")
    ("상공업자"
     "商工業者")
    ("상공인"
     "商工人")
    ("상과"
     "商科")
    ("상관"
     "上官"
     "相關")
    ("상관관계"
     "相關關係")
    ("상관성"
     "相關性")
    ("상국"
     "上國")
    ("상궁"
     "尙宮")
    ("상궁지조"
     "傷弓之鳥")
    ("상권"
     "上卷"
     "商圈"
     "商權")
    ("상극"
     "相剋")
    ("상극적"
     "相剋的")
    ("상근"
     "常勤")
    ("상금"
     "賞金")
    ("상급"
     "上級")
    ("상급반"
     "上級班")
    ("상급생"
     "上級生")
    ("상급자"
     "上級者")
    ("상기"
     "上氣"
     "上記"
     "想起")
    ("상기율"
     "想起率")
    ("상납"
     "上納")
    ("상념"
     "想念")
    ("상노"
     "床奴")
    ("상단"
     "上段"
     "上端")
    ("상담"
     "相談")
    ("상담계"
     "相談係")
    ("상담료"
     "相談料")
    ("상담소"
     "相談所")
    ("상담실"
     "相談室")
    ("상담역"
     "相談役")
    ("상담원"
     "相談員")
    ("상담자"
     "相談者")
    ("상당"
     "相當")
    ("상당량"
     "相當量")
    ("상당성"
     "相當性")
    ("상당수"
     "相當數")
    ("상당액"
     "相當額")
    ("상대"
     "上代"
     "商大"
     "相對")
    ("상대국"
     "相對國")
    ("상대등"
     "上大等")
    ("상대등제"
     "上大等制")
    ("상대론"
     "相對論")
    ("상대방"
     "相對方")
    ("상대사"
     "上代史")
    ("상대성"
     "相對性")
    ("상대역"
     "相對役")
    ("상대자"
     "相對者")
    ("상대적"
     "相對的")
    ("상대주의"
     "相對主義")
    ("상대주의적"
     "相對主義的")
    ("상대편"
     "相對便")
    ("상대화"
     "相對化")
    ("상도"
     "商圖")
    ("상동"
     "相同")
    ("상동성"
     "相同性")
    ("상등"
     "上等")
    ("상등품"
     "上等品")
    ("상량"
     "上樑")
    ("상량문"
     "上樑文")
    ("상량식"
     "上樑式")
    ("상례"
     "常例")
    ("상록"
     "常綠")
    ("상록수"
     "常綠樹")
    ("상루하습"
     "上漏下濕")
    ("상류"
     "上流")
    ("상류층"
     "上流層")
    ("상륙"
     "上陸")
    ("상륙자"
     "上陸者")
    ("상륙정"
     "上陸艇")
    ("상면"
     "相面")
    ("상명"
     "上命")
    ("상명하복"
     "上命下服")
    ("상무"
     "商務"
     "常務")
    ("상무위원"
     "常務委員")
    ("상무이사"
     "常務理事")
    ("상민"
     "常民")
    ("상반"
     "相反")
    ("상반기"
     "上半期")
    ("상반신"
     "上半身")
    ("상방"
     "上方")
    ("상벌"
     "賞罰")
    ("상병"
     "上兵"
     "傷兵")
    ("상보"
     "相補"
     "詳報")
    ("상보적"
     "相補的")
    ("상복"
     "上服"
     "喪服"
     "尙服")
    ("상복착"
     "常服窄")
    ("상봉"
     "相逢")
    ("상부"
     "上部"
     "相符")
    ("상부상조"
     "相扶相助")
    ("상부상조적"
     "相扶相助的")
    ("상분지도"
     "嘗糞之徒")
    ("상비군"
     "常備軍")
    ("상비약"
     "常備藥")
    ("상사"
     "上司"
     "上士"
     "商社")
    ("상사원"
     "商社員")
    ("상상"
     "想像")
    ("상상력"
     "想像力")
    ("상상적"
     "想像的")
    ("상생"
     "上生")
    ("상생적"
     "相生的")
    ("상서"
     "祥瑞")
    ("상석"
     "床石")
    ("상선"
     "商船")
    ("상설"
     "常設")
    ("상설관"
     "常設館")
    ("상설화"
     "常設化")
    ("상세"
     "詳細")
    ("상소"
     "上疏")
    ("상소문"
     "上疏文")
    ("상소자"
     "上訴者")
    ("상속"
     "相續")
    ("상속론"
     "相續論")
    ("상속분"
     "相續分")
    ("상속세"
     "相續稅")
    ("상속인"
     "相續人")
    ("상속자"
     "相續者")
    ("상쇄"
     "相殺")
    ("상수도"
     "上水道")
    ("상수원"
     "上水原")
    ("상순"
     "上旬")
    ("상술"
     "上述"
     "商術")
    ("상습"
     "常習")
    ("상습적"
     "常習的")
    ("상습화"
     "常習化")
    ("상승"
     "上昇")
    ("상승기"
     "上昇期")
    ("상승률"
     "上昇率")
    ("상승세"
     "上昇勢")
    ("상승효과"
     "相乘效果")
    ("상시"
     "常時")
    ("상식"
     "上食"
     "常識"
     "常食")
    ("상식선"
     "常識線")
    ("상식적"
     "常識的")
    ("상식화"
     "常識化")
    ("상실"
     "喪失")
    ("상실감"
     "喪失感")
    ("상실자"
     "喪失者")
    ("상실증"
     "喪失症")
    ("상심"
     "傷心")
    ("상아"
     "象牙")
    ("상아색"
     "象牙色")
    ("상아탑"
     "象牙塔")
    ("상업"
     "商業")
    ("상업계"
     "商業界")
    ("상업극"
     "商業劇")
    ("상업성"
     "商業性")
    ("상업적"
     "商業的")
    ("상업주의"
     "商業主義")
    ("상업주의화"
     "商業主義化")
    ("상업학교"
     "商業學校")
    ("상업화"
     "商業化")
    ("상여"
     "喪輿")
    ("상여금"
     "賞與金")
    ("상연"
     "上演")
    ("상엿"
     "喪輿")
    ("상영"
     "上映")
    ("상영관"
     "上映館")
    ("상영실"
     "上映室")
    ("상영작"
     "上映作")
    ("상오"
     "上午")
    ("상온"
     "常溫")
    ("상용"
     "常用")
    ("상용차"
     "商用車")
    ("상용한자"
     "常用漢字")
    ("상용화"
     "常用化")
    ("상원"
     "上院")
    ("상위"
     "上位")
    ("상위권"
     "上位圈")
    ("상위직"
     "上位職")
    ("상유양심"
     "尙有良心")
    ("상읍례"
     "上揖禮")
    ("상응"
     "相應")
    ("상의"
     "上衣"
     "相議"
     "詳議")
    ("상의하상"
     "上衣下裳")
    ("상이"
     "相異")
    ("상이용사"
     "傷痍勇士")
    ("상이점"
     "相異點")
    ("상인"
     "商人")
    ("상임"
     "常任")
    ("상자"
     "相者"
     "箱子")
    ("상자화"
     "箱子化")
    ("상장"
     "上場"
     "上將"
     "喪章"
     "賞狀")
    ("상장사"
     "上場社")
    ("상전"
     "上典")
    ("상전벽해"
     "桑田碧海")
    ("상점"
     "商店")
    ("상접"
     "相接")
    ("상정"
     "上程"
     "想定")
    ("상제"
     "上帝"
     "喪制")
    ("상조"
     "尙早")
    ("상조회"
     "相助會")
    ("상존"
     "尙存"
     "常存")
    ("상종"
     "相從")
    ("상좌"
     "上座")
    ("상좌평"
     "上佐平")
    ("상좌평제"
     "上佐平制")
    ("상주"
     "喪主"
     "常住"
     "常駐")
    ("상주인구"
     "常住人口")
    ("상중하"
     "上中下")
    ("상징"
     "象徵")
    ("상징계"
     "象徵界")
    ("상징물"
     "象徵物")
    ("상징성"
     "象徵性")
    ("상징적"
     "象徵的")
    ("상징주의"
     "象徵主義")
    ("상징체계"
     "象徵體系")
    ("상징화"
     "象徵化")
    ("상책"
     "上策")
    ("상처"
     "傷處"
     "喪妻")
    ("상처당"
     "傷處當")
    ("상체"
     "上體")
    ("상춘"
     "賞春")
    ("상춘객"
     "賞春客")
    ("상충"
     "相衝")
    ("상층"
     "上層")
    ("상층권"
     "上層圈")
    ("상층부"
     "上層部")
    ("상쾌"
     "爽快")
    ("상탁하부정"
     "上濁下不淨")
    ("상태"
     "常態"
     "狀態")
    ("상통"
     "相通")
    ("상통하달"
     "上通下達")
    ("상투어"
     "常套語")
    ("상투적"
     "常套的")
    ("상투형"
     "常套型")
    ("상투화"
     "常套化")
    ("상팔자"
     "上八字")
    ("상패"
     "賞牌")
    ("상포"
     "常布")
    ("상표"
     "商標")
    ("상표권"
     "商標權")
    ("상표권자"
     "商標權者")
    ("상표력"
     "商標力")
    ("상표명"
     "商標名")
    ("상표율"
     "商標率")
    ("상품"
     "上品"
     "商品"
     "賞品")
    ("상품화"
     "商品化")
    ("상품화권자"
     "商品化權者")
    ("상풍고절"
     "霜風高節")
    ("상하"
     "上下")
    ("상하수도"
     "上下水道")
    ("상한"
     "上限"
     "象限")
    ("상한가"
     "上限價")
    ("상한제"
     "上限制")
    ("상해"
     "傷害")
    ("상행"
     "上行")
    ("상행선"
     "上行線")
    ("상행위"
     "商行爲")
    ("상향"
     "上向")
    ("상현"
     "上弦")
    ("상형"
     "象形")
    ("상호"
     "商號"
     "相互"
     "相好")
    ("상호적"
     "相互的")
    ("상호주의"
     "相互主義")
    ("상혼"
     "商魂")
    ("상환"
     "償還")
    ("상황"
     "狀況")
    ("상황극"
     "狀況劇")
    ("상황성"
     "狀況性")
    ("상황실"
     "狀況室")
    ("상황적"
     "狀況的")
    ("상황판"
     "狀況板")
    ("상회"
     "上廻"
     "商會")
    ("상흔"
     "傷痕")
    ("새"
     ("塞" . "변방 새")
     ("璽" . "도장 새")
     ("賽" . "굿할 새")
     "崽"
     ("鰓" . "뿔심 새"))
    ("새옹지마"
     "塞翁之馬")
    ("색"
     ("嗇" . "아낄 색")
     ("穡" . "거둘 색")
     ("索" . "찾을 색")
     ("色" . "빛 색")
     ("薔" . "아낄 색")
     ("塞" . "막힐 색")
     ("愬" . "놀랍고두려울 색")
     ("槭" . "나뭇잎 떨어져 앙상할 색")
     ("濇" . "껄끄러울 색")
     ("瀒" . "濇의 俗字"))
    ("색감"
     "色感")
    ("색견"
     "色絹")
    ("색광증"
     "色狂症")
    ("색난"
     "色難")
    ("색등"
     "色燈")
    ("색마"
     "色魔")
    ("색맹"
     "色盲")
    ("색사"
     "色絲")
    ("색상"
     "色相")
    ("색색"
     "色色")
    ("색소"
     "色素")
    ("색수상행식"
     "色受想行識")
    ("색안경"
     "色眼鏡")
    ("색연필"
     "色鉛筆")
    ("색위"
     "色緯")
    ("색인"
     "索引")
    ("색조"
     "色調")
    ("색조명"
     "色照明")
    ("색즉시공"
     "色卽是空")
    ("색지"
     "色紙")
    ("색채"
     "色彩")
    ("색채감"
     "色彩感")
    ("색출"
     "索出")
    ("색칠"
     "色漆")
    ("생"
     ("牲" . "희생 생")
     ("生" . "날 생")
     ("甥" . "생질 생")
     ("笙" . "생황 생")
     ("省" . "덜 생")
     ("眚" . "눈에백태낄 생")
     ("鉎" . "녹 생"))
    ("생가"
     "生家")
    ("생강"
     "生薑")
    ("생강즙"
     "生薑汁")
    ("생견"
     "生絹")
    ("생경"
     "生硬")
    ("생경광주"
     "生鏡光紬")
    ("생경험"
     "生經驗")
    ("생계"
     "生計")
    ("생계란"
     "生鷄卵")
    ("생계비"
     "生計費")
    ("생고사"
     "生庫紗")
    ("생광"
     "生光")
    ("생광목"
     "生廣木")
    ("생구"
     "生口")
    ("생기"
     "生氣")
    ("생난리"
     "生亂離")
    ("생년"
     "生年")
    ("생년월일"
     "生年月日")
    ("생도"
     "生徒")
    ("생동"
     "生動")
    ("생동감"
     "生動感")
    ("생동성"
     "生動性")
    ("생두부"
     "生豆腐")
    ("생득적"
     "生得的")
    ("생래적"
     "生來的")
    ("생략"
     "省略")
    ("생력화"
     "省力化")
    ("생령"
     "生靈")
    ("생로병사"
     "生老病死")
    ("생리"
     "生利"
     "生理")
    ("생리대"
     "生理帶")
    ("생리적"
     "生理的")
    ("생리통"
     "生理痛")
    ("생리학자"
     "生理學者")
    ("생리학적"
     "生理學的")
    ("생매장"
     "生埋葬")
    ("생매장당"
     "生埋葬當")
    ("생맥주"
     "生麥酒")
    ("생면부지"
     "生面不知")
    ("생멸"
     "生滅")
    ("생명"
     "生命")
    ("생명감"
     "生命感")
    ("생명계"
     "生命界")
    ("생명관"
     "生命觀")
    ("생명권"
     "生命權")
    ("생명력"
     "生命力")
    ("생명론"
     "生命論")
    ("생명수"
     "生命水")
    ("생명원"
     "生命原")
    ("생명적"
     "生命的")
    ("생명주"
     "生明紬")
    ("생명체"
     "生命體")
    ("생모"
     "生母")
    ("생목"
     "生木")
    ("생무살인"
     "生巫殺人")
    ("생문화"
     "生文化")
    ("생물"
     "生物")
    ("생물계"
     "生物界")
    ("생물권"
     "生物圈")
    ("생물적"
     "生物的")
    ("생물체"
     "生物體")
    ("생물학"
     "生物學")
    ("생물학과"
     "生物學科")
    ("생물학자"
     "生物學者")
    ("생물학적"
     "生物學的")
    ("생물화학적"
     "生物化學的")
    ("생방"
     "生放")
    ("생방송"
     "生放送")
    ("생보사"
     "生保社")
    ("생보업계"
     "生保業界")
    ("생사"
     "生死")
    ("생사실"
     "生事實")
    ("생사육골"
     "生死肉骨")
    ("생사화복"
     "生死禍福")
    ("생산"
     "生産")
    ("생산고"
     "生産高")
    ("생산관계"
     "生産關係")
    ("생산량"
     "生産量")
    ("생산력"
     "生産力")
    ("생산력적"
     "生産力的")
    ("생산물"
     "生産物")
    ("생산비"
     "生産費")
    ("생산성"
     "生産性")
    ("생산업계"
     "生産業界")
    ("생산업자"
     "生産業者")
    ("생산업체"
     "生産業體")
    ("생산자"
     "生産者")
    ("생산자층"
     "生産者層")
    ("생산적"
     "生産的")
    ("생산지"
     "生産地")
    ("생산직"
     "生産職")
    ("생산품"
     "生産品")
    ("생살여탈"
     "生殺與奪")
    ("생색"
     "生色")
    ("생선"
     "生鮮")
    ("생선회"
     "生鮮膾")
    ("생성"
     "生成")
    ("생세목"
     "生細木")
    ("생소"
     "生疏")
    ("생수"
     "生水")
    ("생시"
     "生時")
    ("생식"
     "生殖")
    ("생식기"
     "生殖器")
    ("생신"
     "生辰")
    ("생애"
     "生涯")
    ("생야채"
     "生野菜")
    ("생약"
     "生藥")
    ("생업"
     "生業")
    ("생엽"
     "生葉")
    ("생영사애"
     "生榮死哀")
    ("생원"
     "生員")
    ("생월"
     "生月")
    ("생유리"
     "生琉璃")
    ("생육"
     "生育")
    ("생육신"
     "生六臣")
    ("생이별"
     "生離別")
    ("생이지지"
     "生而知之")
    ("생일"
     "生日")
    ("생자필멸"
     "生者必滅")
    ("생장"
     "生長")
    ("생장력"
     "生長力")
    ("생전"
     "生前")
    ("생존"
     "生存")
    ("생존권"
     "生存權")
    ("생존권적"
     "生存權的")
    ("생존율"
     "生存率")
    ("생존자"
     "生存者")
    ("생졸"
     "生卒")
    ("생주"
     "生紬")
    ("생중계"
     "生中繼")
    ("생즙"
     "生汁")
    ("생지"
     "生紙")
    ("생지옥"
     "生地獄")
    ("생지황"
     "生地黃")
    ("생채식"
     "生菜式")
    ("생체"
     "生體")
    ("생체막"
     "生體膜")
    ("생탄활박"
     "生呑活剝")
    ("생태"
     "生態")
    ("생태계"
     "生態系")
    ("생태계적"
     "生態系的")
    ("생태성"
     "生態性")
    ("생태적"
     "生態的")
    ("생태주의"
     "生態主義")
    ("생태학"
     "生態學")
    ("생태학자"
     "生態學者")
    ("생태학적"
     "生態學的")
    ("생포"
     "生捕")
    ("생필품"
     "生必品")
    ("생항라"
     "生亢羅")
    ("생화학"
     "生化學")
    ("생화학과"
     "生化學科")
    ("생화학적"
     "生化學的")
    ("생환"
     "生還")
    ("생활"
     "生活")
    ("생활고"
     "生活苦")
    ("생활공간"
     "生活空間")
    ("생활권"
     "生活圈")
    ("생활난"
     "生活難")
    ("생활력"
     "生活力")
    ("생활면"
     "生活面")
    ("생활복"
     "生活服")
    ("생활부"
     "生活部")
    ("생활부장"
     "生活部長")
    ("생활비"
     "生活費")
    ("생활사"
     "生活史")
    ("생활상"
     "生活相")
    ("생활수준"
     "生活水準")
    ("생활시간"
     "生活時間")
    ("생활신조"
     "生活信條")
    ("생활양식"
     "生活樣式")
    ("생활용수"
     "生活用水")
    ("생활용품"
     "生活用品")
    ("생활인"
     "生活人")
    ("생활자"
     "生活者")
    ("생활적"
     "生活的")
    ("생활체"
     "生活體")
    ("생활필수품"
     "生活必需品")
    ("생활하수"
     "生活下水")
    ("생활화"
     "生活化")
    ("생활환경"
     "生活環境")
    ("생후"
     "生後")
    ("서"
     ("墅" . "농막 서")
     ("壻" . "사위 서")
     ("嶼" . "섬 서")
     ("序" . "차례 서")
     ("庶" . "여러 서")
     ("徐" . "천천할 서")
     ("恕" . "용서할 서")
     ("抒" . "풀 서")
     ("捿" . "깃들일 서")
     ("敍" . "차례 서")
     ("暑" . "더울 서")
     ("曙" . "새벽 서")
     ("書" . "쓸 서")
     ("栖" . "깃들일 서")
     ("棲" . "살 서")
     ("犀" . "무소 서")
     ("瑞" . "상서 서")
     ("筮" . "점대 서")
     ("絮" . "솜 서")
     ("緖" . "실마리 서")
     ("署" . "관청 서")
     ("胥" . "서로 서")
     ("舒" . "펼 서")
     ("薯" . "참마 서")
     ("西" . "서녘 서")
     ("誓" . "맹세할 서")
     ("逝" . "갈 서")
     ("鋤" . "호미 서")
     ("黍" . "기장 서")
     ("鼠" . "쥐 서")
     ("噬" . "씹을 서")
     ("婿" . "사위 서")
     ("揟" . "나무이름 서")
     ("湑" . "거를 서")
     ("澨" . "물가 서")
     ("紓" . "느슨할 서")
     ("耡" . "구실이름 서")
     ("芧" . "상수리 서")
     ("鉏" . "호미 서"))
    ("서가"
     "書架")
    ("서간체"
     "書簡體")
    ("서간충비"
     "鼠肝蟲臂")
    ("서거"
     "逝去")
    ("서곡"
     "序曲")
    ("서구"
     "西歐")
    ("서구식"
     "西歐式")
    ("서구어"
     "西歐語")
    ("서구인"
     "西歐人")
    ("서구적"
     "西歐的")
    ("서구형"
     "西歐型")
    ("서구화"
     "西歐化")
    ("서기"
     "書記"
     "西紀")
    ("서기관"
     "書記官")
    ("서기장"
     "書記長")
    ("서남"
     "西南")
    ("서남단"
     "西南端")
    ("서남부"
     "西南部")
    ("서남서"
     "西南西")
    ("서단"
     "西端")
    ("서당"
     "書堂")
    ("서당식"
     "書堂式")
    ("서도"
     "書道")
    ("서동부언"
     "胥動浮言")
    ("서두"
     "序頭"
     "書頭")
    ("서력"
     "西曆")
    ("서론"
     "序論")
    ("서루"
     "西樓")
    ("서류"
     "書類")
    ("서리"
     "署理")
    ("서리지탄"
     "黍離之歎")
    ("서막"
     "序幕")
    ("서면"
     "書面"
     "西面")
    ("서명"
     "署名")
    ("서명서"
     "署名書")
    ("서명식"
     "署名式")
    ("서무과"
     "庶務課")
    ("서무과장"
     "庶務課長")
    ("서문"
     "序文"
     "西門")
    ("서민"
     "庶民")
    ("서민적"
     "庶民的")
    ("서민층"
     "庶民層")
    ("서민형"
     "庶民型")
    ("서반"
     "西班")
    ("서반부"
     "西半部")
    ("서반아어"
     "西班牙語")
    ("서방"
     "書房"
     "西方")
    ("서방정토"
     "西方淨土")
    ("서변"
     "西邊")
    ("서부"
     "西部")
    ("서부권"
     "西部圈")
    ("서부극"
     "西部劇")
    ("서북"
     "西北")
    ("서북부"
     "西北部")
    ("서불한"
     "舒弗邯")
    ("서사"
     "敍事")
    ("서사극"
     "敍事劇")
    ("서사극론"
     "敍事劇論")
    ("서사성"
     "敍事性")
    ("서사시"
     "敍事詩")
    ("서사적"
     "敍事的")
    ("서산"
     "西山")
    ("서산낙일"
     "西山落日")
    ("서생원"
     "鼠生員")
    ("서서"
     "徐徐")
    ("서설"
     "序說"
     "瑞雪")
    ("서세동점"
     "西勢東占")
    ("서술"
     "敍述")
    ("서술서"
     "敍述書")
    ("서술자"
     "敍述者")
    ("서시봉심"
     "西施捧心")
    ("서식"
     "書式"
     "棲息")
    ("서식지"
     "棲息地")
    ("서식처"
     "棲息處")
    ("서신"
     "書信")
    ("서안"
     "西岸")
    ("서약"
     "誓約")
    ("서약서"
     "誓約書")
    ("서양"
     "西洋")
    ("서양목"
     "西洋木")
    ("서양사"
     "西洋紗")
    ("서양식"
     "西洋式")
    ("서양인"
     "西洋人")
    ("서양적"
     "西洋的")
    ("서양화"
     "西洋化"
     "西洋畵")
    ("서얼차대"
     "庶孼差待")
    ("서역"
     "西域")
    ("서열"
     "序列")
    ("서열식"
     "序列式")
    ("서열화"
     "序列化")
    ("서예"
     "書藝")
    ("서예관"
     "書藝館")
    ("서예인"
     "書藝人")
    ("서옥"
     "壻屋")
    ("서원"
     "書院"
     "誓願")
    ("서이행지"
     "恕而行之")
    ("서자"
     "庶子")
    ("서장"
     "序章")
    ("서장대"
     "西將臺")
    ("서재"
     "書齋")
    ("서적"
     "書籍")
    ("서절구투"
     "鼠竊狗偸")
    ("서점"
     "書店")
    ("서점가"
     "書店街")
    ("서정"
     "抒情")
    ("서정미"
     "抒情味")
    ("서정성"
     "抒情性")
    ("서정시"
     "抒情詩")
    ("서정적"
     "抒情的")
    ("서정화"
     "抒情化")
    ("서지학"
     "書誌學")
    ("서진"
     "西進")
    ("서찰"
     "書札")
    ("서체"
     "書體")
    ("서탁"
     "書卓")
    ("서편"
     "西便")
    ("서평"
     "書評")
    ("서풍"
     "西風")
    ("서하지통"
     "西河之痛")
    ("서학"
     "西學")
    ("서한"
     "書翰")
    ("서행"
     "徐行"
     "西行")
    ("서화"
     "書畵")
    ("서화전"
     "書畵展")
    ("석"
     ("夕" . "저녁 석")
     ("奭" . "클 석")
     ("席" . "자리 석")
     ("惜" . "아낄 석")
     ("昔" . "옛 석")
     ("晳" . "밝을 석")
     ("析" . "가를 석")
     ("汐" . "조수 석")
     ("淅" . "쌀일 석")
     ("潟" . "개펄 석")
     ("石" . "돌 석")
     ("碩" . "클 석")
     ("蓆" . "자리 석")
     ("釋" . "풀 석")
     ("錫" . "주석 석")
     ("晰" . "밝을 석")
     ("矽" . "석비레 석")
     ("腊" . "포 석")
     ("舃" . "신 석")
     ("蜥" . "도마뱀 석")
     ("鉐" . "놋쇠 석")
     ("鼫" . "석서 석"))
    ("석간"
     "夕刊")
    ("석간수"
     "石間水")
    ("석간신문"
     "夕刊新聞")
    ("석계등천"
     "釋階登天")
    ("석고"
     "石膏")
    ("석고대죄"
     "席藁待罪")
    ("석고상"
     "石膏像")
    ("석고실"
     "石膏室")
    ("석공"
     "石工")
    ("석과불식"
     "碩果不食")
    ("석괴"
     "石塊")
    ("석굴"
     "石窟")
    ("석궁"
     "石弓")
    ("석권"
     "席卷")
    ("석권지세"
     "席卷之勢")
    ("석근관지"
     "釋根灌枝")
    ("석기"
     "石器")
    ("석기관"
     "石器館")
    ("석대"
     "石臺")
    ("석등"
     "石燈")
    ("석류"
     "石榴")
    ("석면"
     "石綿")
    ("석명"
     "釋明")
    ("석방"
     "釋放")
    ("석벽"
     "石壁")
    ("석복종길"
     "釋服從吉")
    ("석불"
     "石佛")
    ("석불가난"
     "席不暇暖")
    ("석사"
     "碩士")
    ("석산"
     "石山")
    ("석상"
     "席上"
     "石像")
    ("석수"
     "石手"
     "石水")
    ("석식"
     "夕式")
    ("석심철장"
     "石心鐵腸")
    ("석양"
     "夕陽")
    ("석연"
     "釋然")
    ("석영"
     "石英")
    ("석옥연향"
     "惜玉憐香")
    ("석유"
     "石油")
    ("석재"
     "石材")
    ("석조"
     "石造")
    ("석지실장"
     "惜指失掌")
    ("석차"
     "席次")
    ("석축"
     "石築")
    ("석축물"
     "石築物")
    ("석탄"
     "石炭")
    ("석탄일"
     "釋誕日")
    ("석탄층"
     "石炭層")
    ("석탑"
     "石塔")
    ("석파천경"
     "石破天驚")
    ("석판"
     "石板")
    ("석학"
     "碩學")
    ("석화"
     "石花")
    ("석회"
     "石灰")
    ("석회분"
     "石灰分")
    ("석회석"
     "石灰石")
    ("석회암"
     "石灰巖")
    ("석회질"
     "石灰質")
    ("석회층"
     "石灰層")
    ("선"
     ("亘" . "구할 선")
     ("仙" . "신선 선")
     ("僊" . "춤출 선")
     ("先" . "먼저 선")
     ("善" . "착할 선")
     ("單" . "고을이름 선")
     ("嬋" . "고울 선")
     ("宣" . "베풀 선")
     ("扇" . "사립문 선")
     ("敾" . "글잘쓸 선")
     ("旋" . "돌 선")
     ("洗" . "조촐할 선, 율이름 선")
     ("渲" . "바림 선")
     "湺"
     ("煽" . "부칠 선")
     ("琁" . "옥 선")
     ("瑄" . "도리옥 선")
     ("璇" . "아름다운옥 선")
     ("璿" . "아름다운옥 선")
     ("癬" . "옴 선")
     ("禪" . "봉선 선")
     ("線" . "실 선")
     ("繕" . "기울 선")
     ("羨" . "부러워할 선")
     ("腺" . "샘 선")
     ("膳" . "반찬 선")
     ("船" . "배 선")
     ("蘚" . "이끼 선")
     ("蟬" . "매미 선")
     ("詵" . "많을 선")
     ("跣" . "맨발 선")
     ("選" . "가릴 선")
     ("銑" . "끌 선")
     ("鐥" . "복자 선")
     ("霰" . "싸락눈 선, 별 선")
     ("饍" . "膳과 同字")
     ("鮮" . "고울 선")
     ("墡" . "백토 선")
     "姍"
     "姺"
     ("嫙" . "예쁠 선")
     ("尟" . "尠과 同字")
     ("尠" . "적을 선")
     ("屳" . "날 선")
     ("愃" . "쾌할 선")
     ("歚" . "고을 선")
     "燹"
     ("筅" . "솔 선")
     ("綫" . "線과 同字")
     "脧"
     ("譔" . "가르칠 선")
     ("譱" . "善의 古字")
     ("鏇" . "갈이틀 선")
     "駪"
     ("騸" . "불깔 선")
     ("鱓" . "두렁허리 선")
     ("鱻" . "생선 선"))
    ("선가"
     "禪家"
     "船價")
    ("선각자"
     "先覺者")
    ("선거"
     "選擧")
    ("선거구"
     "選擧區")
    ("선거권"
     "選擧權")
    ("선거사"
     "選擧史")
    ("선거인"
     "選擧人")
    ("선거인단"
     "選擧人團")
    ("선거일"
     "選擧日")
    ("선거전"
     "選擧戰")
    ("선건전곤"
     "旋乾轉坤")
    ("선견자"
     "先見者")
    ("선견지명"
     "先見之明")
    ("선결"
     "先決")
    ("선경험자"
     "先經驗者")
    ("선고"
     "宣告")
    ("선고심"
     "宣告審")
    ("선공무덕"
     "善供無德")
    ("선공후사"
     "先公後私")
    ("선관"
     "善管"
     "禪觀")
    ("선교"
     "宣敎"
     "禪敎")
    ("선교론"
     "宣敎論")
    ("선교사"
     "宣敎師")
    ("선교용"
     "宣敎用")
    ("선교회"
     "宣敎會")
    ("선구"
     "先驅"
     "船具")
    ("선구자"
     "先驅者")
    ("선구적"
     "先驅的")
    ("선금"
     "先金")
    ("선금제"
     "先金制")
    ("선기자타"
     "善騎者墮")
    ("선기준"
     "先基準")
    ("선남선녀"
     "善男善女")
    ("선납"
     "先納")
    ("선내"
     "船內")
    ("선녀"
     "仙女")
    ("선달"
     "先達")
    ("선대"
     "先代"
     "線帶"
     "選對")
    ("선도"
     "先導"
     "善導")
    ("선도부"
     "善導部")
    ("선도부원"
     "善導部員")
    ("선도자"
     "先導者")
    ("선도적"
     "先導的")
    ("선동"
     "煽動")
    ("선동가"
     "煽動家")
    ("선동부"
     "煽動部")
    ("선동적"
     "煽動的")
    ("선두"
     "先頭"
     "船頭")
    ("선두마"
     "先頭馬")
    ("선두적"
     "先頭的")
    ("선량"
     "善良"
     "選良")
    ("선례"
     "先例")
    ("선로"
     "線路")
    ("선린"
     "善隣")
    ("선망"
     "羨望")
    ("선명"
     "鮮明")
    ("선명력"
     "宣明曆")
    ("선명성"
     "鮮明性")
    ("선묘"
     "線描")
    ("선묘룡"
     "善妙龍")
    ("선문"
     "禪門")
    ("선문답"
     "禪問答")
    ("선문답식"
     "仙問答式")
    ("선물"
     "先物"
     "膳物")
    ("선물전"
     "先物展")
    ("선미"
     "船尾")
    ("선민"
     "先民")
    ("선민사상"
     "選民思想")
    ("선민의식"
     "選民意識")
    ("선박"
     "船舶")
    ("선반"
     "旋盤")
    ("선발"
     "先發"
     "選拔")
    ("선발권"
     "選拔權")
    ("선발대"
     "先發隊")
    ("선방"
     "善防"
     "禪房")
    ("선배"
     "先輩")
    ("선별"
     "選別")
    ("선별적"
     "選別的")
    ("선병복약"
     "先病服藥")
    ("선봉"
     "先鋒")
    ("선봉대"
     "先鋒隊")
    ("선봉장"
     "先鋒將")
    ("선불"
     "先拂")
    ("선사"
     "先史"
     "禪師"
     "膳賜"
     "船社")
    ("선산"
     "先山")
    ("선상"
     "線上"
     "線狀"
     "船上")
    ("선상후벌"
     "先賞後罰")
    ("선생"
     "先生")
    ("선생실"
     "先生室")
    ("선서"
     "宣誓")
    ("선수"
     "先手"
     "船首"
     "選手")
    ("선수권"
     "選手權")
    ("선수권자"
     "選手權者")
    ("선수단"
     "選手團")
    ("선수제"
     "選手制")
    ("선수촌"
     "選手村")
    ("선순환"
     "先循環")
    ("선승"
     "禪僧")
    ("선승제"
     "先勝制")
    ("선시험"
     "先試驗")
    ("선실"
     "船室")
    ("선심"
     "善心"
     "禪心")
    ("선심성"
     "善心性")
    ("선악"
     "善惡")
    ("선악과"
     "善惡果")
    ("선약"
     "先約")
    ("선양"
     "宣揚"
     "煽揚")
    ("선언"
     "宣言")
    ("선언문"
     "宣言文")
    ("선언서"
     "宣言書")
    ("선언자"
     "宣言者")
    ("선언적"
     "宣言的")
    ("선연"
     "鮮然")
    ("선열"
     "先烈")
    ("선왕"
     "先王")
    ("선용"
     "善用")
    ("선용품"
     "船用品")
    ("선우"
     "單于")
    ("선우후락"
     "先憂後樂")
    ("선원"
     "船員")
    ("선유"
     "宣諭")
    ("선율"
     "旋律")
    ("선의"
     "善意")
    ("선의지"
     "善意志")
    ("선인"
     "仙人"
     "先人")
    ("선인수"
     "先引受")
    ("선인장"
     "仙人掌")
    ("선임"
     "先任"
     "選任")
    ("선임권"
     "先任權")
    ("선입감"
     "先入感")
    ("선입견"
     "先入見")
    ("선입관"
     "先入觀")
    ("선자옥질"
     "仙姿玉質")
    ("선자유화"
     "先自由化")
    ("선장"
     "船長")
    ("선장실"
     "船長室")
    ("선재"
     "線材")
    ("선적"
     "船積"
     "船籍")
    ("선적분"
     "船積分")
    ("선전"
     "善戰"
     "宣傳"
     "宣戰")
    ("선전문"
     "宣傳文")
    ("선전물"
     "宣傳物")
    ("선전실"
     "宣傳室")
    ("선전용"
     "宣傳用")
    ("선전장"
     "宣傳場")
    ("선전전"
     "宣傳戰")
    ("선점"
     "先占")
    ("선점기"
     "先占期")
    ("선정"
     "禪定"
     "選定")
    ("선정성"
     "煽情性")
    ("선정작"
     "選定作")
    ("선정적"
     "煽情的")
    ("선정주의"
     "煽情主義")
    ("선제"
     "先制")
    ("선조"
     "先祖")
    ("선조사"
     "先調査")
    ("선조업"
     "先操業")
    ("선종"
     "禪宗")
    ("선주"
     "船主")
    ("선주민"
     "先住民")
    ("선지자"
     "先知者")
    ("선진"
     "先進")
    ("선진국"
     "先進國")
    ("선진국형"
     "先進國型")
    ("선진성"
     "先進性")
    ("선진적"
     "先進的")
    ("선진화"
     "先進化")
    ("선집"
     "選集")
    ("선차적"
     "先次的")
    ("선착"
     "先着")
    ("선착순"
     "先着順")
    ("선착장"
     "船着場")
    ("선창"
     "先唱"
     "船廠"
     "船窓"
     "船艙")
    ("선처"
     "善處")
    ("선천"
     "先天")
    ("선천성"
     "先天性")
    ("선천적"
     "先天的")
    ("선체"
     "船體")
    ("선초"
     "鮮初")
    ("선추"
     "扇錘")
    ("선출"
     "選出")
    ("선취"
     "先取"
     "船醉")
    ("선친"
     "先親")
    ("선탄"
     "煽炭"
     "選炭")
    ("선탄장"
     "選炭場")
    ("선태류"
     "蘚苔類")
    ("선택"
     "選擇")
    ("선택권"
     "選擇權")
    ("선택법"
     "選擇法")
    ("선택적"
     "選擇的")
    ("선통"
     "先通")
    ("선패유기"
     "善敗由己")
    ("선포"
     "宣布")
    ("선포권"
     "宣布權")
    ("선포안"
     "宣布案")
    ("선풍"
     "旋風"
     "禪風")
    ("선풍기"
     "扇風機")
    ("선풍도골"
     "仙風道骨")
    ("선풍적"
     "旋風的")
    ("선학"
     "先學")
    ("선행"
     "先行"
     "善行")
    ("선행무철적"
     "善行無鐵迹")
    ("선험"
     "先驗")
    ("선험적"
     "先驗的")
    ("선현"
     "先賢")
    ("선혈"
     "鮮血")
    ("선형"
     "扇形")
    ("선호"
     "選好")
    ("선호도"
     "選好度")
    ("선호층"
     "選好層")
    ("선홍색"
     "鮮紅色")
    ("선화적"
     "禪畵的")
    ("선화후과"
     "先花後果")
    ("선회"
     "旋回")
    ("선후"
     "先後")
    ("선후배"
     "先後輩")
    ("선후지책"
     "善後之策")
    ("설"
     ("卨" . "사람이름 설")
     ("屑" . "가루 설")
     ("楔" . "문설주 설")
     ("泄" . "샐 설")
     ("洩" . "샐 설")
     ("渫" . "칠 설")
     ("舌" . "혀 설")
     ("薛" . "맑은대쑥 설")
     ("褻" . "더러울 설")
     ("設" . "베풀 설")
     ("說" . "말씀 설")
     ("雪" . "눈 설")
     ("齧" . "물 설")
     ("偰" . "맑을 설")
     ("媟" . "깔볼 설")
     ("揲" . "셀 설")
     ("暬" . "설만할 설")
     ("爇" . "불사를 설")
     ("碟" . "가죽다룰 설")
     ("紲" . "고삐 설"))
    ("설건순초"
     "舌乾脣焦")
    ("설계"
     "設計")
    ("설계도"
     "設計圖")
    ("설계비"
     "設計費")
    ("설계사"
     "設計士")
    ("설계안"
     "設計案")
    ("설계자"
     "設計者")
    ("설교"
     "說敎")
    ("설근미건"
     "舌根未乾")
    ("설니홍조"
     "雪泥鴻爪")
    ("설도"
     "說道")
    ("설득"
     "說得")
    ("설득력"
     "說得力")
    ("설령"
     "設令")
    ("설립"
     "設立")
    ("설립자"
     "設立者")
    ("설망우검"
     "舌芒于劍")
    ("설명"
     "說明")
    ("설명문"
     "說明文")
    ("설명서"
     "說明書")
    ("설명자"
     "說明者")
    ("설명적"
     "說明的")
    ("설명회"
     "說明會")
    ("설문"
     "設問"
     "說文")
    ("설문지"
     "設問紙")
    ("설법"
     "說法")
    ("설부신원"
     "雪憤伸寃")
    ("설부화용"
     "雪膚花容")
    ("설비"
     "設備")
    ("설비업"
     "設備業")
    ("설사"
     "泄瀉"
     "設使")
    ("설사병"
     "泄瀉病")
    ("설사약"
     "泄瀉藥")
    ("설산"
     "雪山")
    ("설삼도사"
     "說三道四")
    ("설상가상"
     "雪上加霜")
    ("설상화"
     "舌狀花")
    ("설악산"
     "雪嶽山")
    ("설왕설래"
     "說往說來")
    ("설욕전"
     "雪辱戰")
    ("설원"
     "雪原")
    ("설장도단"
     "說長道短")
    ("설정"
     "設定")
    ("설중군자"
     "雪中君子")
    ("설중송백"
     "雪中松柏")
    ("설치"
     "設置")
    ("설치물"
     "設置物")
    ("설치비"
     "設置費")
    ("설탕"
     "雪糖")
    ("설파"
     "說破")
    ("설혹"
     "設或")
    ("설화"
     "說話"
     "說話")
    ("설화적"
     "說話的")
    ("섬"
     ("暹" . "해돋을 섬")
     ("殲" . "다죽일 섬")
     ("纖" . "가늘 섬")
     ("蟾" . "두꺼비 섬")
     ("贍" . "넉넉할 섬")
     ("閃" . "번쩍할 섬")
     ("陝" . "고을이름 섬")
     ("孅" . "가늘 섬")
     ("憸" . "간사할 섬")
     ("摻" . "섬섬할 섬")
     ("睒" . "번개빛 섬")
     "笘"
     ("譫" . "헛소리 섬")
     ("銛" . "가래 섬")
     ("韱" . "산부추 섬"))
    ("섬광"
     "閃光")
    ("섬섬옥수"
     "纖纖玉手")
    ("섬세"
     "纖細")
    ("섬세성"
     "纖細性")
    ("섬약"
     "纖弱")
    ("섬유"
     "纖維")
    ("섬유소"
     "纖維素")
    ("섬유적"
     "纖維的")
    ("섬유질"
     "纖維質")
    ("섭"
     ("攝" . "몰아 잡을 섭, 끌 섭, 단정하게 할 섭, 겸할 섭, 거둘 섭, 기록할 섭, 항복할 섭")
     ("涉" . "물 건널 섭, 지나칠 섭, 돌아다닐 섭")
     ("燮" . "불에 익힐 섭, 불꽃 섭, 조화로울 섭")
     ("葉" . "고을이름 섭")
     ("囁" . "말하려다 멈출 섭, 중얼거릴 섭, 입 다물 섭")
     ("懾" . "무서울 섭, 두려울 섭")
     "歙"
     ("灄" . "흠치르르할 섭, 물이름 섭, 떼 섭")
     ("聶" . "소곤거릴 섭, 낄 섭, 성씨 섭")
     ("躡" . "밟을 섭, 신 신을 섭, 오를 섭")
     ("鑷" . "쪽집게 섭")
     ("顳" . "귀밑 뼈 섭"))
    ("섭렵"
     "涉獵")
    ("섭리"
     "攝理")
    ("섭리음양"
     "燮理陰陽")
    ("섭생"
     "攝生")
    ("섭씨"
     "攝氏")
    ("섭외"
     "涉外")
    ("섭외국장"
     "涉外局長")
    ("섭정"
     "攝政")
    ("섭취"
     "攝取")
    ("섭취량"
     "攝取量")
    ("성"
     ("城" . "보루 성, 재 성, 서울 성")
     ("姓" . "일가 성, 아이 낳을 성, 백성 성")
     ("宬" . "사고 성, 도서실 성, 창고 성")
     ("性" . "성품 성, 마음 성, 바탕 성, 색욕 성")
     ("惺" . "깨달을 성, 똑똑할 성, 조용할 성")
     ("成" . "이룰 성, 거듭 성, 마칠 성, 화목할 성")
     ("星" . "별 성, 희뜩희뜩할 성, 세월 성, 성시 성")
     ("晟" . "밝을 성, 햇살 퍼질 성")
     ("猩" . "성성이 성")
     "珹"
     ("盛" . "담을 성, 이룰 성, 정제할 성, 많을 성")
     ("省" . "살필 성")
     ("筬" . "바디 성")
     ("聖" . "성인 성, 착할 성, 통할 성, 지극할 성")
     ("聲" . "소리 성, 풍류 성, 명예 성")
     ("腥" . "비린내 성, 더러울 성, 날고기 성")
     ("誠" . "미쁠 성, 공경할 성, 살필 성, 진실 성")
     ("醒" . "술 깰 성, 꿈 깰 성, 깨달을 성")
     "瑆"
     "餳"
     ("騂" . "붉은 소 성, 누른말 성, 활 물쩡물쩡할 성"))
    ("성가"
     "聖歌"
     "聲價")
    ("성격"
     "性格")
    ("성격적"
     "性格的")
    ("성격파"
     "性格派")
    ("성격화"
     "性格化")
    ("성결"
     "聖潔")
    ("성경"
     "聖經")
    ("성경반"
     "聖經班")
    ("성경전서"
     "聖經全書")
    ("성골"
     "聖骨")
    ("성공"
     "成功")
    ("성공담"
     "成功談")
    ("성공률"
     "成功率")
    ("성공리"
     "成功裏")
    ("성공법"
     "成功法")
    ("성공작"
     "成功作")
    ("성공적"
     "成功的")
    ("성공학"
     "成功學")
    ("성과"
     "成果")
    ("성과물"
     "成果物")
    ("성곽"
     "城郭")
    ("성관"
     "城館")
    ("성교"
     "性交")
    ("성교육"
     "性敎育")
    ("성금"
     "誠金")
    ("성급"
     "性急")
    ("성기"
     "性器")
    ("성내"
     "城內")
    ("성녀"
     "聖女")
    ("성년"
     "成年")
    ("성능"
     "性能")
    ("성당"
     "盛唐"
     "聖堂")
    ("성대"
     "盛大"
     "聲帶")
    ("성대모사"
     "聲帶模寫")
    ("성도덕"
     "性道德")
    ("성동격서"
     "聲東擊西")
    ("성라운포"
     "星羅雲布")
    ("성령"
     "聖靈")
    ("성령화"
     "聖靈化")
    ("성리학"
     "性理學")
    ("성립"
     "成立")
    ("성립기"
     "成立期")
    ("성립설"
     "成立說")
    ("성명"
     "姓名"
     "聲明")
    ("성명서"
     "聲明書")
    ("성목요일"
     "聖木曜日")
    ("성묘"
     "省墓")
    ("성묘객"
     "省墓客")
    ("성무"
     "聖務")
    ("성문"
     "城門")
    ("성문과정"
     "聲聞過情")
    ("성문법"
     "成文法")
    ("성물"
     "聖物")
    ("성미"
     "性味")
    ("성범죄"
     "性犯罪")
    ("성벽"
     "城壁")
    ("성별"
     "性別")
    ("성병"
     "性病")
    ("성병자의"
     "先病者醫")
    ("성분"
     "成分")
    ("성불"
     "成佛")
    ("성비"
     "性比")
    ("성사"
     "成事"
     "聖事")
    ("성상모"
     "性狀毛")
    ("성생활"
     "性生活")
    ("성서"
     "聖書")
    ("성서적"
     "聖書的")
    ("성선설"
     "性善說")
    ("성성"
     "星星"
     "猩猩")
    ("성쇠"
     "盛衰")
    ("성쇠흥폐"
     "盛衰興廢")
    ("성수기"
     "盛需期")
    ("성숙"
     "成熟")
    ("성숙기"
     "成熟期")
    ("성숙도"
     "成熟度")
    ("성숙미"
     "成熟美")
    ("성시"
     "成市")
    ("성실"
     "誠實")
    ("성실도"
     "誠實度")
    ("성실성"
     "誠實性")
    ("성심"
     "誠心")
    ("성심성의"
     "誠心誠意")
    ("성씨"
     "姓氏")
    ("성악"
     "聲樂")
    ("성악가"
     "聲樂家")
    ("성악과"
     "聲樂科")
    ("성애"
     "性愛")
    ("성어"
     "成語")
    ("성업"
     "成業"
     "盛業")
    ("성역"
     "城役"
     "聖域")
    ("성역화"
     "聖域化")
    ("성욕"
     "性慾")
    ("성욕자"
     "性慾者")
    ("성우"
     "聲優")
    ("성운"
     "星雲")
    ("성원"
     "成員"
     "聲援")
    ("성은"
     "聖恩")
    ("성음소모"
     "聲音笑貌")
    ("성읍"
     "城邑")
    ("성의"
     "誠意")
    ("성인"
     "成人"
     "聖人")
    ("성인군자"
     "聖人君子")
    ("성인기"
     "成人期")
    ("성인병"
     "成人病")
    ("성인식"
     "成人式")
    ("성인지미"
     "成人之美")
    ("성인화"
     "成人化")
    ("성자"
     "姓字"
     "聖者")
    ("성장"
     "成長")
    ("성장기"
     "成長期")
    ("성장력"
     "成長力")
    ("성장률"
     "成長率")
    ("성장세"
     "成長勢")
    ("성장주"
     "成長株")
    ("성장지"
     "成長地")
    ("성적"
     "性的"
     "成績"
     "成跡")
    ("성적순"
     "成績順")
    ("성적표"
     "成績表")
    ("성전"
     "聖典"
     "聖戰"
     "聖殿")
    ("성정"
     "性情")
    ("성조"
     "成鳥")
    ("성좌"
     "星座")
    ("성주"
     "城主")
    ("성지"
     "聖地")
    ("성지성"
     "聖地性")
    ("성직"
     "聖職")
    ("성직자"
     "聖職者")
    ("성진임목"
     "聲振林木")
    ("성질"
     "性質")
    ("성징"
     "性徵")
    ("성찬"
     "盛饌")
    ("성찰"
     "省察")
    ("성채"
     "城砦")
    ("성체"
     "成體")
    ("성총"
     "盛寵")
    ("성추행"
     "性醜行")
    ("성취"
     "成就")
    ("성취감"
     "成就感")
    ("성취동기"
     "成就動機")
    ("성취욕"
     "成就慾")
    ("성층권"
     "成層圈")
    ("성층화"
     "成層化")
    ("성탄"
     "聖誕")
    ("성탄절"
     "聖誕節")
    ("성토"
     "聲討")
    ("성패"
     "成敗")
    ("성폭력"
     "性暴力")
    ("성폭행"
     "性暴行")
    ("성폭행당"
     "性暴行當")
    ("성품"
     "性品")
    ("성하지맹"
     "城下之盟")
    ("성함"
     "姓銜")
    ("성행"
     "性行"
     "盛行")
    ("성행야귀"
     "星行夜歸")
    ("성행위"
     "性行爲")
    ("성향"
     "性向")
    ("성현"
     "聖賢")
    ("성형"
     "成型"
     "成形")
    ("성형술"
     "成形術")
    ("성형외과"
     "成形外科")
    ("성형외과의"
     "成形外科醫")
    ("성형외과학"
     "成形外科學")
    ("성형의"
     "成形醫")
    ("성형학적"
     "成形學的")
    ("성호사서"
     "城狐社鼠")
    ("성혼식"
     "成婚式")
    ("성화"
     "成火"
     "聖化"
     "聖火")
    ("성황"
     "盛況")
    ("성황당"
     "城隍堂")
    ("성황리"
     "盛況裏")
    ("성희롱"
     "性戱弄")
    ("세"
     ("世" . "세상 세, 평생 세, 백년 세")
     ("勢" . "권세 세, 위엄 세, 불알 세, 기회 세")
     ("歲" . "해 세, 곡식 익을 세, 돐 세, 풍년 세")
     ("洗" . "씻을 세, 세수 그릇 세")
     ("稅" . "구실 세, 거둘 세, 놓을 세, 쉴 세")
     ("笹" . "가는 대 세")
     ("細" . "가늘 세, 작을 세, 좀놈 세")
     ("貰" . "빌릴 세, 세 바칠 세")
     ("說" . "달랠 세, 쉴 세")
     ("帨" . "차는 수건 세, 손수건 세")
     ("洒" . "씻을 세, 설치할 세")
     ("繐" . "가늘고 성긴 베 세")
     ("蛻" . "매미 허물 세"))
    ("세가"
     "世家")
    ("세간"
     "世間")
    ("세강속말"
     "世降俗末")
    ("세계"
     "世界"
     "歲計")
    ("세계관"
     "世界觀")
    ("세계관적"
     "世界觀的")
    ("세계무대"
     "世界舞臺")
    ("세계사"
     "世界史")
    ("세계사적"
     "世界史的")
    ("세계상"
     "世界像")
    ("세계인"
     "世界人")
    ("세계적"
     "世界的")
    ("세계정세"
     "世界情勢")
    ("세계주의"
     "世界主義")
    ("세계화"
     "世界化")
    ("세곡"
     "稅穀")
    ("세공"
     "細工")
    ("세공품"
     "細工品")
    ("세관"
     "稅關")
    ("세관원"
     "稅關員")
    ("세궁역진"
     "勢窮力盡")
    ("세권"
     "勢圈")
    ("세균"
     "細菌")
    ("세금"
     "稅金")
    ("세기"
     "世紀")
    ("세기말"
     "世紀末")
    ("세기말적"
     "世紀末的")
    ("세기적"
     "世紀的")
    ("세기형"
     "世紀型")
    ("세뇌"
     "洗腦")
    ("세뇌당"
     "洗腦當")
    ("세뇌자"
     "洗腦者")
    ("세단의다"
     "世短意多")
    ("세답족백"
     "洗踏足白")
    ("세대"
     "世代"
     "世帶")
    ("세대교체"
     "世代交替")
    ("세대교체론"
     "世代交替論")
    ("세대론"
     "世代論")
    ("세대론적"
     "世代論的")
    ("세대주"
     "世帶主")
    ("세대표"
     "世帶表")
    ("세도"
     "勢道")
    ("세도가"
     "勢道家")
    ("세력"
     "勢力")
    ("세력가"
     "勢力家")
    ("세력권"
     "勢力圈")
    ("세력론"
     "勢力論")
    ("세력사"
     "勢力史")
    ("세력체"
     "勢力體")
    ("세력화"
     "勢力化")
    ("세련"
     "洗練")
    ("세련미"
     "洗練味")
    ("세례"
     "洗禮")
    ("세례명"
     "洗禮名")
    ("세례식"
     "洗禮式")
    ("세리지교"
     "勢利之交")
    ("세립질"
     "細粒質")
    ("세말"
     "世末")
    ("세면"
     "洗面")
    ("세면기"
     "洗面器")
    ("세면대"
     "洗面臺")
    ("세면도구"
     "洗面道具")
    ("세면실"
     "洗面室")
    ("세면장"
     "洗面場")
    ("세명"
     "細明")
    ("세목"
     "細木"
     "細目")
    ("세무"
     "稅務")
    ("세무사"
     "稅務士")
    ("세무서"
     "稅務署")
    ("세무직"
     "稅務職")
    ("세물"
     "貰物")
    ("세밀"
     "細密")
    ("세배"
     "歲拜")
    ("세뱃"
     "歲拜")
    ("세법"
     "稅法")
    ("세부"
     "細部")
    ("세부적"
     "細部的")
    ("세분"
     "細分")
    ("세분화"
     "細分化")
    ("세불아여"
     "歲不我與")
    ("세불양립"
     "勢不兩立")
    ("세사"
     "世事")
    ("세상"
     "世上")
    ("세상만사"
     "世上萬事")
    ("세상사"
     "世上事")
    ("세세"
     "細細")
    ("세세연년"
     "歲歲年年")
    ("세속"
     "世俗")
    ("세속사"
     "世俗史")
    ("세속성"
     "世俗性")
    ("세속오계"
     "世俗五戒")
    ("세속적"
     "世俗的")
    ("세속화"
     "世俗化")
    ("세손"
     "世孫")
    ("세수"
     "歲首"
     "洗手"
     "稅收")
    ("세수법"
     "洗手法")
    ("세수봉직"
     "洗手奉職")
    ("세숫"
     "洗手")
    ("세습"
     "世襲")
    ("세습적"
     "世襲的")
    ("세습제"
     "世襲制")
    ("세습화"
     "世襲化")
    ("세시"
     "歲時")
    ("세심"
     "細心")
    ("세안"
     "洗顔")
    ("세안법"
     "洗眼法")
    ("세안제"
     "洗眼劑")
    ("세액"
     "稅額")
    ("세여파죽"
     "勢如破竹")
    ("세역"
     "歲易")
    ("세원"
     "稅源")
    ("세월"
     "歲月")
    ("세월여류"
     "歲月如流")
    ("세율"
     "稅率")
    ("세이"
     "洗耳")
    ("세인"
     "世人")
    ("세입자"
     "貰入者")
    ("세자"
     "世子")
    ("세저"
     "細苧")
    ("세전"
     "稅錢")
    ("세정"
     "世情"
     "洗淨")
    ("세정력"
     "洗淨力")
    ("세정제"
     "洗淨劑")
    ("세제"
     "洗劑"
     "稅制")
    ("세제실장"
     "稅制室長")
    ("세조"
     "歲租")
    ("세종대왕"
     "世宗大王")
    ("세주"
     "細綢")
    ("세중마포"
     "細中麻布")
    ("세차"
     "洗車")
    ("세척"
     "洗滌")
    ("세척제"
     "洗滌劑")
    ("세출"
     "歲出")
    ("세칙"
     "細則")
    ("세침"
     "細針")
    ("세칭"
     "世稱")
    ("세탁"
     "洗濯")
    ("세탁기"
     "洗濯機")
    ("세탁물"
     "洗濯物")
    ("세탁성"
     "洗濯性")
    ("세탁소"
     "洗濯所")
    ("세태"
     "世態")
    ("세파"
     "世波")
    ("세평"
     "世評")
    ("세포"
     "細布"
     "細胞")
    ("세포막"
     "細胞膜")
    ("세포체"
     "細胞體")
    ("세필"
     "細筆")
    ("세한삼우"
     "歲寒三友")
    ("세한송백"
     "歲寒松柏")
    ("세형동검"
     "細形銅劍")
    ("셋방"
     "貰房")
    ("소"
     ("召" . "부를 소, 청할 소, 과부 소")
     ("嘯" . "휘파람 소, 세게 뿜을 소, 읊을 소")
     ("塑" . "허수아비 소")
     ("宵" . "밤 소, 작을 소, 벌레이름 소")
     ("小" . "작을 소, 좁을 소, 적을 소, 어릴 소, 적게 여길 소")
     ("少" . "적을 소, 조금 소, 멸시할 소, 잠깐 소, 젊을 소")
     ("巢" . "새집 소, 집 지을 소, 새 보금자리 소, 적진 망보는 높을 수레 소, 도둑굴 소, 큰 피리 소, 채소이름 소")
     ("所" . "바 소, 곳 소, 쯤 소, 가질 소, 얼마 소")
     ("掃" . "쓸 소, 상투 소")
     ("搔" . "긁을 소, 휘저을 소, 분분할 소")
     ("昭" . "소명할 소, 소목 소, 태평세월 소")
     "梢"
     ("梳" . "얼레빗 소")
     ("沼" . "못 소, 늪 소")
     ("消" . "다할 소, 꺼질 소, 풀릴 소, 해어질 소")
     ("溯" . "거슬러 올라갈 소")
     ("瀟" . "물 맑을 소, 비바람 몰아칠 소, 강이름 소")
     ("炤" . "밝을 소")
     ("燒" . "불 붙을 소, 들불 소, 불 놓을 소")
     ("甦" . "깨어날 소, 숨 쉴 소")
     ("疎" . "성길 소, 드물 소")
     ("疏" . "뚫릴 소, 나눌 소, 멀 소, 추할 소, 드물 소")
     ("瘙" . "옴 소, 종기 소")
     ("笑" . "웃음 소")
     ("篠" . "가는 대 소")
     ("簫" . "퉁소 소, 활고지 소")
     ("素" . "흴 소, 생초 소, 빌 소, 바탕 소, 원래 소")
     ("紹" . "이을 소, 얽을 소, 소개할 소")
     ("蔬" . "나물 소")
     ("蕭" . "쑥 소, 쓸쓸할 소, 말 우는 소리 소, 바람소리 소")
     ("蘇" . "차조기 소, 나무할 소, 까무러칠 소, 깨어날 소, 성씨 소")
     ("訴" . "하소연할 소, 송사할 소")
     ("逍" . "노닐 소, 거닐 소")
     ("遡" . "거스를 소, 맞이할 소, 하소연할 소")
     ("邵" . "땅이름 소, 성씨 소")
     "釗"
     ("銷" . "녹을 소, 사라질 소")
     ("韶" . "아름다울 소, 이을 소, 순의 풍류 소, 봄 소")
     ("騷" . "근심스러울 소, 흔들릴 소, 급할 소, 처량할 소")
     ("佋" . "소개할 소, 사신 소, 댓수의 차례 소")
     ("俏" . "거문고 뒤치는 소리 소")
     "劭"
     ("卲" . "높을 소, 성씨 소")
     ("嗉" . "멀떠구니 소")
     ("埽" . "쓸 소, 그릴 소, 언덕 소")
     ("塐" . "塑와 同字")
     ("愬" . "고할 소, 참소할 소, 알릴 소")
     ("捎" . "덜 소, 흔들거릴 소, 추릴 소, 버릴 소")
     ("樔" . "풀막 소, 너스레 소")
     ("泝" . "거슬러 올라갈 소, 흘러갈 소")
     ("筱" . "가는 대 소")
     ("繅" . "고치 실 뽑을 소")
     ("翛" . "날개치는 소리 소, 모지라질 소")
     ("膆" . "살찔 소, 멀떠구니 소")
     ("艘" . "배 소")
     ("蛸" . "거미알 소, 연가시 알집 소")
     ("踈" . "疎의 譌字")
     ("酥" . "타락죽 소")
     ("霄" . "하늘 소, 진눈깨비 소")
     "鞘"
     ("魈" . "산도깨비 소")
     ("鮹" . "문어 소, 낙지 소")
     ("鰺" . "비린내 소의 譌字"))
    ("소가"
     "小家")
    ("소각"
     "燒却")
    ("소각로"
     "燒却爐")
    ("소각장"
     "燒却場")
    ("소감"
     "所感")
    ("소개"
     "疏開"
     "紹介")
    ("소개령"
     "疏開令")
    ("소개서"
     "紹介書")
    ("소격"
     "疏隔")
    ("소견"
     "所見")
    ("소견서"
     "所見書")
    ("소경전"
     "所耕田")
    ("소계보"
     "小系譜")
    ("소고"
     "小考")
    ("소곡"
     "小曲")
    ("소공동체"
     "小共同體")
    ("소공연"
     "小公演")
    ("소공원"
     "小公園")
    ("소관"
     "所管"
     "所關")
    ("소광장"
     "小廣場")
    ("소구"
     "訴求")
    ("소구경"
     "小口徑")
    ("소구력"
     "訴求力")
    ("소국"
     "小國"
     "小菊")
    ("소국가"
     "小國家")
    ("소국적"
     "小國的")
    ("소굴"
     "巢窟")
    ("소규모"
     "小規模")
    ("소규모적"
     "小規模的")
    ("소극"
     "笑劇")
    ("소극성"
     "消極性"
     "笑劇性")
    ("소극장"
     "小劇場")
    ("소극적"
     "消極的"
     "笑劇的")
    ("소극침주"
     "小隙沈舟")
    ("소급"
     "溯及")
    ("소기"
     "所期")
    ("소기업"
     "小企業")
    ("소녀"
     "少女")
    ("소년"
     "少年")
    ("소년기"
     "少年期")
    ("소년병"
     "少年兵")
    ("소년부"
     "少年部")
    ("소년원"
     "少年院")
    ("소농민"
     "小農民")
    ("소농민적"
     "小農民的")
    ("소농적"
     "小農的")
    ("소뇌"
     "小腦")
    ("소단원"
     "小單元")
    ("소대"
     "小隊")
    ("소대원"
     "小隊員")
    ("소대장"
     "小隊長")
    ("소도"
     "蘇塗")
    ("소도구"
     "小道具")
    ("소도시"
     "小都市")
    ("소독"
     "消毒")
    ("소독비"
     "消毒費")
    ("소독약"
     "消毒藥")
    ("소독제"
     "消毒劑")
    ("소독포"
     "消毒布")
    ("소동"
     "騷動")
    ("소두"
     "小斗")
    ("소득"
     "所得")
    ("소득세"
     "所得稅")
    ("소득세액"
     "所得稅額")
    ("소득세율"
     "所得稅率")
    ("소득자"
     "所得者")
    ("소득적"
     "所得的")
    ("소란"
     "騷亂")
    ("소량"
     "少量")
    ("소령"
     "少領")
    ("소로"
     "小爐"
     "小路")
    ("소론"
     "小論")
    ("소류지"
     "沼溜地")
    ("소리장도"
     "笑裏藏刀")
    ("소림"
     "疏林")
    ("소림일지"
     "巢林一枝")
    ("소립자"
     "素粒子")
    ("소만"
     "小滿")
    ("소망"
     "所望")
    ("소매"
     "小賣")
    ("소매가"
     "小賣價")
    ("소매상"
     "小賣商")
    ("소매업"
     "小賣業")
    ("소매업자"
     "小賣業者")
    ("소매점"
     "小賣店")
    ("소멸"
     "消滅")
    ("소명"
     "召命"
     "疏明")
    ("소모"
     "消耗")
    ("소모량"
     "消耗量")
    ("소모성"
     "消耗性")
    ("소모적"
     "消耗的")
    ("소모전"
     "消耗戰")
    ("소모품"
     "消耗品")
    ("소모품화"
     "消耗品化")
    ("소목"
     "小目")
    ("소묘전"
     "小錨展")
    ("소무"
     "小巫")
    ("소문"
     "所聞")
    ("소문능"
     "小紋綾")
    ("소문자"
     "小文字")
    ("소미지급"
     "燒眉之急")
    ("소박"
     "疏薄"
     "素朴")
    ("소박당"
     "素朴當")
    ("소반"
     "小盤")
    ("소방"
     "消防")
    ("소방관"
     "消防官")
    ("소방교"
     "消防校")
    ("소방서"
     "消防署")
    ("소방수"
     "消防手")
    ("소방장"
     "消防長")
    ("소방전"
     "蘇房典")
    ("소방차"
     "消防車")
    ("소백"
     "素白")
    ("소변"
     "小便")
    ("소변량"
     "小便量")
    ("소복"
     "素服")
    ("소부족"
     "小部族")
    ("소분류"
     "小分類")
    ("소불개의"
     "少不介意")
    ("소비"
     "消費")
    ("소비량"
     "消費量")
    ("소비력"
     "消費力")
    ("소비문화"
     "消費文化")
    ("소비성"
     "消費性")
    ("소비세"
     "消費稅")
    ("소비자"
     "消費者")
    ("소비자층"
     "消費者層")
    ("소비재"
     "消費財")
    ("소비적"
     "消費的")
    ("소비주의"
     "消費主義")
    ("소비주의적"
     "消費主義的")
    ("소비지"
     "消費地")
    ("소비층"
     "消費層")
    ("소비형"
     "消費型")
    ("소빙하기"
     "小氷河期")
    ("소사"
     "掃射"
     "燒死")
    ("소사전"
     "小辭典")
    ("소산"
     "所産")
    ("소산물"
     "所産物")
    ("소살"
     "燒殺")
    ("소상"
     "昭詳")
    ("소상인"
     "小商人")
    ("소상품"
     "小商品")
    ("소색"
     "素色")
    ("소생"
     "蘇生")
    ("소서"
     "小暑")
    ("소선거구"
     "小選擧區")
    ("소선거구제"
     "小選擧區制")
    ("소설"
     "小說"
     "小雪")
    ("소설가"
     "小說家")
    ("소설론"
     "小說論")
    ("소설적"
     "小說的")
    ("소설집"
     "小說集")
    ("소설책"
     "小說冊")
    ("소설화"
     "小說化")
    ("소소"
     "小小")
    ("소속"
     "所屬")
    ("소속감"
     "所屬感")
    ("소속원"
     "所屬員")
    ("소송"
     "訴訟")
    ("소수"
     "少數")
    ("소수인"
     "少數人")
    ("소수점"
     "小數點")
    ("소수층"
     "少數層")
    ("소수파"
     "少數派")
    ("소슬"
     "蕭瑟")
    ("소승"
     "小乘"
     "小僧")
    ("소승적"
     "小乘的")
    ("소시민"
     "小市民")
    ("소시민적"
     "小市民的")
    ("소시호탕"
     "小柴胡湯")
    ("소식"
     "小食"
     "消息")
    ("소식주의자"
     "小食主義者")
    ("소식지"
     "消息紙")
    ("소식통"
     "消息通")
    ("소신"
     "小臣"
     "所信")
    ("소실"
     "消失"
     "燒失")
    ("소심"
     "小心")
    ("소심증"
     "小心症")
    ("소아"
     "小兒")
    ("소아과"
     "小兒科")
    ("소아마비"
     "小兒痲痺")
    ("소아적"
     "小兒的")
    ("소액"
     "少額")
    ("소야곡"
     "小夜曲")
    ("소양"
     "素養")
    ("소연"
     "騷然")
    ("소엽"
     "小葉")
    ("소영웅주의"
     "小英雄主義")
    ("소외"
     "疏外")
    ("소외감"
     "疏外感")
    ("소외당"
     "疏外當")
    ("소외수"
     "小外水")
    ("소요"
     "所要"
     "騷擾")
    ("소용"
     "所用"
     "昭容")
    ("소우주"
     "小宇宙")
    ("소운동회"
     "小運動會")
    ("소원"
     "所願"
     "溯源"
     "疏遠"
     "素願"
     "訴願")
    ("소위"
     "小委"
     "少尉"
     "所謂")
    ("소위원회"
     "小委員會")
    ("소유"
     "所有")
    ("소유관계"
     "所有關係")
    ("소유권"
     "所有權")
    ("소유권자"
     "所有權者")
    ("소유론"
     "所有論")
    ("소유욕"
     "所有慾")
    ("소유자"
     "所有者")
    ("소유자적"
     "所有者的")
    ("소유자층"
     "所有者層")
    ("소유적"
     "所有的")
    ("소유제"
     "所有制")
    ("소유주"
     "所有主")
    ("소유지"
     "所有地")
    ("소유층"
     "所有層")
    ("소유화"
     "所有化")
    ("소음"
     "騷音")
    ("소음도"
     "消音度")
    ("소읍"
     "小邑")
    ("소인"
     "小人"
     "消印")
    ("소인국"
     "小人國")
    ("소인묵객"
     "騷人墨客")
    ("소일"
     "消日")
    ("소일변"
     "小一變")
    ("소임"
     "所任")
    ("소자"
     "小子"
     "素子")
    ("소자보"
     "小字報")
    ("소작"
     "小作")
    ("소작권"
     "小作權")
    ("소작농"
     "小作農")
    ("소작료"
     "小作料")
    ("소작인"
     "小作人")
    ("소작제"
     "小作制")
    ("소장"
     "小將"
     "少壯"
     "少將"
     "所藏"
     "所長"
     "訴狀")
    ("소장품"
     "所藏品")
    ("소재"
     "所在"
     "素材")
    ("소재벌"
     "小財閥")
    ("소재적"
     "素材的")
    ("소재지"
     "所在地")
    ("소전"
     "疏典")
    ("소절"
     "小節")
    ("소정"
     "所定")
    ("소제"
     "掃除")
    ("소제양난"
     "笑啼兩難")
    ("소조"
     "小組")
    ("소조산"
     "小祖山")
    ("소주"
     "燒酒")
    ("소주병"
     "燒酒甁")
    ("소주잔"
     "燒酒盞")
    ("소주제"
     "小主題")
    ("소중"
     "所重")
    ("소지"
     "所持"
     "素地")
    ("소지류"
     "小支流")
    ("소지역"
     "小地域")
    ("소지인"
     "所持人")
    ("소지자"
     "所持者")
    ("소지죄"
     "所持罪")
    ("소지품"
     "所持品")
    ("소지황금출"
     "掃地黃金出")
    ("소직"
     "小職")
    ("소진"
     "消盡"
     "燒盡")
    ("소질"
     "素質")
    ("소집"
     "召集")
    ("소집단"
     "小集團")
    ("소집단적"
     "小集團的")
    ("소집처"
     "召集處")
    ("소책자"
     "小冊子")
    ("소총"
     "小銃")
    ("소추"
     "訴追")
    ("소추권"
     "訴追權")
    ("소축적"
     "小蓄積")
    ("소축척"
     "小縮尺")
    ("소출"
     "所出")
    ("소치"
     "所致")
    ("소칠판"
     "小漆板")
    ("소탈"
     "疏脫")
    ("소탐대실"
     "小貪大失")
    ("소탕"
     "掃蕩")
    ("소탕령"
     "掃蕩令")
    ("소택지"
     "沼澤地")
    ("소통"
     "疏通")
    ("소포"
     "小包")
    ("소포장"
     "小包裝")
    ("소폭"
     "小幅")
    ("소폭화"
     "小幅化")
    ("소품"
     "小品")
    ("소풍"
     "逍風")
    ("소피"
     "小避"
     "所避")
    ("소필지"
     "小筆地")
    ("소학교"
     "小學校")
    ("소한"
     "小寒")
    ("소행"
     "所行")
    ("소형"
     "小型")
    ("소형선"
     "小型船")
    ("소형차"
     "小型車")
    ("소호"
     "小戶")
    ("소혼단장"
     "消魂斷腸")
    ("소홀"
     "疏忽")
    ("소화"
     "消化"
     "燒火")
    ("소화금"
     "小花錦")
    ("소화기"
     "消化器"
     "消火器")
    ("소화물"
     "小貨物")
    ("소화성"
     "消化性")
    ("소화어아금"
     "小花魚牙錦")
    ("소화전"
     "消火栓")
    ("소화제"
     "消化劑")
    ("소환"
     "召喚")
    ("소회"
     "所懷")
    ("소회의실"
     "小會議室")
    ("속"
     ("俗" . "익을 속, 버릇 속, 풍속 속, 세상 속")
     ("屬" . "무리 속, 좇을 속, 붙이 속, 거느릴 속")
     ("束" . "묶을 속, 단나무 속, 약속할 속, 비단 다섯끝 속")
     "涑"
     ("粟" . "좁쌀 속, 겉곡식 속")
     ("續" . "이을 속")
     "謖"
     ("贖" . "속바칠 속, 무역할 속")
     ("速" . "빠를 속, 부를 속, 더러울 속, 사슴 발자취 속")
     "洬"
     ("遬" . "공손할 속, 줄어들 속"))
    ("속가"
     "俗家")
    ("속개"
     "續開")
    ("속거천리"
     "速去千里")
    ("속결"
     "速決")
    ("속공"
     "速攻")
    ("속기"
     "速記")
    ("속기록"
     "速記錄")
    ("속기사"
     "速記士")
    ("속단"
     "速斷")
    ("속단단장"
     "續短斷長")
    ("속달"
     "速達")
    ("속담"
     "俗談")
    ("속도"
     "速度")
    ("속도감"
     "速度感")
    ("속도계"
     "速度計")
    ("속도비"
     "速度比")
    ("속도전"
     "速度戰")
    ("속독"
     "速讀")
    ("속등자이전"
     "速登者易顚")
    ("속락"
     "續落")
    ("속량"
     "贖良")
    ("속력"
     "速力")
    ("속마현거"
     "束馬懸車")
    ("속명"
     "俗名")
    ("속물"
     "俗物")
    ("속물적"
     "俗物的")
    ("속물화"
     "俗物化")
    ("속박"
     "束縛")
    ("속박당"
     "束縛當")
    ("속보"
     "速報")
    ("속설"
     "俗說")
    ("속성"
     "俗姓"
     "屬性"
     "續姓")
    ("속세"
     "俗世")
    ("속속"
     "續續")
    ("속수무책"
     "束手無策")
    ("속수지례"
     "束脩之禮")
    ("속식"
     "速食")
    ("속어"
     "俗語")
    ("속언"
     "俗諺")
    ("속음"
     "速飮")
    ("속인"
     "俗人")
    ("속전속결"
     "速戰速決")
    ("속죄"
     "贖罪")
    ("속죄양"
     "贖罪羊")
    ("속출"
     "續出")
    ("속칭"
     "俗稱")
    ("속편"
     "續篇"
     "續編")
    ("속행"
     "續行")
    ("속현"
     "屬縣")
    ("속홍관후"
     "粟紅貫朽")
    ("속회"
     "屬會")
    ("손"
     ("孫" . "손자 손, 움 돋을 손, 순할 손, 피할 손")
     ("巽" . "사양할 손, 낮은체 할 손, 부드러울 손, 괘 이름 손, 동과 남의 사이방향 손")
     ("損" . "덜 손, 잃을 손, 피곤할 손, 삼갈 손, 상할 손, 괘 이름 손")
     "蓀"
     ("遜" . "순할 손, 겸손할 손, 도망할 손, 사양할 손")
     ("飡" . "飱과 同字")
     "喰"
     ("飧" . "저녁밥 손, 물에 만 밥 손")
     ("飱" . "飧의 俗字"))
    ("손강영설"
     "孫康映雪")
    ("손녀"
     "孫女")
    ("손도"
     "損徒")
    ("손배소"
     "損賠訴")
    ("손보사"
     "損保社")
    ("손비"
     "損費")
    ("손상"
     "損傷")
    ("손상익하"
     "損上益下")
    ("손색"
     "遜色")
    ("손세탁"
     "­洗濯")
    ("손실"
     "損失")
    ("손실량"
     "損失量")
    ("손실액"
     "損失額")
    ("손익"
     "損益")
    ("손자"
     "孫子")
    ("손자삼요"
     "損者三樂")
    ("손자삼우"
     "損者三友")
    ("손재"
     "損財")
    ("손재수"
     "損財數")
    ("손해"
     "損害")
    ("손해액"
     "損害額")
    ("솔"
     ("率" . "거느릴 솔, 좇을 솔, 쓸 솔, 대강 솔, 공경할 솔, 뱀 이름 솔")
     ("窣" . "느릿느릿 걸을 솔, 우지직거릴 솔, 구멍으로 나올 솔")
     ("蟀" . "귀뚜라미 솔"))
    ("솔구이발"
     "率口而發")
    ("솔마이기"
     "率馬以驥")
    ("솔선"
     "率先")
    ("솔선수범"
     "率先垂範")
    ("솔성지위도"
     "率性之謂道")
    ("솔수식인"
     "率獸食人")
    ("솔직"
     "率直")
    ("솔토지빈"
     "率土之濱")
    ("송"
     ("宋" . "송나라 송, 성씨 송")
     ("悚" . "두려울 송, 송구할 송")
     ("松" . "소나무 송, 향풀 송, 땅이름 송")
     ("淞" . "강이름 송")
     ("訟" . "송사할 송, 시비할 송, 꾸짖을 송, 괘 이름 송")
     ("誦" . "풍유할 송, 읽을 송, 말할 송, 원망할 송")
     ("送" . "보낼 송, 가질 송, 활쏘기 능통할 송, 줄 송")
     ("頌" . "기릴 송, 칭송할 송, 찬양하는 노래 송")
     ("柗" . "松과 同字")
     ("竦" . "공경할 송, 두려울 송, 높일 송, 솟을 송")
     "菘"
     ("鬆" . "터럭 더부룩할 송"))
    ("송고"
     "送稿")
    ("송구"
     "悚懼")
    ("송구영신"
     "送舊迎新")
    ("송국주인"
     "松菊主人")
    ("송금"
     "送金")
    ("송기"
     "松肌")
    ("송달"
     "送達")
    ("송덕비"
     "頌德碑")
    ("송도삼절"
     "松都三絶")
    ("송림"
     "松林")
    ("송무백열"
     "松茂柏悅")
    ("송백지무"
     "松柏之茂")
    ("송별"
     "送別")
    ("송별회"
     "送別會")
    ("송사"
     "訟事")
    ("송수관"
     "送水管")
    ("송수신"
     "送受信")
    ("송수신자"
     "送受信者")
    ("송수화기"
     "送受話器")
    ("송신"
     "送信")
    ("송신기"
     "送信機")
    ("송신소"
     "送信所")
    ("송양지인"
     "宋襄之仁")
    ("송연"
     "悚然")
    ("송유"
     "松油")
    ("송유관"
     "送油管")
    ("송전"
     "送電")
    ("송조"
     "宋朝")
    ("송죽"
     "松竹")
    ("송죽매"
     "松竹梅")
    ("송죽지절"
     "松竹之節")
    ("송진"
     "松津")
    ("송차"
     "松茶")
    ("송충"
     "松蟲")
    ("송치"
     "送致")
    ("송판"
     "松板")
    ("송풍"
     "松風")
    ("송풍구"
     "送風口")
    ("송풍기"
     "送風機")
    ("송풍수월"
     "松風水月")
    ("송학"
     "宋學")
    ("송화"
     "松花")
    ("송화색별문능"
     "松花色別紋綾")
    ("송환"
     "送還")
    ("솨"
     ("惢" . "의심낼 솨"))
    ("쇄"
     ("刷" . "긁을 쇄, 고칠 쇄, 빗을 쇄, 문지를 쇄")
     ("灑" . "뿌릴 쇄, 깜짝 놀랄 쇄")
     ("碎" . "부술 쇄, 잘 쇄")
     ("鎖" . "자물쇠 쇄, 쇠사슬 쇄, 가둘 쇄, 항쇄 쇄")
     ("殺" . "내릴 쇄, 감할 쇄, 빠를 쇄")
     "曬"
     "洒"
     ("瑣" . "옥가루 쇄, 가늘 쇄, 좀스러울 쇄, 대궐문 아로새길 쇄"))
    ("쇄골분신"
     "碎骨粉身")
    ("쇄도"
     "殺到")
    ("쇄두편관"
     "殺頭便冠")
    ("쇄소응대"
     "灑掃應對")
    ("쇄신"
     "刷新")
    ("쇠"
     ("衰" . "쇠할 쇠, 모손할 쇠, 약할 쇠")
     "釗")
    ("쇠락"
     "衰落")
    ("쇠약"
     "衰弱")
    ("쇠잔"
     "衰殘")
    ("쇠퇴"
     "衰退")
    ("쇠퇴기"
     "衰退期")
    ("수"
     ("修" . "닦을 수, 옳게할 수, 정리할 수, 꾸밀 수")
     ("受" . "이을 수, 얻을 수, 담을 수, 받을 수")
     ("嗽" . "기침할 수, 입가실 수")
     "嗾"
     ("囚" . "가둘 수, 갇힐 수, 묶일 수")
     ("垂" . "드리울 수, 변방 수, 거의 수, 남길 수")
     ("壽" . "목숨 수, 장수할 수, 나이 수, 축복할 수")
     ("嫂" . "형수 수")
     ("守" . "지킬 수, 보살필 수, 원님 수, 기다릴 수")
     ("岫" . "바위구멍 수")
     ("峀" . "岫와 同字")
     ("帥" . "주장할 수, 장수 수")
     ("愁" . "근심 수, 염려할 수, 탄식할 수")
     ("戍" . "수자리 수, 막을 수, 집 수")
     ("手" . "손 수, 잡을 수, 칠 수")
     ("授" . "줄 수, 부칠 수")
     ("搜" . "찾을 수, 더듬을 수, 화살 빨리 가는 소리 수, 어지러울 수")
     ("收" . "모을 수, 거둘 수, 잡을 수, 수레바퀴 수")
     ("數" . "헤아릴 수, 수죄할 수, 몇 수, 이치 수")
     ("樹" . "나무 수, 막을 수, 세울 수, 심을 수")
     ("殊" . "죽을 수, 베일 수, 끊어질 수, 지나갈 수")
     ("水" . "물 수, 고를 수")
     ("洙" . "물가 수, 물읾 수")
     "涑"
     ("漱" . "양치질할 수, 빨래할 수")
     ("燧" . "봉화 수, 불 수, 나무 문질러 불낼 수")
     ("狩" . "겨울사냥 수, 순행할 수")
     ("獸" . "짐승 수")
     ("琇" . "귀막이 수, 옥돌 수")
     ("璲" . "서옥 수, 패옥 수")
     ("瘦" . "파리할 수, 가늘 수")
     ("睡" . "졸음 수, 잠 수")
     ("秀" . "빼어날 수, 이삭 수, 벼 패일 수, 아름다울 수")
     ("穗" . "이삭 수")
     ("竪" . "세울 수, 서있을 수, 더벅머리 수")
     ("粹" . "정할 수, 순수할 수")
     ("綏" . "편안할 수, 수레고삐 수, 물러갈 수, 여우모양 수")
     ("綬" . "인끈 수")
     ("繡" . "수놓을 수, 성씨 수")
     ("羞" . "부끄러울 수, 음식 수")
     ("脩" . "포 수, 길 수, 마를 수")
     ("茱" . "수유 수")
     ("蒐" . "꼭두서니 수, 모을 수, 숨을 수, 찾을 수")
     "蓚"
     ("藪" . "큰 늪 수, 덤불 수, 똬리 수")
     ("袖" . "소매 수")
     ("誰" . "누구 수, 무엇 수")
     ("讐" . "讎와 同字")
     ("輸" . "떨어뜨릴 수, 쏟을 수, 보낼 수, 짐바리 수")
     ("遂" . "사무칠 수, 나아갈 수, 이룰 수, 마침내 수")
     ("邃" . "깊숙할 수")
     ("酬" . "술 권할 수, 갚을 수")
     ("銖" . "저울눈 수")
     ("銹" . "동록 수")
     ("隋" . "수나라 수")
     ("隧" . "무덤길 수, 구멍 수, 길 수")
     ("隨" . "따를 수, 괘 이름 수, 나라이름 수, 맡길 수")
     ("雖" . "비록 수, 벌레이름 수")
     ("需" . "음식 수, 머뭇거릴 수, 기다릴 수, 찾을 수, 괘 이름 수")
     ("須" . "수염 수, 기다릴 수")
     ("首" . "머리 수, 먼저 수, 비롯할 수, 임금 수, 향할 수, 자백할 수")
     ("髓" . "뼛속 기름 수, 마음속 수")
     ("鬚" . "턱수염 수, 아랫수염 수")
     ("叟" . "어른 수, 쌀 씻는 소리 수")
     ("售" . "팔 수, 갚을 수")
     ("廋" . "숨길 수")
     "晬"
     "殳"
     "泅"
     ("溲" . "오줌 수, 반족할 수, 적실 수")
     "濉"
     ("睟" . "똑바로 볼 수, 윤택할 수")
     ("瞍" . "소경 수, 장님 수, 판수 수")
     ("祟" . "빌미 수")
     ("籔" . "조리 수, 곡식 세는 단위 휘 수, 또아리 수")
     ("脺" . "얼굴 윤택할 수, 머리덜미 수")
     ("膄" . "파리할 수")
     ("膸" . "髓와 同字")
     "莠"
     ("讎" . "짝 수, 원수 수, 대거리할 수, 비교할 수, 갚을 수")
     ("豎" . "세울 수, 내시 수, 더벅머리 수")
     "酥"
     ("陲" . "변방 수, 위태할 수")
     ("颼" . "바람소리 수")
     ("饈" . "드릴 수, 반찬 수"))
    ("수가"
     "酬價")
    ("수간모옥"
     "數間茅屋")
    ("수감"
     "收監")
    ("수감자"
     "收監者")
    ("수갑"
     "手匣")
    ("수강"
     "受講")
    ("수강료"
     "受講料")
    ("수강생"
     "受講生")
    ("수강자"
     "受講者")
    ("수강증"
     "受講證")
    ("수개월"
     "數個月")
    ("수거"
     "收去")
    ("수거량"
     "收去量")
    ("수거비"
     "收去費")
    ("수거장"
     "收去場")
    ("수거함"
     "收去函")
    ("수건"
     "手巾")
    ("수결"
     "手決")
    ("수계"
     "水界"
     "水系")
    ("수고"
     "樹高")
    ("수공"
     "手工"
     "水攻")
    ("수공업"
     "手工業")
    ("수공업자"
     "手工業者")
    ("수공예품"
     "手工藝品")
    ("수공품"
     "手工品")
    ("수관"
     "樹冠")
    ("수광"
     "受光")
    ("수광즉어유"
     "水廣則魚遊")
    ("수괴"
     "首魁")
    ("수교"
     "修交")
    ("수구"
     "守舊"
     "水球")
    ("수구여병"
     "守口如甁")
    ("수구적"
     "守舊的")
    ("수구초심"
     "首邱初心")
    ("수군"
     "水軍")
    ("수권"
     "授權"
     "水圈")
    ("수금"
     "收金")
    ("수급"
     "受給"
     "收給"
     "需給")
    ("수긍"
     "首肯")
    ("수기"
     "手記")
    ("수기집"
     "手記集")
    ("수기치인"
     "修己治人")
    ("수난"
     "受難")
    ("수난사"
     "受難史")
    ("수납"
     "收納")
    ("수납장"
     "收納欌")
    ("수납함"
     "受納函")
    ("수녀"
     "修女")
    ("수년"
     "數年")
    ("수뇌"
     "首腦")
    ("수뇌부"
     "首腦部")
    ("수능"
     "受能")
    ("수능식"
     "受能式")
    ("수단"
     "手段")
    ("수단화"
     "手段化")
    ("수달피"
     "水獺皮")
    ("수당"
     "手當")
    ("수도"
     "修道"
     "囚徒"
     "水道"
     "首都")
    ("수도거성"
     "水到渠成")
    ("수도관"
     "水道管")
    ("수도권"
     "首都圈")
    ("수도성"
     "首都性")
    ("수도세"
     "水道稅")
    ("수도승"
     "修道僧")
    ("수도원"
     "修道院")
    ("수도자"
     "修道者")
    ("수도회"
     "修道會")
    ("수돗"
     "水道")
    ("수동"
     "受動"
     "手動"
     "樹洞")
    ("수동성"
     "受動性")
    ("수동식"
     "手動式")
    ("수동적"
     "受動的")
    ("수동화"
     "受動化")
    ("수두색이"
     "垂頭塞耳")
    ("수라장"
     "修羅場")
    ("수락"
     "受諾")
    ("수락석출"
     "水落石出")
    ("수량"
     "數量")
    ("수려"
     "秀麗")
    ("수력"
     "水力")
    ("수련"
     "修鍊"
     "睡蓮")
    ("수련원"
     "修鍊院")
    ("수련의"
     "修鍊醫")
    ("수련장"
     "修練帳"
     "首鍊匠")
    ("수련회"
     "修鍊會")
    ("수렴"
     "收斂")
    ("수렴주의"
     "收斂主義")
    ("수렴청정"
     "垂簾聽政")
    ("수렵"
     "狩獵")
    ("수렵군"
     "狩獵群")
    ("수렵도"
     "狩獵圖")
    ("수렵무"
     "狩獵舞")
    ("수렵민"
     "狩獵民")
    ("수렵자"
     "狩獵者")
    ("수령"
     "受領"
     "守令"
     "樹齡"
     "首領")
    ("수령액"
     "受領額")
    ("수령인"
     "受領人")
    ("수로"
     "水路")
    ("수록"
     "收錄")
    ("수뢰"
     "受賂")
    ("수뢰설"
     "受賂說")
    ("수료"
     "修了")
    ("수료생"
     "修了生")
    ("수류운공"
     "水流雲空")
    ("수류탄"
     "手榴彈")
    ("수륙"
     "水陸")
    ("수리"
     "修理"
     "受理"
     "數理"
     "水利")
    ("수리공"
     "修理工")
    ("수리비"
     "修理費")
    ("수리적"
     "數理的")
    ("수리점"
     "修理店")
    ("수리학"
     "水理學")
    ("수리학자"
     "水理學者")
    ("수림"
     "樹林")
    ("수립"
     "樹立")
    ("수마"
     "水魔")
    ("수만"
     "數萬")
    ("수매"
     "收買")
    ("수매가"
     "收買價")
    ("수매량"
     "收買量")
    ("수면"
     "水面"
     "睡眠")
    ("수면권"
     "睡眠權")
    ("수면제"
     "睡眠劑")
    ("수명"
     "壽命")
    ("수모"
     "受侮")
    ("수목"
     "樹木")
    ("수목원"
     "樹木園")
    ("수몰"
     "水沒")
    ("수무족도"
     "手舞足蹈")
    ("수묵"
     "水墨")
    ("수묵화"
     "水墨畵")
    ("수문"
     "水門")
    ("수문장"
     "守門將")
    ("수미"
     "須彌")
    ("수미상응"
     "首尾相應")
    ("수밀비"
     "水密扉")
    ("수박"
     "手搏")
    ("수반"
     "水盤"
     "隨伴"
     "首班")
    ("수발"
     "受發")
    ("수배"
     "手配")
    ("수배자"
     "手配者")
    ("수백"
     "數百")
    ("수백만"
     "數百萬")
    ("수백억"
     "數百億")
    ("수범"
     "垂範")
    ("수법"
     "手法")
    ("수병좌"
     "水甁座")
    ("수병투약"
     "隨病投藥")
    ("수복"
     "收復")
    ("수복강녕"
     "壽福康寧")
    ("수분"
     "受粉"
     "水分")
    ("수분량"
     "水分量")
    ("수불석권"
     "手不釋卷")
    ("수비"
     "守備")
    ("수비대"
     "守備隊")
    ("수비대원"
     "守備隊員")
    ("수비력"
     "守備力")
    ("수비벽"
     "守備壁")
    ("수비수"
     "守備手")
    ("수비진"
     "守備陣")
    ("수사"
     "修士"
     "修辭"
     "搜査")
    ("수사과"
     "搜査課")
    ("수사과장"
     "搜査課長")
    ("수사관"
     "搜査官")
    ("수사국"
     "搜査局")
    ("수사권"
     "搜査權")
    ("수사대"
     "搜査隊")
    ("수사력"
     "搜査力")
    ("수사반"
     "搜査班")
    ("수사법"
     "修辭法")
    ("수사본부"
     "搜査本部")
    ("수사부"
     "搜査部")
    ("수사설"
     "搜査說")
    ("수사학"
     "修辭學")
    ("수산"
     "水産")
    ("수산물"
     "水産物")
    ("수산업"
     "水産業")
    ("수산화"
     "水酸化")
    ("수삼"
     "數三"
     "水蔘")
    ("수상"
     "受賞"
     "殊常"
     "水上"
     "首相")
    ("수상감"
     "受賞感")
    ("수상기"
     "受像機")
    ("수상록"
     "隨想錄")
    ("수상불변"
     "守常不變")
    ("수상실"
     "首相室")
    ("수상자"
     "受賞者")
    ("수상작"
     "受賞作")
    ("수색"
     "搜索")
    ("수색대"
     "搜索隊")
    ("수서과"
     "受書課")
    ("수서과장"
     "受書課長")
    ("수서양단"
     "首鼠兩端")
    ("수석"
     "水石"
     "首席")
    ("수석대표"
     "首席代表")
    ("수석실"
     "首席室")
    ("수선"
     "修繕")
    ("수설불통"
     "水泄不通")
    ("수성"
     "守城"
     "守成"
     "水性"
     "水星")
    ("수성부화"
     "隨聲附和")
    ("수성암"
     "水成巖")
    ("수세"
     "守勢")
    ("수세식"
     "水洗式")
    ("수세적"
     "守勢的")
    ("수소"
     "水素")
    ("수소문"
     "搜所聞")
    ("수속"
     "手續")
    ("수송"
     "輸送")
    ("수송기"
     "輸送機")
    ("수송대장"
     "輸送隊長")
    ("수송량"
     "輸送量")
    ("수송부"
     "輸送部")
    ("수송선"
     "輸送船")
    ("수송차"
     "輸送車")
    ("수송함"
     "輸送艦")
    ("수수"
     "收受")
    ("수수료"
     "手數料")
    ("수수료율"
     "手數料率")
    ("수수방관"
     "袖手傍觀")
    ("수수상면"
     "囚首喪面")
    ("수순"
     "手順")
    ("수술"
     "手術")
    ("수술대"
     "手術臺")
    ("수술료"
     "手術料")
    ("수술률"
     "手術率")
    ("수술법"
     "手術法")
    ("수술비"
     "手術費")
    ("수술실"
     "手術室")
    ("수술진"
     "手術陣")
    ("수습"
     "修習"
     "收拾")
    ("수습기자"
     "修習記者")
    ("수습사원"
     "修習社員")
    ("수습제"
     "修習制")
    ("수습책"
     "收拾策")
    ("수시"
     "隨時")
    ("수시력"
     "授時曆")
    ("수식"
     "修飾"
     "數式")
    ("수식어"
     "修飾語")
    ("수신"
     "受信")
    ("수신고"
     "受信庫")
    ("수신기"
     "受信機")
    ("수신반"
     "受信班")
    ("수신분리"
     "首身分離")
    ("수신인"
     "受信人")
    ("수신자"
     "受信者")
    ("수신제가"
     "修身齊家")
    ("수심"
     "修心"
     "愁心"
     "水深")
    ("수심어취"
     "水深魚聚")
    ("수십"
     "數十")
    ("수십만"
     "數十萬")
    ("수십억"
     "數十億")
    ("수악한"
     "手握汗")
    ("수압"
     "水壓")
    ("수액"
     "樹液"
     "水液")
    ("수양"
     "修養"
     "垂楊"
     "收養")
    ("수양법"
     "修養法")
    ("수어"
     "守禦")
    ("수어지교"
     "水魚之交")
    ("수억"
     "數億")
    ("수억만"
     "數億萬")
    ("수업"
     "修業"
     "受業"
     "授業")
    ("수업료"
     "授業料")
    ("수여"
     "授與")
    ("수여비봉"
     "首如飛蓬")
    ("수여자"
     "授與者")
    ("수역"
     "水域")
    ("수염"
     "鬚髥")
    ("수영"
     "水泳")
    ("수영복"
     "水泳服")
    ("수영장"
     "水泳場")
    ("수예품"
     "手藝品")
    ("수오지심"
     "羞惡之心")
    ("수온"
     "水溫")
    ("수완"
     "手腕")
    ("수요"
     "需要")
    ("수요력"
     "需要力")
    ("수요일"
     "水曜日")
    ("수요자"
     "需要者")
    ("수요자층"
     "需要者層")
    ("수요처"
     "需要處")
    ("수요층"
     "需要層")
    ("수용"
     "受容"
     "收容"
     "收用")
    ("수용당"
     "收容當")
    ("수용도"
     "收用度")
    ("수용산출"
     "水湧山出")
    ("수용성"
     "水溶性")
    ("수용소"
     "收容所")
    ("수용소식"
     "收容所式")
    ("수용자"
     "收容者")
    ("수용적"
     "受容的")
    ("수우죽백"
     "垂于竹帛")
    ("수운"
     "水運")
    ("수원수구"
     "誰怨誰咎")
    ("수원지"
     "水源地"
     "水源池")
    ("수월경화"
     "水月鏡花")
    ("수위"
     "守衛"
     "水位"
     "首位")
    ("수위실"
     "守衛室")
    ("수유"
     "授乳")
    ("수유아"
     "授乳兒")
    ("수은"
     "水銀")
    ("수은등"
     "水銀燈")
    ("수은제"
     "水銀劑")
    ("수은주"
     "水銀柱")
    ("수의"
     "囚衣"
     "壽衣"
     "隨意")
    ("수의사"
     "獸醫師")
    ("수이부실"
     "秀而不實")
    ("수익"
     "收益")
    ("수익금"
     "收益金")
    ("수익률"
     "收益率")
    ("수익성"
     "收益性")
    ("수익액"
     "收益額")
    ("수익자"
     "受益者")
    ("수인"
     "囚人")
    ("수일"
     "數日")
    ("수임"
     "受任")
    ("수임료"
     "授任料")
    ("수임위"
     "受任委")
    ("수입"
     "收入"
     "輸入")
    ("수입국"
     "輸入國")
    ("수입량"
     "輸入量")
    ("수입물"
     "輸入物")
    ("수입산"
     "輸入産")
    ("수입액"
     "收入額"
     "輸入額")
    ("수입원"
     "收入源")
    ("수입자"
     "收入者")
    ("수입품"
     "輸入品")
    ("수자상"
     "壽者相")
    ("수자원"
     "水資源")
    ("수작"
     "秀作"
     "酬酌")
    ("수작업"
     "手作業")
    ("수장"
     "收藏"
     "水葬"
     "首長")
    ("수장국"
     "首長國")
    ("수장적구"
     "搜章摘句")
    ("수재"
     "收財"
     "水災")
    ("수재민"
     "水災民")
    ("수재죄"
     "受財罪")
    ("수적"
     "數的")
    ("수적석천"
     "水滴石穿")
    ("수적성천"
     "水積成川")
    ("수전증"
     "手顫症")
    ("수절"
     "守節")
    ("수정"
     "修整"
     "修正"
     "修訂"
     "受精"
     "水晶")
    ("수정란"
     "受精卵")
    ("수정안"
     "修正案")
    ("수정주의"
     "修正主義")
    ("수정주의자"
     "修正主義者")
    ("수정체"
     "水晶體")
    ("수제"
     "數制")
    ("수제자"
     "首弟子")
    ("수조"
     "受租"
     "數兆"
     "水槽")
    ("수조권"
     "收租權")
    ("수조권론"
     "收租權論")
    ("수조권설"
     "收租權說")
    ("수조권자"
     "收租權者")
    ("수조권적"
     "收租權的")
    ("수조론"
     "收租論")
    ("수조지"
     "收租地")
    ("수족"
     "手足")
    ("수족관"
     "水族館")
    ("수족궐냉"
     "手足厥冷")
    ("수족지애"
     "手足之愛")
    ("수종"
     "樹種")
    ("수주"
     "受注"
     "水紬")
    ("수주대토"
     "守株待兎")
    ("수주액"
     "受注額")
    ("수주전"
     "受注戰")
    ("수준"
     "水準")
    ("수준급"
     "水準級")
    ("수준작"
     "水準作")
    ("수중"
     "手中"
     "水中")
    ("수중고혼"
     "水中孤魂")
    ("수중전"
     "水中戰")
    ("수즉다욕"
     "壽則多辱")
    ("수증기"
     "水蒸氣")
    ("수지"
     "手指"
     "收支"
     "樹脂")
    ("수지청무어"
     "水至淸無魚")
    ("수지침"
     "手指鍼")
    ("수직"
     "垂直")
    ("수직선"
     "垂直線")
    ("수직적"
     "垂直的")
    ("수직주의"
     "垂直主義")
    ("수직형"
     "垂直型")
    ("수질"
     "水質")
    ("수집"
     "收集"
     "蒐集")
    ("수집가"
     "蒐集家")
    ("수집광"
     "蒐集狂")
    ("수집량"
     "收集量")
    ("수집상"
     "蒐集商")
    ("수집소"
     "收集所")
    ("수집인"
     "收集人")
    ("수차"
     "數次")
    ("수차례"
     "數次例")
    ("수채"
     "水彩")
    ("수채화"
     "水彩畵")
    ("수척"
     "瘦瘠")
    ("수천"
     "數千")
    ("수천만"
     "數千萬")
    ("수천수만"
     "數千數萬")
    ("수천억"
     "數千億")
    ("수첩"
     "手帖")
    ("수초"
     "水草")
    ("수축"
     "收縮")
    ("수축감"
     "收縮感")
    ("수출"
     "輸出")
    ("수출과"
     "輸出課")
    ("수출국"
     "輸出國")
    ("수출량"
     "輸出量")
    ("수출액"
     "輸出額")
    ("수출업체"
     "輸出業體")
    ("수출입"
     "輸出入")
    ("수출품"
     "輸出品")
    ("수취"
     "受取"
     "收取"
     "收聚")
    ("수취인"
     "受取人")
    ("수취조산"
     "獸聚鳥散")
    ("수치"
     "數値"
     "羞恥")
    ("수치심"
     "羞恥心")
    ("수칙"
     "守則")
    ("수탁고"
     "受託庫")
    ("수탈"
     "收奪")
    ("수탈당"
     "收奪當")
    ("수탈론"
     "收奪論")
    ("수탈자"
     "收奪者")
    ("수탈적"
     "收奪的")
    ("수태"
     "受胎")
    ("수태일"
     "受胎日")
    ("수통"
     "水桶")
    ("수평"
     "水平")
    ("수평면"
     "水平面")
    ("수평선"
     "水平線")
    ("수평적"
     "水平的")
    ("수평주의"
     "水平主義")
    ("수포"
     "水泡")
    ("수포성"
     "水疱性")
    ("수포형"
     "水疱型")
    ("수폭"
     "水爆")
    ("수표"
     "手票")
    ("수필"
     "隨筆")
    ("수필가"
     "隨筆家")
    ("수필계"
     "隨筆界")
    ("수필집"
     "隨筆集")
    ("수하"
     "手下")
    ("수하친병"
     "手下親兵")
    ("수학"
     "修學"
     "受學"
     "數學")
    ("수학여행"
     "修學旅行")
    ("수학여행지"
     "修學旅行地")
    ("수학자"
     "數學者")
    ("수학적"
     "數學的")
    ("수한충박상"
     "水旱蟲雹霜")
    ("수해"
     "水害")
    ("수행"
     "修行"
     "遂行"
     "隨行")
    ("수행과장"
     "隨行課長")
    ("수행법"
     "修行法")
    ("수행실장"
     "隨行室長")
    ("수행실장실"
     "隨行室長室")
    ("수행원"
     "隨行員")
    ("수행자"
     "修行者")
    ("수향입향"
     "隨鄕入鄕")
    ("수험"
     "受驗")
    ("수험생"
     "受驗生")
    ("수험표"
     "受驗票")
    ("수혈"
     "輸血")
    ("수혜"
     "受惠")
    ("수혜자"
     "受惠者")
    ("수호"
     "守護")
    ("수호신"
     "守護神")
    ("수호자"
     "守護者")
    ("수호초"
     "秀好草")
    ("수화"
     "手話")
    ("수화기"
     "受話器")
    ("수화무교"
     "水火無交")
    ("수화상극"
     "水火相克")
    ("수화수채"
     "受和受采")
    ("수화폐월"
     "羞花閉月")
    ("수확"
     "收穫")
    ("수확고"
     "收穫高")
    ("수확기"
     "收穫期")
    ("수확량"
     "收穫量")
    ("수확물"
     "收穫物")
    ("수확분"
     "收穫分")
    ("수확제"
     "收穫祭")
    ("수회"
     "數回")
    ("수효"
     "數爻")
    ("수훈"
     "殊勳"
     "首勳")
    ("숙"
     ("叔" . "아재비 숙, 주울 숙, 어릴 숙, 끝 숙")
     ("塾" . "사랑방 숙, 기숙사 숙")
     ("夙" . "이를 숙, 이미 숙, 빠를 숙, 일찍 일어날 숙")
     ("孰" . "누구 숙, 어느 숙, 살필 숙, 익을 숙")
     ("宿" . "잘 숙, 지킬 숙, 머물 숙")
     ("淑" . "맑을 숙, 착할 숙, 사모할 숙")
     "潚"
     ("熟" . "익힐 숙, 삶을 숙, 풍년들 숙")
     "琡"
     "璹"
     ("肅" . "공손할 숙, 공경할 숙, 경계할 숙")
     "菽"
     ("俶" . "비롯할 숙, 처음 숙, 지을 숙")
     ("倏" . "잠간 숙, 홀연 숙, 개의 빨리 달리는 모양 숙")
     ("儵" . "잿빛 숙, 남해 임금 숙, 독화당할 숙, 갑자기 숙")
     ("婌" . "궁녀 벼슬이름 숙")
     ("橚" . "길고 꼿꼿할 숙")
     ("驌" . "좋은말 숙, 숙상말 숙")
     ("鷫" . "숙상새 숙"))
    ("숙견"
     "熟絹")
    ("숙고"
     "熟考")
    ("숙고사"
     "熟庫紗")
    ("숙과"
     "熟果")
    ("숙녀"
     "淑女")
    ("숙녀복"
     "淑女服")
    ("숙능어지"
     "孰能禦之")
    ("숙단"
     "熟緞")
    ("숙달"
     "熟達")
    ("숙독"
     "熟讀")
    ("숙독완미"
     "熟讀玩味")
    ("숙련"
     "熟鍊")
    ("숙련가"
     "熟鍊家")
    ("숙련공"
     "熟鍊工")
    ("숙련도"
     "熟鍊度")
    ("숙련자"
     "熟鍊者")
    ("숙맥"
     "菽麥")
    ("숙맥불변"
     "菽麥不辨")
    ("숙면"
     "熟眠")
    ("숙명"
     "宿命")
    ("숙명론적"
     "宿命論的")
    ("숙명성"
     "宿命性")
    ("숙명적"
     "宿命的")
    ("숙명주"
     "熟明紬")
    ("숙박"
     "宿泊")
    ("숙박료"
     "宿泊料")
    ("숙박비"
     "宿泊費")
    ("숙박업소"
     "宿泊業所")
    ("숙배"
     "肅拜")
    ("숙변"
     "宿便")
    ("숙부"
     "叔父")
    ("숙불환생"
     "熟不還生")
    ("숙서식동"
     "宿西食東")
    ("숙성"
     "熟成")
    ("숙소"
     "宿所")
    ("숙수"
     "熟手")
    ("숙수지공"
     "菽水之供")
    ("숙시주의"
     "熟柿主義")
    ("숙식"
     "宿食")
    ("숙식비"
     "宿食費")
    ("숙어"
     "熟語")
    ("숙연"
     "肅然")
    ("숙원"
     "宿願")
    ("숙위"
     "宿衛")
    ("숙의"
     "淑儀"
     "熟議")
    ("숙적"
     "宿敵")
    ("숙정"
     "肅正")
    ("숙제"
     "宿題")
    ("숙제물"
     "宿題物")
    ("숙주"
     "宿主")
    ("숙지"
     "熟知")
    ("숙직"
     "宿直")
    ("숙직실"
     "宿直室")
    ("숙직자"
     "宿直者")
    ("숙질"
     "叔姪")
    ("숙청"
     "肅淸")
    ("숙청당"
     "肅淸當")
    ("숙취"
     "熟醉")
    ("숙항라"
     "熟亢羅")
    ("숙호충비"
     "宿虎衝鼻")
    ("숙환"
     "宿患")
    ("숙흥야매"
     "夙興夜寐")
    ("순"
     "唇"
     ("巡" . "돌 순, 순행할 순, 두루 순")
     ("徇" . "조리 돌릴 순, 따라 죽을 순, 빠를 순, 부릴 순")
     ("循" . "좇을 순, 의지할 순, 돌 순, 차례 순, 돌아다닐 순")
     ("恂" . "진실할 순, 믿을 순, 온공스러울 순")
     ("旬" . "열흘 순, 두루할 순, 고를 순, 가득할 순, 요사스런 별 순")
     ("栒" . "경쇠걸이 순, 순나무 순")
     ("楯" . "난간 순, 방패 순, 뺄 순, 상여 순")
     ("橓" . "무궁화나무 순")
     ("殉" . "죽은 사람을 따라 죽을 순, 구할 순, 좇을 순")
     ("洵" . "웅덩이물 순, 소리없이 눈물흘릴 순, 믿을 순")
     ("淳" . "맑을 순, 순박할 순")
     "焞"
     ("珣" . "옥그릇 순, 옥 이름 순")
     ("盾" . "방패 순, 벼슬이름 순")
     ("瞬" . "눈 깜작일 순, 잠깐 순")
     ("筍" . "죽순 순, 대싹 순")
     ("純" . "실 순, 순수할 순, 온전할 순, 부드러울 순")
     ("脣" . "입술 순")
     ("舜" . "순임금 순, 무궁화 순")
     ("荀" . "풀 이름 순, 성씨 순")
     ("蓴" . "순나물 순")
     ("蕣" . "무궁화 순")
     ("詢" . "꾀할 순, 물을 순, 믿을 순")
     ("諄" . "거듭 일러줄 순, 지극할 순")
     ("醇" . "전국술 순, 두터울 순, 삼갈 순, 순수할 순")
     ("錞" . "사발종 순")
     ("順" . "좇을 순, 부드러울 순, 차례 순, 성씨 순")
     ("馴" . "길들일 순, 착할 순")
     ("侚" . "좇을 순, 빠를 순, 조리 돌릴 순")
     ("狥" . "徇의 俗字")
     ("盹" . "눈 감을 순, 졸 순")
     ("眴" . "눈짓할 순")
     ("紃" . "신에 실선 두를 순, 실 띠 순, 법 순, 좇을 순")
     ("肫" . "광대뼈 순, 정성스러울 순")
     "駨"
     ("鬊" . "머리 풀어헤칠 순")
     ("鶉" . "메추라기 순, 옷 해질 순"))
    ("순간"
     "瞬間")
    ("순간순간"
     "瞬間瞬間")
    ("순간적"
     "瞬間的")
    ("순검"
     "巡檢")
    ("순검청"
     "巡檢廳")
    ("순결"
     "純潔")
    ("순결무구"
     "純潔無垢")
    ("순경"
     "巡警")
    ("순교"
     "殉敎")
    ("순교자"
     "殉敎者")
    ("순국"
     "殉國")
    ("순국선열"
     "殉國先烈")
    ("순금제"
     "純金製")
    ("순기능"
     "順機能")
    ("순례"
     "巡禮")
    ("순례자"
     "巡禮者")
    ("순리"
     "順理")
    ("순리적"
     "順理的")
    ("순림"
     "純林")
    ("순망치한"
     "脣亡齒寒")
    ("순무대장"
     "巡撫大將")
    ("순박"
     "淳朴")
    ("순발력"
     "瞬發力")
    ("순방"
     "巡訪")
    ("순배"
     "巡杯")
    ("순백"
     "純白")
    ("순백색"
     "純白色")
    ("순백자"
     "純白瓷")
    ("순번"
     "順番")
    ("순번제"
     "順番制")
    ("순부치락"
     "脣腐齒落")
    ("순사"
     "巡査")
    ("순사보"
     "巡査補")
    ("순산"
     "順産")
    ("순서"
     "順序")
    ("순서도"
     "順序圖")
    ("순수"
     "純粹")
    ("순수성"
     "純粹性")
    ("순수시"
     "純粹詩")
    ("순수익"
     "純收益")
    ("순수입"
     "純收入")
    ("순수주의"
     "純粹主義")
    ("순수주의적"
     "純粹主義的")
    ("순순"
     "順順")
    ("순시"
     "巡視")
    ("순시선"
     "巡視船")
    ("순식간"
     "瞬息間")
    ("순애보적"
     "殉愛譜的")
    ("순연"
     "順延")
    ("순위"
     "順位")
    ("순위권"
     "順位圈")
    ("순위자"
     "順位者")
    ("순위표"
     "順位表")
    ("순은"
     "純銀")
    ("순응"
     "順應")
    ("순응적"
     "順應的")
    ("순응주의"
     "順應主義")
    ("순이익"
     "純利益")
    ("순이익률"
     "純利益率")
    ("순익"
     "純益")
    ("순일주의"
     "純一主義")
    ("순장"
     "殉葬")
    ("순장제"
     "殉葬制")
    ("순전"
     "純全")
    ("순정"
     "純情"
     "純正")
    ("순정적"
     "殉情的")
    ("순조"
     "順調")
    ("순종"
     "純種"
     "順從")
    ("순종적"
     "順從的")
    ("순진"
     "純眞")
    ("순진성"
     "純眞性")
    ("순차적"
     "順次的")
    ("순찰"
     "巡察")
    ("순찰차"
     "巡察車")
    ("순천응인"
     "順天應人")
    ("순치"
     "馴致")
    ("순탄"
     "順坦")
    ("순풍이호"
     "順風而呼")
    ("순하디"
     "順-順")
    ("순항"
     "順航")
    ("순행"
     "巡幸")
    ("순화"
     "純化"
     "醇化")
    ("순화미"
     "純化美")
    ("순화안"
     "純化案")
    ("순환"
     "循環")
    ("순환계"
     "循環系")
    ("순환기"
     "循環器")
    ("순환적"
     "循環的")
    ("순회"
     "巡廻")
    ("순회공연"
     "巡廻公演")
    ("순회공연단"
     "巡廻公演團")
    ("순회단"
     "巡廻團")
    ("술"
     ("戌" . "개 술, 열한째 지지 술, 때려 부술 술")
     ("術" . "재주 술, 심술부릴 술, 술법 술")
     ("述" . "이을 술, 좇을 술, 조회할 술, 밝힐 술")
     ("鉥" . "돗바늘 술, 인도할 술")
     "卹"
     "潏"
     "絉")
    ("술사"
     "術師")
    ("술수"
     "術數")
    ("술어"
     "術語"
     "述語")
    ("술어학"
     "述語學")
    ("술이부작"
     "述而不作")
    ("술책"
     "術策")
    ("술회"
     "述懷")
    ("숫자"
     "數字")
    ("숫자판"
     "數字板")
    ("숭"
     ("崇" . "높을 숭, 공경할 숭, 마칠 숭, 산이름 숭")
     ("崧" . "산 불끈 솟을 숭, 산 웅장할 숭, 산이름 숭")
     ("嵩" . "높을 숭, 산이름 숭")
     "滕"
     ("菘" . "배추 숭"))
    ("숭고"
     "崇高")
    ("숭고감"
     "崇高感")
    ("숭배"
     "崇拜")
    ("숭배적"
     "崇拜的")
    ("숭상"
     "崇尙")
    ("숭앙"
     "崇仰")
    ("숭유"
     "崇儒")
    ("숭조"
     "崇祖")
    ("숭조상문"
     "崇祖尙門")
    ("쉬"
     ("倅" . "버금 쉬, 아직 벼슬자리에 오르지 않은 아들 쉬, 원님 쉬")
     ("晬" . "돐 쉬, 첫 생일 쉬")
     ("淬" . "칼 담글 쉬, 물들일 쉬, 범할 쉬")
     ("焠" . "물들일 쉬, 칼날 물에 담글 쉬, 지질 쉬, 태울 쉬"))
    ("슬"
     ("瑟" . "비파 슬, 거문고 슬, 깨끗한체할 슬, 바람소리 슬")
     ("膝" . "무릎 슬, 종지뼈 슬, 치슬말 슬")
     ("蝨" . "이 슬")
     ("虱" . "蝨과 同字")
     "飋")
    ("슬갑도적"
     "膝甲盜賊")
    ("슬처두이흑"
     "蝨處頭而黑")
    ("슬하"
     "膝下")
    ("습"
     ("拾" . "주울 습, 거둘 습, 팔찌 습, 벼슬이름 습")
     ("濕" . "젖을 습, 소 귀 벌룩거릴 습, 근심 습")
     ("習" . "익힐 습, 거듭 습")
     ("褶" . "슬갑 습")
     ("襲" . "옷 덧입을 습, 벼슬 대물릴 습, 반복할 습, 합할 습, 염습할 습, 엄습할 습")
     "慴"
     ("熠" . "환할 습, 선명할 습, 반딧불 반짝거릴 습")
     ("隰" . "진펄 습"))
    ("습격"
     "襲擊")
    ("습격당"
     "襲擊當")
    ("습관"
     "習慣")
    ("습관성"
     "習慣性")
    ("습관적"
     "習慣的")
    ("습관화"
     "習慣化")
    ("습기"
     "濕氣"
     "習氣")
    ("습도"
     "濕度")
    ("습득"
     "拾得"
     "習得")
    ("습생"
     "濕生")
    ("습성"
     "習性")
    ("습성화"
     "習性化")
    ("습속"
     "習俗")
    ("습속이성"
     "習俗移性")
    ("습식"
     "濕食")
    ("습여성성"
     "習與性成")
    ("습윤성"
     "濕潤性")
    ("습자"
     "習字")
    ("습작"
     "習作")
    ("습작기"
     "習作期")
    ("습지"
     "濕地")
    ("습지성"
     "濕地性")
    ("습합"
     "習合")
    ("승"
     ("丞" . "이을 승, 도울 승, 벼슬의 이름 승, 향상할 승")
     ("乘" . "오를 승, 곱할 승, 셈하는 단위 승, 같은 물건 네 개 승")
     ("僧" . "중 승")
     ("勝" . "이길 승, 경치가 좋을 승, 가질 승")
     ("升" . "되 승, 오를 승, 피륙의 짜인 날을 세는 단위 새 승, 괘 이름 승")
     ("承" . "받들 승, 이을 승, 도울 승, 차례 승")
     ("昇" . "해 돋을 승, 풍년들 승")
     ("繩" . "노끈 승, 법 승, 다스릴 승, 이을 승")
     ("蠅" . "파리 승")
     ("陞" . "오를 승, 올릴 승")
     "塍"
     ("鬙" . "터럭 더부룩할 승"))
    ("승가"
     "僧伽")
    ("승감"
     "乘監")
    ("승강기"
     "昇降機")
    ("승강대"
     "昇降臺")
    ("승강이"
     "昇降­")
    ("승강장"
     "乘降場")
    ("승객"
     "乘客")
    ("승격"
     "昇格")
    ("승계"
     "承繼")
    ("승계권"
     "承繼權")
    ("승계설"
     "承繼說")
    ("승고월하문"
     "僧敲月下門")
    ("승과"
     "僧科")
    ("승교"
     "乘轎")
    ("승급"
     "昇給")
    ("승급분"
     "昇級分")
    ("승낙"
     "承諾")
    ("승당입실"
     "升堂入室")
    ("승려"
     "僧侶")
    ("승려군"
     "僧侶軍")
    ("승률"
     "勝率")
    ("승리"
     "勝利")
    ("승리자"
     "勝利者")
    ("승마"
     "乘馬"
     "升麻")
    ("승무"
     "乘務"
     "僧舞")
    ("승무원"
     "乘務員")
    ("승병"
     "僧兵")
    ("승복"
     "僧服"
     "承服")
    ("승부"
     "勝負"
     "承訃")
    ("승부수"
     "勝負手")
    ("승부욕"
     "勝負慾")
    ("승부처"
     "勝負處")
    ("승산"
     "勝算")
    ("승상"
     "丞相")
    ("승상접하"
     "承上接下")
    ("승선"
     "乘船")
    ("승소"
     "勝訴")
    ("승수"
     "乘數")
    ("승승장구"
     "乘勝長驅")
    ("승압기"
     "昇壓器")
    ("승야월장"
     "乘夜越墻")
    ("승용차"
     "乘用車")
    ("승원부"
     "乘員部")
    ("승인"
     "勝因"
     "承認")
    ("승인서"
     "承認書")
    ("승자"
     "勝者")
    ("승전가"
     "勝戰歌")
    ("승전지"
     "勝戰地")
    ("승점"
     "勝點")
    ("승조원"
     "乘組員")
    ("승진"
     "昇進")
    ("승차"
     "乘車")
    ("승차감"
     "乘車感")
    ("승차권"
     "乘車券")
    ("승천"
     "昇天")
    ("승통"
     "僧統")
    ("승패"
     "勝敗")
    ("승풍파랑"
     "乘風破浪")
    ("승하"
     "昇遐")
    ("승하차"
     "乘下車")
    ("승합차"
     "乘合車")
    ("승화"
     "昇華")
    ("승희"
     "繩戱")
    ("시"
     ("侍" . "모실 시, 가까울 시, 좇을 시")
     ("匙" . "숟가락 시, 열쇠 시")
     "十"
     ("嘶" . "말 울 시, 목 쉴 시, 울부짖을 시")
     ("始" . "비로소 시, 처음 시, 시작할 시, 별이름 시")
     ("媤" . "시집 시")
     ("寺" . "내관 시")
     ("尸" . "시동 시, 주검 시")
     ("屍" . "주검 시, 송장 시")
     ("屎" . "똥 시")
     ("市" . "저자 시, 흥정할 시, 집 많은 동리 시")
     ("弑" . "윗사람 죽일 시")
     ("恃" . "믿을 시, 의지할 시, 어머니 시")
     ("施" . "베풀 시, 쓸 시, 더할 시, 안팎 곱사등이 시, 버릴 시, 줄 시, 은혜 시, 공로 시")
     ("是" . "이 시, 바를 시, 곧을 시")
     ("昰" . "是와 同字")
     ("時" . "때 시, 끼니 시, 이 시, 엿볼 시, 가끔 시")
     ("枾" . "柹의 本字")
     ("柴" . "섶 시, 불 땔 나무 시, 시제지낼 시")
     ("猜" . "의심낼 시, 시기할 시, 두려워할 시, 사나울 시")
     ("矢" . "살 시, 소리살 시, 곧을 시, 베풀 시, 똥 시")
     ("示" . "보일 시, 바칠 시, 가르칠 시")
     ("翅" . "날개 시, 깃 시, 뿐 시")
     ("蒔" . "소회향 시, 모종낼 시")
     ("蓍" . "뺑대쑥 시, 시초 시")
     ("視" . "볼 시, 견줄 시, 본받을 시, 대접 시")
     ("試" . "시험할 시, 더듬을 시, 비교할 시")
     ("詩" . "귀글 시, 풍류가락 시, 받들 시")
     ("諡" . "행장 시, 시호 시")
     "謚"
     ("豕" . "돼지 시, 돝 시")
     ("豺" . "승냥이 시, 늑대 시")
     ("偲" . "간절히 책망할 시, 살피고 힘쓸 시, 굳셀 시")
     ("兕" . "외뿔난 소 시")
     ("厮" . "부릴 시, 마부 시, 나눌 시")
     ("啻" . "뿐 시, 쯤 시")
     ("塒" . "홰 시")
     ("廝" . "부릴 시, 천할 시, 마부 시")
     "撕"
     ("枲" . "수삼 시, 도꼬마리 시")
     ("柹" . "감 시")
     ("澌" . "물 잦을 시, 다할 시")
     ("禔" . "복 시, 편안할 시")
     ("緦" . "보름새베 시, 시마복 시, 석달복 시")
     "翤"
     ("諟" . "이 시, 살필 시, 다스릴 시")
     ("諰" . "눈 휘둥글할 시, 곧은말 시")
     ("豉" . "메주 시, 콩자반 시")
     ("釃" . "술 거를 시")
     ("鍉" . "숟가락 시, 열쇠 시")
     ("顋" . "뺨 시, 볼 시"))
    ("시가"
     "媤家"
     "市價"
     "市歌"
     "市街"
     "時價"
     "詩歌")
    ("시가불이"
     "市賈不貳")
    ("시가액"
     "市價額")
    ("시가전"
     "市街戰")
    ("시가지"
     "市街地")
    ("시가행진"
     "市街行進")
    ("시각"
     "時刻"
     "視覺"
     "視角")
    ("시각적"
     "視覺的")
    ("시각차"
     "視角差")
    ("시각화"
     "視覺化")
    ("시간"
     "時間")
    ("시간대"
     "時間帶")
    ("시간론"
     "時間論")
    ("시간문제"
     "時間問題")
    ("시간성"
     "時間性")
    ("시간적"
     "時間的")
    ("시간제"
     "時間制")
    ("시간주의적"
     "時間主義的")
    ("시간표"
     "時間表")
    ("시경"
     "市警")
    ("시계"
     "市界"
     "時計"
     "視界")
    ("시계추"
     "時計錘")
    ("시계탑"
     "時計塔")
    ("시곗"
     "時計")
    ("시공"
     "施工"
     "時空")
    ("시공간"
     "時空間")
    ("시공간적"
     "時空間的")
    ("시공권"
     "施工圈")
    ("시공사"
     "施工社")
    ("시교수휵"
     "豕交獸畜")
    ("시구"
     "詩句")
    ("시국"
     "時局")
    ("시극"
     "詩劇")
    ("시극론"
     "詩劇論")
    ("시극적"
     "詩劇的")
    ("시금석"
     "試金石"
     "試金石")
    ("시급"
     "時急")
    ("시기"
     "始期"
     "時期"
     "時機"
     "猜忌")
    ("시기상조"
     "時機尙早")
    ("시기상조론"
     "時機尙早論")
    ("시기심"
     "猜忌心")
    ("시기적"
     "時期的")
    ("시기적절"
     "時期適切")
    ("시내"
     "市內")
    ("시녀"
     "侍女")
    ("시단"
     "詩壇")
    ("시달"
     "示達")
    ("시대"
     "屍臺"
     "時代")
    ("시대극"
     "時代劇")
    ("시대론"
     "時代論")
    ("시대병"
     "時代病")
    ("시대사"
     "時代史")
    ("시대상"
     "時代相")
    ("시대성"
     "時代性")
    ("시대적"
     "時代的")
    ("시대정신"
     "時代精神")
    ("시대착오"
     "時代錯誤")
    ("시대착오적"
     "時代錯誤的")
    ("시댁"
     "媤宅")
    ("시덕자창"
     "恃德者昌")
    ("시도"
     "市道"
     "示度"
     "試圖")
    ("시도관"
     "市道館")
    ("시도지교"
     "市道之交")
    ("시동"
     "始動")
    ("시력"
     "視力"
     "詩歷")
    ("시련"
     "試鍊")
    ("시론"
     "時論"
     "詩論")
    ("시론적"
     "試論的")
    ("시류"
     "時流")
    ("시립"
     "市立")
    ("시묘"
     "侍墓")
    ("시무식"
     "始務式")
    ("시무책"
     "時務策")
    ("시문"
     "詩文")
    ("시민"
     "市民")
    ("시민권"
     "市民權")
    ("시민상"
     "市民賞")
    ("시민성"
     "市民性")
    ("시민운동"
     "市民運動")
    ("시민적"
     "市民的")
    ("시발"
     "始發")
    ("시발역"
     "始發驛")
    ("시발점"
     "始發點")
    ("시방"
     "十方"
     "時方")
    ("시범"
     "示範")
    ("시범적"
     "示範的")
    ("시범학교"
     "示範學校")
    ("시보"
     "時報")
    ("시부모"
     "媤父母")
    ("시부시자"
     "是父是子")
    ("시비"
     "是非"
     "詩碑")
    ("시비곡직"
     "是非曲直")
    ("시비법"
     "施肥法")
    ("시비지심"
     "是非之心")
    ("시빗"
     "是非")
    ("시사"
     "時事"
     "示唆"
     "試寫"
     "詩史")
    ("시사성"
     "時事性")
    ("시사실"
     "試寫室")
    ("시사여생"
     "視死如生")
    ("시사적"
     "時事的")
    ("시사점"
     "示唆點")
    ("시사회"
     "試寫會")
    ("시사회장"
     "試寫會場")
    ("시산혈해"
     "屍山血海")
    ("시상"
     "施賞"
     "詩想")
    ("시상식"
     "施賞式")
    ("시상식장"
     "施賞式場")
    ("시생대"
     "始生代")
    ("시선"
     "視線")
    ("시설"
     "施設")
    ("시설물"
     "施設物")
    ("시설비"
     "施設費")
    ("시세"
     "時勢")
    ("시속"
     "時速")
    ("시쇄본"
     "試刷本")
    ("시숙"
     "媤叔")
    ("시술"
     "施術")
    ("시술가"
     "施術家")
    ("시술법"
     "施術法")
    ("시술소"
     "施術所")
    ("시술적"
     "施術的")
    ("시시각각"
     "時時刻刻")
    ("시시비비"
     "是是非非")
    ("시식"
     "試食")
    ("시식회"
     "試食會")
    ("시신"
     "屍身")
    ("시신경"
     "視神經")
    ("시심"
     "詩心")
    ("시안"
     "試案")
    ("시야"
     "視野")
    ("시야비야"
     "是耶非耶")
    ("시어"
     "詩語")
    ("시역"
     "弑逆")
    ("시연회"
     "試演會")
    ("시영"
     "市營")
    ("시왕전"
     "十王殿")
    ("시외"
     "市外")
    ("시용"
     "試用")
    ("시운"
     "時運")
    ("시원"
     "始原")
    ("시원적"
     "始原的")
    ("시월"
     "十月")
    ("시위"
     "示威")
    ("시위대"
     "示威隊")
    ("시위소찬"
     "尸位素餐")
    ("시위운동"
     "示威運動")
    ("시위자"
     "示威者")
    ("시음"
     "試飮")
    ("시의"
     "時宜")
    ("시의성"
     "時宜性")
    ("시의회"
     "市議會")
    ("시이모"
     "媤姨母")
    ("시이불견"
     "視而不見")
    ("시인"
     "是認"
     "詩人")
    ("시인적"
     "詩人的")
    ("시일"
     "時日")
    ("시작"
     "始作"
     "詩作")
    ("시작점"
     "始作點")
    ("시작종"
     "始作鐘")
    ("시장"
     "市場"
     "市長")
    ("시장실"
     "市長室")
    ("시장적"
     "市場的")
    ("시장통"
     "市場通")
    ("시장화"
     "市場化")
    ("시적"
     "時的"
     "詩的")
    ("시전"
     "市廛"
     "詩展")
    ("시절"
     "時節")
    ("시점"
     "時點"
     "視點")
    ("시정"
     "始政"
     "市政"
     "是正"
     "時政")
    ("시정무뢰"
     "市井無賴")
    ("시정신"
     "詩精神")
    ("시제품"
     "試製品")
    ("시조"
     "始祖"
     "時調")
    ("시조비"
     "時調碑")
    ("시조신"
     "始祖神")
    ("시조제"
     "始組祭")
    ("시종"
     "侍從"
     "始終")
    ("시종여일"
     "始終如一")
    ("시종일관"
     "始終一貫")
    ("시줏"
     "施主")
    ("시중"
     "市中")
    ("시중가"
     "市中價")
    ("시지"
     "市誌")
    ("시지각"
     "視知覺")
    ("시지각적"
     "視知覺的")
    ("시집"
     "詩集")
    ("시차"
     "時差")
    ("시찰"
     "視察")
    ("시책"
     "施策"
     "時策")
    ("시천주"
     "侍天主")
    ("시청"
     "市廳"
     "視聽")
    ("시청각"
     "視聽覺")
    ("시청각적"
     "視聽覺的")
    ("시청률"
     "視聽率")
    ("시청언동"
     "視聽言動")
    ("시청자"
     "視聽者")
    ("시청층"
     "視聽層")
    ("시체"
     "屍體")
    ("시체실"
     "屍體室")
    ("시쳇"
     "時體")
    ("시초"
     "始初"
     "市草")
    ("시추"
     "試錐")
    ("시침"
     "時針")
    ("시판"
     "市販")
    ("시편"
     "詩篇")
    ("시필서영"
     "試筆書永")
    ("시한"
     "時限")
    ("시한부"
     "時限附")
    ("시한폭탄"
     "時限爆彈")
    ("시합"
     "試合")
    ("시해"
     "弑害")
    ("시행"
     "施行"
     "詩行")
    ("시행령"
     "施行令")
    ("시행령안"
     "施行令案")
    ("시행일"
     "施行日")
    ("시행자"
     "施行者")
    ("시행착오"
     "施行錯誤")
    ("시헌력"
     "時憲曆")
    ("시험"
     "試驗")
    ("시험공부"
     "試驗工夫")
    ("시험관"
     "試驗管")
    ("시험대"
     "試驗臺")
    ("시험소"
     "試驗所")
    ("시험약이"
     "視險若夷")
    ("시험장"
     "試驗場")
    ("시험적"
     "試驗的")
    ("시험지"
     "試驗紙")
    ("시현"
     "示現")
    ("시혜"
     "施惠")
    ("시호"
     "柴胡"
     "諡號")
    ("시화"
     "詩畵"
     "詩話")
    ("시화전"
     "詩畵展")
    ("시황"
     "市況")
    ("시효"
     "時效")
    ("시효일"
     "時效日")
    ("식"
     ("埴" . "찰진흙 식, 흙 이길 식, 더듬어 걸을 식")
     ("寔" . "이 식, 참 식, 뿐 식")
     ("式" . "법 식, 쓸 식, 제도 식, 수레 앞 가로막대 식")
     ("息" . "숨쉴 식, 그칠 식, 자식 식, 기를 식")
     ("拭" . "닦을 식, 다듬을 식")
     ("植" . "심을 식, 세울 식, 초목 식")
     ("殖" . "날 식, 심을 식, 성할 식")
     ("湜" . "물 맑을 식, 엄숙할 식")
     ("熄" . "불 꺼질 식, 없어질 식, 마칠 식")
     "篒"
     ("蝕" . "벌레먹을 식, 일식 식, 월식 식")
     ("識" . "알 식")
     ("軾" . "수레앞 가로막이 나무 식, 수레 안에서 절할 식")
     ("食" . "밥 식, 먹을 식, 씹을 식, 제 식, 헛말할 식")
     ("飾" . "꾸밀 식, 문채날 식, 분 바를 식")
     ("媳" . "며느리 식")
     ("栻" . "점판 식"))
    ("식견"
     "識見"
     "食犬")
    ("식곤증"
     "食困症")
    ("식구"
     "食口")
    ("식기"
     "食器")
    ("식단"
     "食單")
    ("식당"
     "食堂")
    ("식당가"
     "食堂街")
    ("식도"
     "食道")
    ("식도락"
     "食道樂")
    ("식도락가"
     "食道樂家")
    ("식도성"
     "食道性")
    ("식도암"
     "食道癌")
    ("식량"
     "食糧"
     "食量")
    ("식량난"
     "食糧難")
    ("식록"
     "食祿")
    ("식료"
     "食料")
    ("식료품"
     "食料品")
    ("식료품비"
     "食料品費")
    ("식료품점"
     "食料品店")
    ("식모"
     "食母")
    ("식목일"
     "植木日")
    ("식무구포"
     "食無求飽")
    ("식문화"
     "食文化")
    ("식물"
     "植物"
     "食物")
    ("식물상"
     "植物相")
    ("식물성"
     "植物性")
    ("식물원"
     "植物園")
    ("식물인간"
     "植物人間")
    ("식물체"
     "植物體")
    ("식물학"
     "植物學")
    ("식민"
     "植民")
    ("식민성"
     "植民性")
    ("식민주의"
     "植民主義")
    ("식민지"
     "植民地")
    ("식민지적"
     "植民地的")
    ("식민지주의"
     "植民地主義")
    ("식반"
     "食盤")
    ("식별"
     "識別")
    ("식부"
     "植付"
     "食父")
    ("식불감미"
     "食不甘味")
    ("식불이미"
     "食不二味")
    ("식비"
     "食費")
    ("식사"
     "食事")
    ("식사대"
     "食事代")
    ("식사량"
     "食事量")
    ("식사법"
     "食事法")
    ("식사비"
     "食事費")
    ("식상"
     "食傷")
    ("식생"
     "植生")
    ("식생활"
     "食生活")
    ("식성"
     "食性")
    ("식소사번"
     "食少事煩")
    ("식솔"
     "食率")
    ("식송망정"
     "植松望亭")
    ("식수"
     "食水")
    ("식수난"
     "食水難")
    ("식수대"
     "植樹帶")
    ("식수원"
     "食水原")
    ("식순"
     "式順")
    ("식습관"
     "食習慣")
    ("식염"
     "食鹽")
    ("식염수"
     "食鹽水")
    ("식옥취계"
     "食玉炊桂")
    ("식욕"
     "食慾")
    ("식용"
     "食用")
    ("식용유"
     "食用油")
    ("식음"
     "食飮")
    ("식음료"
     "食飮料")
    ("식음료부"
     "食飮料部")
    ("식읍"
     "食邑")
    ("식이"
     "食餌")
    ("식인"
     "食人")
    ("식인종"
     "食人種")
    ("식자기"
     "植字機")
    ("식자욕로"
     "息者欲勞")
    ("식자우환"
     "識字憂患")
    ("식장"
     "式場")
    ("식장업체"
     "式場業體")
    ("식재"
     "植栽")
    ("식재료"
     "食材料")
    ("식전"
     "式前"
     "食前")
    ("식전방장"
     "食前方丈")
    ("식중"
     "食中")
    ("식중독"
     "食中毒")
    ("식체험기"
     "食體驗記")
    ("식초"
     "食醋")
    ("식충"
     "食蟲")
    ("식탁"
     "食卓")
    ("식판"
     "食板")
    ("식품"
     "食品")
    ("식품업계"
     "食品業界")
    ("식품점"
     "食品店")
    ("식품화"
     "食品化")
    ("식혜"
     "食醯")
    ("식후"
     "食後")
    ("식후경"
     "食後景")
    ("식후행"
     "食後行")
    ("신"
     ("伸" . "펼 신, 다스릴 신, 기지개 신")
     ("侁" . "떼지어 갈 신")
     ("信" . "믿을 신, 밝힐 신, 맏길 신, 이틀 밤을 잘 신, 사신 신")
     ("呻" . "읊조릴 신, 끙끙거릴 신")
     ("娠" . "아이밸 신, 마부 신")
     ("宸" . "집 신, 처마 신, 대궐 신")
     ("愼" . "삼갈 신, 정성스러울 신, 고요할 신")
     ("新" . "새 신, 처음 신, 고울 신")
     ("晨" . "샛별 신, 아침을 아뢸 신")
     "汕"
     ("燼" . "깜부기불 신, 불똥 신, 재난의 뒤 신")
     ("申" . "펼 신, 기지개켤 신, 거듭 신, 아홉째 지지 신, 원숭이 신")
     ("神" . "천신 신, 영검할 신, 신명 신, 정신 신")
     ("紳" . "큰 띠 신, 벼슬아치 신")
     ("腎" . "콩팥 신, 불알 신, 자지 신")
     ("臣" . "신하 신, 두려울 신")
     ("莘" . "약 이름 신, 많은 모양 신, 나라이름 신")
     ("薪" . "섶 신, 땔나무 신, 월급 신, 성씨 신")
     ("藎" . "갈골 신, 나아갈 신, 남을 신")
     ("蜃" . "큰 조개 신, 이무기 신, 술잔 신")
     ("訊" . "물을 신, 다스릴 신, 죄 조사할 신, 알릴 신, 꾸짖을 신")
     ("身" . "몸 신, 아이 밸 신, 몸소 신")
     ("辛" . "매울 신, 고생 신, 여덟째 천간 신")
     ("迅" . "빠를 신, 억셀 신")
     ("辰" . "날 신")
     ("哂" . "빙그레 웃을 신, 비웃을 신")
     ("噺" . "이야기 신")
     ("囟" . "숨구멍 신, 정수리 신")
     ("姺" . "나라이름 신")
     ("汛" . "물뿌릴 신")
     ("矧" . "하물며 신, 잇속 드러날 신")
     ("脤" . "사직제 지낸 고기 신")
     ("贐" . "노자 신, 노수 신")
     ("頣" . "눈들고 볼 신")
     ("駪" . "말 우물거릴 신, 빨리 걸을 신"))
    ("신간"
     "新刊")
    ("신개발"
     "新開發")
    ("신개지"
     "新開地")
    ("신검"
     "身檢")
    ("신격"
     "神格")
    ("신격화"
     "神格化")
    ("신경"
     "神經")
    ("신경계"
     "神經系")
    ("신경성"
     "神經性")
    ("신경외과"
     "神經外科")
    ("신경전"
     "神經戰")
    ("신경제"
     "新經濟")
    ("신경증"
     "神經症")
    ("신경질"
     "神經質")
    ("신경질적"
     "神經質的")
    ("신경통"
     "神經痛")
    ("신계몽주의"
     "新啓蒙主義")
    ("신고"
     "申告")
    ("신고서"
     "申告書")
    ("신고식"
     "申告式")
    ("신고전주의"
     "新古典主義")
    ("신고전주의적"
     "新古典主義的")
    ("신고제"
     "申告制")
    ("신고증"
     "申告證")
    ("신곡"
     "新曲")
    ("신공"
     "身貢")
    ("신공법"
     "新工法")
    ("신공안"
     "新公安")
    ("신공안파"
     "新公安派")
    ("신공업"
     "新工業")
    ("신과학"
     "新科學")
    ("신관"
     "神官")
    ("신교"
     "新敎")
    ("신교대"
     "新敎隊")
    ("신교육"
     "新敎育")
    ("신구"
     "新舊")
    ("신구개합"
     "信口開合")
    ("신국제"
     "新國際")
    ("신군부"
     "新軍部")
    ("신궁"
     "神宮")
    ("신궁심불궁"
     "身窮心不窮")
    ("신규"
     "新規")
    ("신규성"
     "新規性")
    ("신극"
     "新劇")
    ("신극사"
     "新劇史")
    ("신금"
     "信金")
    ("신급돈어"
     "信及豚魚")
    ("신기"
     "新奇"
     "新機"
     "神奇"
     "神技"
     "神機"
     "神氣")
    ("신기록"
     "新記錄")
    ("신기루"
     "蜃氣樓")
    ("신기술"
     "新技術")
    ("신기원"
     "新紀元")
    ("신기전"
     "神機箭")
    ("신년"
     "新年")
    ("신년사"
     "新年辭")
    ("신념"
     "信念")
    ("신노정"
     "新勞政")
    ("신농정"
     "新農政")
    ("신당"
     "新黨")
    ("신당론"
     "新黨論")
    ("신대륙"
     "新大陸")
    ("신도"
     "信徒")
    ("신도시"
     "新都市")
    ("신동"
     "神童")
    ("신라"
     "新羅")
    ("신랄"
     "辛辣")
    ("신랑"
     "新郞")
    ("신령"
     "神靈")
    ("신록"
     "新綠")
    ("신뢰"
     "信賴")
    ("신뢰감"
     "信賴感")
    ("신뢰도"
     "信賴度")
    ("신뢰성"
     "信賴性")
    ("신뢰풍렬"
     "迅雷風烈")
    ("신망"
     "信望")
    ("신망도"
     "信望度")
    ("신명"
     "神明"
     "身命")
    ("신무용"
     "新舞踊")
    ("신무용사"
     "新舞踊史")
    ("신문"
     "新聞"
     "訊問")
    ("신문고"
     "申聞鼓")
    ("신문국장"
     "新聞局長")
    ("신문명"
     "新文明")
    ("신문물"
     "新文物")
    ("신문사"
     "新聞社")
    ("신문업계"
     "新聞業界")
    ("신문용지"
     "新聞用紙")
    ("신문지"
     "新聞紙")
    ("신문학"
     "新文學")
    ("신문화"
     "新文化")
    ("신물질"
     "新物質")
    ("신미술"
     "新美術")
    ("신미양요"
     "辛未洋擾")
    ("신민속"
     "新民俗")
    ("신민족주의"
     "新民族主義")
    ("신발명"
     "新發明")
    ("신방"
     "新房")
    ("신법"
     "新法")
    ("신변"
     "身邊")
    ("신변잡기"
     "身邊雜記")
    ("신병"
     "新兵"
     "神兵"
     "神病"
     "身柄"
     "身病")
    ("신보수주의"
     "新保守主義")
    ("신보수주의적"
     "新保守主義的")
    ("신봉"
     "信奉")
    ("신봉자"
     "信奉者")
    ("신부"
     "新婦"
     "神父")
    ("신북구"
     "新北區")
    ("신분"
     "身分")
    ("신분관"
     "身分觀")
    ("신분적"
     "身分的")
    ("신분제"
     "身分制")
    ("신분증"
     "身分證")
    ("신붓"
     "新婦")
    ("신비"
     "神秘")
    ("신비감"
     "神秘感")
    ("신비성"
     "神秘性")
    ("신비적"
     "神秘的")
    ("신비주의"
     "神秘主義")
    ("신비주의성"
     "神秘主義性")
    ("신비주의자"
     "神秘主義者")
    ("신비주의적"
     "神秘主義的")
    ("신비화"
     "神秘化")
    ("신빙"
     "信憑")
    ("신빙성"
     "信憑性")
    ("신사"
     "神社"
     "紳士")
    ("신사고"
     "新思考")
    ("신사도"
     "紳士道")
    ("신사복"
     "紳士服")
    ("신사업"
     "新事業")
    ("신사적"
     "紳士的")
    ("신사회"
     "新社會")
    ("신산"
     "辛酸")
    ("신산업"
     "新産業")
    ("신상"
     "神像"
     "身上")
    ("신상명세서"
     "身上明細書")
    ("신상품"
     "新商品")
    ("신상필벌"
     "信賞必罰")
    ("신생"
     "新生")
    ("신생대"
     "新生代")
    ("신생아"
     "新生兒")
    ("신석기"
     "新石器")
    ("신석기인"
     "新石器人")
    ("신선"
     "新鮮"
     "神仙")
    ("신선로"
     "神仙爐")
    ("신선미"
     "新鮮味")
    ("신선술"
     "神仙術")
    ("신설"
     "新設")
    ("신성"
     "神性"
     "神聖")
    ("신성불가침"
     "神聖不可侵")
    ("신성성"
     "神聖性")
    ("신세계"
     "新世界")
    ("신세대"
     "新世代")
    ("신세대적"
     "新世代的")
    ("신세대형"
     "新世代型")
    ("신소설"
     "新小說")
    ("신소재"
     "新素材")
    ("신속"
     "迅速")
    ("신승"
     "辛勝")
    ("신시"
     "新詩"
     "申時"
     "神市")
    ("신시가지"
     "新市街地")
    ("신시장"
     "新市場")
    ("신식"
     "新式")
    ("신식민지"
     "新植民地")
    ("신신당부"
     "申申當付")
    ("신실"
     "信實")
    ("신안보"
     "新安保")
    ("신앙"
     "信仰")
    ("신앙생활"
     "信仰生活")
    ("신앙심"
     "信仰心")
    ("신앙인"
     "信仰人")
    ("신앙적"
     "信仰的")
    ("신약"
     "新約")
    ("신어"
     "新語")
    ("신언서판"
     "身言書判")
    ("신언지서"
     "信言之瑞")
    ("신여당"
     "新與黨")
    ("신여성"
     "新女性")
    ("신역"
     "身役")
    ("신연극"
     "新演劇")
    ("신예"
     "新銳")
    ("신왕"
     "神王")
    ("신외무물"
     "身外無物")
    ("신용"
     "信用")
    ("신우익"
     "新右翼")
    ("신원"
     "伸寃"
     "身元")
    ("신위"
     "神位")
    ("신유"
     "神癒")
    ("신유학"
     "新儒學")
    ("신음"
     "呻吟")
    ("신의"
     "信義")
    ("신인"
     "新人")
    ("신인사"
     "新人事")
    ("신인왕"
     "新人王")
    ("신인왕전"
     "新人王戰")
    ("신임"
     "信任"
     "新任")
    ("신입"
     "新入")
    ("신입생"
     "新入生")
    ("신자"
     "信者")
    ("신작"
     "新作")
    ("신작로"
     "新作路")
    ("신장"
     "伸張"
     "腎臟"
     "身長")
    ("신장개업"
     "新裝開業")
    ("신장기"
     "伸長期")
    ("신장률"
     "伸張率")
    ("신장세"
     "伸張勢")
    ("신장염"
     "腎臟炎")
    ("신재벌"
     "新財閥")
    ("신저"
     "新著")
    ("신적"
     "神的")
    ("신전"
     "神殿")
    ("신접"
     "新接")
    ("신정"
     "新正")
    ("신정부"
     "新政府")
    ("신정치"
     "新政治")
    ("신제품"
     "新製品")
    ("신조"
     "信條")
    ("신조류"
     "新潮流")
    ("신조어"
     "新造語")
    ("신종"
     "新種")
    ("신종여시"
     "愼終如始")
    ("신종추원"
     "愼終追遠")
    ("신좌익"
     "新左翼")
    ("신주"
     "新株"
     "神主")
    ("신중"
     "愼重")
    ("신중간"
     "新中間")
    ("신중론"
     "愼重論")
    ("신중론자"
     "愼重論者")
    ("신중성"
     "愼重性")
    ("신증설"
     "新增設")
    ("신지"
     "臣智")
    ("신진"
     "新進")
    ("신진대사"
     "新陳代謝")
    ("신진화론"
     "新進化論")
    ("신진화론자"
     "新進化論者")
    ("신진화주의"
     "新進化主義")
    ("신질서"
     "新秩序")
    ("신참"
     "新參")
    ("신청"
     "申請")
    ("신청권"
     "申請權")
    ("신청서"
     "申請書")
    ("신청인"
     "申請人")
    ("신청자"
     "申請者")
    ("신체"
     "身體")
    ("신체검사"
     "身體檢査")
    ("신체발부"
     "身體髮膚")
    ("신체시"
     "新體詩")
    ("신체장애"
     "身體障碍")
    ("신체장애자"
     "身體障碍者")
    ("신체적"
     "身體的")
    ("신축"
     "新築")
    ("신축년"
     "辛丑年")
    ("신축비"
     "新築費")
    ("신축성"
     "伸縮性")
    ("신축적"
     "伸縮的")
    ("신춘"
     "新春")
    ("신춘문예"
     "新春文藝")
    ("신출"
     "新出")
    ("신출귀몰"
     "神出鬼沒")
    ("신출귀물"
     "新出貴物")
    ("신탁"
     "信託"
     "神託")
    ("신토불이"
     "身土不二")
    ("신통"
     "神通")
    ("신통력"
     "神通力")
    ("신통술"
     "神通術")
    ("신파극"
     "新派劇")
    ("신파극단"
     "新派劇團")
    ("신파극적"
     "新派劇的")
    ("신파적"
     "新派的")
    ("신판"
     "新版")
    ("신평야"
     "新平野")
    ("신품"
     "新品")
    ("신풍"
     "新風")
    ("신풍속"
     "新風俗")
    ("신하"
     "臣下")
    ("신학"
     "神學")
    ("신학기"
     "新學期")
    ("신학년도"
     "新學年度")
    ("신학문"
     "新學問")
    ("신학생"
     "神學生")
    ("신학자"
     "神學者")
    ("신학적"
     "神學的")
    ("신항만"
     "新港灣")
    ("신해혁명"
     "辛亥革命")
    ("신협"
     "信協")
    ("신형"
     "新型")
    ("신호"
     "信號")
    ("신호기"
     "信號機")
    ("신호등"
     "信號燈")
    ("신호탄"
     "信號彈")
    ("신혼"
     "新婚")
    ("신혼부부"
     "新婚夫婦")
    ("신혼여행"
     "新婚旅行")
    ("신혼여행지"
     "新婚旅行地")
    ("신화"
     "神話")
    ("신화시대"
     "神話時代")
    ("신화적"
     "神話的")
    ("신화학자"
     "神話學者")
    ("신효자전"
     "新孝子傳")
    ("신흥"
     "新興")
    ("실"
     ("失" . "잃을 실, 그르칠 실")
     ("室" . "집 실, 아내 실")
     ("實" . "열매 실")
     ("悉" . "모두 실")
     ("蟋" . "귀뚜라미 실"))
    ("실가지락"
     "室家之樂")
    ("실각"
     "失脚")
    ("실감"
     "實感")
    ("실거래"
     "實去來")
    ("실격"
     "失格")
    ("실계"
     "失戒")
    ("실과"
     "實科")
    ("실구입"
     "實求入")
    ("실국장"
     "實局長")
    ("실권"
     "實權")
    ("실권자"
     "實權者")
    ("실기"
     "失機"
     "實技")
    ("실기실"
     "實技室")
    ("실내"
     "室內")
    ("실내등"
     "室內燈")
    ("실내악단"
     "室內樂團")
    ("실내용품"
     "室內用品")
    ("실내조명"
     "室內照明")
    ("실내화"
     "室內靴")
    ("실답증"
     "失答症")
    ("실력"
     "實力")
    ("실력자"
     "實力者")
    ("실력파"
     "實力派")
    ("실례"
     "失禮"
     "實例")
    ("실록"
     "實錄")
    ("실리"
     "實利")
    ("실리적"
     "實利的")
    ("실마치구"
     "失馬治廐")
    ("실망"
     "失望")
    ("실망감"
     "失望感")
    ("실명"
     "失明"
     "實名")
    ("실명인"
     "失明人")
    ("실명제"
     "實名制")
    ("실명화"
     "實名化")
    ("실무"
     "實務")
    ("실무자"
     "實務者")
    ("실무적"
     "實務的")
    ("실무진"
     "實務陣")
    ("실물"
     "實物")
    ("실보관"
     "實保管")
    ("실사"
     "實査")
    ("실사구시"
     "實事求是")
    ("실사례"
     "實事例")
    ("실사회"
     "實社會")
    ("실상"
     "實狀"
     "實相")
    ("실상적"
     "實狀的")
    ("실생활"
     "實生活")
    ("실선"
     "實線")
    ("실성"
     "失性")
    ("실성기"
     "失性氣")
    ("실성실성"
     "失性失性")
    ("실세"
     "實勢")
    ("실소"
     "失笑")
    ("실수"
     "失手")
    ("실수담"
     "失手談")
    ("실수왕"
     "失手王")
    ("실수요자"
     "實需要者")
    ("실수율"
     "失手率")
    ("실습"
     "實習")
    ("실습림"
     "實習林")
    ("실습비"
     "實習費")
    ("실습실"
     "實習室")
    ("실습지"
     "實習地")
    ("실시"
     "實施")
    ("실시간"
     "實時間")
    ("실시론"
     "實施論")
    ("실시설"
     "實施說")
    ("실신"
     "失神")
    ("실어증"
     "失語症")
    ("실업"
     "失業"
     "實業")
    ("실업계"
     "實業系")
    ("실업고"
     "實業高")
    ("실업률"
     "失業率")
    ("실업자"
     "失業者")
    ("실업학교"
     "實業學校")
    ("실연"
     "失戀"
     "實演")
    ("실연주의"
     "實演主義")
    ("실온"
     "室溫")
    ("실외"
     "室外")
    ("실용"
     "實用")
    ("실용서"
     "實用書")
    ("실용성"
     "實用性")
    ("실용적"
     "實用的")
    ("실용주의"
     "實用主義")
    ("실용화"
     "實用化")
    ("실유"
     "實有")
    ("실의"
     "失意")
    ("실이익"
     "實利益")
    ("실익"
     "實益")
    ("실작업"
     "實作業")
    ("실장"
     "室長")
    ("실장단"
     "實長短")
    ("실재"
     "實在")
    ("실재론자"
     "實在論者")
    ("실재성"
     "實在性")
    ("실적"
     "實績")
    ("실전"
     "實戰")
    ("실점"
     "失點")
    ("실정"
     "失政"
     "實情")
    ("실정법"
     "實定法")
    ("실제"
     "實弟"
     "實際")
    ("실제성"
     "實題性")
    ("실제적"
     "實題的")
    ("실조"
     "失調")
    ("실족"
     "失足")
    ("실족사"
     "失足死")
    ("실존"
     "實存")
    ("실존적"
     "實存的")
    ("실존주의"
     "實存主義")
    ("실존주의자"
     "實存主義者")
    ("실존주의적"
     "實存主義的")
    ("실종"
     "失踪")
    ("실증"
     "實證")
    ("실증적"
     "實證的")
    ("실증주의"
     "實證主義")
    ("실증주의론자"
     "實證主義論者")
    ("실증주의자"
     "實證主義者")
    ("실증주의적"
     "實證主義的")
    ("실지"
     "實地")
    ("실직"
     "失職")
    ("실직자"
     "失職者")
    ("실질"
     "實質")
    ("실질적"
     "實質的")
    ("실책"
     "失策")
    ("실천"
     "實踐")
    ("실천가"
     "實踐家")
    ("실천성"
     "實踐性")
    ("실천자"
     "實踐者")
    ("실천적"
     "實踐的")
    ("실체"
     "實體")
    ("실체적"
     "實體的")
    ("실체화"
     "實體化")
    ("실추"
     "失墜")
    ("실측"
     "實測")
    ("실탄"
     "實彈")
    ("실태"
     "實態")
    ("실토"
     "實吐")
    ("실패"
     "失敗")
    ("실패담"
     "失敗談")
    ("실패작"
     "失敗作")
    ("실학"
     "實學")
    ("실학사상"
     "實學思想")
    ("실학자"
     "實學者")
    ("실학파"
     "實學派")
    ("실행"
     "實行")
    ("실행기"
     "實行機")
    ("실행형"
     "實行型")
    ("실향"
     "失鄕")
    ("실험"
     "實驗")
    ("실험극"
     "實驗劇")
    ("실험기"
     "實驗期")
    ("실험당"
     "實驗當")
    ("실험대"
     "實驗臺")
    ("실험도"
     "實驗度")
    ("실험복"
     "實驗服")
    ("실험성"
     "實驗性")
    ("실험실"
     "實驗室")
    ("실험적"
     "實驗的")
    ("실험학교"
     "實驗學校")
    ("실현"
     "實現")
    ("실현성"
     "實現性")
    ("실현자"
     "實現者")
    ("실형"
     "實刑")
    ("실화"
     "實話")
    ("실황"
     "實況")
    ("실효"
     "失效"
     "實效")
    ("실효성"
     "實效性")
    ("실효적"
     "實效的")
    ("심"
     ("審" . "살필 심")
     ("尋" . "찾을 심")
     ("心" . "마음 심")
     ("沁" . "스며들 심")
     ("深" . "깊을 심")
     "瀋"
     ("甚" . "심할 심, 무엇 심")
     ("芯" . "등심초 심")
     ("諶" . "참 심")
     ("沈" . "성 심")
     "椹"
     ("沉" . "沈과 同字")
     ("潯" . "물가 심")
     ("燖" . "삶을 심")
     ("葚" . "뽕나무 열매 심")
     ("鐔" . "칼날 아래 코등이 심")
     ("鱏" . "칼철갑상어 심"))
    ("심각"
     "深刻")
    ("심각성"
     "深刻性")
    ("심경"
     "心境")
    ("심고"
     "心告")
    ("심근"
     "心筋")
    ("심금"
     "心琴")
    ("심급"
     "審級")
    ("심기"
     "心氣")
    ("심기일전"
     "心機一轉")
    ("심난"
     "甚難")
    ("심대"
     "甚大")
    ("심도"
     "深度")
    ("심란"
     "心亂")
    ("심려"
     "心慮")
    ("심령"
     "心靈")
    ("심령술사"
     "心靈術使")
    ("심리"
     "審理"
     "心理")
    ("심리극"
     "心理劇")
    ("심리도"
     "心理度")
    ("심리적"
     "心理的")
    ("심리전"
     "心理戰")
    ("심리학"
     "心理學")
    ("심리학과"
     "心理學科")
    ("심리학자"
     "心理學者")
    ("심리학적"
     "心理學的")
    ("심모원려"
     "深謀遠慮")
    ("심문"
     "審問")
    ("심문자"
     "審問者")
    ("심미"
     "審美")
    ("심미성"
     "審美性")
    ("심미안"
     "審美眼")
    ("심미적"
     "審美的")
    ("심박출량"
     "心搏出量")
    ("심법"
     "心法")
    ("심복"
     "心腹")
    ("심부전증"
     "心不全症")
    ("심사"
     "審査"
     "心思")
    ("심사과장"
     "審査課長")
    ("심사숙고"
     "深思熟考")
    ("심산"
     "心算")
    ("심산유곡"
     "深山幽谷")
    ("심상"
     "尋常"
     "心狀"
     "心象")
    ("심상과"
     "尋常科")
    ("심성"
     "心性")
    ("심성암"
     "深成巖")
    ("심술"
     "心術")
    ("심신"
     "心身")
    ("심실중격"
     "心室中隔")
    ("심심"
     "甚深")
    ("심심상인"
     "心心相印")
    ("심야"
     "深夜")
    ("심약"
     "心弱")
    ("심연"
     "深淵")
    ("심오"
     "深奧")
    ("심원"
     "深遠")
    ("심음"
     "心音")
    ("심의"
     "審議"
     "深衣")
    ("심의관"
     "審議官")
    ("심의료"
     "審議料")
    ("심의실"
     "審議室")
    ("심인성"
     "心因性")
    ("심잡음"
     "心雜音")
    ("심장"
     "心臟"
     "深長")
    ("심장병"
     "心臟病")
    ("심장부"
     "心臟部")
    ("심장성"
     "心臟性")
    ("심장학"
     "心臟學")
    ("심적"
     "心的")
    ("심정"
     "心情")
    ("심정적"
     "心情的")
    ("심제"
     "審制")
    ("심중유심"
     "心中有心")
    ("심증"
     "心證")
    ("심지어"
     "甚至於")
    ("심취"
     "心醉")
    ("심층"
     "深層")
    ("심층적"
     "深層的")
    ("심통"
     "心痛")
    ("심판"
     "審判")
    ("심판권"
     "審判權")
    ("심판대"
     "審判臺")
    ("심판적"
     "審判的")
    ("심폐"
     "心肺")
    ("심해"
     "深海")
    ("심혈"
     "心血")
    ("심호흡"
     "深呼吸")
    ("심혼"
     "心魂")
    ("심화"
     "心火"
     "深化")
    ("심회"
     "心懷")
    ("십"
     ("什" . "열 사람 십")
     ("十" . "열 십, 전부 십")
     ("拾" . "十의 갖은자")
     ("辻" . "네거리 십"))
    ("십구"
     "十九")
    ("십년감수"
     "十年減壽")
    ("십년지계"
     "十年之計")
    ("십만"
     "十萬")
    ("십맹일장"
     "十盲一杖")
    ("십목소시"
     "十目所視")
    ("십백지기"
     "什佰之器")
    ("십벌지목"
     "十伐之木")
    ("십부제"
     "十部制")
    ("십분"
     "十分")
    ("십사"
     "十四")
    ("십삼"
     "十三")
    ("십상"
     "十常")
    ("십성"
     "十聖")
    ("십수만"
     "十數萬")
    ("십시일반"
     "十匙一飯")
    ("십오"
     "十五")
    ("십육"
     "十六")
    ("십육국"
     "十六國")
    ("십육위제"
     "十六衛制")
    ("십육절지"
     "十六切紙")
    ("십이"
     "十二")
    ("십이륙"
     "十二六")
    ("십이십이"
     "十二十二")
    ("십이월"
     "十二月")
    ("십이지"
     "十二指"
     "十二支")
    ("십이지장"
     "十二指腸")
    ("십인십색"
     "十人十色")
    ("십일"
     "十一")
    ("십일월"
     "十一月")
    ("십자"
     "十字")
    ("십자가"
     "十字架")
    ("십자군"
     "十字軍")
    ("십장"
     "什長")
    ("십장가"
     "十杖歌")
    ("십장생"
     "十長生")
    ("십전대보탕"
     "十全大補湯")
    ("십전대보환"
     "十全大補丸")
    ("십정"
     "十停")
    ("십중팔구"
     "十中八九")
    ("십진법"
     "十進法")
    ("십찰"
     "十刹")
    ("십칠"
     "十七")
    ("십팔"
     "十八")
    ("십현"
     "十玄")
    ("쌍"
     ("雙" . "짝 쌍"))
    ("쌍곡선"
     "雙曲線")
    ("쌍과부"
     "雙寡婦")
    ("쌍두"
     "雙頭")
    ("쌍무"
     "雙務")
    ("쌍무적"
     "雙務的")
    ("쌍발"
     "雙發")
    ("쌍발기"
     "雙發機")
    ("쌍방"
     "雙方")
    ("쌍방적"
     "雙方的")
    ("쌍벽"
     "雙璧")
    ("쌍생아"
     "雙生兒")
    ("쌍수"
     "雙手")
    ("쌍심"
     "雙心")
    ("쌍쌍"
     "雙雙")
    ("쌍안경"
     "雙眼鏡")
    ("쌍엽"
     "雙葉")
    ("쌍태"
     "雙胎")
    ("쌍포"
     "雙砲")
    ("씨"
     ("氏" . "성 씨"))
    ("씨족"
     "氏族")
    ("씨족제"
     "氏族制")
    ("아"
     ("亞" . "버금 아")
     ("俄" . "갑자기 아")
     ("兒" . "아이 아")
     ("啞" . "벙어리 아, 놀랄 아")
     ("娥" . "예쁠 아")
     ("峨" . "산 높을 아")
     ("我" . "자기 아")
     ("牙" . "어금니 아, 대장 기 아")
     ("芽" . "싹 아")
     ("莪" . "지칭개 아")
     ("蛾" . "누에나방 아")
     ("衙" . "마을 아")
     ("訝" . "맞아들일 아, 의심할 아")
     ("阿" . "언덕 아, 아름다울 아, 알랑거릴 아")
     ("雅" . "아담할 아")
     ("餓" . "주릴 아")
     ("鴉" . "갈가마귀 아, 검을 아")
     ("鵝" . "거위 아")
     ("丫" . "가장귀 아")
     ("哦" . "놀람의 어조사 아")
     ("娿" . "아리따울 아")
     ("婀" . "娿와 同字")
     ("峩" . "峨와 同字")
     ("疴" . "앓을 아")
     ("砑" . "갈 아")
     ("笌" . "대싹 아")
     ("迓" . "마중할 아")
     ("錏" . "투구의 목가림 아")
     ("鵞" . "鵝와 同字"))
    ("아가사창"
     "我歌査唱")
    ("아고산"
     "亞高山")
    ("아관"
     "俄館")
    ("아교"
     "阿膠")
    ("아국"
     "我國")
    ("아군"
     "我軍")
    ("아귀"
     "餓鬼")
    ("아녀자"
     "兒女子")
    ("아담"
     "雅淡")
    ("아동"
     "兒童")
    ("아동기"
     "兒童期")
    ("아동용"
     "兒童用")
    ("아동용품"
     "兒童用品")
    ("아동주졸"
     "兒童走卒")
    ("아동학자"
     "兒童學者")
    ("아랑지구"
     "餓狼之口")
    ("아량"
     "雅量")
    ("아령"
     "啞鈴")
    ("아류화"
     "蛾類化")
    ("아마"
     "亞麻")
    ("아미타불"
     "阿彌陀佛")
    ("아미타여래"
     "阿彌陀如來")
    ("아부"
     "阿附")
    ("아비규환"
     "阿鼻叫喚")
    ("아사"
     "餓死")
    ("아상"
     "我相")
    ("아성"
     "牙城")
    ("아세"
     "亞歲")
    ("아수라"
     "阿修羅")
    ("아수라장"
     "阿修羅場")
    ("아심여칭"
     "我心如稱")
    ("아역"
     "兒役")
    ("아연"
     "亞鉛"
     "俄然"
     "啞然")
    ("아열대"
     "亞熱帶")
    ("아쟁"
     "牙箏")
    ("아전인수"
     "我田引水")
    ("아종"
     "亞種")
    ("아집"
     "我執")
    ("아찬"
     "阿飡")
    ("아첨"
     "阿諂")
    ("아편"
     "阿片")
    ("아함경"
     "阿含經")
    ("아호"
     "雅號")
    ("악"
     ("堊" . "흰 흙 악")
     ("岳" . "큰 산 악")
     ("嶽" . "높은 산 악")
     ("幄" . "장막 악")
     ("惡" . "나쁠 악")
     ("愕" . "놀랄 악")
     ("握" . "잡을 악, 손아귀 악")
     ("樂" . "풍류 악")
     ("渥" . "두터울 악")
     ("鄂" . "나라이름 악")
     ("鍔" . "칼날끝 악")
     ("顎" . "턱 악")
     ("鰐" . "악어 악")
     ("齷" . "악착할 악")
     ("偓" . "거리낄 악")
     ("卾" . "윗턱 악")
     ("咢" . "놀랄 악")
     ("喔" . "닭 우는 소리 악, 아첨해 웃는 소리 악")
     ("噩" . "놀랄 악")
     ("腭" . "잇몸 악")
     ("萼" . "꽃받침 악")
     ("覨" . "오래 볼 악")
     ("諤" . "직언할 악")
     ("鶚" . "물수리 악")
     ("齶" . "잇몸 악"))
    ("악곡"
     "樂曲")
    ("악귀"
     "惡鬼")
    ("악기"
     "樂器")
    ("악기상"
     "樂器商")
    ("악단"
     "樂團")
    ("악담"
     "惡談")
    ("악당"
     "惡黨")
    ("악덕"
     "惡德")
    ("악독"
     "惡毒")
    ("악독성"
     "惡毒性")
    ("악동"
     "惡童")
    ("악랄"
     "惡辣")
    ("악력"
     "握力")
    ("악령"
     "惡靈")
    ("악마"
     "惡魔")
    ("악마적"
     "惡魔的")
    ("악명"
     "惡名")
    ("악몽"
     "惡夢")
    ("악법"
     "惡法")
    ("악보"
     "樂譜")
    ("악사"
     "樂士")
    ("악사천리"
     "惡事千里")
    ("악상"
     "惡喪"
     "樂想")
    ("악선"
     "顎線")
    ("악성"
     "惡性"
     "樂聖")
    ("악성적"
     "惡性的")
    ("악속"
     "惡俗")
    ("악수"
     "握手")
    ("악순환"
     "惡循環")
    ("악습"
     "惡習")
    ("악어"
     "惡語"
     "鰐魚")
    ("악역"
     "惡役")
    ("악연"
     "惡緣")
    ("악영향"
     "惡影響")
    ("악용"
     "惡用")
    ("악의"
     "惡意")
    ("악의악식"
     "惡衣惡食")
    ("악의적"
     "惡意的")
    ("악인"
     "惡人")
    ("악장"
     "樂章"
     "樂長")
    ("악재"
     "惡材")
    ("악전고투"
     "惡戰苦鬪")
    ("악조건"
     "惡條件")
    ("악종"
     "惡種")
    ("악질"
     "惡質")
    ("악질분자"
     "惡質分子")
    ("악착"
     "齷齪")
    ("악취"
     "惡臭")
    ("악폐"
     "惡弊")
    ("악행"
     "惡行")
    ("악화"
     "惡化")
    ("안"
     ("安" . "편안할 안, 어찌 안")
     ("岸" . "물가 언덕 안")
     ("按" . "살필 안, 어루만질 안")
     ("晏" . "늦을 안, 편안할 안")
     ("案" . "책상 안, 생각할 안")
     ("眼" . "눈 안")
     ("雁" . "鴈과 同字")
     ("鞍" . "안장 안")
     ("顔" . "顏과 同字")
     ("鮟" . "아귀 안")
     ("桉" . "案과 同字")
     ("犴" . "들개 안")
     ("贋" . "가짜 안")
     ("鴈" . "기러기 안"))
    ("안가"
     "安家")
    ("안건"
     "案件")
    ("안경"
     "眼鏡")
    ("안경점"
     "眼鏡店")
    ("안고수비"
     "眼高手卑")
    ("안과"
     "眼科")
    ("안구"
     "眼球")
    ("안기"
     "安岐")
    ("안기부법"
     "安企部法")
    ("안내"
     "案內")
    ("안내기"
     "案內記")
    ("안내도"
     "案內圖")
    ("안내문"
     "案內文")
    ("안내서"
     "案內書")
    ("안내소"
     "案內所")
    ("안내실"
     "案內室")
    ("안내양"
     "案內孃")
    ("안내원"
     "案內員")
    ("안내인"
     "案內人")
    ("안내자"
     "案內者")
    ("안내장"
     "案內狀")
    ("안녕"
     "安寧")
    ("안도"
     "安堵")
    ("안도감"
     "安堵感")
    ("안동"
     "安東"
     "按棟")
    ("안동포"
     "安東布")
    ("안락"
     "安樂")
    ("안락성"
     "安樂性")
    ("안락의자"
     "安樂椅子")
    ("안력"
     "眼力")
    ("안마"
     "按摩"
     "鞍馬")
    ("안마법"
     "按摩法")
    ("안마사"
     "按摩師")
    ("안면"
     "顔面")
    ("안면부"
     "顔面部")
    ("안명수쾌"
     "眼明手快")
    ("안목"
     "眼目")
    ("안목소시"
     "眼目所視")
    ("안무"
     "按舞")
    ("안무가"
     "按舞家")
    ("안무상"
     "按舞賞")
    ("안민"
     "安民")
    ("안배"
     "按排")
    ("안보"
     "安保")
    ("안보관"
     "安保觀")
    ("안보적"
     "安保的")
    ("안부"
     "安否")
    ("안분지족"
     "安分知足")
    ("안불망위"
     "安不忘危")
    ("안빈"
     "安貧")
    ("안빈낙도"
     "安貧樂道")
    ("안산"
     "安産"
     "案山")
    ("안상"
     "眼狀")
    ("안색"
     "顔色")
    ("안성"
     "安城")
    ("안수"
     "按手")
    ("안식"
     "安息")
    ("안식일"
     "安息日")
    ("안식처"
     "安息處")
    ("안심"
     "安心")
    ("안악골"
     "眼顎骨")
    ("안여태산"
     "安如泰山")
    ("안온"
     "安穩")
    ("안위"
     "安危"
     "安慰")
    ("안이"
     "安易")
    ("안일"
     "安逸")
    ("안일주의"
     "安逸主義")
    ("안장"
     "安葬"
     "鞍裝")
    ("안전"
     "安全"
     "案前")
    ("안전거리"
     "安全距離")
    ("안전경"
     "安全鏡")
    ("안전도"
     "安全度")
    ("안전망"
     "安全網")
    ("안전모"
     "安全帽")
    ("안전사고"
     "安全事故")
    ("안전선"
     "安全線")
    ("안전성"
     "安全性")
    ("안전시설"
     "安全施設")
    ("안전원"
     "安全員")
    ("안전장치"
     "安全裝置")
    ("안전지대"
     "安全地帶")
    ("안전판"
     "安全瓣")
    ("안전표지판"
     "安全標識板")
    ("안전화"
     "安全靴")
    ("안정"
     "安定"
     "安靜")
    ("안정감"
     "安定感"
     "安靜感")
    ("안정권"
     "安定圈")
    ("안정론"
     "安定論")
    ("안정률"
     "安定率")
    ("안정성"
     "安定性")
    ("안정세"
     "安定勢")
    ("안정적"
     "安定的")
    ("안정제"
     "安靜劑")
    ("안정주"
     "安定株")
    ("안정책"
     "安定策")
    ("안정화"
     "安定化")
    ("안존"
     "安存")
    ("안주"
     "安住"
     "安州"
     "按酒")
    ("안중"
     "眼中")
    ("안중정"
     "眼中釘")
    ("안질환"
     "眼疾患")
    ("안집"
     "安集")
    ("안착"
     "安着")
    ("안치"
     "安置")
    ("안치소"
     "安置所")
    ("안치실"
     "安置室")
    ("안타"
     "安打")
    ("안택정로"
     "安宅正路")
    ("안통"
     "眼痛")
    ("안투지배"
     "眼透紙背")
    ("안하무인"
     "眼下無人")
    ("알"
     ("斡" . "돌릴 알, 주선할 알")
     ("謁" . "아뢸 알, 뵈올 알")
     ("軋" . "수레 삐걱거릴 알")
     "閼"
     ("嘎" . "새소리 알")
     ("戞" . "창 알")
     ("揠" . "뽑을 알")
     ("穵" . "구멍 알")
     ("訐" . "들추어 낼 알")
     ("遏" . "막을 알")
     ("頞" . "콧마루 알")
     ("鴶" . "뻐꾸기 알"))
    ("알력"
     "軋轢")
    ("알선"
     "斡旋")
    ("알선자"
     "斡旋者")
    ("알선책"
     "斡旋責")
    ("알현"
     "謁見")
    ("암"
     "俺"
     "唵"
     ("岩" . "巖의 俗字")
     ("巖" . "바위 암, 험할 암")
     ("庵" . "초막 암")
     ("暗" . "어두울 암, 몰래 암, 어리석을 암")
     ("癌" . "종양 암")
     ("菴" . "암자 암")
     ("闇" . "어두울 암, 어리석을 암")
     ("啽" . "잠꼬대 암")
     ("媕" . "머뭇거릴 암")
     ("嵓" . "바위 암, 가파를 암")
     ("晻" . "어두울 암")
     ("腤" . "고기 삶을 암")
     ("葊" . "풀이름 암")
     ("蓭" . "암자 암")
     ("諳" . "욀 암")
     ("馣" . "향기로울 암")
     ("黯" . "어두울 암"))
    ("암갈색"
     "暗褐色")
    ("암거래"
     "暗去來")
    ("암거래상"
     "暗去來商")
    ("암권"
     "巖圈")
    ("암기"
     "暗記")
    ("암녹색"
     "暗綠色")
    ("암담"
     "暗澹")
    ("암류"
     "暗流")
    ("암막"
     "暗幕")
    ("암매"
     "暗賣")
    ("암묵적"
     "暗默的")
    ("암문"
     "暗門")
    ("암반"
     "巖盤")
    ("암벽"
     "巖壁")
    ("암벽화"
     "巖壁畵")
    ("암살"
     "暗殺")
    ("암살단"
     "暗殺團")
    ("암살당"
     "暗殺當")
    ("암색"
     "暗色")
    ("암석"
     "巖石")
    ("암세포"
     "癌細胞")
    ("암세포적"
     "癌細胞的")
    ("암송"
     "暗誦")
    ("암시"
     "暗示")
    ("암시성"
     "暗示性")
    ("암시적"
     "暗示的")
    ("암암리"
     "暗暗裏")
    ("암약"
     "暗躍")
    ("암운"
     "暗雲")
    ("암울"
     "暗鬱")
    ("암자"
     "庵子")
    ("암자색"
     "暗紫色")
    ("암장"
     "暗葬")
    ("암적"
     "癌的")
    ("암적색"
     "暗赤色")
    ("암주"
     "巖柱")
    ("암중모색"
     "暗中摸索")
    ("암중비약"
     "暗中飛躍")
    ("암청색"
     "暗靑色")
    ("암초"
     "暗礁")
    ("암투"
     "暗鬪")
    ("암행"
     "暗行")
    ("암행어사"
     "暗行御史")
    ("암호"
     "暗號")
    ("암호화"
     "暗號化")
    ("암회갈색"
     "暗灰褐色")
    ("암회색"
     "暗灰色")
    ("암흑"
     "暗黑")
    ("암흑기"
     "暗黑期")
    ("암흑리"
     "暗黑裡")
    ("암흑색"
     "暗黑色")
    ("암흑시대"
     "暗黑時代")
    ("압"
     ("壓" . "누를 압")
     "岬"
     ("押" . "수결 둘 압, 누를 압")
     ("狎" . "친근할 압, 업신여길 압")
     ("鴨" . "오리 압")
     "礏"
     "罨")
    ("압권"
     "壓卷")
    ("압도"
     "壓倒")
    ("압도당"
     "壓倒當")
    ("압도적"
     "壓倒的")
    ("압력"
     "壓力")
    ("압류"
     "押留")
    ("압맥"
     "壓麥")
    ("압박"
     "壓迫")
    ("압박감"
     "壓迫感")
    ("압살"
     "壓殺")
    ("압송"
     "押送")
    ("압수"
     "押守"
     "押收")
    ("압승"
     "壓勝")
    ("압이경지"
     "狎而敬之")
    ("압제"
     "壓制")
    ("압착"
     "壓搾")
    ("압축"
     "壓縮")
    ("압축기"
     "壓縮機")
    ("압축적"
     "壓縮的")
    ("압출기"
     "壓出機")
    ("압통"
     "壓痛")
    ("앙"
     ("仰" . "우러를 앙")
     ("央" . "가운데 앙")
     ("怏" . "원망할 앙")
     ("昻" . "오를 앙, 밝을 앙")
     ("殃" . "재앙 앙")
     ("秧" . "모 앙")
     ("鴦" . "암원앙새 앙")
     ("卬" . "자기 앙")
     ("坱" . "티끌 앙")
     ("泱" . "끝없을 앙")
     ("盎" . "동이 앙")
     ("鞅" . "가슴걸이 앙, 소고삐 앙"))
    ("앙거"
     "仰擧")
    ("앙급지어"
     "殃及池魚")
    ("앙등"
     "昻騰")
    ("앙불괴어천"
     "仰不愧於天")
    ("앙사부휵"
     "仰事俯畜")
    ("앙수신미"
     "仰首伸眉")
    ("앙숙"
     "怏宿")
    ("앙심"
     "怏心")
    ("앙앙불락"
     "怏怏不樂")
    ("앙양"
     "昻揚")
    ("앙천대소"
     "仰天大笑")
    ("앙천이타"
     "仰天而唾")
    ("애"
     ("厓" . "언덕 애, 물가 애")
     ("哀" . "슬플 애, 가여울 애")
     ("喝" . "목 쉴 애")
     ("埃" . "티끌 애, 속세 애")
     ("崖" . "낭떠러지 애")
     ("愛" . "사랑 애")
     ("曖" . "희미할 애")
     ("涯" . "물가 애")
     ("碍" . "礙의 俗字")
     ("艾" . "쑥 애")
     ("隘" . "좁을 애")
     ("靄" . "아지랭이 애")
     ("僾" . "어렴풋할 애")
     ("唉" . "대답하는 소리 애")
     ("啀" . "물어뜯을 애")
     ("噯" . "트림할 애")
     ("娭" . "계집종 애")
     ("崕" . "崖와 同字")
     ("挨" . "밀칠 애")
     ("捱" . "막을 애")
     ("欸" . "한숨쉴 애")
     ("漄" . "물가 애")
     ("獃" . "어리석을 애")
     ("皚" . "흴 애")
     ("睚" . "눈흘길 애")
     ("瞹" . "흐릿할 애")
     ("磑" . "맷돌 애")
     ("礙" . "막을 애")
     ("薆" . "숨겨질 애")
     ("藹" . "화기로울 애")
     ("靉" . "구름낄 애")
     ("騃" . "어리석을 애, 말달릴 애"))
    ("애걸"
     "哀乞")
    ("애걸복걸"
     "哀乞伏乞")
    ("애견"
     "愛犬")
    ("애경사"
     "哀慶事")
    ("애고"
     "愛顧")
    ("애교"
     "愛嬌")
    ("애교심"
     "愛校心")
    ("애국"
     "愛國")
    ("애국시"
     "愛國詩")
    ("애국심"
     "愛國心")
    ("애국자"
     "愛國者")
    ("애국적"
     "愛國的")
    ("애국정신"
     "愛國精神")
    ("애국주의자"
     "愛國主義者")
    ("애급옥오"
     "愛及屋烏")
    ("애덕"
     "愛德")
    ("애도"
     "哀悼")
    ("애도회"
     "哀悼會")
    ("애독서"
     "愛讀書")
    ("애독자"
     "愛讀者")
    ("애련"
     "哀憐")
    ("애로"
     "隘路")
    ("애매"
     "曖昧")
    ("애매모호"
     "曖昧模糊")
    ("애매성"
     "曖昧性")
    ("애모심"
     "愛慕心")
    ("애무"
     "愛撫")
    ("애별리고"
     "愛別離苦")
    ("애사심"
     "愛社心")
    ("애상"
     "哀想")
    ("애상적"
     "哀傷的")
    ("애석"
     "哀惜")
    ("애수"
     "哀愁")
    ("애연가"
     "愛煙家")
    ("애완견"
     "愛玩犬")
    ("애완동물"
     "愛玩動物")
    ("애욕"
     "愛慾")
    ("애용"
     "愛用")
    ("애원"
     "哀怨"
     "哀願")
    ("애이불상"
     "哀而不傷")
    ("애인"
     "愛人")
    ("애인이덕"
     "愛人以德")
    ("애장품"
     "愛藏品")
    ("애절"
     "哀切")
    ("애정"
     "愛情")
    ("애제자"
     "愛弟子")
    ("애족"
     "愛族")
    ("애증"
     "愛憎")
    ("애지중지"
     "愛之重之")
    ("애착"
     "愛着")
    ("애착심"
     "愛着心")
    ("애창곡"
     "愛唱曲")
    ("애처가"
     "愛妻家")
    ("애첩"
     "愛妾")
    ("애청자"
     "愛聽者")
    ("애칭"
     "愛稱")
    ("애통"
     "哀痛")
    ("애향"
     "愛鄕")
    ("애호"
     "愛好")
    ("애호가"
     "愛好家")
    ("애호국"
     "愛好國")
    ("애호도"
     "愛好度")
    ("애호층"
     "愛好層")
    ("애환"
     "哀歡")
    ("애훼골립"
     "哀毁骨立")
    ("액"
     ("厄" . "재앙 액")
     ("扼" . "움켜쥘 액")
     ("掖" . "겨드랑이에 낄 액")
     ("液" . "즙 액")
     ("縊" . "목 맬 액")
     ("腋" . "겨드랑이 액")
     ("額" . "이마 액, 수량 액")
     ("呝" . "울 액")
     ("戹" . "좁을 액")
     ("搤" . "움켜쥘 액")
     ("阨" . "막힐 액"))
    ("액면"
     "額面")
    ("액면가"
     "額面價")
    ("액면가액"
     "額面價額")
    ("액상"
     "液狀")
    ("액수"
     "額數")
    ("액운"
     "厄運")
    ("액자"
     "額子")
    ("액자식"
     "額子式")
    ("액체"
     "液體")
    ("액화"
     "液化")
    ("앵"
     ("櫻" . "앵두나무 앵")
     ("罌" . "술병 앵")
     ("鶯" . "꾀꼬리 앵")
     ("鸚" . "앵무새 앵")
     ("嚶" . "새 소리 앵")
     ("嫈" . "예쁠 앵")
     ("罃" . "술병 앵")
     ("鷪" . "꾀꼬리 앵"))
    ("앵무"
     "鸚鵡")
    ("야"
     ("也" . "단정의 어조사 야")
     ("倻" . "땅이름 야")
     ("冶" . "단련할 야, 대장장이 야")
     ("夜" . "밤 야")
     "射"
     ("惹" . "끌릴 야, 어지러울 야")
     ("揶" . "희롱할 야")
     ("椰" . "야자나무 야")
     ("爺" . "아비 야, 노인 야")
     ("耶" . "의문의 어조야 야, 아비 야")
     ("野" . "들판 야")
     ("若" . "땅이름 야, 지혜(범어의 음역) 야")
     ("埜" . "들판 야"))
    ("야가무식도"
     "冶家無食刀")
    ("야간"
     "夜間")
    ("야간열차"
     "夜間列車")
    ("야간작업"
     "夜間作業")
    ("야경"
     "夜景"
     "夜警")
    ("야광"
     "夜光")
    ("야광침"
     "夜光針")
    ("야구"
     "野球")
    ("야구부"
     "野球部")
    ("야구장"
     "野球場")
    ("야권"
     "野圈")
    ("야근"
     "夜勤")
    ("야근자"
     "夜勤者")
    ("야기"
     "惹起")
    ("야기자"
     "惹起者")
    ("야기형"
     "惹起型")
    ("야단"
     "惹端")
    ("야단법석"
     "野壇法席")
    ("야단야단"
     "惹端惹端")
    ("야당"
     "野黨")
    ("야당사"
     "野黨史")
    ("야당인"
     "野黨人")
    ("야도"
     "野都")
    ("야만"
     "野蠻")
    ("야만시"
     "野蠻視")
    ("야만인"
     "野蠻人")
    ("야만적"
     "野蠻的")
    ("야망"
     "野望")
    ("야무청초"
     "野無靑草")
    ("야박"
     "野薄")
    ("야반도주"
     "夜半逃走")
    ("야불답백"
     "夜不踏白")
    ("야불폐문"
     "夜不閉門")
    ("야비"
     "野卑")
    ("야산"
     "野山")
    ("야산대"
     "野山帶")
    ("야산지"
     "野山地")
    ("야생"
     "野生")
    ("야생마"
     "野生馬")
    ("야생조"
     "野生鳥")
    ("야생화"
     "野生花")
    ("야성"
     "野性")
    ("야성미"
     "野性美")
    ("야성적"
     "野性的")
    ("야세"
     "野勢")
    ("야속"
     "野俗")
    ("야수적"
     "野獸的")
    ("야수파"
     "野獸派")
    ("야식"
     "夜食")
    ("야심"
     "野心")
    ("야심만만"
     "野心滿滿")
    ("야심작"
     "野心作")
    ("야심적"
     "野心的")
    ("야영"
     "野營")
    ("야영객"
     "野營客")
    ("야영장"
     "野營場")
    ("야외"
     "野外")
    ("야외극장"
     "野外劇場")
    ("야외무대"
     "野外舞臺")
    ("야외숙"
     "野外宿")
    ("야욕"
     "野慾")
    ("야유"
     "揶揄")
    ("야유회"
     "野遊會")
    ("야음"
     "夜陰")
    ("야이계일"
     "夜以繼日")
    ("야이망침"
     "夜而忘寢")
    ("야인"
     "野人")
    ("야자"
     "椰子")
    ("야자수"
     "椰子樹")
    ("야자유"
     "椰子油")
    ("야전"
     "野戰")
    ("야조"
     "野鳥")
    ("야차"
     "夜叉")
    ("야채"
     "野菜")
    ("야초라"
     "野草羅")
    ("야폭"
     "夜爆")
    ("야표"
     "野票")
    ("야학"
     "夜學")
    ("야학당"
     "夜學堂")
    ("야합"
     "野合")
    ("야합적"
     "野合的")
    ("야행성"
     "夜行性")
    ("야회"
     "夜會")
    ("약"
     ("弱" . "약할 약, 어릴 약")
     ("約" . "대략 약, 맹세할 약, 간소할 약, 맺을 약")
     ("若" . "같을 약, 자네 약, 만약 약")
     ("葯" . "꽃밥 약")
     ("蒻" . "구약나물 약")
     ("藥" . "약 약")
     ("躍" . "뛸 약")
     ("掠" . "노략질할 약")
     ("略" . "간략할 약, 노략질할 약, 잔꾀 약")
     ("爚" . "스러질 약")
     ("禴" . "종묘의 여름제사 약")
     ("篛" . "죽순 약")
     ("籥" . "피리 약, 잠글 약")
     ("鑰" . "자물쇠 약")
     ("鰯" . "멸치 약, 정어리 약")
     ("鶸" . "댓닭 약, 투계 약")
     ("龠" . "피리 약"))
    ("약간"
     "若干")
    ("약과"
     "藥果")
    ("약관"
     "弱冠"
     "約款")
    ("약국"
     "藥局")
    ("약능제강"
     "弱能制强")
    ("약대"
     "藥大")
    ("약도"
     "略圖")
    ("약동"
     "躍動")
    ("약력"
     "弱力"
     "略歷")
    ("약롱중물"
     "藥籠中物")
    ("약마복중"
     "弱馬卜重")
    ("약물"
     "藥物")
    ("약방"
     "藥房")
    ("약방감초"
     "藥房甘草")
    ("약방문"
     "藥方文")
    ("약봉지"
     "藥封紙")
    ("약불승의"
     "若不勝衣")
    ("약사"
     "藥師")
    ("약사발"
     "藥沙鉢")
    ("약산성"
     "弱酸性")
    ("약석지언"
     "藥石之言")
    ("약선"
     "藥膳")
    ("약성"
     "藥性")
    ("약세"
     "弱勢")
    ("약소"
     "略少")
    ("약소국"
     "弱小國")
    ("약속"
     "約束")
    ("약수"
     "藥水")
    ("약수통"
     "藥水桶")
    ("약술"
     "略述")
    ("약시"
     "弱視")
    ("약식"
     "略式")
    ("약육강식"
     "弱肉强食")
    ("약이능강"
     "弱而能强")
    ("약자"
     "弱者")
    ("약재"
     "藥材")
    ("약점"
     "弱點")
    ("약정"
     "約定")
    ("약제"
     "藥劑")
    ("약조"
     "約條")
    ("약주"
     "藥酒")
    ("약지"
     "藥指")
    ("약진"
     "躍進")
    ("약질"
     "弱質")
    ("약체"
     "弱體")
    ("약초"
     "藥草")
    ("약취"
     "略取")
    ("약칭"
     "略稱")
    ("약탈"
     "掠奪")
    ("약탈당"
     "掠奪當")
    ("약탈적"
     "掠奪的")
    ("약탕"
     "藥湯")
    ("약통"
     "藥桶")
    ("약표"
     "略表")
    ("약품"
     "藥品")
    ("약학"
     "藥學")
    ("약합부절"
     "若合符節")
    ("약혼"
     "約婚")
    ("약혼녀"
     "約婚女")
    ("약혼식"
     "約婚式")
    ("약혼자"
     "約婚者")
    ("약화"
     "弱化"
     "藥禍")
    ("약효"
     "藥效")
    ("양"
     ("佯" . "거짓 양, 어정거릴 양")
     ("壤" . "흙 양, 풍년들 양")
     ("孃" . "계집아이 양")
     ("恙" . "근심 양")
     ("揚" . "드높일 양, 칭찬할 양")
     ("攘" . "물리칠 양, 빼앗을 양")
     ("敭" . "오를 양")
     ("暘" . "해 돋을 양")
     ("楊" . "갯버들 양")
     ("樣" . "모양 양, 모범 양")
     ("洋" . "큰 바다 양, 넘칠 양")
     ("瀁" . "물결 일렁일 양")
     ("煬" . "구울 양")
     ("痒" . "가려울 양, 옴 양")
     ("瘍" . "머리헐 양, 종기 양")
     ("禳" . "푸닥거리할 양")
     ("穰" . "풍년들 양")
     ("羊" . "양 양")
     ("襄" . "오를 양, 장사지낼 양")
     ("讓" . "사양할 양")
     ("釀" . "술 빚을 양")
     ("陽" . "볕 양, 드러낼 양, 시월 양, 거짓 양")
     ("養" . "기를 양, 다스릴 양, 봉양할 양")
     ("亮" . "밝을 량, 임금의 상중 량")
     ("兩" . "두 량")
     ("凉" . "서늘할 량")
     ("梁" . "들보 량, 다리 량")
     ("糧" . "양식 량")
     ("良" . "어질 량, 좋을 량, 남편 량")
     ("諒" . "헤아릴 량")
     ("量" . "헤아릴 량, 용량 량")
     ("徉" . "배회할 양")
     ("漾" . "물결 출렁거릴 양")
     ("瀼" . "이슬 많은 모양 양, 강이름 양")
     ("烊" . "구울 양, 녹일 양")
     ("癢" . "가려울 양")
     ("眻" . "눈 아름다울 양")
     ("蘘" . "양하 양")
     ("輰" . "상여수레 양")
     ("鑲" . "거푸집 속 양")
     ("颺" . "날릴 양, 높일 양")
     ("驤" . "날뛰는 말 양"))
    ("양가"
     "兩家")
    ("양가성"
     "兩價性")
    ("양가적"
     "兩價的")
    ("양감"
     "量感")
    ("양개음폐"
     "陽開陰閉")
    ("양계"
     "養鷄")
    ("양계업"
     "養鷄業")
    ("양곡"
     "糧穀")
    ("양공주"
     "洋公主")
    ("양광"
     "陽光")
    ("양국"
     "兩國")
    ("양군"
     "兩軍")
    ("양궁"
     "洋弓")
    ("양궁난장"
     "良弓難張")
    ("양극"
     "兩極")
    ("양극단"
     "兩極端")
    ("양극적"
     "兩極的")
    ("양극화"
     "兩極化")
    ("양금미옥"
     "良金美玉")
    ("양금신족"
     "量衾伸足")
    ("양금택목"
     "良禽擇木")
    ("양기"
     "陽氣")
    ("양녀"
     "養女")
    ("양단"
     "洋緞")
    ("양단간"
     "兩端間")
    ("양당"
     "兩黨")
    ("양당제"
     "兩黨制")
    ("양대"
     "兩大")
    ("양도"
     "讓渡")
    ("양도분"
     "讓渡分")
    ("양도성"
     "讓渡性")
    ("양돈"
     "養豚")
    ("양돈업"
     "養豚業")
    ("양동작전"
     "陽動作戰")
    ("양두구육"
     "羊頭狗肉")
    ("양두색이"
     "兩豆塞耳")
    ("양력"
     "陽曆")
    ("양로당"
     "養老黨")
    ("양로원"
     "養老院")
    ("양론"
     "兩論")
    ("양립"
     "兩立")
    ("양말"
     "洋襪")
    ("양면"
     "兩面")
    ("양면성"
     "兩面性")
    ("양면적"
     "兩面的")
    ("양목"
     "楊木"
     "洋木")
    ("양묘기"
     "揚錨機")
    ("양무용"
     "洋舞踊")
    ("양물"
     "洋物")
    ("양미간"
     "兩眉間")
    ("양민"
     "良民")
    ("양반"
     "兩班"
     "兩班")
    ("양반가"
     "兩班家")
    ("양반국"
     "兩班國")
    ("양반이경"
     "讓畔而耕")
    ("양반촌"
     "兩班村")
    ("양반층"
     "兩班層")
    ("양방"
     "洋方"
     "兩方")
    ("양보"
     "讓步")
    ("양복"
     "洋服")
    ("양복점"
     "洋服店")
    ("양봉"
     "養蜂")
    ("양봉연비"
     "兩鳳連飛")
    ("양분"
     "養分"
     "兩分")
    ("양분법"
     "兩分法")
    ("양분화"
     "兩分化")
    ("양비대담"
     "攘臂大談")
    ("양비론"
     "兩非論")
    ("양사주석"
     "揚沙走石")
    ("양산"
     "陽傘"
     "量産")
    ("양상"
     "樣相")
    ("양상군자"
     "梁上君子")
    ("양상도회"
     "梁上塗灰")
    ("양생"
     "養生")
    ("양생법"
     "養生法")
    ("양생송사"
     "養生送死")
    ("양서"
     "良書")
    ("양서류"
     "兩棲類")
    ("양성"
     "陽性"
     "養成"
     "兩性")
    ("양성소"
     "養成所")
    ("양성자"
     "陽性子")
    ("양성화"
     "陽性化")
    ("양속"
     "良俗")
    ("양수"
     "揚水"
     "羊水"
     "讓受"
     "陽數")
    ("양수겸장"
     "兩手兼將")
    ("양수집병"
     "兩手執餠")
    ("양수척"
     "楊水尺")
    ("양수청풍"
     "兩袖淸風")
    ("양순음위"
     "陽順陰違")
    ("양시론"
     "兩是論")
    ("양시쌍비"
     "兩是雙非")
    ("양식"
     "樣式"
     "洋食"
     "養殖"
     "糧食"
     "良識")
    ("양식당"
     "洋食堂")
    ("양식론"
     "樣式論")
    ("양식업"
     "養殖業")
    ("양식장"
     "養殖場")
    ("양식적"
     "良識的")
    ("양식화"
     "樣式化")
    ("양심"
     "良心")
    ("양심선언"
     "良心宣言")
    ("양심선언자"
     "良心宣言者")
    ("양심수"
     "良心囚")
    ("양심적"
     "良心的")
    ("양안"
     "量案")
    ("양압"
     "兩壓")
    ("양약"
     "洋藥")
    ("양약고어구"
     "良藥苦於口")
    ("양어장"
     "養魚場")
    ("양옥"
     "洋屋")
    ("양용형"
     "兩用型")
    ("양웅불구립"
     "兩雄不俱立")
    ("양육"
     "養育")
    ("양육권"
     "養育權")
    ("양육자"
     "養育者")
    ("양은"
     "洋銀")
    ("양이"
     "洋夷")
    ("양인"
     "良人")
    ("양일"
     "兩日")
    ("양입계출"
     "量入計出")
    ("양자"
     "陽子"
     "養子"
     "兩者"
     "量子")
    ("양자론"
     "量子論")
    ("양자식지친력"
     "養子息知親力")
    ("양자적"
     "兩者的")
    ("양자택일"
     "兩者擇一")
    ("양자택일론"
     "兩者擇一論")
    ("양자택일적"
     "兩者擇一的")
    ("양잠"
     "養蠶")
    ("양장"
     "洋裝")
    ("양장점"
     "洋裝店")
    ("양재"
     "禳災"
     "量材")
    ("양적"
     "量的")
    ("양전자"
     "陽電子")
    ("양전하"
     "陽電荷")
    ("양조"
     "釀造")
    ("양조장"
     "釀造場")
    ("양좌"
     "羊座")
    ("양주"
     "洋紬"
     "洋酒")
    ("양지"
     "陽地")
    ("양지양능"
     "良知良能")
    ("양질"
     "良質")
    ("양질호피"
     "羊質虎皮")
    ("양질화"
     "良質化")
    ("양차"
     "兩次")
    ("양천"
     "養天")
    ("양천제"
     "良賤制")
    ("양철"
     "洋鐵")
    ("양춘가절"
     "陽春佳節")
    ("양측"
     "兩側")
    ("양친"
     "兩親")
    ("양태"
     "樣態")
    ("양편"
     "兩便")
    ("양품점"
     "洋品店")
    ("양해"
     "諒解")
    ("양호"
     "養護"
     "良好")
    ("양호상투"
     "兩虎相鬪")
    ("양호실"
     "養護室")
    ("양호유환"
     "養虎遺患")
    ("양화"
     "洋靴"
     "良貨"
     "量化")
    ("양화기"
     "揚貨機")
    ("어"
     ("圄" . "가둘 어")
     ("御" . "거느릴 어")
     ("於" . "방향의 어조사 어, 대신할 어")
     ("漁" . "물고기 잡을 어")
     ("瘀" . "어혈질 어")
     ("禦" . "막을 어, 그칠 어")
     ("語" . "말씀 어")
     ("馭" . "말 부릴 어")
     ("魚" . "물고기 어")
     ("齬" . "이 어긋날 어")
     ("圉" . "마부 어, 변방 어")
     ("敔" . "금할 어, 풍류그칠 어")
     ("淤" . "앙금 어, 진흙 어")
     "茣"
     ("飫" . "먹기 싫을 어, 배부를 어"))
    ("어감"
     "語感")
    ("어구"
     "漁具"
     "語句")
    ("어구대"
     "漁具代")
    ("어구점"
     "漁具店")
    ("어군"
     "語群"
     "魚群")
    ("어눌"
     "語訥")
    ("어대"
     "魚袋")
    ("어동육서"
     "魚東肉西")
    ("어두육미"
     "魚頭肉尾")
    ("어란토붕"
     "魚爛土崩")
    ("어로"
     "漁撈")
    ("어로불변"
     "魚魯不辨")
    ("어록"
     "語錄")
    ("어료지"
     "御料地")
    ("어류"
     "魚類")
    ("어린학익"
     "魚鱗鶴翼")
    ("어망"
     "漁網")
    ("어망홍리"
     "魚網鴻離")
    ("어명"
     "御命")
    ("어목연석"
     "魚目燕石")
    ("어목혼주"
     "魚目混珠")
    ("어문"
     "語文")
    ("어문계"
     "語文係")
    ("어문과장"
     "語文科長")
    ("어문일치"
     "語文一致")
    ("어문학"
     "語文學")
    ("어미"
     "語尾")
    ("어민"
     "漁民")
    ("어법"
     "語法")
    ("어변성룡"
     "魚變成龍")
    ("어부"
     "漁夫")
    ("어부지리"
     "漁夫之利"
     "漁父之利")
    ("어불성설"
     "語不成說"
     "語不成說")
    ("어불택발"
     "語不擇發")
    ("어사화"
     "御賜花")
    ("어색"
     "語塞")
    ("어선"
     "漁船"
     "魚船")
    ("어선단"
     "漁船團")
    ("어세"
     "漁稅")
    ("어순"
     "語順")
    ("어시장"
     "魚市場")
    ("어아주"
     "魚牙紬")
    ("어언"
     "於焉")
    ("어언간"
     "於焉間")
    ("어업"
     "漁業")
    ("어역"
     "語域")
    ("어염시수"
     "魚鹽柴水")
    ("어용"
     "御用")
    ("어용상인"
     "御用商人")
    ("어용화"
     "御用化")
    ("어원"
     "語源")
    ("어유"
     "魚油")
    ("어유부중"
     "魚遊釜中")
    ("어음"
     "語音")
    ("어이아이"
     "於異阿異")
    ("어장"
     "漁場")
    ("어장대"
     "御將臺")
    ("어전"
     "御前"
     "御殿")
    ("어조"
     "語調")
    ("어족"
     "語族"
     "魚族")
    ("어종"
     "魚種")
    ("어중"
     "於中")
    ("어중간"
     "於中間")
    ("어질용문"
     "魚質龍文")
    ("어차어피"
     "於此於彼")
    ("어차피"
     "於此彼")
    ("어초한화"
     "漁樵閑話")
    ("어촌"
     "漁村")
    ("어탐기"
     "漁探機")
    ("어투"
     "語套")
    ("어판장"
     "魚販場")
    ("어패류"
     "魚貝類")
    ("어폐"
     "語弊")
    ("어풍지객"
     "馭風之客")
    ("어학"
     "語學")
    ("어학연수"
     "語學硏修")
    ("어항"
     "漁港"
     "魚缸")
    ("어협"
     "漁協")
    ("어형어제"
     "漁兄漁弟")
    ("어황"
     "漁況")
    ("어획"
     "漁獲")
    ("어획고"
     "漁獲高")
    ("어획량"
     "漁獲量")
    ("어획물"
     "漁獲物")
    ("어휘"
     "語彙")
    ("어휘력"
     "語彙力")
    ("억"
     ("億" . "억 억, 편안할 억, 이바지할 억, 헤아릴 억, 인민 억")
     ("憶" . "생각 억")
     ("抑" . "누를 억, 억울할 억")
     ("檍" . "참죽나무 억, 박달나무 억, 싸리나무 억")
     ("臆" . "가슴 억, 가득할 억")
     "薏"
     "嶷"
     ("繶" . "땋은 노 억"))
    ("억강부약"
     "抑强扶弱")
    ("억겁"
     "億劫")
    ("억견"
     "臆見")
    ("억대"
     "億臺")
    ("억류"
     "抑留")
    ("억불"
     "抑佛")
    ("억압"
     "抑壓")
    ("억압당"
     "抑壓當")
    ("억압자"
     "抑壓者")
    ("억압적"
     "抑壓的")
    ("억양"
     "抑揚")
    ("억울"
     "抑鬱")
    ("억장"
     "億丈")
    ("억제"
     "抑制")
    ("억제책"
     "抑制策")
    ("억조창생"
     "億兆蒼生")
    ("억지"
     "抑止")
    ("억지력"
     "抑止力")
    ("억측"
     "臆測")
    ("억하심정"
     "抑何心情")
    ("언"
     ("偃" . "자빠질 언")
     ("堰" . "방죽 언")
     ("彦" . "彥과 同字")
     ("焉" . "어찌 언, 의심쩍을 언")
     ("言" . "말씀 언, 자기 언, 우뚝할 언")
     ("諺" . "상말 언")
     ("傿" . "鄢과 同字")
     ("匽" . "숨길 언, 길 곁 언, 한데 뒷간 언")
     ("嫣" . "생긋생긋 웃을 언")
     ("讞" . "죄 의논할 언")
     ("鄢" . "땅이름 언")
     ("鼴" . "두더쥐 언, 소 같은 큰 쥐 언")
     ("鼹" . "鼴과 同字"))
    ("언감생심"
     "焉敢生心")
    ("언거언래"
     "言去言來")
    ("언겸"
     "言兼")
    ("언과기실"
     "言過其實")
    ("언근지원"
     "言近旨遠")
    ("언급"
     "言及")
    ("언동"
     "言動")
    ("언로"
     "言路")
    ("언론"
     "言論")
    ("언론계"
     "言論界")
    ("언론사"
     "言論史"
     "言論社")
    ("언론인"
     "言論人")
    ("언론학"
     "言論學")
    ("언명"
     "言明")
    ("언문"
     "言文")
    ("언문일치"
     "言文一致")
    ("언미향미"
     "言美響美")
    ("언변"
     "言辯")
    ("언비천리"
     "言飛千里")
    ("언사"
     "言辭")
    ("언설"
     "言說")
    ("언성"
     "言聲")
    ("언소자약"
     "言笑自若")
    ("언신지문"
     "言身之文")
    ("언약"
     "言約")
    ("언어"
     "言語")
    ("언어권"
     "言語圈")
    ("언어도단"
     "言語道斷")
    ("언어불통"
     "言語不通")
    ("언어생활"
     "言語生活")
    ("언어적"
     "言語的")
    ("언어학"
     "言語學")
    ("언어학자"
     "言語學者")
    ("언어학적"
     "言語學的")
    ("언어활동"
     "言語活動")
    ("언외지의"
     "言外之意")
    ("언유소화"
     "言有召禍")
    ("언자부지"
     "言者不知")
    ("언쟁"
     "言爭")
    ("언정이순"
     "言正理順")
    ("언중유골"
     "言中有骨")
    ("언질"
     "言質")
    ("언필칭"
     "言必稱")
    ("언행"
     "言行")
    ("언행일치"
     "言行一致")
    ("얼"
     ("孼" . "첩자식 얼, 요물 얼")
     ("蘖" . "그루터기 얼")
     ("臬" . "법 얼, 문지방 얼, 과녁 얼"))
    ("엄"
     ("俺" . "자기 엄, 클 엄")
     ("儼" . "공경할 엄")
     ("嚴" . "굳셀 엄, 공경할 엄, 엄할 엄")
     ("奄" . "문득 엄, 가릴 엄, 그칠 엄, 오랠 엄")
     ("掩" . "거둘 엄, 가릴 엄")
     ("淹" . "담글 엄, 오래머물 엄")
     ("崦" . "해 지는 산 이름 엄")
     ("广" . "바윗집 엄")
     "弇"
     "晻"
     ("曮" . "해 다니는 길 엄")
     ("罨" . "그물 엄")
     ("醃" . "절일 엄, 김치 엄")
     "釅"
     ("閹" . "고자 엄, 내시 엄"))
    ("엄격"
     "嚴格")
    ("엄격성"
     "嚴格性")
    ("엄금"
     "嚴禁")
    ("엄단"
     "嚴斷")
    ("엄동"
     "嚴冬")
    ("엄동설한"
     "嚴冬雪寒")
    ("엄명"
     "嚴命")
    ("엄목포작"
     "掩目捕雀")
    ("엄밀"
     "嚴密")
    ("엄밀성"
     "嚴密性")
    ("엄벌"
     "嚴罰")
    ("엄부자모"
     "嚴父慈母")
    ("엄선"
     "嚴選")
    ("엄숙"
     "嚴肅")
    ("엄숙성"
     "嚴肅性")
    ("엄숙주의"
     "嚴肅主義")
    ("엄숙주의적"
     "嚴肅主義的")
    ("엄습"
     "掩襲")
    ("엄연"
     "儼然")
    ("엄이도령"
     "掩耳盜鈴")
    ("엄정"
     "嚴正")
    ("엄정중립"
     "嚴正中立")
    ("엄존"
     "儼存")
    ("엄중"
     "嚴重")
    ("엄처시하"
     "嚴妻侍下")
    ("업"
     ("嶪" . "산이 높고 웅장할 업")
     ("業" . "일 업, 위태할 업, 씩씩할 업, 벌써 업, 공경할 업")
     ("嶫" . "嶪과 同字")
     ("鄴" . "땅이름 업, 성씨 업"))
    ("업계"
     "業界")
    ("업무"
     "業務")
    ("업무량"
     "業務量")
    ("업무부"
     "業務部")
    ("업무적"
     "業務的")
    ("업보"
     "業報")
    ("업소"
     "業所")
    ("업자"
     "業者")
    ("업적"
     "業績")
    ("업종"
     "業種")
    ("업주"
     "業主")
    ("업체"
     "業體")
    ("에"
     ("恚" . "성낼 에, 원망할 에")
     ("曀" . "음산할 에, 가리울 에")
     "饐")
    ("여"
     ("予" . "자기 여")
     ("余" . "자기 여, 남을 여")
     ("如" . "같을 여, 만약 여, 어떠할 여, 이를 여")
     ("歟" . "그런가할 어조사 여")
     ("汝" . "물 이름 여, 물에 젖을 여")
     ("璵" . "보배옥 여")
     ("礖" . "여돌 여")
     ("與" . "너울너울할 여, 더불어 여, 같을 여, 미칠 여")
     ("艅" . "나룻배 여")
     ("茹" . "띠 뿌리 여, 받을 여, 헤아릴 여")
     ("輿" . "수레바탕 여, 짐질 여")
     ("轝" . "輿와 同字")
     ("餘" . "남을 여, 나라이름 여")
     ("勵" . "힘쓸 려, 가다듬을 려")
     ("呂" . "풍류 려, 등골뼈 려, 성씨 려")
     ("女" . "계집 녀, 시집보낼 녀")
     ("廬" . "초가 려, 움막 려")
     ("旅" . "나그네 려, 베풀 려")
     ("濾" . "씻을 려, 맑을 려")
     ("礪" . "돌 단단할 려")
     ("閭" . "마을 려")
     ("驪" . "가라말 려, 나라이름 려, 산이름 려")
     ("麗" . "고울 려, 빛날 려, 베풀 려")
     ("黎" . "무리 려, 동틀 려")
     ("舁" . "마주들 여"))
    ("여가"
     "餘暇")
    ("여가수"
     "女歌手")
    ("여각"
     "旅閣")
    ("여간"
     "如干")
    ("여감방"
     "女監房")
    ("여객"
     "旅客")
    ("여객기"
     "旅客機")
    ("여객선"
     "旅客船")
    ("여건"
     "與件")
    ("여견심폐"
     "如見心肺")
    ("여경"
     "女警")
    ("여경찰관"
     "女警察官")
    ("여고"
     "女高")
    ("여고부"
     "女高部")
    ("여고생"
     "女高生")
    ("여공"
     "女工")
    ("여공불급"
     "如恐不及")
    ("여과"
     "濾過"
     "濾過")
    ("여과기"
     "濾過器")
    ("여과제"
     "濾過劑")
    ("여관"
     "旅館")
    ("여관방"
     "旅館房")
    ("여관비"
     "旅館費")
    ("여관촌"
     "旅館村")
    ("여광여취"
     "如狂如醉")
    ("여교사"
     "女敎師")
    ("여교포"
     "女僑胞")
    ("여구식약과"
     "如狗食藥果")
    ("여군"
     "女軍")
    ("여권"
     "與圈"
     "女權"
     "旅券")
    ("여권주의자"
     "女權主義者")
    ("여급"
     "女給")
    ("여남월단"
     "汝南月旦")
    ("여념"
     "餘念")
    ("여노인"
     "女老人")
    ("여단"
     "旅團")
    ("여단수족"
     "如斷手足")
    ("여단원"
     "女團員")
    ("여담"
     "餘談")
    ("여당"
     "與黨")
    ("여대"
     "女大")
    ("여대부"
     "女大部")
    ("여대생"
     "女大生")
    ("여독"
     "旅毒")
    ("여동문"
     "女同門")
    ("여동생"
     "女同生")
    ("여득천금"
     "如得千金")
    ("여력"
     "餘力")
    ("여로"
     "藜蘆"
     "旅路")
    ("여론"
     "輿論")
    ("여론화"
     "輿論化")
    ("여류"
     "女流")
    ("여리박빙"
     "如履薄氷")
    ("여말"
     "麗末")
    ("여망"
     "輿望")
    ("여명"
     "黎明")
    ("여민동락"
     "與民同樂")
    ("여반장"
     "如反掌")
    ("여발통치"
     "如拔痛齒")
    ("여배우"
     "女俳優")
    ("여백"
     "餘白")
    ("여변호사"
     "女辯護士")
    ("여복"
     "女卜")
    ("여부"
     "與否")
    ("여분"
     "餘分")
    ("여비"
     "旅費")
    ("여비사지"
     "如臂使指")
    ("여사"
     "女史")
    ("여사무원"
     "女事務員")
    ("여사원"
     "女社員")
    ("여삼추"
     "如三秋")
    ("여상"
     "女商")
    ("여생"
     "餘生")
    ("여선생"
     "女先生")
    ("여성"
     "女性"
     "女性")
    ("여성계"
     "女性界")
    ("여성관"
     "女性觀")
    ("여성부"
     "女性部")
    ("여성부장"
     "女性部長")
    ("여성상"
     "女性像")
    ("여성적"
     "女性的")
    ("여성층"
     "女性層")
    ("여성학"
     "女性學")
    ("여성형"
     "女性型")
    ("여성화"
     "女性化")
    ("여세"
     "餘勢")
    ("여세추이"
     "與世推移")
    ("여소야대"
     "與小野大")
    ("여수"
     "與受")
    ("여수투수"
     "如水投水")
    ("여승"
     "女僧")
    ("여식"
     "女息")
    ("여신"
     "與信"
     "女神")
    ("여신상"
     "女神像")
    ("여신자"
     "女信者")
    ("여실"
     "如實")
    ("여아"
     "女兒")
    ("여아부화"
     "如蛾赴火")
    ("여야"
     "與野")
    ("여어실수"
     "如魚失水")
    ("여염"
     "閭閻")
    ("여왕"
     "女王")
    ("여우"
     "女優")
    ("여운"
     "餘韻")
    ("여유"
     "餘裕")
    ("여유감"
     "餘裕感")
    ("여유만만"
     "餘裕滿滿")
    ("여유미"
     "餘裕美")
    ("여유분"
     "餘裕分")
    ("여의"
     "如意")
    ("여의사"
     "如意紗"
     "女醫師")
    ("여의주"
     "如意珠")
    ("여인"
     "女人")
    ("여인상"
     "女人像")
    ("여인숙"
     "旅人宿")
    ("여자"
     "女子")
    ("여자관계"
     "女子關係")
    ("여자부"
     "女子部")
    ("여자형"
     "女子型")
    ("여장"
     "旅裝")
    ("여장군"
     "女將軍")
    ("여장부"
     "女丈夫")
    ("여전"
     "如前")
    ("여전도회"
     "女傳道會")
    ("여정"
     "旅情"
     "旅程")
    ("여족여수"
     "如足如手")
    ("여종업원"
     "女從業員")
    ("여좌침석"
     "如坐針席")
    ("여죄"
     "餘罪")
    ("여죄수"
     "女罪囚")
    ("여주인"
     "女主人")
    ("여주인공"
     "女主人公")
    ("여중생"
     "女中生")
    ("여지"
     "餘地")
    ("여직원"
     "女職員")
    ("여진"
     "餘震")
    ("여차"
     "如此")
    ("여차여차"
     "如此如此")
    ("여차장"
     "女車掌")
    ("여체"
     "女體")
    ("여초"
     "麗初")
    ("여출일구"
     "如出一口")
    ("여측이심"
     "如厠二心")
    ("여타"
     "餘他")
    ("여탕"
     "女湯")
    ("여파"
     "餘波")
    ("여판사"
     "女判事")
    ("여편"
     "女便")
    ("여풍과이"
     "如風過耳")
    ("여필종부"
     "女必從夫")
    ("여하"
     "如何")
    ("여하간"
     "如何間")
    ("여학교"
     "女學校")
    ("여학생"
     "女學生")
    ("여학생회"
     "女學生會")
    ("여학우"
     "女學友")
    ("여한"
     "餘恨")
    ("여합부절"
     "如合符節")
    ("여행"
     "旅行")
    ("여행가"
     "旅行家")
    ("여행객"
     "旅行客")
    ("여행권"
     "旅行券")
    ("여행기"
     "旅行記")
    ("여행단"
     "旅行團")
    ("여행담"
     "旅行談")
    ("여행사"
     "旅行社")
    ("여행용"
     "旅行用")
    ("여행원"
     "旅行員")
    ("여행자"
     "旅行者")
    ("여행지"
     "旅行地")
    ("여형사"
     "女刑事")
    ("여형약제"
     "如兄若弟")
    ("여화가"
     "女畵家")
    ("여흥"
     "餘興")
    ("역"
     ("亦" . "또 역, 모두 역")
     ("域" . "경계 역, 범위 역")
     ("役" . "부릴 역, 국경 지킬 역")
     ("易" . "바꿀 역")
     ("疫" . "염병 역")
     "睫"
     ("繹" . "삭일 역, 베풀 역, 실 끝 찾을 역")
     ("譯" . "통변할 역, 번역할 역")
     ("逆" . "거스를 역")
     ("驛" . "잇닿을 역, 쌀 뾰족뾰족할 역, 역말집 역")
     ("力" . "힘 력, 부지런할 력")
     ("曆" . "셀 력, 세월 력")
     ("歷" . "지낼 력, 겪을 력")
     ("轢" . "수레바퀴에 치일 력, 서로 부닥칠 력")
     ("嶧" . "연달아 있는 산 역")
     ("懌" . "기꺼울 역")
     "斁"
     ("淢" . "빨리 흐를 역")
     ("閾" . "문지방 역")
     "鬩")
    ("역가"
     "曆家")
    ("역경"
     "逆境")
    ("역공"
     "逆攻")
    ("역관계"
     "逆關係")
    ("역관권"
     "逆官權")
    ("역광"
     "逆光")
    ("역구내"
     "驛區內")
    ("역구지분"
     "役口之分")
    ("역기"
     "力器")
    ("역기능"
     "逆機能")
    ("역기능적"
     "逆機能的")
    ("역내"
     "域內")
    ("역당"
     "逆黨")
    ("역대"
     "歷代")
    ("역도"
     "力道")
    ("역도부"
     "力道部")
    ("역동"
     "力動")
    ("역동성"
     "逆動性")
    ("역동적"
     "力動的")
    ("역량"
     "力量")
    ("역려"
     "逆旅")
    ("역려과객"
     "逆旅過客")
    ("역력"
     "歷歷")
    ("역류"
     "逆流")
    ("역린"
     "逆鱗")
    ("역마살"
     "驛馬煞")
    ("역마직성"
     "驛馬直星")
    ("역무실"
     "驛務室")
    ("역무원"
     "驛務員")
    ("역법"
     "曆法")
    ("역병"
     "疫病")
    ("역본"
     "譯本")
    ("역부족"
     "力不足")
    ("역분전"
     "役分田")
    ("역분해"
     "逆分解")
    ("역사"
     "役事"
     "驛舍"
     "力士"
     "歷史")
    ("역사가"
     "歷史家")
    ("역사관"
     "歷史觀")
    ("역사상"
     "歷史上")
    ("역사서"
     "歷史書")
    ("역사성"
     "歷史性")
    ("역사의식"
     "歷史意識")
    ("역사적"
     "歷史的")
    ("역사주의"
     "歷史主義")
    ("역사주의자"
     "歷史主義者")
    ("역사주의적"
     "歷史主義的")
    ("역사책"
     "歷史冊")
    ("역사학"
     "歷史學")
    ("역사학계"
     "歷史學界")
    ("역사학과"
     "歷史學科")
    ("역사학자"
     "歷史學者")
    ("역사학적"
     "歷史學的")
    ("역사화"
     "歷史化")
    ("역산"
     "逆算")
    ("역살"
     "轢殺")
    ("역서"
     "易書"
     "譯書"
     "曆書")
    ("역설"
     "逆說"
     "力說")
    ("역설적"
     "逆說的")
    ("역성혁명"
     "易姓革命")
    ("역세권"
     "驛勢圈")
    ("역수출"
     "逆輸出")
    ("역순"
     "逆順")
    ("역술"
     "曆術")
    ("역습"
     "逆襲")
    ("역승화"
     "逆昇華")
    ("역시"
     "亦是")
    ("역역"
     "力役")
    ("역연"
     "歷然")
    ("역외국"
     "域外國")
    ("역의병식"
     "易衣幷食")
    ("역이용"
     "逆利用")
    ("역이지언"
     "逆耳之言")
    ("역인"
     "役人")
    ("역일"
     "曆日")
    ("역임"
     "歷任")
    ("역자이교지"
     "易子而敎之")
    ("역작"
     "力作")
    ("역작용"
     "逆作用")
    ("역장"
     "驛長")
    ("역적"
     "逆賊")
    ("역전"
     "逆戰"
     "逆轉"
     "驛傳"
     "驛前")
    ("역전승"
     "逆轉勝")
    ("역전패"
     "逆轉敗")
    ("역점"
     "易占"
     "力點")
    ("역정"
     "逆情"
     "歷程")
    ("역제"
     "役制")
    ("역조"
     "逆調")
    ("역증"
     "逆症")
    ("역지사지"
     "易地思之")
    ("역질"
     "疫疾")
    ("역촌"
     "驛村")
    ("역추적"
     "逆追跡")
    ("역투지배"
     "力透紙背")
    ("역풍"
     "逆風")
    ("역학"
     "易學"
     "疫學"
     "力學")
    ("역학자"
     "易學者")
    ("역학적"
     "力學的")
    ("역할"
     "役割")
    ("역할극"
     "役割劇")
    ("역할론"
     "役割論")
    ("역행"
     "逆行")
    ("역행적"
     "逆行的")
    ("역효과"
     "逆效果")
    ("연"
     "咽"
     ("嚥" . "침 삼킬 연, 목구멍 연")
     ("堧" . "빈 땅 연")
     ("姸" . "고을 연, 사랑스러울 연")
     ("娟" . "어여쁠 연, 춤추는 모양 연")
     ("宴" . "잔치할 연, 편안할 연")
     ("延" . "미칠 연, 닿을 연")
     "懦"
     ("挻" . "당길 연, 달아날 연, 손바닥으로 칠 연")
     ("捐" . "버릴 연, 병들어 죽을 연")
     ("椽" . "서까래 연")
     ("沇" . "물 졸졸 흐를 연")
     ("沿" . "물 따라 내려갈 연, 좇을 연")
     ("涎" . "침 연, 물 졸졸 흐를 연")
     ("涓" . "물방울 떨어질 연, 조촐할 연")
     ("淵" . "못 연, 깊을 연, 북소리 둥둥할 연, 모래톱 연")
     ("演" . "펼칠 연, 긴 물줄기 연, 통할 연, 윤택할 연, 넓힐 연")
     ("烟" . "煙과 同字")
     ("然" . "불사를 연, 그러할 연, 허락할 연, 그러나 연")
     ("煙" . "연기 연")
     ("燃" . "불사를 연, 연등절 연")
     ("燕" . "제비 연, 편안할 연, 잔치 연, 나라이름 연")
     ("硏" . "연마할 연")
     ("硯" . "벼루 연, 돌 연")
     ("筵" . "대자리 연")
     ("緣" . "인연 연, 서두를 연")
     ("縯" . "길 연, 늘일 연")
     ("衍" . "성할 연, 넓을 연, 물이 넘칠 연, 상자 연, 아름다울 연, 흐를 연")
     ("軟" . "부드러울 연")
     ("鉛" . "납 연, 분 연")
     ("鳶" . "솔개 연")
     ("年" . "해 년, 나이 년, 나아갈 년")
     ("憐" . "불쌍할 련, 사랑할 련")
     ("戀" . "생각할 련, 사모할 련")
     ("撚" . "잡을 년, 닦을 년, 밟을 년, 손 끝으로 비빌 년")
     ("漣" . "물 놀이칠 련, 눈물 줄줄 흘릴 련")
     ("煉" . "쇠 불릴 련, 반죽할 련")
     ("璉" . "종묘 제기 련")
     ("秊" . "年의 本字")
     ("練" . "이길 련, 익힐 련, 겪을 련")
     ("聯" . "잇닿을 련, 관계할 련")
     ("輦" . "당길 련, 궁중의 길 련")
     ("蓮" . "연밥 련, 연꽃 련")
     ("連" . "이을 련, 끌릴 련")
     ("鍊" . "불린 쇠 련, 단련할 련")
     ("兗" . "고을이름 연, 믿을 연, 단정할 연")
     "吮"
     ("囦" . "물 깊을 연")
     ("埏" . "땅 가장자리 연")
     ("嬿" . "아름다울 연")
     ("悁" . "분할 연, 근심할 연")
     ("掾" . "아전 연, 기인할 연")
     ("曣" . "더울 연, 청명할 연")
     ("櫞" . "연나무 연")
     ("渷" . "물 이름 연")
     ("臙" . "목구멍 연, 연지 연")
     ("莚" . "만연할 연, 풀 이름 연")
     ("蜵" . "우렁찰 연, 벌레 이름 연")
     "蠕"
     ("讌" . "잔치 연, 모여 말할 연")
     ("鷰" . "제비 연, 씨름 연"))
    ("연가"
     "戀歌")
    ("연간"
     "年間")
    ("연간권"
     "年間券")
    ("연건축면적"
     "延建築面積")
    ("연건평"
     "延建坪")
    ("연결"
     "連結"
     "連結")
    ("연결망"
     "連結網")
    ("연결선"
     "連結線")
    ("연계"
     "連繫")
    ("연계성"
     "連繫性")
    ("연고"
     "緣故"
     "軟膏")
    ("연고권"
     "緣故權")
    ("연고자"
     "緣故者")
    ("연고지"
     "緣故地")
    ("연공서열"
     "年功序列")
    ("연관"
     "筵官"
     "聯關")
    ("연관성"
     "聯關性")
    ("연교차"
     "年較差")
    ("연구"
     "硏究")
    ("연구가"
     "硏究家")
    ("연구과"
     "硏究課")
    ("연구관"
     "硏究官")
    ("연구부"
     "硏究部")
    ("연구부장"
     "硏究部長")
    ("연구비"
     "硏究費")
    ("연구사적"
     "硏究史的")
    ("연구서"
     "硏究書")
    ("연구세심"
     "年久歲深")
    ("연구소"
     "硏究所")
    ("연구소장"
     "硏究所長")
    ("연구실"
     "硏究室")
    ("연구실장"
     "硏究室長")
    ("연구용"
     "硏究用")
    ("연구원"
     "硏究員"
     "硏究院")
    ("연구자"
     "硏究者")
    ("연구직"
     "硏究職")
    ("연구진"
     "硏究陣")
    ("연구학"
     "硏究學")
    ("연구회"
     "硏究會")
    ("연극"
     "演劇")
    ("연극계"
     "演劇界")
    ("연극과"
     "演劇科")
    ("연극관"
     "演劇觀")
    ("연극론"
     "演劇論")
    ("연극배우"
     "演劇俳優")
    ("연극사"
     "演劇史")
    ("연극사적"
     "演劇史的")
    ("연극상"
     "演劇賞")
    ("연극인"
     "演劇人")
    ("연극적"
     "演劇的")
    ("연극제"
     "演劇祭")
    ("연극패"
     "演劇牌")
    ("연극학과"
     "演劇學科")
    ("연극학자"
     "演劇學者")
    ("연극화"
     "演劇化")
    ("연금"
     "軟禁"
     "年金")
    ("연금술"
     "鍊金術")
    ("연금술적"
     "鍊金術的")
    ("연기"
     "延期"
     "演技"
     "煙氣"
     "緣起")
    ("연기력"
     "演技力")
    ("연기법"
     "演技法")
    ("연기상"
     "演技賞")
    ("연기설"
     "延期設"
     "緣起說")
    ("연기인"
     "演技人")
    ("연기자"
     "演技者")
    ("연기파"
     "演技派")
    ("연꽃형"
     "蓮-形")
    ("연내"
     "年內")
    ("연단"
     "演壇")
    ("연대"
     "年代"
     "聯隊"
     "連帶")
    ("연대감"
     "連帶感")
    ("연대기"
     "年代記")
    ("연대기적"
     "年代記的")
    ("연대기학"
     "年代記學")
    ("연대성"
     "連帶性")
    ("연대장"
     "聯隊長")
    ("연대장실"
     "聯隊長室")
    ("연대적"
     "年代的")
    ("연도"
     "沿道"
     "年度")
    ("연동"
     "聯動")
    ("연동제"
     "聯動制")
    ("연두"
     "軟豆"
     "年頭")
    ("연두색"
     "軟豆色")
    ("연둣"
     "軟豆")
    ("연등"
     "燃燈")
    ("연등회"
     "燃燈會")
    ("연락"
     "連絡"
     "連絡")
    ("연락망"
     "連絡網")
    ("연락병"
     "連絡兵")
    ("연락부"
     "連絡部")
    ("연락선"
     "連絡船")
    ("연락책"
     "連絡責")
    ("연락처"
     "連絡處")
    ("연령"
     "年齡")
    ("연령층"
     "年齡層")
    ("연례"
     "年例")
    ("연례적"
     "年例的")
    ("연례행사"
     "年例行事")
    ("연로"
     "年老")
    ("연료"
     "燃料")
    ("연료유"
     "燃料油")
    ("연루"
     "連累"
     "連累")
    ("연루자"
     "連累者")
    ("연륜"
     "年輪")
    ("연리"
     "年利")
    ("연립"
     "聯立")
    ("연마"
     "硏磨")
    ("연마기"
     "硏磨機")
    ("연마장"
     "硏磨場")
    ("연만"
     "年晩")
    ("연말"
     "年末")
    ("연말연시"
     "年末年始")
    ("연맹"
     "聯盟")
    ("연맹전"
     "聯盟戰")
    ("연맹체"
     "聯盟體")
    ("연맹형"
     "聯盟型")
    ("연면적"
     "延面積")
    ("연명"
     "延命")
    ("연모"
     "戀慕")
    ("연목구어"
     "緣木求魚")
    ("연무관"
     "演武館")
    ("연무대"
     "鍊武臺")
    ("연미지급"
     "燃眉之急")
    ("연민"
     "憐憫")
    ("연발"
     "連發")
    ("연방"
     "聯邦"
     "連方")
    ("연방군"
     "聯邦軍")
    ("연방제"
     "聯邦制")
    ("연배"
     "年輩")
    ("연변"
     "沿變"
     "沿邊")
    ("연병"
     "練兵")
    ("연병설"
     "連兵說")
    ("연병장"
     "練兵場")
    ("연보"
     "年報"
     "年譜")
    ("연봉"
     "年俸"
     "連峯")
    ("연분"
     "緣分"
     "鉛粉")
    ("연분홍"
     "軟粉紅")
    ("연사"
     "演士"
     "年事")
    ("연산"
     "演算"
     "年産")
    ("연산기"
     "演算機")
    ("연상"
     "年上"
     "聯想")
    ("연상차"
     "軟床車")
    ("연서"
     "戀書"
     "連署")
    ("연석회의"
     "連席會議")
    ("연설"
     "演說")
    ("연설문"
     "演說文")
    ("연설자"
     "演說者")
    ("연설조"
     "演說調")
    ("연설회"
     "演說會")
    ("연설회장"
     "演說會場")
    ("연성"
     "延性"
     "軟性")
    ("연성화"
     "軟性化")
    ("연세"
     "年歲")
    ("연소"
     "燃燒")
    ("연속"
     "連屬"
     "連續")
    ("연속극"
     "連續劇")
    ("연속선"
     "連續線")
    ("연속설"
     "連續說")
    ("연속성"
     "連續性")
    ("연속적"
     "連續的")
    ("연속체"
     "連續體")
    ("연쇄"
     "連鎖")
    ("연쇄적"
     "連鎖的")
    ("연쇄점"
     "連鎖店")
    ("연수"
     "硏修")
    ("연수과"
     "練修課")
    ("연수부"
     "練修部")
    ("연수비"
     "練修費")
    ("연수생"
     "硏修生")
    ("연수원"
     "練修院")
    ("연수유답"
     "烟受有畓")
    ("연수유전"
     "烟受有田")
    ("연수유전답"
     "烟受有田畓")
    ("연수처"
     "練修處")
    ("연수회"
     "練修會")
    ("연습"
     "演習"
     "練習")
    ("연습기"
     "練習機")
    ("연습량"
     "練習量")
    ("연습생"
     "練習生")
    ("연습실"
     "練習室")
    ("연습용"
     "練習用")
    ("연습장"
     "演習場"
     "練習帳")
    ("연습장지"
     "練習帳紙")
    ("연승"
     "連勝")
    ("연시"
     "連時")
    ("연안"
     "沿岸")
    ("연안국"
     "沿岸國")
    ("연애"
     "戀愛")
    ("연애결혼"
     "戀愛結婚")
    ("연애시"
     "戀愛詩")
    ("연애지상주의자"
     "戀愛至上主義者")
    ("연애편지"
     "戀愛便紙")
    ("연약"
     "軟弱")
    ("연어"
     "淵魚")
    ("연역"
     "演繹")
    ("연역적"
     "演繹的")
    ("연연"
     "戀戀")
    ("연영과"
     "演映科")
    ("연예"
     "演藝")
    ("연예가"
     "演藝街")
    ("연예계"
     "演藝界")
    ("연예인"
     "演藝人")
    ("연원"
     "淵源")
    ("연유"
     "緣由")
    ("연인"
     "戀人")
    ("연인원"
     "延人員")
    ("연일"
     "連日")
    ("연임"
     "連任")
    ("연자"
     "硏子")
    ("연작"
     "連作"
     "聯作")
    ("연장"
     "延長")
    ("연장감"
     "延長感")
    ("연장선"
     "延長線")
    ("연장자"
     "年長者")
    ("연장전"
     "延長戰")
    ("연재"
     "連載")
    ("연재소설"
     "連載小說")
    ("연적"
     "硯滴"
     "戀敵")
    ("연전연승"
     "連戰連勝")
    ("연정"
     "戀情"
     "聯政")
    ("연좌"
     "蓮座")
    ("연좌시위"
     "連坐示威")
    ("연좌차"
     "軟座車")
    ("연주"
     "演奏"
     "筵奏"
     "連奏")
    ("연주가"
     "演奏家")
    ("연주곡"
     "演奏曲")
    ("연주법"
     "演奏法")
    ("연주소"
     "演奏所")
    ("연주인"
     "演奏人")
    ("연주자"
     "演奏者")
    ("연주회"
     "演奏會")
    ("연중"
     "年中")
    ("연중무휴"
     "年中無休")
    ("연중행사"
     "年中行事")
    ("연직"
     "鉛直")
    ("연진천리"
     "煙塵千里")
    ("연차"
     "年次")
    ("연차적"
     "年次的")
    ("연착"
     "延着")
    ("연착륙"
     "延着陸"
     "軟着陸")
    ("연찬"
     "硏鑽")
    ("연천계"
     "漣川系")
    ("연체"
     "延滯")
    ("연체동물"
     "軟體動物")
    ("연체료"
     "延滯料")
    ("연초"
     "煙草"
     "年初")
    ("연초록"
     "軟草綠")
    ("연출"
     "演出")
    ("연출가"
     "演出家")
    ("연출력"
     "演出力")
    ("연출상"
     "演出賞")
    ("연출선"
     "演出線")
    ("연출자"
     "演出者")
    ("연출작"
     "演出作")
    ("연출적"
     "演出的")
    ("연출진"
     "演出陣")
    ("연층"
     "年層")
    ("연치"
     "年齒")
    ("연타"
     "連打")
    ("연탄"
     "煉炭"
     "煉炭")
    ("연통"
     "煙筒")
    ("연판장"
     "連判狀")
    ("연패"
     "連敗"
     "連覇")
    ("연평균"
     "年平均")
    ("연표"
     "年表")
    ("연필"
     "鉛筆")
    ("연필심"
     "鉛筆心")
    ("연하"
     "嚥下"
     "年下")
    ("연하고질"
     "煙霞痼疾")
    ("연하장"
     "年賀狀")
    ("연한"
     "年限")
    ("연합"
     "聯合")
    ("연합고사"
     "聯合考査")
    ("연합국"
     "聯合國")
    ("연합군"
     "聯合軍")
    ("연합사"
     "聯合司")
    ("연합체"
     "聯合體")
    ("연합체적"
     "聯合體的")
    ("연합통신"
     "聯合通信")
    ("연합회"
     "聯合會")
    ("연해"
     "沿海")
    ("연행"
     "演行"
     "連行")
    ("연형"
     "年形")
    ("연호"
     "年號"
     "連呼")
    ("연화"
     "蓮花")
    ("연화대"
     "蓮花臺")
    ("연화부수형"
     "蓮花浮水形")
    ("연화석"
     "蓮花石")
    ("연화세계"
     "蓮花世界")
    ("연회"
     "宴會")
    ("연회비"
     "年會費")
    ("연회석"
     "宴會席")
    ("연후"
     "然後")
    ("연휴"
     "連休")
    ("연희"
     "演戱")
    ("연희자"
     "演戱者")
    ("열"
     ("悅" . "즐거울 열, 복종할 열, 성씨 열")
     ("熱" . "뜨거울 열, 쏠릴 열")
     ("閱" . "겪을 열, 군대 점호할 열, 용납할 열")
     ("列" . "벌릴 렬, 무리에 들어갈 렬, 항렬 렬, 베풀 렬")
     ("劣" . "용렬할 렬, 못날 렬, 어릴 렬, 서툴 렬")
     ("咽" . "목 멜 열, 막힐 열")
     ("烈" . "불 활활 붙을 렬, 빛날 렬, 업적 렬, 아름다울 렬, 사나울 렬")
     ("裂" . "찢어질 렬, 비단 자투리 렬")
     ("說" . "기꺼울 열")
     ("噎" . "목 멜 열")
     "拽"
     "爇")
    ("열강"
     "列强")
    ("열거"
     "列擧")
    ("열광"
     "熱狂")
    ("열광적"
     "熱狂的")
    ("열구지물"
     "悅口之物")
    ("열기"
     "熱氣")
    ("열녀"
     "烈女")
    ("열녀상"
     "烈女像")
    ("열대"
     "熱帶")
    ("열대림"
     "熱帶林")
    ("열대성"
     "熱帶性")
    ("열대어"
     "熱帶魚")
    ("열도"
     "列島")
    ("열독"
     "熱讀")
    ("열등"
     "劣等")
    ("열등감"
     "劣等感")
    ("열등반"
     "劣等班")
    ("열등생"
     "劣等生")
    ("열등성"
     "劣等性")
    ("열등의식"
     "劣等意識")
    ("열람"
     "閱覽")
    ("열람권"
     "閱覽權")
    ("열람실"
     "閱覽室")
    ("열량"
     "熱量")
    ("열렬"
     "熱烈")
    ("열망"
     "熱望")
    ("열명"
     "列名")
    ("열반"
     "涅槃")
    ("열반적정"
     "涅槃寂靜")
    ("열변"
     "熱辯")
    ("열병"
     "熱病"
     "閱兵")
    ("열부"
     "烈婦")
    ("열사"
     "熱沙"
     "烈士")
    ("열선"
     "熱線")
    ("열성"
     "熱誠"
     "劣性")
    ("열성적"
     "熱誠的")
    ("열성파"
     "熱誠派")
    ("열세"
     "劣勢")
    ("열심"
     "熱心")
    ("열악"
     "劣惡")
    ("열애"
     "熱愛")
    ("열약"
     "劣弱")
    ("열역학"
     "熱力學")
    ("열연"
     "熱演")
    ("열외"
     "列外")
    ("열외자"
     "列外者")
    ("열위"
     "劣位")
    ("열의"
     "熱意")
    ("열전"
     "列傳")
    ("열전도성"
     "熱傳導性")
    ("열정"
     "熱情")
    ("열정적"
     "熱情的")
    ("열주식"
     "列柱式")
    ("열중"
     "熱中")
    ("열증"
     "熱症")
    ("열차"
     "列車")
    ("열차관"
     "列車館")
    ("열창"
     "熱唱")
    ("열처리"
     "熱處理")
    ("열판"
     "熱板")
    ("열패감"
     "劣敗感")
    ("열편"
     "裂片")
    ("열편상"
     "裂片狀")
    ("열풍"
     "烈風")
    ("열혈남아"
     "熱血男兒")
    ("열화"
     "熱火")
    ("염"
     "剡"
     ("厭" . "넉넉할 염, 아름다울 염, 게으를 염, 만족할 염, 미워할 염")
     "枏"
     ("染" . "꼭두서니 염, 물들일 염")
     ("炎" . "불꽃 염, 임금의 호 염")
     "焰"
     ("琰" . "아름다운 옥 염, 비취옥 염")
     ("艶" . "고울 염, 얼굴 탐스러울 염")
     ("苒" . "풀 우거질 염, 덧없을 염")
     "錟"
     ("閻" . "마을 염, 항간 염, 저승 염")
     ("髥" . "구레나룻 염")
     ("鹽" . "소금 염, 절일 염, 후렴 염")
     ("廉" . "맑을 렴, 조촐할 렴, 청렴할 렴, 살필 렴")
     ("念" . "생각할 념, 읽을 념, 스물 념, 대단히 짧은시각 념")
     ("捻" . "손가락으로 찍을 념")
     ("殮" . "염할 염")
     ("簾" . "발 렴")
     ("冉" . "가는 털 늘어질 염, 남생이 등 언저리 염, 침노할 염")
     ("塩" . "鹽의 俗字")
     ("懕" . "편안할 염")
     ("扊" . "문 빗장 염")
     ("檿" . "산뽕나무 염")
     ("灎" . "灩의 俗字")
     ("灩" . "물 그득할 염, 물결 출렁거릴 염")
     "焱"
     "靨"
     ("饜" . "싫을 염, 물릴 염")
     ("魘" . "잠꼬대할 염")
     ("黶" . "검은 사마귀 염"))
    ("염가"
     "廉價")
    ("염기"
     "鹽基"
     "鹽氣")
    ("염기성"
     "鹽基性")
    ("염두"
     "念頭")
    ("염량세태"
     "炎凉世態")
    ("염려"
     "念慮"
     "念慮")
    ("염려증"
     "念慮症")
    ("염료"
     "染料")
    ("염류"
     "鹽類")
    ("염문"
     "艶聞")
    ("염문설"
     "艶聞說")
    ("염병"
     "染病")
    ("염분"
     "鹽分")
    ("염불"
     "念佛")
    ("염산"
     "鹽酸")
    ("염색"
     "染色")
    ("염색업체"
     "染色業體")
    ("염색체"
     "染色體")
    ("염세주의"
     "厭世主義")
    ("염소"
     "鹽素")
    ("염원"
     "念願")
    ("염전"
     "染典"
     "鹽田")
    ("염정무이"
     "染淨無二")
    ("염좌"
     "捻挫")
    ("염주"
     "念呪"
     "念珠")
    ("염증"
     "厭症"
     "炎症")
    ("염천"
     "炎天")
    ("염초"
     "焰硝")
    ("염출"
     "捻出")
    ("염치"
     "廉恥")
    ("염탐"
     "廉探")
    ("염화"
     "鹽化")
    ("염화미소"
     "拈華微笑")
    ("염화시중"
     "拈華示衆")
    ("엽"
     ("曄" . "빛날 엽, 번개 번쩍거릴 엽")
     ("燁" . "불 이글글할 엽, 번쩍번쩍할 엽")
     ("葉" . "잎 엽, 세대 엽, 성씨 엽")
     ("獵" . "사냥할 렵, 진동할 렵, 어긋날 렵, 바람소리 렵")
     "叶"
     "揲"
     ("曅" . "曄과 同字")
     "楪"
     ("熀" . "불빛 이글이글할 녑")
     ("爗" . "불 이글글할 엽, 번쩍번쩍할 엽")
     ("靨" . "웃는 볼 옴쏙 들어갈 엽, 얼굴의 검은 사마귀 엽")
     "魘")
    ("엽관"
     "獵官")
    ("엽락지추"
     "葉落知秋")
    ("엽병"
     "葉柄")
    ("엽서"
     "葉書")
    ("엽액"
     "葉腋")
    ("엽전"
     "葉錢")
    ("엽차"
     "葉茶")
    ("엽총"
     "獵銃")
    ("영"
     ("塋" . "무덤 영")
     ("嶸" . "산 높을 영")
     ("影" . "그림자 영, 형상 영")
     ("映" . "비칠 영, 빛날 영")
     ("暎" . "비칠 영")
     ("楹" . "기둥 영, 하관들 영")
     ("榮" . "영화로울 영, 오동나무 영, 추녀 영, 꽃다울 영")
     ("永" . "길 영, 오랠 영")
     ("泳" . "헤엄칠 영")
     ("渶" . "물 맑을 영")
     ("潁" . "물 이름 영, 성씨 영")
     ("濚" . "물 돌아나갈 영")
     ("瀛" . "큰 바다 영, 신선 사는 산 영")
     ("瀯" . "물소리 영, 물 돌아나갈 영, 물웅덩이 영")
     ("煐" . "빛날 영")
     ("營" . "지을 영, 헤아릴 영, 다스릴 영, 진 영")
     ("瑛" . "옥빛 영, 수정 영")
     ("瓔" . "옥돌 영, 구슬 목걸이 영")
     ("盈" . "가득할 영, 넘칠 영, 물 흐를 영")
     ("穎" . "이삭 영, 송곳 끝 영, 빼어날 영")
     ("纓" . "갓끈 영, 말 가슴걸이 영, 얽힐 영")
     ("英" . "꽃부리 영, 영웅 영, 구름 뭉게뭉게 일어날 영, 아름다울 영")
     ("詠" . "읊을 영")
     ("迎" . "맞을 영")
     ("鍈" . "방울소리 영")
     ("霙" . "눈꽃 영, 구름 피어오를 영")
     ("令" . "하여금 령, 시킬 령, 가령 령, 개 목소리 령, 벼슬이름 령")
     ("囹" . "감옥 령")
     ("寧" . "편안할 녕, 차라리 녕, 어찌 녕")
     ("嶺" . "고개 령, 봉우리 령")
     ("怜" . "영리할 령")
     ("玲" . "옥소리 쟁그렁거릴 령, 아롱아롱할 령, 정교할 령")
     ("瑩" . "귀막이 옥 영, 밝을 영")
     ("羚" . "영양 령, 큰 뿔 양 령")
     ("聆" . "들을 령, 깨달을 령")
     ("鈴" . "방울 령")
     ("零" . "부서질 령, 비뚝비뚝 떨어질 령, 셈 나머지 령")
     ("靈" . "신령 령, 혼백 령, 좋을 령")
     ("領" . "옷깃 령, 고개 령, 거느릴 령, 받을 령")
     ("咏" . "노래할 영, 읊을 영")
     ("嬰" . "어릴 영, 더할 영, 머리치장할 영, 물요괴 영")
     ("嬴" . "성씨 영, 풀어낼 영, 가득할 영, 아름다울 영")
     ("浧" . "잠길 영, 앙금 영")
     ("濴" . "물 졸졸 흐를 영")
     ("癭" . "목 혹 영")
     ("碤" . "물 속 돌 영")
     ("縈" . "얽힐 영, 맬 영")
     ("蠑" . "도마뱀 영")
     ("贏" . "이문 남길 영, 멜 영, 자랄 영")
     ("郢" . "땅이름 영")
     ("韺" . "풍류이름 영"))
    ("영감"
     "令監"
     "令監"
     "靈感")
    ("영거"
     "領去")
    ("영겁"
     "永劫")
    ("영결식"
     "永訣式")
    ("영계"
     "靈界")
    ("영고"
     "迎鼓")
    ("영고성쇠"
     "榮枯盛衰")
    ("영공"
     "領空")
    ("영관"
     "領官")
    ("영광"
     "榮光")
    ("영교"
     "靈交")
    ("영구"
     "永久")
    ("영구불변"
     "永久不變")
    ("영구장천"
     "永久長天")
    ("영구적"
     "永久的")
    ("영구차"
     "靈柩車")
    ("영구화"
     "永久化")
    ("영국"
     "英國")
    ("영남"
     "嶺南")
    ("영내"
     "營內"
     "領內")
    ("영농"
     "營農")
    ("영농비"
     "營農費")
    ("영도"
     "領導")
    ("영동"
     "嶺東")
    ("영락"
     "零落")
    ("영령"
     "英靈")
    ("영롱"
     "玲瓏")
    ("영리"
     "營利"
     "怜悧")
    ("영리적"
     "營利的")
    ("영목"
     "靈木")
    ("영문"
     "英文")
    ("영문과"
     "英文科")
    ("영문자"
     "英文字")
    ("영문학"
     "英文學")
    ("영문학과"
     "英文學科")
    ("영문학자"
     "英文學者")
    ("영민"
     "英敏")
    ("영법"
     "泳法")
    ("영빈관"
     "迎賓館")
    ("영사"
     "領事")
    ("영사관"
     "領事館")
    ("영사실"
     "映寫室")
    ("영상"
     "映像"
     "零上")
    ("영상물"
     "映像物")
    ("영상미"
     "映像美")
    ("영상회"
     "映像會")
    ("영생"
     "永生")
    ("영서"
     "嶺西")
    ("영선공"
     "營繕工")
    ("영설지재"
     "詠雪之才")
    ("영성"
     "靈性")
    ("영성적"
     "靈性的")
    ("영세"
     "零細"
     "領洗")
    ("영세민"
     "零細民")
    ("영세불망"
     "永世不忘")
    ("영세업자"
     "零細業者")
    ("영속"
     "永續"
     "營屬")
    ("영속적"
     "永續的")
    ("영수"
     "領袖")
    ("영수증"
     "領收證")
    ("영수증철"
     "領收證綴")
    ("영순위"
     "零順位")
    ("영시"
     "詠詩"
     "零時")
    ("영아기"
     "　兒期")
    ("영악"
     "靈惡")
    ("영안실"
     "靈安室")
    ("영약"
     "靈藥")
    ("영양"
     "營養")
    ("영양가"
     "營養價")
    ("영양과"
     "營養課")
    ("영양과장"
     "營養課長")
    ("영양기"
     "營養氣")
    ("영양분"
     "營養分")
    ("영양사"
     "營養士")
    ("영양소"
     "營養素")
    ("영양식"
     "營養食")
    ("영양실조"
     "營養失調")
    ("영양원"
     "營養源")
    ("영양학자"
     "營養學者")
    ("영어"
     "英語"
     "囹圄")
    ("영어과"
     "英語科")
    ("영어권"
     "英語圈")
    ("영어부"
     "英語部")
    ("영어식"
     "英語式")
    ("영업"
     "營業")
    ("영업국장"
     "營業局長")
    ("영업권"
     "營業權")
    ("영업부"
     "營業部")
    ("영업소"
     "營業所")
    ("영업소장"
     "營業所長")
    ("영업시간"
     "營業時間")
    ("영업용"
     "營業用")
    ("영업전"
     "永業田")
    ("영업직"
     "營業職")
    ("영역"
     "領域")
    ("영역권"
     "領域權")
    ("영역성"
     "領域性")
    ("영역적"
     "領域的")
    ("영영"
     "永永")
    ("영예"
     "榮譽")
    ("영욕"
     "榮辱")
    ("영웅"
     "英雄")
    ("영웅담"
     "英雄譚")
    ("영웅시"
     "英雄視")
    ("영웅심"
     "英雄心")
    ("영웅적"
     "英雄的")
    ("영웅호걸"
     "英雄豪傑")
    ("영원"
     "永遠")
    ("영원무궁"
     "永遠無窮")
    ("영원불멸"
     "永遠不滅")
    ("영원불변"
     "永遠不變")
    ("영원성"
     "永遠性")
    ("영위"
     "營爲")
    ("영유"
     "領有")
    ("영유권"
     "領有權")
    ("영의정"
     "領議政")
    ("영인"
     "影印")
    ("영입"
     "迎入")
    ("영자"
     "英字")
    ("영자지"
     "英字紙")
    ("영자팔법"
     "永字八法")
    ("영장"
     "令狀"
     "靈長")
    ("영장주의"
     "令狀主義")
    ("영재"
     "英才")
    ("영적"
     "靈的")
    ("영전"
     "榮轉")
    ("영접"
     "迎接")
    ("영정"
     "影幀")
    ("영주"
     "永住"
     "領主")
    ("영주권"
     "永住權")
    ("영주적"
     "領主的")
    ("영지"
     "靈芝"
     "領地")
    ("영창"
     "營倉")
    ("영치"
     "領置")
    ("영치금"
     "領置金")
    ("영타"
     "英打")
    ("영토"
     "領土")
    ("영토적"
     "領土的")
    ("영특"
     "英特")
    ("영포"
     "嶺布")
    ("영하"
     "零下")
    ("영한사전"
     "英韓辭典")
    ("영합"
     "迎合")
    ("영합적"
     "迎合的")
    ("영해"
     "領海")
    ("영향"
     "影響")
    ("영향권"
     "影響圈")
    ("영향력"
     "影響力")
    ("영험"
     "靈驗")
    ("영험자"
     "靈驗者")
    ("영혼"
     "靈魂"
     "靈魂")
    ("영화"
     "映畵"
     "榮華")
    ("영화가"
     "映畵街")
    ("영화감독"
     "映畵監督")
    ("영화계"
     "映畵界")
    ("영화과"
     "映畵科")
    ("영화관"
     "映畵館")
    ("영화광"
     "映畵狂")
    ("영화배우"
     "映畵俳優")
    ("영화사"
     "映畵社")
    ("영화업"
     "映畵業")
    ("영화업체"
     "映畵業體")
    ("영화인"
     "映畵人")
    ("영화적"
     "映畵的")
    ("영화제"
     "映畵祭")
    ("영화형"
     "映畵型")
    ("영화화"
     "映畵化")
    ("예"
     ("乂" . "풀 벨 예, 다스릴 예")
     ("倪" . "어릴 예, 도울 예, 끝 예")
     ("刈" . "풀 벨 예, 죽일 예")
     ("叡" . "밝을 예, 임금 예, 어질 예")
     ("曳" . "끌 예, 당길 예, 천천히 할 예")
     ("汭" . "물 이름 예, 물 굽이 예")
     ("泄" . "내칠 예, 날개 훨훨칠 예, 흩을 예")
     ("洩" . "퍼질 예, 날개 훨훨칠 예")
     ("濊" . "흐릴 예, 물 넘칠 예")
     ("猊" . "사자 예")
     ("睿" . "슬기로울 예, 밝을 예, 통할 예")
     ("穢" . "더러울 예, 거칠 예")
     ("芮" . "풀 뾰족뾰족할 예, 물가 예, 방패끈 예, 나라이름 예, 성씨 예")
     ("藝" . "재주 예, 글 예, 가늠할 예, 극진할 예, 심을 예")
     ("蘂" . "蕊와 同字")
     ("裔" . "옷 뒷자락 예, 변방 예, 후손 예")
     ("詣" . "이를 예, 나아갈 예, 학문 통달할 예")
     ("譽" . "칭찬할 예, 이름날 예, 즐길 예")
     ("豫" . "기쁠 예, 편안할 예, 미리 예")
     ("銳" . "날카로울 예, 까끄라기 예")
     "隷"
     ("霓" . "암무지개 예")
     ("預" . "미리 예, 참여할 예")
     ("例" . "본보기 례, 견줄 례, 대부분 례")
     ("禮" . "예도 례, 인사 례")
     ("醴" . "단술 례, 고을이름 례")
     ("隸" . "종 례, 노비 례, 검열할 례")
     ("囈" . "잠꼬대할 예, 헛소리할 예")
     ("嫛" . "유순할 예, 갓난아이 예")
     "惢"
     ("拽" . "당길 예")
     ("掜" . "부칠 예, 비길 예, 잡을 예, 당길 예")
     "曀"
     ("枘" . "자루 예")
     ("獩" . "민족이름 예")
     ("瞖" . "눈에 백태 낄 예")
     ("繄" . "검푸른 비단 예, 탄식하는 소리 예")
     ("翳" . "어조사 예, 깃 일산 예, 가려 숨길 예, 새이름 예")
     ("苅" . "벨 예, 자를 예")
     ("蕊" . "꽃술 예, 꽃 예")
     ("蕋" . "蕊의 俗字")
     ("薉" . "더러울 예")
     ("蚋" . "모기 예")
     "蛻"
     ("蜺" . "말매미 예, 암무지개 예")
     ("鯢" . "암고래 예")
     ("鷖" . "갈매기 예, 봉황 예")
     ("麑" . "아기사슴 예, 사자 예"))
    ("예감"
     "豫感")
    ("예견"
     "豫見")
    ("예견적"
     "豫見的")
    ("예결"
     "豫決")
    ("예고"
     "藝高"
     "豫告")
    ("예고제"
     "豫告制")
    ("예고편"
     "豫告篇")
    ("예규"
     "例規")
    ("예금"
     "預金")
    ("예금계"
     "預金係")
    ("예금액"
     "預金額")
    ("예금자"
     "預金者")
    ("예금주"
     "預金主")
    ("예기"
     "豫期")
    ("예년"
     "例年")
    ("예농적"
     "隸農的")
    ("예능"
     "藝能")
    ("예능계"
     "藝能係")
    ("예능국"
     "藝能局")
    ("예능대"
     "藝能大")
    ("예능인"
     "藝能人")
    ("예단"
     "豫斷"
     "禮緞")
    ("예대"
     "預貸"
     "禮待")
    ("예독"
     "豫讀")
    ("예리"
     "銳利")
    ("예매"
     "豫買"
     "豫賣")
    ("예명"
     "藝名")
    ("예문"
     "例文")
    ("예문관"
     "藝文館")
    ("예문의로"
     "禮門義路")
    ("예물"
     "禮物")
    ("예민"
     "銳敏")
    ("예민종"
     "銳敏種")
    ("예방"
     "豫防"
     "禮訪")
    ("예방법"
     "豫防法")
    ("예방책"
     "豫防策")
    ("예배"
     "禮拜")
    ("예배당"
     "禮拜堂")
    ("예배소"
     "禮拜所")
    ("예배일"
     "禮拜日")
    ("예번즉난"
     "禮煩則亂")
    ("예법"
     "禮法")
    ("예보"
     "豫報")
    ("예복"
     "禮服")
    ("예복활"
     "禮服闊")
    ("예불"
     "禮佛")
    ("예불기"
     "預拂機")
    ("예비"
     "豫備")
    ("예비고사"
     "豫備考査")
    ("예비군"
     "豫備軍")
    ("예비령"
     "豫備令")
    ("예비부부"
     "豫備夫婦")
    ("예비역"
     "豫備役")
    ("예비율"
     "豫備率")
    ("예비적"
     "豫備的")
    ("예비지식"
     "豫備知識")
    ("예비품"
     "豫備品")
    ("예사"
     "例事"
     "禮辭")
    ("예산"
     "豫算")
    ("예산서"
     "豫算書")
    ("예산실"
     "豫算室")
    ("예산실장"
     "豫算室長")
    ("예산액"
     "豫算額")
    ("예삿"
     "例事")
    ("예상"
     "豫想"
     "例常")
    ("예상률"
     "豫想率")
    ("예상외"
     "豫想外")
    ("예상자"
     "豫想者")
    ("예선"
     "豫選")
    ("예속"
     "隸屬")
    ("예속민"
     "隸屬民")
    ("예속상교"
     "禮俗相交")
    ("예속성"
     "隸屬性")
    ("예속적"
     "隸屬的")
    ("예수금"
     "豫受金")
    ("예술"
     "藝術")
    ("예술가"
     "藝術家")
    ("예술가상"
     "藝術家賞")
    ("예술가적"
     "藝術家的")
    ("예술가촌"
     "藝術家村")
    ("예술계"
     "藝術界")
    ("예술과"
     "藝術科")
    ("예술관"
     "藝術觀")
    ("예술단"
     "藝術團")
    ("예술론"
     "藝術論")
    ("예술론자"
     "藝術論者")
    ("예술미"
     "藝術美")
    ("예술사"
     "藝術史")
    ("예술성"
     "藝術性")
    ("예술인"
     "藝術人")
    ("예술적"
     "藝術的")
    ("예술제"
     "藝術祭")
    ("예술제상"
     "藝術祭賞")
    ("예술촌"
     "藝術村")
    ("예술품"
     "藝術品")
    ("예술학"
     "藝術學")
    ("예술학과"
     "藝術學科")
    ("예술화"
     "藝術化")
    ("예습"
     "豫習")
    ("예시"
     "豫示"
     "例示")
    ("예시적"
     "例示的")
    ("예식"
     "禮式")
    ("예식장"
     "禮式場")
    ("예약"
     "豫約")
    ("예약금"
     "豫約金")
    ("예약제"
     "豫約制")
    ("예언"
     "豫言")
    ("예언서"
     "豫言書")
    ("예언자"
     "豫言者")
    ("예언적"
     "豫言的")
    ("예열"
     "豫熱")
    ("예외"
     "例外")
    ("예외적"
     "例外的")
    ("예우"
     "禮遇")
    ("예의"
     "銳意"
     "禮儀"
     "禮義")
    ("예의범절"
     "禮儀凡節")
    ("예의염치"
     "禮義廉恥")
    ("예의적"
     "禮儀的")
    ("예입"
     "預入")
    ("예절"
     "禮節")
    ("예절실"
     "禮節室")
    ("예정"
     "豫定"
     "豫程")
    ("예정가"
     "豫定價")
    ("예정일"
     "豫定日")
    ("예정자"
     "豫定者")
    ("예제"
     "豫題")
    ("예증"
     "例證")
    ("예지"
     "銳智")
    ("예찬"
     "禮讚")
    ("예찬론"
     "禮讚論")
    ("예찬자"
     "禮讚者")
    ("예체능"
     "藝體能")
    ("예체능계"
     "藝體能係")
    ("예측"
     "豫測")
    ("예치"
     "預置")
    ("예치금"
     "預置金")
    ("예탁"
     "豫度")
    ("예탁금"
     "預託金")
    ("예토"
     "穢土")
    ("예화"
     "例話")
    ("오"
     ("五" . "다섯 오")
     ("伍" . "五의 갖은자, 다섯 사람 오, 무리 오")
     ("俉" . "맞이할 오")
     ("傲" . "업신여길 오, 즐길 오")
     ("午" . "낮 오, 남쪽 오, 말 오")
     ("吳" . "오나라 오, 큰소리 지를 오, 성씨 오")
     ("吾" . "자기 오, 아들 오")
     ("嗚" . "탄식할 오")
     ("塢" . "산 언덕 오, 마을 오")
     ("墺" . "방 구들 오, 물가 언덕 오")
     ("奧" . "속 오, 비밀 오, 깊을 오")
     ("娛" . "즐거울 오")
     ("寤" . "잠 깨어날 오, 깨달을 오")
     ("悟" . "깨우칠 오")
     ("懊" . "원망할 오, 번뇌할 오")
     ("敖" . "희롱할 오, 거만할 오")
     ("旿" . "밝을 오")
     ("晤" . "밝을 오, 만날 오")
     ("梧" . "머귀나무 오, 버틸 오")
     ("汚" . "더러울 오, 웅덩이 오")
     ("澳" . "깊을 오, 물 이름 오")
     ("烏" . "까마귀 오, 검을 오, 어찌 오, 탄식할 오")
     ("熬" . "볶을 오, 애 끓는 소리 오")
     ("獒" . "사나운 개 오")
     "禑"
     ("筽" . "버들 고리 오")
     ("蜈" . "지네 오")
     ("誤" . "그릇할 오")
     ("鰲" . "큰 자라 오")
     ("鼇" . "매우 큰 자라 오")
     ("惡" . "미워할 오, 부끄러울 오")
     ("仵" . "짝 오, 같을 오")
     ("俣" . "갈래질 오")
     ("唔" . "글 읽는 소리 오")
     ("嗷" . "여럿이 걱정할 오")
     ("噁" . "성낼 오")
     ("圬" . "흙손 오")
     ("媪" . "할미 오, 땅귀신 오")
     "媼"
     ("嫯" . "업신여길 오")
     ("忤" . "거스릴 오, 미워할 오")
     ("慠" . "거만할 오")
     ("捂" . "부닥칠 오, 거스릴 오")
     ("汙" . "汚와 同字")
     ("窹" . "아궁이 오")
     ("聱" . "못 들은채 할 오, 말 더듬거릴 오")
     ("茣" . "차조기 오")
     ("襖" . "도포 오")
     ("謷" . "중얼거릴 오, 거만할 오")
     ("迕" . "만날 오, 어길 오")
     ("遨" . "노닐 오")
     ("鏊" . "번철 오")
     ("鏖" . "무찌를 오, 구리동이 오")
     ("隩" . "감출 오, 물가 언덕 오")
     ("驁" . "준마 오, 깔볼 오")
     ("鼯" . "날다람쥐 오"))
    ("오가작통법"
     "五家作統法")
    ("오가피"
     "五加皮")
    ("오감"
     "五感")
    ("오경"
     "五京")
    ("오계"
     "五戒")
    ("오곡"
     "五穀")
    ("오골계"
     "烏骨鷄")
    ("오관"
     "五官")
    ("오교"
     "五敎")
    ("오기"
     "五伎"
     "傲氣"
     "誤記")
    ("오뉴월"
     "五六月")
    ("오니"
     "汚泥")
    ("오니층"
     "汚泥層")
    ("오답"
     "誤答")
    ("오대륙"
     "五大陸")
    ("오대양"
     "五大洋")
    ("오덕"
     "五德")
    ("오도"
     "汚塗"
     "誤導")
    ("오독"
     "誤讀")
    ("오동"
     "梧桐")
    ("오두품"
     "五頭品")
    ("오등"
     "五等")
    ("오락"
     "娛樂")
    ("오락성"
     "娛樂性")
    ("오락실"
     "娛樂室")
    ("오락적"
     "娛樂的")
    ("오락화"
     "娛樂化")
    ("오락회"
     "娛樂會")
    ("오류"
     "誤謬")
    ("오륙백"
     "五六百")
    ("오륙십"
     "五六十")
    ("오륜"
     "五倫")
    ("오리무중"
     "五里霧中")
    ("오만"
     "五萬"
     "傲慢")
    ("오만무례"
     "傲慢無禮")
    ("오만불손"
     "傲慢不遜")
    ("오만상"
     "五萬相")
    ("오매불망"
     "寤寐不忘")
    ("오명"
     "汚名")
    ("오묘"
     "奧妙")
    ("오묘제"
     "五廟制")
    ("오물"
     "汚物")
    ("오미자"
     "五味子")
    ("오밀조밀"
     "奧密稠密")
    ("오발"
     "誤發")
    ("오밤중"
     "午-中")
    ("오백"
     "伍伯")
    ("오백만"
     "五百萬")
    ("오복"
     "五福")
    ("오부"
     "五部")
    ("오불관언"
     "吾不關焉")
    ("오비삼척"
     "吾鼻三尺")
    ("오비이락"
     "烏飛梨落")
    ("오사"
     "五四")
    ("오산"
     "誤算")
    ("오상고절"
     "傲霜孤節")
    ("오색"
     "五色")
    ("오색영롱"
     "五色玲瓏")
    ("오색찬란"
     "五色燦爛")
    ("오석"
     "烏石")
    ("오선지"
     "五線紙")
    ("오성"
     "悟性")
    ("오성적"
     "五性的")
    ("오수"
     "午睡"
     "汚水")
    ("오수부동"
     "五獸不動")
    ("오순절"
     "五旬節")
    ("오승목"
     "五升木")
    ("오시"
     "五時")
    ("오식"
     "誤植")
    ("오십"
     "五十")
    ("오십견"
     "五十肩")
    ("오십만"
     "五十萬")
    ("오십보백보"
     "五十步百步")
    ("오십사"
     "五十四")
    ("오십오"
     "五十五")
    ("오악"
     "五岳")
    ("오언성마"
     "烏焉成馬")
    ("오열"
     "嗚咽")
    ("오염"
     "汚染")
    ("오염도"
     "汚染度")
    ("오염물"
     "汚染物")
    ("오염원"
     "汚染源")
    ("오염자"
     "汚染者")
    ("오염치"
     "汚染値")
    ("오욕"
     "汚辱")
    ("오월"
     "五月")
    ("오월동주"
     "吳越同舟")
    ("오음"
     "五音")
    ("오음성고"
     "五陰盛苦")
    ("오인"
     "誤認")
    ("오일"
     "午日")
    ("오일륙"
     "五一六")
    ("오일일석"
     "五日一石")
    ("오일장"
     "五日場")
    ("오일칠"
     "五一七")
    ("오일팔"
     "五一八")
    ("오입"
     "誤入")
    ("오자"
     "誤字")
    ("오장"
     "五臟")
    ("오장육부"
     "五臟六腑")
    ("오전"
     "午前")
    ("오전반"
     "午前班")
    ("오점"
     "汚點")
    ("오족"
     "五族")
    ("오지"
     "奧地")
    ("오지선다"
     "五枝選多")
    ("오진"
     "誤診")
    ("오차"
     "誤差")
    ("오차율"
     "誤差率")
    ("오찬"
     "午餐")
    ("오천"
     "五千")
    ("오첩반상"
     "五-飯床")
    ("오촌"
     "五寸")
    ("오층탑"
     "五層塔")
    ("오타"
     "誤打")
    ("오판"
     "誤判")
    ("오풍십우"
     "五風十雨")
    ("오한"
     "惡寒")
    ("오합지졸"
     "烏合之卒")
    ("오해"
     "誤解")
    ("오행"
     "五行")
    ("오행상극"
     "五行相剋")
    ("오행상생"
     "五行相生")
    ("오행설"
     "五行說")
    ("오호"
     "五胡")
    ("오호애재"
     "嗚呼哀哉")
    ("오호통재"
     "嗚呼痛哉")
    ("오후"
     "午後")
    ("오후반"
     "午後班")
    ("옥"
     ("屋" . "집 옥, 지붕 옥, 거북 덮개 옥")
     ("沃" . "기름질 옥, 부드러울 옥, 손 씻을 옥, 아리따울 옥")
     ("獄" . "감옥 옥")
     ("玉" . "구슬 옥, 사랑할 옥, 이룰 옥")
     ("鈺" . "보배 옥"))
    ("옥개석"
     "屋蓋石")
    ("옥고"
     "獄苦"
     "玉稿")
    ("옥곤금우"
     "玉昆金友")
    ("옥골선풍"
     "玉骨仙風")
    ("옥관자"
     "玉貫子")
    ("옥내"
     "屋內")
    ("옥녀"
     "玉女")
    ("옥녀형"
     "玉女型")
    ("옥도정기"
     "沃度丁幾")
    ("옥동자"
     "玉童子")
    ("옥리"
     "獄吏")
    ("옥문"
     "獄門")
    ("옥병"
     "玉甁")
    ("옥사"
     "獄事"
     "獄舍")
    ("옥상"
     "屋上")
    ("옥상가옥"
     "屋上架屋")
    ("옥색"
     "玉色")
    ("옥색목"
     "玉色木")
    ("옥석"
     "玉石")
    ("옥석구분"
     "玉石俱焚")
    ("옥석혼효"
     "玉石混淆")
    ("옥선"
     "玉蟬")
    ("옥야천리"
     "沃野千里")
    ("옥양목"
     "玉洋木")
    ("옥오지애"
     "屋烏之愛")
    ("옥외"
     "屋外")
    ("옥잠"
     "玉簪")
    ("옥잠화"
     "玉簪花")
    ("옥좌"
     "玉座")
    ("옥중"
     "獄中")
    ("옥편"
     "玉篇")
    ("옥하가옥"
     "屋下架屋")
    ("옥황상제"
     "玉皇上帝")
    ("온"
     ("溫" . "따뜻할 온, 부드러울 온")
     ("瑥" . "사람이름 온")
     ("瘟" . "염병 온, 온역 온")
     ("穩" . "편안할 온, 곡식 걷어 모을 온")
     ("縕" . "모시 온, 묵은 솜 온")
     ("蘊" . "마름 온, 쌓일 온")
     "媼"
     ("慍" . "성낼 온, 병 온")
     ("昷" . "어질 온")
     ("氳" . "기운 어릴 온, 기운 성할 온")
     ("薀" . "마름 온, 쌓일 온")
     ("轀" . "온량차 온")
     ("醞" . "술 빚을 온")
     ("韞" . "감출 온, 붉은 빛 온")
     ("饂" . "밀 국수 온")
     ("鰮" . "멸치 온"))
    ("온건"
     "穩健")
    ("온건론"
     "穩健論")
    ("온건책"
     "穩健策")
    ("온건파"
     "穩健派")
    ("온고지신"
     "溫故知新")
    ("온공자허"
     "溫恭自虛")
    ("온기"
     "溫氣")
    ("온난"
     "溫暖")
    ("온난화"
     "溫暖化")
    ("온당"
     "穩當")
    ("온대"
     "溫帶")
    ("온도"
     "溫度")
    ("온도계"
     "溫度計")
    ("온돌"
     "溫突")
    ("온돌방"
     "溫突房")
    ("온상"
     "溫床")
    ("온수"
     "溫水")
    ("온수기"
     "溫水器")
    ("온순"
     "溫順")
    ("온식"
     "溫食")
    ("온실"
     "溫室")
    ("온여옥"
     "溫如玉")
    ("온유돈후"
     "溫柔敦厚")
    ("온전"
     "穩全")
    ("온전성"
     "穩全性")
    ("온정정성"
     "溫凊定省")
    ("온존"
     "溫存")
    ("온존적"
     "溫存的")
    ("온주"
     "溫綢")
    ("온천"
     "溫泉")
    ("온축"
     "蘊蓄")
    ("온탕식"
     "溫湯式")
    ("온풍기"
     "溫風器")
    ("온화"
     "溫和")
    ("올"
     ("兀" . "우뚝할 올, 움직이지 않을 올")
     ("嗢" . "목 멜 올")
     ("膃" . "해구 올, 살찔 올"))
    ("옹"
     ("壅" . "막을 옹, 북돋울 옹")
     ("擁" . "안을 옹, 품을 옹, 가질 옹")
     ("瓮" . "항아리 옹")
     ("甕" . "항아리 옹, 물장군 옹")
     "癰"
     ("翁" . "늙은이 옹, 새 목털 아래 옹")
     ("邕" . "막힐 옹, 사람이름 옹")
     ("雍" . "조화로울 옹, 학교 옹")
     ("饔" . "아침밥 옹")
     ("喁" . "물고기 입 오물거릴 옹")
     ("廱" . "벽옹 옹")
     ("滃" . "구름 피어 오를 옹, 안개 자욱할 옹")
     ("癕" . "등창 옹")
     ("禺" . "땅 이름 옹")
     ("罋" . "甕과 同字")
     ("蓊" . "옹풀 옹, 우거질 옹")
     ("雝" . "조화로울 옹, 학교 옹")
     ("顒" . "우러를 옹"))
    ("옹고집"
     "壅固執")
    ("옹립"
     "擁立")
    ("옹벽"
     "擁壁")
    ("옹산화병"
     "甕算畵餠")
    ("옹색"
     "壅塞")
    ("옹성"
     "甕城")
    ("옹성문"
     "甕城門")
    ("옹졸"
     "壅拙")
    ("옹호"
     "擁護")
    ("옹호론"
     "擁護論")
    ("옹호론자"
     "擁護論者")
    ("옹호자"
     "擁護者")
    ("옹호적"
     "擁護的")
    ("와"
     "娃"
     ("渦" . "소용돌이 와, 시끄러울 와")
     ("瓦" . "질그릇 와, 기와 와")
     ("窩" . "굴 와, 움집 와")
     ("窪" . "도랑 와, 깊을 와")
     ("臥" . "누울 와, 쉴 와")
     ("蛙" . "개구리 와")
     ("蝸" . "달팽이 와")
     ("訛" . "거짓말 와, 어긋날 와")
     "鍋"
     ("哇" . "음란한 소리 와, 게울 와")
     ("囮" . "새 후릴 와")
     ("婐" . "정숙할 와, 단정할 와")
     "媧"
     ("枙" . "옹이 와")
     ("洼" . "물 이름 와")
     "涴"
     ("猧" . "와개 와")
     ("窊" . "웅덩이 와")
     ("萵" . "상추 와, 부루 와")
     ("譌" . "거짓 와, 와전될 와, 요사스런 말 와"))
    ("와각지쟁"
     "蝸角之爭")
    ("와룡봉추"
     "臥龍鳳雛")
    ("와부뇌명"
     "瓦釜雷鳴")
    ("와선"
     "渦旋")
    ("와신상담"
     "臥薪嘗膽")
    ("와우형"
     "臥牛形")
    ("와유강산"
     "臥遊江山")
    ("와전"
     "訛傳")
    ("와중"
     "渦中")
    ("와해"
     "瓦解")
    ("와해적"
     "瓦解的")
    ("와해토붕"
     "瓦解土崩")
    ("완"
     ("婉" . "순할 완, 예쁠 완, 젊을 완")
     ("完" . "완전할 완, 끝날 완, 지킬 완")
     ("宛" . "어슴푸레할 완, 언덕 위 언덕 완")
     ("梡" . "네 발 도마 완, 토막나무 완")
     ("椀" . "주발 완, 사발 완")
     ("浣" . "옷 빨 완, 씻을 완")
     ("玩" . "희롱할 완, 보배 완")
     "琓"
     ("琬" . "보석 완, 아름다운 옥 완")
     ("碗" . "그릇 완")
     ("緩" . "느즈러질 완, 더딜 완")
     ("翫" . "익숙할 완, 싫을 완, 구경할 완")
     ("脘" . "중완 완")
     ("腕" . "팔뚝 완")
     ("莞" . "빙그레 웃는 모양 완")
     ("豌" . "동부 완, 완두 완")
     ("阮" . "성씨 완")
     ("頑" . "완고할 완, 완악할 완")
     ("刓" . "깎을 완")
     ("垸" . "회 섞어 바를 완")
     ("妧" . "좋을 완, 고울 완")
     ("岏" . "산 뾰족할 완")
     ("忨" . "탐할 완, 사랑할 완")
     ("惋" . "한탄할 완, 놀라 탄식할 완")
     ("涴" . "물 굽이쳐 흐를 완, 진흙 묻을 완")
     ("盌" . "은 바리 완")
     "蜿")
    ("완간"
     "完刊")
    ("완강"
     "頑强")
    ("완결"
     "完結")
    ("완결감"
     "完決感")
    ("완결성"
     "完結性")
    ("완결적"
     "完決的")
    ("완경사"
     "緩傾斜")
    ("완고"
     "頑固")
    ("완곡"
     "婉曲")
    ("완곡면"
     "緩曲面")
    ("완공"
     "完工")
    ("완구"
     "玩具")
    ("완구점"
     "玩具店")
    ("완급"
     "緩急")
    ("완납"
     "完納")
    ("완두"
     "豌豆")
    ("완력"
     "腕力")
    ("완료"
     "完了")
    ("완만"
     "緩慢"
     "緩晩")
    ("완벽"
     "完璧")
    ("완벽성"
     "完壁性")
    ("완벽주의"
     "完璧主義")
    ("완비"
     "完備")
    ("완사면"
     "緩斜面")
    ("완성"
     "完成")
    ("완성도"
     "完成度")
    ("완성체"
     "完成體")
    ("완성품"
     "完成品")
    ("완성형"
     "完成型")
    ("완송"
     "完誦")
    ("완수"
     "完遂")
    ("완숙"
     "完熟")
    ("완숙기"
     "完熟期")
    ("완승"
     "完勝")
    ("완연"
     "完然"
     "宛然")
    ("완장"
     "腕章")
    ("완전"
     "完全")
    ("완전무결"
     "完全無缺")
    ("완전성"
     "完全性")
    ("완전자"
     "完全者")
    ("완전주의자"
     "完全主義者")
    ("완제품"
     "完製品")
    ("완주"
     "完走")
    ("완충"
     "緩衝")
    ("완충기"
     "緩衝期")
    ("완충제"
     "緩衝劑")
    ("완치"
     "完治")
    ("완쾌"
     "完快")
    ("완파"
     "完破")
    ("완패"
     "完敗")
    ("완행선"
     "緩行線")
    ("완행열차"
     "緩行列車")
    ("완화"
     "緩和")
    ("완화론"
     "緩和論")
    ("왈"
     ("曰" . "가로되 왈")
     "刖")
    ("왈가왈부"
     "曰可曰否")
    ("왈시왈비"
     "曰是曰非")
    ("왕"
     ("往" . "갈 왕, 옛 왕, 이따금 왕")
     ("旺" . "고울 왕, 해무리 왕, 성할 왕")
     ("枉" . "굽을 왕, 원통할 왕")
     ("汪" . "물 출렁출렁할 왕, 연못 왕")
     ("王" . "임금 왕, 할아버지 왕")
     ("尫" . "절름발이 왕, 파리할 왕, 천상바라기 왕")
     ("瀇" . "아득할 왕, 넓을 왕, 고인 물 썪어 냄새날 왕")
     ("迬" . "往과 同字"))
    ("왕가"
     "王家")
    ("왕관"
     "王冠")
    ("왕국"
     "王國")
    ("왕궁"
     "王宮")
    ("왕권"
     "王權")
    ("왕녀"
     "王女")
    ("왕년"
     "往年")
    ("왕대비"
     "王大妃")
    ("왕대합"
     "王大蛤")
    ("왕도"
     "王道"
     "王都")
    ("왕도정치"
     "王道政治")
    ("왕래"
     "往來")
    ("왕릉"
     "王陵")
    ("왕립"
     "王立")
    ("왕명"
     "王名"
     "王命")
    ("왕복"
     "往復")
    ("왕복선"
     "往復船")
    ("왕비"
     "王妃")
    ("왕비족"
     "王妃族")
    ("왕생"
     "往生")
    ("왕생극락"
     "往生極樂")
    ("왕성"
     "旺盛")
    ("왕세자"
     "王世子")
    ("왕세자비"
     "王世子妃")
    ("왕실"
     "王室")
    ("왕왕"
     "往往")
    ("왕위"
     "王位")
    ("왕자"
     "王子"
     "王者")
    ("왕자물지"
     "往者勿止")
    ("왕자병"
     "王子病")
    ("왕정"
     "王政")
    ("왕정복고"
     "王政復古")
    ("왕조"
     "王朝")
    ("왕조사적"
     "王朝史的")
    ("왕족"
     "王族")
    ("왕좌"
     "王座")
    ("왕중왕전"
     "王中王戰")
    ("왕척직심"
     "枉尺直尋")
    ("왕토"
     "王土")
    ("왕통"
     "王統")
    ("왕호"
     "王號")
    ("왕후"
     "王后")
    ("왕후장상"
     "王侯將相")
    ("왜"
     ("倭" . "나라이름 왜")
     ("娃" . "어여쁜 계집 왜, 얼굴 아름다울 왜")
     "歪"
     ("矮" . "난장이 왜")
     ("媧" . "여자이름 왜"))
    ("왜간장"
     "倭-醬")
    ("왜곡"
     "歪曲")
    ("왜관"
     "倭館")
    ("왜구"
     "倭寇")
    ("왜국"
     "倭國")
    ("왜군"
     "倭軍")
    ("왜된장"
     "倭-醬")
    ("왜란"
     "倭亂")
    ("왜상"
     "倭商")
    ("왜색"
     "倭色")
    ("왜색조"
     "倭色調")
    ("왜선"
     "倭船")
    ("왜소"
     "矮小")
    ("왜소화"
     "矮小化")
    ("왜식"
     "倭式")
    ("왜인"
     "倭人")
    ("왜자간희"
     "矮子看戱")
    ("왜적"
     "倭敵")
    ("왜정"
     "倭政")
    ("왜주"
     "倭紬")
    ("외"
     ("外" . "바깥 외, 다를 외, 잃을 외, 아버지 외")
     ("嵬" . "산 뾰족할 외, 산 울뚝질뚝할 외")
     ("巍" . "높을 외, 높고 튼 모양 외")
     ("猥" . "더러울 외, 굽을 외, 섞일 외, 개 새끼 셋 낳을 외")
     ("畏" . "두려울 외, 겁낼 외")
     ("偎" . "사랑할 외, 가물거릴 외")
     ("崴" . "평평치 아니할 외")
     ("嵔" . "산이름 외, 산 높을 외")
     ("渨" . "더러울 외")
     ("煨" . "불에 묻어 구울 외, 그슬릴 외, 사람이름 외")
     ("碨" . "돌 자갈 땅 외, 바위 옹두라지 외")
     ("磈" . "돌 사닥다리 외")
     ("聵" . "배냇귀머거리 외")
     ("隗" . "높을 외, 성씨 외"))
    ("외가"
     "外家")
    ("외가댁"
     "外家宅")
    ("외간"
     "外間")
    ("외갓"
     "外家")
    ("외거"
     "外居")
    ("외견상"
     "外見上")
    ("외경"
     "畏敬")
    ("외경심"
     "畏敬心")
    ("외계"
     "外界")
    ("외계인"
     "外界人")
    ("외과"
     "外科")
    ("외과적"
     "外科的")
    ("외곽"
     "外郭")
    ("외곽선"
     "外郭線")
    ("외곽적"
     "外郭的")
    ("외관"
     "外觀")
    ("외관상"
     "外觀上")
    ("외관적"
     "外觀的")
    ("외관화"
     "外觀化")
    ("외교"
     "外交"
     "外敎")
    ("외교관"
     "外交官")
    ("외교력"
     "外交力")
    ("외교적"
     "外交的")
    ("외교전"
     "外交戰")
    ("외교학과"
     "外交學科")
    ("외국"
     "外國")
    ("외국계"
     "外國係")
    ("외국곡"
     "外國曲")
    ("외국산"
     "外國産")
    ("외국식"
     "外國式")
    ("외국어"
     "外國語")
    ("외국어화"
     "外國語化")
    ("외국인"
     "外國人")
    ("외국적"
     "外國的")
    ("외국제"
     "外國製")
    ("외국환"
     "外國換")
    ("외근"
     "外勤")
    ("외도"
     "外道")
    ("외등"
     "外燈")
    ("외람"
     "猥濫")
    ("외래"
     "外來")
    ("외래문화"
     "外來文化")
    ("외래어"
     "外來語")
    ("외래인"
     "外來人")
    ("외래적"
     "外來的")
    ("외래종"
     "外來種")
    ("외면"
     "外面")
    ("외면당"
     "外面當")
    ("외면적"
     "外面的")
    ("외면화"
     "外面化")
    ("외모"
     "外貌")
    ("외모적"
     "外貌的")
    ("외무"
     "外務")
    ("외무직"
     "外務職")
    ("외박"
     "外泊")
    ("외방"
     "外方")
    ("외벽"
     "外壁")
    ("외부"
     "外部")
    ("외부인"
     "外部人")
    ("외부적"
     "外部的")
    ("외사촌"
     "外四寸")
    ("외산"
     "外産")
    ("외삼촌"
     "外三寸")
    ("외삽법"
     "外揷法")
    ("외삽법적"
     "外揷法的")
    ("외상"
     "外傷"
     "外相")
    ("외생적"
     "外生的")
    ("외서"
     "外書")
    ("외설"
     "猥褻")
    ("외세"
     "外勢")
    ("외손"
     "外孫")
    ("외손녀"
     "外孫女")
    ("외손자"
     "外孫子")
    ("외수"
     "外數"
     "外水")
    ("외수외미"
     "畏首畏尾")
    ("외숙"
     "外叔")
    ("외숙모"
     "外叔母")
    ("외숙부"
     "外叔父")
    ("외식"
     "外食")
    ("외신"
     "外信")
    ("외신부"
     "外信部")
    ("외심"
     "外心")
    ("외압"
     "外壓")
    ("외야수"
     "外野手")
    ("외양"
     "外樣")
    ("외역전"
     "外役田")
    ("외연"
     "外延")
    ("외연성"
     "外延性")
    ("외연적"
     "外延的")
    ("외연화"
     "外延化")
    ("외영오적"
     "畏影惡迹")
    ("외왕"
     "外王")
    ("외용약"
     "外用藥")
    ("외위"
     "外位")
    ("외유"
     "外遊")
    ("외유내강"
     "外柔內剛")
    ("외의"
     "外衣")
    ("외인"
     "外人")
    ("외자"
     "外資")
    ("외적"
     "外敵"
     "外的")
    ("외제"
     "外製")
    ("외제품"
     "外製品")
    ("외조부모"
     "外祖父母")
    ("외주"
     "外注")
    ("외지"
     "外地"
     "外紙"
     "外誌")
    ("외지인"
     "外地人")
    ("외채"
     "外債")
    ("외척"
     "外戚")
    ("외청"
     "外廳")
    ("외청장"
     "外廳長")
    ("외출"
     "外出")
    ("외출복"
     "外出服")
    ("외측"
     "外側")
    ("외치"
     "外治")
    ("외침"
     "外侵")
    ("외투"
     "外套")
    ("외판원"
     "外販員")
    ("외표"
     "外表")
    ("외피"
     "外皮")
    ("외항"
     "外港")
    ("외항선"
     "外航船")
    ("외향"
     "外向")
    ("외향적"
     "外向的")
    ("외형"
     "外形")
    ("외형적"
     "外形的")
    ("외호"
     "外護")
    ("외화"
     "外化"
     "外畵"
     "外華"
     "外貨")
    ("외화난"
     "外貨難")
    ("외환"
     "外換")
    ("외환계"
     "外換係")
    ("외환부"
     "外換部")
    ("요"
     ("僥" . "거짓 요, 난장이 요")
     ("凹" . "오목할 요")
     "咬"
     ("堯" . "높을 요, 요임금 요")
     ("夭" . "어여쁠 요, 무성할 요, 재앙 요, 일찍 죽을 요, 뱃속에 든 아이 요, 끊어 죽일 요")
     ("妖" . "요괴로울 요, 생긋생긋 웃는 모양 요")
     ("姚" . "어여쁠 요, 날랠 요, 멀 요")
     ("嶢" . "높을 요")
     ("拗" . "고집스러울 요")
     ("搖" . "흔들 요, 회오리 바람 요, 별이름 요")
     ("擾" . "길들일 요, 번거로울 요")
     ("曜" . "해 비칠 요, 요일 요")
     ("橈" . "노 요")
     ("燿" . "비칠 요, 빛날 요")
     ("瑤" . "아름다운 옥 요, 못 이름 요")
     ("窈" . "고요할 요, 깊을 요")
     ("窯" . "기와가마 요, 오지그릇 요")
     ("繇" . "따를 요, 성할 요")
     ("繞" . "얽힐 요, 둘릴 요")
     ("耀" . "빛날 요")
     ("腰" . "허리 요")
     ("蟯" . "촌백충 요")
     ("要" . "구할 요, 살필 요, 언약할 요, 허리 요, 기다릴 요, 부를 요, 반드시 요")
     ("謠" . "노래 요, 소문 요")
     ("遙" . "멀 요, 노닐 요")
     ("邀" . "맞을 요, 구할 요, 부를 요")
     ("陶" . "화락할 요, 순임금의 신하 요")
     ("饒" . "용서할 요, 배부를 요")
     ("了" . "마칠 료, 깨달을 료")
     ("僚" . "벗 료, 어여쁠 료")
     ("寮" . "동관 료, 관리 료, 중의 집 료")
     ("尿" . "오줌 뇨")
     ("料" . "말질할 료, 헤아릴 료, 대금 료")
     ("樂" . "좋아할 요")
     ("燎" . "뜰에 세운 횃불 료, 풀 태울 료")
     ("療" . "병 나을 료, 병 고칠 료")
     ("蓼" . "병 나을 료")
     ("遼" . "멀 료, 강이름 료, 나라이름 료")
     ("偠" . "허리 가늘 요")
     ("喓" . "벌레소리 요")
     "嚙"
     ("坳" . "凹와 同字")
     ("墝" . "메마른 밭 요, 자갈 땅 요")
     ("嬈" . "예쁜체 할 요")
     ("幺" . "작을 요, 어릴 요")
     ("徭" . "부릴 요")
     ("徼" . "돌아다닐 요, 순라 요, 변방 요, 구할 요")
     ("殀" . "단명할 요")
     ("澆" . "걸찰 요, 물 끌어올 요")
     ("祅" . "재앙 요")
     ("穾" . "깊숙할 요, 골방 요")
     ("窅" . "움펑눈 요, 까마득할 요")
     ("蕘" . "나무할 요, 거칠 요")
     "軺"
     ("遶" . "둘릴 요")
     "銚"
     ("鷂" . "장끼 요, 새매 요"))
    ("요강"
     "要綱")
    ("요건"
     "要件")
    ("요격"
     "邀擊")
    ("요고순목"
     "堯鼓舜木")
    ("요괴"
     "妖怪")
    ("요구"
     "要求")
    ("요구량"
     "要求量")
    ("요구불"
     "要求拂")
    ("요구서"
     "要求書")
    ("요구액"
     "要求額")
    ("요구율"
     "要求率")
    ("요구자"
     "要求者")
    ("요금"
     "料金"
     "料金")
    ("요금액"
     "料金額")
    ("요기"
     "療飢"
     "療飢")
    ("요긴"
     "要緊")
    ("요도염"
     "尿道炎")
    ("요동"
     "搖動")
    ("요동지시"
     "遼東之豕")
    ("요두전목"
     "搖頭顚目")
    ("요란"
     "搖亂")
    ("요람"
     "搖籃")
    ("요량"
     "料量")
    ("요령"
     "要領")
    ("요령부득"
     "要領不得")
    ("요로"
     "要路")
    ("요리"
     "料理")
    ("요리반"
     "料理班")
    ("요리법"
     "料理法")
    ("요리사"
     "料理師")
    ("요릿"
     "料理")
    ("요망"
     "要望")
    ("요목"
     "要目")
    ("요물"
     "妖物")
    ("요미걸련"
     "搖尾乞憐")
    ("요배"
     "遙拜")
    ("요법"
     "療法")
    ("요법적"
     "療法的")
    ("요부"
     "妖婦"
     "腰部")
    ("요사"
     "妖邪"
     "寮舍")
    ("요산요수"
     "樂山樂水")
    ("요새"
     "要塞")
    ("요새지"
     "要塞地")
    ("요새화"
     "要塞化")
    ("요설"
     "饒舌")
    ("요소"
     "要素")
    ("요소론"
     "要素論")
    ("요소요소"
     "要所要所")
    ("요수촉금"
     "搖手觸禁")
    ("요순고설"
     "搖脣鼓舌")
    ("요순시대"
     "堯舜時代")
    ("요순시절"
     "堯舜時節")
    ("요술"
     "妖術")
    ("요시찰자"
     "要視察者")
    ("요식"
     "要式")
    ("요약"
     "要約")
    ("요양"
     "療養")
    ("요양원"
     "療養院")
    ("요언불번"
     "要言不煩")
    ("요업"
     "窯業")
    ("요염"
     "妖艶")
    ("요원"
     "要員"
     "遙遠"
     "燎原")
    ("요육"
     "療育")
    ("요의"
     "尿意")
    ("요인"
     "要人"
     "要因")
    ("요일"
     "曜日")
    ("요장순단"
     "堯長舜短")
    ("요절"
     "夭折"
     "撓折")
    ("요점"
     "要點")
    ("요정"
     "妖精"
     "料亭")
    ("요조숙녀"
     "窈窕淑女")
    ("요주의"
     "要注意")
    ("요중냉"
     "腰重冷")
    ("요지"
     "要地"
     "要旨")
    ("요지경"
     "瑤池鏡")
    ("요지부동"
     "搖之不動"
     "搖之不動")
    ("요직"
     "要職")
    ("요철"
     "凹凸")
    ("요청"
     "要請")
    ("요청서"
     "要請書")
    ("요체"
     "要諦")
    ("요추"
     "腰椎")
    ("요충지"
     "要衝地")
    ("요통"
     "腰痛")
    ("요포형"
     "腰布型")
    ("요풍순우"
     "堯風舜雨")
    ("요항부"
     "要港部")
    ("요행"
     "僥倖")
    ("요행수"
     "僥倖數")
    ("욕"
     ("慾" . "욕심낼 욕, 하고자할 욕")
     ("欲" . "욕심낼 욕, 하고자할 욕")
     ("浴" . "깨끗이할 욕, 못 이름 욕")
     "縟"
     "褥"
     ("辱" . "욕될 욕, 굽힐 욕")
     ("溽" . "유월 더위 욕, 무더울 욕")
     ("蓐" . "새싹 욕, 가을 맡은 귀신 욕"))
    ("욕교반졸"
     "欲巧反拙")
    ("욕구"
     "欲求")
    ("욕망"
     "欲望")
    ("욕사무지"
     "欲死無地")
    ("욕설"
     "辱說")
    ("욕속부달"
     "欲速不達")
    ("욕실"
     "浴室")
    ("욕심"
     "欲心")
    ("욕정"
     "欲情")
    ("욕조"
     "浴槽")
    ("욕창"
     "褥瘡")
    ("욕탕"
     "浴湯")
    ("욕탕법"
     "浴湯法")
    ("용"
     ("俑" . "시체와 함께 매장하는 허수아비 인형 용")
     ("傭" . "머슴 용, 지을 용, 삯 용")
     ("冗" . "宂과 同字")
     ("勇" . "날랠 용, 용맹할 용")
     ("埇" . "골목길 용, 길 돋울 용")
     ("墉" . "작은 성 용, 담벽 용")
     ("容" . "얼굴 용, 감쌀 용, 용서할 용")
     ("庸" . "쓸 용, 떳떳할 용, 수고로울 용, 어리석을 용, 물도랑 용")
     ("慂" . "권할 용, 거들어 말할 용")
     ("榕" . "용나무 용")
     ("涌" . "물 넘칠 용, 날칠 용")
     ("湧" . "涌의 俗字")
     ("溶" . "물 질펀히 흐를 용, 녹일 용")
     ("熔" . "鎔의 俗字")
     ("瑢" . "패옥소리 용")
     ("用" . "쓸 용, 재물 용, 통할 용")
     ("甬" . "물 솟아 오를 용, 골목길 용, 쇠북 꼭지 용, 곡식 셈하는 단위 휘 용")
     ("聳" . "솟을 용, 귀먹을 용, 공경할 용")
     ("茸" . "풀 뾰죽뾰죽 날 용, 못생길 용")
     ("蓉" . "연꽃 용, 약 이름 용")
     "踊"
     ("鎔" . "불릴 용, 녹일 용, 거푸집 용")
     ("鏞" . "큰 쇠북 용")
     ("龍" . "용 룡, 임금 룡")
     ("傛" . "혁혁할 용, 몸 굽힐 용")
     ("宂" . "번잡할 용, 바쁠 용, 떠돌아 다닐 용")
     ("嵱" . "봉우리 쭝굿쭝굿할 용")
     ("慵" . "게으를 용")
     ("憃" . "천치 용")
     ("槦" . "병기 얹는 시렁 용")
     "硧"
     "筩"
     ("舂" . "방아 찧을 용, 쇠북소리 용, 해가 질 용")
     ("蛹" . "번데기 용")
     ("踴" . "뛸 용"))
    ("용감"
     "勇敢")
    ("용감무쌍"
     "勇敢無雙")
    ("용감성"
     "勇敢性")
    ("용건"
     "用件")
    ("용골"
     "龍骨")
    ("용공"
     "容共")
    ("용광로"
     "鎔鑛爐")
    ("용구"
     "用具")
    ("용궁"
     "龍宮")
    ("용기"
     "勇氣"
     "容器")
    ("용기백배"
     "勇氣百倍")
    ("용납"
     "容納")
    ("용단"
     "勇斷")
    ("용담"
     "龍膽")
    ("용도"
     "用途")
    ("용두사미"
     "龍頭蛇尾")
    ("용량"
     "容量")
    ("용맹"
     "勇猛")
    ("용맹성"
     "勇猛性")
    ("용맹심"
     "勇猛心")
    ("용맹정진"
     "勇猛精進")
    ("용모"
     "容貌")
    ("용무"
     "用務")
    ("용문점액"
     "龍門點額")
    ("용미봉탕"
     "龍味鳳湯")
    ("용법"
     "用法")
    ("용변"
     "用便")
    ("용병"
     "傭兵")
    ("용사"
     "勇士")
    ("용사비등"
     "龍蛇飛騰")
    ("용상"
     "龍床")
    ("용서"
     "容恕")
    ("용선주"
     "傭船主")
    ("용수"
     "用水")
    ("용수량"
     "用水量")
    ("용수철"
     "龍鬚鐵")
    ("용암"
     "鎔巖")
    ("용암류"
     "鎔巖流")
    ("용액"
     "溶液")
    ("용어"
     "用語")
    ("용역"
     "用役")
    ("용역비"
     "用役費")
    ("용역업"
     "用役業")
    ("용역업체"
     "用役業體")
    ("용역직"
     "用役職")
    ("용왕"
     "龍王")
    ("용원"
     "傭員")
    ("용의"
     "容儀"
     "用意")
    ("용의자"
     "容疑者")
    ("용의주도"
     "用意周到")
    ("용이"
     "容易")
    ("용인"
     "容認")
    ("용일"
     "容日")
    ("용적률"
     "容積率")
    ("용전여수"
     "用錢如水")
    ("용접"
     "鎔接")
    ("용접공"
     "鎔接工")
    ("용접기"
     "鎔接器")
    ("용접봉"
     "鎔接棒")
    ("용지"
     "用地"
     "用紙")
    ("용지불분"
     "用志不分")
    ("용지여지"
     "容之如地")
    ("용추지지"
     "用錐指地")
    ("용태"
     "容態")
    ("용퇴"
     "勇退")
    ("용포"
     "龍袍")
    ("용품"
     "用品")
    ("용품점"
     "用品店")
    ("용해"
     "溶解")
    ("용행사장"
     "用行舍藏")
    ("용형"
     "龍形")
    ("용호비"
     "龍虎碑")
    ("용호상박"
     "龍虎相搏")
    ("우"
     ("于" . "갈 우, 여기 우, 만족할 우, 탄식의 어조사 우")
     "亐"
     ("佑" . "도울 우")
     ("偶" . "짝지울 우, 무리 우, 뜻밖에 우")
     ("優" . "넉넉할 우, 부드러울 우, 나을 우, 결단성 없을 우")
     ("又" . "또 우, 용서할 우")
     ("友" . "벗 우, 합할 우")
     ("右" . "오른쪽 우, 높일 우, 강할 우, 도울 우")
     ("宇" . "집 우, 처마 기슭 우, 하늘 우")
     ("寓" . "살 우, 부탁할 우, 빙자할 우")
     ("尤" . "가장 우, 더욱 우, 탓할 우")
     ("愚" . "어리석을 우, 어두울 우, 업신여길 우")
     ("憂" . "근심 우, 상제될 우, 병 우")
     ("旴" . "해 돋을 우, 새벽 우")
     ("牛" . "소 우, 별 이름 우")
     ("玗" . "옥돌 우, 우기나무 우")
     ("瑀" . "옥돌 우")
     ("盂" . "바리 우, 사냥하는 진 우")
     ("祐" . "도울 우, 다행할 우")
     ("禹" . "하우씨 우, 성씨 우, 느릴 우")
     ("紆" . "얽힐 우, 굽을 우")
     ("羽" . "깃 우, 오음의 하나 우")
     ("芋" . "토란 우")
     ("藕" . "연뿌리 우")
     ("虞" . "염려할 우, 즐거울 우, 갖출 우, 우제 지낼 우")
     ("迂" . "굽을 우, 피할 우, 멀 우")
     ("遇" . "만날 우, 대접할 우, 뜻밖에 우")
     ("郵" . "역말 우, 지날 우, 우편 우")
     ("釪" . "요령 우, 바리때 우")
     ("隅" . "모퉁이 우, 기슭 우")
     ("雨" . "비 우")
     ("雩" . "기우제 우")
     "亏"
     "亴"
     "俁"
     "俣"
     "偊"
     "吁"
     ("吽" . "개 싸울 우, 개 짖는 소리 우")
     ("喁" . "서로 부를 우")
     "堣"
     "嵎"
     "庽"
     "杅"
     "疣"
     "盱"
     "禺"
     ("竽" . "큰 생황 우")
     ("耦" . "쟁기 우, 겨리 우, 짝 맞을 우")
     ("耰" . "고무래 우, 곰방메 우")
     ("謣" . "망령되게 말할 우")
     ("踽" . "타달거릴 우")
     "迃"
     ("鍝" . "귀고리 우")
     ("麀" . "암사슴 우")
     ("麌" . "숫사슴 우")
     ("齲" . "충치 우"))
    ("우거"
     "寓居")
    ("우경"
     "牛耕")
    ("우경화"
     "右傾化")
    ("우계"
     "雨季")
    ("우공이산"
     "愚公移山")
    ("우국"
     "憂國")
    ("우국지사"
     "憂國之士")
    ("우기"
     "雨期")
    ("우단"
     "羽緞")
    ("우답불파"
     "牛踏不破")
    ("우대"
     "優待")
    ("우도할계"
     "牛刀割鷄")
    ("우둔"
     "愚鈍")
    ("우등상"
     "優等賞")
    ("우등상장"
     "優等賞狀")
    ("우등생"
     "優等生")
    ("우래무방"
     "憂來無方")
    ("우량"
     "優良")
    ("우량주"
     "優良株")
    ("우려"
     "憂慮")
    ("우롱"
     "愚弄")
    ("우림"
     "雨林")
    ("우마차"
     "牛馬車")
    ("우매"
     "愚昧")
    ("우문"
     "愚問")
    ("우문좌무"
     "右文左武")
    ("우문현답"
     "愚問賢答")
    ("우미"
     "優美")
    ("우민"
     "愚民"
     "憂民")
    ("우박"
     "雨雹")
    ("우발"
     "偶發")
    ("우발성"
     "偶發性")
    ("우발적"
     "偶發的")
    ("우방"
     "友邦")
    ("우방국"
     "友邦國")
    ("우백질"
     "優白質")
    ("우백호"
     "右白虎")
    ("우보"
     "右輔")
    ("우부우부"
     "愚夫愚婦")
    ("우비"
     "雨備")
    ("우사"
     "雨師")
    ("우산"
     "雨傘")
    ("우산형"
     "雨傘型")
    ("우상"
     "偶像"
     "羽狀")
    ("우상화"
     "偶像化")
    ("우생학"
     "優生學")
    ("우생학적"
     "優生學的")
    ("우선"
     "于先"
     "優先"
     "右旋")
    ("우선권"
     "優先權")
    ("우선룡"
     "右旋龍")
    ("우선순위"
     "優先順位")
    ("우선적"
     "優先的")
    ("우선주의"
     "優先主義")
    ("우세"
     "優勢")
    ("우세성"
     "優勢性")
    ("우송"
     "郵送")
    ("우수"
     "優秀"
     "憂愁")
    ("우수마발"
     "牛溲馬勃")
    ("우수상"
     "優秀賞")
    ("우수성"
     "優秀性")
    ("우승"
     "優勝")
    ("우승권"
     "優勝圈")
    ("우승배"
     "優勝杯")
    ("우승열패"
     "優勝劣敗")
    ("우승자"
     "優勝者")
    ("우아"
     "優雅")
    ("우악"
     "愚惡")
    ("우애"
     "友愛")
    ("우여곡절"
     "迂餘曲折")
    ("우연"
     "偶然")
    ("우연성"
     "偶然性")
    ("우연적"
     "偶然的")
    ("우열"
     "優劣")
    ("우완"
     "右腕")
    ("우왕좌왕"
     "右往左往")
    ("우우"
     "牛遇")
    ("우울"
     "憂鬱")
    ("우울감"
     "憂鬱感")
    ("우울증"
     "憂鬱症")
    ("우월"
     "優越")
    ("우월감"
     "優越感")
    ("우월성"
     "優越性")
    ("우월주의"
     "優越主義")
    ("우위"
     "優位")
    ("우위론"
     "優位論")
    ("우위성"
     "優位性")
    ("우유"
     "牛乳")
    ("우유부단"
     "優柔不斷"
     "優柔不斷")
    ("우유죽"
     "牛乳粥")
    ("우유함영"
     "優游涵泳")
    ("우육면"
     "牛肉麵")
    ("우의"
     "友誼"
     "寓意"
     "雨衣")
    ("우의극"
     "寓意劇")
    ("우의성"
     "寓意性")
    ("우의적"
     "友誼的")
    ("우의정"
     "右議政")
    ("우이독경"
     "牛耳讀經")
    ("우이득중"
     "偶爾得中")
    ("우익"
     "右翼")
    ("우자"
     "愚者")
    ("우자일득"
     "愚者一得")
    ("우장"
     "雨裝")
    ("우점"
     "優占"
     "優點")
    ("우점적"
     "優點的")
    ("우점종"
     "優占種")
    ("우정"
     "友情"
     "郵政")
    ("우주"
     "宇宙")
    ("우주관"
     "宇宙觀")
    ("우주론"
     "宇宙論")
    ("우주복"
     "宇宙服")
    ("우주선"
     "宇宙船")
    ("우주인"
     "宇宙人")
    ("우주적"
     "宇宙的")
    ("우주전"
     "宇宙戰")
    ("우주화"
     "宇宙化")
    ("우중"
     "愚衆"
     "雨中")
    ("우직"
     "愚直")
    ("우체"
     "郵遞")
    ("우체국"
     "郵遞局")
    ("우체부"
     "郵遞夫")
    ("우체통"
     "郵遞筒")
    ("우측"
     "右側")
    ("우파"
     "右派")
    ("우파적"
     "右派的")
    ("우편"
     "右便"
     "郵便")
    ("우편물"
     "郵便物")
    ("우편선"
     "郵便船")
    ("우편함"
     "郵便函")
    ("우편환"
     "郵便換")
    ("우표"
     "郵票")
    ("우현"
     "右舷")
    ("우호"
     "友好")
    ("우호적"
     "友好的")
    ("우화"
     "寓話")
    ("우화등선"
     "羽化登仙")
    ("우화성"
     "寓話性")
    ("우화적"
     "寓話的")
    ("우환"
     "憂患")
    ("우황"
     "牛黃")
    ("우회"
     "迂廻")
    ("우회로"
     "迂廻路")
    ("우회적"
     "迂廻的")
    ("우회전"
     "右回轉")
    ("우후죽순"
     "雨後竹筍")
    ("욱"
     ("勖" . "힘쓸 욱")
     ("彧" . "빛날 욱, 문채날 욱")
     ("旭" . "빛날 욱, 햇살 치밀 욱, 교만할 욱")
     ("昱" . "햇빛 밝을 욱")
     ("栯" . "산앵두 욱")
     "澳"
     ("煜" . "비칠 욱, 불꽃 욱, 성할 욱")
     ("稶" . "서직 무성할 욱")
     ("郁" . "문채날 욱, 자욱할 욱")
     ("頊" . "머리 굽실거릴 욱, 별이름 욱")
     ("燠" . "더울 욱")
     "隩")
    ("욱일"
     "旭日")
    ("욱일승천"
     "旭日昇天")
    ("욱일형"
     "旭日形")
    ("운"
     ("云" . "이를 운, 움직일 운, 돌아갈 운")
     ("橒" . "나무 무늬 운")
     ("殞" . "죽을 운, 떨어질 운")
     ("澐" . "큰 물결 운")
     ("熉" . "누른 빛 운")
     ("耘" . "길 맬 운")
     ("芸" . "향풀 운, 궁궁이 운, 촘촘할 운, 성씨 운")
     ("蕓" . "운풀 운, 평지 운")
     ("運" . "움직일 운, 운수 운")
     ("隕" . "떨어질 운, 곤란할 운")
     ("雲" . "구름 운, 팔대손 운, 하늘 운")
     ("韻" . "울림 운, 소리 맞을 운, 운 운")
     ("暈" . "무리 운, 어지러울 운")
     ("惲" . "의논할 운, 혼후할 운")
     ("沄" . "물 콸콸 흐를 운, 끓을 운")
     ("篔" . "왕대나무 운")
     ("紜" . "얼크러질 운")
     ("霣" . "떨어질 운, 천둥에 비 몰아올 운")
     ("韵" . "韻과 同字"))
    ("운감"
     "殞感")
    ("운개견일"
     "雲開見日")
    ("운구"
     "運柩")
    ("운근성풍"
     "運斤成風")
    ("운니지차"
     "雲泥之差")
    ("운동"
     "運動")
    ("운동가"
     "運動家")
    ("운동감"
     "運動感")
    ("운동권"
     "運動圈")
    ("운동량"
     "運動量")
    ("운동력"
     "運動力")
    ("운동론"
     "運動論")
    ("운동복"
     "運動服")
    ("운동비"
     "運動費")
    ("운동사"
     "運動史")
    ("운동상"
     "運動賞")
    ("운동선수"
     "運動選手")
    ("운동성"
     "運動性")
    ("운동원"
     "運動員")
    ("운동장"
     "運動場")
    ("운동적"
     "運動的")
    ("운동화"
     "運動靴")
    ("운동회"
     "運動會")
    ("운력"
     "運力")
    ("운룡풍호"
     "雲龍風虎")
    ("운명"
     "殞命"
     "運命")
    ("운명론"
     "運命論")
    ("운명적"
     "運命的")
    ("운모"
     "雲母")
    ("운무"
     "雲霧")
    ("운문"
     "韻文")
    ("운문극"
     "韻文劇")
    ("운문대단"
     "雲紋大緞")
    ("운반"
     "運搬")
    ("운반비"
     "運搬費")
    ("운반인"
     "運搬人")
    ("운보법"
     "運步法")
    ("운사"
     "雲師")
    ("운산조몰"
     "雲散鳥沒")
    ("운상기품"
     "雲上氣稟")
    ("운석"
     "隕石")
    ("운세"
     "運勢")
    ("운송"
     "運送")
    ("운송선"
     "運送船")
    ("운송업"
     "運送業")
    ("운송업자"
     "運送業者")
    ("운수"
     "運數"
     "運輸"
     "雲水")
    ("운수소관"
     "運數所關")
    ("운수업자"
     "運輸業者")
    ("운수업체"
     "運輸業體")
    ("운신"
     "運身")
    ("운심월성"
     "雲心月性")
    ("운연과안"
     "雲煙過眼")
    ("운영"
     "運營")
    ("운영과장"
     "運營課長")
    ("운영난"
     "運營難")
    ("운영부"
     "運營部")
    ("운영비"
     "運營費")
    ("운영사"
     "運營社")
    ("운영자"
     "運營者")
    ("운용"
     "運用")
    ("운용비"
     "運用費")
    ("운우지정"
     "雲雨之情")
    ("운운"
     "云云")
    ("운위"
     "云謂")
    ("운율"
     "韻律")
    ("운임"
     "運賃")
    ("운전"
     "運轉")
    ("운전기사"
     "運轉技士")
    ("운전면허"
     "運轉免許")
    ("운전병"
     "運轉兵")
    ("운전사"
     "運轉士")
    ("운전석"
     "運轉席")
    ("운전수"
     "運轉手")
    ("운전자"
     "運轉者")
    ("운전회"
     "運轉會")
    ("운중백학"
     "雲中白鶴")
    ("운증용변"
     "雲蒸龍變")
    ("운증초윤"
     "雲蒸礎潤")
    ("운지법"
     "運指法")
    ("운지장상"
     "運之掌上")
    ("운집"
     "雲集")
    ("운출무심"
     "雲出無心")
    ("운치"
     "韻致")
    ("운하"
     "運河")
    ("운합무집"
     "雲合霧集")
    ("운항"
     "運航")
    ("운항권"
     "運航權")
    ("운행"
     "運行")
    ("운행제"
     "運行制")
    ("운휴"
     "運休")
    ("울"
     ("蔚" . "고을이름 울")
     ("鬱" . "향기로운 풀 울")
     "熨")
    ("울분"
     "鬱憤")
    ("울산"
     "蔚山")
    ("울적"
     "鬱寂")
    ("울창"
     "鬱蒼")
    ("울화"
     "鬱火")
    ("울화병"
     "鬱火病")
    ("움막"
     "­幕")
    ("웅"
     ("熊" . "곰 웅, 빛날 웅")
     ("雄" . "수컷 웅, 영웅 웅, 웅장할 웅"))
    ("웅건"
     "雄健")
    ("웅담"
     "熊膽")
    ("웅대"
     "雄大")
    ("웅변"
     "雄辯")
    ("웅변대회"
     "雄辯大會")
    ("웅변적"
     "雄辯的")
    ("웅변조"
     "雄辯調")
    ("웅장"
     "雄壯")
    ("웅호지사"
     "熊虎之士")
    ("원"
     ("元" . "으뜸 원, 착하고 어질 원, 일 년의 첫 날 원, 임금 원, 백성 원, 하늘 원")
     "円"
     ("原" . "근본 원, 거듭 원, 언덕 원, 기인할 원, 들판 원")
     ("員" . "관원 원, 둥글 원")
     ("園" . "동산 원, 능 원, 울타리 원")
     ("圓" . "둥글 원, 원만할 원, 화폐의 단위 원")
     ("垣" . "낮은 담 원, 보호하는 사람 원, 별 이름 원")
     ("媛" . "아리따운 여자 원, 여자 벼슬이름 원")
     ("嫄" . "여자이름 원")
     ("寃" . "원통할 원, 굽힐 원, 죄 없을 원")
     ("怨" . "원망할 원, 원수 원, 분낼 원")
     ("愿" . "정성 원, 착할 원, 삼갈 원")
     ("援" . "당길 원, 사다리 원, 구원할 원")
     ("沅" . "물 이름 원")
     ("洹" . "흐를 원, 물 이름 원")
     ("湲" . "물소리 원, 물 졸졸 흐를 원")
     ("源" . "근원 원, 샘 원, 계속할 원")
     ("爰" . "당길 원, 이끌 원, 가로되 원")
     ("猿" . "원숭이 원, 잔나비 원")
     "琬"
     ("瑗" . "도리옥 원, 구멍 큰 둥근 옥 원")
     ("苑" . "나랏동산 원, 큰 바람 원")
     ("袁" . "옷 치렁거릴 원, 성씨 원")
     ("轅" . "진문 원, 멍에 원, 별 이름 원")
     ("遠" . "멀 원, 심오할 원")
     ("院" . "원집 원, 공해 원, 절 원, 학교 원")
     ("願" . "하고자할 원, 바랄 원, 생각할 원")
     ("鴛" . "숫원앙새 원")
     ("阮" . "원나라 원, 성씨 원")
     ("冤" . "원통할 원, 원한 원")
     ("杬" . "몸 주무를 원, 나무이름 원")
     ("楥" . "떡갈나무 원, 실감개 원, 신골 원")
     ("猨" . "猿과 同字")
     "綩"
     ("芫" . "고기 잡는 풀 원, 여뀌 원")
     ("薗" . "園과 同字")
     ("蜿" . "굼틀거릴 원")
     ("謜" . "천천히 말할 원, 기꺼울 원")
     ("鋺" . "저울 바탕 원")
     ("騵" . "배 희고 갈기 검은 말 원")
     ("鵷" . "원추새 원")
     ("黿" . "큰 자라 원"))
    ("원가"
     "原價")
    ("원가력"
     "元嘉曆")
    ("원거리"
     "遠距離")
    ("원격"
     "遠隔")
    ("원경"
     "遠景")
    ("원고"
     "原告"
     "原稿")
    ("원고료"
     "原稿料")
    ("원고지"
     "原稿紙")
    ("원고향"
     "原故鄕")
    ("원공방목"
     "圓孔方木")
    ("원교근공"
     "遠交近攻")
    ("원군"
     "援軍")
    ("원귀"
     "寃鬼")
    ("원근"
     "遠近")
    ("원근법"
     "遠近法")
    ("원근법적"
     "遠近法的")
    ("원금"
     "元金")
    ("원기"
     "元氣")
    ("원내"
     "院內")
    ("원내무반"
     "原內務班")
    ("원년"
     "元年")
    ("원단"
     "元旦")
    ("원대"
     "原隊"
     "遠大")
    ("원도"
     "原圖")
    ("원동력"
     "原動力")
    ("원두"
     "原豆")
    ("원두막"
     "園頭幕")
    ("원두방족"
     "圓頭方足")
    ("원래"
     "元來")
    ("원려"
     "遠慮")
    ("원력"
     "元力")
    ("원로"
     "元老")
    ("원로원"
     "元老院")
    ("원론"
     "原論")
    ("원론적"
     "原論的")
    ("원료"
     "原料")
    ("원료비"
     "原料費")
    ("원류"
     "源流")
    ("원리"
     "原理")
    ("원리금"
     "元利金")
    ("원리적"
     "原理的")
    ("원리주의"
     "原理主義")
    ("원만"
     "圓滿")
    ("원망"
     "怨望")
    ("원면"
     "原綿")
    ("원목"
     "原木")
    ("원목경침"
     "圓木警枕")
    ("원무과"
     "院務課")
    ("원문"
     "原文")
    ("원반"
     "圓盤")
    ("원본"
     "原本")
    ("원부"
     "原簿")
    ("원비"
     "元妃")
    ("원산"
     "原産")
    ("원산지"
     "原産地")
    ("원삼"
     "圓衫")
    ("원상"
     "原狀")
    ("원상태"
     "原狀態")
    ("원상회복"
     "原狀回復")
    ("원색"
     "原色")
    ("원색적"
     "原色的")
    ("원생"
     "院生")
    ("원생목"
     "原生木")
    ("원서"
     "原書"
     "願書")
    ("원서대"
     "願書代")
    ("원석"
     "原石")
    ("원성"
     "怨聲")
    ("원소"
     "元素")
    ("원수"
     "元帥"
     "元首"
     "怨讐")
    ("원수지간"
     "怨讐之間")
    ("원숙"
     "圓熟")
    ("원숙기"
     "圓熟期")
    ("원숙미"
     "圓熟美")
    ("원숙성"
     "圓熟性")
    ("원시"
     "原始")
    ("원시림"
     "原始林")
    ("원시생활"
     "原始生活")
    ("원시인"
     "原始人")
    ("원시적"
     "原始的")
    ("원시주의"
     "原始主義")
    ("원시주의자"
     "原始主義者")
    ("원심"
     "原審")
    ("원안"
     "原案")
    ("원앙금침"
     "鴛鴦衾枕")
    ("원앙지계"
     "鴛鴦之契")
    ("원액"
     "原液")
    ("원양"
     "遠洋")
    ("원어"
     "原語")
    ("원예"
     "園藝")
    ("원예사"
     "園藝師")
    ("원외"
     "院外")
    ("원용"
     "援用")
    ("원운동"
     "圓運動")
    ("원위치"
     "原位置")
    ("원유"
     "原油")
    ("원유가"
     "原油價")
    ("원융"
     "圓融")
    ("원음"
     "原音")
    ("원의미"
     "原意味")
    ("원인"
     "原人"
     "原因")
    ("원인균"
     "原因菌")
    ("원인론"
     "原因論")
    ("원인적"
     "原因的")
    ("원입골수"
     "怨入骨髓")
    ("원자"
     "原子")
    ("원자력"
     "原子力")
    ("원자로"
     "原子爐")
    ("원자시계"
     "原子時計")
    ("원자재"
     "原資材")
    ("원자탄"
     "原子彈")
    ("원자핵"
     "原子核")
    ("원자화"
     "原子化")
    ("원작"
     "原作")
    ("원작자"
     "原作者")
    ("원장"
     "園長"
     "院長")
    ("원장실"
     "院長室")
    ("원재료"
     "原材料")
    ("원저자"
     "原著者")
    ("원적"
     "原籍")
    ("원적외선"
     "遠赤外線")
    ("원전"
     "原典"
     "原電")
    ("원점"
     "原點")
    ("원정"
     "遠征")
    ("원정군"
     "遠征軍")
    ("원정대"
     "遠征隊")
    ("원정대원"
     "遠征隊員")
    ("원정대장"
     "遠征隊長")
    ("원제"
     "原題")
    ("원조"
     "元祖"
     "援助")
    ("원족근린"
     "遠族近隣")
    ("원죄"
     "原罪")
    ("원죄자"
     "原罪者")
    ("원주민"
     "原住民")
    ("원주인"
     "原主人")
    ("원증회고"
     "怨憎會苦")
    ("원직"
     "原職")
    ("원천"
     "源泉")
    ("원천우인"
     "怨天尤人")
    ("원천적"
     "源泉的")
    ("원청유청"
     "源淸流淸")
    ("원체"
     "元體")
    ("원초"
     "原初")
    ("원초아"
     "原初我")
    ("원초적"
     "原初的")
    ("원추"
     "圓錐")
    ("원칙"
     "原則")
    ("원칙론"
     "原則論")
    ("원칙론적"
     "原則論的")
    ("원칙적"
     "原則的")
    ("원탁"
     "圓卓")
    ("원탁회의"
     "圓卓會議")
    ("원탑"
     "圓塔")
    ("원통"
     "圓筒"
     "寃痛")
    ("원판"
     "圓板")
    ("원폭"
     "原爆")
    ("원표"
     "元標")
    ("원한"
     "怨恨")
    ("원행"
     "遠行")
    ("원형"
     "元型"
     "原型"
     "原形"
     "圓形")
    ("원형이정"
     "元亨利貞")
    ("원형적"
     "原形的")
    ("원형질"
     "元型質"
     "原形質")
    ("원호"
     "援護")
    ("원혼"
     "寃魂")
    ("원화"
     "源花")
    ("원화소복"
     "遠禍召福")
    ("원환"
     "圓環")
    ("원활"
     "圓滑")
    ("원후취월"
     "猿猴取月")
    ("원흉"
     "元兇")
    ("월"
     ("月" . "달 월")
     ("越" . "넘을 월, 뛸 월, 월나라 월")
     ("鉞" . "도끼 월")
     ("刖" . "발꿈치 자를 월")
     ("粤" . "말 내킬 월, 곰곰히 생각할 월, 나라이름 월"))
    ("월간"
     "月刊")
    ("월간지"
     "月刊誌")
    ("월경"
     "月經")
    ("월경량"
     "月經量")
    ("월계수"
     "月桂樹")
    ("월광"
     "月光")
    ("월권행위"
     "越權行爲")
    ("월급"
     "月給")
    ("월급봉투"
     "月給封套")
    ("월남"
     "越南")
    ("월남어"
     "越南語")
    ("월단평"
     "月旦評")
    ("월동"
     "越冬")
    ("월등"
     "越等")
    ("월라"
     "越羅")
    ("월례"
     "月例")
    ("월로풍운"
     "月露風雲")
    ("월만즉휴"
     "月滿則虧")
    ("월말"
     "月末")
    ("월명성희"
     "月明星稀")
    ("월반"
     "越班")
    ("월백풍청"
     "月白風淸")
    ("월별"
     "月別")
    ("월병"
     "月餠")
    ("월봉"
     "月俸")
    ("월부"
     "月賦")
    ("월북"
     "越北")
    ("월사금"
     "月謝金")
    ("월색"
     "月色")
    ("월세"
     "月貰")
    ("월수입"
     "月收入")
    ("월요"
     "月曜")
    ("월요일"
     "月曜日")
    ("월장"
     "越牆")
    ("월장성구"
     "月章星句")
    ("월조소남지"
     "越鳥巢南枝")
    ("월중"
     "月中")
    ("월진승선"
     "越津乘船")
    ("월척"
     "越尺")
    ("월초"
     "月初")
    ("월평"
     "月評")
    ("월평균"
     "月平均")
    ("월하빙인"
     "月下氷人")
    ("위"
     ("位" . "벼슬 위, 임금의 신분 위, 자리 위, 방위 위")
     ("倭" . "순한 모양 위, 빙글 돌아올 위")
     ("偉" . "클 위, 넉넉할 위, 기특할 위")
     ("僞" . "거짓 위, 속일 위")
     ("危" . "위태할 위, 무너질 위, 상할 위, 높을 위, 별 이름 위")
     ("圍" . "둘레 위, 에워 쌀 위, 한아람 위, 지킬 위")
     ("委" . "맡길 위, 버릴 위, 맘에 든든할 위, 벼이삭 고개 숙일 위")
     ("威" . "위엄 위, 두려울 위")
     ("尉" . "벼슬이름 위, 눌릴 위")
     ("慰" . "위로할 위")
     ("暐" . "햇빛 위, 빛 환할 위")
     ("渭" . "물 이름 위, 속 끓일 위")
     ("爲" . "할 위, 다스릴 위, 하여금 위, 어미원숭이 위, 이룰 위")
     ("瑋" . "위옥 위, 노리개 위")
     ("緯" . "씨줄 위, 별 오른편으로 돌 위")
     ("胃" . "밥통 위, 별 이름 위, 성씨 위")
     ("萎" . "마를 위, 풀 이름 위, 쇠약해질 위")
     ("葦" . "갈대 위, 작은 배 위")
     ("蔚" . "제비쑥 위, 초목 우거진 모양 위, 잔무늬 위")
     ("蔿" . "풀 위, 성씨 위, 고을이름 위")
     ("蝟" . "고슴도치 위")
     ("衛" . "衞와 同字")
     ("褘" . "휘장 위, 아름다울 위")
     ("謂" . "고할 위, 이를 위")
     ("違" . "어길 위, 미적거릴 위, 되돌아올 위")
     ("韋" . "다룬 가죽 위, 훌부들할 위, 군복 위, 성씨 위")
     ("魏" . "위나라 위, 대궐 위, 우뚝할 위")
     ("喟" . "한숨쉴 위")
     ("幃" . "향낭 위, 홑휘장 위")
     "撝"
     "潙"
     ("煒" . "벌그레할 위, 환할 위")
     ("熨" . "다리미 위, 고약 붙일 위")
     ("痿" . "습병 위, 잘름거릴 위, 음위증 위")
     ("葳" . "초목 성할 위, 위유풀 위")
     ("衞" . "막을 위, 지킬 위, 핏기운 위, 나라이름 위")
     ("諉" . "핑계할 위, 버릴 위")
     ("逶" . "비틀거릴 위")
     ("闈" . "대궐안의 문 위")
     ("韙" . "옳을 위")
     ("韡" . "꽃 환히 필 위")
     ("餧" . "먹일 위")
     "骪")
    ("위경련"
     "胃痙攣")
    ("위계"
     "位階")
    ("위계적"
     "位階的")
    ("위계질서"
     "位階秩序")
    ("위계질서적"
     "位階秩序的")
    ("위관"
     "偉觀")
    ("위국"
     "危局")
    ("위국충절"
     "爲國忠節")
    ("위권"
     "位圈")
    ("위궤양"
     "胃潰瘍")
    ("위금"
     "緯錦")
    ("위급"
     "危急")
    ("위기"
     "危機")
    ("위기감"
     "危機感")
    ("위기관리"
     "危機管理")
    ("위기론"
     "危機論")
    ("위기론적"
     "危機論的")
    ("위기의식"
     "危機意識")
    ("위기일발"
     "危機一髮")
    ("위기적"
     "危機的")
    ("위기지학"
     "爲己之學")
    ("위대"
     "偉大")
    ("위대성"
     "偉大性")
    ("위도"
     "緯度")
    ("위독"
     "危篤")
    ("위락"
     "慰樂")
    ("위력"
     "威力")
    ("위력성당"
     "威力成黨")
    ("위력적"
     "威力的")
    ("위령"
     "慰靈")
    ("위령비"
     "慰靈碑")
    ("위령탑"
     "慰靈塔")
    ("위로"
     "慰勞")
    ("위로금"
     "慰勞金")
    ("위로자"
     "慰勞者")
    ("위무"
     "威武"
     "慰撫")
    ("위무경문"
     "緯武經文")
    ("위문"
     "慰問")
    ("위문편지"
     "慰問便紙")
    ("위반"
     "違反")
    ("위반자"
     "違反者")
    ("위반죄"
     "違反罪")
    ("위배"
     "違背")
    ("위법"
     "違法")
    ("위법성"
     "違法性")
    ("위법자폐"
     "爲法自弊")
    ("위법적"
     "違法的")
    ("위벽"
     "胃壁")
    ("위병"
     "衛兵")
    ("위병소"
     "衛兵所")
    ("위병소장"
     "衛兵所長")
    ("위사"
     "緯絲")
    ("위산"
     "胃酸")
    ("위상"
     "位相")
    ("위생"
     "衛生")
    ("위생법"
     "衛生法")
    ("위생성"
     "衛生性")
    ("위생적"
     "衛生的")
    ("위생학적"
     "衛生學的")
    ("위선"
     "僞善")
    ("위선자"
     "僞善者")
    ("위선적"
     "僞善的")
    ("위성"
     "衛星")
    ("위세"
     "位勢"
     "威勢")
    ("위수령"
     "衛戍令")
    ("위시"
     "爲始")
    ("위신"
     "威信")
    ("위악적"
     "僞惡的")
    ("위안"
     "慰安")
    ("위안부"
     "慰安婦")
    ("위암"
     "胃癌")
    ("위압"
     "威壓")
    ("위압감"
     "威壓感")
    ("위압적"
     "威壓的")
    ("위약조로"
     "危若朝露")
    ("위엄"
     "威嚴")
    ("위엄성"
     "威嚴性")
    ("위업"
     "偉業")
    ("위염"
     "胃炎")
    ("위용"
     "威容")
    ("위원"
     "委員")
    ("위원실"
     "委員室")
    ("위원장"
     "委員長")
    ("위원장직"
     "委員長職")
    ("위원직"
     "委員職")
    ("위원회"
     "委員會")
    ("위원회장"
     "委員會長")
    ("위의"
     "威儀")
    ("위인"
     "偉人"
     "爲人")
    ("위인설관"
     "爲人設官")
    ("위인설관식"
     "爲人設官式")
    ("위인전"
     "偉人傳")
    ("위인전기"
     "偉人傳記")
    ("위임"
     "委任")
    ("위임자"
     "委任者")
    ("위임장"
     "委任狀")
    ("위자료"
     "慰藉料")
    ("위작"
     "僞作")
    ("위장"
     "僞裝"
     "委長"
     "胃臟")
    ("위장병"
     "胃臟病")
    ("위장술"
     "僞裝術")
    ("위장염"
     "胃臟炎")
    ("위전"
     "位戰")
    ("위정자"
     "爲政者")
    ("위정척사"
     "衛正斥邪")
    ("위조"
     "僞造")
    ("위조단"
     "僞造團")
    ("위조설"
     "僞造說")
    ("위조죄"
     "僞造罪")
    ("위조지폐"
     "僞造紙幣")
    ("위주"
     "爲主")
    ("위주적"
     "爲主的")
    ("위증"
     "僞證")
    ("위촉"
     "委囑")
    ("위촉장"
     "委囑狀")
    ("위축"
     "萎縮")
    ("위치"
     "位置")
    ("위친지도"
     "爲親之道")
    ("위탁"
     "委託")
    ("위태"
     "危殆")
    ("위통"
     "胃痛")
    ("위패"
     "位牌")
    ("위편삼절"
     "韋編三絶")
    ("위폐"
     "僞幣")
    ("위풍당당"
     "威風堂堂")
    ("위하수"
     "胃下垂")
    ("위해"
     "危害")
    ("위해성"
     "危害性")
    ("위헌"
     "違憲")
    ("위헌성"
     "違憲性")
    ("위헌적"
     "違憲的")
    ("위험"
     "危險")
    ("위험물"
     "危險物")
    ("위험성"
     "危險性")
    ("위험천만"
     "危險千萬")
    ("위협"
     "威脅")
    ("위협감"
     "威脅感")
    ("위협당"
     "威脅當")
    ("위협론"
     "威脅論")
    ("위협성"
     "威脅性")
    ("위협적"
     "威脅的")
    ("위협조"
     "威脅調")
    ("위호부익"
     "爲虎傅翼")
    ("위화감"
     "違和感")
    ("유"
     ("乳" . "젖 유, 종유석 유, 낳을 유, 젖먹일 유, 기를 유")
     ("侑" . "도울 유, 권할 유, 귀인을 모시고 밥먹을 유")
     ("儒" . "선비 유, 나장이 유, 유도 유, 광대 유")
     ("兪" . "그럴 유, 대답할 유, 공손할 유")
     ("唯" . "오직 유, 허락할 유")
     ("喩" . "깨우쳐 줄 유, 알릴 유, 비유할 유")
     ("孺" . "젖먹이 유, 사모할 유, 딸릴 유")
     ("宥" . "너그러울 유, 죄 사할 유, 도울 유")
     ("幼" . "어릴 유, 사랑할 유")
     ("幽" . "숨을 유, 그윽할 유, 적을 유, 어두울 유, 귀신 유, 저승 유")
     ("庾" . "노적 유, 곡식 셈하는 단위 휘 유")
     ("悠" . "멀 유, 생각할 유, 한가할 유, 근심할 유")
     ("惟" . "꾀할 유, 오직 유, 생각할 유")
     ("愈" . "나을 유, 어질 유, 더욱 유, 병 나을 유")
     ("愉" . "기뻐할 유, 즐거울 유")
     ("揄" . "당길 유, 칭찬할 유, 희롱할 유")
     ("攸" . "곳 유, 휙 달아날 유, 아득할 유, 대롱거릴 유")
     ("有" . "있을 유, 얻을 유, 과연 유, 또 유")
     ("柔" . "부드러울 유, 순할 유, 복종할 유")
     ("柚" . "유자 유")
     ("楡" . "느름나무 유, 서쪽 유")
     ("楢" . "부드러운 나무 유, 홰 유")
     ("油" . "기름 유, 구름 피어오를 유, 공손할 유")
     ("洧" . "물이름 유")
     ("游" . "헤엄칠 유, 노닐 유, 깃발 유")
     ("濡" . "적실 유, 막힐 유, 곱고 윤택할 유")
     ("猶" . "어미 원숭이 유, 같을 유, 오히려 유")
     ("猷" . "꾀 유, 그릴 유, 옳을 유, 탄식할 유")
     ("瑜" . "아름다운 옥 유")
     ("由" . "말미암을 유, 쓸 유, 지날 유")
     ("癒" . "병 나을 유, 병들 유")
     ("綏" . "깃발 늘어질 유")
     ("維" . "벼리 유, 이을 유, 맺을 유, 오직 유")
     "繇"
     ("臾" . "잠간 유, 착할 유, 나라이름 유, 활이 뒤로 젖혀질 유")
     ("萸" . "수유 유")
     ("裕" . "넉넉할 유, 너그러울 유")
     ("誘" . "꾀일 유, 가르칠 유, 당길 유")
     ("諛" . "아첨할 유")
     ("諭" . "고할 유, 비유할 유")
     ("踰" . "넘을 유")
     ("蹂" . "밟을 유, 쌀 씻을 유")
     ("逾" . "갈 유, 지날 유")
     ("遊" . "놀 유, 벗 사귈 유")
     ("遺" . "잃어버릴 유, 남을 유, 끼칠 유")
     ("酉" . "별 유, 열째 지지 유, 나아갈 유")
     ("釉" . "물건 빛날 유")
     ("鍮" . "놋쇠 유")
     ("劉" . "이길 류, 죽일 류, 베풀 류, 성씨 류")
     ("杻" . "싸리 뉴")
     ("柳" . "버들 류, 별 이름 류")
     ("流" . "흐를 류, 번져나갈 류, 구할 류, 내칠 류, 달아날 류, 무리 류, 귀양보낼 류")
     ("溜" . "처마물 류, 낙수물 류, 증류수 류")
     ("琉" . "유리돌 류, 나라이름 류")
     ("留" . "머무를 류, 그칠 류, 오랠 류, 횡사할 류")
     ("硫" . "석류황 류, 유황 류")
     ("紐" . "단추 뉴, 맺을 뉴")
     ("類" . "같을 류, 나눌 류, 착할 류, 무리 류")
     ("冘" . "머뭇거릴 유, 갈 유")
     ("呦" . "사슴 우는 소리 유, 새짐승 우는 소리 유")
     ("囿" . "엔담 유, 고루할 유")
     ("壝" . "토담 유, 단 둘러쌓은 담 유")
     ("帷" . "휘장 유")
     ("揉" . "풀 유, 부드럽게 할 유, 희일 유")
     ("斿" . "깃발 유, 깃술 유, 면류관술 유")
     ("泑" . "물빛이 검을 유, 물이름 유")
     ("牖" . "엇살창 유, 들창 유, 밝을 유, 인도할 유")
     ("瘉" . "癒와 同字")
     ("瘐" . "죄인 주려 죽을 유")
     ("窬" . "판장문 유")
     ("窳" . "이지러질 유, 약할 유, 짐승이름 유")
     ("籲" . "부르짖을 유")
     ("糅" . "섞일 유, 얽힐 유, 잡곡밥 유")
     "緌"
     ("腴" . "아랫배 살찔 유")
     ("莠" . "가라지 유, 추할 유")
     ("蕕" . "냄새나는 풀 유, 유풀 유")
     ("蕤" . "더북할 유")
     ("蚰" . "노래기 유, 땅지네 유")
     ("蚴" . "굼틀거릴 유")
     ("蝤" . "하루살이 유")
     "蠕"
     ("褕" . "꿩의 깃으로 꾸민 옷 유, 쾌자 유")
     ("讉" . "성낼 유")
     ("逌" . "빙그레할 유")
     ("鞣" . "다룬 가죽 유, 마른 가죽 유")
     ("鮪" . "상어 유")
     ("黝" . "검푸를 유, 검은칠할 유")
     ("鼬" . "청서 유, 족제비 유")
     ("龥" . "부르짖을 유"))
    ("유가"
     "儒家"
     "有價"
     "油價")
    ("유가적"
     "儒家的")
    ("유가족"
     "遺家族")
    ("유각양춘"
     "有脚陽春")
    ("유감"
     "有感"
     "遺憾")
    ("유개념"
     "類槪念")
    ("유격"
     "遊擊")
    ("유격대원"
     "遊擊隊員")
    ("유격수"
     "遊擊手")
    ("유고"
     "遺稿")
    ("유골"
     "遺骨")
    ("유공자"
     "有功者")
    ("유관"
     "有關")
    ("유관성"
     "有關性")
    ("유괴"
     "誘拐")
    ("유괴범"
     "誘拐犯")
    ("유교"
     "儒敎")
    ("유교권"
     "儒敎圈")
    ("유교적"
     "儒敎的")
    ("유교학과"
     "儒敎學科")
    ("유교화"
     "儒敎化")
    ("유구"
     "悠久")
    ("유구무언"
     "有口無言")
    ("유구불언"
     "有口不言")
    ("유권"
     "有權")
    ("유권자"
     "有權者")
    ("유급"
     "有給")
    ("유기"
     "有期"
     "有機"
     "遺棄"
     "鍮器")
    ("유기농"
     "有機農")
    ("유기론"
     "唯氣論")
    ("유기물"
     "有機物")
    ("유기적"
     "有機的")
    ("유기질"
     "有機質")
    ("유기체"
     "有機體")
    ("유년"
     "幼年")
    ("유년기"
     "幼年期")
    ("유념"
     "留念")
    ("유능"
     "有能")
    ("유능제강"
     "柔能制剛")
    ("유단자"
     "有段者")
    ("유당"
     "乳糖")
    ("유대"
     "紐帶")
    ("유대감"
     "紐帶感")
    ("유덕"
     "有德")
    ("유도"
     "柔道"
     "誘導")
    ("유독"
     "唯獨"
     "有毒")
    ("유독물"
     "有毒物")
    ("유독성"
     "有毒性")
    ("유동"
     "流動")
    ("유동성"
     "流動性")
    ("유동적"
     "流動的")
    ("유동화"
     "流動化")
    ("유두"
     "乳頭")
    ("유두무미"
     "有頭無尾")
    ("유두분면"
     "油頭粉面")
    ("유락가"
     "遊樂街")
    ("유람"
     "遊覽")
    ("유람선"
     "遊覽船")
    ("유랑"
     "流浪")
    ("유랑파"
     "流浪派")
    ("유래"
     "由來")
    ("유래지풍"
     "由來之風")
    ("유량"
     "流量")
    ("유려"
     "流麗")
    ("유력"
     "有力")
    ("유력시"
     "有力視")
    ("유력자"
     "有力者")
    ("유력층"
     "有力層")
    ("유령"
     "幽靈")
    ("유례"
     "類例")
    ("유로"
     "流路")
    ("유록색"
     "柳綠色")
    ("유록화홍"
     "柳綠花紅")
    ("유료"
     "有料")
    ("유료화"
     "有料化")
    ("유류"
     "油類")
    ("유리"
     "有利"
     "遊離"
     "流離"
     "琉璃")
    ("유리걸식"
     "流離乞食")
    ("유리문"
     "琉璃門")
    ("유리병"
     "琉璃甁")
    ("유리잔"
     "琉璃盞")
    ("유리창"
     "琉璃窓")
    ("유리판"
     "琉璃板")
    ("유린"
     "蹂躪")
    ("유린당"
     "蹂躪當")
    ("유림"
     "儒林")
    ("유만부동"
     "類萬不同")
    ("유망"
     "有望"
     "流亡")
    ("유망민"
     "流亡民")
    ("유망주"
     "有望株")
    ("유명"
     "有名")
    ("유명무실"
     "有名無實")
    ("유명세"
     "有名稅")
    ("유명인"
     "有名人")
    ("유모"
     "乳母")
    ("유모차"
     "乳母車")
    ("유목"
     "遊牧")
    ("유목민"
     "遊牧民")
    ("유무"
     "有無")
    ("유무상생"
     "有無相生")
    ("유묵"
     "遺墨")
    ("유물"
     "唯物"
     "遺物")
    ("유물론"
     "唯物論")
    ("유물론자"
     "唯物論者")
    ("유물론적"
     "唯物論的")
    ("유물주의"
     "唯物主義")
    ("유미주의자"
     "唯美主義者")
    ("유미주의적"
     "唯美主義的")
    ("유민"
     "遺民"
     "流民")
    ("유민사"
     "流民史")
    ("유발"
     "誘發")
    ("유발력"
     "誘發力")
    ("유발점"
     "誘發點")
    ("유방"
     "乳房")
    ("유방백세"
     "流芳百世")
    ("유방암"
     "乳房癌")
    ("유배"
     "流配")
    ("유배지"
     "流配地")
    ("유별"
     "有別")
    ("유보"
     "留保"
     "留保")
    ("유보적"
     "留保的")
    ("유복"
     "裕福")
    ("유복아"
     "遺腹兒")
    ("유복자"
     "遺腹子")
    ("유복지친"
     "有服之親")
    ("유부"
     "乳腐"
     "油腐")
    ("유부남"
     "有婦男")
    ("유부녀"
     "有夫女")
    ("유분"
     "油分")
    ("유분기"
     "油分氣")
    ("유분수"
     "有分數")
    ("유불선"
     "儒佛仙")
    ("유비무환"
     "有備無患")
    ("유사"
     "有史"
     "類似")
    ("유사무이"
     "有死無二")
    ("유사성"
     "類似性")
    ("유사시"
     "有事時")
    ("유사어"
     "類似語")
    ("유사점"
     "類似點")
    ("유사품"
     "類似品")
    ("유산"
     "乳酸"
     "有産"
     "遺産"
     "流産")
    ("유산율"
     "流産率")
    ("유산증"
     "流産症")
    ("유상"
     "有償"
     "有常")
    ("유색"
     "有色")
    ("유생"
     "儒生")
    ("유서"
     "由緖"
     "遺書")
    ("유선"
     "有線")
    ("유선형"
     "流線型")
    ("유성"
     "油性"
     "流星")
    ("유성기"
     "留聲機")
    ("유세"
     "有勢"
     "遊說")
    ("유세장"
     "遊說場")
    ("유세전"
     "遊說戰")
    ("유소년"
     "幼少年")
    ("유소성"
     "留巢性")
    ("유수"
     "有數"
     "有水"
     "流水")
    ("유수불부"
     "流水不腐")
    ("유숙"
     "留宿")
    ("유순"
     "柔順")
    ("유시무종"
     "有始無終")
    ("유식"
     "有識")
    ("유식론"
     "唯識論")
    ("유식자"
     "有識者")
    ("유식학"
     "唯識學")
    ("유신"
     "維新"
     "遺臣")
    ("유실"
     "流失")
    ("유심"
     "有心")
    ("유아"
     "乳兒"
     "幼兒")
    ("유아기"
     "幼兒期")
    ("유아독존"
     "唯我獨尊")
    ("유아복"
     "乳兒服")
    ("유아어"
     "幼兒語")
    ("유아지탄"
     "由我之歎")
    ("유아화"
     "幼兒化")
    ("유야무야"
     "有耶無耶")
    ("유약"
     "柔弱")
    ("유언"
     "有言"
     "遺言"
     "流言")
    ("유언비어"
     "流言蜚語")
    ("유언장"
     "遺言狀")
    ("유역"
     "流域")
    ("유역권"
     "流域圈")
    ("유연"
     "悠然"
     "柔軟")
    ("유연성"
     "柔軟性")
    ("유연탄"
     "有煙炭")
    ("유영"
     "游泳")
    ("유영복"
     "遊泳服")
    ("유예"
     "猶豫")
    ("유예론자"
     "猶豫論者")
    ("유용"
     "有用"
     "流用")
    ("유용성"
     "有用性")
    ("유운경룡"
     "游雲驚龍")
    ("유원지"
     "遊園地")
    ("유월"
     "六月")
    ("유유"
     "悠悠")
    ("유유낙낙"
     "唯唯諾諾")
    ("유유도일"
     "悠悠度日")
    ("유유상종"
     "類類相從")
    ("유유자적"
     "悠悠自適")
    ("유의"
     "有意"
     "留意")
    ("유의미성"
     "有意味性")
    ("유의유식"
     "遊衣遊食")
    ("유익"
     "有益")
    ("유인"
     "有人"
     "誘因"
     "誘引")
    ("유인물"
     "油印物")
    ("유인원"
     "類人猿")
    ("유인책"
     "誘引策")
    ("유일"
     "唯一")
    ("유일무이"
     "唯一無二")
    ("유일부족"
     "惟日不足")
    ("유일신"
     "唯一神")
    ("유임"
     "留任"
     "留任")
    ("유입"
     "流入")
    ("유입기"
     "流入期")
    ("유입량"
     "流入量")
    ("유입부"
     "流入部")
    ("유자"
     "儒者"
     "柚子"
     "諛者")
    ("유자차"
     "柚子茶")
    ("유작전"
     "遺作展")
    ("유장"
     "悠長")
    ("유적"
     "遺跡")
    ("유적지"
     "遺跡地")
    ("유전"
     "油田"
     "遺傳"
     "流轉")
    ("유전병"
     "遺傳病")
    ("유전성"
     "遺傳性")
    ("유전자"
     "遺傳子")
    ("유전적"
     "遺傳的")
    ("유전학"
     "遺傳學")
    ("유전학적"
     "遺傳學的")
    ("유정"
     "有情"
     "油井"
     "遺精")
    ("유제"
     "遺制")
    ("유제품"
     "乳製品")
    ("유조"
     "幼鳥")
    ("유조군"
     "留鳥群")
    ("유조선"
     "油槽船")
    ("유족"
     "遺族")
    ("유족회"
     "遺族會")
    ("유종"
     "有終")
    ("유종지미"
     "有終之美")
    ("유죄"
     "有罪")
    ("유죄자"
     "有罪者")
    ("유주무량"
     "有酒無量")
    ("유지"
     "乳脂"
     "有志"
     "油紙"
     "維持"
     "遺志")
    ("유지권"
     "維持權")
    ("유지방"
     "乳脂肪")
    ("유지비"
     "維持費")
    ("유지인"
     "維持人")
    ("유착"
     "癒着")
    ("유창"
     "流暢")
    ("유채"
     "油彩"
     "油菜")
    ("유추"
     "類推")
    ("유출"
     "流出"
     "流出")
    ("유출구"
     "流出口")
    ("유출액"
     "流出液")
    ("유충"
     "幼蟲")
    ("유취만년"
     "遺臭萬年")
    ("유치"
     "幼稚"
     "誘致"
     "留置")
    ("유치원"
     "幼稚園")
    ("유치원생"
     "幼稚園生")
    ("유치장"
     "留置場")
    ("유쾌"
     "愉快")
    ("유탄"
     "榴彈")
    ("유태교"
     "猶太敎")
    ("유태교도"
     "猶太敎徒")
    ("유통"
     "流通")
    ("유통계"
     "流通界")
    ("유통력"
     "流通力")
    ("유통망"
     "流通網")
    ("유통업"
     "流通業")
    ("유통업계"
     "流通業界")
    ("유통업자"
     "流通業者")
    ("유통업체"
     "流通業體")
    ("유파"
     "流派")
    ("유폐"
     "幽閉")
    ("유포"
     "流布"
     "流布")
    ("유포죄"
     "流布罪")
    ("유표적"
     "有標的")
    ("유품"
     "遺品")
    ("유필유방"
     "游必有方")
    ("유학"
     "儒學"
     "遊學"
     "留學")
    ("유학생"
     "遊學生"
     "留學生")
    ("유학승"
     "留學僧")
    ("유학자"
     "儒學者")
    ("유학파"
     "儒學派")
    ("유한"
     "有限")
    ("유한공자"
     "游閑公子")
    ("유한성"
     "有限性")
    ("유한층"
     "有閑層")
    ("유해"
     "有害"
     "遺骸")
    ("유해론"
     "有害論")
    ("유해무익"
     "有害無益")
    ("유해물"
     "有害物")
    ("유해성"
     "有害性")
    ("유행"
     "流行"
     "流行")
    ("유행가"
     "流行歌")
    ("유행곡"
     "流行曲")
    ("유행병"
     "流行病")
    ("유행성"
     "流行性")
    ("유행어"
     "流行語")
    ("유행적"
     "流行的")
    ("유허비"
     "遺墟碑")
    ("유현"
     "幽玄")
    ("유혈"
     "流血")
    ("유혈성천"
     "流血成川")
    ("유형"
     "有形"
     "類型")
    ("유형무적"
     "有形無跡")
    ("유형무형"
     "有形無形")
    ("유형성"
     "類型性")
    ("유형수"
     "流刑囚")
    ("유형적"
     "有形的"
     "類型的")
    ("유형지"
     "流刑地")
    ("유호덕"
     "攸好德")
    ("유혹"
     "誘惑")
    ("유혹적"
     "誘惑的")
    ("유화"
     "宥和"
     "油化"
     "油畵"
     "遺畵")
    ("유화업계"
     "油化業界")
    ("유화업체"
     "油化業體")
    ("유화전"
     "油畵展")
    ("유황"
     "硫黃")
    ("유효"
     "有效")
    ("유효성"
     "有效性")
    ("유효적절"
     "有效適切")
    ("유훈"
     "遺訓")
    ("유휴"
     "遊休")
    ("유휴지"
     "遊休地")
    ("유흥"
     "遊興")
    ("유흥가"
     "遊興街")
    ("유흥업"
     "遊興業")
    ("유흥업소"
     "遊興業所")
    ("유희"
     "遊戱")
    ("유희자"
     "遊戱者")
    ("유희적"
     "遊戱的")
    ("육"
     ("堉" . "기름진 땅 육")
     ("毓" . "기를 육, 어릴 육, 많을 육")
     ("肉" . "고기 육, 몸 육")
     ("育" . "기를 육, 날 육, 자랄 육")
     ("六" . "여섯 륙, 나라이름 륙")
     ("戮" . "죽일 륙, 육시할 륙, 욕할 륙")
     ("陸" . "뭍 륙, 길 륙, 어긋날 륙, 뛸 륙, 두터울 륙")
     ("儥" . "팔 육, 길 육"))
    ("육각"
     "六角")
    ("육각형"
     "六角形")
    ("육감"
     "肉感"
     "六感")
    ("육갑"
     "六甲")
    ("육개장"
     "肉-醬")
    ("육계"
     "肉鷄")
    ("육계색"
     "肉桂色")
    ("육교"
     "陸橋")
    ("육군"
     "陸軍")
    ("육기"
     "肉氣")
    ("육대주"
     "六大洲")
    ("육덕"
     "肉德")
    ("육두문자"
     "肉頭文字")
    ("육두품"
     "六頭品")
    ("육력동심"
     "戮力同心")
    ("육로"
     "陸路")
    ("육류"
     "肉類")
    ("육만"
     "六萬")
    ("육모정"
     "六-亭")
    ("육바라밀"
     "六波羅蜜")
    ("육박"
     "肉薄")
    ("육백"
     "六百")
    ("육백만"
     "六百萬")
    ("육부"
     "六腑"
     "六部")
    ("육부출충"
     "肉腐出蟲")
    ("육사"
     "陸士")
    ("육산포림"
     "肉山脯林")
    ("육상"
     "陸上")
    ("육상부원"
     "陸上部員")
    ("육성"
     "肉聲"
     "育成")
    ("육성책"
     "育成策")
    ("육성회"
     "育成會")
    ("육성회비"
     "育成會費")
    ("육성회장"
     "育成會長")
    ("육수"
     "肉垂"
     "肉水")
    ("육순"
     "六旬")
    ("육시"
     "戮屍")
    ("육식"
     "肉食")
    ("육식성"
     "肉食性")
    ("육신"
     "肉身")
    ("육십"
     "六十")
    ("육십갑자"
     "六十甲子")
    ("육십구"
     "六十九")
    ("육십삼"
     "六十三")
    ("육십진법"
     "六十進法")
    ("육십칠"
     "六十七")
    ("육십팔"
     "六十八")
    ("육아"
     "育兒")
    ("육아법"
     "育兒法")
    ("육안"
     "肉眼")
    ("육욕"
     "肉慾")
    ("육이구"
     "六二九")
    ("육이오"
     "六二五")
    ("육입"
     "六入")
    ("육자"
     "六字")
    ("육장"
     "六場")
    ("육전"
     "六典")
    ("육종"
     "育種")
    ("육중"
     "肉重")
    ("육지"
     "陸地")
    ("육지행선"
     "陸地行船")
    ("육진"
     "六鎭")
    ("육질"
     "肉質")
    ("육참"
     "陸參")
    ("육참총장"
     "陸參總長")
    ("육척지고"
     "六尺之孤")
    ("육천이백"
     "六千二百")
    ("육체"
     "肉體")
    ("육체노동"
     "肉體勞動")
    ("육체적"
     "肉體的")
    ("육체파"
     "肉體派")
    ("육촌"
     "六寸"
     "六村")
    ("육추"
     "育雛")
    ("육축"
     "六畜")
    ("육친"
     "肉親")
    ("육칠십"
     "六七十")
    ("육필"
     "肉筆")
    ("육하원칙"
     "六何原則")
    ("육해공"
     "陸海空")
    ("육해공군"
     "陸海空軍")
    ("육향"
     "肉香")
    ("육화"
     "肉化")
    ("육환장"
     "六環杖")
    ("윤"
     ("允" . "미쁠 윤, 마땅할 윤, 옳게 여길 윤, 좇을 윤, 허락할 윤")
     ("勻" . "가지런할 윤, 적을 윤")
     ("奫" . "물 깊을 윤, 물이 충충할 윤")
     ("尹" . "다스릴 윤, 바를 윤, 벼슬이름 윤, 믿을 윤")
     "潤"
     ("玧" . "귀막이 구슬 윤")
     "畇"
     ("胤" . "맏아들 윤, 익힐 윤")
     ("鈗" . "창 윤")
     "閏"
     ("倫" . "인륜 륜, 무리 륜, 조리 륜, 의리 륜, 가릴 륜")
     ("崙" . "곤륜산 륜, 나라이름 륜")
     ("淪" . "빠질 륜, 물놀이칠 륜, 거느릴 륜")
     ("輪" . "바퀴 륜, 땅 길이 륜, 우렁찰 륜, 서릴 륜, 둘레 륜")
     "昀"
     "鋆")
    ("윤간당"
     "輪姦當")
    ("윤곽"
     "輪廓")
    ("윤곽선"
     "輪廓線")
    ("윤기"
     "潤氣")
    ("윤년"
     "閏年")
    ("윤락"
     "淪落")
    ("윤리"
     "倫理")
    ("윤리관"
     "倫理觀")
    ("윤리적"
     "倫理的")
    ("윤리학"
     "倫理學")
    ("윤문윤무"
     "允文允武")
    ("윤색"
     "潤色")
    ("윤체천자"
     "輪遞天子")
    ("윤택"
     "潤澤")
    ("윤필지자"
     "潤筆之資")
    ("윤허"
     "允許")
    ("윤화"
     "輪禍")
    ("윤활유"
     "潤滑油")
    ("윤회"
     "輪廻")
    ("윤회설"
     "輪廻說")
    ("윤회적"
     "輪廻的")
    ("윤회전생"
     "輪廻轉生")
    ("율"
     ("聿" . "마침내 율, 지을 율, 오직 율, 스스로 율, 붓 율")
     ("律" . "법 률, 풍률 률, 지을 률, 저울질할 률")
     ("慄" . "두려울 률, 쭈그릴 률, 슬플 률, 떨 률")
     ("栗" . "밤 률, 신주 재목 률, 단단할 률, 무서울 률, 공손할 률")
     ("率" . "헤아릴 률, 과녁 률, 홀 한껏 다릴 률")
     ("潏" . "물 흐를 율")
     ("矞" . "송곳질할 율, 상서구름 율, 궤휼할 율, 귀신이름 율"))
    ("율동"
     "律動")
    ("율동감"
     "律動感")
    ("율동미"
     "律動美")
    ("율동적"
     "律動的")
    ("율령"
     "律令")
    ("율법"
     "律法")
    ("율사"
     "律師")
    ("융"
     ("戎" . "병장기 융, 싸움수레 융, 클 융, 너 융, 도울 융, 서쪽 오랑캐 융")
     ("瀜" . "물 깊을 륭")
     ("絨" . "삶은 실 융, 가는 베 융")
     ("融" . "부드러울 융, 밝을 융, 융통할 융, 불길 위로 오를 융, 귀신이름 융")
     ("隆" . "성할 륭, 높을 륭, 가운데 우뚝할 륭, 괘 이름 륭")
     ("狨" . "원숭이 융"))
    ("융동설한"
     "隆冬雪寒")
    ("융마생교"
     "戎馬生郊")
    ("융모"
     "絨毛")
    ("융성"
     "隆盛")
    ("융성기"
     "隆盛期")
    ("융숭"
     "隆崇")
    ("융용기"
     "融用機")
    ("융자"
     "融資")
    ("융자금"
     "融資金")
    ("융통"
     "融通")
    ("융통성"
     "融通性")
    ("융합"
     "融合")
    ("융화"
     "融和")
    ("은"
     ("圻" . "언덕 은")
     ("垠" . "언덕 은, 하늘 가장자리 은, 경계 은")
     ("恩" . "은혜 은, 신세 은, 사랑할 은")
     ("慇" . "은근할 은, 공손할 은, 간절할 은")
     ("殷" . "많을 은, 무리 은, 클 은, 가운데 은, 은나라 은, 융성할 은, 천둥소리 은")
     ("誾" . "화평할 은")
     ("銀" . "은 은, 돈 은")
     ("隱" . "숨을 은, 아낄 은, 속걱정할 은, 불쌍히 여길 은, 점칠 은, 의지할 은, 쌓을 은")
     ("听" . "벙긋거릴 은, 들을 은, 입이 큰 모양 은")
     ("嚚" . "어리석을 은, 말다툼할 은, 불칙하게 말할 은")
     ("圁" . "물이름 은")
     ("垽" . "해감 은, 찌끼 은")
     ("憖" . "물을 은, 공근할 은, 힘쓸 은, 서러워할 은")
     ("檼" . "집 마룻대 은, 대공 은")
     ("溵" . "물소리 은, 물이름 은")
     ("狺" . "뭇 개 짖는 소리 은")
     ("珢" . "옥돌 은")
     ("癮" . "두드러기 은")
     ("訔" . "시비할 은")
     ("鄞" . "땅이름 은")
     ("齗" . "잇몸 은, 말다툼할 은, 미워할 은")
     "齦")
    ("은감불원"
     "殷鑑不遠")
    ("은갑"
     "銀匣")
    ("은거"
     "隱居")
    ("은공"
     "恩功")
    ("은근"
     "慇懃")
    ("은기"
     "銀器")
    ("은닉"
     "隱匿")
    ("은덕"
     "恩德")
    ("은둔"
     "隱遁")
    ("은둔자"
     "隱遁者")
    ("은둔적"
     "隱遁的")
    ("은린옥척"
     "銀鱗玉尺")
    ("은막"
     "銀幕")
    ("은밀"
     "隱密")
    ("은박"
     "銀箔")
    ("은박지"
     "銀箔紙")
    ("은반"
     "銀盤")
    ("은반위구"
     "恩反爲仇")
    ("은발"
     "銀髮")
    ("은백색"
     "銀白色")
    ("은사"
     "恩師"
     "恩賜")
    ("은사권"
     "恩賜權")
    ("은산덕해"
     "恩山德海")
    ("은상"
     "銀賞")
    ("은성"
     "殷盛")
    ("은신"
     "隱身")
    ("은애"
     "恩愛")
    ("은어"
     "隱語")
    ("은연"
     "隱然")
    ("은연중"
     "隱然中")
    ("은유"
     "隱喩")
    ("은유적"
     "隱喩的")
    ("은은"
     "隱隱")
    ("은인"
     "恩人")
    ("은인자중"
     "隱忍自重")
    ("은자"
     "銀子"
     "隱者")
    ("은장도"
     "銀粧刀")
    ("은전"
     "恩典")
    ("은정월"
     "殷正月")
    ("은제"
     "銀製")
    ("은조사"
     "銀造紗")
    ("은중태산"
     "恩重泰山")
    ("은총"
     "恩寵")
    ("은퇴"
     "隱退")
    ("은퇴기"
     "隱退期")
    ("은폐"
     "隱蔽")
    ("은하"
     "銀河")
    ("은하계"
     "銀河系")
    ("은하단"
     "銀河團")
    ("은하수"
     "銀河水")
    ("은행"
     "銀杏"
     "銀行")
    ("은행가"
     "銀行家")
    ("은행권"
     "銀行圈")
    ("은행식"
     "銀行式")
    ("은행원"
     "銀行員")
    ("은행장"
     "銀行長")
    ("은혜"
     "恩惠")
    ("을"
     ("乙" . "새 을, 천간 이름 을, 굽힐 을, 생선의 창자 을, 모모 을")
     ("鳦" . "제비 을"))
    ("을미"
     "乙未")
    ("을미년"
     "乙未年")
    ("을사오적"
     "乙巳五賊")
    ("을유"
     "乙酉")
    ("을축"
     "乙丑")
    ("을축갑자"
     "乙丑甲子")
    ("을해"
     "乙亥")
    ("음"
     ("吟" . "읊을 음, 끙끙거릴 음, 탄식할 음, 턱 끄덕거릴 음, 노래할 음, 말 더듬을 음, 울 음")
     ("淫" . "방탕할 음, 간음할 음, 음란할 음, 넘칠 음, 적실 음, 오랠 음")
     ("蔭" . "덮을 음, 가릴 음, 그늘 음")
     ("陰" . "음기 음, 부인에게 예 가르칠 음, 몰래 음, 세월 음")
     ("音" . "소리 음, 편지 음, 음악 음")
     ("飮" . "마실 음")
     ("喑" . "소리지를 음, 안간힘 쓸 음, 목 쉴 음")
     ("崟" . "멧부리 음, 산 높을 음")
     ("廕" . "덮을 음")
     ("愔" . "조용할 음, 화평할 음")
     ("霪" . "장마 음"))
    ("음경"
     "陰莖")
    ("음경골"
     "陰莖骨")
    ("음기"
     "陰氣")
    ("음담"
     "淫談")
    ("음담패설"
     "淫談悖說")
    ("음대"
     "音大")
    ("음대생"
     "音大生")
    ("음덕양보"
     "陰德陽報")
    ("음란"
     "淫亂")
    ("음란물"
     "淫亂物")
    ("음란성"
     "淫亂性")
    ("음력"
     "陰曆")
    ("음료"
     "飮料")
    ("음료사"
     "飮料社")
    ("음료수"
     "飮料水")
    ("음료업"
     "飮料業")
    ("음료업체"
     "飮料業體")
    ("음료화"
     "飮料化")
    ("음률"
     "音律")
    ("음모"
     "陰毛"
     "陰謀")
    ("음모가"
     "陰謀家")
    ("음모극"
     "陰謀劇")
    ("음모죄"
     "陰謀罪")
    ("음미"
     "吟味")
    ("음반"
     "音盤")
    ("음복"
     "飮福")
    ("음산"
     "陰散")
    ("음색"
     "音色")
    ("음서제"
     "蔭敍制")
    ("음성"
     "陰性"
     "音聲")
    ("음성적"
     "陰性的")
    ("음성학적"
     "音聲學的")
    ("음소"
     "音素")
    ("음수"
     "陰數")
    ("음습"
     "陰濕")
    ("음식"
     "飮食")
    ("음식물"
     "飮食物")
    ("음식상"
     "飮食床")
    ("음식업"
     "飮食業")
    ("음식점"
     "飮食店")
    ("음악"
     "音樂")
    ("음악가"
     "音樂家")
    ("음악계"
     "音樂界")
    ("음악다방"
     "音樂茶房")
    ("음악당"
     "音樂堂")
    ("음악대"
     "音樂隊")
    ("음악도"
     "音樂徒")
    ("음악실"
     "音樂室")
    ("음악원"
     "音樂院")
    ("음악인"
     "音樂人")
    ("음악적"
     "音樂的")
    ("음악제"
     "音樂祭")
    ("음악회"
     "音樂會")
    ("음악회장"
     "音樂會場")
    ("음압"
     "音壓")
    ("음양"
     "陰陽")
    ("음양론"
     "陰陽論")
    ("음양오행"
     "陰陽五行")
    ("음양오행설"
     "陰陽五行說")
    ("음역"
     "音譯")
    ("음영"
     "陰影")
    ("음용"
     "飮用")
    ("음용량"
     "飮用量")
    ("음용률"
     "飮用率")
    ("음용수"
     "飮用水")
    ("음운"
     "音韻")
    ("음울"
     "陰鬱")
    ("음유"
     "吟遊")
    ("음유시인"
     "吟遊詩人")
    ("음전하"
     "陰電荷")
    ("음절"
     "音節")
    ("음정"
     "音程")
    ("음조"
     "音調")
    ("음주"
     "飮酒")
    ("음지"
     "陰地")
    ("음질"
     "音質")
    ("음침"
     "陰沈")
    ("음탕"
     "淫蕩")
    ("음파"
     "音波")
    ("음표"
     "音標")
    ("음풍농월"
     "吟風弄月")
    ("음하만복"
     "飮河滿腹")
    ("음해"
     "陰害")
    ("음행"
     "淫行")
    ("음행성"
     "淫行性")
    ("음향"
     "音響")
    ("음험"
     "陰險")
    ("음화"
     "音畵")
    ("음황"
     "淫荒")
    ("음흉"
     "陰凶")
    ("읍"
     ("揖" . "읍할 읍, 나아갈 읍, 깍지낄 읍, 공손할 읍")
     ("泣" . "눈물 줄줄 흘릴 읍, 부글부글 끓는 소리 읍")
     ("邑" . "고을 읍, 답답할 읍")
     ("悒" . "답답할 읍, 근심할 읍")
     ("挹" . "잡아당길 읍, 잔질할 읍")
     ("浥" . "젖을 읍, 흠치르르할 읍"))
    ("읍각부동"
     "邑各不同")
    ("읍견불폐"
     "邑犬群吠")
    ("읍내"
     "邑內")
    ("읍례"
     "揖禮")
    ("읍사"
     "邑司")
    ("읍성"
     "邑城")
    ("읍소"
     "泣訴")
    ("읍양지풍"
     "揖讓之風")
    ("읍제"
     "邑制")
    ("읍참마속"
     "泣斬馬謖")
    ("읍치"
     "邑治")
    ("응"
     ("凝" . "엉길 응, 이룰 응, 열중할 응")
     ("應" . "응당 응, 꼭 응, 사랑할 응, 대답할 응")
     ("膺" . "가슴 응, 친할 응, 당할 응, 응할 응, 받을 응")
     ("鷹" . "매 응"))
    ("응결"
     "凝結")
    ("응결처"
     "凝結處")
    ("응결체"
     "凝結體")
    ("응급"
     "應急")
    ("응급실"
     "應急室")
    ("응급조치"
     "應急措置")
    ("응낙"
     "應諾")
    ("응답"
     "應答")
    ("응답기"
     "應答器")
    ("응답률"
     "應答率")
    ("응답식"
     "應答式")
    ("응답자"
     "應答者")
    ("응당"
     "應當")
    ("응대"
     "應對")
    ("응모"
     "應募")
    ("응모자"
     "應募者")
    ("응분"
     "應分")
    ("응수"
     "應酬")
    ("응시"
     "凝視"
     "應試")
    ("응시교"
     "應試校")
    ("응시생"
     "應試生")
    ("응시자"
     "應試者")
    ("응용"
     "應用")
    ("응용과학"
     "應用科學")
    ("응용과학자"
     "應用科學者")
    ("응용력"
     "應用力")
    ("응용법"
     "應用法")
    ("응원"
     "應援")
    ("응원가"
     "應援歌")
    ("응원단"
     "應援團")
    ("응원단장"
     "應援團長")
    ("응원비"
     "應援費")
    ("응원상"
     "應援賞")
    ("응원석"
     "應援席")
    ("응원전"
     "應援戰")
    ("응전"
     "應戰")
    ("응전력"
     "應戰力")
    ("응접"
     "應接")
    ("응접무가"
     "應接無暇")
    ("응접실"
     "應接室")
    ("응집"
     "凝集")
    ("응집력"
     "凝集力")
    ("응징"
     "膺懲")
    ("응찰"
     "應札")
    ("응찰액"
     "應札額")
    ("응찰자"
     "應札者")
    ("응천순인"
     "應天順人")
    ("응축"
     "凝縮")
    ("응혈"
     "凝血")
    ("의"
     ("依" . "의지할 의, 기댈 의, 비슷할 의, 따를 의, 비유할 의, 병풍 의")
     ("倚" . "기댈 의, 의지할 의, 믿을 의")
     ("儀" . "꼴 의, 모양 의, 법도 의, 좋을 의")
     ("宜" . "옳을 의, 마땅할 의, 유순할 의")
     ("意" . "뜻 의, 생각 의, 의리 의, 형세 의")
     ("懿" . "아름다울 의, 클 의")
     ("擬" . "의논할 의, 헤아릴 의, 흡사할 의")
     ("椅" . "가래나무 의, 교의 의")
     ("毅" . "굳셀 의, 발끈 성낼 의")
     ("疑" . "의심할 의, 두려워할 의, 그럴듯할 의")
     ("矣" . "말 그칠 의")
     ("縊" . "목 맬 의")
     ("義" . "옳을 의, 의리 의, 뜻 의")
     ("艤" . "배 닿을 의")
     ("薏" . "연밥 의, 율무 의")
     ("蟻" . "왕개미 의, 검을 의, 술구더기 의")
     ("衣" . "옷 의, 입을 의")
     ("誼" . "옳을 의, 다스릴 의")
     ("議" . "말할 의, 의논할 의, 꾀할 의")
     ("醫" . "의원 의, 병 고칠 의")
     ("錡" . "세발 가마 의, 쇠뇌틀 의, 휘뚝거릴 의")
     ("儗" . "서로 못믿을 의, 참람할 의")
     ("凒" . "눈서리 쌓일 의")
     ("劓" . "코 베일 의, 베일 의")
     ("嶷" . "산이름 의")
     ("欹" . "아름답다할 의, 거룩하다할 의")
     ("漪" . "물놀이칠 의")
     ("猗" . "불 깐 개 의, 탄식할 의, 길 의")
     ("礒" . "바위 의")
     ("螘" . "목 매어 죽는 벌레 의")
     ("饐" . "밥 쉴 의"))
    ("의가반낭"
     "衣架飯囊")
    ("의가지락"
     "宜家之樂")
    ("의거"
     "依據"
     "義擧")
    ("의거일"
     "義擧日")
    ("의견"
     "意見")
    ("의견서"
     "意見書")
    ("의결"
     "議決")
    ("의결권"
     "議決權")
    ("의경"
     "義警")
    ("의고"
     "衣袴")
    ("의과"
     "醫科")
    ("의관"
     "衣冠")
    ("의관금수"
     "衣冠禽獸")
    ("의구심"
     "疑懼心")
    ("의금상경"
     "衣錦尙絅")
    ("의금야행"
     "衣錦夜行")
    ("의금주행"
     "衣錦晝行")
    ("의기"
     "意氣")
    ("의기소침"
     "意氣銷沈")
    ("의기양양"
     "意氣揚揚")
    ("의기투합"
     "意氣投合")
    ("의논"
     "議論")
    ("의논성"
     "議論性")
    ("의당"
     "宜當")
    ("의대"
     "衣帶"
     "醫大")
    ("의대생"
     "醫大生")
    ("의도"
     "意圖")
    ("의도적"
     "意圖的")
    ("의려지정"
     "倚閭之情")
    ("의례"
     "依例"
     "儀禮")
    ("의례복화"
     "儀禮服化")
    ("의례적"
     "儀禮的")
    ("의뢰"
     "依賴")
    ("의뢰인"
     "依賴人")
    ("의료"
     "衣料"
     "醫療")
    ("의료계"
     "醫療界")
    ("의료기"
     "醫療器")
    ("의료단"
     "醫療團")
    ("의료비"
     "醫療費")
    ("의료인"
     "醫療人")
    ("의료적"
     "醫療的")
    ("의료진"
     "醫療陣")
    ("의류"
     "衣類")
    ("의류업계"
     "衣類業界")
    ("의리"
     "義理")
    ("의마심원"
     "意馬心猿")
    ("의마지재"
     "倚馬之才")
    ("의무"
     "義務")
    ("의무감"
     "義務感")
    ("의무대"
     "醫務隊")
    ("의무병"
     "義務兵")
    ("의무실"
     "醫務室")
    ("의무자"
     "義務者")
    ("의무적"
     "義務的")
    ("의무화"
     "義務化")
    ("의문"
     "疑問")
    ("의문문"
     "疑問文")
    ("의문사"
     "疑問詞")
    ("의문시"
     "疑問視")
    ("의문점"
     "疑問點")
    ("의미"
     "意味")
    ("의미론적"
     "意味論的")
    ("의미심장"
     "意味深長")
    ("의미화"
     "意味化")
    ("의발"
     "衣鉢")
    ("의법"
     "依法")
    ("의병"
     "義兵")
    ("의병장"
     "義兵將")
    ("의보"
     "醫保")
    ("의복"
     "倚伏"
     "衣服")
    ("의부증"
     "疑夫症")
    ("의분"
     "義憤")
    ("의붓"
     "義父")
    ("의사"
     "意思"
     "擬似"
     "義士"
     "醫師")
    ("의사당"
     "議事堂")
    ("의사부도처"
     "意思不到處")
    ("의사소통"
     "意思疏通")
    ("의사율"
     "意思率")
    ("의상"
     "衣裳")
    ("의상실"
     "衣裳室")
    ("의상점"
     "衣裳店")
    ("의상화"
     "衣裳化")
    ("의생"
     "醫生")
    ("의생활"
     "衣生活")
    ("의석"
     "議席")
    ("의석수"
     "議席數")
    ("의수"
     "義手")
    ("의술"
     "醫術")
    ("의식"
     "儀式"
     "意識")
    ("의식적"
     "意識的")
    ("의식주"
     "衣食住")
    ("의식화"
     "意識化")
    ("의심"
     "疑心")
    ("의심암귀"
     "疑心暗鬼")
    ("의아"
     "疑訝")
    ("의아심"
     "疑訝心")
    ("의약"
     "醫藥")
    ("의약품"
     "醫藥品")
    ("의역"
     "意譯")
    ("의연"
     "毅然")
    ("의연금"
     "義捐金")
    ("의외"
     "意外")
    ("의외성"
     "意外性")
    ("의욕"
     "意欲")
    ("의욕적"
     "意欲的")
    ("의용군"
     "義勇軍")
    ("의원"
     "議員"
     "議院"
     "醫員"
     "醫院")
    ("의원직"
     "議員職")
    ("의원회"
     "議員會")
    ("의의"
     "意義"
     "疑意")
    ("의인"
     "義人")
    ("의인화"
     "擬人化")
    ("의자"
     "倚子"
     "椅子")
    ("의장"
     "意匠"
     "議長")
    ("의장국"
     "議長國")
    ("의장권"
     "意匠權")
    ("의장단"
     "議長團")
    ("의장직"
     "議長職")
    ("의재필선"
     "意在筆先")
    ("의적"
     "義賊")
    ("의전"
     "儀典")
    ("의전복"
     "儀典服")
    ("의정"
     "議政"
     "醫政")
    ("의정서"
     "議定書")
    ("의제"
     "議題")
    ("의제적"
     "擬制的")
    ("의존"
     "依存")
    ("의존도"
     "依存度")
    ("의존성"
     "依存性")
    ("의존심"
     "依存心")
    ("의존적"
     "依存的")
    ("의중"
     "意中")
    ("의지"
     "依支"
     "意志")
    ("의지적"
     "意志的")
    ("의처증"
     "疑妻症")
    ("의초부목"
     "依草附木")
    ("의치"
     "義齒")
    ("의탁"
     "依託")
    ("의표"
     "意表")
    ("의학"
     "醫學")
    ("의학계"
     "醫學界")
    ("의학과"
     "醫學科")
    ("의학부"
     "醫學部")
    ("의학적"
     "醫學的")
    ("의학진"
     "醫學陣")
    ("의학회"
     "醫學會")
    ("의향"
     "意向")
    ("의협심"
     "義俠心")
    ("의형의제"
     "宜兄宜弟")
    ("의혹"
     "疑惑")
    ("의혹설"
     "疑惑說")
    ("의회"
     "議會")
    ("이"
     ("二" . "두 이, 풍신 이, 같을 이, 의심할 이")
     ("以" . "써 이, 쓸 이, 까닭 이, 함께 이, 거느릴 이")
     ("伊" . "저 이, 이 이, 오직 이, 답답할 이, 성씨 이")
     ("夷" . "동쪽 오랑캐 이, 평평할 이, 기꺼울 이, 상할 이, 베풀 이, 괘 이름 이")
     ("姨" . "이모 이, 처이모 이")
     ("已" . "이미 이, 그칠 이, 버릴 이, 너무 이")
     ("弛" . "늦출 이, 활 부릴 이, 방탕할 이, 해이할 이")
     ("彛" . "彝의 俗字")
     ("怡" . "기쁠 이, 즐거울 이")
     ("爾" . "너 이, 가까울 이, 오직 이")
     ("珥" . "귀막이 옥 이, 귀고리 이, 해무리 이")
     ("異" . "다를 이, 괴이할 이, 나눌 이")
     ("痍" . "상할 이, 다칠 이, 흠집 이")
     ("移" . "옮길 이, 모낼 이, 변할 이")
     ("而" . "순접의 어조사 이, 너 이, 말이을 이, 이에 이")
     ("耳" . "귀 이, 조자리 이, 말 그칠 이, 여덟대 손자 이")
     ("肄" . "익힐 이, 수고할 이, 휘추리 이, 곁가지 이")
     ("苡" . "율무 이, 질경이 이")
     ("荑" . "흰 비름 이, 베일 이")
     ("貳" . "二의 갖은자, 버금 이, 의심낼 이, 마음 변할 이, 이별할 이")
     ("貽" . "끼칠 이, 줄 이")
     ("邇" . "가까울 이")
     ("飴" . "엿 이")
     ("餌" . "미끼 이, 이깝 이, 먹일 이, 흰떡 이")
     ("利" . "날카로울 리, 이로울 리, 탐할 리, 편리할 리, 이자 리")
     ("吏" . "아전 리, 관리 리")
     ("履" . "가죽신 리, 신을 리, 밟을 리")
     ("易" . "쉬울 이, 다스릴 이, 게으를 이, 편할 이")
     ("李" . "오얏 리, 선비 천거리할 리, 역말 리, 보따리 리")
     ("梨" . "배 리, 벌레이름 리")
     ("泥" . "진흙 니, 물이 더러워질 니, 흙손 니, 술취할 니, 이슬 맺힐 니")
     ("理" . "다스릴 리, 바를 리, 누늬낼 리, 성품 리, 이치 리, 고칠 리, 나무결 리")
     ("痢" . "이질 리, 곱똥 리, 설사 리")
     ("罹" . "만날 리, 근심할 리, 걸릴 리")
     ("裏" . "옷 안 리, 속 리")
     ("裡" . "裏의 俗字")
     ("里" . "마을 리, 근심할 리, 잇수 리")
     ("離" . "떠날 리, 베풀 리, 지날 리, 아름다울 리, 둘 리, 외손 리")
     ("咿" . "선웃음칠 이, 책 읽는 소리 이")
     ("尔" . "爾와 同字")
     ("彝" . "떳떳할 이, 법 이, 종묘 제기 이, 술통 이")
     ("栮" . "버섯 이, 느타리 이")
     ("洟" . "콧물 이, 눈물 이, 못이름 이")
     "珆"
     ("訑" . "자랑할 이")
     ("詑" . "자랑할 이")
     ("迤" . "든든할 이")
     ("隶" . "밑 이")
     ("鮧" . "창자젓 이"))
    ("이간"
     "離間")
    ("이견"
     "異見")
    ("이겸차안"
     "以鎌遮眼")
    ("이경"
     "二更"
     "二警")
    ("이고위감"
     "以古爲鑑")
    ("이공계"
     "理工系")
    ("이공대"
     "理工大")
    ("이공학"
     "理工學")
    ("이과"
     "理科")
    ("이과대"
     "理科大")
    ("이과생"
     "理科生")
    ("이관"
     "移管")
    ("이관규천"
     "以管窺天")
    ("이교도"
     "異敎徒")
    ("이구동성"
     "異口同聲")
    ("이국"
     "異國")
    ("이국인"
     "異國人")
    ("이국적"
     "異國的")
    ("이국정취"
     "異國情趣")
    ("이국종"
     "異國種")
    ("이국취미"
     "異國趣味")
    ("이궁"
     "離宮")
    ("이권"
     "利權")
    ("이권설"
     "利權說")
    ("이급"
     "二級")
    ("이기"
     "利器"
     "利己"
     "理氣")
    ("이기론"
     "二氣論")
    ("이기심"
     "利己心")
    ("이기적"
     "利己的")
    ("이기주의"
     "利己主義")
    ("이기주의자"
     "利己主義者")
    ("이기주의적"
     "利己主義的")
    ("이남"
     "以南")
    ("이내"
     "以內")
    ("이념"
     "理念")
    ("이념성"
     "理念性")
    ("이념적"
     "理念的")
    ("이념형"
     "理念型")
    ("이념화"
     "理念化")
    ("이농"
     "離農")
    ("이농민"
     "離農民")
    ("이농자"
     "離農者")
    ("이뇨제"
     "利尿劑")
    ("이단"
     "異端")
    ("이단자"
     "異端者")
    ("이덕보원"
     "以德報怨")
    ("이동"
     "異同"
     "移動")
    ("이동도서관"
     "移動圖書館")
    ("이동설"
     "移動說")
    ("이동식"
     "移動式")
    ("이동형"
     "移動型")
    ("이두"
     "吏讀")
    ("이두문"
     "吏讀文")
    ("이득"
     "利得")
    ("이득금"
     "利得金")
    ("이등"
     "二等")
    ("이등병"
     "二等兵")
    ("이등분"
     "二等分")
    ("이란격석"
     "以卵擊石")
    ("이래"
     "以來")
    ("이력"
     "履歷")
    ("이력서"
     "履歷書")
    ("이례적"
     "異例的")
    ("이로동귀"
     "異路同歸")
    ("이론"
     "異論"
     "理論")
    ("이론가"
     "理論家")
    ("이론과학자"
     "理論科學者")
    ("이론적"
     "理論的")
    ("이론화"
     "理論化")
    ("이롱"
     "耳聾")
    ("이루"
     "二壘")
    ("이루수"
     "二壘手")
    ("이루타"
     "二壘打")
    ("이류"
     "二流")
    ("이륙"
     "離陸")
    ("이륜차"
     "二輪車")
    ("이립지년"
     "而立之年")
    ("이만"
     "二萬")
    ("이만사천육백"
     "二萬四千六百")
    ("이만오천"
     "二萬五千")
    ("이만육천"
     "二萬六千")
    ("이만융적"
     "夷蠻戎狄")
    ("이면"
     "裏面")
    ("이모"
     "姨母")
    ("이모부"
     "姨母夫")
    ("이모상마"
     "以毛相馬")
    ("이모작"
     "二毛作")
    ("이목"
     "耳目")
    ("이목구비"
     "耳目口鼻")
    ("이목지신"
     "移木之信")
    ("이문"
     "利文")
    ("이문회우"
     "以文會友")
    ("이물"
     "異物")
    ("이물감"
     "異物感")
    ("이물질"
     "異物質")
    ("이민"
     "移民"
     "利民")
    ("이민위천"
     "以民爲天")
    ("이민족"
     "異民族")
    ("이반"
     "離叛")
    ("이발"
     "理髮")
    ("이발료"
     "理髮料")
    ("이발사"
     "理髮師")
    ("이발소"
     "理髮所")
    ("이발지시"
     "已發之矢")
    ("이방"
     "異邦")
    ("이방인"
     "異邦人")
    ("이백"
     "二百")
    ("이백만"
     "二百萬")
    ("이백몇"
     "二百몇")
    ("이백억"
     "二百億")
    ("이백오륙십만"
     "二百五六十萬")
    ("이백오십"
     "二百五十")
    ("이벌찬"
     "伊伐飡")
    ("이법계"
     "理法界")
    ("이변"
     "異變")
    ("이변비중"
     "離邊非中")
    ("이별"
     "離別")
    ("이병"
     "二兵")
    ("이복동생"
     "異腹同生")
    ("이복형제"
     "異腹兄弟")
    ("이부"
     "二部")
    ("이부제"
     "二部制")
    ("이북"
     "以北")
    ("이분법"
     "二分法")
    ("이분법적"
     "二分法的")
    ("이사"
     "二死"
     "理事"
     "移徙")
    ("이사관"
     "理事官")
    ("이사국"
     "理事國")
    ("이사금"
     "尼斯今")
    ("이사무애법계"
     "理事無碍法界")
    ("이사장"
     "理事長")
    ("이사장직"
     "理事長職")
    ("이사직"
     "理事職")
    ("이사회"
     "理事會")
    ("이산"
     "離散")
    ("이산가족"
     "離散家族")
    ("이산화질소"
     "二酸化窒素")
    ("이산화탄소"
     "二酸化炭素")
    ("이산화황"
     "二酸化黃")
    ("이삼"
     "二三")
    ("이삼십"
     "二三十")
    ("이삼천"
     "二三千")
    ("이삿"
     "移徙")
    ("이상"
     "以上"
     "理想"
     "異常")
    ("이상론"
     "理想論")
    ("이상상"
     "理想像")
    ("이상성"
     "理想性")
    ("이상자"
     "異常者")
    ("이상적"
     "理想的")
    ("이상주의"
     "理想主義")
    ("이상주의적"
     "理想主義的")
    ("이상증"
     "異常症")
    ("이상향"
     "理想鄕")
    ("이상형"
     "理想型")
    ("이상화"
     "理想化")
    ("이색"
     "異色")
    ("이색적"
     "異色的")
    ("이설"
     "異說")
    ("이성"
     "異性"
     "理性")
    ("이성애"
     "異性愛")
    ("이성적"
     "理性的")
    ("이성지합"
     "二姓之合")
    ("이세"
     "二世")
    ("이속"
     "移屬")
    ("이속층"
     "移屬層")
    ("이송"
     "移送")
    ("이수"
     "履修")
    ("이수자"
     "履修者")
    ("이순"
     "耳順")
    ("이순지년"
     "耳順之年")
    ("이시"
     "移是")
    ("이식"
     "移植"
     "利息")
    ("이실직고"
     "以實直告")
    ("이심"
     "二審")
    ("이심전심"
     "以心傳心")
    ("이심전심적"
     "以心傳心的")
    ("이십"
     "二十")
    ("이십구"
     "二十九")
    ("이십만"
     "二十萬")
    ("이십사"
     "二十四")
    ("이십사절기"
     "二十四節氣")
    ("이십오"
     "二十五")
    ("이십육"
     "二十六")
    ("이십이"
     "二十二")
    ("이십일"
     "二十一")
    ("이십칠"
     "二十七")
    ("이십팔"
     "二十八")
    ("이앙법"
     "移秧法")
    ("이양"
     "移讓")
    ("이양기"
     "移讓期")
    ("이양선"
     "異樣船")
    ("이역만리"
     "異域萬里")
    ("이열치열"
     "以熱治熱")
    ("이완"
     "弛緩")
    ("이완성"
     "弛緩性")
    ("이완제"
     "弛緩劑")
    ("이왕"
     "已往")
    ("이왕지사"
     "已往之事")
    ("이외"
     "以外")
    ("이용"
     "利用")
    ("이용객"
     "利用客")
    ("이용당"
     "利用當")
    ("이용도"
     "利用度")
    ("이용량"
     "利用量")
    ("이용료"
     "利用料")
    ("이용률"
     "利用率")
    ("이용법"
     "利用法")
    ("이용비"
     "利用費")
    ("이용성"
     "利用性")
    ("이용자"
     "利用者")
    ("이용자층"
     "利用者層")
    ("이용층"
     "利用層")
    ("이용후생"
     "利用厚生")
    ("이원"
     "二元"
     "二院")
    ("이원론"
     "二元論")
    ("이원론적"
     "二元論的")
    ("이원작소"
     "理院鵲巢")
    ("이원적"
     "二元的")
    ("이원화"
     "二元化")
    ("이월"
     "二月"
     "移越")
    ("이유"
     "理由"
     "離乳")
    ("이유서"
     "理由書")
    ("이유식"
     "離乳食")
    ("이윤"
     "利潤")
    ("이율"
     "利率")
    ("이율배반"
     "二律背反")
    ("이율배반성"
     "二律背反性")
    ("이율배반적"
     "二律背反的")
    ("이의"
     "異意"
     "異議")
    ("이이제이"
     "以夷制夷")
    ("이익"
     "利益")
    ("이익금"
     "利益金")
    ("이인위감"
     "以人爲鑑")
    ("이일경백"
     "以一警百")
    ("이임"
     "離任")
    ("이임식"
     "移任式")
    ("이입"
     "移入")
    ("이자"
     "利子")
    ("이자세"
     "利子稅")
    ("이자율"
     "利子率")
    ("이장"
     "移葬"
     "里長")
    ("이재국"
     "理財局")
    ("이재민"
     "罹災民")
    ("이적"
     "利敵"
     "異跡"
     "移籍")
    ("이적료"
     "移籍料")
    ("이적성"
     "利敵性")
    ("이전"
     "以前"
     "移轉")
    ("이전투구"
     "泥田鬪狗")
    ("이점"
     "利點")
    ("이정표"
     "里程標")
    ("이제"
     "里制")
    ("이조"
     "李朝")
    ("이족"
     "異族")
    ("이종"
     "姨從")
    ("이주"
     "移住"
     "耳柱")
    ("이주민"
     "移住民")
    ("이주비"
     "移住費")
    ("이중"
     "二重")
    ("이중고"
     "二重苦")
    ("이중성"
     "二重性")
    ("이중적"
     "二重的")
    ("이중주"
     "二重奏")
    ("이중창"
     "二重唱")
    ("이지적"
     "理智的")
    ("이지측해"
     "以指測海")
    ("이직"
     "移職")
    ("이직률"
     "移職率")
    ("이직자"
     "移職者")
    ("이진"
     "二進"
     "二陣")
    ("이진수"
     "二進數")
    ("이질"
     "異質"
     "痢疾")
    ("이질감"
     "異質感")
    ("이질성"
     "異質性")
    ("이질적"
     "異質的")
    ("이질화"
     "異質化")
    ("이차"
     "二次")
    ("이차원"
     "二次元")
    ("이차적"
     "二次的")
    ("이착륙"
     "離着陸")
    ("이찬"
     "伊飡")
    ("이채"
     "異彩")
    ("이천"
     "二千")
    ("이천만"
     "二千萬")
    ("이천역일"
     "移天易日")
    ("이천오백"
     "二千五百")
    ("이첩"
     "移牒")
    ("이체"
     "異體"
     "移替")
    ("이층"
     "二層")
    ("이치"
     "理致")
    ("이타적"
     "利他的")
    ("이탈"
     "離脫")
    ("이탈물"
     "離脫物")
    ("이탕지비"
     "以湯止沸")
    ("이팔"
     "二八")
    ("이팔청춘"
     "二八靑春")
    ("이하"
     "以下")
    ("이하부정관"
     "李下不整冠")
    ("이하선"
     "耳下腺")
    ("이합"
     "離合")
    ("이합집산"
     "離合集散")
    ("이해"
     "利害"
     "理解")
    ("이해관계"
     "利害關係")
    ("이해득실"
     "利害得失"
     "利害得失")
    ("이해력"
     "理解力")
    ("이해심"
     "理解心")
    ("이해타산"
     "利害打算")
    ("이행"
     "移行"
     "履行")
    ("이행기"
     "移行期")
    ("이행론"
     "移行論")
    ("이행설"
     "移行說")
    ("이현령비현령"
     "耳懸鈴鼻懸鈴")
    ("이혈세혈"
     "以血洗血")
    ("이혼"
     "離婚")
    ("이혼남"
     "離婚男")
    ("이혼자"
     "離婚者")
    ("이화"
     "理化")
    ("이화감"
     "異化感")
    ("이황화탄소"
     "二黃化炭素")
    ("이후"
     "以後")
    ("익"
     ("瀷" . "강이름 익")
     ("益" . "더할 익")
     ("翊" . "도울 익")
     ("翌" . "다음날 익")
     ("翼" . "날개 익")
     ("謚" . "웃을 익")
     ("匿" . "숨을 닉, 숨길 닉, 덮어둘 닉, 몰래 붙을 닉, 쌀 닉, 술 담는 그릇 닉")
     ("溺" . "빠질 닉, 약할 닉, 헤어 나오지 못할 닉")
     ("弋" . "주살 익, 취할 익, 홰 익, 검을 익, 벼슬이름 익, 오랑캐 익")
     ("熤" . "빛날 익, 사람이름 익")
     ("鷁" . "익새 익, 돛대 끝 바람개비 익"))
    ("익명"
     "匿名")
    ("익명성"
     "匿名性")
    ("익명인"
     "匿名人")
    ("익명적"
     "匿名的")
    ("익모초"
     "益母草")
    ("익사"
     "溺死")
    ("익사자"
     "溺死者")
    ("익사체"
     "溺死體")
    ("익선관"
     "翼善冠")
    ("익일"
     "翌日")
    ("익자삼요"
     "益者三樂")
    ("익자삼우"
     "益者三友")
    ("익적소성"
     "匿跡消聲")
    ("인"
     ("人" . "사람 인")
     ("仁" . "어질 인")
     ("刃" . "칼날 인")
     ("印" . "도장 인")
     ("咽" . "목구멍 인")
     ("因" . "인할 인")
     ("姻" . "혼인 인")
     ("寅" . "세째지지 인")
     ("引" . "끌 인")
     ("忍" . "참을 인")
     ("湮" . "잠길 인")
     ("絪" . "기운 인")
     ("茵" . "자리 인")
     ("蚓" . "지렁이 인")
     ("認" . "알 인")
     ("靭" . "韌과 同字")
     ("靷" . "가슴걸이 인")
     ("吝" . "아낄 인")
     ("燐" . "도깨비불 인")
     ("璘" . "옥빛 인")
     ("藺" . "골풀 인")
     ("隣" . "鄰의 俗字")
     ("鱗" . "비늘 인")
     ("麟" . "기린 인")
     ("仞" . "길 인")
     ("堙" . "막을 인")
     ("夤" . "조심할 인")
     ("婣" . "姻과 同字")
     ("扨" . "그러하나 인")
     ("氤" . "기운성할 인")
     ("洇" . "湮과 同字")
     ("禋" . "제사지낼 인")
     ("籾" . "벼 인")
     ("芢" . "씨 인")
     ("裀" . "요 인"))
    ("인가"
     "人家"
     "認可")
    ("인간"
     "人間")
    ("인간관"
     "人間觀")
    ("인간관계"
     "人間關係")
    ("인간군"
     "人間群")
    ("인간문화재"
     "人間文化財")
    ("인간미"
     "人間味")
    ("인간사"
     "人間事")
    ("인간상"
     "人間像")
    ("인간성"
     "人間性")
    ("인간애"
     "人間愛")
    ("인간적"
     "人間的")
    ("인간주의"
     "人間主義")
    ("인간학적"
     "人間學的")
    ("인간형"
     "人間型")
    ("인간화"
     "人間化")
    ("인감"
     "印鑑")
    ("인건비"
     "人件費")
    ("인격"
     "人格")
    ("인격권"
     "人格權")
    ("인격신"
     "人格神")
    ("인격자"
     "人格者")
    ("인격적"
     "人格的")
    ("인격체"
     "人格體")
    ("인격화"
     "人格化")
    ("인견"
     "人絹")
    ("인계"
     "引繼")
    ("인고"
     "忍苦")
    ("인공"
     "人共"
     "人工")
    ("인공물"
     "人工物")
    ("인공미"
     "人工美")
    ("인공위성"
     "人工衛星")
    ("인공적"
     "人工的")
    ("인공조명"
     "人工照明")
    ("인공호흡"
     "人工呼吸")
    ("인공호흡법"
     "人工呼吸法")
    ("인공화"
     "人工化")
    ("인과"
     "因果")
    ("인과론적"
     "因果論的")
    ("인과성"
     "因果性")
    ("인과율"
     "因果律")
    ("인과응보"
     "因果應報")
    ("인과적"
     "因果的")
    ("인광"
     "燐光")
    ("인구"
     "人口")
    ("인구수"
     "人口數")
    ("인구어"
     "印歐語")
    ("인구율"
     "人口率")
    ("인권"
     "人權")
    ("인귀상반"
     "人鬼相半")
    ("인근"
     "隣近")
    ("인급가족"
     "人給家足")
    ("인기"
     "人氣")
    ("인기곡"
     "人氣曲")
    ("인기도"
     "人氣度")
    ("인기리"
     "人氣裡")
    ("인기세"
     "人氣稅")
    ("인기인"
     "人氣人")
    ("인내"
     "忍耐")
    ("인내력"
     "忍耐力")
    ("인내성"
     "忍耐性")
    ("인내심"
     "忍耐心")
    ("인내천"
     "人乃天")
    ("인대"
     "靭帶")
    ("인덕력"
     "麟德曆")
    ("인도"
     "人道"
     "引導"
     "引渡")
    ("인도교"
     "人道橋")
    ("인도자"
     "引導者")
    ("인도주의"
     "人道主義")
    ("인도주의적"
     "人道主義的")
    ("인력"
     "人力"
     "引力")
    ("인력거"
     "人力車")
    ("인력난"
     "人力難")
    ("인력층"
     "人力層")
    ("인류"
     "人類")
    ("인류사"
     "人類史")
    ("인류애"
     "人類愛")
    ("인류학"
     "人類學")
    ("인류학계"
     "人類學界")
    ("인류학과"
     "人類學科")
    ("인류학자"
     "人類學者")
    ("인류학적"
     "人類學的")
    ("인륜"
     "人倫")
    ("인륜대사"
     "人倫大事")
    ("인맥"
     "人脈")
    ("인면수심"
     "人面獸心")
    ("인멸"
     "湮滅")
    ("인명"
     "人名"
     "人命")
    ("인명사전"
     "人名事典")
    ("인명재천"
     "人命在天")
    ("인문"
     "人文")
    ("인문계"
     "人文系")
    ("인문대"
     "人文大")
    ("인문서"
     "人文書")
    ("인문적"
     "人文的")
    ("인문주의"
     "人文主義")
    ("인문주의자"
     "人文主義者")
    ("인문주의적"
     "人文主義的")
    ("인문학적"
     "人文學的")
    ("인물"
     "人物")
    ("인물론"
     "人物論")
    ("인물상"
     "人物像")
    ("인물학"
     "人物學")
    ("인물형"
     "人物型")
    ("인물화"
     "人物畵")
    ("인민"
     "人民")
    ("인민군"
     "人民軍")
    ("인민군복"
     "人民軍服")
    ("인민배우"
     "人民俳優")
    ("인민적"
     "人民的")
    ("인민학교"
     "人民學校")
    ("인복"
     "人福")
    ("인본적"
     "人本的")
    ("인본주의적"
     "人本主義的")
    ("인봉"
     "麟鳳")
    ("인부"
     "人夫")
    ("인분"
     "人糞")
    ("인사"
     "人事"
     "人士")
    ("인사계"
     "人事係")
    ("인사과"
     "人事課")
    ("인사법"
     "人事法")
    ("인사부"
     "人事部")
    ("인사부장"
     "人事部長")
    ("인사불성"
     "人事不省"
     "人事不省")
    ("인사성"
     "人事性")
    ("인사안"
     "人事案")
    ("인사유명"
     "人死留名")
    ("인사이동설"
     "人事移動說")
    ("인산"
     "引産"
     "燐酸")
    ("인산인해"
     "人山人海")
    ("인삼"
     "人蔘")
    ("인삼차"
     "人蔘茶")
    ("인상"
     "人相"
     "印象"
     "引上")
    ("인상각우"
     "引商刻羽")
    ("인상률"
     "引上率")
    ("인상분"
     "引上分")
    ("인상안"
     "引上案")
    ("인상적"
     "印象的")
    ("인상착의"
     "人相着衣")
    ("인상파"
     "印象派")
    ("인색"
     "吝嗇")
    ("인생"
     "人生")
    ("인생관"
     "人生觀")
    ("인생담"
     "人生談")
    ("인생무상"
     "人生無常")
    ("인생사"
     "人生史")
    ("인생철학"
     "人生哲學")
    ("인생초로"
     "人生草露")
    ("인선"
     "人選")
    ("인성"
     "人性")
    ("인세"
     "人世"
     "印稅")
    ("인솔"
     "引率")
    ("인쇄"
     "印刷")
    ("인쇄물"
     "印刷物")
    ("인쇄소"
     "印刷所")
    ("인쇄술"
     "印刷術")
    ("인쇄업자"
     "印刷業者")
    ("인수"
     "引受")
    ("인수권부"
     "引受權部")
    ("인수인계"
     "引受引繼")
    ("인순고식"
     "因循姑息")
    ("인술"
     "仁術")
    ("인습"
     "因習")
    ("인습적"
     "因襲的")
    ("인식"
     "認識")
    ("인식기"
     "認識期")
    ("인식도"
     "認識度")
    ("인식론적"
     "認識論的")
    ("인식률"
     "認識率")
    ("인식자"
     "認識者")
    ("인식적"
     "認識的")
    ("인식표"
     "認識票")
    ("인신"
     "人身")
    ("인신공격"
     "人身攻擊")
    ("인신매매"
     "人身賣買")
    ("인신매매단"
     "人身賣買團")
    ("인신매매범"
     "人身賣買犯")
    ("인심"
     "人心")
    ("인심여면"
     "人心如面")
    ("인양기"
     "引揚機")
    ("인어"
     "人魚")
    ("인언이박"
     "仁言利博")
    ("인연"
     "因緣")
    ("인연위시"
     "因緣爲市")
    ("인욕"
     "忍辱")
    ("인용"
     "引用"
     "認容")
    ("인용자"
     "引用者")
    ("인원"
     "人員")
    ("인원수"
     "人員數")
    ("인위적"
     "人爲的")
    ("인육"
     "人肉")
    ("인의예지"
     "仁義禮智")
    ("인의예지신"
     "仁義禮智信")
    ("인이불발"
     "引而不發")
    ("인입선"
     "引入線")
    ("인자"
     "仁慈"
     "因子")
    ("인자무적"
     "仁者無敵")
    ("인자불우"
     "仁者不憂")
    ("인자안인"
     "仁者安仁")
    ("인자요산"
     "仁者樂山")
    ("인장의속"
     "仁漿義粟")
    ("인재"
     "人材"
     "人災")
    ("인적"
     "人的"
     "人跡")
    ("인접"
     "隣接")
    ("인정"
     "人丁"
     "人情"
     "認定")
    ("인정미"
     "人情美")
    ("인정사정"
     "人情事情")
    ("인정승천"
     "人定勝天")
    ("인정자"
     "認定者")
    ("인조"
     "人造")
    ("인조물"
     "人造物")
    ("인조반정"
     "仁祖反正")
    ("인종"
     "人種")
    ("인종적"
     "人種的")
    ("인종주의자"
     "人種主義者")
    ("인주"
     "印朱")
    ("인준"
     "認准")
    ("인중"
     "人中")
    ("인중승천"
     "人衆勝天")
    ("인증"
     "認證")
    ("인지"
     "人指"
     "人智"
     "認知")
    ("인지도"
     "認知度")
    ("인지상정"
     "人之常情")
    ("인지세"
     "印紙稅")
    ("인지위덕"
     "忍之爲德")
    ("인지율"
     "認知率")
    ("인지적"
     "認知的")
    ("인질"
     "人質")
    ("인책"
     "引責")
    ("인책적"
     "引責的")
    ("인척"
     "姻戚")
    ("인천"
     "仁川")
    ("인천공항"
     "仁川空港")
    ("인체"
     "人體")
    ("인출"
     "引出")
    ("인출기"
     "引出機")
    ("인치"
     "人治"
     "引致")
    ("인파"
     "人波")
    ("인편"
     "人便")
    ("인품"
     "人品")
    ("인피"
     "靭皮")
    ("인하"
     "引下")
    ("인해전술"
     "人海戰術")
    ("인형"
     "人形")
    ("인형극"
     "人形劇")
    ("인화"
     "人化"
     "人和"
     "印畵"
     "引火")
    ("인화물"
     "引火物")
    ("인화성"
     "引火性")
    ("인화지"
     "印畵紙")
    ("인환"
     "引換")
    ("인후지지"
     "咽喉之地")
    ("일"
     ("一" . "한 일")
     ("佚" . "편안할 일")
     ("佾" . "춤 일")
     ("壹" . "한 일")
     ("日" . "날 일")
     ("溢" . "넘칠 일")
     ("逸" . "달아날 일")
     ("鎰" . "중량 일")
     ("馹" . "역말 일")
     ("泆" . "끊을 일")
     ("軼" . "앞지를 일"))
    ("일가"
     "一家")
    ("일가견"
     "一家見")
    ("일가월증"
     "日加月增")
    ("일가족"
     "一家族")
    ("일가친척"
     "一家親戚")
    ("일각"
     "一刻"
     "一角")
    ("일각여삼추"
     "一刻如三秋")
    ("일각일각"
     "一刻一刻")
    ("일간"
     "日刊"
     "日間")
    ("일간지"
     "日刊紙")
    ("일갈"
     "一喝")
    ("일개"
     "一介")
    ("일거"
     "一擧")
    ("일거수일투족"
     "一擧手一投足")
    ("일거양득"
     "一擧兩得")
    ("일거일동"
     "一擧一動")
    ("일격"
     "一擊")
    ("일견"
     "一見")
    ("일견식"
     "一見識")
    ("일경"
     "一警"
     "日警")
    ("일고경성"
     "一顧傾城")
    ("일고작기"
     "一鼓作氣")
    ("일과"
     "日課")
    ("일과성"
     "一過性")
    ("일과표"
     "日課表")
    ("일관"
     "一貫")
    ("일관성"
     "一貫性")
    ("일괄"
     "一括")
    ("일괄적"
     "一括的")
    ("일광"
     "日光")
    ("일광욕"
     "日光浴")
    ("일교차"
     "日較差")
    ("일구월심"
     "日久月深")
    ("일구이언"
     "一口二言")
    ("일국"
     "一國")
    ("일급"
     "一級")
    ("일기"
     "一期"
     "日氣"
     "日記")
    ("일기당천"
     "一騎當千")
    ("일기장"
     "日記帳")
    ("일기책"
     "日記冊")
    ("일년생"
     "一年生")
    ("일념"
     "一念")
    ("일념삼천"
     "一念三千")
    ("일단"
     "一團"
     "一旦"
     "一段"
     "一端")
    ("일단락"
     "一段落")
    ("일단정지"
     "一旦停止")
    ("일당"
     "一黨"
     "日當")
    ("일당제"
     "一黨制")
    ("일대"
     "一代"
     "一大"
     "一帶")
    ("일대기"
     "一代記")
    ("일대일"
     "一對一")
    ("일도양단"
     "一刀兩斷")
    ("일도양단식"
     "一刀兩斷式")
    ("일동"
     "一同")
    ("일등"
     "一等")
    ("일등병"
     "一等兵")
    ("일등품"
     "一等品")
    ("일란성"
     "一卵性")
    ("일람표"
     "一覽表")
    ("일래"
     "日來")
    ("일력"
     "日曆")
    ("일련"
     "一連")
    ("일련번호"
     "一連番號")
    ("일렬"
     "一列")
    ("일렬횡대"
     "一列橫隊")
    ("일례"
     "一例")
    ("일로"
     "一路")
    ("일룡일사"
     "一龍一蛇")
    ("일루수"
     "一壘手")
    ("일류"
     "一流")
    ("일률"
     "一律")
    ("일률적"
     "一律的")
    ("일리"
     "一理")
    ("일만"
     "一萬")
    ("일만이천"
     "一萬二千")
    ("일말"
     "一抹")
    ("일망무제"
     "一望無際")
    ("일망타진"
     "一網打盡")
    ("일맥"
     "一脈")
    ("일맥상통"
     "一脈相通")
    ("일면"
     "一面")
    ("일면적"
     "一面的")
    ("일명"
     "一名")
    ("일모"
     "一毛")
    ("일모도궁"
     "日暮途窮")
    ("일모불발"
     "一毛不拔")
    ("일목난지"
     "一木難支")
    ("일목십행"
     "一目十行")
    ("일목요연"
     "一目瞭然")
    ("일몰"
     "日沒")
    ("일무"
     "佾舞")
    ("일문"
     "一門")
    ("일문과"
     "日文科")
    ("일문일답"
     "一問一答")
    ("일문일답식"
     "一問一答式")
    ("일문학과"
     "日文學科")
    ("일반"
     "一般")
    ("일반도"
     "一般圖")
    ("일반론"
     "一般論")
    ("일반론적"
     "一般論的")
    ("일반법"
     "一般法")
    ("일반부"
     "一般部")
    ("일반인"
     "一般人")
    ("일반적"
     "一般的")
    ("일반지덕"
     "一飯之德")
    ("일반직"
     "一般職")
    ("일반화"
     "一般化")
    ("일발"
     "一發")
    ("일방"
     "一方")
    ("일방성"
     "一方性")
    ("일방적"
     "一方的")
    ("일백"
     "一百")
    ("일백만"
     "一百萬")
    ("일백오십"
     "一百五十")
    ("일백오십만"
     "一百五十萬")
    ("일벌백계"
     "一罰百戒")
    ("일변"
     "一變"
     "一邊")
    ("일변도"
     "一邊倒")
    ("일별"
     "一瞥")
    ("일병"
     "一兵")
    ("일보"
     "一步")
    ("일본"
     "日本")
    ("일본명"
     "日本名")
    ("일본식"
     "日本式")
    ("일본어"
     "日本語")
    ("일본제"
     "日本製")
    ("일본화"
     "日本化")
    ("일부"
     "一部")
    ("일부분"
     "一部分")
    ("일부일처제"
     "一夫一妻制")
    ("일사"
     "一四")
    ("일사병"
     "日射病")
    ("일사부재리"
     "一事不再理")
    ("일사불란"
     "一絲不亂"
     "一絲不亂")
    ("일사천리"
     "一瀉千里")
    ("일산화이질소"
     "一酸化二窒素")
    ("일산화탄소"
     "一酸化炭素")
    ("일상"
     "日常")
    ("일상다반사"
     "日常茶飯事")
    ("일상복"
     "日常服")
    ("일상사"
     "日常事")
    ("일상생활"
     "日常生活")
    ("일상생활적"
     "日常生活的")
    ("일상성"
     "日常性")
    ("일상어"
     "日常語")
    ("일상용어"
     "日常用語")
    ("일상적"
     "日常的")
    ("일상화"
     "日常化")
    ("일색"
     "一色")
    ("일생"
     "一生"
     "日生")
    ("일생일대"
     "一生一代")
    ("일석이조"
     "一石二鳥")
    ("일석점호"
     "日夕點呼")
    ("일선"
     "一線")
    ("일설"
     "一說")
    ("일소"
     "一掃")
    ("일속"
     "一粟")
    ("일수"
     "日收"
     "日數")
    ("일숙직"
     "日宿直")
    ("일순"
     "一瞬")
    ("일순간"
     "一瞬間")
    ("일시"
     "一時"
     "日時")
    ("일시적"
     "一時的")
    ("일식"
     "日食")
    ("일신"
     "一新"
     "一身")
    ("일신교"
     "一神敎")
    ("일신상"
     "一身上")
    ("일신우일신"
     "日新又日新")
    ("일실"
     "一室")
    ("일심"
     "一審"
     "一心")
    ("일심동체"
     "一心同體")
    ("일약"
     "一躍")
    ("일어"
     "日語")
    ("일어탁수"
     "一魚濁水")
    ("일어판"
     "日語版")
    ("일언거사"
     "一言居士")
    ("일언반구"
     "一言半句")
    ("일언이폐지"
     "一言以蔽之")
    ("일언지하"
     "一言之下")
    ("일엽지추"
     "一葉知秋")
    ("일엽편주"
     "一葉片舟")
    ("일요"
     "日曜")
    ("일요일"
     "日曜日")
    ("일용"
     "日傭"
     "日用")
    ("일용직"
     "日用職")
    ("일용품"
     "日用品")
    ("일원"
     "一元"
     "一員"
     "一圓")
    ("일원론"
     "一元論")
    ("일원론적"
     "一元論的")
    ("일원적"
     "一元的")
    ("일원화"
     "一元化")
    ("일월"
     "一月")
    ("일월성신"
     "日月星辰")
    ("일이"
     "一二")
    ("일이관지"
     "一以貫之")
    ("일이천"
     "一二千")
    ("일익"
     "一翼")
    ("일인"
     "一人"
     "一因")
    ("일인극"
     "一人劇")
    ("일인자"
     "一人者")
    ("일일"
     "一一"
     "一日"
     "日日")
    ("일일삼추"
     "一日三秋")
    ("일일생활권"
     "一日生活圈")
    ("일일일선"
     "一日一善")
    ("일임"
     "一任")
    ("일자"
     "一字"
     "一者"
     "日子")
    ("일자무식"
     "一字無識")
    ("일자천금"
     "一字千金")
    ("일자형"
     "一字形")
    ("일장"
     "一場")
    ("일장기"
     "日章旗")
    ("일장일단"
     "一長一短")
    ("일장춘몽"
     "一場春夢")
    ("일전"
     "一戰"
     "日前")
    ("일전쌍조"
     "一箭雙雕")
    ("일절"
     "一切")
    ("일정"
     "一定"
     "日程")
    ("일정량"
     "一定量")
    ("일정액"
     "一定額")
    ("일정표"
     "日程表")
    ("일제"
     "一齊"
     "日帝"
     "日製")
    ("일조"
     "一兆"
     "一助"
     "日照")
    ("일조권"
     "日照權")
    ("일조량"
     "日照量")
    ("일조점호"
     "日朝點呼")
    ("일족"
     "一族")
    ("일종"
     "一種")
    ("일주"
     "一周")
    ("일주일"
     "一週日")
    ("일지"
     "日誌")
    ("일직"
     "日直")
    ("일직선"
     "一直線")
    ("일진"
     "一陣"
     "日辰")
    ("일진불염"
     "一塵不染")
    ("일진일퇴"
     "一進一退")
    ("일차"
     "一次")
    ("일차원적"
     "一次元的")
    ("일차적"
     "一次的")
    ("일착"
     "一着")
    ("일천"
     "一千"
     "日淺")
    ("일천구백칠십"
     "一千九百七十")
    ("일천구백팔십"
     "一千九百八十")
    ("일체"
     "一體"
     "一切")
    ("일체감"
     "一體感")
    ("일체성"
     "一體性")
    ("일체유심조"
     "一切唯心造")
    ("일체적"
     "一體的")
    ("일체주의"
     "一體主義")
    ("일체화"
     "一體化")
    ("일촉즉발"
     "一觸卽發")
    ("일촌"
     "一村")
    ("일촌광음"
     "一寸光陰")
    ("일축"
     "一蹴")
    ("일출"
     "日出")
    ("일취월장"
     "日就月將")
    ("일취지몽"
     "一炊之夢")
    ("일치"
     "一致")
    ("일치단결"
     "一致團結")
    ("일치론"
     "一致論")
    ("일침"
     "一鍼")
    ("일탈"
     "逸脫")
    ("일탈자"
     "逸脫者")
    ("일통"
     "一統")
    ("일파"
     "一派")
    ("일파만파"
     "一波萬波")
    ("일패도지"
     "一敗塗地")
    ("일편단심"
     "一片丹心")
    ("일평생"
     "一平生")
    ("일품"
     "一品")
    ("일품요리"
     "一品料理")
    ("일필휘지"
     "一筆揮之")
    ("일행"
     "一行")
    ("일호반점"
     "一毫半點")
    ("일화"
     "逸話")
    ("일확천금"
     "一攫千金"
     "一攫千金")
    ("일환"
     "一環")
    ("일회성"
     "一回性")
    ("일회용"
     "一回用")
    ("일회용품"
     "一回用品")
    ("일회적"
     "一回的")
    ("일희일비"
     "一喜一悲")
    ("임"
     ("任" . "맡길 임")
     ("壬" . "아홉째천간 임")
     ("妊" . "아이밸 임")
     ("姙" . "妊과 同字")
     ("恁" . "생각할 임")
     ("稔" . "곡식익을 임")
     ("荏" . "들깨 임")
     ("賃" . "품팔이 임")
     ("林" . "수풀 림, 더북더북 날 림")
     ("淋" . "지적지적할 림, 축일 림, 번지르르할 림")
     ("臨" . "임할 림, 군림할 림, 여럿이 울 림, 굽힐 림")
     ("絍" . "짤 임, 길쌈할 임")
     ("衽" . "옷깃 임")
     ("銋" . "젖을 임")
     ("飪" . "익힐 임"))
    ("임간"
     "林間")
    ("임갈굴정"
     "臨渴掘井")
    ("임검소"
     "臨檢所")
    ("임관식"
     "任官式")
    ("임괘"
     "臨卦")
    ("임금"
     "賃金")
    ("임금제"
     "賃金制")
    ("임기"
     "任期")
    ("임기응변"
     "臨機應變"
     "臨機應變")
    ("임기제"
     "任期制")
    ("임내"
     "任內")
    ("임노동"
     "賃勞動")
    ("임농탈경"
     "臨農奪耕")
    ("임대"
     "賃貸")
    ("임대료"
     "賃貸料")
    ("임대비"
     "賃貸費")
    ("임대율"
     "賃貸率")
    ("임대차"
     "賃貸借")
    ("임란"
     "壬亂")
    ("임립"
     "林立")
    ("임면"
     "任免")
    ("임명"
     "任命")
    ("임명권자"
     "任命權者")
    ("임명장"
     "任命狀")
    ("임명직"
     "任命職")
    ("임목"
     "林木")
    ("임무"
     "任務")
    ("임박"
     "臨迫")
    ("임부"
     "妊婦")
    ("임부복"
     "妊婦服")
    ("임사"
     "臨死")
    ("임산"
     "妊産"
     "林産")
    ("임산부"
     "妊産婦")
    ("임산부복"
     "姙産婦服")
    ("임상"
     "臨床")
    ("임석"
     "臨席")
    ("임수"
     "臨水")
    ("임시"
     "臨時")
    ("임시방편"
     "臨時方便")
    ("임시변통"
     "臨時變通")
    ("임시적"
     "臨時的")
    ("임시직"
     "臨時職")
    ("임신"
     "妊娠"
     "姙娠")
    ("임신년"
     "壬申年")
    ("임신부"
     "妊娠婦")
    ("임신성"
     "姙娠性")
    ("임신율"
     "姙娠率")
    ("임야"
     "林野")
    ("임업"
     "林業")
    ("임오년"
     "壬午年")
    ("임용"
     "任用")
    ("임용권자"
     "任用權者")
    ("임용제"
     "任用制")
    ("임원"
     "任員")
    ("임원실"
     "任員室")
    ("임원진"
     "任員陣")
    ("임의"
     "任意")
    ("임의성"
     "任意性")
    ("임의적"
     "任意的")
    ("임자"
     "壬子")
    ("임자수탕"
     "荏子水湯")
    ("임재무구득"
     "臨財無求得")
    ("임전무퇴"
     "臨戰無退"
     "臨戰無退")
    ("임정"
     "臨政")
    ("임종"
     "臨終")
    ("임지"
     "任地"
     "林地")
    ("임직원"
     "任職員")
    ("임진왜란"
     "壬辰倭亂")
    ("임차인"
     "賃借人")
    ("임파선"
     "淋巴腺")
    ("임하선어"
     "臨河羨魚")
    ("임학"
     "林學")
    ("임해"
     "臨海")
    ("입"
     ("入" . "들 입")
     ("卄" . "스물 입")
     ("立" . "설 입")
     ("笠" . "우리 입")
     ("粒" . "알 입")
     ("廿" . "스물 입"))
    ("입각"
     "入閣"
     "立脚")
    ("입거"
     "入渠")
    ("입건"
     "立件")
    ("입경"
     "入京")
    ("입고"
     "入庫")
    ("입관"
     "入棺")
    ("입교"
     "入敎"
     "入校")
    ("입구"
     "入口")
    ("입국"
     "入國"
     "立國")
    ("입국문속"
     "入國問俗")
    ("입국자"
     "入國者")
    ("입금"
     "入金")
    ("입금자"
     "入金者")
    ("입단"
     "入團")
    ("입당"
     "入黨")
    ("입대"
     "入隊")
    ("입동"
     "立冬")
    ("입력"
     "入力")
    ("입론"
     "立論")
    ("입립신고"
     "粒粒辛苦")
    ("입무"
     "入巫")
    ("입문"
     "入聞"
     "入門")
    ("입법"
     "立法")
    ("입법권"
     "立法權")
    ("입법례"
     "立法例")
    ("입법부"
     "立法府")
    ("입법안"
     "立法案")
    ("입법자"
     "立法者")
    ("입법적"
     "立法的")
    ("입법화"
     "立法化")
    ("입사"
     "入社")
    ("입사각"
     "入射角")
    ("입사일"
     "入社日")
    ("입산"
     "入山")
    ("입산기호"
     "入山忌虎")
    ("입상"
     "入賞")
    ("입상자"
     "入賞者")
    ("입석"
     "立席")
    ("입선"
     "入選")
    ("입선작"
     "入選作")
    ("입성"
     "入城")
    ("입소"
     "入所")
    ("입소자"
     "入所者")
    ("입수"
     "入手"
     "入水"
     "入首")
    ("입시"
     "入試")
    ("입시생"
     "入試生")
    ("입시일"
     "入試日")
    ("입시장"
     "入試場")
    ("입시제"
     "入試制")
    ("입식"
     "立式")
    ("입신"
     "入神"
     "立身")
    ("입신양명"
     "立身揚名"
     "立身揚名")
    ("입신출세"
     "立身出世")
    ("입신출세주의"
     "立身出世主義")
    ("입실"
     "入室")
    ("입안"
     "立案")
    ("입양"
     "入養")
    ("입양아"
     "入養兒")
    ("입어료"
     "入漁料")
    ("입영"
     "入營")
    ("입욕"
     "入浴")
    ("입원"
     "入院")
    ("입원비"
     "入院費")
    ("입원실"
     "入院室")
    ("입자"
     "粒子")
    ("입자기"
     "粒子期")
    ("입장"
     "入場"
     "立場")
    ("입장객"
     "入場客")
    ("입장권"
     "入場券")
    ("입장료"
     "入場料")
    ("입적"
     "入寂"
     "入籍")
    ("입주"
     "入住")
    ("입주금"
     "入住金")
    ("입주자"
     "入住者")
    ("입증"
     "立證")
    ("입지"
     "立地"
     "立志"
     "立地")
    ("입지점"
     "立地點")
    ("입찰"
     "入札")
    ("입찰제"
     "入札制")
    ("입체"
     "立體")
    ("입체감"
     "立體感")
    ("입체적"
     "立體的")
    ("입체파"
     "立體派")
    ("입체형"
     "立體形")
    ("입체화"
     "立體化")
    ("입초"
     "入超")
    ("입초국"
     "入超國")
    ("입추"
     "立錐")
    ("입추지지"
     "立錐之地")
    ("입춘"
     "立春")
    ("입춘대길"
     "立春大吉")
    ("입춘서"
     "立春書")
    ("입춘절"
     "立春節")
    ("입출금"
     "入出金")
    ("입출금기"
     "入出金機")
    ("입하"
     "立夏")
    ("입학"
     "入學")
    ("입학금"
     "入學金")
    ("입학난"
     "入學難")
    ("입학생"
     "入學生")
    ("입학시험"
     "入學試驗")
    ("입학시험장"
     "入學試驗場")
    ("입학식"
     "入學式")
    ("입학식장"
     "入學式場")
    ("입학자"
     "入學者")
    ("입학제"
     "入學制")
    ("입항"
     "入港")
    ("입항주"
     "入港酒")
    ("입행"
     "入行")
    ("입회"
     "入會"
     "立會")
    ("입회비"
     "入會費")
    ("입후보"
     "立候補")
    ("입후보자"
     "立候補者")
    ("잉"
     ("仍" . "인할 잉")
     ("剩" . "남을 잉")
     ("孕" . "아이밸 잉")
     ("芿" . "새풀싹 잉")
     ("媵" . "보낼 잉"))
    ("잉부"
     "孕婦")
    ("잉여"
     "剩餘")
    ("잉여금"
     "剩餘金")
    ("잉태"
     "孕胎")
    ("자"
     ("仔" . "자세할 자")
     ("刺" . "찌를 자")
     ("咨" . "물을 자")
     ("姉" . "姊의 俗字")
     ("姿" . "맵시 자")
     ("子" . "아들 자")
     ("字" . "글자 자")
     ("孜" . "힘쓸 자")
     ("恣" . "방자할 자")
     ("慈" . "사랑할 자")
     ("滋" . "불을 자")
     ("炙" . "고기구을 자")
     "炸"
     ("煮" . "삶을 자")
     ("玆" . "이 자")
     ("瓷" . "오지그릇 자")
     ("疵" . "흠 자")
     ("磁" . "자석 자")
     ("紫" . "자주빛 자")
     ("者" . "놈 자")
     ("自" . "스스로 자")
     ("茨" . "가시나무 자")
     ("蔗" . "사탕수수 자")
     "薺"
     ("藉" . "깔개 자")
     ("諮" . "물을 자")
     ("資" . "재물 자")
     ("雌" . "암컷 자")
     ("呰" . "주차할 자")
     ("嬨" . "계집성품너그러고순할 자")
     ("孖" . "쌍둥이 자")
     ("孶" . "부지런할 자")
     ("柘" . "산뽕나무 자")
     ("泚" . "맑을 자")
     ("牸" . "암컷 자")
     ("眥" . "흘길 자")
     ("眦" . "眥와 同字")
     ("粢" . "피 자")
     ("耔" . "복돋을 자")
     ("胾" . "고깃점 자")
     ("茈" . "지치 자")
     ("茲" . "무성할 자")
     ("莿" . "풀가시 자")
     "虸"
     "蚱"
     ("觜" . "털뿔 자")
     ("訾" . "헐뜯을 자")
     ("貲" . "재물 자")
     ("赭" . "붉은흙 자")
     ("鎡" . "호미 자")
     ("頿" . "코밑수염 자")
     ("髭" . "코밑수염 자")
     ("鮓" . "젓 자")
     ("鶿" . "가마우지 자")
     ("鷓" . "자고 자"))
    ("자가"
     "自家")
    ("자가당착"
     "自家撞着")
    ("자가용"
     "自家用")
    ("자가운전"
     "自家運轉")
    ("자각"
     "自覺")
    ("자각적"
     "自覺的")
    ("자갈색"
     "紫褐色")
    ("자강불식"
     "自强不息")
    ("자객"
     "刺客")
    ("자격"
     "資格")
    ("자격증"
     "資格證")
    ("자격지심"
     "自激之心")
    ("자견"
     "自牽")
    ("자결"
     "自決")
    ("자계"
     "自戒")
    ("자고"
     "自古")
    ("자고이래"
     "自古以來")
    ("자고저"
     "字高低")
    ("자괴감"
     "自愧感")
    ("자괴지심"
     "自愧之心")
    ("자구"
     "自救")
    ("자구지단"
     "藉口之端")
    ("자구책"
     "自救策")
    ("자국"
     "自國")
    ("자국민"
     "自國民")
    ("자국어"
     "自國語")
    ("자국적"
     "自國的")
    ("자국화"
     "自國化")
    ("자궁"
     "子宮")
    ("자궁병"
     "子宮病")
    ("자궁암"
     "子宮癌")
    ("자규"
     "子規")
    ("자극"
     "刺戟")
    ("자극성"
     "刺戟性")
    ("자극적"
     "刺戟的")
    ("자극제"
     "刺戟劑")
    ("자금"
     "紫金"
     "資金")
    ("자금난"
     "資金難")
    ("자금력"
     "資金力")
    ("자금부장"
     "資金部長")
    ("자금원"
     "資金源")
    ("자금화"
     "資金化")
    ("자급"
     "自給")
    ("자급도"
     "自給度")
    ("자급자족"
     "自給自足")
    ("자급적"
     "自給的")
    ("자긍"
     "自矜")
    ("자긍심"
     "自矜心")
    ("자기"
     "瓷器"
     "磁氣"
     "自己")
    ("자기감정"
     "自己感情")
    ("자기규정"
     "自己規定")
    ("자기기만"
     "自己欺瞞")
    ("자기기만적"
     "自己欺瞞的")
    ("자기도취"
     "自己陶醉")
    ("자기도취적"
     "自己陶醉的")
    ("자기만족"
     "自己滿足")
    ("자기만족적"
     "自己滿足的")
    ("자기모순"
     "自己矛盾")
    ("자기모순적"
     "自己矛盾的")
    ("자기반성"
     "自己反省")
    ("자기변호"
     "自己辯護")
    ("자기비판"
     "自己批判")
    ("자기선전"
     "自己宣傳")
    ("자기소개"
     "自己紹介")
    ("자기식"
     "自記式")
    ("자기실현"
     "自己實現")
    ("자기애"
     "自己愛")
    ("자기의식"
     "自己意識")
    ("자기장"
     "磁氣場")
    ("자기주장"
     "自己主張")
    ("자기중심"
     "自己中心")
    ("자기중심적"
     "自己中心的")
    ("자기중심주의"
     "自己中心主義")
    ("자기편"
     "自己便")
    ("자기표현"
     "自己表現")
    ("자기희생"
     "自己犧牲")
    ("자녀"
     "子女")
    ("자녀관"
     "子女觀")
    ("자당"
     "慈堂")
    ("자대"
     "自隊")
    ("자동"
     "自動")
    ("자동문"
     "自動門")
    ("자동식"
     "自動式")
    ("자동인형"
     "自動人形")
    ("자동적"
     "自動的")
    ("자동차"
     "自動車")
    ("자동차관"
     "自動車館")
    ("자동차사"
     "自動車社")
    ("자동차세"
     "自動車稅")
    ("자동차업계"
     "自動車業界")
    ("자동차업체"
     "自動車業體")
    ("자동차용품"
     "自動車用品")
    ("자동판매기"
     "自動販賣機")
    ("자동학과"
     "自動學科")
    ("자동화"
     "自動化")
    ("자두연기"
     "煮豆燃萁")
    ("자두지미"
     "自頭至尾")
    ("자라"
     "紫羅")
    ("자란"
     "紫蘭")
    ("자력"
     "自力")
    ("자력갱생"
     "自力更生")
    ("자료"
     "資料")
    ("자료관"
     "資料館")
    ("자료실"
     "資料室")
    ("자료실장"
     "資料室長")
    ("자료은행"
     "資料銀行")
    ("자료집"
     "資料集")
    ("자립"
     "自立")
    ("자립도"
     "自立度")
    ("자립성"
     "自立性")
    ("자립적"
     "自立的")
    ("자립형"
     "自立型")
    ("자막"
     "字幕")
    ("자만"
     "自慢")
    ("자만심"
     "自慢心")
    ("자매"
     "姉妹")
    ("자매편"
     "姉妹篇")
    ("자멸"
     "自滅")
    ("자명"
     "自明")
    ("자명종"
     "自鳴鐘")
    ("자모"
     "字母")
    ("자모회"
     "姉母會")
    ("자목련"
     "紫木蓮")
    ("자문"
     "自問"
     "諮問")
    ("자문자답"
     "自問自答")
    ("자민족"
     "自民族")
    ("자발"
     "自發")
    ("자발성"
     "自發性")
    ("자발적"
     "自發的")
    ("자백"
     "自白")
    ("자보"
     "字報")
    ("자본"
     "資本")
    ("자본가"
     "資本家")
    ("자본금"
     "資本金")
    ("자본력"
     "資本力")
    ("자본론"
     "資本論")
    ("자본재"
     "資本財")
    ("자본제"
     "資本制")
    ("자본제적"
     "資本制的")
    ("자본주의"
     "資本主義")
    ("자본주의권"
     "資本主義圈")
    ("자본주의자"
     "資本主義者")
    ("자본주의적"
     "資本主義的")
    ("자본파적"
     "資本派的")
    ("자부"
     "自負")
    ("자부심"
     "自負心")
    ("자비"
     "慈悲"
     "自費")
    ("자사"
     "自社")
    ("자산"
     "資産")
    ("자산가"
     "資産家")
    ("자산권화"
     "資産權化")
    ("자살"
     "自殺")
    ("자살극"
     "自殺劇")
    ("자살자"
     "自殺者")
    ("자상"
     "仔詳")
    ("자색"
     "姿色"
     "紫色")
    ("자생"
     "自生")
    ("자생력"
     "自生力")
    ("자생적"
     "自生的")
    ("자서"
     "自序")
    ("자서전"
     "自敍傳")
    ("자석"
     "磁石")
    ("자선"
     "慈善")
    ("자성"
     "自省")
    ("자세"
     "仔細"
     "姿勢"
     "藉勢")
    ("자소"
     "字素")
    ("자손"
     "子孫")
    ("자손만대"
     "子孫萬代")
    ("자수"
     "刺繡"
     "自首")
    ("자수성가"
     "自手成家")
    ("자숙"
     "自肅")
    ("자술서"
     "自述書")
    ("자습"
     "自習")
    ("자습서"
     "自習書")
    ("자승자박"
     "自繩自縛")
    ("자시불각취"
     "自屎不覺臭")
    ("자시지벽"
     "自是之癖")
    ("자식"
     "子息")
    ("자신"
     "自信"
     "自身")
    ("자신감"
     "自信感")
    ("자신만만"
     "自信滿滿")
    ("자신조불량"
     "自身照不亮")
    ("자아"
     "自我")
    ("자아도취"
     "自我陶醉")
    ("자아비판"
     "自我批判")
    ("자아실현"
     "自我實現")
    ("자아의식"
     "自我意識")
    ("자애"
     "慈愛")
    ("자양"
     "滋養")
    ("자양분"
     "滋養分")
    ("자업자득"
     "自業自得")
    ("자연"
     "自然")
    ("자연경관"
     "自然景觀")
    ("자연계"
     "自然界"
     "自然系")
    ("자연관"
     "自然觀")
    ("자연대"
     "自然大")
    ("자연도태"
     "自然淘汰")
    ("자연동"
     "自然銅")
    ("자연림"
     "自然林")
    ("자연물"
     "自然物")
    ("자연미"
     "自然美")
    ("자연법적"
     "自然法的")
    ("자연법칙"
     "自然法則")
    ("자연변증법"
     "自然辨證法")
    ("자연보호"
     "自然保護")
    ("자연사"
     "自然史")
    ("자연산"
     "自然産")
    ("자연석"
     "自然石")
    ("자연성"
     "自然性")
    ("자연식"
     "自然食")
    ("자연식품"
     "自然食品")
    ("자연인"
     "自然人")
    ("자연재해"
     "自然災害")
    ("자연적"
     "自然的")
    ("자연조건"
     "自然條件")
    ("자연주의"
     "自然主義")
    ("자연주의자"
     "自然主義者")
    ("자연주의적"
     "自然主義的")
    ("자연촌"
     "自然村")
    ("자연치료"
     "自然治療")
    ("자연현상"
     "自然現象")
    ("자연환경"
     "自然環境")
    ("자영"
     "自營")
    ("자영업자"
     "自營業者")
    ("자오반포"
     "慈烏反哺")
    ("자외선"
     "紫外線")
    ("자원"
     "自願"
     "資源")
    ("자위"
     "自慰"
     "自衛")
    ("자위권"
     "自衛權")
    ("자위대"
     "自衛隊")
    ("자위부은"
     "子爲父隱")
    ("자위행위"
     "自慰行爲")
    ("자유"
     "自由")
    ("자유권"
     "自由權")
    ("자유민"
     "自由民")
    ("자유방임"
     "自由放任")
    ("자유분방"
     "自由奔放")
    ("자유사상"
     "自由思想")
    ("자유선거"
     "自由選擧")
    ("자유시"
     "自由詩")
    ("자유업"
     "自由業")
    ("자유의사"
     "自由意思")
    ("자유인"
     "自由人")
    ("자유자재"
     "自由自在")
    ("자유정신"
     "自由精神")
    ("자유주의"
     "自由主義")
    ("자유주의자"
     "自由主義者")
    ("자유주의적"
     "自由主義的")
    ("자유직종"
     "自由職種")
    ("자유항"
     "自由港")
    ("자유형"
     "自由型")
    ("자유화"
     "自由化")
    ("자유화율"
     "自由化率")
    ("자유휼고"
     "慈幼恤孤")
    ("자율"
     "自律")
    ("자율권"
     "自律權")
    ("자율성"
     "自律性")
    ("자율적"
     "自律的")
    ("자율화"
     "自律化")
    ("자음"
     "子音")
    ("자의"
     "自意")
    ("자의성"
     "自意性")
    ("자의식"
     "自意識")
    ("자의적"
     "恣意的")
    ("자인"
     "自認")
    ("자임"
     "自任")
    ("자자"
     "藉藉")
    ("자자손손"
     "子子孫孫")
    ("자자주옥"
     "字字珠玉")
    ("자작"
     "自作")
    ("자작극"
     "自作劇")
    ("자작농"
     "自作農")
    ("자작지"
     "自作地")
    ("자작지얼"
     "自作之孼")
    ("자장권"
     "磁場圈")
    ("자재"
     "自在"
     "資材")
    ("자재난"
     "資材難")
    ("자재부"
     "資材部")
    ("자적"
     "自適")
    ("자전"
     "自傳"
     "自專"
     "自轉")
    ("자전거"
     "自轉車")
    ("자전적"
     "自傳的")
    ("자정"
     "子正"
     "字丁"
     "自淨")
    ("자제"
     "子弟"
     "自制")
    ("자제력"
     "自制力")
    ("자조"
     "自助"
     "自嘲"
     "自照")
    ("자조적"
     "自嘲的")
    ("자족"
     "自足")
    ("자족성"
     "自足性")
    ("자족적"
     "自足的")
    ("자존"
     "自存")
    ("자존감"
     "自尊感")
    ("자존성"
     "自存性")
    ("자존심"
     "自尊心")
    ("자존심론"
     "自尊心論")
    ("자주"
     "自主")
    ("자주국방"
     "自主國防")
    ("자주권"
     "自主權")
    ("자주독립"
     "自主獨立")
    ("자주력"
     "自主力")
    ("자주색"
     "紫朱色")
    ("자주성"
     "自主性")
    ("자주적"
     "自主的")
    ("자주정신"
     "自主精神")
    ("자주화"
     "自主化")
    ("자줏"
     "紫朱")
    ("자중"
     "自重")
    ("자중지란"
     "自中之亂")
    ("자진"
     "自進")
    ("자질"
     "資質")
    ("자책"
     "自責")
    ("자책감"
     "自責感")
    ("자책점"
     "自責點")
    ("자처"
     "自處")
    ("자천"
     "自薦")
    ("자천타배"
     "自賤他拜")
    ("자청"
     "自請")
    ("자체"
     "字體"
     "自體")
    ("자체적"
     "自體的")
    ("자초"
     "自招")
    ("자초지종"
     "自初至終")
    ("자충수"
     "自充手")
    ("자취"
     "自炊")
    ("자취방"
     "自炊房")
    ("자취생"
     "自炊生")
    ("자치"
     "自治")
    ("자치구"
     "自治區")
    ("자치권"
     "自治權")
    ("자치적"
     "自治的")
    ("자치제"
     "自治制")
    ("자치회"
     "自治會")
    ("자칭"
     "自稱")
    ("자타"
     "自他")
    ("자타공인"
     "自他共認")
    ("자탄"
     "自歎")
    ("자태"
     "姿態")
    ("자택"
     "自宅")
    ("자퇴"
     "自退")
    ("자파"
     "自派")
    ("자판"
     "字板")
    ("자판기"
     "自販機")
    ("자폐"
     "自廢")
    ("자폐아"
     "自閉兒")
    ("자폐적"
     "自閉的")
    ("자폐증"
     "自閉症")
    ("자폐증아"
     "自閉症兒")
    ("자포자기"
     "自暴自棄")
    ("자폭"
     "自爆")
    ("자필"
     "自筆")
    ("자하달상"
     "自下達上")
    ("자학"
     "自虐")
    ("자해"
     "字解"
     "自害")
    ("자행"
     "恣行")
    ("자행자지"
     "自行自止")
    ("자현"
     "自現")
    ("자현자불명"
     "自現者不明")
    ("자형"
     "姉兄"
     "字形")
    ("자화라"
     "紫花羅")
    ("자화상"
     "自畵像")
    ("자화자찬"
     "自畵自讚")
    ("자회사"
     "子會社")
    ("작"
     ("作" . "지을 작")
     ("勺" . "구기 작")
     ("嚼" . "씹을 작")
     ("斫" . "벨 작")
     ("昨" . "어제 작")
     ("杓" . "구기 작")
     ("灼" . "사를 작")
     ("炸" . "터질 작")
     ("爵" . "벼슬 작")
     ("綽" . "너그러울 작")
     ("芍" . "작약 작")
     ("酌" . "따를 작")
     ("酢" . "초 작")
     ("醋" . "술잔을 돌릴 작")
     ("雀" . "참새 작")
     ("鵲" . "까치 작")
     ("岝" . "산 높을 작")
     ("怍" . "부끄러울 작")
     ("斱" . "쪼갤 작")
     ("柞" . "나무이름 작")
     ("汋" . "삶을 작")
     ("焯" . "밝을 작")
     ("犳" . "아롱 짐승 작")
     ("碏" . "삼갈 작"))
    ("작가"
     "作家")
    ("작가상"
     "作家賞")
    ("작가적"
     "作家的")
    ("작가전"
     "作家展")
    ("작가주의"
     "作家主義")
    ("작고"
     "作故")
    ("작곡"
     "作曲")
    ("작곡가"
     "作曲家")
    ("작곡과"
     "作曲科")
    ("작곡자"
     "作曲者")
    ("작금"
     "昨今")
    ("작년"
     "昨年")
    ("작년도"
     "昨年度")
    ("작년분"
     "昨年分")
    ("작당"
     "作黨")
    ("작도기"
     "斫刀機")
    ("작동"
     "作動")
    ("작렬"
     "炸裂")
    ("작료"
     "作料")
    ("작명"
     "作名")
    ("작목"
     "作木")
    ("작문"
     "作文")
    ("작물"
     "作物")
    ("작법"
     "作法")
    ("작별"
     "作別")
    ("작별주"
     "作別酒")
    ("작부"
     "酌婦")
    ("작사"
     "作詞")
    ("작사가"
     "作詞家")
    ("작사도방"
     "作舍道傍")
    ("작성"
     "作成")
    ("작성자"
     "作成者")
    ("작수성례"
     "酌水成禮")
    ("작시"
     "作詩")
    ("작심"
     "作心")
    ("작심삼일"
     "作心三日")
    ("작업"
     "作業")
    ("작업량"
     "作業量")
    ("작업반"
     "作業班")
    ("작업반원"
     "作業班員")
    ("작업반장"
     "作業班長")
    ("작업복"
     "作業服")
    ("작업실"
     "作業室")
    ("작업원"
     "作業員")
    ("작업자"
     "作業者")
    ("작업장"
     "作業場")
    ("작업화"
     "作業化")
    ("작열"
     "灼熱")
    ("작용"
     "作用")
    ("작용력"
     "作用力")
    ("작용적"
     "作用的")
    ("작용점"
     "作用點")
    ("작위"
     "作爲"
     "爵位")
    ("작위적"
     "作爲的")
    ("작인"
     "作人")
    ("작자"
     "作者")
    ("작작"
     "綽綽")
    ("작작유여"
     "綽綽有餘")
    ("작전"
     "作戰")
    ("작전권"
     "作戰權")
    ("작전식"
     "作戰式")
    ("작전통"
     "作戰通")
    ("작정"
     "作定")
    ("작중"
     "作中")
    ("작지불이"
     "作之不已")
    ("작태"
     "作態")
    ("작파"
     "作破")
    ("작품"
     "作品")
    ("작품상"
     "作品賞")
    ("작품성"
     "作品性")
    ("작품적"
     "作品的")
    ("작품전"
     "作品展")
    ("작품집"
     "作品集")
    ("작품화"
     "作品化")
    ("작풍"
     "作風")
    ("작황"
     "作況")
    ("잔"
     ("孱" . "잔약할 잔")
     ("棧" . "잔교 잔")
     ("殘" . "해칠 잔")
     ("潺" . "물이 줄줄 흐르는 모양 잔")
     ("盞" . "작은 술잔 잔")
     ("剗" . "깍을 잔")
     ("戔" . "쌓일 잔")
     ("驏" . "안장 얹지 않은 말 잔"))
    ("잔구성"
     "殘丘性")
    ("잔금"
     "殘金")
    ("잔당"
     "殘黨")
    ("잔량"
     "殘量")
    ("잔류"
     "殘留")
    ("잔망"
     "孱妄")
    ("잔배냉적"
     "殘杯冷炙")
    ("잔상"
     "殘像")
    ("잔설"
     "殘雪")
    ("잔악성"
     "殘惡性")
    ("잔액"
     "殘額")
    ("잔업"
     "殘業")
    ("잔여"
     "殘餘")
    ("잔여물"
     "殘餘物")
    ("잔여적"
     "殘餘的")
    ("잔영"
     "殘影")
    ("잔월효성"
     "殘月曉星")
    ("잔인"
     "殘忍")
    ("잔인무도"
     "殘忍無道")
    ("잔인성"
     "殘忍性")
    ("잔인화"
     "殘忍化")
    ("잔재"
     "殘在"
     "殘滓")
    ("잔존"
     "殘存")
    ("잔편단간"
     "殘編斷簡")
    ("잔해"
     "殘骸")
    ("잔향"
     "殘響")
    ("잔혹"
     "殘酷")
    ("잔혹성"
     "殘酷性")
    ("잠"
     ("岑" . "봉우리 잠")
     ("暫" . "잠시 잠")
     "湛"
     ("潛" . "잠길 잠")
     ("箴" . "바늘 잠")
     ("簪" . "비녀 잠")
     ("蠶" . "누에 잠")
     "梣"
     ("涔" . "괸물 잠")
     ("潜" . "潛의 俗字")
     ("濳" . "潛의 俗字")
     "笒"
     ("蚕" . "누에 잠"))
    ("잠덕지유광"
     "潛德之幽光")
    ("잠로영일"
     "暫勞永逸")
    ("잠망경"
     "潛望鏡")
    ("잠복"
     "潛伏")
    ("잠복근무"
     "潛伏勤務")
    ("잠복기"
     "潛伏期")
    ("잠불리측"
     "暫不離側")
    ("잠상"
     "潛商")
    ("잠수"
     "潛水")
    ("잠수부"
     "潛水夫")
    ("잠수정"
     "潛水艇")
    ("잠수함"
     "潛水艦")
    ("잠시"
     "暫時")
    ("잠식"
     "蠶食")
    ("잠식당"
     "蠶食當")
    ("잠실"
     "蠶室")
    ("잠언"
     "箴言")
    ("잠입"
     "潛入")
    ("잠잠"
     "潛潛")
    ("잠재"
     "潛在")
    ("잠재력"
     "潛在力")
    ("잠재성"
     "潛在性")
    ("잠재의식"
     "潛在意識")
    ("잠재적"
     "潛在的")
    ("잠적"
     "潛寂"
     "潛跡")
    ("잠정"
     "暫定")
    ("잠정적"
     "暫定的")
    ("잠종비적"
     "潛蹤秘跡")
    ("잠행"
     "潛行")
    ("잡"
     "閘"
     ("雜" . "섞일 잡")
     ("卡" . "관 잡")
     ("囃" . "장단 잡을 잡")
     ("眨" . "눈 깜작일 잡")
     ("磼" . "산 높을 잡")
     ("襍" . "雜의 本字")
     "霅")
    ("잡거"
     "雜居")
    ("잡곡"
     "雜穀")
    ("잡귀"
     "雜鬼")
    ("잡균"
     "雜菌")
    ("잡급직"
     "雜給職")
    ("잡념"
     "雜念")
    ("잡다"
     "雜多")
    ("잡담"
     "雜談")
    ("잡답"
     "雜沓")
    ("잡목"
     "雜木")
    ("잡목림"
     "雜木林")
    ("잡무"
     "雜務")
    ("잡문"
     "雜文")
    ("잡부금"
     "雜賦金")
    ("잡비"
     "雜費")
    ("잡사"
     "雜事")
    ("잡상인"
     "雜商人")
    ("잡식"
     "雜識")
    ("잡식성"
     "雜食性")
    ("잡역부"
     "雜役夫")
    ("잡음"
     "雜音")
    ("잡인배"
     "雜人輩")
    ("잡종"
     "雜種")
    ("잡지"
     "雜誌")
    ("잡지명"
     "雜誌名")
    ("잡지사"
     "雜誌社")
    ("잡지책"
     "雜誌冊")
    ("잡직"
     "雜職")
    ("잡채"
     "雜菜")
    ("잡척층"
     "雜尺層")
    ("잡초"
     "雜草")
    ("잡탕"
     "雜湯")
    ("잡피"
     "雜皮")
    ("잡화"
     "雜貨")
    ("잡화상"
     "雜貨商")
    ("잡화점"
     "雜貨店")
    ("장"
     ("丈" . "어른 장")
     ("仗" . "병장기 장")
     ("匠" . "장인 장")
     ("場" . "마당 장")
     ("墻" . "牆과 同字")
     ("壯" . "씩씩할 장")
     ("奬" . "도울 장")
     ("將" . "장차 장")
     ("帳" . "휘장 장막 장")
     ("庄" . "장중할 장")
     ("張" . "베풀 장")
     ("掌" . "손바닥 장")
     ("暲" . "햇발이 돋아올 장")
     ("杖" . "지팡이 장")
     ("樟" . "녹나무 장")
     ("檣" . "돛대 장")
     ("欌" . "장농 장")
     ("漿" . "미음 장")
     ("牆" . "담 장")
     ("獐" . "노루 장")
     ("璋" . "끝의 반을 깎아 뾰족하게 한 홀 장")
     ("章" . "문채 장")
     ("粧" . "단장할 장")
     ("腸" . "창자 장")
     ("臟" . "오장 장")
     ("臧" . "착할 장")
     ("莊" . "엄할 장")
     ("葬" . "장사 지낼 장")
     ("蔣" . "줄 장")
     ("薔" . "물여뀌 장")
     ("藏" . "감출 장")
     ("裝" . "차려 입을 장")
     ("贓" . "장물 장")
     ("醬" . "장 장")
     ("長" . "길 장")
     ("障" . "막을 장")
     ("狀" . "모양 형상 장")
     ("傽" . "놀랄 장")
     ("奘" . "클 장")
     ("妝" . "꾸밀 장")
     ("嬙" . "궁녀 장")
     ("嶂" . "높고 가파른 산 장")
     ("廧" . "담 장")
     ("戕" . "죽일 장")
     "橦"
     ("漳" . "강이름 장")
     ("牂" . "암양 장")
     ("瘴" . "장기 장")
     ("糚" . "妝과 同字")
     ("羘" . "수양 장")
     ("萇" . "나무 이름 장")
     ("装" . "裝의 俗字")
     ("賬" . "치부책 장")
     ("鄣" . "나라이름 장")
     ("鏘" . "금옥 소리 장")
     ("餦" . "산자 장")
     ("麞" . "노루 장"))
    ("장갑"
     "掌匣")
    ("장갑차"
     "裝甲車")
    ("장강"
     "長江")
    ("장거"
     "壯擧")
    ("장거리"
     "長距離")
    ("장거리포"
     "長距離砲")
    ("장경"
     "場景")
    ("장계취계"
     "將計就計")
    ("장고"
     "藏庫"
     "長考")
    ("장과"
     "漿果")
    ("장관"
     "壯觀"
     "將官"
     "長官")
    ("장관상"
     "長官賞")
    ("장관실"
     "長官室")
    ("장관이대"
     "張冠李戴")
    ("장관직"
     "長官職")
    ("장광설"
     "長廣舌")
    ("장교"
     "將校")
    ("장구"
     "裝具"
     "長久")
    ("장구지계"
     "長久之計")
    ("장구지학"
     "章句之學")
    ("장군"
     "將軍")
    ("장급"
     "長級")
    ("장기"
     "將棋"
     "臟器"
     "長技"
     "長期")
    ("장기간"
     "長期間")
    ("장기성"
     "長期性")
    ("장기수"
     "長期囚")
    ("장기적"
     "長期的")
    ("장기화"
     "長期化")
    ("장남"
     "長男")
    ("장내"
     "場內"
     "腸內")
    ("장녀"
     "長女")
    ("장년"
     "壯年"
     "長年")
    ("장년기"
     "壯年期")
    ("장년층"
     "壯年層")
    ("장뇌"
     "樟腦")
    ("장단"
     "長短")
    ("장단점"
     "長短點")
    ("장담"
     "壯談")
    ("장대"
     "壯大"
     "將臺"
     "張大"
     "長大")
    ("장도"
     "壯途")
    ("장독"
     "杖毒")
    ("장독대"
     "醬-臺")
    ("장래"
     "將來")
    ("장래성"
     "將來性")
    ("장려"
     "壯麗"
     "奬勵")
    ("장려금"
     "奬勵金")
    ("장려책"
     "奬勵策")
    ("장력"
     "張力")
    ("장렬"
     "壯烈")
    ("장례"
     "葬禮")
    ("장례복"
     "葬禮服")
    ("장례식"
     "葬禮式")
    ("장례일"
     "葬禮日")
    ("장로"
     "長老")
    ("장롱"
     "欌籠")
    ("장리"
     "長利")
    ("장립대명"
     "長立待命")
    ("장막"
     "帳幕")
    ("장막여신"
     "杖莫如信")
    ("장면"
     "場面")
    ("장면장면"
     "場面場面")
    ("장명"
     "長命")
    ("장명등"
     "長明燈")
    ("장모"
     "丈母")
    ("장목전"
     "長木廛")
    ("장문"
     "長文")
    ("장물"
     "贓物")
    ("장미"
     "薔薇")
    ("장미과"
     "薔薇科")
    ("장미반"
     "薔薇班")
    ("장미원"
     "薔薇園")
    ("장밋"
     "薔薇")
    ("장발"
     "長髮")
    ("장방형"
     "長方形")
    ("장벽"
     "障壁")
    ("장변"
     "場邊")
    ("장병"
     "將兵")
    ("장본인"
     "張本人")
    ("장부"
     "丈夫"
     "帳簿")
    ("장비"
     "裝備")
    ("장비군령"
     "張飛軍令")
    ("장사"
     "壯士"
     "葬事")
    ("장사진"
     "長蛇陣")
    ("장산적"
     "醬散炙")
    ("장삼"
     "長衫")
    ("장삼이사"
     "張三李四")
    ("장상전장"
     "掌上煎醬")
    ("장색"
     "匠色")
    ("장생불사"
     "長生不死")
    ("장서"
     "藏書")
    ("장석"
     "張石"
     "長石")
    ("장석운근"
     "匠石運斤")
    ("장성"
     "將星"
     "長城"
     "長成")
    ("장성일"
     "長聖日")
    ("장세"
     "場稅")
    ("장소"
     "場所")
    ("장손"
     "長孫")
    ("장송"
     "葬送")
    ("장송곡"
     "葬送曲")
    ("장수"
     "將帥"
     "張數"
     "長壽")
    ("장수선무"
     "長袖善舞")
    ("장시"
     "場市")
    ("장시간"
     "長時間")
    ("장식"
     "裝飾")
    ("장식문"
     "裝飾文")
    ("장식물"
     "裝飾物")
    ("장식상"
     "裝飾商")
    ("장식선"
     "裝飾線")
    ("장식성"
     "裝飾性")
    ("장식욕"
     "裝飾慾")
    ("장식적"
     "裝飾的")
    ("장식품"
     "裝飾品")
    ("장신"
     "長身")
    ("장신구"
     "裝身具")
    ("장악"
     "掌握")
    ("장악력"
     "掌握力")
    ("장안"
     "長安")
    ("장애"
     "障碍")
    ("장애물"
     "障碍物")
    ("장애아"
     "障碍兒")
    ("장애인"
     "障碍人")
    ("장애자"
     "障碍者")
    ("장애적"
     "障碍的")
    ("장어"
     "長魚")
    ("장엄"
     "莊嚴")
    ("장엄감"
     "莊嚴感")
    ("장외"
     "場外")
    ("장원"
     "壯元"
     "莊園")
    ("장원주"
     "壯元紬")
    ("장유유서"
     "長幼有序")
    ("장의"
     "葬儀")
    ("장이론"
     "場理論")
    ("장인"
     "丈人"
     "匠人")
    ("장자"
     "長子")
    ("장작"
     "長斫")
    ("장장"
     "長長")
    ("장전"
     "裝塡")
    ("장점"
     "長點")
    ("장정"
     "壯丁"
     "長程")
    ("장조"
     "長調")
    ("장좌불와"
     "長坐不臥")
    ("장주지몽"
     "莊周之夢")
    ("장죽"
     "長竹")
    ("장중"
     "莊重")
    ("장중득실"
     "場中得失")
    ("장중보옥"
     "掌中寶玉")
    ("장지"
     "葬地")
    ("장지문"
     "障-門")
    ("장차"
     "將次"
     "欌車")
    ("장차관"
     "長次官")
    ("장착"
     "裝着")
    ("장책"
     "帳冊"
     "長策")
    ("장처전"
     "莊處田")
    ("장천"
     "長天")
    ("장취불성"
     "長醉不醒")
    ("장치"
     "裝置")
    ("장치적"
     "裝置的")
    ("장침대금"
     "長枕大衾")
    ("장쾌"
     "壯快")
    ("장타"
     "長打")
    ("장타율"
     "長打率")
    ("장탄식"
     "長歎息")
    ("장토"
     "莊土")
    ("장판"
     "壯版")
    ("장판방"
     "壯版房")
    ("장판지"
     "壯版紙")
    ("장편"
     "長篇")
    ("장풍"
     "藏風")
    ("장학"
     "奬學")
    ("장학과"
     "奬學課")
    ("장학관"
     "奬學官")
    ("장학금"
     "奬學金")
    ("장학사"
     "奬學士")
    ("장학생"
     "奬學生")
    ("장학회"
     "奬學會")
    ("장항"
     "醬缸")
    ("장해"
     "障害")
    ("장형"
     "長兄")
    ("장화"
     "長靴")
    ("장황"
     "張皇")
    ("재"
     ("再" . "두 번 재, 거듭 재")
     ("哉" . "비로소 재, 답다 재, 그런가 재")
     ("在" . "있을 재, 살 재, 살필 재, 곳 재")
     ("宰" . "주관할 재, 다스릴 재, 재상 재, 으뜸 재, 삶을 재")
     ("才" . "재주 재, 능할 재, 현인 재, 바탕 재")
     ("材" . "재목 재, 늘미 재, 성품 재, 재주 재")
     ("栽" . "심을 재")
     ("梓" . "가래나무 재, 목수 재, 우러러 볼 재, 고향 재")
     ("渽" . "맑을 재")
     ("滓" . "앙금 재, 찌끼 재")
     ("災" . "재앙 재, 천벌 재, 횡액 재")
     ("縡" . "일 재, 실을 재")
     ("裁" . "마름질할 재, 헤아릴 재, 결단할 재")
     ("財" . "재물 재, 뇌물 재, 보배 재")
     ("載" . "실을 재, 이길 재, 비롯할 재, 가득할 재")
     ("齋" . "재계할 재, 집 재")
     ("齎" . "탄식할 재, 쌀 재, 가질 재")
     "夈"
     "扗"
     "榟"
     ("灾" . "災와 同字")
     ("纔" . "겨우 재, 비롯할 재")
     "菑")
    ("재가"
     "再嫁"
     "裁可")
    ("재가동"
     "再稼動")
    ("재가열"
     "再加熱")
    ("재간"
     "才幹")
    ("재개"
     "再開")
    ("재개발"
     "再開發")
    ("재개정"
     "再改正")
    ("재거주"
     "再居住")
    ("재건"
     "再建")
    ("재검사"
     "再檢査")
    ("재검토"
     "再檢討")
    ("재격돌"
     "再激突")
    ("재결과"
     "再結果")
    ("재결성"
     "再結成")
    ("재결합"
     "再結合")
    ("재경"
     "財經")
    ("재계"
     "財界")
    ("재계약"
     "再契約")
    ("재고"
     "再考"
     "在庫")
    ("재고량"
     "在庫量")
    ("재공개"
     "再公開")
    ("재공연"
     "再公演")
    ("재교육"
     "再敎育")
    ("재구매"
     "再購買")
    ("재구성"
     "再構成")
    ("재구축"
     "再構築")
    ("재규정"
     "再規定")
    ("재기"
     "再起"
     "才氣")
    ("재기습"
     "再奇襲")
    ("재난"
     "災難")
    ("재녹음"
     "再錄音")
    ("재능"
     "才能")
    ("재단"
     "裁斷"
     "財團")
    ("재단반"
     "裁斷班")
    ("재담"
     "才談")
    ("재덕겸비"
     "才德兼備")
    ("재도발"
     "再挑發")
    ("재도약"
     "再跳躍")
    ("재도전"
     "再挑戰")
    ("재독"
     "在獨")
    ("재돌입"
     "再突入")
    ("재등록"
     "再登錄")
    ("재등장"
     "再登場")
    ("재래"
     "再來"
     "在來")
    ("재래극"
     "在來劇")
    ("재래선"
     "在來線")
    ("재래시장"
     "在來市場")
    ("재래식"
     "在來式")
    ("재래종"
     "在來種")
    ("재량"
     "裁量")
    ("재량권"
     "裁量權")
    ("재력"
     "財力")
    ("재력가"
     "財力家")
    ("재론"
     "再論")
    ("재롱"
     "才弄")
    ("재료"
     "材料")
    ("재료량"
     "材料量")
    ("재료비"
     "材料費")
    ("재료학과"
     "材料學科")
    ("재림"
     "再臨")
    ("재목"
     "材木")
    ("재무"
     "財務")
    ("재무장"
     "再武裝")
    ("재무제표"
     "財務諸表")
    ("재물"
     "財物")
    ("재미"
     "在美")
    ("재발"
     "再發")
    ("재발견"
     "再發見")
    ("재발탁"
     "再拔擢")
    ("재방송"
     "再放送")
    ("재배"
     "栽培")
    ("재배지"
     "栽培地")
    ("재배치"
     "再配置")
    ("재벌"
     "財閥")
    ("재벌가"
     "財閥家")
    ("재복"
     "財福")
    ("재봉"
     "裁縫")
    ("재부"
     "財富")
    ("재분류"
     "再分類")
    ("재분배"
     "再分配")
    ("재사용"
     "再使用")
    ("재산"
     "財産")
    ("재산가"
     "財産家")
    ("재산권"
     "財産權")
    ("재산세"
     "財産稅")
    ("재산세국"
     "財産稅局")
    ("재산세율"
     "財産稅率")
    ("재산제"
     "財産制")
    ("재산형"
     "財産刑")
    ("재삼"
     "再三")
    ("재상"
     "宰相")
    ("재생"
     "再生")
    ("재생부"
     "再生部")
    ("재생산"
     "再生産")
    ("재생산적"
     "再生産的")
    ("재생용품"
     "再生用品")
    ("재생적"
     "再生的")
    ("재생지은"
     "再生之恩")
    ("재생창"
     "再生廠")
    ("재선"
     "再選")
    ("재선거"
     "再選擧")
    ("재설계"
     "再設計")
    ("재성장"
     "再成長")
    ("재세"
     "在世")
    ("재소자"
     "在所者")
    ("재소환"
     "再召喚")
    ("재소환장"
     "再召喚狀")
    ("재수"
     "再修"
     "財數")
    ("재수사"
     "再搜査")
    ("재수생"
     "再修生")
    ("재수생반"
     "再修生班")
    ("재순환"
     "再循環")
    ("재승격"
     "再昇格")
    ("재승덕박"
     "才勝德薄")
    ("재심"
     "再審")
    ("재심사"
     "再審査")
    ("재앙"
     "災殃")
    ("재야"
     "在野")
    ("재야인사"
     "在野人士")
    ("재연"
     "再演"
     "再燃")
    ("재연기"
     "再延期")
    ("재외"
     "在外")
    ("재용"
     "財用")
    ("재원"
     "才媛"
     "財源")
    ("재위"
     "在位")
    ("재음미"
     "再吟味")
    ("재의"
     "再議")
    ("재의뢰"
     "再依賴")
    ("재이용"
     "再利用")
    ("재인식"
     "再認識")
    ("재일"
     "在日")
    ("재임"
     "在任")
    ("재임용"
     "再任用")
    ("재임용제"
     "再任用制")
    ("재입국"
     "再入國")
    ("재입성"
     "再入城")
    ("재입학"
     "再入學")
    ("재자가인"
     "才子佳人")
    ("재자다병"
     "才子多病")
    ("재작년"
     "再昨年")
    ("재장악"
     "再掌握")
    ("재재작년"
     "再再昨年")
    ("재점검"
     "再點檢")
    ("재접근"
     "再接近")
    ("재정"
     "裁定"
     "財政")
    ("재정국장"
     "財政局長")
    ("재정난"
     "財政難")
    ("재정돈"
     "再整頓")
    ("재정리"
     "再整理")
    ("재정립"
     "再正立")
    ("재정부"
     "財政部")
    ("재정비"
     "再整備")
    ("재정적"
     "財政的")
    ("재조립"
     "再組立")
    ("재조명"
     "再照明")
    ("재조사"
     "再調査")
    ("재조율"
     "再調律")
    ("재조정"
     "再調整")
    ("재조직"
     "再組織")
    ("재조합"
     "再組合")
    ("재종조모"
     "再從祖母")
    ("재종조부"
     "再從祖父")
    ("재중"
     "在中")
    ("재지"
     "在地")
    ("재지적"
     "在地的")
    ("재지층"
     "在地層")
    ("재직"
     "在職")
    ("재직권"
     "在職權")
    ("재질"
     "才質"
     "材質")
    ("재집권"
     "再執權")
    ("재차"
     "再次")
    ("재창작"
     "再創作")
    ("재창조"
     "再創造")
    ("재채혈"
     "再採血")
    ("재처리"
     "再處理")
    ("재천명"
     "再闡明")
    ("재촉구"
     "再促求")
    ("재촌탈농"
     "在村脫農")
    ("재촬영"
     "再撮影")
    ("재출발"
     "再出發")
    ("재충"
     "再充")
    ("재측정"
     "再測定")
    ("재치"
     "才致")
    ("재타협"
     "再妥協")
    ("재탄생"
     "再誕生")
    ("재탈환"
     "再奪還")
    ("재탕"
     "再湯")
    ("재통일"
     "再統一")
    ("재통합"
     "再統合")
    ("재투입"
     "再投入")
    ("재투자"
     "再投資")
    ("재투표"
     "再投票")
    ("재판"
     "再版"
     "裁判")
    ("재판관"
     "裁判官")
    ("재판권"
     "裁判權")
    ("재판부"
     "裁判部")
    ("재판석"
     "裁判席")
    ("재판소"
     "裁判所")
    ("재판식"
     "裁判式")
    ("재판장"
     "裁判長")
    ("재판정"
     "裁判廷")
    ("재편"
     "再編")
    ("재편성"
     "再編成")
    ("재편입"
     "再編入")
    ("재평가"
     "再評價")
    ("재학"
     "在學"
     "才學")
    ("재학생"
     "在學生")
    ("재학식삼장"
     "才學識三長")
    ("재항고"
     "再抗告")
    ("재해"
     "災害")
    ("재해석"
     "再解釋")
    ("재해직"
     "再解職")
    ("재현"
     "再現")
    ("재형"
     "財形")
    ("재형저축"
     "財形貯蓄")
    ("재혼"
     "再婚")
    ("재화"
     "財貨")
    ("재확립"
     "再確立")
    ("재확인"
     "再確認")
    ("재활"
     "再活")
    ("재활성화"
     "再活性化")
    ("재활용"
     "再活用")
    ("재활용품"
     "再活用品")
    ("재활원"
     "再活院")
    ("재활원장"
     "再活院長")
    ("재회"
     "再會")
    ("재회동"
     "再會同")
    ("쟁"
     ("爭" . "다툴 쟁, 다스릴 쟁, 분별할 쟁")
     ("箏" . "쟁 쟁, 풍경 쟁")
     ("諍" . "간할 쟁")
     ("錚" . "쇳소리 쟁그렁거릴 쟁, 징 쟁")
     ("崢" . "가파를 쟁, 산 높을 쟁")
     ("猙" . "밉살스럴 쟁, 짐승이름 쟁")
     ("琤" . "옥소리 쟁")
     ("瞠" . "똑바로 볼 쟁")
     ("鎗" . "금석소리 쟁, 창 쟁, 총 쟁")
     "鐺")
    ("쟁론"
     "爭論")
    ("쟁반"
     "錚盤")
    ("쟁위"
     "爭委")
    ("쟁의"
     "爭議")
    ("쟁의권"
     "爭議權")
    ("쟁쟁"
     "錚錚")
    ("쟁점"
     "爭點")
    ("쟁점화"
     "爭點化")
    ("쟁취"
     "爭取")
    ("쟁탈전"
     "爭奪戰")
    ("쟁패"
     "爭覇")
    ("저"
     ("佇" . "오래 설 저, 기다릴 저, 잠깐 머물 저")
     ("低" . "낮을 저, 값 쌀 저, 소리 약할 저, 숙일 저, 머뭇거릴 저")
     ("儲" . "쌓을 저, 버금 저, 용납할 저")
     ("咀" . "씹을 저, 깨달을 저, 먹을 저")
     ("姐" . "맏누이 저, 아가씨 저, 교만할 저")
     ("底" . "밑 저, 그칠 저")
     ("抵" . "밀칠 저, 당할 저, 막을 저, 다달을 저, 씨름할 저")
     ("杵" . "공이 저, 방망이 저, 혜성 저")
     ("楮" . "닥나무 저, 종이돈 저, 감매나무 저")
     ("樗" . "가죽나무 저")
     ("沮" . "그칠 저, 막을 저, 무너질 저, 공갈할 저, 물이 번질 저, 나라이름 저")
     ("渚" . "물가 저, 물 갈라질 저")
     ("狙" . "원숭이 저, 엿볼 저, 살필 저")
     ("猪" . "豬의 俗字")
     ("疽" . "등창 저")
     ("箸" . "젓가락 저")
     ("紵" . "모시 저")
     ("苧" . "모시 저")
     ("菹" . "김치 저, 푸서리 저")
     ("著" . "나타날 저, 널리 알려질 저, 글 지을 저, 옹저 저")
     ("藷" . "마 저, 감자 저")
     "詛"
     "諸"
     ("貯" . "쌓을 저, 감출 저, 둘 저")
     ("躇" . "머뭇거릴 저")
     ("這" . "맞을 저, 이것 저, 여기 저")
     ("邸" . "사처 저, 주막 저, 홀바탕 저, 병풍 저")
     ("雎" . "저구 저, 증경이 저, 원앙 저")
     ("齟" . "이 어긋날 저")
     ("宁" . "조회 받는 곳 저, 멈출 저")
     ("岨" . "돌산에 흙 덮일 저")
     ("杼" . "북 저, 도토리 저")
     ("柢" . "뿌리 저")
     ("氐" . "낮을 저, 오랑캐 이름 저, 이를 저, 근본 저, 별이름 저")
     ("潴" . "瀦와 同字")
     ("瀦" . "물 괼 저, 못 저")
     ("牴" . "찌를 저, 대강 저, 씨름 저, 당할 저")
     ("罝" . "짐승 그물 저")
     ("羝" . "숫양 저")
     "芧"
     ("苴" . "암삼 저, 꾸러미 저, 대지팡이 저, 신바닥 저")
     ("蛆" . "구더기 저, 지네 저")
     ("袛" . "속적삼 저")
     ("褚" . "주머니 저, 쌓을 저, 옷에 솜 둘 저")
     ("觝" . "찌를 저, 받을 저, 씨름 저")
     ("詆" . "꾸짖을 저, 알소할 저, 비방할 저")
     ("豬" . "돼지 저, 물이 괼 저, 못이름 저")
     ("陼" . "모래섬 저, 둔덕 저, 언덕 저"))
    ("저가"
     "低價")
    ("저가격"
     "低價格")
    ("저가품"
     "低價品")
    ("저간"
     "這間")
    ("저감"
     "低減")
    ("저개발"
     "低開發")
    ("저격"
     "狙擊")
    ("저격당"
     "狙擊當")
    ("저격범"
     "狙擊犯")
    ("저곡가"
     "低穀價")
    ("저공비행"
     "低空飛行")
    ("저공해"
     "低公害")
    ("저금"
     "貯金")
    ("저금통"
     "貯金筒")
    ("저금통장"
     "貯金通帳")
    ("저급"
     "低級")
    ("저기압"
     "低氣壓")
    ("저기압권"
     "低氣壓圈")
    ("저기압부"
     "低氣壓部")
    ("저농산물"
     "低農産物")
    ("저농산품"
     "低農産品")
    ("저농약"
     "低農藥")
    ("저능아"
     "低能兒")
    ("저단백"
     "低蛋白")
    ("저당"
     "抵當")
    ("저돌성"
     "猪突性")
    ("저두평신"
     "低頭平身")
    ("저력"
     "底力")
    ("저력지재"
     "樗櫟之材")
    ("저렴"
     "低廉")
    ("저리"
     "低利")
    ("저면"
     "底面")
    ("저명"
     "著名")
    ("저명인사"
     "著名人士")
    ("저반"
     "底盤")
    ("저번"
     "這番")
    ("저변"
     "底邊")
    ("저변층"
     "底邊層")
    ("저비용"
     "低費用")
    ("저산성"
     "低山性")
    ("저산소"
     "低酸素")
    ("저산소증"
     "低酸素症")
    ("저상"
     "沮喪")
    ("저서"
     "著書")
    ("저서성"
     "底棲性")
    ("저성장"
     "低成長")
    ("저소득"
     "低所得")
    ("저소득층"
     "低所得層")
    ("저속"
     "低俗"
     "低速")
    ("저속화"
     "低俗化")
    ("저수"
     "貯水")
    ("저수량"
     "貯水量")
    ("저수지"
     "貯水池")
    ("저수하심"
     "低首下心")
    ("저술"
     "著述")
    ("저술가"
     "著述家")
    ("저액"
     "低額")
    ("저열"
     "低劣")
    ("저예산"
     "低豫算")
    ("저오염"
     "低汚染")
    ("저온"
     "低溫")
    ("저위"
     "低位")
    ("저유소"
     "貯油所")
    ("저유지"
     "貯油地")
    ("저음"
     "低音")
    ("저음계"
     "低音階")
    ("저의"
     "底意")
    ("저임"
     "低賃")
    ("저임금"
     "低賃金")
    ("저자"
     "著者")
    ("저자세"
     "低姿勢")
    ("저작"
     "著作")
    ("저작권"
     "著作權")
    ("저작권성"
     "著作權性")
    ("저작권자"
     "著作權者")
    ("저작물"
     "著作物")
    ("저작물성"
     "著作物性")
    ("저작자"
     "著作者")
    ("저장"
     "貯藏")
    ("저장고"
     "貯藏庫")
    ("저장법"
     "貯藏法")
    ("저장성"
     "貯藏性")
    ("저장소"
     "貯藏所")
    ("저장판"
     "貯藏板")
    ("저조"
     "低調")
    ("저주"
     "紵紬"
     "詛呪")
    ("저주가"
     "低株價")
    ("저준위"
     "低準位")
    ("저지"
     "低地"
     "沮止")
    ("저지대"
     "低地帶")
    ("저지방"
     "低脂肪")
    ("저지선"
     "沮止線")
    ("저질"
     "低質")
    ("저질성"
     "低質性")
    ("저질화"
     "低質化")
    ("저체중아"
     "低體重兒")
    ("저촉"
     "抵觸")
    ("저축"
     "貯蓄")
    ("저축률"
     "貯蓄率")
    ("저축성"
     "貯蓄性")
    ("저축액"
     "貯蓄額")
    ("저택"
     "邸宅")
    ("저평"
     "低平")
    ("저포"
     "紵布")
    ("저하"
     "低下"
     "邸下")
    ("저하론"
     "低下論")
    ("저하제"
     "低下劑")
    ("저학년"
     "低學年")
    ("저항"
     "抵抗")
    ("저항권"
     "抵抗權")
    ("저항기"
     "抵抗器")
    ("저항라"
     "紵亢羅")
    ("저항력"
     "抵抗力")
    ("저항선"
     "抵抗線")
    ("저항적"
     "抵抗的")
    ("저해"
     "沮害")
    ("저혈압"
     "低血壓")
    ("저효율"
     "低效率")
    ("저효율성"
     "低效率性")
    ("적"
     ("勣" . "공적 적, 사업 적")
     ("嫡" . "정실 적, 맏아들 적")
     ("寂" . "고요할 적, 쓸쓸할 적")
     ("摘" . "딸 적, 돋구어낼 적, 움직일 적")
     ("敵" . "대적할 적, 원수 적, 무리 적, 막을 적")
     ("滴" . "물방울 적, 물 댈 적")
     ("狄" . "북방 오랑캐 적, 꿩 그린 옷 적, 멀 적")
     ("的" . "과녁 적, 꼭 그러할 적, 밝을 적")
     ("積" . "포갤 적, 모을 적, 넓이 적, 부피 적")
     ("笛" . "피리 적, 날라리 적")
     ("籍" . "문서 적, 왁자할 적, 호적 적, 압수할 적, 임금이 가는 밭 적")
     ("績" . "길쌈 적, 공 적, 이룰 적, 이을 적")
     ("翟" . "꿩의 깃 적, 황후의 옷 적")
     ("荻" . "갈대 적")
     ("藉" . "어수선할 적, 확자할 적, 임금이 가는 밭 적")
     ("謫" . "귀양갈 적, 꾸짖을 적")
     ("賊" . "도적 적, 해칠 적")
     ("赤" . "붉을 적, 금치 적")
     ("跡" . "자취 적")
     ("蹟" . "행적 적, 자취 적")
     ("迪" . "나아갈 적, 순할 적, 열어줄 적")
     ("迹" . "발자국 적, 자취 적, 뒤따를 적")
     ("適" . "맞갖을 적, 편안할 적, 깨달을 적, 시집갈 적, 좇을 적, 주장할 적")
     ("鏑" . "화살촉 적")
     ("炙" . "고기구이 적, 김 쏘일 적, 냄새 퍼질 적")
     "幘"
     ("樀" . "추녀 적, 도토마리 적, 방망이 적")
     ("磧" . "돌무더기 적, 모래벌 적")
     ("糴" . "쌀 사들일 적, 빠를 적")
     ("菂" . "연밥 적")
     ("覿" . "볼 적")
     ("逖" . "멀 적")
     ("馰" . "별배기 적, 소태성 적"))
    ("적갈색"
     "赤褐色")
    ("적개심"
     "敵愾心")
    ("적격"
     "適格")
    ("적격성"
     "適格性")
    ("적공"
     "積功")
    ("적공담"
     "積功談")
    ("적구독설"
     "赤口毒舌")
    ("적구지병"
     "適口之餠")
    ("적국"
     "敵國")
    ("적군"
     "敵軍"
     "赤軍")
    ("적군파"
     "赤軍派")
    ("적극"
     "積極")
    ("적극성"
     "積極性")
    ("적극적"
     "積極的")
    ("적극화"
     "積極化")
    ("적금"
     "積金"
     "赤錦")
    ("적기"
     "敵旗"
     "敵機"
     "適期")
    ("적나라"
     "赤裸裸")
    ("적년누월"
     "積年累月")
    ("적당"
     "適當")
    ("적당량"
     "適當量")
    ("적대"
     "敵對")
    ("적대감"
     "敵對感")
    ("적대국"
     "敵對國")
    ("적대시"
     "敵對視")
    ("적대자"
     "敵對者")
    ("적대적"
     "敵對的")
    ("적도"
     "赤道")
    ("적도제"
     "赤道祭")
    ("적립"
     "積立")
    ("적막"
     "寂寞")
    ("적멸"
     "寂滅")
    ("적멸감"
     "寂滅感")
    ("적멸보궁"
     "寂滅寶宮")
    ("적반하장"
     "賊反荷杖")
    ("적발"
     "摘發")
    ("적법"
     "適法")
    ("적부"
     "適否")
    ("적부심"
     "適否審")
    ("적분"
     "積分")
    ("적빈여세"
     "赤貧如洗")
    ("적산"
     "敵産")
    ("적색"
     "敵色"
     "赤色")
    ("적색형"
     "赤色型")
    ("적선"
     "敵船"
     "積善")
    ("적선여경"
     "積善餘慶")
    ("적설량"
     "積雪量")
    ("적성"
     "敵性"
     "適性")
    ("적성국"
     "敵性國")
    ("적소"
     "適所")
    ("적소성대"
     "積小成大")
    ("적수"
     "敵手")
    ("적수공권"
     "赤手空拳")
    ("적수성가"
     "赤手成家")
    ("적수성연"
     "積水成淵")
    ("적시"
     "摘示"
     "適時")
    ("적시타"
     "適時打")
    ("적신"
     "積薪")
    ("적신지탄"
     "積薪之嘆")
    ("적신호"
     "赤信號")
    ("적실"
     "嫡室"
     "的實")
    ("적실성"
     "適實性")
    ("적악여앙"
     "積惡餘殃")
    ("적여구산"
     "積如邱山")
    ("적역"
     "適役")
    ("적연부동"
     "寂然不動")
    ("적외선"
     "赤外線")
    ("적용"
     "適用")
    ("적우침주"
     "積羽沈舟")
    ("적원심노"
     "積怨深怒")
    ("적응"
     "適應")
    ("적응감"
     "適應感")
    ("적응력"
     "適應力")
    ("적응성"
     "適應性")
    ("적의"
     "敵意"
     "適宜")
    ("적의성"
     "敵意性")
    ("적일"
     "適日")
    ("적임"
     "適任")
    ("적임자"
     "適任者")
    ("적자"
     "嫡子"
     "赤字"
     "適者")
    ("적자국"
     "赤字國")
    ("적자생존"
     "適者生存")
    ("적자지심"
     "赤子之心")
    ("적장"
     "敵將")
    ("적장자"
     "嫡長子")
    ("적재"
     "積載"
     "適材")
    ("적재량"
     "積載量")
    ("적재적소"
     "適材適所")
    ("적재함"
     "積載函")
    ("적적"
     "寂寂")
    ("적절"
     "適切")
    ("적정"
     "適正")
    ("적정선"
     "適正線")
    ("적정성"
     "適正性")
    ("적정화"
     "適正化")
    ("적중"
     "的中")
    ("적지"
     "敵地"
     "適地")
    ("적진"
     "敵陣")
    ("적채"
     "赤菜")
    ("적체"
     "積滯")
    ("적출관문"
     "賊出關門")
    ("적토마"
     "赤兎馬")
    ("적토성산"
     "積土成山")
    ("적폐"
     "積弊")
    ("적합"
     "適合")
    ("적합성"
     "適合性")
    ("적혈"
     "赤血")
    ("적화"
     "赤化")
    ("적확"
     "的確")
    ("적환장"
     "積換場")
    ("전"
     ("佃" . "밭 맬 전, 머슴꾼 전, 사냥할 전")
     ("傳" . "전할 전, 펼 전, 이을 전, 주막 전, 책 전")
     ("全" . "온전할 전, 갖출 전")
     ("典" . "책 전, 법 전, 맡을 전, 도덕 전")
     ("前" . "앞 전, 옛 전, 인도할 전")
     ("剪" . "가위 전")
     ("塡" . "메일 전, 북소리 전, 순종할 전, 병들 전")
     ("塼" . "벽돌 전")
     ("奠" . "정할 전")
     ("專" . "오로지 전")
     ("展" . "펼칠 전, 열릴 전, 살필 전")
     ("廛" . "전방 전, 터전 전")
     ("悛" . "고칠 전, 차례 전")
     ("戰" . "싸움 전, 경쟁할 전")
     ("栓" . "말뚝 전")
     ("殿" . "대궐 전")
     ("氈" . "단자리 전, 전방석 전")
     "淀"
     ("澱" . "찌끼 전, 물 고일 전")
     ("煎" . "달일 전, 불에 말릴 전")
     "琠"
     ("田" . "밭 전, 사냥할 전, 논 전")
     ("甸" . "경기 전")
     ("畑" . "화전 전, 밭 전")
     ("癲" . "미칠 전")
     ("筌" . "통발 전")
     ("箋" . "기록할 전, 글 전")
     ("箭" . "화살 전, 약이름 전")
     ("篆" . "문체이름 전")
     ("纏" . "둘릴 전, 묶을 전, 얽을 전")
     ("詮" . "평론할 전, 갖출 전")
     ("輾" . "돌아 누울 전")
     ("轉" . "구를 전, 변할 전, 굴릴 전")
     ("鈿" . "비녀 전, 보배로 꾸민 그릇 전")
     ("銓" . "사람 가릴 전, 저울질할 전")
     ("錢" . "돈 전, 가래 전")
     ("鐫" . "새길 전")
     "雋"
     ("電" . "번개 전, 전기 전")
     ("顚" . "이마 전, 엎드러질 전")
     ("顫" . "사지 떨릴 전, 머리 비뚤이 전")
     ("餞" . "전별잔치 전, 보낼 전")
     ("吮" . "빨 전")
     ("囀" . "새 지저귈 전, 후렴 전")
     ("嫥" . "아름다울 전")
     ("屇" . "구멍 전")
     ("巓" . "산 꼭대기 전")
     "戔"
     "戩"
     ("揃" . "가를 전, 자를 전, 가지런히 할 전")
     ("旃" . "기 전, 말 그칠 전")
     ("栴" . "향나무 전")
     "槇"
     ("湔" . "빨 전, 씻을 전, 물 번질 전")
     ("澶" . "물이름 전")
     ("牋" . "글 전, 표 전, 문체이름 전")
     ("瑱" . "귀막이옥 전, 옥이름 전")
     ("甎" . "벽돌 전, 기와 전")
     ("畋" . "사냥할 전")
     ("畠" . "밭 전")
     ("痊" . "병 나을 전")
     ("癜" . "어루러기 전")
     ("磚" . "벽돌 전, 기와 전")
     ("籛" . "성씨 전")
     "縳"
     ("羶" . "노린내날 전")
     ("翦" . "베어 없앨 전, 멸할 전")
     ("腆" . "두터울 전, 지극할 전, 많이 차려놓을 전")
     ("膞" . "썰 전, 질그릇 만드는 틀 전")
     ("荃" . "향풀 전, 전풀 전")
     ("躔" . "햇길 전, 별자리 전")
     ("輇" . "달 전, 잴 전")
     ("邅" . "머뭇거릴 전")
     ("鄽" . "가게 전")
     "鋑"
     ("錪" . "솥 전, 쇠 전")
     ("靛" . "푸른 대 전")
     ("靦" . "무안할 전, 물끄러미 볼 전")
     ("顓" . "어리석을 전, 오로지 전")
     ("飦" . "범벅 전, 된죽 전")
     ("餰" . "된죽 전")
     ("鬋" . "수염 깎을 전, 귀밑 털 드릴 전")
     ("鱣" . "전어 전")
     ("鸇" . "구진매 전"))
    ("전가"
     "傳家"
     "轉嫁")
    ("전가지보"
     "傳家之寶")
    ("전각"
     "殿閣")
    ("전갈"
     "傳喝")
    ("전갈자"
     "全갈@")
    ("전개"
     "展開")
    ("전개형"
     "展開型")
    ("전객제"
     "田客制")
    ("전격"
     "電擊")
    ("전격적"
     "電擊的")
    ("전경"
     "全景"
     "前景"
     "戰警")
    ("전공"
     "前功"
     "專攻"
     "戰功")
    ("전공과목"
     "專攻科目")
    ("전공의"
     "專攻醫")
    ("전공자"
     "專攻者")
    ("전과"
     "前科")
    ("전과자"
     "前科者")
    ("전관"
     "全館"
     "前官")
    ("전광석화"
     "電光石火")
    ("전광판"
     "電光板")
    ("전교"
     "全校")
    ("전교생"
     "全校生")
    ("전구"
     "電球")
    ("전국"
     "全國"
     "戰國")
    ("전국구"
     "全國區")
    ("전국적"
     "全國的")
    ("전국화"
     "全國化")
    ("전군"
     "全軍")
    ("전권"
     "全權"
     "專權"
     "田券")
    ("전근"
     "轉勤")
    ("전근대"
     "前近代")
    ("전근대적"
     "前近代的")
    ("전기"
     "傳記"
     "前期"
     "前記"
     "轉機"
     "電氣")
    ("전기공"
     "電氣工")
    ("전기과"
     "電氣科")
    ("전기동"
     "電氣銅")
    ("전기선"
     "電氣線")
    ("전기적"
     "前期的")
    ("전깃"
     "電氣")
    ("전년"
     "前年")
    ("전년도"
     "前年度")
    ("전념"
     "專念")
    ("전농"
     "田農")
    ("전뇌"
     "電腦")
    ("전능"
     "全能")
    ("전단"
     "傳單")
    ("전단물"
     "傳單物")
    ("전달"
     "傳達")
    ("전달식"
     "傳達式")
    ("전담"
     "專擔")
    ("전담반"
     "全擔班")
    ("전답"
     "田畓")
    ("전당"
     "全黨"
     "殿堂")
    ("전당포"
     "典當鋪")
    ("전대"
     "前代"
     "纏帶")
    ("전대미문"
     "前代未聞")
    ("전도"
     "傳導"
     "傳道"
     "全圖"
     "奠都"
     "顚倒")
    ("전도사"
     "傳道師")
    ("전도양양"
     "前途洋洋")
    ("전도유망"
     "前途有望")
    ("전도율"
     "傳導率")
    ("전동"
     "傳棟")
    ("전동기"
     "電動機")
    ("전동식"
     "電動式")
    ("전동차"
     "電動車")
    ("전등"
     "電燈")
    ("전라"
     "全裸")
    ("전라도"
     "全羅道")
    ("전락"
     "轉落")
    ("전란"
     "戰亂")
    ("전람회"
     "展覽會")
    ("전래"
     "傳來")
    ("전략"
     "戰略")
    ("전략기"
     "戰略期")
    ("전략적"
     "戰略的")
    ("전량"
     "全量")
    ("전력"
     "全力"
     "前歷"
     "專力"
     "戰力"
     "電力")
    ("전력난"
     "電力難")
    ("전력량"
     "電力量")
    ("전력자"
     "前歷者")
    ("전력투구"
     "全力投球")
    ("전령"
     "傳令")
    ("전령사"
     "傳令使")
    ("전례"
     "前例")
    ("전류"
     "電流")
    ("전류기"
     "電流機")
    ("전리품"
     "戰利品")
    ("전립선암"
     "前立腺癌")
    ("전말"
     "顚末")
    ("전말기"
     "顚末記")
    ("전말서"
     "顚末書")
    ("전망"
     "展望")
    ("전망대"
     "展望臺")
    ("전망치"
     "展望値")
    ("전매"
     "專賣")
    ("전매제"
     "專賣制")
    ("전면"
     "全面"
     "前面")
    ("전면적"
     "全面的")
    ("전면전"
     "全面戰")
    ("전면화"
     "全面化")
    ("전멸"
     "全滅")
    ("전모"
     "全貌")
    ("전무"
     "全無"
     "專務")
    ("전무이사"
     "專務理事")
    ("전무후무"
     "前無後無")
    ("전문"
     "全文"
     "專門"
     "電文")
    ("전문가"
     "專門家")
    ("전문대"
     "專門大")
    ("전문대입"
     "專門大入")
    ("전문대졸"
     "專門大卒")
    ("전문대학"
     "專門大學")
    ("전문서"
     "專門書")
    ("전문성"
     "專門性")
    ("전문업자"
     "專門業者")
    ("전문의"
     "專門醫")
    ("전문인"
     "專門人")
    ("전문적"
     "專門的")
    ("전문점"
     "專門店")
    ("전문지"
     "專門誌")
    ("전문직"
     "專門職")
    ("전문화"
     "專門化")
    ("전민변정"
     "田民辨整")
    ("전반"
     "全般"
     "前半")
    ("전반기"
     "前半期")
    ("전반부"
     "前半部")
    ("전반적"
     "全般的")
    ("전반전"
     "前半戰")
    ("전방"
     "全方"
     "前方"
     "廛房")
    ("전번"
     "前番")
    ("전범"
     "戰犯")
    ("전범자"
     "戰犯者")
    ("전법"
     "戰法")
    ("전별"
     "餞別")
    ("전별금"
     "餞別金")
    ("전병"
     "煎餠")
    ("전보"
     "轉補"
     "電報")
    ("전복"
     "全鰒"
     "顚覆")
    ("전복적"
     "顚覆的")
    ("전복죽"
     "全鰒粥")
    ("전복후계"
     "前覆後戒")
    ("전봇"
     "電報")
    ("전부"
     "全部")
    ("전부지공"
     "田父之功")
    ("전분"
     "澱粉")
    ("전불습호"
     "傳不習乎")
    ("전비"
     "戰費")
    ("전사"
     "戰史"
     "戰士"
     "戰死"
     "轉寫")
    ("전산"
     "電算")
    ("전산과"
     "電算科")
    ("전산망"
     "電算網")
    ("전산실"
     "電算室")
    ("전산실장"
     "電算室長")
    ("전산학"
     "電算學")
    ("전산학부"
     "電算學部")
    ("전산화"
     "電算化")
    ("전상자"
     "戰傷者")
    ("전생"
     "前生"
     "轉生")
    ("전서"
     "全書")
    ("전석지"
     "轉石地")
    ("전선"
     "前線"
     "戰線"
     "戰船"
     "電線")
    ("전설"
     "傳說")
    ("전설적"
     "傳說的")
    ("전성"
     "全盛")
    ("전성기"
     "全盛期")
    ("전성시대"
     "全盛時代")
    ("전세"
     "傳貰"
     "專貰"
     "戰勢")
    ("전세금"
     "傳貰金")
    ("전세기"
     "傳貰機"
     "前世紀")
    ("전세방"
     "傳貰房")
    ("전셋"
     "傳貰")
    ("전소"
     "全燒")
    ("전속"
     "全速"
     "專屬")
    ("전속권"
     "專屬權")
    ("전속력"
     "全速力")
    ("전송"
     "傳送"
     "電送"
     "餞送")
    ("전송망"
     "電送網")
    ("전수"
     "傳受"
     "傳授")
    ("전수생"
     "傳受生")
    ("전술"
     "前述"
     "戰術")
    ("전술적"
     "戰術的")
    ("전승"
     "傳乘"
     "傳承"
     "全勝"
     "戰勝")
    ("전승국"
     "戰勝國")
    ("전승성"
     "傳乘性")
    ("전시"
     "展示"
     "戰時"
     "電示")
    ("전시과"
     "田柴科")
    ("전시관"
     "展示館")
    ("전시대"
     "展示臺")
    ("전시물"
     "展示物")
    ("전시실"
     "展示室")
    ("전시장"
     "展示場")
    ("전시품"
     "展示品")
    ("전시회"
     "展示會")
    ("전신"
     "全身"
     "前身"
     "電信")
    ("전신기"
     "電信機")
    ("전신주"
     "電信柱")
    ("전실"
     "前室")
    ("전심전력"
     "全心全力"
     "專心專力")
    ("전압"
     "電壓")
    ("전액"
     "全額")
    ("전야"
     "前夜")
    ("전야제"
     "前夜祭")
    ("전어"
     "錢魚")
    ("전언"
     "傳言")
    ("전업"
     "專業"
     "轉業")
    ("전업농"
     "專業農")
    ("전업적"
     "專業的")
    ("전역"
     "全域"
     "戰役"
     "轉役")
    ("전역서"
     "轉役書")
    ("전역식"
     "轉役式")
    ("전역자"
     "轉役者")
    ("전연"
     "全然")
    ("전열"
     "戰列")
    ("전염"
     "傳染")
    ("전염병"
     "傳染病")
    ("전염성"
     "傳染性")
    ("전영"
     "電影")
    ("전왕"
     "前王")
    ("전용"
     "專用"
     "轉用")
    ("전용관"
     "專用館")
    ("전용식"
     "專用食")
    ("전우"
     "戰友")
    ("전원"
     "全員"
     "田園"
     "電源")
    ("전원도시"
     "田園都市")
    ("전원주택"
     "田園住宅")
    ("전위"
     "前衛")
    ("전위성"
     "前衛性")
    ("전위적"
     "前衛的")
    ("전유"
     "專有")
    ("전유물"
     "專有物")
    ("전율"
     "戰慄"
     "戰慄")
    ("전이"
     "轉移")
    ("전이성"
     "轉移性")
    ("전인"
     "全人")
    ("전인격"
     "全人格")
    ("전인격적"
     "全人格的")
    ("전인미답"
     "前人未踏")
    ("전인미발"
     "前人未發")
    ("전인성"
     "全人性")
    ("전인적"
     "全人的")
    ("전임"
     "前任"
     "專任")
    ("전임자"
     "前任者")
    ("전입"
     "轉入")
    ("전입금"
     "轉入金")
    ("전입자"
     "轉入者")
    ("전자"
     "前者"
     "電子"
     "電磁")
    ("전자계산기"
     "電子計算機")
    ("전자기"
     "電磁氣")
    ("전자기력"
     "電磁氣力")
    ("전자기적"
     "電磁氣的")
    ("전자기파"
     "電磁氣波")
    ("전자동"
     "全自動")
    ("전자석"
     "電磁石")
    ("전자시계"
     "電子時計")
    ("전자식"
     "電子式")
    ("전자오락"
     "電子娛樂")
    ("전자오락실"
     "電子娛樂室")
    ("전자음"
     "電子音")
    ("전자적"
     "電子的")
    ("전자파"
     "電子波"
     "電磁波")
    ("전자화"
     "電子化")
    ("전작"
     "全作"
     "前作")
    ("전장"
     "全長"
     "前場"
     "戰場"
     "田莊")
    ("전장제"
     "田莊制")
    ("전장화"
     "田莊化")
    ("전재"
     "轉載")
    ("전쟁"
     "戰爭")
    ("전쟁무"
     "戰爭舞")
    ("전적"
     "全的"
     "典籍")
    ("전전"
     "前前"
     "戰前"
     "轉轉")
    ("전전긍긍"
     "戰戰兢兢")
    ("전전반측"
     "輾轉反側")
    ("전전자"
     "全電子")
    ("전절기"
     "全切機")
    ("전정"
     "剪定"
     "田丁")
    ("전제"
     "前提"
     "專制"
     "田制")
    ("전제국"
     "專制國")
    ("전제적"
     "專制的")
    ("전제주의"
     "專制主義")
    ("전조"
     "前兆"
     "田租")
    ("전조등"
     "前照燈")
    ("전조율"
     "田租率")
    ("전주"
     "全州"
     "前主"
     "錢主"
     "電柱")
    ("전주제"
     "田主制")
    ("전지"
     "剪枝"
     "電池")
    ("전지전능"
     "全知全能")
    ("전지훈련"
     "轉地訓鍊")
    ("전직"
     "前職"
     "轉職")
    ("전진"
     "前進"
     "前陣")
    ("전진적"
     "前進的")
    ("전집"
     "全集")
    ("전차"
     "電車")
    ("전처"
     "前妻")
    ("전천후"
     "全天候")
    ("전철"
     "前轍"
     "電鐵")
    ("전철망"
     "電鐵網")
    ("전철역"
     "電鐵驛")
    ("전첨후고"
     "前瞻後顧")
    ("전체"
     "傳遞"
     "全體")
    ("전체성"
     "全體性")
    ("전체적"
     "全體的")
    ("전체주의"
     "全體主義")
    ("전체주의적"
     "全體主義的")
    ("전체주의화"
     "全體主義化")
    ("전체화"
     "全體化")
    ("전초"
     "前哨")
    ("전초적"
     "前哨的")
    ("전초전"
     "前哨戰")
    ("전축"
     "電蓄")
    ("전출"
     "轉出")
    ("전취"
     "戰取")
    ("전치"
     "全治")
    ("전토"
     "全土")
    ("전통"
     "傳統"
     "傳通")
    ("전통극"
     "傳統劇")
    ("전통문화"
     "傳統文化")
    ("전통미"
     "傳統美")
    ("전통복"
     "傳統服")
    ("전통성"
     "傳統性")
    ("전통적"
     "傳統的")
    ("전통주의"
     "傳統主義")
    ("전통형"
     "傳統型")
    ("전투"
     "戰鬪")
    ("전투기"
     "戰鬪機")
    ("전투력"
     "戰鬪力")
    ("전투복"
     "戰鬪服")
    ("전투성"
     "戰鬪性")
    ("전투적"
     "戰鬪的")
    ("전파"
     "傳播"
     "全波"
     "電波")
    ("전파자"
     "傳播者")
    ("전편"
     "全篇"
     "前篇")
    ("전폐"
     "全廢")
    ("전폭"
     "全幅")
    ("전폭기"
     "戰爆機")
    ("전폭적"
     "全幅的")
    ("전표"
     "傳票"
     "錢票")
    ("전하"
     "殿下"
     "電荷")
    ("전학"
     "轉學")
    ("전함"
     "戰艦")
    ("전해질액"
     "電解質液")
    ("전향"
     "轉向")
    ("전향서"
     "轉向書")
    ("전향적"
     "前向的")
    ("전형"
     "典型"
     "銓衡")
    ("전형성"
     "典型性")
    ("전형적"
     "典型的")
    ("전호"
     "佃戶")
    ("전호적"
     "佃戶的")
    ("전호제"
     "佃戶制")
    ("전호제적"
     "佃戶制的")
    ("전화"
     "轉化"
     "電話")
    ("전화국"
     "電話局")
    ("전화기"
     "電話機")
    ("전화론자"
     "轉化論者")
    ("전화망"
     "電話網")
    ("전화번호"
     "電話番號")
    ("전화번호부"
     "電話番號簿")
    ("전화비"
     "電話費")
    ("전화선"
     "電話線")
    ("전화위복"
     "轉禍爲福")
    ("전화통"
     "電話筒")
    ("전환"
     "轉換")
    ("전환기"
     "轉換期")
    ("전환점"
     "轉換點")
    ("전황"
     "戰況")
    ("전획물"
     "戰獲物")
    ("전횡"
     "專橫")
    ("전후"
     "前後"
     "戰後")
    ("전후사"
     "前後事")
    ("전후좌우"
     "前後左右")
    ("전희"
     "前戱")
    ("절"
     ("切" . "끊을 절, 저밀 절, 정성스럴 절, 급할 절, 진맥할 절")
     ("截" . "끊을 절, 말 잘할 절")
     ("折" . "꺾을 절, 자를 절, 휘일 절, 알맞을 절")
     ("浙" . "쌀 씻을 절, 물이름 절")
     ("癤" . "멍울 절, 부스럼 절")
     ("竊" . "좀도둑 절, 얕을 절")
     ("節" . "마디 절, 절개 절")
     ("絶" . "絕과 同字")
     ("岊" . "산 모퉁이 우뚝 내밀 절")
     ("晢" . "밝을 절, 비칠 절")
     ("窃" . "竊의 俗字")
     "軼")
    ("절감"
     "切感"
     "節減")
    ("절감액"
     "節減額")
    ("절감책"
     "節減策")
    ("절개"
     "切開"
     "節槪")
    ("절개선"
     "切開線")
    ("절경"
     "絶景")
    ("절골지통"
     "折骨之痛")
    ("절규"
     "絶叫")
    ("절급"
     "折給")
    ("절기"
     "節氣")
    ("절단"
     "切斷"
     "絶斷")
    ("절단기"
     "切斷機")
    ("절단당"
     "切斷當")
    ("절단선"
     "切斷線")
    ("절대"
     "絶對")
    ("절대다수"
     "絶對多數")
    ("절대성"
     "絶對性")
    ("절대시"
     "絶對視")
    ("절대액"
     "絶對額")
    ("절대적"
     "絶對的")
    ("절대정신"
     "絶對精神")
    ("절대지"
     "絶對知")
    ("절대화"
     "絶對化")
    ("절도"
     "竊盜"
     "節度")
    ("절도단"
     "竊盜團")
    ("절도범"
     "竊盜犯")
    ("절도사"
     "節度使")
    ("절도죄"
     "竊盜罪")
    ("절륜이륜"
     "絶倫離倫")
    ("절리"
     "節理")
    ("절리곡"
     "節理谷")
    ("절망"
     "絶望")
    ("절망감"
     "絶望感")
    ("절망적"
     "絶望的")
    ("절멸"
     "絶滅")
    ("절묘"
     "絶妙")
    ("절박"
     "切迫")
    ("절박감"
     "切迫感")
    ("절박성"
     "切迫性")
    ("절반"
     "折半")
    ("절벽"
     "絶壁")
    ("절상"
     "切上")
    ("절세가인"
     "絶世佳人")
    ("절세미인"
     "絶世美人")
    ("절식"
     "節食")
    ("절실"
     "切實")
    ("절실성"
     "切實性")
    ("절약"
     "節約")
    ("절약적"
     "節約的")
    ("절약책"
     "節約策")
    ("절약형"
     "節約型")
    ("절연"
     "絶緣")
    ("절장보단"
     "絶長補短")
    ("절절"
     "切切")
    ("절정"
     "絶頂")
    ("절정기"
     "絶頂期")
    ("절제"
     "切除"
     "節制")
    ("절제감"
     "節制感")
    ("절주"
     "節酒")
    ("절지"
     "切紙")
    ("절차"
     "節次")
    ("절차법"
     "節次法")
    ("절차적"
     "節次的")
    ("절차탁마"
     "切磋琢磨")
    ("절창"
     "絶唱")
    ("절처봉생"
     "絶處逢生")
    ("절충"
     "折衝"
     "折衷")
    ("절충안"
     "折衷案")
    ("절충적"
     "折衝的")
    ("절충주의적"
     "折衷主義的")
    ("절치부심"
     "切齒腐心")
    ("절친"
     "切親")
    ("절통"
     "切痛")
    ("절하"
     "切下")
    ("절함"
     "折檻")
    ("절해"
     "絶海")
    ("절해고도"
     "絶海孤島")
    ("점"
     ("占" . "점칠 점, 날씨 볼 점, 점령할 점")
     ("岾" . "고개 점")
     ("店" . "가게 점, 주막 점")
     "拈"
     ("漸" . "번질 점, 물 흘러 들어갈 점, 점점 점, 차차 점")
     ("点" . "點의 略字")
     ("粘" . "붙일 점, 끈끈할 점")
     ("霑" . "젖을 점, 비 지정거릴 점")
     ("鮎" . "메기 점")
     ("點" . "더러울 점, 뭉갤 점, 검은 점 점")
     ("佔" . "엿볼 점, 숙일 점")
     ("墊" . "빠질 점, 축축할 점")
     ("玷" . "옥의 티 점, 흠각 점")
     "笘"
     ("簟" . "삿자리 점, 대 이름 점")
     ("苫" . "이엉 점, 거적자리 점, 글씨 흘려 쓸 점")
     ("蔪" . "풀 벨 점, 보리 팰 점")
     "蛅"
     "覘"
     ("颭" . "펄렁거릴 점")
     ("黏" . "붙일 점, 풀 점"))
    ("점거"
     "占據")
    ("점검"
     "點檢")
    ("점검당"
     "點檢當")
    ("점검제"
     "點檢制")
    ("점고"
     "漸高")
    ("점괘"
     "占卦")
    ("점내"
     "店內")
    ("점령"
     "占領")
    ("점령군"
     "占領軍")
    ("점령지"
     "占領地")
    ("점막"
     "粘膜")
    ("점멸"
     "點滅")
    ("점사"
     "點射")
    ("점선"
     "點線")
    ("점성술"
     "占星術")
    ("점소"
     "店所")
    ("점수"
     "漸修"
     "點數")
    ("점수제"
     "點數制")
    ("점수화"
     "點數化")
    ("점술"
     "占術")
    ("점심"
     "點心")
    ("점심시간"
     "點心時間")
    ("점원"
     "店員")
    ("점유"
     "占有")
    ("점유율"
     "占有率")
    ("점유지"
     "占有地")
    ("점이"
     "漸移")
    ("점이적"
     "漸移的")
    ("점입가경"
     "漸入佳境")
    ("점자"
     "點字")
    ("점장"
     "店長")
    ("점점"
     "漸漸"
     "點點")
    ("점주"
     "店主")
    ("점증"
     "漸增")
    ("점증적"
     "漸增的")
    ("점진적"
     "漸進的")
    ("점차"
     "漸次")
    ("점차적"
     "漸次的")
    ("점철"
     "點綴")
    ("점토"
     "粘土")
    ("점토판"
     "粘土板")
    ("점포"
     "店鋪")
    ("점포망"
     "店鋪網")
    ("점호"
     "點呼")
    ("점화"
     "點火")
    ("접"
     ("接" . "사귈 접, 잇닿을 접")
     ("摺" . "접을 접, 패할 접")
     ("渫" . "물결 출렁출렁할 접")
     ("蝶" . "들나비 접")
     ("慴" . "두려울 접, 겁낼 접")
     "揲"
     ("椄" . "나무 접붙일 접, 형벌틀 접, 문설주 접")
     ("楪" . "널평상 접")
     "檝"
     ("蜨" . "나비 접")
     ("跕" . "미끄러질 접")
     ("蹀" . "저벅저벅 걸을 접")
     ("鰈" . "가자미 접, 넙치 접"))
    ("접객"
     "接客")
    ("접객업"
     "接客業")
    ("접객업소"
     "接客業所")
    ("접견"
     "接見")
    ("접견권"
     "接見權")
    ("접견실"
     "接見室")
    ("접견제"
     "接見制")
    ("접경"
     "接境")
    ("접골"
     "接骨")
    ("접골사"
     "接骨師")
    ("접근"
     "接近")
    ("접근권"
     "接近權")
    ("접근로"
     "接近路")
    ("접근법"
     "接近法")
    ("접대"
     "接待")
    ("접대부"
     "接待婦")
    ("접대원"
     "接待員")
    ("접두어"
     "接頭語")
    ("접례"
     "接禮")
    ("접목"
     "接木")
    ("접미사"
     "接尾辭")
    ("접변"
     "接變")
    ("접속"
     "接續")
    ("접속률"
     "接續率")
    ("접수"
     "接受"
     "接收")
    ("접수국"
     "接受國")
    ("접수일"
     "接收日")
    ("접수창구"
     "接受窓口")
    ("접신"
     "接神")
    ("접안"
     "接岸")
    ("접영"
     "蝶泳")
    ("접장"
     "接長")
    ("접적"
     "接敵")
    ("접전"
     "接戰")
    ("접종"
     "接種")
    ("접종력"
     "接種歷")
    ("접착"
     "接着")
    ("접착식"
     "接着式")
    ("접착제"
     "接着劑")
    ("접촉"
     "接觸")
    ("접촉률"
     "接觸率")
    ("접촉면"
     "接觸面")
    ("접촉성"
     "接觸性")
    ("접촉점"
     "接觸點")
    ("접촉제"
     "接觸劑")
    ("접합"
     "接合")
    ("접합점"
     "接合點")
    ("정"
     ("丁" . "장정 정, 네째 천간 정")
     ("井" . "우물 정, 단정할 정, 괘 이름 정, 천정 정, 저자 정")
     ("亭" . "정자 정, 여관 정, 고를 정")
     ("停" . "머무를 정, 늦어질 정")
     ("偵" . "엿볼 정, 정탐할 정, 물을 정")
     ("呈" . "보일 정, 드러낼 정")
     "姃"
     ("定" . "정할 정, 편안할 정, 고요할 정")
     ("幀" . "그림족자 정")
     ("庭" . "뜰 정, 곧을 정")
     ("廷" . "조정 정, 바를 정, 곧을 정")
     ("征" . "칠 정, 갈 정")
     ("情" . "뜻 정, 마음속 정")
     ("挺" . "빼어날 정, 너그러울 정, 향초이름 정")
     ("政" . "정사 정, 바르게 할 정, 조세 정")
     ("整" . "가지런할 정")
     ("旌" . "장목기 정, 표시할 정")
     ("晶" . "수정 정, 맑을 정, 빛날 정")
     "晸"
     ("柾" . "나무결 바를 정")
     ("楨" . "담틀 마구리대 정, 단단한 나무 정")
     ("檉" . "능수버들 정")
     ("正" . "바를 정, 과녁 정, 남쪽으로 난 창 정, 어른 정, 분별할 정")
     ("汀" . "물가 정, 수렁 정")
     ("淨" . "맑을 정, 조촐할 정")
     ("渟" . "물 고일 정, 도랑 정, 물가 정")
     ("湞" . "물이름 정")
     ("瀞" . "맑을 정, 정결할 정")
     ("炡" . "데칠 정, 불 번쩍거릴 정")
     ("玎" . "옥소리 정")
     ("珽" . "옥 이름 정")
     ("町" . "밭 두덕 정, 정보 정, 시가 정")
     ("睛" . "눈 검은자위 정, 눈동자 정")
     ("碇" . "닻돌 정, 배 멈출 정")
     ("禎" . "상서로울 정")
     ("程" . "법 정, 한정 정, 과정 정, 품수 정, 헤아릴 정, 길 정")
     ("穽" . "구덩이 정, 함정 정")
     ("精" . "정교할 정, 세밀할 정, 정할 정, 성실할 정, 신령 정")
     ("綎" . "띠술 정")
     ("艇" . "거룻배 정, 작은 배 정")
     "菁"
     ("訂" . "바로잡을 정, 의논할 정")
     "諪"
     ("貞" . "곧을 정, 굳을 정")
     ("鄭" . "나라이름 정, 성씨 정")
     ("酊" . "비틀거릴 정")
     ("釘" . "창 정, 못 정")
     ("鉦" . "징 정")
     ("鋌" . "화살촉 정, 달음박질할 정, 쇳덩이 정")
     ("錠" . "촛대 정")
     ("霆" . "벼락 정, 번개 정")
     ("靖" . "다스릴 정, 편안할 정, 생각할 정")
     ("靜" . "고요할 정, 조용할 정, 쉴 정, 편안할 정")
     ("頂" . "이마 정, 꼭대기 정, 관 꼭대기 치장하는 장식 정")
     "鯖"
     ("鼎" . "솥 정, 바야흐로 정, 새로울 정")
     ("佂" . "두려워할 정")
     ("叮" . "단단히 부탁할 정, 정성스러울 정")
     "婧"
     ("婷" . "아리따울 정, 쌀쌀할 정")
     ("怔" . "황겁할 정, 가슴 두근두근할 정")
     ("掟" . "둘러칠 정")
     ("桯" . "서안 정, 걸상 정")
     ("梃" . "외줄기 정, 막대 정, 꼿꼿할 정")
     ("棖" . "문설주 정, 막대 정")
     ("珵" . "노리개 정, 패옥 정")
     "琤"
     ("疔" . "헌데 정")
     ("筳" . "대쪽 정")
     ("莛" . "풀 줄거리 정, 들보 정")
     ("証" . "간할 정")
     ("遉" . "순라군 정, 염탐할 정")
     ("酲" . "술병 정, 술 깰 정")
     "鋥"
     ("靚" . "단장할 정, 밝을 정"))
    ("정가"
     "定價"
     "政街")
    ("정가표"
     "定價票")
    ("정각"
     "正刻"
     "正覺")
    ("정간"
     "井間")
    ("정간물"
     "定刊物")
    ("정감"
     "情感")
    ("정강"
     "政綱")
    ("정거장"
     "停車場")
    ("정견"
     "定見"
     "政見"
     "正見")
    ("정결"
     "淨潔")
    ("정경"
     "情景"
     "政經")
    ("정계"
     "政界")
    ("정곡"
     "正鵠")
    ("정공"
     "精工")
    ("정공법"
     "正攻法")
    ("정관"
     "定款"
     "精管"
     "靜觀")
    ("정관사"
     "定冠詞")
    ("정교"
     "政敎"
     "精巧")
    ("정교사"
     "正敎師")
    ("정교회"
     "正敎會")
    ("정구"
     "庭球")
    ("정구장"
     "庭球場")
    ("정구품"
     "正九品")
    ("정국"
     "政局")
    ("정궁"
     "正宮")
    ("정권"
     "政權")
    ("정권기"
     "政權期")
    ("정권론"
     "政權論")
    ("정권설"
     "政權說")
    ("정권적"
     "政權的")
    ("정규"
     "正規")
    ("정규군"
     "正規軍")
    ("정규직"
     "定規職")
    ("정규직화"
     "定規職化")
    ("정근"
     "精勤")
    ("정기"
     "定期"
     "精氣")
    ("정기적"
     "定期的")
    ("정기전"
     "定期戰")
    ("정낭"
     "精囊")
    ("정년"
     "停年")
    ("정년퇴직"
     "停年退職")
    ("정념"
     "情念"
     "正念")
    ("정념적"
     "情念的")
    ("정녕"
     "丁寧")
    ("정담"
     "情談")
    ("정답"
     "正答")
    ("정당"
     "政黨"
     "正當")
    ("정당방위"
     "正當防衛")
    ("정당성"
     "正當性")
    ("정당인"
     "政黨人")
    ("정당적"
     "政黨的")
    ("정당화"
     "正當化")
    ("정도"
     "定都"
     "正道"
     "程度")
    ("정독"
     "正讀"
     "精讀")
    ("정돈"
     "整頓")
    ("정돈성"
     "整頓性")
    ("정략"
     "政略")
    ("정략적"
     "政略的")
    ("정량"
     "定量")
    ("정량적"
     "定量的")
    ("정력"
     "精力")
    ("정력적"
     "精力的")
    ("정력제"
     "精力劑")
    ("정렬"
     "整列")
    ("정령"
     "精靈")
    ("정례"
     "定例")
    ("정례화"
     "定例化")
    ("정로"
     "正路")
    ("정론"
     "正論")
    ("정류장"
     "停留場")
    ("정리"
     "整理")
    ("정리함"
     "整理函")
    ("정립"
     "定立"
     "正立"
     "鼎立")
    ("정립적"
     "定立的")
    ("정맥"
     "靜脈")
    ("정면"
     "正面")
    ("정면성"
     "正面性")
    ("정면충돌"
     "正面衝突")
    ("정명"
     "正命")
    ("정묘"
     "丁卯")
    ("정무"
     "政務")
    ("정무직"
     "政務職")
    ("정문"
     "旌門"
     "正門")
    ("정문일침"
     "頂門一針")
    ("정물"
     "靜物")
    ("정물화"
     "靜物畵")
    ("정미"
     "精米")
    ("정미기"
     "精米機")
    ("정미소"
     "精米所")
    ("정밀"
     "精密")
    ("정밀도"
     "精密度")
    ("정밀성"
     "精密性")
    ("정밀적"
     "精密的")
    ("정박"
     "碇泊")
    ("정박세"
     "碇泊稅")
    ("정반대"
     "正反對")
    ("정방형"
     "正方形")
    ("정벌"
     "征伐")
    ("정범"
     "正犯")
    ("정법"
     "正法")
    ("정변"
     "政變")
    ("정보"
     "情報"
     "町步")
    ("정보과장"
     "情報課長")
    ("정보국장"
     "情報局長")
    ("정보기관"
     "情報機關")
    ("정보량"
     "情報量")
    ("정보망"
     "情報網")
    ("정보부"
     "情報部")
    ("정보부장"
     "情報部長")
    ("정보사"
     "情報司")
    ("정보서"
     "情報書")
    ("정보원"
     "情報員"
     "情報源")
    ("정보원망"
     "情報院網")
    ("정보은행"
     "情報銀行")
    ("정보적"
     "情報的")
    ("정보지"
     "情報誌")
    ("정보집"
     "情報集")
    ("정보화"
     "情報化")
    ("정복"
     "征服"
     "正服")
    ("정복당"
     "征服當")
    ("정복민"
     "征服民")
    ("정복자"
     "征服者")
    ("정복적"
     "征服的")
    ("정복지"
     "征服地")
    ("정부"
     "情夫"
     "情婦"
     "政府"
     "正否")
    ("정부관"
     "政府館")
    ("정부군"
     "政府軍")
    ("정부당"
     "政府黨")
    ("정부미"
     "政府米")
    ("정부안"
     "政府案")
    ("정부통령"
     "正副統領")
    ("정비"
     "整備")
    ("정비계"
     "整備係")
    ("정비사"
     "整備士")
    ("정비소"
     "整備所")
    ("정비업체"
     "整備業體")
    ("정비창"
     "整備廠")
    ("정비창장"
     "整備倉長")
    ("정사"
     "情事"
     "情死"
     "政事"
     "正思"
     "靜思")
    ("정사각형"
     "正四角形")
    ("정산"
     "精算")
    ("정상"
     "情狀"
     "正常"
     "頂上")
    ("정상급"
     "頂上級")
    ("정상배"
     "政商輩")
    ("정상성"
     "正常性")
    ("정상아"
     "正常兒")
    ("정상인"
     "正常人")
    ("정상적"
     "正常的")
    ("정상화"
     "正常化")
    ("정색"
     "正色")
    ("정생"
     "頂生")
    ("정서"
     "情緖")
    ("정서적"
     "情緖的")
    ("정석"
     "定石")
    ("정석적"
     "定石的")
    ("정설"
     "定說")
    ("정설화"
     "定說化")
    ("정성"
     "精誠")
    ("정세"
     "情勢"
     "政勢")
    ("정수"
     "定數"
     "正手"
     "精髓")
    ("정숙"
     "整肅"
     "貞淑"
     "靜肅")
    ("정승"
     "政丞")
    ("정시"
     "定時")
    ("정식"
     "定食"
     "正式")
    ("정식화"
     "定式化")
    ("정신"
     "井神"
     "挺身"
     "精神")
    ("정신과"
     "精神科")
    ("정신과장"
     "精神科長")
    ("정신과적"
     "精神科的")
    ("정신과학"
     "精神科學")
    ("정신권"
     "精神圈")
    ("정신노동"
     "精神勞動")
    ("정신노동자"
     "精神勞動者")
    ("정신대"
     "挺身隊")
    ("정신력"
     "精神力")
    ("정신문화"
     "精神文化")
    ("정신박약"
     "精神薄弱")
    ("정신박약아"
     "精神薄弱兒")
    ("정신병"
     "精神病")
    ("정신병자"
     "精神病者")
    ("정신사"
     "精神史")
    ("정신사적"
     "精神史的")
    ("정신생활"
     "精神生活")
    ("정신세계"
     "精神世界")
    ("정신적"
     "精神的")
    ("정신주의적"
     "精神主義的")
    ("정실"
     "情實")
    ("정액"
     "精液")
    ("정액제"
     "定額制")
    ("정어"
     "正語")
    ("정업"
     "正業")
    ("정역"
     "定役")
    ("정연"
     "井然"
     "整然")
    ("정열"
     "情熱")
    ("정열적"
     "情熱的")
    ("정예"
     "精銳")
    ("정오"
     "正午")
    ("정외과"
     "政外科")
    ("정욕"
     "情慾")
    ("정원"
     "定員"
     "庭園")
    ("정원령"
     "定員令")
    ("정원수"
     "庭園樹")
    ("정월"
     "正月")
    ("정유"
     "精油")
    ("정유업체"
     "精油業體")
    ("정유재란"
     "丁酉再亂")
    ("정육론"
     "情育論")
    ("정육점"
     "精肉店")
    ("정의"
     "定義"
     "情誼"
     "正義")
    ("정의감"
     "正義感")
    ("정이품"
     "正二品")
    ("정일"
     "靜逸")
    ("정일품"
     "正一品")
    ("정자"
     "亭子"
     "精子")
    ("정장"
     "正裝")
    ("정장식"
     "正裝式")
    ("정재"
     "呈才")
    ("정쟁"
     "政爭")
    ("정쟁화"
     "政爭化")
    ("정저지와"
     "井中求火"
     "井底之蛙")
    ("정적"
     "情的"
     "政敵"
     "靜寂"
     "靜的")
    ("정전"
     "丁田"
     "停戰"
     "停電"
     "正殿")
    ("정전기"
     "靜電氣")
    ("정전기적"
     "靜電氣的")
    ("정전제"
     "丁田制")
    ("정절"
     "貞節")
    ("정절관"
     "貞節觀")
    ("정점"
     "頂點")
    ("정정"
     "亭亭"
     "正定"
     "訂正")
    ("정정당당"
     "正正堂堂")
    ("정정진"
     "正精進")
    ("정제"
     "整齊"
     "精製"
     "錠劑")
    ("정제물"
     "精製物")
    ("정제성"
     "整齊性")
    ("정조"
     "情操"
     "情調"
     "貞操")
    ("정종"
     "正宗")
    ("정좌"
     "正坐")
    ("정주"
     "定住")
    ("정중"
     "鄭重")
    ("정중동"
     "靜中動")
    ("정중선"
     "正中線")
    ("정지"
     "停止"
     "整地"
     "靜止")
    ("정직"
     "停職"
     "正直")
    ("정직성"
     "正直性")
    ("정진"
     "精進")
    ("정진력"
     "精進力")
    ("정차"
     "停車")
    ("정착"
     "定着")
    ("정착촌"
     "定着村")
    ("정착화"
     "定着化")
    ("정찰"
     "偵察")
    ("정찰기"
     "偵察機")
    ("정책"
     "政策")
    ("정책국"
     "政策局")
    ("정책부장"
     "政策部長")
    ("정책실"
     "政策室")
    ("정책실장"
     "政策室長")
    ("정책적"
     "政策的")
    ("정책화"
     "政策化")
    ("정처"
     "定處")
    ("정체"
     "停滯"
     "政體"
     "正體")
    ("정체감"
     "停滯感")
    ("정체기"
     "停滯期")
    ("정체불명"
     "正體不明")
    ("정체성"
     "正體性")
    ("정체성론"
     "停滯性論")
    ("정초"
     "正初")
    ("정총"
     "定總")
    ("정출지일"
     "正出之日")
    ("정취"
     "情趣")
    ("정치"
     "政治"
     "精緻")
    ("정치가"
     "政治家")
    ("정치계"
     "政治界")
    ("정치관"
     "政治觀")
    ("정치국"
     "政治局")
    ("정치국원"
     "政治局員")
    ("정치군인"
     "政治軍人")
    ("정치권"
     "政治權")
    ("정치권력"
     "政治權力")
    ("정치극"
     "政治劇")
    ("정치력"
     "政治力")
    ("정치범"
     "政治犯")
    ("정치부"
     "政治部")
    ("정치부장"
     "政治部長")
    ("정치사"
     "政治史")
    ("정치사가"
     "政治史家")
    ("정치사상"
     "政治思想")
    ("정치사적"
     "政治史的")
    ("정치성"
     "政治性")
    ("정치의식"
     "政治意識")
    ("정치인"
     "政治人")
    ("정치적"
     "政治的")
    ("정치체"
     "政治體")
    ("정치학"
     "政治學")
    ("정치학과"
     "政治學科")
    ("정치학도"
     "政治學徒")
    ("정치학자"
     "政治學者")
    ("정치학적"
     "政治學的")
    ("정치화"
     "政治化")
    ("정태적"
     "靜態的")
    ("정토"
     "淨土")
    ("정통"
     "正統"
     "精通")
    ("정통극"
     "正統劇")
    ("정통성"
     "正統性")
    ("정통적"
     "正統的")
    ("정통파"
     "正統派")
    ("정파"
     "政派")
    ("정평"
     "定評")
    ("정포"
     "正布")
    ("정풍"
     "整風")
    ("정학"
     "停學")
    ("정합성"
     "整合性")
    ("정향"
     "定向")
    ("정형"
     "定型"
     "整形")
    ("정형외과"
     "整形外科")
    ("정형적"
     "定型的")
    ("정형화"
     "定型化")
    ("정혜"
     "定慧")
    ("정혜쌍수"
     "定慧雙修")
    ("정호"
     "丁戶")
    ("정호층"
     "丁戶層")
    ("정혼"
     "定婚")
    ("정화"
     "淨化"
     "精華")
    ("정화제"
     "淨化劑")
    ("정화조"
     "淨化槽")
    ("정확"
     "正確")
    ("정확도"
     "正確度")
    ("정확성"
     "正確性")
    ("정황"
     "情況")
    ("정회원"
     "正會員")
    ("정회원국"
     "正會員國")
    ("정훈"
     "政訓")
    ("제"
     ("制" . "억제할 제")
     ("劑" . "약 지을 제")
     ("啼" . "울 제")
     ("堤" . "둑 제")
     ("帝" . "임금 제")
     ("弟" . "아우 제")
     ("悌" . "공경할 제")
     ("提" . "끌 제")
     ("梯" . "사다리 제")
     ("濟" . "나루 제")
     ("祭" . "제사 제")
     ("第" . "집 제")
     ("臍" . "배꼽 제")
     ("荑" . "띠싹 제")
     ("薺" . "냉이 제")
     ("製" . "만들 제")
     ("諸" . "모든 제")
     ("蹄" . "굽 제")
     ("醍" . "맑은 술 제")
     ("除" . "섬돌 제")
     ("際" . "사이 제")
     ("霽" . "갤 제")
     ("題" . "이마 제")
     ("齊" . "가지런할 제")
     "齎"
     ("儕" . "동배 제")
     ("娣" . "여동생 제")
     ("擠" . "물리칠 제")
     ("猘" . "미친개 제")
     ("瑅" . "제당 제")
     ("睇" . "흘끗 볼 제")
     ("禔" . "복 제")
     ("稊" . "강아지풀 제")
     ("緹" . "붉은 비단 제")
     ("踶" . "찰 제")
     ("蹏" . "蹄와 同字")
     ("躋" . "오를 제")
     ("鍗" . "큰 가마 제")
     ("隄" . "堤와 同字")
     ("韲" . "양념할 제")
     ("鮧" . "복 제")
     ("鯷" . "메기 제"))
    ("제가"
     "諸加")
    ("제가회의"
     "諸加會議")
    ("제간회의"
     "諸干會議")
    ("제감"
     "弟監")
    ("제감층"
     "弟監層")
    ("제강"
     "製鋼")
    ("제강소"
     "製鋼所")
    ("제강소장"
     "製鋼所長")
    ("제거"
     "除去")
    ("제거제"
     "除去劑")
    ("제고"
     "提高")
    ("제공"
     "提供")
    ("제공권"
     "制空權")
    ("제공업자"
     "提供業者")
    ("제공자"
     "提供者")
    ("제과"
     "製菓")
    ("제과용품"
     "製菓用品")
    ("제과점"
     "製菓店")
    ("제관"
     "祭官")
    ("제국"
     "帝國"
     "諸國")
    ("제국군"
     "帝國軍")
    ("제국주의"
     "帝國主義")
    ("제국주의론"
     "帝國主義論")
    ("제국주의자"
     "帝國主義者")
    ("제국주의적"
     "帝國主義的")
    ("제국주의화"
     "帝國主義化")
    ("제궤의혈"
     "堤潰蟻穴")
    ("제기"
     "提起")
    ("제단"
     "祭壇")
    ("제당"
     "祭堂")
    ("제대"
     "祭臺"
     "除隊")
    ("제도"
     "制度"
     "濟度"
     "製圖")
    ("제도권"
     "制度圈")
    ("제도적"
     "制度的")
    ("제도판"
     "製圖板")
    ("제도화"
     "制度化")
    ("제독"
     "提督")
    ("제동"
     "制動")
    ("제력"
     "帝力")
    ("제련"
     "製鍊")
    ("제련술"
     "製鍊術")
    ("제례악"
     "祭禮樂")
    ("제막식"
     "除幕式")
    ("제명"
     "除名")
    ("제목"
     "題目")
    ("제목체"
     "題目體")
    ("제문"
     "祭文")
    ("제물"
     "祭物")
    ("제물론"
     "齊物論")
    ("제민"
     "齊民")
    ("제반"
     "諸般")
    ("제방"
     "堤防")
    ("제법무아"
     "諸法無我")
    ("제보"
     "提報")
    ("제보자"
     "提報者")
    ("제보철"
     "提報綴")
    ("제복"
     "制服"
     "祭服")
    ("제본"
     "製本")
    ("제분"
     "製粉")
    ("제사"
     "祭祀")
    ("제사권"
     "祭祀權")
    ("제사명"
     "祭祀名")
    ("제사상"
     "祭祀床")
    ("제사장"
     "祭司長")
    ("제사장적"
     "祭司長的")
    ("제삼"
     "弟三")
    ("제삼국"
     "第三國")
    ("제삼국산"
     "第三國産")
    ("제삼자"
     "第三者")
    ("제삿"
     "祭祀")
    ("제상"
     "祭床")
    ("제석"
     "帝釋")
    ("제선"
     "諸善")
    ("제설"
     "除雪")
    ("제세안민"
     "濟世安民")
    ("제세지재"
     "濟世之才")
    ("제소"
     "提訴")
    ("제솔회의"
     "諸率會議")
    ("제수"
     "祭需")
    ("제수용품"
     "祭需用品")
    ("제시"
     "提示")
    ("제식"
     "制式"
     "祭式")
    ("제신"
     "祭神")
    ("제실"
     "帝室")
    ("제악"
     "諸惡")
    ("제안"
     "提案")
    ("제안권"
     "提案權")
    ("제안서"
     "提案書")
    ("제안자"
     "提案者")
    ("제압"
     "制壓")
    ("제약"
     "制約"
     "製藥")
    ("제약사"
     "製藥社")
    ("제약성"
     "制約性")
    ("제어"
     "制御")
    ("제어식"
     "制御式")
    ("제언"
     "提言")
    ("제왕"
     "帝王"
     "諸王")
    ("제외"
     "除外")
    ("제외당"
     "除外當")
    ("제원"
     "諸元")
    ("제월광풍"
     "霽月光風")
    ("제위"
     "諸位")
    ("제의"
     "提議"
     "祭儀"
     "祭衣")
    ("제의명"
     "祭儀名")
    ("제의서"
     "提議書")
    ("제의성"
     "祭儀性")
    ("제의적"
     "祭儀的")
    ("제일"
     "祭日"
     "第一"
     "齊一")
    ("제일선"
     "第一線")
    ("제일성"
     "第一聲"
     "齊一性")
    ("제일의"
     "第一義")
    ("제일주의"
     "第一主義")
    ("제일주의론"
     "第一主義論")
    ("제일주의자"
     "第一主義者")
    ("제자"
     "弟子")
    ("제자백가"
     "諸子百家")
    ("제작"
     "製作")
    ("제작국"
     "製作局")
    ("제작권"
     "製作權")
    ("제작물"
     "製作物")
    ("제작비"
     "製作費")
    ("제작사"
     "製作社")
    ("제작소"
     "製作所")
    ("제작술"
     "製作術")
    ("제작실"
     "製作室")
    ("제작업체"
     "製作業體")
    ("제작자"
     "製作者")
    ("제작진"
     "製作陣")
    ("제장"
     "祭場")
    ("제재"
     "制裁"
     "製材"
     "題材")
    ("제재성"
     "制裁性")
    ("제재소"
     "製材所")
    ("제재안"
     "制裁案")
    ("제적"
     "除籍")
    ("제적당"
     "除籍當")
    ("제적생"
     "除籍生")
    ("제전"
     "祭典")
    ("제전경기"
     "祭典競技")
    ("제정"
     "制定"
     "帝政"
     "祭政")
    ("제정안"
     "制定案")
    ("제정일치"
     "祭政一致")
    ("제제"
     "帝制"
     "製劑")
    ("제제다사"
     "濟濟多士")
    ("제조"
     "製造")
    ("제조기"
     "製造機")
    ("제조법"
     "製造法")
    ("제조비"
     "製造費")
    ("제조업"
     "製造業")
    ("제조업계"
     "製造業界")
    ("제조업자"
     "製造業者")
    ("제조업체"
     "製造業體")
    ("제조일"
     "製造日")
    ("제조자"
     "製造者")
    ("제조창"
     "製造倉")
    ("제조창화"
     "製造倉化")
    ("제주"
     "濟州"
     "祭主")
    ("제주도"
     "濟州島")
    ("제지"
     "制止"
     "製紙")
    ("제지업체"
     "製紙業體")
    ("제직"
     "製織")
    ("제창"
     "提唱")
    ("제천"
     "祭天")
    ("제철"
     "製鐵")
    ("제철소"
     "製鐵所")
    ("제청"
     "提請"
     "祭廳")
    ("제초제"
     "除草劑")
    ("제출"
     "提出")
    ("제출자"
     "提出者")
    ("제패"
     "制覇")
    ("제표"
     "除標")
    ("제품"
     "製品")
    ("제품군"
     "製品群")
    ("제품력"
     "製品力")
    ("제품명"
     "製品名")
    ("제품점"
     "製品店")
    ("제품화"
     "製品化")
    ("제하"
     "題下")
    ("제하분주"
     "濟河焚舟")
    ("제한"
     "制限")
    ("제한당"
     "制限當")
    ("제한성"
     "制限性")
    ("제한적"
     "制限的")
    ("제한점"
     "制限店")
    ("제행무상"
     "諸行無常")
    ("제헌"
     "制憲")
    ("제헌절"
     "制憲節")
    ("제현"
     "諸賢")
    ("제호"
     "題號")
    ("제후"
     "諸侯")
    ("제후국"
     "諸侯國")
    ("제휴"
     "提携")
    ("조"
     ("俎" . "도마 조")
     ("兆" . "조짐 조")
     ("凋" . "시들 조")
     ("助" . "도울 조")
     "吊"
     ("嘲" . "조롱할 조")
     ("弔" . "위문할 조")
     ("彫" . "새길 조")
     ("措" . "둘 조")
     ("操" . "잡을 조")
     ("早" . "새벽 조")
     ("晁" . "朝의 古字")
     ("曹" . "무리 조")
     ("曺" . "성 조")
     ("朝" . "아침 조")
     ("條" . "가지 조")
     ("棗" . "대추나무 조")
     ("槽" . "구유 조")
     ("漕" . "배로 실어 나를 조")
     ("潮" . "조수 조")
     ("炤" . "照와 同字")
     ("照" . "비출 조")
     ("燥" . "마를 조")
     ("爪" . "손톱 조")
     ("璪" . "면루관 드림 옥 조")
     ("眺" . "바라볼 조")
     ("祖" . "조상 조")
     ("祚" . "복 조")
     ("租" . "구실 조")
     ("稠" . "빽빽할 조")
     ("窕" . "정숙할 조")
     ("粗" . "거칠 조")
     ("糟" . "지게미 조")
     ("組" . "끈 조")
     ("繰" . "야청 통견 조")
     ("肇" . "비롯할 조")
     ("藻" . "조류 조")
     ("蚤" . "벼룩 조")
     ("詔" . "고할 조")
     "詛"
     ("調" . "고를 조")
     ("趙" . "조나라 조")
     ("跳" . "뛸 조")
     ("躁" . "떠들 조")
     ("造" . "지을 조")
     ("遭" . "만날 조")
     ("釣" . "낚시 조")
     ("阻" . "험할 조")
     ("雕" . "독수리 조")
     ("鳥" . "새 조")
     ("佻" . "방정맞을 조")
     ("傮" . "마칠 조")
     ("刁" . "바라 조")
     ("厝" . "措와 同字")
     ("嘈" . "지껄일 조")
     ("噪" . "떠들썩할 조")
     ("嬥" . "날씬할 조")
     ("徂" . "갈 조")
     ("懆" . "근심할 조")
     ("找" . "채울 조")
     ("殂" . "죽을 조")
     "洮"
     ("澡" . "씻을 조")
     "琱"
     ("皁" . "하인 조")
     ("祧" . "조묘 조")
     ("竈" . "부엌 조")
     ("笊" . "조리 조")
     ("糙" . "매조미쌀 조")
     ("糶" . "쌀 내어 팔 조")
     ("絩" . "견직물 날실 수 조")
     ("胙" . "복 조")
     ("臊" . "누릴 조")
     ("艚" . "거룻배 조")
     ("蔦" . "담쟁이 조")
     ("蜩" . "매미 조")
     ("誂" . "꾈 조")
     ("譟" . "시끄러울 조")
     ("鈟" . "낚시 조")
     ("銚" . "쟁개비 조")
     ("鋽" . "불리지 않은 쇠 조")
     ("鯛" . "도미 조")
     ("鵰" . "수리 조")
     ("鼂" . "朝와 同字"))
    ("조각"
     "彫刻"
     "組閣")
    ("조각가"
     "彫刻家")
    ("조각상"
     "彫刻像")
    ("조각전"
     "彫刻展")
    ("조각품"
     "彫刻品")
    ("조간"
     "朝刊")
    ("조간신문"
     "朝刊新聞")
    ("조간화"
     "朝刊化")
    ("조감독"
     "助監督")
    ("조강지처"
     "糟糠之妻")
    ("조객"
     "弔客")
    ("조건"
     "條件")
    ("조건부"
     "條件附")
    ("조건적"
     "條件的")
    ("조건화"
     "條件化")
    ("조걸위학"
     "助桀爲虐")
    ("조견"
     "早絹")
    ("조계종"
     "曹溪宗")
    ("조공"
     "朝貢")
    ("조관"
     "朝冠")
    ("조교"
     "助敎")
    ("조교수"
     "助敎授")
    ("조국"
     "祖國")
    ("조근성"
     "朝勤性")
    ("조급"
     "早急"
     "躁急")
    ("조급성"
     "躁急性")
    ("조급증"
     "躁急症")
    ("조기"
     "早期"
     "早起")
    ("조난당"
     "遭難當")
    ("조난자"
     "遭難者")
    ("조달"
     "調達")
    ("조달망"
     "調達網")
    ("조달책"
     "調達策")
    ("조동모서"
     "朝東暮西")
    ("조력"
     "助力"
     "潮力")
    ("조력권"
     "助力權")
    ("조령모개"
     "朝令暮改")
    ("조례"
     "條例")
    ("조로인생"
     "朝露人生")
    ("조롱"
     "嘲弄")
    ("조루"
     "早漏")
    ("조루증"
     "早漏症")
    ("조류"
     "潮流"
     "藻類"
     "鳥類")
    ("조리"
     "條理"
     "調理")
    ("조리기"
     "調理器")
    ("조리대"
     "調理臺")
    ("조리법"
     "調理法")
    ("조리사"
     "調理士")
    ("조리용"
     "調理用")
    ("조리용품"
     "調理用品")
    ("조림"
     "造林")
    ("조립"
     "組立")
    ("조립도"
     "組立圖")
    ("조립식"
     "組立式")
    ("조립질"
     "粗粒質")
    ("조립품"
     "組立品")
    ("조만간"
     "早晩間")
    ("조망"
     "眺望")
    ("조명"
     "嘲名"
     "照明")
    ("조명등"
     "照明燈")
    ("조명시리"
     "朝名市利")
    ("조목조목"
     "條目條目")
    ("조문"
     "弔問"
     "條文")
    ("조문객"
     "弔問客")
    ("조문석사"
     "朝聞夕死")
    ("조물주"
     "造物主")
    ("조미"
     "助味"
     "調味")
    ("조미료"
     "調味料")
    ("조밀"
     "稠密")
    ("조발"
     "調髮")
    ("조방제"
     "條坊制")
    ("조변석개"
     "朝變夕改")
    ("조별"
     "組別")
    ("조복"
     "朝服")
    ("조부"
     "祖父")
    ("조부모"
     "祖父母")
    ("조불급석"
     "朝不及夕")
    ("조불려석"
     "朝不慮夕")
    ("조사"
     "助詞"
     "弔詞"
     "照査"
     "祖師"
     "調査")
    ("조사계"
     "調査界")
    ("조사권"
     "調査權")
    ("조사단"
     "調査團")
    ("조사단장"
     "調査團長")
    ("조사반"
     "調査班")
    ("조사부"
     "調査部")
    ("조사부장"
     "調査部長")
    ("조사원"
     "調査員")
    ("조사자"
     "調査者")
    ("조사표"
     "調査表")
    ("조산"
     "早産"
     "祖山")
    ("조산통"
     "早産痛")
    ("조삼모사"
     "朝三暮四")
    ("조삼모사식"
     "朝三暮四式")
    ("조상"
     "彫像"
     "祖上")
    ("조상신"
     "祖上神")
    ("조서"
     "調書")
    ("조석"
     "潮汐")
    ("조석간제"
     "朝夕刊制")
    ("조선"
     "朝鮮"
     "漕船"
     "造船")
    ("조선량"
     "造船量")
    ("조선소"
     "造船所")
    ("조선어"
     "朝鮮語")
    ("조선업"
     "造船業")
    ("조선업계"
     "造船業界")
    ("조선조"
     "朝鮮朝")
    ("조성"
     "助成"
     "組成"
     "造成")
    ("조성설"
     "造成說")
    ("조세"
     "租稅")
    ("조소"
     "嘲笑"
     "彫塑")
    ("조소성"
     "彫塑性")
    ("조속"
     "早速")
    ("조송지근"
     "照松之勤")
    ("조수"
     "助手"
     "潮水"
     "鳥獸")
    ("조수석"
     "助手席")
    ("조숙"
     "早熟")
    ("조숙형"
     "早熟型")
    ("조승모문"
     "朝蠅暮蚊")
    ("조식"
     "早食")
    ("조신"
     "操身"
     "朝臣")
    ("조실부모"
     "早失父母")
    ("조심"
     "操心")
    ("조심성"
     "操心性")
    ("조심조심"
     "操心操心")
    ("조악"
     "粗惡")
    ("조야"
     "朝野")
    ("조약"
     "條約")
    ("조어"
     "造語")
    ("조언"
     "助言")
    ("조언자"
     "助言者")
    ("조업"
     "操業"
     "肇業")
    ("조역"
     "助役")
    ("조연"
     "助演")
    ("조연상"
     "助演賞")
    ("조연출자"
     "助演出者")
    ("조영"
     "造營")
    ("조예"
     "造詣")
    ("조용조"
     "租庸調")
    ("조우"
     "遭遇")
    ("조운모우"
     "朝雲暮雨")
    ("조울증"
     "躁鬱症")
    ("조원"
     "組員")
    ("조율"
     "租率"
     "調律")
    ("조율이시"
     "棗栗梨柿")
    ("조응"
     "照應")
    ("조의금"
     "弔意金")
    ("조익모습"
     "朝益暮習")
    ("조인"
     "調印")
    ("조작"
     "操作"
     "造作")
    ("조작극"
     "造作劇")
    ("조작설"
     "造作說")
    ("조작적"
     "造作的")
    ("조잡"
     "稠雜"
     "粗雜")
    ("조장"
     "助長"
     "組長")
    ("조장자"
     "助長者")
    ("조절"
     "調節")
    ("조절기"
     "調節器")
    ("조정"
     "朝廷"
     "漕艇"
     "調停"
     "調整")
    ("조정관"
     "調停官")
    ("조정기"
     "調停期")
    ("조정력"
     "調整力")
    ("조정법"
     "調停法")
    ("조정실"
     "調整室")
    ("조정실장"
     "調整室長")
    ("조제"
     "調劑")
    ("조족지혈"
     "鳥足之血")
    ("조종"
     "操縱")
    ("조종간"
     "操縱杆")
    ("조종대"
     "操縱臺")
    ("조종사"
     "操縱士")
    ("조종술"
     "操縱術")
    ("조종자"
     "操縱者")
    ("조종형"
     "操縱型")
    ("조준"
     "照準")
    ("조직"
     "組織")
    ("조직단"
     "組織團")
    ("조직력"
     "組織力")
    ("조직론"
     "組織論")
    ("조직원"
     "組織員")
    ("조직적"
     "組織的")
    ("조직책"
     "組織責")
    ("조직체"
     "組織體")
    ("조직화"
     "組織化")
    ("조진궁장"
     "鳥盡弓藏")
    ("조진모초"
     "朝秦暮楚")
    ("조짐"
     "兆朕")
    ("조차"
     "潮差")
    ("조차지"
     "租借地")
    ("조찬"
     "朝餐")
    ("조처"
     "措處")
    ("조처안"
     "措處案")
    ("조청"
     "造淸")
    ("조출모귀"
     "朝出暮歸")
    ("조충전각"
     "彫蟲篆刻")
    ("조취모산"
     "朝聚暮散")
    ("조치"
     "措置"
     "調治")
    ("조칙"
     "詔勅")
    ("조타수"
     "操舵手")
    ("조퇴"
     "早退")
    ("조폐"
     "造幣")
    ("조하금"
     "朝霞錦")
    ("조하주"
     "朝霞紬")
    ("조합"
     "組合")
    ("조합물"
     "組合物")
    ("조합비"
     "組合費")
    ("조합원"
     "組合員")
    ("조합장"
     "組合長")
    ("조합주의"
     "組合主義")
    ("조합형"
     "組合型")
    ("조합형주의자"
     "組合型主義者")
    ("조항"
     "條項")
    ("조형"
     "造形")
    ("조형관"
     "造形館")
    ("조형물"
     "造形物")
    ("조형미"
     "造形美")
    ("조형성"
     "造形性")
    ("조형적"
     "造形的")
    ("조화"
     "調和"
     "造化")
    ("조화미"
     "調和美")
    ("조화성"
     "調和性")
    ("조회"
     "朝會"
     "照會")
    ("조회란"
     "照會欄")
    ("족"
     ("族" . "겨레 족")
     ("簇" . "모일 족")
     ("足" . "발 족")
     ("鏃" . "화살촉 족")
     ("瘯" . "피부병 이름 족")
     "蔟")
    ("족단"
     "族團")
    ("족단적"
     "族團的")
    ("족벌"
     "族閥")
    ("족보"
     "族譜")
    ("족부"
     "足部")
    ("족불리지"
     "足不離地")
    ("족속"
     "族屬")
    ("족쇄"
     "足鎖")
    ("족외혼"
     "族外婚")
    ("족자"
     "簇子")
    ("족장"
     "族長")
    ("족장적"
     "族長的")
    ("족적"
     "族的"
     "足跡")
    ("족정"
     "足丁")
    ("족정제"
     "足丁制")
    ("족출"
     "簇出")
    ("족탈불급"
     "足脫不及")
    ("족탕"
     "足湯")
    ("존"
     ("存" . "있을 존")
     ("尊" . "존귀할 존")
     ("拵" . "꽂을 존")
     "鐏")
    ("존경"
     "尊敬")
    ("존경심"
     "尊敬心")
    ("존귀"
     "尊貴")
    ("존대어"
     "尊待語")
    ("존댓"
     "尊待")
    ("존립"
     "存立")
    ("존망"
     "存亡")
    ("존망지추"
     "存亡之秋")
    ("존부"
     "存否")
    ("존부론"
     "存否論")
    ("존비귀천"
     "尊卑貴賤")
    ("존속"
     "存續"
     "尊屬")
    ("존엄"
     "尊嚴")
    ("존엄성"
     "尊嚴性")
    ("존영"
     "尊影")
    ("존재"
     "存在")
    ("존재감"
     "存在感")
    ("존재론자"
     "存在論者")
    ("존재론적"
     "存在論的")
    ("존재설"
     "存在說")
    ("존재자"
     "存在者")
    ("존중"
     "尊重")
    ("존중론"
     "尊重論")
    ("존중심"
     "尊重心")
    ("존치"
     "存置")
    ("존칭"
     "尊稱")
    ("존폐"
     "存廢")
    ("존호"
     "尊號")
    ("존화"
     "尊華")
    ("졸"
     ("卒" . "군사 졸")
     ("拙" . "서툴 졸")
     ("猝" . "갑자기 졸")
     "倅"
     "脺")
    ("졸고"
     "拙稿")
    ("졸도"
     "卒倒")
    ("졸병"
     "卒兵")
    ("졸부"
     "猝富")
    ("졸속"
     "拙速")
    ("졸업"
     "卒業")
    ("졸업반"
     "卒業班")
    ("졸업생"
     "卒業生")
    ("졸업식"
     "卒業式")
    ("졸업식장"
     "卒業式場")
    ("졸업자"
     "卒業者")
    ("졸업장"
     "卒業狀")
    ("졸업화"
     "卒業化")
    ("졸작"
     "拙作")
    ("졸저"
     "拙著")
    ("졸지"
     "猝地")
    ("종"
     ("倧" . "상고 신인 종")
     ("宗" . "마루 종")
     ("從" . "좇을 종")
     ("悰" . "즐길 종")
     ("慫" . "권할 종")
     ("棕" . "종려나무 종")
     ("淙" . "물 소리 종")
     ("琮" . "옥홀 종")
     ("種" . "씨 종")
     ("終" . "끝낼 종")
     ("綜" . "모을 종")
     ("縱" . "늘어질 종")
     ("腫" . "부스럼 종")
     ("踪" . "자취 종")
     ("踵" . "발꿈치 종")
     ("鍾" . "술병 종")
     ("鐘" . "쇠북 종")
     ("伀" . "두려워할 종")
     ("慒" . "생각할 종")
     ("柊" . "방망이 종")
     ("椶" . "棕과 同字")
     ("樅" . "전나무 종")
     ("瑽" . "패옥소리 종")
     ("瘇" . "수종 종")
     ("粽" . "주악 종")
     "蓯"
     ("螽" . "누리 종")
     ("蹤" . "자취 종"))
    ("종가"
     "宗家"
     "終價")
    ("종각"
     "鐘閣")
    ("종강"
     "終講")
    ("종개념"
     "種槪念")
    ("종개념적"
     "種槪念的")
    ("종결"
     "終決"
     "終結")
    ("종괴"
     "腫塊")
    ("종교"
     "宗敎")
    ("종교가"
     "宗敎家")
    ("종교계"
     "宗敎界")
    ("종교관"
     "宗敎觀")
    ("종교극"
     "宗敎劇")
    ("종교사적"
     "宗敎史的")
    ("종교설"
     "宗敎說")
    ("종교인"
     "宗敎人")
    ("종교적"
     "宗敎的")
    ("종교학"
     "宗敎學")
    ("종교학과"
     "宗敎學科")
    ("종교학자"
     "宗敎學者")
    ("종국"
     "終局")
    ("종국적"
     "終局的")
    ("종군"
     "從軍")
    ("종권"
     "宗權")
    ("종기"
     "腫氣")
    ("종내"
     "終乃")
    ("종단"
     "宗團")
    ("종대"
     "縱隊")
    ("종란"
     "種卵")
    ("종래"
     "從來")
    ("종량세"
     "從量稅")
    ("종려"
     "棕櫚")
    ("종례"
     "終禮")
    ("종로"
     "鍾路")
    ("종료"
     "終了")
    ("종루"
     "鐘樓")
    ("종류"
     "種類")
    ("종류별"
     "種類別")
    ("종막"
     "終幕")
    ("종말"
     "終末")
    ("종말론"
     "終末論")
    ("종목"
     "種目")
    ("종목별"
     "種目別")
    ("종묘사직"
     "宗廟社稷")
    ("종무소식"
     "終無消息")
    ("종무식"
     "終務式")
    ("종민"
     "從民")
    ("종반"
     "終盤")
    ("종별"
     "種別")
    ("종사"
     "從事"
     "從辭")
    ("종사관"
     "從事官")
    ("종사원"
     "從事員")
    ("종사자"
     "從事者")
    ("종성"
     "終聲")
    ("종속"
     "從屬")
    ("종속론"
     "從屬論")
    ("종속물"
     "從屬物")
    ("종속성"
     "從屬性")
    ("종속적"
     "從屬的")
    ("종시여일"
     "終始如一")
    ("종식"
     "終熄")
    ("종신"
     "終身")
    ("종신직"
     "終身職")
    ("종신형"
     "終身刑")
    ("종심소욕"
     "從心所欲")
    ("종양"
     "腫瘍")
    ("종언"
     "終焉")
    ("종업식"
     "終業式")
    ("종업원"
     "從業員")
    ("종영"
     "終映")
    ("종용"
     "慫慂")
    ("종일"
     "終日")
    ("종일품"
     "從一品")
    ("종자"
     "從者"
     "種子")
    ("종장"
     "終章")
    ("종적"
     "種的"
     "縱的")
    ("종전"
     "從前"
     "終戰")
    ("종점"
     "終點")
    ("종조"
     "宗祖")
    ("종조부"
     "從祖父")
    ("종족"
     "種族")
    ("종족적"
     "種族的")
    ("종종"
     "種種")
    ("종주국"
     "宗主國")
    ("종지"
     "宗旨")
    ("종지부"
     "終止符")
    ("종착역"
     "終着驛")
    ("종착점"
     "終着點")
    ("종칠품"
     "從七品")
    ("종토세"
     "綜土稅")
    ("종파"
     "宗派")
    ("종파주의"
     "宗派主義")
    ("종합"
     "綜合")
    ("종합적"
     "綜合的")
    ("종합지"
     "綜合誌")
    ("종합화"
     "綜合化")
    ("종회"
     "宗會")
    ("종횡"
     "縱橫")
    ("종횡무진"
     "縱橫無盡")
    ("종횡적"
     "縱橫的")
    ("좌"
     ("佐" . "도울 좌")
     ("坐" . "앉을 좌")
     ("左" . "왼 좌")
     ("座" . "자리 좌")
     ("挫" . "꺽을 좌")
     ("剉" . "꺽을 좌")
     ("痤" . "뾰루지 좌")
     ("莝" . "여물 좌")
     ("髽" . "북상투 좌"))
    ("좌경"
     "左傾")
    ("좌경화"
     "左傾化")
    ("좌고우면"
     "左顧右眄")
    ("좌기"
     "左記")
    ("좌단"
     "左袒")
    ("좌담"
     "座談")
    ("좌담회"
     "座談會")
    ("좌대"
     "座臺")
    ("좌보"
     "左輔")
    ("좌불안석"
     "坐不安席"
     "坐不安席")
    ("좌사우고"
     "左思右考")
    ("좌상"
     "坐像")
    ("좌석"
     "坐席"
     "座席")
    ("좌석미난"
     "座席未煖")
    ("좌선"
     "坐禪"
     "左旋")
    ("좌선룡"
     "左旋龍")
    ("좌시"
     "坐視")
    ("좌식"
     "坐式")
    ("좌식산공"
     "坐食山空")
    ("좌와기거"
     "坐臥起居")
    ("좌우"
     "左右")
    ("좌우간"
     "左右間")
    ("좌우익"
     "左右翼")
    ("좌우지간"
     "左右之間")
    ("좌우지명"
     "座右之銘")
    ("좌이대단"
     "坐而待旦")
    ("좌이대사"
     "坐而待死")
    ("좌익"
     "左翼")
    ("좌절"
     "挫折")
    ("좌절감"
     "挫折感")
    ("좌정"
     "坐定")
    ("좌정관천"
     "坐井觀天")
    ("좌중"
     "座中")
    ("좌중월"
     "左中越")
    ("좌지우지"
     "左之右之")
    ("좌찬성"
     "左贊成")
    ("좌천"
     "左遷")
    ("좌청룡"
     "左靑龍")
    ("좌초"
     "坐礁")
    ("좌충우돌"
     "左衝右突")
    ("좌측"
     "左側")
    ("좌측통행"
     "左側通行")
    ("좌파"
     "左派")
    ("좌파적"
     "左派的")
    ("좌판"
     "坐板")
    ("좌편"
     "左便")
    ("좌평"
     "佐平")
    ("좌포우혜"
     "左脯右醯")
    ("좌표"
     "座標")
    ("좌표계"
     "座標系")
    ("좌향"
     "坐向")
    ("죄"
     ("罪" . "허물 죄"))
    ("죄견천리"
     "坐見千里")
    ("죄과"
     "罪過")
    ("죄명"
     "罪名")
    ("죄목"
     "罪目")
    ("죄불용주"
     "罪不容誅")
    ("죄송"
     "罪悚")
    ("죄수"
     "罪囚")
    ("죄수복"
     "罪囚服")
    ("죄악"
     "罪惡")
    ("죄악상"
     "罪惡相")
    ("죄악시"
     "罪惡視")
    ("죄의식"
     "罪意識")
    ("죄의유경"
     "罪疑惟輕")
    ("죄인"
     "罪人")
    ("죄중벌경"
     "罪重罰輕")
    ("죄질"
     "罪質")
    ("죄책감"
     "罪責感")
    ("죄형"
     "罪刑")
    ("주"
     ("主" . "주인 주")
     ("住" . "살 주")
     ("侏" . "난쟁이 주")
     ("做" . "지을 주")
     ("周" . "두루 주")
     ("呪" . "빌 주")
     ("奏" . "아뢸 주")
     ("姝" . "예쁠 주")
     ("宙" . "집 주")
     ("州" . "고을 주")
     ("廚" . "부엌 주")
     ("晝" . "낮 주")
     ("朱" . "붉을 주")
     "枓"
     ("柱" . "기둥 주")
     ("株" . "그루 주")
     ("注" . "물댈 주")
     ("洲" . "섬 주")
     ("湊" . "모일 주")
     ("澍" . "단비 주")
     ("炷" . "심지 주")
     ("珠" . "구슬 주")
     ("疇" . "밭두둑 주")
     ("稠" . "빽빽할 주")
     ("籌" . "투호 살 주")
     ("紂" . "껑거리끈 주")
     ("紬" . "명주 주")
     ("綢" . "얽힐 주")
     ("胄" . "후사 주")
     ("舟" . "배 주")
     ("蛛" . "거미 주")
     ("註" . "주낼 주")
     ("誅" . "벨 주")
     ("走" . "달릴 주")
     ("躊" . "머뭇거릴 주")
     ("輳" . "모일 주")
     ("週" . "돌 주")
     ("酎" . "세 번 빚은 술 주")
     ("酒" . "술 주")
     ("鑄" . "쇠 부어 만들 주")
     ("駐" . "머무를 주")
     "齟"
     ("丟" . "갈 주")
     ("侜" . "속일 주")
     ("儔" . "무리 주")
     ("尌" . "세울 주")
     ("幬" . "휘장 주")
     ("拄" . "떠받칠 주")
     ("硃" . "주사 주")
     ("籒" . "주문 주")
     ("肘" . "팔꿈치 주")
     ("腠" . "살결 주")
     ("蔟" . "태주 주")
     ("蛀" . "나무좀 주")
     ("裯" . "홑이불 주")
     ("詋" . "呪와 同字")
     ("賙" . "진휼할 주")
     ("趎" . "사람이름 주")
     ("輈" . "끌채 주")
     "迬"
     ("遒" . "다가설 주")
     ("鉒" . "쇳돌 주")
     ("霌" . "운우 모양 주")
     ("霔" . "장마 주")
     ("鼄" . "거미 주"))
    ("주가"
     "株價")
    ("주간"
     "主幹"
     "晝間"
     "週刊"
     "週間")
    ("주간지"
     "週刊紙"
     "週刊誌")
    ("주객"
     "主客"
     "酒客")
    ("주객전도"
     "主客顚倒")
    ("주거"
     "住居")
    ("주거비"
     "住居費")
    ("주거지"
     "住居地")
    ("주견"
     "主見"
     "紬絹")
    ("주경야독"
     "晝耕夜讀")
    ("주고야비"
     "晝高夜卑")
    ("주곡"
     "主穀")
    ("주관"
     "主管"
     "主觀")
    ("주관성"
     "主觀性")
    ("주관식"
     "主觀式")
    ("주관자"
     "主管者")
    ("주관적"
     "主觀的")
    ("주관주의"
     "主觀主義")
    ("주관화"
     "主觀化")
    ("주교"
     "主敎")
    ("주구"
     "走狗")
    ("주군제"
     "主君制")
    ("주권"
     "主權")
    ("주권자"
     "主權者")
    ("주급"
     "週給")
    ("주기"
     "周忌"
     "週期")
    ("주기성"
     "週期性")
    ("주기적"
     "週期的")
    ("주낭반대"
     "酒囊飯袋")
    ("주년"
     "周年")
    ("주누선"
     "主淚線")
    ("주당"
     "酒黨")
    ("주도"
     "主導"
     "主都")
    ("주도국"
     "主導國")
    ("주도권"
     "主導權")
    ("주도력"
     "主導力")
    ("주도면밀"
     "周到綿密")
    ("주도성"
     "主導性")
    ("주도적"
     "主導的")
    ("주도형"
     "主導型")
    ("주동"
     "主動")
    ("주동력"
     "主動力")
    ("주동자"
     "主動者")
    ("주동적"
     "主動的")
    ("주둔"
     "駐屯")
    ("주둔국"
     "駐屯國")
    ("주둔군"
     "駐屯軍")
    ("주등"
     "酒燈")
    ("주란"
     "酒亂")
    ("주량"
     "酒量")
    ("주력"
     "主力"
     "注力"
     "走力")
    ("주련"
     "柱聯")
    ("주례"
     "主禮"
     "週例")
    ("주루"
     "走壘")
    ("주류"
     "主流"
     "酒類")
    ("주마가편"
     "走馬加鞭")
    ("주마간산"
     "走馬看山")
    ("주마등"
     "走馬燈")
    ("주막"
     "酒幕")
    ("주말"
     "週末")
    ("주말여행"
     "週末旅行")
    ("주맥"
     "主脈")
    ("주모자"
     "主謀者")
    ("주목"
     "注目")
    ("주목표"
     "主目標")
    ("주무"
     "主務")
    ("주문"
     "呪文"
     "注文")
    ("주물"
     "鑄物")
    ("주미"
     "駐美")
    ("주민"
     "住民")
    ("주민세"
     "住民稅")
    ("주민세액"
     "住民稅額")
    ("주민증"
     "住民證")
    ("주발"
     "周鉢")
    ("주방"
     "廚房")
    ("주방장"
     "廚房長")
    ("주백약지장"
     "酒百藥之長")
    ("주번"
     "週番")
    ("주범"
     "主犯")
    ("주변"
     "周邊")
    ("주변국"
     "周邊國")
    ("주변부"
     "周邊部")
    ("주변인"
     "周邊人")
    ("주변적"
     "周邊的")
    ("주변촌"
     "周邊村")
    ("주변화"
     "周邊化")
    ("주보"
     "週報")
    ("주복무지"
     "走伏無地")
    ("주봉"
     "主峯")
    ("주부"
     "主婦")
    ("주부상"
     "主婦像")
    ("주부층"
     "主婦層")
    ("주불"
     "駐佛")
    ("주비수불행"
     "舟非水不行")
    ("주빈"
     "主賓")
    ("주사"
     "主事"
     "主思"
     "注射")
    ("주사기"
     "注射器")
    ("주사액"
     "注射液")
    ("주사야탁"
     "晝思夜度")
    ("주사제"
     "注射劑")
    ("주사파"
     "主思派")
    ("주산"
     "主山"
     "珠算")
    ("주산지"
     "主産地")
    ("주살"
     "誅殺")
    ("주상"
     "主上")
    ("주상골"
     "舟狀骨")
    ("주색"
     "酒色")
    ("주색잡기"
     "酒色雜技")
    ("주생활"
     "住生活")
    ("주석"
     "主席"
     "朱錫"
     "註釋")
    ("주석단"
     "主席團")
    ("주석서"
     "註釋書")
    ("주석직"
     "主席職")
    ("주선"
     "周旋")
    ("주성분"
     "主成分")
    ("주성신직"
     "主聖臣直")
    ("주소"
     "住所")
    ("주소지"
     "住所地")
    ("주수"
     "主帥")
    ("주순호치"
     "朱脣皓齒")
    ("주술"
     "呪術")
    ("주술적"
     "呪術的")
    ("주시"
     "注視")
    ("주식"
     "主食"
     "株式")
    ("주식형"
     "株式型")
    ("주식회사"
     "株式會社")
    ("주신"
     "主神")
    ("주심"
     "主審")
    ("주안상"
     "酒案床")
    ("주안점"
     "主眼點")
    ("주야장천"
     "晝夜長川")
    ("주어"
     "主語")
    ("주업"
     "主業")
    ("주역"
     "主役")
    ("주역론"
     "主役論")
    ("주연"
     "主演"
     "酒宴")
    ("주연상"
     "主演賞")
    ("주연성"
     "周緣性")
    ("주연자"
     "主演者")
    ("주연작"
     "主演作")
    ("주영"
     "駐英")
    ("주옥"
     "珠玉")
    ("주요"
     "主要")
    ("주요인"
     "主要因")
    ("주원료"
     "主原料")
    ("주원인"
     "主原因")
    ("주위"
     "周圍")
    ("주위상책"
     "走爲上策")
    ("주유"
     "周遊")
    ("주유별장"
     "酒有別腸")
    ("주유소"
     "注油所")
    ("주유천하"
     "周遊天下")
    ("주의"
     "主義"
     "注意")
    ("주의보"
     "注意報")
    ("주의서"
     "注意書")
    ("주의식"
     "主義式")
    ("주의자"
     "主義者")
    ("주이불비"
     "周而不比")
    ("주인"
     "主人"
     "主因")
    ("주인공"
     "主人公")
    ("주인공적"
     "主人公的")
    ("주일"
     "主日"
     "週日"
     "駐日")
    ("주임"
     "主任"
     "奏任")
    ("주입"
     "注入")
    ("주입설출"
     "酒入舌出")
    ("주자"
     "奏者"
     "走者")
    ("주자학"
     "朱子學")
    ("주작"
     "朱雀")
    ("주작수"
     "朱雀水")
    ("주장"
     "主將"
     "主張"
     "主掌"
     "周章")
    ("주장자"
     "主張者")
    ("주재"
     "主宰"
     "駐在")
    ("주재국"
     "駐在國")
    ("주재료"
     "主材料")
    ("주재소"
     "駐在所")
    ("주재원"
     "駐在員")
    ("주재자"
     "主宰者")
    ("주저"
     "躊躇")
    ("주저주저"
     "躊躇躊躇")
    ("주적"
     "主敵")
    ("주전"
     "主戰")
    ("주전산기"
     "主電算機")
    ("주전자"
     "酒煎子")
    ("주전출족"
     "走前出足")
    ("주점"
     "酒店")
    ("주정"
     "酒酊")
    ("주제"
     "主題")
    ("주제가"
     "主題歌")
    ("주제도"
     "主題圖")
    ("주제문"
     "主題文")
    ("주제어"
     "主題語")
    ("주조"
     "主潮")
    ("주종"
     "主宗"
     "主從")
    ("주주"
     "株主")
    ("주중적국"
     "舟中敵國")
    ("주지"
     "主旨"
     "主知"
     "住持"
     "周池"
     "周知")
    ("주지사"
     "州知事")
    ("주지육림"
     "酒池肉林")
    ("주지주의"
     "主知主義")
    ("주차"
     "駐車")
    ("주차권"
     "駐車券")
    ("주차료"
     "駐車料")
    ("주차장"
     "駐車場")
    ("주창"
     "主唱")
    ("주창자"
     "主唱者")
    ("주체"
     "主體")
    ("주체사상"
     "主體思想")
    ("주체사상파"
     "主體思想派")
    ("주체사상화"
     "主體思想化")
    ("주체성"
     "主體性")
    ("주체자"
     "主體者")
    ("주체적"
     "主體的")
    ("주체화"
     "主體化")
    ("주초"
     "週初")
    ("주총"
     "株總")
    ("주최"
     "主催")
    ("주축"
     "主軸")
    ("주치의"
     "主治醫")
    ("주침야소"
     "晝寢夜梳")
    ("주택"
     "住宅")
    ("주택가"
     "住宅街")
    ("주택난"
     "住宅難")
    ("주택지"
     "住宅地")
    ("주특기"
     "主特技")
    ("주파"
     "走破")
    ("주파수"
     "周波數")
    ("주판"
     "籌板")
    ("주평"
     "週評")
    ("주필"
     "主筆")
    ("주한"
     "駐韓")
    ("주해"
     "註解")
    ("주행"
     "走行")
    ("주향"
     "走向")
    ("주현"
     "主縣")
    ("주홍"
     "朱紅")
    ("주홍색"
     "朱紅色")
    ("주황"
     "朱黃")
    ("주황색"
     "朱黃色")
    ("주효"
     "奏效")
    ("죽"
     ("竹" . "대 죽")
     ("粥" . "죽 죽"))
    ("죽두목설"
     "竹頭木屑")
    ("죽마고우"
     "竹馬故友")
    ("죽백지공"
     "竹帛之功")
    ("죽사발"
     "粥沙鉢")
    ("죽색"
     "粥色")
    ("죽세공"
     "竹細工")
    ("죽세공품"
     "竹細工品")
    ("죽순"
     "竹筍")
    ("죽제공"
     "竹製工")
    ("죽제품"
     "竹製品")
    ("죽창"
     "竹槍")
    ("준"
     ("俊" . "준걸 준")
     ("儁" . "雋·俊과 同字")
     ("准" . "승인할 준")
     ("埈" . "가파를 준")
     ("寯" . "모일 준")
     ("峻" . "높을 준")
     ("晙" . "밝을 준")
     ("樽" . "술그릇 준")
     ("浚" . "깊을 준")
     ("準" . "수준기 준")
     ("濬" . "칠 준")
     ("焌" . "굽을 준")
     ("畯" . "俊과 同字")
     ("竣" . "마칠 준")
     ("蠢" . "꿈틀거릴 준")
     ("逡" . "뒷걸음칠 준")
     ("遵" . "좇을 준")
     ("駿" . "준마 준")
     ("噂" . "수군거릴 준")
     ("埻" . "과녘 준")
     ("墫" . "樽·罇과 同字")
     ("惷" . "어수선할 준")
     ("撙" . "누를 준")
     ("皴" . "주름 준")
     ("綧" . "피륙의 폭의 넓이 준")
     ("罇" . "樽·尊과 同字")
     ("踆" . "그칠 준")
     ("蹲" . "걸터앉을 준")
     ("鐏" . "창고달 준")
     ("隼" . "새매 준")
     ("餕" . "대궁 준")
     ("鱒" . "송어 준")
     ("鵔" . "금계 준"))
    ("준거"
     "準據")
    ("준거안"
     "準據案")
    ("준결승"
     "準決勝")
    ("준결승전"
     "準決勝戰")
    ("준고정"
     "準固定")
    ("준공"
     "竣工")
    ("준공년"
     "竣工年")
    ("준공설"
     "竣工說")
    ("준공식"
     "竣工式")
    ("준공익"
     "準公益")
    ("준공일"
     "竣工日")
    ("준국가"
     "準國家")
    ("준기술자"
     "準技術者")
    ("준도시"
     "準都市")
    ("준동"
     "蠢動")
    ("준민고택"
     "浚民膏澤")
    ("준법"
     "遵法")
    ("준법정신"
     "遵法精神")
    ("준별"
     "峻別")
    ("준보전"
     "準保全")
    ("준비"
     "準備")
    ("준비금"
     "準備金")
    ("준비단"
     "準備團")
    ("준비물"
     "準備物")
    ("준비생"
     "準備生")
    ("준비서"
     "準備書")
    ("준비실"
     "準備室")
    ("준사관"
     "準士官")
    ("준선전"
     "準宣傳")
    ("준설"
     "浚渫")
    ("준수"
     "俊秀"
     "遵守")
    ("준엄"
     "峻嚴")
    ("준여권"
     "準旅券")
    ("준열"
     "峻烈")
    ("준우승"
     "準優勝")
    ("준위"
     "准尉")
    ("준장"
     "准將")
    ("준재"
     "俊才")
    ("준전시"
     "準戰時")
    ("준주거"
     "準住居")
    ("준준무식"
     "蠢蠢無識")
    ("준칙"
     "準則")
    ("준핵보유국"
     "準核保有國")
    ("준형"
     "俊兄")
    ("줄"
     ("茁" . "풀 처음 나는 모양 줄")
     ("乼" . "줄 줄"))
    ("줄탁동시"
     "啐啄同時")
    ("줏대감"
     "主大監")
    ("중"
     ("中" . "가운데 중")
     ("仲" . "버금 중")
     ("衆" . "무리 중")
     ("重" . "무거울 중")
     ("眾" . "衆의 本字"))
    ("중가"
     "重價")
    ("중간"
     "中間")
    ("중간고사"
     "中間考査")
    ("중간국"
     "中間國")
    ("중간보고"
     "中間報告")
    ("중간보고일"
     "中間報告日")
    ("중간색"
     "中間色")
    ("중간석"
     "中間石")
    ("중간시험"
     "中間試驗")
    ("중간자"
     "中間子")
    ("중간재"
     "中間財")
    ("중간적"
     "中間的")
    ("중간중간"
     "中間中間")
    ("중간착취"
     "中間搾取")
    ("중개"
     "仲介")
    ("중개료"
     "仲介料")
    ("중개상"
     "仲介商")
    ("중개업소"
     "仲介業所")
    ("중개업자"
     "仲介業者")
    ("중개인"
     "仲介人")
    ("중개자"
     "仲介者")
    ("중거리"
     "中距離")
    ("중건"
     "重建")
    ("중견"
     "中堅")
    ("중경상"
     "重輕傷")
    ("중계"
     "中繼")
    ("중계권료"
     "中繼權料")
    ("중계방송"
     "中繼放送")
    ("중계방송반"
     "中繼放送班")
    ("중계방송사"
     "中繼放送社")
    ("중계실"
     "中繼室")
    ("중계차"
     "中繼車")
    ("중고"
     "中古")
    ("중고교"
     "中高校")
    ("중고교생"
     "中高校生")
    ("중고생"
     "中高生")
    ("중고선"
     "中古船")
    ("중고차"
     "中古車")
    ("중고품"
     "中古品")
    ("중공업"
     "重工業")
    ("중과"
     "重課")
    ("중과부적"
     "衆寡不敵"
     "衆寡不敵")
    ("중과세"
     "重課稅")
    ("중교생"
     "中校生")
    ("중구금"
     "重拘禁")
    ("중구난방"
     "衆口難防")
    ("중구삭금"
     "衆口鑠金")
    ("중구일사"
     "衆口一辭")
    ("중국"
     "中國")
    ("중국어"
     "中國語")
    ("중국인"
     "中國人")
    ("중군"
     "中軍")
    ("중금속"
     "重金屬")
    ("중금채"
     "中金債")
    ("중급"
     "中級")
    ("중기"
     "中企"
     "中期")
    ("중기작"
     "中期作")
    ("중기차"
     "重機車")
    ("중남부권"
     "中南部圈")
    ("중년"
     "中年")
    ("중년기"
     "中年期")
    ("중년층"
     "中年層")
    ("중노난범"
     "衆怒難犯")
    ("중노동"
     "重勞動")
    ("중농"
     "中農")
    ("중농주의"
     "重農主義")
    ("중니지도"
     "仲尼之徒")
    ("중단"
     "中單"
     "中斷")
    ("중당"
     "中唐")
    ("중대"
     "中代"
     "中隊"
     "重大")
    ("중대사"
     "重大事")
    ("중대성"
     "重大性")
    ("중대장"
     "中隊長")
    ("중도"
     "中圖"
     "中途"
     "中道")
    ("중도금"
     "中途金")
    ("중도실상"
     "中道實相")
    ("중도적"
     "中道的")
    ("중독"
     "中毒")
    ("중독자"
     "中毒者")
    ("중독증"
     "中毒症")
    ("중동"
     "中東")
    ("중등"
     "中等")
    ("중등부"
     "中等部")
    ("중등학교"
     "中等學校")
    ("중략"
     "中略")
    ("중량"
     "重量")
    ("중량감"
     "重量感")
    ("중력"
     "重力")
    ("중력기"
     "中力機")
    ("중력이산"
     "衆力移山")
    ("중령"
     "中領")
    ("중론"
     "衆論")
    ("중류"
     "中流")
    ("중립"
     "中立"
     "中粒")
    ("중립국"
     "中立國")
    ("중립성"
     "中立性")
    ("중립적"
     "中立的")
    ("중립화"
     "中立化")
    ("중매"
     "仲媒")
    ("중매결혼"
     "仲媒結婚")
    ("중매인"
     "仲買人")
    ("중명"
     "中命")
    ("중명조"
     "重明朝")
    ("중무장"
     "重武裝")
    ("중문"
     "中門")
    ("중문과"
     "中文科")
    ("중문학과"
     "中文學科")
    ("중문화주의"
     "重文化主義")
    ("중반"
     "中半"
     "中盤")
    ("중벌"
     "重罰")
    ("중범위"
     "中範圍")
    ("중병"
     "重病")
    ("중복"
     "中伏"
     "重複")
    ("중복성"
     "重複性")
    ("중부"
     "中部")
    ("중부권"
     "中部圈")
    ("중사"
     "中士")
    ("중산"
     "中産")
    ("중산층"
     "中産層")
    ("중상"
     "重傷")
    ("중상모략"
     "中傷謀略")
    ("중상자"
     "重傷者")
    ("중상주의"
     "重商主義")
    ("중상층"
     "中上層")
    ("중생"
     "中生"
     "衆生")
    ("중생계"
     "衆生界")
    ("중생대"
     "中生代")
    ("중생상"
     "衆生相")
    ("중생적"
     "衆生的")
    ("중선"
     "重船")
    ("중선거구제"
     "中選擧區制")
    ("중성"
     "中性"
     "中聲")
    ("중성미자"
     "中性微子")
    ("중성자"
     "中性子")
    ("중성적"
     "中性的")
    ("중세"
     "中世")
    ("중세기"
     "中世紀")
    ("중세적"
     "中世的")
    ("중소"
     "中小")
    ("중소기업"
     "中小企業")
    ("중소기업가"
     "中小企業家")
    ("중소기업계"
     "中小企業界")
    ("중소기업관"
     "中小企業館")
    ("중소기업자"
     "中小企業者")
    ("중소기업체"
     "中小企業體")
    ("중소형"
     "中小型")
    ("중수"
     "重修"
     "重水")
    ("중수도"
     "中水道")
    ("중수부"
     "中搜部")
    ("중순"
     "中旬")
    ("중시"
     "重視")
    ("중식"
     "中食")
    ("중신"
     "重臣")
    ("중심"
     "中心"
     "重心")
    ("중심가"
     "中心街")
    ("중심국"
     "中心國")
    ("중심부"
     "中心部")
    ("중심선"
     "中心線")
    ("중심설"
     "中心說")
    ("중심인물"
     "中心人物")
    ("중심적"
     "中心的")
    ("중심제"
     "中心制")
    ("중심주의"
     "中心主義")
    ("중심주의적"
     "中心主義的")
    ("중심지"
     "中心地")
    ("중심체"
     "中心體")
    ("중심촌"
     "中心村")
    ("중심축"
     "中心軸")
    ("중심핵"
     "中心核")
    ("중심화"
     "中心化")
    ("중아"
     "衆我")
    ("중압"
     "重壓")
    ("중압감"
     "重壓感")
    ("중앙"
     "中央")
    ("중앙난방"
     "中央暖房")
    ("중앙당"
     "中央黨")
    ("중앙로"
     "中央路")
    ("중앙부"
     "中央部")
    ("중앙선"
     "中央線")
    ("중앙은행"
     "中央銀行")
    ("중앙적"
     "中央的")
    ("중앙회"
     "中央會")
    ("중양절"
     "重陽節")
    ("중어"
     "中語")
    ("중언부언"
     "重言復言")
    ("중역"
     "中譯"
     "重役")
    ("중엽"
     "中葉")
    ("중요"
     "重要")
    ("중요성"
     "重要性")
    ("중요시"
     "重要視")
    ("중용"
     "中庸"
     "重用")
    ("중용적"
     "重用的")
    ("중위"
     "中位"
     "中尉")
    ("중위도"
     "中緯度")
    ("중유"
     "重油")
    ("중음신"
     "中陰身")
    ("중읍례"
     "中揖禮")
    ("중의"
     "中衣")
    ("중의성림"
     "衆議成林")
    ("중의원"
     "衆議院")
    ("중인"
     "中人")
    ("중임"
     "重任")
    ("중장"
     "中將")
    ("중장거리"
     "中長距離")
    ("중장기적"
     "中長期的")
    ("중장년층"
     "中長年層")
    ("중장비"
     "重裝備")
    ("중재"
     "仲裁")
    ("중재원"
     "仲裁院")
    ("중재인"
     "仲裁人")
    ("중재자"
     "仲裁者")
    ("중저가"
     "中低價")
    ("중저가품"
     "中低價品")
    ("중전"
     "中殿")
    ("중절"
     "中絶")
    ("중절률"
     "中絶率")
    ("중점"
     "重點")
    ("중점적"
     "重點的")
    ("중조산"
     "中早産")
    ("중족골"
     "中足骨")
    ("중족측목"
     "重足側目")
    ("중졸"
     "中卒")
    ("중죄"
     "重罪")
    ("중증"
     "重症")
    ("중지"
     "中指"
     "中止")
    ("중지자"
     "中止者")
    ("중진"
     "重鎭")
    ("중진국"
     "中進國")
    ("중징계"
     "重懲戒")
    ("중차"
     "重車")
    ("중차대"
     "重且大")
    ("중창반"
     "重唱班")
    ("중책"
     "重責")
    ("중천"
     "中天")
    ("중첩"
     "重疊")
    ("중체"
     "中諦")
    ("중추"
     "中樞")
    ("중추적"
     "中樞的")
    ("중추절"
     "仲秋節")
    ("중축"
     "重築")
    ("중층"
     "中層")
    ("중층적"
     "中層的")
    ("중탕"
     "重湯")
    ("중태"
     "重態")
    ("중퇴"
     "中退")
    ("중파"
     "中波")
    ("중편"
     "中篇")
    ("중풍"
     "中風")
    ("중하급"
     "中下級")
    ("중하위권"
     "中下位圈")
    ("중학"
     "中學")
    ("중학교"
     "中學校")
    ("중학생"
     "中學生")
    ("중학생부"
     "中學生部")
    ("중합체"
     "重合體")
    ("중핵"
     "中核")
    ("중형"
     "中型"
     "重刑")
    ("중형선"
     "中型船")
    ("중호"
     "中戶")
    ("중화"
     "中和")
    ("중화상"
     "重火傷")
    ("중화학"
     "重化學")
    ("중환자"
     "重患者")
    ("중환자실"
     "重患者室")
    ("중후"
     "重厚")
    ("중흥"
     "中興")
    ("즉"
     "則"
     ("卽" . "곧 즉")
     ("即" . "卽의 俗字")
     "喞")
    ("즉각"
     "卽刻")
    ("즉각적"
     "卽刻的")
    ("즉결"
     "卽決")
    ("즉물적"
     "卽物的")
    ("즉사"
     "卽死")
    ("즉석"
     "卽席")
    ("즉석식품"
     "卽席食品")
    ("즉석요리"
     "卽席料理")
    ("즉시"
     "卽時")
    ("즉위"
     "卽位")
    ("즉일"
     "卽日")
    ("즉자적"
     "卽自的")
    ("즉지"
     "卽地")
    ("즉흥"
     "卽興")
    ("즉흥적"
     "卽興的")
    ("즐"
     ("櫛" . "빗 즐")
     ("喞" . "두런거릴 즐")
     ("騭" . "수말 즐"))
    ("즐비"
     "櫛比")
    ("즐풍목우"
     "櫛風沐雨")
    ("즙"
     ("楫" . "노 즙")
     ("汁" . "즙 즙")
     ("葺" . "기울 즙")
     "輯"
     ("檝" . "楫과 同字")
     ("蕺" . "삼백초 즙"))
    ("증"
     ("增" . "불을 증")
     ("憎" . "미워할 증")
     ("拯" . "건질 증")
     ("曾" . "일찍 증")
     ("烝" . "김 오를 증")
     ("甑" . "시루 증")
     ("症" . "증세 증")
     ("繒" . "비단 증")
     ("蒸" . "찔 증")
     ("證" . "증거 증")
     ("贈" . "보낼 증")
     ("嶒" . "산 높고 험할 증")
     ("矰" . "주살 증")
     ("罾" . "어망 증")
     "証")
    ("증가"
     "增加")
    ("증가량"
     "增加量")
    ("증가분"
     "增加分")
    ("증가세"
     "增加勢")
    ("증가액"
     "增加額")
    ("증가율"
     "增加率")
    ("증감"
     "增減")
    ("증강"
     "增强")
    ("증강론자"
     "增强論者")
    ("증개축"
     "增改築")
    ("증거"
     "證據")
    ("증거금"
     "證據金")
    ("증거물"
     "證據物")
    ("증과"
     "證果")
    ("증권"
     "證券")
    ("증권가"
     "證券街")
    ("증권계"
     "證券界")
    ("증권국"
     "證券局")
    ("증권사"
     "證券社")
    ("증권업"
     "證券業")
    ("증권업계"
     "證券業界")
    ("증기"
     "蒸氣")
    ("증대"
     "增大")
    ("증류"
     "蒸溜")
    ("증류수"
     "蒸溜水")
    ("증류주"
     "蒸溜酒")
    ("증명"
     "證明")
    ("증명사진"
     "證明寫眞")
    ("증명서"
     "證明書")
    ("증발"
     "增發"
     "蒸發")
    ("증발량"
     "蒸發量")
    ("증백제"
     "蒸白劑")
    ("증보판"
     "增補版")
    ("증산"
     "增産")
    ("증상"
     "症狀")
    ("증서"
     "證書")
    ("증설"
     "增設")
    ("증세"
     "增稅"
     "症勢")
    ("증손"
     "曾孫")
    ("증손녀"
     "曾孫女")
    ("증손부"
     "曾孫婦")
    ("증손자"
     "曾孫子")
    ("증시"
     "證市")
    ("증식"
     "增殖")
    ("증안"
     "證安")
    ("증액"
     "增額")
    ("증언"
     "證言")
    ("증언대"
     "證言臺")
    ("증언식"
     "證言式")
    ("증여"
     "贈與")
    ("증여세"
     "贈與稅")
    ("증오"
     "憎惡")
    ("증오감"
     "憎惡感")
    ("증원"
     "增員"
     "增援")
    ("증이파의"
     "甑已破矣")
    ("증인"
     "證人")
    ("증자"
     "增資")
    ("증자분"
     "增資分")
    ("증정"
     "贈呈")
    ("증조"
     "曾祖")
    ("증조모"
     "曾祖母")
    ("증좌"
     "證左")
    ("증진"
     "增進")
    ("증축"
     "增築")
    ("증파"
     "增派")
    ("증판"
     "增販")
    ("증폭"
     "增幅")
    ("증표"
     "證票")
    ("증후"
     "症候"
     "證候")
    ("증후군"
     "症候群")
    ("증후성"
     "症候性")
    ("지"
     ("之" . "갈 지")
     ("只" . "다만 지")
     ("咫" . "길이 지")
     ("地" . "땅 지")
     ("址" . "터 지")
     ("志" . "뜻 지")
     ("持" . "가질 지")
     ("指" . "손가락 지")
     ("摯" . "잡을 지")
     ("支" . "가를 지")
     ("旨" . "맛있을 지")
     ("智" . "슬기 지")
     ("枝" . "가지 지")
     ("枳" . "탱자나무 지")
     ("止" . "발 지")
     ("池" . "못 지")
     ("沚" . "물가 지")
     ("漬" . "담글 지")
     ("知" . "알 지")
     ("砥" . "숫돌 지")
     ("祇" . "마침 지")
     ("祉" . "복 지")
     ("祗" . "공경할 지")
     ("紙" . "종이 지")
     ("肢" . "사지 지")
     ("脂" . "기름 지")
     ("至" . "이를 지")
     ("芝" . "지초 지")
     ("芷" . "구리때 지")
     ("蜘" . "거미 지")
     ("誌" . "기록할 지")
     ("贄" . "폐백 지")
     ("趾" . "발 지")
     ("遲" . "늦을 지")
     ("識" . "표할 지")
     ("坻" . "모래섬 지")
     ("墀" . "계단 위의 공지 지")
     ("扺" . "손바닥 지")
     ("榰" . "주춧돌 지")
     ("泜" . "강 이름 지")
     ("痣" . "사마귀 지")
     ("秪" . "벼 처음 익을 지")
     "箎"
     ("篪" . "저 이름 지")
     ("舐" . "핥을 지")
     ("踟" . "머뭇거릴 지")
     ("躓" . "넘어질 지")
     ("軹" . "굴대 머리 지")
     ("阯" . "터 지")
     ("鮨" . "젓갈 지")
     ("鷙" . "맹금 지"))
    ("지가"
     "地價")
    ("지각"
     "地殼"
     "知覺"
     "遲刻")
    ("지갑"
     "紙匣")
    ("지검"
     "地檢")
    ("지경"
     "地境")
    ("지계"
     "持戒")
    ("지고"
     "至高")
    ("지고기양"
     "趾高氣揚")
    ("지고지상"
     "至高至上")
    ("지고지순"
     "至高至純")
    ("지공무사"
     "至公無私")
    ("지관"
     "地觀")
    ("지구"
     "地區"
     "地球")
    ("지구국"
     "地區局")
    ("지구당"
     "地區黨")
    ("지구력"
     "持久力")
    ("지구어"
     "地球語")
    ("지구적"
     "地球的")
    ("지구촌"
     "地球村")
    ("지구촌화"
     "地球村化")
    ("지국"
     "支局")
    ("지국장"
     "支局長")
    ("지극"
     "至極")
    ("지근거리"
     "至近距離")
    ("지근지처"
     "至近之處")
    ("지금"
     "只今")
    ("지급"
     "支給")
    ("지급기"
     "支給機")
    ("지급률"
     "支給率")
    ("지급설"
     "支給說")
    ("지급인"
     "支給人")
    ("지급일"
     "支給日")
    ("지기"
     "地氣"
     "知己"
     "至氣")
    ("지기론"
     "知己論")
    ("지기상합"
     "志氣相合")
    ("지기지우"
     "知己之友")
    ("지난"
     "至難")
    ("지난행이"
     "知難行易")
    ("지능"
     "知能")
    ("지능적"
     "知能的")
    ("지능화"
     "知能化")
    ("지당"
     "至當")
    ("지대"
     "地代"
     "地帶"
     "址臺"
     "至大")
    ("지대공"
     "地對空")
    ("지대어비"
     "指大於臂")
    ("지대화"
     "地帶化")
    ("지덕"
     "地德"
     "智德")
    ("지덕체"
     "智德體")
    ("지도"
     "地圖"
     "指導")
    ("지도과"
     "指導科")
    ("지도관실"
     "指導官室")
    ("지도국"
     "指導局")
    ("지도국장"
     "指導局長")
    ("지도급"
     "指導級")
    ("지도력"
     "指導力")
    ("지도부"
     "指導部")
    ("지도부실"
     "指導部室")
    ("지도부장"
     "指導部長")
    ("지도소"
     "指導所")
    ("지도실"
     "指導室")
    ("지도자"
     "指導者")
    ("지도자반"
     "指導者班")
    ("지도자적"
     "指導者的")
    ("지도적"
     "指導的")
    ("지도책"
     "地圖冊")
    ("지도층"
     "指導層")
    ("지독"
     "至毒")
    ("지독지애"
     "舐犢之愛")
    ("지동설"
     "地動說")
    ("지동지서"
     "之東之西"
     "指東指西")
    ("지둔"
     "智鈍")
    ("지득"
     "知得")
    ("지락"
     "至樂")
    ("지란지교"
     "芝蘭之交")
    ("지력"
     "地力"
     "知力")
    ("지령"
     "指令")
    ("지령문"
     "指令文")
    ("지령실"
     "指令室")
    ("지령인걸"
     "地靈人傑")
    ("지록위마"
     "指鹿爲馬")
    ("지론"
     "持論")
    ("지뢰"
     "地雷")
    ("지류"
     "支流")
    ("지리"
     "地利"
     "地理")
    ("지리관"
     "地理觀")
    ("지리멸렬"
     "支離滅裂")
    ("지리부도"
     "地理附圖")
    ("지리산"
     "智異山")
    ("지리서"
     "地理書")
    ("지리적"
     "地理的")
    ("지리학"
     "地理學")
    ("지리학과"
     "地理學科")
    ("지리학자"
     "地理學者")
    ("지리학적"
     "地理學的")
    ("지망"
     "志望")
    ("지망망"
     "地茫茫")
    ("지망생"
     "志望生")
    ("지망자"
     "志望者")
    ("지맥"
     "地脈")
    ("지면"
     "地面"
     "紙面"
     "誌面")
    ("지명"
     "地名"
     "指名")
    ("지명권"
     "指名權")
    ("지명도"
     "知名度")
    ("지명자"
     "指名者")
    ("지명지사"
     "知名之士")
    ("지목"
     "地木"
     "地目"
     "指目")
    ("지문"
     "地文"
     "指紋")
    ("지반"
     "地盤")
    ("지방"
     "地方"
     "紙榜"
     "脂肪")
    ("지방간"
     "脂肪肝")
    ("지방관"
     "地方官")
    ("지방당"
     "地方黨")
    ("지방대"
     "地方隊")
    ("지방도"
     "地方道")
    ("지방민"
     "地方民")
    ("지방별"
     "地方別")
    ("지방사"
     "地方社")
    ("지방색"
     "地方色")
    ("지방세"
     "地方稅")
    ("지방지"
     "地方紙")
    ("지방질"
     "脂肪質")
    ("지방청"
     "地方廳")
    ("지방층"
     "脂肪層")
    ("지방판"
     "地方版")
    ("지방화"
     "地方化")
    ("지배"
     "支配")
    ("지배권"
     "支配權")
    ("지배력"
     "支配力")
    ("지배론"
     "支配論")
    ("지배인"
     "支配人")
    ("지배자"
     "支配者")
    ("지배적"
     "支配的")
    ("지배층"
     "支配層")
    ("지법"
     "地法")
    ("지병"
     "持病")
    ("지복"
     "至福")
    ("지봉"
     "支峰")
    ("지부"
     "支部")
    ("지부작족"
     "知斧斫足")
    ("지부장"
     "支部長")
    ("지부장직"
     "支部長職")
    ("지분"
     "持分")
    ("지분율"
     "支分率")
    ("지불"
     "支拂")
    ("지불승굴"
     "指不勝屈")
    ("지불일"
     "支拂日")
    ("지사"
     "支社"
     "知事")
    ("지사장"
     "支社長")
    ("지사적"
     "志士的")
    ("지상"
     "地上"
     "紙上"
     "至上")
    ("지상계"
     "地上界")
    ("지상군"
     "地上軍")
    ("지상명령"
     "至上命令")
    ("지상적"
     "地上的")
    ("지상전"
     "地上戰")
    ("지상주의"
     "至上主義")
    ("지상주의자"
     "至上主義者")
    ("지상주의적"
     "至上主義的")
    ("지상주의파"
     "至上主義派")
    ("지서"
     "支署")
    ("지석"
     "誌石")
    ("지석묘"
     "支石墓")
    ("지성"
     "知性"
     "脂性"
     "至誠")
    ("지성감천"
     "至誠感天")
    ("지성계"
     "知性界")
    ("지성적"
     "知性的")
    ("지성파"
     "知性派")
    ("지세"
     "地勢")
    ("지소"
     "支所")
    ("지소모대"
     "知小謀大")
    ("지속"
     "持續")
    ("지속성"
     "持續性")
    ("지속적"
     "持續的")
    ("지수"
     "地水"
     "指數")
    ("지순"
     "至純")
    ("지시"
     "指示")
    ("지시판"
     "指示板")
    ("지식"
     "知識")
    ("지식수준"
     "知識水準")
    ("지식인"
     "知識人")
    ("지식인연"
     "知識人然")
    ("지식인적"
     "知識人的")
    ("지식층"
     "知識層")
    ("지신"
     "地神")
    ("지신족"
     "地神族")
    ("지압"
     "指壓")
    ("지양"
     "止揚")
    ("지엄"
     "至嚴")
    ("지역"
     "地域")
    ("지역감정"
     "地域感情")
    ("지역구"
     "地域區")
    ("지역권"
     "地役權")
    ("지역당"
     "地域黨")
    ("지역당적"
     "地域黨的")
    ("지역민"
     "地域民")
    ("지역사"
     "地域史")
    ("지역성"
     "地域性")
    ("지역신"
     "地域神")
    ("지역적"
     "地域的")
    ("지역주의"
     "地域主義")
    ("지역촌"
     "地域村")
    ("지역화"
     "地域化")
    ("지연"
     "地緣"
     "遲延")
    ("지연성"
     "地緣性")
    ("지연적"
     "地緣的")
    ("지연제"
     "地緣制")
    ("지엽"
     "枝葉")
    ("지엽적"
     "枝葉的")
    ("지옥"
     "地獄")
    ("지우"
     "智愚"
     "知友")
    ("지우산"
     "紙雨傘")
    ("지원"
     "志願"
     "支援"
     "支院")
    ("지원국"
     "支援國")
    ("지원군"
     "支援軍")
    ("지원금"
     "支援金")
    ("지원단"
     "支援團")
    ("지원법"
     "支援法")
    ("지원병"
     "志願兵")
    ("지원병제"
     "志願兵制")
    ("지원생"
     "支援生")
    ("지원서"
     "志願書")
    ("지원액"
     "支援額")
    ("지원율"
     "支援率")
    ("지원자"
     "志願者"
     "支援者")
    ("지원작"
     "支援作")
    ("지원적"
     "支援的")
    ("지원제"
     "支援制")
    ("지원책"
     "支援策")
    ("지원포"
     "支援砲")
    ("지원형"
     "支援型")
    ("지위"
     "地位")
    ("지육"
     "智育")
    ("지의류"
     "地衣類")
    ("지입"
     "支入")
    ("지자"
     "之字")
    ("지자제"
     "地自制")
    ("지자체"
     "地自體")
    ("지장"
     "支障")
    ("지재권"
     "知財權")
    ("지적"
     "地籍"
     "指摘"
     "知的")
    ("지적도"
     "地籍圖")
    ("지점"
     "地點"
     "指點"
     "支店")
    ("지점망"
     "支店網")
    ("지점장"
     "支店長")
    ("지점토"
     "地粘土")
    ("지정"
     "指定")
    ("지정석"
     "指定席")
    ("지정적"
     "地政的")
    ("지정학적"
     "地政學的")
    ("지조"
     "志操")
    ("지존"
     "至尊")
    ("지주"
     "地主"
     "持株"
     "支柱")
    ("지주적"
     "地主的")
    ("지주층"
     "地主層")
    ("지준금"
     "支準金")
    ("지준율"
     "支準率")
    ("지중"
     "智衆")
    ("지중선"
     "地中線")
    ("지지"
     "地誌"
     "支持")
    ("지지대"
     "支持臺")
    ("지지도"
     "支持度")
    ("지지부진"
     "遲遲不進")
    ("지지율"
     "支持率")
    ("지지자"
     "支持者")
    ("지지표"
     "支持票")
    ("지진"
     "地震")
    ("지진학"
     "地震學")
    ("지질"
     "地質"
     "紙質"
     "脂質")
    ("지질학"
     "地質學")
    ("지질학과"
     "地質學科")
    ("지질학자"
     "地質學者")
    ("지질학적"
     "地質學的")
    ("지참"
     "持參")
    ("지참금"
     "持參金")
    ("지척"
     "咫尺")
    ("지천"
     "至賤")
    ("지청"
     "支廳")
    ("지체"
     "肢體"
     "遲滯")
    ("지축"
     "地軸")
    ("지출"
     "支出")
    ("지층"
     "地層")
    ("지치주의"
     "知致主義")
    ("지침"
     "指針")
    ("지침서"
     "指針書")
    ("지칭"
     "指稱")
    ("지탄"
     "指彈")
    ("지판"
     "地板")
    ("지평"
     "地平")
    ("지평선"
     "地平線")
    ("지폐"
     "紙幣")
    ("지표"
     "地表"
     "指標")
    ("지표면"
     "地表面")
    ("지표적"
     "指標的")
    ("지필묵"
     "紙筆墨")
    ("지하"
     "地下")
    ("지하계"
     "地下界")
    ("지하공작"
     "地下工作")
    ("지하당"
     "地下黨")
    ("지하도"
     "地下道")
    ("지하상가"
     "地下商街")
    ("지하수"
     "地下水")
    ("지하실"
     "地下室")
    ("지하자원"
     "地下資源")
    ("지하철"
     "地下鐵")
    ("지하철역"
     "地下鐵驛")
    ("지향"
     "志向"
     "指向")
    ("지향성"
     "志向性")
    ("지향적"
     "指向的")
    ("지향점"
     "指向點")
    ("지혈"
     "止血")
    ("지혈대"
     "止血帶")
    ("지혈법"
     "止血法")
    ("지형"
     "地形")
    ("지형도"
     "地形圖")
    ("지형성"
     "地形性")
    ("지형적"
     "地形的")
    ("지혜"
     "智慧")
    ("지회"
     "支會")
    ("지회장"
     "支會長")
    ("지휘"
     "指揮")
    ("지휘관"
     "指揮官")
    ("지휘권"
     "指揮權")
    ("지휘봉"
     "指揮棒")
    ("지휘부"
     "指揮部")
    ("지휘소"
     "指揮所")
    ("지휘자"
     "指揮者")
    ("직"
     ("直" . "곧을 직")
     ("稙" . "올벼 직")
     ("稷" . "기장 직")
     ("織" . "짤 직")
     ("職" . "벼슬 직")
     ("禝" . "사람 이름 직"))
    ("직각"
     "直角")
    ("직감"
     "直感")
    ("직감력"
     "直感力")
    ("직감적"
     "直感的")
    ("직거래"
     "直去來")
    ("직격"
     "直擊")
    ("직결"
     "直結")
    ("직경"
     "直徑")
    ("직계"
     "直系")
    ("직계손"
     "直系孫")
    ("직공"
     "織工")
    ("직관"
     "直觀"
     "職官")
    ("직관력"
     "直觀力")
    ("직관적"
     "直觀的")
    ("직군"
     "職群")
    ("직권"
     "職權")
    ("직금"
     "織金")
    ("직급"
     "職級")
    ("직능"
     "職能")
    ("직능계"
     "職能係")
    ("직렬"
     "直列")
    ("직령"
     "直領")
    ("직류"
     "直流")
    ("직립"
     "直立")
    ("직립적"
     "直立的")
    ("직립형"
     "直立型")
    ("직매점"
     "直賣店")
    ("직면"
     "直面")
    ("직무"
     "職務")
    ("직물"
     "織物")
    ("직물학"
     "織物學")
    ("직반입"
     "直搬入")
    ("직방체"
     "直方體")
    ("직배"
     "直配")
    ("직분"
     "職分")
    ("직사각형"
     "直四角形")
    ("직사광선"
     "直射光線")
    ("직삼각형"
     "直三角形")
    ("직선"
     "直線"
     "直選")
    ("직선거리"
     "直線距離")
    ("직선적"
     "直線的")
    ("직선제"
     "直選制")
    ("직설법"
     "直說法")
    ("직설적"
     "直說的")
    ("직성"
     "直星"
     "織成")
    ("직소력"
     "直訴力")
    ("직속"
     "直屬")
    ("직속지"
     "直屬地")
    ("직송"
     "直送")
    ("직수입"
     "直輸入")
    ("직승기"
     "直昇機")
    ("직시"
     "直視")
    ("직언"
     "直言")
    ("직업"
     "職業")
    ("직업관"
     "職業觀")
    ("직업란"
     "職業欄")
    ("직업력"
     "職業力")
    ("직업병"
     "職業病")
    ("직업소개소"
     "職業紹介所")
    ("직업여성"
     "職業女性")
    ("직업윤리"
     "職業倫理")
    ("직업의식"
     "職業意識")
    ("직업인"
     "職業人")
    ("직업적"
     "職業的")
    ("직업혁명가"
     "職業革命家")
    ("직업화"
     "職業化")
    ("직역"
     "直譯"
     "職役")
    ("직영"
     "直營")
    ("직원"
     "直員"
     "職員")
    ("직원실"
     "職員室")
    ("직위"
     "職位")
    ("직인"
     "職人"
     "職印")
    ("직장"
     "直腸"
     "職場"
     "職長")
    ("직장성"
     "職場性")
    ("직장인"
     "職場人")
    ("직전"
     "直前"
     "職田")
    ("직접"
     "直接")
    ("직접성"
     "直接性")
    ("직접세"
     "直接稅")
    ("직접적"
     "直接的")
    ("직제"
     "職制")
    ("직조"
     "織造")
    ("직조기"
     "織造機")
    ("직종"
     "職種")
    ("직진"
     "直進")
    ("직책"
     "職責")
    ("직통"
     "直通")
    ("직판"
     "直販")
    ("직판장"
     "直販場")
    ("직할"
     "直轄")
    ("직할시"
     "直轄市")
    ("직함"
     "職銜")
    ("직행"
     "直行")
    ("직후"
     "直後")
    ("진"
     ("唇" . "놀랄 진")
     ("嗔" . "성낼 진")
     ("塵" . "띠끌 진")
     ("振" . "떨칠 진")
     ("搢" . "꽂을 진")
     ("晉" . "進과 同字")
     ("晋" . "晉의 俗字")
     ("桭" . "평고대 진")
     ("榛" . "개암나무 진")
     ("殄" . "끊어질 진")
     ("津" . "나루 진")
     ("溱" . "많을 진")
     ("珍" . "보배 진")
     ("瑨" . "아름다운 돌 진")
     ("璡" . "옥돌 진")
     ("畛" . "두렁길 진")
     ("疹" . "홍역 진")
     ("盡" . "다할 진")
     ("眞" . "참 진")
     ("瞋" . "부릅뜰 진")
     ("秦" . "벼 이름 진")
     ("縉" . "搢과 同字")
     ("縝" . "삼실 진")
     ("臻" . "이를 진")
     ("蔯" . "더워지기 진")
     ("袗" . "홑옷 진")
     ("診" . "볼 진")
     ("賑" . "구휼할 진")
     ("軫" . "수레 뒤턱 나무 진")
     ("辰" . "다섯째지지 진")
     ("進" . "나아갈 진")
     ("鎭" . "누를 진")
     ("陣" . "줄 진")
     ("陳" . "늘어놓을 진")
     ("震" . "벼락 진")
     ("侲" . "동자 진")
     ("儘" . "盡과 同字")
     ("珒" . "옥 이름 진")
     "瑱"
     ("稹" . "떨기로 날 진")
     ("蓁" . "우거질 진")
     ("螴" . "설렐 진")
     ("趁" . "좇을 진")
     ("鉁" . "보배 진")
     ("鬒" . "숱 많을 진"))
    ("진가"
     "眞價")
    ("진갑"
     "進甲")
    ("진격"
     "進擊")
    ("진경"
     "珍景")
    ("진경산수"
     "眞景山水")
    ("진골"
     "眞骨")
    ("진공"
     "眞空")
    ("진공관"
     "眞空管")
    ("진공청소기"
     "眞空淸掃器")
    ("진국"
     "辰國")
    ("진귀"
     "珍貴")
    ("진급"
     "進級")
    ("진기"
     "珍奇")
    ("진기록"
     "眞記錄")
    ("진노"
     "瞋怒")
    ("진단"
     "診斷")
    ("진단기"
     "診斷機")
    ("진단명"
     "診斷名")
    ("진단법"
     "診斷法")
    ("진단서"
     "診斷書")
    ("진단적"
     "診斷的")
    ("진담"
     "眞談")
    ("진도"
     "進度")
    ("진도율"
     "進度率")
    ("진돗"
     "珍島")
    ("진동"
     "振動"
     "震動")
    ("진동수"
     "振動數")
    ("진동자"
     "振動子")
    ("진두지휘"
     "陣頭指揮")
    ("진력"
     "盡力")
    ("진로"
     "進路")
    ("진료"
     "診療")
    ("진료비"
     "診療費")
    ("진료실"
     "診療室")
    ("진료진"
     "診療陣")
    ("진리"
     "眞理")
    ("진리성"
     "眞理性")
    ("진맥"
     "診脈")
    ("진면목"
     "眞面目")
    ("진미"
     "珍味"
     "眞味")
    ("진보"
     "進步")
    ("진보성"
     "進步性")
    ("진보적"
     "進步的")
    ("진보주의"
     "進步主義")
    ("진보주의자"
     "進步主義者")
    ("진보파"
     "進步派")
    ("진부"
     "陳腐")
    ("진부성"
     "陳腐性")
    ("진사"
     "進士")
    ("진산"
     "鎭山")
    ("진상"
     "眞相"
     "進上")
    ("진상품"
     "進上品")
    ("진서"
     "眞書")
    ("진선미"
     "眞善美")
    ("진설"
     "陳設")
    ("진속"
     "眞俗")
    ("진솔"
     "眞率")
    ("진수"
     "眞髓")
    ("진수성찬"
     "珍羞盛饌")
    ("진술"
     "陳述")
    ("진술권"
     "陳述權")
    ("진술서"
     "陳述書")
    ("진신"
     "眞身")
    ("진실"
     "眞實")
    ("진실성"
     "眞實性")
    ("진심"
     "眞心")
    ("진압"
     "鎭壓")
    ("진압군"
     "鎭壓軍")
    ("진압책"
     "鎭壓策")
    ("진애"
     "塵埃")
    ("진언"
     "進言")
    ("진여"
     "眞如")
    ("진열"
     "陳列")
    ("진열대"
     "陳列臺")
    ("진열장"
     "陳列欌")
    ("진열창"
     "陳列窓")
    ("진영"
     "陣營")
    ("진용"
     "陣容")
    ("진운"
     "進運")
    ("진원"
     "震源")
    ("진원지"
     "震源地")
    ("진위"
     "眞僞")
    ("진의"
     "眞意")
    ("진일보"
     "進一步")
    ("진입"
     "進入")
    ("진입로"
     "進入路")
    ("진자"
     "振子")
    ("진자시계"
     "振子時計")
    ("진작"
     "振作")
    ("진전"
     "進展"
     "陳田")
    ("진전화"
     "陳田化")
    ("진정"
     "眞情"
     "眞正"
     "鎭靜"
     "陳情")
    ("진정서"
     "陳情書")
    ("진정성"
     "眞正性")
    ("진종일"
     "盡終日")
    ("진주"
     "眞珠"
     "進駐")
    ("진주담"
     "眞珠淡")
    ("진주사"
     "眞珠紗")
    ("진지"
     "眞摯"
     "陣地")
    ("진진"
     "津津")
    ("진찰"
     "診察")
    ("진찰실"
     "診察室")
    ("진척"
     "進陟")
    ("진초록"
     "津草綠")
    ("진출"
     "進出")
    ("진출설"
     "進出說")
    ("진취"
     "進取")
    ("진취적"
     "進取的")
    ("진통"
     "陣痛")
    ("진통제"
     "鎭痛劑")
    ("진퇴"
     "進退")
    ("진퇴양난"
     "進退兩難")
    ("진퇴유곡"
     "進退維谷")
    ("진폭"
     "振幅")
    ("진품"
     "眞品")
    ("진풍경"
     "珍風景")
    ("진학"
     "進學")
    ("진학률"
     "進學率")
    ("진행"
     "進行")
    ("진행상"
     "進行相")
    ("진행자"
     "進行者")
    ("진행자상"
     "進行者賞")
    ("진행표"
     "進行表")
    ("진호"
     "鎭護")
    ("진혼곡"
     "鎭魂曲")
    ("진홍"
     "眞紅")
    ("진홍색"
     "眞紅色")
    ("진화"
     "進化"
     "鎭火")
    ("진화론"
     "進化論")
    ("진화론적"
     "進化論的")
    ("진화사"
     "進化史")
    ("진화적"
     "進化的")
    ("진휼"
     "賑恤")
    ("진흥"
     "振興")
    ("진흥국"
     "振興局")
    ("진흥국장"
     "振興局長")
    ("진흥책"
     "振興策")
    ("질"
     ("佚" . "흐릴 질")
     ("侄" . "어리석을 질")
     ("叱" . "꾸짖을 질")
     ("姪" . "조카 질")
     ("嫉" . "미워할 질")
     ("帙" . "책갑 질")
     ("桎" . "차꼬 질")
     ("瓆" . "사람 이름 질")
     ("疾" . "병 질")
     ("秩" . "차례 질")
     ("窒" . "막을 질")
     ("膣" . "새살 날 질")
     ("蛭" . "거머리 질")
     ("質" . "바탕 질")
     ("跌" . "넘어질 질")
     ("迭" . "갈마들 질")
     "咥"
     ("垤" . "개밋둑 질")
     ("絰" . "질 질")
     ("蒺" . "납가새 질")
     "躓"
     "軼"
     ("郅" . "고을 이름 질")
     ("鑕" . "모루 질")
     "騭")
    ("질감"
     "質感")
    ("질곡"
     "桎梏")
    ("질권"
     "質權")
    ("질량"
     "質量")
    ("질료"
     "質料")
    ("질문"
     "質問")
    ("질문벽"
     "質問癖")
    ("질문지"
     "質問紙")
    ("질박"
     "質樸")
    ("질병"
     "疾病")
    ("질산"
     "窒酸")
    ("질산성"
     "窒酸性")
    ("질산염"
     "窒酸鹽")
    ("질색"
     "窒塞")
    ("질서"
     "秩序")
    ("질서화"
     "秩序化")
    ("질소"
     "窒素")
    ("질시"
     "嫉視"
     "疾視")
    ("질식"
     "窒息")
    ("질식사"
     "窒息死")
    ("질의"
     "質疑")
    ("질의서"
     "質疑書")
    ("질적"
     "質的")
    ("질정"
     "叱正")
    ("질주"
     "疾走")
    ("질주력"
     "疾走力")
    ("질주범"
     "疾走犯")
    ("질책"
     "叱責")
    ("질타"
     "叱咤")
    ("질탕"
     "跌宕")
    ("질투"
     "嫉妬")
    ("질투심"
     "嫉妬心")
    ("질풍"
     "疾風")
    ("질풍노도"
     "疾風怒濤")
    ("질환"
     "疾患")
    ("질환자"
     "疾患者")
    ("짐"
     ("斟" . "술 따를 짐")
     ("朕" . "나 짐")
     "酖"
     ("鴆" . "짐새 짐"))
    ("짐작"
     "斟酌")
    ("집"
     ("執" . "잡을 집")
     ("潗" . "샘솟을 집")
     ("緝" . "낳을 집")
     ("輯" . "모을 집")
     ("鏶" . "판금 집")
     ("集" . "모일 집")
     ("什" . "세간 집")
     ("咠" . "참소할 집")
     ("戢" . "그칠 집"))
    ("집결"
     "集結")
    ("집결지"
     "集結地")
    ("집계"
     "集計")
    ("집권"
     "執權"
     "集權")
    ("집권기"
     "執權期")
    ("집권당"
     "執權黨")
    ("집권력"
     "執權力")
    ("집권자"
     "執權者")
    ("집권적"
     "執權的")
    ("집권제"
     "執權制")
    ("집권층"
     "執權層")
    ("집권화"
     "執權化")
    ("집기"
     "什器")
    ("집기병"
     "集氣甁")
    ("집념"
     "執念")
    ("집단"
     "集團")
    ("집단무"
     "集團舞")
    ("집단의식"
     "集團意識")
    ("집단적"
     "集團的")
    ("집단주의"
     "集團主義")
    ("집단행동"
     "集團行動")
    ("집단화"
     "集團化")
    ("집대성"
     "集大成")
    ("집도"
     "執刀")
    ("집무"
     "執務")
    ("집무실"
     "執務室")
    ("집사"
     "執事")
    ("집사부"
     "執事部")
    ("집성"
     "集成")
    ("집성제"
     "集聖諦")
    ("집성촌"
     "集姓村")
    ("집수리"
     "­修理")
    ("집시"
     "集示")
    ("집약"
     "集約")
    ("집약적"
     "集約的")
    ("집약형"
     "集約型")
    ("집어"
     "集魚")
    ("집어등"
     "集魚燈")
    ("집요"
     "執拗")
    ("집장사령"
     "執杖使令")
    ("집적"
     "集積")
    ("집적도"
     "集積度")
    ("집전"
     "執典")
    ("집점"
     "集點")
    ("집정관"
     "執政官")
    ("집정부제"
     "執政府制")
    ("집중"
     "執中"
     "集中")
    ("집중력"
     "集中力")
    ("집중률"
     "集中率")
    ("집중적"
     "集中的")
    ("집중제"
     "集中制")
    ("집중화"
     "集中化")
    ("집진기"
     "集塵機")
    ("집착"
     "執着")
    ("집총"
     "執銃")
    ("집필"
     "執筆")
    ("집필실"
     "執筆室")
    ("집필자"
     "執筆者")
    ("집하"
     "集荷")
    ("집하장"
     "集荷場")
    ("집합"
     "集合")
    ("집합소"
     "集合所")
    ("집합적"
     "集合的")
    ("집합주의"
     "集合主義")
    ("집합체"
     "集合體")
    ("집행"
     "執行")
    ("집행당"
     "執行當")
    ("집행령"
     "執行令")
    ("집행부"
     "執行部")
    ("집행자"
     "執行者")
    ("집회"
     "集會")
    ("징"
     ("徵" . "부를 징")
     ("懲" . "혼날 징")
     ("澄" . "맑을 징")
     ("澂" . "澄과 同字")
     ("瀓" . "맑을 징")
     ("癥" . "적취 징")
     ("瞪" . "바로 볼 징"))
    ("징계"
     "懲戒")
    ("징계자"
     "懲戒者")
    ("징발"
     "徵發")
    ("징벌"
     "懲罰")
    ("징병"
     "徵兵")
    ("징세"
     "徵稅")
    ("징세권"
     "徵稅權")
    ("징수"
     "徵收")
    ("징수부"
     "徵收部")
    ("징수액"
     "徵收額")
    ("징역"
     "懲役")
    ("징역형"
     "懲役刑")
    ("징용"
     "徵用")
    ("징용당"
     "徵用當")
    ("징용자"
     "徵用者")
    ("징조"
     "徵兆")
    ("징집"
     "徵集")
    ("징집당"
     "徵集當")
    ("징치"
     "懲治")
    ("징표"
     "徵標")
    ("징후"
     "徵候")
    ("차"
     ("且" . "또 차")
     ("侘" . "실의할 차")
     ("借" . "빌 차")
     ("叉" . "깍지낄 차")
     ("嗟" . "탄식할 차")
     ("嵯" . "우뚝 솟을 차")
     ("差" . "어긋날 차")
     ("次" . "버금 차")
     ("此" . "이 차")
     ("磋" . "윤낼 차")
     ("箚" . "차자 차")
     ("蹉" . "넘어질 차")
     ("車" . "수레 차")
     ("遮" . "막을 차")
     ("釵" . "비녀 차")
     ("茶" . "차 차")
     ("佽" . "도울 차")
     ("偖" . "찢을 차")
     ("奓" . "오만할 차")
     ("岔" . "갈림길 차")
     ("徣" . "빌릴 차")
     ("槎" . "뗏목 차")
     ("瑳" . "깨끗할 차")
     ("硨" . "조개 이름 차")
     "苴")
    ("차감"
     "差減")
    ("차고"
     "車庫")
    ("차과로초"
     "車過路草")
    ("차관"
     "借款"
     "次官")
    ("차관보"
     "次官補")
    ("차기"
     "次期"
     "此機")
    ("차남"
     "次男")
    ("차내"
     "車內")
    ("차단"
     "遮斷")
    ("차단당"
     "遮斷當")
    ("차단술"
     "遮斷術")
    ("차단식"
     "遮斷式")
    ("차단제"
     "遮斷制")
    ("차도"
     "差度"
     "車道")
    ("차동식"
     "差動式")
    ("차등"
     "差等")
    ("차량"
     "車輛")
    ("차례"
     "次例"
     "茶禮")
    ("차례용품"
     "茶禮用品")
    ("차례차례"
     "次例次例")
    ("차륜승"
     "車輪乘")
    ("차명"
     "借名")
    ("차별"
     "差別")
    ("차별상"
     "差別狀")
    ("차별성"
     "差別性")
    ("차별적"
     "差別的")
    ("차별주의"
     "差別主義")
    ("차별화"
     "差別化")
    ("차분"
     "次分")
    ("차비"
     "差備"
     "車費")
    ("차석"
     "次席")
    ("차선"
     "次善"
     "車線")
    ("차선책"
     "次善策")
    ("차세대"
     "次世代")
    ("차수"
     "次帥")
    ("차순위자"
     "次順位者")
    ("차안"
     "此岸")
    ("차액"
     "差額")
    ("차양"
     "遮陽")
    ("차용"
     "借用")
    ("차원"
     "次元")
    ("차율"
     "差率")
    ("차이"
     "差異")
    ("차이성"
     "差異性")
    ("차이점"
     "差異點")
    ("차익"
     "差益")
    ("차일"
     "遮日")
    ("차일피일"
     "此日彼日")
    ("차입"
     "借入")
    ("차입금"
     "借入金")
    ("차입액"
     "借入額")
    ("차자"
     "次子")
    ("차장"
     "次長"
     "車掌")
    ("차장보"
     "次長補")
    ("차장직"
     "次長職")
    ("차전"
     "次戰"
     "車戰")
    ("차전자"
     "車前子")
    ("차전초"
     "車前草")
    ("차점"
     "次點")
    ("차점자"
     "次點者")
    ("차점작"
     "次點作")
    ("차정"
     "差定")
    ("차제"
     "此際")
    ("차종"
     "車種")
    ("차질"
     "蹉跌")
    ("차차"
     "次次")
    ("차창"
     "車窓")
    ("차체"
     "車體")
    ("차출"
     "差出")
    ("차치"
     "且置")
    ("차폭"
     "車幅")
    ("차표"
     "車票")
    ("차후"
     "此後")
    ("착"
     ("捉" . "잡을 착")
     ("搾" . "짤 착")
     ("着" . "붙을 착")
     ("窄" . "좁을 착")
     ("著" . "분명할 착")
     ("躇" . "머뭇거릴 착")
     ("錯" . "섞일 착")
     ("鑿" . "뚫을 착")
     ("齪" . "악착할 착")
     ("戳" . "창으로 찌를 착")
     ("擉" . "찌를 착")
     ("斲" . "깎을 착"))
    ("착각"
     "錯覺")
    ("착공"
     "着工")
    ("착관"
     "着冠")
    ("착근"
     "着根")
    ("착란"
     "錯亂")
    ("착란적"
     "錯亂的")
    ("착륙"
     "着陸")
    ("착목"
     "着目")
    ("착복"
     "着服")
    ("착상"
     "着床"
     "着想")
    ("착색"
     "着色")
    ("착색제"
     "着色劑")
    ("착석"
     "着席")
    ("착수"
     "着手"
     "窄袖")
    ("착실"
     "着實")
    ("착안"
     "着眼")
    ("착오"
     "錯誤")
    ("착용"
     "着用")
    ("착용자"
     "着用者")
    ("착잡"
     "錯雜")
    ("착지"
     "着地")
    ("착취"
     "搾取")
    ("착취당"
     "搾取當")
    ("착취자"
     "搾取者")
    ("찬"
     ("撰" . "지을 찬")
     ("澯" . "맑을 찬")
     ("燦" . "빛날 찬")
     ("璨" . "빛날 찬")
     ("瓚" . "제기 찬")
     ("竄" . "숨을 찬")
     ("簒" . "빼앗을 찬")
     ("粲" . "정미 찬")
     ("纂" . "모을 찬")
     ("纘" . "이을 찬")
     ("讚" . "기릴 찬")
     ("贊" . "도울 찬")
     ("鑽" . "끌 찬")
     "飡"
     ("餐" . "먹을 찬")
     ("饌" . "반찬 찬")
     ("儧" . "모일 찬")
     ("儹" . "모을 찬")
     ("劗" . "끊을 찬")
     ("巑" . "높이 솟을 찬")
     ("攢" . "모일 찬")
     ("欑" . "모일 찬")
     ("爨" . "불땔 찬")
     ("趲" . "놀라 흩어질 찬"))
    ("찬동"
     "贊同")
    ("찬란"
     "燦爛")
    ("찬미"
     "讚美")
    ("찬반"
     "贊反")
    ("찬반양론"
     "贊反兩論")
    ("찬사"
     "讚辭")
    ("찬성"
     "贊成")
    ("찬송가"
     "讚頌歌")
    ("찬양"
     "讚揚")
    ("찬연"
     "燦然")
    ("찬염전"
     "瓚染典")
    ("찬장"
     "饌欌")
    ("찬조"
     "贊助")
    ("찬탄"
     "讚歎")
    ("찬탈"
     "簒奪")
    ("찬합"
     "饌盒")
    ("찰"
     ("刹" . "절 찰")
     ("察" . "살필 찰")
     ("擦" . "뿌릴 찰")
     ("札" . "패 찰")
     ("紮" . "감을 찰")
     ("扎" . "뺄 찰")
     ("拶" . "핍박할 찰"))
    ("찰나"
     "刹那")
    ("찰나적"
     "刹那的")
    ("참"
     ("僭" . "참람할 참")
     ("參" . "간여할 참")
     ("塹" . "구덩이 참")
     ("慘" . "참혹할 참")
     ("慙" . "부끄러울 참")
     ("懺" . "뉘우칠 참")
     ("斬" . "벨 참")
     ("站" . "우두커니 설 참")
     ("讒" . "참소할 참")
     ("讖" . "참서 참")
     ("儳" . "어긋날 참")
     ("叅" . "의논할 참")
     ("嶄" . "높을 참")
     ("巉" . "가파를 참")
     ("慚" . "부끄러울 참")
     ("憯" . "슬퍼할 참")
     "摻"
     ("攙" . "찌를 참")
     ("槧" . "판 참")
     ("欃" . "살별 참")
     ("毚" . "토끼 참")
     ("譖" . "참소할 참")
     ("鏨" . "끌 참")
     ("鑱" . "보습 참")
     ("饞" . "탐할 참")
     ("驂" . "곁마 참")
     ("黲" . "검푸르죽죽할 참"))
    ("참가"
     "參加")
    ("참가비"
     "參加費")
    ("참가인"
     "參加人")
    ("참가자"
     "參加者")
    ("참가작"
     "參加作")
    ("참견"
     "參見")
    ("참고"
     "參考")
    ("참고서"
     "參考書")
    ("참고인"
     "參考人")
    ("참관"
     "參觀")
    ("참관인"
     "參觀人")
    ("참관인단"
     "參觀人團")
    ("참관자"
     "參觀者")
    ("참구"
     "參究")
    ("참극"
     "慘劇")
    ("참담"
     "慘憺"
     "慘澹")
    ("참례"
     "參禮")
    ("참모"
     "參謀")
    ("참모부"
     "參謀部")
    ("참모장"
     "參謀長")
    ("참배"
     "參拜")
    ("참배객"
     "參拜客")
    ("참변"
     "慘變")
    ("참봉"
     "參奉")
    ("참사"
     "慘事")
    ("참사관"
     "參事官")
    ("참상"
     "慘狀")
    ("참석"
     "參席")
    ("참석자"
     "參席者")
    ("참선"
     "參禪")
    ("참신"
     "斬新")
    ("참신성"
     "斬新性")
    ("참여"
     "參與")
    ("참여권"
     "參與權")
    ("참여도"
     "參與度")
    ("참여율"
     "參與率")
    ("참여적"
     "參與的")
    ("참예"
     "參預")
    ("참의원"
     "參議院")
    ("참작"
     "參酌")
    ("참작론"
     "參酌論")
    ("참전"
     "參戰")
    ("참전국"
     "參戰國")
    ("참전자"
     "參戰者")
    ("참정"
     "參政")
    ("참정권"
     "參政權")
    ("참조"
     "參照")
    ("참조적"
     "參照的")
    ("참주"
     "僭主")
    ("참판"
     "參判")
    ("참패"
     "慘敗")
    ("참호"
     "塹壕")
    ("참혹"
     "慘酷")
    ("참화"
     "慘禍")
    ("참회"
     "慙悔"
     "懺悔")
    ("찻간"
     "車間")
    ("찻상"
     "茶床")
    ("찻잔"
     "茶盞")
    ("찻주전자"
     "茶酒煎子")
    ("창"
     ("倉" . "곳집 창")
     ("倡" . "여광대 창")
     ("創" . "비롯할 창")
     ("唱" . "노래 창")
     ("娼" . "몸 파는 여자 창")
     ("廠" . "헛간 창")
     ("彰" . "밝을 창")
     ("愴" . "슬퍼할 창")
     ("敞" . "높을 창")
     ("昌" . "창성할 창")
     ("昶" . "밝을 창")
     ("暢" . "펼 창")
     ("槍" . "창 창")
     ("滄" . "찰 창")
     ("漲" . "불을 창")
     ("猖" . "미쳐 날뛸 창")
     ("瘡" . "부스럼 창")
     ("窓" . "창 창")
     ("脹" . "배부를 창")
     ("艙" . "선창 창")
     ("菖" . "창포 창")
     ("蒼" . "푸를 창")
     ("倀" . "미칠 창")
     ("傖" . "천할 창")
     ("凔" . "찰 창")
     ("刱" . "비롯할 창")
     ("悵" . "슬퍼할 창")
     ("惝" . "멍할 창")
     "憃"
     ("戧" . "다칠 창")
     ("搶" . "닿을 창")
     ("氅" . "새털 창")
     ("瑲" . "옥 소리 창")
     ("窗" . "창 창")
     ("窻" . "창 창")
     ("蹌" . "추창할 창")
     "鋹"
     "錆"
     "鎗"
     "鏦"
     "閶"
     "鬯"
     "鶬")
    ("창가"
     "唱歌")
    ("창간"
     "創刊")
    ("창간사"
     "創刊辭")
    ("창간호"
     "創刊號")
    ("창건"
     "創建")
    ("창건일"
     "創建日")
    ("창검"
     "槍劍")
    ("창고"
     "倉庫")
    ("창고업"
     "倉庫業")
    ("창공"
     "蒼空")
    ("창구"
     "窓口")
    ("창군"
     "創軍")
    ("창기"
     "娼妓")
    ("창녀"
     "娼女")
    ("창단"
     "創團")
    ("창달"
     "暢達")
    ("창당"
     "創黨")
    ("창도"
     "唱導")
    ("창립"
     "創立")
    ("창만"
     "脹滿")
    ("창문"
     "窓門")
    ("창백"
     "蒼白")
    ("창사"
     "創社")
    ("창생"
     "蒼生")
    ("창설"
     "創設")
    ("창시"
     "創始")
    ("창시자"
     "創始者")
    ("창씨개명"
     "創氏改名")
    ("창안"
     "創案")
    ("창안자"
     "創案者")
    ("창업"
     "創業")
    ("창업자"
     "創業者")
    ("창업주"
     "創業主")
    ("창업주적"
     "創業主的")
    ("창유리"
     "窓琉璃")
    ("창의"
     "倡義"
     "創意")
    ("창의력"
     "創意力")
    ("창의성"
     "創意性")
    ("창의적"
     "創意的")
    ("창작"
     "創作")
    ("창작가"
     "創作家")
    ("창작극"
     "創作劇")
    ("창작물"
     "創作物")
    ("창작성"
     "創作性")
    ("창작실"
     "創作室")
    ("창작열"
     "創作熱")
    ("창작자"
     "創作者")
    ("창작집"
     "創作集")
    ("창작품"
     "創作品")
    ("창장"
     "倉長")
    ("창제"
     "創製")
    ("창조"
     "創造")
    ("창조력"
     "創造力")
    ("창조론"
     "創造論")
    ("창조물"
     "創造物")
    ("창조성"
     "創造性")
    ("창조자"
     "創造者")
    ("창조적"
     "創造的")
    ("창조주"
     "創造主")
    ("창창"
     "蒼蒼")
    ("창출"
     "創出")
    ("창피"
     "猖披")
    ("창해"
     "滄海")
    ("창호"
     "窓戶")
    ("창호지"
     "窓戶紙")
    ("채"
     ("債" . "빚 채")
     ("埰" . "영지 채")
     ("寀" . "녹봉 채")
     ("寨" . "울짱 채")
     ("彩" . "무늬 채")
     ("採" . "캘 채")
     ("砦" . "울타리 채")
     ("綵" . "비단 채")
     ("菜" . "나물 채")
     ("蔡" . "거북 채")
     ("采" . "캘 채")
     ("釵" . "비녀 채")
     ("棌" . "참나무 채")
     ("茝" . "구리때 채"))
    ("채광"
     "採鑛")
    ("채굴"
     "採掘")
    ("채권"
     "債券")
    ("채권단"
     "債權團")
    ("채근"
     "採根")
    ("채금"
     "綵錦")
    ("채도"
     "彩度")
    ("채무"
     "債務")
    ("채산제"
     "採算制")
    ("채색"
     "彩色")
    ("채색화"
     "彩色畵")
    ("채석"
     "採石")
    ("채석장"
     "採石場")
    ("채소"
     "菜蔬")
    ("채송화"
     "菜松花")
    ("채식"
     "菜食")
    ("채용"
     "採用")
    ("채전"
     "菜田")
    ("채점"
     "採點")
    ("채집"
     "採集")
    ("채취"
     "採取")
    ("채취군"
     "採取群")
    ("채취선"
     "採取船")
    ("채취자"
     "採取者")
    ("채탄"
     "採炭")
    ("채택"
     "採擇")
    ("채택료"
     "採擇料")
    ("채택료율"
     "採擇料率")
    ("채함"
     "採鹹")
    ("채혈"
     "採血")
    ("채화"
     "採火")
    ("책"
     ("冊" . "책 책")
     ("柵" . "울짱 책")
     ("策" . "채찍 책")
     ("翟" . "꿩 책")
     ("責" . "꾸짖을 책")
     ("嘖" . "외칠 책")
     ("幘" . "건 책")
     ("磔" . "찢을 책")
     ("笧" . "책 상자 책")
     ("簀" . "살평상 책")
     ("蚱" . "벼메뚜기 책"))
    ("책걸상"
     "冊-床")
    ("책략"
     "策略")
    ("책망"
     "責望")
    ("책무"
     "責務")
    ("책방"
     "冊房")
    ("책보"
     "冊褓")
    ("책봉"
     "冊封")
    ("책상"
     "冊床")
    ("책임"
     "責任")
    ("책임감"
     "責任感")
    ("책임량"
     "責任量")
    ("책임론"
     "責任論")
    ("책임성"
     "責任性")
    ("책임자"
     "責任者")
    ("책임제"
     "責任制")
    ("책임주의"
     "責任主義")
    ("책자"
     "冊子")
    ("책장"
     "冊張"
     "冊欌")
    ("책정"
     "策定")
    ("책정권"
     "策定權")
    ("처"
     ("凄" . "쓸쓸할 처")
     ("妻" . "아내 처")
     ("悽" . "슬퍼할 처")
     ("處" . "살 처")
     ("淒" . "쓸쓸할 처")
     ("萋" . "풀 성하게 우거진 모양 처")
     ("褄" . "깃의 가 처")
     ("覷" . "엿볼 처")
     ("郪" . "고을 이름 처"))
    ("처가"
     "妻家")
    ("처갓"
     "妻家")
    ("처결"
     "處決")
    ("처남"
     "妻男")
    ("처녀"
     "處女")
    ("처녀성"
     "處女性")
    ("처녀좌"
     "處女座")
    ("처단"
     "處斷")
    ("처량"
     "凄凉")
    ("처리"
     "處理")
    ("처리기"
     "處理機")
    ("처리비"
     "處理費")
    ("처리업"
     "處理業")
    ("처리장"
     "處理場")
    ("처방"
     "處方")
    ("처방전"
     "處方箋")
    ("처벌"
     "處罰")
    ("처분"
     "處分")
    ("처분장"
     "處分場")
    ("처사"
     "處事")
    ("처서"
     "處暑")
    ("처세"
     "處世")
    ("처세술"
     "處世術")
    ("처신"
     "處身")
    ("처연"
     "悽然")
    ("처용무"
     "處容舞")
    ("처우"
     "處遇")
    ("처우제"
     "處遇制")
    ("처자"
     "妻子")
    ("처자식"
     "妻子息")
    ("처장"
     "處長")
    ("처절"
     "凄切"
     "悽絶")
    ("처제"
     "妻弟")
    ("처지"
     "處地")
    ("처참"
     "悽慘")
    ("처첩"
     "妻妾")
    ("처치"
     "處置")
    ("처치실"
     "處置室")
    ("처형"
     "妻兄"
     "處刑")
    ("처형당"
     "處刑當")
    ("척"
     ("倜" . "대범할 척")
     ("剔" . "바를 척")
     ("尺" . "자 척")
     ("慽" . "근심할 척")
     ("戚" . "겨레 척")
     ("拓" . "주울 척")
     ("擲" . "던질 척")
     ("斥" . "물리칠 척")
     ("滌" . "씻을 척")
     ("瘠" . "파리할 척")
     ("脊" . "등성마루 척")
     ("蹠" . "밟을 척")
     ("陟" . "오를 척")
     ("隻" . "새 한 마리 척")
     ("刺" . "찌를 척")
     ("俶" . "시작할 척")
     ("呎" . "길이 단위 척")
     ("坧" . "기지 척")
     ("塉" . "메마른 땅 척")
     ("惕" . "두려워할 척")
     ("摭" . "주울 척")
     ("蜴" . "도마뱀 척")
     ("跖" . "발바닥 척")
     ("躑" . "머뭇거릴 척"))
    ("척결"
     "剔抉")
    ("척도"
     "尺度")
    ("척박"
     "瘠薄")
    ("척불론"
     "斥佛論")
    ("척사론"
     "斥邪論")
    ("척수"
     "脊髓")
    ("척추"
     "脊椎")
    ("척추관"
     "脊椎管")
    ("척후병"
     "斥候兵")
    ("천"
     ("串" . "꿸 천")
     ("仟" . "일천 천")
     ("千" . "일천 천")
     ("喘" . "헐떡거릴 천")
     ("天" . "하늘 천")
     ("川" . "내 천")
     ("擅" . "멋대로 천")
     ("泉" . "샘 천")
     ("淺" . "얕을 천")
     ("玔" . "옥고리 천")
     ("穿" . "뚫을 천")
     ("舛" . "어그러질 천")
     ("薦" . "천거할 천")
     ("賤" . "천할 천")
     ("踐" . "밟을 천")
     ("遷" . "옮길 천")
     ("釧" . "팔찌 천")
     ("闡" . "열 천")
     ("阡" . "두렁 천")
     ("韆" . "그네 천")
     ("俴" . "엷을 천")
     ("倩" . "예쁠 천")
     ("僢" . "어그러질 천")
     ("儃" . "머뭇거릴 천")
     ("洊" . "이를 천")
     ("濺" . "흩뿌릴 천")
     ("瓩" . "킬로그램 천")
     ("祆" . "하늘 천")
     ("粁" . "킬로메트르 천")
     ("臶" . "거듭 천")
     ("芊" . "풀 무성할 천")
     "茜"
     ("荐" . "거듭할 천")
     ("蒨" . "대가 우거질 천")
     ("蕆" . "경계할 천")
     ("蚕" . "지렁이 천")
     ("辿" . "천천히 걸을 천")
     ("靝" . "하늘 천"))
    ("천거"
     "薦擧")
    ("천고"
     "千古")
    ("천고마비"
     "天高馬肥")
    ("천공"
     "天工"
     "穿孔")
    ("천구"
     "天球")
    ("천구백구십"
     "千九百九十")
    ("천구백구십구"
     "千九百九十九")
    ("천구백구십일"
     "千九百九十一")
    ("천구백오십삼"
     "千九百五十三")
    ("천구백육십"
     "千九百六十")
    ("천구백육십삼"
     "千九百六十三")
    ("천구백팔십"
     "千九百八十")
    ("천구백팔십육"
     "千九百八十六")
    ("천구백팔십이"
     "千九百八十二")
    ("천국"
     "天國")
    ("천군"
     "天君")
    ("천군만마"
     "千軍萬馬")
    ("천근만근"
     "千斤萬斤")
    ("천금"
     "千金")
    ("천길만"
     "千-萬")
    ("천남성"
     "天南星")
    ("천년만년"
     "千年萬年")
    ("천당"
     "天堂")
    ("천대"
     "賤待")
    ("천도"
     "天道"
     "遷都")
    ("천도론"
     "遷都論")
    ("천동설"
     "天動說")
    ("천렵"
     "川獵")
    ("천륜"
     "天倫")
    ("천리"
     "天理")
    ("천마"
     "天馬")
    ("천막"
     "天幕")
    ("천막생활"
     "天幕生活")
    ("천막촌"
     "天幕村")
    ("천만"
     "千萬")
    ("천만금"
     "千萬金")
    ("천만년"
     "千萬年")
    ("천만다행"
     "千萬多幸")
    ("천만리"
     "千萬里")
    ("천만세"
     "千萬世")
    ("천명"
     "天命"
     "闡明")
    ("천명론"
     "天命論")
    ("천명민본론"
     "天命民本論")
    ("천문"
     "天文")
    ("천문대"
     "天文臺")
    ("천문학"
     "天文學")
    ("천문학계"
     "天文學界")
    ("천문학자"
     "天文學者")
    ("천문학적"
     "天文學的")
    ("천민"
     "天民"
     "賤民")
    ("천민적"
     "賤民的")
    ("천박"
     "淺薄")
    ("천방지축"
     "天方地軸")
    ("천백"
     "千百")
    ("천백이십육"
     "千百二十六")
    ("천벌"
     "天罰")
    ("천변만화"
     "千變萬化")
    ("천부인"
     "天符印")
    ("천부적"
     "天賦的")
    ("천분"
     "天分")
    ("천사"
     "天使")
    ("천사표"
     "天使標")
    ("천삼백"
     "千三百")
    ("천상"
     "天上")
    ("천상계"
     "天上界")
    ("천생"
     "天生")
    ("천생연분"
     "天生緣分")
    ("천석"
     "千石")
    ("천성"
     "天性")
    ("천성적"
     "天性的")
    ("천세"
     "千歲")
    ("천손"
     "天孫")
    ("천수"
     "天壽")
    ("천시"
     "賤視")
    ("천시관"
     "賤視觀")
    ("천식"
     "喘息")
    ("천신"
     "天神")
    ("천신만고"
     "千辛萬苦")
    ("천신족"
     "天神族")
    ("천안"
     "天眼")
    ("천양지판"
     "天壤之判")
    ("천억"
     "千億")
    ("천연"
     "天然")
    ("천연기념물"
     "天然記念物")
    ("천연기념물적"
     "天然記念物的")
    ("천연두"
     "天然痘")
    ("천연색"
     "天然色")
    ("천연성"
     "天然性")
    ("천연자원"
     "天然資源")
    ("천염"
     "天染")
    ("천오백"
     "千五百")
    ("천왕"
     "天王")
    ("천운"
     "天運")
    ("천위"
     "天位")
    ("천의"
     "天衣")
    ("천의무봉"
     "天衣無縫")
    ("천인합일"
     "天人合一")
    ("천인합일설"
     "天人合一說")
    ("천일"
     "天日")
    ("천일제염업"
     "天日製鹽業")
    ("천자"
     "天子")
    ("천장"
     "天障")
    ("천재"
     "天才"
     "天災")
    ("천재성"
     "天才性")
    ("천재일우"
     "千載一遇")
    ("천재적"
     "天才的")
    ("천재지변"
     "天災地變")
    ("천적"
     "天敵"
     "賤籍")
    ("천정부지"
     "天井不知")
    ("천제"
     "天帝")
    ("천제단"
     "天祭壇")
    ("천주교"
     "天主敎")
    ("천주학"
     "天主學")
    ("천즉리"
     "天卽理")
    ("천지"
     "天地")
    ("천지개벽"
     "天地開闢")
    ("천지신"
     "天地神")
    ("천지인"
     "天地人")
    ("천지조화"
     "天地造化")
    ("천직"
     "天職")
    ("천진"
     "天眞")
    ("천진난만"
     "天眞爛漫")
    ("천진무구"
     "天眞無垢")
    ("천차만별"
     "千差萬別")
    ("천착"
     "穿鑿")
    ("천창창"
     "天蒼蒼")
    ("천체"
     "天體")
    ("천체계"
     "天體界")
    ("천체관"
     "天體觀")
    ("천촌만락"
     "千村萬落")
    ("천추"
     "千秋")
    ("천측"
     "天測")
    ("천치"
     "天癡")
    ("천칭"
     "天秤")
    ("천칭좌"
     "天秤座")
    ("천태종"
     "天台宗")
    ("천편일률"
     "千篇一律")
    ("천편일률적"
     "千篇一律的")
    ("천평"
     "天平")
    ("천품"
     "天稟")
    ("천하"
     "天下")
    ("천하무적"
     "天下無敵")
    ("천하장사"
     "天下壯士")
    ("천하제일"
     "天下第一")
    ("천하지대본"
     "天下之大本")
    ("천하태평"
     "天下泰平")
    ("천혜"
     "天惠")
    ("천황"
     "天皇")
    ("철"
     ("凸" . "볼록할 철")
     ("哲" . "밝을 철")
     ("喆" . "哲과 同字")
     ("徹" . "통할 철")
     ("撤" . "거둘 철")
     ("澈" . "물 맑을 철")
     ("綴" . "꿰맬 철")
     ("輟" . "그칠 철")
     ("轍" . "바퀴 자국 철")
     ("鐵" . "쇠 철")
     ("剟" . "깎을 철")
     ("啜" . "마실 철")
     ("埑" . "밝을 철")
     ("惙" . "근심할 철")
     ("掇" . "주울 철")
     ("歠" . "마실 철")
     ("銕" . "鐵의 古字")
     ("錣" . "물미 철")
     ("飻" . "탐할 철")
     ("餮" . "탐할 철"))
    ("철갑"
     "鐵甲")
    ("철강"
     "鐵鋼")
    ("철강재"
     "鐵鋼材")
    ("철거"
     "撤去")
    ("철거당"
     "撤去當")
    ("철거반원"
     "撤去班員")
    ("철거식"
     "撤去式")
    ("철골"
     "鐵骨")
    ("철광산"
     "鐵鑛山")
    ("철광석"
     "鐵鑛石")
    ("철교"
     "鐵橋")
    ("철군"
     "撤軍")
    ("철권"
     "鐵拳")
    ("철근"
     "鐵筋")
    ("철금"
     "綴錦")
    ("철기"
     "鐵器")
    ("철기병"
     "鐵器兵")
    ("철도"
     "鐵道")
    ("철도망"
     "鐵道網")
    ("철도역"
     "鐵道驛")
    ("철두철미"
     "徹頭徹尾")
    ("철로"
     "鐵路")
    ("철마"
     "鐵馬")
    ("철망"
     "鐵網")
    ("철면피"
     "鐵面皮")
    ("철모"
     "鐵帽")
    ("철물"
     "鐵物")
    ("철벽"
     "鐵壁")
    ("철봉"
     "鐵棒")
    ("철분"
     "鐵分")
    ("철사"
     "鐵絲")
    ("철석"
     "鐵石")
    ("철선"
     "鐵線"
     "鐵船")
    ("철수"
     "撤收")
    ("철야"
     "徹夜")
    ("철옹성"
     "鐵甕城")
    ("철인"
     "哲人")
    ("철자"
     "綴字")
    ("철자법"
     "綴字法")
    ("철재"
     "鐵材")
    ("철저"
     "徹底")
    ("철저성"
     "徹底性")
    ("철제"
     "鐵製")
    ("철조"
     "鐵造")
    ("철조망"
     "鐵條網")
    ("철창"
     "鐵窓")
    ("철창문"
     "鐵窓門")
    ("철책"
     "鐵柵")
    ("철칙"
     "鐵則")
    ("철침"
     "鐵針")
    ("철탑"
     "鐵塔")
    ("철통"
     "鐵桶")
    ("철퇴"
     "撤退"
     "鐵槌")
    ("철판"
     "鐵板")
    ("철폐"
     "撤廢")
    ("철학"
     "哲學")
    ("철학가"
     "哲學家")
    ("철학계"
     "哲學界")
    ("철학과"
     "哲學科")
    ("철학도"
     "哲學徒")
    ("철학사"
     "哲學史")
    ("철학자"
     "哲學者")
    ("철학적"
     "哲學的")
    ("철학화"
     "哲學化")
    ("철회"
     "撤回")
    ("첨"
     ("僉" . "다 첨")
     ("尖" . "뾰족할 첨")
     ("沾" . "더할 첨")
     ("添" . "더할 첨")
     ("甛" . "달 첨")
     ("瞻" . "볼 첨")
     ("簽" . "농 첨")
     ("籤" . "제비 첨")
     ("詹" . "이를 첨")
     ("諂" . "아첨할 첨")
     ("幨" . "휘장 첨")
     ("忝" . "더럽힐 첨")
     ("惉" . "팰 첨")
     "憸"
     "栝"
     ("槧" . "편지 첨")
     ("檐" . "처마 첨")
     ("櫼" . "쐐기 첨")
     ("瀸" . "적실 첨")
     ("簷" . "처마 첨")
     ("襜" . "행주치마 첨"))
    ("첨가"
     "添加")
    ("첨가물"
     "添加物")
    ("첨단"
     "尖端")
    ("첨단적"
     "尖端的")
    ("첨병"
     "尖兵")
    ("첨부"
     "添附")
    ("첨삭"
     "添削")
    ("첨언"
     "添言")
    ("첨예"
     "尖銳")
    ("첨예화"
     "尖銳化")
    ("첨지"
     "僉知")
    ("첨치"
     "尖齒")
    ("첨탑"
     "尖塔")
    ("첩"
     ("堞" . "성가퀴 첩")
     ("妾" . "첩 첩")
     ("帖" . "표제 첩")
     ("捷" . "이길 첩")
     ("牒" . "글씨판 첩")
     ("疊" . "거듭 첩, 포갤 첩")
     ("褶" . "덧옷 첩, 겹옷 첩")
     ("諜" . "염탐할 첩")
     ("貼" . "붙을 첩")
     ("輒" . "문득 첩")
     ("倢" . "빠를 첩")
     ("呫" . "맛 볼 첩, 귀에 대고 소근거릴 첩, 앙징할 첩")
     ("喋" . "재잘거릴 첩")
     ("怗" . "고요할 첩")
     ("褺" . "겹옷 첩")
     "鰈")
    ("첩경"
     "捷徑")
    ("첩보"
     "諜報")
    ("첩보전"
     "諜報戰")
    ("첩자"
     "諜者")
    ("첩첩"
     "疊疊")
    ("첩첩산중"
     "疊疊山中")
    ("청"
     ("廳" . "관청 청")
     ("晴" . "갤 청")
     ("淸" . "맑을 청")
     ("聽" . "들을 청")
     ("菁" . "부추꽃 청")
     ("請" . "청할 청")
     ("靑" . "푸를 청")
     ("鯖" . "청어 청")
     "倩"
     ("凊" . "서늘할 청")
     "听"
     ("圊" . "뒷간 청")
     "婧"
     ("蜻" . "귀뚜라미 청")
     ("鶄" . "교청새 청"))
    ("청각"
     "聽覺")
    ("청각적"
     "聽覺的")
    ("청결"
     "淸潔")
    ("청결성"
     "淸潔性")
    ("청경"
     "請警")
    ("청과부"
     "靑果部")
    ("청구"
     "請求")
    ("청구권"
     "請求權")
    ("청구권자"
     "請求權者")
    ("청구권적"
     "請求權的")
    ("청구분"
     "請求分")
    ("청구서"
     "請求書")
    ("청군"
     "靑軍")
    ("청금고"
     "靑錦袴")
    ("청년"
     "靑年")
    ("청년기"
     "靑年期")
    ("청년부"
     "靑年部")
    ("청년층"
     "靑年層")
    ("청년회"
     "靑年會")
    ("청담"
     "淸談")
    ("청동"
     "靑銅")
    ("청동기"
     "靑銅器")
    ("청동색"
     "靑銅色")
    ("청띠신선"
     "靑-神仙")
    ("청라"
     "靑羅")
    ("청량"
     "淸凉")
    ("청량감"
     "淸凉感")
    ("청량음료"
     "淸凉飮料")
    ("청력"
     "聽力")
    ("청렴"
     "淸廉")
    ("청렴결백"
     "淸廉潔白")
    ("청렴도"
     "淸廉度")
    ("청렴성"
     "淸廉性")
    ("청록"
     "靑綠")
    ("청록색"
     "靑綠色")
    ("청룡"
     "靑龍")
    ("청류객"
     "淸流客")
    ("청명"
     "淸明")
    ("청명주"
     "淸明酒")
    ("청문회"
     "聽聞會")
    ("청백색"
     "靑白色")
    ("청병"
     "請兵")
    ("청부"
     "請負")
    ("청빈"
     "淸貧")
    ("청사"
     "廳舍")
    ("청사진"
     "靑寫眞")
    ("청사초롱"
     "靑紗-籠")
    ("청산"
     "淸算"
     "靑山")
    ("청산주의적"
     "淸算主義的")
    ("청상과부"
     "靑孀寡婦")
    ("청색"
     "靑色")
    ("청색증"
     "靑色症")
    ("청설모"
     "靑鼠毛")
    ("청소"
     "淸掃")
    ("청소과"
     "淸掃課")
    ("청소과장"
     "淸掃課長")
    ("청소기"
     "淸掃機")
    ("청소년"
     "靑少年")
    ("청소년기"
     "靑少年期")
    ("청소년단"
     "靑少年團")
    ("청소년층"
     "靑少年層")
    ("청소부"
     "淸掃夫")
    ("청소비"
     "淸掃費")
    ("청소차"
     "淸掃車")
    ("청수"
     "淸水")
    ("청순"
     "淸純")
    ("청순미"
     "淸純美")
    ("청순성"
     "淸純性")
    ("청순파"
     "淸純派")
    ("청신"
     "淸新")
    ("청신호"
     "靑信號")
    ("청심환"
     "淸心丸")
    ("청아"
     "淸雅")
    ("청약"
     "請約")
    ("청약권"
     "請約權")
    ("청약서"
     "請約書")
    ("청약자"
     "請約者")
    ("청운"
     "靑雲")
    ("청원"
     "請願")
    ("청원서"
     "請願書")
    ("청자"
     "靑瓷")
    ("청장"
     "廳長"
     "淸醬")
    ("청장년"
     "靑壯年")
    ("청정"
     "淸淨")
    ("청정기"
     "淸淨機")
    ("청제"
     "靑帝")
    ("청조"
     "淸朝")
    ("청중"
     "聽衆")
    ("청진기"
     "聽診器")
    ("청진봉"
     "聽診棒")
    ("청천"
     "晴天"
     "靑天")
    ("청천벽력"
     "靑天霹靂")
    ("청첩장"
     "請牒狀")
    ("청초"
     "淸楚")
    ("청춘"
     "靑春")
    ("청춘물"
     "靑春物")
    ("청출어람"
     "靑出於藍")
    ("청취"
     "聽取")
    ("청취율"
     "聽取率")
    ("청취자"
     "聽取者")
    ("청탁"
     "淸濁"
     "請託")
    ("청태"
     "靑太")
    ("청포도"
     "靑葡萄")
    ("청혼"
     "請婚")
    ("청홍"
     "靑紅")
    ("청홍색"
     "靑紅色")
    ("청화"
     "靑華")
    ("청회색"
     "靑灰色")
    ("체"
     ("剃" . "머리 깎을 체")
     ("替" . "바꿀 체")
     ("涕" . "눈물 체")
     ("滯" . "막힐 체")
     ("綴" . "꿰멜 체")
     ("締" . "맺을 체")
     ("諦" . "살필 체")
     ("逮" . "미칠 체")
     ("遞" . "갈마들 체")
     ("體" . "몸 체")
     ("切" . "자를 체")
     ("体" . "몸 체")
     ("嚏" . "재채기 할 체")
     ("彘" . "돼지 체")
     ("棣" . "산앵두나무 체")
     ("殢" . "나른할 체")
     "泚"
     ("砌" . "섬돌 체")
     ("蒂" . "작은 가시 체")
     ("蔕" . "작은 가시 체")
     "薙"
     ("軆" . "몸 체")
     ("靆" . "구름 낄 체")
     "髰")
    ("체감"
     "體感")
    ("체격"
     "體格")
    ("체결"
     "締結")
    ("체결설"
     "締結說")
    ("체계"
     "體系")
    ("체계도"
     "體系圖")
    ("체계론자"
     "體系論者")
    ("체계성"
     "體系性")
    ("체계적"
     "體系的")
    ("체계화"
     "體系化")
    ("체구"
     "體軀")
    ("체급"
     "體級")
    ("체납"
     "滯納")
    ("체납액"
     "滯納額")
    ("체내"
     "體內")
    ("체념"
     "諦念")
    ("체념적"
     "滯念的")
    ("체두관"
     "剃頭官")
    ("체득"
     "體得")
    ("체력"
     "體力")
    ("체력적"
     "體力的")
    ("체류"
     "滯留")
    ("체류자"
     "滯留者")
    ("체면"
     "體面")
    ("체모"
     "體毛")
    ("체벌"
     "體罰")
    ("체불"
     "滯拂")
    ("체비지"
     "替費地")
    ("체신"
     "遞信")
    ("체액"
     "體液")
    ("체열"
     "體熱")
    ("체온"
     "體溫")
    ("체온계"
     "體溫計")
    ("체외"
     "體外")
    ("체위"
     "體位")
    ("체육"
     "體育")
    ("체육계"
     "體育界")
    ("체육과"
     "體育科")
    ("체육관"
     "體育館")
    ("체육국"
     "體育局")
    ("체육단"
     "體育團")
    ("체육복"
     "體育服")
    ("체육인"
     "體育人")
    ("체육학"
     "體育學")
    ("체육학과"
     "體育學科")
    ("체육회"
     "體育會")
    ("체인"
     "體認")
    ("체임"
     "滯賃")
    ("체재"
     "滯在"
     "體裁")
    ("체전"
     "體典")
    ("체제"
     "體制")
    ("체제론"
     "體制論")
    ("체조"
     "體操")
    ("체조법"
     "體操法")
    ("체조직"
     "體組織")
    ("체중"
     "體重")
    ("체중계"
     "體重計")
    ("체증"
     "滯症"
     "遞增")
    ("체질"
     "體質")
    ("체질화"
     "體質化")
    ("체취"
     "體臭")
    ("체통"
     "體統")
    ("체포"
     "逮捕")
    ("체포죄"
     "逮捕罪")
    ("체한"
     "滯韓")
    ("체험"
     "體驗")
    ("체험담"
     "體驗談")
    ("체험적"
     "體驗的")
    ("체현"
     "體現")
    ("체형"
     "體型")
    ("체형적"
     "體型的")
    ("체형형"
     "體形型")
    ("초"
     ("初" . "처음 초")
     ("剿" . "죽일 초")
     ("哨" . "망 볼 초")
     ("憔" . "수척할 초")
     ("抄" . "베낄 초")
     ("招" . "부를 초")
     ("梢" . "나무 끝 초")
     ("椒" . "산초나무 초")
     ("楚" . "회초리 초")
     ("樵" . "땔나무 초")
     "湫"
     ("炒" . "볶을 초")
     ("焦" . "그슬릴 초")
     ("硝" . "초석 초")
     ("礁" . "암초 초")
     ("礎" . "주춧돌 초")
     ("秒" . "시간 단위 초")
     ("稍" . "벼 줄기 끝 초")
     ("肖" . "닮을 초")
     ("艸" . "풀 초")
     ("苕" . "능소화 초")
     ("草" . "풀 초")
     ("蕉" . "파초 초")
     ("貂" . "담비 초")
     ("超" . "뛰어넘을 초")
     ("酢" . "초 초")
     ("醋" . "초산 초")
     ("醮" . "초례 초")
     "俏"
     ("偢" . "얼이 빠져 있을 초")
     ("僬" . "밝게 살필 초")
     ("勦" . "수고롭게 할 초")
     ("噍" . "먹을 초")
     ("嫶" . "수척할 초")
     ("岧" . "산이 높을 초")
     ("峭" . "가파를 초")
     ("嶕" . "높을 초")
     ("怊" . "슬퍼할 초")
     ("悄" . "근심할 초")
     ("愀" . "정색할 초")
     ("杪" . "끝 초")
     ("燋" . "홰 초")
     ("綃" . "생명주실 초")
     ("耖" . "밭 거듭 갈 초")
     ("誚" . "꾸짖을 초")
     ("譙" . "꾸짖을 초")
     ("趠" . "멀 초")
     "踔"
     ("軺" . "수레 초")
     ("迢" . "멀 초")
     ("鈔" . "노략질할 초")
     ("鍫" . "가래 초")
     ("鍬" . "가래 초")
     "隹"
     ("鞘" . "칼집 초")
     ("顦" . "야윌 초")
     ("髫" . "다박머리 초")
     ("鷦" . "뱁새 초")
     ("齠" . "이를 갈 초"))
    ("초가"
     "草家")
    ("초간단"
     "超簡單")
    ("초간장"
     "醋-醬")
    ("초간편"
     "超簡便")
    ("초감각"
     "超感覺")
    ("초감각적"
     "超感覺的")
    ("초강경"
     "超强勁")
    ("초강대국"
     "超强大國")
    ("초강세"
     "超强勢")
    ("초개"
     "草芥")
    ("초거대"
     "超巨大")
    ("초경"
     "初經")
    ("초경도"
     "超硬度")
    ("초경량"
     "超輕量")
    ("초경험적"
     "超經驗的")
    ("초계급적"
     "超階級的")
    ("초고"
     "草稿")
    ("초고본"
     "草稿本")
    ("초고속"
     "超高速")
    ("초고속관"
     "超高速館")
    ("초고압"
     "超高壓")
    ("초고집적"
     "超高集積")
    ("초고층"
     "超高層")
    ("초과"
     "超過")
    ("초과자"
     "超過者")
    ("초근목피"
     "草根木皮")
    ("초급"
     "初級")
    ("초급반"
     "初級班")
    ("초기"
     "初期")
    ("초기작"
     "初期作")
    ("초긴장"
     "超緊張")
    ("초내열"
     "超耐熱")
    ("초년"
     "初年")
    ("초년병"
     "初年兵")
    ("초년생"
     "初年生")
    ("초논리적"
     "超論理的")
    ("초능력"
     "超能力")
    ("초단열"
     "超斷熱")
    ("초당"
     "初唐"
     "草堂"
     "超黨")
    ("초당적"
     "超黨的")
    ("초대"
     "初代"
     "招待"
     "礎臺")
    ("초대권"
     "招待券")
    ("초대석"
     "招待席")
    ("초대장"
     "招待狀")
    ("초대형"
     "超大型")
    ("초동"
     "初動")
    ("초등"
     "初等")
    ("초등학교"
     "初等學校")
    ("초등학생"
     "初等學生")
    ("초래"
     "招來")
    ("초례청"
     "醮禮廳")
    ("초로"
     "初老")
    ("초록"
     "抄錄"
     "草綠")
    ("초록색"
     "草綠色")
    ("초립"
     "草笠")
    ("초막"
     "草幕")
    ("초만원"
     "超滿員")
    ("초목"
     "草木")
    ("초문화적"
     "超文化的")
    ("초미"
     "焦眉")
    ("초미속"
     "超微速")
    ("초반"
     "初盤")
    ("초반부"
     "初盤部")
    ("초병"
     "哨兵")
    ("초보"
     "初步")
    ("초보자"
     "初步者")
    ("초보적"
     "初步的")
    ("초복"
     "初伏")
    ("초본"
     "抄本"
     "草本")
    ("초비상"
     "超非常")
    ("초빙"
     "招聘")
    ("초사회적"
     "超社會的")
    ("초산"
     "初産")
    ("초상"
     "初喪"
     "肖像")
    ("초상화"
     "肖像畵")
    ("초색"
     "草色")
    ("초서"
     "草書")
    ("초석"
     "硝石"
     "礎石")
    ("초선"
     "初選")
    ("초성"
     "初聲")
    ("초소"
     "哨所")
    ("초속"
     "秒速")
    ("초수평선"
     "超水平線")
    ("초순"
     "初旬")
    ("초승"
     "初生")
    ("초시"
     "初試")
    ("초시간적"
     "超時間的")
    ("초시대적"
     "超時代的")
    ("초신성"
     "超新星")
    ("초심자"
     "初心者")
    ("초안"
     "草案")
    ("초야"
     "初夜"
     "草野")
    ("초어"
     "草魚")
    ("초역사적"
     "超歷史的")
    ("초연"
     "初演"
     "招演"
     "超然")
    ("초엽"
     "初葉")
    ("초오"
     "草烏")
    ("초원"
     "草原")
    ("초월"
     "超越")
    ("초월자"
     "超越者")
    ("초월적"
     "超越的")
    ("초월화"
     "超越化")
    ("초유"
     "招諭")
    ("초은하단"
     "超銀河團")
    ("초음속"
     "超音速")
    ("초음파"
     "超音波")
    ("초인"
     "超人")
    ("초인간적"
     "超人間的")
    ("초인적"
     "超人的")
    ("초인종"
     "招人鐘")
    ("초일류"
     "超一流")
    ("초임"
     "初任")
    ("초입"
     "初入")
    ("초자"
     "硝子")
    ("초자아"
     "超自我")
    ("초자연적"
     "超自然的")
    ("초자연주의"
     "超自然主義")
    ("초장"
     "醋醬")
    ("초전"
     "初戰"
     "初轉")
    ("초전도"
     "超傳導")
    ("초점"
     "焦點")
    ("초정밀"
     "超精密")
    ("초정치"
     "超政治")
    ("초조"
     "焦燥")
    ("초조감"
     "焦燥感")
    ("초중고"
     "初中高")
    ("초중고교"
     "初中高校")
    ("초중고생"
     "初中高生")
    ("초중구금"
     "超重拘禁")
    ("초지"
     "草地")
    ("초지일관"
     "初志一貫")
    ("초진"
     "初診")
    ("초집적"
     "超集積")
    ("초창기"
     "草創期")
    ("초청"
     "招請")
    ("초청객"
     "招請客")
    ("초청장"
     "招請狀")
    ("초청전"
     "招請展")
    ("초초중구금"
     "超超重拘禁")
    ("초췌"
     "憔悴")
    ("초침"
     "秒針")
    ("초토"
     "焦土")
    ("초토화"
     "焦土化")
    ("초특급"
     "超特級")
    ("초파일"
     "初八日")
    ("초판"
     "初版")
    ("초행"
     "初行")
    ("초현대식"
     "超現代式")
    ("초현실"
     "超現實")
    ("초현실적"
     "超現實的")
    ("초현실주의"
     "超現實主義")
    ("초현실주의자"
     "超現實主義者")
    ("초혈연적"
     "超血緣的")
    ("초형"
     "草型")
    ("초호화"
     "超豪華")
    ("초혼"
     "初婚")
    ("촉"
     ("促" . "핍박할 촉, 촉박할 촉, 좁을 촉, 빠를 촉, 짧을 촉")
     ("囑" . "부탁할 촉")
     ("屬" . "이을 촉, 닿을 촉, 부탁할 촉, 모을 촉, 조심할 촉")
     ("燭" . "爥의 俗字")
     ("矗" . "곧을 촉, 우뚝 솟을 촉")
     ("蜀" . "촉규화벌레 촉, 큰 닭 촉")
     ("觸" . "받을 촉, 느낄 촉, 지날 촉, 범할 촉")
     "鏃"
     ("曯" . "비칠 촉")
     ("爥" . "비칠 촉")
     ("矚" . "볼 촉")
     ("薥" . "촉규화 촉, 자귀밥 촉")
     ("躅" . "자취 촉, 강동강동 뛸 촉, 철쭉꽃 촉")
     ("髑" . "해골 촉"))
    ("촉각"
     "觸覺"
     "觸角")
    ("촉각적"
     "觸覺的")
    ("촉감"
     "觸感")
    ("촉구"
     "促求")
    ("촉망"
     "屬望")
    ("촉매"
     "觸媒")
    ("촉매제"
     "觸媒劑")
    ("촉발"
     "觸發")
    ("촉발점"
     "觸發點")
    ("촉진"
     "促進")
    ("촉진제"
     "促進劑")
    ("촉진책"
     "促進策")
    ("촉탁"
     "囑託")
    ("촌"
     ("寸" . "치 촌, 마디 촌, 헤아릴 촌, 조금 촌")
     ("忖" . "헤아릴 촌, 짐작할 촌")
     ("村" . "마을 촌, 밭집 촌, 시골 촌")
     ("邨" . "村과 同字")
     ("吋" . "인치(inch) 촌"))
    ("촌극"
     "寸劇")
    ("촌락"
     "村落")
    ("촌로"
     "村老")
    ("촌부"
     "村夫")
    ("촌수"
     "寸數")
    ("촌음"
     "寸陰")
    ("촌장"
     "村長")
    ("촌장층"
     "村長層")
    ("촌정층"
     "村正層")
    ("촌주"
     "村主")
    ("촌주위답"
     "村主位畓")
    ("촌지"
     "寸志")
    ("촌평"
     "寸評")
    ("총"
     ("叢" . "떨기 총, 모을 총, 번잡할 총")
     ("塚" . "冢의 俗字")
     ("寵" . "사랑할 총, 임금께 총애받을 총, 은혜 총, 첩 총")
     ("悤" . "바쁠 총, 덤빌 총")
     ("摠" . "거느릴 총, 모을 총, 무리 총, 장수 총")
     ("總" . "꿰맬 총, 거느릴 총, 합할 총, 끄덩이 잡을 총")
     ("聰" . "귀 밝을 총, 민첩할 총")
     ("蔥" . "파 총, 파 뿌리 총, 푸를 총")
     ("銃" . "도끼 구멍 총, 총 총")
     ("葱" . "풀 더북할 총")
     ("蓯" . "풀 더북할 총")
     ("鏦" . "창 총, 찌를 총")
     ("騘" . "驄과 同字")
     ("驄" . "총이말 총"))
    ("총각"
     "總角")
    ("총감독"
     "總監督")
    ("총개념"
     "總槪念")
    ("총검"
     "銃劍")
    ("총격"
     "銃擊")
    ("총격전"
     "銃擊戰")
    ("총결산"
     "總決算")
    ("총경"
     "總警")
    ("총계"
     "總計")
    ("총공격"
     "總攻擊")
    ("총괄"
     "總括")
    ("총괄서"
     "總括書")
    ("총괄적"
     "總括的")
    ("총구"
     "銃口")
    ("총국"
     "總局")
    ("총국장"
     "總局長")
    ("총궐기"
     "總蹶起")
    ("총기"
     "聰氣"
     "銃器")
    ("총대장"
     "總大將")
    ("총독"
     "總督")
    ("총동문회"
     "總同門會")
    ("총동원"
     "總動員")
    ("총등장"
     "總登場")
    ("총량"
     "總量")
    ("총력"
     "總力")
    ("총력전"
     "總力戰")
    ("총론"
     "總論")
    ("총리"
     "總理")
    ("총리령"
     "總理令")
    ("총리실"
     "總理室")
    ("총망라"
     "總網羅")
    ("총매상"
     "總賣上")
    ("총매출액"
     "總賣出額")
    ("총면적"
     "總面積")
    ("총명"
     "聰明")
    ("총무"
     "總務")
    ("총무과장"
     "總務課長")
    ("총무국장"
     "總務局長")
    ("총무부"
     "總務部")
    ("총무부장"
     "總務部長")
    ("총무실"
     "總務室")
    ("총무원"
     "總務院")
    ("총반격"
     "總反擊")
    ("총본부"
     "總本部")
    ("총부"
     "摠部")
    ("총비"
     "寵妃")
    ("총비서"
     "總秘書")
    ("총비서직"
     "總秘書職")
    ("총사령탑"
     "總司令塔")
    ("총사업"
     "總事業")
    ("총사퇴"
     "總辭退")
    ("총사퇴설"
     "總辭退說")
    ("총살"
     "銃殺")
    ("총상"
     "銃傷")
    ("총상금"
     "總賞金")
    ("총생산"
     "總生産")
    ("총생산량"
     "總生産量")
    ("총생산액"
     "總生産額")
    ("총서"
     "叢書")
    ("총서기"
     "總書記")
    ("총선"
     "總選")
    ("총선거"
     "總選擧")
    ("총선전"
     "總選戰")
    ("총설"
     "總說")
    ("총성"
     "銃聲")
    ("총수"
     "總帥"
     "總數")
    ("총수요"
     "總需要")
    ("총수익"
     "總收益")
    ("총수입"
     "總收入")
    ("총수입액"
     "總輸入額")
    ("총신"
     "銃身")
    ("총아"
     "寵兒")
    ("총애"
     "寵愛")
    ("총액"
     "總額")
    ("총액수"
     "總額數")
    ("총여신"
     "總與信")
    ("총역량"
     "總力量")
    ("총연맹"
     "總聯盟")
    ("총연봉"
     "總年俸")
    ("총연합"
     "總聯合")
    ("총영사"
     "總領事")
    ("총영사관"
     "總領事館")
    ("총인원"
     "總人員")
    ("총자본"
     "總資本")
    ("총자본금"
     "總資本金")
    ("총장"
     "總長")
    ("총장상"
     "總長賞")
    ("총장실"
     "總長室")
    ("총장직"
     "總長職")
    ("총재"
     "總裁")
    ("총점"
     "總點")
    ("총점검"
     "總點檢")
    ("총점주의"
     "總點主義")
    ("총정리"
     "總整理")
    ("총정원"
     "總定員")
    ("총조사"
     "總調査")
    ("총조정관"
     "總調整官")
    ("총중"
     "悤中")
    ("총지배인"
     "總支配人")
    ("총집결"
     "總集結")
    ("총집합"
     "總集合")
    ("총참모장"
     "總參謀長")
    ("총책"
     "總責")
    ("총책임자"
     "總責任者")
    ("총체"
     "總體")
    ("총체감"
     "總體感")
    ("총체성"
     "總體性")
    ("총체적"
     "總體的")
    ("총총"
     "叢叢"
     "悤悤")
    ("총출연"
     "總出演")
    ("총칭"
     "總稱")
    ("총탄"
     "銃彈")
    ("총통"
     "總統")
    ("총통화"
     "總通貨")
    ("총판"
     "總販")
    ("총학생회"
     "總學生會")
    ("총학생회장"
     "總學生會長")
    ("총합"
     "總合")
    ("총화"
     "總和")
    ("총활동"
     "總活動")
    ("총회"
     "總會")
    ("총회장"
     "總會長")
    ("촬"
     ("撮" . "머리 끄덩이 잡을 촬, 당길 촬, 비칠 촬"))
    ("촬영"
     "撮影")
    ("촬영기"
     "撮影機")
    ("촬영반"
     "撮影班")
    ("촬영분"
     "撮影分")
    ("촬영술"
     "撮影術")
    ("촬영장"
     "撮影場")
    ("촬영지"
     "撮影地")
    ("최"
     ("催" . "재촉할 최, 핍박할 최, 일어날 최")
     ("崔" . "산 우뚝할 최, 높고 가파를 최, 성씨 최")
     ("最" . "가장 최, 우뚝할 최, 넉넉할 최")
     ("嘬" . "물 최, 산적 한 입에 넣을 최")
     ("摧" . "꺾을 최, 망할 최, 저지할 최")
     ("榱" . "서까래 최")
     "淬"
     ("漼" . "깊을 최, 고을 최, 눈물 줄줄 흘릴 최, 눈서리 쌓일 최")
     ("璀" . "옥빛 찬란할 최, 구슬 주렁주렁 달릴 최")
     ("磪" . "험하고 높을 최")
     ("縗" . "상복 최, 상옷 최")
     "脧"
     "蕞")
    ("최강"
     "最强")
    ("최강수"
     "最强數")
    ("최강자"
     "最强者")
    ("최강전"
     "最强戰")
    ("최경량"
     "最輕量")
    ("최경례"
     "最敬禮")
    ("최고"
     "最古"
     "最高")
    ("최고가액"
     "最高價額")
    ("최고급"
     "最高級")
    ("최고도"
     "最高度")
    ("최고령"
     "最高齡")
    ("최고미"
     "最高美")
    ("최고본"
     "最高本")
    ("최고봉"
     "最高峯")
    ("최고상"
     "最高賞")
    ("최고신"
     "最高神")
    ("최고위"
     "最高位")
    ("최고점"
     "最高點")
    ("최고조"
     "最高潮")
    ("최고참"
     "最古參")
    ("최고치"
     "最高値")
    ("최근"
     "最近")
    ("최근세"
     "最近世")
    ("최근작"
     "最近作")
    ("최남단"
     "最南端")
    ("최다"
     "最多")
    ("최단"
     "最短")
    ("최단명"
     "最短命")
    ("최대"
     "最大")
    ("최대어"
     "最大魚")
    ("최대치"
     "最大値")
    ("최대한"
     "最大限")
    ("최루"
     "催淚")
    ("최루성"
     "催淚性")
    ("최루액"
     "催淚液")
    ("최루탄"
     "催淚彈")
    ("최말직"
     "最末職")
    ("최면"
     "催眠")
    ("최북단"
     "最北端")
    ("최빈국"
     "最貧國")
    ("최상"
     "最上")
    ("최상급"
     "最上級")
    ("최상급자"
     "最上級者")
    ("최상품"
     "最上品")
    ("최선"
     "最善")
    ("최선책"
     "最善策")
    ("최소"
     "最小"
     "最少")
    ("최소우"
     "最小雨")
    ("최소한"
     "最小限")
    ("최소한도"
     "最小限度")
    ("최소화"
     "最小化"
     "最少化")
    ("최신"
     "最新")
    ("최신곡"
     "最新曲")
    ("최신식"
     "最新式")
    ("최신형"
     "最新型")
    ("최악"
     "最惡")
    ("최연소자"
     "最年少者")
    ("최우량품"
     "最優良品")
    ("최우선"
     "最優先")
    ("최우선적"
     "最優先的")
    ("최우수"
     "最優秀")
    ("최우수상"
     "最優秀賞")
    ("최일선"
     "最一線")
    ("최장"
     "最長")
    ("최장기간"
     "最長其間")
    ("최장수"
     "最長壽")
    ("최장신"
     "最長身")
    ("최저"
     "最低")
    ("최저치"
     "最低値")
    ("최적"
     "最適")
    ("최전방"
     "最前方")
    ("최전선"
     "最前線")
    ("최종"
     "最終")
    ("최종심"
     "最終審")
    ("최종안"
     "最終案")
    ("최종일"
     "最終日")
    ("최종적"
     "最終的")
    ("최종전"
     "最終戰")
    ("최첨단"
     "最尖端")
    ("최초"
     "最初")
    ("최촉"
     "催促")
    ("최측근"
     "最側近")
    ("최하"
     "最下")
    ("최하위"
     "最下位")
    ("최하위권"
     "最下位圈")
    ("최하층"
     "最下層")
    ("최혜국"
     "最惠國")
    ("최후"
     "最後")
    ("최후적"
     "最後的")
    ("최후통첩"
     "最後通牒")
    ("추"
     ("丑" . "수갑 추, 사람이름 추")
     ("墜" . "떨어질 추, 잃을 추")
     ("抽" . "뺄 추, 뽑을 추, 당길 추, 거둘 추")
     ("推" . "옮길 추, 가릴 추, 궁구할 추")
     ("杻" . "수갑 추, 조막손이 추")
     ("椎" . "쇠몽둥이 추, 칠 추, 짓찧을 추, 참나무 추")
     ("楸" . "가래나무 추, 노나무 추, 산유자 추, 바둑판 추")
     ("槌" . "칠 추")
     ("樞" . "밑둥 추, 지두리 추, 고동 추, 북두 첫째 별 추, 긴요할 추, 달 추, 가운데 추")
     ("湫" . "늪 추, 폭포 추, 찌푸릴 추, 서늘할 추")
     ("皺" . "쭈그러질 추")
     ("秋" . "가을 추, 세월 추, 때 추, 말이 뛰놀 추, 성씨 추")
     ("芻" . "꼴 추, 짐승먹이 추")
     ("萩" . "맑은 대쑥 추, 가래나무 추")
     "藪"
     ("諏" . "꾀할 추, 물을 추")
     ("趨" . "달아날 추, 추창할 추")
     ("追" . "쫓을 추, 따를 추")
     ("鄒" . "추나라 추")
     ("酋" . "괴수 추, 두목 추, 숙 익을 추, 끝날 추")
     ("醜" . "추할 추, 같을 추, 무리 추, 자라똥구멍 추, 부끄러울 추")
     ("錐" . "송곳 추")
     ("錘" . "저울눈 추, 마치 추, 저울 추")
     ("鎚" . "쇠마치 추, 저울 추")
     ("雛" . "새 새끼 추, 병아리 추, 어린아이 추")
     ("騶" . "거덜 추, 마부 추, 짐승이름 추")
     ("鰍" . "미꾸라지 추")
     ("僦" . "임금 추, 고용할 추")
     ("啾" . "두런거릴 추, 찍찍거릴 추")
     "妯"
     ("娵" . "젊을 추, 물고기 추, 예쁜 여자 추")
     ("帚" . "비 추, 털 추")
     ("惆" . "실심할 추, 섭섭할 추")
     "愀"
     ("捶" . "종아리 칠 추, 짓찧을 추")
     ("揫" . "묶을 추, 거둘 추, 모을 추")
     ("搥" . "북 칠 추")
     ("甃" . "우물 벽돌 추")
     ("瘳" . "병 나을 추, 덜릴 추")
     ("箒" . "비 추")
     ("箠" . "채찍 추, 볼기채 추")
     ("簉" . "버금 추, 가지런히 날 추")
     ("縋" . "줄에 달릴 추")
     ("縐" . "주름 추, 구길 추")
     ("蒭" . "芻와 同字")
     "蝤"
     "鍬"
     ("陬" . "벼루 추, 정월 추, 부끄러울 추, 마을 추")
     ("隹" . "새 추")
     ("鞦" . "그네 추, 말고들개 추")
     ("騅" . "청부루말 추")
     ("魋" . "북상투 추")
     ("鰌" . "미꾸라지 추, 빙자할 추, 해추 추")
     ("鵻" . "아롱비둘기 추")
     ("鶖" . "두루미 추")
     "鶵"
     "麄"
     ("麤" . "성길 추, 클 추, 거칠 추")
     ("龝" . "秋의 古字"))
    ("추가"
     "追加")
    ("추가적"
     "追加的")
    ("추간판"
     "椎間板")
    ("추격"
     "追擊")
    ("추격전"
     "追擊戰")
    ("추경"
     "追更")
    ("추계"
     "推計"
     "秋季")
    ("추곡"
     "秋穀")
    ("추골"
     "椎骨")
    ("추구"
     "追求"
     "追究")
    ("추구욕"
     "追求慾")
    ("추궁"
     "追窮")
    ("추기경"
     "樞機卿")
    ("추나"
     "推拿")
    ("추달"
     "推撻")
    ("추대"
     "推戴")
    ("추도사"
     "追悼辭")
    ("추도식"
     "追悼式")
    ("추돌"
     "追突")
    ("추동"
     "推動"
     "秋冬")
    ("추락"
     "墜落")
    ("추론"
     "推論")
    ("추리"
     "推理")
    ("추리극적"
     "推理劇的")
    ("추리력"
     "推理力")
    ("추모"
     "追慕")
    ("추모비"
     "追慕碑")
    ("추모식"
     "追慕式")
    ("추모제"
     "追慕祭")
    ("추문"
     "醜聞")
    ("추방"
     "追放")
    ("추방당"
     "追放當")
    ("추분"
     "秋分")
    ("추산"
     "推算")
    ("추상"
     "抽象"
     "秋霜")
    ("추상성"
     "抽象性")
    ("추상어"
     "抽象語")
    ("추상적"
     "抽象的")
    ("추상주의"
     "抽象主義")
    ("추상파"
     "抽象派")
    ("추상화"
     "抽象化"
     "抽象畵")
    ("추서"
     "追敍")
    ("추석"
     "秋夕")
    ("추세"
     "趨勢")
    ("추수"
     "秋收"
     "追隨")
    ("추수선"
     "秋水禪")
    ("추수주의"
     "追隨主義")
    ("추수주의자"
     "秋收主義者")
    ("추신"
     "追伸")
    ("추심"
     "推尋")
    ("추악"
     "醜惡")
    ("추악상"
     "醜惡相")
    ("추앙"
     "推仰")
    ("추억"
     "追憶")
    ("추억담"
     "追憶談")
    ("추억물"
     "追憶物")
    ("추월"
     "追越")
    ("추이"
     "推移")
    ("추인"
     "追認")
    ("추인적"
     "追認的")
    ("추잡"
     "醜雜")
    ("추장"
     "酋長")
    ("추적"
     "追跡")
    ("추전"
     "鰍典")
    ("추정"
     "推定")
    ("추정액"
     "推定額")
    ("추정치"
     "推定値")
    ("추종"
     "追從")
    ("추종자"
     "追從者")
    ("추진"
     "推進")
    ("추진력"
     "推進力")
    ("추진반"
     "推進班")
    ("추진부장"
     "推進部長")
    ("추진제"
     "推進劑")
    ("추징"
     "追徵")
    ("추징금"
     "追徵金")
    ("추천"
     "推薦"
     "追薦")
    ("추천권자"
     "推薦權者")
    ("추천사"
     "推薦辭")
    ("추천서"
     "推薦書")
    ("추첨"
     "抽籤")
    ("추체"
     "椎體")
    ("추체험"
     "追體驗")
    ("추초"
     "秋草")
    ("추축국"
     "樞軸國")
    ("추출"
     "抽出")
    ("추출물"
     "抽出物")
    ("추출액"
     "抽出液")
    ("추측"
     "推測")
    ("추측성"
     "推測性")
    ("추태"
     "醜態")
    ("추파"
     "秋波")
    ("추풍낙엽"
     "秋風落葉")
    ("추행"
     "醜行")
    ("추호"
     "秋毫")
    ("추후"
     "追後")
    ("축"
     ("丑" . "소 축, 축시 축, 북동쪽 축")
     ("柚" . "북 축")
     ("畜" . "가축 축, 쌓을 축, 그칠 축")
     ("祝" . "빌 축, 끊을 축, 비로소 축")
     ("竺" . "나라이름 축")
     ("筑" . "비파 축")
     ("築" . "다질 축, 쌓을 축")
     ("縮" . "줄어들 축, 물러갈 축, 거둘 축, 모자랄 축")
     ("蓄" . "쌓을 축, 모을 축, 감출 축")
     ("蹙" . "찡그릴 축, 쭈그러질 축")
     ("蹴" . "찰 축, 밟을 축")
     ("軸" . "바디집 축, 질책 축, 속바퀴 축, 얇을 축")
     ("逐" . "쫓을 축, 물리칠 축")
     ("妯" . "동서 축")
     ("槭" . "단풍나무 축")
     ("舳" . "고물 축, 배 꼬리 축")
     ("豖" . "발 얽은 돼지걸음 축")
     ("蹜" . "발 끌어 디딜 축")
     ("鼀" . "두꺼비 축"))
    ("축가"
     "祝歌")
    ("축간사"
     "祝刊辭")
    ("축객"
     "逐客")
    ("축관"
     "祝官")
    ("축구"
     "蹴球")
    ("축구계"
     "蹴球界")
    ("축구단"
     "蹴球團")
    ("축구부"
     "蹴球部")
    ("축구인"
     "蹴球人")
    ("축구장"
     "蹴球場")
    ("축구회"
     "蹴球會")
    ("축농증"
     "蓄膿症")
    ("축대"
     "築臺")
    ("축도"
     "縮圖")
    ("축문"
     "祝文")
    ("축방"
     "築防")
    ("축배"
     "祝杯")
    ("축법"
     "築法")
    ("축복"
     "祝福")
    ("축사"
     "畜舍"
     "祝辭")
    ("축산"
     "畜産")
    ("축산물"
     "畜産物")
    ("축산업"
     "畜産業")
    ("축산업자"
     "畜産業者")
    ("축생"
     "畜生")
    ("축선"
     "軸線")
    ("축성"
     "築城")
    ("축소"
     "縮小")
    ("축소판"
     "縮小版")
    ("축시"
     "縮時")
    ("축음기"
     "蓄音機")
    ("축의금"
     "祝儀金")
    ("축재"
     "蓄財")
    ("축재자"
     "蓄財者")
    ("축적"
     "蓄積")
    ("축전"
     "祝典")
    ("축전기"
     "蓄電器")
    ("축전지"
     "蓄電池")
    ("축제"
     "祝祭")
    ("축제일"
     "祝祭日")
    ("축제적"
     "祝祭的")
    ("축조"
     "築造")
    ("축조물"
     "築造物")
    ("축조적"
     "逐條的")
    ("축지법"
     "縮地法")
    ("축척"
     "縮尺")
    ("축첩"
     "蓄妾")
    ("축출"
     "逐出")
    ("축포"
     "祝砲")
    ("축하"
     "祝賀")
    ("축하객"
     "祝賀客")
    ("축하단"
     "祝賀團")
    ("축하연"
     "祝賀宴")
    ("축하주"
     "祝賀酒")
    ("축하품"
     "祝賀品")
    ("축항"
     "築港")
    ("춘"
     ("春" . "봄 춘, 남녀의 정 춘, 술 춘, 온화할 춘")
     ("椿" . "참죽나무 춘, 대춘나무 춘, 어르신네 춘")
     "瑃")
    ("춘계"
     "春季")
    ("춘궁기"
     "春窮期")
    ("춘방"
     "春榜")
    ("춘분"
     "春分")
    ("춘양목"
     "春陽木")
    ("춘추"
     "春秋")
    ("춘축"
     "春祝")
    ("춘축심"
     "春祝心")
    ("춘풍"
     "春風")
    ("춘하추동"
     "春夏秋冬")
    ("춘향"
     "春香")
    ("춘화"
     "春畵")
    ("출"
     ("出" . "날 출, 게울 출, 도망할 출, 보일 출, 낳을 출, 물러갈 출, 생질 출")
     ("朮" . "삽주뿌리 출")
     ("黜" . "내칠 출, 물리칠 출")
     ("秫" . "차조 출"))
    ("출가"
     "出嫁"
     "出家")
    ("출가외인"
     "出嫁外人")
    ("출간"
     "出刊")
    ("출감"
     "出監")
    ("출강"
     "出講")
    ("출격"
     "出擊")
    ("출고"
     "出庫")
    ("출고일"
     "出庫日")
    ("출구"
     "出口")
    ("출국"
     "出國")
    ("출근"
     "出勤")
    ("출금"
     "出禁"
     "出金")
    ("출납"
     "出納")
    ("출당"
     "黜黨")
    ("출동"
     "出動")
    ("출두"
     "出頭")
    ("출력"
     "出力")
    ("출력기"
     "出力機")
    ("출루율"
     "出壘率")
    ("출마"
     "出馬")
    ("출마설"
     "出馬說")
    ("출마자"
     "出馬者")
    ("출몰"
     "出沒")
    ("출반"
     "出班")
    ("출발"
     "出發")
    ("출발법"
     "出發法")
    ("출발선"
     "出發線")
    ("출발점"
     "出發點")
    ("출범"
     "出帆")
    ("출분"
     "出奔")
    ("출사표"
     "出師表")
    ("출산"
     "出産")
    ("출산기"
     "出産氣")
    ("출산력"
     "出産力")
    ("출산아"
     "出産兒")
    ("출산율"
     "出産率")
    ("출산자"
     "出産者")
    ("출생"
     "出生")
    ("출생설"
     "出生說")
    ("출생인"
     "出生人")
    ("출생지"
     "出生地")
    ("출석"
     "出席")
    ("출석부"
     "出席簿")
    ("출세"
     "出世")
    ("출세작"
     "出世作")
    ("출세주의"
     "出世主義")
    ("출소자"
     "出所者")
    ("출시"
     "出市")
    ("출시사"
     "出市社")
    ("출신"
     "出身")
    ("출신고"
     "出身高")
    ("출신자"
     "出身者")
    ("출신지"
     "出身地")
    ("출어"
     "出漁")
    ("출연"
     "出捐"
     "出演")
    ("출연금"
     "出捐金")
    ("출연료"
     "出演料")
    ("출연자"
     "出演者")
    ("출연진"
     "出演陣")
    ("출옥"
     "出獄")
    ("출원"
     "出願")
    ("출원인"
     "出願人")
    ("출입"
     "出入")
    ("출입구"
     "出入口")
    ("출입국"
     "出入國")
    ("출입문"
     "出入門")
    ("출입항"
     "出入港")
    ("출자"
     "出資")
    ("출자금"
     "出資金")
    ("출자액"
     "出資額")
    ("출자자"
     "出資者")
    ("출장"
     "出場"
     "出張")
    ("출장비"
     "出張費")
    ("출장소"
     "出張所")
    ("출전"
     "出戰")
    ("출전비"
     "出戰費")
    ("출정"
     "出廷"
     "出征")
    ("출정식"
     "出征式")
    ("출제"
     "出題")
    ("출중"
     "出衆")
    ("출처"
     "出處")
    ("출타"
     "出他")
    ("출토"
     "出土")
    ("출퇴근"
     "出退勤")
    ("출판"
     "出版")
    ("출판가"
     "出版街")
    ("출판계"
     "出版界")
    ("출판국"
     "出版國")
    ("출판물"
     "出版物")
    ("출판부"
     "出版部")
    ("출판사"
     "出版社")
    ("출판업주"
     "出版業主")
    ("출판인"
     "出版人")
    ("출품"
     "出品")
    ("출품작"
     "出品作")
    ("출하"
     "出荷")
    ("출하량"
     "出荷量")
    ("출항"
     "出港")
    ("출항주"
     "出港酒")
    ("출향관"
     "出鄕關")
    ("출현"
     "出現")
    ("출혈"
     "出血")
    ("출혈열"
     "出血熱")
    ("충"
     ("充" . "가득찰 충, 막을 충, 당할 충")
     ("忠" . "충성 충, 곧을 충")
     ("沖" . "깊을 충, 온화할 충, 어릴 충")
     ("蟲" . "벌레 충, 김 오를 충")
     ("衝" . "충돌할 충, 찌를 충, 거리 충, 돌파할 충")
     ("衷" . "가운데 충, 정성 충, 착할 충, 속곳 충, 마음 충")
     ("冲" . "깊을 충, 온화할 충, 어릴 충")
     ("忡" . "근심할 충")
     "珫"
     "艟"
     ("虫" . "벌레 충"))
    ("충격"
     "衝擊"
     "衝激")
    ("충격력"
     "衝擊力")
    ("충격식"
     "衝擊式")
    ("충격적"
     "衝擊的")
    ("충격파"
     "衝擊波")
    ("충고"
     "忠告")
    ("충당"
     "充當")
    ("충돌"
     "衝突")
    ("충돌대"
     "衝突帶")
    ("충동"
     "衝動")
    ("충동구매"
     "衝動購買")
    ("충동적"
     "衝動的")
    ("충량"
     "衝樑")
    ("충렬탑"
     "忠烈塔")
    ("충만"
     "充滿")
    ("충분"
     "充分")
    ("충분조건"
     "充分條件")
    ("충상호형"
     "充常戶刑")
    ("충성"
     "忠誠")
    ("충성도"
     "忠誠度")
    ("충성심"
     "忠誠心")
    ("충신"
     "忠臣")
    ("충실"
     "充實"
     "忠實")
    ("충실성"
     "充實性")
    ("충심"
     "衷心")
    ("충원"
     "充員")
    ("충일"
     "充溢")
    ("충적세"
     "沖積世")
    ("충적지"
     "沖積地")
    ("충전"
     "充電")
    ("충전식"
     "充電式")
    ("충절"
     "忠節")
    ("충정"
     "忠情")
    ("충족"
     "充足")
    ("충족감"
     "充足感")
    ("충족성"
     "充足性")
    ("충족적"
     "充足的")
    ("충직"
     "忠直")
    ("충천"
     "衝天")
    ("충청도"
     "忠淸道")
    ("충치"
     "蟲齒")
    ("충혈"
     "充血")
    ("충효"
     "忠孝")
    ("췌"
     ("悴" . "근심할 췌, 파리할 췌, 피폐할 췌")
     ("膵" . "첩육경 췌, 지라 췌")
     ("萃" . "모을 췌, 괘 이름 췌")
     ("贅" . "붙일 췌, 데릴사위 췌, 혹 췌, 군더더기 췌")
     ("惴" . "두려워할 췌")
     "揣"
     "疩"
     "瘁"
     "顇")
    ("췌장"
     "膵臟")
    ("췌장암"
     "膵臟癌")
    ("췌장염"
     "膵臟炎")
    ("취"
     ("取" . "거둘 취, 찾을 취, 받을 취, 빼앗을 취, 장가들 취")
     ("吹" . "불 취, 숨쉴 취, 악기 불 취, 부를 취, 충동할 취")
     ("嘴" . "부리 취")
     ("娶" . "장가들 취, 중개인 취")
     ("就" . "좇을 취, 이룰 취, 곧 취, 가령 취, 능할 취, 저자 취")
     ("炊" . "불 지필 취, 밥 지을 취")
     ("翠" . "비취 취, 푸를 취")
     ("聚" . "모을 취, 고을 취, 걷을 취, 쌓을 취")
     ("脆" . "연할 취, 약할 취")
     ("臭" . "냄새 취, 향기 취, 썪을 취, 고약한 이름 취")
     ("趣" . "추창할 취, 뜻 취")
     ("醉" . "술취할 취, 궤란할 취")
     ("驟" . "몰아갈 취, 달릴 취, 별안간 취")
     ("鷲" . "독수리 취")
     ("冣" . "쌓을 취, 모을 취")
     ("揣" . "잴 취, 시험할 취, 요량할 취")
     ("毳" . "솜털 취, 연하고 부드러울 취")
     ("觜" . "부리 취"))
    ("취객"
     "醉客")
    ("취급"
     "取扱")
    ("취급당"
     "取扱當")
    ("취급률"
     "取扱率")
    ("취기"
     "醉氣")
    ("취득"
     "取得")
    ("취득자"
     "取得者")
    ("취락"
     "聚落")
    ("취락지"
     "聚落地")
    ("취로"
     "就勞")
    ("취모방"
     "吹毛紡")
    ("취미"
     "趣味")
    ("취민유도"
     "取民有度")
    ("취사"
     "取捨"
     "炊事")
    ("취사도구"
     "炊事道具")
    ("취사선택"
     "取捨選擇")
    ("취사장"
     "炊事場")
    ("취생몽사"
     "醉生夢死")
    ("취소"
     "取消")
    ("취약"
     "脆弱")
    ("취약성"
     "脆弱性")
    ("취약점"
     "脆弱點")
    ("취업"
     "就業")
    ("취업난"
     "就業難")
    ("취업률"
     "就業率")
    ("취업반"
     "就業班")
    ("취업자"
     "就業者")
    ("취임"
     "就任")
    ("취임사"
     "就任辭")
    ("취임식"
     "就任式")
    ("취임일"
     "就任日")
    ("취입"
     "吹入")
    ("취재"
     "取材")
    ("취재반"
     "取材班")
    ("취재석"
     "取材席")
    ("취재원"
     "取材源")
    ("취재지"
     "取材地")
    ("취재진"
     "取材陣")
    ("취조"
     "取調")
    ("취중"
     "醉中")
    ("취지"
     "趣旨")
    ("취지문"
     "趣旨文")
    ("취직"
     "就職")
    ("취침"
     "就寢")
    ("취침나팔"
     "就寢喇叭")
    ("취택"
     "取擇")
    ("취하"
     "取下")
    ("취학"
     "就學")
    ("취학률"
     "就學率")
    ("취합"
     "聚合")
    ("취항"
     "就航")
    ("취향"
     "趣向")
    ("측"
     ("仄" . "기울 측, 성조 측, 물이 괄괄 흐를 측, 희미할 측, 옆 측, 돈 이름 측")
     ("側" . "곁 측, 기울어질 측, 저물 측, 배반할 측, 가까울 측, 미천할 측, 아플 측")
     ("厠" . "뒷간 측, 평상 가장자리 측, 섞일 측")
     ("惻" . "슬플 측, 감창할 측, 아플 측, 불쌍할 측")
     ("測" . "측량할 측, 깊을 측, 맑을 측, 날카로울 측")
     "廁"
     "昃")
    ("측간"
     "厠間")
    ("측근"
     "側近")
    ("측근자"
     "側近者")
    ("측량"
     "測量")
    ("측량법"
     "測量法")
    ("측량술"
     "測量術")
    ("측량업자"
     "測量業者")
    ("측면"
     "側面")
    ("측면적"
     "側面的")
    ("측백"
     "側柏")
    ("측우기"
     "測雨器")
    ("측은"
     "惻隱")
    ("측은지심"
     "惻隱之心")
    ("측정"
     "測定")
    ("측정기"
     "測定器")
    ("측정망"
     "測定網")
    ("측정소"
     "測定所")
    ("측정치"
     "測定値")
    ("츤"
     "櫬"
     "藽"
     "襯"
     "齔")
    ("츰"
     "闖")
    ("층"
     ("層" . "겹 층, 거듭 층, 층층대 층"))
    ("층계"
     "層階")
    ("층계참"
     "層階站")
    ("층위"
     "層位")
    ("층층"
     "層層")
    ("층층대"
     "層層臺")
    ("층층시하"
     "層層侍下")
    ("층하"
     "層下")
    ("치"
     ("侈" . "사치할 치, 넓을 치, 많을 치, 풍부할 치")
     ("値" . "값 치, 가치있을 치, 만날 치, 당할 치")
     ("嗤" . "비웃을 치, 냉소 치")
     ("埴" . "찰진흙 치, 흙 이길 치")
     ("峙" . "산이 우뚝 솟을 치, 갖출 치, 쌓을 치")
     ("嵯" . "산 울뚝질뚝할 치")
     ("幟" . "깃대 치")
     ("徵" . "치성 치")
     ("恥" . "부끄럼 치, 욕될 치")
     ("梔" . "치자 치")
     ("治" . "다스릴 치, 다듬을 치, 익을 치, 치료할 치")
     ("淄" . "물이름 치, 검을 치")
     ("熾" . "불 활활 붙을 치")
     ("痔" . "치질 치")
     ("痴" . "癡의 俗字")
     ("癡" . "어리석을 치, 미련할 치, 미치광이 치, 주근깨 치")
     ("稚" . "어린 벼 치, 어릴 치, 늦을 치")
     ("穉" . "稚와 同字")
     ("緇" . "검을 치")
     ("緻" . "톡톡할 치, 빽빽할 치, 헌 옷 기울 치")
     ("置" . "베풀 치, 버릴 치, 역말 치, 안치할 치")
     ("致" . "이를 치, 극진할 치, 버릴 치, 불러올 치, 풍치 치, 드릴 치, 보낼 치, 연구할 치")
     ("蚩" . "치벌레 치, 어리석을 치, 업신여길 치")
     ("輜" . "짐수레 치, 휘장 친 수레 치")
     ("雉" . "꿩 치, 폐백 치, 성 윗담 치, 목맬 치")
     ("馳" . "달릴 치, 거동길 치, 전할 치")
     ("齒" . "이 치, 나이 치, 같을 치")
     ("卮" . "술잔 치, 연지 치")
     ("哆" . "입 딱 벌일 치")
     ("寘" . "둘 치, 폐할 치, 쉴 치")
     ("巵" . "잔 치, 연지 치")
     ("廁" . "뒷간 치, 평상 가장자리 치, 섞일 치, 버금 치")
     ("畤" . "제터 치")
     ("痓" . "풍병 치, 악할 치")
     ("絺" . "가는 칡베 치, 가는 갈포 치")
     ("菑" . "따비밭 치")
     ("薙" . "풀 깎을 치")
     "螭"
     ("褫" . "옷 빼앗을 치, 벗을 치, 넋 잃을 치")
     ("豸" . "발 없는 벌레 치, 풀 치, 해치양 치")
     ("跱" . "머뭇거릴 치, 주저할 치, 갖출 치")
     ("錙" . "저울눈 치, 조금 치")
     ("阤" . "떨어질 치, 헐릴 치, 언덕 치, 사태날 치")
     ("鯔" . "숭어 치")
     ("鴙" . "雉와 同字")
     ("鴟" . "솔개 치, 수알치 치, 부엉이 치, 말똥구리 치, 토란 치, 마음대로 날릴 치, 올빼미 치")
     ("鵄" . "솔개 치")
     "黐")
    ("치골"
     "恥骨")
    ("치과"
     "齒科")
    ("치과의"
     "齒科醫")
    ("치근"
     "齒根")
    ("치근막"
     "齒根膜")
    ("치기"
     "稚氣")
    ("치기만만"
     "稚氣滿滿")
    ("치도곤"
     "治盜棍")
    ("치료"
     "治療")
    ("치료가"
     "治療價")
    ("치료법"
     "治療法")
    ("치료비"
     "治療費")
    ("치료실"
     "治療室")
    ("치료자"
     "治療者")
    ("치료제"
     "治療劑")
    ("치명적"
     "致命的")
    ("치명타"
     "致命打")
    ("치모"
     "恥毛")
    ("치목"
     "治木")
    ("치밀"
     "緻密")
    ("치부"
     "恥部"
     "置簿"
     "致富")
    ("치부책"
     "置簿冊")
    ("치사"
     "恥事"
     "致死"
     "致詞")
    ("치사상"
     "致死傷")
    ("치사율"
     "致死率")
    ("치세"
     "治世")
    ("치수"
     "治水")
    ("치신경"
     "齒神經")
    ("치아"
     "齒牙")
    ("치안"
     "治安")
    ("치안국장"
     "治安局長")
    ("치안대"
     "治安隊")
    ("치약"
     "齒藥")
    ("치열"
     "熾烈"
     "齒列")
    ("치외"
     "治外")
    ("치욕"
     "恥辱")
    ("치유"
     "治癒")
    ("치유력"
     "治癒力")
    ("치유책"
     "治癒策")
    ("치의"
     "緇衣")
    ("치자"
     "梔子")
    ("치장"
     "治粧")
    ("치적"
     "治績")
    ("치정"
     "癡情")
    ("치졸"
     "稚拙")
    ("치중"
     "置重")
    ("치질"
     "痔疾")
    ("치통"
     "齒痛")
    ("치하"
     "治下")
    ("치한"
     "癡漢")
    ("치환"
     "置換")
    ("칙"
     ("則" . "법칙 칙, 본받을 칙, 모범 칙, 조목 칙")
     ("勅" . "신칙할 칙, 칙령 칙")
     ("飭" . "갖출 칙, 닦을 칙, 부지런할 칙")
     ("敕" . "경계할 칙, 다스릴 칙, 삼갈 칙, 바를 칙, 칙서 칙, 기릴 칙, 신칙할 칙"))
    ("칙사"
     "勅使")
    ("칙서"
     "勅書")
    ("친"
     ("親" . "사랑할 친, 친할 친, 몸소 친, 일가 친, 사돈 친")
     ("櫬" . "관 친, 무궁화나무 친, 땔나무 친")
     ("襯" . "속옷 친, 접근할 친, 베풀 친")
     ("齔" . "이 갈 친, 어릴 친"))
    ("친가"
     "親家")
    ("친고죄"
     "親告罪")
    ("친교"
     "親交")
    ("친구"
     "親舊")
    ("친구지간"
     "親舊之間")
    ("친귀족적"
     "親貴族的")
    ("친근"
     "親近")
    ("친근감"
     "親近感")
    ("친동생"
     "親同生")
    ("친목"
     "親睦")
    ("친목계"
     "親睦契")
    ("친목회"
     "親睦會")
    ("친밀"
     "親密")
    ("친밀감"
     "親密感")
    ("친밀도"
     "親密度")
    ("친부모"
     "親父母")
    ("친분"
     "親分")
    ("친서"
     "親書")
    ("친서방"
     "親西方")
    ("친선"
     "親善")
    ("친선전"
     "親善戰")
    ("친손녀"
     "親孫女")
    ("친손자"
     "親孫子")
    ("친숙"
     "親熟")
    ("친숙성"
     "親熟性")
    ("친애"
     "親愛")
    ("친야"
     "親野")
    ("친여"
     "親與")
    ("친원전"
     "親原電")
    ("친위"
     "親衛")
    ("친위대"
     "親衛隊")
    ("친일"
     "親日")
    ("친일적"
     "親日的")
    ("친일파"
     "親日派")
    ("친자"
     "親子")
    ("친자매"
     "親姉妹")
    ("친자식"
     "親子息")
    ("친잠례"
     "親蠶禮")
    ("친절"
     "親切")
    ("친정"
     "親庭"
     "親政")
    ("친조부모"
     "親祖父母")
    ("친족"
     "親族")
    ("친지"
     "親知")
    ("친척"
     "親戚")
    ("친형"
     "親兄")
    ("친형제"
     "親兄弟")
    ("친화"
     "親和")
    ("친화감"
     "親和感")
    ("친화력"
     "親和力")
    ("친화성"
     "親和性")
    ("친화적"
     "親和的")
    ("칠"
     ("七" . "일곱 칠, 글체이름 칠")
     ("柒" . "漆의 俗字")
     ("漆" . "옻나무 칠, 물이름 칠"))
    ("칠거지악"
     "七去之惡")
    ("칠기"
     "漆器")
    ("칠면조"
     "七面鳥")
    ("칠백"
     "七百")
    ("칠백오십삼"
     "七百五十三")
    ("칠보"
     "七寶")
    ("칠삭"
     "七朔")
    ("칠서"
     "七書")
    ("칠석"
     "七夕")
    ("칠순"
     "七旬")
    ("칠십"
     "七十")
    ("칠십객"
     "七十客")
    ("칠십억"
     "七十億")
    ("칠십일"
     "七十一")
    ("칠오조"
     "七五調")
    ("칠월"
     "七月")
    ("칠전팔기"
     "七顚八起")
    ("칠천"
     "七賤")
    ("칠천만"
     "七千萬")
    ("칠첩반상"
     "七-飯床")
    ("칠촌"
     "七寸")
    ("칠판"
     "漆板")
    ("칠팔"
     "七八")
    ("칠팔십"
     "七八十")
    ("칠팔월"
     "七八月")
    ("칠팔월생"
     "七八月生")
    ("칠향계탕"
     "七香鷄湯")
    ("칠흑"
     "漆黑")
    ("침"
     ("侵" . "범할 침, 침노할 침, 습격할 침, 흉작 침")
     ("寢" . "잠잘 침, 쉴 침, 방 침, 못생길 침")
     ("枕" . "베개 침, 수레뒤 가로댄 나무 침, 소말뚝 침")
     ("沈" . "장마물 침, 진펄 침, 잠길 침, 채색할 침, 고요할 침")
     ("浸" . "적실 침, 불릴 침, 번질 침, 빠질 침")
     ("湛" . "빠질 침, 잠길 침")
     ("琛" . "보배 침")
     ("砧" . "방칫돌 침, 다듬잇돌 침")
     "諶"
     ("針" . "바늘 침, 침 침, 바느질할 침, 찌를 침")
     ("鍼" . "바늘 침, 침 침")
     ("寖" . "젖을 침, 점점 침")
     ("忱" . "믿을 침, 정성 침")
     "梣"
     ("椹" . "모탕 침, 도끼바탕 침, 토막 침")
     ("沉" . "沈의 俗字")
     ("郴" . "땅이름 침")
     ("鋟" . "새길 침")
     ("駸" . "말 몰아 달릴 침"))
    ("침공"
     "侵攻")
    ("침구"
     "寢具"
     "鍼灸")
    ("침구류"
     "寢具類")
    ("침낭"
     "寢囊")
    ("침노"
     "侵擄")
    ("침대"
     "寢臺")
    ("침대보"
     "寢臺褓")
    ("침략"
     "侵掠"
     "侵略")
    ("침략기"
     "侵略期")
    ("침략당"
     "侵略當")
    ("침략성"
     "侵略性")
    ("침략자"
     "侵略者")
    ("침략적"
     "侵略的")
    ("침모"
     "針母")
    ("침몰"
     "沈沒")
    ("침묵"
     "沈默")
    ("침묵병"
     "沈默病")
    ("침묵증"
     "沈默症")
    ("침범"
     "侵犯")
    ("침봉"
     "針峯")
    ("침상"
     "寢牀")
    ("침선"
     "針線")
    ("침수"
     "沈水"
     "浸水")
    ("침술"
     "鍼術")
    ("침식"
     "侵蝕"
     "寢食"
     "浸蝕")
    ("침식곡"
     "浸蝕谷")
    ("침실"
     "寢室")
    ("침염"
     "浸染")
    ("침엽수"
     "針葉樹")
    ("침엽수림"
     "針葉樹林")
    ("침울"
     "沈鬱")
    ("침윤"
     "浸潤")
    ("침입"
     "侵入")
    ("침입자"
     "侵入者")
    ("침입죄"
     "侵入罪")
    ("침잠"
     "沈潛")
    ("침전"
     "沈澱")
    ("침전물"
     "沈澱物")
    ("침착"
     "沈着")
    ("침체"
     "沈滯")
    ("침체기"
     "沈滯期")
    ("침침"
     "沈沈")
    ("침탈"
     "侵奪")
    ("침통"
     "沈痛")
    ("침투"
     "浸透")
    ("침하"
     "沈下")
    ("침해"
     "侵害")
    ("침해당"
     "侵害當")
    ("침해자"
     "侵害者")
    ("침해죄"
     "侵害罪")
    ("칩"
     ("蟄" . "벌레 움츠릴 칩, 우물거릴 칩"))
    ("칩거"
     "蟄居")
    ("칭"
     ("秤" . "저울 칭, 백 근 칭")
     ("稱" . "저울질할 칭, 일컬을 칭, 헤아릴 칭, 같을 칭"))
    ("칭송"
     "稱頌")
    ("칭제"
     "稱帝")
    ("칭찬"
     "稱讚")
    ("칭호"
     "稱號")
    ("쾌"
     ("快" . "기분이 좋을 쾌, 시원할 쾌, 빠를 쾌")
     ("獪" . "간교할 쾌, 교활할 쾌")
     ("噲" . "목구멍 쾌, 훨할 쾌")
     ("夬" . "결단할 쾌, 나누어 정할 쾌, 괘 이름 쾌"))
    ("쾌감"
     "快感")
    ("쾌거"
     "快擧")
    ("쾌도난마"
     "快刀亂麻")
    ("쾌락"
     "快樂")
    ("쾌락적"
     "快樂的")
    ("쾌락주의"
     "快樂主義")
    ("쾌자"
     "快子")
    ("쾌재"
     "快哉")
    ("쾌적"
     "快適")
    ("쾌적감"
     "快適感")
    ("쾌차"
     "快差")
    ("쾌청"
     "快晴")
    ("쾌활"
     "快活")
    ("타"
     ("他" . "다를 타, 저 타, 간사할 타")
     ("咤" . "꾸짖을 타, 슬플 타, 뿜을 타, 쩍쩍 씹는소리 타")
     ("唾" . "침 타, 버릴 타")
     ("墮" . "떨어질 타, 상투 타, 잃을 타")
     ("妥" . "편안할 타, 일 없을 타, 타협할 타, 떨어질 타")
     ("惰" . "게으를 타, 태만할 타")
     ("打" . "때릴 타")
     ("拖" . "拕와 同字")
     ("朶" . "나무가지 휘늘어질 타, 떨기 타, 움킬 타")
     ("楕" . "橢의 略字")
     ("舵" . "키 타")
     ("陀" . "비탈 타, 땅이름 타")
     "隋"
     ("馱" . "탈 타, 짐 실을 타")
     ("駝" . "약대 타, 곱사등이 타")
     ("佗" . "다를 타, 저 타, 마음에 든든할 타, 더할 타, 입을 타, 짊어질 타")
     "坨"
     "垞"
     ("拕" . "끌 타, 당길 타")
     ("柁" . "키 타")
     ("橢" . "둥글길죽할 타, 수레통 가운데그릇 타, 길죽한 그릇 타")
     ("沱" . "물이 갈래질 타, 큰 비 타, 눈물이 흐를 타")
     "詑"
     ("詫" . "자랑할 타, 풍칠 타, 신통할 타")
     ("跎" . "미끄러질 타")
     ("躱" . "피할 타")
     ("迤" . "어정거릴 타")
     "阤"
     ("駄" . "馱의 俗字")
     ("駞" . "駞와 同字")
     "驒"
     ("鮀" . "모래무지 타")
     ("鴕" . "타조 타")
     ("鼉" . "자라 타"))
    ("타각"
     "他覺")
    ("타개"
     "打開")
    ("타개책"
     "打開策")
    ("타건"
     "打鍵")
    ("타격"
     "打擊")
    ("타격대"
     "打擊隊")
    ("타결"
     "妥結")
    ("타결책"
     "妥結策")
    ("타계"
     "他界")
    ("타관송치"
     "他管送致")
    ("타교"
     "他校")
    ("타구"
     "唾具")
    ("타국"
     "他國")
    ("타군"
     "他郡")
    ("타기시"
     "唾棄視")
    ("타당"
     "他黨"
     "妥當")
    ("타당성"
     "妥當性")
    ("타도"
     "打倒")
    ("타락"
     "墮落")
    ("타락상"
     "墮落相")
    ("타락죽"
     "駝酪粥")
    ("타면"
     "他面")
    ("타박"
     "打撲")
    ("타박상"
     "打撲傷")
    ("타사"
     "他社")
    ("타산"
     "打算")
    ("타산성"
     "打算性")
    ("타산식"
     "打算式")
    ("타산적"
     "打算的")
    ("타산지석"
     "他山之石")
    ("타살"
     "他殺"
     "打殺")
    ("타성"
     "惰性")
    ("타성적"
     "惰性的")
    ("타성화"
     "惰性化")
    ("타아"
     "他我")
    ("타악기"
     "打樂器")
    ("타액선"
     "唾液腺")
    ("타원"
     "楕圓")
    ("타원형"
     "楕圓形")
    ("타율"
     "他律"
     "打率")
    ("타율성론"
     "他律性論")
    ("타율적"
     "他律的")
    ("타의"
     "他意")
    ("타의적"
     "他意的")
    ("타인"
     "他人")
    ("타자"
     "打字"
     "打者")
    ("타자건"
     "打字鍵")
    ("타자계"
     "打字界")
    ("타자기"
     "打字機")
    ("타자법"
     "打字法")
    ("타자수"
     "打字手")
    ("타작"
     "打作")
    ("타전"
     "打典"
     "打電")
    ("타점"
     "打點")
    ("타조"
     "駝鳥")
    ("타종"
     "打鐘")
    ("타종수"
     "打鐘手")
    ("타지"
     "他地")
    ("타지방"
     "他地方")
    ("타진"
     "打診")
    ("타처"
     "他處")
    ("타천"
     "他薦")
    ("타칭"
     "他稱")
    ("타파"
     "打破")
    ("타향"
     "他鄕")
    ("타협"
     "妥協")
    ("타협안"
     "妥協案")
    ("타협적"
     "妥協的")
    ("타협점"
     "妥協點")
    ("탁"
     ("倬" . "환할 탁, 클 탁")
     ("卓" . "높을 탁, 뛰어날 탁, 책상 탁, 성씨 탁")
     ("啄" . "쪼을 탁, 문 두드릴 탁")
     ("坼" . "찢을 탁, 터질 탁, 난산할 탁, 싹 트일 탁")
     ("托" . "밀칠 탁, 떡국 탁, 차반 탁")
     ("擢" . "뽑을 탁, 뺄 탁, 솟을 탁, 이길 탁")
     ("晫" . "환할 탁, 밝을 탁")
     ("柝" . "쪼갤 탁, 조두 탁, 목탁 탁")
     ("濁" . "흐릴 탁, 더러울 탁, 물이름 탁")
     ("濯" . "씻을 탁, 빨래할 탁, 적실 탁, 클 탁, 빛날 탁, 산 민둥민둥할 탁, 살찔 탁, 놀 탁")
     ("琢" . "옥 쪼을 탁, 옥 다듬을 탁, 가릴 탁")
     ("琸" . "사람이름 탁")
     ("託" . "맡길 탁, 부탁할 탁, 핑계할 탁")
     ("鐸" . "요령 탁, 목탁 탁")
     ("度" . "꾀할 탁, 헤아릴 탁, 벼슬이름 탁")
     ("拓" . "물리칠 탁, 헤칠 탁, 밀칠 탁")
     ("拆" . "터질 탁, 찢어질 탁, 열릴 탁")
     ("橐" . "전대 탁, 자루 탁, 도가니 탁, 공잇소리 탁, 짐승이름 탁")
     ("沰" . "떨어뜨릴 탁, 돌 던질 탁, 떨어질 탁")
     ("涿" . "물방울 떨어질 탁, 칠 탁, 물이름 탁, 땅이름 탁")
     ("矺" . "나무이름 탁")
     ("籜" . "대 껍질 탁")
     ("蘀" . "떨어질 탁, 마를 탁")
     "趠"
     ("踔" . "우뚝 설 탁, 앙감질 탁")
     ("逴" . "멀 탁, 절름거릴 탁, 뛰어날 탁"))
    ("탁견"
     "卓見")
    ("탁구"
     "卓球")
    ("탁구관"
     "卓球館")
    ("탁구대"
     "卓球臺")
    ("탁구장"
     "卓球場")
    ("탁류"
     "濁流")
    ("탁발"
     "托鉢")
    ("탁발식"
     "托鉢式")
    ("탁본"
     "拓本")
    ("탁상"
     "卓上")
    ("탁상공론"
     "卓上空論")
    ("탁상시계"
     "卓上時計")
    ("탁상출판"
     "卓上出版")
    ("탁송"
     "託送")
    ("탁아"
     "託兒")
    ("탁아방"
     "託兒房")
    ("탁아소"
     "託兒所")
    ("탁아원"
     "託兒院")
    ("탁엽"
     "托葉")
    ("탁월"
     "卓越")
    ("탁자"
     "卓子")
    ("탁주"
     "濁酒")
    ("탄"
     ("呑" . "삼킬 탄, 휩쌀 탄, 감출 탄, 멸할 탄")
     ("嘆" . "한숨쉴 탄")
     ("坦" . "너그러울 탄, 평평할 탄, 넓을 탄")
     ("彈" . "쏠 탄, 악기부릴 탄, 탄알 탄, 탄핵할 탄")
     ("憚" . "수고로울 탄, 꺼릴 탄")
     ("歎" . "탄식할 탄, 아름답다 할 탄, 화답할 탄")
     ("灘" . "여울 탄, 해 이름 탄")
     ("炭" . "숯 탄, 불똥 탄, 볶일 탄")
     ("綻" . "옷 터질 탄, 나타날 탄, 파할 탄")
     ("誕" . "기를 탄, 클 탄, 속일 탄, 넓을 탄, 탄생할 탄, 방탕할 탄")
     ("憻" . "坦과 同字")
     ("攤" . "열 탄, 펼칠 탄")
     ("殫" . "다할 탄")
     ("癱" . "중풍증 탄, 사지 틀릴 탄")
     ("驒" . "돈짝무늬총이말 탄"))
    ("탄광"
     "炭鑛")
    ("탄광업체"
     "炭鑛業體")
    ("탄광촌"
     "炭鑛村")
    ("탄도학"
     "彈道學")
    ("탄두"
     "彈頭")
    ("탄력"
     "彈力")
    ("탄력성"
     "彈力性")
    ("탄력적"
     "彈力的")
    ("탄로"
     "綻露")
    ("탄복"
     "歎服")
    ("탄산"
     "炭酸")
    ("탄산수"
     "炭酸水")
    ("탄산음료"
     "炭酸飮料")
    ("탄생"
     "誕生")
    ("탄생일"
     "誕生日")
    ("탄생지"
     "誕生地")
    ("탄성"
     "彈性"
     "歎聲")
    ("탄성파"
     "彈性波")
    ("탄소"
     "炭素")
    ("탄수화물"
     "炭水化物")
    ("탄식"
     "歎息")
    ("탄압"
     "彈壓")
    ("탄약실"
     "彈藥室")
    ("탄원"
     "歎願")
    ("탄원서"
     "歎願書")
    ("탄저병"
     "炭疽病")
    ("탄전"
     "炭田")
    ("탄좌"
     "炭座")
    ("탄탄대로"
     "坦坦大路")
    ("탄핵"
     "彈劾")
    ("탄핵권"
     "彈劾權")
    ("탄화수소"
     "炭化水素")
    ("탈"
     ("奪" . "빼앗을 탈, 잃어버릴 탈, 좁은 길 탈, 깎을 탈")
     ("脫" . "벗어날 탈, 간략할 탈, 뼈 바를 탈, 그르칠 탈")
     ("侻" . "간사할 탈, 가벼울 탈, 간략할 탈"))
    ("탈각"
     "脫却")
    ("탈고"
     "脫稿")
    ("탈곡기"
     "脫穀機")
    ("탈골"
     "脫骨")
    ("탈구"
     "脫臼")
    ("탈구조화"
     "脫構造化")
    ("탈근대적"
     "脫近代的")
    ("탈냉전"
     "脫冷戰")
    ("탈냉전기"
     "脫冷戰期")
    ("탈당"
     "脫黨")
    ("탈대권"
     "脫大權")
    ("탈락"
     "脫落")
    ("탈락률"
     "脫落率")
    ("탈락자"
     "脫落者")
    ("탈루"
     "脫漏")
    ("탈모"
     "脫帽")
    ("탈모증"
     "脫毛症")
    ("탈법"
     "脫法")
    ("탈법적"
     "脫法的")
    ("탈북"
     "脫北")
    ("탈북자"
     "脫北者")
    ("탈색"
     "脫色")
    ("탈선"
     "脫線")
    ("탈성별화"
     "脫性別化")
    ("탈세"
     "脫稅")
    ("탈세왕"
     "脫稅王")
    ("탈속"
     "脫俗")
    ("탈수"
     "脫水")
    ("탈수기"
     "脫水機")
    ("탈영"
     "脫營")
    ("탈영병"
     "脫營兵")
    ("탈옥"
     "脫獄")
    ("탈옥수"
     "脫獄囚")
    ("탈의실"
     "脫衣室")
    ("탈이념"
     "脫理念")
    ("탈일상성"
     "脫日常性")
    ("탈점"
     "奪占")
    ("탈정치적"
     "脫政治的")
    ("탈정치화"
     "脫政治化")
    ("탈주"
     "脫走")
    ("탈주자"
     "脫走者")
    ("탈진"
     "脫盡")
    ("탈집단주의"
     "脫集團主義")
    ("탈출"
     "脫出")
    ("탈출구"
     "脫出口")
    ("탈출기"
     "脫出記")
    ("탈출자"
     "脫出者")
    ("탈취"
     "奪取")
    ("탈취당"
     "奪取當")
    ("탈퇴"
     "脫退")
    ("탈퇴형"
     "脫退型")
    ("탈피"
     "脫皮")
    ("탈환"
     "奪還")
    ("탈황"
     "脫黃")
    ("탐"
     ("探" . "더듬을 탐, 찾을 탐, 취할 탐, 염탐할 탐")
     ("眈" . "노려볼 탐, 즐길 탐")
     ("耽" . "즐길 탐, 귀 축 늘어질 탐, 웅크리고 볼 탐, 즐거울 탐, 깊고 멀 탐")
     ("貪" . "탐할 탐, 욕심낼 탐")
     ("嗿" . "여럿이 먹는 소리 탐")
     ("酖" . "술 즐길 탐"))
    ("탐관오리"
     "貪官汚吏")
    ("탐구"
     "探求"
     "探究")
    ("탐구심"
     "探究心")
    ("탐닉"
     "耽溺")
    ("탐독"
     "耽讀")
    ("탐문"
     "探問")
    ("탐미주의자"
     "眈美主義者")
    ("탐미주의적"
     "眈美主義的")
    ("탐방"
     "探訪")
    ("탐방자"
     "探訪者")
    ("탐사"
     "探査")
    ("탐사선"
     "探査船")
    ("탐색"
     "探索")
    ("탐색기"
     "探索機")
    ("탐식"
     "貪食")
    ("탐신"
     "探新")
    ("탐욕"
     "貪慾")
    ("탐욕적"
     "貪慾的")
    ("탐정"
     "探偵")
    ("탐지"
     "探知")
    ("탐지기"
     "探知機")
    ("탐침"
     "探針")
    ("탐학"
     "貪虐")
    ("탐험"
     "探險")
    ("탐험가"
     "探險家")
    ("탐험관"
     "探險館")
    ("탑"
     ("塔" . "탑 탑")
     ("搭" . "모뜰 탑, 박을 탑")
     ("榻" . "평상 탑, 모직 탑, 자리 탑")
     ("傝" . "답답할 탑, 불안할 탑, 어리석을 탑, 용렬할 탑")
     ("塌" . "낮은 땅 탑, 초벌갈 탑, 떨어질 탑")
     ("搨" . "비문 박을 탑, 베낄 탑")
     "鰈")
    ("탑승"
     "搭乘")
    ("탑승자"
     "搭乘者")
    ("탑신"
     "塔身")
    ("탑재"
     "搭載")
    ("탕"
     ("宕" . "골집 탕, 방탕할 탕, 석수 탕")
     ("帑" . "나라 곳집 탕")
     ("湯" . "물 끓일 탕, 물이름 탕, 씻을 탕")
     ("蕩" . "넓고 클 탕, 없어질 탕, 방탕할 탕, 소탕할 탕")
     "糖"
     ("燙" . "씻을 탕, 불에 델 탕")
     ("盪" . "씻을 탕, 움직일 탕, 진동할 탕, 그릇 부실 탕, 뭍 배질할 탕")
     ("碭" . "무늬진 돌 탕, 흰 기운 탕, 넘칠 탕, 산이름 탕")
     ("蘯" . "盪과 同字"))
    ("탕감"
     "蕩減")
    ("탕건"
     "宕巾")
    ("탕녀"
     "蕩女")
    ("탕반"
     "湯飯")
    ("탕아"
     "蕩兒")
    ("탕약"
     "湯藥")
    ("탕자"
     "蕩子")
    ("탕진"
     "蕩盡")
    ("탕탕"
     "蕩蕩")
    ("태"
     ("兌" . "기쁠 태, 지름길 태, 모일 태, 통할 태, 곧을 태, 구멍 태, 바꿀 태, 괘 이름 태")
     ("台" . "별 태, 늙을 태")
     ("太" . "클 태, 굵을 태, 심할 태, 처음 태, 콩 태")
     ("怠" . "게으를 태, 느릴 태, 거만할 태")
     ("態" . "모양 태, 뜻 태")
     ("殆" . "위태할 태, 가까이할 태, 비롯할 태")
     ("汰" . "미끄러울 태, 넘칠 태, 씻길 태, 사치할 태")
     ("泰" . "클 태, 통할 태, 너그러울 태, 편안할 태, 괘 이름 태")
     ("笞" . "볼기칠 태")
     ("胎" . "아이 밸 태, 시작 태")
     ("苔" . "이끼 태")
     ("跆" . "밟을 태")
     ("邰" . "태나라 태")
     ("颱" . "몹시 부는 바람 태")
     "呆"
     ("埭" . "보뚝 태")
     ("娧" . "기뻐할 태, 더딜 태")
     "孡"
     ("抬" . "칠 태")
     "蛻"
     ("迨" . "미칠 태")
     "駄"
     "駘")
    ("태고"
     "太古")
    ("태곳"
     "太古")
    ("태교"
     "胎敎")
    ("태권도"
     "跆拳道")
    ("태권도인"
     "跆拳道人")
    ("태권도장"
     "跆拳道場")
    ("태극"
     "太極")
    ("태극기"
     "太極旗")
    ("태극형"
     "太極形")
    ("태내"
     "胎內")
    ("태도"
     "態度")
    ("태동"
     "胎動")
    ("태두"
     "泰斗")
    ("태만"
     "怠慢")
    ("태몽"
     "胎夢")
    ("태반"
     "太半"
     "胎盤")
    ("태반성"
     "胎盤性")
    ("태부족"
     "太不足")
    ("태사"
     "太絲")
    ("태사령"
     "太史令")
    ("태산"
     "泰山")
    ("태산준령"
     "泰山峻嶺")
    ("태산형"
     "泰山型")
    ("태생"
     "胎生")
    ("태세"
     "態勢")
    ("태아"
     "胎兒")
    ("태양"
     "太陽"
     "態樣")
    ("태양계"
     "太陽系")
    ("태양광"
     "太陽光")
    ("태양력"
     "太陽曆")
    ("태양신"
     "太陽神")
    ("태양열"
     "太陽熱")
    ("태양초"
     "太陽草")
    ("태연"
     "泰然")
    ("태엽"
     "胎葉")
    ("태음"
     "太陰")
    ("태음력"
     "太陰曆")
    ("태자"
     "太子")
    ("태조"
     "太祖")
    ("태중"
     "胎中")
    ("태초"
     "太初")
    ("태토"
     "胎土")
    ("태평"
     "太平")
    ("태평성대"
     "太平聖代")
    ("태풍"
     "颱風")
    ("태풍권"
     "颱風圈")
    ("태형"
     "笞刑")
    ("태환"
     "兌換")
    ("택"
     ("擇" . "가릴 택, 추릴 택, 차별할 택")
     ("澤" . "못 택, 진펄 택, 진액 택, 윤택할 택, 비와 이슬 택")
     ("宅" . "집 택, 자리 택, 살 택, 정할 택, 묘 구덩이 택"))
    ("택배"
     "宅配")
    ("택배료"
     "宅配料")
    ("택일"
     "擇一"
     "擇日")
    ("택지"
     "宅地")
    ("탱"
     ("撑" . "撐의 俗字")
     ("撐" . "버틸 탱, 취할 탱, 헤칠 탱")
     "牚")
    ("탱화"
     "幀畵")
    ("터"
     ("攄" . "펼칠 터, 흩을 터, 날칠 터, 비길 터"))
    ("터득"
     "攄得")
    ("토"
     ("兎" . "兔의 俗字")
     ("吐" . "토할 토, 나올 토, 펼 토")
     ("土" . "흙 토, 뿌리 토, 나라 토, 뭍 토")
     ("討" . "다스릴 토, 칠 토, 찾을 토, 벨 토, 꾸짖을 토")
     "菟")
    ("토광묘"
     "土壙墓")
    ("토굴"
     "土窟")
    ("토기"
     "土器")
    ("토기관"
     "土器館")
    ("토대"
     "土臺")
    ("토란"
     "土卵")
    ("토로"
     "吐露")
    ("토론"
     "討論")
    ("토론식"
     "討論式")
    ("토론자"
     "討論者")
    ("토론장"
     "討論場")
    ("토론집"
     "討論集")
    ("토론회"
     "討論會")
    ("토멸"
     "討滅")
    ("토목"
     "土木")
    ("토목과"
     "土木科")
    ("토목학자"
     "土木學者")
    ("토목학회"
     "土木學會")
    ("토방"
     "土房")
    ("토벌"
     "討伐")
    ("토벌군"
     "討伐軍")
    ("토사"
     "土沙")
    ("토사구팽"
     "兎死狗烹")
    ("토사물"
     "吐瀉物")
    ("토산"
     "土産")
    ("토산품"
     "土産品")
    ("토색"
     "討索")
    ("토성"
     "土城"
     "土姓"
     "土星")
    ("토성분정"
     "土姓分定")
    ("토속"
     "土俗")
    ("토속성"
     "土俗性")
    ("토속적"
     "土俗的")
    ("토수"
     "土手")
    ("토양"
     "土壤")
    ("토왜"
     "討倭")
    ("토요"
     "土曜")
    ("토요일"
     "土曜日")
    ("토의"
     "討議")
    ("토인"
     "土人")
    ("토장"
     "土醬")
    ("토정비결"
     "土亭秘訣")
    ("토종"
     "土種")
    ("토주"
     "吐紬")
    ("토지"
     "土地")
    ("토지관"
     "土地觀")
    ("토지세"
     "土地稅")
    ("토지적"
     "土地的")
    ("토질"
     "土質")
    ("토착"
     "土着")
    ("토착민"
     "土着民")
    ("토착성"
     "土着性")
    ("토착신"
     "土着神")
    ("토착적"
     "土着的")
    ("토착족"
     "土着族")
    ("토착화"
     "土着化")
    ("토현삼"
     "土玄蔘")
    ("토호"
     "土豪")
    ("톤"
     ("噋" . "啍과 同字"))
    ("통"
     ("慟" . "서러울 통")
     ("桶" . "엿되들이 통 통")
     ("痛" . "아플 통, 상할 통, 심할 통, 몹시 통")
     ("筒" . "사통대 통, 통 통")
     ("統" . "거느릴 통, 벼리 통, 실마디 통, 근본 통, 이을 통")
     ("通" . "뚫릴 통, 사무칠 통, 형통할 통, 사귈 통, 다닐 통, 간음할 통")
     ("洞" . "구렁 통, 깊을 통, 빌 통, 밝을 통")
     "侗"
     ("恫" . "슬플 통, 아플 통, 앓을 통")
     ("樋" . "대 홈 통, 어름나무 통")
     ("筩" . "대나무통 통, 낚시 통"))
    ("통감"
     "痛感"
     "統監")
    ("통계"
     "統計")
    ("통계적"
     "統計的")
    ("통계학"
     "統計學")
    ("통계학과"
     "統計學科")
    ("통고"
     "通告")
    ("통고서"
     "通告書")
    ("통곡"
     "痛哭")
    ("통과"
     "通過")
    ("통과조"
     "通過組")
    ("통관"
     "通關")
    ("통괄"
     "統括")
    ("통권"
     "通卷")
    ("통근"
     "通勤")
    ("통금"
     "通禁")
    ("통기성"
     "通氣性")
    ("통념"
     "通念")
    ("통달"
     "通達")
    ("통독"
     "統獨")
    ("통렬"
     "痛烈")
    ("통로"
     "通路")
    ("통박"
     "痛駁")
    ("통반장"
     "統班長")
    ("통방"
     "通房")
    ("통보"
     "通報")
    ("통불교"
     "通佛敎")
    ("통불교적"
     "統佛敎的")
    ("통사"
     "通史")
    ("통사정"
     "通事情")
    ("통산"
     "通算")
    ("통상"
     "通商"
     "通常")
    ("통상관"
     "通商官")
    ("통상국장"
     "通商局長")
    ("통상적"
     "通常的")
    ("통석"
     "痛惜")
    ("통선"
     "通船")
    ("통설"
     "通說")
    ("통설화"
     "通說化")
    ("통성명"
     "通姓名")
    ("통속"
     "通俗")
    ("통속극"
     "通俗劇")
    ("통속성"
     "通俗性")
    ("통속적"
     "通俗的")
    ("통속화"
     "通俗化")
    ("통솔"
     "統率")
    ("통수권"
     "統帥權")
    ("통시"
     "通時")
    ("통시적"
     "通時的")
    ("통신"
     "通信")
    ("통신관"
     "通信館")
    ("통신국"
     "通信國"
     "通信局")
    ("통신량"
     "通信量")
    ("통신망"
     "通信網")
    ("통신문"
     "通信文")
    ("통신병"
     "通信兵")
    ("통신부"
     "通信簿")
    ("통신사"
     "通信使"
     "通信社")
    ("통신선"
     "通信線")
    ("통신인"
     "通信人")
    ("통어"
     "統御")
    ("통역"
     "通譯")
    ("통역관"
     "通譯官")
    ("통역병"
     "通譯兵")
    ("통역인"
     "通譯人")
    ("통용"
     "通用")
    ("통원"
     "通院")
    ("통음"
     "痛飮")
    ("통일"
     "統一")
    ("통일감"
     "統一感")
    ("통일기"
     "統一期")
    ("통일론"
     "統一論")
    ("통일성"
     "統一性")
    ("통일안"
     "統一案")
    ("통일장"
     "統一場")
    ("통일적"
     "統一的")
    ("통일체"
     "統一體")
    ("통장"
     "通帳")
    ("통장식"
     "通帳式")
    ("통전"
     "統戰")
    ("통제"
     "統制")
    ("통제권"
     "統制權")
    ("통제기"
     "統制期")
    ("통제력"
     "統制力")
    ("통제적"
     "統制的")
    ("통제책"
     "統制策")
    ("통증"
     "痛症")
    ("통증학"
     "痛症學")
    ("통지"
     "通知")
    ("통지문"
     "通知文")
    ("통지서"
     "通知書")
    ("통찰"
     "洞察")
    ("통찰력"
     "洞察力")
    ("통첩"
     "通牒")
    ("통치"
     "統治")
    ("통치권"
     "統治權")
    ("통치권자"
     "統治權者")
    ("통치력"
     "統治力")
    ("통치배"
     "統治輩")
    ("통치자"
     "統治者")
    ("통치처"
     "統治處")
    ("통칙"
     "通則")
    ("통칭"
     "統稱"
     "通稱")
    ("통쾌"
     "痛快")
    ("통탄"
     "痛歎")
    ("통폐합"
     "統廢合")
    ("통폐합설"
     "統廢合說")
    ("통풍"
     "通風")
    ("통풍관"
     "通風管")
    ("통학"
     "通學")
    ("통한"
     "統韓")
    ("통할"
     "統轄")
    ("통합"
     "統合")
    ("통합론"
     "統合論")
    ("통합성"
     "統合性")
    ("통합액"
     "統合額")
    ("통합적"
     "統合的")
    ("통행"
     "通行")
    ("통행금지"
     "通行禁止")
    ("통행량"
     "通行量")
    ("통행로"
     "通行路")
    ("통행료"
     "通行料")
    ("통행증"
     "通行證")
    ("통형"
     "筒形")
    ("통혼권"
     "通婚圈")
    ("통화"
     "統和"
     "通話"
     "通貨")
    ("통화권"
     "通話圈")
    ("통화량"
     "通話量")
    ("통화료"
     "通話料")
    ("퇴"
     ("堆" . "흙무더기 퇴 놓을 퇴, 언덕 퇴")
     "椎"
     ("槌" . "몽둥이 퇴, 너스레 퇴, 누에시렁 퇴, 던질 퇴")
     "焞"
     ("腿" . "넓적다리 퇴")
     ("褪" . "옷 벗을 퇴, 꽃빛 옅어질 퇴")
     ("退" . "물러갈 퇴, 겸양할 퇴, 물리칠 퇴")
     ("鎚" . "옥 다듬을 퇴")
     ("頹" . "기울어질 퇴, 사나운 바람 퇴, 쇠할 퇴, 무너질 퇴, 대머리 퇴")
     "搥"
     ("隤" . "무너질 퇴, 미끄러질 퇴, 부드러울 퇴, 땅이름 퇴")
     "魋")
    ("퇴각"
     "退却")
    ("퇴거"
     "退去")
    ("퇴고"
     "推敲")
    ("퇴교당"
     "退校當")
    ("퇴교생"
     "退校生")
    ("퇴근"
     "退勤")
    ("퇴근제"
     "退勤制")
    ("퇴락"
     "頹落")
    ("퇴로"
     "退路")
    ("퇴물"
     "退物")
    ("퇴보"
     "退步")
    ("퇴비"
     "堆肥")
    ("퇴비화"
     "堆肥化")
    ("퇴사"
     "退社")
    ("퇴색"
     "退色")
    ("퇴역"
     "退役")
    ("퇴영하"
     "退영@")
    ("퇴원"
     "退院")
    ("퇴임"
     "退任")
    ("퇴장"
     "退場"
     "退藏")
    ("퇴장당"
     "退場當")
    ("퇴장설"
     "退場說")
    ("퇴적"
     "堆積")
    ("퇴적물"
     "堆積物")
    ("퇴적암"
     "堆積巖")
    ("퇴조"
     "退潮")
    ("퇴조기"
     "退潮期")
    ("퇴직"
     "退職")
    ("퇴직금"
     "退職金")
    ("퇴직률"
     "退職率")
    ("퇴직일"
     "退職日")
    ("퇴직자"
     "退職者")
    ("퇴진"
     "退陣")
    ("퇴진당"
     "退陣當")
    ("퇴짜"
     "退字")
    ("퇴창"
     "退窓")
    ("퇴창문"
     "推窓門")
    ("퇴청"
     "退廳")
    ("퇴치"
     "退治")
    ("퇴폐"
     "頹廢")
    ("퇴폐물"
     "頹廢物")
    ("퇴폐미"
     "頹廢美")
    ("퇴폐성"
     "頹廢性")
    ("퇴폐율"
     "頹廢率")
    ("퇴폐적"
     "頹廢的")
    ("퇴폐주의"
     "頹廢主義")
    ("퇴학"
     "退學")
    ("퇴학당"
     "退學當")
    ("퇴행"
     "退行")
    ("퇴행성"
     "退行性")
    ("퇴행적"
     "退行的")
    ("퇴화"
     "退化")
    ("투"
     ("偸" . "훔칠 투, 엷을 투, 구차할 투, 인정머리없을 투")
     ("套" . "전례 투")
     ("妬" . "투기할 투, 자식 없는 계집 투")
     ("投" . "던질 투, 버릴 투, 줄 투, 의탁할 투")
     ("透" . "통할 투, 사무칠 투, 지나칠 투")
     "鍮"
     ("鬪" . "싸움 투")
     ("妒" . "투기할 투, 미워할 투, 강샘할 투, 부러워할 투")
     ("渝" . "빛 변할 투, 더러워질 투, 고을이름 투")
     ("骰" . "주사위 투"))
    ("투고"
     "投稿")
    ("투고란"
     "投稿欄")
    ("투과"
     "透過")
    ("투구"
     "投球")
    ("투금"
     "投金")
    ("투기"
     "妬忌"
     "投企"
     "投棄"
     "投機")
    ("투기성"
     "投機性")
    ("투기심"
     "投機心")
    ("투기적"
     "投機的")
    ("투망식"
     "投網式")
    ("투매"
     "投賣")
    ("투명"
     "透明")
    ("투명감"
     "透明感")
    ("투명성"
     "透明性")
    ("투명지"
     "透明紙")
    ("투병"
     "鬪病")
    ("투사"
     "投射"
     "透射"
     "鬪士")
    ("투사기"
     "投射機")
    ("투사물"
     "投射物")
    ("투사성"
     "投射性")
    ("투서"
     "投書")
    ("투석"
     "投石")
    ("투석전"
     "投石戰")
    ("투수"
     "投手")
    ("투숙"
     "投宿")
    ("투숙객"
     "投宿客")
    ("투시"
     "透視")
    ("투시경"
     "透視鏡")
    ("투신"
     "投信"
     "投身")
    ("투신사"
     "投信社")
    ("투신자"
     "投信者")
    ("투신자살"
     "投身自殺")
    ("투약"
     "投藥")
    ("투여"
     "投與")
    ("투영"
     "投影")
    ("투옥"
     "投獄")
    ("투우장"
     "鬪牛場")
    ("투융자"
     "投融資")
    ("투입"
     "投入")
    ("투입구"
     "投入口")
    ("투자"
     "投資")
    ("투자가"
     "投資家")
    ("투자비"
     "投資費")
    ("투자액"
     "投資額")
    ("투자자"
     "投資者")
    ("투쟁"
     "鬪爭")
    ("투쟁가"
     "鬪爭家")
    ("투쟁성"
     "鬪爭性")
    ("투쟁적"
     "鬪爭的")
    ("투지"
     "鬪志")
    ("투척"
     "投擲")
    ("투척조"
     "投擲組")
    ("투철"
     "透徹")
    ("투표"
     "投票")
    ("투표구"
     "投票區")
    ("투표권"
     "投票權")
    ("투표권자"
     "投票權者")
    ("투표소"
     "投票所")
    ("투표율"
     "投票率")
    ("투표일"
     "投票日")
    ("투표자"
     "投票者")
    ("투표장"
     "投票場")
    ("투표제"
     "投票制")
    ("투표지"
     "投票紙")
    ("투표함"
     "投票函")
    ("투하"
     "投下")
    ("투항"
     "投降")
    ("투항적"
     "投降的")
    ("투호"
     "投壺")
    ("투혼"
     "鬪魂")
    ("특"
     ("慝" . "간악할 특, 간사할 특, 더러울 특")
     ("特" . "우뚝할 특, 숫소 특, 뛰어날 특, 다만 특, 세 살 먹은 짐승 특")
     ("忒" . "변할 특, 의심할 특, 어기어질 특")
     "螣")
    ("특강"
     "特講")
    ("특검제"
     "特檢制")
    ("특고"
     "特告")
    ("특공대"
     "特攻隊")
    ("특공대식"
     "特攻隊式")
    ("특권"
     "特權")
    ("특권적"
     "特權的")
    ("특권층"
     "特權層")
    ("특급"
     "特級")
    ("특기"
     "特技"
     "特記")
    ("특기생"
     "特技生")
    ("특기자"
     "特技者")
    ("특단"
     "特段")
    ("특대형"
     "特大型")
    ("특례"
     "特例")
    ("특무대장"
     "特務隊長")
    ("특별"
     "特別")
    ("특별반"
     "特別班")
    ("특별법"
     "特別法")
    ("특별법적"
     "特別法的")
    ("특별상"
     "特別賞")
    ("특별세"
     "特別稅")
    ("특별시"
     "特別市")
    ("특별시민"
     "特別市民")
    ("특별실"
     "特別室")
    ("특보"
     "特保"
     "特報")
    ("특사"
     "特使"
     "特赦")
    ("특산"
     "特産")
    ("특산물"
     "特産物")
    ("특산종"
     "特産種")
    ("특산품"
     "特産品")
    ("특상품"
     "特商品")
    ("특색"
     "特色")
    ("특선"
     "特選")
    ("특설"
     "特設")
    ("특성"
     "特性")
    ("특성화"
     "特性化")
    ("특수"
     "特殊"
     "特秀"
     "特需")
    ("특수대"
     "特殊隊")
    ("특수복"
     "特殊服")
    ("특수부"
     "特殊部")
    ("특수성"
     "特殊性")
    ("특수자"
     "特殊者")
    ("특수직"
     "特殊職")
    ("특수층"
     "特殊層")
    ("특실"
     "特室")
    ("특약"
     "特約")
    ("특연"
     "特緣")
    ("특용"
     "特用")
    ("특위"
     "特委")
    ("특유"
     "特有")
    ("특융"
     "特融")
    ("특이"
     "特異")
    ("특이성"
     "特異性")
    ("특장"
     "特長")
    ("특장차"
     "特裝車")
    ("특전"
     "特典"
     "特戰")
    ("특정"
     "特定")
    ("특정인"
     "特定人")
    ("특정일"
     "特定日")
    ("특조위"
     "特調委")
    ("특종"
     "特種")
    ("특진"
     "特進")
    ("특질"
     "特質")
    ("특집"
     "特輯")
    ("특집극"
     "特輯劇")
    ("특집호"
     "特輯號")
    ("특징"
     "特徵")
    ("특징적"
     "特徵的")
    ("특차"
     "特次")
    ("특채"
     "特採")
    ("특출"
     "特出")
    ("특파원"
     "特派員")
    ("특파원단"
     "特派員團")
    ("특품"
     "特品")
    ("특허"
     "特許")
    ("특허권"
     "特許權")
    ("특허권자"
     "特許權者")
    ("특허성"
     "特許性")
    ("특혜"
     "特惠")
    ("특혜성"
     "特惠性")
    ("특혜적"
     "特惠的")
    ("특화"
     "特化")
    ("특활"
     "特活")
    ("특효"
     "特效")
    ("특효약"
     "特效藥")
    ("특훈"
     "特訓")
    ("튼실"
     "­實")
    ("틈"
     "闖")
    ("틈입"
     "闖入")
    ("파"
     ("坡" . "언덕 파, 제방 파")
     ("婆" . "할머니 파, 너풀너풀 춤출 파")
     ("巴" . "꼬리 파, 뱀 파, 땅이름 파")
     ("把" . "잡을 파, 헤칠 파")
     ("播" . "심을 파, 펼칠 파, 버릴 파, 까불 파, 달아날 파")
     ("擺" . "열 파, 헤칠 파, 제거할 파, 손뼉칠 파")
     ("杷" . "비파나무 파, 써레 파, 칼자루 파, 악기이름 파")
     ("波" . "물결 파, 물 젖을 파, 눈 광채 파, 움직일 파, 달빛 파")
     ("派" . "물 갈래 파, 보낼 파, 나눌 파, 파벌 파")
     ("爬" . "긁을 파, 기어다닐 파")
     ("琶" . "비파 파")
     ("破" . "깨뜨릴 파, 다할 파, 갈라질 파")
     ("罷" . "파할 파, 내칠 파")
     ("芭" . "파초 파")
     ("跛" . "절뚝발이 파")
     "陂"
     ("頗" . "비뚤어질 파, 자못 파")
     ("叵" . "못할 파, 드디어 파, 술잔 파")
     ("妑" . "새앙머리 파, 갈래머리 파")
     ("岥" . "산 비알질 파")
     ("帕" . "머리 동이수건 파")
     ("怕" . "두려울 파")
     ("灞" . "물이름 파")
     ("爸" . "아비 파")
     ("玻" . "파려옥 파, 유리옥 파")
     ("皤" . "흴 파, 배 불룩할 파, 귀 밑에 희끗희끗할 파")
     ("笆" . "가시 대 파, 울타리 파")
     ("簸" . "까부를 파, 키 파")
     ("耙" . "쇠시랑 파")
     ("菠" . "시금치 파")
     ("葩" . "꽃봉오리 파")
     ("鄱" . "땅이름 파")
     "霸")
    ("파격"
     "破格")
    ("파격적"
     "破格的")
    ("파견"
     "派遣")
    ("파견관"
     "派遣官")
    ("파견대"
     "派遣隊")
    ("파견제"
     "派遣制")
    ("파계"
     "破戒")
    ("파고"
     "波高")
    ("파괴"
     "破壞")
    ("파괴당"
     "破壞當")
    ("파괴력"
     "破壞力")
    ("파괴적"
     "破壞的")
    ("파국"
     "破局")
    ("파국적"
     "破局的")
    ("파급"
     "波及")
    ("파기"
     "破棄")
    ("파농"
     "破農")
    ("파다"
     "播多")
    ("파도"
     "波濤")
    ("파동"
     "波動")
    ("파동론"
     "波動論")
    ("파동성"
     "波動性")
    ("파두"
     "巴豆")
    ("파락호"
     "破落戶")
    ("파란"
     "波瀾")
    ("파란곡절"
     "波瀾曲折")
    ("파란만장"
     "波瀾萬丈")
    ("파력"
     "波力")
    ("파렴치"
     "破廉恥")
    ("파렴치범"
     "破廉恥犯")
    ("파면"
     "罷免")
    ("파멸"
     "破滅")
    ("파문"
     "波紋")
    ("파벌"
     "派閥")
    ("파병"
     "派兵")
    ("파병용"
     "派兵用")
    ("파북"
     "派北")
    ("파산"
     "破産")
    ("파산기"
     "破散期")
    ("파상적"
     "波狀的")
    ("파생"
     "派生")
    ("파선"
     "破線")
    ("파손"
     "破損")
    ("파송"
     "派送")
    ("파수"
     "把守")
    ("파악"
     "把握")
    ("파업"
     "罷業")
    ("파열"
     "破裂")
    ("파열음"
     "破裂音")
    ("파월"
     "派越")
    ("파작"
     "破作")
    ("파장"
     "波長"
     "罷場")
    ("파쟁"
     "派爭")
    ("파적"
     "破寂")
    ("파종"
     "播種")
    ("파종기"
     "播種期")
    ("파죽지세"
     "破竹之勢")
    ("파지"
     "破紙")
    ("파지장"
     "波止場")
    ("파천"
     "播遷")
    ("파천황"
     "破天荒")
    ("파출부"
     "派出婦")
    ("파출소"
     "派出所")
    ("파출소장"
     "派出所長")
    ("파충류"
     "爬蟲類")
    ("파탄"
     "破綻")
    ("파탄자"
     "破綻者")
    ("파편"
     "破片")
    ("파편화"
     "破片化")
    ("파행"
     "跛行")
    ("파행성"
     "跛行性")
    ("파행적"
     "跛行的")
    ("판"
     ("判" . "판단할 판, 쪼갤 판, 맡을 판")
     ("坂" . "언덕 판, 산비탈 판, 순나라 서울이름 판")
     ("板" . "널조각 판, 널기와 판, 풍류이름 판")
     ("版" . "조각 판, 호적 판, 국경 판, 한 길 판, 인쇄할 판")
     ("瓣" . "외씨 판, 실과씨 판, 꽃잎 판")
     ("販" . "장사 판, 팔 판")
     ("辦" . "힘들일 판, 갖출 판")
     ("鈑" . "불린 금 판")
     ("阪" . "산비탈 판, 언덕 판"))
    ("판검사"
     "判檢事")
    ("판결"
     "判決")
    ("판결문"
     "判決文")
    ("판공비"
     "辦公費")
    ("판교"
     "判敎")
    ("판권"
     "版權")
    ("판단"
     "判斷")
    ("판단력"
     "判斷力")
    ("판도"
     "版圖")
    ("판독"
     "判讀")
    ("판독기"
     "判讀機")
    ("판례"
     "判例")
    ("판로"
     "販路")
    ("판막"
     "瓣膜")
    ("판막증"
     "瓣膜症")
    ("판매"
     "販賣")
    ("판매대"
     "販賣臺")
    ("판매량"
     "販賣量")
    ("판매력"
     "販賣力")
    ("판매망"
     "販賣網")
    ("판매사"
     "販賣社")
    ("판매소"
     "販賣所")
    ("판매액"
     "販賣額")
    ("판매원"
     "販賣員")
    ("판매율"
     "販賣率")
    ("판매전"
     "販賣戰")
    ("판매점"
     "販賣店")
    ("판매직"
     "販賣職")
    ("판명"
     "判明")
    ("판별"
     "判別")
    ("판별법"
     "判別法")
    ("판사"
     "判事")
    ("판상"
     "板狀")
    ("판서"
     "判書"
     "板書")
    ("판시"
     "判示")
    ("판윤"
     "判尹")
    ("판이"
     "判異")
    ("판자"
     "板子")
    ("판자촌"
     "板子村")
    ("판잣"
     "板子")
    ("판전"
     "版殿")
    ("판정"
     "判定")
    ("판정승"
     "判定勝")
    ("판정패"
     "判定敗")
    ("판지"
     "判旨"
     "板紙")
    ("판촉"
     "販促")
    ("판촉물"
     "販促物")
    ("판형"
     "判型")
    ("판화"
     "版畵")
    ("팔"
     ("八" . "여덟 팔")
     ("叭" . "나팔 팔, 입 벌릴 팔")
     ("捌" . "깨뜨릴 팔, 나눌 팔, 칠 팔")
     "扒"
     "朳"
     "汃")
    ("팔각"
     "八角")
    ("팔각정"
     "八角亭")
    ("팔각형"
     "八角形")
    ("팔경"
     "八景")
    ("팔고"
     "八苦")
    ("팔관회"
     "八關會")
    ("팔도"
     "八道")
    ("팔도강산"
     "八道江山")
    ("팔만"
     "八萬")
    ("팔만사천"
     "八萬四千")
    ("팔방"
     "八方")
    ("팔방미인"
     "八方美人")
    ("팔백"
     "八白")
    ("팔순"
     "八旬")
    ("팔십"
     "八十")
    ("팔십오"
     "八十五")
    ("팔십칠"
     "八十七")
    ("팔십팔"
     "八十八")
    ("팔열"
     "八熱")
    ("팔월"
     "八月")
    ("팔월대"
     "八月大")
    ("팔위"
     "八衛")
    ("팔일오"
     "八一五")
    ("팔자"
     "八字")
    ("팔작"
     "八作")
    ("팔정도"
     "八正道")
    ("팔조법금"
     "八條法禁")
    ("팔천"
     "八賤")
    ("팔천오백"
     "八千五百")
    ("팔풍"
     "八風")
    ("패"
     ("佩" . "패옥 패, 찰 패, 마음에 먹을 패, 물이 흘러서 합할 패")
     ("唄" . "염불소리 패, 노래부를 패")
     ("悖" . "거스를 패, 어지러울 패")
     ("敗" . "헐어질 패, 무너질 패, 깨어질 패, 썪을 패")
     ("沛" . "둥둥 뜰 패, 비 쏟아질 패, 넉넉할 패")
     ("浿" . "물이름 패, 물가 패")
     ("牌" . "방 붙일 패, 호패 패, 방패 패")
     ("狽" . "이리 패")
     ("稗" . "돌피 패, 조그마할 패")
     ("覇" . "霸의 俗字")
     ("貝" . "조개 패, 재물 패, 비단 패")
     ("孛" . "혜성 패")
     ("旆" . "기 패, 깃발 날릴 패")
     ("珮" . "노리개 패, 찰 패")
     ("霈" . "비 쏟아질 패")
     ("霸" . "으뜸 패, 패왕 패"))
    ("패가"
     "敗家")
    ("패가망신"
     "敗家亡身")
    ("패권"
     "覇權")
    ("패권주의"
     "覇權主義")
    ("패권주의자"
     "覇權主義者")
    ("패권주의적"
     "覇權主義的")
    ("패기"
     "覇氣")
    ("패도"
     "覇道")
    ("패두"
     "牌頭")
    ("패류"
     "貝類")
    ("패륜"
     "悖倫")
    ("패륜아"
     "悖倫兒")
    ("패륜적"
     "悖倫的")
    ("패망"
     "敗亡")
    ("패물"
     "佩物")
    ("패배"
     "敗北")
    ("패배감"
     "敗北感")
    ("패배당"
     "敗北當")
    ("패배자"
     "敗北者")
    ("패배주의"
     "敗北主義")
    ("패산"
     "敗散")
    ("패색"
     "敗色")
    ("패소"
     "敗訴")
    ("패인"
     "敗因")
    ("패자"
     "敗者")
    ("패자전"
     "敗者戰")
    ("패전"
     "敗戰")
    ("패전국"
     "敗戰國")
    ("패혈"
     "敗血")
    ("패혈증"
     "敗血症")
    ("팽"
     "庄"
     ("彭" . "성씨 팽, 땅이름 팽, 방패 팽, 총소리 팽, 북소리 팽")
     ("澎" . "물소리 팽, 물결 부딛는 형세 팽")
     ("烹" . "삶을 팽, 요리 팽")
     "硼"
     ("膨" . "배 불룩할 팽")
     ("砰" . "여울 물소리 팽")
     ("祊" . "사당문 제사 팽")
     ("蟚" . "蟛과 同字")
     ("蟛" . "방게 팽"))
    ("팽배"
     "澎湃")
    ("팽창"
     "膨脹")
    ("팽창감"
     "膨脹感")
    ("팽창주의"
     "膨脹主義")
    ("팽팽"
     "膨膨")
    ("퍅"
     ("愎" . "사나울 퍅, 고집할 퍅"))
    ("편"
     ("便" . "편할 편, 소식 편, 익힐 편, 오줌 편")
     ("偏" . "치우칠 편, 무리 편, 오십명 편, 간사한 모양 편")
     ("扁" . "특별할 편, 거룻배 편")
     ("片" . "조각 편, 쪼갤 편, 성씨 편")
     ("篇" . "책 편, 편차할 편")
     ("編" . "책편 편, 기록할 편, 첩지 편, 벌릴 편")
     ("翩" . "훌쩍 날 편, 오락가락할 편")
     ("遍" . "두루 편")
     ("鞭" . "채찍 편, 볼기채 편, 태장 편")
     ("騙" . "속일 편, 말에 뛰어 오를 편")
     ("惼" . "조급할 편, 편협할 편")
     ("緶" . "꿰맬 편")
     ("艑" . "거룻배 편")
     ("蝙" . "박쥐 편")
     ("褊" . "좁을 편, 급할 편, 옷이 몸에 낄 편")
     ("諞" . "공교한 말 편"))
    ("편견"
     "偏見")
    ("편곡"
     "編曲")
    ("편년"
     "編年")
    ("편년체"
     "編年體")
    ("편대"
     "編隊")
    ("편도"
     "片道")
    ("편도선"
     "扁桃腺")
    ("편두통"
     "偏頭痛")
    ("편람"
     "便覽")
    ("편력"
     "遍歷")
    ("편리"
     "便利")
    ("편리성"
     "便利性")
    ("편린"
     "片鱗")
    ("편마암"
     "片麻巖")
    ("편목"
     "篇目")
    ("편발"
     "編髮")
    ("편법"
     "便法")
    ("편법적"
     "便法的")
    ("편벽"
     "偏僻")
    ("편복"
     "便服")
    ("편성"
     "編成")
    ("편성론"
     "編成論")
    ("편성안"
     "編成案")
    ("편수"
     "編修")
    ("편수관"
     "編修官")
    ("편수관실"
     "編修官室")
    ("편수국"
     "編修局")
    ("편수직"
     "編修職")
    ("편수직원"
     "編修職員")
    ("편승"
     "便乘")
    ("편식"
     "偏食")
    ("편쌈"
     "便­")
    ("편안"
     "便安")
    ("편암"
     "片巖")
    ("편애"
     "偏愛")
    ("편액"
     "扁額")
    ("편역서"
     "編譯書")
    ("편육"
     "片肉")
    ("편의"
     "便宜")
    ("편의성"
     "便宜性")
    ("편의율"
     "便宜率")
    ("편의적"
     "便宜的")
    ("편의점"
     "便宜店")
    ("편의주의"
     "便宜主義")
    ("편의주의적"
     "便宜主義的")
    ("편의치적선"
     "便宜置籍船")
    ("편의품"
     "便宜品")
    ("편익"
     "便益")
    ("편입"
     "編入")
    ("편입학"
     "編入學")
    ("편재"
     "偏在")
    ("편재성"
     "偏在性")
    ("편저"
     "編著")
    ("편저자"
     "編著者")
    ("편적"
     "偏積")
    ("편제"
     "編制")
    ("편중"
     "偏重")
    ("편지"
     "便紙")
    ("편지지"
     "便紙紙")
    ("편집"
     "編輯")
    ("편집국"
     "編輯局")
    ("편집국장"
     "編輯局長")
    ("편집물"
     "編輯物")
    ("편집부"
     "編輯部")
    ("편집부장"
     "編輯部長")
    ("편집부장직"
     "編輯部長職")
    ("편집인"
     "編輯人")
    ("편집자"
     "編輯者")
    ("편집장"
     "編輯長")
    ("편집진"
     "編輯陣")
    ("편차"
     "偏差")
    ("편찬"
     "編纂")
    ("편찬자"
     "編纂者")
    ("편파"
     "偏頗")
    ("편파적"
     "偏頗的")
    ("편편"
     "便便"
     "片片")
    ("편평"
     "扁平")
    ("편향"
     "偏向")
    ("편향성"
     "偏向性")
    ("편향적"
     "偏向的")
    ("편향주의자"
     "偏向主義者")
    ("편협"
     "偏狹")
    ("편협성"
     "偏狹性")
    ("폄"
     ("貶" . "떨어질 폄, 덜릴 폄, 꺾을 폄, 귀양보낼 폄")
     ("砭" . "돌침 폄")
     ("窆" . "하관할 폄, 광중 폄"))
    ("평"
     ("坪" . "벌판 평, 평평할 평")
     ("平" . "평탄할 평, 바를 평, 고를 평, 다스릴 평, 쉬울 평, 풍년 평, 화친할 평, 재관관 평")
     ("枰" . "장기판 평, 바둑판 평, 회양목 평")
     ("萍" . "마름 평, 머구리밥 평, 개구리밥 평")
     ("評" . "평론할 평, 헤아릴 평, 고칠 평, 기롱할 평")
     ("怦" . "맘 급할 평, 칼칼할 평")
     ("抨" . "탄핵할 평")
     ("泙" . "물소리 평, 물결 셀 평")
     ("苹" . "맑은 대쑥 평, 사과 평")
     ("蓱" . "마름 평, 머구리밥 평, 개구리밥 평")
     ("鮃" . "가자미 평"))
    ("평가"
     "平價"
     "評價")
    ("평가관"
     "平價官")
    ("평가단"
     "平價團")
    ("평가법"
     "平價法")
    ("평가부장"
     "平價部長")
    ("평가사"
     "平價師")
    ("평가손"
     "評價損")
    ("평가액"
     "平價額")
    ("평가용"
     "平價用")
    ("평가전"
     "評價戰")
    ("평가제"
     "平價制")
    ("평가회"
     "平價會")
    ("평결"
     "評決")
    ("평경례"
     "平敬禮")
    ("평교사"
     "平敎師")
    ("평교사회"
     "平敎師會")
    ("평균"
     "平均")
    ("평균대"
     "平均臺")
    ("평균작"
     "平均作")
    ("평균적"
     "平均的")
    ("평균치"
     "平均値")
    ("평년"
     "平年")
    ("평년작"
     "平年作")
    ("평단"
     "評壇")
    ("평당원"
     "平黨員")
    ("평대문"
     "平大門")
    ("평등"
     "平等")
    ("평등관"
     "平等觀")
    ("평등권"
     "平等權")
    ("평등사상"
     "平等思想")
    ("평등주의"
     "平等主義")
    ("평등주의적"
     "平等主義的")
    ("평등화"
     "平等化")
    ("평론"
     "評論")
    ("평론가"
     "評論家")
    ("평론집"
     "評論集")
    ("평면"
     "平面")
    ("평면적"
     "平面的")
    ("평문"
     "平文"
     "評文")
    ("평민"
     "平民")
    ("평배"
     "平拜")
    ("평범"
     "平凡")
    ("평사원"
     "平社員")
    ("평상"
     "平常"
     "平牀")
    ("평상복"
     "平常服")
    ("평상시"
     "平常時")
    ("평상심"
     "平常心")
    ("평상적"
     "平常的")
    ("평생"
     "平生")
    ("평생직장"
     "平生職場")
    ("평석"
     "評釋")
    ("평소"
     "平素")
    ("평수"
     "坪數")
    ("평시"
     "平時")
    ("평신도"
     "平信徒")
    ("평안"
     "平安")
    ("평안감"
     "平安感")
    ("평야"
     "平野")
    ("평양"
     "平壤")
    ("평영"
     "平泳")
    ("평온"
     "平穩")
    ("평원"
     "平原")
    ("평의회"
     "評議會")
    ("평이"
     "平易")
    ("평일"
     "平日")
    ("평자"
     "評者")
    ("평작"
     "平作")
    ("평잔"
     "平殘")
    ("평저"
     "平底")
    ("평점"
     "評點")
    ("평정"
     "平定"
     "平靜"
     "評定")
    ("평조직"
     "平組織")
    ("평조합원"
     "平組合員")
    ("평준화"
     "平準化")
    ("평지"
     "平地")
    ("평지능문능"
     "平地綾文綾")
    ("평직"
     "平織")
    ("평직금"
     "平織錦")
    ("평직원"
     "平職員")
    ("평탄"
     "平坦")
    ("평토장"
     "平土葬")
    ("평판"
     "評判")
    ("평판상"
     "平板床")
    ("평평"
     "平平")
    ("평행"
     "平行")
    ("평행봉"
     "平行棒")
    ("평행선"
     "平行線")
    ("평형"
     "坪形"
     "平衡")
    ("평형성"
     "平衡性")
    ("평화"
     "平和")
    ("평화상"
     "平和賞")
    ("평화적"
     "平和的")
    ("평화주의자"
     "平和主義者")
    ("평화학"
     "平和學")
    ("평화협정"
     "平和協定")
    ("평화형"
     "平和型")
    ("폐"
     ("吠" . "짖을 폐, 땅이름 폐")
     ("嬖" . "사랑할 폐, 윗사람으로부터 사랑받을 폐, 벼슬이름 폐")
     ("幣" . "폐백 폐, 예물 폐, 재물 폐, 돈 폐")
     ("廢" . "폐할 폐, 내칠 폐, 집 쏠릴 폐, 떨어질 폐")
     ("弊" . "해질 폐, 폐단 폐, 곤할 폐, 곰곰 궁리할 폐, 결단할 폐, 엎드릴 폐")
     ("斃" . "죽을 폐, 엎드러질 폐")
     ("肺" . "허파 폐, 부아 폐, 친할 폐, 마음속 폐")
     ("蔽" . "가리울 폐, 다할 폐, 정할 폐")
     ("閉" . "닫을 폐, 마칠 폐, 가릴 폐")
     ("陛" . "대궐 섬돌 폐")
     ("敝" . "옷 해질 폐, 버릴 폐, 무너질 폐, 실패할 폐, 활줌통 폐")
     ("狴" . "짐승이름 폐, 옥 폐, 들개 폐")
     ("獘" . "곤할 폐, 폐단 폐, 죽을 폐, 엎드러질 폐")
     ("癈" . "고질병 폐"))
    ("폐가구"
     "廢家具")
    ("폐가전제품"
     "廢家電製品")
    ("폐간"
     "廢刊")
    ("폐건전지"
     "廢乾電池")
    ("폐경"
     "肺經")
    ("폐경기"
     "閉經期")
    ("폐광"
     "廢鑛")
    ("폐광산"
     "廢鑛山")
    ("폐교"
     "廢校")
    ("폐기"
     "廢棄")
    ("폐기물"
     "廢棄物")
    ("폐냉장고"
     "廢冷藏庫")
    ("폐단"
     "弊端")
    ("폐동맥"
     "肺動脈")
    ("폐렴"
     "肺炎")
    ("폐마"
     "廢馬")
    ("폐막"
     "閉幕")
    ("폐막식"
     "閉幕式")
    ("폐막제"
     "閉幕制")
    ("폐문"
     "閉門")
    ("폐물"
     "廢物")
    ("폐백"
     "幣帛")
    ("폐병"
     "肺病")
    ("폐부"
     "肺腑")
    ("폐부품"
     "廢部品")
    ("폐비"
     "廢妃")
    ("폐사"
     "斃死")
    ("폐산"
     "廢酸")
    ("폐색"
     "閉塞")
    ("폐생활용품"
     "廢生活用品")
    ("폐선"
     "廢船")
    ("폐설물"
     "廢屑物")
    ("폐쇄"
     "閉鎖")
    ("폐쇄성"
     "閉鎖性")
    ("폐쇄적"
     "閉鎖的")
    ("폐쇄화"
     "閉鎖化")
    ("폐수"
     "廢水")
    ("폐식용유"
     "廢食用油")
    ("폐신문지"
     "廢新聞紙")
    ("폐암"
     "肺癌")
    ("폐업"
     "廢業")
    ("폐왕"
     "廢王")
    ("폐위"
     "廢位")
    ("폐유"
     "廢油")
    ("폐인"
     "廢人")
    ("폐일언"
     "蔽一言")
    ("폐자재"
     "廢資材")
    ("폐자전거"
     "廢自轉車")
    ("폐장"
     "閉場")
    ("폐장롱"
     "廢欌籠")
    ("폐점"
     "閉店")
    ("폐지"
     "廢止"
     "廢紙")
    ("폐차"
     "廢車")
    ("폐차업체"
     "廢車業體")
    ("폐차장"
     "廢車場")
    ("폐촉매"
     "廢觸媒")
    ("폐품"
     "廢品")
    ("폐하"
     "陛下")
    ("폐해"
     "弊害")
    ("폐허"
     "廢墟")
    ("폐혈관"
     "肺血管")
    ("폐활량"
     "肺活量")
    ("폐휴지"
     "廢休紙")
    ("포"
     ("佈" . "펼칠 포")
     ("包" . "꾸릴 포, 용납할 포, 더부룩히 날 포, 보따리 포")
     ("匍" . "엉금엉금 길 포, 엎드러질 포")
     ("匏" . "박 포, 바가지 포, 퉁소 포")
     ("咆" . "고함지를 포, 짐승소리 포, 불끈 성낼 포")
     ("哺" . "씹어 먹을 포, 먹일 포")
     ("圃" . "채마밭 포, 밭 갈 포, 곳 포, 산이름 포")
     ("布" . "베 포, 피륙 포, 벌릴 포, 돈 포, 베풀 포")
     ("怖" . "두려울 포, 놀래킬 포")
     ("抛" . "拋와 同字")
     ("抱" . "안을 포, 품을 포, 낄 포")
     ("捕" . "사로잡을 포")
     ("曝" . "볕 쬘 포, 볕 쏘일 포")
     ("泡" . "물거품 포, 물이 솟아날 포, 물 흐를 포, 성할 포")
     ("浦" . "물가 포, 갯가 포")
     ("疱" . "부풀 포, 부르틀 포")
     ("砲" . "큰 대포 포, 돌쇠뇌 포, 돌 튀기는 화살 포")
     ("胞" . "태보 포, 한 배 포, 동포 포")
     ("脯" . "포 포")
     ("苞" . "그령풀 포, 밑둥 포, 초목이 다복히 날 포, 꾸러피 포")
     ("葡" . "포도 포, 들머리 포, 나라이름 포")
     ("蒲" . "부들풀 포, 창포 포, 개버들 포")
     ("袍" . "도포 포, 관디 포, 앞섶 포")
     ("褒" . "포장할 포, 옷 뒤길 포, 도포 포, 고을이름 포")
     ("逋" . "달아날 포, 포흠할 포")
     ("鋪" . "전방 포, 베풀 포, 문고리 포, 펼 포, 아플 포")
     ("飽" . "배부를 포, 물릴 포, 먹기 싫을 포, 흡족할 포")
     ("鮑" . "절인 생선 포, 성씨 포")
     ("暴" . "사나울 포, 급할 포, 맨손으로 칠 포, 불끈 일어날 포, 마를 포, 상할 포")
     "儤"
     ("庖" . "푸줏간 포, 부엌 포")
     ("晡" . "신시 포, 해질 포")
     ("曓" . "급할 포, 창졸 포")
     ("炮" . "그슬릴 포, 싸서 구울 포, 형벌 포")
     ("炰" . "그슬 포, 까불거릴 포")
     ("舖" . "鋪의 俗字")
     ("誧" . "꾀할 포, 클 포, 도울 포, 간할 포")
     ("鉋" . "대패 포")
     ("鞄" . "가방 포, 가죽 다로는 장인 포")
     ("餔" . "저녁 곁두리 포, 먹을 포")
     ("鯆" . "매가리 포, 물아지 포"))
    ("포격"
     "砲擊")
    ("포경"
     "捕鯨")
    ("포고"
     "布告")
    ("포고령"
     "布告令")
    ("포고문"
     "布告文")
    ("포괄"
     "包括")
    ("포괄미"
     "包括美")
    ("포괄성"
     "包括性")
    ("포괄자"
     "包括者")
    ("포괄적"
     "包括的")
    ("포괄주의"
     "包括主義")
    ("포교"
     "布敎"
     "捕校")
    ("포교용"
     "布敎用")
    ("포교장"
     "布敎場")
    ("포구"
     "浦口")
    ("포기"
     "抛棄")
    ("포대"
     "包袋"
     "砲臺"
     "砲隊")
    ("포대장"
     "砲隊長")
    ("포도"
     "葡萄")
    ("포도당"
     "葡萄糖")
    ("포도원"
     "葡萄園")
    ("포도주"
     "葡萄酒")
    ("포란"
     "抱卵")
    ("포로"
     "捕虜")
    ("포로수용소"
     "捕虜收容所")
    ("포만"
     "飽滿")
    ("포만감"
     "飽滿感")
    ("포말"
     "泡沫")
    ("포목전"
     "布木廛")
    ("포문"
     "砲門")
    ("포물선"
     "抛物線")
    ("포박"
     "捕縛")
    ("포박당"
     "捕縛當")
    ("포병"
     "砲兵")
    ("포복"
     "匍匐")
    ("포복절도"
     "抱腹絶倒")
    ("포부"
     "抱負")
    ("포상"
     "褒賞")
    ("포상금"
     "褒賞金")
    ("포석"
     "布石")
    ("포섭"
     "包攝")
    ("포섭주의"
     "包攝主義")
    ("포성"
     "砲聲")
    ("포수"
     "捕手"
     "砲手")
    ("포승"
     "捕繩")
    ("포식"
     "捕食"
     "飽食")
    ("포악"
     "暴惡")
    ("포연"
     "砲煙")
    ("포옹"
     "抱擁")
    ("포용"
     "包容")
    ("포용력"
     "包容力")
    ("포용성"
     "包容性")
    ("포용적"
     "包容的")
    ("포위"
     "包圍")
    ("포위당"
     "包圍當")
    ("포위망"
     "包圍網")
    ("포유동물"
     "哺乳動物")
    ("포유류"
     "哺乳類")
    ("포육"
     "哺育")
    ("포의"
     "布衣"
     "袍衣")
    ("포장"
     "包裝"
     "布帳"
     "鋪裝")
    ("포장도로"
     "鋪裝道路")
    ("포장마차"
     "布帳馬車")
    ("포장술"
     "包裝術")
    ("포장지"
     "包裝紙")
    ("포접"
     "抱接")
    ("포졸"
     "捕卒")
    ("포주"
     "抱主")
    ("포진"
     "布陣"
     "疱疹")
    ("포착"
     "捕捉")
    ("포착률"
     "捕捉率")
    ("포청"
     "捕廳")
    ("포탄"
     "砲彈")
    ("포탈"
     "逋脫")
    ("포태"
     "胞胎")
    ("포폭"
     "布幅")
    ("포함"
     "包含")
    ("포화"
     "砲火"
     "飽和")
    ("포환"
     "砲丸")
    ("포효"
     "咆哮")
    ("폭"
     ("幅" . "폭 폭, 겉치레할 폭")
     ("暴" . "햇빛 쪼일 폭, 나타날 폭, 드러날 폭")
     ("曝" . "햇볕에 말릴 폭")
     ("瀑" . "폭포수 폭")
     ("爆" . "불터질 폭")
     ("輻" . "바퀴살통 폭")
     "曓")
    ("폭거"
     "暴擧")
    ("폭격"
     "爆擊")
    ("폭격기"
     "爆擊機")
    ("폭격당"
     "爆擊當")
    ("폭군"
     "暴君")
    ("폭도"
     "暴徒")
    ("폭동"
     "暴動")
    ("폭등"
     "暴騰")
    ("폭등세"
     "暴騰勢")
    ("폭락"
     "暴落")
    ("폭력"
     "暴力")
    ("폭력단"
     "暴力團")
    ("폭력배"
     "暴力輩")
    ("폭력성"
     "暴力性")
    ("폭력적"
     "暴力的")
    ("폭력화"
     "暴力化")
    ("폭로"
     "暴露")
    ("폭로전"
     "暴露戰")
    ("폭리"
     "暴利")
    ("폭발"
     "暴發"
     "爆發")
    ("폭발력"
     "爆發力")
    ("폭발물"
     "爆發物")
    ("폭발성"
     "爆發性")
    ("폭발적"
     "暴發的")
    ("폭서"
     "暴暑")
    ("폭설"
     "暴雪")
    ("폭소"
     "爆笑")
    ("폭압"
     "暴壓")
    ("폭압적"
     "暴壓的")
    ("폭약"
     "爆藥")
    ("폭양"
     "曝陽")
    ("폭언"
     "暴言")
    ("폭염"
     "暴炎")
    ("폭우"
     "暴雨")
    ("폭음"
     "暴飮"
     "爆音")
    ("폭정"
     "暴政")
    ("폭주"
     "暴注")
    ("폭죽"
     "爆竹")
    ("폭증"
     "爆增")
    ("폭탄"
     "爆彈")
    ("폭탄선언"
     "爆彈宣言")
    ("폭탄주"
     "爆彈酒")
    ("폭파"
     "爆破")
    ("폭파당"
     "爆破當")
    ("폭포"
     "瀑布")
    ("폭포수"
     "瀑布水")
    ("폭폭"
     "幅幅")
    ("폭풍"
     "暴風")
    ("폭풍우"
     "暴風雨")
    ("폭행"
     "暴行")
    ("폭행당"
     "暴行當")
    ("표"
     ("俵" . "나누어 줄 표, 흩어질 표, 가마니 표")
     ("剽" . "표독할 표, 긁을 표, 겁박할 표, 끝 표, 찌를 표, 빠를 표")
     ("彪" . "칡범 표, 문채 표, 작은 범 표")
     ("慓" . "급할 표")
     ("杓" . "북두자루 표")
     ("標" . "표시할 표, 높은 가지 표, 적을 표, 나무 끝 표")
     ("漂" . "뜰 표, 움직일 표, 으스스할 표, 높이 훨훨 날 표")
     ("瓢" . "표주박 표")
     ("票" . "쪽지 표, 문서 표, 불날릴 표, 훌쩍 날 표, 날랠 표")
     ("表" . "겉 표, 윗옷 표, 밝을 표")
     ("豹" . "표범 표, 아롱범 표")
     ("飄" . "회오리바람 표, 나부낄 표, 떨어질 표")
     ("飇" . "회오리바람 표")
     ("驃" . "날쌜 표, 누런 말 표")
     ("僄" . "몸이 가벼울 표, 진중치 못할 표")
     ("勡" . "겁탈할 표, 겁박할 표")
     ("嘌" . "휙 불 표, 몰아갈 표")
     ("嫖" . "가벼울 표, 날랠 표, 색에 빠질 표")
     ("摽" . "칠 표, 두를 표, 찔러 밀칠 표, 가슴 만질 표")
     ("殍" . "굶어 죽을 표")
     ("熛" . "불똥 튈 표, 성낼 표, 붉을 표, 빛날 표")
     ("縹" . "옥빛 표, 훌쩍 날 표")
     ("裱" . "목수건 표")
     ("鏢" . "칼날 표, 비수 표")
     ("鑣" . "말 재갈 표, 성할 표")
     ("髟" . "머리털 희뜩희뜩할 표, 깃발 날릴 표, 머리 늘일 표")
     ("鰾" . "부레 표"))
    ("표결"
     "票決")
    ("표고"
     "標高")
    ("표구"
     "表具")
    ("표기"
     "表記")
    ("표기법"
     "表記法")
    ("표랑"
     "漂浪")
    ("표류"
     "漂流")
    ("표류당"
     "漂流當")
    ("표류자"
     "漂流者")
    ("표리"
     "表裏")
    ("표면"
     "表面")
    ("표면적"
     "表面的"
     "表面積")
    ("표면화"
     "表面化")
    ("표명"
     "表明")
    ("표방"
     "標榜")
    ("표백"
     "漂白")
    ("표백미"
     "表白美")
    ("표변"
     "豹變")
    ("표본"
     "標本")
    ("표본적"
     "標本的")
    ("표상"
     "表裳"
     "表象")
    ("표상화"
     "表象化")
    ("표석"
     "標石")
    ("표수"
     "票數")
    ("표수현위"
     "漂水縣尉")
    ("표시"
     "標示"
     "表示")
    ("표시권"
     "表示權")
    ("표시등"
     "標示燈")
    ("표시량"
     "表示量")
    ("표시설"
     "表示說")
    ("표시판"
     "標示板")
    ("표식"
     "標式")
    ("표어"
     "標語")
    ("표음"
     "表音")
    ("표의"
     "表意"
     "表衣")
    ("표적"
     "標的")
    ("표적물"
     "標的物")
    ("표전"
     "漂典")
    ("표절"
     "剽竊")
    ("표정"
     "表定"
     "表情")
    ("표제"
     "標題")
    ("표제어"
     "標題語")
    ("표제작"
     "表題作")
    ("표준"
     "標準")
    ("표준궤"
     "標準軌")
    ("표준안"
     "標準案")
    ("표준액"
     "標準額")
    ("표준어"
     "標準語")
    ("표준화"
     "標準化")
    ("표지"
     "標識"
     "表紙")
    ("표지색"
     "標識色")
    ("표지판"
     "標識板")
    ("표징"
     "表徵")
    ("표창"
     "表彰")
    ("표창록"
     "表彰錄")
    ("표창장"
     "表彰狀")
    ("표출"
     "表出")
    ("표토"
     "表土")
    ("표토층"
     "漂土層")
    ("표피"
     "表皮")
    ("표피적"
     "表皮的")
    ("표행"
     "漂行")
    ("표현"
     "表現")
    ("표현력"
     "表現力")
    ("표현물"
     "表現物")
    ("표현미"
     "表現美")
    ("표현법"
     "表現法")
    ("표현성"
     "表現性")
    ("표현적"
     "表現的")
    ("표현주의"
     "表現主義")
    ("표현주의적"
     "表現主義的")
    ("표현체"
     "表現體")
    ("표현화"
     "表現化")
    ("푸대접"
     "­待接")
    ("풀칠"
     "­漆")
    ("품"
     ("品" . "뭇 품, 품수 품, 가지 품, 벼슬 차례 품")
     ("稟" . "여쭐 품, 줄 품, 받을 품, 성품 품")
     ("禀" . "여쭐 품, 사뢸 품, 받을 품, 성품 품"))
    ("품격"
     "品格")
    ("품계석"
     "品階石")
    ("품관"
     "品官")
    ("품귀"
     "品貴")
    ("품목"
     "品目")
    ("품사"
     "品詞")
    ("품성"
     "品性"
     "稟性")
    ("품성적"
     "品性的")
    ("품위"
     "品位")
    ("품제"
     "品制")
    ("품종"
     "品種")
    ("품질"
     "品質")
    ("품평"
     "品評")
    ("품평회"
     "品評會")
    ("품행"
     "品行")
    ("풍"
     ("楓" . "단풍나무 풍, 신나무 풍")
     ("諷" . "비유로 간할 풍, 외울 풍")
     ("豊" . "豐의 略字")
     ("風" . "바람 풍, 흘레할 풍, 울릴 풍, 풍속 풍, 경치 풍, 위엄 풍, 병풍 풍, 모양 풍")
     ("馮" . "벼슬이름 풍, 성씨 풍, 물귀신이름 풍, 고을이름 풍")
     "丰"
     ("瘋" . "두풍 풍, 미치광이 풍"))
    ("풍각"
     "風角")
    ("풍경"
     "風景"
     "風磬")
    ("풍경화"
     "風景畵")
    ("풍관"
     "風觀")
    ("풍광"
     "風光")
    ("풍금"
     "風琴")
    ("풍년"
     "豊年")
    ("풍년가"
     "豊年歌")
    ("풍랑"
     "風浪")
    ("풍려"
     "豊麗")
    ("풍력"
     "風力")
    ("풍류"
     "風流")
    ("풍류도"
     "風流徒")
    ("풍만"
     "豊滿")
    ("풍모"
     "風貌")
    ("풍문"
     "風聞")
    ("풍물"
     "風物")
    ("풍미"
     "風味"
     "風靡")
    ("풍백"
     "風伯")
    ("풍부"
     "豊富")
    ("풍부화"
     "豊富化")
    ("풍비박산"
     "風飛雹散")
    ("풍사"
     "風沙")
    ("풍상"
     "風霜")
    ("풍선"
     "風扇"
     "風船")
    ("풍설"
     "風說")
    ("풍성"
     "豊盛")
    ("풍성감"
     "豊盛感")
    ("풍성풍성"
     "豊盛豊盛")
    ("풍속"
     "風俗"
     "風速")
    ("풍속도"
     "風俗圖")
    ("풍속화"
     "風俗畵")
    ("풍수"
     "風水")
    ("풍수가"
     "風水家")
    ("풍수론"
     "風水論")
    ("풍수사"
     "風水師")
    ("풍수설"
     "風水說")
    ("풍수성"
     "風水性")
    ("풍수적"
     "風水的")
    ("풍수지리"
     "風水地理")
    ("풍수지리관"
     "風水地理觀")
    ("풍수지리론"
     "風水地理論")
    ("풍수지리적"
     "風水地理的")
    ("풍수지리학"
     "風水地理學")
    ("풍수해"
     "風水害")
    ("풍습"
     "風習")
    ("풍습성"
     "風習性")
    ("풍악"
     "風樂")
    ("풍요"
     "豊饒")
    ("풍요성"
     "豊饒性")
    ("풍우"
     "風雨")
    ("풍운"
     "風雲")
    ("풍운아"
     "風雲兒")
    ("풍월"
     "風月")
    ("풍자"
     "諷刺")
    ("풍자극"
     "諷刺劇")
    ("풍자성"
     "諷刺性")
    ("풍자시"
     "諷刺詩")
    ("풍자적"
     "諷刺的")
    ("풍자집"
     "諷刺集")
    ("풍작"
     "豊作")
    ("풍장"
     "風葬")
    ("풍정"
     "風情")
    ("풍조"
     "風潮")
    ("풍족"
     "豊足")
    ("풍차"
     "風車")
    ("풍채"
     "風采")
    ("풍취"
     "風趣")
    ("풍치"
     "風致")
    ("풍토"
     "風土")
    ("풍토성"
     "風土性")
    ("풍토적"
     "風土的")
    ("풍파"
     "風波")
    ("풍편"
     "風便")
    ("풍향"
     "風向")
    ("풍화"
     "風化")
    ("피"
     ("彼" . "저 피")
     ("披" . "헤칠 피, 흩어질 피, 찢어질 피")
     ("疲" . "피곤할 피, 나른할 피")
     ("皮" . "가죽 피, 껍질 피, 성씨 피")
     ("被" . "이불 피, 덥힐 피, 미칠 피, 나타날 피, 창피할 피")
     ("跛" . "기울어 지게 설 피")
     ("避" . "숨을 피, 어길 피, 싫어할 피")
     ("陂" . "기울어질 피, 치우칠 피")
     "屁"
     ("詖" . "말 잘할 피, 간사할 피, 알소할 피")
     ("鞁" . "말 가슴걸이 피, 안갑 피")
     ("髲" . "머리쓰개 피, 첩지 피"))
    ("피격"
     "被擊")
    ("피고"
     "被告")
    ("피고발인"
     "被告發人")
    ("피고소인"
     "被告訴人")
    ("피고인"
     "被告人")
    ("피고인석"
     "被告人席")
    ("피곤"
     "疲困")
    ("피골"
     "皮骨")
    ("피교육자"
     "被敎育者")
    ("피구금자"
     "被拘禁者")
    ("피구속성"
     "被拘束性")
    ("피구속자"
     "被拘束者")
    ("피난"
     "避難")
    ("피난민"
     "避難民")
    ("피난지"
     "避難地")
    ("피난처"
     "避難處")
    ("피동적"
     "被動的")
    ("피란"
     "避亂")
    ("피력"
     "披瀝")
    ("피로"
     "疲勞")
    ("피로감"
     "疲勞感")
    ("피로도"
     "疲勞度")
    ("피로연"
     "披露宴")
    ("피뢰침"
     "避雷針")
    ("피발행인"
     "被發行人")
    ("피보호"
     "被保護")
    ("피복"
     "被服"
     "被覆")
    ("피부"
     "皮膚"
     "皮部")
    ("피부과"
     "皮膚科")
    ("피부병"
     "皮膚病")
    ("피부색"
     "皮膚色")
    ("피부암"
     "皮膚癌")
    ("피부염"
     "皮膚炎")
    ("피사체"
     "被寫體")
    ("피살"
     "被殺")
    ("피살당"
     "被殺當")
    ("피상성"
     "皮相性")
    ("피상적"
     "皮相的")
    ("피서"
     "避暑")
    ("피서객"
     "避暑客")
    ("피서법"
     "避暑法")
    ("피서지"
     "避暑地")
    ("피선"
     "被選")
    ("피선거권"
     "被選擧權")
    ("피습"
     "被襲")
    ("피신"
     "避身")
    ("피신처"
     "避身處")
    ("피신청인"
     "被申請人")
    ("피안"
     "彼岸")
    ("피안적"
     "彼岸的")
    ("피압박"
     "被壓迫")
    ("피용인"
     "被用人")
    ("피의"
     "被疑")
    ("피의자"
     "被疑者")
    ("피임"
     "避妊")
    ("피임법"
     "避妊法")
    ("피임약"
     "避妊藥")
    ("피전"
     "皮典")
    ("피정"
     "避靜")
    ("피정복"
     "被征服")
    ("피정복민"
     "被征服民")
    ("피정복자"
     "被征服者")
    ("피조물"
     "被造物")
    ("피지"
     "皮脂")
    ("피지배"
     "被支配")
    ("피지배자"
     "被支配者")
    ("피지배층"
     "被支配層")
    ("피지선"
     "皮脂腺")
    ("피질"
     "皮質")
    ("피차"
     "彼此")
    ("피차간"
     "彼此間")
    ("피청구인"
     "被請求人")
    ("피체포자"
     "被逮捕者")
    ("피침해"
     "被侵害")
    ("피침형"
     "披針形")
    ("피타전"
     "皮打典")
    ("피폐"
     "疲弊")
    ("피폐화"
     "疲弊化")
    ("피폭자"
     "被爆者")
    ("피하"
     "皮下")
    ("피항"
     "避港")
    ("피해"
     "被害")
    ("피해망상증"
     "被害妄想症")
    ("피해액"
     "被害額")
    ("피해자"
     "被害者")
    ("픽"
     ("腷" . "뜩 막힐 픽, 답답할 픽, 닭 홰치는 소리 픽"))
    ("필"
     ("匹" . "짝 필, 둘 필, 한마리 필, 벗 필, 무리 필")
     ("弼" . "도울 필, 도지개 필, 거듭 필")
     ("必" . "반드시 필, 오로지 필, 살필 필, 기약 필")
     ("珌" . "칼 장식 옥 필")
     ("畢" . "마칠 필, 토끼그물 필, 다할 필, 편지 필, 책 필, 고기 꿰 다는 나무 필")
     ("疋" . "짝 필, 끝 필")
     ("筆" . "붓 필, 오랑캐 이름 필")
     "苾"
     ("馝" . "향내날 필")
     ("佖" . "점잔피울 필, 가득할 필")
     ("咇" . "향기날 필")
     ("滭" . "샘 끓어 솟을 필")
     ("篳" . "대 사립문 필, 나무 실은 수레 필")
     ("罼" . "토끼그물 필")
     ("蓽" . "휘추리 필, 약이름 필")
     ("觱" . "바람이 쌀쌀할 필, 대평수 필")
     ("蹕" . "길 치울 필")
     ("鞸" . "슬갑 필")
     ("韠" . "슬갑 필")
     ("駜" . "살찐 말 필")
     ("鵯" . "갈가마귀 필"))
    ("필경"
     "畢竟")
    ("필기"
     "筆記")
    ("필기구"
     "筆記具")
    ("필기도구"
     "筆記道具")
    ("필기시험"
     "筆記試驗")
    ("필기시험지"
     "筆記試驗紙")
    ("필독"
     "必讀")
    ("필두"
     "筆頭")
    ("필력"
     "筆力")
    ("필명"
     "筆名")
    ("필묵"
     "筆墨")
    ("필방"
     "筆房")
    ("필법"
     "筆法")
    ("필부"
     "匹夫")
    ("필사"
     "必死"
     "筆寫")
    ("필사적"
     "必死的")
    ("필선"
     "筆線")
    ("필수"
     "必修"
     "必需"
     "必須")
    ("필수적"
     "必須的")
    ("필수품"
     "必需品")
    ("필승"
     "必勝")
    ("필시"
     "必是")
    ("필압"
     "筆壓")
    ("필연"
     "必然")
    ("필연성"
     "必然性")
    ("필연적"
     "必然的")
    ("필요"
     "必要")
    ("필요금"
     "必要金")
    ("필요량"
     "必要量")
    ("필요성"
     "必要性")
    ("필요악"
     "必要惡")
    ("필요조건"
     "必要條件")
    ("필요충분조건"
     "必要充分條件")
    ("필자"
     "筆者")
    ("필적"
     "匹敵"
     "筆跡")
    ("필진"
     "筆陣")
    ("필체"
     "筆體")
    ("필치"
     "筆致")
    ("필통"
     "筆筒")
    ("핍"
     ("乏" . "없을 핍, 옹색할 핍, 다할 핍")
     ("逼" . "가까울 핍, 궁핍할 핍, 핍박학 핍")
     ("偪" . "핍박할 핍, 가까울 핍"))
    ("핍박"
     "逼迫")
    ("하"
     ("下" . "아래 하")
     ("何" . "어찌 하")
     ("厦" . "큰 집 하")
     ("夏" . "여름 하")
     ("廈" . "큰 집 하")
     ("昰" . "是와 同字")
     ("河" . "물 하")
     ("瑕" . "티 하")
     ("荷" . "연 하")
     ("蝦" . "새우 하")
     ("賀" . "축하할 하")
     ("遐" . "멀 하")
     ("霞" . "놀 하")
     ("鰕" . "새우 하")
     ("呀" . "입 벌릴 하")
     ("嚇" . "놀라게 할 하")
     ("岈" . "휑뎅그렁할 하")
     ("懗" . "속일 하")
     ("煆" . "불사를 하")
     ("瘕" . "이질 하")
     ("罅" . "틈 하")
     ("鍜" . "목투구 하"))
    ("하강"
     "下降")
    ("하강기"
     "下降期")
    ("하강세"
     "下降勢")
    ("하객"
     "賀客")
    ("하계"
     "下界"
     "夏季")
    ("하계절"
     "夏季節")
    ("하곡"
     "夏穀"
     "河谷")
    ("하곡지"
     "河曲地")
    ("하관"
     "下棺"
     "下觀")
    ("하관시"
     "下棺時")
    ("하교"
     "下校")
    ("하굣"
     "下校")
    ("하구"
     "河口")
    ("하권"
     "下卷")
    ("하극상"
     "下剋上")
    ("하급"
     "下級")
    ("하급심"
     "下級審")
    ("하급자"
     "下級者")
    ("하녀"
     "下女")
    ("하단"
     "下段"
     "下端")
    ("하단부"
     "下段部")
    ("하달"
     "下達")
    ("하달식"
     "下達式")
    ("하대"
     "下代")
    ("하도"
     "河道")
    ("하도급"
     "下都給")
    ("하등"
     "下等"
     "何等")
    ("하락"
     "下落")
    ("하락기"
     "下落期")
    ("하락률"
     "下落率")
    ("하락세"
     "下落勢")
    ("하례"
     "下隷"
     "賀禮")
    ("하례객"
     "賀禮客")
    ("하례식"
     "賀禮式")
    ("하류"
     "下流")
    ("하마"
     "河馬")
    ("하명"
     "下命")
    ("하반"
     "下半")
    ("하반기"
     "下半期")
    ("하반신"
     "下半身")
    ("하방"
     "下方")
    ("하방식"
     "下放式")
    ("하복"
     "下服")
    ("하복부"
     "下腹部")
    ("하부"
     "下部")
    ("하사"
     "下士"
     "下賜")
    ("하사관"
     "下士官")
    ("하사금"
     "下賜金")
    ("하사품"
     "下賜品")
    ("하산"
     "下山")
    ("하삼도"
     "下三道")
    ("하상"
     "下裳"
     "河床")
    ("하선"
     "下船")
    ("하선동력"
     "夏扇冬曆")
    ("하수"
     "下水")
    ("하수구"
     "下水溝")
    ("하수도"
     "下水道")
    ("하수도관"
     "下水道管")
    ("하수면"
     "下水面")
    ("하수오"
     "何首烏")
    ("하수인"
     "下手人")
    ("하숙"
     "下宿")
    ("하숙방"
     "下宿房")
    ("하숙비"
     "下宿費")
    ("하숙생"
     "下宿生")
    ("하숙집형"
     "下宿-型")
    ("하순"
     "下旬")
    ("하시"
     "何時")
    ("하야"
     "下野")
    ("하여"
     "何如")
    ("하여간"
     "何如間")
    ("하역"
     "荷役")
    ("하오"
     "下午")
    ("하옥"
     "下獄")
    ("하원"
     "下院")
    ("하위"
     "下位")
    ("하위권"
     "下位圈")
    ("하위문화"
     "下位文化")
    ("하위법"
     "下位法")
    ("하읍례"
     "下揖禮")
    ("하의"
     "下衣")
    ("하인"
     "下人")
    ("하자"
     "瑕疵")
    ("하적호"
     "河跡湖")
    ("하주"
     "荷主")
    ("하중"
     "荷重")
    ("하중도"
     "河中島")
    ("하지"
     "夏至")
    ("하직"
     "下直")
    ("하진부"
     "下進部")
    ("하짓"
     "夏至")
    ("하차"
     "下車")
    ("하책"
     "下策")
    ("하천"
     "河川")
    ("하청"
     "下請")
    ("하청업"
     "下請業")
    ("하체"
     "下體")
    ("하층"
     "下層")
    ("하층민"
     "下層民")
    ("하치장"
     "荷置場")
    ("하필"
     "何必")
    ("하학"
     "下學")
    ("하학적"
     "下學的")
    ("하한가"
     "下限價")
    ("하한기"
     "夏閑期")
    ("하항"
     "河港")
    ("하행선"
     "下行線")
    ("하향"
     "下向"
     "下鄕")
    ("하현"
     "下弦")
    ("하혈"
     "下血")
    ("하혈량"
     "下血量")
    ("하호"
     "下戶")
    ("학"
     ("壑" . "골짜기 학")
     ("學" . "배울 학")
     ("虐" . "사나울 학")
     ("謔" . "희롱할 학")
     ("鶴" . "두루미 학")
     ("涸" . "마를 학")
     "熇"
     ("狢" . "오소리 학")
     ("瘧" . "학질 학")
     ("皬" . "흴 학")
     ("确" . "확실할 학")
     ("郝" . "고을 이름 학")
     ("鷽" . "메까치 학"))
    ("학계"
     "學界")
    ("학과"
     "學科"
     "學課")
    ("학과란"
     "學科欄")
    ("학과장"
     "學科長")
    ("학교"
     "學校")
    ("학교생활"
     "學校生活")
    ("학교장"
     "學校長")
    ("학구열"
     "學究熱")
    ("학구적"
     "學究的")
    ("학군"
     "學群")
    ("학급"
     "學級")
    ("학급비"
     "學級費")
    ("학기"
     "學期")
    ("학내"
     "學內")
    ("학년"
     "學年")
    ("학년도"
     "學年度")
    ("학년생"
     "學年生")
    ("학당"
     "學堂")
    ("학대"
     "虐待")
    ("학덕"
     "學德")
    ("학도"
     "學徒")
    ("학도대"
     "學徒隊")
    ("학도병"
     "學徒兵")
    ("학동"
     "學童")
    ("학력"
     "學力"
     "學歷")
    ("학력고사"
     "學力考査")
    ("학령"
     "學齡")
    ("학맥"
     "學脈")
    ("학명"
     "學名")
    ("학모"
     "學帽")
    ("학무"
     "鶴舞")
    ("학문"
     "學問")
    ("학문적"
     "學問的")
    ("학반"
     "學班")
    ("학번"
     "學番")
    ("학벌"
     "學閥")
    ("학병"
     "學兵")
    ("학보"
     "學報")
    ("학부"
     "學部")
    ("학부모"
     "學父母")
    ("학부형"
     "學父兄")
    ("학비"
     "學費")
    ("학사"
     "學事"
     "學士")
    ("학사모"
     "學士帽")
    ("학살"
     "虐殺")
    ("학살범"
     "虐殺犯")
    ("학생"
     "學生")
    ("학생과"
     "學生課")
    ("학생과장"
     "學生課長")
    ("학생극"
     "學生劇")
    ("학생부"
     "學生部")
    ("학생부실"
     "學生部室")
    ("학생증"
     "學生證")
    ("학생처"
     "學生處")
    ("학생처장"
     "學生處長")
    ("학생회"
     "學生會")
    ("학생회관"
     "學生會館")
    ("학생회비"
     "學生會費")
    ("학생회장"
     "學生會長")
    ("학설"
     "學說")
    ("학설사적"
     "學說史的")
    ("학수고대"
     "鶴首苦待")
    ("학술"
     "學術")
    ("학술적"
     "學術的")
    ("학술지"
     "學術誌")
    ("학술회의"
     "學術會議")
    ("학습"
     "學習")
    ("학습권"
     "學習權")
    ("학습량"
     "學習量")
    ("학습장"
     "學習場")
    ("학습지"
     "學習紙")
    ("학식"
     "學識")
    ("학업"
     "學業")
    ("학연"
     "學緣")
    ("학예"
     "學藝")
    ("학예원"
     "學藝院")
    ("학예회"
     "學藝會")
    ("학용품"
     "學用品")
    ("학우"
     "學友")
    ("학원"
     "學院")
    ("학원비"
     "學院費")
    ("학위"
     "學位")
    ("학의"
     "鶴衣")
    ("학자"
     "學者")
    ("학자금"
     "學資金")
    ("학장"
     "學長")
    ("학적과"
     "學籍課")
    ("학적부"
     "學籍簿")
    ("학점"
     "學點")
    ("학정"
     "學正")
    ("학제"
     "學制")
    ("학창"
     "學窓")
    ("학칙"
     "學則")
    ("학파"
     "學派")
    ("학풍"
     "學風")
    ("학회"
     "學會")
    ("학회장"
     "學會長")
    ("학회지"
     "學會紙")
    ("학훈단"
     "學訓團")
    ("한"
     ("寒" . "찰 한")
     ("恨" . "한탄할 한")
     ("悍" . "사나울 한")
     ("旱" . "가물 한")
     ("桿" . "막대기 한")
     ("汗" . "땀 한")
     ("漢" . "한수 한")
     ("澣" . "빨 한")
     ("瀚" . "넓고 큰 한")
     ("罕" . "드물 한")
     ("翰" . "날개 한")
     ("邯" . "고을 이름 한")
     ("閑" . "한가할 한")
     ("閒" . "한가할 한")
     ("限" . "한정할 한")
     ("韓" . "나라 이름 한")
     ("僩" . "노할 한")
     ("嫺" . "우아할 한")
     ("嫻" . "우아할 한")
     ("捍" . "막을 한")
     ("暵" . "말릴 한")
     "熯"
     "犴"
     ("閈" . "마을 문 한")
     ("駻" . "사나운 말 한")
     ("鷳" . "소리개 한")
     ("鼾" . "코골 한"))
    ("한가"
     "閑暇")
    ("한강"
     "漢江")
    ("한거"
     "閑居")
    ("한계"
     "限界")
    ("한계성"
     "限界性")
    ("한계점"
     "限界點")
    ("한국"
     "韓國")
    ("한국미"
     "韓國美")
    ("한국어"
     "韓國語")
    ("한국적"
     "韓國的")
    ("한국학"
     "韓國學")
    ("한국화"
     "韓國化"
     "韓國畵")
    ("한기"
     "寒氣")
    ("한도"
     "限度")
    ("한도액"
     "限度額")
    ("한라산"
     "漢拏山")
    ("한랭"
     "寒冷")
    ("한량"
     "閑良"
     "限量")
    ("한로"
     "寒露")
    ("한류"
     "寒流")
    ("한림원"
     "翰林院")
    ("한말"
     "韓末")
    ("한문"
     "漢文")
    ("한문식"
     "漢文式")
    ("한반도"
     "韓半島")
    ("한발"
     "旱魃")
    ("한방"
     "韓方")
    ("한방적"
     "韓方的")
    ("한방차"
     "韓方茶")
    ("한복"
     "韓服")
    ("한사"
     "限死")
    ("한산"
     "閑散")
    ("한서"
     "寒暑")
    ("한수"
     "寒水")
    ("한시"
     "漢詩")
    ("한시사"
     "漢詩史")
    ("한시인"
     "漢詩人")
    ("한시적"
     "限時的")
    ("한식"
     "寒食"
     "韓式"
     "韓食")
    ("한심"
     "寒心")
    ("한심유항"
     "寒深柳巷")
    ("한약"
     "韓藥")
    ("한약물"
     "韓藥物")
    ("한약방"
     "韓藥房")
    ("한약업자"
     "韓藥業者")
    ("한약재"
     "韓藥材")
    ("한어"
     "漢語")
    ("한역"
     "漢譯")
    ("한영"
     "韓英")
    ("한옥"
     "韓屋")
    ("한우"
     "韓牛")
    ("한유"
     "閑裕")
    ("한의사"
     "韓醫師")
    ("한의원"
     "韓醫院")
    ("한의학"
     "韓醫學")
    ("한의학적"
     "韓醫學的")
    ("한자"
     "漢字")
    ("한자식"
     "漢字式")
    ("한자어"
     "漢字語")
    ("한잔"
     "­盞")
    ("한재"
     "旱災")
    ("한적"
     "閑寂")
    ("한정"
     "限定")
    ("한정적"
     "限定的")
    ("한증"
     "寒症")
    ("한증막"
     "汗蒸幕")
    ("한증탕"
     "汗蒸湯")
    ("한지"
     "韓紙")
    ("한직"
     "閑職")
    ("한직제"
     "限職制")
    ("한촌"
     "寒村"
     "閑村")
    ("한탄"
     "恨歎")
    ("한파"
     "寒波")
    ("한평생"
     "限平生")
    ("한학자"
     "漢學者")
    ("한학파"
     "漢學派")
    ("한해"
     "旱害")
    ("한화"
     "韓貨")
    ("할"
     ("割" . "벨 할")
     "蝎"
     ("轄" . "다스릴 할")
     ("瞎" . "애꾸눈 할")
     "蠍"
     "鶡"
     "黠")
    ("할거주의"
     "割據主義")
    ("할당"
     "割當")
    ("할당제"
     "割當制")
    ("할맥"
     "割麥")
    ("할복"
     "割腹")
    ("할부"
     "割賦")
    ("할부금"
     "割賦金")
    ("할애"
     "割愛")
    ("할인"
     "割引")
    ("할인율"
     "割引率")
    ("할인점"
     "割引店")
    ("할증료"
     "割增料")
    ("함"
     ("函" . "상자 함")
     ("含" . "머금을 함")
     ("咸" . "모두 함")
     ("啣" . "재갈 함")
     ("喊" . "소리 함")
     ("檻" . "우리 함")
     ("涵" . "젖을 함")
     ("緘" . "봉할 함")
     ("銜" . "재갈 함")
     ("陷" . "빠질 함")
     ("鹹" . "짤 함")
     "嗛"
     "憨"
     ("莟" . "꽃봉오리 함")
     ("菡" . "연봉오리 함")
     ("諴" . "화할 함")
     ("轞" . "함거 함")
     ("闞" . "범 소리 함")
     "頷")
    ("함구령"
     "緘口令")
    ("함담"
     "鹹淡")
    ("함대"
     "艦隊")
    ("함락"
     "陷落")
    ("함락당"
     "陷落當")
    ("함량"
     "含量")
    ("함몰"
     "陷沒")
    ("함선"
     "艦船")
    ("함성"
     "喊聲")
    ("함수"
     "函數")
    ("함양"
     "涵養")
    ("함유"
     "含有")
    ("함유량"
     "含有量")
    ("함의"
     "含意")
    ("함자"
     "銜字")
    ("함정"
     "艦艇"
     "陷穽")
    ("함축"
     "含蓄")
    ("함축성"
     "含蓄性")
    ("함축적"
     "含蓄的")
    ("함포"
     "艦砲")
    ("합"
     ("合" . "합할 합, 같을 합, 짝 합, 대답할 합")
     ("哈" . "한 모금 합")
     ("盒" . "소반 뚜껑 합, 합 합")
     ("蛤" . "조개 합")
     ("閤" . "도장 합, 침방 합, 개구리소리 합")
     ("闔" . "문짝 합, 닫을 합")
     ("匌" . "기운 답답할 합")
     ("嗑" . "잔말할 합, 웃는 소리 합, 입 다물 합, 괘 이름 합")
     ("柙" . "우리 합, 향나무 합")
     ("榼" . "술그릇 합, 물통 합, 뚜껑 합")
     ("溘" . "문득 합, 이를 합, 의지할 합")
     ("盍" . "덮을 합, 합할 합, 어찌 아니할 합")
     ("郃" . "땅이름 합"))
    ("합격"
     "合格")
    ("합격률"
     "合格率")
    ("합격생"
     "合格生")
    ("합격선"
     "合格線")
    ("합격자"
     "合格者")
    ("합격점"
     "合格點")
    ("합계"
     "合計")
    ("합곡"
     "合谷")
    ("합금"
     "合金")
    ("합기덕"
     "合其德")
    ("합당"
     "合當"
     "合黨")
    ("합동"
     "合同")
    ("합류"
     "合流")
    ("합리"
     "合理")
    ("합리성"
     "合理性")
    ("합리적"
     "合理的")
    ("합리주의"
     "合理主義")
    ("합리주의적"
     "合理主義的")
    ("합리화"
     "合理化")
    ("합목적적"
     "合目的的")
    ("합방"
     "合邦")
    ("합법"
     "合法")
    ("합법성"
     "合法性")
    ("합법적"
     "合法的")
    ("합법칙성"
     "合法則性")
    ("합법칙적"
     "合法則的")
    ("합법화"
     "合法化")
    ("합병"
     "合倂")
    ("합병증"
     "合倂症")
    ("합산"
     "合算")
    ("합석"
     "合席")
    ("합선"
     "合線")
    ("합성"
     "合成")
    ("합성수지"
     "合成樹脂")
    ("합성수지제"
     "合成樹脂製")
    ("합성어"
     "合成語")
    ("합세"
     "合勢")
    ("합수"
     "合水")
    ("합숙"
     "合宿")
    ("합숙소"
     "合宿所")
    ("합승"
     "合乘")
    ("합심"
     "合心")
    ("합의"
     "合意"
     "合議")
    ("합의부"
     "合議部")
    ("합의서"
     "合意書")
    ("합의제"
     "合議制")
    ("합일"
     "合一")
    ("합일적"
     "合一的")
    ("합일점"
     "合一點")
    ("합자"
     "合資")
    ("합자사"
     "合資社")
    ("합자연"
     "合自然")
    ("합작"
     "合作")
    ("합작사"
     "合作社")
    ("합작품"
     "合作品")
    ("합장"
     "合掌")
    ("합종"
     "合從")
    ("합종연횡"
     "合從連衡")
    ("합주"
     "合奏")
    ("합참"
     "合參")
    ("합창"
     "合唱")
    ("합창가"
     "合唱歌")
    ("합창단"
     "合唱團")
    ("합체"
     "合體")
    ("합치"
     "合致")
    ("합판"
     "合板")
    ("합헌"
     "合憲")
    ("합헌성"
     "合憲性")
    ("합헌적"
     "合憲的")
    ("합환주"
     "合歡酒")
    ("항"
     ("亢" . "목 항, 높을 항, 별이름 항, 기둥 항, 가릴 항")
     ("伉" . "강직할 항, 우뚝할 항, 배필 항, 겨룰 항")
     ("姮" . "항아 항, 달에 사는 미녀 항, 달 부르는 다른 이름 항")
     ("巷" . "거리 항, 마을 항, 복도 항, 내시 항")
     ("恒" . "늘 항, 옛 항")
     ("抗" . "막을 항, 들 항, 겨룰 항")
     ("杭" . "건널 항, 거루 항, 고을이름 항")
     ("桁" . "수갑 항, 배다리 항, 횃대 항")
     ("沆" . "큰 물 항, 진펀할 항, 이슬 항")
     ("港" . "물 갈라질 항, 항구 항, 뱃길 항")
     ("缸" . "항아리 항")
     ("肛" . "똥구멍 항, 배 뚱뚱할 항")
     ("航" . "쌍배 항, 배질할 항")
     ("項" . "목덜미 항, 클 항, 항목 항")
     ("行" . "시장 항, 항렬 항, 굳셀 항")
     ("降" . "항복할 항")
     ("夯" . "멜 항, 다질 항")
     ("恆" . "恒의 本字")
     ("炕" . "마를 항, 구울 항, 구들 항")
     ("缿" . "항통 항, 문서함 항, 벙어리 항")
     ("頏" . "목 항, 오르락 내리락할 항"))
    ("항간"
     "巷間")
    ("항거"
     "抗拒")
    ("항고"
     "抗告")
    ("항고인"
     "抗告人")
    ("항공"
     "航空")
    ("항공관"
     "航空觀")
    ("항공관제"
     "航空管制")
    ("항공관제사"
     "航空管制使")
    ("항공국"
     "航空局")
    ("항공기"
     "航空機")
    ("항공대"
     "航空隊")
    ("항공로"
     "航空路")
    ("항공모함"
     "航空母艦")
    ("항공사"
     "航空社")
    ("항공사진"
     "航空寫眞")
    ("항공편"
     "航空便")
    ("항구"
     "港口")
    ("항구성"
     "恒久性")
    ("항구적"
     "恒久的")
    ("항라"
     "亢羅")
    ("항렬자"
     "行列字")
    ("항로"
     "航路")
    ("항마"
     "降魔")
    ("항만"
     "港灣")
    ("항명성"
     "抗命性")
    ("항모"
     "航母")
    ("항목"
     "項目")
    ("항문"
     "肛門")
    ("항변"
     "抗卞"
     "抗辯")
    ("항복"
     "降伏")
    ("항산화제"
     "抗酸化劑")
    ("항상"
     "恒常")
    ("항상성"
     "恒常性")
    ("항상적"
     "恒常的")
    ("항생"
     "抗生")
    ("항생제"
     "抗生劑")
    ("항성"
     "恒星")
    ("항성표"
     "恒星表")
    ("항소"
     "抗訴")
    ("항소심"
     "抗訴審")
    ("항수"
     "恒數")
    ("항수적"
     "恒數的")
    ("항습"
     "抗濕")
    ("항시"
     "恒時")
    ("항시적"
     "恒時的")
    ("항심"
     "恒心")
    ("항암"
     "抗癌")
    ("항암제"
     "抗癌劑")
    ("항온"
     "恒溫")
    ("항원"
     "抗原")
    ("항응고제"
     "抗凝固劑")
    ("항의"
     "抗議")
    ("항의단"
     "抗議團")
    ("항의문"
     "抗議文")
    ("항의서"
     "抗議書")
    ("항의성"
     "抗議性")
    ("항일"
     "抗日")
    ("항쟁"
     "抗爭")
    ("항전"
     "抗戰")
    ("항진"
     "亢進"
     "航進")
    ("항차"
     "航次")
    ("항체"
     "抗體")
    ("항해"
     "航海")
    ("항해술"
     "航海術")
    ("해"
     ("亥" . "열 둘째 지지 해, 서북쪽과 북쪽의 사이 방향 해, 음력 시월 해, 돼지 해")
     ("偕" . "함께할 해, 굳셀 해")
     ("咳" . "기침 해, 침 뱉을 해, 방글방글 웃을 해")
     ("垓" . "땅 가장자리 해, 햇수 해, 계단 해")
     ("奚" . "어찌 해, 종 해, 큰 배 해")
     ("孩" . "어린아이 해, 방글방글 웃을 해")
     ("害" . "해할 해, 시기할 해, 죽일 해")
     ("懈" . "게으를 해")
     ("楷" . "해나무 해, 본뜰 해, 해자 해, 법 해")
     ("海" . "바다 해, 많을 해, 세계 해")
     ("瀣" . "찬이슬 해, 이슬 기운 해")
     ("蟹" . "게 해")
     ("解" . "쪼갤 해, 꺠우칠 해, 풀 해, 괘 이름 해, 벗을 해")
     ("該" . "갖출 해, 모두 해, 겸할 해, 마땅할 해")
     ("諧" . "조화할 해, 글 해, 기롱지거리할 해, 고를 해")
     ("邂" . "우연히 만날 해")
     ("駭" . "놀랄 해, 북 울릴 해")
     ("骸" . "뼈 해")
     ("咍" . "비웃을 해")
     ("嶰" . "골짝 사이 해, 골 이름 해")
     ("廨" . "관청 해, 공해 해")
     ("欬" . "기침할 해, 크게 부를 해, 일깨울 해")
     ("獬" . "신통한 양 해, 해갓 해")
     "瑎"
     ("痎" . "학질 해, 하루거리 해")
     ("薤" . "염교 해, 부추 해")
     ("醢" . "젓 해, 젓 담글 해, 젓 담그는 형벌 해")
     ("頦" . "턱 해")
     ("鮭" . "어채 해, 복 해"))
    ("해결"
     "解決")
    ("해결법"
     "解決法")
    ("해결사"
     "解決士")
    ("해결안"
     "解決案")
    ("해결점"
     "解決點")
    ("해결책"
     "解決策")
    ("해경"
     "海警")
    ("해고"
     "解雇")
    ("해고당"
     "解雇當")
    ("해고자"
     "解雇者")
    ("해고제"
     "解雇制")
    ("해골"
     "骸骨")
    ("해괴"
     "駭怪")
    ("해괴망측"
     "駭怪罔測")
    ("해군"
     "海軍")
    ("해금"
     "解禁")
    ("해난"
     "海難")
    ("해남"
     "海南")
    ("해내"
     "海內")
    ("해녀"
     "海女")
    ("해답"
     "解答")
    ("해당"
     "該當")
    ("해당국"
     "該當國")
    ("해당란"
     "該當欄")
    ("해당자"
     "該當者")
    ("해당화"
     "海棠花")
    ("해독"
     "害毒"
     "解讀")
    ("해독률"
     "解讀率")
    ("해독성"
     "害毒性")
    ("해독제"
     "解毒劑")
    ("해동"
     "海東"
     "解凍")
    ("해동종"
     "海東宗")
    ("해득률"
     "解得率")
    ("해로"
     "偕老"
     "海路")
    ("해류"
     "海流")
    ("해마"
     "海馬")
    ("해면"
     "海面")
    ("해명"
     "解明")
    ("해몽"
     "解夢")
    ("해물"
     "海物")
    ("해물탕"
     "海物湯")
    ("해박"
     "該博")
    ("해발"
     "海拔")
    ("해방"
     "解放")
    ("해방감"
     "解放感")
    ("해방구"
     "解放區")
    ("해방군"
     "解放軍")
    ("해방기"
     "解放期")
    ("해방론자"
     "解放論者")
    ("해방자"
     "解放者")
    ("해방적"
     "解放的")
    ("해방전"
     "解放戰")
    ("해법"
     "解法")
    ("해변"
     "海邊")
    ("해병"
     "海兵")
    ("해병대"
     "海兵隊")
    ("해부"
     "解剖")
    ("해부학적"
     "解剖學的")
    ("해빙"
     "解氷")
    ("해빙기"
     "解氷期")
    ("해산"
     "解散"
     "解産")
    ("해산권"
     "解散權")
    ("해산당"
     "解散當")
    ("해산물"
     "海産物")
    ("해산일"
     "解産日")
    ("해상"
     "海上"
     "海商")
    ("해상도"
     "解像度")
    ("해서체"
     "楷書體")
    ("해석"
     "解析"
     "解釋")
    ("해석론"
     "解釋論")
    ("해석자"
     "解釋者")
    ("해석적"
     "解析的")
    ("해석학"
     "解釋學")
    ("해석학적"
     "解釋學的")
    ("해설"
     "解說")
    ("해설가"
     "解說家")
    ("해설서"
     "解說書")
    ("해설자"
     "解說者")
    ("해소"
     "解消")
    ("해소법"
     "解消法")
    ("해소책"
     "解消策")
    ("해송"
     "海松")
    ("해수"
     "海水")
    ("해수면"
     "海水面")
    ("해수병"
     "咳嗽病")
    ("해수욕"
     "海水浴")
    ("해수욕장"
     "海水浴場")
    ("해악"
     "害惡")
    ("해악적"
     "害惡的")
    ("해안"
     "海岸")
    ("해안선"
     "海岸線")
    ("해안통"
     "海岸通")
    ("해약"
     "解約")
    ("해양"
     "海洋")
    ("해양국"
     "海洋國")
    ("해양성"
     "海洋性")
    ("해양인"
     "海洋人")
    ("해역"
     "海域")
    ("해열제"
     "解熱劑")
    ("해왕성"
     "海王星")
    ("해외"
     "海外")
    ("해외여행"
     "海外旅行")
    ("해외여행지"
     "海外旅行地")
    ("해운"
     "海運")
    ("해원"
     "海員")
    ("해이"
     "解弛")
    ("해인"
     "海印")
    ("해임"
     "解任")
    ("해임당"
     "解任當")
    ("해장국"
     "解장@")
    ("해장술"
     "解장@")
    ("해저"
     "海底")
    ("해적"
     "海賊")
    ("해전"
     "海戰")
    ("해제"
     "解除")
    ("해제경보"
     "解除警報")
    ("해조류"
     "海藻類")
    ("해지"
     "解止")
    ("해직"
     "解職")
    ("해직당"
     "解職當")
    ("해직자"
     "解職者")
    ("해참"
     "海參")
    ("해체"
     "解體")
    ("해체론"
     "解體論")
    ("해초"
     "海草")
    ("해충"
     "害蟲")
    ("해탈"
     "解脫")
    ("해태"
     "海苔")
    ("해토"
     "解土")
    ("해풍"
     "海風")
    ("해학"
     "諧謔")
    ("해학적"
     "諧謔的")
    ("해협"
     "海峽")
    ("해후"
     "邂逅")
    ("핵"
     ("劾" . "캐물을 핵, 핵실할 핵")
     ("核" . "실과 핵, 자세할 핵")
     ("翮" . "깃촉 핵, 쭉지 핵, 칼 갓 핵")
     ("覈" . "핵실할 핵, 겨무거리 핵, 씨 핵, 액색할 핵"))
    ("핵가족"
     "核家族")
    ("핵무기"
     "核武器")
    ("핵물리"
     "核物理")
    ("핵물리학과"
     "核物理學科")
    ("핵분열"
     "核分裂")
    ("핵산"
     "核酸")
    ("핵심"
     "核心")
    ("핵심부"
     "核心部")
    ("핵심적"
     "核心的")
    ("핵심층"
     "核心層")
    ("핵연료"
     "核燃料")
    ("핵우산"
     "核雨傘")
    ("핵융합"
     "核融合")
    ("핵자기"
     "核磁氣")
    ("핵전략"
     "核戰略")
    ("핵전쟁"
     "核戰爭")
    ("핵탄두"
     "核彈頭")
    ("핵폐기물"
     "核廢棄物")
    ("핵폭탄"
     "核爆彈")
    ("행"
     ("倖" . "요행 행, 괴일 행, 아당할 행, 친할 행")
     ("幸" . "다행할 행, 바랄 행")
     ("杏" . "살구 행, 은행 행")
     ("荇" . "마름풀 행, 조아기 행")
     ("行" . "다닐 행, 길귀신 행, 오행 행, 그릇 얄긋거릴 행, 행서 행, 행실 행")
     ("悻" . "발끈 성낼 행"))
    ("행각"
     "行脚")
    ("행간"
     "行間")
    ("행군"
     "行軍")
    ("행궁"
     "行宮")
    ("행동"
     "行動")
    ("행동거지"
     "行動擧止")
    ("행동권"
     "行動權")
    ("행동력"
     "行動力")
    ("행동반경"
     "行動半徑")
    ("행동자"
     "行動者")
    ("행동적"
     "行動的")
    ("행동주의"
     "行動主義")
    ("행동파"
     "行動派")
    ("행락"
     "行樂")
    ("행락객"
     "行樂客")
    ("행랑"
     "行廊")
    ("행려병자"
     "行旅病者")
    ("행려자"
     "行旅者")
    ("행렬"
     "行列")
    ("행로"
     "行路")
    ("행방"
     "行方")
    ("행방불명"
     "行方不明")
    ("행방불명자"
     "行方不明者")
    ("행보"
     "行步")
    ("행복"
     "幸福")
    ("행복감"
     "幸福感")
    ("행복권"
     "幸福權")
    ("행사"
     "行事"
     "行使")
    ("행사장"
     "行事場")
    ("행상"
     "行商")
    ("행색"
     "行色")
    ("행서체"
     "行書體")
    ("행선지"
     "行先地")
    ("행성"
     "行星")
    ("행세"
     "行世")
    ("행시"
     "行試")
    ("행실"
     "行實")
    ("행악"
     "行惡")
    ("행운"
     "幸運")
    ("행운목"
     "幸運木")
    ("행원"
     "行員")
    ("행위"
     "行爲")
    ("행위자"
     "行爲者")
    ("행위적"
     "行爲的")
    ("행의"
     "行衣")
    ("행이지난"
     "行易知難")
    ("행인"
     "行人")
    ("행자"
     "行者")
    ("행장"
     "行長"
     "行障")
    ("행적"
     "行跡")
    ("행정"
     "行政")
    ("행정가"
     "行政家")
    ("행정관"
     "行政官")
    ("행정권"
     "行政權")
    ("행정력"
     "行政力")
    ("행정반"
     "行政班")
    ("행정법"
     "行政法")
    ("행정병"
     "行政兵")
    ("행정부"
     "行政府")
    ("행정실"
     "行政室")
    ("행정원"
     "行政院")
    ("행정원장"
     "行政院長")
    ("행정적"
     "行政的")
    ("행정직"
     "行政職")
    ("행정청"
     "行政廳")
    ("행정촌제"
     "行政村制")
    ("행정학과"
     "行政學科")
    ("행진"
     "行進")
    ("행진곡"
     "行進曲")
    ("행진곡풍"
     "行進曲風")
    ("행진풍"
     "行進風")
    ("행차"
     "行次")
    ("행태"
     "行態")
    ("행태주의적"
     "行態主義的")
    ("행패"
     "行悖")
    ("행협"
     "行協")
    ("향"
     ("享" . "드릴 향, 제사지낼 향, 잔치 향, 흠향할 향")
     ("向" . "향할 향, 나아갈 향, 북쪽 창 향, 기울어질 향")
     ("嚮" . "향할 향, 누릴 향, 울릴 향, 받을 향")
     "珦"
     ("鄕" . "시골 향, 고향 향")
     ("響" . "소리 울릴 향, 소리 마주칠 향, 악기 향")
     ("餉" . "먹일 향, 군량 향, 점심 향")
     ("饗" . "잔치할 향, 흠향할 향")
     ("香" . "향내 향, 약이름 향")
     ("薌" . "곡기 향, 향기 향, 기장 향"))
    ("향교"
     "鄕校")
    ("향기"
     "香氣")
    ("향년"
     "享年")
    ("향도"
     "香徒")
    ("향락"
     "享樂")
    ("향락객"
     "享樂客")
    ("향락업소"
     "享樂業所")
    ("향락적"
     "享樂的")
    ("향락화"
     "享樂化")
    ("향로"
     "香爐")
    ("향료"
     "香料")
    ("향리"
     "鄕吏")
    ("향리제"
     "鄕吏制")
    ("향리층"
     "鄕吏層")
    ("향방"
     "向方")
    ("향배"
     "向背")
    ("향벽설위"
     "向壁設位")
    ("향상"
     "向上")
    ("향수"
     "享受"
     "鄕愁"
     "香水")
    ("향수권"
     "享受權")
    ("향수병"
     "鄕愁病"
     "香水甁")
    ("향수자"
     "享受者")
    ("향시"
     "鄕市"
     "鄕試")
    ("향신료"
     "香辛料")
    ("향심"
     "向心")
    ("향아설위"
     "向我設位")
    ("향악"
     "享樂")
    ("향약"
     "鄕約")
    ("향약록"
     "鄕約錄")
    ("향연"
     "饗宴")
    ("향연장"
     "饗宴場")
    ("향유"
     "享有")
    ("향응"
     "饗應")
    ("향인"
     "鄕人")
    ("향직원"
     "鄕織院")
    ("향촌"
     "鄕村")
    ("향취"
     "香臭")
    ("향토"
     "鄕土")
    ("향토사"
     "鄕土史")
    ("향토색"
     "鄕土色")
    ("향토애"
     "鄕土愛")
    ("향토적"
     "鄕土的")
    ("향후"
     "向後")
    ("향훈"
     "香薰")
    ("허"
     ("噓" . "불 허, 뿜을 허")
     ("墟" . "옛 터 허, 장 허, 큰 두덕 허")
     ("虛" . "빌 허, 헛될 허, 다할 허, 약할 허, 거짓 허, 하늘 허")
     ("許" . "허락할 허, 나아갈 허, 기약할 허, 여럿이 힘쓰는 소리 허")
     ("歔" . "한숨 쉴 허, 흑흑 느껴 울 허, 코로 숨 내쉴 허")
     "詡")
    ("허가"
     "許可")
    ("허가서"
     "許可書")
    ("허가제"
     "許可制")
    ("허가증"
     "許可證")
    ("허공"
     "虛空")
    ("허공중"
     "虛空中")
    ("허구"
     "虛構"
     "許久")
    ("허구성"
     "虛構性")
    ("허구심"
     "虛構心")
    ("허구적"
     "虛構的")
    ("허구화"
     "虛構化")
    ("허기"
     "虛飢")
    ("허기증"
     "虛飢症")
    ("허다"
     "許多")
    ("허락"
     "許諾")
    ("허랑"
     "虛浪")
    ("허례"
     "虛禮")
    ("허망"
     "虛妄")
    ("허망감"
     "虛妄感")
    ("허무"
     "虛無")
    ("허무감"
     "虛無感")
    ("허무맹랑"
     "虛無孟浪")
    ("허무주의"
     "虛無主義")
    ("허무주의자"
     "虛無主義者")
    ("허비"
     "虛費")
    ("허사"
     "虛事")
    ("허상"
     "虛像")
    ("허세"
     "虛勢")
    ("허송"
     "虛送")
    ("허송세월"
     "虛送歲月")
    ("허실"
     "虛實")
    ("허심탄회"
     "虛心坦懷")
    ("허약"
     "虛弱")
    ("허영"
     "虛榮")
    ("허영심"
     "虛榮心")
    ("허영적"
     "虛榮的")
    ("허용"
     "許容")
    ("허용량"
     "許容量")
    ("허위"
     "虛僞")
    ("허위성"
     "虛僞性")
    ("허위의식"
     "虛僞意識")
    ("허위적"
     "虛僞的")
    ("허장성세"
     "虛張聲勢")
    ("허점"
     "虛點")
    ("허증"
     "虛症")
    ("허탈"
     "虛脫")
    ("허탈감"
     "虛脫感")
    ("허풍"
     "虛風")
    ("허풍기"
     "虛風氣")
    ("허허"
     "虛虛")
    ("허황"
     "虛荒")
    ("허황기"
     "虛荒氣")
    ("헌"
     ("憲" . "법 헌, 표준될 헌, 고시할 헌, 기뻐할 헌")
     "櫶"
     ("獻" . "바칠 헌, 음식 헌, 어진이 헌")
     ("軒" . "초헌 헌, 껄껄 웃을 헌, 주적댈 헌, 추녀끝 헌, 고기 굵게 저밀 헌")
     ("巚" . "봉우리 헌, 시루봉 헌")
     ("幰" . "수레 안장 헌, 휘장 헌")
     "掀"
     ("攇" . "비길 헌, 물건 맬 헌"))
    ("헌금"
     "獻金")
    ("헌납"
     "獻納")
    ("헌물"
     "獻物")
    ("헌물장"
     "獻物帳")
    ("헌법"
     "憲法")
    ("헌법안"
     "憲法案")
    ("헌병"
     "憲兵")
    ("헌병감"
     "憲兵監")
    ("헌병감실"
     "憲兵監室")
    ("헌병대"
     "憲兵隊")
    ("헌상"
     "獻上")
    ("헌신"
     "獻身")
    ("헌신적"
     "獻身的")
    ("헌장"
     "憲章")
    ("헌정"
     "憲政")
    ("헌정사"
     "憲政史")
    ("헌헌장부"
     "軒軒丈夫")
    ("헌혈"
     "獻血")
    ("헌혈자"
     "獻血者")
    ("헐"
     ("歇" . "쉴 헐, 나른할 헐, 다할 헐, 으슥할 헐, 스러질 헐, 흩어질 헐")
     "蝎"
     "蠍")
    ("험"
     ("險" . "험할 험")
     ("驗" . "시험할 험, 중험할 험, 보람 험")
     ("嶮" . "산 가파를 험")
     "憸"
     ("獫" . "험윤 오랑캐 험")
     ("玁" . "獫과 同字"))
    ("험구"
     "險口")
    ("험난"
     "險難")
    ("험담"
     "險談")
    ("험상"
     "險狀")
    ("험악"
     "險惡")
    ("험준"
     "險峻")
    ("혁"
     ("奕" . "아름다울 혁, 클 혁, 차례 혁, 바둑 혁, 빛날 혁, 근심할 혁")
     ("爀" . "불빛 혁, 빛날 혁")
     ("赫" . "불 이글이글할 혁, 빛날 혁, 성할 혁")
     ("革" . "가죽 혁, 고칠 혁, 갑주 혁")
     ("嚇" . "노할 혁, 꾸짖을 혁")
     ("弈" . "바둑둘 혁")
     ("洫" . "넘칠 혁, 빌 혁, 봇도랑 혁")
     ("鬩" . "송사할 혁, 싸울 혁"))
    ("혁대"
     "革帶")
    ("혁명"
     "革命")
    ("혁명가"
     "革命家")
    ("혁명군"
     "革命軍")
    ("혁명기"
     "革命期")
    ("혁명론"
     "革命論")
    ("혁명론자"
     "革命論者")
    ("혁명성"
     "革命性")
    ("혁명적"
     "革命的")
    ("혁명주의"
     "革命主義")
    ("혁신"
     "革新")
    ("혁신적"
     "革新的")
    ("혁파"
     "革罷")
    ("혁혁"
     "赫赫")
    ("현"
     ("俔" . "연탐할 현, 풍세보는 깃 현")
     ("峴" . "고개 현, 산이름 현")
     ("弦" . "시위 현, 반달 현, 맥박 잦을 현, 땅이름 현")
     ("懸" . "매달 현, 멀 현")
     ("晛" . "햇발 현")
     ("泫" . "물 깊을 현, 이슬 맺힐 현, 눈물 줄줄 흘릴 현")
     ("洵" . "멀 현")
     ("炫" . "밝을 현, 불빛 현")
     ("玄" . "검을 현, 검붉을 현, 하늘 현, 아득할 현, 고요할 현")
     "玹"
     ("現" . "나타날 현, 지금 현, 옥빛 현")
     ("眩" . "아찔할 현, 현혹할 현")
     ("睍" . "물끄러미 볼 현, 고울 현")
     ("絃" . "줄풍류 현")
     ("絢" . "채색무늬 현")
     ("縣" . "매달릴 현, 끊어질 현")
     ("舷" . "뱃전 현")
     ("衒" . "자랑할 현, 팔릴 현")
     ("賢" . "어질 현, 좋을 현, 구멍 현")
     ("鉉" . "솥귀 현")
     ("顯" . "나타날 현, 밝을 현, 통달할 현, 높을 현")
     ("見" . "나타날 현, 드러날 현, 있을 현, 보일 현")
     ("儇" . "영리할 현, 빠를 현")
     ("嬛" . "산뜻할 현")
     ("昡" . "햇빛 현")
     "琄"
     ("痃" . "힘줄 당기는 병 현, 적병 현")
     ("県" . "고을 현, 지방 현")
     "眴"
     "祆"
     "筧"
     ("繯" . "얽힐 현, 둘릴 현, 맬 현")
     ("翾" . "파뜩파뜩 날 현, 경박할 현, 영리할 현, 급할 현")
     ("蜆" . "가막조개 현, 호수이름 현")
     "誢"
     ("鋗" . "노구솥 현, 퉁노구 현")
     ("駽" . "돗총이 현, 철총이 현"))
    ("현감"
     "縣監")
    ("현격"
     "懸隔")
    ("현관"
     "玄關")
    ("현관문"
     "玄關門")
    ("현금"
     "現金")
    ("현금화"
     "現金化")
    ("현기"
     "眩氣")
    ("현기증"
     "眩氣症")
    ("현대"
     "現代")
    ("현대극"
     "現代劇")
    ("현대문"
     "現代文")
    ("현대물"
     "現代物")
    ("현대병"
     "現代病")
    ("현대사"
     "現代史")
    ("현대성"
     "現代性")
    ("현대식"
     "現代式")
    ("현대인"
     "現代人")
    ("현대적"
     "現代的")
    ("현대전"
     "現代戰")
    ("현대주의"
     "現代主義")
    ("현대판"
     "現代版")
    ("현대화"
     "現代化")
    ("현란"
     "絢爛")
    ("현맥"
     "玄麥")
    ("현명"
     "賢明")
    ("현모"
     "賢母")
    ("현모양처"
     "賢母良妻")
    ("현모양처주의"
     "賢母良妻主義")
    ("현묘"
     "玄妙")
    ("현무"
     "玄武")
    ("현무암"
     "玄武巖")
    ("현문"
     "舷門")
    ("현물"
     "現物")
    ("현미"
     "玄米")
    ("현미경"
     "顯微鏡")
    ("현상"
     "懸賞"
     "現像"
     "現狀"
     "現象")
    ("현상계"
     "現象界")
    ("현상금"
     "懸賞金")
    ("현상적"
     "現象的")
    ("현상학"
     "現象學")
    ("현상학적"
     "現象學的")
    ("현생"
     "現生")
    ("현세"
     "現世")
    ("현세력"
     "現勢力")
    ("현세불"
     "現世佛")
    ("현세적"
     "現世的")
    ("현세주의"
     "現世主義")
    ("현세주의적"
     "現世主義的")
    ("현수막"
     "懸垂幕")
    ("현시"
     "顯示")
    ("현시기"
     "現時期")
    ("현시대"
     "現時代")
    ("현시적"
     "現時的")
    ("현시점"
     "現時點")
    ("현실"
     "現實")
    ("현실감"
     "現實感")
    ("현실론"
     "現實論")
    ("현실성"
     "現實性")
    ("현실적"
     "現實的")
    ("현실주의"
     "現實主義")
    ("현실주의자"
     "現實主義者")
    ("현실주의적"
     "現實主義的")
    ("현실주의화"
     "現實主義化")
    ("현실층"
     "現實層")
    ("현실화"
     "現實化")
    ("현실화도"
     "現實化度")
    ("현악기"
     "絃樂器")
    ("현안"
     "懸案")
    ("현업"
     "現業")
    ("현역"
     "現役")
    ("현위"
     "縣尉")
    ("현인"
     "賢人")
    ("현자"
     "賢者")
    ("현장"
     "現場")
    ("현장감"
     "現場感")
    ("현장성"
     "現場性")
    ("현재"
     "現在")
    ("현재성"
     "現在性")
    ("현재적"
     "現在的")
    ("현재화"
     "現在化")
    ("현저"
     "顯著")
    ("현저화"
     "顯著化")
    ("현존"
     "現存")
    ("현존자"
     "現存者")
    ("현주소"
     "現住所")
    ("현지"
     "現地")
    ("현지답사"
     "現地踏査")
    ("현지인"
     "現地人")
    ("현직"
     "現職"
     "顯職")
    ("현찰"
     "現札")
    ("현창"
     "顯彰")
    ("현처"
     "賢妻")
    ("현충일"
     "顯忠日")
    ("현충탑"
     "顯忠塔")
    ("현판"
     "懸板")
    ("현판식"
     "懸板式")
    ("현학적"
     "衒學的")
    ("현행"
     "現行")
    ("현행범"
     "現行犯")
    ("현행법"
     "現行法")
    ("현현"
     "顯現")
    ("현혹"
     "眩惑")
    ("현혹당"
     "眩惑當")
    ("현황"
     "現況")
    ("혈"
     ("孑" . "외로울 혈, 나머지 혈, 창갈구리 혈")
     ("穴" . "굴 혈, 움 혈, 틈 혈, 굿 혈")
     ("血" . "피 혈, 피붙이 혈, 씩씩할 혈")
     ("頁" . "머리 혈, 마리 혈, 페이지(page) 혈")
     ("絜" . "헤아릴 혈, 묶을 혈")
     ("趐" . "새가 떼로 날 혈, 나아갈 혈"))
    ("혈관"
     "血管")
    ("혈기"
     "血氣")
    ("혈당"
     "血糖")
    ("혈맥"
     "血脈")
    ("혈색"
     "血色")
    ("혈색소"
     "血色素")
    ("혈세"
     "血稅")
    ("혈안"
     "血眼")
    ("혈압"
     "血壓")
    ("혈액"
     "血液")
    ("혈액형"
     "血液型")
    ("혈연"
     "血緣")
    ("혈연관계"
     "血緣關係")
    ("혈연성"
     "血緣性")
    ("혈연적"
     "血緣的")
    ("혈우병"
     "血友病")
    ("혈육"
     "血肉")
    ("혈전"
     "血戰")
    ("혈족"
     "血族")
    ("혈족적"
     "血族的")
    ("혈청"
     "血淸")
    ("혈통"
     "血統")
    ("혈투"
     "血鬪")
    ("혈행"
     "血行")
    ("혈허성"
     "血虛性")
    ("혈혈단신"
     "孑孑單身")
    ("혐"
     ("嫌" . "싫어할 혐, 의심할 혐, 유쾌하지 않을 혐")
     "鼸")
    ("혐오"
     "嫌惡")
    ("혐오감"
     "嫌惡感")
    ("혐의"
     "嫌疑")
    ("혐의자"
     "嫌疑者")
    ("협"
     ("俠" . "의기 협, 사이에 낄 협")
     ("協" . "조화할 협, 맞을 협, 도울 협")
     ("夾" . "곁 협, 낄 협, 잡을 협, 성씨 협, 가까울 협")
     ("峽" . "물 낀 두메 협, 산이름 협")
     ("挾" . "낄 협, 도울 협, 품을 협")
     ("浹" . "사무칠 협, 둘릴 협")
     ("狹" . "좁을 협")
     ("脅" . "갈빗대 협, 위협할 협")
     ("脇" . "脅과 同字")
     ("莢" . "콩 꼬투리 협, 명협 협")
     ("鋏" . "칼 손잡이 협, 집개 협")
     ("陜" . "좁을 협")
     ("頰" . "뺨 협, 천천히 말할 협")
     ("匧" . "옷상자 협, 꿰맬 협")
     ("叶" . "화합할 협")
     "埉"
     ("恊" . "겁낼 협, 위협할 협")
     "悏"
     ("愜" . "쾌할 협, 뜻에 맞을 협")
     ("篋" . "상자 협, 행담 협"))
    ("협객"
     "俠客")
    ("협곡"
     "峽谷")
    ("협공"
     "挾攻")
    ("협궤"
     "狹軌")
    ("협동"
     "協同")
    ("협동농장"
     "協同農場")
    ("협동심"
     "協同心")
    ("협동적"
     "協同的")
    ("협동조합"
     "協同組合")
    ("협동형"
     "協同型")
    ("협동화"
     "協同化")
    ("협력"
     "協力")
    ("협력관"
     "協力官")
    ("협력국"
     "協力局")
    ("협력국장"
     "協力局長")
    ("협력단장"
     "協力團長")
    ("협력사"
     "協力社")
    ("협박"
     "脅迫")
    ("협박성"
     "脅迫性")
    ("협상"
     "協商")
    ("협상물"
     "協商物")
    ("협소"
     "狹小")
    ("협소화"
     "狹小化")
    ("협심증"
     "狹心症")
    ("협약"
     "協約")
    ("협업"
     "協業")
    ("협업적"
     "協業的")
    ("협연"
     "協演")
    ("협연자"
     "協演者")
    ("협의"
     "協議"
     "狹義")
    ("협의체"
     "協議體")
    ("협의회"
     "協議會")
    ("협정"
     "協定")
    ("협정량"
     "協定量")
    ("협정문"
     "協定文")
    ("협정서"
     "協定書")
    ("협정안"
     "協定案")
    ("협조"
     "協助"
     "協調")
    ("협조주의"
     "協助主義")
    ("협주곡"
     "協奏曲")
    ("협주단"
     "協奏團")
    ("협착증"
     "狹窄症")
    ("협찬"
     "協贊")
    ("협화"
     "協和")
    ("협회"
     "協會")
    ("협회원"
     "協會員")
    ("협회장"
     "協會長")
    ("형"
     ("亨" . "형통할 형, 제사 형")
     ("兄" . "맏이 형")
     ("刑" . "형벌 형, 죽일 형")
     ("型" . "거푸집 형, 본보기 형")
     ("形" . "모양 형, 몸 형")
     ("桁" . "시렁 형, 마개 형")
     ("泂" . "멀 형, 깊고 넓은 모양 형, 차가운 형")
     ("滎" . "실개천 형, 물결 일 형")
     ("瀅" . "맑을 형, 개천 형")
     ("灐" . "물 이름 형")
     ("炯" . "빛날 형, 밝을 형")
     "烱"
     ("熒" . "등불 형")
     ("珩" . "노리개 형, 갓끈 형")
     ("瑩" . "밝을 형")
     ("荊" . "모형나무 형, 곤장 형")
     ("螢" . "개똥벌레 형")
     ("衡" . "저울대 형")
     ("逈" . "멀 형, 빛날 형")
     ("邢" . "나라 이름 형, 땅 이름 형")
     ("鎣" . "줄 형, 꾸밀 형")
     ("馨" . "향기 형")
     ("夐" . "멀 형, 바라보는 모양 형")
     ("娙" . "여관 이름 형, 예쁠 형")
     ("詗" . "염탐할 형, 구할 형")
     ("迥" . "막을 형, 차단할 형")
     ("陘" . "지레목 형, 비탈 형"))
    ("형광"
     "螢光")
    ("형광등"
     "螢光燈")
    ("형국"
     "形局")
    ("형국론"
     "形局論")
    ("형량"
     "刑量")
    ("형리"
     "刑吏")
    ("형무소"
     "刑務所")
    ("형문"
     "刑問")
    ("형문당"
     "刑問當")
    ("형벌"
     "刑罰")
    ("형법"
     "刑法")
    ("형부"
     "兄夫")
    ("형사"
     "刑事")
    ("형사계"
     "刑事係")
    ("형사계장"
     "刑事係長")
    ("형사계장실"
     "刑事係長室")
    ("형사범"
     "刑事犯")
    ("형사법"
     "刑事法")
    ("형사부"
     "刑事部")
    ("형상"
     "形狀"
     "形象")
    ("형상론"
     "形象論")
    ("형상론적"
     "形象論的")
    ("형상화"
     "形象化")
    ("형성"
     "形性"
     "形成")
    ("형성기"
     "形成期")
    ("형성력"
     "形成力")
    ("형성론"
     "形成論")
    ("형성론자"
     "形成論者")
    ("형성자"
     "形成者")
    ("형성적"
     "形成的")
    ("형성화"
     "形成化")
    ("형세"
     "形勢")
    ("형수"
     "兄嫂")
    ("형식"
     "型式"
     "形式")
    ("형식미"
     "形式美")
    ("형식성"
     "形式性")
    ("형식적"
     "形式的")
    ("형식주의"
     "形式主義")
    ("형식주의적"
     "形式主義的")
    ("형식화"
     "形式化")
    ("형언"
     "形言")
    ("형옥"
     "刑獄")
    ("형용"
     "形容")
    ("형용사"
     "形容詞")
    ("형이상학"
     "形而上學")
    ("형이상학적"
     "形而上學的")
    ("형장"
     "刑場")
    ("형정"
     "刑政")
    ("형제"
     "兄弟")
    ("형제간"
     "兄弟間")
    ("형제국"
     "兄弟國")
    ("형제애"
     "兄弟愛")
    ("형제자매"
     "兄弟姉妹")
    ("형제지간"
     "兄弟之間")
    ("형질"
     "形質")
    ("형체"
     "形體")
    ("형태"
     "形態")
    ("형태미"
     "形態美")
    ("형태적"
     "形態的")
    ("형편"
     "形便")
    ("형평"
     "衡平")
    ("형평성"
     "衡平性")
    ("형평화"
     "衡平化")
    ("형해화"
     "形骸化")
    ("형형"
     "炯炯")
    ("형형색색"
     "形形色色")
    ("혜"
     ("兮" . "어조사 혜")
     ("彗" . "비 혜, 꼬리별 혜")
     ("惠" . "은혜 혜, 사랑할 혜")
     ("慧" . "슬기로울 혜, 총명할 혜")
     "暳"
     ("蕙" . "혜초 혜")
     ("蹊" . "지름길 혜, 건널 혜")
     ("醯" . "초 혜, 위대로울 혜")
     ("鞋" . "신 혜")
     ("傒" . "묶을 혜")
     ("嘒" . "가냘플 혜")
     ("寭" . "밝힐 혜, 깨달을 혜")
     ("徯" . "기다릴 혜, 사잇길 혜")
     ("槥" . "널 혜, 작은 관 혜")
     ("盻" . "흘겨볼 혜, 돌아볼 혜")
     ("謑" . "창피줄 혜")
     ("譿" . "슬기로울 혜"))
    ("혜성"
     "彗星")
    ("혜안"
     "慧眼")
    ("혜택"
     "惠澤")
    ("호"
     ("乎" . "인가 호")
     ("互" . "서로 호, 함께 호")
     ("呼" . "부를 호, 숨 내쉴 호")
     ("壕" . "해자 호")
     ("壺" . "병 호, 단지 호")
     ("好" . "좋을 호, 옳을 호")
     ("岵" . "산 호")
     ("弧" . "활 호")
     ("戶" . "지게 호")
     ("扈" . "뒤따를 호")
     ("昊" . "하늘 호, 큰 모양 호")
     ("晧" . "밝을 호, 빛날 호")
     "槁"
     ("毫" . "가는 털 호")
     ("浩" . "클 호")
     ("淏" . "맑을 호")
     ("湖" . "호수 호")
     ("滸" . "물가 호")
     ("澔" . "浩와 同字")
     ("濠" . "해자 호, 강 이름 호")
     ("濩" . "퍼질 호")
     ("灝" . "넓을 호, 콩 삶은 물 호")
     ("狐" . "여우 호")
     ("琥" . "호박 호")
     ("瑚" . "산호 호")
     ("瓠" . "표주박 호, 단지 호")
     ("皓" . "흴 호, 깨끗할 호")
     ("祜" . "복 호")
     ("糊" . "풀 호, 끈끈할 호")
     ("縞" . "명주 호, 흴 호")
     ("胡" . "턱밑살 호")
     ("芦" . "芐와 同字, 蔖의 俗字")
     ("葫" . "마늘 호, 조롱박 호")
     ("蒿" . "쑥 호, 향기날 호, 지칠 호")
     ("虎" . "범 호")
     ("號" . "울부짖을 호")
     "蝴"
     ("護" . "보호할 호, 감쌀 호")
     ("豪" . "호걸 호, 귀인 호")
     ("鎬" . "호경 호")
     ("頀" . "구할 호, 지킬 호")
     ("顥" . "클 호, 빛나는 모양 호")
     ("儫" . "영웅 호")
     ("冱" . "찰 호, 얼 호, 막을 호")
     ("嘷" . "짖을 호, 외칠 호")
     "嫭"
     ("嫮" . "아름다울 호, 시기할 호")
     ("怙" . "믿을 호")
     ("沍" . "冱의 譌字")
     ("滈" . "장마 호")
     ("滬" . "강 이름 호")
     ("犒" . "호궤할 호")
     ("猢" . "원숭이 호")
     ("皜" . "흴 호, 흰 모양 호")
     ("皞" . "밝을 호, 흴 호")
     ("箎" . "긴 대 호")
     ("聕" . "들릴 호, 긴 귀 호")
     ("醐" . "제호 호")
     ("餬" . "기식할 호")
     ("鬍" . "수염 호"))
    ("호가"
     "呼價")
    ("호가호위"
     "狐假虎威")
    ("호각"
     "號角")
    ("호감"
     "好感")
    ("호감도"
     "好感度")
    ("호객"
     "豪客")
    ("호걸"
     "豪傑")
    ("호경기"
     "好景氣")
    ("호곡"
     "號哭")
    ("호구"
     "戶口")
    ("호국"
     "護國")
    ("호기"
     "好機"
     "號機"
     "豪氣")
    ("호기심"
     "好奇心")
    ("호남"
     "好男"
     "湖南")
    ("호당"
     "戶當")
    ("호도"
     "糊塗"
     "護都")
    ("호란"
     "胡亂")
    ("호랑"
     "虎狼")
    ("호랑이신"
     "虎狼-神")
    ("호령"
     "號令")
    ("호명"
     "呼名")
    ("호민"
     "豪民")
    ("호박색"
     "琥珀色")
    ("호반"
     "湖畔")
    ("호방"
     "豪放")
    ("호별지정"
     "戶別之丁")
    ("호봉"
     "號俸")
    ("호부층"
     "豪富層")
    ("호불"
     "護佛")
    ("호사"
     "豪奢")
    ("호사가"
     "好事家")
    ("호사다마"
     "好事多魔")
    ("호상"
     "好喪"
     "弧狀")
    ("호생"
     "互生")
    ("호선"
     "號線")
    ("호소"
     "呼訴"
     "湖沼"
     "號召")
    ("호소력"
     "呼訴力")
    ("호소문"
     "呼訴文")
    ("호송"
     "護送")
    ("호수"
     "戶數"
     "湖水"
     "號數")
    ("호숫"
     "湖水")
    ("호시탐탐"
     "虎視眈眈")
    ("호식"
     "好食")
    ("호신"
     "虎神")
    ("호실"
     "號室")
    ("호언장담"
     "豪言壯談")
    ("호역"
     "戶役")
    ("호연"
     "好演"
     "浩然")
    ("호연지기"
     "浩然之氣")
    ("호열자"
     "虎列刺")
    ("호외"
     "號外")
    ("호우"
     "豪雨")
    ("호위"
     "扈衛"
     "護衛")
    ("호응"
     "呼應")
    ("호응도"
     "呼應度")
    ("호의"
     "好意")
    ("호의적"
     "好意的")
    ("호재"
     "好材")
    ("호재성"
     "好材性")
    ("호적"
     "戶籍")
    ("호전"
     "好轉")
    ("호전성"
     "好戰性")
    ("호전적"
     "好戰的")
    ("호접몽"
     "胡蝶夢")
    ("호조"
     "好調"
     "戶曹")
    ("호조황"
     "好釣況")
    ("호족"
     "豪族")
    ("호족적"
     "豪族的")
    ("호주"
     "戶主"
     "濠洲")
    ("호주가"
     "好酒家")
    ("호출"
     "呼出")
    ("호출기"
     "呼出機")
    ("호칭"
     "呼稱")
    ("호쾌"
     "豪快")
    ("호탕"
     "豪宕")
    ("호판"
     "戶判")
    ("호패"
     "號牌")
    ("호패법"
     "號牌法")
    ("호평"
     "好評")
    ("호헌"
     "護憲")
    ("호혜"
     "互惠")
    ("호혜적"
     "互惠的")
    ("호화"
     "豪華")
    ("호환"
     "互換")
    ("호환성"
     "互換性")
    ("호황"
     "好況")
    ("호황기"
     "好況期")
    ("호흡"
     "呼吸")
    ("호흡계"
     "呼吸計")
    ("호흡기"
     "呼吸器")
    ("호흡법"
     "呼吸法")
    ("호흡수"
     "呼吸數")
    ("호흡증"
     "呼吸症")
    ("혹"
     ("惑" . "미혹할 혹")
     ("或" . "혹 혹")
     ("酷" . "독할 혹")
     ("鵠" . "고니 혹"))
    ("혹독"
     "酷毒")
    ("혹사"
     "酷使")
    ("혹사당"
     "酷使當")
    ("혹서기"
     "酷暑期")
    ("혹성"
     "惑星")
    ("혹세무민"
     "惑世誣民")
    ("혹시"
     "或是")
    ("혹심"
     "酷甚")
    ("혹여"
     "或如")
    ("혹자"
     "或者")
    ("혹평"
     "酷評")
    ("혹평가"
     "酷評家")
    ("혹한"
     "酷寒")
    ("혼"
     ("婚" . "혼인할 혼")
     ("昏" . "어두울 혼")
     ("混" . "섞을 혼")
     ("渾" . "흐릴 혼")
     "煇"
     "琿"
     ("魂" . "넋 혼")
     ("圂" . "뒷간 혼")
     ("惛" . "흐릴 혼")
     "湣"
     ("溷" . "어지러울 혼")
     ("焜" . "빛날 혼")
     "睨"
     ("閽" . "문지기 혼"))
    ("혼곤"
     "昏困")
    ("혼구"
     "昏衢")
    ("혼기"
     "婚期")
    ("혼담"
     "婚談")
    ("혼돈"
     "混沌")
    ("혼동"
     "混同")
    ("혼란"
     "混亂")
    ("혼란기"
     "混亂期")
    ("혼란상"
     "混亂相")
    ("혼령"
     "魂靈")
    ("혼례"
     "婚禮")
    ("혼례식"
     "婚禮式")
    ("혼미"
     "昏迷")
    ("혼방"
     "混紡")
    ("혼백"
     "魂魄")
    ("혼복"
     "混複")
    ("혼비백산"
     "魂飛魄散")
    ("혼사"
     "婚事")
    ("혼색"
     "混色")
    ("혼생"
     "混生")
    ("혼서장"
     "婚書狀")
    ("혼선"
     "混線")
    ("혼성"
     "混成"
     "混聲")
    ("혼성군"
     "混成群")
    ("혼성림"
     "混成林")
    ("혼수"
     "婚需")
    ("혼수비"
     "婚需費")
    ("혼수상태"
     "昏睡狀態")
    ("혼수품"
     "婚需品")
    ("혼숫"
     "婚需")
    ("혼식"
     "混食")
    ("혼신"
     "渾身"
     "魂神")
    ("혼약"
     "婚約")
    ("혼약금"
     "婚約金")
    ("혼연일체"
     "渾然一體")
    ("혼외"
     "婚外")
    ("혼용"
     "混用")
    ("혼융"
     "混融")
    ("혼인"
     "婚姻")
    ("혼인식"
     "婚姻式")
    ("혼잡"
     "混雜")
    ("혼재"
     "婚材")
    ("혼전"
     "婚前"
     "混戰")
    ("혼절"
     "昏絶")
    ("혼조"
     "混調")
    ("혼종어"
     "混種語")
    ("혼처"
     "婚處")
    ("혼천의"
     "渾天儀")
    ("혼탁"
     "混濁")
    ("혼탁상"
     "混濁狀")
    ("혼합"
     "混合")
    ("혼합반"
     "混合班")
    ("혼합적"
     "混合的")
    ("혼혈"
     "混血")
    ("혼혈아"
     "混血兒")
    ("혼효림"
     "混淆林")
    ("홀"
     ("忽" . "소흘히 할 홀")
     ("惚" . "황홀할 홀")
     ("笏" . "홀 홀")
     ("囫" . "온전할 홀"))
    ("홀대"
     "忽待")
    ("홀연"
     "忽然")
    ("홍"
     ("哄" . "떠들썩할 홍")
     ("弘" . "넓을 홍")
     ("汞" . "수은 홍")
     ("泓" . "깊을 홍")
     ("洪" . "큰물 홍")
     ("烘" . "횃불 홍")
     ("紅" . "붉을 홍")
     ("虹" . "무지개 홍")
     ("訌" . "무너질 홍")
     ("鴻" . "큰 기러기 홍")
     ("晎" . "날 밝으려 할 홍")
     ("澒" . "수은 홍")
     ("篊" . "홈통 홍")
     ("鉷" . "돌쇠뇌 홍")
     ("鬨" . "싸울 홍"))
    ("홍당"
     "紅唐")
    ("홍라"
     "紅羅")
    ("홍류"
     "紅柳")
    ("홍류석"
     "紅榴石")
    ("홍반"
     "紅斑")
    ("홍백색"
     "紅白色")
    ("홍보"
     "弘報")
    ("홍보과"
     "弘報課")
    ("홍보물"
     "弘報物")
    ("홍보비"
     "弘報費")
    ("홍보성"
     "弘報性")
    ("홍보실"
     "弘報室")
    ("홍보실장"
     "弘報室長")
    ("홍보전"
     "弘報戰")
    ("홍보지"
     "弘報紙")
    ("홍보처"
     "弘報處")
    ("홍보판"
     "弘報版")
    ("홍복"
     "洪福")
    ("홍색"
     "紅色")
    ("홍수"
     "洪水")
    ("홍수림"
     "紅樹林")
    ("홍안"
     "紅顔")
    ("홍어"
     "洪魚")
    ("홍역"
     "紅疫")
    ("홍예"
     "虹霓")
    ("홍의"
     "紅衣")
    ("홍익"
     "弘益")
    ("홍익인간"
     "弘益人間")
    ("홍전"
     "紅典")
    ("홍조"
     "紅潮")
    ("홍차"
     "紅茶")
    ("홍합"
     "紅蛤")
    ("화"
     ("化" . "될 화")
     ("和" . "화할 화")
     ("嬅" . "여자 이름 화")
     "樗"
     ("樺" . "자작나무 화")
     ("火" . "불 화")
     ("畵" . "그림 화")
     ("禍" . "재화 화")
     ("禾" . "벼 화")
     ("花" . "꽃 화")
     ("華" . "꽃 화")
     ("話" . "말할 화")
     ("譁" . "시끄러울 화")
     ("貨" . "재화 화")
     ("靴" . "신 화")
     ("俰" . "화할 화")
     ("嘩" . "譁와 同字")
     "夥"
     ("婲" . "예쁠 화")
     ("畫" . "그림 화")
     ("驊" . "준마 화")
     ("龢" . "풍류 조화될 화"))
    ("화가"
     "畵家")
    ("화강"
     "花崗")
    ("화강석"
     "花崗石")
    ("화강암"
     "花崗巖")
    ("화공"
     "化工")
    ("화공학"
     "化工學")
    ("화관무"
     "花冠舞")
    ("화교과"
     "化敎科")
    ("화구"
     "火口")
    ("화구호"
     "火口湖")
    ("화근"
     "禍根")
    ("화급"
     "火急")
    ("화기"
     "和氣"
     "火氣"
     "禍機")
    ("화기애애"
     "和氣靄靄")
    ("화농"
     "化膿")
    ("화단"
     "畵壇"
     "花壇")
    ("화답"
     "和答")
    ("화동"
     "和同")
    ("화두"
     "話頭")
    ("화두선"
     "話頭禪")
    ("화등잔"
     "火燈盞")
    ("화랑"
     "畵廊")
    ("화랑가"
     "畵廊街")
    ("화랑도"
     "花郞道")
    ("화려"
     "華麗")
    ("화려체"
     "華麗體")
    ("화력"
     "火力")
    ("화로"
     "火爐")
    ("화롯"
     "火爐")
    ("화류계"
     "花柳界")
    ("화류회"
     "花柳會")
    ("화마"
     "火魔")
    ("화면"
     "畵面")
    ("화목"
     "和睦")
    ("화문석"
     "花紋席")
    ("화물"
     "貨物")
    ("화물기"
     "貨物機")
    ("화물선"
     "貨物船")
    ("화물차"
     "貨物車")
    ("화물창"
     "貨物艙")
    ("화방주"
     "花紡紬")
    ("화백"
     "畵伯")
    ("화법"
     "話法")
    ("화병"
     "花甁")
    ("화보"
     "畵報")
    ("화보집"
     "畵報集")
    ("화복"
     "禍福")
    ("화북"
     "華北")
    ("화분"
     "花盆")
    ("화사"
     "花蛇"
     "華奢")
    ("화산"
     "火山")
    ("화산도"
     "火山島")
    ("화상"
     "火傷"
     "畵像"
     "畵商"
     "畵想")
    ("화생"
     "化生")
    ("화생방"
     "化生放")
    ("화서"
     "花序")
    ("화석"
     "化石")
    ("화석화"
     "化石化")
    ("화선지"
     "畵宣紙")
    ("화성"
     "火星")
    ("화소"
     "畵素")
    ("화순"
     "和順")
    ("화술"
     "話術")
    ("화술극"
     "話術劇")
    ("화식"
     "貨殖")
    ("화신"
     "化身")
    ("화실"
     "畵室")
    ("화약"
     "火藥")
    ("화약품"
     "火藥品")
    ("화엄경"
     "華嚴經")
    ("화엄적"
     "華嚴的")
    ("화엄학"
     "華嚴學")
    ("화업"
     "畵業")
    ("화염"
     "火焰")
    ("화염병"
     "火焰甁")
    ("화요일"
     "火曜日")
    ("화우"
     "畵友")
    ("화원"
     "花園"
     "花宛")
    ("화음"
     "和音")
    ("화의"
     "和議")
    ("화인"
     "火因")
    ("화자"
     "話者")
    ("화장"
     "化粧"
     "火葬")
    ("화장기"
     "化粧氣")
    ("화장대"
     "化粧臺")
    ("화장법"
     "化粧法")
    ("화장비"
     "化粧費")
    ("화장수"
     "化粧水")
    ("화장술"
     "化粧術")
    ("화장실"
     "化粧室")
    ("화장지"
     "化粧紙")
    ("화장품"
     "化粧品")
    ("화장품점"
     "化粧品店")
    ("화재"
     "火災")
    ("화재경보기"
     "火災警報器")
    ("화쟁"
     "和諍")
    ("화적패"
     "火賊牌")
    ("화전"
     "靴典")
    ("화전민"
     "火田民")
    ("화제"
     "畵題"
     "話題")
    ("화제성"
     "話題性")
    ("화제작"
     "話題作")
    ("화젯"
     "話題")
    ("화조화"
     "花鳥畵")
    ("화질"
     "畵質")
    ("화집"
     "畵集")
    ("화창"
     "和暢")
    ("화채"
     "花菜")
    ("화첩"
     "畵帖")
    ("화초"
     "花草")
    ("화초원"
     "花草園")
    ("화친"
     "和親")
    ("화투"
     "花鬪")
    ("화투장"
     "花鬪張")
    ("화평"
     "和平")
    ("화폐"
     "貨幣")
    ("화포"
     "火砲")
    ("화폭"
     "畵幅")
    ("화풍"
     "火風"
     "畵風")
    ("화학"
     "化學")
    ("화학과"
     "化學科")
    ("화학식"
     "化學式")
    ("화학업계"
     "化學業界")
    ("화학자"
     "化學者")
    ("화학적"
     "化學的")
    ("화학조미료"
     "化學調味料")
    ("화합"
     "和合")
    ("화합물"
     "化合物")
    ("화해"
     "和解"
     "和諧")
    ("화형"
     "火刑")
    ("화형당"
     "火刑當")
    ("화환"
     "花環")
    ("화훼"
     "花卉")
    ("확"
     ("擴" . "넓힐 확")
     ("攫" . "붙잡을 확")
     "濩"
     ("確" . "굳을 확")
     ("碻" . "굳을 확")
     ("穫" . "벼 벨 확")
     ("廓" . "둘레 확")
     "擭"
     "涸"
     ("矍" . "두리번거릴 확")
     "确"
     ("鑊" . "가마 확"))
    ("확고"
     "確固")
    ("확고부동"
     "確固不動")
    ("확답"
     "確答")
    ("확대"
     "擴大"
     "廓大")
    ("확대안"
     "擴大案")
    ("확대일로"
     "擴大一路")
    ("확률"
     "確率")
    ("확률적"
     "確率的")
    ("확립"
     "確立")
    ("확립기"
     "確立期")
    ("확보"
     "確保")
    ("확산"
     "擴散")
    ("확산성"
     "擴散性")
    ("확산적"
     "擴散的")
    ("확성"
     "擴聲")
    ("확성기"
     "擴聲器")
    ("확신"
     "確信")
    ("확신감"
     "確信感")
    ("확신범"
     "確信犯")
    ("확실"
     "確實")
    ("확실성"
     "確實性")
    ("확실시"
     "確實視")
    ("확약"
     "確約")
    ("확언"
     "確言")
    ("확연"
     "確然")
    ("확인"
     "確認")
    ("확인서"
     "確認書")
    ("확인제"
     "確認制")
    ("확장"
     "擴張")
    ("확장명"
     "擴張名")
    ("확장법"
     "擴張法")
    ("확장성"
     "擴張性")
    ("확정"
     "確定")
    ("확정설"
     "確定說")
    ("확정안"
     "確定案")
    ("확정적"
     "確定的")
    ("확증"
     "確證")
    ("확충"
     "擴充")
    ("확충비"
     "擴充費")
    ("확충안"
     "擴充案")
    ("환"
     ("丸" . "알 환")
     ("喚" . "부를 환")
     ("奐" . "빛날 환")
     ("宦" . "벼슬 환")
     ("幻" . "변할 환")
     ("患" . "근심 환")
     ("換" . "바꿀 환")
     ("晥" . "환할 환")
     ("桓" . "푯말 환")
     ("歡" . "기뻐할 환")
     ("渙" . "흩어질 환")
     ("煥" . "불꽃 환")
     ("環" . "고리 환")
     ("紈" . "흰 비단 환")
     ("還" . "돌아올 환")
     ("驩" . "기뻐할 환")
     ("鰥" . "환어 환")
     ("圜" . "두를 환")
     "垸"
     ("寰" . "기내 환")
     ("懽" . "기뻐할 환")
     ("擐" . "입을 환")
     ("瓛" . "옥홀 환")
     ("皖" . "샛별 환")
     ("睆" . "가득 차 있는 모양 환")
     ("絙" . "끈목 환")
     "繯"
     ("豢" . "기를 환")
     ("轘" . "환형 환")
     ("鍰" . "무게 단위 환")
     ("鐶" . "고리 환")
     ("鬟" . "쪽찐 머리 환"))
    ("환각"
     "幻覺")
    ("환각성"
     "幻覺性")
    ("환각적"
     "幻覺的")
    ("환각제"
     "幻覺劑")
    ("환갑"
     "還甲")
    ("환갑일"
     "還甲日")
    ("환경"
     "環境")
    ("환경관"
     "環境觀")
    ("환경권"
     "環境權")
    ("환경비"
     "環境費")
    ("환경성"
     "環境性")
    ("환경오염"
     "環境汚染")
    ("환경적"
     "環境的")
    ("환경조건"
     "環境條件")
    ("환골탈태"
     "換骨奪胎")
    ("환관"
     "宦官")
    ("환국"
     "還國")
    ("환기"
     "喚起"
     "換氣")
    ("환기통"
     "換氣筒")
    ("환난"
     "患難")
    ("환난상휼"
     "患難相恤")
    ("환담"
     "歡談")
    ("환대"
     "歡待")
    ("환등기"
     "幻燈機")
    ("환락"
     "歡樂")
    ("환로"
     "宦路")
    ("환매"
     "還買")
    ("환멸"
     "幻滅")
    ("환멸감"
     "幻滅感")
    ("환부"
     "患部")
    ("환산"
     "換算")
    ("환상"
     "幻想")
    ("환상적"
     "幻想的")
    ("환상주의"
     "幻想主義")
    ("환생"
     "幻生"
     "還生")
    ("환성"
     "喚聲"
     "歡聲")
    ("환속"
     "還俗")
    ("환송"
     "歡送")
    ("환송심"
     "還訟審")
    ("환수"
     "還收")
    ("환승역"
     "換乘驛")
    ("환시"
     "幻視")
    ("환심"
     "歡心")
    ("환영"
     "幻影"
     "歡迎")
    ("환영식"
     "歡迎式")
    ("환영식장"
     "歡迎式場")
    ("환영회"
     "歡迎會")
    ("환원"
     "還元")
    ("환원론"
     "還元論")
    ("환원론자"
     "還元論者")
    ("환원론적"
     "還元論的")
    ("환원성"
     "還元性")
    ("환원주의"
     "還元主義")
    ("환유법"
     "換喩法")
    ("환율"
     "換率")
    ("환율제"
     "換率制")
    ("환자"
     "患者")
    ("환자병"
     "患者兵")
    ("환자복"
     "患者服")
    ("환자촌"
     "患者村")
    ("환장"
     "換腸")
    ("환전"
     "換錢")
    ("환절기"
     "換節期")
    ("환차익"
     "換差益")
    ("환청"
     "幻聽")
    ("환형"
     "換刑")
    ("환호"
     "歡呼")
    ("환호성"
     "歡呼聲")
    ("환희"
     "歡喜")
    ("활"
     ("活" . "살 활")
     ("滑" . "미끄러울 활")
     ("猾" . "교활할 활")
     ("豁" . "뚫린 골 활")
     ("闊" . "트일 활")
     "佸"
     ("蛞" . "괄태충 활"))
    ("활공"
     "滑空")
    ("활공비"
     "滑空比")
    ("활기"
     "活氣")
    ("활달"
     "豁達")
    ("활동"
     "活動")
    ("활동가"
     "活動家")
    ("활동감"
     "活動感")
    ("활동량"
     "活動量")
    ("활동력"
     "活動力")
    ("활동비"
     "活動費")
    ("활동상"
     "活動狀")
    ("활동성"
     "活動性")
    ("활동장"
     "活動場")
    ("활동적"
     "活動的")
    ("활력"
     "活力")
    ("활력소"
     "活力素")
    ("활력적"
     "活力的")
    ("활로"
     "活路")
    ("활발"
     "活潑")
    ("활보"
     "闊步")
    ("활성"
     "活性")
    ("활성탄"
     "活性炭")
    ("활성화"
     "活性化")
    ("활약"
     "活躍")
    ("활약상"
     "活躍狀")
    ("활연"
     "豁然")
    ("활엽"
     "闊葉")
    ("활엽수"
     "闊葉樹")
    ("활엽수림"
     "闊葉樹林")
    ("활용"
     "活用")
    ("활용기"
     "活用記")
    ("활용도"
     "活用度")
    ("활용적"
     "活用的")
    ("활인"
     "活人")
    ("활인심방"
     "活人心方")
    ("활자"
     "活字")
    ("활자화"
     "活字化")
    ("활주"
     "滑走")
    ("활주로"
     "滑走路")
    ("활판"
     "活版")
    ("활화산"
     "活火山")
    ("활황"
     "活況")
    ("황"
     ("凰" . "봉황새 황")
     ("幌" . "휘장 황")
     ("徨" . "노닐 황")
     ("恍" . "황홀할 황")
     ("惶" . "두려워할 황")
     ("愰" . "밝을 황")
     ("慌" . "어렴풋할 황")
     ("晃" . "밝을 황")
     ("晄" . "晃과 同字")
     ("榥" . "책상 황")
     ("況" . "하물며 황")
     ("湟" . "해자 황")
     ("滉" . "물 깊고 넓을 황")
     ("潢" . "웅덩이 황")
     ("煌" . "빛날 황")
     ("璜" . "서옥 황")
     ("皇" . "임금 황")
     ("篁" . "대숲 황")
     ("簧" . "혀 황")
     ("荒" . "거칠 황")
     ("蝗" . "누리 황")
     ("遑" . "허둥거릴 황")
     ("隍" . "해자 황")
     ("黃" . "누를 황")
     ("喤" . "어린아이 울음 황")
     ("媓" . "어머니 황")
     ("怳" . "멍할 황")
     "熀"
     ("瑝" . "옥 소리 황")
     ("肓" . "명치 끝 황")
     ("貺" . "줄 황")
     ("鎤" . "종소리 황"))
    ("황갈색"
     "黃褐色")
    ("황공"
     "惶恐")
    ("황구"
     "黃狗")
    ("황국"
     "黃菊")
    ("황군"
     "皇軍")
    ("황궁"
     "皇宮")
    ("황금"
     "黃芩"
     "黃金")
    ("황금기"
     "黃金期")
    ("황금색"
     "黃金色")
    ("황금시대"
     "黃金時代")
    ("황급"
     "遑急")
    ("황기"
     "黃耆")
    ("황달"
     "黃疸")
    ("황당"
     "荒唐")
    ("황당무계"
     "荒唐無稽")
    ("황량"
     "荒凉")
    ("황련"
     "黃連")
    ("황록색"
     "黃綠色")
    ("황마"
     "黃麻")
    ("황막"
     "荒漠")
    ("황망"
     "慌忙")
    ("황매화"
     "黃梅花")
    ("황무지"
     "荒蕪地")
    ("황백색"
     "黃白色")
    ("황사"
     "黃沙")
    ("황산화물"
     "黃酸化物")
    ("황색"
     "黃色")
    ("황색경보"
     "黃色警報")
    ("황설탕"
     "黃雪糖")
    ("황성"
     "荒城")
    ("황소좌"
     "黃-座")
    ("황송"
     "惶悚")
    ("황실"
     "皇室")
    ("황야"
     "荒野")
    ("황열"
     "黃熱")
    ("황우"
     "黃牛")
    ("황저"
     "黃苧")
    ("황제"
     "皇帝")
    ("황천"
     "荒天"
     "黃泉")
    ("황태자"
     "皇太子")
    ("황토"
     "荒土"
     "黃土")
    ("황폐"
     "荒廢")
    ("황폐성"
     "荒廢性")
    ("황폐화"
     "荒廢化")
    ("황혼"
     "黃昏")
    ("황혼기"
     "黃昏期")
    ("황홀"
     "恍惚")
    ("황홀경"
     "恍惚境")
    ("황화"
     "黃禍")
    ("황화론"
     "黃禍論")
    ("황황"
     "遑遑")
    ("황후"
     "皇后")
    ("홰"
     "罫")
    ("회"
     ("匯" . "물돌 회")
     ("回" . "돌 회")
     ("廻" . "돌 회")
     ("徊" . "노닐 회")
     ("恢" . "넓을 회")
     ("悔" . "뉘우칠 회")
     ("懷" . "품을 회")
     ("晦" . "그믐 회")
     ("會" . "모일 회")
     ("檜" . "노송나무 회")
     ("淮" . "강 이름 회")
     ("澮" . "봇도랑 회")
     "濊"
     ("灰" . "재 회")
     ("獪" . "교활할 회")
     ("繪" . "그림 회")
     ("膾" . "회 회")
     ("茴" . "회향풀 회")
     ("蛔" . "거위 회")
     ("誨" . "가르칠 회")
     ("賄" . "뇌물 회")
     ("佪" . "어정거릴 회")
     ("栃" . "상수리나무 회")
     "沬"
     ("洄" . "거슬러 올라 갈 회")
     ("滙" . "匯와 同字")
     "燹"
     ("盔" . "바리 회")
     "繢"
     ("詼" . "조롱할 회")
     ("迴" . "回와 同字")
     "闠"
     ("頮" . "세수할 회")
     ("鱠" . "회 회"))
    ("회갈색"
     "灰褐色")
    ("회갑"
     "回甲")
    ("회갑연회장"
     "回甲宴會場")
    ("회개"
     "悔改")
    ("회견"
     "會見")
    ("회견문"
     "會見文")
    ("회견장"
     "會見場")
    ("회계"
     "會計")
    ("회계사"
     "會計士")
    ("회계학과"
     "會計學科")
    ("회고"
     "回顧")
    ("회고담"
     "回顧談")
    ("회고록"
     "回顧錄")
    ("회관"
     "會館")
    ("회교"
     "回敎")
    ("회교도"
     "回敎徒")
    ("회구성"
     "懷舊性")
    ("회군"
     "回軍")
    ("회귀"
     "回歸")
    ("회귀점"
     "回歸點")
    ("회귀처"
     "回歸處")
    ("회기"
     "會期")
    ("회담"
     "會談")
    ("회담장"
     "會談場")
    ("회동"
     "會同")
    ("회랑"
     "回廊")
    ("회로"
     "回路")
    ("회룡"
     "回龍")
    ("회룡고조"
     "回龍顧祖")
    ("회말"
     "回末")
    ("회백색"
     "灰白色")
    ("회벽"
     "灰壁")
    ("회보"
     "會報")
    ("회복"
     "回復")
    ("회복세"
     "回復勢")
    ("회복식"
     "回復式")
    ("회복제"
     "回復劑")
    ("회부"
     "回附")
    ("회분"
     "灰分")
    ("회비"
     "會費")
    ("회사"
     "會社")
    ("회사명"
     "會社名")
    ("회사원"
     "會社員")
    ("회사채"
     "會社債")
    ("회상"
     "回想")
    ("회상록"
     "回想錄")
    ("회색"
     "灰色")
    ("회색분자"
     "灰色分子")
    ("회색적"
     "灰色的")
    ("회생"
     "回生")
    ("회선"
     "回線")
    ("회수"
     "回收")
    ("회수금"
     "回收金")
    ("회수율"
     "回收率")
    ("회식"
     "會食")
    ("회식자"
     "會食者")
    ("회신"
     "回信")
    ("회심"
     "回心"
     "會心")
    ("회억"
     "回憶")
    ("회오"
     "悔悟")
    ("회원"
     "會員")
    ("회원국"
     "會員國")
    ("회원권"
     "會員券")
    ("회원사"
     "會員社")
    ("회원전"
     "會員展")
    ("회원제"
     "會員制")
    ("회유"
     "回遊"
     "懷柔")
    ("회의"
     "懷疑"
     "會議")
    ("회의감"
     "懷疑感")
    ("회의록"
     "會議錄")
    ("회의소"
     "會議所")
    ("회의실"
     "會議室")
    ("회의장"
     "會議場")
    ("회의적"
     "懷疑的")
    ("회의주의"
     "懷疑主義")
    ("회의주의자"
     "懷疑主義者")
    ("회의체"
     "會議體")
    ("회자"
     "膾炙")
    ("회장"
     "回裝"
     "會場"
     "會長")
    ("회장단"
     "會長團")
    ("회장선"
     "回裝線")
    ("회장실"
     "會長室")
    ("회장직"
     "會長職")
    ("회전"
     "回戰"
     "回轉")
    ("회전수"
     "回轉數")
    ("회전식"
     "回轉式")
    ("회전율"
     "回轉率")
    ("회전의"
     "回轉儀")
    ("회전의자"
     "回轉椅子")
    ("회전자"
     "回轉子")
    ("회전축"
     "回轉軸")
    ("회진"
     "回診")
    ("회춘"
     "回春")
    ("회충"
     "蛔蟲")
    ("회칠"
     "灰漆")
    ("회통"
     "回通"
     "會通")
    ("회통적"
     "回通的")
    ("회포"
     "懷抱")
    ("회피"
     "回避")
    ("회한"
     "悔恨")
    ("회합"
     "會合")
    ("회혼례"
     "回婚禮")
    ("회화"
     "會話"
     "繪畵")
    ("회화과"
     "繪畵科")
    ("회화관"
     "繪畵館")
    ("회화론"
     "繪畵論")
    ("회화사"
     "繪畵史")
    ("회화적"
     "繪畵的")
    ("회화전"
     "繪畵展")
    ("회흑갈색"
     "灰黑褐色")
    ("획"
     ("劃" . "쪼갤 획")
     ("獲" . "얻을 획")
     ("畵" . "畫의 俗字")
     "硅"
     ("嚄" . "외칠 획")
     "擭"
     ("畫" . "그을 획"))
    ("획기적"
     "劃期的")
    ("획득"
     "獲得")
    ("획연"
     "劃然")
    ("획일"
     "劃一")
    ("획일성"
     "劃一性")
    ("획일적"
     "劃一的")
    ("획일주의"
     "劃一主義")
    ("획일화"
     "劃一化")
    ("획정"
     "劃定")
    ("획책"
     "劃策")
    ("횟수"
     "回數")
    ("횡"
     ("宖" . "집 울릴 횡")
     ("橫" . "가로 횡")
     ("薨" . "많을 횡")
     ("鐄" . "종 횡")
     ("澋" . "물이 빙 돌 횡")
     ("鈜" . "쇳소리 횡")
     ("黌" . "글방 횡"))
    ("횡격막"
     "橫膈膜")
    ("횡단"
     "橫斷")
    ("횡단기"
     "橫斷記")
    ("횡단보도"
     "橫斷步道")
    ("횡대"
     "橫帶")
    ("횡령"
     "橫領")
    ("횡선"
     "橫線")
    ("횡설수설"
     "橫說竪說")
    ("횡압력"
     "橫壓力")
    ("횡재"
     "橫財")
    ("횡파"
     "橫波")
    ("횡포"
     "橫暴")
    ("횡행"
     "橫行")
    ("효"
     ("哮" . "으르렁거릴 효")
     ("嚆" . "울릴 효")
     ("孝" . "효도 효")
     ("效" . "본받을 효")
     ("斅" . "가르칠 효")
     ("曉" . "새벽 효")
     ("梟" . "올배미 효")
     ("涍" . "성 효")
     ("淆" . "뒤섞일 효")
     ("爻" . "효 효")
     ("肴" . "안주 효")
     ("驍" . "날랠 효")
     ("傚" . "본받을 효")
     "嘐"
     ("囂" . "시끄럽다 효")
     ("崤" . "산 이름 효")
     ("殽" . "섞일 효")
     ("熇" . "불김 효")
     ("皛" . "나타날 효")
     ("虓" . "울부짖을 효")
     ("餚" . "반찬 효"))
    ("효과"
     "效果")
    ("효과음"
     "效果音")
    ("효과적"
     "效果的")
    ("효녀"
     "孝女")
    ("효능"
     "效能")
    ("효도"
     "孝道")
    ("효력"
     "效力")
    ("효모"
     "酵母")
    ("효부"
     "孝夫")
    ("효부상"
     "孝婦賞")
    ("효성"
     "孝誠")
    ("효성심"
     "孝誠心")
    ("효소"
     "酵素")
    ("효시"
     "嚆矢")
    ("효심"
     "孝心")
    ("효용"
     "效用")
    ("효용성"
     "效用性")
    ("효우"
     "孝友")
    ("효율"
     "效率")
    ("효율성"
     "效率性")
    ("효율적"
     "效率的")
    ("효율화"
     "效率化")
    ("효익"
     "效益")
    ("효자"
     "孝子")
    ("효자상"
     "孝子賞")
    ("효행"
     "孝行")
    ("효험"
     "效驗")
    ("후"
     ("侯" . "과녁 후")
     ("候" . "물을 후")
     ("厚" . "두터울 후")
     ("后" . "임금 후")
     ("吼" . "울 후")
     ("喉" . "목구멍 후")
     ("嗅" . "맡을 후")
     ("帿" . "과녁 후")
     ("後" . "뒤 후")
     ("朽" . "섞을 후")
     ("煦" . "따뜻하게 할 후")
     ("珝" . "옥 이름 후")
     ("逅" . "만날 후")
     "佝"
     ("喣" . "불 후")
     ("垕" . "厚의 古字")
     ("堠" . "봉화대 후")
     ("猴" . "원숭이 후")
     ("篌" . "공후 후")
     ("詡" . "자랑할 후")
     "詬"
     ("譃" . "망녕된 말 후")
     ("酗" . "주정할 후")
     ("餱" . "건량 후"))
    ("후각"
     "嗅覺")
    ("후견인"
     "後見人")
    ("후계"
     "後繼")
    ("후계자"
     "後繼者")
    ("후광"
     "後光")
    ("후궁"
     "後宮")
    ("후기"
     "後期"
     "後記")
    ("후기대"
     "後期大")
    ("후기대반"
     "後期大班")
    ("후기용"
     "後期用")
    ("후기작"
     "後期作")
    ("후납"
     "後納")
    ("후대"
     "後代")
    ("후덕"
     "厚德")
    ("후두"
     "喉頭")
    ("후두부"
     "後頭部")
    ("후두염"
     "喉頭炎")
    ("후렴"
     "後斂")
    ("후만증"
     "後彎症")
    ("후문"
     "後聞"
     "後門")
    ("후미"
     "後尾")
    ("후반"
     "後半")
    ("후반기"
     "後半期")
    ("후반부"
     "後半部")
    ("후반전"
     "後半戰")
    ("후발"
     "後發")
    ("후방"
     "後方")
    ("후배"
     "後輩")
    ("후보"
     "候補")
    ("후보생"
     "候補生")
    ("후보안"
     "候補案")
    ("후보자"
     "候補者")
    ("후보지"
     "候補地")
    ("후불제"
     "後佛制")
    ("후삼국"
     "後三國")
    ("후생"
     "厚生"
     "後生")
    ("후세"
     "後世")
    ("후세대"
     "後世代")
    ("후세인"
     "後世人")
    ("후속"
     "後續")
    ("후손"
     "後孫")
    ("후송"
     "後送")
    ("후술"
     "後述")
    ("후식"
     "後食")
    ("후실"
     "後室")
    ("후예"
     "後裔")
    ("후원"
     "後園"
     "後援")
    ("후원금"
     "後援金")
    ("후원자"
     "後援者")
    ("후원회"
     "後援會")
    ("후유증"
     "後遺症")
    ("후의"
     "厚意")
    ("후일"
     "後日")
    ("후일담"
     "後日談")
    ("후임"
     "後任")
    ("후임자"
     "後任者")
    ("후자"
     "後者")
    ("후작"
     "侯爵")
    ("후장"
     "後場")
    ("후지원"
     "後支援")
    ("후진"
     "後進")
    ("후진국"
     "後進國")
    ("후진성"
     "後進性")
    ("후진적"
     "後進的")
    ("후창"
     "後唱")
    ("후처리"
     "後處理")
    ("후천"
     "後天")
    ("후천성"
     "後天性")
    ("후천적"
     "後天的")
    ("후퇴"
     "後退")
    ("후편"
     "後篇")
    ("후학"
     "後學")
    ("후협상"
     "後協商")
    ("후환"
     "後患")
    ("후회"
     "後悔")
    ("후회막급"
     "後悔莫及")
    ("후후"
     "煦煦")
    ("후희"
     "後戱")
    ("훈"
     ("勛" . "勳의 古字")
     ("勳" . "공 훈")
     ("塤" . "壎과 同字")
     ("壎" . "진나팔 훈")
     ("暈" . "무리 훈")
     ("焄" . "연기에 그을릴 훈")
     ("熏" . "연기 낄 훈")
     ("燻" . "연기 낄 훈")
     ("薰" . "향불 훈")
     ("訓" . "가르칠 훈")
     ("曛" . "삭양 빛 훈")
     ("爋" . "불에 말릴 훈")
     ("獯" . "오랑캐 이름 훈")
     ("纁" . "분홍빛 훈")
     ("葷" . "매운 채소 훈")
     ("鑂" . "금빛 투색할 훈"))
    ("훈계"
     "訓戒")
    ("훈기"
     "薰氣")
    ("훈련"
     "訓練"
     "訓鍊")
    ("훈련법"
     "訓練法")
    ("훈련병"
     "訓鍊兵")
    ("훈련생"
     "訓鍊生")
    ("훈련소"
     "訓鍊所")
    ("훈련장"
     "訓鍊場")
    ("훈령"
     "訓令")
    ("훈병"
     "訓兵")
    ("훈시"
     "訓示")
    ("훈육"
     "訓育")
    ("훈육관"
     "訓育官")
    ("훈장"
     "勳章"
     "訓長")
    ("훈제"
     "燻製")
    ("훈증"
     "燻蒸")
    ("훈풍"
     "薰風")
    ("훈화"
     "訓話")
    ("훈훈"
     "薰薰")
    ("훌"
     ("欻" . "문득 훌"))
    ("훙"
     ("薨" . "죽을 훙"))
    ("훤"
     ("喧" . "의젓할 훤")
     ("暄" . "따뜻할 훤")
     ("煊" . "따뜻할 훤")
     ("萱" . "원추리 훤")
     ("烜" . "마를 훤")
     ("諠" . "잊을 훤")
     ("諼" . "속일 훤"))
    ("훤소"
     "喧騷")
    ("훼"
     ("卉" . "풀 훼")
     ("喙" . "부리 훼")
     ("毁" . "毀의 俗字")
     ("燬" . "불 훼")
     ("芔" . "풀 훼")
     ("虫" . "벌레 훼")
     ("虺" . "살무사 훼"))
    ("훼방"
     "毁謗")
    ("훼상"
     "毁傷")
    ("훼손"
     "毁損")
    ("훼손당"
     "毁損當")
    ("훼손죄"
     "毁損罪")
    ("휘"
     ("彙" . "무리 휘")
     ("徽" . "아름다울 휘")
     ("揮" . "휘두를 휘")
     ("暉" . "빛 휘")
     ("煇" . "빛날 휘")
     "褘"
     ("諱" . "꺼릴 휘")
     ("輝" . "빛날 휘")
     ("麾" . "대장기 휘")
     ("撝" . "찣을 휘")
     ("翬" . "훨훨날 휘"))
    ("휘발유"
     "揮發油")
    ("휘장"
     "徽章"
     "揮帳")
    ("휘하"
     "麾下")
    ("휘호"
     "揮毫")
    ("휘황"
     "輝煌")
    ("휘황찬란"
     "輝煌燦爛")
    ("휴"
     ("休" . "쉴 휴")
     "墮"
     ("携" . "끌 휴, 가질 휴, 떠날 휴, 나눌 휴, 연속할 휴")
     ("烋" . "경사로울 휴")
     ("畦" . "밭두둑 휴")
     ("虧" . "이지러질 휴")
     "亏"
     ("咻" . "떠들 휴")
     ("擕" . "携와 同字")
     "睢"
     ("隳" . "무너뜨릴 휴")
     ("髹" . "옻칠할 휴")
     ("鵂" . "수리부엉이 휴"))
    ("휴가"
     "休暇")
    ("휴가제"
     "休暇制")
    ("휴간"
     "休刊")
    ("휴강"
     "休講")
    ("휴게소"
     "休憩所")
    ("휴게실"
     "休憩室")
    ("휴경"
     "休耕")
    ("휴관"
     "休館")
    ("휴대"
     "携帶")
    ("휴대용"
     "携帶用")
    ("휴대품"
     "携帶品")
    ("휴면"
     "休眠")
    ("휴면기"
     "休眠期")
    ("휴무"
     "休務")
    ("휴무일"
     "休務日")
    ("휴식"
     "休息")
    ("휴식년제"
     "休息年制")
    ("휴식일"
     "休息日")
    ("휴식처"
     "休息處")
    ("휴양"
     "休養")
    ("휴양객"
     "休養客")
    ("휴양림"
     "休養林")
    ("휴양소"
     "休養所")
    ("휴양원"
     "休養院")
    ("휴양지"
     "休養地")
    ("휴업"
     "休業")
    ("휴일"
     "休日")
    ("휴전"
     "休戰")
    ("휴전선"
     "休戰線")
    ("휴지"
     "休紙")
    ("휴지통"
     "休紙桶")
    ("휴직"
     "休職")
    ("휴진"
     "休診")
    ("휴학"
     "休學")
    ("휴한"
     "休閑")
    ("휴한법"
     "休閑法")
    ("휵"
     ("畜" . "기를 휵, 용납할 휵"))
    ("휼"
     ("恤" . "구휼할 휼")
     ("譎" . "속일 휼")
     "鷸"
     "潏")
    ("흉"
     ("兇" . "흉악할 흉")
     ("凶" . "흉할 흉")
     "匈"
     ("洶" . "물살세찰 흉")
     ("胸" . "가슴 흉")
     ("恟" . "두려워할 흉")
     ("胷" . "胸과 同字"))
    ("흉가"
     "凶家")
    ("흉갓"
     "凶家")
    ("흉고"
     "胸高")
    ("흉괘"
     "凶卦")
    ("흉금"
     "胸襟")
    ("흉기"
     "凶器")
    ("흉년"
     "凶年")
    ("흉대"
     "胸帶")
    ("흉몽"
     "凶夢")
    ("흉물"
     "凶物")
    ("흉변"
     "凶變")
    ("흉부외과"
     "胸部外科")
    ("흉상"
     "胸像")
    ("흉악"
     "凶惡")
    ("흉악범"
     "凶惡犯")
    ("흉인"
     "凶人")
    ("흉일"
     "凶日")
    ("흉작"
     "凶作")
    ("흉조"
     "凶兆")
    ("흉추"
     "胸椎")
    ("흉측"
     "凶測")
    ("흉포"
     "凶暴")
    ("흉포화"
     "凶暴化")
    ("흉흉"
     "洶洶")
    ("흑"
     ("黑" . "검을 흑"))
    ("흑갈색"
     "黑褐色")
    ("흑마술"
     "黑魔術")
    ("흑막"
     "黑幕")
    ("흑백"
     "黑白")
    ("흑번"
     "黑番")
    ("흑색"
     "黑色")
    ("흑색선전"
     "黑色宣傳")
    ("흑색선전물"
     "黑色宣傳物")
    ("흑선"
     "黑船")
    ("흑심"
     "黑心")
    ("흑연"
     "黑鉛")
    ("흑운모"
     "黑雲母")
    ("흑인"
     "黑人")
    ("흑인성"
     "黑人性")
    ("흑임자"
     "黑荏子")
    ("흑임자죽"
     "黑荏子粥")
    ("흑자"
     "黑字")
    ("흑자국"
     "黑字國")
    ("흑자색"
     "黑紫色")
    ("흑자액"
     "黑字額")
    ("흑장미"
     "黑薔薇")
    ("흑질백장"
     "黑質白章")
    ("흑체"
     "黑體")
    ("흔"
     ("昕" . "아침 흔")
     ("欣" . "기뻐할 흔")
     ("炘" . "화끈거릴 흔")
     ("痕" . "흉터 흔")
     ("很" . "패려궂을 흔")
     ("忻" . "기뻐할 흔")
     ("掀" . "치켜들 흔")
     ("焮" . "불사를 흔")
     ("訢" . "기뻐할 흔")
     ("釁" . "피바를 흔"))
    ("흔연"
     "欣然")
    ("흔적"
     "痕跡")
    ("흔쾌"
     "欣快")
    ("흘"
     ("吃" . "말더듬을 흘")
     ("屹" . "산 우뚝솟을 흘")
     ("汽" . "汔과 同字")
     ("紇" . "질 낮은 명주실 흘")
     ("訖" . "이를 흘")
     ("仡" . "날랠 흘")
     ("汔" . "거의 흘")
     ("疙" . "쥐부스럼 흘")
     ("迄" . "이를 흘")
     ("齕" . "깨물 흘"))
    ("흠"
     ("欠" . "하품 흠")
     ("欽" . "공경할 흠")
     ("歆" . "받을 흠")
     ("廞" . "진열할 흠"))
    ("흠결"
     "欠缺")
    ("흠모"
     "欽慕")
    ("흠앙"
     "欽仰")
    ("흠절"
     "欠節")
    ("흡"
     ("吸" . "숨 들이쉴 흡")
     ("恰" . "마치 흡")
     "扱"
     ("洽" . "윤태하게 할 흡")
     ("翕" . "합할 흡")
     ("噏" . "숨 들이쉴 흡")
     ("歙" . "줄일 흡")
     ("潝" . "빨리 흐르는 소리 흡")
     ("翖" . "翕과 同字"))
    ("흡사"
     "恰似")
    ("흡수"
     "吸收"
     "吸水")
    ("흡연"
     "吸煙")
    ("흡연가"
     "吸煙家")
    ("흡연실"
     "吸煙室")
    ("흡연율"
     "吸煙率")
    ("흡음식"
     "吸音式")
    ("흡인"
     "吸引")
    ("흡인력"
     "吸引力")
    ("흡인성"
     "吸引性")
    ("흡입"
     "吸入")
    ("흡입력"
     "吸入力")
    ("흡입술"
     "吸入術")
    ("흡입제"
     "吸入劑")
    ("흡족"
     "洽足")
    ("흡혈귀"
     "吸血鬼")
    ("흥"
     ("興" . "일 흥"))
    ("흥국"
     "興國")
    ("흥망"
     "興亡")
    ("흥망성쇠"
     "興亡盛衰")
    ("흥미"
     "興味")
    ("흥미진진"
     "興味津津")
    ("흥밋"
     "興味")
    ("흥분"
     "興奮")
    ("흥불"
     "興佛")
    ("흥신업"
     "興信業")
    ("흥취"
     "興趣")
    ("흥행"
     "興行")
    ("흥행사"
     "興行師")
    ("흥행성"
     "興行性")
    ("흥행작"
     "興行作")
    ("희"
     ("僖" . "기쁠 희")
     ("凞" . "빛날 희")
     ("喜" . "기뻐할 희")
     ("噫" . "탄식할 희")
     ("囍" . "쌍희 희")
     ("姬" . "성 희")
     ("嬉" . "즐길 희")
     ("希" . "바랄 희")
     ("愾" . "한숨 희")
     ("憘" . "憙의 古字")
     ("憙" . "성할 희")
     ("戱" . "戲의 俗字")
     ("晞" . "마를 희")
     ("曦" . "햇빛 희")
     ("熙" . "빛날 희")
     ("熹" . "성할 희")
     ("熺" . "熹와 同字")
     ("犧" . "희생 희")
     ("禧" . "복 희")
     ("稀" . "드물 희")
     ("羲" . "숨 희")
     ("咥" . "허허 웃을 희")
     ("唏" . "슬퍼할 희")
     ("嘻" . "웃을 희")
     ("悕" . "슬퍼할 희")
     ("戲" . "탄식할 희")
     ("暿" . "웃을 희")
     ("欷" . "흐느낄 희")
     ("爔" . "불 희")
     ("豨" . "멧돼지 희")
     ("餼" . "꾸밀 희")
     "黖")
    ("희곡"
     "戱曲")
    ("희곡계"
     "戱曲界")
    ("희곡론"
     "戱曲論")
    ("희곡사"
     "戱曲史")
    ("희구"
     "希求")
    ("희귀"
     "稀貴")
    ("희귀목"
     "稀貴木")
    ("희귀조"
     "稀貴鳥")
    ("희귀종"
     "稀貴種")
    ("희극"
     "喜劇")
    ("희극성"
     "喜劇性")
    ("희극적"
     "喜劇的")
    ("희대"
     "稀代")
    ("희락"
     "喜樂")
    ("희로애락"
     "喜怒哀樂")
    ("희롱"
     "戱弄")
    ("희망"
     "希望")
    ("희망봉"
     "希望峯")
    ("희망자"
     "希望者")
    ("희망적"
     "希望的")
    ("희미"
     "稀微")
    ("희박"
     "稀薄")
    ("희비"
     "喜悲")
    ("희비극"
     "喜悲劇")
    ("희비극적"
     "喜悲劇的")
    ("희사"
     "喜捨")
    ("희색"
     "喜色")
    ("희생"
     "犧牲")
    ("희생당"
     "犧牲當")
    ("희생물"
     "犧牲物")
    ("희생심"
     "犧牲心")
    ("희생양"
     "犧牲羊")
    ("희생자"
     "犧牲者")
    ("희생적"
     "犧牲的")
    ("희생정신"
     "犧牲精神")
    ("희석"
     "稀釋")
    ("희소"
     "稀少")
    ("희수"
     "喜壽")
    ("희열"
     "喜悅")
    ("희열감"
     "喜悅感")
    ("희원"
     "希願")
    ("희한"
     "稀罕")
    ("희화"
     "戱畵")
    ("희화적"
     "戱化的")
    ("희화화"
     "戱畵化")
    ("희희낙락"
     "喜喜樂樂")
    ("히"
     "屎")
    ("힐"
     ("詰" . "물을 힐")
     ("犵" . "오랑캐이름 힐")
     ("纈" . "홀치기염색 힐")
     ("襭" . "옷자락 꽂을 힐")
     ("頡" . "곧은목 힐")
     ("黠" . "약을 힐"))
    ("힐난"
     "詰難")))

;; Local Variables:
;; mode: scheme
;; coding: utf-8
;; End:
