/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.applet;

import com.sun.deploy.config.Config;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.javaws.LaunchDownload;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.ResourceType;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.security.AppPolicy;
import com.sun.jnlp.ClipboardServiceImpl;
import com.sun.jnlp.DownloadServiceImpl;
import com.sun.jnlp.ExtendedServiceImpl;
import com.sun.jnlp.ExtensionInstallerServiceImpl;
import com.sun.jnlp.FileOpenServiceImpl;
import com.sun.jnlp.FileSaveServiceImpl;
import com.sun.jnlp.JNLPClassLoaderIf;
import com.sun.jnlp.PersistenceServiceImpl;
import com.sun.jnlp.PrintServiceImpl;
import com.sun.jnlp.SingleInstanceServiceImpl;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import javax.jnlp.BasicService;
import javax.jnlp.ClipboardService;
import javax.jnlp.DownloadService;
import javax.jnlp.ExtendedService;
import javax.jnlp.ExtensionInstallerService;
import javax.jnlp.FileOpenService;
import javax.jnlp.FileSaveService;
import javax.jnlp.PersistenceService;
import javax.jnlp.PrintService;
import javax.jnlp.SingleInstanceService;
import sun.plugin2.applet.NativeLibraryBundle;
import sun.plugin2.applet.Plugin2BasicService;
import sun.plugin2.applet.Plugin2ClassLoader;

public final class JNLP2ClassLoader
extends Plugin2ClassLoader
implements JNLPClassLoaderIf {
    private LaunchDesc _launchDesc = null;
    private AppPolicy _appPolicy;
    private boolean _initialized = false;
    private ArrayList _jarsInURLClassLoader = new ArrayList();
    private ArrayList _jarsNotInURLClassLoader = new ArrayList();
    private Map libraryNameMap = new HashMap();
    private List nativeLibBundles = Collections.synchronizedList(new ArrayList());
    BasicService _basicService = null;

    protected JNLP2ClassLoader(URL uRL) {
        super(new URL[0], uRL);
        if (DEBUG) {
            Trace.println((String)"JNLP2ClassLoader: cstr ...", (TraceLevel)TraceLevel.BASIC);
        }
    }

    protected void initialize(LaunchDesc launchDesc, AppPolicy appPolicy) {
        if (DEBUG) {
            Trace.println((String)"JNLP2ClassLoader: initialize ...", (TraceLevel)TraceLevel.BASIC);
        }
        this._launchDesc = launchDesc;
        this._appPolicy = appPolicy;
        this._initialized = true;
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc != null) {
            this.sortJarDescriptors(resourcesDesc);
            for (int i = 0; i < this._jarsInURLClassLoader.size(); ++i) {
                JARDesc jARDesc = (JARDesc)this._jarsInURLClassLoader.get(i);
                if (DEBUG) {
                    Trace.println((String)("\t addURL: " + jARDesc.getLocation()), (TraceLevel)TraceLevel.BASIC);
                }
                this.addURL(jARDesc.getLocation());
            }
        }
        if (DEBUG) {
            Trace.println((String)"JNLP2ClassLoader: initialize done", (TraceLevel)TraceLevel.BASIC);
        }
    }

    public URL getResource(final String string) {
        URL uRL = (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() throws SecurityException {
                URL uRL = null;
                for (int i = 0; uRL == null && i < 3; ++i) {
                    uRL = JNLP2ClassLoader.super.getResource(string);
                }
                return uRL;
            }
        });
        return uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String findLibrary(String string) {
        if (!this._initialized) {
            Trace.println((String)("JNLP2ClassLoader.findLibrary: " + string + ": not initialized -> super()"), (TraceLevel)TraceLevel.BASIC);
            return super.findLibrary(string);
        }
        string = Config.getInstance().getLibraryPrefix() + string + Config.getInstance().getLibrarySufix();
        Trace.println((String)("JNLP2ClassLoader.findLibrary: Looking up native library: " + string), (TraceLevel)TraceLevel.BASIC);
        File[] fileArray = this;
        synchronized (this) {
            String string2 = (String)this.libraryNameMap.get(string);
            if (string2 != null) {
                Trace.println((String)("JNLP2ClassLoader.findLibrary: native library found: " + string2), (TraceLevel)TraceLevel.BASIC);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return string2;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            fileArray = LaunchDownload.getNativeDirectories((LaunchDesc)this._launchDesc);
            for (int i = 0; i < fileArray.length; ++i) {
                File file = new File(fileArray[i], string);
                if (!file.exists()) continue;
                try {
                    NativeLibraryBundle nativeLibraryBundle = NativeLibraryBundle.createTemporaryCopy(fileArray[i]);
                    this.nativeLibBundles.add(nativeLibraryBundle);
                    File[] fileArray2 = this;
                    synchronized (this) {
                        nativeLibraryBundle.addNamesToMap(this.libraryNameMap);
                        String string3 = (String)this.libraryNameMap.get(string);
                        Trace.println((String)("JNLP2ClassLoader.findLibrary: native library found: " + string3), (TraceLevel)TraceLevel.BASIC);
                        // ** MonitorExit[var6_9] (shouldn't be in output)
                        return string3;
                    }
                }
                catch (IOException iOException) {
                    Trace.ignoredException((Exception)iOException);
                }
            }
            Trace.println((String)("Native library " + string + " not found"), (TraceLevel)TraceLevel.BASIC);
            return super.findLibrary(string);
        }
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        if (!this._initialized) {
            Trace.println((String)("JNLP2ClassLoader.findClass: " + string + ": not initialized -> super()"), (TraceLevel)TraceLevel.BASIC);
            return super.findClass(string);
        }
        try {
            return this.findClassHelper(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Trace.println((String)("JNLP2ClassLoader.findClass: " + string + ": try again .."), (TraceLevel)TraceLevel.BASIC);
            if (this.checkPackageParts(string)) {
                return this.findClassHelper(string);
            }
            throw classNotFoundException;
        }
    }

    public URL findResource(String string) {
        URL uRL = super.findResource(string);
        if (!this._initialized) {
            Trace.println((String)("JNLP2ClassLoader.findResource: " + string + ": not initialized -> super()"), (TraceLevel)TraceLevel.BASIC);
            return uRL;
        }
        if (uRL == null && this.checkPackageParts(string)) {
            uRL = super.findResource(string);
        }
        return uRL;
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        Trace.println((String)"JNLP2ClassLoader.getPermissions() ..", (TraceLevel)TraceLevel.BASIC);
        PermissionCollection permissionCollection = super.getPermissions(codeSource);
        try {
            this._appPolicy.addPermissions((JNLPClassLoaderIf)this, permissionCollection, codeSource, false);
        }
        catch (ExitException exitException) {
            Trace.println((String)("_appPolicy.addPermissions: " + (Object)((Object)exitException)), (TraceLevel)TraceLevel.BASIC);
            Trace.ignoredException((Exception)((Object)exitException));
        }
        URL uRL = codeSource.getLocation();
        JARDesc jARDesc = this.getJarDescFromURL(uRL);
        if (jARDesc != null) {
            try {
                JarFile jarFile = DownloadEngine.getCachedJarFile((URL)jARDesc.getLocation(), (String)jARDesc.getVersion());
                if (jarFile != null) {
                    String string = jarFile.getName();
                    permissionCollection.add(new FilePermission(string, "read"));
                }
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
        Trace.println((String)"JNLP2ClassLoader.getPermissions() X", (TraceLevel)TraceLevel.BASIC);
        return permissionCollection;
    }

    public LaunchDesc getLaunchDesc() {
        return this._launchDesc;
    }

    public void downloadResource(URL uRL, String string, LaunchDownload.DownloadProgress downloadProgress, boolean bl) throws JNLPException, IOException {
        LaunchDownload.downloadResource((LaunchDesc)this._launchDesc, (URL)uRL, (String)string, (LaunchDownload.DownloadProgress)downloadProgress, (boolean)bl);
    }

    public void downloadParts(String[] stringArray, LaunchDownload.DownloadProgress downloadProgress, boolean bl) throws JNLPException, IOException {
        LaunchDownload.downloadParts((LaunchDesc)this._launchDesc, (String[])stringArray, (LaunchDownload.DownloadProgress)downloadProgress, (boolean)bl);
    }

    public void downloadExtensionParts(URL uRL, String string, String[] stringArray, LaunchDownload.DownloadProgress downloadProgress, boolean bl) throws JNLPException, IOException {
        LaunchDownload.downloadExtensionPart((LaunchDesc)this._launchDesc, (URL)uRL, (String)string, (String[])stringArray, (LaunchDownload.DownloadProgress)downloadProgress, (boolean)bl);
    }

    public void downloadEager(LaunchDownload.DownloadProgress downloadProgress, boolean bl) throws JNLPException, IOException {
        LaunchDownload.downloadEagerorAll((LaunchDesc)this._launchDesc, (boolean)false, (LaunchDownload.DownloadProgress)downloadProgress, (boolean)bl);
    }

    public JARDesc getJarDescFromURL(URL uRL) {
        for (int i = 0; i < this._jarsInURLClassLoader.size(); ++i) {
            JARDesc jARDesc = (JARDesc)this._jarsInURLClassLoader.get(i);
            if (!jARDesc.getLocation().toString().equals(uRL.toString())) continue;
            return jARDesc;
        }
        return null;
    }

    public JarFile getJarFile(URL uRL) throws IOException {
        final JARDesc jARDesc = this.getJarDescFromURL(uRL);
        JarFile jarFile = null;
        if (jARDesc != null) {
            jarFile = (JarFile)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() throws SecurityException {
                    try {
                        JarFile jarFile = DownloadEngine.getCachedJarFile((URL)jARDesc.getLocation(), (String)jARDesc.getVersion());
                        if (jarFile != null) {
                            return jarFile;
                        }
                        return DownloadEngine.getUpdatedJarFile((URL)jARDesc.getLocation(), (String)jARDesc.getVersion());
                    }
                    catch (IOException iOException) {
                        Trace.ignoredException((Exception)iOException);
                        return null;
                    }
                }
            });
            if (jarFile == null) {
                throw new IOException("Resource not found: " + jARDesc.getLocation() + ":" + jARDesc.getVersion());
            }
            return jarFile;
        }
        return null;
    }

    public int getDefaultSecurityModel() {
        return this._launchDesc.getSecurityModel();
    }

    private boolean checkPackageParts(String string) {
        boolean bl = false;
        try {
            JARDesc[] jARDescArray = null;
            ResourcesDesc resourcesDesc = this._launchDesc.getResources();
            ResourcesDesc.PackageInformation packageInformation = resourcesDesc.getPackageInformation(string);
            if (packageInformation != null) {
                jARDescArray = packageInformation.getLaunchDesc().getResources().getPart(packageInformation.getPart());
            }
            if (jARDescArray != null) {
                for (int i = 0; i < jARDescArray.length; ++i) {
                    if (!this._jarsNotInURLClassLoader.contains(jARDescArray[i])) continue;
                    this._jarsNotInURLClassLoader.remove(jARDescArray[i]);
                    if (this._jarsInURLClassLoader.contains(jARDescArray[i])) continue;
                    this._jarsInURLClassLoader.add(jARDescArray[i]);
                    this.addURL(jARDescArray[i].getLocation());
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            Trace.ignoredException((Exception)exception);
        }
        return bl;
    }

    private void sortJarDescriptors(ResourcesDesc resourcesDesc) {
        int n;
        ArrayList<JARDesc> arrayList = new ArrayList<JARDesc>();
        JARDesc[] jARDescArray = resourcesDesc.getEagerOrAllJarDescs(true);
        JARDesc jARDesc = resourcesDesc.getMainJar(true);
        if (jARDesc != null) {
            this._jarsInURLClassLoader.add(jARDesc);
        }
        for (n = 0; n < jARDescArray.length; ++n) {
            if (jARDescArray[n] == jARDesc) continue;
            if (!jARDescArray[n].isLazyDownload()) {
                this._jarsInURLClassLoader.add(jARDescArray[n]);
                continue;
            }
            if (!resourcesDesc.isPackagePart(jARDescArray[n].getPartName())) {
                arrayList.add(jARDescArray[n]);
                continue;
            }
            this._jarsNotInURLClassLoader.add(jARDescArray[n]);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            this._jarsInURLClassLoader.add(arrayList.get(n));
        }
    }

    protected void updateJarDescriptors(ResourcesDesc resourcesDesc) {
        JARDesc[] jARDescArray = resourcesDesc.getEagerOrAllJarDescs(true);
        if (jARDescArray != null) {
            for (int i = 0; i < jARDescArray.length; ++i) {
                this.updateJarDescriptor(resourcesDesc, jARDescArray[i]);
            }
        }
    }

    protected void updateJarDescriptor(ResourcesDesc resourcesDesc, JARDesc jARDesc) {
        if (jARDesc != null && !this._jarsInURLClassLoader.contains(jARDesc) && !this._jarsNotInURLClassLoader.contains(jARDesc)) {
            if (!jARDesc.isLazyDownload() || !resourcesDesc.isPackagePart(jARDesc.getPartName())) {
                this._jarsInURLClassLoader.add(jARDesc);
                this.addURL(jARDesc.getLocation());
            } else {
                this._jarsNotInURLClassLoader.add(jARDesc);
            }
        }
    }

    public void addResource(URL uRL, String string, String string2) {
        JARDesc jARDesc = new JARDesc(uRL, string, true, false, false, null, 0, null);
        if (!this._jarsInURLClassLoader.contains(jARDesc)) {
            this._launchDesc.getResources().addResource((ResourceType)jARDesc);
            this._jarsInURLClassLoader.add(jARDesc);
            this.addURL(uRL);
        }
    }

    public BasicService getBasicService() {
        if (this._basicService == null) {
            this._basicService = new Plugin2BasicService(this.base);
        }
        return this._basicService;
    }

    public FileOpenService getFileOpenService() {
        return FileOpenServiceImpl.getInstance();
    }

    public FileSaveService getFileSaveService() {
        return FileSaveServiceImpl.getInstance();
    }

    public ExtensionInstallerService getExtensionInstallerService() {
        return ExtensionInstallerServiceImpl.getInstance();
    }

    public DownloadService getDownloadService() {
        return DownloadServiceImpl.getInstance();
    }

    public ClipboardService getClipboardService() {
        return ClipboardServiceImpl.getInstance();
    }

    public PrintService getPrintService() {
        return PrintServiceImpl.getInstance();
    }

    public PersistenceService getPersistenceService() {
        return PersistenceServiceImpl.getInstance();
    }

    public ExtendedService getExtendedService() {
        return ExtendedServiceImpl.getInstance();
    }

    public SingleInstanceService getSingleInstanceService() {
        return SingleInstanceServiceImpl.getInstance();
    }
}

