/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import sun.print.PrinterGraphicsDevice;

public class PrinterGraphicsConfig
extends GraphicsConfiguration {
    GraphicsDevice gd;
    ColorModel model;
    Raster raster;
    int pageWidth;
    int pageHeight;
    AffineTransform deviceTransform;

    public PrinterGraphicsConfig(String string, AffineTransform affineTransform, int n, int n2) {
        BufferedImage bufferedImage = new BufferedImage(1, 1, 5);
        this.model = bufferedImage.getColorModel();
        this.raster = bufferedImage.getRaster().createCompatibleWritableRaster(1, 1);
        this.pageWidth = n;
        this.pageHeight = n2;
        this.deviceTransform = affineTransform;
        this.gd = new PrinterGraphicsDevice(this, string);
    }

    public GraphicsDevice getDevice() {
        return this.gd;
    }

    public BufferedImage createCompatibleImage(int n, int n2) {
        WritableRaster writableRaster = this.raster.createCompatibleWritableRaster(n, n2);
        return new BufferedImage(this.model, writableRaster, this.model.isAlphaPremultiplied(), null);
    }

    public ColorModel getColorModel() {
        return this.model;
    }

    public ColorModel getColorModel(int n) {
        if (this.model.getTransparency() == n) {
            return this.model;
        }
        switch (n) {
            case 1: {
                return new DirectColorModel(24, 0xFF0000, 65280, 255);
            }
            case 2: {
                return new DirectColorModel(25, 0xFF0000, 65280, 255, 0x1000000);
            }
            case 3: {
                return ColorModel.getRGBdefault();
            }
        }
        return null;
    }

    public AffineTransform getDefaultTransform() {
        return new AffineTransform(this.deviceTransform);
    }

    public AffineTransform getNormalizingTransform() {
        return new AffineTransform();
    }

    public Rectangle getBounds() {
        return new Rectangle(0, 0, this.pageWidth, this.pageHeight);
    }
}

