/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.plaf.FontUIResource;
import sun.applet.AppletSecurity;
import sun.awt.AppContext;
import sun.awt.FontConfiguration;
import sun.awt.SunHints;
import sun.awt.SunToolkit;
import sun.font.CompositeFont;
import sun.font.FileFont;
import sun.font.Font2D;
import sun.font.Font2DHandle;
import sun.font.FontFamily;
import sun.font.NativeFont;
import sun.font.PhysicalFont;
import sun.font.StrikeCache;
import sun.font.TrueTypeFont;
import sun.font.Type1Font;
import sun.java2d.HeadlessGraphicsEnvironment;
import sun.java2d.SunGraphicsEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FontManager {
    public static final int FONTFORMAT_NONE = -1;
    public static final int FONTFORMAT_TRUETYPE = 0;
    public static final int FONTFORMAT_TYPE1 = 1;
    public static final int FONTFORMAT_T2K = 2;
    public static final int FONTFORMAT_TTC = 3;
    public static final int FONTFORMAT_COMPOSITE = 4;
    public static final int FONTFORMAT_NATIVE = 5;
    public static final int NO_FALLBACK = 0;
    public static final int PHYSICAL_FALLBACK = 1;
    public static final int LOGICAL_FALLBACK = 2;
    public static final int QUADPATHTYPE = 1;
    public static final int CUBICPATHTYPE = 2;
    private static final int CHANNELPOOLSIZE = 20;
    private static int lastPoolIndex = 0;
    private static FileFont[] fontFileCache = new FileFont[20];
    private static int maxCompFont = 0;
    private static CompositeFont[] compFonts = new CompositeFont[20];
    private static Hashtable compositeFonts = new Hashtable();
    private static Hashtable physicalFonts = new Hashtable();
    private static ConcurrentHashMap<String, PhysicalFont> registeredFontFiles = new ConcurrentHashMap();
    private static Hashtable fullNameToFont = new Hashtable();
    private static HashMap localeFullNamesToFont;
    private static PhysicalFont defaultPhysicalFont;
    private static boolean usePlatformFontMetrics;
    public static Logger logger;
    public static boolean logging;
    static boolean longAddresses;
    static String osName;
    static boolean useT2K;
    static boolean isWindows;
    static boolean isSolaris;
    public static boolean isSolaris8;
    public static boolean isSolaris9;
    private static boolean loaded1dot0Fonts;
    static SunGraphicsEnvironment sgEnv;
    static boolean loadedAllFonts;
    static boolean loadedAllFontFiles;
    static TrueTypeFont eudcFont;
    static HashMap<String, String> jreFontMap;
    static HashSet<String> jreLucidaFontFiles;
    static String[] jreOtherFontFiles;
    static boolean noOtherJREFontFiles;
    private static String[] STR_ARRAY;
    private static final Hashtable deferredFontFiles;
    private static final Hashtable initialisedFonts;
    private static HashMap<String, String> fontToFileMap;
    private static HashMap<String, String> fontToFamilyNameMap;
    private static HashMap<String, ArrayList<String>> familyToFontListMap;
    private static String[] pathDirs;
    private static Hashtable fontNameCache;
    private static final short US_LCID = 1033;
    private static Map lcidMap;
    private static Thread fileCloser;
    static Vector<File> tmpFontFiles;
    private static final Object altJAFontKey;
    private static final Object localeFontKey;
    private static final Object proportionalFontKey;
    public static boolean usingPerAppContextComposites;
    private static boolean usingAlternateComposites;
    private static boolean gAltJAFont;
    private static boolean gLocalePref;
    private static boolean gPropPref;
    private static HashSet installedNames;
    private static final Object regFamilyKey;
    private static final Object regFullNameKey;
    private static Hashtable<String, FontFamily> createdByFamilyName;
    private static Hashtable<String, Font2D> createdByFullName;
    private static boolean fontsAreRegistered;
    private static boolean fontsAreRegisteredPerAppContext;
    private static final String[][] nameMap;
    private static String[] fontConfigNames;
    private static FontConfigInfo[] fontConfigFonts;

    private static native void initIDs();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToPool(FileFont fileFont) {
        FileFont fileFont2 = null;
        int n = -1;
        FileFont[] fileFontArray = fontFileCache;
        synchronized (fontFileCache) {
            for (int i = 0; i < 20; ++i) {
                if (fontFileCache[i] == fileFont) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
                if (fontFileCache[i] != null || n >= 0) continue;
                n = i;
            }
            if (n >= 0) {
                FontManager.fontFileCache[n] = fileFont;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            fileFont2 = fontFileCache[lastPoolIndex];
            FontManager.fontFileCache[FontManager.lastPoolIndex] = fileFont;
            lastPoolIndex = (lastPoolIndex + 1) % 20;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (fileFont2 != null) {
                fileFont2.close();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFromPool(FileFont fileFont) {
        FileFont[] fileFontArray = fontFileCache;
        synchronized (fontFileCache) {
            for (int i = 0; i < 20; ++i) {
                if (fontFileCache[i] != fileFont) continue;
                FontManager.fontFileCache[i] = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static boolean fontSupportsDefaultEncoding(Font font) {
        return FontManager.getFont2D(font) instanceof CompositeFont;
    }

    public static FontUIResource getCompositeFontUIResource(Font font) {
        FontUIResource fontUIResource = new FontUIResource(font.getName(), font.getStyle(), font.getSize());
        Font2D font2D = FontManager.getFont2D(font);
        if (!(font2D instanceof PhysicalFont)) {
            return fontUIResource;
        }
        CompositeFont compositeFont = (CompositeFont)FontManager.findFont2D("dialog", font.getStyle(), 0);
        if (compositeFont == null) {
            return fontUIResource;
        }
        PhysicalFont physicalFont = (PhysicalFont)font2D;
        CompositeFont compositeFont2 = new CompositeFont(physicalFont, compositeFont);
        FontManager.setFont2D(fontUIResource, compositeFont2.handle);
        FontManager.setCreatedFont(fontUIResource);
        return fontUIResource;
    }

    public static Font2DHandle getNewComposite(String string, int n, Font2DHandle font2DHandle) {
        Font2D font2D;
        if (!(font2DHandle.font2D instanceof CompositeFont)) {
            return font2DHandle;
        }
        CompositeFont compositeFont = (CompositeFont)font2DHandle.font2D;
        PhysicalFont physicalFont = compositeFont.getSlotFont(0);
        if (string == null) {
            string = physicalFont.getFamilyName(null);
        }
        if (n == -1) {
            n = compositeFont.getStyle();
        }
        if (!((font2D = FontManager.findFont2D(string, n, 0)) instanceof PhysicalFont)) {
            font2D = physicalFont;
        }
        PhysicalFont physicalFont2 = (PhysicalFont)font2D;
        CompositeFont compositeFont2 = (CompositeFont)FontManager.findFont2D("dialog", n, 0);
        if (compositeFont2 == null) {
            return font2DHandle;
        }
        CompositeFont compositeFont3 = new CompositeFont(physicalFont2, compositeFont2);
        Font2DHandle font2DHandle2 = new Font2DHandle(compositeFont3);
        return font2DHandle2;
    }

    public static native void setFont2D(Font var0, Font2DHandle var1);

    private static native boolean isCreatedFont(Font var0);

    private static native void setCreatedFont(Font var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerCompositeFont(String string, String[] stringArray, String[] stringArray2, int n, int[] nArray, int[] nArray2, boolean bl) {
        CompositeFont compositeFont = new CompositeFont(string, stringArray, stringArray2, n, nArray, nArray2, bl);
        FontManager.addCompositeToFontList(compositeFont, 2);
        CompositeFont[] compositeFontArray = compFonts;
        synchronized (compFonts) {
            FontManager.compFonts[FontManager.maxCompFont++] = compositeFont;
            // ** MonitorExit[var8_8] (shouldn't be in output)
            return;
        }
    }

    public static void registerCompositeFont(String string, String[] stringArray, String[] stringArray2, int n, int[] nArray, int[] nArray2, boolean bl, Hashtable hashtable) {
        CompositeFont compositeFont = new CompositeFont(string, stringArray, stringArray2, n, nArray, nArray2, bl);
        Font2D font2D = (Font2D)hashtable.get(string.toLowerCase(Locale.ENGLISH));
        if (font2D instanceof CompositeFont) {
            font2D.handle.font2D = compositeFont;
        }
        hashtable.put(string.toLowerCase(Locale.ENGLISH), compositeFont);
    }

    private static void addCompositeToFontList(CompositeFont compositeFont, int n) {
        if (logging) {
            logger.info("Add to Family " + compositeFont.familyName + ", Font " + compositeFont.fullName + " rank=" + n);
        }
        compositeFont.setRank(n);
        compositeFonts.put(compositeFont.fullName, compositeFont);
        fullNameToFont.put(compositeFont.fullName.toLowerCase(Locale.ENGLISH), compositeFont);
        FontFamily fontFamily = FontFamily.getFamily(compositeFont.familyName);
        if (fontFamily == null) {
            fontFamily = new FontFamily(compositeFont.familyName, true, n);
        }
        fontFamily.setFont(compositeFont, compositeFont.style);
    }

    private static PhysicalFont addToFontList(PhysicalFont physicalFont, int n) {
        String string = physicalFont.fullName;
        String string2 = physicalFont.familyName;
        if (string == null || "".equals(string)) {
            return null;
        }
        if (compositeFonts.containsKey(string)) {
            return null;
        }
        physicalFont.setRank(n);
        if (!physicalFonts.containsKey(string)) {
            if (logging) {
                logger.info("Add to Family " + string2 + ", Font " + string + " rank=" + n);
            }
            physicalFonts.put(string, physicalFont);
            FontFamily fontFamily = FontFamily.getFamily(string2);
            if (fontFamily == null) {
                fontFamily = new FontFamily(string2, false, n);
                fontFamily.setFont(physicalFont, physicalFont.style);
            } else if (fontFamily.getRank() >= n) {
                fontFamily.setFont(physicalFont, physicalFont.style);
            }
            fullNameToFont.put(string.toLowerCase(Locale.ENGLISH), physicalFont);
            return physicalFont;
        }
        PhysicalFont physicalFont2 = physicalFont;
        PhysicalFont physicalFont3 = (PhysicalFont)physicalFonts.get(string);
        if (physicalFont3 == null) {
            return null;
        }
        if (physicalFont3.getRank() >= n) {
            Object object;
            if (physicalFont3.mapper != null && n > 2) {
                return physicalFont3;
            }
            if (physicalFont3.getRank() == n) {
                if (physicalFont3 instanceof TrueTypeFont && physicalFont2 instanceof TrueTypeFont) {
                    object = (TrueTypeFont)physicalFont3;
                    TrueTypeFont trueTypeFont = (TrueTypeFont)physicalFont2;
                    if (((TrueTypeFont)object).fileSize >= trueTypeFont.fileSize) {
                        return physicalFont3;
                    }
                } else {
                    return physicalFont3;
                }
            }
            if (physicalFont3.platName.startsWith(SunGraphicsEnvironment.jreFontDirName)) {
                if (logging) {
                    logger.warning("Unexpected attempt to replace a JRE  font " + string + " from " + physicalFont3.platName + " with " + physicalFont2.platName);
                }
                return physicalFont3;
            }
            if (logging) {
                logger.info("Replace in Family " + string2 + ",Font " + string + " new rank=" + n + " from " + physicalFont3.platName + " with " + physicalFont2.platName);
            }
            FontManager.replaceFont(physicalFont3, physicalFont2);
            physicalFonts.put(string, physicalFont2);
            fullNameToFont.put(string.toLowerCase(Locale.ENGLISH), physicalFont2);
            object = FontFamily.getFamily(string2);
            if (object == null) {
                object = new FontFamily(string2, false, n);
                ((FontFamily)object).setFont(physicalFont2, physicalFont2.style);
            } else if (((FontFamily)object).getRank() >= n) {
                ((FontFamily)object).setFont(physicalFont2, physicalFont2.style);
            }
            return physicalFont2;
        }
        return physicalFont3;
    }

    public static Font2D[] getRegisteredFonts() {
        PhysicalFont[] physicalFontArray = FontManager.getPhysicalFonts();
        int n = maxCompFont;
        Font2D[] font2DArray = new Font2D[physicalFontArray.length + n];
        System.arraycopy(compFonts, 0, font2DArray, 0, n);
        System.arraycopy(physicalFontArray, 0, font2DArray, n, physicalFontArray.length);
        return font2DArray;
    }

    public static PhysicalFont[] getPhysicalFonts() {
        return physicalFonts.values().toArray(new PhysicalFont[0]);
    }

    public static synchronized void initialiseDeferredFonts() {
        String[] stringArray = deferredFontFiles.keySet().toArray(STR_ARRAY);
        for (int i = 0; i < stringArray.length; ++i) {
            FontManager.initialiseDeferredFont(stringArray[i]);
        }
    }

    public static synchronized void registerDeferredJREFonts(String string) {
        FontRegistrationInfo[] fontRegistrationInfoArray = deferredFontFiles.values().toArray(new FontRegistrationInfo[0]);
        for (int i = 0; i < fontRegistrationInfoArray.length; ++i) {
            if (fontRegistrationInfoArray[i].fontFilePath == null || !fontRegistrationInfoArray[i].fontFilePath.startsWith(string)) continue;
            FontManager.initialiseDeferredFont(fontRegistrationInfoArray[i].fontFilePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PhysicalFont findJREDeferredFont(String string, int n) {
        PhysicalFont physicalFont;
        String string2 = string.toLowerCase(Locale.ENGLISH) + n;
        String string3 = jreFontMap.get(string2);
        if (string3 != null) {
            FontManager.initSGEnv();
            string3 = SunGraphicsEnvironment.jreFontDirName + File.separator + string3;
            if (deferredFontFiles.get(string3) != null && (physicalFont = FontManager.initialiseDeferredFont(string3)) != null && (physicalFont.getFontName(null).equalsIgnoreCase(string) || physicalFont.getFamilyName(null).equalsIgnoreCase(string)) && physicalFont.style == n) {
                return physicalFont;
            }
        }
        if (noOtherJREFontFiles) {
            return null;
        }
        HashSet<String> hashSet = jreLucidaFontFiles;
        synchronized (hashSet) {
            if (jreOtherFontFiles == null) {
                HashSet<String> hashSet2 = new HashSet<String>();
                String[] stringArray = deferredFontFiles.keySet().toArray(STR_ARRAY);
                for (int i = 0; i < stringArray.length; ++i) {
                    File file = new File(stringArray[i]);
                    String string4 = file.getParent();
                    String string5 = file.getName();
                    if (string4 == null || !string4.equals(SunGraphicsEnvironment.jreFontDirName) || jreLucidaFontFiles.contains(string5)) continue;
                    hashSet2.add(stringArray[i]);
                }
                jreOtherFontFiles = hashSet2.toArray(STR_ARRAY);
                if (jreOtherFontFiles.length == 0) {
                    noOtherJREFontFiles = true;
                }
            }
            for (int i = 0; i < jreOtherFontFiles.length; ++i) {
                string3 = jreOtherFontFiles[i];
                if (string3 == null) continue;
                FontManager.jreOtherFontFiles[i] = null;
                physicalFont = FontManager.initialiseDeferredFont(string3);
                if (physicalFont == null || !physicalFont.getFontName(null).equalsIgnoreCase(string) && !physicalFont.getFamilyName(null).equalsIgnoreCase(string) || physicalFont.style != n) continue;
                return physicalFont;
            }
        }
        return null;
    }

    private static PhysicalFont findOtherDeferredFont(String string, int n) {
        String[] stringArray = deferredFontFiles.keySet().toArray(STR_ARRAY);
        for (int i = 0; i < stringArray.length; ++i) {
            PhysicalFont physicalFont;
            File file = new File(stringArray[i]);
            String string2 = file.getParent();
            String string3 = file.getName();
            if (string2 != null && string2.equals(SunGraphicsEnvironment.jreFontDirName) && jreLucidaFontFiles.contains(string3) || (physicalFont = FontManager.initialiseDeferredFont(stringArray[i])) == null || !physicalFont.getFontName(null).equalsIgnoreCase(string) && !physicalFont.getFamilyName(null).equalsIgnoreCase(string) || physicalFont.style != n) continue;
            return physicalFont;
        }
        return null;
    }

    private static PhysicalFont findDeferredFont(String string, int n) {
        PhysicalFont physicalFont = FontManager.findJREDeferredFont(string, n);
        if (physicalFont != null) {
            return physicalFont;
        }
        return FontManager.findOtherDeferredFont(string, n);
    }

    public static void registerDeferredFont(String string, String string2, String[] stringArray, int n, boolean bl, int n2) {
        FontRegistrationInfo fontRegistrationInfo = new FontRegistrationInfo(string2, stringArray, n, bl, n2);
        deferredFontFiles.put(string, fontRegistrationInfo);
    }

    public static synchronized PhysicalFont initialiseDeferredFont(String string) {
        PhysicalFont physicalFont;
        FontRegistrationInfo fontRegistrationInfo;
        if (string == null) {
            return null;
        }
        if (logging) {
            logger.info("Opening deferred font file " + string);
        }
        if ((fontRegistrationInfo = (FontRegistrationInfo)deferredFontFiles.get(string)) != null) {
            deferredFontFiles.remove(string);
            physicalFont = FontManager.registerFontFile(fontRegistrationInfo.fontFilePath, fontRegistrationInfo.nativeNames, fontRegistrationInfo.fontFormat, fontRegistrationInfo.javaRasterizer, fontRegistrationInfo.fontRank);
            if (physicalFont != null) {
                initialisedFonts.put(string, physicalFont.handle);
            } else {
                initialisedFonts.put(string, FontManager.getDefaultPhysicalFont().handle);
            }
        } else {
            Font2DHandle font2DHandle = (Font2DHandle)initialisedFonts.get(string);
            physicalFont = font2DHandle == null ? FontManager.getDefaultPhysicalFont() : (PhysicalFont)font2DHandle.font2D;
        }
        return physicalFont;
    }

    public static PhysicalFont registerFontFile(String string, String[] stringArray, int n, boolean bl, int n2) {
        PhysicalFont physicalFont;
        block11: {
            PhysicalFont physicalFont2 = registeredFontFiles.get(string);
            if (physicalFont2 != null) {
                return physicalFont2;
            }
            physicalFont = null;
            try {
                switch (n) {
                    case 0: {
                        TrueTypeFont trueTypeFont;
                        int n3 = 0;
                        do {
                            trueTypeFont = new TrueTypeFont(string, stringArray, n3++, bl);
                            PhysicalFont physicalFont3 = FontManager.addToFontList(trueTypeFont, n2);
                            if (physicalFont != null) continue;
                            physicalFont = physicalFont3;
                        } while (n3 < trueTypeFont.getFontCount());
                        break;
                    }
                    case 1: {
                        Type1Font type1Font = new Type1Font(string, stringArray);
                        physicalFont = FontManager.addToFontList(type1Font, n2);
                        break;
                    }
                    case 5: {
                        NativeFont nativeFont = new NativeFont(string, false);
                        physicalFont = FontManager.addToFontList(nativeFont, n2);
                    }
                }
                if (logging) {
                    logger.info("Registered file " + string + " as font " + physicalFont + " rank=" + n2);
                }
            }
            catch (FontFormatException fontFormatException) {
                if (!logging) break block11;
                logger.warning("Unusable font: " + string + " " + fontFormatException.toString());
            }
        }
        if (physicalFont != null && n != 5) {
            registeredFontFiles.put(string, physicalFont);
        }
        return physicalFont;
    }

    public static void registerFonts(String[] stringArray, String[][] stringArray2, int n, int n2, boolean bl, int n3, boolean bl2) {
        for (int i = 0; i < n; ++i) {
            if (bl2) {
                FontManager.registerDeferredFont(stringArray[i], stringArray[i], stringArray2[i], n2, bl, n3);
                continue;
            }
            FontManager.registerFontFile(stringArray[i], stringArray2[i], n2, bl, n3);
        }
    }

    public static PhysicalFont getDefaultPhysicalFont() {
        if (defaultPhysicalFont == null) {
            defaultPhysicalFont = (PhysicalFont)FontManager.findFont2D("Lucida Sans Regular", 0, 0);
            if (defaultPhysicalFont == null) {
                defaultPhysicalFont = (PhysicalFont)FontManager.findFont2D("Arial", 0, 0);
            }
            if (defaultPhysicalFont == null) {
                Iterator iterator = physicalFonts.values().iterator();
                if (iterator.hasNext()) {
                    defaultPhysicalFont = (PhysicalFont)iterator.next();
                } else {
                    throw new Error("Probable fatal error:No fonts found.");
                }
            }
        }
        return defaultPhysicalFont;
    }

    public static CompositeFont getDefaultLogicalFont(int n) {
        return (CompositeFont)FontManager.findFont2D("dialog", n, 0);
    }

    private static String dotStyleStr(int n) {
        switch (n) {
            case 1: {
                return ".bold";
            }
            case 2: {
                return ".italic";
            }
            case 3: {
                return ".bolditalic";
            }
        }
        return ".plain";
    }

    static void initSGEnv() {
        if (sgEnv == null) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            if (graphicsEnvironment instanceof HeadlessGraphicsEnvironment) {
                HeadlessGraphicsEnvironment headlessGraphicsEnvironment = (HeadlessGraphicsEnvironment)graphicsEnvironment;
                sgEnv = (SunGraphicsEnvironment)headlessGraphicsEnvironment.getSunGraphicsEnvironment();
            } else {
                sgEnv = (SunGraphicsEnvironment)graphicsEnvironment;
            }
        }
    }

    private static native void populateFontFileNameMap(HashMap<String, String> var0, HashMap<String, String> var1, HashMap<String, ArrayList<String>> var2, Locale var3);

    private static String[] getFontFilesFromPath() {
        return (String[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (pathDirs.length == 1) {
                    File file = new File(pathDirs[0]);
                    String[] stringArray = file.list(SunGraphicsEnvironment.ttFilter);
                    if (stringArray == null) {
                        return new String[0];
                    }
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringArray[i] = stringArray[i].toLowerCase();
                    }
                    return stringArray;
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < pathDirs.length; ++i) {
                    File file = new File(pathDirs[i]);
                    String[] stringArray = file.list(SunGraphicsEnvironment.ttFilter);
                    if (stringArray == null) continue;
                    for (int j = 0; j < stringArray.length; ++j) {
                        arrayList.add(stringArray[j].toLowerCase());
                    }
                }
                return arrayList.toArray(STR_ARRAY);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private static void resolveWindowsFonts() {
        Object n;
        ArrayList<String> arrayList = null;
        for (String object2 : fontToFamilyNameMap.keySet()) {
            n = fontToFileMap.get(object2);
            if (n != null) continue;
            if (object2.indexOf("  ") > 0) {
                String i = object2.replaceFirst("  ", " ");
                n = fontToFileMap.get(i);
                if (n == null || fontToFamilyNameMap.containsKey(i)) continue;
                fontToFileMap.remove(i);
                fontToFileMap.put(object2, (String)n);
                continue;
            }
            if (object2.equals("marlett")) {
                fontToFileMap.put(object2, "marlett.ttf");
                continue;
            }
            if (object2.equals("david")) {
                n = fontToFileMap.get("david regular");
                if (n == null) continue;
                fontToFileMap.remove("david regular");
                fontToFileMap.put("david", (String)n);
                continue;
            }
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            arrayList.add(object2);
        }
        if (arrayList != null) {
            HashSet hashSet = new HashSet();
            HashMap hashMap = (HashMap)fontToFileMap.clone();
            for (String string : fontToFamilyNameMap.keySet()) {
                hashMap.remove(string);
            }
            for (String string : hashMap.keySet()) {
                hashSet.add(hashMap.get(string));
                fontToFileMap.remove(string);
            }
            FontManager.resolveFontFiles(hashSet, arrayList);
            if (arrayList.size() > 0) {
                n = new ArrayList<String>();
                for (String string : fontToFileMap.values()) {
                    ((ArrayList)n).add(string.toLowerCase());
                }
                for (String string : FontManager.getFontFilesFromPath()) {
                    if (((ArrayList)n).contains(string)) continue;
                    hashSet.add(string);
                }
                FontManager.resolveFontFiles(hashSet, arrayList);
            }
            if (arrayList.size() > 0) {
                void var4_15;
                int n2 = arrayList.size();
                boolean bl = false;
                while (var4_15 < n2) {
                    ArrayList<String> arrayList2;
                    String string = (String)arrayList.get((int)var4_15);
                    String string2 = fontToFamilyNameMap.get(string);
                    if (string2 != null && (arrayList2 = familyToFontListMap.get(string2)) != null && arrayList2.size() <= 1) {
                        familyToFontListMap.remove(string2);
                    }
                    fontToFamilyNameMap.remove(string);
                    if (logging) {
                        logger.info("No file for font:" + string);
                    }
                    ++var4_15;
                }
            }
        }
    }

    private static void resolveFontFiles(HashSet<String> hashSet, ArrayList<String> arrayList) {
        Locale locale = SunToolkit.getStartupLocale();
        for (String string : hashSet) {
            try {
                TrueTypeFont trueTypeFont;
                int n = 0;
                String string2 = FontManager.getPathName(string);
                if (logging) {
                    logger.info("Trying to resolve file " + string2);
                }
                do {
                    String string3;
                    if (!arrayList.contains(string3 = (trueTypeFont = new TrueTypeFont(string2, null, n++, true)).getFontName(locale).toLowerCase())) continue;
                    fontToFileMap.put(string3, string);
                    arrayList.remove(string3);
                    if (!logging) continue;
                    logger.info("Resolved absent registry entry for " + string3 + " located in " + string2);
                } while (n < trueTypeFont.getFontCount());
            }
            catch (Exception exception) {}
        }
    }

    private static synchronized HashMap<String, String> getFullNameToFileMap() {
        if (fontToFileMap == null) {
            StringTokenizer stringTokenizer = new StringTokenizer(FontManager.getFontPath(SunGraphicsEnvironment.noType1Font), File.pathSeparator);
            ArrayList<String> arrayList = new ArrayList<String>();
            try {
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(stringTokenizer.nextToken());
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            pathDirs = arrayList.toArray(STR_ARRAY);
            fontToFileMap = new HashMap(100);
            fontToFamilyNameMap = new HashMap(100);
            familyToFontListMap = new HashMap(50);
            FontManager.populateFontFileNameMap(fontToFileMap, fontToFamilyNameMap, familyToFontListMap, Locale.ENGLISH);
            if (isWindows) {
                FontManager.resolveWindowsFonts();
            }
            if (logging) {
                FontManager.logPlatformFontInfo();
            }
        }
        return fontToFileMap;
    }

    private static void logPlatformFontInfo() {
        for (int i = 0; i < pathDirs.length; ++i) {
            logger.info("fontdir=" + pathDirs[i]);
        }
        for (String string : fontToFileMap.keySet()) {
            logger.info("font=" + string + " file=" + fontToFileMap.get(string));
        }
        for (String string : fontToFamilyNameMap.keySet()) {
            logger.info("font=" + string + " family=" + fontToFamilyNameMap.get(string));
        }
        for (String string : familyToFontListMap.keySet()) {
            logger.info("family=" + string + " fonts=" + familyToFontListMap.get(string));
        }
    }

    public static String[] getFontNamesFromPlatform() {
        if (FontManager.getFullNameToFileMap().size() == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ArrayList<String> arrayList2 : familyToFontListMap.values()) {
            for (String string : arrayList2) {
                arrayList.add(string);
            }
        }
        return arrayList.toArray(STR_ARRAY);
    }

    public static boolean gotFontsFromPlatform() {
        return FontManager.getFullNameToFileMap().size() != 0;
    }

    public static String getFileNameForFontName(String string) {
        String string2 = string.toLowerCase(Locale.ENGLISH);
        return fontToFileMap.get(string2);
    }

    public static void registerOtherFontFiles(HashSet hashSet) {
        if (FontManager.getFullNameToFileMap().size() == 0) {
            return;
        }
        String[] stringArray = fontToFileMap.values().toArray(STR_ARRAY);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!new File(stringArray[i]).isAbsolute() || hashSet.contains(stringArray[i])) continue;
            int n = -1;
            int n2 = 6;
            if (SunGraphicsEnvironment.ttFilter.accept(null, stringArray[i])) {
                n = 0;
                n2 = 3;
            } else if (SunGraphicsEnvironment.t1Filter.accept(null, stringArray[i])) {
                n = 1;
                n2 = 4;
            }
            if (n == -1) continue;
            FontManager.registerFontFile(stringArray[i], null, n, false, n2);
        }
    }

    public static boolean getFamilyNamesFromPlatform(TreeMap<String, String> treeMap, Locale locale) {
        if (FontManager.getFullNameToFileMap().size() == 0) {
            return false;
        }
        String[] stringArray = fontToFamilyNameMap.values().toArray(STR_ARRAY);
        for (int i = 0; i < stringArray.length; ++i) {
            treeMap.put(stringArray[i].toLowerCase(locale), stringArray[i]);
        }
        return true;
    }

    private static String getPathName(String string) {
        File file = new File(string);
        if (file.isAbsolute()) {
            return string;
        }
        if (pathDirs.length == 1) {
            return pathDirs[0] + File.separator + string;
        }
        for (int i = 0; i < pathDirs.length; ++i) {
            file = new File(pathDirs[i] + File.separator + string);
            if (!file.exists()) continue;
            return file.getAbsolutePath();
        }
        return string;
    }

    private static Font2D findFontFromPlatform(String string, int n) {
        Object object;
        String[] stringArray;
        if (FontManager.getFullNameToFileMap().size() == 0) {
            return null;
        }
        ArrayList<String> arrayList = null;
        String string2 = null;
        String string3 = fontToFamilyNameMap.get(string);
        if (string3 != null) {
            string2 = fontToFileMap.get(string);
            arrayList = familyToFontListMap.get(string3.toLowerCase(Locale.ENGLISH));
        } else {
            arrayList = familyToFontListMap.get(string);
            if (arrayList != null && arrayList.size() > 0 && (stringArray = arrayList.get(0).toLowerCase(Locale.ENGLISH)) != null) {
                string3 = fontToFamilyNameMap.get(stringArray);
            }
        }
        if (arrayList == null || string3 == null) {
            return null;
        }
        stringArray = arrayList.toArray(STR_ARRAY);
        if (stringArray.length == 0) {
            return null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = stringArray[i].toLowerCase(Locale.ENGLISH);
            object = fontToFileMap.get(string4);
            if (object != null) continue;
            if (logging) {
                logger.info("Platform lookup : No file for font " + stringArray[i] + " in family " + string3);
            }
            return null;
        }
        PhysicalFont physicalFont = null;
        if (string2 != null) {
            physicalFont = FontManager.registerFontFile(FontManager.getPathName(string2), null, 0, false, 3);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i].toLowerCase(Locale.ENGLISH);
            String string5 = fontToFileMap.get(object);
            if (string2 != null && string2.equals(string5)) continue;
            FontManager.registerFontFile(FontManager.getPathName(string5), null, 0, false, 3);
        }
        Font2D font2D = null;
        object = FontFamily.getFamily(string3);
        if (physicalFont != null) {
            n |= physicalFont.style;
        }
        if (object != null && (font2D = ((FontFamily)object).getFont(n)) == null) {
            font2D = ((FontFamily)object).getClosestStyle(n);
        }
        return font2D;
    }

    public static Font2D findFont2D(String string, int n, int n2) {
        Object object;
        Object object2;
        String string2 = string.toLowerCase(Locale.ENGLISH);
        String string3 = string2 + FontManager.dotStyleStr(n);
        Font2D font2D = usingPerAppContextComposites ? ((object2 = (Hashtable)AppContext.getAppContext().get(CompositeFont.class)) != null ? (Font2D)((Hashtable)object2).get(string3) : null) : (Font2D)fontNameCache.get(string3);
        if (font2D != null) {
            return font2D;
        }
        if (logging) {
            logger.info("Search for font: " + string);
        }
        if (isWindows) {
            if (string2.equals("ms sans serif")) {
                string = "sansserif";
            } else if (string2.equals("ms serif")) {
                string = "serif";
            }
        }
        if (string2.equals("default")) {
            string = "dialog";
        }
        if ((object2 = FontFamily.getFamily(string)) != null) {
            font2D = ((FontFamily)object2).getFontWithExactStyleMatch(n);
            if (font2D == null) {
                font2D = FontManager.findDeferredFont(string, n);
            }
            if (font2D == null) {
                font2D = ((FontFamily)object2).getFont(n);
            }
            if (font2D == null) {
                font2D = ((FontFamily)object2).getClosestStyle(n);
            }
            if (font2D != null) {
                fontNameCache.put(string3, font2D);
                return font2D;
            }
        }
        if ((font2D = (Font2D)fullNameToFont.get(string2)) != null) {
            if (font2D.style == n || n == 0) {
                fontNameCache.put(string3, font2D);
                return font2D;
            }
            object2 = FontFamily.getFamily(font2D.getFamilyName(null));
            if (object2 != null) {
                object = ((FontFamily)object2).getFont(n | font2D.style);
                if (object != null) {
                    fontNameCache.put(string3, object);
                    return object;
                }
                object = ((FontFamily)object2).getClosestStyle(n | font2D.style);
                if (object != null && ((Font2D)object).canDoStyle(n | font2D.style)) {
                    fontNameCache.put(string3, object);
                    return object;
                }
            }
        }
        if (sgEnv == null) {
            FontManager.initSGEnv();
            return FontManager.findFont2D(string, n, n2);
        }
        if (isWindows) {
            if (deferredFontFiles.size() > 0 && (font2D = FontManager.findJREDeferredFont(string2, n)) != null) {
                fontNameCache.put(string3, font2D);
                return font2D;
            }
            font2D = FontManager.findFontFromPlatform(string2, n);
            if (font2D != null) {
                if (logging) {
                    logger.info("Found font via platform API for request:\"" + string + "\":, style=" + n + " found font: " + font2D);
                }
                fontNameCache.put(string3, font2D);
                return font2D;
            }
        }
        if (deferredFontFiles.size() > 0 && (font2D = FontManager.findDeferredFont(string, n)) != null) {
            fontNameCache.put(string3, font2D);
            return font2D;
        }
        if (isSolaris && !loaded1dot0Fonts) {
            if (string2.equals("timesroman")) {
                font2D = FontManager.findFont2D("serif", n, n2);
                fontNameCache.put(string3, font2D);
            }
            sgEnv.register1dot0Fonts();
            loaded1dot0Fonts = true;
            object = FontManager.findFont2D(string, n, n2);
            return object;
        }
        if (fontsAreRegistered || fontsAreRegisteredPerAppContext) {
            Hashtable hashtable;
            object = null;
            if (fontsAreRegistered) {
                object = createdByFamilyName;
                hashtable = createdByFullName;
            } else {
                AppContext appContext = AppContext.getAppContext();
                object = (Hashtable)appContext.get(regFamilyKey);
                hashtable = (Hashtable)appContext.get(regFullNameKey);
            }
            object2 = (FontFamily)((Hashtable)object).get(string2);
            if (object2 != null) {
                font2D = ((FontFamily)object2).getFontWithExactStyleMatch(n);
                if (font2D == null) {
                    font2D = ((FontFamily)object2).getFont(n);
                }
                if (font2D == null) {
                    font2D = ((FontFamily)object2).getClosestStyle(n);
                }
                if (font2D != null) {
                    if (fontsAreRegistered) {
                        fontNameCache.put(string3, font2D);
                    }
                    return font2D;
                }
            }
            if ((font2D = (Font2D)hashtable.get(string2)) != null) {
                if (fontsAreRegistered) {
                    fontNameCache.put(string3, font2D);
                }
                return font2D;
            }
        }
        if (!loadedAllFonts) {
            if (logging) {
                logger.info("Load fonts looking for:" + string);
            }
            sgEnv.loadFonts();
            loadedAllFonts = true;
            return FontManager.findFont2D(string, n, n2);
        }
        if (!loadedAllFontFiles) {
            if (logging) {
                logger.info("Load font files looking for:" + string);
            }
            sgEnv.loadFontFiles();
            loadedAllFontFiles = true;
            return FontManager.findFont2D(string, n, n2);
        }
        font2D = FontManager.findFont2DAllLocales(string, n);
        if (font2D != null) {
            fontNameCache.put(string3, font2D);
            return font2D;
        }
        if (isWindows) {
            object = sgEnv.getFontConfiguration().getFallbackFamilyName(string, null);
            if (object != null) {
                font2D = FontManager.findFont2D((String)object, n, n2);
                fontNameCache.put(string3, font2D);
                return font2D;
            }
        } else {
            if (string2.equals("timesroman")) {
                font2D = FontManager.findFont2D("serif", n, n2);
                fontNameCache.put(string3, font2D);
                return font2D;
            }
            if (string2.equals("helvetica")) {
                font2D = FontManager.findFont2D("sansserif", n, n2);
                fontNameCache.put(string3, font2D);
                return font2D;
            }
            if (string2.equals("courier")) {
                font2D = FontManager.findFont2D("monospaced", n, n2);
                fontNameCache.put(string3, font2D);
                return font2D;
            }
        }
        if (logging) {
            logger.info("No font found for:" + string);
        }
        switch (n2) {
            case 1: {
                return FontManager.getDefaultPhysicalFont();
            }
            case 2: {
                return FontManager.getDefaultLogicalFont(n);
            }
        }
        return null;
    }

    public static native Font2D getFont2D(Font var0);

    public static boolean usePlatformFontMetrics() {
        return usePlatformFontMetrics;
    }

    static native boolean getPlatformFontVar();

    public static short getLCIDFromLocale(Locale locale) {
        if (locale.equals(Locale.US)) {
            return 1033;
        }
        if (lcidMap == null) {
            FontManager.createLCIDMap();
        }
        String string = locale.toString();
        while (!"".equals(string)) {
            Short s = (Short)lcidMap.get(string);
            if (s != null) {
                return s;
            }
            int n = string.lastIndexOf(95);
            if (n < 1) {
                return 1033;
            }
            string = string.substring(0, n);
        }
        return 1033;
    }

    private static void addLCIDMapEntry(Map map, String string, short s) {
        map.put(string, new Short(s));
    }

    private static synchronized void createLCIDMap() {
        if (lcidMap != null) {
            return;
        }
        HashMap hashMap = new HashMap(200);
        FontManager.addLCIDMapEntry(hashMap, "ar", (short)1025);
        FontManager.addLCIDMapEntry(hashMap, "bg", (short)1026);
        FontManager.addLCIDMapEntry(hashMap, "ca", (short)1027);
        FontManager.addLCIDMapEntry(hashMap, "zh", (short)1028);
        FontManager.addLCIDMapEntry(hashMap, "cs", (short)1029);
        FontManager.addLCIDMapEntry(hashMap, "da", (short)1030);
        FontManager.addLCIDMapEntry(hashMap, "de", (short)1031);
        FontManager.addLCIDMapEntry(hashMap, "el", (short)1032);
        FontManager.addLCIDMapEntry(hashMap, "es", (short)1034);
        FontManager.addLCIDMapEntry(hashMap, "fi", (short)1035);
        FontManager.addLCIDMapEntry(hashMap, "fr", (short)1036);
        FontManager.addLCIDMapEntry(hashMap, "iw", (short)1037);
        FontManager.addLCIDMapEntry(hashMap, "hu", (short)1038);
        FontManager.addLCIDMapEntry(hashMap, "is", (short)1039);
        FontManager.addLCIDMapEntry(hashMap, "it", (short)1040);
        FontManager.addLCIDMapEntry(hashMap, "ja", (short)1041);
        FontManager.addLCIDMapEntry(hashMap, "ko", (short)1042);
        FontManager.addLCIDMapEntry(hashMap, "nl", (short)1043);
        FontManager.addLCIDMapEntry(hashMap, "no", (short)1044);
        FontManager.addLCIDMapEntry(hashMap, "pl", (short)1045);
        FontManager.addLCIDMapEntry(hashMap, "pt", (short)1046);
        FontManager.addLCIDMapEntry(hashMap, "rm", (short)1047);
        FontManager.addLCIDMapEntry(hashMap, "ro", (short)1048);
        FontManager.addLCIDMapEntry(hashMap, "ru", (short)1049);
        FontManager.addLCIDMapEntry(hashMap, "hr", (short)1050);
        FontManager.addLCIDMapEntry(hashMap, "sk", (short)1051);
        FontManager.addLCIDMapEntry(hashMap, "sq", (short)1052);
        FontManager.addLCIDMapEntry(hashMap, "sv", (short)1053);
        FontManager.addLCIDMapEntry(hashMap, "th", (short)1054);
        FontManager.addLCIDMapEntry(hashMap, "tr", (short)1055);
        FontManager.addLCIDMapEntry(hashMap, "ur", (short)1056);
        FontManager.addLCIDMapEntry(hashMap, "in", (short)1057);
        FontManager.addLCIDMapEntry(hashMap, "uk", (short)1058);
        FontManager.addLCIDMapEntry(hashMap, "be", (short)1059);
        FontManager.addLCIDMapEntry(hashMap, "sl", (short)1060);
        FontManager.addLCIDMapEntry(hashMap, "et", (short)1061);
        FontManager.addLCIDMapEntry(hashMap, "lv", (short)1062);
        FontManager.addLCIDMapEntry(hashMap, "lt", (short)1063);
        FontManager.addLCIDMapEntry(hashMap, "fa", (short)1065);
        FontManager.addLCIDMapEntry(hashMap, "vi", (short)1066);
        FontManager.addLCIDMapEntry(hashMap, "hy", (short)1067);
        FontManager.addLCIDMapEntry(hashMap, "eu", (short)1069);
        FontManager.addLCIDMapEntry(hashMap, "mk", (short)1071);
        FontManager.addLCIDMapEntry(hashMap, "tn", (short)1074);
        FontManager.addLCIDMapEntry(hashMap, "xh", (short)1076);
        FontManager.addLCIDMapEntry(hashMap, "zu", (short)1077);
        FontManager.addLCIDMapEntry(hashMap, "af", (short)1078);
        FontManager.addLCIDMapEntry(hashMap, "ka", (short)1079);
        FontManager.addLCIDMapEntry(hashMap, "fo", (short)1080);
        FontManager.addLCIDMapEntry(hashMap, "hi", (short)1081);
        FontManager.addLCIDMapEntry(hashMap, "mt", (short)1082);
        FontManager.addLCIDMapEntry(hashMap, "se", (short)1083);
        FontManager.addLCIDMapEntry(hashMap, "gd", (short)1084);
        FontManager.addLCIDMapEntry(hashMap, "ms", (short)1086);
        FontManager.addLCIDMapEntry(hashMap, "kk", (short)1087);
        FontManager.addLCIDMapEntry(hashMap, "ky", (short)1088);
        FontManager.addLCIDMapEntry(hashMap, "sw", (short)1089);
        FontManager.addLCIDMapEntry(hashMap, "tt", (short)1092);
        FontManager.addLCIDMapEntry(hashMap, "bn", (short)1093);
        FontManager.addLCIDMapEntry(hashMap, "pa", (short)1094);
        FontManager.addLCIDMapEntry(hashMap, "gu", (short)1095);
        FontManager.addLCIDMapEntry(hashMap, "ta", (short)1097);
        FontManager.addLCIDMapEntry(hashMap, "te", (short)1098);
        FontManager.addLCIDMapEntry(hashMap, "kn", (short)1099);
        FontManager.addLCIDMapEntry(hashMap, "ml", (short)1100);
        FontManager.addLCIDMapEntry(hashMap, "mr", (short)1102);
        FontManager.addLCIDMapEntry(hashMap, "sa", (short)1103);
        FontManager.addLCIDMapEntry(hashMap, "mn", (short)1104);
        FontManager.addLCIDMapEntry(hashMap, "cy", (short)1106);
        FontManager.addLCIDMapEntry(hashMap, "gl", (short)1110);
        FontManager.addLCIDMapEntry(hashMap, "dv", (short)1125);
        FontManager.addLCIDMapEntry(hashMap, "qu", (short)1131);
        FontManager.addLCIDMapEntry(hashMap, "mi", (short)1153);
        FontManager.addLCIDMapEntry(hashMap, "ar_IQ", (short)2049);
        FontManager.addLCIDMapEntry(hashMap, "zh_CN", (short)2052);
        FontManager.addLCIDMapEntry(hashMap, "de_CH", (short)2055);
        FontManager.addLCIDMapEntry(hashMap, "en_GB", (short)2057);
        FontManager.addLCIDMapEntry(hashMap, "es_MX", (short)2058);
        FontManager.addLCIDMapEntry(hashMap, "fr_BE", (short)2060);
        FontManager.addLCIDMapEntry(hashMap, "it_CH", (short)2064);
        FontManager.addLCIDMapEntry(hashMap, "nl_BE", (short)2067);
        FontManager.addLCIDMapEntry(hashMap, "no_NO_NY", (short)2068);
        FontManager.addLCIDMapEntry(hashMap, "pt_PT", (short)2070);
        FontManager.addLCIDMapEntry(hashMap, "ro_MD", (short)2072);
        FontManager.addLCIDMapEntry(hashMap, "ru_MD", (short)2073);
        FontManager.addLCIDMapEntry(hashMap, "sr_CS", (short)2074);
        FontManager.addLCIDMapEntry(hashMap, "sv_FI", (short)2077);
        FontManager.addLCIDMapEntry(hashMap, "az_AZ", (short)2092);
        FontManager.addLCIDMapEntry(hashMap, "se_SE", (short)2107);
        FontManager.addLCIDMapEntry(hashMap, "ga_IE", (short)2108);
        FontManager.addLCIDMapEntry(hashMap, "ms_BN", (short)2110);
        FontManager.addLCIDMapEntry(hashMap, "uz_UZ", (short)2115);
        FontManager.addLCIDMapEntry(hashMap, "qu_EC", (short)2155);
        FontManager.addLCIDMapEntry(hashMap, "ar_EG", (short)3073);
        FontManager.addLCIDMapEntry(hashMap, "zh_HK", (short)3076);
        FontManager.addLCIDMapEntry(hashMap, "de_AT", (short)3079);
        FontManager.addLCIDMapEntry(hashMap, "en_AU", (short)3081);
        FontManager.addLCIDMapEntry(hashMap, "fr_CA", (short)3084);
        FontManager.addLCIDMapEntry(hashMap, "sr_CS", (short)3098);
        FontManager.addLCIDMapEntry(hashMap, "se_FI", (short)3131);
        FontManager.addLCIDMapEntry(hashMap, "qu_PE", (short)3179);
        FontManager.addLCIDMapEntry(hashMap, "ar_LY", (short)4097);
        FontManager.addLCIDMapEntry(hashMap, "zh_SG", (short)4100);
        FontManager.addLCIDMapEntry(hashMap, "de_LU", (short)4103);
        FontManager.addLCIDMapEntry(hashMap, "en_CA", (short)4105);
        FontManager.addLCIDMapEntry(hashMap, "es_GT", (short)4106);
        FontManager.addLCIDMapEntry(hashMap, "fr_CH", (short)4108);
        FontManager.addLCIDMapEntry(hashMap, "hr_BA", (short)4122);
        FontManager.addLCIDMapEntry(hashMap, "ar_DZ", (short)5121);
        FontManager.addLCIDMapEntry(hashMap, "zh_MO", (short)5124);
        FontManager.addLCIDMapEntry(hashMap, "de_LI", (short)5127);
        FontManager.addLCIDMapEntry(hashMap, "en_NZ", (short)5129);
        FontManager.addLCIDMapEntry(hashMap, "es_CR", (short)5130);
        FontManager.addLCIDMapEntry(hashMap, "fr_LU", (short)5132);
        FontManager.addLCIDMapEntry(hashMap, "bs_BA", (short)5146);
        FontManager.addLCIDMapEntry(hashMap, "ar_MA", (short)6145);
        FontManager.addLCIDMapEntry(hashMap, "en_IE", (short)6153);
        FontManager.addLCIDMapEntry(hashMap, "es_PA", (short)6154);
        FontManager.addLCIDMapEntry(hashMap, "fr_MC", (short)6156);
        FontManager.addLCIDMapEntry(hashMap, "sr_BA", (short)6170);
        FontManager.addLCIDMapEntry(hashMap, "ar_TN", (short)7169);
        FontManager.addLCIDMapEntry(hashMap, "en_ZA", (short)7177);
        FontManager.addLCIDMapEntry(hashMap, "es_DO", (short)7178);
        FontManager.addLCIDMapEntry(hashMap, "sr_BA", (short)7194);
        FontManager.addLCIDMapEntry(hashMap, "ar_OM", (short)8193);
        FontManager.addLCIDMapEntry(hashMap, "en_JM", (short)8201);
        FontManager.addLCIDMapEntry(hashMap, "es_VE", (short)8202);
        FontManager.addLCIDMapEntry(hashMap, "ar_YE", (short)9217);
        FontManager.addLCIDMapEntry(hashMap, "es_CO", (short)9226);
        FontManager.addLCIDMapEntry(hashMap, "ar_SY", (short)10241);
        FontManager.addLCIDMapEntry(hashMap, "en_BZ", (short)10249);
        FontManager.addLCIDMapEntry(hashMap, "es_PE", (short)10250);
        FontManager.addLCIDMapEntry(hashMap, "ar_JO", (short)11265);
        FontManager.addLCIDMapEntry(hashMap, "en_TT", (short)11273);
        FontManager.addLCIDMapEntry(hashMap, "es_AR", (short)11274);
        FontManager.addLCIDMapEntry(hashMap, "ar_LB", (short)12289);
        FontManager.addLCIDMapEntry(hashMap, "en_ZW", (short)12297);
        FontManager.addLCIDMapEntry(hashMap, "es_EC", (short)12298);
        FontManager.addLCIDMapEntry(hashMap, "ar_KW", (short)13313);
        FontManager.addLCIDMapEntry(hashMap, "en_PH", (short)13321);
        FontManager.addLCIDMapEntry(hashMap, "es_CL", (short)13322);
        FontManager.addLCIDMapEntry(hashMap, "ar_AE", (short)14337);
        FontManager.addLCIDMapEntry(hashMap, "es_UY", (short)14346);
        FontManager.addLCIDMapEntry(hashMap, "ar_BH", (short)15361);
        FontManager.addLCIDMapEntry(hashMap, "es_PY", (short)15370);
        FontManager.addLCIDMapEntry(hashMap, "ar_QA", (short)16385);
        FontManager.addLCIDMapEntry(hashMap, "es_BO", (short)16394);
        FontManager.addLCIDMapEntry(hashMap, "es_SV", (short)17418);
        FontManager.addLCIDMapEntry(hashMap, "es_HN", (short)18442);
        FontManager.addLCIDMapEntry(hashMap, "es_NI", (short)19466);
        FontManager.addLCIDMapEntry(hashMap, "es_PR", (short)20490);
        lcidMap = hashMap;
    }

    public static int getNumFonts() {
        return physicalFonts.size() + maxCompFont;
    }

    private static boolean fontSupportsEncoding(Font font, String string) {
        return FontManager.getFont2D(font).supportsEncoding(string);
    }

    public static synchronized native String getFontPath(boolean var0);

    public static synchronized native void setNativeFontPath(String var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Font2D createFont2D(File file, int n, boolean bl) throws FontFormatException {
        String string = file.getPath();
        FileFont fileFont = null;
        final File file2 = file;
        try {
            switch (n) {
                case 0: {
                    fileFont = new TrueTypeFont(string, null, 0, true);
                    break;
                }
                case 1: {
                    fileFont = new Type1Font(string, null);
                    break;
                }
                default: {
                    throw new FontFormatException("Unrecognised Font Format");
                }
            }
        }
        catch (FontFormatException fontFormatException) {
            if (!bl) throw fontFormatException;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    file2.delete();
                    return null;
                }
            });
            throw fontFormatException;
        }
        if (!bl) return fileFont;
        fileFont.setFileToRemove(file);
        Class<FontManager> clazz = FontManager.class;
        synchronized (FontManager.class) {
            if (tmpFontFiles == null) {
                tmpFontFiles = new Vector();
            }
            tmpFontFiles.add(file);
            if (fileCloser != null) return fileFont;
            final Runnable runnable = new Runnable(){

                public void run() {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            for (int i = 0; i < 20; ++i) {
                                if (fontFileCache[i] == null) continue;
                                try {
                                    fontFileCache[i].close();
                                    continue;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (tmpFontFiles != null) {
                                File[] fileArray = new File[tmpFontFiles.size()];
                                fileArray = tmpFontFiles.toArray(fileArray);
                                for (int i = 0; i < fileArray.length; ++i) {
                                    try {
                                        fileArray[i].delete();
                                        continue;
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            }
                            return null;
                        }
                    });
                }
            };
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ThreadGroup threadGroup;
                    ThreadGroup threadGroup2 = threadGroup = Thread.currentThread().getThreadGroup();
                    while (threadGroup2 != null) {
                        threadGroup = threadGroup2;
                        threadGroup2 = threadGroup.getParent();
                    }
                    fileCloser = new Thread(threadGroup, runnable);
                    Runtime.getRuntime().addShutdownHook(fileCloser);
                    return null;
                }
            });
            // ** MonitorExit[var6_7] (shouldn't be in output)
            return fileFont;
        }
    }

    public static synchronized String getFullNameByFileName(String string) {
        PhysicalFont[] physicalFontArray = FontManager.getPhysicalFonts();
        for (int i = 0; i < physicalFontArray.length; ++i) {
            if (!physicalFontArray[i].platName.equals(string)) continue;
            return physicalFontArray[i].getFontName(null);
        }
        return null;
    }

    public static synchronized void deRegisterBadFont(Font2D font2D) {
        if (!(font2D instanceof PhysicalFont)) {
            return;
        }
        if (logging) {
            logger.severe("Deregister bad font: " + font2D);
        }
        FontManager.replaceFont((PhysicalFont)font2D, FontManager.getDefaultPhysicalFont());
    }

    public static synchronized void replaceFont(PhysicalFont physicalFont, PhysicalFont physicalFont2) {
        int n;
        Object[] objectArray;
        if (physicalFont.handle.font2D != physicalFont) {
            return;
        }
        if (physicalFont == physicalFont2) {
            if (logging) {
                logger.severe("Can't replace bad font with itself " + physicalFont);
            }
            objectArray = FontManager.getPhysicalFonts();
            for (n = 0; n < objectArray.length; ++n) {
                if (objectArray[n] == physicalFont2) continue;
                physicalFont2 = objectArray[n];
                break;
            }
            if (physicalFont == physicalFont2) {
                if (logging) {
                    logger.severe("This is bad. No good physicalFonts found.");
                }
                return;
            }
        }
        physicalFont.handle.font2D = physicalFont2;
        physicalFonts.remove(physicalFont.fullName);
        fullNameToFont.remove(physicalFont.fullName.toLowerCase(Locale.ENGLISH));
        FontFamily.remove(physicalFont);
        if (localeFullNamesToFont != null) {
            objectArray = localeFullNamesToFont.entrySet().toArray(new Map.Entry[0]);
            for (n = 0; n < objectArray.length; ++n) {
                if (objectArray[n].getValue() != physicalFont) continue;
                try {
                    objectArray[n].setValue(physicalFont2);
                    continue;
                }
                catch (Exception exception) {
                    localeFullNamesToFont.remove(objectArray[n].getKey());
                }
            }
        }
        for (int i = 0; i < maxCompFont; ++i) {
            if (physicalFont2.getRank() <= 2) continue;
            compFonts[i].replaceComponentFont(physicalFont, physicalFont2);
        }
    }

    private static synchronized void loadLocaleNames() {
        if (localeFullNamesToFont != null) {
            return;
        }
        localeFullNamesToFont = new HashMap();
        Font2D[] font2DArray = FontManager.getRegisteredFonts();
        for (int i = 0; i < font2DArray.length; ++i) {
            if (!(font2DArray[i] instanceof TrueTypeFont)) continue;
            TrueTypeFont trueTypeFont = (TrueTypeFont)font2DArray[i];
            String[] stringArray = trueTypeFont.getAllFullNames();
            for (int j = 0; j < stringArray.length; ++j) {
                localeFullNamesToFont.put(stringArray[j], trueTypeFont);
            }
            FontFamily fontFamily = FontFamily.getFamily(trueTypeFont.familyName);
            if (fontFamily == null) continue;
            FontFamily.addLocaleNames(fontFamily, trueTypeFont.getAllFamilyNames());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Font2D findFont2DAllLocales(String string, int n) {
        if (logging) {
            logger.info("Searching localised font names for:" + string);
        }
        if (localeFullNamesToFont == null) {
            FontManager.loadLocaleNames();
        }
        String string2 = string.toLowerCase();
        Font2D font2D = null;
        FontFamily fontFamily = FontFamily.getLocaleFamily(string2);
        if (fontFamily != null) {
            font2D = fontFamily.getFont(n);
            if (font2D == null) {
                font2D = fontFamily.getClosestStyle(n);
            }
            if (font2D != null) {
                return font2D;
            }
        }
        Object object = FontManager.class;
        synchronized (FontManager.class) {
            font2D = (Font2D)localeFullNamesToFont.get(string);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (font2D != null) {
                if (font2D.style == n || n == 0) {
                    return font2D;
                }
                fontFamily = FontFamily.getFamily(font2D.getFamilyName(null));
                if (fontFamily != null) {
                    object = fontFamily.getFont(n);
                    if (object != null) {
                        return object;
                    }
                    object = fontFamily.getClosestStyle(n);
                    if (object != null) {
                        if (!((Font2D)object).canDoStyle(n)) {
                            object = null;
                        }
                        return object;
                    }
                }
            }
            return font2D;
        }
    }

    static boolean maybeUsingAlternateCompositeFonts() {
        return usingAlternateComposites || usingPerAppContextComposites;
    }

    public static boolean usingAlternateCompositeFonts() {
        return usingAlternateComposites || usingPerAppContextComposites && AppContext.getAppContext().get(CompositeFont.class) != null;
    }

    private static boolean maybeMultiAppContext() {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SecurityManager securityManager = System.getSecurityManager();
                return new Boolean(securityManager instanceof AppletSecurity);
            }
        });
        return bl;
    }

    public static synchronized void useAlternateFontforJALocales() {
        if (!isWindows) {
            return;
        }
        FontManager.initSGEnv();
        if (!FontManager.maybeMultiAppContext()) {
            gAltJAFont = true;
        } else {
            AppContext appContext = AppContext.getAppContext();
            appContext.put(altJAFontKey, altJAFontKey);
        }
    }

    public static boolean usingAlternateFontforJALocales() {
        if (!FontManager.maybeMultiAppContext()) {
            return gAltJAFont;
        }
        AppContext appContext = AppContext.getAppContext();
        return appContext.get(altJAFontKey) == altJAFontKey;
    }

    public static synchronized void preferLocaleFonts() {
        FontManager.initSGEnv();
        if (!FontConfiguration.willReorderForStartupLocale()) {
            return;
        }
        if (!FontManager.maybeMultiAppContext()) {
            if (gLocalePref) {
                return;
            }
            gLocalePref = true;
            sgEnv.createCompositeFonts(fontNameCache, gLocalePref, gPropPref);
            usingAlternateComposites = true;
        } else {
            AppContext appContext = AppContext.getAppContext();
            if (appContext.get(localeFontKey) == localeFontKey) {
                return;
            }
            appContext.put(localeFontKey, localeFontKey);
            boolean bl = appContext.get(proportionalFontKey) == proportionalFontKey;
            Hashtable hashtable = new Hashtable();
            appContext.put(CompositeFont.class, hashtable);
            usingPerAppContextComposites = true;
            sgEnv.createCompositeFonts(hashtable, true, bl);
        }
    }

    public static synchronized void preferProportionalFonts() {
        if (!FontConfiguration.hasMonoToPropMap()) {
            return;
        }
        FontManager.initSGEnv();
        if (!FontManager.maybeMultiAppContext()) {
            if (gPropPref) {
                return;
            }
            gPropPref = true;
            sgEnv.createCompositeFonts(fontNameCache, gLocalePref, gPropPref);
            usingAlternateComposites = true;
        } else {
            AppContext appContext = AppContext.getAppContext();
            if (appContext.get(proportionalFontKey) == proportionalFontKey) {
                return;
            }
            appContext.put(proportionalFontKey, proportionalFontKey);
            boolean bl = appContext.get(localeFontKey) == localeFontKey;
            Hashtable hashtable = new Hashtable();
            appContext.put(CompositeFont.class, hashtable);
            usingPerAppContextComposites = true;
            sgEnv.createCompositeFonts(hashtable, bl, true);
        }
    }

    private static HashSet getInstalledNames() {
        if (installedNames == null) {
            int n;
            Locale locale = sgEnv.getSystemStartupLocale();
            String[] stringArray = sgEnv.getInstalledFontFamilyNames(locale);
            Font[] fontArray = sgEnv.getAllInstalledFonts();
            HashSet<String> hashSet = new HashSet<String>();
            for (n = 0; n < stringArray.length; ++n) {
                hashSet.add(stringArray[n].toLowerCase(locale));
            }
            for (n = 0; n < fontArray.length; ++n) {
                hashSet.add(fontArray[n].getFontName(locale).toLowerCase(locale));
            }
            installedNames = hashSet;
        }
        return installedNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean registerFont(Font font) {
        Object object;
        Hashtable<String, Object> hashtable;
        Hashtable<String, FontFamily> hashtable2;
        Object object2 = regFamilyKey;
        synchronized (object2) {
            if (createdByFamilyName == null) {
                createdByFamilyName = new Hashtable();
                createdByFullName = new Hashtable();
            }
        }
        if (!FontManager.isCreatedFont(font)) {
            return false;
        }
        if (sgEnv == null) {
            FontManager.initSGEnv();
        }
        object2 = FontManager.getInstalledNames();
        Locale locale = sgEnv.getSystemStartupLocale();
        String string = font.getFamily(locale).toLowerCase();
        String string2 = font.getFontName(locale).toLowerCase();
        if (((HashSet)object2).contains(string) || ((HashSet)object2).contains(string2)) {
            return false;
        }
        if (!FontManager.maybeMultiAppContext()) {
            hashtable2 = createdByFamilyName;
            hashtable = createdByFullName;
            fontsAreRegistered = true;
        } else {
            object = AppContext.getAppContext();
            hashtable2 = (Hashtable<String, FontFamily>)((AppContext)object).get(regFamilyKey);
            hashtable = (Hashtable<String, Object>)((AppContext)object).get(regFullNameKey);
            if (hashtable2 == null) {
                hashtable2 = new Hashtable<String, FontFamily>();
                hashtable = new Hashtable<String, Object>();
                ((AppContext)object).put(regFamilyKey, hashtable2);
                ((AppContext)object).put(regFullNameKey, hashtable);
            }
            fontsAreRegisteredPerAppContext = true;
        }
        object = FontManager.getFont2D(font);
        int n = ((Font2D)object).getStyle();
        FontFamily fontFamily = (FontFamily)hashtable2.get(string);
        if (fontFamily == null) {
            fontFamily = new FontFamily(font.getFamily(locale));
            hashtable2.put(string, fontFamily);
        }
        if (fontsAreRegistered) {
            FontManager.removeFromCache(fontFamily.getFont(0));
            FontManager.removeFromCache(fontFamily.getFont(1));
            FontManager.removeFromCache(fontFamily.getFont(2));
            FontManager.removeFromCache(fontFamily.getFont(3));
            FontManager.removeFromCache((Font2D)hashtable.get(string2));
        }
        fontFamily.setFont((Font2D)object, n);
        hashtable.put(string2, object);
        return true;
    }

    private static void removeFromCache(Font2D font2D) {
        if (font2D == null) {
            return;
        }
        String[] stringArray = fontNameCache.keySet().toArray(STR_ARRAY);
        for (int i = 0; i < stringArray.length; ++i) {
            if (fontNameCache.get(stringArray[i]) != font2D) continue;
            fontNameCache.remove(stringArray[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TreeMap<String, String> getCreatedFontFamilyNames() {
        Object object;
        Hashtable hashtable;
        if (fontsAreRegistered) {
            hashtable = createdByFamilyName;
        } else if (fontsAreRegisteredPerAppContext) {
            object = AppContext.getAppContext();
            hashtable = (Hashtable)((AppContext)object).get(regFamilyKey);
        } else {
            return null;
        }
        object = sgEnv.getSystemStartupLocale();
        Hashtable hashtable2 = hashtable;
        synchronized (hashtable2) {
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            for (FontFamily fontFamily : hashtable.values()) {
                Font2D font2D = fontFamily.getFont(0);
                if (font2D == null) {
                    font2D = fontFamily.getClosestStyle(0);
                }
                String string = font2D.getFamilyName((Locale)object);
                treeMap.put(string.toLowerCase((Locale)object), string);
            }
            return treeMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Font[] getCreatedFonts() {
        Object object;
        Hashtable hashtable;
        if (fontsAreRegistered) {
            hashtable = createdByFullName;
        } else if (fontsAreRegisteredPerAppContext) {
            object = AppContext.getAppContext();
            hashtable = (Hashtable)((AppContext)object).get(regFullNameKey);
        } else {
            return null;
        }
        object = sgEnv.getSystemStartupLocale();
        Hashtable hashtable2 = hashtable;
        synchronized (hashtable2) {
            Font[] fontArray = new Font[hashtable.size()];
            int n = 0;
            for (Font2D font2D : hashtable.values()) {
                fontArray[n++] = new Font(font2D.getFontName((Locale)object), 0, 1);
            }
            return fontArray;
        }
    }

    public static String mapFcName(String string) {
        for (int i = 0; i < nameMap.length; ++i) {
            if (!string.equals(nameMap[i][0])) continue;
            return nameMap[i][1];
        }
        return null;
    }

    private static String getFCLocaleStr() {
        Locale locale = SunToolkit.getStartupLocale();
        String string = locale.getLanguage();
        String string2 = locale.getCountry();
        if (!string2.equals("")) {
            string = string + "-" + string2;
        }
        return string;
    }

    private static native int getFontConfigAASettings(String var0, String var1);

    public static Object getFontConfigAAHint(String string) {
        if (isWindows) {
            return null;
        }
        int n = FontManager.getFontConfigAASettings(FontManager.getFCLocaleStr(), string);
        if (n < 0) {
            return null;
        }
        return SunHints.Value.get(2, n);
    }

    public static Object getFontConfigAAHint() {
        return FontManager.getFontConfigAAHint("sans");
    }

    private static native void getFontConfig(String var0, FontConfigInfo[] var1);

    private static void initFontConfigFonts() {
        if (isWindows) {
            return;
        }
        FontConfigInfo[] fontConfigInfoArray = new FontConfigInfo[fontConfigNames.length];
        for (int i = 0; i < fontConfigInfoArray.length; ++i) {
            fontConfigInfoArray[i] = new FontConfigInfo();
            fontConfigInfoArray[i].fcName = fontConfigNames[i];
            int n = fontConfigInfoArray[i].fcName.indexOf(58);
            fontConfigInfoArray[i].fcFamily = fontConfigInfoArray[i].fcName.substring(0, n);
            fontConfigInfoArray[i].jdkName = FontManager.mapFcName(fontConfigInfoArray[i].fcFamily);
            fontConfigInfoArray[i].style = i % 4;
        }
        FontManager.getFontConfig(FontManager.getFCLocaleStr(), fontConfigInfoArray);
        fontConfigFonts = fontConfigInfoArray;
    }

    private static PhysicalFont registerFromFcInfo(FontConfigInfo fontConfigInfo) {
        int n = fontConfigInfo.fontFile.length() - 4;
        if (n <= 0) {
            return null;
        }
        String string = fontConfigInfo.fontFile.substring(n).toLowerCase();
        boolean bl = string.equals(".ttc");
        PhysicalFont physicalFont = registeredFontFiles.get(fontConfigInfo.fontFile);
        if (physicalFont != null) {
            if (bl) {
                Font2D font2D = FontManager.findFont2D(fontConfigInfo.familyName, fontConfigInfo.style, 0);
                if (font2D instanceof PhysicalFont) {
                    return (PhysicalFont)font2D;
                }
                return null;
            }
            return physicalFont;
        }
        physicalFont = FontManager.findJREDeferredFont(fontConfigInfo.familyName, fontConfigInfo.style);
        if (physicalFont == null && deferredFontFiles.get(fontConfigInfo.fontFile) != null && (physicalFont = FontManager.initialiseDeferredFont(fontConfigInfo.fontFile)) != null) {
            if (bl) {
                Font2D font2D = FontManager.findFont2D(fontConfigInfo.familyName, fontConfigInfo.style, 0);
                if (font2D instanceof PhysicalFont) {
                    return (PhysicalFont)font2D;
                }
                return null;
            }
            return physicalFont;
        }
        if (physicalFont == null) {
            int n2 = -1;
            int n3 = 6;
            if (string.equals(".ttf") || bl) {
                n2 = 0;
                n3 = 3;
            } else if (string.equals(".pfa") || string.equals(".pfb")) {
                n2 = 1;
                n3 = 4;
            }
            physicalFont = FontManager.registerFontFile(fontConfigInfo.fontFile, null, n2, true, n3);
        }
        return physicalFont;
    }

    private static CompositeFont getFontConfigFont(String string, int n) {
        Font2D font2D;
        PhysicalFont physicalFont = null;
        if (fontConfigFonts == null) {
            long l = 0L;
            if (logging) {
                l = System.currentTimeMillis();
            }
            FontManager.initFontConfigFonts();
            if (logging) {
                long l2 = System.currentTimeMillis();
                logger.info("Time spent accessing fontconfig=" + (l2 - l) + "ms.");
                for (int i = 0; i < fontConfigFonts.length; ++i) {
                    FontConfigInfo fontConfigInfo = fontConfigFonts[i];
                    logger.info("FC font " + fontConfigInfo.fcName + " maps to family " + fontConfigInfo.familyName + " in file " + fontConfigInfo.fontFile);
                }
            }
        }
        string = string.toLowerCase();
        FontConfigInfo fontConfigInfo = null;
        for (int i = 0; i < fontConfigFonts.length; ++i) {
            if (!string.equals(FontManager.fontConfigFonts[i].fcFamily) || n != FontManager.fontConfigFonts[i].style) continue;
            fontConfigInfo = fontConfigFonts[i];
            break;
        }
        if (fontConfigInfo == null) {
            fontConfigInfo = fontConfigFonts[0];
        }
        if (logging) {
            logger.info("FC name=" + string + " style=" + n + " uses " + fontConfigInfo.familyName + " in file: " + fontConfigInfo.fontFile);
        }
        if (fontConfigInfo.compFont != null) {
            return fontConfigInfo.compFont;
        }
        CompositeFont compositeFont = (CompositeFont)FontManager.findFont2D(fontConfigInfo.jdkName, n, 2);
        if (fontConfigInfo.familyName == null || fontConfigInfo.fontFile == null) {
            fontConfigInfo.compFont = compositeFont;
            return fontConfigInfo.compFont;
        }
        FontFamily fontFamily = FontFamily.getFamily(fontConfigInfo.familyName);
        if (fontFamily != null && (font2D = fontFamily.getFontWithExactStyleMatch(fontConfigInfo.style)) instanceof PhysicalFont) {
            physicalFont = (PhysicalFont)font2D;
        }
        if (physicalFont == null || !fontConfigInfo.fontFile.equals(physicalFont.platName)) {
            physicalFont = FontManager.registerFromFcInfo(fontConfigInfo);
            if (physicalFont == null) {
                fontConfigInfo.compFont = compositeFont;
                return fontConfigInfo.compFont;
            }
            fontFamily = FontFamily.getFamily(physicalFont.getFamilyName(null));
        }
        for (int i = 0; i < fontConfigFonts.length; ++i) {
            FontConfigInfo fontConfigInfo2 = fontConfigFonts[i];
            if (fontConfigInfo2 == fontConfigInfo || !physicalFont.getFamilyName(null).equals(fontConfigInfo2.familyName) || fontConfigInfo2.fontFile.equals(physicalFont.platName) || fontFamily.getFontWithExactStyleMatch(fontConfigInfo2.style) != null) continue;
            FontManager.registerFromFcInfo(fontConfigFonts[i]);
        }
        fontConfigInfo.compFont = new CompositeFont(physicalFont, compositeFont);
        return fontConfigInfo.compFont;
    }

    public static FontUIResource getFontConfigFUIR(String string, int n, int n2) {
        String string2 = FontManager.mapFcName(string);
        if (string2 == null) {
            string2 = "sansserif";
        }
        if (isWindows) {
            return new FontUIResource(string2, n, n2);
        }
        CompositeFont compositeFont = FontManager.getFontConfigFont(string, n);
        if (compositeFont == null) {
            return new FontUIResource(string2, n, n2);
        }
        FontUIResource fontUIResource = new FontUIResource(compositeFont.getFamilyName(null), n, n2);
        FontManager.setFont2D(fontUIResource, compositeFont.handle);
        FontManager.setCreatedFont(fontUIResource);
        return fontUIResource;
    }

    static {
        usePlatformFontMetrics = false;
        logger = null;
        loaded1dot0Fonts = false;
        loadedAllFonts = false;
        loadedAllFontFiles = false;
        noOtherJREFontFiles = false;
        STR_ARRAY = new String[0];
        if (SunGraphicsEnvironment.debugFonts) {
            logger = Logger.getLogger("sun.java2d", null);
            logging = logger.getLevel() != Level.OFF;
        }
        jreFontMap = new HashMap();
        jreFontMap.put("lucida sans0", "LucidaSansRegular.ttf");
        jreFontMap.put("lucida sans1", "LucidaSansDemiBold.ttf");
        jreFontMap.put("lucida sans regular0", "LucidaSansRegular.ttf");
        jreFontMap.put("lucida sans regular1", "LucidaSansDemiBold.ttf");
        jreFontMap.put("lucida sans bold1", "LucidaSansDemiBold.ttf");
        jreFontMap.put("lucida sans demibold1", "LucidaSansDemiBold.ttf");
        jreFontMap.put("lucida sans typewriter0", "LucidaTypewriter.ttf");
        jreFontMap.put("lucida sans typewriter1", "LucidaTypewriterBold.ttf");
        jreFontMap.put("lucida sans typewriter regular0", "LucidaTypewriter.ttf");
        jreFontMap.put("lucida sans typewriter regular1", "LucidaTypewriterBold.ttf");
        jreFontMap.put("lucida sans typewriter bold1", "LucidaTypewriterBold.ttf");
        jreFontMap.put("lucida sans typewriter demibold1", "LucidaTypewriterBold.ttf");
        jreFontMap.put("lucida bright0", "LucidaBrightRegular.ttf");
        jreFontMap.put("lucida bright1", "LucidaBrightDemiBold.ttf");
        jreFontMap.put("lucida bright2", "LucidaBrightItalic.ttf");
        jreFontMap.put("lucida bright3", "LucidaBrightDemiItalic.ttf");
        jreFontMap.put("lucida bright regular0", "LucidaBrightRegular.ttf");
        jreFontMap.put("lucida bright regular1", "LucidaBrightDemiBold.ttf");
        jreFontMap.put("lucida bright regular2", "LucidaBrightItalic.ttf");
        jreFontMap.put("lucida bright regular3", "LucidaBrightDemiItalic.ttf");
        jreFontMap.put("lucida bright bold1", "LucidaBrightDemiBold.ttf");
        jreFontMap.put("lucida bright bold3", "LucidaBrightDemiItalic.ttf");
        jreFontMap.put("lucida bright demibold1", "LucidaBrightDemiBold.ttf");
        jreFontMap.put("lucida bright demibold3", "LucidaBrightDemiItalic.ttf");
        jreFontMap.put("lucida bright italic2", "LucidaBrightItalic.ttf");
        jreFontMap.put("lucida bright italic3", "LucidaBrightDemiItalic.ttf");
        jreFontMap.put("lucida bright bold italic3", "LucidaBrightDemiItalic.ttf");
        jreFontMap.put("lucida bright demibold italic3", "LucidaBrightDemiItalic.ttf");
        jreLucidaFontFiles = new HashSet();
        String[] stringArray = jreFontMap.values().toArray(STR_ARRAY);
        for (int i = 0; i < stringArray.length; ++i) {
            jreLucidaFontFiles.add(stringArray[i]);
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.loadLibrary("awt");
                System.loadLibrary("fontmanager");
                FontManager.initIDs();
                switch (StrikeCache.nativeAddressSize) {
                    case 8: {
                        longAddresses = true;
                        break;
                    }
                    case 4: {
                        longAddresses = false;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unexpected address size");
                    }
                }
                osName = System.getProperty("os.name", "unknownOS");
                isSolaris = osName.startsWith("SunOS");
                String string = System.getProperty("sun.java2d.font.scaler");
                if (string != null) {
                    useT2K = "t2k".equals(string);
                }
                if (isSolaris) {
                    String string2 = System.getProperty("os.version", "unk");
                    isSolaris8 = string2.equals("5.8");
                    isSolaris9 = string2.equals("5.9");
                } else {
                    isWindows = osName.startsWith("Windows");
                    if (isWindows) {
                        String string3;
                        String string4 = SunGraphicsEnvironment.eudcFontFileName;
                        if (string4 != null) {
                            try {
                                eudcFont = new TrueTypeFont(string4, null, 0, true);
                            }
                            catch (FontFormatException fontFormatException) {
                                // empty catch block
                            }
                        }
                        if ("true".equals(string3 = System.getProperty("java2d.font.usePlatformFont")) || FontManager.getPlatformFontVar()) {
                            usePlatformFontMetrics = true;
                            System.out.println("Enabling platform font metrics for win32. This is an unsupported option.");
                            System.out.println("This yields incorrect composite font metrics as reported by 1.1.x releases.");
                            System.out.println("It is appropriate only for use by applications which do not use any Java 2");
                            System.out.println("functionality. This property will be removed in a later release.");
                        }
                    }
                }
                return null;
            }
        });
        deferredFontFiles = new Hashtable();
        initialisedFonts = new Hashtable();
        fontToFileMap = null;
        fontToFamilyNameMap = null;
        familyToFontListMap = null;
        pathDirs = null;
        fontNameCache = new Hashtable(10, 0.75f);
        fileCloser = null;
        tmpFontFiles = null;
        altJAFontKey = new Object();
        localeFontKey = new Object();
        proportionalFontKey = new Object();
        usingPerAppContextComposites = false;
        usingAlternateComposites = false;
        gAltJAFont = false;
        gLocalePref = false;
        gPropPref = false;
        installedNames = null;
        regFamilyKey = new Object();
        regFullNameKey = new Object();
        fontsAreRegistered = false;
        fontsAreRegisteredPerAppContext = false;
        nameMap = new String[][]{{"sans", "sansserif"}, {"sans-serif", "sansserif"}, {"serif", "serif"}, {"monospace", "monospaced"}};
        fontConfigNames = new String[]{"sans:regular:roman", "sans:bold:roman", "sans:regular:italic", "sans:bold:italic", "serif:regular:roman", "serif:bold:roman", "serif:regular:italic", "serif:bold:italic", "monospace:regular:roman", "monospace:bold:roman", "monospace:regular:italic", "monospace:bold:italic"};
    }

    private static class FontConfigInfo {
        String fcName;
        String fcFamily;
        String jdkName;
        int style;
        String familyName;
        String fontFile;
        CompositeFont compFont;

        private FontConfigInfo() {
        }
    }

    private static final class FontRegistrationInfo {
        String fontFilePath;
        String[] nativeNames;
        int fontFormat;
        boolean javaRasterizer;
        int fontRank;

        FontRegistrationInfo(String string, String[] stringArray, int n, boolean bl, int n2) {
            this.fontFilePath = string;
            this.nativeNames = stringArray;
            this.fontFormat = n;
            this.javaRasterizer = bl;
            this.fontRank = n2;
        }
    }
}

