/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HiddenTagView;

class CommentView
extends HiddenTagView {
    static final Border CBorder = new CommentBorder();
    static final int commentPadding = 3;
    static final int commentPaddingD = 9;

    CommentView(Element element) {
        super(element);
    }

    protected Component createComponent() {
        Font font;
        Container container = this.getContainer();
        if (container != null && !((JTextComponent)container).isEditable()) {
            return null;
        }
        JTextArea jTextArea = new JTextArea(this.getRepresentedText());
        Document document = this.getDocument();
        if (document instanceof StyledDocument) {
            font = ((StyledDocument)document).getFont(this.getAttributes());
            jTextArea.setFont(font);
        } else {
            font = jTextArea.getFont();
        }
        this.updateYAlign(font);
        jTextArea.setBorder(CBorder);
        jTextArea.getDocument().addDocumentListener(this);
        jTextArea.setFocusable(this.isVisible());
        return jTextArea;
    }

    void resetBorder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _updateModelFromText() {
        JTextComponent jTextComponent = this.getTextComponent();
        Document document = this.getDocument();
        if (jTextComponent != null && document != null) {
            String string = jTextComponent.getText();
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            this.isSettingAttributes = true;
            try {
                simpleAttributeSet.addAttribute(HTML.Attribute.COMMENT, string);
                ((StyledDocument)document).setCharacterAttributes(this.getStartOffset(), this.getEndOffset() - this.getStartOffset(), simpleAttributeSet, false);
                Object var6_5 = null;
                this.isSettingAttributes = false;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.isSettingAttributes = false;
                throw throwable;
            }
        }
    }

    JTextComponent getTextComponent() {
        return (JTextComponent)this.getComponent();
    }

    String getRepresentedText() {
        Object object;
        AttributeSet attributeSet = this.getElement().getAttributes();
        if (attributeSet != null && (object = attributeSet.getAttribute(HTML.Attribute.COMMENT)) instanceof String) {
            return (String)object;
        }
        return "";
    }

    static class CommentBorder
    extends LineBorder {
        CommentBorder() {
            super(Color.black, 1);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            super.paintBorder(component, graphics, n + 3, n2, n3 - 9, n4);
        }

        public Insets getBorderInsets(Component component) {
            Insets insets = super.getBorderInsets(component);
            insets.left += 3;
            insets.right += 3;
            return insets;
        }

        public boolean isBorderOpaque() {
            return false;
        }
    }
}

