/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding;

import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.client.SelectOptimalEncodingFeature;
import com.sun.xml.internal.ws.api.fastinfoset.FastInfosetFeature;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.pipe.Codec;
import com.sun.xml.internal.ws.api.pipe.Codecs;
import com.sun.xml.internal.ws.api.pipe.ContentType;
import com.sun.xml.internal.ws.api.pipe.StreamSOAPCodec;
import com.sun.xml.internal.ws.binding.SOAPBindingImpl;
import com.sun.xml.internal.ws.client.ContentNegotiation;
import com.sun.xml.internal.ws.encoding.MimeCodec;
import com.sun.xml.internal.ws.encoding.MimeMultipartParser;
import com.sun.xml.internal.ws.encoding.MtomCodec;
import com.sun.xml.internal.ws.encoding.SwACodec;
import com.sun.xml.internal.ws.resources.StreamingMessages;
import com.sun.xml.internal.ws.server.UnsupportedMediaException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.StringTokenizer;
import javax.xml.ws.soap.MTOMFeature;

public class SOAPBindingCodec
extends MimeCodec
implements com.sun.xml.internal.ws.api.pipe.SOAPBindingCodec {
    private static final String BASE_ACCEPT_VALUE = "text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2";
    private boolean isFastInfosetDisabled;
    private boolean useFastInfosetForEncoding;
    private boolean ignoreContentNegotiationProperty;
    private final StreamSOAPCodec xmlSoapCodec;
    private final Codec fiSoapCodec;
    private final MimeCodec xmlMtomCodec;
    private final MimeCodec xmlSwaCodec;
    private final MimeCodec fiSwaCodec;
    private final SOAPBindingImpl binding;
    private final String xmlMimeType;
    private final String fiMimeType;
    private final String xmlAccept;
    private final String connegXmlAccept;
    private AcceptContentType _adaptingContentType = new AcceptContentType();

    public StreamSOAPCodec getXMLCodec() {
        return this.xmlSoapCodec;
    }

    public SOAPBindingCodec(WSBinding wSBinding) {
        this(wSBinding, Codecs.createSOAPEnvelopeXmlCodec(wSBinding.getSOAPVersion()));
    }

    public SOAPBindingCodec(WSBinding wSBinding, StreamSOAPCodec streamSOAPCodec) {
        super(wSBinding.getSOAPVersion());
        this.xmlSoapCodec = streamSOAPCodec;
        this.xmlMimeType = streamSOAPCodec.getMimeType();
        this.xmlMtomCodec = new MtomCodec(this.version, streamSOAPCodec, wSBinding.getFeature(MTOMFeature.class));
        this.xmlSwaCodec = new SwACodec(this.version, streamSOAPCodec);
        String string = streamSOAPCodec.getMimeType() + ", " + this.xmlMtomCodec.getMimeType() + ", " + BASE_ACCEPT_VALUE;
        FastInfosetFeature fastInfosetFeature = wSBinding.getFeature(FastInfosetFeature.class);
        boolean bl = this.isFastInfosetDisabled = fastInfosetFeature != null && !fastInfosetFeature.isEnabled();
        if (!this.isFastInfosetDisabled) {
            this.fiSoapCodec = SOAPBindingCodec.getFICodec(streamSOAPCodec, this.version);
            if (this.fiSoapCodec != null) {
                this.fiMimeType = this.fiSoapCodec.getMimeType();
                this.fiSwaCodec = new SwACodec(this.version, this.fiSoapCodec);
                this.connegXmlAccept = this.fiMimeType + ", " + string;
                SelectOptimalEncodingFeature selectOptimalEncodingFeature = wSBinding.getFeature(SelectOptimalEncodingFeature.class);
                if (selectOptimalEncodingFeature != null) {
                    this.ignoreContentNegotiationProperty = true;
                    if (selectOptimalEncodingFeature.isEnabled()) {
                        if (fastInfosetFeature != null) {
                            this.useFastInfosetForEncoding = true;
                        }
                        string = this.connegXmlAccept;
                    } else {
                        this.isFastInfosetDisabled = true;
                    }
                }
            } else {
                this.isFastInfosetDisabled = true;
                this.fiSwaCodec = null;
                this.fiMimeType = "";
                this.connegXmlAccept = string;
                this.ignoreContentNegotiationProperty = true;
            }
        } else {
            this.fiSwaCodec = null;
            this.fiSoapCodec = null;
            this.fiMimeType = "";
            this.connegXmlAccept = string;
            this.ignoreContentNegotiationProperty = true;
        }
        this.xmlAccept = string;
        this.binding = (SOAPBindingImpl)wSBinding;
    }

    public String getMimeType() {
        return null;
    }

    public ContentType getStaticContentType(Packet packet) {
        ContentType contentType = this.getEncoder(packet).getStaticContentType(packet);
        return contentType != null ? this._adaptingContentType.set(packet, contentType) : null;
    }

    public ContentType encode(Packet packet, OutputStream outputStream) throws IOException {
        return this._adaptingContentType.set(packet, this.getEncoder(packet).encode(packet, outputStream));
    }

    public ContentType encode(Packet packet, WritableByteChannel writableByteChannel) {
        return this._adaptingContentType.set(packet, this.getEncoder(packet).encode(packet, writableByteChannel));
    }

    public void decode(InputStream inputStream, String string, Packet packet) throws IOException {
        if (string == null) {
            throw new UnsupportedMediaException();
        }
        if (packet.contentNegotiation == null) {
            this.useFastInfosetForEncoding = false;
        }
        if (this.isMultipartRelated(string)) {
            super.decode(inputStream, string, packet);
        } else if (this.isFastInfoset(string)) {
            if (!this.ignoreContentNegotiationProperty && packet.contentNegotiation == ContentNegotiation.none) {
                throw this.noFastInfosetForDecoding();
            }
            this.useFastInfosetForEncoding = true;
            this.fiSoapCodec.decode(inputStream, string, packet);
        } else {
            this.xmlSoapCodec.decode(inputStream, string, packet);
        }
        if (!this.useFastInfosetForEncoding) {
            this.useFastInfosetForEncoding = this.isFastInfosetAcceptable(packet.acceptableMimeTypes);
        }
    }

    public void decode(ReadableByteChannel readableByteChannel, String string, Packet packet) {
        if (string == null) {
            throw new UnsupportedMediaException();
        }
        if (packet.contentNegotiation == null) {
            this.useFastInfosetForEncoding = false;
        }
        if (this.isMultipartRelated(string)) {
            super.decode(readableByteChannel, string, packet);
        } else if (this.isFastInfoset(string)) {
            if (packet.contentNegotiation == ContentNegotiation.none) {
                throw this.noFastInfosetForDecoding();
            }
            this.useFastInfosetForEncoding = true;
            this.fiSoapCodec.decode(readableByteChannel, string, packet);
        } else {
            this.xmlSoapCodec.decode(readableByteChannel, string, packet);
        }
        if (!this.useFastInfosetForEncoding) {
            this.useFastInfosetForEncoding = this.isFastInfosetAcceptable(packet.acceptableMimeTypes);
        }
    }

    public SOAPBindingCodec copy() {
        return new SOAPBindingCodec(this.binding, (StreamSOAPCodec)this.xmlSoapCodec.copy());
    }

    protected void decode(MimeMultipartParser mimeMultipartParser, Packet packet) throws IOException {
        String string = mimeMultipartParser.getRootPart().getContentType();
        if (this.isApplicationXopXml(string)) {
            this.xmlMtomCodec.decode(mimeMultipartParser, packet);
        } else if (this.isFastInfoset(string)) {
            if (packet.contentNegotiation == ContentNegotiation.none) {
                throw this.noFastInfosetForDecoding();
            }
            this.useFastInfosetForEncoding = true;
            this.fiSwaCodec.decode(mimeMultipartParser, packet);
        } else if (this.isXml(string)) {
            this.xmlSwaCodec.decode(mimeMultipartParser, packet);
        } else {
            throw new IOException("");
        }
    }

    private boolean isMultipartRelated(String string) {
        return this.compareStrings(string, "multipart/related");
    }

    private boolean isApplicationXopXml(String string) {
        return this.compareStrings(string, "application/xop+xml");
    }

    private boolean isXml(String string) {
        return this.compareStrings(string, this.xmlMimeType);
    }

    private boolean isFastInfoset(String string) {
        if (this.isFastInfosetDisabled) {
            return false;
        }
        return this.compareStrings(string, this.fiMimeType);
    }

    private boolean compareStrings(String string, String string2) {
        return string.length() >= string2.length() && string2.equalsIgnoreCase(string.substring(0, string2.length()));
    }

    private boolean isFastInfosetAcceptable(String string) {
        if (string == null || this.isFastInfosetDisabled) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (!string2.equalsIgnoreCase(this.fiMimeType)) continue;
            return true;
        }
        return false;
    }

    private Codec getEncoder(Packet packet) {
        if (!this.ignoreContentNegotiationProperty) {
            if (packet.contentNegotiation == ContentNegotiation.none) {
                this.useFastInfosetForEncoding = false;
            } else if (packet.contentNegotiation == ContentNegotiation.optimistic) {
                this.useFastInfosetForEncoding = true;
            }
        }
        if (this.useFastInfosetForEncoding) {
            Message message = packet.getMessage();
            if (message == null || message.getAttachments().isEmpty() || this.binding.isFeatureEnabled(MTOMFeature.class)) {
                return this.fiSoapCodec;
            }
            return this.fiSwaCodec;
        }
        if (this.binding.isFeatureEnabled(MTOMFeature.class)) {
            return this.xmlMtomCodec;
        }
        Message message = packet.getMessage();
        if (message == null || message.getAttachments().isEmpty()) {
            return this.xmlSoapCodec;
        }
        return this.xmlSwaCodec;
    }

    private RuntimeException noFastInfosetForDecoding() {
        return new RuntimeException(StreamingMessages.FASTINFOSET_DECODING_NOT_ACCEPTED());
    }

    private static Codec getFICodec(StreamSOAPCodec streamSOAPCodec, SOAPVersion sOAPVersion) {
        try {
            Class<?> clazz = Class.forName("com.sun.xml.internal.ws.encoding.fastinfoset.FastInfosetStreamSOAPCodec");
            Method method = clazz.getMethod("create", StreamSOAPCodec.class, SOAPVersion.class);
            return (Codec)method.invoke(null, new Object[]{streamSOAPCodec, sOAPVersion});
        }
        catch (Exception exception) {
            return null;
        }
    }

    private class AcceptContentType
    implements ContentType {
        private ContentType _c;
        private String _accept;

        private AcceptContentType() {
        }

        public AcceptContentType set(Packet packet, ContentType contentType) {
            this._accept = !SOAPBindingCodec.this.ignoreContentNegotiationProperty && packet.contentNegotiation != ContentNegotiation.none ? SOAPBindingCodec.this.connegXmlAccept : SOAPBindingCodec.this.xmlAccept;
            this._c = contentType;
            return this;
        }

        public String getContentType() {
            return this._c.getContentType();
        }

        public String getSOAPActionHeader() {
            return this._c.getSOAPActionHeader();
        }

        public String getAcceptHeader() {
            return this._accept;
        }
    }
}

