#!/bin/bash
# Drupal	(http://drupal.org)(http://drupal.jp)
#	BuildScript for Plamo Linux 4.3
#			by Jun Kuwamura <juk@linet.gr.jp> on 2008-07-16
# require:
#	httpd-2.2.x
#	php-5.2.x
#	postgresql-8.3.x
#
MVER=5
VERSION=6.$MVER
#SRC_URI="http://ftp.drupal.org/files/projects/drupal-${VERSION}.tar.gz"
PAC_NAME=drupal-$VERSION
SRC_URI=http://downloads.sourceforge.net/drupal-jp/${PAC_NAME}-japanese_00${MVER}.tgz
SRC_FILE=${SRC_URI##*/}
JAM_URI=http://downloads.sourceforge.net/drupal-jp/jamail-6.x-1.0.tgz
JAM_FILE=${JAM_URI##*/}


PLAMO=/expo/Build
SRC_DIR=$PLAMO/Archive/www/php/appli
PAC_DIR=$PLAMO/Packages/4.5/WWW/PHPAppli
PAC_DIR=$PLAMO/Packages/4.5/09_webdb/03_PHP.tgz
BUILD_DIR=$PLAMO/drupal6
CUSTOM_DIR=$BUILD_DIR/Custom
PAT_FILE=
#pgsql.patch

REL=P1
CPU=noname
SYS_NAME="${CPU}-${REL}"


umask 022
CWD=`pwd`
WORK=$CWD/work
rm -rf $WORK/*
mkdir -p  $WORK
export LANG=C
export CFLAGS="-O2"
export PATH=$PATH:/usr/X11R6/bin

echo $PAC_DIR
if [ ! -d $PAC_DIR ]; then
  mkdir -p  $PAC_DIR
fi
echo $SRC_DIR/$SRC_FILE
if [ ! -f $SRC_DIR/$SRC_FILE ]; then
  if [ ! -d $SRC_DIR ]; then
    mkdir -p $SRC_DIR
  fi
  ( cd $SRC_DIR; wget $SRC_URI )
fi
if [ ! -f $SRC_DIR/$JAM_FILE ]; then
  ( cd $SRC_DIR; wget $JAM_URI )
fi 

cd $WORK
mkdir -p install
sed -e "s/VERSION/$VERSION/g" \
    -e "s/_PACKAGE_NAME_/${PAC_NAME}-${SYS_NAME}/g" \
  $CUSTOM_DIR/doinst.sh > install/doinst.sh
echo "To install japanese package drupal see:"
echo "        http://drupal.jp/drupal6/guide/install-step1"

mkdir -p opt/htdocs | exit 1
cd opt/htdocs
tar xvfz $SRC_DIR/$SRC_FILE
cd $PAC_NAME

if [ -f $CUSTOM_DIR/$PAT_FILE ]; then
  patch -p1 < $CUSTOM_DIR/$PAT_FILE
fi

# insert installtion notation into index.php
head -2 index.php > index.php.new
cat >>index.php.new<<EOF

if ( file_exists("install.php") ) {
  echo "<font color='red'>1.) Please access '<a href='install.php'>install.php</a>' for initial installation!  (You should make sure your mail server working before the installation.)</a></font><br />\n";
  echo "<font color='red'>2.) Please remove 'install.php' after the installation to start setup your site!</font><br />\n";
}

EOF
sed -e '1,2d' index.php >> index.php.new
mv  index.php.new  index.php


mkdir -p files
mkdir -p sites/all/themes
mkdir -p sites/all/modules
(cd sites/all/modules; tar xvfz $SRC_DIR/$JAM_FILE)


DOC_DIR=usr/share/doc/$PAC_NAME
mkdir -p $WORK/$DOC_DIR | exit
cp -p $BUILD_DIR/`basename $0`  \
      [A-Z][A-Z]*  \
    $WORK/$DOC_DIR
chown -R root.root $WORK/$DOC_DIR
chmod -R a+rX,go-w $WORK/$DOC_DIR

cp -a $CUSTOM_DIR/custom/ .

chown -R root:apache ./


mkdir -p $WORK/opt/htdocs/AppList || exit 1
TYP=2 #(0:httpd, 1:libraries, 2:application)
cat >> $WORK/opt/htdocs/AppList/${TYP}.${PAC_NAME}.list <<__EOCL__
TYP	$TYP
NAM	${PAC_NAME}
URL	http://drupal.jp/
DOC	/${DOC_DIR}/
EXE	/drupal6/
REM	content management platform(blog etc.)
__EOCL__



cd $WORK
echo "y
1
" | makepkg ${PAC_NAME}.tgz

echo -n "$PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz"
if `mv -v ${PAC_NAME}.tgz  $PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz 1>/dev/null 2>&1`; then
  echo " ... done"
else
  echo " ... false"
fi

cd $CWD
