/*
 *  xfmedia - simple gtk2 media player based on xine
 *
 *  Copyright (c) 2004-2005 Brian Tarricone, <bjt23@cornell.edu>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License ONLY.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __XFMEDIA_INTERFACE_H__
#define __XFMEDIA_INTERFACE_H__

#include <glib.h>

#include <xfmedia/xfmedia-plugin.h>

G_BEGIN_DECLS

typedef enum
{
	XFMEDIA_STATUS_CLOSED = 0,
	XFMEDIA_STATUS_STOPPED,
	XFMEDIA_STATUS_PLAYING,
	XFMEDIA_STATUS_UNAVAILABLE
} XfmediaStatus;

typedef enum
{
	XFMEDIA_SPEED_PAUSED = 0,
	XFMEDIA_SPEED_SLOWER,
	XFMEDIA_SPEED_SLOW,
	XFMEDIA_SPEED_NORMAL,
	XFMEDIA_SPEED_FAST,
	XFMEDIA_SPEED_FASTER
} XfmediaSpeed;

gint     xfmedia_interface_get_session_number(XfmediaPlugin *plugin);

gboolean xfmedia_engine_open(XfmediaPlugin *plugin, const gchar *location);
gboolean xfmedia_engine_play(XfmediaPlugin *plugin);
void     xfmedia_engine_pause(XfmediaPlugin *plugin);
void     xfmedia_engine_stop(XfmediaPlugin *plugin);

gboolean xfmedia_engine_seek(XfmediaPlugin *plugin, gint time);
gboolean xfmedia_engine_seek_stream_pos(XfmediaPlugin *plugin, gint position);

gint     xfmedia_engine_get_current_time(XfmediaPlugin *plugin);
gint     xfmedia_engine_get_current_stream_pos(XfmediaPlugin *plugin);
gint     xfmedia_engine_get_total_time(XfmediaPlugin *plugin);

XfmediaStatus xfmedia_engine_get_status(XfmediaPlugin *plugin);

XfmediaSpeed xfmedia_engine_get_speed(XfmediaPlugin *plugin);
void     xfmedia_engine_set_speed(XfmediaPlugin *plugin, XfmediaSpeed speed);

gboolean xfmedia_get_fullscreen(XfmediaPlugin *plugin);
void     xfmedia_set_fullscreen(XfmediaPlugin *plugin, gboolean setting);

gboolean xfmedia_get_video_window_visible(XfmediaPlugin *plugin);
void     xfmedia_set_video_window_visible(XfmediaPlugin *plugin, gboolean setting);

G_CONST_RETURN gchar *xfmedia_info_get_location(XfmediaPlugin *plugin);
gchar   *xfmedia_info_get_name(XfmediaPlugin *plugin);
gboolean xfmedia_info_get_has_video(XfmediaPlugin *plugin);
gboolean xfmedia_info_get_has_audio(XfmediaPlugin *plugin);

gboolean xfmedia_info_get_audio_info(XfmediaPlugin *plugin, gchar **codec,
		gint *bitrate, gint *sample_rate, gint *channels, gint *bits_per_sample);
gboolean xfmedia_info_get_video_info(XfmediaPlugin *plugin, gchar **codec,
		gint *bitrate, gdouble *fps, gint *width, gint *height, gdouble *aspect);

G_END_DECLS

#endif
