/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.util;

public class SimpleInputBuffer {
    private String sContent;
    private int nIndex;
    private int nLen;

    private static boolean isEndOrLineEnd(char c) {
        switch (c) {
            case '\u0000': 
            case '\n': 
            case '\r': {
                return true;
            }
        }
        return false;
    }

    private static boolean isDigitOrDot(char c) {
        return c >= '0' && c <= '9' || c == '.';
    }

    private static boolean isDigitOrDotOrComma(char c) {
        return SimpleInputBuffer.isDigitOrDot(c) || c == ',';
    }

    public SimpleInputBuffer(String string) {
        this.sContent = string;
        this.nLen = string.length();
        this.nIndex = 0;
    }

    public int getIndex() {
        return this.nIndex;
    }

    public char peekChar() {
        return this.nIndex < this.nLen ? this.sContent.charAt(this.nIndex) : (char)'\u0000';
    }

    public char peekFollowingChar() {
        return this.nIndex + 1 < this.nLen ? this.sContent.charAt(this.nIndex + 1) : (char)'\u0000';
    }

    public char getChar() {
        return this.nIndex < this.nLen ? this.sContent.charAt(this.nIndex++) : (char)'\u0000';
    }

    public String getIdentifier() {
        int n = this.nIndex;
        while (this.nIndex < this.nLen && (Character.isLetter(this.sContent.charAt(this.nIndex)) || SimpleInputBuffer.isDigitOrDot(this.sContent.charAt(this.nIndex)))) {
            ++this.nIndex;
        }
        return this.sContent.substring(n, this.nIndex);
    }

    public String getNumber() {
        int n = this.nIndex;
        while (this.nIndex < this.nLen && SimpleInputBuffer.isDigitOrDotOrComma(this.sContent.charAt(this.nIndex))) {
            ++this.nIndex;
        }
        return this.sContent.substring(n, this.nIndex);
    }

    public String getInteger() {
        int n = this.nIndex;
        while (this.nIndex < this.nLen && this.sContent.charAt(this.nIndex) >= '0' && this.sContent.charAt(this.nIndex) <= '9') {
            ++this.nIndex;
        }
        return this.sContent.substring(n, this.nIndex);
    }
}

