/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.office;

import java.util.Hashtable;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import writer2latex.office.OfficeStyle;
import writer2latex.util.Misc;

public class StyleWithProperties
extends OfficeStyle {
    private Hashtable properties = new Hashtable();

    public void loadStyleFromDOM(Node node) {
        NamedNodeMap namedNodeMap;
        Element element;
        super.loadStyleFromDOM(node);
        if (node.hasChildNodes() && (element = Misc.getChildByTagName(node, "style:properties")) != null && (namedNodeMap = element.getAttributes()) != null) {
            int n = namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = namedNodeMap.item(i);
                this.setProperty(node2.getNodeName(), node2.getNodeValue());
            }
        }
    }

    public void setProperty(String string, String string2) {
        this.properties.put(string, string2);
    }

    public String getProperty(String string, boolean bl) {
        if (bl) {
            return this.getProperty(string);
        }
        if (this.properties.containsKey(string)) {
            String string2 = (String)this.properties.get(string);
            return Misc.truncateLength(string2);
        }
        return null;
    }

    public String getProperty(String string) {
        StyleWithProperties styleWithProperties;
        if (this.properties.containsKey(string)) {
            String string2 = (String)this.properties.get(string);
            return Misc.truncateLength(string2);
        }
        if (this.sParentName != null && (styleWithProperties = (StyleWithProperties)this.family.getStyle(this.sParentName)) != null) {
            return styleWithProperties.getProperty(string);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getAbsoluteProperty(String string) {
        StyleWithProperties styleWithProperties;
        String string2;
        if (this.properties.containsKey(string)) {
            String string3 = (String)this.properties.get(string);
            if (!string3.endsWith("%")) return Misc.truncateLength(string3);
            StyleWithProperties styleWithProperties2 = (StyleWithProperties)this.family.getStyle(this.sParentName);
            if (styleWithProperties2 != null) {
                String string4 = styleWithProperties2.getAbsoluteProperty(string);
                if (string4 == null) return null;
                return Misc.multiply(string3, string4);
            }
            if (this.getFamily() == null || this.getFamily().getDefaultStyle() == null) return null;
            StyleWithProperties styleWithProperties3 = (StyleWithProperties)this.getFamily().getDefaultStyle();
            String string5 = styleWithProperties3.getProperty(string);
            if (string3 == null) return null;
            return Misc.multiply(string3, string5);
        }
        if (this.sParentName != null) {
            StyleWithProperties styleWithProperties4 = (StyleWithProperties)this.family.getStyle(this.sParentName);
            if (styleWithProperties4 == null) return null;
            return styleWithProperties4.getAbsoluteProperty(string);
        }
        if (this.getFamily() == null || this.getFamily().getDefaultStyle() == null || (string2 = (styleWithProperties = (StyleWithProperties)this.getFamily().getDefaultStyle()).getProperty(string)) == null) return null;
        return string2;
    }
}

