#!/bin/sh -x

wget -q https://www.kernel.org/pub/linux/kernel/v3.x/linux-3.16.tar.xz
tar xpJf linux-3.16.tar.xz

wget https://www.kernel.org/pub/linux/kernel/v3.x/patch-3.16.7.xz
wget ftp://plamo.linet.gr.jp/pub/Plamo-test/kernelsrc_patches/UNICON/vd_unicon-kernel-20140809-3.16.patch
wget http://vdlinux.sourceforge.jp/dists/UNICON/vd_unicon-kernel-fonts-20140614.patch.bz2
git clone git://git.code.sf.net/p/aufs/aufs3-standalone.git
( cd aufs3-standalone ; git checkout origin/aufs3.16 ; git reset --hard 1bfa94d )
wget ftp://plamo.linet.gr.jp/pub/Plamo-test/kernelsrc_patches/mcp/3.16-panic_beep.patch
wget ftp://plamo.linet.gr.jp/pub/Plamo-test/kernelsrc_patches/mcp/3.16-morse_code_panics.patch
git clone git://github.com/NigelCunningham/tuxonice-kernel.git
( cd tuxonice-kernel ; git checkout origin/tuxonice-3.16 ; git reset --hard 8f6885f
  git diff 19583ca | bzip2 > ../current-tuxonice-for-3.16.patch.bz2 )
git clone https://git.kernel.org/pub/scm/linux/kernel/git/mszeredi/vfs.git
( cd vfs ; git checkout origin/overlayfs.v23 ; git reset --hard 3e24c88
  git diff cd3de83 > ../overlayfs-3.16-rc4.patch )
wget ftp://plamo.linet.gr.jp/pub/Plamo-test/kernelsrc_patches/ovlfs/overlayfs-allow_unprivileged_mounts.patch

cd linux-3.16
unxz -c ../patch-3.16.7.xz | patch -Np1 -i -
patch -Np1 -i ../vd_unicon-kernel-20140809-3.16.patch
bunzip2 -c ../vd_unicon-kernel-fonts-20140614.patch.bz2 | patch -Np1 -i -
patch -Np1 -i ../aufs3-standalone/aufs3-kbuild.patch
patch -Np1 -i ../aufs3-standalone/aufs3-base.patch
patch -Np1 -i ../aufs3-standalone/aufs3-mmap.patch
patch -Np1 -i ../aufs3-standalone/aufs3-standalone.patch
cp -av ../aufs3-standalone/Documentation .
cp -av ../aufs3-standalone/fs .
cp -pv ../aufs3-standalone/include/uapi/linux/aufs_type.h include/uapi/linux
patch -Np1 -i ../3.16-panic_beep.patch
patch -Np1 -i ../3.16-morse_code_panics.patch
bunzip2 -c ../current-tuxonice-for-3.16.patch.bz2 | patch -Np1 -i -
patch -Np1 -i ../overlayfs-3.16.2.patch
patch -Np1 -i ../overlayfs-allow_unprivileged_mounts.patch
find . -name "*.orig" -ls -exec rm {} \;
