#!/bin/sh -x

wget -q https://www.kernel.org/pub/linux/kernel/v3.x/linux-3.15.tar.xz
tar xpJf linux-3.15.tar.xz

wget https://www.kernel.org/pub/linux/kernel/v3.x/patch-3.15.10.xz
wget ftp://plamo.linet.gr.jp/pub/Plamo-test/kernelsrc_patches/UNICON/vd_unicon-kernel-20140614-3.15.patch
wget http://vdlinux.sourceforge.jp/dists/UNICON/vd_unicon-kernel-fonts-20140614.patch.bz2
git clone git://git.code.sf.net/p/aufs/aufs3-standalone.git
( cd aufs3-standalone ; git checkout origin/aufs3.15 ; git reset --hard 340fd4b )
wget ftp://plamo.linet.gr.jp/pub/Plamo-test/kernelsrc_patches/mcp/3.15-panic_beep.patch
wget ftp://plamo.linet.gr.jp/pub/Plamo-test/kernelsrc_patches/mcp/3.15-morse_code_panics.patch
git clone git://github.com/NigelCunningham/tuxonice-kernel.git
( cd tuxonice-kernel ; git checkout origin/tuxonice-3.15 ; git reset --hard 1b3ff57
  git diff edfabbd | bzip2 > ../current-tuxonice-for-3.15.8.patch.bz2 )
git clone https://git.kernel.org/pub/scm/linux/kernel/git/mszeredi/vfs.git
( cd vfs ; git checkout origin/overlayfs.v22 ; git reset --hard 17eb601
  git diff 4b660a7 > ../overlayfs-3.15-rc6.patch )
wget ftp://plamo.linet.gr.jp/pub/Plamo-test/kernelsrc_patches/ovlfs/overlayfs-allow_unprivileged_mounts.patch

cd linux-3.15
unxz -c ../patch-3.15.10.xz | patch -Np1 -i -
patch -Np1 -i ../vd_unicon-kernel-20140614-3.15.patch
bunzip2 -c ../vd_unicon-kernel-fonts-20140614.patch.bz2 | patch -Np1 -i -
patch -Np1 -i ../aufs3-standalone/aufs3-kbuild.patch
patch -Np1 -i ../aufs3-standalone/aufs3-base.patch
patch -Np1 -i ../aufs3-standalone/aufs3-mmap.patch
patch -Np1 -i ../aufs3-standalone/aufs3-standalone.patch
cp -av ../aufs3-standalone/Documentation .
cp -av ../aufs3-standalone/fs .
cp -pv ../aufs3-standalone/include/uapi/linux/aufs_type.h include/uapi/linux
patch -Np1 -i ../3.15-panic_beep.patch
patch -Np1 -i ../3.15-morse_code_panics.patch
bunzip2 -c ../current-tuxonice-for-3.15.8.patch.bz2 | patch -Np1 -i -
patch -Np1 -i ../overlayfs-3.15.1.patch
patch -Np1 -i ../overlayfs-allow_unprivileged_mounts.patch
find . -name "*.orig" -ls -exec rm {} \;
