#!/bin/sh -x

wget -q https://www.kernel.org/pub/linux/kernel/v3.x/linux-3.14.tar.xz
tar xpJf linux-3.14.tar.xz

wget https://www.kernel.org/pub/linux/kernel/v3.x/patch-3.14.8.xz
wget ftp://plamo.linet.gr.jp/pub/Plamo-test/kernelsrc_patches/UNICON/vd_unicon-kernel-20140405-3.14.patch
wget http://vdlinux.sourceforge.jp/dists/UNICON/vd_unicon-kernel-fonts-20040205.patch.bz2
git clone git://git.code.sf.net/p/aufs/aufs3-standalone.git
( cd aufs3-standalone ; git checkout origin/aufs3.14 ; git reset --hard d201c50 )
wget ftp://plamo.linet.gr.jp/pub/Plamo-test/kernelsrc_patches/mcp/3.14-panic_beep.patch
wget ftp://plamo.linet.gr.jp/pub/Plamo-test/kernelsrc_patches/mcp/3.14-morse_code_panics.patch
git clone git://github.com/NigelCunningham/tuxonice-kernel.git
( cd tuxonice-kernel ; git checkout origin/tuxonice-3.14 ; git reset --hard 9cc8fd6
  git diff 0314057 | bzip2 > ../current-tuxonice-for-3.14.5.patch.bz2 )
git clone https://git.kernel.org/pub/scm/linux/kernel/git/mszeredi/vfs.git
( cd vfs ; git checkout origin/overlayfs.v21 ; git reset --hard 6025894
  git diff d6e0a2d > ../overlayfs-3.13-rc7.patch )
wget ftp://plamo.linet.gr.jp/pub/Plamo-test/kernelsrc_patches/ovlfs/overlayfs-allow_unprivileged_mounts.patch

cd linux-3.14
unxz -c ../patch-3.14.8.xz | patch -Np1 -i -
patch -Np1 -i ../vd_unicon-kernel-20140405-3.14.patch
bunzip2 -c ../vd_unicon-kernel-fonts-20040205.patch.bz2 | patch -Np1 -i -
patch -Np1 -i ../aufs3-standalone/aufs3-kbuild.patch
patch -Np1 -i ../aufs3-standalone/aufs3-base.patch
patch -Np1 -i ../aufs3-standalone/aufs3-mmap.patch
patch -Np1 -i ../aufs3-standalone/aufs3-standalone.patch
cp -av ../aufs3-standalone/Documentation .
cp -av ../aufs3-standalone/fs .
cp -pv ../aufs3-standalone/include/uapi/linux/aufs_type.h include/uapi/linux
patch -Np1 -i ../3.14-panic_beep.patch
patch -Np1 -i ../3.14-morse_code_panics.patch
bunzip2 -c ../current-tuxonice-for-3.14.5.patch.bz2 | patch -Np1 -i -
patch -Np1 -i ../overlayfs-3.14.patch
patch -Np1 -i ../overlayfs-allow_unprivileged_mounts.patch
find . -name "*.orig" -ls -exec rm {} \;
