#!/bin/sh -x

wget -q http://www.kernel.org/pub/linux/kernel/v2.6/linux-2.6.39.tar.bz2
tar xpjf linux-2.6.39.tar.bz2

wget http://www.kernel.org/pub/linux/kernel/v2.6/patch-2.6.39.4.bz2
wget ftp://plamo.linet.gr.jp/pub/Plamo-test/kernelsrc_patches/UNICON/vd_unicon-kernel-20110521-2.6.39.patch
wget http://vdlinux.sourceforge.jp/dists/UNICON/vd_unicon-kernel-fonts-20040205.patch.bz2
wget ftp://plamo.linet.gr.jp/pub/Plamo-test/kernelsrc_patches/misc/2.6.31-export-init_mm.patch
git clone http://git.c3sl.ufpr.br/pub/scm/aufs/aufs2-standalone.git
( cd aufs2-standalone ; git checkout origin/aufs2.1-39 ; git reset --hard f0d6cc5 )
wget ftp://plamo.linet.gr.jp/pub/Plamo-test/kernelsrc_patches/sqlzma/2.6.38-sqlzma.tar.gz
tar xvpzf 2.6.38-sqlzma.tar.gz
wget ftp://plamo.linet.gr.jp/pub/Plamo-test/kernelsrc_patches/sqlzma/2.6.38-sqlzma_decompress_unxz.patch
wget ftp://plamo.linet.gr.jp/pub/Plamo-test/kernelsrc_patches/mcp/2.6.39-panic_beep.patch
wget ftp://plamo.linet.gr.jp/pub/Plamo-test/kernelsrc_patches/mcp/2.6.39-morse_code_panics.patch

cd linux-2.6.39
bunzip2 -c ../patch-2.6.39.4.bz2 | patch -Np1 -i -
patch -Np1 -i ../vd_unicon-kernel-20110521-2.6.39.patch
bunzip2 -c ../vd_unicon-kernel-fonts-20040205.patch.bz2 | patch -Np1 -i -
patch -Np1 -i ../2.6.31-export-init_mm.patch
patch -Np1 -i ../aufs2-standalone/aufs2-kbuild.patch
patch -Np1 -i ../aufs2-standalone/aufs2-base.patch
patch -Np1 -i ../aufs2-standalone/aufs2-standalone.patch
cp -av ../aufs2-standalone/Documentation .
cp -av ../aufs2-standalone/fs .
cp -pv ../aufs2-standalone/include/linux/aufs_type.h include/linux
mkdir Documentation/aufs
cp -av ../aufs2-standalone/{COPYING,ChangeLog,README,design} Documentation/aufs
sqlzma_pdir=2.6.38-sqlzma/patches
patch -Np1 -i ../$sqlzma_pdir/0001-Squashfs-add-support-for-LZMA-compressed-filesystems.patch
patch -Np1 -i ../$sqlzma_pdir/0002-lzma-Make-lzma-available-to-non-initramfs-initrd-cod.patch
patch -Np1 -i ../$sqlzma_pdir/0003-Squashfs-select-DECOMPRESS_LZMA_NEEDED-when-includin.patch
patch -Np1 -i ../$sqlzma_pdir/0004-lzma-make-lzma-reentrant.patch
patch -Np1 -i ../$sqlzma_pdir/0005-libs-force-lzma_wrapper-to-be-retained.patch
patch -Np1 -i ../$sqlzma_pdir/0006-squashfs-add-missing-slab.h-include-in-lzma_wrapper.patch
patch -Np1 -i ../2.6.38-sqlzma_decompress_unxz.patch
patch -Np1 -i ../2.6.39-panic_beep.patch
patch -Np1 -i ../2.6.39-morse_code_panics.patch
find . -name "*.orig" -ls -exec rm {} \;
