#!/bin/sh
#
#                           Time-stamp: <2004-03-07 18:47:19 cyamauch>
#                           Time-stamp: <2011-10-08 16:48:55 tamuki>

DEFAULT_ENV_DIRNAME=Default

if [ -z "$1" ] ; then
  echo "Specify Source directory."
  exit 0
fi

SOURCE_DIR=$1
DEFAULT_ENV_DIR=$SOURCE_DIR/../$DEFAULT_ENV_DIRNAME

FSIZE_UI=${2:-12}
FSIZE_TERM=${3:-14}
FSIZE_EDITOR=${4:-16}
FSIZE_UI_SMALL=$((FSIZE_UI - 2))
FSIZE_UI_LARGE=$((FSIZE_UI + 2))

echo "[User Interface    : $FSIZE_UI pixels]"
echo "[Terminal and Text : $FSIZE_TERM pixels]"
echo "[Editor (emacs)    : $FSIZE_EDITOR pixels]"

rm -rf $DEFAULT_ENV_DIR
cp -a $SOURCE_DIR $DEFAULT_ENV_DIR

LST=`grep "@FSIZE_" $SOURCE_DIR/.* | cut -d: -f1 | sort -u`
for i in $LST ; do
  cat $i | sed -e "s/@FSIZE_UI@/$FSIZE_UI/g" \
      -e "s/@FSIZE_UI_SMALL@/$FSIZE_UI_SMALL/g" \
      -e "s/@FSIZE_UI_LARGE@/$FSIZE_UI_LARGE/g" \
      -e "s/@FSIZE_TERM@/$FSIZE_TERM/g" \
      -e "s/@FSIZE_EDITOR@/$FSIZE_EDITOR/g" \
      > `echo $i | sed "s/Source/$DEFAULT_ENV_DIRNAME/"`
done

if (( $FSIZE_TERM < 16 )) ; then (
  cd $DEFAULT_ENV_DIR
  cat .dir_colors_medium > .dir_colors
  rm .dir_colors_medium
) fi
