-- Copyright (c) 2004-2005 Sean Chittenden <sean@chittenden.org>
-- Copyright (c) 2007 Neil Conway <neilc@samurai.com>
-- Copyright (c) 2007 Open Technology Group, Inc. <http://www.otg-nc.com>
-- Copyright (c) 2008-2009 Hannu Valtonen <hannu.valtonen@hut.fi>
--
--$PostgreSQL: pgmemcache/pgmemcache.sql.in,v 1.12 2009/11/29 18:20:23 ormod Exp $
--
-- See the file COPYING for distribution terms.

-- Adjust this setting to control where the objects get created.
SET search_path = public;

-- $1 = server hostname - TEXT
CREATE OR REPLACE FUNCTION memcache_server_add(TEXT) RETURNS BOOL
AS '$libdir/pgmemcache', 'memcache_server_add' LANGUAGE 'C' STRICT;

-- $1 = key - TEXT
-- $2 = val - TEXT (opt)
-- $3 = expire - INTERVAL or TIMESTAMPTZ (opt)
-- $4 = flags - INT4 (opt)
CREATE OR REPLACE FUNCTION memcache_add(TEXT, TEXT, INTERVAL) RETURNS BOOL
AS '$libdir/pgmemcache', 'memcache_add' LANGUAGE 'C';

CREATE OR REPLACE FUNCTION memcache_add(TEXT, TEXT, TIMESTAMPTZ) RETURNS BOOL
AS '$libdir/pgmemcache', 'memcache_add_absexpire' LANGUAGE 'C';

CREATE OR REPLACE FUNCTION memcache_add(TEXT, TEXT) RETURNS BOOL
AS '$libdir/pgmemcache', 'memcache_add' LANGUAGE 'C';


CREATE OR REPLACE FUNCTION memcache_get(TEXT) RETURNS TEXT
AS '$libdir/pgmemcache', 'memcache_get' LANGUAGE 'C';

CREATE OR REPLACE FUNCTION memcache_get(BYTEA) RETURNS TEXT
AS '$libdir/pgmemcache', 'memcache_get' LANGUAGE 'C';

CREATE OR REPLACE FUNCTION memcache_get_multi(IN TEXT[], OUT key TEXT, OUT value TEXT) RETURNS SETOF record
AS '$libdir/pgmemcache', 'memcache_get_multi' LANGUAGE 'C';

CREATE OR REPLACE FUNCTION memcache_get_multi(IN BYTEA[], OUT key TEXT, OUT value TEXT) RETURNS SETOF record
AS '$libdir/pgmemcache', 'memcache_get_multi' LANGUAGE 'C';

-- $1 = key - TEXT
-- $2 = decrement - INT4, default 1 (opt)
CREATE OR REPLACE FUNCTION memcache_decr(TEXT, INT4) RETURNS INT4
AS '$libdir/pgmemcache', 'memcache_decr' LANGUAGE 'C';

CREATE OR REPLACE FUNCTION memcache_decr(TEXT) RETURNS INT4
AS '$libdir/pgmemcache', 'memcache_decr' LANGUAGE 'C';


-- $1 = key - TEXT
-- $2 = increment - INT4, default 1 (opt)
CREATE OR REPLACE FUNCTION memcache_incr(TEXT, INT4) RETURNS INT4
AS '$libdir/pgmemcache', 'memcache_incr' LANGUAGE 'C' STRICT;

CREATE OR REPLACE FUNCTION memcache_incr(TEXT) RETURNS INT4
AS '$libdir/pgmemcache', 'memcache_incr' LANGUAGE 'C' STRICT;


-- $1 = key - TEXT
-- $2 = hold timer - INTERVAL (opt)
CREATE OR REPLACE FUNCTION memcache_delete(TEXT, INTERVAL) RETURNS BOOL
AS '$libdir/pgmemcache', 'memcache_delete' LANGUAGE 'C';

CREATE OR REPLACE FUNCTION memcache_delete(TEXT) RETURNS BOOL
AS '$libdir/pgmemcache', 'memcache_delete' LANGUAGE 'C';

-- Flush all servers in the cluster
CREATE OR REPLACE FUNCTION memcache_flush_all() RETURNS BOOL
AS '$libdir/pgmemcache', 'memcache_flush_all0' LANGUAGE 'C';

-- $1 = key - TEXT
-- $2 = val - TEXT
-- $3 = expire - INTERVAL or TIMESTAMPTZ (opt)
CREATE OR REPLACE FUNCTION memcache_replace(TEXT, TEXT, INTERVAL) RETURNS BOOL
AS '$libdir/pgmemcache', 'memcache_replace' LANGUAGE 'C';

CREATE OR REPLACE FUNCTION memcache_replace(TEXT, TEXT, TIMESTAMPTZ) RETURNS BOOL
AS '$libdir/pgmemcache', 'memcache_replace_absexpire' LANGUAGE 'C';

CREATE OR REPLACE FUNCTION memcache_replace(TEXT, TEXT) RETURNS BOOL
AS '$libdir/pgmemcache', 'memcache_replace' LANGUAGE 'C';

-- $1 = key - TEXT
-- $2 = val - TEXT
-- $3 = expire - INTERVAL or TIMESTAMPTZ (opt)
CREATE OR REPLACE FUNCTION memcache_set(TEXT, TEXT, INTERVAL) RETURNS BOOL
AS '$libdir/pgmemcache', 'memcache_set' LANGUAGE 'C';

CREATE OR REPLACE FUNCTION memcache_set(TEXT, TEXT, TIMESTAMPTZ) RETURNS BOOL
AS '$libdir/pgmemcache', 'memcache_set_absexpire' LANGUAGE 'C';

CREATE OR REPLACE FUNCTION memcache_set(TEXT, TEXT) RETURNS BOOL
AS '$libdir/pgmemcache', 'memcache_set' LANGUAGE 'C';

CREATE OR REPLACE FUNCTION memcache_set(BYTEA, TEXT) RETURNS BOOL
AS '$libdir/pgmemcache', 'memcache_set' LANGUAGE 'C';

-- $1 = key - TEXT
-- $2 = val - TEXT
-- $3 = expire - INTERVAL or TIMESTAMPTZ (opt)
CREATE OR REPLACE FUNCTION memcache_prepend(TEXT, TEXT, INTERVAL) RETURNS BOOL
AS '$libdir/pgmemcache', 'memcache_prepend' LANGUAGE 'C';

CREATE OR REPLACE FUNCTION memcache_prepend(TEXT, TEXT, TIMESTAMPTZ) RETURNS BOOL
AS '$libdir/pgmemcache', 'memcache_prepend_absexpire' LANGUAGE 'C';

CREATE OR REPLACE FUNCTION memcache_prepend(TEXT, TEXT) RETURNS BOOL
AS '$libdir/pgmemcache', 'memcache_prepend' LANGUAGE 'C';

-- $1 = key - TEXT
-- $2 = val - TEXT
-- $3 = expire - INTERVAL or TIMESTAMPTZ (opt)
CREATE OR REPLACE FUNCTION memcache_append(TEXT, TEXT, INTERVAL) RETURNS BOOL
AS '$libdir/pgmemcache', 'memcache_append' LANGUAGE 'C';

CREATE OR REPLACE FUNCTION memcache_append(TEXT, TEXT, TIMESTAMPTZ) RETURNS BOOL
AS '$libdir/pgmemcache', 'memcache_append_absexpire' LANGUAGE 'C';

CREATE OR REPLACE FUNCTION memcache_append(TEXT, TEXT) RETURNS BOOL
AS '$libdir/pgmemcache', 'memcache_append' LANGUAGE 'C';


-- $1 = key - TEXT
-- $2 = val - TEXT
-- $3 = expire - INTERVAL or TIMESTAMPTZ (opt)
CREATE OR REPLACE FUNCTION memcache_prepend(TEXT, TEXT, INTERVAL) RETURNS BOOL
AS '$libdir/pgmemcache', 'memcache_prepend' LANGUAGE 'C';

CREATE OR REPLACE FUNCTION memcache_prepend(TEXT, TEXT, TIMESTAMPTZ) RETURNS BOOL
AS '$libdir/pgmemcache', 'memcache_prepend_absexpire' LANGUAGE 'C';

CREATE OR REPLACE FUNCTION memcache_prepend(TEXT, TEXT) RETURNS BOOL
AS '$libdir/pgmemcache', 'memcache_prepend' LANGUAGE 'C';

-- $1 = key - TEXT
-- $2 = val - TEXT
-- $3 = expire - INTERVAL or TIMESTAMPTZ (opt)
CREATE OR REPLACE FUNCTION memcache_append(TEXT, TEXT, INTERVAL) RETURNS BOOL
AS '$libdir/pgmemcache', 'memcache_append' LANGUAGE 'C';

CREATE OR REPLACE FUNCTION memcache_append(TEXT, TEXT, TIMESTAMPTZ) RETURNS BOOL
AS '$libdir/pgmemcache', 'memcache_append_absexpire' LANGUAGE 'C';

CREATE OR REPLACE FUNCTION memcache_append(TEXT, TEXT) RETURNS BOOL
AS '$libdir/pgmemcache', 'memcache_append' LANGUAGE 'C';


CREATE OR REPLACE FUNCTION memcache_stats() RETURNS TEXT
AS '$libdir/pgmemcache', 'memcache_stats' LANGUAGE 'C';

-- $1 = stat name - TEXT
CREATE OR REPLACE FUNCTION memcache_stats(TEXT) RETURNS TEXT
AS '$libdir/pgmemcache', 'memcache_stat' LANGUAGE 'C' STRICT;
