#!/bin/bash
# memcached	(http://www.danga.com/memcached/)
#	BuildScript for Plamo Linux 4.71
#			by Jun Kuwamura <juk@linet.gr.jp> on 2009-12-10
# require:
#	libevent-1.4.x
#
SRC_URI=http://memcached.googlecode.com/files/memcached-1.4.4.tar.gz
SRC_FILE=${SRC_URI##*/}
SRC_NAME=${SRC_FILE%%.tar.gz}
PAC_NAME=${SRC_NAME%%-stable}


REL=P1
CPU=i586
SYS_NAME="${CPU}-${REL}"

PLAMO=/expo/Build
SRC_DIR=$PLAMO/Archive/network
PAC_DIR=$PLAMO/Packages/4.7/Memcache
BUILD_DIR=$PLAMO/memcached
CUSTOM_DIR=$BUILD_DIR/Custom

echo $PAC_DIR
if [ ! -d $PAC_DIR ]; then
  mkdir -p  $PAC_DIR
fi
echo $SRC_DIR/$SRC_FILE
if [ ! -f $SRC_DIR/$SRC_FILE ]; then
  if [ ! -d $SRC_DIR ]; then
    mkdir -p $SRC_DIR
  fi
  ( cd $SRC_DIR; wget $SRC_URI )
fi


umask 022
CWD=`pwd`
WORK=$CWD/work
rm -rf $WORK/*
mkdir -p $WORK
export LANG=C
export LC_ALL=C
export CFLAGS="-O2 -march=$CPU"
export PATH=$PATH:/usr/X11R7/bin


tar xvfz $SRC_DIR/$SRC_FILE
cd $PAC_NAME
./configure --prefix=/usr

make
make install DESTDIR=$WORK

DOC_DIR=$WORK/usr/share/doc/$PAC_NAME
mkdir -p $DOC_DIR
cp -p $BUILD_DIR/`basename $0`  \
    AUTHORS COPYING ChangeLog NEWS README \
    doc/*.txt  \
  $DOC_DIR/
chown -R root.root $DOC_DIR/
chmod -R a+rX,go-w $DOC_DIR/


cd $WORK
echo "y
1
" | makepkg ${PAC_NAME}.tgz

echo -n "$PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz"
if `mv -v ${PAC_NAME}.tgz  $PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz 1>/dev/null 2>&1`; then
  echo " ... done"
else
  echo " ... false"
fi

cd $CWD
