<?php
 /*
 PukiWiki イベント・リスト(登録)プラグイン ver. 2009-04-18
 	  					 by J.Kuwamura

  2010-05-17 Add entry limit number for registration and banquet(req. alter table).
  2010-05-08 Mod display form values set in db on edit mode.
  2009-04-18 Mod display only in administration mode.
  2009-04-12 Ren renamed to eventlist.inc.php for evententry.inc.php
  2009-04-11 Mod minimum table
  2009-04-05 New registerlist for registerform.inc.php
 */
			      
///////////////////////////////////////////////////////////////////
// BENKYOKAI的設定項目
//
// BENKYOKAI的設定項目: データベースとテーブル名
// (PDOのDSNにて指定してください。)
//$GLOBALS['dsn'] = "sqlite:".DATA_HOME."/counter/eventlist.sq3";
$GLOBALS['dsn'] = "sqlite:counter/eventlist.sq3";
$GLOBALS['atable'] = "eventlist";
//
// BENKYOKAI的設定項目: 管理モード
// (管理者用のページを指定することができます。)
$GLOBALS['admin'] = ($_SERVER["PHP_AUTH_USER"]=="jpadm")?1:0;
//
///////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////
// プラグインで利用するグローバル変数
// 時刻フォーマット
$GLOBALS['regtform'] = '%Y-%m-%d %H:%M';	// e.x. '2009-04-05 19:00'
// 現時刻
$GLOBALS['timenow'] = time();			// unix time(u_int type)

//項目名
$GLOBALS['eventlist_values']['lab']['id'] = "＃";
$GLOBALS['eventlist_values']['lab']['acckey'] = "イベント情報アクセスキー";
$GLOBALS['eventlist_values']['lab']['tblname'] = "テーブル名";
$GLOBALS['eventlist_values']['lab']['title'] = "イベントのタイトル";
$GLOBALS['eventlist_values']['lab']['entrylimit'] = "募集人数";
$GLOBALS['eventlist_values']['lab']['optconfirm'] = "メール確認オプションフラグ";
$GLOBALS['eventlist_values']['lab']['optsns'] = "メンバー公開オプションフラグ";
$GLOBALS['eventlist_values']['lab']['optbanquet'] = "懇親会オプションフラグ";
$GLOBALS['eventlist_values']['lab']['banquetmsg'] = "懇親会案内文";
$GLOBALS['eventlist_values']['lab']['banquetwarn'] = "懇親会注意事項";
$GLOBALS['eventlist_values']['lab']['banquetlimit'] = "懇親会募集人数";
$GLOBALS['eventlist_values']['lab']['optnews'] = "お知らせ配信オプションフラグ";
$GLOBALS['eventlist_values']['lab']['newsinquery'] = "お知らせ配信案内文";
$GLOBALS['eventlist_values']['lab']['regtform'] = "受付開始終了日時の書式";
$GLOBALS['eventlist_values']['lab']['regtstart'] = "受付開始日時";
$GLOBALS['eventlist_values']['lab']['regtend'] = "受付終了日時";
$GLOBALS['eventlist_values']['lab']['regpend'] = "懇親会受付終了";
$GLOBALS['eventlist_values']['lab']['jimukyoku'] = "主催者";
$GLOBALS['eventlist_values']['lab']['shitsumon'] = "主催者紹介文";
$GLOBALS['eventlist_values']['lab']['bjmail'] = "主催者メールアドレス";
$GLOBALS['eventlist_values']['lab']['bjurl'] = "主催者ウェブサイト";
$GLOBALS['eventlist_values']['lab']['bjlist'] = "主催者関連メールリスト";
$GLOBALS['eventlist_values']['lab']['timestamp'] = "最終更新日時";

//デフォルト値
$GLOBALS['eventlist_values']['def']['acckey'] = "";
$GLOBALS['eventlist_values']['def']['tblname'] = "";
$GLOBALS['eventlist_values']['def']['title'] = $vars['page'];
$GLOBALS['eventlist_values']['def']['entrylimit'] = "1";
$GLOBALS['eventlist_values']['def']['regtform'] = '%%Y-%%m-%%d %%H:%%M';
 $tstart = date('Y-m-d H:i', $GLOBALS['timenow']);		// now
 $tend = date('Y-m-d 00:00', $GLOBALS['timenow'] + 2419200);	// +4weaks
$GLOBALS['eventlist_values']['def']['regtstart'] = $tstart;
$GLOBALS['eventlist_values']['def']['regtend'] = $tend;

$GLOBALS['eventlist_values']['def']['optconfirm'] = "1";

$GLOBALS['eventlist_values']['def']['optsns'] = "0";

$GLOBALS['eventlist_values']['def']['optbanquet'] = "1";
$GLOBALS['eventlist_values']['def']['banquetmsg'] = "会費 ？,000円程度の懇親会を予定しております(当日の変更はできません)。";
$GLOBALS['eventlist_values']['def']['banquetwarn'] = "参加を希望されない方はチェックを外してください。";
$GLOBALS['eventlist_values']['def']['banquetlimit'] = "1";
 $pend = date('Y-m-d 23:59', $GLOBALS['timenow'] + 1814400);	// +3weaks
$GLOBALS['eventlist_values']['def']['regpend'] = $pend;

$GLOBALS['eventlist_values']['def']['optnews'] = "0";
$GLOBALS['eventlist_values']['def']['newsinquery'] = "今後、当事務局からのお知らせを受け取りたい場合はチェックをしてください。";

//事務局情報
$GLOBALS['eventlist_values']['def']['jimukyoku'] = "オープンソース勉強会事務局";
$GLOBALS['eventlist_values']['def']['shitsumon'] = "お問い合わせなどございましたら、以下にご連絡ください。";
$GLOBALS['eventlist_values']['def']['bjmail'] = 'kuwamura+eventlist-jimukyoku@example.com';
$GLOBALS['eventlist_values']['def']['bjurl'] = 'http://jimukyoku.example.jp/';
$GLOBALS['eventlist_values']['def']['bjlist'] = 'http://jimukyoku.example.jp/mailman/listinfo/study/';

//必須入力項目
$GLOBALS['eventlist_values']['req']['acckey'] = "1";
$GLOBALS['eventlist_values']['req']['tblname'] = "1";
$GLOBALS['eventlist_values']['req']['title'] = "1";
$GLOBALS['eventlist_values']['req']['entrylimit'] = "1";
$GLOBALS['eventlist_values']['req']['regtform'] = "1";
$GLOBALS['eventlist_values']['req']['regtstart'] = "1";
$GLOBALS['eventlist_values']['req']['regtend'] = "1";
$GLOBALS['eventlist_values']['req']['optconfirm'] = "0";
$GLOBALS['eventlist_values']['req']['optsns'] = "0";
$GLOBALS['eventlist_values']['req']['optbanquet'] = "0";
$GLOBALS['eventlist_values']['req']['banquetmsg'] = "0";
$GLOBALS['eventlist_values']['req']['banquetwarn'] = "0";
$GLOBALS['eventlist_values']['req']['banquetlimit'] = "0";
$GLOBALS['eventlist_values']['req']['regpend'] = "0";
$GLOBALS['eventlist_values']['req']['optnews'] = "0";
$GLOBALS['eventlist_values']['req']['newsinquery'] = "1";
$GLOBALS['eventlist_values']['req']['jimukyoku'] = "1";
$GLOBALS['eventlist_values']['req']['shitsumon'] = "0";
$GLOBALS['eventlist_values']['req']['bjmail'] = "1";
$GLOBALS['eventlist_values']['req']['bjurl'] = "0";
$GLOBALS['eventlist_values']['req']['bjlist'] = "0";


// 出力／データベースのエンコーディング
// (利用環境にあわせてください。)
define('OUTPUT_ENCODING', 'UTF-8');
define('DB_ENCODING', 'UTF-8');
///////////////////////////////////////////////////////////////////

function plugin_eventlist_init()
{
	$messages['_eventlist_messages'] = array(
		'msg_title' => '<p>メッセージ:%s</p>',
		'err' => "<p>エラー:%s</p>");
	set_plugin_messages($messages);
}


function _plugin_eventlist_strptime($strtime)
{
  $tma = strptime($strtime, $GLOBALS['regtform']);
  //tm_sec  	分未満の秒数 (0-61)
  //tm_min 	時間未満の分数 (0-59)
  //tm_hour 	0 時以降の時間数 (0-23)
  //tm_mday 	月内の日数 (1-31)
  //tm_mon 	1 月から数えた月数 (0-11)
  //tm_year 	1900 年以降の年
  //tm_wday 	日曜日からの日数 (0-6)
  //tm_yday 	1 月 1 日からの日数 (0-365)
  return (mktime($tma['tm_hour'], $tma['tm_min'], $tma['tm_sec'],
		 $tma['tm_mon']+1, $tma['tm_mday'], $tma['tm_year']+1900));
}

function _plugin_eventlist_isstart($regtstart)
{
  $t0 = _plugin_eventlist_strptime($regtstart);
  return ($t0<=$GLOBALS['timenow'])?1:0;
}

function _plugin_eventlist_isend($regtend)
{
  $t1 = _plugin_eventlist_strptime($regtend);
  return ($t1<$GLOBALS['timenow'])?1:0;
}  

//
// プラグイン登録アクション
//
function plugin_eventlist_action()
{
  global $post,$vars,$digest,$script;
  global $_btn_registerconfirm;

  $items = $GLOBALS['eventlist_values']['lab'];

  $error = array();
  foreach ($items as $l => $v) {
      $k = "from{$l}";
      $post[$k] = uniDecode($post[$k], OUTPUT_ENCODING);
      if ( $GLOBALS['eventlist_values']['req'][$l] ) {
	  if ( empty($post[$k]) ) {
	      $error[] = "{$v}を入力してください";
	  }
      }
  }

  if (count($error)) {
    // エラーのときはフォームに戻る
    $s = _plugin_eventlist_form($post, $error);
    
  } else {
    // DBエントリの確認
    $row = plugin_eventlist_search($post['fromtblname']);
    if ($row === false) {
	// DB登録
	$op = "登録";
	if ( plugin_eventlist_preentry($post) ) {
	    $st = "成功";

	} else {
	    $st = "失敗";
	    echo "<pre>"; print_r($post); echo "</pre>";
	}
    } else {
	// DB更新
	$op = "更新";
	if ( plugin_eventlist_fixentry($post) ) {
	    $st = "成功";

	} else {
	    $st = "失敗";
	    echo "<pre>"; print_r($post); echo "</pre>";
	}
    }

    // 結果の画面表示
    $s = <<<__EOD__
<div style="width:100%; text-align: left; background-color:#E0E0FE;">
<p>{$op}に{$st}しました。</p>
<p>
<br></p>
__EOD__;

  }

  $page = get_script_uri().key($vars);
  $s .= <<<__EOD__
      <form action="{$page}" method="post">
      <input type="submit" name="eventlist" value="{$_btn_registerconfirm}">
      </form>
__EOD__;

  print mb_convert_encoding($s, "UTF-8");

  exit;
}

//
// プラグイン
//
function plugin_eventlist_convert()
{
    global $vars, $post, $get, $auth_users;
  //echo basename($_SERVER["PHP_SELF"]);

  if ( $GLOBALS['admin'] == 0 ) {
      echo "This plugin must be used in administration mode!<br>\n";
      return;
  }

  $args = func_get_args();
  // serial
  if (isset($args[0])) {
      //$num = intval($args[0]);
      $GLOBALS['eventlist_values']['def']['tblname'] = trim(trim($args[0]), "'\"");
  } else {
      if ( empty($GLOBALS['eventlist_values']['def']['tblname']) ) {
	  $table = trim($vars['fromtblname']);
	  $GLOBALS['eventlist_values']['def']['tblname'] = $table;
	  $row = plugin_eventlist_search($table);
	  foreach ( $row as $l => $v ) {
	      $k = "from{$l}";
	      $vars[$k] = $v;
	  }
      }
  }
  if ( ! empty($GLOBALS['eventlist_values']['def']['tblname']) ) {
      return _plugin_eventlist_form($vars);
  } else {
      return _plugin_eventlist_list();
  }
}


//
// イベントリスト
//
function _plugin_eventlist_list()
{
    return plugin_eventlist_summary();
}

//
// イベント登録フォーム
//
function _plugin_eventlist_form($vars, $error = array())
{
    global $_btn_registersend;

    $lab = $GLOBALS['eventlist_values']['lab'];
    $def = $GLOBALS['eventlist_values']['def'];

  if (UA_PROFILE == 'keitai') {
    $errmsg = '<p>現在，携帯電話端末からは利用できません。</p>';
    return $errmsg;
  }

  $value = array();
  try {
    $query = "SELECT * FROM {$GLOBALS['atable']} where tblname = '{$def['tblname']}'";
    // 実行
    $dbh = new PDO($GLOBALS['dsn'], '', '');
    if ($dbh) {
      $dbh->setAttribute(PDO_ATTR_ERRMODE, PDO_ERRMODE_EXCEPTION);
      $sth = $dbh->prepare($query);
      if ($sth) {
        $sth->execute();
        $cols = $sth->fetch(PDO::FETCH_ASSOC);
        foreach ( $cols as $l => $v ) {
          $k = "from{$l}";
          $value[$k] = htmlspecialchars($v);
	  //echo "sth=>$k: ".$value[$k]."<br>\n";
        }
      }
    }
  } catch (PDOException $exception){
    $cols=$def;
  }

  foreach ($vars as $k => $v) {
      if (! isset($value[$k]) ){
          $value[$k] = htmlspecialchars($v);
	  //echo "vars=>$k: ".$value[$k]."<br>\n";
      }
  }

  foreach ( $def as $l => $v ) {
      $k = "from{$l}";
      if (! isset($value[$k]) ){
	  $value[$k] = htmlspecialchars($v);
	  //echo "def=>$k: ".$value[$k]."<br>\n";
      }
  }

  if ($value['fromoptconfirm'] == "1") {
    $value['fromoptconfirm_check'] = "checked";
  }
  if ($value['fromoptsns'] == "1") {
    $value['fromoptsns_check'] = "checked";
  }
  if ($value['fromoptbanquet'] == "1") {
    $value['fromoptbanquet_check'] = "checked";
  }
  if ($value['fromoptnews'] == "1") {
    $value['fromoptnews_check'] = "checked";
  }

  $string = "<div id='eventlist'>";

  if ($error) {
    $string .= "<ul class='arrowhead'>";
    foreach ($error as $errmsg) {
      $string .= "<li>$errmsg</li>";
    }
    $string .= "</ul>";
  }

  $button = "<input type=\"button\" name=\"eventlist\" value=\"$_btn_registersend\" onclick=\"eventlist_submit()\">\n";

  $string .= "<form action=\"$script\" method=\"post\">\n"
		 ."<input type=\"hidden\" name=\"refer\" value=\"{$vars['page']}\">\n"
		 ."<input type=\"hidden\" name=\"page\" value=\"{$vars['page']}\">\n"
		 ."<input type=\"hidden\" name=\"serial\" value=\"{$GLOBALS['serial']}\" id=\"serial\">\n"

		 ."<input type=\"hidden\" name=\"digest\" value=\"$digest\">\n"
		 ."<input type=\"hidden\" name=\"plugin\" value=\"eventlist\">\n"
		 ."<input type=\"hidden\" name=\"pcmd\" value=\"send\">\n";


  foreach ( array('optconfirm','optsns','optbanquet','optnews') as $aname ) {
      $cname = "from{$aname}";
      $add_js[$cname] = "query_string += \"&$cname=\" + (\$('{$cname}').checked ? \"1\" : \"\");\n";
      $cname_check = $value[$cname."_check"];
      $add_html[$cname] = <<<__EOD__
			<tr>
			  <th class="style_th">{$lab[$aname]}</th>
				<td class="style_td"><input type="checkbox" name="{$cname}" style="" {$cname_check} value="1" id="{$cname}">
			</tr>
__EOD__;
  }


  $indexpage = get_script_uri().'?'.$vars['page'];

  // post request with Ajax.Updater(prototype.js)
  $string .= <<<__EOD__
	<script type="text/javascript">
	<!--
	// <![CDATA[
	function eventlist_submit()
	{
		var query_string = "";

		if(window.location.search){
			var q=window.location.search.substring(1,window.location.search.length);
			var p = q.split('&');
			if (p[0])
				query_string = "page="+p[0];
		}
		if (! query_string)
		  query_string = "page={$vars['page']}";

		query_string += "&plugin=eventlist";
		query_string += "&fromacckey=" + escape($('fromacckey').value);
		query_string += "&fromtblname=" + escape($('fromtblname').value);
		query_string += "&fromtitle=" + escape($('fromtitle').value);
		query_string += "&fromentrylimit=" + escape($('fromentrylimit').value);
		query_string += "&fromregtform=" + escape($('fromregtform').value);
		query_string += "&fromregtstart=" + escape($('fromregtstart').value);
		query_string += "&fromregtend=" + escape($('fromregtend').value);
		%s
		%s
		%s
		query_string += "&frombanquetmsg=" + escape($('frombanquetmsg').value);
		query_string += "&frombanquetwarn=" + escape($('frombanquetwarn').value);
		query_string += "&frombanquetlimit=" + escape($('frombanquetlimit').value);
		query_string += "&fromregpend=" + escape($('fromregpend').value);
		%s
		query_string += "&fromnewsinquery=" + escape($('fromnewsinquery').value);
		query_string += "&fromjimukyoku=" + escape($('fromjimukyoku').value);
		query_string += "&fromshitsumon=" + escape($('fromshitsumon').value);
		query_string += "&frombjmail=" + escape($('frombjmail').value);
		query_string += "&frombjurl=" + escape($('frombjurl').value);
		query_string += "&frombjlist=" + escape($('frombjlist').value);

		ajax = new Ajax.Updater(
			'eventlist',
			'{$indexpage}',
			{
				'method': 'post',
				'parameters': query_string
	                });
	}
	// ]]>
	-->
	</script>
	    <div class="style_blockquote">
		<table border="0">
		<tbody>
	      <tr>
		<th class="style_th">{$lab['acckey']}</th>
		<td class="style_td"><input type="text" name="fromacckey" style="width: 384px;" value="" id="fromacckey"></td>
	      </tr>
	      <tr>
		<th class="style_th">{$lab['tblname']}</th>
		<td class="style_td">{$value['fromtblname']}<input type="hidden" name="fromtblname" value="{$value['fromtblname']}" id="fromtblname"></td>
	      </tr>
	      <tr>
		<th class="style_th">{$lab['title']}</th>
		<td class="style_td"><input type="text" name="fromtitle" style="width: 384px;" value="{$value['fromtitle']}" id="fromtitle"></td>
	      </tr>
	      <tr>
		<th class="style_th">{$lab['entrylimit']}</th>
		<td class="style_td"><input type="text" name="fromentrylimit" size="5" value="{$value['fromentrylimit']}" id="fromentrylimit"></td>
	      </tr>
	      <tr>
		<th class="style_th">{$lab['regtform']}</th>
		  <td class="style_td">{$GLOBALS['eventlist_values']['def']['regtform']}
		  <input type="hidden" name="fromregtform" size="16" value="{$GLOBALS['eventlist_values']['def']['regtform']}" id="fromregtform"></td>
	      </tr>
	      <tr>
		<th class="style_th">{$lab['regtstart']}</th>
		<td class="style_td"><input type="text" name="fromregtstart" size="16" value="{$value['fromregtstart']}" id="fromregtstart"></td>
	      </tr>
	      <tr>
		<th class="style_th">{$lab['regtend']}</th>
		<td class="style_td"><input type="text" name="fromregtend" size="16" value="{$value['fromregtend']}" id="fromregtend"></td>
	      </tr>
%s
%s
%s
	      <tr>
		<th class="style_th">{$lab['banquetmsg']}</th>
		<td class="style_td"><textarea name="frombanquetmsg" style="width: 384px;" rows="2" cols="40" id="frombanquetmsg">{$value['frombanquetmsg']}</textarea></td>
	      </tr>
	      <tr>
		<th class="style_th">{$lab['banquetwarn']}</th>
		<td class="style_td"><textarea name="frombanquetwarn" style="width: 384px;" rows="2" cols="40" id="frombanquetwarn">{$value['frombanquetwarn']}</textarea></td>
	      </tr>
	      <tr>
		<th class="style_th">{$lab['banquetlimit']}</th>
		<td class="style_td"><input type="text" name="frombanquetlimit" size="5" value="{$value['frombanquetlimit']}" id="frombanquetlimit"></td>
	      </tr>
	      <tr>
		<th class="style_th">{$lab['regpend']}</th>
		<td class="style_td"><input type="text" name="fromregpend" size="16" value="{$value['fromregpend']}" id="fromregpend"></td>
	      </tr>
%s
	      <tr>
		<th class="style_th">{$lab['newsinquery']}</th>
	<td class="style_td"><textarea name="fromnewsinquery" style="width: 384px;" rows="3" cols="40"  id="fromnewsinquery">{$value['fromnewsinquery']}</textarea></td>
	      </tr>
	      <tr>
		<th class="style_th">{$lab['jimukyoku']}</th>
		<td class="style_td"><input type="text" name="fromjimukyoku" style="width: 384px;" value="{$value['fromjimukyoku']}" id="fromjimukyoku"></td>
	      </tr>
	      <tr>
	      <th class="style_th">{$lab['shitsumon']}</th>
	      <td class="style_td"><textarea name="fromshitsumon" style="width: 384px;" rows="3" cols="40"  id="fromshitsumon">{$value['fromshitsumon']}</textarea></td>
	      </tr>
	      <tr>
		<th class="style_th">{$lab['bjmail']}</th>
		<td class="style_td"><input type="text" name="frombjmail" style="width: 384px;" value="{$value['frombjmail']}" id="frombjmail"></td>
	      </tr>
	      <tr>
		<th class="style_th">{$lab['bjurl']}</th>
		<td class="style_td"><input type="text" name="frombjurl" style="width: 384px;" value="{$value['frombjurl']}" id="frombjurl"></td>
	      </tr>
	      <tr>
		<th class="style_th">{$lab['bjlist']}</th>
		<td class="style_td"><input type="text" name="frombjlist" style="width: 384px;" value="{$value['frombjlist']}" id="frombjlist"></td>
	      </tr>

		</tbody>
			<tr>
				<th class="style_th" />
				<td class="style_td" style="text-align: center">$button</td>
			</tr>
		</table>
	    </div>
	 </form>
<br />
__EOD__;

  $string .= "</div>";

  // チェックボックス値を挿入
  $string = sprintf($string, 
		    $add_js['fromoptconfirm'],$add_js['fromoptsns'],
		    $add_js['fromoptbanquet'],$add_js['fromoptnews'],
		    $add_html['fromoptconfirm'],$add_html['fromoptsns'],
		    $add_html['fromoptbanquet'],$add_html['fromoptnews']);

  return $string;
}



//
// URL Encodedから、指定の文字エンコーディングへ変換 
//
function uniDecode($str, $charcode = 'EUC-JP')
{
	$text = preg_replace_callback("/%u[0-9A-Za-z]{4}/", "toUtf8", $str); 
	if ($charcode == 'UTF-8') {
	  return $text;
	} else {
	  return mb_convert_encoding($text, $charcode, 'utf-8');
	}
}

//
// URL Encodedから、utf-8へ変換 
//
function toUtf8($ar)
{
	foreach($ar as $val)
	{
		$val = intval(substr($val,2),16); 
		if ($val < 0x7F) {
			$c .= chr($val); 
		} elseif ($val < 0x800) {
			$c .= chr(0xC0 | ($val / 64)); 
			$c .= chr(0x80 | ($val % 64)); 
		} else {
			$c .= chr(0xE0 | (($val / 64) / 64)); 
			$c .= chr(0x80 | (($val / 64) % 64)); 
			$c .= chr(0x80 | ($val % 64)); 
		}
	} 
	return $c; 
}

//
// DB接続
//
function plugin_eventlist_conn()
{
  // 接続
  try {
    $dbh = new PDO($GLOBALS['dsn'], '', '');
    // 例外処理の有効化
    $dbh->setAttribute(PDO_ATTR_ERRMODE, PDO_ERRMODE_EXCEPTION);
    return $dbh;
  } catch (PDOException $exception){
    echo "DBError#1\n";
    echo $exception->getMessage();
    return false;
  }
}



//
// テーブル作成
//
function plugin_eventlist_create($dbh)
{
  // テーブルの定義
  $query = <<<_EOQ_
    CREATE TABLE {$GLOBALS['atable']}
	  (
	   id INTEGER PRIMARY KEY,	-- 識別番号
	   acckey  VARCHAR(32),		-- アクセスキー
	   tblname  VARCHAR(64) UNIQUE,	-- イベントテーブル名
	   title  VARCHAR(256),		-- イベントのタイトル
	   entrylimit INT,		-- イベントの募集人数
	   regtform  VARCHAR(128),	-- 受付の開始終了日時の書式
	   regtstart  DATETIME,		-- 受付開始日時
	   regtend  DATETIME,		-- 受付終了日時
   
	   -- 登録メール確認オプションフラグ
	   optconfirm bool NOT NULL DEFAULT true,
	   
	   -- 参加メンバー公開オプションフラグ
	   optsns  bool NOT NULL DEFAULT true,
	   
	   -- 懇親会オプションフラグ
	   optbanquet  bool NOT NULL DEFAULT true,
	   banquetmsg  VARCHAR(512),	-- 懇親会案内文
	   banquetwarn  VARCHAR(256),	-- 懇親会注意事項
	   banquetlimit  INT,		-- 懇親会募集人数
	   regpend  DATETIME,		-- 懇親会受付終了日時
	   
	   -- お知らせ配信オプションフラグ
	   optnews  bool NOT NULL DEFAULT false,
	   newsinquery  VARCHAR(256),	-- お知らせ配信案内文
	   
	   -- 主催者情報
	   jimukyoku  VARCHAR(128),	-- 主催者事務局名
	   shitsumon  VARCHAR(256),	-- 主催者事務局案内文

	   bjmail  VARCHAR(128),	-- 主催者メールアドレス
	   bjurl  VARCHAR(256),		-- 主催者ウェブサイト
	   bjlist  VARCHAR(256),	-- 主催者関連メールリスト
	   
	   timestamp DATETIME		-- レコード更新タイムスタンプ
	   );
_EOQ_;
  // テーブルの作成
  if (! $dbh->query($query) ) {
    echo "DBError#2\n";
    print_r($dbh->errorInfo());
    return false;
  }
  return true;
}


//
// 登録
//
function plugin_eventlist_insert($dbh, $post)
{
  // プレースホルダの用意
  $query = "INSERT INTO {$GLOBALS['atable']} ("
      ." optconfirm, optsns, title, optbanquet, banquetmsg, banquetwarn"
      .", optnews, newsinquery, regtform, regtstart, regtend, regpend"
      .", jimukyoku, shitsumon, bjmail, bjurl, bjlist"
      .", entrylimit, banquetlimit"
      .", tblname, acckey, timestamp"
    ." ) VALUES ("
      .":optconfirm, :optsns, :title, :optbanquet, :banquetmsg, :banquetwarn"
      . ", :optnews, :newsinquery, :regtform, :regtstart, :regtend,:regpend"
      . ", :jimukyoku, :shitsumon, :bjmail, :bjurl, :bjlist"
      . ", :entrylimit, :banquetlimit"
      . ", :tblname, :acckey, :timestamp"
    .")";

  if (!  $sth = $dbh->prepare($query) ) {
    echo "DBError#3";
    echo " ($query)\n";
    return false;
  }

  foreach ($post as $k => $v) {
      $l = substr($k, 4);
      if ( "$l" == "bjmail" ) {
	$v = str_replace(" ", "+", trim($v));
      }
      if ( strtoupper(mb_detect_encoding($v)) != DB_ENCODING ) {
	  $row[$l] = strip_tags(mb_convert_encoding($v, DB_ENCODING, 'auto'));
      } else {
	  $row[$l] = strip_tags($v);
      }
  }

  // 値のバインド
  $sth->bindParam(':optconfirm', $row['optconfirm'],	PDO::PARAM_INT);
  $sth->bindParam(':optsns',     $row['optsns'], 	PDO::PARAM_INT);
  $sth->bindParam(':title',      $row['title'],  	PDO::PARAM_STR, 256);
  $sth->bindParam(':optbanquet', $row['optbanquet'],	PDO::PARAM_INT);
  $sth->bindParam(':banquetmsg', $row['banquetmsg'],	PDO::PARAM_STR, 512);
  $sth->bindParam(':banquetwarn',$row['banquetwarn'],	PDO::PARAM_STR, 256);
  $sth->bindParam(':optnews',    $row['optnews'],	PDO::PARAM_INT);
  $sth->bindParam(':newsinquery',$row['newsinquery'],	PDO::PARAM_STR, 256);
  $sth->bindParam(':regtform',   $row['regtform'],	PDO::PARAM_STR, 128);
  $sth->bindParam(':regtstart',  $row['regtstart'],	PDO::PARAM_STR, 19);
  $sth->bindParam(':regtend',    $row['regtend'],	PDO::PARAM_STR, 19);
  $sth->bindParam(':regpend',    $row['regpend'],	PDO::PARAM_STR, 19);
  $sth->bindParam(':jimukyoku',  $row['jimukyoku'],	PDO::PARAM_STR, 128);
  $sth->bindParam(':shitsumon',  $row['shitsumon'],	PDO::PARAM_STR, 256);
  $sth->bindParam(':bjmail',     $row['bjmail'], 	PDO::PARAM_STR, 128);
  $sth->bindParam(':bjurl',      $row['bjurl'],  	PDO::PARAM_STR, 256);
  $sth->bindParam(':bjlist',     $row['bjlist'], 	PDO::PARAM_STR, 256);
  $sth->bindParam(':entrylimit', $row['entrylimit'], 	PDO::PARAM_INT);
  $sth->bindParam(':banquetlimit', $row['banquetlimit'], PDO::PARAM_INT);
  $sth->bindParam(':tblname',    $row['tblname'],  	PDO::PARAM_STR, 64);
  $sth->bindParam(':acckey',     $row['acckey'],    	PDO::PARAM_STR, 32);
  $now = date("Y-m-d G:i:s");	//'CURRENT_TIMESTAMP'
  $sth->bindParam(':timestamp',  $now,          	PDO::PARAM_STR, 19);

  // クエリを実行
  if (! $sth->execute() ) {
    echo "DBError#4\n";
    print_r($sth->errorInfo());
    return false;
  }
  // プレースホルダーを開放
  $sth = null;
  return true;
}

//
// 更新
//
function plugin_eventlist_update($dbh, $post)
{
  // プレースホルダの用意
  $query = "UPDATE {$GLOBALS['atable']} SET "
      ." optconfirm = :optconfirm, optsns = :optsns, title = :title,"
      ." optbanquet = :optbanquet, banquetmsg = :banquetmsg, banquetwarn = :banquetwarn,"
      ." optnews = :optnews, newsinquery = :newsinquery,"
      ." regtform = :regtform, regtstart = :regtstart, regtend = :regtend, regpend = :regpend,"
      ." jimukyoku = :jimukyoku, shitsumon = :shitsumon, bjmail = :bjmail, bjurl = :bjurl, bjlist = :bjlist,"
      ." entrylimit = :entrylimit, banquetlimit = :banquetlimit,"
      ." tblname = :tblname, acckey = :acckey, timestamp = :timestamp"
    ." WHERE tblname = :tblname AND acckey = :acckey";

  if (!  $sth = $dbh->prepare($query) ) {
    echo "DBError#3";
    echo " ($query)\n";
    return false;
  }

  foreach ($post as $k => $v) {
      $l = substr($k, 4);
      if ( "$l" == "bjmail" ) {
	$v = str_replace(" ", "+", trim($v));
      }
      if ( strtoupper(mb_detect_encoding($v)) != DB_ENCODING ) {
	  $row[$l] = strip_tags(mb_convert_encoding($v, DB_ENCODING, 'auto'));
      } else {
	  $row[$l] = strip_tags($v);
      }
  }

  // 値のバインド
  $sth->bindParam(':optconfirm', $row['optconfirm'],	PDO::PARAM_INT);
  $sth->bindParam(':optsns',     $row['optsns'], 	PDO::PARAM_INT);
  $sth->bindParam(':title',      $row['title'],  	PDO::PARAM_STR, 256);
  $sth->bindParam(':optbanquet', $row['optbanquet'],	PDO::PARAM_INT);
  $sth->bindParam(':banquetmsg', $row['banquetmsg'],	PDO::PARAM_STR, 512);
  $sth->bindParam(':banquetwarn',$row['banquetwarn'],	PDO::PARAM_STR, 256);
  $sth->bindParam(':optnews',    $row['optnews'],	PDO::PARAM_INT);
  $sth->bindParam(':newsinquery',$row['newsinquery'],	PDO::PARAM_STR, 256);
  $sth->bindParam(':regtform',   $row['regtform'],	PDO::PARAM_STR, 128);
  $sth->bindParam(':regtstart',  $row['regtstart'],	PDO::PARAM_STR, 19);
  $sth->bindParam(':regtend',    $row['regtend'],	PDO::PARAM_STR, 19);
  $sth->bindParam(':regpend',    $row['regpend'],	PDO::PARAM_STR, 19);
  $sth->bindParam(':jimukyoku',  $row['jimukyoku'],	PDO::PARAM_STR, 128);
  $sth->bindParam(':shitsumon',  $row['shitsumon'],	PDO::PARAM_STR, 256);
  $sth->bindParam(':bjmail',     $row['bjmail'], 	PDO::PARAM_STR, 128);
  $sth->bindParam(':bjurl',      $row['bjurl'],  	PDO::PARAM_STR, 256);
  $sth->bindParam(':bjlist',     $row['bjlist'], 	PDO::PARAM_STR, 256);
  $now = date("Y-m-d G:i:s");	//'CURRENT_TIMESTAMP'
  $sth->bindParam(':timestamp',  $now,          	PDO::PARAM_STR, 19);
  $sth->bindParam(':entrylimit', $row['entrylimit'], 	PDO::PARAM_INT);
  $sth->bindParam(':banquetlimit', $row['banquetlimit'], PDO::PARAM_INT);
  // 条件
  $sth->bindParam(':tblname',    $row['tblname'],  	PDO::PARAM_STR, 64);
  $sth->bindParam(':acckey',     $row['acckey'],   	PDO::PARAM_STR, 32);

  // クエリを実行
  if (! $sth->execute() ) {
    echo "DBError#6\n";
    print_r($sth->errorInfo());
    return false;
  }
  $ret = $sth->rowCount();

  // プレースホルダーを開放
  $sth = null;

  if ($ret>0) {
      return true;
  } else {
      return false;
  }
}

//
// イベントリスト
//
function plugin_eventlist_list($dbh, $admin=0)
{
    global $vars, $script, $_btn_edit, $_btn_insert;

  // クエリのステートメントを準備
  $tbl = "<div id=\"list\">\n";
  $query = "SELECT * FROM {$GLOBALS['atable']} order by id desc";

  $lab = $GLOBALS['eventlist_values']['lab'];
  try {
    // 実行
    $sth = $dbh->prepare($query);
    $sth->execute();

    $tbl .= <<<_EOR_
<style type="text/css">
<!--
#list_master {
	border-top-width: 2px;
	border-right-width: 2px;
	border-left-width: 2px;
	border-top-style: solid;
	border-right-style: solid;
	border-bottom-style: solid;
	border-left-style: solid;
#	border-top-color: #990000;
#	border-right-color: #990000;
#	border-left-color: #990000;
#	border-bottom-color: #990000;
	border-bottom-width: 1px;
	width: 550px;
}
#list_master th {
	padding: 5px;
	margin: 0px;
	border-bottom-width: 1px;
	border-bottom-style: solid;
	border-bottom-color: #990000;
	border-right-width: 1px;
	border-right-style: solid;
	border-right-color: #990000;
}
#list_master td {
	padding: 5px;
	margin: 0px;
	border-bottom-width: 1px;
	border-bottom-style: solid;
#	border-bottom-color: #990000;
	border-right-width: 1px;
	border-right-style: solid;
#	border-right-color: #990000;
}
#list_master .name {
	width: 150px;
}
#list_master .num {
	width: 20px;
	border-bottom-width: 2px;
	border-bottom-style: solid;
	text-align: center;
}
#list_master .comment {
	border-bottom-width: 2px;
	border-bottom-style: solid;
}
#list_master .haishin {
	width: 30px;
	text-align: center;
}
#list_master .konshinkai {
	width: 30px;
	text-align: center;
}
-->
</style>
_EOR_;

// リストヘッダ
if ($debug == 1) {
    $tbl .= <<<_EOR_
<table border="0" cellpadding="0" cellspacing="0" id="list_master">
  <tr>
      <th rowspan="4" class="style_th">{$lab['id']}</th>
      <!-- th class="style_th">{$lab['acckey']}</th -->
      <th class="style_th">状態</th>
      <th class="style_th">{$lab['tblname']}</th>
      <th class="style_th">{$lab['title']}</th>
      <th class="style_th">{$lab['optconfirm']}</th>
      <th class="style_th">{$lab['optsns']}</th>
  </tr>
  <tr>
      <th class="style_th">{$lab['optbanquet']}</th>
      <th class="style_th">{$lab['banquetmsg']}</th>
      <th class="style_th">{$lab['banquetwarn']}</th>

      <th class="style_th">{$lab['optnews']}</th>
      <th class="style_th">{$lab['newsinquery']}</th>
  </tr>
  <tr>
      <th class="style_th">{$lab['jimukyoku']}</th>
      <th class="style_th">{$lab['shitsumon']}</th>
      <th class="style_th">{$lab['bjmail']}</th>
      <th class="style_th">{$lab['bjurl']}</th>
      <th class="style_th">{$lab['bjlist']}</th>
  </tr>
  <tr>
      <th class="style_th">{$lab['regtform']}</th>
      <th class="style_th">{$lab['regtstart']}</th>
      <th class="style_th">{$lab['regtend']}</th>
      <th class="style_th">{$lab['regpend']}</th>
      <th class="style_th">{$lab['timestamp']}</th>
  </tr>
_EOR_;
} else {
    $tbl .= <<<_EOR_
<table border="0" cellpadding="0" cellspacing="0" id="list_master">
  <tr>
      <th rowspan="1" class="style_th">{$lab['id']}</th>
      <th class="style_th">状態</th>
      <th class="style_th">{$lab['tblname']}</th>
      <th class="style_th">{$lab['title']}</th>
      <th class="style_th">{$lab['jimukyoku']}</th>
      <th class="style_th">{$lab['regtstart']}</th>
      <th class="style_th">{$lab['regtend']}</th>
      <th class="style_th">{$lab['regpend']}</th>
  </tr>
_EOR_;
}

    // リスト内容出力
    $cols = array();
    $nl = 0;
    while ($cols = $sth->fetch(PDO::FETCH_ASSOC)) { 
      foreach ($cols as $k => $v) {
        if ( strtoupper(mb_detect_encoding($v)) != OUTPUT_ENCODING ) {
	  $cols[$k] =  mb_convert_encoding($v, OUTPUT_ENCODING, 'auto');
        }
        // タグが混じってしまった場合の対策
        $cols[$k] = str_replace(array("<",">"), "", strip_tags($cols[$k]));
	if (empty($cols[$k])) {
	    $cols[$k] = "　";
	}
      }

      // 受け付け期間のチェック
      if (! _plugin_eventlist_isstart($cols['regtstart']) ) {
	  $class_style = "style_td1"; $confirm_str = "準備中"; 
      } elseif (! _plugin_eventlist_isend($cols['regtend']) ) {
	  $class_style="style_td2"; $confirm_str = "受付中";
      } else {
	  $class_style = "style_td3"; $confirm_str = "受付終了";
      }

      // 懇親会の有無
      if ( intval($cols['optbanquet']) != 1 ) {
          $cols['regpend'] = "-";
      }

      if ($debug == 1) {
	  $tbl .= <<<__EOR__
<tr>
    <td rowspan="4" class=$class_style>
	    #{$cols['id']}
	    <form action="{$script}?{$vars['page']}" method="post">
	    <input type="hidden" name="page" value="{$vars['page']}">
	    <input type="hidden" name="fromtblname" value="{$cols['tblname']}">
	    <input type="submit" name="eventlist" value="{$_btn_edit}">
	    </form>
	    </td>
    <!-- td class=$class_style>{$cols['acckey']}</td -->
    <td class=$class_style>{$confirm_str}</td>
    <td class=$class_style>{$cols['tblname']}</td>
    <td class=$class_style>{$cols['title']}</td>
    <td class=$class_style>{$cols['optconfirm']}</td>
    <td class=$class_style>{$cols['optsns']}</td>
</tr>
<tr>
    <td class=$class_style>{$cols['optbanquet']}</td>
    <td class=$class_style>{$cols['banquetmsg']}</td>
    <td class=$class_style>{$cols['banquetwarn']}</td>

    <td class=$class_style>{$cols['optnews']}</td>
    <td class=$class_style>{$cols['newsinquery']}</td>
</tr>
<tr>
    <td class=$class_style>{$cols['jimukyoku']}</td>
    <td class=$class_style>{$cols['shitsumon']}</td>
    <td class=$class_style>{$cols['bjmail']}</td>
    <td class=$class_style>{$cols['bjurl']}</td>
    <td class=$class_style>{$cols['bjlist']}</td>
</tr>
<tr>
    <td class=$class_style>{$cols['regtform']}</td>
    <td class=$class_style>{$cols['regtstart']}</td>
    <td class=$class_style>{$cols['regtend']}</td>
    <td class=$class_style>{$cols['regpend']}</td>
    <td class=$class_style>{$cols['timestamp']}</td>
</tr>
__EOR__;
      } else {
	  $path = dirname($_SERVER['PHP_SELF']);
	  $tbl .= <<<__EOR__
<tr>
    <td rowspan="1" class=$class_style>
	    #{$cols['id']}
	    <form action="{$script}?{$vars['page']}" method="post">
	    <input type="hidden" name="page" value="{$vars['page']}">
	    <input type="hidden" name="fromtblname" value="{$cols['tblname']}">
	    <input type="submit" name="eventlist" value="{$_btn_edit}">
	    </form>
	    </td>
    <td class=$class_style>{$confirm_str}</td>
    <td class=$class_style>{$cols['tblname']}</td>
    <td class=$class_style><a href="$path/{$cols['title']}">{$cols['title']}</a></td>
    <td class=$class_style>{$cols['jimukyoku']}</td>
    <td class=$class_style>{$cols['regtstart']}</td>
    <td class=$class_style>{$cols['regtend']}</td>
    <td class=$class_style>{$cols['regpend']}</td>
</tr>
__EOR__;
      }

      $nl++;
    } 

    $tbl .= "    </tbody>  </table>\n";
    $tbl .= "</div>\n";
    // ステートメントを開放
    $sth = null;

    $tbl .= <<<__EOR__
	<br />
	<form action="{$script}?{$vars['page']}" method="post">
	<input type="hidden" name="page" value="{$vars['page']}">
	<b>エントリーの追加</b>=>
	テーブル名（重複のないように）:
	<input type="text" name="fromtblname" value="">
	<input type="submit" name="eventlist" value="{$_btn_insert}">
	</form>
__EOR__;


    return $tbl;
  } catch (PDOException $e) {
    echo "DBError#5\n";
    echo $e->getMessage();
    return false;
  }
}

//
// 登録イベント数
//
function plugin_eventlist_count($dbh)
{
  $query = "SELECT count(*) FROM {$GLOBALS['atable']}";
  if ($GLOBALS['optconfirm']) {
    $query .= " WHERE confirm = 1";
  }

  if (! $sth = $dbh->prepare($query) ) {
    if (! plugin_eventlist_create($dbh) ) {
      echo "DBError@_count!\n";
      return false;
    }
    if (! $sth = $dbh->prepare($query) ) {
      echo "SQLError@_count!\n";
      echo " ($query)\n";
      return false;
    }
  }
  if (! $sth->execute() ) {
    echo "QUELError@_count!\n";
    print_r($sth->errorInfo());
    return false;
  }
  $ret = $sth->fetchColumn();
  $sth = null;
  return $ret;
}

//
// 懇親会有の数
//
function plugin_eventlist_countmeeting($dbh)
{
  $query = "SELECT count(optbanquet) FROM {$GLOBALS['atable']} WHERE optbanquet = 1";
  if (! $sth = $dbh->prepare($query) ) {
    if (! plugin_eventlist_create($dbh) ) {
      echo "DBError@_countmeeting!\n";
      return false;
    }
    if (!  $sth = $dbh->prepare($query) ) {
      echo "SQLError@_countmeeting!\n";
      echo " ($query)\n";
      return false;
    }
  }
  if (! $sth->execute() ) {
    echo "QUELError@_countmeeting!\n";
    print_r($sth->errorInfo());
    return false;
  }
  $ret = $sth->fetchColumn();
  $sth = null;
  return $ret;
}

//
// 懇親会
//
function plugin_eventlist_countmeetingnull($dbh)
{
  $query = "SELECT count(optbanquet) FROM {$GLOBALS['atable']} WHERE optbanquet = 0";
  if (! $sth = $dbh->prepare($query) ) {
    if (! plugin_eventlist_create($dbh) ) {
      echo "DBError@_countmeeting!\n";
      return false;
    }
    if (!  $sth = $dbh->prepare($query) ) {
      echo "SQLError@_countmeeting!\n";
      echo " ($query)\n";
      return false;
    }
  }
  if (! $sth->execute() ) {
    echo "QUELError@_countmeeting!\n";
    print_r($sth->errorInfo());
    return false;
  }
  $ret = $sth->fetchColumn();
  $sth = null;
  return $ret;
}

//
// データベースへのエントリ登録
//
function plugin_eventlist_preentry($post)
{
  // DB接続
  if (! $dbh = plugin_eventlist_conn() ) {
    return false;
  }

  //// テーブル作成＝＞自動化（各所でエラー処理として行う）
  //if (! TABLE_CREATED ) {
  //  if (! plugin_eventlist_create($dbh) ) {
  //    return false;
  //  }
  //}
 
  // 登録
  if (! plugin_eventlist_insert($dbh, $post) ) {
    if (! plugin_eventlist_create($dbh) ) {
      return false;
    }
    if (! plugin_eventlist_insert($dbh, $post) ) {
      return false;
    }
  }

  //// リスト
  //$tbl = plugin_eventlist_list($dbh);

  return true;
}

//
// データベースへのエントリ更新
//
function plugin_eventlist_fixentry($post)
{
  // DB接続
  if (! $dbh = plugin_eventlist_conn() ) {
    return false;
  }

  //// テーブル作成＝＞自動化（各所でエラー処理として行う）
  //if (! TABLE_CREATED ) {
  //  if (! plugin_eventlist_create($dbh) ) {
  //    return false;
  //  }
  //}
 
  // 更新
  if (! plugin_eventlist_update($dbh, $post) ) {
      return false;
  }
  return true;
}

//
// 参加登録者サマリー
//
function plugin_eventlist_summary($dbh='')
{

  if (empty($dbh)) {
    // 登録者DBアクセス
    if (!  $dbh = plugin_eventlist_conn() ) {
      return "DB接続エラー！";
    }
  }

  // イベント数集計
  $now = date("Y-m-d G:i");
  $string .= "<p>{$now} 現在";
  $nentry = plugin_eventlist_count($dbh);
  $string .= "&nbsp;&nbsp;&nbsp;登録数: {$nentry}";
  $nbanqu = plugin_eventlist_countmeeting($dbh);
  $string .= "（懇親会有: {$nbanqu}）";
  $string .= "</p>";

  if ($GLOBALS['admin']) {
      // 現行リスト
      $string .= plugin_eventlist_list($dbh, 1);
  } else {
      $string .= plugin_eventlist_list($dbh, 1);
  }

  return $string;
}

//
// イベント検索
//
function plugin_eventlist_search($table, $key='')
{
  // イベントリストDBアクセス
  if (!  $dbh = plugin_eventlist_conn() ) {
    echo "接続エラー@_search！";
    return false;
  }

  $query = "SELECT * FROM {$GLOBALS['atable']}"
  	   . " WHERE tblname = '$table'";
  if (! empty($key) ) {
      $query .= " AND acckey = '$key'";
  }

  if (!  $sth = $dbh->prepare($query) ) {
    echo "DBError@_search!";
    echo " ($query)\n";
    return false;
  }
  if (! $sth->execute() ) {
    echo "SQLError@_search!\n";
    print_r($sth->errorInfo());
    return false;
  }
  $row = $sth->fetch(PDO::FETCH_ASSOC);
  $sth = null;

  return $row;
}
?>
