<?php
 /*
 
 PukiWiki イベント参加申込フォーム・プラグイン ver. 2009-04-12
 	  					 by J.Kuwamura

  2010-05-17 Add entry limit number check for registration and banquet.
  2010-05-17 Mod add banquet entry time expireing
  2010-05-10 Mod error processing and confirmation forms.
  2009-04-12 Ren renamed to evententry.inc.php with eventlist.inc.php
  2009-04-12 Mod use table variable for table specification instead of serial
  2009-04-09 Mod table name must be specified or page name is used
  2009-04-09 New delived from registerform.inc.php to use eventlist db,
  		also management plugin(eventlist.inc.php) added.

 <<This plugin was delived from registerform plugin.>>
 PukiWiki 登録フォームプラグイン ver. 2008-11-12
  2008-11-12 Registration(DB) added by J.Kuwamura

 PukiWiki メールフォームプラグイン ver. 2008-11-11 by J.Kuwamura
 delived from Ajax版 by masaki.fujimoto
  (version 1.4 of prototype.js is required)

 <<This originaly was a mailform plugin.>>
 PukiWiki メールフォームプラグイン ver. 2002-06-18
 CopyRight 2002 OKAWARA,Satoshi All rights reserved.
 http://www.dml.co.jp/~kawara/pukiwiki/pukiwiki.php
 kawara@dml.co.jp
 
 LANGUAGEファイルに下記の値を追加してからご使用ください
	$_btn_registersend	= '上記の内容で送信';
	$_btn_registerfinish	= '完了';
 */
			      
////////////////////////////////////////////////////////////////////////
// 以下、必要に応じて設定のこと
////////////////////////////////////////////////////////////////////////
// 現在時刻
$GLOBALS['timenow']   = time();

// PHP-PDO用のデータベース名DSN、および、管理テーブル名
// (registerlist.inc.php と合わせてください。)
$GLOBALS['dsn'] = "sqlite:counter/eventlist.sq3";
$GLOBALS['atable'] = "eventlist";


// 管理モード
// (管理者用のページを指定することができます。)
//$GLOBALS['admin'] = (basename($_SERVER["PHP_SELF"])=="ifadmin.php")?1:0;
$GLOBALS['admin'] = ($_SERVER["PHP_AUTH_USER"]=="jpadm")?1:0;

// 出力／データベースのエンコーディング(利用環境にあわせてください。)
define('OUTPUT_ENCODING', 'UTF-8');
define('DB_ENCODING', 'UTF-8');
///////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////
// 以下のBENKYOKAI的設定項目は eventlist.inc.php でDB登録する
///////////////////////////////////////////////////////////////////
// BENKYOKAI的設定項目: 登録確認のアクティベートフラグ
// (いたずら対策です)
$GLOBALS['active'] = true;

// BENKYOKAI的設定項目: 参加メンバー公開
// （エントリメンバ公開で宴会君のようなSNS的になります)
$GLOBALS['sns'] = true;

// BENKYOKAI的設定項目: 勉強会タイトル
$GLOBALS['title']="オープンソース勉強会";

// BENKYOKAI的設定項目: 懇親会案内
$GLOBALS['meeting'] = true;
$GLOBALS['banquet'] = "";
  //"会費 ？,000円程度の懇親会を予定しております(当日の変更はできません)。".
  //"<br />&nbsp;&nbsp;&nbsp;&nbsp;";
$GLOBALS['banqwarn'] = "<font color='red'>参加を希望されない方はチェックを外してください。</font>";

// BENKYOKAI的設定項目: お知らせ配信案内
$GLOBALS['news'] = false;
$GLOBALS['optinquery'] = "今後、当事務局からのお知らせを受け取りたい場合はチェックをしてください。";

// BENKYOKAI的設定項目: 登録の開始と終了
$GLOBALS['regtform'] = '%Y-%m-%d %H:%M';
$GLOBALS['regtstart'] = '2009-01-18 17:55';
$GLOBALS['regtend']   = '2009-03-01 00:00';


// BENKYOKAI的設定項目: 勉強会事務局
$GLOBALS['jimukyoku'] = "オープンソース勉強会事務局";
$GLOBALS['shitsumon'] = "お問い合わせなどございましたら、以下にご連絡ください。";

// BENKYOKAI的設定項目: 主催者連絡先
// ToDo:このあたりのデフォルトもDBから取り出したい（eventlistのほうで登録）
// (必ず届くメールアドレスを指定してください。)
//$GLOBALS['mailfrom'] = 'kuwamura+jimukyoku@example.com';
$GLOBALS['mailfrom'] = 'kuwamura+jimukyoku@example.com';
$GLOBALS['url'] = 'http://jimukyoku.example.jp/';
$GLOBALS['list'] = 'http://jimukyoku.example.jp/mailman/listinfo/study/';

// BENKYOKAI的設定項目: テーブル名
//$GLOBALS['table'] = "benkyokai";

//$GLOBALS['entryurl'] = "https://{$_SERVER["HTTP_HOST"]}{$_SERVER['PHP_SELF']}";
$GLOBALS['entryurl'] = "http://{$_SERVER["HTTP_HOST"]}{$_SERVER['PHP_SELF']}";
///////////////////////////////////////////////////////////////////



function _plugin_evententry_definition($table)
{
    global $vars, $error_string;

    ///////////////////////////////////////////////////////////////////
    // 以下の設定項目は registerlist.inc.php で設定のこと
    ///////////////////////////////////////////////////////////////////
    // イベントリストDBアクセス
    if (!  $dbh = plugin_evententry_conn() ) {
      syslog(LOG_DEBUG,"pukiwiki: DBError@_definition！(connect {$GLOBALS['atable']})");
	return false;
    }

    $query = "SELECT * FROM {$GLOBALS['atable']}"
	. " WHERE tblname = '{$table}'";

    if (!  $sth = $dbh->prepare($query) ) {
	syslog(LOG_DEBUG,"pukiwiki: DBError@_definition!(preare $table)\n\t $query");
	return false;
    }
    if (! $sth->execute() ) {
	syslog(LOG_DEBUG,"pukiwiki: DBError@_definition!(execute $table)\n\t $query");
	//print_r($sth->errorInfo());
	return false;
    }
    $row = $sth->fetch(PDO::FETCH_ASSOC);
    $sth = null;

    if ( empty($row) ) {
	echo "No data!\n";
	echo "table: ".$table;
	return false;
    }

    $GLOBALS['table'] = $table;

    // 登録確認アクティベーション用のメール送信フラグ(いたずら対策です)
    $GLOBALS['active'] = $row['optconfirm'];

    // 参加メンバー公開（エントリメンバ公開で宴会君のようなSNS的になります)
    $GLOBALS['sns'] = $row['optsns'];

    // 勉強会タイトル
    $GLOBALS['title'] = $row['title'];

    // 募集人数
    $GLOBALS['entrylimit'] = $row['entrylimit'];

    // 懇親会のオプションフラッグとその案内文
    $GLOBALS['meeting'] = $row['optbanquet'];
    $GLOBALS['banquet'] = $row['banquetmsg'];
    $GLOBALS['banqwarn'] = $row['banquetwarn'];
    $GLOBALS['banqlimit'] = $row['banquetlimit'];
    // 案内文の例：
    //"会費 ？,000円程度の懇親会を予定しております(当日の変更はできません)。".
    //"<br />&nbsp;&nbsp;&nbsp;&nbsp;";
    //"<font color='red'>参加を希望されない方はチェックを外してください。</font>";

    // お知らせ配信許諾のオプションフラグおよびその案内文
    $GLOBALS['news'] = $row['optnews'];
    $GLOBALS['optinquery'] = $row['newsinquery'];
    //"今後、当事務局からのお知らせを受け取りたい場合はチェックをしてください。";

    // 日時のフォーマット、および、登録の開始と終了日時
    $GLOBALS['regtform'] = $row['regtform'];	//'%Y-%m-%d %H:%M';
    $GLOBALS['regtstart'] = $row['regtstart'];	//'2009-01-18 17:55';
    $GLOBALS['regtend']   = $row['regtend'];	//'2009-03-01 00:00';
    // 懇親会の受付終了日時
    $GLOBALS['regpend']   = $row['regpend'];	//'2009-02-24 00:00';

    // 勉強会事務局
    $GLOBALS['jimukyoku'] = $row['jimukyoku'];
    $GLOBALS['shitsumon'] = $row['shitsumon'];

    // 事務局等の連絡先、Webページ、メーリングリスト
    // (必ず届くメールアドレスを指定してください。)
    $GLOBALS['mailfrom'] = $row['bjmail'];
    $GLOBALS['url'] = $row['bjurl'];
    $GLOBALS['list'] = $row['bjlist'];

    return true;
}

function _plugin_evententry_strptime($strtime)
{
  $tma = strptime($strtime, $GLOBALS['regtform']);
  //tm_sec  	分未満の秒数 (0-61)
  //tm_min 	時間未満の分数 (0-59)
  //tm_hour 	0 時以降の時間数 (0-23)
  //tm_mday 	月内の日数 (1-31)
  //tm_mon 	1 月から数えた月数 (0-11)
  //tm_year 	1900 年以降の年
  //tm_wday 	日曜日からの日数 (0-6)
  //tm_yday 	1 月 1 日からの日数 (0-365)
  return (mktime($tma['tm_hour'], $tma['tm_min'], 0, /* $tma['tm_sec'], */
		 $tma['tm_mon']+1, $tma['tm_mday'], $tma['tm_year']+1900));
}

function _plugin_evententry_isstart()
{
  $t0 = _plugin_evententry_strptime($GLOBALS['regtstart']);
  return ($t0<=$GLOBALS['timenow'])?1:0;
}

function _plugin_evententry_isend()
{
  $t1 = _plugin_evententry_strptime($GLOBALS['regtend']);
  return ($t1<$GLOBALS['timenow'])?1:0;
}  

function _plugin_evententry_banqend()
{
  $t1 = _plugin_evententry_strptime($GLOBALS['regpend']);
  return ($t1<$GLOBALS['timenow'])?1:0;
}  

function _plugin_evententry_before()
{
  $string = <<<__EOM__
  申し込みの受け付けはまだ始まっていません。<br />
  受け付けは、
    {$GLOBALS['regtstart']}
  〜
    {$GLOBALS['regtend']}
  に行う予定です。<br />
__EOM__;
  $string .= strftime($GLOBALS['regtform']) . "現在";
  return $string;
}

function _plugin_evententry_after()
{
  $string = <<<__EOM__
  申し込みの受け付けは終了しました。<br />
__EOM__;
  $string .= strftime($GLOBALS['regtform']) . "現在";

  return $string;
}

function _plugin_evententry_over_entrylimit()
{
  if ( $dbh = plugin_evententry_conn() ) {
    $nentry = plugin_evententry_count($dbh);
    syslog(LOG_DEBUG,"pukiwiki:evententry: number of entry = $nentry < {$GLOBALS['entrylimit']}");
    return ($nentry>=$GLOBALS['entrylimit'])?1:0;
  }
}  

function _plugin_evententry_over_banquetlimit()
{
  if ( $dbh = plugin_evententry_conn() ) {
    $nentry = plugin_evententry_countmeeting($dbh);
    syslog(LOG_DEBUG,"pukiwiki:evententry: number of banquetentry = $nentry < {$GLOBALS['banqlimit']}");
    return ($nentry>=$GLOBALS['banqlimit'])?1:0;
  }
}  

/////
/////
///// mailto_*
//
// 事務局へのメール
//
function plugin_evententry_mailto_secretariat($row='')
{
  global $post;

  $entryurl = $GLOBALS['entryurl']."?page={$post['page']}";
  $accesskey = urlencode(md5($post['fromaddress'].$post['fromname']));
  $confirmurl = $entryurl."&plugin={$post['plugin']}&table={$post['table']}&fromaddress={$post['fromaddress']}&fromkey={$accesskey}";

  if (empty($row)) {
    $row = plugin_evententry_search($post['fromaddress'], $accesskey);
  }

  // 事務局へ
  // メール通知
  $mailsubject = "［" . $GLOBALS['title'] . "］ <{$post['fromaddress']}>";
  //$mailsubject = mb_convert_encoding( $mailsubject, "ISO-2022-JP" );
  //$mailsubject = mb_encode_mimeheader($mailsubject, "ISO-2022-JP" );

  $mailbody = '';
  foreach ($row as $k => $v) {
    $mailbody .= "{$k}： {$v}\n";
  }
  $mailbody .= "\n登録日時：" . strftime("%Y/%m/%d %H:%M:%S") . "\n";
  $mailbody .= "AGENT：" . getenv('HTTP_USER_AGENT') . "\n";
  $mailbody .= "REMOTE：" . $_SERVER['REMOTE_ADDR'] . "\n";

  $mailbody .= "\n確認URL：\n" . $confirmurl . "\n";

  //$mailbody = mb_convert_encoding( $mailbody, "ISO-2022-JP" );
  $mailaddheader = "From: ".$post['fromaddress'];

  // 事務局へ送信。
  mb_language("ja");
  mb_send_mail($GLOBALS['mailfrom'], $mailsubject, $mailbody, $mailaddheader);
}

//
// 参加者へのメール
// 以下の内容でお受付いたしましたのでお知らせいたします。
function plugin_evententry_mailto_participant($confirm=0, $row='')
{
  global $post;

  $entryurl = $GLOBALS['entryurl']."?page={$post['page']}";
  $accesskey = urlencode(md5($post['fromaddress'].$post['fromname']));
  $confirmurl = $entryurl."&plugin={$post['plugin']}&table={$post['table']}&fromaddress={$post['fromaddress']}&fromkey={$accesskey}";

  if ($confirm) {
    if (empty($row)) {
      $row = plugin_evententry_search($address, $key);
    }
    foreach ($row as $k => $v) {
      $post["from$k"] = $row[$k];
    }
  }

  $mailaddheader = "From: " . $GLOBALS['mailfrom'];

  if ($GLOBALS['active']) {
    $subject = "【" . $GLOBALS['title'] . "】 参加登録の御連絡";
  } else {
    $subject = "【" . $GLOBALS['title'] . "】 登録完了の御連絡";
    if ($post['fromnews'] == 1) {
      $newsannounce = "上記アドレス宛てに次回のご案内を送付させていただきます。";
    } else {
      $newsannounce = '';
    }

  }

  if ($GLOBALS['meeting']) {
    if ($post['frommeeting'] == 1) {
      $meeting = "・懇親会：参加する";
    } else {
      $meeting = "・懇親会：参加しない";
    }
  } else {
    $meeting = "";
  }
  if ($post['fromnews'] == 1) {
    $news = "希望する";
  } else {
    $news = "希望しない";
  }

  $now = strftime("%Y/%m/%d %H:%M:%S");
  $agent = getenv('HTTP_USER_AGENT');

  if ($GLOBALS['active']) {
    if ($post['confirm'] == 0) {
      $confirm_str = "取消";
    } else {
      $confirm_str = "確定";
    }      
    $mailbody = <<<__EOD__
{$post['fromname']} <{$post['fromaddress']}> 様

「{$GLOBALS['title']}」参加の申し込みをいただき，ありがとうございます。

__EOD__;

    if ($confirm == 1) {
      $mailbody .= <<<__EOD__

参加申し込みを{$confirm_str}しました。

__EOD__;
    } else {	//($confirm != 1)//
      $mailbody .= <<<__EOD__
以下の内容で*仮*登録いたしました。

__EOD__;
    }

    $mailbody .= <<<__EOD__

《登録内容》
・メールアドレス: {$post['fromaddress']}
・氏名: {$post['fromname']}
・所属: {$post['frombelong']}
{$meeting}
・連絡事項: {$post['frommsg']}

__EOD__;

    if ($GLOBALS['news']) {
      $mailbody .= <<<__EOD__
・お知らせ配信： {$news}

__EOD__;
    }

    if ($confirm == 1) {
      $mailbody .= <<<__EOD__


《確認時の情報》
・TIME: {$now}
・AGENT: {$agent}
・REMOTE: {$_SERVER['REMOTE_ADDR']}

__EOD__;
    } else {	//($confirm == 0)//
      $mailbody .= <<<__EOD__

【重要】以下の確認確認URLをクリックし，登録を*確定*してください。
このURLは参加申し込みの変更に利用できますので，大切に保管してください
登録確認URL:
$confirmurl

参加申込URL:
$entryurl

__EOD__;
    }

    if (! empty($GLOBALS['list']) ) {
      $mailbody .= <<<__EOD__

次回以降の開催案内等を希望される方は，以下のURLから告知MLに登録してください。

{$GLOBALS['list']}

{$GLOBALS['shitsumon']}

__EOD__;
    }
    $mailbody .= <<<__EOD__

------------------
{$GLOBALS['jimukyoku']}
{$GLOBALS['url']}
{$GLOBALS['mailfrom']}
__EOD__;

  } else {
  //($GLOBALS['active']==false)//
    $mailbody = <<<__EOD__
{$post['fromname']} <{$post['fromaddress']}> 様

{$GLOBALS['title']}登録の申し込みをいただき，ありがとうございます。

以下の内容で登録いたしました。

《登録内容》
・メールアドレス: {$post['fromaddress']}
・氏名: {$post['fromname']}
・所属: {$post['frombelong']}
{$meeting}
・連絡事項: {$post['frommsg']}

__EOD__;

    if ($GLOBALS['news']) {
      $mailbody .= <<<__EOD__
・お知らせ配信： {$news}

__EOD__;
    }

    $mailbody .= <<<__EOD__

《登録時の情報》
・TIME: {$now}
・AGENT: {$agent}
・REMOTE: {$_SERVER['REMOTE_ADDR']}

{$newsannounce}

{$GLOBALS['shitsumon']}

------------------
{$GLOBALS['jimukyoku']}
{$GLOBALS['url']}
{$GLOBALS['mailfrom']}
__EOD__;
  }			//($GLOBALS['active'])//

  // 参加者へ送信！
  mb_language("ja");
  mb_send_mail($post['fromaddress'], $subject, $mailbody, $mailaddheader);
}
///// mailto_*
/////
/////


function plugin_evententry_init()
{
}

//
// プラグイン登録アクション
//
function plugin_evententry_action()
{
  global $post,$vars,$digest;

  // table name
  $table = $vars['table'];
  if (! _plugin_evententry_definition($table) ) {
      return $error_string;
  }

  if ( $post['pcmd'] == "confirm" ) {
    if ($post['confirm'] == 0) {
      $confirm_str = "取消";
    } else {
      $confirm_str = "確定";
    }      
    // 登録確認の更新処理
    $html = <<<_EOD_
<head>
 <meta http-equiv="content-type" content="application/xhtml+xml; charset=UTF-8" />
<title>《{$confirm_str}完了》{$GLOBALS['title']}</title>
 <link rel="stylesheet" type="text/css" media="screen" href="skin/jpug.css.php?charset=Shift_JIS" charset="Shift_JIS" />
</head>
<body>

<h2>《{$confirm_str}完了》{$GLOBALS['title']}</h2>
<blockquote>
  <div id='confirmation'>
_EOD_;

    // for posted checkbox values not checked
    if (! isset($post['meeting']) ) {
      $post['meeting'] = 0;
    }
    if (! isset($post['news']) ) {
      $post['news'] = 0;
    }

    $tbl = plugin_evententry_fixentry();
    if (! empty($tbl) ) {
      $html .= "ありがとうございます。<br />";
      $html .= "申し込みを{$confirm_str}しました。<br />";
      $html .= "<p>\n$tbl\n</p>";

      // 登録メール送信
      $address = str_replace(" ", "+", trim($post['fromaddress']));
      $key = $post['fromkey'];
      $row = plugin_evententry_search($address, $key);
      plugin_evententry_mailto_participant(1,$row);
      plugin_evententry_mailto_secretariat($row);
    } else {
      $html .= "申し訳ありません。<br />";
      $html .= "何らかの理由で>申し込みの{$confirm_str}に失敗した模様です。<br />";
      $html .= "以下まで連絡してください。<br />";
    }

    $html .= <<<_EOD_
  </div>
</blockquote>
<pre>
{$GLOBALS['jimukyoku']}
{$GLOBALS['url']}
{$GLOBALS['mailfrom']}
</pre>
<br />
<a href="{$GLOBALS['entryurl']}?{$post['page']}">
登録ページにもどる</a>
</body>
</html>
_EOD_;

    print mb_convert_encoding($html, 'UTF-8');
    exit;

  } //($post['pcmd']=="confirm")//
	   
  if ($GLOBALS['meeting']) {
    $items = array(
		 'fromaddress' => "メールアドレス",
		 'fromname' => "氏名",
		 'frombelong' => "所属",
		 'fromurl' => "URL(blog等)",
		 'frommeeting' => "懇親会参加",
		 'frommsg' => "連絡事項",
		 'fromnews' => "お知らせ配信",
		 );
  } else {
    $items = array(
		 'fromaddress' => "メールアドレス",
		 'fromname' => "氏名",
		 'frombelong' => "所属",
		 'fromurl' => "URL(blog等)",
		 'frommsg' => "連絡事項",
		 'fromnews' => "お知らせ配信",
		 );
  }

  $error = array();
  foreach ($items as $k => $v) {
    $post[$k] = uniDecode($post[$k], OUTPUT_ENCODING);
    if ($post[$k] == "" && $k != "frommsg" && $k != "fromurl" && $k != "frommeeting"  && $k != "fromnews") {
      $error[] = "{$v}を入力してください";
    }
  }

  // Mail Address replacement
  $pattern = '/(.*)<(.*)>(.*)/i';
  $replacement = '${2}';
  $post['fromaddress'] = preg_replace($pattern, $replacement, $post['fromaddress']);
  // メ・アドに含まれる' 'は、誤変換された'+'として元に戻す
  $post['fromaddress'] = str_replace(" ", "+", trim($post['fromaddress']));

  if ($error) {
    $s = _plugin_evententry_form($post, $error);
    print mb_convert_encoding($s, 'UTF-8');
    exit;
  }

  // 事務局へメール
  //foreach ($items as $k => $v) {
  //  $row[$v] = $post[$k];
  //}

  if ( $post['pcmd'] != "confirm" ) {
    // 記載確認
    if ( plugin_evententry_check($post['fromaddress']) ) {
      $s = <<<__EOD__
<div style="width:100%; text-align: left; background-color:#E0E0FE;">
<p>ご登録ありがとうございます。</p>
<p>ご指定のメールアドレスは既に登録済みのようです。<br />
ご登録の確認メールを受け取られていないかご確認ください。<br />
</p>
</div>
__EOD__;
    } elseif ( plugin_evententry_preentry($post) ) {  // DB登録

      // 事務局へメール
      plugin_evententry_mailto_secretariat();

      // 応募者へメール
      plugin_evententry_mailto_participant();

      // 成功時の画面表示
      $s = <<<__EOD__
<div style="width:100%; text-align: left; background-color:#E0E0FE;">
<p>ご登録ありがとうございます。</p>
<p>ご指定のメールアドレス宛へ登録確認メールが送信いたしました。<br />
<font color="red">
登録確認メールに記載されている登録確認URLをクリックし，登録を完了してください。
</font><br />
</p>
</div>
__EOD__;
    } else {
      $s = <<<__EOD__
<div style="width:100%; text-align: left; background-color:#FEE0E0;">
<p>
申し訳ございません。<br />
何らかの理由（既に登録されたメールアドレス等）で登録に失敗した模様です。<br />
以下まで連絡してください。
</p>
<p>
------------------<br />
{$GLOBALS['jimukyoku']}<br />
{$GLOBALS['url']}<br />
{$GLOBALS['mailfrom']}
<br>
</p>
</div>
__EOD__;

    }

    $s .= "<form action=\"".$_SERVER['PHP_SELF']."\" method=\"post\">\n"
      ."<input type=\"hidden\" name=\"refer\" value=\"{$post['page']}\">\n"
      ."<input type=\"hidden\" name=\"page\" value=\"{$post['page']}\">\n"
      ."<input type=\"hidden\" name=\"digest\" value=\"{$post['digest']}\">\n"
      ."<input type=\"hidden\" name=\"plugin\" value=\"evententry\">\n"
      ."<input type=\"hidden\" name=\"pcmd\" value=\"send\">\n"
      ."<input type=\"button\" name=\"evententry\" value=\"戻る\" onclick=\"location.reload()\">\n"
      ."</form>\n";

//// 登録者サマリー表
//$s .= plugin_evententry_summary();

    print mb_convert_encoding($s, "UTF-8");
  } 	     	//($post['pcmd']!="confirm")//

  exit;
}

//
// プラグイン
//
function plugin_evententry_convert()
{
  global $vars, $post, $get, $error_string;

  //echo basename($_SERVER["PHP_SELF"]);

  // table name
  if (isset($vars['table'])) {
      $table = $vars['table'];
  } else {
    $args = func_get_args();
    if (isset($args[0])) {
      $table = trim(trim($args[0]), "'\"");
    } else {
      $table = $vars['page'];
    }
  }
  if (! _plugin_evententry_definition($table) ) {
      return $error_string;
  }


  // 受け付け期間のチェック
  if (! _plugin_evententry_isstart() ) {
    return _plugin_evententry_before();
  }
  if ( _plugin_evententry_isend() ) {
    return _plugin_evententry_after();
  }
  if ( _plugin_evententry_over_entrylimit() ) {
    return _plugin_evententry_after();
  }
  

  if (! isset($vars['fromkey']) ) {
    //return _plugin_evententry_form(array('frommeeting' => 1));
    $fromvarskey = array('fromaddress', 'fromname', 'frombelong', 'fromurl', 'frommsg');
    foreach ($fromvarskey as $key) {
      if (! isset($vars[$key]) ) {
	$vars[$key] = '';
      }
    }
    if (! isset($vars['frommeeting']) ) {
      $vars['frommeeting'] = 1;
    }
    if (! isset($vars['fromnews']) ) {
      $vars['fromnews'] = 0;
    }
    return _plugin_evententry_form($vars);
  } else {
    return _plugin_evententry_confirm($vars);
  }
}


//
// プラグイン・確認フォーム
//
function _plugin_evententry_confirm($value)
{
  global $vars,$post,$script,$_btn_registerfinish;

  $address = str_replace(" ", "+", trim($value['fromaddress']));
  $key = $value['fromkey'];
  $row = plugin_evententry_search($address, $key);
  foreach ($row as $k => $v) {
    if ( strtoupper(mb_detect_encoding($v)) != OUTPUT_ENCODING ) {
      $row[$k] =  mb_convert_encoding($v, OUTPUT_ENCODING, 'auto');
    }
    // タグが混じってしまった場合の対策
    $row[$k] = str_replace(array("<",">"), "", strip_tags($row[$k]));
    //$post["from$k"] = $row[$k];
  }

  if ($row['meeting'] == "1") {
    $value['meeting_check'] = "checked";
  }
  if ($row['news'] == "1") {
    $value['news_check'] = "checked";
  }

  if ($row['confirm'] == "1") {
    $h2str = "《登録の変更》";
    $radio1_check = "checked";
    $radio0_check = "";
  } elseif ($row['confirm'] == "0") {
    $h2str = "《登録の変更》";
    $radio1_check = "";
    $radio0_check = "checked";
  } elseif ($row['confirm'] == "") { 
    $h2str = "《登録の確定》";
    $radio1_check = "checked";
    $radio0_check = "";
  }

  // サブミットボタン
  $button = "<input type=\"submit\" name=\"evententry\" value=\"$_btn_registerfinish\">\n";

  $vakey = array_keys($value);
  $page  = empty($value['page'])?$vakey[0]:$value['page'];

  // 登録の確定用ページ
  $string = <<<_EOD_
<head>
 <meta http-equiv="content-type" content="application/xhtml+xml; charset=UTF-8" />
<title>{$h2str}{$GLOBALS['title']}</title>
 <link rel="stylesheet" type="text/css" media="screen" href="skin/jpug.css.php?charset=Shift_JIS" charset="Shift_JIS" />
</head>
<body>

<h2>{$h2str}{$GLOBALS['title']}</h2>

<div id='confirmation'>
	<form action="{$_SERVER['PHP_SELF']}" method="post">
	<input type="hidden" name="digest" value="{$digest}">
	<input type="hidden" name="plugin" value="evententry">
	<input type="hidden" name="pcmd" value="confirm">

	<input type="hidden" name="page" value="{$page}">
	<input type="hidden" name="table" value="{$value['table']}">
	<input type="hidden" name="fromaddress" value="{$address}">
	<input type="hidden" name="fromkey" value="{$key}">

	<input type="hidden" name="fromname" value="{$row['name']}">
	<input type="hidden" name="frombelong" value="{$row['belong']}">
	<input type="hidden" name="frommeeting" value="{$row['meeting']}">
	<input type="hidden" name="frommsg" value="{$row['msg']}">
	<input type="hidden" name="fromnews" value="{$row['news']}">
_EOD_;

  if ($GLOBALS['meeting']) {
    if ( _plugin_evententry_banqend() || _plugin_evententry_over_banquetlimit() ) {
      $meeting_html = <<<__EOD__
		<tr><th class="style_th">懇親会参加</th>
			<td class="style_td">もうしわけありませんが、懇親会の受付は終了しております。</td></tr>
__EOD__;
    } else {
      $meeting_html = <<<__EOD__
		<tr><th class="style_th">懇親会参加</th>
			<td class="style_td"><input type="checkbox" name="meeting" style="" {$value['meeting_check']} value="1" id="meeting">
{$GLOBALS['banquet']}{$GLOBALS['banqwarn']}</td></tr>
__EOD__;
    }
  } else {
    $meeting_html = "<input type=\"hidden\" name=\"meeting\" value=\"0\">\n";
  }

  if ($GLOBALS['news']) {
    $meeting_html .= <<<__EOD__
		<tr>
		  <th class="style_th">お知らせの配信</th>
		  <td class="style_td">
		  <input type="checkbox" name="news" style="" {$value['news_check']} value="1" id="news">{$GLOBALS['optinquery']}
		  </td>
		</tr>
__EOD__;
  } else {
    $meeting_html .= "<input type=\"hidden\" name=\"news\" value=\"0\">\n";
  }



  // post request
  $string .= <<<__EOD__
	<table border="0">
	  <tbody>
		<tr>
		  <th class="style_th">メールアドレス(*)</th>	<td class="style_td">{$row['address']}</td>
		  <input type="hidden" name="address" value="{$row['address']}">
		  <input type="hidden" name="ackey" value="{$row['ackey']}">
		</tr><tr>
		  <th class="style_th">氏名(*)</th>		<td class="style_td">{$row['name']}</td>
		  <input type="hidden" name="name" value="{$row['name']}">
		</tr><tr>
		  <th class="style_th">所属(*)</th>	<td class="style_td">{$row['belong']}</td>
		  <input type="hidden" name="belong" value="{$row['belong']}">
		</tr><tr>
		  <th class="style_th">URL(blog等)</th>		<td class="style_td">{$row['url']}</td>
		  <input type="hidden" name="url" value="{$row['url']}">
		</tr><tr>
		  <th class="style_th">連絡事項等</th>		<td class="style_td">{$row['msg']}</td>
		  <input type="hidden" name="msg" value="{$row['msg']}">
		%s

		<tr bgcolor="#ff66cc">
		  <th class="style_th">確認項目</th>
		    <td class="style_td">
                    <input type="radio" name="confirm" value="1" id="comfirm" {$radio1_check}>
		    登録確定(申し込みを確定します)<br />
		    <input type="radio" name="confirm" value="0" id="comfirm" {$radio0_check}>
		    登録解除(申し込みを取消します)<br />
		    </td></tr>
	  </tbody>
		<tr>
		  <th class="style_th" />
		  <td class="style_td" style="text-align: center">$button</td>
		</tr>
	</table>
	</form>
<br />
<pre>
{$GLOBALS['shitsumon']}
------------------
{$GLOBALS['jimukyoku']}
{$GLOBALS['url']}
{$GLOBALS['mailfrom']}
</pre>
__EOD__;

//// 登録者サマリー表
//$string .= plugin_evententry_summary();

  $string .= "</div>";
  $string .= "</body>\n</html>\n";

  // 懇親会参加確認にチェックボックスの挿入
  $string = sprintf($string, $meeting_html);

  return $string;
}


//
// プラグイン・登録フォーム
//
function _plugin_evententry_form($value, $error = array())
{
  global $_btn_registersend,$vars,$digest;
  if (UA_PROFILE == 'keitai') {
    $errmsg = '<p>現在，携帯電話端末からの申し込みは受け付けられません。PCサイトから申し込んでください。</p>';
    return $errmsg;
  }

  if ( isset($vars['fromkey']) ) {
    // 確認フォーム
    return _plugin_evententry_confirm($vars);
  }

  foreach ($value as $k => $v) {
    $value[$k] = htmlspecialchars($v);
  }
  if ($value['frommeeting'] == "1") {
    $value['frommeeting_check'] = "checked";
  }
  if ($value['fromnews'] == "1") {
    $value['fromnews_check'] = "checked";
  }


  $string = "<div id='evententry'>";

  if ($error) {
    $string .= "<ul class='arrowhead'>";
    foreach ($error as $errmsg) {
      $string .= "<li>$errmsg</li>";
    }
    $string .= "</ul>";
  }

  $button = "<input type=\"button\" name=\"evententry\" value=\"$_btn_registersend\" onclick=\"evententry_submit()\">\n";

  $string .= "<form action=\"$script\" method=\"post\">\n"
		 ."<input type=\"hidden\" name=\"refer\" value=\"{$vars['page']}\">\n"
		 ."<input type=\"hidden\" name=\"page\" value=\"{$vars['page']}\">\n"
		 ."<input type=\"hidden\" name=\"table\" value=\"{$GLOBALS['table']}\" id=\"table\">\n"

		 ."<input type=\"hidden\" name=\"digest\" value=\"$digest\">\n"
		 ."<input type=\"hidden\" name=\"plugin\" value=\"evententry\">\n"
		 ."<input type=\"hidden\" name=\"pcmd\" value=\"send\">\n";

  if ($GLOBALS['meeting']) {
    if ( _plugin_evententry_banqend() || _plugin_evententry_over_banquetlimit() ) {
      $meeting_js = "";
      $meeting_html = <<<__EOD__
			<tr>
				<th class="style_th">懇親会参加</th>
				<td class="style_td">申し訳ありませんが、懇親会の受け付けは終了しております。</td></tr>
			</tr>
__EOD__;
    } else {
      $meeting_js = "query_string += \"&frommeeting=\" + ($('frommeeting').checked ? \"1\" : \"\");\n";

      $meeting_html = <<<__EOD__
			<tr>
				<th class="style_th">懇親会参加</th>
				<td class="style_td"><input type="checkbox" name="frommeeting" style="" {$value['frommeeting_check']} value="1" id="frommeeting">
{$GLOBALS['banquet']}{$GLOBALS['banqwarn']}</td></tr>
			</tr>
__EOD__;
    }
  } else {	// $GLOBALS['meeting']: false
    $meeting_js = "query_string += \"&frommeeting=\" + \"0\";";
    $meeting_html = 
      "<input type=\"hidden\" name=\"frommeeting\" value=\"0\">\n";
  }

  if ($GLOBALS['news']) {
    $news_js =  <<<__EOD__
		query_string += "&fromnews=" + escape($('fromnews').checked ? "1" : "");
__EOD__;

    $news_html = <<<__EOD__
			<tr>
				<th class="style_th">お知らせの配信</th>
				<td class="style_td"><input type="checkbox" name="fromnews" style="" {$value['fromnews_check']} value="1" id="fromnews">{$GLOBALS['optinquery']}</td>
			</tr>
__EOD__;
  } else {	// $GLOBALS['news']: false
    $news_js = "query_string += \"&fromnews=\" + \"0\";";
    $news_html = 
      "<input type=\"hidden\" name=\"fromnews\" value=\"0\">\n";
  }


  $indexpage = get_script_uri().'?'.$value['page'];

  // post request with Ajax.Updater(prototype.js)
  $string .= <<<__EOD__
	<script type="text/javascript">
	<!--
	// <![CDATA[
	function evententry_submit()
	{
		var query_string = "";

		if(window.location.search){
			var q=window.location.search.substring(1,window.location.search.length);
			var p = q.split('&');
			if (p[0])
				query_string = "page="+p[0];
		}
		if (! query_string)
		  query_string = "page={$vars['page']}";

		query_string += "&plugin=evententry";
		query_string += "&fromaddress=" + escape($('fromaddress').value);
		query_string += "&fromname=" + escape($('fromname').value);
		query_string += "&frombelong=" + escape($('frombelong').value);
		query_string += "&fromurl=" + escape($('fromurl').value);
		%s
		query_string += "&frommsg=" + escape($('frommsg').value);
		%s
		query_string += "&table=" + escape($('table').value);

		ajax = new Ajax.Updater(
			'evententry',
			'{$indexpage}',
			{
				'method': 'post',
				'parameters': query_string
	                });
	}
	// ]]>
	-->
	</script>
	    <div class="style_blockquote">
		 <table border="0">
		 	<tbody>
		 	<tr>
				<th class="style_th">メールアドレス(*)</th>
				<td class="style_td"><input type="text" name="fromaddress" style="width: 384px;" value="{$value['fromaddress']}" id="fromaddress"></td>
			</tr>
			<tr>
				<th class="style_th">氏名(*)</th>
				<td class="style_td"><input type="text" name="fromname" style="width: 384px;" value="{$value['fromname']}" id="fromname"></td>
			</tr>
			<tr>
				<th class="style_th">所属(*)</th>
				<td class="style_td"><input type="text" name="frombelong" style="width: 384px;" value="{$value['frombelong']}" id="frombelong"></td>
			</tr>
			<tr>
				<th class="style_th">URL(blog等)</th>
				<td class="style_td"><input type="text" name="fromurl" style="width: 384px;" value="{$value['fromurl']}" id="fromurl"></td>
			</tr>
			%s
			<tr>
				<th class="style_th">連絡事項等<br /></th>
				<td class="style_td"><textarea style="width: 384px; height: 80px;" name="frommsg" id="frommsg">{$value['frommsg']}</textarea></td>
			</tr>
			%s

			</tbody>
			<tr>
				<th class="style_th" />
				<td class="style_td" style="text-align: center">$button</td>
			</tr>
		  </table>
	    </div>
	 </form>
<br />
__EOD__;

  if ($GLOBALS['active']) {
    $string .= "※ここで送信 [REGISTER] ボタンを押すと仮登録され、登録されたアドレス宛にメールが返送されます。<font color=\"red\">お手数ですが、返信メールに書かれているURLにアクセスをし、登録を完了してください。</font><br /><br />";
  }

  // 登録者サマリー
  $string .= plugin_evententry_summary();

  $string .= "</div>";

  // 懇親会参加確認に関する挿入
  $string = sprintf($string, $meeting_js, $news_js, $meeting_html, $news_html);

  return $string;
}

//
// URL Encodedから、指定の文字エンコーディングへ変換 
//
function uniDecode($str, $charcode = 'EUC-JP')
{
	$text = preg_replace_callback("/%u[0-9A-Za-z]{4}/", "toUtf8", $str); 
	if ($charcode == 'UTF-8') {
	  return $text;
	} else {
	  return mb_convert_encoding($text, $charcode, 'utf-8');
	}
}

//
// URL Encodedから、utf-8へ変換 
//
function toUtf8($ar)
{
	foreach($ar as $val)
	{
		$val = intval(substr($val,2),16); 
		if ($val < 0x7F) {
			$c .= chr($val); 
		} elseif ($val < 0x800) {
			$c .= chr(0xC0 | ($val / 64)); 
			$c .= chr(0x80 | ($val % 64)); 
		} else {
			$c .= chr(0xE0 | (($val / 64) / 64)); 
			$c .= chr(0x80 | (($val / 64) % 64)); 
			$c .= chr(0x80 | ($val % 64)); 
		}
	} 
	return $c; 
}



//
// DB接続
//
function plugin_evententry_conn()
{
  // 接続
  try {
    $dbh = new PDO($GLOBALS['dsn'], '', '');
    // 例外処理の有効化
    $dbh->setAttribute(PDO_ATTR_ERRMODE, PDO_ERRMODE_EXCEPTION);
    return $dbh;
  } catch (PDOException $exception){
    syslog(LOG_DEBUG,"pukiwiki: DBError#1\n\t".$exception->getMessage());
    return false;
  }
}


//
// テーブル作成
//
function plugin_evententry_create($dbh)
{
  // テーブルの定義
  $query = <<<_EOQ_
      CREATE TABLE {$GLOBALS['table']}
	       (
		id INTEGER PRIMARY KEY,
		address VARCHAR(128) UNIQUE NOT NULL,
		name VARCHAR(64) NOT NULL,
		belong VARCHAR(128),
		url VARCHAR(128),
		meeting bool NOT NULL DEFAULT true,
		msg VARCHAR(256),
		news bool NOT NULL DEFAULT false,
		ackey VARCHAR(32) NOT NULL,
		confirm BOOL DEFAULT false,
		browser VARCHAR(256),
		remoteip VARCHAR(16),
		timestamp DATETIME
		);
_EOQ_;
  // テーブルの作成
  if (! $dbh->query($query) ) {
    syslog(LOG_DEBUG,"pukiwiki: DBError#2\n\t $query");
    //print_r($dbh->errorInfo());
    return false;
  }
  return true;
}

//
// 登録
//
function plugin_evententry_insert($dbh, $post)
{
  // プレースホルダの用意
  $query = "INSERT INTO {$GLOBALS['table']} ("
    ." address, name, belong, url, meeting, msg, news"
    .", ackey, confirm, browser, remoteip, timestamp"
    ." ) VALUES ("
    ." :address, :name, :belong, :url, :meeting, :msg, :news"
    .", :ackey, :confirm, :browser, :remoteip, :timestamp"
    .")";

  if (!  $sth = $dbh->prepare($query) ) {
    syslog(LOG_DEBUG,"pukiwiki: DBError#3\n\t $query");
    return false;
  }

  foreach ($post as $k => $v) {
      if ( strtoupper(mb_detect_encoding($v)) != DB_ENCODING ) {
	  $row[$k] = strip_tags(mb_convert_encoding($v, DB_ENCODING, 'auto'));
      } else {
	  $row[$k] = strip_tags($v);
      }
  }

  // 値のバインド
  $sth->bindParam(':address',  $row['fromaddress'],     PDO::PARAM_STR, 128);
  $sth->bindParam(':name',     $row['fromname'],        PDO::PARAM_STR,  64);
  $sth->bindParam(':belong',   $row['frombelong'],      PDO::PARAM_STR, 128);
  $sth->bindParam(':url',      $row['fromurl'],         PDO::PARAM_STR, 128);
  $sth->bindParam(':meeting',  $row['frommeeting'],     PDO::PARAM_INT);
  $sth->bindParam(':msg',      $row['frommsg'],         PDO::PARAM_STR, 256);
  $sth->bindParam(':news',     $row['fromnews'],        PDO::PARAM_INT);
  $accesskey = md5($post['fromaddress'].$post['fromname']);
  $sth->bindParam(':ackey',    $accesskey,              PDO::PARAM_STR,  32);
  $useragent = $dbh->quote(strip_tags(substr(getenv('HTTP_USER_AGENT'), 0, 255)));
  $sth->bindParam(':browser',  $useragent,              PDO::PARAM_STR, 256);
  $sth->bindParam(':remoteip', $_SERVER['REMOTE_ADDR'], PDO::PARAM_STR,  16);
  $now = date("Y-m-d G:i:s");	//'CURRENT_TIMESTAMP'
  $sth->bindParam(':timestamp', $now,                   PDO::PARAM_STR,  19);
  // クエリを実行
  if (! $sth->execute() ) {
    syslog(LOG_DEBUG,"pukiwiki: DBError#4\n\t $query");
    //print_r($sth->errorInfo());
    return false;
  }
  // プレースホルダーを開放
  $sth = null;
  return true;
}

//
// 更新
//
function plugin_evententry_update($dbh, $post)
{
  // プレースホルダの用意
  $query = "UPDATE {$GLOBALS['table']} SET "
    ." name = :name, belong = :belong, url = :url,"
    ." meeting = :meeting, msg = :msg, news = :news, "
    ." confirm = :confirm, timestamp = :timestamp"
    ." WHERE address = :address AND ackey = :ackey";

  if (!  $sth = $dbh->prepare($query) ) {
    syslog(LOG_DEBUG,"pukiwiki: DBError#3\n\t $query");
    return false;
  }

  if (! $post['confirm']) {
    $post['meeting'] = 0;
  }

  foreach ($post as $k => $v) {
      if ( strtoupper(mb_detect_encoding($v)) != DB_ENCODING ) {
	  $row[$k] = strip_tags(mb_convert_encoding($v, DB_ENCODING, 'auto'));
      } else {
	  $row[$k] = strip_tags($v);
      }
  }

  // 値のバインド
  $sth->bindParam(':name',     $row['name'],    PDO::PARAM_STR, 64);
  $sth->bindParam(':belong',   $row['belong'],  PDO::PARAM_STR, 128);
  $sth->bindParam(':url',      $row['url'],     PDO::PARAM_STR, 128);
  $sth->bindParam(':meeting',  $row['meeting'], PDO::PARAM_INT);
  $sth->bindParam(':msg',      $row['msg'],     PDO::PARAM_STR, 256);
  $sth->bindParam(':news',     $row['news'],    PDO::PARAM_INT);
  $sth->bindParam(':confirm',  $row['confirm'], PDO::PARAM_INT);
  $now = date("Y-m-d G:i:s");	//'CURRENT_TIMESTAMP'
  $sth->bindParam(':timestamp', $now,            PDO::PARAM_STR, 19);
  // 条件
  $sth->bindParam(':address',  $row['address'], PDO::PARAM_STR, 128);
  $sth->bindParam(':ackey',    $row['ackey'],   PDO::PARAM_STR, 32);

  // クエリを実行
  if (! $sth->execute() ) {
    syslog(LOG_DEBUG,"pukiwiki: DBError#6\n\t $query");
    //print_r($sth->errorInfo());
    return false;
  }
  // プレースホルダーを開放
  $sth = null;
  return true;
}

//
// 登録者リスト
//
function plugin_evententry_list($dbh, $fix = 1, $admin=0, $nlrow=3)
{
  // クエリのステートメントを準備
  $tbl = "<div id=\"list\">\n";
  $query = "SELECT * FROM {$GLOBALS['table']}";

  if ($GLOBALS['active']) {
    if ( $fix == 1 ) {
      $query .= " WHERE confirm = 1";
    }
  }

  try {
    // 実行
    $sth = $dbh->prepare($query);
    $sth->execute();

    // リストヘッダ
    if ($nlrow == 1) {
      $tbl .= "  <table border=\"0\">\n    <tbody>\n";
      $tbl .= "    <tr>";
      $tbl .= "<th class=\"style_th\">＃</th>";
      $tbl .= "<th class=\"style_th\">メールアドレス</th>";
      $tbl .= "<th class=\"style_th\">氏名</th>";
      $tbl .= "<th class=\"style_th\">所属</th>";
      $tbl .= "<th class=\"style_th\">URL</th>";
      if ($GLOBALS['meeting']) {
	$tbl .= "<th class=\"style_th\">懇親会</th>";
      }
      $tbl .= "<th class=\"style_th\">その他</th>";
      if ($GLOBALS['news']) {
	$tbl .= "<th class=\"style_th\">配信</th>";
      }
      if ($admin) {
	$tbl .= "<th class=\"style_th\">確定</th>";
      }
      $tbl .= "    </tr>\n";

    } elseif ($nlrow == 3) {
      // きれいな表で出力
      $la_confirm = ($admin)?"(確定)":"";
      $la_meeting = ($GLOBALS['meeting'])?"懇親会":"--";
      //$la_news = ($GLOBALS['news'])?"配信許諾":"--";
      $la_news = "確定等";
      $rowspan = 3;
	if (! $admin) {
	  $rowspan -= 1;
	}


      $tbl .= <<<_EOR_
<style type="text/css">
<!--
#list_master {
	border-top-width: 2px;
	border-right-width: 2px;
	border-left-width: 2px;
	border-top-style: solid;
	border-right-style: solid;
	border-bottom-style: solid;
	border-left-style: solid;
#	border-top-color: #990000;
#	border-right-color: #990000;
#	border-left-color: #990000;
#	border-bottom-color: #990000;
	border-bottom-width: 1px;
	width: 550px;
}
#list_master td {
	padding: 5px;
	margin: 0px;
	border-bottom-width: 1px;
	border-bottom-style: solid;
#	border-bottom-color: #990000;
	border-right-width: 1px;
	border-right-style: solid;
#	border-right-color: #990000;
}
#list_master .name {
	width: 150px;
}
#list_master .num {
	width: 20px;
	border-bottom-width: 2px;
	border-bottom-style: solid;
	text-align: center;
}
#list_master .comment {
	border-bottom-width: 2px;
	border-bottom-style: solid;
}
#list_master .haishin {
	width: 30px;
	text-align: center;
}
#list_master .konshinkai {
	width: 30px;
	text-align: center;
}
-->
</style>

<table border="0" cellpadding="0" cellspacing="0" id="list_master">
  <tr>
    <td rowspan="$rowspan" class="num">No{$la_confirm}</td>
	<td class="style_th">氏名</td>
	<td class="style_th">{$la_meeting}</td>
	<td class="style_th">メールアドレス</td>
	<td class="style_th">{$la_news}</td>
  </tr>
_EOR_;
	if ($admin) {
            $tbl .= <<<_EOR_
  <tr>	<td colspan="2" class="style_th">所属</td>
  	<td colspan="2" class="style_th">URL</td></tr>
_EOR_;
	}
      $tbl .= <<<_EOR_
  <tr>
	<td colspan="4" class="style_th">連絡事項</td>
  </tr>
_EOR_;
    } else {
      // default
      $tbl .= "<table border=\"1\" width=\"550px\">\n    <tbody>\n";
      $tbl .= "<tr><td width=\"170px\"><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\n";
      $tbl .= "    <tr>";
      $tbl .= "<th align=\"left\">＃</th>";
      $tbl .= "    </tr>\n";
      $tbl .= "    <tr>";
      $tbl .= "<th >氏名</th>";
      $tbl .= "    </tr>\n";
      $tbl .= "    <tr>";
      $tbl .= "<td align=\"center\">".($GLOBALS['meeting']?"懇親会":"")."</td>";
      $tbl .= "    </tr></table>\n";
      $tbl .= "</td><td><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"380px\">\n";
      $tbl .= "    <tr>";
      $tbl .= "<th align=\"left\">メールアドレス</th>";
      $tbl .= "<th >所属</th>";
      $tbl .= "<th align=\"right\">".($GLOBALS['news']?"配信許諾":"")."</th>";
      if ($admin) {
	$tbl .= "<th >確定</th>";
      }
      $tbl .= "    </tr>\n";
      $tbl .= "    <tr>";
      $tbl .= "<th colspan=\"4\" align=\"left\">URL</th>";
      $tbl .= "    </tr>\n";
      $tbl .= "    <tr>";
      $tbl .= "<th colspan=\"4\" align=\"left\">連絡事項</th>";
      $tbl .= "    </tr>\n";
      $tbl .= "</table></td></tr>\n";
    }

    // リスト出力
    $cols = array();
    $nl = 0;
    while ($cols = $sth->fetch(PDO::FETCH_ASSOC)) { 
      foreach ($cols as $k => $v) {
        if ( strtoupper(mb_detect_encoding($v)) != OUTPUT_ENCODING ) {
	  $cols[$k] =  mb_convert_encoding($v, OUTPUT_ENCODING, 'auto');
        }
        // タグが混じってしまった場合の対策
        $cols[$k] = str_replace(array("<",">"), "", strip_tags($cols[$k]));
      }

      $id = "{$cols['id']}";
      $adduser = substr($cols['address'], 0, strpos($cols['address'],'@'));
      if ($admin) {
	$confirm = ($cols['confirm']?"":"未");
	if (empty($confirm)) {
	  $id = "({$cols['id']})";
	}
      }

      if ($GLOBALS['meeting']) {
	$meeting = ($cols['meeting']?"参加":"×");
      } else {
	$meeting = "";
      }

      if ($GLOBALS['news']) {
	$news = ($cols['news']?"配信":"×");
      } else {
	$news = "";
      }

      //"style=\"background-color: ".{($nl%2)?"lightyellow":"seashell"}."\""
      if ($nlrow == 1) {
	$tbl .= "    <tr bgcolor=\"".(($nl % 2)?"#ffffe0":"#fff5ee")."\">";
	$tbl .= "<td class=\"style_td\">{$id}</td>";
	$tbl .= "<td class=\"style_td\">{$adduser}</td>";
	$tbl .= "<td class=\"style_td\">{$cols['name']}</td>";
	$tbl .= "<td class=\"style_td\">{$cols['belong']}</td>";
	$tbl .= "<td class=\"style_td\">{$cols['url']}</td>";
	if ($GLOBALS['meeting']) {
	  $tbl .= "<td align=\"center\">".($cols['meeting']?"参加":"×")."</td>";
	}
	$tbl .= "<td class=\"style_td\">{$cols['msg']}</td>";
	if ($GLOBALS['meeting']) {
	  $tbl .= "<td class=\"style_td\">".($cols['news']?"配信":"×")."</td>";
	}
	if ($admin) {
	  $tbl .= "<td class=\"style_td\">{$cols['confirm']}</td>";
	}
	$tbl .= "    </tr>\n";
    } elseif ($nlrow == 3) {
	// きれいな表で出力
	if ($cols['confirm'] == "1") { $class_style = "style_td2"; $confirm_str = "確定"; }
	elseif ($cols['confirm'] == "0") { $class_style="style_td3"; $confirm_str = "取消"; } 
	else { $class_style = "style_td1"; $confirm_str = "未確定"; }

	if ($cols['msg']) {
	  $rowspan = 3; 
	  $msg = "<tr><td colspan=\"4\" class=$class_style>{$cols['msg']}</td></tr>";
	} else { 
	  $rowspan = 2;
	  $msg = "";
	} 
	if (! $admin) {
	  $rowspan -= 1;
	}
	$tbl .= <<<__EOR__
<tr>
	<td rowspan={$rowspan} class=$class_style>{$id}</td>
	<td class=$class_style>{$cols['name']} 様</td>
	<td class=$class_style>{$meeting}</td>
	<td class=$class_style>{$adduser}</td>
	<td class=$class_style>{$confirm_str}</td>
</tr>
__EOR__;
	if ($admin) {
	    $tbl .= <<<__EOR__
<tr>	<td colspan="2" class=$class_style>{$cols['belong']}</td>
	<td colspan="2" class=$class_style>{$cols['url']}</tr>
__EOR__;
	}

	$tbl .= $msg;

      } else {
	// default
	if ($cols['confirm'] != 1) {
	  $bgc = ($nl % 2)?"#777760":"#777066";
	} else {
	  $bgc = ($nl % 2)?"#ffffe0":"#fff0ee";
	}
	$tbl .= "<tr bgcolor=\"{$bgc}\"><td bgcolor=\"{$bgc}\" width=\"170px\"><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" bgcolor=\"{$bgc}\" width=\"170px\">\n";

	$tbl .= "    <tr bgcolor=\"{$bgc}\">";
	$tbl .= "<td align=\"left\" bgcolor=\"{$bgc}\">{$cols['id']}</td>";
	$tbl .= "    </tr>\n";
	$tbl .= "    <tr>";
	$tbl .= "<td >{$cols['name']} 様</td>";
	$tbl .= "    </tr>\n";
	$tbl .= "    <tr>";
	$tbl .= "<td align=\"right\">".($GLOBALS['meeting']?$meeting:"")."</td>";
	$tbl .= "    </tr></table>\n";
	$tbl .= "</td><td><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"380px\">\n";
	$tbl .= "    <tr>";
	$tbl .= "<td align=\"left\">{$adduser}</td>";
	$tbl .= "<td >{$cols['belong']}</td>";
	$tbl .= "<td align=\"right\">".($GLOBALS['news']?$news:"")."</td>";
	if ($admin) {
	  $tbl .= "<td >{$cols['confirm']}</td>";
	}
	$tbl .= "    </tr><tr>\n";
	$tbl .= "<td colspan=\"4\" >{$cols['url']}</td>";
	$tbl .= "    </tr><tr>\n";
	$tbl .= "<td colspan=\"4\" >{$cols['msg']}</td>";
	$tbl .= "    </tr>\n";
	$tbl .= "</table></td></tr>\n";
      }
      $nl++;
    } 

    $tbl .= "    </tbody>  </table>\n";
    $tbl .= "</div>\n";
    // ステートメントを開放
    $sth = null;

    return $tbl;
  } catch (PDOException $e) {
    syslog(LOG_DEBUG,"pukiwiki: DBError#5\n\t".$e->getMessage());
    return false;
  }
}

//
// 登録確定者数
//
function plugin_evententry_count($dbh)
{
  $query = "SELECT count(*) FROM {$GLOBALS['table']}";
  if ($GLOBALS['active']) {
    $query .= " WHERE confirm = 1";
  }

  if (! $sth = $dbh->prepare($query) ) {
    if (! plugin_evententry_create($dbh) ) {
      syslog(LOG_DEBUG,"pukiwiki: DBError@_count! (evententry_create failed)");
      return false;
    }
    if (! $sth = $dbh->prepare($query) ) {
      syslog(LOG_DEBUG,"pukiwiki: DBError@_count! (failed after evententry_create)");
      return false;
    }
  }
  if (! $sth->execute() ) {
    syslog(LOG_DEBUG,"pukiwiki: DBError@_count! (execute failed)");
    //print_r($sth->errorInfo());
    return false;
  }
  $ret = $sth->fetchColumn();
  $sth = null;
  return $ret;
}

//
// 登録者(未確定)
//
function plugin_evententry_countnull($dbh)
{
  $query = "SELECT count(*) FROM {$GLOBALS['table']}";
  if ($GLOBALS['active']) {
    $query .= " WHERE confirm is null";
  }

  if (! $sth = $dbh->prepare($query) ) {
    if (! plugin_evententry_create($dbh) ) {
      syslog(LOG_DEBUG,"pukiwiki: DBError@_countnull! (evententry_create failed)");
      return false;
    }
    if (! $sth = $dbh->prepare($query) ) {
      syslog(LOG_DEBUG,"pukiwiki: DBError@_countnull! (failed after evententry_create)");
      return false;
    }
  }
  if (! $sth->execute() ) {
    syslog(LOG_DEBUG,"pukiwiki: DBError@_countnull! (execute failed)");
    print_r($sth->errorInfo());
    return false;
  }
  $ret = $sth->fetchColumn();
  $sth = null;
  return $ret;
}


//
// 懇親会参加者数
//
function plugin_evententry_countmeeting($dbh)
{
  $query = "SELECT count(meeting) FROM {$GLOBALS['table']} WHERE meeting = 1";
  if ($GLOBALS['active']) {
    $query .= " AND confirm = 1";
  }
  if (! $sth = $dbh->prepare($query) ) {
    if (! plugin_evententry_create($dbh) ) {
      syslog(LOG_DEBUG,"pukiwiki: DBError@_countmeeting! (evententry_create failed)");
      return false;
    }
    if (!  $sth = $dbh->prepare($query) ) {
      syslog(LOG_DEBUG,"pukiwiki: DBError@_countmeeting! (failed after evententry_create)");
      return false;
    }
  }
  if (! $sth->execute() ) {
    syslog(LOG_DEBUG,"pukiwiki: DBError@_countmeeting! (execute failed)");
    //print_r($sth->errorInfo());
    return false;
  }
  $ret = $sth->fetchColumn();
  $sth = null;
  return $ret;
}

//
// 懇親会参加(未確定)
//
function plugin_evententry_countmeetingnull($dbh)
{
  $query = "SELECT count(meeting) FROM {$GLOBALS['table']} WHERE meeting = 1";
  if ($GLOBALS['active']) {
    $query .= " AND confirm is null";
  }
  if (! $sth = $dbh->prepare($query) ) {
    if (! plugin_evententry_create($dbh) ) {
      syslog(LOG_DEBUG,"pukiwiki: DBError@_countmeetingnull! (evententry_create failed)");
      return false;
    }
    if (!  $sth = $dbh->prepare($query) ) {
      syslog(LOG_DEBUG,"pukiwiki: DBError@_countmeetingnull! (failed after evententry_create)");
      return false;
    }
  }
  if (! $sth->execute() ) {
    syslog(LOG_DEBUG,"pukiwiki: DBError@_countmeetingnull! (execute failed)");
    //print_r($sth->errorInfo());
    return false;
  }
  $ret = $sth->fetchColumn();
  $sth = null;
  return $ret;
}

//
// データベースへのエントリ登録
//
function plugin_evententry_preentry($post)
{
  // DB接続
  if (! $dbh = plugin_evententry_conn() ) {
    return false;
  }

  //// テーブル作成＝＞自動化（各所でエラー処理として行う）
  //if (! TABLE_CREATED ) {
  //  if (! plugin_evententry_create($dbh) ) {
  //    return false;
  //  }
  //}
 
  // 登録
  if (! plugin_evententry_insert($dbh, $post) ) {
    if (! plugin_evententry_create($dbh) ) {
      return false;
    }
    if (! plugin_evententry_insert($dbh, $post) ) {
      return false;
    }
  }

  //// リスト
  //$tbl = plugin_evententry_list($dbh);

  return true;
}

//
// データベースへのエントリ更新
//
function plugin_evententry_fixentry()
{
  global $post;
	
  // DB接続
  if (! $dbh = plugin_evententry_conn() ) {
    return false;
  }

  //// テーブル作成＝＞自動化（各所でエラー処理として行う）
  //if (! TABLE_CREATED ) {
  //  if (! plugin_evententry_create($dbh) ) {
  //    return false;
  //  }
  //}
 
  // 登録
  if (! plugin_evententry_update($dbh, $post) ) {
    return false;
  }

  // リスト
  if ( $tbl = plugin_evententry_summary($dbh, 0) ) {
    return $tbl;
  }
}

//
// 参加登録者サマリー
//
function plugin_evententry_summary($dbh='', $list=1)
{

  if (empty($dbh)) {
    // 登録者DBアクセス
    if (!  $dbh = plugin_evententry_conn() ) {
      return "ご迷惑をおかけしております。ただいまお問い合わせできません（conn@_summary）";
    }
  }

  // 登録者数集計
  $now = date("Y-m-d G:i");
  $string .= "<p>{$now} 現在";
  $nentry = plugin_evententry_count($dbh);
  $nentryall = $nentry + plugin_evententry_countnull($dbh);
  $string .= "&nbsp;&nbsp;&nbsp;登録者数: {$nentryall}名（確定: {$nentry}名）";
  if ($GLOBALS['meeting']) {
    $nbanqu = plugin_evententry_countmeeting($dbh);
    $nbanquall = $nbanqu + plugin_evententry_countmeetingnull($dbh);
    $string .= "，懇親会: {$nbanquall}名（確定: {$nbanqu}名）";
  }
  $string .= "</p>";

  if ($list) {
    if ($GLOBALS['admin']) {
      // 現行リスト
      $string .= plugin_evententry_list($dbh, 0, 1);
    } else {
      if ($GLOBALS['sns']) {
	if ($GLOBALS['active']) {
	  $string .= "<br />ここには，登録が確定されたエントリのみリストされています。" ;
	}
	$string .= plugin_evententry_list($dbh, 1);
      }
    }
  }

  return $string;
}

//
// 登録者検索
//
function plugin_evententry_search($addr, $key)
{
  // 登録者DBアクセス
  if (!  $dbh = plugin_evententry_conn() ) {
    echo "接続エラー@_search！";
    return false;
  }

  $query = "SELECT * FROM {$GLOBALS['table']}"
  	   . " WHERE address = '$addr' AND ackey = '$key'";

  if (!  $sth = $dbh->prepare($query) ) {
    syslog(LOG_DEBUG,"pukiwiki: DBError@_search!(prepare)\n\t $query");
    return false;
  }
  if (! $sth->execute() ) {
    syslog(LOG_DEBUG,"pukiwiki: DBError@_search!(execute)\n\t $query");
    //print_r($sth->errorInfo());
    return false;
  }
  $row = $sth->fetch(PDO::FETCH_ASSOC);
  $sth = null;

  return $row;
}

//
// 登録記載確認
//
function plugin_evententry_check($addr)
{
  // 登録者DBアクセス
  if (!  $dbh = plugin_evententry_conn() ) {
    echo "接続エラー@_check！";
    return false;
  }

  $query = "SELECT * FROM {$GLOBALS['table']}"
  	   . " WHERE address = '$addr'";

  if (!  $sth = $dbh->prepare($query) ) {
    syslog(LOG_DEBUG,"pukiwiki: DBError@_check!(prepare)\n\t $query");
    return false;
  }
  if (! $sth->execute() ) {
    syslog(LOG_DEBUG,"pukiwiki: DBError@_check!(execute)\n\t $query");
    //print_r($sth->errorInfo());
    return false;
  }
  $row = $sth->fetch(PDO::FETCH_ASSOC);
  $sth = null;

  return $row;
}

?>
