#!/bin/bash
# MediaWiki	(http://www.mediawiki.org/wiki/MediaWiki)
#	BuildScript for Plamo Linux 4.7
#			by Jun Kuwamura <juk@linet.gr.jp> on 2011-09-04
# require:
# require:
#	httpd-2.2.x
#	php-5.2.x
#	postgresql-8.4.x
#	textsearch_ja-8.4.x
#	mecab-0.97, ipadic-0.9.2
#
VERSION=1.16.5
M_VER=${VERSION%%\.?}
echo $M_VER
SRC_URI="http://download.wikimedia.org/mediawiki/$M_VER/mediawiki-${VERSION}.tar.gz"
#(for example: http://download.wikimedia.org/mediawiki/1.16/mediawiki-1.16.5.tar.gz)

BLDOC=
BLDOC=1

REL=P1

SRC_FILE=${SRC_URI##*/}
PAC_NAME=${SRC_FILE%%.tar.gz}

CPU=noarch
SYS_NAME="${CPU}-${REL}"

PLAMO=/expo/Build
SRC_DIR=$PLAMO/Archive/www/php/appli
PAC_DIR=$PLAMO/Packages/4.7/09_webdb/03_PHP.tgz/
BUILD_DIR=$PLAMO/mediawiki
CUSTOM_DIR=$BUILD_DIR/Custom

PAT_FILE=

JPO_URI=
JPO_FILE=${JPO_URI##*/}

echo $PAC_DIR
if [ ! -d $PAC_DIR ]; then
  mkdir -p  $PAC_DIR
fi
echo $SRC_DIR/$SRC_FILE
if [ ! -f $SRC_DIR/$SRC_FILE ]; then
  if [ ! -d $SRC_DIR ]; then
    mkdir -p $SRC_DIR
  fi
  ( cd $SRC_DIR; wget $SRC_URI )
fi


umask 022
CWD=`pwd`
WORK=$CWD/work
rm -rf $WORK/*
mkdir -p $WORK
export LANG=C
export LC_ALL=C
export CFLAGS="-O2 -march=$CPU"
export PATH=$PATH:/usr/X11R7/bin


cd $WORK

mkdir -p install
sed -e "s/VERSION/$VERSION/g" \
    -e "s/_PACKAGENAME_/${PAC_NAME}-${SYS_NAME}/g" \
    $CUSTOM_DIR/doinst.sh-16 > install/doinst.sh


mkdir -p opt/htdocs
cd opt/htdocs
# cd to application directory
tar xvfz $SRC_DIR/$SRC_FILE
cd $PAC_NAME

sed -e 's/wikiuser/www/' \
    -e 's/localhost/127.0.0.1/' \
    -e 's/wikidb/wikidb16/' \
    -e 's/"en"/"ja"/' \
    -e 's/"Shm", "none"/"Shm", "apc"/' \
    -e '/MEDIAWIKI_INSTALL/a define( "TEXTSEARCH_COMPAT", true );' \
    config/Installer.php > config/Installer.php.new || exit 1
mv -v  config/Installer.php.new  config/Installer.php
sed -e "s%(\$this->numeric_version >= 8.3)%(\$this->numeric_version >= 8.3 \&\&  ( defined('TEXTSEARCH_COMPAT') \&\& TEXTSEARCH_COMPAT != true ))%" \
    includes/db/DatabasePostgres.php > includes/db/DatabasePostgres.php.new || exit 1
mv -v includes/db/DatabasePostgres.php.new includes/db/DatabasePostgres.php

if ! [ -f $CUSTOM_DIR/mediawiki-${VERSION}-docs_html.tgz ]; then
  export PATH=/opt/php5/bin:$PATH
  #echo "0" | php maintenance/mwdocgen.php 
  (cd maintenance; make doc)
  tar cvfz  $CUSTOM_DIR/mediawiki-${VERSION}-docs_html.tgz docs/html
  rm -rf docs/html/
fi

#
# apply or add patches
#
if [ -f $CUSTOM_DIR/$PAT_FILE ]; then
  patch -p1 < $CUSTOM_DIR/$PAT_FILE
fi


# remove unnessasery wrappers
find . -name "*.php5" -o -name "*.phtml" | xargs rm -f

cp -a $CUSTOM_DIR/custom/  ./
cp  $CUSTOM_DIR/plamo7c_ss.png ./skins/common/images/wiki.png
chown -R wadm:apache ./
chown -R www ./config


DOC_DIR=usr/share/doc/$PAC_NAME
mkdir -p $WORK/$DOC_DIR || exit 1
cp -p $BUILD_DIR/`basename $0`  \
    $CUSTOM_DIR/Pg8.3-textsearch_ja.patch \
    $CUSTOM_DIR/Plamo-INSTALL-ja.txt \
  $WORK/$DOC_DIR/
mv -v  [A-Z][A-Z]*  docs/ \
    $WORK/$DOC_DIR
chown -R root:root $WORK/$DOC_DIR
chmod -R a+rX,go-w $WORK/$DOC_DIR


mkdir -p $WORK/opt/htdocs/AppList || exit 1
TYP=2 #(0:httpd, 1:libraries, 2:application)
cat >> $WORK/opt/htdocs/AppList/${TYP}.${PAC_NAME}.list <<__EOCL__
TYP	$TYP
NAM	${PAC_NAME}
URL	http://www.mediawiki.org/wiki/MediaWiki
DOC	/${DOC_DIR}/
EXE	/mediawiki/
REM	wiki package originally written for Wikipedia
__EOCL__


cd $WORK
echo "y
1
" | makepkg ${PAC_NAME}-${SYS_NAME}.tgz

echo -n "$PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz"
if `mv -v ${PAC_NAME}-${SYS_NAME}.tgz  $PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz 1>/dev/null 2>&1`; then
  echo " ... done"
else
  echo " ... false"
fi


if [ "$BLDOC" = "" ]; then
  exit
fi

if ! [ -f $PAC_DIR/mediawiki_doc_html-${VERSION}-${SYS_NAME}.tgz ]; then
  tar xfz  $CUSTOM_DIR/mediawiki-${VERSION}-docs_html.tgz -C $DOC_DIR
  tar cvfz  $PAC_DIR/mediawiki_doc_html-${VERSION}-${SYS_NAME}.tgz \
	$DOC_DIR/docs/html/
  echo -n $PAC_DIR/mediawiki_doc_html-${VERSION}-${SYS_NAME}.tgz
  echo "... done"
fi

cd $CWD
