/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.xml;

import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class XMLEncoding {
    private static final int BOM_LENGTH = 4;
    private static final int MAX_ENC_NAME = 512;
    private static final int SPACE = 32;
    private static final int TAB = 9;
    private static final int LINEFEED = 10;
    private static final int RETURN = 13;
    private static final int EQUAL = 61;
    private static final int DOUBLE_QUOTE = 34;
    private static final int SINGLE_QUOTE = 39;
    private static final int UTF_32_BE_BOM = 65279;
    private static final int UTF_32_LE_BOM = -131072;
    private static final int UTF_16_BE_BOM = -16842752;
    private static final int UTF_16_LE_BOM = -131072;
    private static final int UTF_8_BOM = -272908544;
    private static final int UNUSUAL_OCTET_1 = 15360;
    private static final int UNUSUAL_OCTET_2 = 0x3C0000;
    private static final int UTF_16BE = 3932223;
    private static final int UTF_16LE = 1006649088;
    private static final int EBCDIC = 1282385812;
    private static final int XML_DECLARATION = 1010792557;
    private static final String UTF_32_ENC = "UTF-32";
    private static final String UTF_16_ENC = "UTF-16";
    private static final String UTF_16BE_ENC = "UTF-16BE";
    private static final String UTF_16LE_ENC = "UTF-16LE";
    private static final String UTF_8_ENC = "UTF-8";
    private static final String IBM037_ENC = "IBM037";
    private static final String XML_DECL_START = "<?xml";
    private static final String ENCODING_DECL = "encoding";

    public static String decodeXML(byte[] byArray) throws IOException {
        int n = 0;
        String string = null;
        if (byArray.length < 4) {
            throw new EOFException(ResourceManager.getMessage("encoding.error.not.xml"));
        }
        int n2 = 0xFF000000 & byArray[0] << 24 | 0xFF0000 & byArray[1] << 16 | 0xFF00 & byArray[2] << 8 | 0xFF & byArray[3];
        block0 : switch (n2) {
            case 1282385812: {
                string = XMLEncoding.examineEncodingDeclaration(byArray, IBM037_ENC);
                break;
            }
            case 1010792557: {
                string = XMLEncoding.examineEncodingDeclaration(byArray, UTF_8_ENC);
                break;
            }
            case 3932223: {
                string = UTF_16BE_ENC;
                Trace.println("Detected UTF-16BE encoding from first four bytes", TraceLevel.BASIC);
                break;
            }
            case 1006649088: {
                string = UTF_16LE_ENC;
                Trace.println("Detected UTF-16LE encoding from first four bytes", TraceLevel.BASIC);
                break;
            }
            case 15360: 
            case 0x3C0000: {
                throw new UnsupportedEncodingException(ResourceManager.getMessage("encoding.error.unusual.octet"));
            }
            case -131072: 
            case 65279: {
                string = UTF_32_ENC;
                break;
            }
            default: {
                int n3 = n2 & 0xFFFFFF00;
                switch (n3) {
                    case -272908544: {
                        n = 3;
                        string = UTF_8_ENC;
                        break block0;
                    }
                }
                int n4 = n2 & 0xFFFF0000;
                switch (n4) {
                    case -16842752: 
                    case -131072: {
                        string = UTF_16_ENC;
                        break block0;
                    }
                }
                string = UTF_8_ENC;
            }
        }
        return new String(byArray, n, byArray.length - n, string);
    }

    private static String examineEncodingDeclaration(byte[] byArray, String string) throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        int n = 0;
        int n2 = -1;
        InputStreamReader inputStreamReader = null;
        String string2 = string != null ? string : UTF_8_ENC;
        inputStreamReader = new InputStreamReader((InputStream)new ByteArrayInputStream(byArray), string2);
        n2 = ((Reader)inputStreamReader).read();
        for (int i = 0; i < XML_DECL_START.length() && !bl5; ++i) {
            if (n2 != XML_DECL_START.charAt(i)) {
                bl5 = true;
                break;
            }
            n2 = ((Reader)inputStreamReader).read();
        }
        bl = true;
        block10: while (bl && !bl5) {
            switch (n2) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    n2 = ((Reader)inputStreamReader).read();
                    continue block10;
                }
                case -1: {
                    bl5 = true;
                    continue block10;
                }
            }
            bl = false;
        }
        bl = true;
        while (bl && !bl5) {
            if (n2 == -1) {
                bl5 = true;
                break;
            }
            if (bl2) {
                switch (n2) {
                    case 9: 
                    case 10: 
                    case 13: 
                    case 32: {
                        break;
                    }
                    case 61: {
                        if (!bl3) {
                            bl3 = true;
                            break;
                        }
                        bl2 = false;
                        bl5 = true;
                        break;
                    }
                    case 34: 
                    case 39: {
                        if (bl3) {
                            bl = false;
                            break;
                        }
                        bl2 = false;
                        bl5 = true;
                        break;
                    }
                    default: {
                        bl2 = false;
                        if (!bl3) break;
                        bl5 = true;
                    }
                }
                if (!bl2) {
                    n = 0;
                    continue;
                }
            } else if (n2 == ENCODING_DECL.charAt(n++)) {
                if (ENCODING_DECL.length() == n) {
                    bl2 = true;
                }
            } else if (n2 == 63) {
                bl4 = true;
                n = 0;
            } else {
                if (n2 == 62 && bl4) {
                    bl5 = true;
                    continue;
                }
                n = 0;
            }
            n2 = ((Reader)inputStreamReader).read();
        }
        if (!bl5) {
            StringBuffer stringBuffer = new StringBuffer(512);
            if ((n2 >= 97 && n2 <= 122) | (n2 >= 65 && n2 <= 90)) {
                stringBuffer.append((char)n2);
                bl = true;
                while (bl && !bl5) {
                    n2 = ((Reader)inputStreamReader).read();
                    if (n2 >= 97 && n2 <= 122 || n2 >= 65 && n2 <= 90 || n2 >= 48 && n2 <= 57 || n2 == 95 || n2 == 46 || n2 == 45) {
                        stringBuffer.append((char)n2);
                        continue;
                    }
                    if (n2 == 34 || n2 == 39) {
                        bl6 = true;
                        bl5 = true;
                        string2 = stringBuffer.toString();
                        continue;
                    }
                    bl5 = true;
                }
            } else {
                bl5 = true;
            }
        }
        return string2;
    }
}

