/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertStore;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.security.CertValidator;
import com.sun.deploy.security.DeniedCertStore;
import com.sun.deploy.security.DeployCertPathChecker;
import com.sun.deploy.security.DeploySigningCertStore;
import com.sun.deploy.security.RootCertStore;
import com.sun.deploy.security.SessionCertStore;
import com.sun.deploy.security.X509CertificateWrapper;
import com.sun.deploy.security.X509Util;
import com.sun.deploy.services.Service;
import com.sun.deploy.services.ServiceManager;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.util.Trace;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.security.Timestamp;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import sun.security.validator.PKIXValidator;
import sun.security.validator.Validator;
import sun.security.validator.ValidatorException;

public class TrustDecider {
    private static CertStore rootStore = null;
    private static CertStore permanentStore = null;
    private static CertStore sessionStore = null;
    private static CertStore deniedStore = null;
    private static CertStore browserRootStore = null;
    private static CertStore browserTrustedStore = null;
    private static List jurisdictionList = null;
    private static final List preTrustList = Collections.singletonList("OU=Java Signed Extensions,OU=Corporate Object Signing,O=Sun Microsystems Inc");
    private static boolean isBrowserRootStoreLoaded = false;
    private static X509CRL crl509 = null;
    private static boolean ocspValidConfig = false;
    private static String ocspSigner = null;
    private static String ocspURL = null;
    private static boolean crlCheck = false;
    private static boolean ocspCheck = false;
    private static HashSet deniedURL = null;
    public static final int PERMISSION_GRANTED = 0;
    public static final int PERMISSION_GRANTED_FOR_SESSION = 1;
    public static final int PERMISSION_DENIED = 2;

    public static synchronized void resetDenyStore() {
        Trace.msgSecurityPrintln("trustdecider.check.reset.denystore");
        deniedStore = new DeniedCertStore();
        deniedURL.clear();
    }

    public static synchronized HashSet getDeniedURL() {
        return deniedURL;
    }

    public static synchronized void reset() {
        rootStore = RootCertStore.getCertStore();
        permanentStore = DeploySigningCertStore.getCertStore();
        sessionStore = new SessionCertStore();
        deniedStore = new DeniedCertStore();
        deniedURL = new HashSet();
        jurisdictionList = null;
        if (Config.getBooleanProperty("deployment.security.pretrust.list")) {
            jurisdictionList = preTrustList;
        }
        if (Config.getBooleanProperty("deployment.security.browser.keystore.use")) {
            Service service = ServiceManager.getService();
            browserRootStore = service.getBrowserSigningRootCertStore();
            browserTrustedStore = service.getBrowserTrustedCertStore();
            isBrowserRootStoreLoaded = false;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    String string;
                    crlCheck = Config.getBooleanProperty("deployment.security.validation.crl");
                    if (crlCheck && (string = Config.getProperty("deployment.security.validation.crl.url")) != null && string.length() > 0) {
                        CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
                        URL uRL = new URL(string);
                        URLConnection uRLConnection = uRL.openConnection();
                        uRLConnection.setDoInput(true);
                        uRLConnection.setUseCaches(false);
                        DataInputStream dataInputStream = new DataInputStream(uRLConnection.getInputStream());
                        crl509 = (X509CRL)certificateFactory.generateCRL(dataInputStream);
                        dataInputStream.close();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            privilegedActionException.printStackTrace();
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    ocspCheck = Config.getBooleanProperty("deployment.security.validation.ocsp");
                    if (ocspCheck) {
                        ocspSigner = Config.getProperty("deployment.security.validation.ocsp.signer");
                        ocspURL = Config.getProperty("deployment.security.validation.ocsp.url");
                        if (ocspSigner != null && ocspSigner.length() > 0 && ocspURL != null && ocspURL.length() > 0) {
                            ocspValidConfig = true;
                        }
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            privilegedActionException.printStackTrace();
        }
    }

    public static boolean isAllPermissionGranted(CodeSource codeSource) throws CertificateEncodingException, CertificateExpiredException, CertificateNotYetValidException, CertificateParsingException, CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException, CRLException, InvalidAlgorithmParameterException {
        return TrustDecider.isAllPermissionGranted(codeSource, new AppInfo());
    }

    public static synchronized boolean isAllPermissionGranted(CodeSource codeSource, AppInfo appInfo) throws CertificateEncodingException, CertificateExpiredException, CertificateNotYetValidException, CertificateParsingException, CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException, CRLException, InvalidAlgorithmParameterException {
        return TrustDecider.isAllPermissionGranted(codeSource, appInfo, false) != 2;
    }

    public static synchronized int isAllPermissionGranted(CodeSource codeSource, AppInfo appInfo, boolean bl) throws CertificateEncodingException, CertificateExpiredException, CertificateNotYetValidException, CertificateParsingException, CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException, CRLException, InvalidAlgorithmParameterException {
        int n;
        Certificate[] certificateArray = codeSource.getCertificates();
        URL uRL = codeSource.getLocation();
        if (certificateArray == null) {
            return 2;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String string = null;
        rootStore.load();
        permanentStore.load();
        sessionStore.load();
        deniedStore.load();
        if (browserRootStore != null && !isBrowserRootStoreLoaded) {
            browserRootStore.load();
            isBrowserRootStoreLoaded = true;
        }
        if (browserTrustedStore != null) {
            browserTrustedStore.load();
        }
        ArrayList arrayList = new ArrayList();
        while (n3 < certificateArray.length) {
            ArrayList<Certificate> arrayList2 = new ArrayList<Certificate>();
            int n5 = n2;
            while (n5 + 1 < certificateArray.length && certificateArray[n5] instanceof X509Certificate && certificateArray[n5 + 1] instanceof X509Certificate && CertUtils.isIssuerOf((X509Certificate)certificateArray[n5], (X509Certificate)certificateArray[n5 + 1])) {
                ++n5;
            }
            n3 = n5 + 1;
            for (n = n2; n < n3; ++n) {
                arrayList2.add(certificateArray[n]);
            }
            arrayList.add(arrayList2);
            n2 = n3;
            ++n4;
        }
        boolean bl2 = true;
        try {
            Class<?> clazz = Class.forName("sun.security.validator.Validator", true, ClassLoader.getSystemClassLoader());
            if (clazz == null) {
                bl2 = false;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            Trace.msgSecurityPrintln("trustdecider.check.validate.notfound");
            bl2 = false;
        }
        if (Config.isJavaVersionAtLeast16() && bl2) {
            Trace.msgSecurityPrintln("trustdecider.check.validate.certpath.algorithm");
            boolean bl3 = false;
            n = 0;
            int n6 = 2;
            int n7 = 0;
            LinkedHashSet<X509Certificate> linkedHashSet = new LinkedHashSet<X509Certificate>();
            linkedHashSet.addAll(rootStore.getCertificates());
            if (browserRootStore != null) {
                linkedHashSet.addAll(browserRootStore.getCertificates());
            }
            Iterator iterator = arrayList.iterator();
            n4 = 0;
            while (iterator.hasNext()) {
                boolean bl4;
                Object object;
                Date date;
                X509Certificate x509Certificate;
                int n8;
                Certificate[] certificateArray2;
                block78: {
                    X509Certificate[] x509CertificateArray;
                    Object object2;
                    X500Principal x500Principal;
                    List list = (List)iterator.next();
                    certificateArray2 = list.toArray(new X509Certificate[0]);
                    CertificateExpiredException certificateExpiredException = null;
                    CertificateNotYetValidException certificateNotYetValidException = null;
                    for (n8 = 0; n8 < certificateArray2.length; ++n8) {
                        try {
                            certificateArray2[n8].checkValidity();
                            continue;
                        }
                        catch (CertificateExpiredException certificateExpiredException2) {
                            if (certificateExpiredException != null) continue;
                            certificateExpiredException = certificateExpiredException2;
                            n7 = -1;
                            n = 1;
                            continue;
                        }
                        catch (CertificateNotYetValidException certificateNotYetValidException2) {
                            if (certificateNotYetValidException != null) continue;
                            certificateNotYetValidException = certificateNotYetValidException2;
                            n7 = 1;
                            n = 1;
                        }
                    }
                    n8 = certificateArray2.length;
                    x509Certificate = certificateArray2[n8 - 1];
                    X500Principal x500Principal2 = x509Certificate.getIssuerX500Principal();
                    if (((Object)x500Principal2).equals(x500Principal = x509Certificate.getSubjectX500Principal()) && !linkedHashSet.contains(x509Certificate)) {
                        if (!Config.getBooleanProperty("deployment.security.askgrantdialog.notinca")) {
                            string = ResourceManager.getMessage("trustdecider.user.cannot.grant.notinca");
                            throw new CertificateException(string);
                        }
                        bl3 = true;
                        linkedHashSet.add(x509Certificate);
                    }
                    date = null;
                    try {
                        CodeSigner[] codeSignerArray = codeSource.getCodeSigners();
                        Timestamp timestamp = codeSignerArray[n4].getTimestamp();
                        if (timestamp != null) {
                            Trace.msgSecurityPrintln("trustdecider.check.timestamping.yes");
                            date = timestamp.getTimestamp();
                            CertPath certPath = timestamp.getSignerCertPath();
                            if (n != 0) {
                                Trace.msgSecurityPrintln("trustdecider.check.timestamping.need");
                                object2 = certificateArray2[n8 - 1].getNotAfter();
                                object = certificateArray2[n8 - 1].getNotBefore();
                                if (date.before((Date)object2) && date.after((Date)object)) {
                                    Trace.msgSecurityPrintln("trustdecider.check.timestamping.valid");
                                    boolean bl5 = TrustDecider.checkTSAPath(certPath, linkedHashSet);
                                    if (bl5) {
                                        n = 0;
                                        n7 = 0;
                                    } else {
                                        date = null;
                                    }
                                } else {
                                    Trace.msgSecurityPrintln("trustdecider.check.timestamping.invalid");
                                }
                            } else {
                                Trace.msgSecurityPrintln("trustdecider.check.timestamping.noneed");
                            }
                        } else {
                            Trace.msgSecurityPrintln("trustdecider.check.timestamping.no");
                        }
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        Trace.msgSecurityPrintln("trustdecider.check.timestamping.notfound");
                    }
                    bl4 = false;
                    if (jurisdictionList != null) {
                        Trace.msgSecurityPrintln("trustdecider.check.jurisdiction.found");
                        if (!bl3 && n7 == 0) {
                            Trace.msgSecurityPrintln("trustdecider.check.trustextension.on");
                            bl4 = TrustDecider.checkTrustedExtension(certificateArray2[0]);
                        } else {
                            Trace.msgSecurityPrintln("trustdecider.check.trustextension.off");
                        }
                        if (!(crlCheck && ocspCheck || !bl4 || permanentStore.contains(certificateArray2[0]))) {
                            crlCheck = true;
                            ocspCheck = true;
                            Security.setProperty("com.sun.security.onlyCheckRevocationOfEECert", "true");
                        }
                    } else {
                        Trace.msgSecurityPrintln("trustdecider.check.jurisdiction.notfound");
                    }
                    boolean bl6 = false;
                    boolean bl7 = false;
                    try {
                        int n9;
                        object2 = Validator.getInstance("PKIX", "plugin code signing", linkedHashSet);
                        object = (PKIXValidator)object2;
                        PKIXParameters pKIXParameters = ((PKIXValidator)object).getParameters();
                        pKIXParameters.addCertPathChecker(new DeployCertPathChecker((PKIXValidator)object));
                        if (crlCheck) {
                            Trace.msgSecurityPrintln("trustdecider.check.validation.crl.on");
                            if (crl509 != null) {
                                bl6 = true;
                            } else {
                                for (n9 = 0; n9 < certificateArray2.length; ++n9) {
                                    if (!CertUtils.getCertCRLExtension(certificateArray2[n9])) continue;
                                    bl6 = true;
                                }
                            }
                            pKIXParameters = TrustDecider.doCRLValidation(pKIXParameters, bl6);
                        } else {
                            Trace.msgSecurityPrintln("trustdecider.check.validation.crl.off");
                        }
                        if (ocspCheck) {
                            Trace.msgSecurityPrintln("trustdecider.check.validation.ocsp.on");
                            if (ocspValidConfig) {
                                bl7 = true;
                            } else {
                                for (n9 = 0; n9 < certificateArray2.length; ++n9) {
                                    if (!CertUtils.getCertAIAExtension(certificateArray2[n9])) continue;
                                    bl7 = true;
                                }
                            }
                            TrustDecider.doOCSPValidation(pKIXParameters, linkedHashSet, (X509Certificate[])certificateArray2, bl7);
                        } else {
                            Trace.msgSecurityPrintln("trustdecider.check.validation.ocsp.off");
                        }
                        x509CertificateArray = new X509Certificate[n8];
                        for (int i = 0; i < n8; ++i) {
                            x509CertificateArray[i] = new X509CertificateWrapper(certificateArray2[i]);
                        }
                        ((Validator)object2).validate(x509CertificateArray);
                        if (crlCheck && bl6) {
                            Trace.msgSecurityPrintln("trustdecider.check.validation.crl.succeed");
                        }
                        if (ocspCheck && bl7) {
                            Trace.msgSecurityPrintln("trustdecider.check.validation.ocsp.succeed");
                        }
                    }
                    catch (CertificateException certificateException) {
                        if (!Config.getBooleanProperty("deployment.security.askgrantdialog.notinca")) {
                            string = ResourceManager.getMessage("trustdecider.user.cannot.grant.notinca");
                            throw new CertificateException(string);
                        }
                        if (certificateException instanceof ValidatorException) {
                            object = (ValidatorException)certificateException;
                            if (ValidatorException.T_NO_TRUST_ANCHOR.equals(((ValidatorException)object).getErrorType())) {
                                bl3 = true;
                                break block78;
                            }
                            String string2 = "Certificate has been revoked";
                            if (crlCheck && bl6 || ocspCheck && bl7) {
                                x509CertificateArray = ((Throwable)object).getMessage();
                                if (x509CertificateArray.contains(string2)) {
                                    Trace.msgSecurityPrintln("trustdecider.check.validation.revoked");
                                } else {
                                    Trace.msgSecurityPrintln((String)x509CertificateArray);
                                }
                                throw object;
                            }
                            throw object;
                        }
                        throw certificateException;
                    }
                    catch (IOException iOException) {
                        Trace.msgSecurityPrintln(iOException.getMessage());
                        throw iOException;
                    }
                    catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                        Trace.msgSecurityPrintln(invalidAlgorithmParameterException.getMessage());
                        throw invalidAlgorithmParameterException;
                    }
                    catch (CRLException cRLException) {
                        Trace.msgSecurityPrintln(cRLException.getMessage());
                        throw cRLException;
                    }
                    finally {
                        Security.setProperty("com.sun.security.onlyCheckRevocationOfEECert", "false");
                    }
                }
                if (bl3) {
                    linkedHashSet.remove(x509Certificate);
                }
                int n10 = 0;
                if (deniedStore.contains(certificateArray2[0])) {
                    deniedURL.add(uRL);
                    n10 = deniedStore.contains(certificateArray2[0], true) ? 1 : n;
                }
                if (n10 == 0) {
                    if (permanentStore.contains(certificateArray2[0]) && (n == 0 || !permanentStore.contains(certificateArray2[0], true))) {
                        return 0;
                    }
                    if (bl4 && !permanentStore.contains(certificateArray2[0], true)) {
                        object = DeploySigningCertStore.getUserCertStore();
                        object.load(true);
                        if (object.add(certificateArray2[0], true)) {
                            object.save();
                        }
                        Trace.msgSecurityPrintln("trustdecider.check.trustextension.add");
                        return 0;
                    }
                    if (sessionStore.contains(certificateArray2[0]) && (n == 0 || !sessionStore.contains(certificateArray2[0], true))) {
                        return 1;
                    }
                    if (browserTrustedStore != null && browserTrustedStore.contains(certificateArray2[0])) {
                        return 1;
                    }
                    if (!Config.getBooleanProperty("deployment.security.askgrantdialog.show")) {
                        string = ResourceManager.getMessage("trustdecider.user.cannot.grant.any");
                        throw new CertificateException(string);
                    }
                    int n11 = X509Util.showSecurityDialog(certificateArray2, codeSource.getLocation(), 0, n8, bl3, n7, date, appInfo, bl);
                    if (n11 == 0) {
                        Trace.msgSecurityPrintln("trustdecider.user.grant.session");
                        sessionStore.add(certificateArray2[0], n == 0);
                        sessionStore.save();
                        n6 = 1;
                    } else if (n11 == 2) {
                        Trace.msgSecurityPrintln("trustdecider.user.grant.forever");
                        CertStore certStore = DeploySigningCertStore.getUserCertStore();
                        certStore.load(true);
                        if (certStore.add(certificateArray2[0], n == 0)) {
                            certStore.save();
                        }
                        n6 = 0;
                    } else {
                        Trace.msgSecurityPrintln("trustdecider.user.deny");
                        deniedStore.add(certificateArray2[0], n == 0);
                        deniedStore.save();
                        deniedURL.add(uRL);
                    }
                    if (n6 != 2) {
                        return n6;
                    }
                }
                ++n4;
            }
        } else {
            Trace.msgSecurityPrintln("trustdecider.check.validate.legacy.algorithm");
            if (CertValidator.validate(codeSource, appInfo, certificateArray, n4, rootStore, browserRootStore, browserTrustedStore, sessionStore, permanentStore, deniedStore)) {
                return 1;
            }
        }
        return 2;
    }

    private static boolean checkTSAPath(CertPath certPath, LinkedHashSet linkedHashSet) {
        Trace.msgSecurityPrintln("trustdecider.check.timestamping.tsapath");
        Validator validator = Validator.getInstance("PKIX", "tsa server", linkedHashSet);
        List<? extends Certificate> list = certPath.getCertificates();
        X509Certificate[] x509CertificateArray = list.toArray(new X509Certificate[0]);
        try {
            x509CertificateArray = validator.validate(x509CertificateArray);
        }
        catch (CertificateException certificateException) {
            Trace.msgSecurityPrintln(certificateException.getMessage());
            return false;
        }
        return true;
    }

    private static PKIXParameters doCRLValidation(PKIXParameters pKIXParameters, boolean bl) throws IOException, InvalidAlgorithmParameterException, CRLException, NoSuchAlgorithmException {
        if (crl509 != null) {
            Trace.msgSecurityPrintln("trustdecider.check.validation.crl.system.on");
            System.clearProperty("com.sun.security.enableCRLDP");
            pKIXParameters.setRevocationEnabled(true);
            pKIXParameters.addCertStore(java.security.cert.CertStore.getInstance("Collection", new CollectionCertStoreParameters(Collections.singletonList(crl509))));
        } else {
            Trace.msgSecurityPrintln("trustdecider.check.validation.crl.system.off");
            pKIXParameters.setRevocationEnabled(bl);
            System.setProperty("com.sun.security.enableCRLDP", Boolean.toString(bl));
        }
        return pKIXParameters;
    }

    private static void doOCSPValidation(PKIXParameters pKIXParameters, LinkedHashSet linkedHashSet, X509Certificate[] x509CertificateArray, boolean bl) throws IOException {
        X509Certificate x509Certificate = null;
        boolean bl2 = false;
        Security.setProperty("ocsp.enable", Boolean.toString(bl));
        if (ocspValidConfig) {
            Security.setProperty("ocsp.responderURL", ocspURL);
        }
        pKIXParameters.setRevocationEnabled(bl);
        if (ocspValidConfig) {
            Trace.msgSecurityPrintln("trustdecider.check.validation.ocsp.system.on");
            String string = null;
            Iterator iterator = linkedHashSet.iterator();
            while (iterator.hasNext()) {
                x509Certificate = (X509Certificate)iterator.next();
                string = CertUtils.extractSubjectAliasName(x509Certificate);
                if (!ocspSigner.equals(string)) continue;
                bl2 = true;
                break;
            }
            if (bl2 && x509Certificate != null) {
                Security.setProperty("ocsp.responderCertSubjectName", x509Certificate.getSubjectX500Principal().getName());
            }
        } else {
            Trace.msgSecurityPrintln("trustdecider.check.validation.ocsp.system.off");
        }
        if (!crlCheck && bl) {
            System.setProperty("com.sun.security.enableCRLDP", "true");
        }
    }

    private static boolean checkTrustedExtension(X509Certificate x509Certificate) {
        Trace.msgSecurityPrintln("trustdecider.check.trustextension.jurisdiction");
        X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
        String string = x500Principal.getName();
        Iterator iterator = jurisdictionList.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string.endsWith(string2)) continue;
            Trace.msgSecurityPrintln("trustdecider.check.trustextension.jurisdiction.found");
            return true;
        }
        return false;
    }

    static {
        TrustDecider.reset();
    }
}

