/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.ExtensionType;
import com.sun.net.ssl.internal.ssl.HandshakeInStream;
import com.sun.net.ssl.internal.ssl.HandshakeOutStream;
import com.sun.net.ssl.internal.ssl.HelloExtension;
import com.sun.net.ssl.internal.ssl.ServerNameExtension;
import com.sun.net.ssl.internal.ssl.SupportedEllipticCurvesExtension;
import com.sun.net.ssl.internal.ssl.SupportedEllipticPointFormatsExtension;
import com.sun.net.ssl.internal.ssl.UnknownExtension;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLProtocolException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class HelloExtensions {
    private List<HelloExtension> extensions;
    private int encodedLength;

    HelloExtensions() {
        this.extensions = Collections.emptyList();
    }

    HelloExtensions(HandshakeInStream handshakeInStream) throws IOException {
        int n;
        int n2;
        this.extensions = new ArrayList<HelloExtension>();
        this.encodedLength = n2 + 2;
        for (n2 = handshakeInStream.getInt16(); n2 > 0; n2 -= n + 4) {
            int n3 = handshakeInStream.getInt16();
            n = handshakeInStream.getInt16();
            ExtensionType extensionType = ExtensionType.get(n3);
            HelloExtension helloExtension = extensionType == ExtensionType.EXT_SERVER_NAME ? new ServerNameExtension(handshakeInStream, n) : (extensionType == ExtensionType.EXT_ELLIPTIC_CURVES ? new SupportedEllipticCurvesExtension(handshakeInStream, n) : (extensionType == ExtensionType.EXT_EC_POINT_FORMATS ? new SupportedEllipticPointFormatsExtension(handshakeInStream, n) : new UnknownExtension(handshakeInStream, n, extensionType)));
            this.extensions.add(helloExtension);
        }
        if (n2 != 0) {
            throw new SSLProtocolException("Error parsing extensions: extra data");
        }
    }

    List<HelloExtension> list() {
        return this.extensions;
    }

    void add(HelloExtension helloExtension) {
        if (this.extensions.isEmpty()) {
            this.extensions = new ArrayList<HelloExtension>();
        }
        this.extensions.add(helloExtension);
        this.encodedLength = -1;
    }

    HelloExtension get(ExtensionType extensionType) {
        for (HelloExtension helloExtension : this.extensions) {
            if (helloExtension.type != extensionType) continue;
            return helloExtension;
        }
        return null;
    }

    int length() {
        if (this.encodedLength >= 0) {
            return this.encodedLength;
        }
        if (this.extensions.isEmpty()) {
            this.encodedLength = 0;
        } else {
            this.encodedLength = 2;
            for (HelloExtension helloExtension : this.extensions) {
                this.encodedLength += helloExtension.length();
            }
        }
        return this.encodedLength;
    }

    void send(HandshakeOutStream handshakeOutStream) throws IOException {
        int n = this.length();
        if (n == 0) {
            return;
        }
        handshakeOutStream.putInt16(n - 2);
        for (HelloExtension helloExtension : this.extensions) {
            helloExtension.send(handshakeOutStream);
        }
    }

    void print(PrintStream printStream) throws IOException {
        for (HelloExtension helloExtension : this.extensions) {
            printStream.println(helloExtension.toString());
        }
    }
}

