/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.AWTEvent;
import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.PaintEvent;
import java.awt.image.ColorModel;
import java.awt.peer.ComponentPeer;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.EmbeddedFrame;
import sun.awt.PaintEventDispatcher;
import sun.awt.PeerEvent;
import sun.awt.SunToolkit;
import sun.awt.X11.AwtGraphicsConfigData;
import sun.awt.X11.ComponentAccessor;
import sun.awt.X11.MWMConstants;
import sun.awt.X11.Native;
import sun.awt.X11.PropMwmHints;
import sun.awt.X11.WindowPropertyGetter;
import sun.awt.X11.XAtom;
import sun.awt.X11.XAtomList;
import sun.awt.X11.XAwtState;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XButtonEvent;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XCrossingEvent;
import sun.awt.X11.XDecoratedPeer;
import sun.awt.X11.XEvent;
import sun.awt.X11.XExposeEvent;
import sun.awt.X11.XGlobalCursorManager;
import sun.awt.X11.XKeyEvent;
import sun.awt.X11.XKeysym;
import sun.awt.X11.XMotionEvent;
import sun.awt.X11.XPropertyEvent;
import sun.awt.X11.XRepaintArea;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XVisualInfo;
import sun.awt.X11.XWM;
import sun.awt.X11.XWindowAttributesData;
import sun.awt.X11.XWindowPeer;
import sun.awt.X11.XlibWrapper;
import sun.awt.X11ComponentPeer;
import sun.awt.X11GraphicsConfig;
import sun.awt.image.PixelConverter;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;

public class XWindow
extends XBaseWindow
implements X11ComponentPeer,
MWMConstants {
    private static Logger log = Logger.getLogger("sun.awt.X11.XWindow");
    private static Logger insLog = Logger.getLogger("sun.awt.X11.insets.XWindow");
    private static Logger eventLog = Logger.getLogger("sun.awt.X11.event.XWindow");
    private static final Logger focusLog = Logger.getLogger("sun.awt.X11.focus.XWindow");
    private static Logger keyEventLog = Logger.getLogger("sun.awt.X11.kye.XWindow");
    private static final int AWT_MULTICLICK_SMUDGE = 4;
    static int rbutton = 0;
    static int lastX = 0;
    static int lastY = 0;
    static long lastTime = 0L;
    static long lastButton = 0L;
    static WeakReference lastWindowRef = null;
    static int clickCount = 0;
    int oldWidth = -1;
    int oldHeight = -1;
    protected X11GraphicsConfig graphicsConfig;
    protected AwtGraphicsConfigData graphicsConfigData;
    private boolean reparented;
    XWindow parent;
    Component target;
    private static int JAWT_LOCK_ERROR = 1;
    private static int JAWT_LOCK_CLIP_CHANGED = 2;
    private static int JAWT_LOCK_BOUNDS_CHANGED = 4;
    private static int JAWT_LOCK_SURFACE_CHANGED = 8;
    private int drawState = JAWT_LOCK_CLIP_CHANGED | JAWT_LOCK_BOUNDS_CHANGED | JAWT_LOCK_SURFACE_CHANGED;
    public static final String TARGET = "target";
    public static final String REPARENTED = "reparented";
    SurfaceData surfaceData;
    XRepaintArea paintArea;
    static final Font defaultFont = new Font("Dialog", 0, 12);
    protected PropMwmHints mwm_hints;
    protected static XAtom wm_protocols;
    protected static XAtom wm_delete_window;
    protected static XAtom wm_take_focus;
    private boolean stateChanged;
    private int savedState;
    XWindowAttributesData winAttr;
    private static Field isPostedField;
    private static Field rawCodeField;
    private static Field primaryLevelUnicodeField;
    static Method m_sendMessage;
    Color backgroundColor;
    private boolean mouseAboveMe;
    static Hashtable<Integer, Character> jkeycode2UCSHash;
    static Field bdata;

    native int getNativeColor(Color var1, GraphicsConfiguration var2);

    native void getWMInsets(long var1, long var3, long var5, long var7, long var9, long var11);

    native long getTopWindow(long var1, long var3);

    native void getWindowBounds(long var1, long var3, long var5, long var7, long var9);

    private static native void initIDs();

    XWindow(XCreateWindowParams xCreateWindowParams) {
        super(xCreateWindowParams);
    }

    XWindow() {
    }

    XWindow(long l, Rectangle rectangle) {
        super(new XCreateWindowParams(new Object[]{"bounds", rectangle, "parent window", l}));
    }

    XWindow(Component component, long l, Rectangle rectangle) {
        super(new XCreateWindowParams(new Object[]{"bounds", rectangle, "parent window", l, TARGET, component}));
    }

    XWindow(Component component, long l) {
        this(component, l, component.getBounds());
    }

    XWindow(Component component) {
        this(component, component.getParent() == null ? 0L : XWindow.getParentWindowID(component), component.getBounds());
    }

    XWindow(Object object) {
        this(null, 0L, null);
    }

    XWindow(long l) {
        super(new XCreateWindowParams(new Object[]{"parent window", l, REPARENTED, Boolean.TRUE, "embedded", Boolean.TRUE}));
    }

    protected void initGraphicsConfiguration() {
        this.graphicsConfig = (X11GraphicsConfig)this.target.getGraphicsConfiguration();
        this.graphicsConfigData = new AwtGraphicsConfigData(this.graphicsConfig.getAData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void preInit(XCreateWindowParams xCreateWindowParams) {
        super.preInit(xCreateWindowParams);
        this.reparented = Boolean.TRUE.equals(xCreateWindowParams.get(REPARENTED));
        this.target = (Component)xCreateWindowParams.get(TARGET);
        this.initGraphicsConfiguration();
        AwtGraphicsConfigData awtGraphicsConfigData = this.getGraphicsConfigurationData();
        X11GraphicsConfig x11GraphicsConfig = (X11GraphicsConfig)this.getGraphicsConfiguration();
        XVisualInfo xVisualInfo = awtGraphicsConfigData.get_awt_visInfo();
        xCreateWindowParams.putIfNull((Object)"event mask", 2269311L);
        if (this.target != null) {
            xCreateWindowParams.putIfNull((Object)"bounds", this.target.getBounds());
        } else {
            xCreateWindowParams.putIfNull((Object)"bounds", new Rectangle(0, 0, 1, 1));
        }
        xCreateWindowParams.putIfNull((Object)"border pixel", (Object)0L);
        this.getColorModel();
        xCreateWindowParams.putIfNull((Object)"color map", awtGraphicsConfigData.get_awt_cmap());
        xCreateWindowParams.putIfNull((Object)"visual depth", awtGraphicsConfigData.get_awt_depth());
        xCreateWindowParams.putIfNull((Object)"visual class", (Object)1);
        xCreateWindowParams.putIfNull((Object)"visual", xVisualInfo.get_visual());
        xCreateWindowParams.putIfNull((Object)"value mask", 10248L);
        Long l = (Long)xCreateWindowParams.get("parent window");
        if ((l == null || l == 0L) && xVisualInfo != null) {
            XToolkit.awtLock();
            try {
                int n = xVisualInfo.get_screen();
                if (n != -1) {
                    xCreateWindowParams.add((Object)"parent window", XlibWrapper.RootWindow(XToolkit.getDisplay(), n));
                } else {
                    xCreateWindowParams.add((Object)"parent window", XToolkit.getDefaultRootWindow());
                }
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        this.paintArea = new XRepaintArea();
        if (this.target != null) {
            this.parent = XWindow.getParentXWindowObject(this.target.getParent());
        }
        xCreateWindowParams.putIfNull((Object)"backing store", XToolkit.getBackingStoreType());
        XToolkit.awtLock();
        try {
            if (wm_protocols == null) {
                wm_protocols = XAtom.get("WM_PROTOCOLS");
                wm_delete_window = XAtom.get("WM_DELETE_WINDOW");
                wm_take_focus = XAtom.get("WM_TAKE_FOCUS");
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
        this.winAttr = new XWindowAttributesData();
        this.savedState = 0;
    }

    void postInit(XCreateWindowParams xCreateWindowParams) {
        Color color;
        super.postInit(xCreateWindowParams);
        this.setWMClass(this.getWMClass());
        this.surfaceData = this.graphicsConfig.createSurfaceData(this);
        if (this.target != null && (color = this.target.getBackground()) != null) {
            this.xSetBackground(color);
        }
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        if (this.graphicsConfig == null) {
            this.initGraphicsConfiguration();
        }
        return this.graphicsConfig;
    }

    public AwtGraphicsConfigData getGraphicsConfigurationData() {
        if (this.graphicsConfigData == null) {
            this.initGraphicsConfiguration();
        }
        return this.graphicsConfigData;
    }

    protected String[] getWMClass() {
        return new String[]{XToolkit.getCorrectXIDString(this.getClass().getName()), XToolkit.getAWTAppClassName()};
    }

    void setReparented(boolean bl) {
        this.reparented = bl;
    }

    boolean isReparented() {
        return this.reparented;
    }

    static long getParentWindowID(Component component) {
        ComponentPeer componentPeer = component.getParent().getPeer();
        Container container = component.getParent();
        while (!(componentPeer instanceof XWindow)) {
            container = container.getParent();
            componentPeer = container.getPeer();
        }
        if (componentPeer != null && componentPeer instanceof XWindow) {
            return ((XWindow)((Object)componentPeer)).getContentWindow();
        }
        return 0L;
    }

    static XWindow getParentXWindowObject(Component component) {
        if (component == null) {
            return null;
        }
        Container container = component.getParent();
        if (container == null) {
            return null;
        }
        ComponentPeer componentPeer = container.getPeer();
        if (componentPeer == null) {
            return null;
        }
        while (componentPeer != null && !(componentPeer instanceof XWindow)) {
            container = container.getParent();
            componentPeer = container.getPeer();
        }
        if (componentPeer != null && componentPeer instanceof XWindow) {
            return (XWindow)((Object)componentPeer);
        }
        return null;
    }

    boolean isParentOf(XWindow xWindow) {
        if (!(this.target instanceof Container) || xWindow == null || xWindow.getTarget() == null) {
            return false;
        }
        Container container = ComponentAccessor.getParent_NoClientCode(xWindow.target);
        while (container != null && container != this.target) {
            container = ComponentAccessor.getParent_NoClientCode(container);
        }
        return container == this.target;
    }

    public Object getTarget() {
        return this.target;
    }

    public Component getEventSource() {
        return this.target;
    }

    public ColorModel getColorModel(int n) {
        return this.graphicsConfig.getColorModel(n);
    }

    public ColorModel getColorModel() {
        if (this.graphicsConfig != null) {
            return this.graphicsConfig.getColorModel();
        }
        return XToolkit.getStaticColorModel();
    }

    Graphics getGraphics(SurfaceData surfaceData, Color color, Color color2, Font font) {
        Font font2;
        Color color3;
        if (surfaceData == null) {
            return null;
        }
        Component component = this.target;
        Color color4 = color2;
        if (color4 == null) {
            color4 = SystemColor.window;
        }
        if ((color3 = color) == null) {
            color3 = SystemColor.windowText;
        }
        if ((font2 = font) == null) {
            font2 = defaultFont;
        }
        return new SunGraphics2D(surfaceData, color3, color4, font2);
    }

    public Graphics getGraphics() {
        return this.getGraphics(this.surfaceData, this.target.getForeground(), this.target.getBackground(), this.target.getFont());
    }

    public FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public Rectangle getTargetBounds() {
        return this.target.getBounds();
    }

    boolean prePostEvent(AWTEvent aWTEvent) {
        return false;
    }

    static void sendEvent(final AWTEvent aWTEvent) {
        if (isPostedField == null) {
            isPostedField = XToolkit.getField(AWTEvent.class, "isPosted");
        }
        SunToolkit.setSystemGenerated(aWTEvent);
        PeerEvent peerEvent = new PeerEvent(Toolkit.getDefaultToolkit(), new Runnable(){

            public void run() {
                block4: {
                    try {
                        isPostedField.setBoolean(aWTEvent, true);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        assert (false);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        if ($assertionsDisabled) break block4;
                        throw new AssertionError();
                    }
                }
                ((Component)aWTEvent.getSource()).dispatchEvent(aWTEvent);
            }
        }, 2L);
        if (focusLog.isLoggable(Level.FINER) && aWTEvent instanceof FocusEvent) {
            focusLog.finer("Sending " + aWTEvent);
        }
        XToolkit.postEvent(XToolkit.targetToAppContext(aWTEvent.getSource()), peerEvent);
    }

    void postEvent(AWTEvent aWTEvent) {
        XToolkit.postEvent(XToolkit.targetToAppContext(aWTEvent.getSource()), aWTEvent);
    }

    static void postEventStatic(AWTEvent aWTEvent) {
        XToolkit.postEvent(XToolkit.targetToAppContext(aWTEvent.getSource()), aWTEvent);
    }

    public void postEventToEventQueue(AWTEvent aWTEvent) {
        if (!this.prePostEvent(aWTEvent)) {
            this.postEvent(aWTEvent);
        }
    }

    protected boolean doEraseBackground() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void xSetBackground(Color color) {
        XToolkit.awtLock();
        try {
            this.winBackground(color);
            if (!this.doEraseBackground()) {
                return;
            }
            ColorModel colorModel = this.getColorModel();
            int n = PixelConverter.instance.rgbToPixel(color.getRGB(), colorModel);
            XlibWrapper.XSetWindowBackground(XToolkit.getDisplay(), this.getContentWindow(), n);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    public void setBackground(Color color) {
        this.xSetBackground(color);
    }

    void winBackground(Color color) {
        this.backgroundColor = color;
    }

    public Color getWinBackground() {
        Color color = null;
        if (this.backgroundColor != null) {
            color = this.backgroundColor;
        } else if (this.parent != null) {
            color = this.parent.getWinBackground();
        }
        if (color instanceof SystemColor) {
            color = new Color(color.getRGB());
        }
        return color;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaint(int n, int n2, int n3, int n4) {
        if (!this.isVisible()) {
            return;
        }
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            try {
                graphics.setClip(n, n2, n3, n4);
                this.paint(graphics);
            }
            finally {
                graphics.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaint() {
        if (!this.isVisible()) {
            return;
        }
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            try {
                this.paint(graphics);
            }
            finally {
                graphics.dispose();
            }
        }
    }

    void paint(Graphics graphics) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flush() {
        XToolkit.awtLock();
        try {
            XlibWrapper.XFlush(XToolkit.getDisplay());
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    public void popup(int n, int n2, int n3, int n4) {
        this.xSetBounds(n, n2, n3, n4);
    }

    public void handleExposeEvent(XEvent xEvent) {
        super.handleExposeEvent(xEvent);
        XExposeEvent xExposeEvent = xEvent.get_xexpose();
        if (this.isEventDisabled(xEvent)) {
            return;
        }
        int n = xExposeEvent.get_x();
        int n2 = xExposeEvent.get_y();
        int n3 = xExposeEvent.get_width();
        int n4 = xExposeEvent.get_height();
        Component component = this.getEventSource();
        if (!ComponentAccessor.getIgnoreRepaint(component) && ComponentAccessor.getWidth(component) != 0 && ComponentAccessor.getHeight(component) != 0) {
            this.handleExposeEvent(component, n, n2, n3, n4);
        }
    }

    public void handleExposeEvent(Component component, int n, int n2, int n3, int n4) {
        PaintEvent paintEvent = PaintEventDispatcher.getPaintEventDispatcher().createPaintEvent(component, n, n2, n3, n4);
        if (paintEvent != null) {
            this.postEventToEventQueue(paintEvent);
        }
    }

    static int getModifiers(int n, int n2, int n3) {
        int n4 = 0;
        if ((n & 1) != 0 ^ n3 == 16) {
            n4 |= 0x40;
        }
        if ((n & 4) != 0 ^ n3 == 17) {
            n4 |= 0x80;
        }
        if ((n & XToolkit.metaMask) != 0 ^ n3 == 157) {
            n4 |= 0x100;
        }
        if ((n & XToolkit.altMask) != 0 ^ n3 == 18) {
            n4 |= 0x200;
        }
        if ((n & XToolkit.modeSwitchMask) != 0 ^ n3 == 65406) {
            n4 |= 0x2000;
        }
        if ((n & 0x100) != 0 ^ n2 == 1) {
            n4 |= 0x400;
        }
        if ((n & 0x200) != 0 ^ n2 == 2) {
            n4 |= 0x800;
        }
        if ((n & 0x400) != 0 ^ n2 == 3) {
            n4 |= 0x1000;
        }
        return n4;
    }

    static int getXModifiers(AWTKeyStroke aWTKeyStroke) {
        int n = aWTKeyStroke.getModifiers();
        int n2 = 0;
        if ((n & 0x41) != 0) {
            n2 |= 1;
        }
        if ((n & 0x82) != 0) {
            n2 |= 4;
        }
        if ((n & 0x208) != 0) {
            n2 |= XToolkit.altMask;
        }
        if ((n & 0x104) != 0) {
            n2 |= XToolkit.metaMask;
        }
        if ((n & 0x2020) != 0) {
            n2 |= XToolkit.modeSwitchMask;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getRightButtonNumber() {
        if (rbutton == 0) {
            XToolkit.awtLock();
            try {
                rbutton = XlibWrapper.XGetPointerMapping(XToolkit.getDisplay(), XlibWrapper.ibuffer, 3);
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        return rbutton;
    }

    static int getMouseMovementSmudge() {
        return 4;
    }

    public void handleButtonPressRelease(XEvent xEvent) {
        Serializable serializable;
        super.handleButtonPressRelease(xEvent);
        XButtonEvent xButtonEvent = xEvent.get_xbutton();
        if (this.isEventDisabled(xEvent)) {
            return;
        }
        if (eventLog.isLoggable(Level.FINE)) {
            eventLog.fine(xButtonEvent.toString());
        }
        boolean bl = false;
        int n = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        long l = xButtonEvent.get_button();
        int n2 = xEvent.get_type();
        long l2 = xButtonEvent.get_time();
        long l3 = XToolkit.nowMillisUTC_offset(l2);
        int n3 = xButtonEvent.get_x();
        int n4 = xButtonEvent.get_y();
        if (xEvent.get_xany().get_window() != this.window) {
            serializable = this.toLocal(xButtonEvent.get_x_root(), xButtonEvent.get_y_root());
            n3 = serializable.x;
            n4 = serializable.y;
        }
        if (n2 == 4) {
            Point point = serializable = lastWindowRef != null ? (XWindow)lastWindowRef.get() : null;
            if (eventLog.isLoggable(Level.FINEST)) {
                eventLog.finest("lastWindow = " + serializable + ", lastButton " + lastButton + ", lastTime " + lastTime + ", multiClickTime " + XToolkit.getMultiClickTime());
            }
            if (serializable == this && lastButton == l && l2 - lastTime < (long)XToolkit.getMultiClickTime()) {
                ++clickCount;
            } else {
                clickCount = 1;
                lastWindowRef = new WeakReference<XWindow>(this);
                lastButton = l;
                lastX = n3;
                lastY = n4;
            }
            lastTime = l2;
            bl = l == (long)XWindow.getRightButtonNumber() || l > 2L;
        } else {
            Point point = serializable = lastWindowRef != null ? (XWindow)lastWindowRef.get() : null;
            if (serializable == this) {
                bl2 = true;
            }
        }
        if (l == 1L) {
            n = 1;
        } else if (l == 2L) {
            n = 2;
        } else if (l == 3L) {
            n = 3;
        } else if (l == 4L) {
            n = 4;
            bl3 = true;
        } else if (l == 5L) {
            n = 5;
            bl3 = true;
        }
        int n5 = XWindow.getModifiers(xButtonEvent.get_state(), n, 0);
        if (!bl3) {
            serializable = new MouseEvent(this.getEventSource(), n2 == 4 ? 501 : 502, l3, n5, n3, n4, xButtonEvent.get_x_root(), xButtonEvent.get_y_root(), clickCount, bl, n);
            this.postEventToEventQueue((AWTEvent)serializable);
            if (bl2) {
                serializable = new MouseEvent(this.getEventSource(), 500, l3, n5, n3, n4, xButtonEvent.get_x_root(), xButtonEvent.get_y_root(), clickCount, false, n);
                this.postEventToEventQueue((AWTEvent)serializable);
            }
        } else if (xEvent.get_type() == 4) {
            serializable = new MouseWheelEvent(this.getEventSource(), 507, l3, n5, n3, n4, xButtonEvent.get_x_root(), xButtonEvent.get_y_root(), clickCount, false, 0, 3, n == 4 ? -1 : 1);
            this.postEventToEventQueue((AWTEvent)serializable);
        }
    }

    public void handleMotionNotify(XEvent xEvent) {
        Serializable serializable;
        XWindow xWindow;
        super.handleMotionNotify(xEvent);
        XMotionEvent xMotionEvent = xEvent.get_xmotion();
        if (this.isEventDisabled(xEvent)) {
            return;
        }
        int n = xMotionEvent.get_x();
        int n2 = xMotionEvent.get_y();
        XWindow xWindow2 = xWindow = lastWindowRef != null ? (XWindow)lastWindowRef.get() : null;
        if (xWindow != this || xMotionEvent.get_time() - lastTime >= (long)XToolkit.getMultiClickTime() || Math.abs(lastX - n) >= 4 || Math.abs(lastY - n2) >= 4) {
            clickCount = 0;
            lastWindowRef = null;
            lastTime = 0L;
            lastX = 0;
            lastY = 0;
        }
        long l = XToolkit.nowMillisUTC_offset(xMotionEvent.get_time());
        int n3 = XWindow.getModifiers(xMotionEvent.get_state(), 0, 0);
        boolean bl = false;
        boolean bl2 = (xMotionEvent.get_state() & 0x700) != 0;
        int n4 = bl2 ? 506 : 503;
        Component component = this.getEventSource();
        if (xMotionEvent.get_window() != this.window) {
            serializable = this.toLocal(xMotionEvent.get_x_root(), xMotionEvent.get_y_root());
            n = serializable.x;
            n2 = serializable.y;
        }
        if (bl2 && clickCount == 0 || !bl2) {
            serializable = new MouseEvent(component, n4, l, n3, n, n2, xMotionEvent.get_x_root(), xMotionEvent.get_y_root(), clickCount, bl, 0);
            this.postEventToEventQueue((AWTEvent)serializable);
        }
    }

    public native boolean x11inputMethodLookupString(long var1, long[] var3);

    native boolean haveCurrentX11InputMethodInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMouseAbove() {
        Object object = this.getStateLock();
        synchronized (object) {
            return this.mouseAboveMe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setMouseAbove(boolean bl) {
        Object object = this.getStateLock();
        synchronized (object) {
            this.mouseAboveMe = bl;
        }
    }

    protected void enterNotify(long l) {
        if (l == this.getWindow()) {
            this.setMouseAbove(true);
        }
    }

    protected void leaveNotify(long l) {
        if (l == this.getWindow()) {
            this.setMouseAbove(false);
        }
    }

    public void handleXCrossingEvent(XEvent xEvent) {
        Serializable serializable;
        Object object;
        super.handleXCrossingEvent(xEvent);
        XCrossingEvent xCrossingEvent = xEvent.get_xcrossing();
        if (eventLog.isLoggable(Level.FINEST)) {
            eventLog.finest(xCrossingEvent.toString());
        }
        if (xCrossingEvent.get_type() == 7) {
            this.enterNotify(xCrossingEvent.get_window());
        } else {
            this.leaveNotify(xCrossingEvent.get_window());
        }
        XWindowPeer xWindowPeer = this.getToplevelXWindow();
        if (xWindowPeer != null && !xWindowPeer.isModalBlocked() && xCrossingEvent.get_mode() != 0) {
            if (xCrossingEvent.get_type() == 7) {
                XAwtState.setComponentMouseEntered(this.getEventSource());
                XGlobalCursorManager.nativeUpdateCursor(this.getEventSource());
            } else {
                XAwtState.setComponentMouseEntered(null);
            }
            return;
        }
        long l = xCrossingEvent.get_subwindow();
        if (l != 0L && (object = XToolkit.windowToXWindow(l)) != null && object instanceof XWindow && !((XBaseWindow)object).isEventDisabled(xEvent)) {
            return;
        }
        object = XAwtState.getComponentMouseEntered();
        if (xWindowPeer != null) {
            if (!xWindowPeer.isModalBlocked()) {
                if (xCrossingEvent.get_type() == 7) {
                    XAwtState.setComponentMouseEntered(this.getEventSource());
                    XGlobalCursorManager.nativeUpdateCursor(this.getEventSource());
                } else {
                    XAwtState.setComponentMouseEntered(null);
                }
            } else {
                ((XComponentPeer)this.target.getPeer()).pSetCursor(Cursor.getPredefinedCursor(0));
            }
        }
        if (this.isEventDisabled(xEvent)) {
            return;
        }
        long l2 = XToolkit.nowMillisUTC_offset(xCrossingEvent.get_time());
        int n = XWindow.getModifiers(xCrossingEvent.get_state(), 0, 0);
        int n2 = 0;
        boolean bl = false;
        int n3 = xCrossingEvent.get_x();
        int n4 = xCrossingEvent.get_y();
        if (xCrossingEvent.get_window() != this.window) {
            serializable = this.toLocal(xCrossingEvent.get_x_root(), xCrossingEvent.get_y_root());
            n3 = serializable.x;
            n4 = serializable.y;
        }
        if (object != null) {
            serializable = new MouseEvent((Component)object, 505, l2, n, xCrossingEvent.get_x(), xCrossingEvent.get_y(), xCrossingEvent.get_x_root(), xCrossingEvent.get_y_root(), n2, bl, 0);
            this.postEventToEventQueue((AWTEvent)serializable);
            eventLog.finest("Clearing last window ref");
            lastWindowRef = null;
        }
        if (xCrossingEvent.get_type() == 7) {
            serializable = new MouseEvent(this.getEventSource(), 504, l2, n, xCrossingEvent.get_x(), xCrossingEvent.get_y(), xCrossingEvent.get_x_root(), xCrossingEvent.get_y_root(), n2, bl, 0);
            this.postEventToEventQueue((AWTEvent)serializable);
        }
    }

    public void doLayout(int n, int n2, int n3, int n4) {
    }

    public void handleConfigureNotifyEvent(XEvent xEvent) {
        Rectangle rectangle = this.getBounds();
        super.handleConfigureNotifyEvent(xEvent);
        insLog.log(Level.FINER, "Configure, {0}, event disabled: {1}", new Object[]{xEvent, this.isEventDisabled(xEvent)});
        if (this.isEventDisabled(xEvent)) {
            return;
        }
        long l = xEvent.get_xany().get_window();
        Rectangle rectangle2 = this.getBounds();
        if (!rectangle2.getSize().equals(rectangle.getSize())) {
            this.postEventToEventQueue(new ComponentEvent(this.getEventSource(), 101));
        }
        if (!rectangle2.getLocation().equals(rectangle.getLocation())) {
            this.postEventToEventQueue(new ComponentEvent(this.getEventSource(), 100));
        }
    }

    public void handleMapNotifyEvent(XEvent xEvent) {
        super.handleMapNotifyEvent(xEvent);
        log.log(Level.FINE, "Mapped {0}", new Object[]{this});
        if (this.isEventDisabled(xEvent)) {
            return;
        }
        ComponentEvent componentEvent = new ComponentEvent(this.getEventSource(), 102);
        this.postEventToEventQueue(componentEvent);
    }

    public void handleUnmapNotifyEvent(XEvent xEvent) {
        super.handleUnmapNotifyEvent(xEvent);
        if (this.isEventDisabled(xEvent)) {
            return;
        }
        ComponentEvent componentEvent = new ComponentEvent(this.target, 103);
        this.postEventToEventQueue(componentEvent);
    }

    private void dumpKeysymArray(XKeyEvent xKeyEvent) {
        keyEventLog.fine("  " + Long.toHexString(XlibWrapper.XKeycodeToKeysym(XToolkit.getDisplay(), xKeyEvent.get_keycode(), 0)) + "\n        " + Long.toHexString(XlibWrapper.XKeycodeToKeysym(XToolkit.getDisplay(), xKeyEvent.get_keycode(), 1)) + "\n        " + Long.toHexString(XlibWrapper.XKeycodeToKeysym(XToolkit.getDisplay(), xKeyEvent.get_keycode(), 2)) + "\n        " + Long.toHexString(XlibWrapper.XKeycodeToKeysym(XToolkit.getDisplay(), xKeyEvent.get_keycode(), 3)));
    }

    int keysymToUnicode(long l, int n) {
        return XKeysym.convertKeysym(l, n);
    }

    int keyEventType2Id(int n) {
        return n == 2 ? 401 : (n == 3 ? 402 : 0);
    }

    private static char getCharForKeycode(int n) {
        Character c = jkeycode2UCSHash.get(n);
        return c == null ? (char)'\u0000' : c.charValue();
    }

    private static void putCharForKeycode(int n, char c) {
        jkeycode2UCSHash.put(n, Character.valueOf(c));
    }

    private static long xkeycodeToKeysym(XKeyEvent xKeyEvent) {
        return XKeysym.getKeysym(xKeyEvent);
    }

    private static long xkeycodeToPrimaryKeysym(XKeyEvent xKeyEvent) {
        return XlibWrapper.XKeycodeToKeysym(XToolkit.getDisplay(), xKeyEvent.get_keycode(), 0);
    }

    void logIncomingKeyEvent(XKeyEvent xKeyEvent) {
        keyEventLog.fine("--XWindow.java:handleKeyEvent:" + xKeyEvent);
        this.dumpKeysymArray(xKeyEvent);
        keyEventLog.fine("XXXXXXXXXXXXXX javakeycode will be most probably:0x" + Integer.toHexString(XKeysym.getJavaKeycodeOnly(xKeyEvent)));
    }

    public void handleKeyPress(XEvent xEvent) {
        super.handleKeyPress(xEvent);
        XKeyEvent xKeyEvent = xEvent.get_xkey();
        if (eventLog.isLoggable(Level.FINE)) {
            eventLog.fine(xKeyEvent.toString());
        }
        if (this.isEventDisabled(xEvent)) {
            return;
        }
        this.handleKeyPress(xKeyEvent);
    }

    void handleKeyPress(XKeyEvent xKeyEvent) {
        XKeysym.Keysym2JavaKeycode keysym2JavaKeycode;
        boolean bl = false;
        long[] lArray = new long[2];
        int n = 0;
        lArray[0] = 0L;
        if (keyEventLog.isLoggable(Level.FINE)) {
            this.logIncomingKeyEvent(xKeyEvent);
        }
        if (this.haveCurrentX11InputMethodInstance()) {
            if (this.x11inputMethodLookupString(xKeyEvent.pData, lArray)) {
                if (keyEventLog.isLoggable(Level.FINE)) {
                    keyEventLog.fine("--XWindow.java XIM did process event; return; dec keysym processed:" + lArray[0] + "; hex keysym processed:" + Long.toHexString(lArray[0]));
                }
                return;
            }
            n = this.keysymToUnicode(lArray[0], xKeyEvent.get_state());
            if (keyEventLog.isLoggable(Level.FINE)) {
                keyEventLog.fine("--XWindow.java XIM did NOT process event, hex keysym:" + Long.toHexString(lArray[0]) + "\n" + "                                         unicode key:" + Integer.toHexString(n));
            }
        } else {
            lArray[0] = XWindow.xkeycodeToKeysym(xKeyEvent);
            if (lArray[0] < 256L) {
                lArray[0] = XlibWrapper.XLookupStringShort(xKeyEvent.pData);
            }
            n = this.keysymToUnicode(lArray[0], xKeyEvent.get_state());
            if (keyEventLog.isLoggable(Level.FINE)) {
                keyEventLog.fine("--XWindow.java XIM is absent;             hex keysym:" + Long.toHexString(lArray[0]) + "\n" + "                                         unicode key:" + Integer.toHexString(n));
            }
        }
        if ((keysym2JavaKeycode = XKeysym.getJavaKeycode(xKeyEvent)) == null) {
            keysym2JavaKeycode = new XKeysym.Keysym2JavaKeycode(0, 0);
        }
        int n2 = this.keysymToUnicode(XWindow.xkeycodeToPrimaryKeysym(xKeyEvent), 0);
        if (keyEventLog.isLoggable(Level.FINE)) {
            keyEventLog.fine(">>>Fire Event:" + (xKeyEvent.get_type() == 2 ? "KEY_PRESSED; " : "KEY_RELEASED; ") + "jkeycode:decimal=" + keysym2JavaKeycode.getJavaKeycode() + ", hex=0x" + Integer.toHexString(keysym2JavaKeycode.getJavaKeycode()) + "; ");
        }
        this.postKeyEvent(401, xKeyEvent.get_time(), keysym2JavaKeycode.getJavaKeycode(), n == 0 ? 65535 : n, keysym2JavaKeycode.getKeyLocation(), xKeyEvent.get_state(), xKeyEvent.getPData(), XKeyEvent.getSize(), xKeyEvent.get_keycode(), n2);
        if (n > 0) {
            keyEventLog.fine("fire _TYPED on " + n);
            this.postKeyEvent(400, xKeyEvent.get_time(), 0, n, 0, xKeyEvent.get_state(), xKeyEvent.getPData(), XKeyEvent.getSize(), 0L, n2);
        }
    }

    public void handleKeyRelease(XEvent xEvent) {
        super.handleKeyRelease(xEvent);
        XKeyEvent xKeyEvent = xEvent.get_xkey();
        if (eventLog.isLoggable(Level.FINE)) {
            eventLog.fine(xKeyEvent.toString());
        }
        if (this.isEventDisabled(xEvent)) {
            return;
        }
        this.handleKeyRelease(xKeyEvent);
    }

    final void handleKeyRelease(XKeyEvent xKeyEvent) {
        XKeysym.Keysym2JavaKeycode keysym2JavaKeycode;
        boolean bl = false;
        long[] lArray = new long[2];
        int n = 0;
        lArray[0] = 0L;
        if (keyEventLog.isLoggable(Level.FINE)) {
            this.logIncomingKeyEvent(xKeyEvent);
        }
        if ((keysym2JavaKeycode = XKeysym.getJavaKeycode(xKeyEvent)) == null) {
            keysym2JavaKeycode = new XKeysym.Keysym2JavaKeycode(0, 0);
        }
        if (keyEventLog.isLoggable(Level.FINE)) {
            keyEventLog.fine(">>>Fire Event:" + (xKeyEvent.get_type() == 2 ? "KEY_PRESSED; " : "KEY_RELEASED; ") + "jkeycode:decimal=" + keysym2JavaKeycode.getJavaKeycode() + ", hex=0x" + Integer.toHexString(keysym2JavaKeycode.getJavaKeycode()) + "; ");
        }
        n = this.keysymToUnicode(XWindow.xkeycodeToKeysym(xKeyEvent), xKeyEvent.get_state());
        int n2 = this.keysymToUnicode(XWindow.xkeycodeToPrimaryKeysym(xKeyEvent), 0);
        this.postKeyEvent(402, xKeyEvent.get_time(), keysym2JavaKeycode.getJavaKeycode(), n == 0 ? 65535 : n, keysym2JavaKeycode.getKeyLocation(), xKeyEvent.get_state(), xKeyEvent.getPData(), XKeyEvent.getSize(), xKeyEvent.get_keycode(), n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getWMState() {
        if (this.stateChanged) {
            this.stateChanged = false;
            WindowPropertyGetter windowPropertyGetter = new WindowPropertyGetter(this.window, XWM.XA_WM_STATE, 0L, 1L, false, XWM.XA_WM_STATE);
            try {
                int n = windowPropertyGetter.execute();
                if (n != 0 || windowPropertyGetter.getData() == 0L) {
                    this.savedState = 0;
                    int n2 = 0;
                    return n2;
                }
                if (windowPropertyGetter.getActualType() != XWM.XA_WM_STATE.getAtom() && windowPropertyGetter.getActualFormat() != 32) {
                    this.savedState = 0;
                    int n3 = 0;
                    return n3;
                }
                this.savedState = (int)Native.getCard32(windowPropertyGetter.getData());
            }
            finally {
                windowPropertyGetter.dispose();
            }
        }
        return this.savedState;
    }

    protected void stateChanged(long l, int n, int n2) {
    }

    public void handlePropertyNotify(XEvent xEvent) {
        super.handlePropertyNotify(xEvent);
        XPropertyEvent xPropertyEvent = xEvent.get_xproperty();
        if (xPropertyEvent.get_atom() == XWM.XA_WM_STATE.getAtom()) {
            this.stateChanged = true;
            this.stateChanged(xPropertyEvent.get_time(), this.savedState, this.getWMState());
        }
    }

    public void reshape(Rectangle rectangle) {
        this.reshape(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void reshape(int n, int n2, int n3, int n4) {
        if (n3 <= 0) {
            n3 = 1;
        }
        if (n4 <= 0) {
            n4 = 1;
        }
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        this.xSetBounds(n, n2, n3, n4);
        this.validateSurface();
        this.layout();
    }

    public void layout() {
    }

    boolean isShowing() {
        return this.visible;
    }

    boolean isResizable() {
        return true;
    }

    boolean isLocationByPlatform() {
        return false;
    }

    void updateSizeHints() {
        this.updateSizeHints(this.x, this.y, this.width, this.height);
    }

    void updateSizeHints(int n, int n2, int n3, int n4) {
        long l = 8L | (this.isLocationByPlatform() ? 0L : 5L);
        if (!this.isResizable()) {
            log.log(Level.FINER, "Window {0} is not resizable", new Object[]{this});
            l |= 0x30L;
        } else {
            log.log(Level.FINER, "Window {0} is resizable", new Object[]{this});
        }
        this.setSizeHints(l, n, n2, n3, n4);
    }

    void updateSizeHints(int n, int n2) {
        long l;
        long l2 = l = this.isLocationByPlatform() ? 0L : 5L;
        if (!this.isResizable()) {
            log.log(Level.FINER, "Window {0} is not resizable", new Object[]{this});
            l |= 0x38L;
        } else {
            log.log(Level.FINER, "Window {0} is resizable", new Object[]{this});
        }
        this.setSizeHints(l, n, n2, this.width, this.height);
    }

    void validateSurface() {
        if (this.width != this.oldWidth || this.height != this.oldHeight) {
            SurfaceData surfaceData = this.surfaceData;
            if (surfaceData != null) {
                this.surfaceData = this.graphicsConfig.createSurfaceData(this);
                surfaceData.invalidate();
            }
            this.oldWidth = this.width;
            this.oldHeight = this.height;
        }
    }

    public SurfaceData getSurfaceData() {
        return this.surfaceData;
    }

    public void dispose() {
        SurfaceData surfaceData = this.surfaceData;
        this.surfaceData = null;
        if (surfaceData != null) {
            surfaceData.invalidate();
        }
        XToolkit.targetDisposedPeer(this.target, this);
        this.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Point getLocationOnScreen() {
        Object object = this.target.getTreeLock();
        synchronized (object) {
            Component component = this.target;
            while (component != null && !(component instanceof Window)) {
                component = ComponentAccessor.getParent_NoClientCode(component);
            }
            if (component == null || component instanceof EmbeddedFrame) {
                return this.toGlobal(0, 0);
            }
            XToolkit.awtLock();
            try {
                Object object2 = XToolkit.targetToPeer(component);
                if (object2 == null || !(object2 instanceof XDecoratedPeer) || ((XDecoratedPeer)object2).configure_seen) {
                    Point point = this.toGlobal(0, 0);
                    return point;
                }
                Point point = XWindow.toOtherWindow(this.getContentWindow(), ((XDecoratedPeer)object2).getContentWindow(), 0, 0);
                if (point == null) {
                    point = new Point(((XBaseWindow)object2).getAbsoluteX(), ((XBaseWindow)object2).getAbsoluteY());
                }
                point.x += component.getX();
                point.y += component.getY();
                Point point2 = point;
                return point2;
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
    }

    static void setBData(KeyEvent keyEvent, byte[] byArray) {
        block3: {
            try {
                if (bdata == null) {
                    bdata = XToolkit.getField(AWTEvent.class, "bdata");
                }
                bdata.set(keyEvent, byArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    public void postKeyEvent(int n, long l, int n2, int n3, int n4, int n5, long l2, int n6, long l3, int n7) {
        KeyEvent keyEvent;
        block7: {
            long l4 = XToolkit.nowMillisUTC_offset(l);
            int n8 = XWindow.getModifiers(n5, 0, n2);
            if (rawCodeField == null) {
                rawCodeField = XToolkit.getField(KeyEvent.class, "rawCode");
            }
            if (primaryLevelUnicodeField == null) {
                primaryLevelUnicodeField = XToolkit.getField(KeyEvent.class, "primaryLevelUnicode");
            }
            keyEvent = new KeyEvent(this.getEventSource(), n, l4, n8, n2, (char)n3, n4);
            if (l2 != 0L) {
                byte[] byArray = Native.toBytes(l2, n6);
                XWindow.setBData(keyEvent, byArray);
            }
            try {
                rawCodeField.set(keyEvent, l3);
                primaryLevelUnicodeField.set(keyEvent, n7);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                assert (false);
            }
            catch (IllegalAccessException illegalAccessException) {
                if ($assertionsDisabled) break block7;
                throw new AssertionError();
            }
        }
        this.postEventToEventQueue(keyEvent);
    }

    static native int getAWTKeyCodeForKeySym(int var0);

    static native int getKeySymForAWTKeyCode(int var0);

    public PropMwmHints getMWMHints() {
        if (this.mwm_hints == null) {
            this.mwm_hints = new PropMwmHints();
            if (!XWM.XA_MWM_HINTS.getAtomData(this.getWindow(), this.mwm_hints.pData, 5)) {
                this.mwm_hints.zero();
            }
        }
        return this.mwm_hints;
    }

    public void setMWMHints(PropMwmHints propMwmHints) {
        this.mwm_hints = propMwmHints;
        if (propMwmHints != null) {
            XWM.XA_MWM_HINTS.setAtomData(this.getWindow(), this.mwm_hints.pData, 5);
        }
    }

    protected final void initWMProtocols() {
        wm_protocols.setAtomListProperty((XBaseWindow)this, this.getWMProtocols());
    }

    protected XAtomList getWMProtocols() {
        return new XAtomList();
    }

    static {
        XWindow.initIDs();
        jkeycode2UCSHash = new Hashtable();
    }
}

