/*
 * Decompiled with CFR 0.152.
 */
package javax.print;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import javax.print.DocFlavor;
import javax.print.MultiDocPrintService;
import javax.print.PrintService;
import javax.print.StreamPrintService;
import javax.print.attribute.AttributeSet;
import sun.awt.AppContext;
import sun.misc.Service;

public abstract class PrintServiceLookup {
    private static Services getServicesForContext() {
        Services services = (Services)AppContext.getAppContext().get(Services.class);
        if (services == null) {
            services = new Services();
            AppContext.getAppContext().put(Services.class, services);
        }
        return services;
    }

    private static ArrayList getListOfLookupServices() {
        return PrintServiceLookup.getServicesForContext().listOfLookupServices;
    }

    private static ArrayList initListOfLookupServices() {
        ArrayList arrayList = new ArrayList();
        PrintServiceLookup.getServicesForContext().listOfLookupServices = arrayList;
        return arrayList;
    }

    private static ArrayList getRegisteredServices() {
        return PrintServiceLookup.getServicesForContext().registeredServices;
    }

    private static ArrayList initRegisteredServices() {
        ArrayList arrayList = new ArrayList();
        PrintServiceLookup.getServicesForContext().registeredServices = arrayList;
        return arrayList;
    }

    public static final PrintService[] lookupPrintServices(DocFlavor docFlavor, AttributeSet attributeSet) {
        ArrayList arrayList = PrintServiceLookup.getServices(docFlavor, attributeSet);
        return arrayList.toArray(new PrintService[arrayList.size()]);
    }

    public static final MultiDocPrintService[] lookupMultiDocPrintServices(DocFlavor[] docFlavorArray, AttributeSet attributeSet) {
        ArrayList arrayList = PrintServiceLookup.getMultiDocServices(docFlavorArray, attributeSet);
        return arrayList.toArray(new MultiDocPrintService[arrayList.size()]);
    }

    public static final PrintService lookupDefaultPrintService() {
        Iterator iterator = PrintServiceLookup.getAllLookupServices().iterator();
        while (iterator.hasNext()) {
            try {
                PrintServiceLookup printServiceLookup = (PrintServiceLookup)iterator.next();
                PrintService printService = printServiceLookup.getDefaultPrintService();
                if (printService == null) continue;
                return printService;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean registerServiceProvider(PrintServiceLookup printServiceLookup) {
        Class<PrintServiceLookup> clazz = PrintServiceLookup.class;
        synchronized (PrintServiceLookup.class) {
            Iterator iterator = PrintServiceLookup.getAllLookupServices().iterator();
            while (iterator.hasNext()) {
                try {
                    Object e = iterator.next();
                    if (e.getClass() != printServiceLookup.getClass()) continue;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return false;
                }
                catch (Exception exception) {
                }
            }
            PrintServiceLookup.getListOfLookupServices().add(printServiceLookup);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean registerService(PrintService printService) {
        Class<PrintServiceLookup> clazz = PrintServiceLookup.class;
        synchronized (PrintServiceLookup.class) {
            if (printService instanceof StreamPrintService) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return false;
            }
            ArrayList arrayList = PrintServiceLookup.getRegisteredServices();
            if (arrayList == null) {
                arrayList = PrintServiceLookup.initRegisteredServices();
            } else if (arrayList.contains(printService)) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return false;
            }
            arrayList.add(printService);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return true;
        }
    }

    public abstract PrintService[] getPrintServices(DocFlavor var1, AttributeSet var2);

    public abstract PrintService[] getPrintServices();

    public abstract MultiDocPrintService[] getMultiDocPrintServices(DocFlavor[] var1, AttributeSet var2);

    public abstract PrintService getDefaultPrintService();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList getAllLookupServices() {
        Class<PrintServiceLookup> clazz = PrintServiceLookup.class;
        synchronized (PrintServiceLookup.class) {
            ArrayList arrayList = PrintServiceLookup.getListOfLookupServices();
            if (arrayList != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return arrayList;
            }
            arrayList = PrintServiceLookup.initListOfLookupServices();
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() {
                        Iterator iterator = Service.providers(PrintServiceLookup.class);
                        ArrayList arrayList = PrintServiceLookup.getListOfLookupServices();
                        while (iterator.hasNext()) {
                            try {
                                PrintServiceLookup printServiceLookup = (PrintServiceLookup)iterator.next();
                                arrayList.add(printServiceLookup);
                            }
                            catch (Exception exception) {}
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                // empty catch block
            }
            return arrayList;
        }
    }

    private static ArrayList getServices(DocFlavor docFlavor, AttributeSet attributeSet) {
        PrintService[] printServiceArray;
        Object object;
        ArrayList<PrintService> arrayList = new ArrayList<PrintService>();
        Iterator iterator = PrintServiceLookup.getAllLookupServices().iterator();
        while (iterator.hasNext()) {
            try {
                object = (PrintServiceLookup)iterator.next();
                printServiceArray = null;
                if (docFlavor == null && attributeSet == null) {
                    try {
                        printServiceArray = ((PrintServiceLookup)object).getPrintServices();
                    }
                    catch (Throwable throwable) {}
                } else {
                    printServiceArray = ((PrintServiceLookup)object).getPrintServices(docFlavor, attributeSet);
                }
                if (printServiceArray == null) continue;
                for (int i = 0; i < printServiceArray.length; ++i) {
                    arrayList.add(printServiceArray[i]);
                }
            }
            catch (Exception exception) {
            }
        }
        object = null;
        try {
            printServiceArray = System.getSecurityManager();
            if (printServiceArray != null) {
                printServiceArray.checkPrintJobAccess();
            }
            object = PrintServiceLookup.getRegisteredServices();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (object != null) {
            printServiceArray = ((ArrayList)object).toArray(new PrintService[((ArrayList)object).size()]);
            for (int i = 0; i < printServiceArray.length; ++i) {
                if (arrayList.contains(printServiceArray[i])) continue;
                if (docFlavor == null && attributeSet == null) {
                    arrayList.add(printServiceArray[i]);
                    continue;
                }
                if ((docFlavor == null || !printServiceArray[i].isDocFlavorSupported(docFlavor)) && docFlavor != null || null != printServiceArray[i].getUnsupportedAttributes(docFlavor, attributeSet)) continue;
                arrayList.add(printServiceArray[i]);
            }
        }
        return arrayList;
    }

    private static ArrayList getMultiDocServices(DocFlavor[] docFlavorArray, AttributeSet attributeSet) {
        int n;
        PrintService[] printServiceArray;
        Object object;
        ArrayList<PrintService> arrayList = new ArrayList<PrintService>();
        Iterator iterator = PrintServiceLookup.getAllLookupServices().iterator();
        while (iterator.hasNext()) {
            try {
                object = (PrintServiceLookup)iterator.next();
                printServiceArray = ((PrintServiceLookup)object).getMultiDocPrintServices(docFlavorArray, attributeSet);
                if (printServiceArray == null) continue;
                for (n = 0; n < printServiceArray.length; ++n) {
                    arrayList.add(printServiceArray[n]);
                }
            }
            catch (Exception exception) {
            }
        }
        object = null;
        try {
            printServiceArray = System.getSecurityManager();
            if (printServiceArray != null) {
                printServiceArray.checkPrintJobAccess();
            }
            object = PrintServiceLookup.getRegisteredServices();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (object != null) {
            printServiceArray = ((ArrayList)object).toArray(new PrintService[((ArrayList)object).size()]);
            for (n = 0; n < printServiceArray.length; ++n) {
                if (!(printServiceArray[n] instanceof MultiDocPrintService) || arrayList.contains(printServiceArray[n])) continue;
                if (docFlavorArray == null || docFlavorArray.length == 0) {
                    arrayList.add(printServiceArray[n]);
                    continue;
                }
                boolean bl = true;
                for (int i = 0; i < docFlavorArray.length; ++i) {
                    if (printServiceArray[n].isDocFlavorSupported(docFlavorArray[i])) {
                        if (printServiceArray[n].getUnsupportedAttributes(docFlavorArray[i], attributeSet) == null) continue;
                        bl = false;
                        break;
                    }
                    bl = false;
                    break;
                }
                if (!bl) continue;
                arrayList.add(printServiceArray[n]);
            }
        }
        return arrayList;
    }

    static class Services {
        private ArrayList listOfLookupServices = null;
        private ArrayList registeredServices = null;

        Services() {
        }
    }
}

