/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import gnu.javax.swing.tree.GnuPath;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Set;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.VariableHeightLayoutCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedHeightLayoutCache
extends VariableHeightLayoutCache {
    Set expanded = new HashSet();
    Hashtable nodes = new Hashtable();
    Hashtable row2node = new Hashtable();
    boolean dirty;
    int totalHeight;
    int maximalWidth;

    @Override
    public int getRowCount() {
        if (this.dirty) {
            this.update();
        }
        return this.row2node.size();
    }

    private final void update() {
        this.nodes.clear();
        this.row2node.clear();
        this.maximalWidth = 0;
        this.totalHeight = 0;
        Object root = this.treeModel.getRoot();
        if (this.rootVisible) {
            this.countRows(root, null, 0);
        } else {
            int sc = this.treeModel.getChildCount(root);
            int i = 0;
            while (i < sc) {
                Object child = this.treeModel.getChild(root, i);
                this.countRows(child, root, 0);
                ++i;
            }
        }
        this.dirty = false;
    }

    private final void countRows(Object node2, Object parent, int depth) {
        Integer n = new Integer(this.row2node.size());
        this.row2node.put(n, node2);
        NodeRecord nr = new NodeRecord(n, depth, node2, parent);
        this.nodes.put(node2, nr);
        if (this.expanded.contains(node2)) {
            int sc = this.treeModel.getChildCount(node2);
            int deeper = depth + 1;
            int i = 0;
            while (i < sc) {
                Object child = this.treeModel.getChild(node2, i);
                this.countRows(child, node2, deeper);
                ++i;
            }
        }
    }

    @Override
    public void invalidatePathBounds(TreePath path) {
        NodeRecord r = (NodeRecord)this.nodes.get(path.getLastPathComponent());
        if (r != null) {
            r.bounds = null;
        }
    }

    @Override
    public void invalidateSizes() {
        this.dirty = true;
    }

    @Override
    public void setExpandedState(TreePath path, boolean isExpanded) {
        if (isExpanded) {
            this.expanded.add(path.getLastPathComponent());
        } else {
            this.expanded.remove(path.getLastPathComponent());
        }
        this.dirty = true;
    }

    @Override
    public boolean isExpanded(TreePath path) {
        return this.expanded.contains(path.getLastPathComponent());
    }

    @Override
    public Rectangle getBounds(TreePath path, Rectangle rect) {
        Object last;
        NodeRecord r;
        if (path == null) {
            return null;
        }
        if (this.dirty) {
            this.update();
        }
        if ((r = (NodeRecord)this.nodes.get(last = path.getLastPathComponent())) == null) {
            rect.height = 0;
            rect.width = 0;
            rect.y = 0;
            rect.x = 0;
        } else {
            if (r.bounds == null) {
                Rectangle dim;
                r.bounds = dim = this.getNodeDimensions(last, r.row, r.depth, r.isExpanded, rect);
            }
            rect.setRect(r.bounds);
        }
        return rect;
    }

    @Override
    public TreePath getPathForRow(int row) {
        Object last;
        if (this.dirty) {
            this.update();
        }
        if ((last = this.row2node.get(new Integer(row))) == null) {
            return null;
        }
        NodeRecord r = (NodeRecord)this.nodes.get(last);
        return r.getPath();
    }

    @Override
    public int getRowForPath(TreePath path) {
        NodeRecord r;
        if (path == null) {
            return -1;
        }
        if (this.dirty) {
            this.update();
        }
        if ((r = (NodeRecord)this.nodes.get(path.getLastPathComponent())) == null) {
            return -1;
        }
        return r.row;
    }

    @Override
    public TreePath getPathClosestTo(int x, int y) {
        if (this.dirty) {
            this.update();
        }
        NodeRecord best = null;
        Enumeration en = this.nodes.elements();
        int dist = Integer.MAX_VALUE;
        while (en.hasMoreElements() && dist > 0) {
            NodeRecord r = (NodeRecord)en.nextElement();
            if (best == null) {
                best = r;
                dist = this.distance(r.getBounds(), x, y);
                continue;
            }
            int rr = this.distance(r.getBounds(), x, y);
            if (rr >= dist) continue;
            best = r;
            dist = rr;
        }
        if (best == null) {
            return null;
        }
        return best.getPath();
    }

    @Override
    int distance(Rectangle r, int x, int y) {
        if (y < r.y) {
            return r.y - y;
        }
        if (y > r.y + r.height) {
            return y - (r.y + r.height);
        }
        return 0;
    }

    @Override
    public int getVisibleChildCount(TreePath path) {
        if (this.isExpanded(path)) {
            return 0;
        }
        return this.treeModel.getChildCount(path.getLastPathComponent());
    }

    @Override
    public Enumeration<TreePath> getVisiblePathsFrom(TreePath parentPath) {
        if (this.dirty) {
            this.update();
        }
        Vector<Object> p = new Vector<Object>(parentPath.getPathCount());
        int i = 0;
        while (i < parentPath.getPathCount()) {
            Object node2 = parentPath.getPathComponent(i);
            NodeRecord nr = (NodeRecord)this.nodes.get(node2);
            if (nr.row >= 0) {
                p.add(node2);
            }
            ++i;
        }
        return p.elements();
    }

    @Override
    public boolean getExpandedState(TreePath path) {
        return this.expanded.contains(path.getLastPathComponent());
    }

    @Override
    public void treeNodesChanged(TreeModelEvent event) {
        this.dirty = true;
    }

    @Override
    public void treeNodesInserted(TreeModelEvent event) {
        this.dirty = true;
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent event) {
        this.dirty = true;
    }

    @Override
    public void treeStructureChanged(TreeModelEvent event) {
        this.dirty = true;
    }

    @Override
    public void setModel(TreeModel newModel) {
        this.treeModel = newModel;
        this.expanded.add(this.treeModel.getRoot());
        this.dirty = true;
    }

    @Override
    public void setRootVisible(boolean visible) {
        this.rootVisible = visible;
        this.dirty = true;
    }

    @Override
    public int getPreferredHeight() {
        if (this.dirty) {
            this.update();
        }
        this.totalHeight = 0;
        Enumeration en = this.nodes.elements();
        while (en.hasMoreElements()) {
            NodeRecord nr = (NodeRecord)en.nextElement();
            Rectangle r = nr.getBounds();
            this.totalHeight += r.height;
        }
        return this.totalHeight;
    }

    @Override
    public int getPreferredWidth(Rectangle value) {
        if (this.dirty) {
            this.update();
        }
        this.maximalWidth = 0;
        Enumeration en = this.nodes.elements();
        while (en.hasMoreElements()) {
            NodeRecord nr = (NodeRecord)en.nextElement();
            Rectangle r = nr.getBounds();
            if (r.x + r.width <= this.maximalWidth) continue;
            this.maximalWidth = r.x + r.width;
        }
        return this.maximalWidth;
    }

    @Override
    protected boolean isFixedRowHeight() {
        return true;
    }

    class NodeRecord {
        final int row;
        final int depth;
        final Object parent;
        final Object node;
        final boolean isExpanded;
        Rectangle bounds;
        private TreePath path;

        NodeRecord(int aRow, int aDepth, Object aNode, Object aParent) {
            this.row = aRow;
            this.depth = aDepth;
            this.parent = aParent;
            this.node = aNode;
            this.isExpanded = FixedHeightLayoutCache.this.expanded.contains(aNode);
        }

        TreePath getPath() {
            if (this.path == null) {
                int n;
                int nc;
                boolean lastChild = false;
                if (this.parent != null && (nc = FixedHeightLayoutCache.this.treeModel.getChildCount(this.parent)) > 0 && (n = FixedHeightLayoutCache.this.treeModel.getIndexOfChild(this.parent, this.node)) == nc - 1) {
                    lastChild = true;
                }
                LinkedList<Object> lpath = new LinkedList<Object>();
                NodeRecord rp = this;
                while (rp != null) {
                    lpath.addFirst(rp.node);
                    if (rp.parent != null) {
                        Object parent = rp.parent;
                        rp = (NodeRecord)FixedHeightLayoutCache.this.nodes.get(parent);
                        if (rp != null) continue;
                        lpath.addFirst(parent);
                        continue;
                    }
                    rp = null;
                }
                this.path = new GnuPath(lpath.toArray(), lastChild);
            }
            return this.path;
        }

        Rectangle getBounds() {
            if (this.bounds == null) {
                this.bounds = FixedHeightLayoutCache.this.getNodeDimensions(this.node, this.row, this.depth, this.isExpanded, new Rectangle());
            }
            return this.bounds;
        }
    }
}

