/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import gnu.classpath.ServiceFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiFileFormat;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Transmitter;
import javax.sound.midi.spi.MidiDeviceProvider;
import javax.sound.midi.spi.MidiFileReader;
import javax.sound.midi.spi.MidiFileWriter;
import javax.sound.midi.spi.SoundbankReader;

public class MidiSystem {
    private MidiSystem() {
    }

    public static MidiDevice.Info[] getMidiDeviceInfo() {
        Iterator deviceProviders = ServiceFactory.lookupProviders(MidiDeviceProvider.class);
        ArrayList<MidiDevice.Info> infoList = new ArrayList<MidiDevice.Info>();
        while (deviceProviders.hasNext()) {
            MidiDeviceProvider provider = (MidiDeviceProvider)deviceProviders.next();
            MidiDevice.Info[] infos = provider.getDeviceInfo();
            int i = infos.length;
            while (i > 0) {
                infoList.add(infos[--i]);
            }
        }
        return infoList.toArray(new MidiDevice.Info[infoList.size()]);
    }

    public static MidiDevice getMidiDevice(MidiDevice.Info info) throws MidiUnavailableException {
        Iterator deviceProviders = ServiceFactory.lookupProviders(MidiDeviceProvider.class);
        if (!deviceProviders.hasNext()) {
            throw new MidiUnavailableException("No MIDI device providers available.");
        }
        do {
            MidiDeviceProvider provider;
            if (!(provider = (MidiDeviceProvider)deviceProviders.next()).isDeviceSupported(info)) continue;
            return provider.getDevice(info);
        } while (deviceProviders.hasNext());
        throw new IllegalArgumentException("MIDI device " + info + " not available.");
    }

    public static Receiver getReceiver() throws MidiUnavailableException {
        MidiDevice.Info[] infos = MidiSystem.getMidiDeviceInfo();
        int i = 0;
        while (i < infos.length) {
            MidiDevice device = MidiSystem.getMidiDevice(infos[i]);
            if (device instanceof Receiver) {
                return (Receiver)((Object)device);
            }
            ++i;
        }
        throw new MidiUnavailableException("No Receiver device available");
    }

    public static Transmitter getTransmitter() throws MidiUnavailableException {
        MidiDevice.Info[] infos = MidiSystem.getMidiDeviceInfo();
        int i = 0;
        while (i < infos.length) {
            MidiDevice device = MidiSystem.getMidiDevice(infos[i]);
            if (device instanceof Transmitter) {
                return (Transmitter)((Object)device);
            }
            ++i;
        }
        throw new MidiUnavailableException("No Transmitter device available");
    }

    public static Synthesizer getSynthesizer() throws MidiUnavailableException {
        MidiDevice.Info[] infos = MidiSystem.getMidiDeviceInfo();
        int i = 0;
        while (i < infos.length) {
            MidiDevice device = MidiSystem.getMidiDevice(infos[i]);
            if (device instanceof Synthesizer) {
                return (Synthesizer)device;
            }
            ++i;
        }
        throw new MidiUnavailableException("No Synthesizer device available");
    }

    public static Sequencer getSequencer() throws MidiUnavailableException {
        MidiDevice.Info[] infos = MidiSystem.getMidiDeviceInfo();
        int i = 0;
        while (i < infos.length) {
            MidiDevice device = MidiSystem.getMidiDevice(infos[i]);
            if (device instanceof Sequencer) {
                return (Sequencer)device;
            }
            ++i;
        }
        throw new MidiUnavailableException("No Sequencer device available");
    }

    public static Soundbank getSoundbank(InputStream stream) throws InvalidMidiDataException, IOException {
        Iterator readers = ServiceFactory.lookupProviders(SoundbankReader.class);
        while (readers.hasNext()) {
            SoundbankReader sr = (SoundbankReader)readers.next();
            Soundbank sb = sr.getSoundbank(stream);
            if (sb == null) continue;
            return sb;
        }
        throw new InvalidMidiDataException("Cannot read soundbank from stream");
    }

    public static Soundbank getSoundbank(URL url) throws InvalidMidiDataException, IOException {
        Iterator readers = ServiceFactory.lookupProviders(SoundbankReader.class);
        while (readers.hasNext()) {
            SoundbankReader sr = (SoundbankReader)readers.next();
            Soundbank sb = sr.getSoundbank(url);
            if (sb == null) continue;
            return sb;
        }
        throw new InvalidMidiDataException("Cannot read from url " + url);
    }

    public static Soundbank getSoundbank(File file) throws InvalidMidiDataException, IOException {
        Iterator readers = ServiceFactory.lookupProviders(SoundbankReader.class);
        while (readers.hasNext()) {
            SoundbankReader sr = (SoundbankReader)readers.next();
            Soundbank sb = sr.getSoundbank(file);
            if (sb == null) continue;
            return sb;
        }
        throw new InvalidMidiDataException("Cannot read soundbank from file " + file);
    }

    public static MidiFileFormat getMidiFileFormat(InputStream stream) throws InvalidMidiDataException, IOException {
        Iterator readers = ServiceFactory.lookupProviders(MidiFileReader.class);
        while (readers.hasNext()) {
            MidiFileReader sr = (MidiFileReader)readers.next();
            MidiFileFormat sb = sr.getMidiFileFormat(stream);
            if (sb == null) continue;
            return sb;
        }
        throw new InvalidMidiDataException("Can't read MidiFileFormat from stream");
    }

    public static MidiFileFormat getMidiFileFormat(URL url) throws InvalidMidiDataException, IOException {
        Iterator readers = ServiceFactory.lookupProviders(MidiFileReader.class);
        while (readers.hasNext()) {
            MidiFileReader sr = (MidiFileReader)readers.next();
            MidiFileFormat sb = sr.getMidiFileFormat(url);
            if (sb == null) continue;
            return sb;
        }
        throw new InvalidMidiDataException("Cannot read from url " + url);
    }

    public static MidiFileFormat getMidiFileFormat(File file) throws InvalidMidiDataException, IOException {
        Iterator readers = ServiceFactory.lookupProviders(MidiFileReader.class);
        while (readers.hasNext()) {
            MidiFileReader sr = (MidiFileReader)readers.next();
            MidiFileFormat sb = sr.getMidiFileFormat(file);
            if (sb == null) continue;
            return sb;
        }
        throw new InvalidMidiDataException("Can't read MidiFileFormat from file " + file);
    }

    public static Sequence getSequence(InputStream stream) throws InvalidMidiDataException, IOException {
        Iterator readers = ServiceFactory.lookupProviders(MidiFileReader.class);
        while (readers.hasNext()) {
            MidiFileReader sr = (MidiFileReader)readers.next();
            Sequence sq = sr.getSequence(stream);
            if (sq == null) continue;
            return sq;
        }
        throw new InvalidMidiDataException("Can't read Sequence from stream");
    }

    public static Sequence getSequence(URL url) throws InvalidMidiDataException, IOException {
        Iterator readers = ServiceFactory.lookupProviders(MidiFileReader.class);
        while (readers.hasNext()) {
            MidiFileReader sr = (MidiFileReader)readers.next();
            Sequence sq = sr.getSequence(url);
            if (sq == null) continue;
            return sq;
        }
        throw new InvalidMidiDataException("Cannot read from url " + url);
    }

    public static Sequence getSequence(File file) throws InvalidMidiDataException, IOException {
        Iterator readers = ServiceFactory.lookupProviders(MidiFileReader.class);
        while (readers.hasNext()) {
            MidiFileReader sr = (MidiFileReader)readers.next();
            Sequence sq = sr.getSequence(file);
            if (sq == null) continue;
            return sq;
        }
        throw new InvalidMidiDataException("Can't read Sequence from file " + file);
    }

    public static int[] getMidiFileTypes() {
        boolean[] supported = new boolean[3];
        int count = 0;
        Iterator writers = ServiceFactory.lookupProviders(MidiFileWriter.class);
        while (writers.hasNext()) {
            MidiFileWriter fw = (MidiFileWriter)writers.next();
            int[] types = fw.getMidiFileTypes();
            int i = types.length;
            while (i > 0) {
                int type;
                if (supported[type = types[--i]]) continue;
                ++count;
                supported[type] = true;
            }
        }
        int[] result = new int[count];
        int i = supported.length;
        while (i > 0) {
            if (!supported[--i]) continue;
            result[--count] = i;
        }
        return result;
    }

    public static boolean isFileTypeSupported(int fileType) {
        Iterator writers = ServiceFactory.lookupProviders(MidiFileWriter.class);
        while (writers.hasNext()) {
            MidiFileWriter fw = (MidiFileWriter)writers.next();
            if (!fw.isFileTypeSupported(fileType)) continue;
            return true;
        }
        return false;
    }

    public static int[] getMidiFileTypes(Sequence sequence) {
        boolean[] supported = new boolean[3];
        int count = 0;
        Iterator writers = ServiceFactory.lookupProviders(MidiFileWriter.class);
        while (writers.hasNext()) {
            MidiFileWriter fw = (MidiFileWriter)writers.next();
            int[] types = fw.getMidiFileTypes(sequence);
            int i = types.length;
            while (i > 0) {
                int type;
                if (supported[type = types[--i]]) continue;
                ++count;
                supported[type] = true;
            }
        }
        int[] result = new int[count];
        int i = supported.length;
        while (i > 0) {
            if (!supported[--i]) continue;
            result[--count] = i;
        }
        return result;
    }

    public static boolean isFileTypeSupported(int fileType, Sequence sequence) {
        Iterator writers = ServiceFactory.lookupProviders(MidiFileWriter.class);
        while (writers.hasNext()) {
            MidiFileWriter fw = (MidiFileWriter)writers.next();
            if (!fw.isFileTypeSupported(fileType, sequence)) continue;
            return true;
        }
        return false;
    }

    public static int write(Sequence in, int fileType, OutputStream out) throws IOException {
        Iterator writers = ServiceFactory.lookupProviders(MidiFileWriter.class);
        while (writers.hasNext()) {
            MidiFileWriter fw = (MidiFileWriter)writers.next();
            if (!fw.isFileTypeSupported(fileType, in)) continue;
            return fw.write(in, fileType, out);
        }
        throw new IllegalArgumentException("File type " + fileType + " is not supported");
    }

    public static int write(Sequence in, int fileType, File out) throws IOException {
        Iterator writers = ServiceFactory.lookupProviders(MidiFileWriter.class);
        while (writers.hasNext()) {
            MidiFileWriter fw = (MidiFileWriter)writers.next();
            if (!fw.isFileTypeSupported(fileType, in)) continue;
            return fw.write(in, fileType, out);
        }
        throw new IllegalArgumentException("File type " + fileType + " is not supported");
    }
}

