/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.CollationKey;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.text.spi.CollatorProvider;
import java.util.Comparator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.ServiceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Collator
implements Comparator<Object>,
Cloneable {
    public static final int PRIMARY = 0;
    public static final int SECONDARY = 1;
    public static final int TERTIARY = 2;
    public static final int IDENTICAL = 3;
    public static final int NO_DECOMPOSITION = 0;
    public static final int CANONICAL_DECOMPOSITION = 1;
    public static final int FULL_DECOMPOSITION = 2;
    int decmp = 1;
    int strength = 2;

    protected Collator() {
    }

    @Override
    public abstract int compare(String var1, String var2);

    @Override
    public int compare(Object o1, Object o2) {
        return this.compare((String)o1, (String)o2);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Collator)) {
            return false;
        }
        Collator c = (Collator)obj;
        return this.decmp == c.decmp && this.strength == c.strength;
    }

    public boolean equals(String source, String target) {
        return this.compare(source, target) == 0;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public static synchronized Locale[] getAvailableLocales() {
        Locale[] l = new Locale[]{Locale.US};
        return l;
    }

    public abstract CollationKey getCollationKey(String var1);

    public synchronized int getDecomposition() {
        return this.decmp;
    }

    public static Collator getInstance() {
        return Collator.getInstance(Locale.getDefault());
    }

    public static Collator getInstance(Locale loc) {
        try {
            ResourceBundle res = ResourceBundle.getBundle("gnu.java.locale.LocaleInformation", loc, ClassLoader.getSystemClassLoader());
            return new RuleBasedCollator(res.getString("collation_rules"));
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (ParseException x) {
            throw (InternalError)new InternalError().initCause(x);
        }
        block5: for (CollatorProvider p : ServiceLoader.load(CollatorProvider.class)) {
            Locale[] localeArray = p.getAvailableLocales();
            int n = localeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Locale l = localeArray[n2];
                if (l.equals(loc)) {
                    Collator c = p.getInstance(loc);
                    if (c == null) continue block5;
                    return c;
                }
                ++n2;
            }
        }
        if (loc.equals(Locale.ROOT)) {
            try {
                return new RuleBasedCollator("<0<1<2<3<4<5<6<7<8<9<A,a<b,B<c,C<d,D<e,E<f,F<g,G<h,H<i,I<j,J<k,K<l,L<m,M<n,N<o,O<p,P<q,Q<r,R<s,S<t,T<u,U<v,V<w,W<x,X<y,Y<z,Z");
            }
            catch (ParseException x) {
                throw (InternalError)new InternalError().initCause(x);
            }
        }
        return Collator.getInstance(Locale.US);
    }

    public synchronized int getStrength() {
        return this.strength;
    }

    public abstract int hashCode();

    public synchronized void setDecomposition(int mode) {
        if (mode != 0 && mode != 1 && mode != 2) {
            throw new IllegalArgumentException();
        }
        this.decmp = mode;
    }

    public synchronized void setStrength(int strength) {
        if (strength != 0 && strength != 1 && strength != 2 && strength != 3) {
            throw new IllegalArgumentException();
        }
        this.strength = strength;
    }

    final native void decomposeCharacter(char var1, StringBuffer var2);
}

