/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import gnu.java.security.Engine;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.DummyMessageDigest;
import java.security.MessageDigestSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;

public abstract class MessageDigest
extends MessageDigestSpi {
    private static final String MESSAGE_DIGEST = "MessageDigest";
    private String algorithm;
    Provider provider;
    private byte[] lastDigest;

    protected MessageDigest(String algorithm) {
        this.algorithm = algorithm;
        this.provider = null;
    }

    public static MessageDigest getInstance(String algorithm) throws NoSuchAlgorithmException {
        Provider[] p = Security.getProviders();
        NoSuchAlgorithmException lastException = null;
        int i = 0;
        while (i < p.length) {
            try {
                return MessageDigest.getInstance(algorithm, p[i]);
            }
            catch (NoSuchAlgorithmException x) {
                lastException = x;
                ++i;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        throw new NoSuchAlgorithmException(algorithm);
    }

    public static MessageDigest getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (provider == null) {
            throw new IllegalArgumentException("provider MUST NOT be null");
        }
        if ((provider = provider.trim()).length() == 0) {
            throw new IllegalArgumentException("provider MUST NOT be empty");
        }
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(provider);
        }
        return MessageDigest.getInstance(algorithm, p);
    }

    public static MessageDigest getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        MessageDigest result;
        Object o;
        StringBuilder sb = new StringBuilder("MessageDigest for algorithm [").append(algorithm).append("] from provider[").append(provider).append("] ");
        try {
            o = Engine.getInstance(MESSAGE_DIGEST, algorithm, provider);
        }
        catch (InvocationTargetException x) {
            Throwable cause = x.getCause();
            if (cause instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)cause;
            }
            if (cause == null) {
                cause = x;
            }
            sb.append("could not be created");
            NoSuchAlgorithmException y = new NoSuchAlgorithmException(sb.toString());
            y.initCause(cause);
            throw y;
        }
        if (o instanceof MessageDigestSpi) {
            result = new DummyMessageDigest((MessageDigestSpi)o, algorithm);
        } else if (o instanceof MessageDigest) {
            result = (MessageDigest)o;
            result.algorithm = algorithm;
        } else {
            sb.append("is of an unexpected Type: ").append(o.getClass().getName());
            throw new NoSuchAlgorithmException(sb.toString());
        }
        result.provider = provider;
        return result;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public void update(byte input) {
        this.engineUpdate(input);
    }

    public void update(byte[] input, int offset, int len) {
        this.engineUpdate(input, offset, len);
    }

    public void update(byte[] input) {
        this.engineUpdate(input, 0, input.length);
    }

    public void update(ByteBuffer input) {
        this.engineUpdate(input);
    }

    public byte[] digest() {
        this.lastDigest = this.engineDigest();
        return this.lastDigest;
    }

    public int digest(byte[] buf, int offset, int len) throws DigestException {
        return this.engineDigest(buf, offset, len);
    }

    public byte[] digest(byte[] input) {
        this.update(input);
        return this.digest();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " Message Digest <" + this.digestToString() + ">";
    }

    public static boolean isEqual(byte[] digesta, byte[] digestb) {
        if (digesta.length != digestb.length) {
            return false;
        }
        int i = digesta.length - 1;
        while (i >= 0) {
            if (digesta[i] != digestb[i]) {
                return false;
            }
            --i;
        }
        return true;
    }

    public void reset() {
        this.engineReset();
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final int getDigestLength() {
        return this.engineGetDigestLength();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private String digestToString() {
        byte[] digest = this.lastDigest;
        if (digest == null) {
            return "incomplete";
        }
        StringBuffer buf = new StringBuffer();
        int len = digest.length;
        int i = 0;
        while (i < len) {
            byte b = digest[i];
            byte high = (byte)((b & 0xFF) >>> 4);
            byte low = (byte)(b & 0xF);
            buf.append(high > 9 ? 87 + high : 48 + high);
            buf.append(low > 9 ? 87 + low : 48 + low);
            ++i;
        }
        return buf.toString();
    }
}

