/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.xpath;

import gnu.xml.xpath.Expr;
import gnu.xml.xpath.IdFunction;
import java.util.List;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class LangFunction
extends Expr {
    final Expr arg;

    LangFunction(List args) {
        this((Expr)args.get(0));
    }

    LangFunction(Expr arg) {
        this.arg = arg;
    }

    public Object evaluate(Node context, int pos, int len) {
        Object val = this.arg.evaluate(context, pos, len);
        String lang = LangFunction._string(context, val);
        String clang = this.getLang(context);
        while (clang == null && context != null) {
            context = context.getParentNode();
            clang = this.getLang(context);
        }
        boolean ret = clang == null ? false : clang.toLowerCase().startsWith(lang.toLowerCase());
        return ret ? Boolean.TRUE : Boolean.FALSE;
    }

    String getLang(Node node2) {
        while (node2 != null) {
            String lang;
            if (node2.getNodeType() == 1 && (lang = ((Element)node2).getAttribute("xml:lang")) != null) {
                return lang;
            }
            node2 = node2.getParentNode();
        }
        return null;
    }

    public Expr clone(Object context) {
        return new IdFunction(this.arg.clone(context));
    }

    public boolean references(QName var) {
        return this.arg.references(var);
    }

    public String toString() {
        return "lang(" + this.arg + ")";
    }
}

