/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.jce.prng;

import gnu.java.security.prng.LimitReachedException;
import gnu.javax.crypto.prng.UMacGenerator;
import java.security.SecureRandomSpi;
import java.util.HashMap;
import java.util.Random;
import java.util.logging.Logger;

public class UMacRandomSpi
extends SecureRandomSpi {
    private static final Logger log = Logger.getLogger(UMacRandomSpi.class.getName());
    private static final UMacGenerator prng = new UMacGenerator();
    private static final String MSG = "Exception while setting up a umac-kdf SPI: ";
    private static final String RETRY = "Retry...";
    private UMacGenerator adaptee = new UMacGenerator();

    static {
        UMacRandomSpi.resetLocalPRNG();
    }

    private static void resetLocalPRNG() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("gnu.crypto.prng.umac.cipher.name", "aes");
        byte[] key = new byte[16];
        Random rand = new Random(System.currentTimeMillis());
        rand.nextBytes(key);
        attributes.put("gnu.crypto.cipher.key.material", key);
        int index = rand.nextInt() & 0xFF;
        attributes.put("gnu.crypto.prng.umac.index", index);
        prng.setup(attributes);
    }

    public byte[] engineGenerateSeed(int numBytes) {
        if (numBytes < 1) {
            return new byte[0];
        }
        byte[] result = new byte[numBytes];
        this.engineNextBytes(result);
        return result;
    }

    public void engineNextBytes(byte[] bytes) {
        if (!this.adaptee.isInitialised()) {
            this.engineSetSeed(new byte[0]);
        }
        while (true) {
            try {
                this.adaptee.nextBytes(bytes, 0, bytes.length);
            }
            catch (LimitReachedException limitReachedException) {
                UMacRandomSpi.resetLocalPRNG();
                continue;
            }
            break;
        }
    }

    public void engineSetSeed(byte[] seed) {
        int materialLength = 0;
        materialLength += 16;
        byte[] material = new byte[++materialLength];
        int materialOffset = 0;
        int materialLeft = material.length;
        if (seed.length > 0) {
            int lenToCopy = Math.min(materialLength, seed.length);
            System.arraycopy(seed, 0, material, 0, lenToCopy);
            materialOffset += lenToCopy;
            materialLeft -= lenToCopy;
        }
        if (materialOffset > 0) {
            while (true) {
                try {
                    prng.nextBytes(material, materialOffset, materialLeft);
                }
                catch (IllegalStateException x) {
                    throw new InternalError(MSG + String.valueOf(x));
                }
                catch (LimitReachedException limitReachedException) {
                    continue;
                }
                break;
            }
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("gnu.crypto.prng.umac.cipher.name", "aes");
        byte[] key = new byte[16];
        System.arraycopy(material, 0, key, 0, 16);
        attributes.put("gnu.crypto.cipher.key.material", key);
        attributes.put("gnu.crypto.prng.umac.index", material[16] & 0xFF);
        this.adaptee.init(attributes);
    }
}

