/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.jce.prng;

import gnu.java.security.prng.LimitReachedException;
import gnu.javax.crypto.prng.Fortuna;
import java.security.SecureRandomSpi;
import java.util.Collections;

public final class FortunaImpl
extends SecureRandomSpi {
    private final Fortuna adaptee = new Fortuna();

    public FortunaImpl() {
        this.adaptee.init(Collections.singletonMap("gnu.crypto.prng.fortuna.seed", new byte[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void engineSetSeed(byte[] seed) {
        Fortuna fortuna = this.adaptee;
        synchronized (fortuna) {
            this.adaptee.addRandomBytes(seed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void engineNextBytes(byte[] buffer) {
        Fortuna fortuna = this.adaptee;
        synchronized (fortuna) {
            try {
                this.adaptee.nextBytes(buffer);
            }
            catch (LimitReachedException shouldNotHappen) {
                throw new Error(shouldNotHappen);
            }
        }
    }

    protected byte[] engineGenerateSeed(int numbytes) {
        byte[] seed = new byte[numbytes];
        this.engineNextBytes(seed);
        return seed;
    }
}

