/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.ComponentReshapeEvent;
import gnu.java.awt.peer.gtk.GtkContainerPeer;
import gnu.java.awt.peer.gtk.GtkMainThread;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.PaintEvent;
import java.awt.event.WindowEvent;
import java.awt.peer.WindowPeer;

public class GtkWindowPeer
extends GtkContainerPeer
implements WindowPeer {
    protected static final int GDK_WINDOW_TYPE_HINT_NORMAL = 0;
    protected static final int GDK_WINDOW_TYPE_HINT_DIALOG = 1;
    protected static final int GDK_WINDOW_TYPE_HINT_MENU = 2;
    protected static final int GDK_WINDOW_TYPE_HINT_TOOLBAR = 3;
    protected static final int GDK_WINDOW_TYPE_HINT_SPLASHSCREEN = 4;
    protected static final int GDK_WINDOW_TYPE_HINT_UTILITY = 5;
    protected static final int GDK_WINDOW_TYPE_HINT_DOCK = 6;
    protected static final int GDK_WINDOW_TYPE_HINT_DESKTOP = 7;
    protected int windowState = 0;
    private int x;
    private int y;
    private int width;
    private int height;

    native void gtkWindowSetTitle(String var1);

    native void gtkWindowSetResizable(boolean var1);

    native void gtkWindowSetModal(boolean var1);

    native void gtkWindowSetAlwaysOnTop(boolean var1);

    native boolean gtkWindowHasFocus();

    native void realize();

    public void dispose() {
        super.dispose();
        GtkMainThread.destroyWindow();
    }

    int getX() {
        return this.x;
    }

    int getY() {
        return this.y;
    }

    int getWidth() {
        return this.width;
    }

    int getHeight() {
        return this.height;
    }

    native void create(int var1, boolean var2, GtkWindowPeer var3);

    void create(int type, boolean decorated) {
        Window window = (Window)this.awtComponent;
        GtkWindowPeer parent_peer = null;
        Container parent = this.awtComponent.getParent();
        this.x = this.awtComponent.getX();
        this.y = this.awtComponent.getY();
        this.height = this.awtComponent.getHeight();
        this.width = this.awtComponent.getWidth();
        if (!window.isFocusableWindow()) {
            type = 2;
        }
        if (parent != null) {
            parent_peer = (GtkWindowPeer)this.awtComponent.getParent().getPeer();
        }
        this.create(type, decorated, parent_peer);
    }

    void create() {
        this.create(0, false);
    }

    void setParent() {
        this.setVisible(this.awtComponent.isVisible());
        this.setEnabled(this.awtComponent.isEnabled());
    }

    void setVisibleAndEnabled() {
    }

    public native void setVisibleNative(boolean var1);

    public native void setVisibleNativeUnlocked(boolean var1);

    native void connectSignals();

    public GtkWindowPeer(Window window) {
        super(window);
        window.setFont(new Font("Dialog", 0, 12));
    }

    public native void toBack();

    public native void toFront();

    native void nativeSetBounds(int var1, int var2, int var3, int var4);

    native void nativeSetBoundsUnlocked(int var1, int var2, int var3, int var4);

    native void nativeSetLocation(int var1, int var2);

    native void nativeSetLocationUnlocked(int var1, int var2);

    protected void setLocation(int x, int y) {
        this.nativeSetLocation(x, y);
    }

    public void setBounds(int x, int y, int width, int height) {
        if (x != this.getX() || y != this.getY() || width != this.getWidth() || height != this.getHeight()) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.nativeSetBounds(x, y, width - this.insets.left - this.insets.right, height - this.insets.top - this.insets.bottom);
        }
    }

    public void setTitle(String title) {
        this.gtkWindowSetTitle(title);
    }

    protected native void setSize(int var1, int var2);

    public void setResizable(boolean resizable) {
        this.x = this.awtComponent.getX();
        this.y = this.awtComponent.getY();
        this.width = this.awtComponent.getWidth();
        this.height = this.awtComponent.getHeight();
        this.setSize(this.width - this.insets.left - this.insets.right, this.height - this.insets.top - this.insets.bottom);
        this.gtkWindowSetResizable(resizable);
    }

    protected void postInsetsChangedEvent(int top, int left, int bottom, int right) {
        this.insets.top = top;
        this.insets.left = left;
        this.insets.bottom = bottom;
        this.insets.right = right;
    }

    protected void postConfigureEvent(int x, int y, int width, int height) {
        int frame_x = x - this.insets.left;
        int frame_y = y - this.insets.top;
        int frame_width = width + this.insets.left + this.insets.right;
        int frame_height = height + this.insets.top + this.insets.bottom;
        if (frame_x != this.x || frame_y != this.y || frame_width != this.width || frame_height != this.height) {
            ComponentReshapeEvent ev = new ComponentReshapeEvent(this.awtComponent, frame_x, frame_y, frame_width, frame_height);
            this.awtComponent.dispatchEvent(ev);
        }
        if (frame_width != this.getWidth() || frame_height != this.getHeight()) {
            this.width = frame_width;
            this.height = frame_height;
            GtkWindowPeer.q().postEvent(new ComponentEvent(this.awtComponent, 101));
        }
        if (frame_x != this.getX() || frame_y != this.getY()) {
            this.x = frame_x;
            this.y = frame_y;
            GtkWindowPeer.q().postEvent(new ComponentEvent(this.awtComponent, 100));
        }
    }

    public void show() {
        this.x = this.awtComponent.getX();
        this.y = this.awtComponent.getY();
        this.width = this.awtComponent.getWidth();
        this.height = this.awtComponent.getHeight();
        this.setLocation(this.x, this.y);
        this.setVisible(true);
    }

    void postWindowEvent(int id, Window opposite, int newState) {
        if (id == 209) {
            if (this.windowState != newState) {
                if ((this.windowState & 1) != 0 && (newState & 1) == 0) {
                    GtkWindowPeer.q().postEvent(new WindowEvent((Window)this.awtComponent, 204, opposite, 0, 0));
                } else if ((this.windowState & 1) == 0 && (newState & 1) != 0) {
                    GtkWindowPeer.q().postEvent(new WindowEvent((Window)this.awtComponent, 203, opposite, 0, 0));
                }
                GtkWindowPeer.q().postEvent(new WindowEvent((Window)this.awtComponent, id, opposite, this.windowState, newState));
                this.windowState = newState;
            }
        } else {
            GtkWindowPeer.q().postEvent(new WindowEvent((Window)this.awtComponent, id, opposite));
        }
    }

    public void updateAlwaysOnTop() {
        this.gtkWindowSetAlwaysOnTop(((Window)this.awtComponent).isAlwaysOnTop());
    }

    protected void postExposeEvent(int x, int y, int width, int height) {
        GtkWindowPeer.q().postEvent(new PaintEvent(this.awtComponent, 800, new Rectangle(x + this.insets.left, y + this.insets.top, width, height)));
    }

    public boolean requestWindowFocus() {
        return false;
    }

    public boolean requestFocus(Component request, boolean temporary, boolean allowWindowFocus, long time) {
        assert (request == this.awtComponent || this.isLightweightDescendant(request));
        boolean retval = false;
        if (this.gtkWindowHasFocus()) {
            KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Component currentFocus = kfm.getFocusOwner();
            if (currentFocus == request) {
                retval = true;
            } else {
                this.postFocusEvent(1004, temporary);
                retval = true;
            }
        } else if (allowWindowFocus) {
            retval = this.requestWindowFocus();
        }
        return retval;
    }

    public Graphics getGraphics() {
        Graphics g = super.getGraphics();
        g.translate(-this.insets.left, -this.insets.top);
        return g;
    }

    protected void postMouseEvent(int id, long when, int mods, int x, int y, int clickCount, boolean popupTrigger) {
        super.postMouseEvent(id, when, mods, x + this.insets.left, y + this.insets.top, clickCount, popupTrigger);
    }

    public Point getLocationOnScreen() {
        int[] point = new int[2];
        this.gtkWindowGetLocationOnScreen(point);
        return new Point(point[0], point[1]);
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public void updateIconImages() {
    }

    public void updateMinimumSize() {
    }

    public void setModalBlocked(Dialog d, boolean b) {
    }

    public void updateFocusableWindowState() {
    }

    public void setAlwaysOnTop(boolean b) {
    }
}

