/*
 * Decompiled with CFR 0.152.
 */
package gnu.gcj.tools.gcj_dbtool;

import gnu.gcj.runtime.PersistentByteMap;
import gnu.gcj.tools.gcj_dbtool.Fileset;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class Main {
    private static boolean verbose = false;

    public static void main(String[] s) {
        PersistentByteMap b;
        File database;
        boolean fileListFromStdin = false;
        char filenameSeparator = ' ';
        Main.insist(s.length >= 1);
        if (s[0].equals("-") || s[0].equals("-0")) {
            if (s[0].equals("-0")) {
                filenameSeparator = '\u0000';
            }
            fileListFromStdin = true;
            String[] newArgs = new String[s.length - 1];
            System.arraycopy(s, 1, newArgs, 0, s.length - 1);
            s = newArgs;
        }
        if (s[0].equals("-v") || s[0].equals("--version")) {
            Main.insist(s.length == 1);
            System.out.println("gcj-dbtool (" + System.getProperty("java.vm.name") + ") " + System.getProperty("java.vm.version"));
            System.out.println();
            System.out.println("Copyright 2008 Free Software Foundation, Inc.");
            System.out.println("This is free software; see the source for copying conditions.  There is NO");
            System.out.println("warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.");
            return;
        }
        if (s[0].equals("--help")) {
            Main.usage(System.out);
            return;
        }
        if (s[0].equals("-n")) {
            Main.insist(s.length >= 2 && s.length <= 3);
            int capacity = 32749;
            if (s.length == 3 && (capacity = Integer.parseInt(s[2])) <= 2) {
                Main.usage(System.err);
                System.exit(1);
            }
            try {
                PersistentByteMap.emptyPersistentByteMap(new File(s[1]), capacity, capacity * 32);
            }
            catch (Exception e) {
                System.err.println("error: could not create " + s[1] + ": " + e.toString());
                System.exit(2);
            }
            return;
        }
        if (s[0].equals("-a") || s[0].equals("-f")) {
            try {
                Main.insist(s.length == 4);
                database = new File(s[1]);
                database = database.getAbsoluteFile();
                File jar = new File(s[2]);
                PersistentByteMap map = database.isFile() ? new PersistentByteMap(database, PersistentByteMap.AccessMode.READ_ONLY) : PersistentByteMap.emptyPersistentByteMap(database, 100, 3200);
                File soFile = new File(s[3]);
                if (!s[0].equals("-f") && !soFile.isFile()) {
                    throw new IllegalArgumentException(String.valueOf(s[3]) + " is not a file");
                }
                map = Main.addJar(jar, map, soFile);
            }
            catch (Exception e) {
                System.err.println("error: could not update " + s[1] + ": " + e.toString());
                System.exit(2);
            }
            return;
        }
        if (s[0].equals("-t")) {
            try {
                Main.insist(s.length == 2);
                b = new PersistentByteMap(new File(s[1]), PersistentByteMap.AccessMode.READ_ONLY);
                Iterator iterator = b.iterator(2);
                while (iterator.hasNext()) {
                    PersistentByteMap.MapEntry entry = (PersistentByteMap.MapEntry)iterator.next();
                    byte[] key = (byte[])entry.getKey();
                    byte[] value = b.get(key);
                    if (Arrays.equals(value, (byte[])entry.getValue())) continue;
                    String err = "Key " + Main.bytesToString(key) + " at bucket " + entry.getBucket();
                    throw new RuntimeException(err);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(3);
            }
            return;
        }
        if (s[0].equals("-m")) {
            Main.insist(s.length >= 3 || fileListFromStdin && s.length == 2);
            try {
                database = new File(s[1]);
                database = database.getAbsoluteFile();
                File temp = File.createTempFile(database.getName(), "", database.getParentFile());
                int newSize = 0;
                int newStringTableSize = 0;
                Fileset files = Main.getFiles(s, 2, fileListFromStdin, filenameSeparator);
                PersistentByteMap[] sourceMaps = new PersistentByteMap[files.size()];
                Iterator it = files.iterator();
                int i = 0;
                while (it.hasNext()) {
                    PersistentByteMap b2 = new PersistentByteMap((File)it.next(), PersistentByteMap.AccessMode.READ_ONLY);
                    newSize += b2.size();
                    newStringTableSize += b2.stringTableSize();
                    sourceMaps[i++] = b2;
                }
                newSize = (int)((double)newSize * 1.5);
                PersistentByteMap map = PersistentByteMap.emptyPersistentByteMap(temp, newSize, newStringTableSize);
                i = 0;
                while (i < sourceMaps.length) {
                    if (verbose) {
                        System.err.println("adding " + sourceMaps[i].size() + " elements from " + sourceMaps[i].getFile());
                    }
                    map.putAll(sourceMaps[i]);
                    ++i;
                }
                map.close();
                temp.renameTo(database);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(3);
            }
            return;
        }
        if (s[0].equals("-l")) {
            Main.insist(s.length == 2);
            try {
                b = new PersistentByteMap(new File(s[1]), PersistentByteMap.AccessMode.READ_ONLY);
                System.out.println("Capacity: " + b.capacity());
                System.out.println("Size: " + b.size());
                System.out.println();
                System.out.println("Elements: ");
                Iterator iterator = b.iterator(2);
                while (iterator.hasNext()) {
                    PersistentByteMap.MapEntry entry = (PersistentByteMap.MapEntry)iterator.next();
                    byte[] digest = (byte[])entry.getKey();
                    System.out.print("[" + entry.getBucket() + "] " + Main.bytesToString(digest) + " -> ");
                    System.out.println(new String((byte[])entry.getValue()));
                }
            }
            catch (Exception e) {
                System.err.println("error: could not list " + s[1] + ": " + e.toString());
                System.exit(2);
            }
            return;
        }
        if (s[0].equals("-d")) {
            Main.insist(s.length == 2);
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                PersistentByteMap b3 = new PersistentByteMap(new File(s[1]), PersistentByteMap.AccessMode.READ_WRITE);
                int N = b3.capacity();
                byte[] bytes = new byte[1];
                byte[] digest = md.digest(bytes);
                int i = 0;
                while (i < N) {
                    digest = md.digest(digest);
                    b3.put(digest, digest);
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(3);
            }
            return;
        }
        if (s[0].equals("-p")) {
            Main.insist(s.length == 1 || s.length == 2);
            String result = s.length == 1 ? System.getProperty("gnu.gcj.precompiled.db.path", "") : String.valueOf(s[1]) + (s[1].endsWith(File.separator) ? "" : File.separator) + Main.getDbPathTail();
            System.out.println(result);
            return;
        }
        Main.usage(System.err);
        System.exit(1);
    }

    private static native String getDbPathTail();

    private static void insist(boolean ok) {
        if (!ok) {
            Main.usage(System.err);
            System.exit(1);
        }
    }

    private static void usage(PrintStream out) {
        out.println("gcj-dbtool: Manipulate gcj map database files\n\n  Usage: \n    gcj-dbtool -n file.gcjdb [size]     - Create a new gcj map database\n    gcj-dbtool -a file.gcjdb file.jar file.so\n            - Add the contents of file.jar to a gcj map database\n    gcj-dbtool -f file.gcjdb file.jar file.so\n            - Add the contents of file.jar to a gcj map database\n    gcj-dbtool -t file.gcjdb            - Test a gcj map database\n    gcj-dbtool -l file.gcjdb            - List a gcj map database\n    gcj-dbtool [-][-0] -m dest.gcjdb [source.gcjdb]...\n            - Merge gcj map databases into dest\n              Replaces dest\n              To add to dest, include dest in the list of sources\n              If the first arg is -, read the list from stdin\n              If the first arg is -0, filenames separated by nul\n    gcj-dbtool -p [LIBDIR]              - Print default database name");
    }

    private static PersistentByteMap addJar(File f, PersistentByteMap b, File soFile) throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        JarFile jar = new JarFile(f);
        int count = 0;
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry classfile = entries.nextElement();
            if (!classfile.getName().endsWith(".class")) continue;
            ++count;
        }
        if (verbose) {
            System.err.println("adding " + count + " elements from " + f + " to " + b.getFile());
        }
        b = Main.resizeMap(b, (b.size() + count) * 2, true);
        entries = jar.entries();
        byte[] soFileName = soFile.getCanonicalPath().getBytes("UTF-8");
        while (entries.hasMoreElements()) {
            JarEntry classfile = entries.nextElement();
            if (!classfile.getName().endsWith(".class")) continue;
            InputStream str = jar.getInputStream(classfile);
            int length = (int)classfile.getSize();
            if (length == -1) {
                throw new EOFException();
            }
            byte[] data = new byte[length];
            int pos = 0;
            while (length - pos > 0) {
                int len = str.read(data, pos, length - pos);
                if (len == -1) {
                    throw new EOFException("Not enough data reading from: " + classfile.getName());
                }
                pos += len;
            }
            b.put(md.digest(data), soFileName);
        }
        return b;
    }

    static PersistentByteMap resizeMap(PersistentByteMap m, int newCapacity, boolean close) throws IOException, IllegalAccessException {
        newCapacity = Math.max(m.capacity(), newCapacity);
        File name = m.getFile();
        File copy = File.createTempFile(name.getName(), "", name.getParentFile());
        try {
            PersistentByteMap dest = PersistentByteMap.emptyPersistentByteMap(copy, newCapacity, newCapacity * 32);
            dest.putAll(m);
            dest.force();
            if (close) {
                m.close();
            }
            copy.renameTo(name);
            return dest;
        }
        catch (Exception exception) {
            copy.delete();
            return null;
        }
    }

    static String bytesToString(byte[] b) {
        StringBuffer hexBytes = new StringBuffer();
        int length = b.length;
        int i = 0;
        while (i < length) {
            int v = b[i] & 0xFF;
            if (v < 16) {
                hexBytes.append('0');
            }
            hexBytes.append(Integer.toHexString(v));
            ++i;
        }
        return hexBytes.toString();
    }

    private static final Fileset getFiles(String[] s, int startPos, boolean fileListFromStdin, char separator) {
        if (fileListFromStdin) {
            return new Fileset(System.in, separator);
        }
        return new Fileset(s, startPos, s.length);
    }
}

