<?php
// PukiWiki - Yet another WikiWikiWeb clone
// $Id: tburl.inc.php,v 0.3 2007/05/20 08:00:00 g@kko Exp $
// Copyright (C) 2007 g@kko
// License: GPL v2 or (at your option) any later version
//
// show Trackback URL

define('PLUGIN_TBURL_SIZE', 50);    // INPUTのサイズ
define('PLUGIN_TBURL_AUTOSIZE', 1); // 1: URLの文字数をINPUTのサイズ, 0:固定指定
define('PLUGIN_TBURL_LABEL', 'Trackback URL: '); // ブロック型のラベル
define('PLUGIN_TBURL_CONVERT_USAGE', '<p>#tburl(page)</p>');
define('PLUGIN_TBURL_INLINE_USAGE', '&tburl(page);');

// ----

function plugin_tburl_convert($page = '')
{
	global $trackback, $vars;

	if (! $trackback) return '';

	if ($page != '') $_page = (is_page($page)) ? $page : '';
	else             $_page = isset($vars['page']) ? $vars['page'] : '';
	if (! $_page) return PLUGIN_TBURL_CONVERT_USAGE;

	$tb_url = get_script_uri() . '?tb_id=' . tb_get_id($_page);
	$size = PLUGIN_TBURL_AUTOSIZE ? strlen($tb_url) : PLUGIN_TBURL_SIZE;
	$js = PKWK_ALLOW_JAVASCRIPT ? ' onclick="this.focus();this.select();return false"' : '';

	return '<div class="tbid"><p>' . PLUGIN_TBURL_LABEL . '<input type="text" size="' . $size
		. '"'. $js . '" readonly="readonly" value="' . $tb_url . '" /></p></div>';
}

function plugin_tburl_inline()
{
	global $trackback, $vars;

	if (! $trackback) return '';

	list($page) = func_get_args();

	if ($page != '') $_page = (is_page($page)) ? $page : '';
	else 	         $_page = isset($vars['page']) ? $vars['page'] : '';
	if (! $_page) return PLUGIN_TBURL_INLINE_USAGE;

	return get_script_uri() . '?tb_id=' . tb_get_id($_page);
}
?>
