#
#  wmove.py - a wmove.dll compatible Saori module for ninix
#  Copyright (C) 2003 by Shyouzou Sugitani <shy@debian.or.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#

# TODO:
# - STANDBY, STANDBY_INSIDE

import sys
import os
import string
import StringIO
import time

if os.environ.has_key('DISPLAY'):
    if not sys.modules.has_key('gtk'):
        try:
            import pygtk
            pygtk.require("2.0")
        except ImportError:
            pass
    import gtk
else:
    gtk = None

class Saori:
    def __init__(self):
	self.loaded = 0
        self.sakura = None
    def use_sakura(self, sakura):
        self.sakura = sakura
    def load(self, dir=os.curdir):
        self.commands = [[], []]
        self.timeout_id = None
        self.dir = dir
        result = 0
        if not self.sakura or not gtk:
            pass
        elif self.loaded:
	    result = 2
        else:
            self.sakura_name = self.sakura.get_selfname()
            self.kero_name = self.sakura.get_keroname()
            self.loaded = 1
            result = 1
	return result
    def unload(self):
        if self.timeout_id:
            gtk.timeout_remove(self.timeout_id)
            self.timeout_id = None
        self.commands = [[], []]
        self.sakura_name = ''
        self.kero_name = ''
        self.loaded = 0
        return 1
    def request(self, req):
        type, argument = self.evaluate_request(req)
        if not type:
            return 'SAORI/1.0 400 Bad Request\r\n\r\n'
        elif type == 'GET Version':
            return 'SAORI/1.0 204 No Content\r\n\r\n'
        elif type == 'EXECUTE':
            if len(argument) == 0:
                return 'SAORI/1.0 400 Bad Request\r\n\r\n'
            name = argument[0]
            if name in ['MOVE', 'MOVE_INSIDE']:
                if len(argument) != 4:
                    return 'SAORI/1.0 400 Bad Request\r\n\r\n'
                if argument[1] not in [self.sakura_name, self.kero_name]: ## FIXME: HWND
                    return 'SAORI/1.0 400 Bad Request\r\n\r\n'
            elif name in ['MOVETO', 'MOVETO_INSIDE']:
                if len(argument) != 4:
                    return 'SAORI/1.0 400 Bad Request\r\n\r\n'
                if argument[1] not in [self.sakura_name, self.kero_name]: ## FIXME: HWND
                    return 'SAORI/1.0 400 Bad Request\r\n\r\n'
            elif name == 'ZMOVE':
                if len(argument) != 3:
                    return 'SAORI/1.0 400 Bad Request\r\n\r\n'
                if argument[1] not in [self.sakura_name, self.kero_name]: ## FIXME: HWND
                    return 'SAORI/1.0 400 Bad Request\r\n\r\n'
            elif name in ['STANDBY', 'STANDBY_INSIDE']:
                if len(argument) != 6:
                    return 'SAORI/1.0 400 Bad Request\r\n\r\n'
                if argument[1] not in [self.sakura_name, self.kero_name] or \
	           argument[2] not in [self.sakura_name, self.kero_name]: ## FIXME: HWND
                    return 'SAORI/1.0 400 Bad Request\r\n\r\n'
            elif name == 'GET_POSITION':
                if len(argument) != 2:
                    return 'SAORI/1.0 400 Bad Request\r\n\r\n'
                if argument[1] == self.sakura_name: ## FIXME: HWND
                    side = 0
                elif argument[1] == self.kero_name: ## FIXME: HWND
                    side = 1
	        else:
                    return 'SAORI/1.0 400 Bad Request\r\n\r\n'
	        try:
                    x, y = self.sakura.surface.get_position(side)
                    w, h = self.sakura.surface.get_surface_size(side)
                    return 'SAORI/1.0 200 OK\r\nResult: %d\r\nValue0: %d\r\nValue1: %d\r\nValue2: %d\r\n\r\n' % (x, x, x + w / 2, x + w)
	        except:
                    return 'SAORI/1.0 500 Internal Server Error\r\n\r\n'
            elif name == 'GET_DESKTOP_SIZE':
                if len(argument) != 1:
                    return 'SAORI/1.0 400 Bad Request\r\n\r\n'
                else:
	            try:
	                scrn_w = gtk.gdk.screen_width()
	                scrn_h = gtk.gdk.screen_height()
                        return 'SAORI/1.0 200 OK\r\nResult: %d\r\nValue0: %d\r\nValue1: %d\r\n\r\n' % (scrn_w, scrn_w, scrn_h)
	            except:
                        return 'SAORI/1.0 500 Internal Server Error\r\n\r\n'
            elif name == 'WAIT':
                if len(argument) != 3:
                    return 'SAORI/1.0 400 Bad Request\r\n\r\n'
                if argument[1] not in [self.sakura_name, self.kero_name]: ## FIXME: HWND
                    return 'SAORI/1.0 400 Bad Request\r\n\r\n'
            elif name == 'CLEAR':
                if len(argument) != 2:
                    return 'SAORI/1.0 400 Bad Request\r\n\r\n'
                if argument[1] not in [self.sakura_name, self.kero_name]: ## FIXME: HWND
                    return 'SAORI/1.0 400 Bad Request\r\n\r\n'
            elif name == 'NOTIFY':
                if len(argument) < 3 or len(argument) > 8:
                    return 'SAORI/1.0 400 Bad Request\r\n\r\n'
                if argument[1] not in [self.sakura_name, self.kero_name]: ## FIXME: HWND
                    return 'SAORI/1.0 400 Bad Request\r\n\r\n'
            self.enqueue_commands(name, argument[1:])
            if self.timeout_id == None:
                self.do_idle_tasks()
            return 'SAORI/1.0 204 No Content\r\n\r\n'
    def evaluate_request(self, req):
        type = None
        argument = []
	charset = 'Shift_JIS' # default
        header = StringIO.StringIO(req)
        line = header.readline()
        if not line:
            return type, argument
        if line[-1] == '\n':
            line = line[:-1]
        line = string.strip(line)
        if not line:
            return type, argument
        for request in ['EXECUTE', 'GET Version']:
            if line[:len(request)] == request:
                type = request
                break
        while 1:
            line = header.readline()
            if not line:
                break # EOF
            if line[-1] == '\n':
                line = line[:-1]
            line = string.strip(line)
            if not line:
                continue
            colon = string.find(line, ':')
            if colon >= 0:
                key = string.strip(line[:colon])
                value = string.strip(line[colon+1:])
                if key == 'Charset':
                    try:
                        codecs.lookup(value)
                    except:
                        sys.stderr.write("Unsupported charset %s" % repr(charset))
                    else:
                        charset = value
                elif key[:8] == 'Argument':
                    argument.append(unicode(value, charset, 'replace'))
                else:
                    continue
        return type, argument
    def enqueue_commands(self, command, args):
	if command in ['MOVE', 'MOVE_INSIDE', 'MOVETO', 'MOVETO_INSIDE', 'ZMOVE', 'WAIT', 'NOTIFY']:
            if args[0] == self.sakura_name: ## FIXME: HWND
	        self.commands[0].append([command, args[1:]])
            elif args[0] == self.kero_name: ## FIXME: HWND
	        self.commands[1].append([command, args[1:]])
	elif command in ['STANDBY', 'STANDBY_INSIDE']:
	    self.commands[0] = []
	    self.commands[1] = []
            if args[0] == self.sakura_name: ## FIXME: HWND
	        self.commands[0].append([command, args[1:]])
            elif args[0] == self.kero_name: ## FIXME: HWND
	        self.commands[1].append([command, args[1:]])
	elif command == 'CLEAR':
            if args[0] == self.sakura_name: ## FIXME: HWND
	        self.commands[0] = []
            elif args[0] == self.kero_name: ## FIXME: HWND
	        self.commands[1] = []
    def do_idle_tasks(self):
	for side in [0, 1]:
            if len(self.commands[side]) > 0:
	        command, args = self.commands[side].pop(0)
	        if command in ['MOVE', 'MOVE_INSIDE']:
                    x, y = self.sakura.surface.get_position(side)
	            vx = int(args[0])
	            speed = int(args[1])
	            if command == 'MOVE_INSIDE':
                        w, h = self.sakura.surface.get_surface_size(side)
	                scrn_w = gtk.gdk.screen_width()
	                if vx < 0 and x + vx <0:
	                    vx = min(-x, 0)
	                elif vx > 0 and x + vx + w > scrn_w:
	                    vx = max(scrn_w - w - x, 0)
	            if abs(vx) > speed:
	                if vx > 0:
	                    self.sakura.surface.set_position(side, x + speed, y)
	                    self.commands[side].insert(0, [command, [str(vx-speed), args[1]]])
	                elif vx < 0:
	                    self.sakura.surface.set_position(side, x - speed, y)
	                    self.commands[side].insert(0, [command, [str(vx+speed), args[1]]])
	            else:
	                self.sakura.surface.set_position(side, x + vx, y)
	        elif command in ['MOVETO', 'MOVETO_INSIDE']:
                    x, y = self.sakura.surface.get_position(side)
	            to = int(args[0])
	            speed = int(args[1])
	            if command == 'MOVETO_INSIDE':
                        w, h = self.sakura.surface.get_surface_size(side)
	                scrn_w = gtk.gdk.screen_width()
	                if to < 0:
	                    to = 0
	                elif to > scrn_w - w:
	                    to = scrn_w - w
	            if abs(to - x) > speed:
	                if to - x > 0:
	                    self.sakura.surface.set_position(side, x + speed, y)
	                    self.commands[side].insert(0, [command, args])
	                elif to - x < 0:
	                    self.sakura.surface.set_position(side, x - speed, y)
	                    self.commands[side].insert(0, [command, args])
	            else:
	                self.sakura.surface.set_position(side, to, y)
	        elif command in ['STANDBY', 'STANDBY_INSIDE']:
	            pass ## FIXME
	        elif command == 'ZMOVE':
	            if args[0] == '1':
	                self.sakura.surface.raise_(side)
	            elif args[0] == '2':
	                self.sakura.surface.lower(side)
	            else:
	                pass
	        elif command == 'WAIT':
	            try:
	                wait = int(args[0]) # ms
	            except:
	                wait = 0
                    if wait < 25:
	                pass
	            else:
	                self.commands[side].insert(0, ['WAIT', str(wait - 20)])
	        elif command == 'NOTIFY':
	            apply(self.sakura.notify_event, args)
        if len(self.commands[0]) == 0 and len(self.commands[1]) == 0:
	    if self.timeout_id != None:
                gtk.timeout_remove(self.timeout_id)
                self.timeout_id = None
        else:
	    if self.timeout_id == None:
                self.timeout_id = gtk.timeout_add(20, self.do_idle_tasks)
