#
#  dll.py - a pseudo DLL (SHIORI/SAORI API support) module for ninix
#  Copyright (C) 2002, 2003 by Shyouzou Sugitani <shy@debian.or.jp>
#  Copyright (C) 2002, 2003 by MATSUMURA Namihiko <nie@counterghost.net>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#
#  $Id: dll.py,v 1.2 2003/05/27 04:29:41 shy Exp $
#

import sys
import imp
import os
import string

class Library:
    def __init__(self, type, dir, sakura=None, saori_lib=None):
        self.type = type
        self.dir_list = []
        self.dir_list.append(dir)
        self.__sakura = sakura
        self.__saori_lib = saori_lib
    def request(self, name):
        if self.type == 'shiori':
            dll_name, name = name
            if not name and dll_name:
                name = dll_name
        name = string.replace(name, '\\', '/')
        head, tail = os.path.split(name)
        name = tail
        if name:
            if name[-4:] == '.dll':
                name = name[:-4]
        else:
            return None
        module = self.import_module(name)
        if not module:
            return None
        else:
            instance = None
            if self.type == 'saori':
                if getattr(module, 'Saori', None):
                    saori = module.Saori()
                    if getattr(saori, 'use_sakura', None):
                        saori.use_sakura(self.__sakura)
                else:
                    saori = None
                instance = saori
            elif self.type == 'shiori':
                if getattr(module, 'Shiori', None):
                    shiori = module.Shiori(dll_name)
                    if getattr(shiori, 'use_saori', None):
                        shiori.use_saori(self.__saori_lib)
                else:
                    shiori = None
                instance = shiori
            if instance == None:
                del module
                del sys.modules[name]
            return instance
    def import_module(self, name):
        fp = None
        try:
            return sys.modules[name]
        except:
            pass
        try:
            fp, pathname, description = imp.find_module(name, self.dir_list)
        except:
            return None
        try:
            return imp.load_module(name, fp, pathname, description)
        finally:
            if fp:
                fp.close()
        return None
