# -*- coding: ascii -*-
#
#  communicate.py - ghost-to-ghost communication mechanism
#  Copyright (C) 2002-2005 by Shyouzou Sugitani <shy@users.sourceforge.jp>
#  Copyright (C) 2002, 2003 by MATSUMURA Namihiko <nie@counterghost.net>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#
#  $Id: communicate.py,v 1.9 2005/02/14 10:50:20 shy Exp $
#

import os
import socket
import string
import fcntl

import ninix.home

class Communicate:

    def __init__(self):
        self.__ghosts = {}

    def rebuild_ghostdb(self, ghost, name='', s0=0, s1=10):
        if ghost in self.__ghosts.keys():
            del self.__ghosts[ghost]
        if name == None:
            return
        else:
            self.__ghosts[ghost] = (name, s0, s1)

    def get_otherghostname(self, name):
        otherghostname = []
        for key in self.__ghosts.keys():
            if self.__ghosts[key][0] != name:
                otherghostname.append(string.join(self.__ghosts[key], chr(1)))
        return otherghostname

    def send_message(self, ghostname, sender, sentence):
        for key in self.__ghosts.keys():
            if self.__ghosts[key][0] == ghostname:
                ghost = key
                ghost.notify_communicate(sender, sentence)
                break
