<?php

/* 
 *	W-AGORA 4.0
 *	-----------
 *	$Id: config.php5,v 1.31 2005/06/22 13:13:33 mdruilhe Exp $
 *	Usage:		include file - Configuration class
 *	Author:		Marc Druilhe <mdruilhe@w-agora.net>
 */

$databases = array (
//	"dbm" => "DBM",
	"mysql"  => "mySQL",
	"msql"   => "mini SQL (mSQL 2.0)",
	"mssql7" => "Microsoft SQL server 7",
	"adomsaccess" => "Microsoft Access (ADO driver)",
//	"odbc" => "ODBC",
//	"oracle" => "Oracle 7",
	"oci8" => "Oracle 8 OCI",
	"postgres65" => "PostgreSQL version 6.5 or higher",
	"postgres"   => "PostgreSQL version 6.4 or older"
);

$search_engines = array (
	"none" => "None (database)",
	"swish" => "Swish-e",
	"namazu" => "Namazu"
);

class Config {

var $fd=0;

function open ($file) {
	global $ext;

	$ext = (empty($ext) ) ? "php5" : $ext;

	if ($this->fd > 0) {
		print ("$file already opened");
		return false;
	}
	
	if (file_exists ("$file"))
		Copy ("$file", "${file}.bak.$ext");
	$this->fd = fopen ("$file", "w");
	if (!$this->fd)
		return false;
	fputs ($this->fd, "<?php\n");
	return true;
}

function close () {
	if ($this->fd == 0) {
		print ("Warning: no open configuration file");
		return false;
	}
	fputs ($this->fd, '?'.">\n");
	fclose ($this->fd);
	return true;
}

function restore ($file) {
	global $ext;

	$ext = (empty($ext) ) ? "php5" : $ext;

	if (file_exists ("${file}.bak.$ext")) {
		return copy ("${file}.bak.$ext", "$file");
	} else {
		return false;
	}
}

function writeString ($var, $val, $comment="") {

	if ($this->fd == 0) {
		print ("no configuration file open");
		return false;
	}

	$value="";
	if (!empty($val)) {
		// $value = ereg_replace (13, "", stripSlashes($val));
		$value = ereg_replace (13, "", $val);
		$value = str_replace ('\\', '\\\\', $value);
		$value = ereg_replace("\{"."([a-zA-Z0-9_]+)"."}", "\$\\1", $value);
		$value = ereg_replace (10, "\\n", $value);
		$value = ereg_replace ('"', '\\"', $value);
		$value = ereg_replace ("\\$","\\$", $value);
	}

	if (!empty ($comment)) {
		$comment = "\t// $comment";
	}

	if(get_cfg_var("magic_quotes_runtime")) {
		$value = addSlashes($value);
	}
	fputs ($this->fd, "\$$var = \"$value\";$comment\n");
}

function writeInt ($var, $val, $comment="") {
	setType ($value, "integer");
	if (empty ($val)) {
		$value=0;
	}
	else {
		$value=$val;
	}
	if (!empty ($comment)) {
		$comment = "\t// $comment";
	}
	fputs ($this->fd, "\$$var = $value;$comment\n");
}

function writeLn () {
	fputs ($this->fd, "\n");
}

function writeComment ($comment) {
	fputs ($this->fd, "# $comment\n");
}

function writeArrayConfig($conf) {
	if (!is_array($conf))
		return false;

	while ( list( $var, $val) = each($conf) ) {
		if (is_int($val))
			fputs ($fp, "\$$var=$val;\n");
		else
			fputs ($fp, "\$$var=\"$val\";\n");
	}
	fputs ($fp, "?>\n"); // <? helps syntax editor
	fclose ($fp);
	return 0;
}

	/***********************************/
	/*  Initialize Configuration File  */
	/***********************************/

function writeConfig($config=null) {

	if(!is_array($config)) {
		$config = & $GLOBALS;
	}

	$this->writeString("site", $config["site"]);
	$this->writeString("bn_dir", $config["bn_dir"]);
	$this->writeString("bn_dir_notes", $config["bn_dir_notes"]);

	if ( empty($GLOBALS['bn']) ) {
		// Site level parameters
		$this->writeString("bn_dir_forums", $config["bn_dir_forums"]);
		$this->writeString("bn_dir_default", $config["bn_dir_default"]);
		$this->writeString("bn_access", $config["bn_access"]);
		$this->writeString("dbname", $config["dbname"]);
		$this->writeString("dbhost", $config["dbhost"]);
		$this->writeString("dbport", $config["dbport"]);
		$this->writeString("dbuser", $config["dbuser"]);
		$this->writeString("dbpassword", $config["dbpassword"]);
		$this->writeString("dbadmuser", $config["dbadmuser"]);
		$this->writeString("dbadmpassword", $config["dbadmpassword"]);
		$this->writeString("bn_usersource", $config["bn_usersource"]);
		$this->writeInt("bn_registration_mode", $config["bn_registration_mode"]);
	}

	$this->writeString("bn_body", $config["bn_body"]);
	$this->writeString("bn_date_format", $config["bn_date_format"]);
	$this->writeInt("bn_tz_offset", $config["bn_tz_offset"]);
	$this->writeString("bn_font_face", $config["bn_font_face"]);

	$this->writeInt("bn_view_reply", $config["bn_view_reply"]);
	$this->writeInt("bn_no_toolbar", $config["bn_no_toolbar"]);
	$this->writeInt("bn_no_thread_list", $config["bn_no_thread_list"]);
	$this->writeInt("bn_no_nav_bar", $config["bn_no_nav_bar"]);
	$this->writeInt("bn_list_post", $config["bn_list_post"]);
	$this->writeInt("bn_list_no_nav_bar", $config["bn_list_no_nav_bar"]);
	$this->writeInt("bn_no_thanks_msg", $config["bn_no_thanks_msg"]);
	$this->writeString("bn_post_return", $config["bn_post_return"]);

	$this->writeInt("bn_cookies", $config["bn_cookies"]);
	$this->writeInt("bn_popup", $config["bn_popup"]);
	$this->writeInt("bn_no_form_button_bar", $config["bn_no_form_button_bar"]);
	$this->writeInt("bn_frames", $config["bn_frames"]);
	$this->writeString("bn_frameset", $config["bn_frameset"]);
	$this->writeString("bn_frame1", $config["bn_frame1"]);
	$this->writeString("bn_frame2", $config["bn_frame2"]);

	$this->writeString("bn_style", $config["bn_style"]);
	$this->writeString("bn_header", $config["bn_header"]);
	$this->writeString("bn_footer", $config["bn_footer"]);
	$this->writeString("bn_list_vars", $config["bn_list_vars"]);
	$this->writeString("bn_msgs", $config["bn_msgs"]);
	$this->writeString("bn_form", $config["bn_form"]);
	$this->writeString("bn_mail_form", $config["bn_mail_form"]);
	$this->writeString("bn_search_form", $config["bn_search_form"]);
	$this->writeString("bn_template", $config["bn_template"]);
	$this->writeString("bn_fields", $config["bn_fields"]);
	$this->writeString("bn_before_access", $config["bn_before_access"]);
	$this->writeString("bn_login_form", $config["bn_login_form"]);
	$this->writeString("bn_register_form", $config["bn_register_form"]);
	$this->writeString("bn_show_profile", $config["bn_show_profile"]);
	$this->writeString("bn_change_form", $config["bn_change_form"]);
	$this->writeString("bn_forgot_form", $config["bn_forgot_form"]);
	$this->writeString("bn_mail_template", $config["bn_mail_template"]);
	$this->writeString("bn_subscribe_form", $config["bn_subscribe_form"]);

	$this->writeInt("bn_search", $config["bn_search"]);
	$this->writeString("bn_search_engine", $config["bn_search_engine"]);
	$this->writeString("bn_search_path", $config["bn_search_path"]);

	$this->writeInt("bn_file_upload", $config["bn_file_upload"]);
	$this->writeString("MAX_FILE_SIZE", $config["MAX_FILE_SIZE"]);
	$this->writeString("bn_allowed_extensions", $config["bn_allowed_extensions"]);
	$this->writeString("bn_banned_extensions", $config["bn_banned_extensions"]);
	$this->writeString("bn_allowed_mimetypes", $config["bn_allowed_mimetypes"]);
	$this->writeString("bn_banned_mimetypes", $config["bn_banned_mimetypes"]);

	$this->writeInt("bn_browse_server", $config["bn_browse_server"]);
	$this->writeString("bn_browse_dir", $config["bn_browse_dir"]);

	$this->writeInt("bn_mail", $config["bn_mail"]);
	$this->writeInt("bn_user_mail", $config["bn_user_mail"]);
	$this->writeInt("bn_private_mail", $config["bn_private_mail"]);
	$this->writeInt("bn_mail_attachment", $config["bn_mail_attachment"]);

	$this->writeInt("bn_modify", $config["bn_modify"]);
	$this->writeInt("bn_delete", $config["bn_delete"]);
	$this->writeInt("bn_thread", $config["bn_thread"]);
	$this->writeInt("bn_allow_html", $config["bn_allow_html"]);
	$this->writeString ("bn_banned_tags", $config["bn_banned_tags"]);
	$this->writeString ("bn_allowed_tags", $config["bn_allowed_tags"]);
	$this->writeInt("bn_use_smileys", $config["bn_use_smileys"]);
	$this->writeInt("bn_auto_url", $config["bn_auto_url"]);
	$this->writeString ("bn_banned_ips", $config["bn_banned_ips"]);
}

} // end class
?>
