<?PHP

/*
 *	W-AGORA 4.0
 *	-----------
 *	$Id: admin_categories.php5,v 1.13 2004/01/14 23:20:22 mdruilhe Exp $
 *	Usage:		admin - add/edit categories
 *	Authors:	Marc Druilhe <mdruilhe@w-agora.com>
 */

require ("init_admin.inc");

function list_categories() {

	global $icon_dir, $img_dir;
	global $db, $ext, $site, $WA_SELF;

	$query = "SELECT cle, rank, bn_title AS title FROM $site WHERE category=1 ORDER BY rank, bn_title";
	$result = $db->query ($query);
	while ($db->next_record() ) {
		$categories[] = $db->Record;
	}

	table_header(LABEL_EDIT_CATEGORIES . "$site", "80%");
	print "<br> [ " . anchor ("admin_categories.$ext?site=$site&action=add", "", LABEL_ADD_CATEGORY, LABEL_ADD_CATEGORY) . " ]<br>";

	if (is_array($categories)) {
		beginForm();
		hiddenField ("action", "reorder");
		echo "<TABLE BORDER='0' WIDTH='100%' CELLPADDING='4' CELLSPACING='0'>\n";
		echo "<TR><TH align=left>" . COLUMN_ORDER . "</TH><TH align=left>" . COLUMN_CAT_TITLE . "</TH><TH align=left>" . COLUMN_EDIT . "</TH><TH align=left>" . COLUMN_DELETE . "</TH></TR>\n";
		reset($categories);
		while (list(, $cat) = each($categories)) {
			$cle = $cat["cle"];
			$rank_field = getTextfield("ranks[$cle]", $cat["rank"], 3);
			$title = htmlspecialchars(stripslashes($cat["title"]))." (".$cat["cle"].")";
			$edit_url = "<A HREF='$WA_SELF?action=edit&site=$site&cat_id=$cle'><img src='$icon_dir/edit.gif' border=0 align='absmiddle' alt='" . COLUMN_EDIT_CATEGORY . ": [$title]'></A>";
			$delete_url = "<A HREF='$WA_SELF?action=del&site=$site&cat_id=$cle'><img src='$icon_dir/delete.gif' border=0 align='absmiddle' alt='" . COLUMN_DELETE_CATEGORY . ": [$title]'></A>";
			printf ("<TR><td>%s</td><td>%s</td><td>%s</td><td>%s</td></tr>\n", $rank_field,	$title, $edit_url, $delete_url);
		}
		echo "</table>\n";
		submitButton ("reorder", LABEL_UPDATE_ORDER);
		endForm();
	}
	table_footer();

}



$action = (empty($action)) ? "list" : $action;

switch ($action) {

	case "add":
		display_header(LABEL_ADD_NEW_CATEGORY);
		br();
		table_header(LABEL_ADD_NEW_CATEGORY, "80%");
		beginForm();
		hiddenField ("action", "doadd");
		print "<br>" . COLUMN_ORDER . " : " . getTextfield("cat_order", "1", 3);
		print "&nbsp;" . COLUMN_CAT_TITLE . " : " . getTextfield("cat_title", "", 50);
		submitButton("add", LABEL_ADD_THIS_CATEGORY);
		endForm();
		table_footer();
	break;

	case "doadd":
		$cat["order"] =  $cat_order;
		$cat["title"] =  strip_magic_quotes($cat_title);
		$cat["owner"] =  $auth->userid;
		$db->addCategory ($site, $cat, 0);
		display_header(LABEL_EDIT_CATEGORIES);
		list_categories();
	break;

	case "edit":
		display_header(LABEL_ADD_NEW_CATEGORY);
		if (!isset($cat_id) ) {
			die ("You must select a category");
		} else {
			$cat = $db->getCategory ($site, $cat_id);
			if (is_array($cat) ) {
				$rank = $cat["rank"];
				$title = htmlspecialchars($cat["cat_title"]);
			}
		}

		if ($auth->level >= ADMIN ) {
			$all_forums = $db->listForums ($site);
		} else {
			$all_forums = $db->listForums ($site, $auth->userid);
		} 

		if (is_array($all_forums)) {
			foreach($all_forums as $name=>$forum_data) {
				$f = $forum_data["bn_name"];
				if ($forum_data["parent"] == $cat_id) {
					$cat_forums[$f] = $forum_data["bn_title"];
				} else {
					$add_forums[$f] = $forum_data["bn_title"];
				}
			}
		}

		br();
		table_header(LABEL_EDIT_CATEGORY, "80%");
		beginForm();
		hiddenField ("action", "update");
		hiddenField ("cat_id", "$cat_id");
		echo "<TABLE BORDER='0' WIDTH='100%' CELLPADDING='4' CELLSPACING='0'>\n";
		print "<tr><td>" . COLUMN_ORDER . ":</td><td>" . getTextfield("cat_order", $rank, 5) . "</td><tr>";
		print "<tr><td>#</td><td>$cat_id</td><tr>";
		print "<tr><td>" . COLUMN_CAT_TITLE . ":</td><td>" . getTextfield("cat_title", $title, 50) . "</td><tr>";

		if (is_array($cat_forums)) {
			print "<tr><td valign=\"top\">".LABEL_FORUMS."</td><td><ul>";
			foreach($cat_forums as $name=>$f_title) {
				print "<li>$f_title";
			}
			print "</ul></td><tr>";
		}

		if (@is_array($add_forums)) {
			$add_forums[''] = '----';
			print "<tr><td>" . LABEL_ADD_FORUM. "</td><td>". getListBox ('add_forum', $add_forums, "", 0)."</td><tr>";
		}
		print "<tr><td colspan=2 align=center>";
		submitButton("update", LABEL_UPDATE_THIS_CATEGORY);
		print "</td></tr></table>";
		endForm();
		table_footer();
	break;

	case "update":
		display_header(LABEL_EDIT_CATEGORY);
		if (!isset($cat_id) ) {
			die ("You must select a category");
		} else {
			$cat["owner"] =  $auth->userid;
			$cat["rank"] = $cat_order;
			$cat["bn_title"] = strip_magic_quotes($cat_title);
			$db->updateTable ("$site", $cat, "cle='$cat_id'");
		}

		if (!empty($add_forum) ) {
			$forum_datas["parent"] = $cat_id;
			$db->updateForum ($site, $add_forum, $forum_datas);
		}

		list_categories();
	break;

	case "del":
		display_header(COLUMN_DELETE_CATEGORY);
		if ($cat_id > 0) {
			$db->deleteCategory ($site, $cat_id);
		} else {
			msgWarning ("Cannot remove top level category");
		}
		list_categories();
	break;

	case "reorder":
		display_header(LABEL_UPDATE_ORDER);
		if (is_array($ranks)) {
			reset($ranks);
			while (list($cle, $rank) = each($ranks)) {
				$fields["rank"] = $rank;
				$db->updateTable ($site, $fields, "cle='$cle'");
			}
		}
		list_categories();
	break;

	default:
		display_header(LABEL_EDIT_CATEGORIES);
		list_categories();
	break;

}


?>
