<?php

/*
 *	W-AGORA 4.0
 *	-----------
 *	$Id: add_user.php5,v 1.12 2005/06/10 22:15:28 mdruilhe Exp $
 *	Usage:		Create a new user for a site
 *	Author:		Syloo <syl@espace-syl.com>
 */

require ("init_admin.inc");

# Read site administration configuration
# --------------------------------------
require ("$site_cfg_file");	
if (empty($bn_msgs) ) {
	include ("$bn_dir_default/site_msgs.$ext");
} else {
	include "$bn_dir/$bn_msgs";
}

 
 /**
  * Short description.
  *
  * Detail description
  * @param     
  * @since     1.0
  * @access    private
  * @return    void
  * @throws    
  */
function add_a_user($userid, $privs, &$output) {
	global $site, $bn, $db;

	$uf_fields["unixdate"] = time();
	$uf_fields["userid"] = $userid;
	$uf_fields["lastpost"] = 0;
	$uf_fields["totalpost"] = 0;
	$uf_fields["bn_name"] = $bn;
	$uf_fields["listpriv"] = $privs['listpriv'];
	$uf_fields["readpriv"] = $privs['readpriv'];
	$uf_fields["writepriv"] = $privs['writepriv'];
	$uf_fields["modpriv"] = $privs['modpriv'];
	$uf_fields["state"] = 1;

	# insert into userforum
	# ---------------------
	$ret = $db->insertPrivs ($site, $bn, $userid, $uf_fields);

	if ($ret < 0) {
		MsgForm (sprintf(ERROR_NO_ADD_USER, $userid, $site), "$WA_SELF?site=$site", "back");
		exit;
	}
	if (!empty($output)) {
		$output .= "<br>";
	}
	$output .= sprintf(WARNING_USER_ADDED, $userid, $bn);
}


display_header (TITLE_ADD_USER);

if (is_uploaded_file($_FILES['csvfile']['tmp_name'])) {
    // Ouverture et lecture du fichier csvfile...
	// Stockage dans une chaine de caracteres appelee useraddresses (comme la textarea)
	$useraddresses = join ("\n", file($_FILES['csvfile']['tmp_name']));

}

if (!empty($useraddresses)) {
    // Traitement de useraddresses pour recuperation des adresses dans un tableau
	// Acces a la base pour recuperation des id correspondant aux adresses dans un tableau appele userid 
	// (comme la liste de choix)
	$words = preg_split ("/[\s,;]+/", $useraddresses);
	reset($words);
	while ( list(,$word)=each($words) ) {
		if (preg_match('/.+\@(\[?)[a-zA-Z0-9\-\.]+\.([a-zA-Z]{2,5}|[0-9]{1,3})(\]?)\b/',
	$word, $result) ) {
			$db->query ("SELECT userid FROM ${site}_users WHERE upper(useraddress)=upper('". $result[0]."')");
			if ($db->next_record() ) {
				$userid = $db->f("userid");
				$userlist[$userid] = $userid;
			}
		}
	}
}

if (is_array($userlist)) {
	reset($userlist);
	while (list(,$userid) = each($userlist)) {
	    if (!empty($userid)) {
			$privs['listpriv'] = $_POST['listpriv'];
			$privs['readpriv'] = $_POST['readpriv'];
			$privs['writepriv'] = $_POST['writepriv'];
			$privs['modpriv'] = $_POST['modpriv'];
			add_a_user($userid, $privs, $output);
	    }
	}

	if (!empty($output)) {
	    msgWarning($output);
	}
}

# Get users that are not registered in that forum
# -----------------------------------------------
	print (LABEL_RETRIEVING_USERS);
	flush();

	$all_site_users = $db->getAllUsers($site, 'username', "userpriv not in ('root','admin')");
	if (is_array($all_site_users) ) {
		// remove already registered users
		$result = $db->query("SELECT userid FROM ${site}_userforum WHERE bn_name='$bn' AND state='1'");
		while ($db->next_record() ) {
			$userid = $db->f('userid');
			unset ($all_site_users[$userid]);
		}
	}

	if (is_array($all_site_users) && !empty($all_site_users) ) {
		$all_site_users[''] = LABEL_FORM_SELECT;
	} else {
		msgWarning(WARNING_NO_USER_TO_ADD);
	}

	echo "<FORM ACTION=\"add_user.$ext\" METHOD=\"post\" ENCTYPE=\"multipart/form-data\" >";
	hiddenField ('site', $site);
	hiddenField ('bn', $bn);
	hiddenField ('MAX_FILE_SIZE', '1000000');

	table_header (sprintf(LABEL_ADD_FORUM_USER, $forum_name));

?>

 <TABLE BORDER=0 WIDTH="100%">
  <TR>
	<TD bgcolor=#e0eaf6 valign=top><?php radioButton ("input_way", "list", "list")?></TD>
	<TD WIDTH=40% ALIGN=RIGHT VALIGN=TOP bgcolor=#e0eaf6 class=label><?php echo LABEL_CHOOSE_USER_ADD?></TD>
	<TD bgcolor=#e0eaf6><?php listBox ("userlist", $all_site_users, "",1)?></TD></TR>
   <TR>
	<TD bgcolor=#e0eaf6 valign=top><?php echo LABEL_OR?><br><?php radioButton ("input_way", "textarea", "list")?></TD>
	<TD WIDTH=40% ALIGN=RIGHT VALIGN=TOP bgcolor=#e0eaf6 class=label><?php echo LABEL_ENTER_EMAILS_TO_ADD?></TD>
   <TD bgcolor=#e0eaf6><?php textArea ("useraddresses", "", 5,40);?></TD></TR>
   <TR>
	<TD bgcolor=#e0eaf6 valign=top>
	  <?php echo LABEL_OR?><br><?php radioButton ("input_way", "file", "list")?>
	</TD>
	<TD WIDTH=40% ALIGN=RIGHT VALIGN=TOP bgcolor=#e0eaf6 class=label>
	  <?php echo LABEL_CHOOSE_EMAILS_FILE?>
	</TD>
	<TD bgcolor=#e0eaf6>
	  <INPUT TYPE="file" NAME="csvfile" width="260" SIZE="30" />
	</TD>
  </TR>
 </TABLE>
<?php 

	echo '<TABLE border="1" WIDTH="70%" align="center">';
	caption (sprintf(LABEL_USER_GRANT_PRIVILEGES, $forum_name));
	echo "<tr><th>" . COLUMN_CAN_LIST . "</th><th>" . COLUMN_CAN_READ . "</th><th>" . COLUMN_CAN_WRITE . "</th>";
/*
	if ($auth->level > MODER) {
		echo "<th>" . LABEL_MODERATOR . "</th>";
	}
	echo "<th>" . LABEL_ACTIVE . "</th>";
*/
	printf ("</tr><tr align=center><td>");
	checkBox ("listpriv", "1", "1");
	print ("</td><td>");
	checkBox ("readpriv", "1", "1");
	print ("</td><td>");
	checkBox ("writepriv", "1", "1");
/*
	if ($auth->level > MODER) {
		print ("</td><td>");
		checkBox ("modpriv", "1", "0");
	}
	print ("</td><td>");
	checkBox ("state", "1", "1");
*/
	print ("</td></tr>");
	echo " </TABLE>";
?>
<br>
<center>
 <INPUT TYPE="submit" VALUE="<?php echo LABEL_ADD_USER ?>">
 <INPUT TYPE="reset"  VALUE="<?php echo LABEL_RESET ?>">
</CENTER>
<?php table_footer() ?>
</FORM>
</BODY>
</HTML>
