#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <malloc.h>
#include <memory.h>
#include <string.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <unistd.h>

#define CONFFILE	".iepg"	/* config filename */
#define CONFENV		"HOME"
#define MAXCONF		100		/* max. config param */
static char *keyword[] = {
	"browser", "URL"
};

static char *conf[MAXCONF];	/* config setting */
static char charset[16] = { "SHIFT_JIS" };

/*
 * functions
 */
char *skipwhite(char *);
int lookupkey(char *);
int urlencode(unsigned char *, int, unsigned char *);

int main(int argc, char* argv[])
{
	FILE *iepg, *fd;
	char *buf, *cmd;
	char *key, *val;
	char *k, *m, *s, *t;
	unsigned char *u;
	int len, idx, clen;
	int ret;
	struct stat stbuf;
	int size;
	char *tmpnam, *nkfcmd, *tmpdir;
	
#ifndef _DEBUG 
	if(argc < 2) {
		fprintf(stderr, "iepg file missing\n");
		exit(-1);
	}
#endif
	if(stat(argv[1], &stbuf) == -1) {
		fprintf(stderr, "can not get access %s\n", argv[1]);
		exit(-1);
	}
	if((stbuf.st_mode & S_IFMT) == S_IFREG) {
		size = stbuf.st_size;
		buf = calloc(size * 2, sizeof(char));
		cmd = calloc(size * 2, sizeof(char));
		key = calloc(size, sizeof(char));
		val = calloc(size, sizeof(char));
	} else {
		fprintf(stderr, "%s file type seems wrong\n", argv[1]);
		exit(-1);
	}
	tmpdir = getenv("TMPDIR");
	if(!tmpdir) {
		tmpdir = getenv("TMP");
	}
	if(!tmpdir) {
		tmpnam = calloc(32, sizeof(char));
		memcpy(tmpnam, "/tmp/tvrecXXXXXX", 16);
	} else {
		len = strlen(tmpdir);
		tmpnam = calloc(len + 1 + 11 + 1, sizeof(char));
		memcpy(tmpnam, tmpdir, len);
		*(tmpnam+len) = '/';
		len++;
		memcpy(tmpnam+len, "tvrecXXXXXX", 11);
	}
	ret = mkstemp(tmpnam);
	if(ret < 0) {
		fprintf(stderr, "can not create temporary file(%d)\n", ret);
		exit(-1);
	}
	close(ret);
	nkfcmd = calloc(31+strlen(argv[1])+strlen(tmpnam)+1, sizeof(char));
	sprintf(nkfcmd, "cat %s | /usr/bin/nkf -e > %s", argv[1], tmpnam);
	ret = system(nkfcmd);
	if(ret < 0) {
		fprintf(stderr, "can not convert iepg file character set\n");
		exit(-1);
	}
	idx = 0;
	memset(conf, '\0', sizeof(conf));

	if((k = getenv(CONFENV))) {
		len = (strlen(k)+1+strlen(CONFFILE)+1);
		m = (char *)calloc(len, sizeof(char));
		len = strlen(k);
		memcpy(m, k, len);
		*(m+len) = '/';
		len++;
	} else {
		m = (char *)calloc(strlen(CONFFILE)+1, sizeof(char));
		len = 0;
	}
	memcpy(m+len, CONFFILE, strlen(CONFFILE));
	len += strlen(CONFFILE);
	*(m+len) = '\0';

	if((fd = fopen(m, "r"))) {
		while(fgets(buf, size*2, fd)) {
			k = skipwhite(buf);
			if(*k == '#') continue;
			if((idx = lookupkey(k)) >= 0) {
				s = skipwhite(k + strlen(keyword[idx]));
				len = strlen(s);
				t = s + len - 1;
				while(*t < ' ') {
					t--;
				}
				len = t - s + 1;
				m = (char *)calloc((size_t)len+1, (size_t)sizeof(char*));
				memcpy(m, s, len);
				conf[idx] = m;
			}
		}
		fclose(fd);
	} else {
		/* default setting */
		m = (char *)calloc((size_t)100, (size_t)sizeof(char*));
		strcpy(m, "/usr/bin/mozilla");
		conf[0] = m;
		m = (char *)calloc((size_t)100, (size_t)sizeof(char*));
		strcpy(m, "http://localhost/");
		conf[1] = m;
	}
	sprintf(cmd, "%s %s?", conf[0], conf[1]);
	iepg = fopen(tmpnam, "r");
	while(fgets(buf, size*2, iepg)) {
		k = skipwhite(buf);
		if((s = strchr(k, ':')) == NULL) continue;
		len = s - k;
		memset(key, 0, size);
		memcpy(key, k, len);
		
		s = skipwhite(s+1);
		len = strlen(s);
		u = (unsigned char *)s + len - 1;
		while(*u < ' ') {
			u--;
		}
		t = (char *)u;
		len = t - s + 1;
		memset(val, 0, size);
		memcpy(val, s, len);
		
		if(strcmp(key, "Content-type") == 0) {
			if((s = strchr(val, '='))) {
				s++;
				strcpy(charset, s);
			}
			continue;
		}
		clen = strlen(cmd);
		if(*(cmd+clen-1) != '?') {
			*(cmd+clen) = '?';
			clen++;
		}
		len = urlencode((unsigned char *)key, strlen(key), (unsigned char *)cmd+clen);
		clen += len;
		*(cmd+clen++) = '=';
		len = urlencode((unsigned char *)val, strlen(val), (unsigned char *)cmd+clen);
		clen += len;
		*(cmd+clen) = '\0';
	}
	fclose(iepg);
	ret = system(cmd);
	unlink(tmpnam);
	return(0);
}
char *skipwhite(char *p)
{
	while(*p && ((*p == ' ') || (*p == '\t'))) {
		p++;
	}
	return(*p ? p : NULL);
}

int lookupkey(char *k)
{
	int i, n, len;

	n = sizeof(keyword)/sizeof(char *);
	for(i=0; i<n; i++) {
		len = strlen(keyword[i]);
		if(strncmp(k, keyword[i], len) == 0) return(i);
	}
	return(-1);
}

int urlencode(unsigned char *s, int len, unsigned char *d)
{
	unsigned char *od = d;
	int i;

	for(i=0; i < len; i++) {
		if(isalnum(*s)) {
			*d++ = *s++;
		} else {
			if((*s >= 0x80) 
			   || ((*s != '-') && (*s != '_') &&  (*s != '.'))) {
				*d++ = '%';
				sprintf((char *)d, "%X", ((*s) & 0xf0)>>4);
				d++;
				sprintf((char *)d, "%X", (*s) & 0x0f);
				d++;
				s++;
			} else {
				if(*s == ' ') {
					*d++ = '+';
				} else {
					*d++ = *s++;
				}
			}
		}
	}
	return(d - od);
}
