<?php

/* 
 *	W-AGORA 4.0
 *	-----------
 *	$Id: upgrade_402.php5,v 1.5 2005/06/10 21:53:01 mdruilhe Exp $
 *	Usage:		Upgrade all installation from 4.0 beta to 4.0.1
 *	Author:		Marc Druilhe <mdruilhe@w-agora.com>
 */

# Define globals
# --------------

	$agora_dir = "..";

function updateSite ($site) {
	global $db;

	$db->Halt_On_Error = "no";

	// Update UserForum table
	echo ("<li> <I>updating table</I> <B>${site}_userforum</B>");
	$db->query ("alter table ${site}_userforum change bn_name bn_name varchar(64) NOT NULL DEFAULT ''");
	$db->Halt_On_Error = "halt";
}

function updateMsgFile ($msgfile) {

	global $bn_dir, $new_msg;

	include "$msgfile";
	reset ($new_msg);

	print "<li> <I>updating messages in </I> <B>$msgfile</B> ";
	$touch = FALSE;

	if (ereg ("^images/", $msg[79]) ) {
		$touch = TRUE;
		$old = $msg[79];
		$msg[79] =  "<img src='".$old."' border='0'>";
		echo " <B>79</B> ";
		$old = $msg[80];
		$msg[80] =  "<img src='".$old."' border='0'>";
		echo " <B>80</B> ";
	}

	while (list ($i, $m) = each($new_msg) ) {
		if (!isset($msg[$i]) ) {
			$touch = TRUE;
			$msg[$i] = $new_msg[$i];
			echo " <B>$i</B> ";
		}
	}

	if ($touch) {
		print "<li> <I>writing file </I> <B>$msgfile</B>";
		$f = new Config;
		$ret = $f->open("$msgfile");
		if (!$ret) {
			return FALSE;
		}
		reset ($msg);
		while (list ($i, $m) = each($msg) ) {
			$f->writeString ("msg[$i]", $msg[$i]);
		}
		$f->close ();
	}
}

function updateNotes ($bn_dir_notes) {

	if (!empty($bn_dir_notes) && is_dir($bn_dir_notes)) {
		echo "<li> <I>moving attachments</I> in directory: <b>$bn_dir_notes</b><br>";
		$dir = opendir($bn_dir_notes);
		while ( $key = readdir($dir) ) {
			if ( ($key != ".") && ($key != "..") && is_dir("$bn_dir_notes/$key") ) {
				$keydir = opendir("$bn_dir_notes/$key");
				while ( $file = readdir($keydir) ) {
					if (is_file ("$bn_dir_notes/$key/$file")) {
						echo "moving file: <b>$bn_dir_notes/$key/$file</b> to <b>$bn_dir_notes/$key.$file</b><br>";
						$ret = copy ("$bn_dir_notes/$key/$file", "$bn_dir_notes/$key.$file");
						if ($ret) {
							unlink ("$bn_dir_notes/$key/$file");
						}
					}
				}
				closedir($keydir);
				rmdir ("$bn_dir_notes/$key");
			}
		}
		closedir($dir);
	}
}

function updateTemplate ($template) {

	include "$template";

	if (!ereg ("att_link", $bn_doc_var) ) {
		$bn_doc_var = ereg_replace ("att_url", "att_link", $bn_doc_var);
	}

	print "<li> <I>updating template</I> in file <B>$template</B> ";

	$conf = new Config;
	$ret = $conf->open($template);
	if (!$ret) {
		return FALSE;
	}

	$conf->writeString ("bn_doc_type", $bn_doc_type);
	$conf->writeString ("bn_doc_var", $bn_doc_var);
	$conf->close();
}

	chdir ("$agora_dir");
	include ("init_admin.inc");

# Load default messages
# ---------------------
	require "$tmpl_dir/default/agora/msgs.$ext";
	$new_msg = $msg;
	unset ($msg);

?>
<html>
<head>
<style type="text/css">
<!--
 body { font-size: 9pt  font-family: Helvetica, Arial, Geneva; }
-->
</style>
</head>
<body>
<H3>Upgrading w-agora from version 4.0.1 to 4.0.2</H3>

<?php 


# If site specified then upgrade it
# ---------------------------------
	if (!empty ($site) ) {
		set_time_limit(30);
		print "<ul>";
		print "<li><I>Upgrading site:</I> <B>$site</B><br> ";
		require "tools/upgrade_site_402.$ext";
		print "</ul>";
		exit;
	}

# ... else (no site specified => upgrade all sites)
# -------------------------------------------------

# Initial setup
# -------------
	include "$cfg_dir/site_agora.$ext";

# Open database
# -------------
	include "$inc_dir/$bn_access.$ext";
	$db_class = "${bn_access}_access";
	$db = new $db_class;
	$ret = $db->openDB($dbhost, $dbport, $dbuser, $dbpassword, $dbname, $site);

	print "<ul>";
	print "<li><I>Upgrading agora main configuration and database:</I> <br> ";

	print "<ul>";

# Update site config. files
# -------------------------
	// update messages
	echo "<li> copy $tmpl_dir/admin/site_msgs.$ext $bn_dir_forums/$site/msgs.$ext ";
	copy ("$tmpl_dir/admin/site_msgs.$ext", "$bn_dir_forums/$site/msgs.$ext");


# Update site tables
# ------------------
	updateSite("agora");

	print "</ul>";

# Update all sites
# ----------------

	// gets all configured sites
	$db->query ("select bn_name AS site from agora");
	while ($db->next_record() ) {
		$sites[] = $db->f("site");
	}

	$db->closeDB();
	unset ($db);

	reset ($sites);
	while (list (, $site) = each($sites) ) {
		set_time_limit(30);
		print "<hr>";
		print "<li><I>Upgrading site:</I> <B>$site</B><br> ";
		require "tools/upgrade_site_402.$ext";
	}

	print "</ul>";

?>