<?PHP

/*
 *	W-AGORA 4.1
 *	-----------
 *	$Id: quicklist.php5,v 1.8 2004/10/14 11:46:20 mdruilhe Exp $
 *	Author:		Marc Druilhe <mdruilhe@w-agora.net>
 *	Usage:		get last messages from one/all forum[s] (can be included in your main page)
 *
 *	Parameters:
 *
 *  site	site name
 *	bn		forum name, either bn or site must be set
 *	s		sort order : 
 *			1 : show messages order by descending date
 *			2 : show most read messages (messages order by hits)
 *			3 : show only threads, last updated first (default)
 *
 *	n		Number of messages to display (default: 10)
 *	noprint	if set to 1 or true, then return the list as a string ($list) instead of printing it out
 *
 *  Example: To include it into another page :
 *
 *	<?PHP
 *	 $n = 20;
 *	 $s = 2;
 *	 $site = "mysite";
 *	 $noprint = 1;
 *	 include ("path/to/w-agora/extras/quicklist.php5");
 *   print ($list);
 *
 *	?>
 */

// just to help my editor to begin syntax checking: <?

# Adjust the following lines to your environment
# ----------------------------------------------
	define ('WA_PATH', '..');	// adjust to the w-agora directory
	$wa_url =  "..";	// adjust to the w-agora URL

	$old_dir = getcwd();
	chdir(WA_PATH);
	include ("globals.inc");

	if (empty($bn) && empty($site)) {
		die("you must select a forum or a site");
	}

	if (!defined('_GLOBALS') || ereg('[/<]', $bn)) {
		die('Hacking attempt');
	}

	settype($n, "integer");
	settype($s, "integer");

	if (empty($n) ) {
		$n=10;
	}

	if (empty($s) ) {
		$s = 3;		//sort by newest thread;
	}

	if (empty ($bn) ) {
		include ("$cfg_dir/site_${site}.$ext");
	} else {
		$bn = basename($bn);
		include ("$cfg_dir/$bn.$ext");
	}

	// Open database connection
	include ("$inc_dir/$bn_access.$ext");
	$db_class = "${bn_access}_access";
	$db = new $db_class;
	$ret = $db->openDB($dbhost, $dbport, $dbuser, $dbpassword, $dbname, $site);

	if (isset($forums)) {
	    unset($forums);
	}

	if (isset($tables)) {
	    unset($tables);
	}

	if (empty ($bn) ) {
		// get all forums from $site
		$forums = $db->getForums($site);
	} else {
		// set array with the given forum
		$forums[$bn] = $bn;
	}

# Get all tables used to store forums
# -----------------------------------
	reset ($forums);
	while (list($bn) = each ($forums) ) {
		$forum = $db->getForum($site, $bn);
		if ( ($forum["rank"]!=0 ) && ($forum["type"]!="priv") && ($forum["state"]!=0) ) {
			$bn_db = $forum["bn_db"];
			if (!isset($tables [$bn_db]) ) {
				$tables [$bn_db] = $bn;	// eliminate doubles
			}
		}
	}

	if (isset($notes)) {
	    unset($notes);
	}

	reset ($tables);
	while (list($table, $bn) = each ($tables) ) {
		if ($s == 1) {
			// order by last post
			$q = "SELECT cle,unixdate,username,subject,hits,newest FROM $table WHERE hidden=0 ORDER BY unixdate DESC LIMIT $n";
		} elseif ($s == 2) {
			// order by most active
			$q = "SELECT cle,unixdate,username,subject,hits,newest FROM $table WHERE hidden=0 ORDER BY hits DESC LIMIT $n";
		} else {
			// order by last updated thread
			$q = "SELECT thread AS cle,unixdate,username,subject,hits,newest,count(cle)-1 AS replies FROM $table WHERE hidden=0 GROUP BY thread ORDER BY newest DESC LIMIT $n";
		}
		$result = $db->query ("$q");
		while ($db->next_record() ) {
			if ($s==1) {
				$k = $db->f("unixdate");
			} elseif($s==2) {
				$k = $db->f("hits");
			} else {
				$k = $db->f("newest");
			}
			$notes[$k] = $db->Record;
			$notes[$k]["bn"] = $bn;
		}
	}

	// sort by reverse order
	krsort ($notes);

	// display list
	reset ($notes);
	$i=0;
	$list = "";

	while (list($k,$note) = each ($notes) ) {
		if (++$i > $n) break;
		$bn = $note["bn"];
		$key = $note["cle"];
		$username = $note["username"];
		$subject = $note["subject"];

		if (!empty($note["hits"]) ) {
			$hits = "views: " . (int) $note["hits"];	    
		} else {
			$hits = "";
		}

		if (!empty($note["replies"]) ) {
			$replies = "- replies: " . (int) $note["replies"];	    
		} else {
			$replies = "";
		}

		$date = date ($bn_date_format, ( ($s==3) ? $note["newest"] : $note["unixdate"]) + ($bn_tz_offset*3600) );
		$list .= "$date <a href=\"$wa_url/view.$ext?bn=$bn&key=$key\">$subject</a> ($hits $replies)<br>\n";
	}

	if (empty($noprint)) {
		print "$list";
	}

	chdir($old_dir);
?>
