<?php

/*
 *	W-AGORA 4.0
 *	-----------
 *	$Id: change_password.php5,v 1.24 2005/06/10 22:15:28 mdruilhe Exp $
 *	Usage:		Allows the user to change his password
 *	Author:		Marc Druilhe <mdruilhe@w-agora.net>
 *
 */

$no_cookie=1;
$bn_action="change_password";

require ("init.inc");

# redirect to change password page if defined
# -------------------------------------------
	$newURL = $auth->getChangePasswordURL();
	if (is_string($newURL)) {
		if (empty($newURL)) {
			if (!empty($before_access)) include $before_access;
			display_header (LABEL_CHANGE_PASSWORD, $header_footer);
			msgForm (ERROR_FEATURE_DISABLED, "$WA_SELF", 'back');
			display_footer ($header_footer);
		} else {
			header("Location: $newURL");
		}
		exit;
	}

# Execute before_access program
# -----------------------------
if (!empty($before_access)) include $before_access;

# If Creation form have been submitted
# ------------------------------------
if ( !empty($_POST) ) {

	$userid = strip_magic_quotes($_POST['userid']);
	$passwd = strip_magic_quotes($_POST['passwd']);
	$newpasswd1 = strip_magic_quotes($_POST['newpasswd1']);
	$newpasswd2 = strip_magic_quotes($_POST['newpasswd2']);

#	Check for required fields
#	-------------------------
	if (empty ($newpasswd1) || ($newpasswd1 != $newpasswd2)) {
		display_header (LABEL_CHANGE_PASSWORD, $header_footer);
		MsgForm (LABEL_NEW_PASSWORD_TWICE, "$WA_SELF", 'back');
		display_footer ($header_footer);
		exit;
	}

#	Check userid / password
#	-----------------------
	$u = $db->getUser($site, $userid);
	if (is_array($u) && ( $is_administrator || (md5($passwd) == $u["password"]) ) ) {

#  Update password for this user in the users table
#  ------------------------------------------------

#		1. for the current site
#		-----------------------
		$u_fields["password"] = md5($newpasswd1);
		$ret = $db->updateUser ($site, $userid, $u_fields);

		$db->setHaltOnError("report");

#		2. then the main site for administrators.
#		-----------------------------------------
		if ( ($u["userpriv"] == "admin") || ($u["userpriv"] == "root") ) {
			$db->updateUser ("agora", $userid, $u_fields);
		}

#		3. then for all sites for 'admin'
#		---------------------------------
		if ($u["userpriv"] == "root") {
			$sites = $db->listForums ("agora");
			while (is_array($sites) && list(, $s) = each($sites)) {
				$db->updateUser ($s["bn_name"], $userid, $u_fields);
			}
		}

		if ($ret < 0) {
			display_header (LABEL_CHANGE_PASSWORD, $header_footer);
			msgForm (sprintf(ERROR_NO_PASSWORD_CHANGE, $userid), "$WA_SELF?site=$site", 'back');
		} else {
			if (isset($auth) && ($auth->userid == $userid) ) {
				$auth->authenticate ($userid, $newpasswd1);
			}
			display_header (LABEL_CHANGE_PASSWORD, $header_footer);
			msgForm (LABEL_PASSWORD_CHANGED, "$main_page?site=$site&bn=$bn", "", ($bn_frames==1)?"_parent":"");
		}
	} else {
		display_header (LABEL_CHANGE_PASSWORD, $header_footer);
		msgForm (ERROR_INVALID_LOGIN, "$WA_SELF?site=$site", 'back');
	}

	display_footer ($header_footer);
	exit;
}

#  -------------------------------------------
#  Initialize default values then display FORM
#  -------------------------------------------

	$userid = (isset($userid)) ? $userid : ( (isset($auth) && ($auth->userid!="guest") ) ? $auth->userid : "");
	$form_title = TITLE_CHANGE_PASSWORD_FORM;
	$input_userid = getTextField ('userid', $userid, 32, 32);
	$input_password = getPasswordField ('passwd', $passwd, 32, 32);
	$input_newpasswd1 = getPasswordField ('newpasswd1', $newpasswd1, 32, 32);
	$input_newpasswd2 = getPasswordField ('newpasswd2', $newpasswd2, 32, 32);

	$change_password_url = "change_password.$ext?site=$site&bn=$bn&userid=$userid";
	$forgot_password_url = "forgot_password.$ext?site=$site&bn=$bn";

	$submit_button = getSubmitButton('submit', BUTTON_SUBMIT);

	display_header (LABEL_CHANGE_PASSWORD, $header_footer);
	beginForm();

	if ($is_administrator) {
?>
		<table width="95%" border=0 cellspacing=1 cellpadding=3 class=list>
		 <TR><td align="center" colspan=2 class=column><?php echo TITLE_CHANGE_USER_PASSWORD?></td></TR>
		 <TR>
		  <TD WIDTH="40%" ALIGN="RIGHT" VALIGN="MIDDLE" class=row><?php echo LABEL_USER_LOGIN?></TD>
		  <TD class=row><input type="text" NAME="userid" value="<?php echo $userid?>" size=20 maxlength=32></TD>
		 </TR>
		 <TR>
		  <TD WIDTH="40%" ALIGN="RIGHT" VALIGN="MIDDLE" class=row><?php echo LABEL_USER_NEW_PASSWORD?></TD>
		  <TD class=row><input type="password" NAME="newpasswd1" size=20 maxlength=32></TD>
		 </TR>
		 <TR>
		  <TD WIDTH="40%" ALIGN="RIGHT" VALIGN="MIDDLE" class=row><?php echo LABEL_USER_NEW_PASSWORD_AGAIN?></TD>
		  <TD class=row><input type="password" NAME="newpasswd2" size=20 maxlength=32></TD>
		 </TR>
		 <tr><td colspan=2 align=center class=row><INPUT TYPE="submit"></TD></TR>
		</TABLE><br>

<?php
	} elseif (!empty($bn_change_form) && file_exists("${bn_dir}/${bn_change_form}") ) {
		include "${bn_dir}/${bn_change_form}";
	} elseif ( file_exists("${bn_dir_default}/change_password_form.$ext") ) {
		include "${bn_dir_default}/change_password_form.$ext";
	} else {
		include "${tmpl_dir}/default/agora/change_password_form.$ext";
	}

	endForm();
	display_footer ($header_footer);
?>
