;; site-custom.scm: site-customizations support.

(define custom-load-hook ())

(define custom-call-load-hook-procs
  (lambda ()
    (for-each
     (lambda (func)
       (eval (list func)))
     custom-load-hook)))

(define add-custom-load-hook
  (lambda (func)
    (set! custom-load-hook (append! custom-load-hook (list func)))))

(define custom-set-default!
  (lambda (sym default)
    (let ((quoted-default (if (or (symbol? default)
				  (list? default))
			      (list 'quote default)
			      default)))
      (eval (list 'define sym quoted-default)))
    (custom-set-value! sym default)
    (add-custom-load-hook
     (lambda ()
       (let ((rec (custom-rec sym)))
	 (if rec
	     (custom-rec-set-default! rec default)))))))

(define custom-set-default-key!
  (lambda (key default)
    (eval (list 'define (symbolconc key '?) list))
    (custom-set-default! key default)))

(define custom-choice-list-append!
  (lambda (sym spec)
    (add-custom-load-hook
     (lambda ()
       (let ((rec (custom-rec sym)))
	 (if rec
	     (append! (custom-rec-type rec) (list spec))))))))
